/* babel - News transport agent for STiK
 *
 * strings.c - Strings, in a separate file for easy translation
 *
 * (c)1996 Mark Baker. Distributable under the terms of the GNU
 *                     general public licence
 *
 * $Id: strings.c,v 1.4 1996/10/01 18:46:34 mnb20 Exp $
 */

#include "babelstr.h"

struct babel_strings strings = {
  /* Program name used in menu etc */
  "  Babel",                               /* menu_name */
  " Babel ",                               /* wind_name */

  /* Version information */
  "Babel 0.5beta  2 August 1996\n",        /* version */

  /* Help text */                          /* helptext */
  "(c) Mark Baker 1996, distributable under the terms\n"
  "of the GNU general public licence.\n\n"
  "babel [--directory=newsdir] [--gem|--text|--quiet] [--help] [--version]\n"
  "  --directory=newsdir (-d)   News spool directory is newsdir\n"
  "  --gem (-g)                 Use GEM (default)\n"
  "  --text (-t)                No GEM, messages to stdout\n"
  "  --quiet (-q)               No GEM, no output apart from errors\n"
  "  --help (-h)                Show this help message\n"
  "  --version (-v)             Show version number\n",

  /* Status lines */
  "Opening active file",                   /* filesopen */
  "Closing active file",                   /* filesclose */
  "Resolving server %s",                   /* resolving */
  "Opening server %s",                     /* serveropen */
  "Closing server",                        /* serverclose */
  "Creating .grp file for %s",             /* groupfile */
  "Getting full group list",               /* fullgroups */
  "Getting list of new groups",            /* newgroups */
  "Getting descriptions",                  /* descriptions */
  "Reading %s",                            /* readgroup */
  "Retrieving %s",                         /* request */
  "Sending to %s",                         /* sendgroup */
  "Expunging in %s",                       /* expunging */

  /* Error messages */
  "This requires STiK to be installed",    /* nostik */
  "Can't find active file",                /* noactivefile */
  "Error in active file %s",               /* activeerror */
  "Can't write temporary file",            /* cantwriteactivetmp */
  "Can't resolve %s",                      /* cantresolve */
  "Can't connect to server",               /* opensocket */
  "Server doesnt give 200",                /* no200 */ 
  "Server gives unexpected response",      /* unexpected */
  "Can't seek in messages file - corrupt?" /* poserror */
  "Out of memory"                          /* memory */
} ;



