/*  globdecl.h          (c) Steve Adam 1995         steve@netinfo.com.au
 *
 *  Global declarations of functions
 *
 *  This should probably be the last header file included
 */


/* functions to convert between host and network byte order (big endian) */
#define	ntohl(x)	(x)
#define	ntohs(x)	(x)
#define	htonl(x)	(x)
#define	htons(x)	(x)


/* memory allocation functions in krmalloc.c */
extern int16 KRinit_mem(long);
extern char * cdecl KRmalloc(long);
extern void cdecl KRfree(char *);
extern long cdecl KRgetfree(int16);
extern char * cdecl KRrealloc(char *, long);

/* functions in main.c          */
extern char * cdecl get_err_text(int16);
extern void disp_error(char *, char *);
extern void disp_info(char *);

/* functions in config.c        */
extern int16 equ_txtn(char *, char *, int16);
extern int16 init_cfg(char *);
extern char * cdecl getvstr(char *);
extern long drv_initjar(void);
extern long  drv_exitjar(void);


/*  Dial and Modem control functions in dialer.c    */
extern int16 cdecl carrier_detect(void);
extern void disconnect(void);
extern void sleep200HZ(clock_t);
extern clock_t msclock(void);
extern int16 cdecl dial(char *);
extern void cdecl ser_disable(void);
extern void cdecl ser_enable(void);

/* Packet functions in packet.c */
extern GPKT *allocate_packet(uint16);
extern void delete_packet(GPKT *, int16);

/* Raw IO functions in slip.c   */
extern 	void slip_in(void);
extern 	void slip_out(void);
/*extern  int  slip_decomp(GPKT *pkt,int newch);*/

extern  struct slcompress *slc_init(void);
extern	long slc_unco (GPKT *b, octet type, struct slcompress *comp);
extern  octet slc_type (GPKT *b);
extern unsigned char slc_comp (GPKT *b,	struct slcompress *comp, long compress_cid);
extern short uncompre (GPKT *b, struct slip *slp);
/*short   chksum (void *buf, short nwords);*/

/* output queue function in slip.c  */
extern void output_packet(GPKT *);

/* various functions in ip.c    */
extern void ip_in(GPKT *);
extern void ip_send(GPKT *, uint8, uint8, uint16);
extern uint16 oc_sum(char *, uint16);
extern uint16 calc_sum(char *, uint16, uint16);
extern GPKT *mkpacket(uint32, int16, int16);
extern int ping(uint32, int16, int16, char *, int16);
extern void frag_ttl_check(void);
extern void ICMP_err_return(GPKT *, int16, int16);

/*  Various functions in tcpin.c  */
extern void tcp_in(GPKT *, TCP_HDR *);
extern void tcp_icmp(int32, uint8, uint8, TCP_HDR *);
extern clock_t set_time(clock_t);
extern struct tcp_rtt *rtt_get(int32);
extern void close_self(int16, TCB *);

/*  Various functions in tcpout.c  */
extern void tcp_output(int16);
extern int16 cdecl TCP_send(int16, char *, int16);
extern int16 cdecl TCP_open(uint32, int16, int16, uint16);
extern int16 cdecl TCP_close(int16, int16);
extern int16 cdecl TCP_wait_state(int16, int16, int16);
extern int16 cdecl TCP_ack_wait(int16, int16);
extern int16 cdecl CNkick(int16);

/* functions in input.c         */
extern void init_ports(void);
extern void start_icmp_listen(void);
extern void stop_icmp_listen(void);
extern void q_icmp_reply(GPKT *);
extern GPKT *get_icmp(void);
extern int16 cdecl UDP_open(uint32, int16);
extern int16 CNopen(void);
extern int16 cdecl UDP_close(int16);
extern void CNclose(int16);
extern CCB * cdecl CNgetinfo(int16);
extern int16 cdecl CNbyte_count(int16);
extern NDB * cdecl CNget_NDB(int16);
extern int16 cdecl CNget_char(int16);
extern int16 cdecl CNget_block(int16,char *,int16);
extern void q_udp_in(GPKT *, UDP_HDR *);
extern int16 CNget_cn(GPKT *);
extern int16 CNlookup_cn(int16, int16, int32);
extern void q_tcp_in(int16, GPKT *);
extern void cdecl housekeep(void);

/* functions in ping.c          */
extern void start_ping(void);

/* functions in udp.c           */
extern void udp_in(GPKT *, UDP_HDR *);
extern int16 cdecl UDP_send(int16, char *, int16);

/* functions in resolve.c	*/
extern uint32 dd_to_ip(char *);
extern int16 cdecl resolve(char *, char **, uint32 *, int16);
extern int16 init_dns(void);
extern void dns_write(void);
extern void do_resolve(void);

/* Flagbox functions		*/
extern int16 cdecl set_flag(int16);
extern void  cdecl clear_flag(int16);

