/*-------------------------------------------------------------------------*\
|* File name:	CSLIP_HD.C						Revision date:	1996.09.02 *|
|* Revised by:	Ulf Ronald Andersson			Revision start:	1996.08.02 *|
|* Original by:	Steve Adam & Dan Ackerman								   *|
\*-------------------------------------------------------------------------*/

/*extern void	*memcpy (void *, const void *, unsigned long);*/
extern int	memcmp (const void *, const void *, unsigned long);
extern void    *memset( void *ptr, int val, size_t len );
/*extern void	*bzero (void *, unsigned long);*/


/* SLIP special character codes
 */
#define END             0300    /* indicates end of packet */
#define ESC             0333    /* indicates byte stuffing */
#define ESC_END         0334    /* ESC ESC_END means END data byte */
#define ESC_ESC         0335    /* ESC ESC_ESC means ESC data byte */

/* Bits in first octet of compressed packet */
#define NEW_C	0x40	/* flag bits for what changed in a packet */
#define NEW_I	0x20
#define NEW_S	0x08
#define NEW_A	0x04
#define NEW_W	0x02
#define NEW_U	0x01

#define TCP_PUSH_BIT 0x10

/* reserved, special-case values of above */
#define SPECIAL_I	(NEW_S|NEW_W|NEW_U)	  /* echoed interactive traffic */
#define SPECIAL_D	(NEW_S|NEW_A|NEW_W|NEW_U) /* unidirectional data */
#define SPECIALS_MASK	(NEW_S|NEW_A|NEW_W|NEW_U)


#define BCMP(p1,p2,n)		memcmp((p2), (p1), (uint32)(n))
#define BCOPY(p1,p2,n)		memcpy((p2), (p1), (uint32)(n))

/*-------------------------------------------------------------------------*\
|* End of file:	CSLIP_HD.C												   *|
\*-------------------------------------------------------------------------*/
