/*-------------------------------------------------------------------------*\
|* File name:	SLC_TYPE.C						Revision date:	1996.09.02 *|
|* Revised by:	Ulf Ronald Andersson			Revision start:	1996.08.02 *|
|* Original by:	Steve Adam & Dan Ackerman								   *|
\*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*\
|* URAn revision history:												   *|
|* 1996.09.02:	Minor simplifications made to the source text.			   *|
\*-------------------------------------------------------------------------*/

#include <stdio.h>      /* Included for NULL.  Might change that later...   */
#include <tos.h>
#include <string.h>
#include <stdlib.h>

#include "globdefs.h"
#include "cslip_hd.h"

octet
slc_type (b)
	GPKT *b;
{
	octet c = *b->fp & 0xf0; 
	
	if (c == (IP_VERSION << 4))
		return TYPE_IP;

	if (c & 0x80)
		return TYPE_COMPRESSED_TCP;

	if (c == TYPE_UNCOMPRESSED_TCP)
		return TYPE_UNCOMPRESSED_TCP;

	return TYPE_ERROR;
}

/*-------------------------------------------------------------------------*\
|* End of file:	SLC_TYPE.C												   *|
\*-------------------------------------------------------------------------*/
