/*-------------------------------------------------------------------------*\
|* File name:	UNCOMPRE.C						Revision date:	1996.09.06 *|
|* Revised by:	Ulf Ronald Andersson			Revision start:	1996.08.02 *|
|* Original by:	Steve Adam & Dan Ackerman								   *|
\*-------------------------------------------------------------------------*/

#include <stdio.h>      /* Included for NULL.  Might change that later...   */
#include <tos.h>
#include <string.h>
#include <stdlib.h>

#include "globdefs.h"
#include "cslip_hd.h"

extern	long slc_unco (GPKT *b, octet type, struct slcompress *comp);
extern  octet slc_type (GPKT *b);


short
uncompre (b, slp)
	GPKT *b;
	struct slip *slp;
{
	octet type;

	type = slc_type(b);

	switch (type)
	{
	case TYPE_IP:
		return 0;

	case TYPE_COMPRESSED_TCP:
		if (slp->flags & SLF_COMPRESS)
		{
			return !slc_unco(b, type, slp->comp);
		}
		break;

	case TYPE_UNCOMPRESSED_TCP:
		if (slp->flags & SLF_COMPRESS)
		{
			return !slc_unco(b, type, slp->comp);
		}
		if (slp->flags & SLF_AUTOCOMP &&
		    slc_unco(b, type, slp->comp))
		{
			slp->flags |= SLF_COMPRESS;
			return 0;
		}
		break;
	}
	return 1;
}

/*-------------------------------------------------------------------------*\
|* End of file:	UNCOMPRE.C												   *|
\*-------------------------------------------------------------------------*/
