

#include <tos.h>
#include <stdio.h>
#include <string.h>

#include "transprt.h"


#pragma warn -par


#define  UINT8      0
#define  INT8       1
#define  UINT16     2
#define  INT16      3
#define  UINT32     4
#define  INT32      5
#define  STRING     6


long       deinstall (void);
char *     get_error (int16 error);
void       write_log_text (char *text);
void       write_function (char *name);
void       write_parameter (char *name, int type, void *value, char *supple);
void       write_buffer (char *buffer, int length);

DRV_HDR *  cdecl  my_get_dftab (char *drv_name);
char *     cdecl  my_KRmalloc (int32 length);
void       cdecl  my_KRfree (char *mem_block);
int32      cdecl  my_KRgetfree (int16 flag);
char *     cdecl  my_KRrealloc (char *mem_block, int32 length);
int16      cdecl  my_TCP_open (uint32 rem_host, int16 rem_port, int16 tos, uint16 size);
int16      cdecl  my_TCP_close (int16 connec, int16 timeout);
int16      cdecl  my_TCP_send (int16 connec, char *buffer, int16 length);
int16      cdecl  my_TCP_wait_state (int16 connec, int16 state, int16 timeout);
int16      cdecl  my_TCP_ack_wait (int16 connec, int16 timeout);
int16      cdecl  my_UDP_open (uint32 rem_host, int16 rem_port);
int16      cdecl  my_UDP_close (int16 connec);
int16      cdecl  my_UDP_send (int16 connec, char *buffer, int16 length);
int16      cdecl  my_CNkick (int16 connec);
int16      cdecl  my_CNbyte_count (int16 connec);
int16      cdecl  my_CNget_char (int16 connec);
NDB *      cdecl  my_CNget_NDB (int16 connec);
int16      cdecl  my_CNget_block (int16 connec, char *block, int16 length);
CIB *      cdecl  my_CNget_info (int16 connec);
int16      cdecl  my_resolve (char *domain, char **real, uint32 *ip_list, int16 ip_num);
int16      cdecl  my_g_resolve (char *domain, char **real, uint32 *ip_list, int16 ip_num);
int16      cdecl  my_setvstr (char name[], char value[]);
char *     cdecl  my_getvstr (char name[]);
int16      cdecl  my_on_port (char *port);
void       cdecl  my_off_port (char *port);
int16      cdecl  my_query_port (char *port);
void       cdecl  my_ser_disable (void);
void       cdecl  my_ser_enable (void);
int16      cdecl  my_set_flag (int16 flag);
void       cdecl  my_clear_flag (int16 flag);
char *     cdecl  my_get_err_text (int16 error);
int16      cdecl  my_carrier_detect (void);
void       cdecl  my_housekeep (void);

extern  TPL                *tpl, my_tpl;
extern  DRV_HDR  * cdecl  (*old_get_dftab) (char *drv_name);



DRV_HDR *  cdecl  my_get_dftab (drv_name)

char  *drv_name;

{
   if (strcmp (drv_name, "LOGSTIK?") == 0)
        return ((DRV_HDR *) 'Here');

   if (strcmp (drv_name, "SELF_DESTRUCT") == 0) {
        Supexec (deinstall);
        return ((DRV_HDR *) 'OkOk');
      }

   return ((*old_get_dftab) (drv_name));
 }


char *  cdecl  my_KRmalloc (length)

int32  length;

{
   char  *ret_val;

   write_function ("KRmalloc");
   write_parameter ("Length", INT32, & length, "");

   ret_val = KRmalloc (length);

   write_parameter ("returns", UINT32, & ret_val, "");

   return (ret_val);
 }


void  cdecl  my_KRfree (mem_block)

char  *mem_block;

{
   write_function ("KRfree");
   write_parameter ("Memory_Block", UINT32, & mem_block, "");

   KRfree (mem_block);
 }


int32  cdecl  my_KRgetfree (flag)

int16  flag;

{
   int32  ret_val;

   write_function ("KRgetfree");
   write_parameter ("Block_Flag", INT16, & flag, (flag) ? "Query_Largest" : "Query_Total");

   ret_val = KRgetfree (flag);

   write_parameter ("returns", INT32, & ret_val, "");

   return (ret_val);
 }


char *  cdecl  my_KRrealloc (mem_block, length)

char   *mem_block;
int32  length;

{
   char  *ret_val;

   write_function ("KRrealloc");
   write_parameter ("Memory_Block", UINT32, & mem_block, "");
   write_parameter ("New_Length", INT32, & length, "");

   ret_val = KRrealloc (mem_block, length);

   write_parameter ("returns", UINT32, & ret_val, "");

   return (ret_val);
 }


int16  cdecl  my_TCP_open (rem_host, rem_port, tos, buff_size)

uint32  rem_host;
int16   rem_port, tos;
uint16  buff_size;

{
   int16  ret_val;

   write_function ("TCP_open");
   write_parameter ("Remote_Host", UINT32, & rem_host, "");
   write_parameter ("Remote_Port", INT16, & rem_port, "");
   write_parameter ("Type_Of_Service", INT16, & tos, "");
   write_parameter ("Buffer_Size", UINT16, & buff_size, "");

   ret_val = TCP_open (rem_host, rem_port, tos, buff_size);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));

   return (ret_val);
 }


int16  cdecl  my_TCP_close (connec, timeout)

int16  connec, timeout;

{
   int16  ret_val;

   write_function ("TCP_close");
   write_parameter ("Connection", INT16, & connec, "");
   write_parameter ("Timeout", INT16, & timeout, "");

   ret_val = TCP_close (connec, timeout);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));

   return (ret_val);

 }


int16  cdecl  my_TCP_send (connec, buffer, length)

int16  connec, length;
char   *buffer;

{
   int16  ret_val;

   write_function ("TCP_send");
   write_parameter ("Connection", INT16, & connec, "");
   write_parameter ("Buffer_Address", UINT32, & buffer, "");
   write_parameter ("Buffer_Length", INT16, & length, "");
   write_buffer (buffer, length);

   ret_val = TCP_send (connec, buffer, length);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));

   return (ret_val);
 }


int16  cdecl  my_TCP_wait_state (connec, state, timeout)

int16  connec, state, timeout;

{
   int16  ret_val;

   write_function ("TCP_wait_state");
   write_parameter ("Connection", INT16, & connec, "");
   write_parameter ("State", INT16, & state, "");
   write_parameter ("Timeout", INT16, & timeout, "");

   ret_val = TCP_wait_state (connec, state, timeout);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));

   return (ret_val);
 }


int16  cdecl  my_TCP_ack_wait (connec, timeout)

int16  connec, timeout;

{
   int16  ret_val;

   write_function ("TCP_ack_wait");
   write_parameter ("Connection", INT16, & connec, "");
   write_parameter ("Timeout", INT16, & timeout, "");

   ret_val = TCP_ack_wait (connec, timeout);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));

   return (ret_val);
 }


int16  cdecl  my_UDP_open (rem_host, rem_port)

uint32  rem_host;
int16   rem_port;

{
   int16  ret_val;

   write_function ("UDP_open");
   write_parameter ("Remote_Host", UINT32, & rem_host, "");
   write_parameter ("Remote_Port", INT16, & rem_port, "");

   ret_val = UDP_open (rem_host, rem_port);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));

   return (ret_val);
 }


int16  cdecl  my_UDP_close (connec)

int16  connec;

{
   int16  ret_val;

   write_function ("UDP_close");
   write_parameter ("Connection", INT16, & connec, "");

   ret_val = UDP_close (connec);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));

   return (ret_val);
 }


int16  cdecl  my_UDP_send (connec, buffer, length)

int16  connec, length;
char   *buffer;

{
   int16  ret_val;

   write_function ("UDP_send");
   write_parameter ("Connection", INT16, & connec, "");
   write_parameter ("Buffer_Address", UINT32, & buffer, "");
   write_parameter ("Buffer_Length", INT16, & length, "");
   write_buffer (buffer, length);

   ret_val = UDP_send (connec, buffer, length);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));

   return (ret_val);
 }


int16  cdecl  my_CNkick (connec)

int16  connec;

{
   int16  ret_val;

   write_function ("CNkick");
   write_parameter ("Connection", INT16, & connec, "");

   ret_val = CNkick (connec);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));

   return (ret_val);
 }


int16  cdecl  my_CNbyte_count (connec)

int16  connec;

{
   int16  ret_val;

   write_function ("CNbyte_count");
   write_parameter ("Connection", INT16, & connec, "");

   ret_val = CNbyte_count (connec);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));

   return (ret_val);
 }


int16  cdecl  my_CNget_char (connec)

int16  connec;

{
   int16  ret_val;

   write_function ("CNget_char");
   write_parameter ("Connection", INT16, & connec, "");

   ret_val = CNget_char (connec);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));

   return (ret_val);
 }


NDB *  cdecl  my_CNget_NDB (connec)

int16  connec;

{
   NDB  *ret_val;

   write_function ("CNget_NDB");
   write_parameter ("Connection", INT16, & connec, "");

   ret_val = CNget_NDB (connec);

   write_parameter ("returns", UINT32, & ret_val, "");

   return (ret_val);
 }


int16  cdecl  my_CNget_block (connec, block, length)

int16  connec, length;
char   *block;

{
   int16  ret_val;

   write_function ("CNget_block");
   write_parameter ("Connection", INT16, & connec, "");
   write_parameter ("Block_Length", INT16, & length, "");

   ret_val = CNget_block (connec, block, length);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));
   if (ret_val >= 0)
        write_buffer (block, length);

   return (ret_val);
 }


CIB *  cdecl  my_CNget_info (connec)

int16  connec;

{
   CIB   *ret_val;
   char  line[100];

   write_function ("CNget_info");
   write_parameter ("Connection", INT16, & connec, "");

   ret_val = CNgetinfo (connec);

   write_parameter ("returns", UINT32, & ret_val, "");
   sprintf (line, "     Protocol = %d, Lcl_Port = %d, Rem_Port = %d, Rem_Host = %04lx",
         ret_val->protocol, ret_val->lport, ret_val->rport, ret_val->rhost);
   write_log_text (line);

   return (ret_val);
 }


int16  cdecl  my_resolve (domain, real_domain, ip_list, ip_num)

char    *domain, **real_domain;
uint32  *ip_list;
int16   ip_num;

{
   int16  ret_val;

   write_function ("resolve");
   write_parameter ("Domain_Name", STRING, domain, "");
   write_parameter ("IP_List_Address", UINT32, & ip_list, "");
   write_parameter ("IP_List_Length", INT16, & ip_num, "");

   ret_val = resolve (domain, real_domain, ip_list, ip_num);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));
   if (real_domain) {
        write_parameter ("Real_Buffer", UINT32, real_domain, "");
        if (*real_domain)
             write_buffer (*real_domain, 32);
      }
   write_parameter ("IP_List[0]", UINT32, ip_list, "");
   write_buffer ((char *) ip_list, ip_num * 4);

   return (ret_val);
 }


int16  cdecl  my_g_resolve (domain, real_domain, ip_list, ip_num)

char    *domain, **real_domain;
uint32  *ip_list;
int16   ip_num;

{
   int16  ret_val;

   write_function ("g_resolve");
   write_parameter ("Domain_Name", STRING, domain, "");
   write_parameter ("IP_List_Address", UINT32, & ip_list, "");
   write_parameter ("IP_List_Length", INT16, & ip_num, "");

   ret_val = g_resolve (domain, real_domain, ip_list, ip_num);

   write_parameter ("returns", INT16, & ret_val, get_error (ret_val));
   if (real_domain) {
        write_parameter ("Real_Buffer", UINT32, real_domain, "");
        if (*real_domain)
             write_buffer (*real_domain, 32);
      }
   write_parameter ("IP_List[0]", UINT32, ip_list, "");
   write_buffer ((char *) ip_list, ip_num * 4);

   return (ret_val);
 }


int16  cdecl  my_setvstr (name, value)

char  *name, *value;

{
   int16  ret_val;

   write_function ("setvstr");
   write_parameter ("Variable", STRING, name, "");
   write_parameter ("Value", STRING, value, "");

   ret_val = setvstr (name, value);

   write_parameter ("returns", INT16, & ret_val, (ret_val) ? "Okay" : "Error");

   return (ret_val);
 }


char *  cdecl  my_getvstr (name)

char  *name;

{
   char  *ret_val;

   write_function ("getvstr");
   write_parameter ("Variable", STRING, name, "");

   ret_val = getvstr (name);

   write_parameter ("returns", UINT32, & ret_val, ret_val);

   return (ret_val);
 }


int16  cdecl  my_on_port (port)

char  *port;

{
   int16  ret_val;

   write_function ("on_port");
   write_parameter ("Port_Name", STRING, port, "");

   ret_val = on_port (port);

   write_parameter ("returns", INT16, & ret_val, (ret_val) ? "Okay" : "Error");

   return (ret_val);
 }


void  cdecl  my_off_port (port)

char  *port;

{
   write_function ("off_port");
   write_parameter ("Port_Name", STRING, port, "");

   off_port (port);
 }


int16  cdecl  my_query_port (port)

char  *port;

{
   int16  ret_val;

   write_function ("query_port");
   write_parameter ("Port_Name", STRING, port, "");

   ret_val = query_port (port);

   write_parameter ("returns", INT16, & ret_val, (ret_val) ? "Connected" : "No Connection");

   return (ret_val);
 }


void  cdecl  my_ser_disable()

{
   write_function ("ser_disable");

   ser_disable();
 }


void  cdecl  my_ser_enable()

{
   write_function ("ser_enable");

   ser_enable();
 }


int16  cdecl  my_set_flag (flag)

int16  flag;

{
   int16  ret_val;

   write_function ("set_flag");
   write_parameter ("Flag_No", INT16, & flag, "");

   ret_val = set_flag (flag);

   write_parameter ("returns", INT16, & ret_val, (ret_val) ? "Failed" : "Success");

   return (ret_val);
 }


void  cdecl  my_clear_flag (flag)

int16  flag;

{
   write_function ("clear_flag");
   write_parameter ("Flag_No", INT16, & flag, "");

   clear_flag (flag);
 }


char *  cdecl  my_get_err_text (error)

int16  error;

{
   char  *ret_val;

   write_function ("get_err_text");
   write_parameter ("Error_No", INT16, & error, get_error (error));

   ret_val = get_err_text (error);

   write_parameter ("returns", STRING, ret_val, "");

   return (ret_val);
 }


int16  cdecl  my_carrier_detect()

{
   int16  ret_val;

   write_function ("carrier_detect");

   ret_val = carrier_detect();

   write_parameter ("returns", INT16, & ret_val,
             (ret_val) ? ((ret_val == 1) ? "Carrier" : "No Carrier") : "Unknown");

   return (ret_val);
 }


void  cdecl  my_housekeep()

{
   write_function ("housekeep");

   housekeep();
 }
