;----------------------------------------------------------------------------
;File name:	DISCARD.S			Revision date:	1999.04.13
;Creator:	Ulf Ronald Andersson		Creation date:	1997.12.01
;(c)1998 by:	Ulf Ronald Andersson		All rights reserved
;Feedback to:	dlanor@oden.se
;----------------------------------------------------------------------------
	include	RA_TOS.I
	include	RA_JAR.I
;
	include	sting\NETD.I
	include	sting\LAYER.I
	include	sting\TRANSPRT.I
;----------------------------------------------------------------------------
	output	.PRG
;----------------------------------------------------------------------------
M_YEAR	=	1999
M_MONTH	=	4
M_DAY	=	13
;
M_TITLE		MACRO
		dc.b	'DISCARD server'
		ENDM
M_VERSION	MACRO
		dc.b	'01.04'
		ENDM
M_AUTHOR	MACRO
		dc.b	'Ronald Andersson'
		ENDM
;----------------------------------------------------------------------------
ZERO_IP		=	0	;local IP code for listening connections
TOS_NORMAL	=	0	;normal TCP TOS code for TCP_open
DISCARD_PORT	=	9
BUF_SIZE	=	500
;----------------------------------------------------------------------------
;Start of:	server program
;----------------------------------------------------------------------------
	SECTION	TEXT
;----------------------------------------------------------------------------
text_start:
basepage	=	(text_start-$100)
my_SRV		=	basepage	;ND_SRV_base
;----------------------------------------------------------------------------
my_LongJump:
start:
	jmp	(start_1).l		;ND_SRV_jump
;----------------------------------------------------------------------------
;Start of:	Resident server data (starting with tail of NetD_SRV struct)
;----------------------------------------------------------------------------
my_magic:
	dc.l	ND_XB_ID	;ND_SRV_magic	;Must equal ND_XB_ID
	dc.l	'_SRV'		;ND_SRV_xmagic	;Must equal '_SRV'
	dc.l	REF_IF_VER	;ND_SRV_if_ver	;NetD interface version of server
	dc.w	((M_YEAR-1980)<<9)|(M_MONTH<<5)|M_DAY	;uint16 ND_SRV_date
	dc.l	my_version_s	;ND_SRV_version	;server version string in "xx.yy" format
	dc.l	my_author_s	;char_p ND_SRV_author	;-> name of author of server
;-------
	dc.l	my_title_s	;char_p ND_SRV_name	;name of the server
;-------
	dc.l	0		;struc_p ND_SRV_next	    ;-> next server struct or is NULL
	dc.l	my_SRV_connect	;func_p  ND_SRV_connect   ;-> server function used at connect
	dc.l	my_SRV_traffic	;func_p  ND_SRV_traffic   ;-> server function for fluent traffic
	dc.l	my_SRV_warning	;func_p  ND_SRV_warning ;-> server function used at NetD APP termination
	dc.l	0		;struc_p ND_SRV_listen_q  ;-> queue for listening connections
	dc.l	0		;struc_p ND_SRV_turnon_q  ;-> queue for connections turning active
	dc.l	0		;struc_p ND_SRV_active_q  ;-> queue for active connections
	dc.w	0		;uint16  ND_SRV_flags     ;control flags
;----------------------------------------------------------------------------
sting_drivers:	dc.l	0	;DRV_LIST	*sting_drivers;
tpl:		dc.l	0	;TPL		*tpl;
stx:		dc.l	0	;STX		*stx;
;----------------------------------------------------------------------------
my_title_s:
	M_TITLE
	dc.b	NUL
my_version_s:
	M_VERSION
	dc.b	NUL
my_author_s:
	M_AUTHOR
	dc.b	NUL
	EVEN
;----------------------------------------------------------------------------
NetD_STX_p:	dc.l	0
;----------------------------------------------------------------------------
;End of:	Resident server data
;----------------------------------------------------------------------------
;Start of:	Main server functions
;----------------------------------------------------------------------------
;Start of:	my_SRV_connect
;----------------------------------------------------------------------------
;int16	my_SRV_connect (NetD_APP *NetD_APP_p, NetD_CON *new_con_p);
;
my_SRV_connect:
	lv_init		sp			;use sp to index args & locals
	lv_arg.l	NetD_APP_p		;-> NetD_APP struct
	lv_arg.l	new_con_p		;-> newly activated NetD_CON struct
;-------
	TIMER_now				;d0 = current time
	move.l		new_con_p(sp),a0	;a0 -> NetD_CON
	move.l		d0,ND_CON_pad(a0)	;store d0 as activity time in pad
	moveq		#E_NORMAL,d0		;flag acceptance of connection
;-------
	lv_exit		sp			;end scope of sp for args & locals
	rts					;return to caller (the NetD STX)
;----------------------------------------------------------------------------
;End of:	my_SRV_connect
;----------------------------------------------------------------------------
;Start of:	my_SRV_traffic
;----------------------------------------------------------------------------
;void my_SRV_traffic (NetD_APP *NetD_APP_p);
;
my_SRV_traffic:
	lv_init		a6		;use a6 to index args & locals
	lv_arg.l	NetD_APP_p	;-> NetD_APP struct
	movem.l		a2-a4,-(sp)	;push some registers
;-------
	move.l	NetD_STX_p(pc),a3	;a3 -> NetD_STX struct  (from cookie)
	move.l	ND_SRV_active_q+my_SRV(pc),a4	;a4 -> NetD_CON in active queue
	move.l	a4,d0			;d0 -> current NetD_CON for traffic
	ble	exit_traffic		;exit at end of queue
traffic_loop:
	move.l		ND_CON_next(a4),a2	;a2 -> next NetD_CON (for next loop)
;
	CNbyte_count	ND_CON_handle(a4)
	cmp		#E_NODATA,d0
	beq.s		done_traffic		;done on E_NODATA
	tst		d0
	beq.s		done_traffic		;done if byte_count = 0
	bmi.s		kill_traffic		;go kill CON on network errors
read_traffic:
	CNget_NDB	ND_CON_handle(a4)	;d0 -> ndb
	tst.l		d0			;did we get a new NDB ?
	ble.s		done_traffic		;if not we're done
	move.l		d0,a3			;a3 -> ndb
	KRfree.i	NDB_ptr(a3)		;release data RAM of NDB
	KRfree		(a3)			;release RAM of NDB struct
	TIMER_now				;d0 = current time
	move.l		d0,ND_CON_pad(a4)	;store d0 as activity time in pad
done_traffic:
	TIMER_elapsed	ND_CON_pad(a4)		;d0 = measured time since activity
	cmp.l		#1*60*1000,d0		;d0 >= 1 minute silence ?
	bhs.s		kill_traffic		;if so, abort connection
	tst		ND_CON_type(a4)		;TCP/UDP ?
	bne.s		next_traffic		;continue for TCP connection
kill_traffic:
	pea	(a4)			;push -> NetD_CON to be killed
	pea	my_SRV(pc)		;push -> NetD_SRV of this server
	move.l	ND_kill_CON(a3),a0	;a0 -> ND_kill_CON function in NetD STX
	jsr	(a0)			;call ND_kill_CON function in NetD_STX
	addq	#8,sp			;clean stack
next_traffic:
	move.l	a2,a4			;a4 -> next NetD_CON in queue
	move.l	a2,d0			;test next NetD_CON
	bgt	traffic_loop		;loop unless at end of queue
exit_traffic:
	movem.l	(sp)+,a2-a4		;pull some registers
	lv_exit	a6			;end scope of a6 for args & locals
	rts				;return to caller (the NetD STX)
;----------------------------------------------------------------------------
;End of:	my_SRV_traffic
;----------------------------------------------------------------------------
;Start of:	my_SRV_warning
;----------------------------------------------------------------------------
;void my_SRV_warning (NetD_APP *NetD_APP_p);
;
my_SRV_warning:
	rts
;----------------------------------------------------------------------------
;End of:	my_SRV_warning
;----------------------------------------------------------------------------
;End of:	Main server functions
;----------------------------------------------------------------------------
;Start of:	Resident library code used by server
;----------------------------------------------------------------------------
	make	JAR_links
;----------------------------------------------------------------------------
resident_end:
;all beyond this point will be released in going resident
resident_size	=	resident_end-text_start+$100
;----------------------------------------------------------------------------
;End of:	Resident server routines
;----------------------------------------------------------------------------
;Start of:	Non-resident server initialization code
;----------------------------------------------------------------------------
start_1:
	move.l		a0,d0
	bne.s		.have_basepage
	move.l		4(sp),d0
.have_basepage:
	move.l		d0,a5
	lea		mystack(pc),sp
	move.l		a0,d0
	bne		.ACC_launch
	gemdos		Mshrink,#0,(a5),#initial_size
;
	gemdos		Super,!
	move.l		d0,d7
	eval_cookie	#"STiK"
	move.l		d0,sting_drivers		;store -> DRV_LIST structure
	eval_cookie	#ND_XB_ID
	move.l		d0,NetD_STX_p			;store -> NetD cookie struct
.done_cookies:
	gemdos		Super|_ind,d7
;
	move.l		sting_drivers(pc),d0
	ble		.STiK_not_found
	move.l		d0,a3				;a3 -> DRV_LIST structure
	tst.l		NetD_STX_p
	ble		.NetD_not_found
;
	lea		DRV_LIST_magic(a3),a0
	lea		STiKmagic_s(pc),a1
	moveq		#10-1,d0
.strcmp_loop:					;loop to test STiKmagic of DRV_LIST
	cmpm.b		(a0)+,(a1)+
	dbne		d0,.strcmp_loop
	bne		.STiK_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		TRANSPORT_DRIVER_s		;-(sp) = "TRANSPORT_TCPIP"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,tpl				;store pointer in 'tpl'
	ble		.driver_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		MODULE_DRIVER_s			;-(sp) = "MODULE_LAYER"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,stx				;store pointer in 'stx'
	ble.s		.layer_not_valid
.install:
	NetD_init_SRV	my_SRV(pc)		;login server with NetD STX
	tst.l		d0			;test result
	bmi.s		.server_refused
	NetD_init_CON	my_SRV(pc),!,#DISCARD_PORT		;request UDP DISCARD service
	NetD_init_CON	my_SRV(pc),#BUF_SIZE,#DISCARD_PORT	;request TCP DISCARD service
.final_install:
	gemdos	Ptermres,#resident_size,#0
;-------------------------------------
.ACC_launch:
	lea	ACC_launch_s(pc),a0
	bsr.s	report_error
.loop:
	bra	.loop
;-------------------------------------
.NetD_not_found:
	lea	NetD_not_found_s,a0
	bra.s	.error_exit
;-------------------------------------
.STiK_not_found:
	lea	STiK_not_found_s,a0
	bra.s	.error_exit
;-------------------------------------
.STiK_not_valid:
	lea	STiK_not_valid_s,a0
	bra.s	.error_exit
;-------------------------------------
.driver_not_valid:
	lea	driver_not_valid_s,a0
	bra.s	.error_exit
;-------------------------------------
.layer_not_valid:
	lea	layer_not_valid_s(pc),a0
	bra.s	.error_exit
;-------------------------------------
.server_refused:
	lea	server_refused_s(pc),a0
.error_exit:
	bsr.s	report_error
	gemdos	Pterm,#E_ERROR
;-------------------------------------
report_error:
	move.l	a0,-(sp)
	lea	error_title_s(pc),a0
	bsr.s	Cconws_sub
	move.l	(sp)+,a0
	bsr.s	Cconws_sub
	lea	error_tail_s(pc),a0
Cconws_sub:
	gemdos	Cconws,(a0)
	rts
;----------------------------------------------------------------------------
;End of:	Non-resident server initialization code with tests
;----------------------------------------------------------------------------
;Start of:	Non-resident library code used by server
;----------------------------------------------------------------------------
	make	JAR_links
;----------------------------------------------------------------------------
;End of:	Non-resident library code used by server
;----------------------------------------------------------------------------
text_limit:
text_size	= text_limit-text_start
	SECTION	DATA
data_start:
;----------------------------------------------------------------------------
;Start of:	Non-resident data used by server
;----------------------------------------------------------------------------
STiKmagic_s:
	dc.b	'STiKmagic',NUL
TRANSPORT_DRIVER_s:
	dc.b	'TRANSPORT_TCPIP',NUL
MODULE_DRIVER_s:
	dc.b	'MODULE_LAYER',NUL
;-------------------------------------
ACC_launch_s:
	dc.b	'This non-ACC, was launched as an ACC,',CR,LF
	dc.b	'so now you must reset the computer !',CR,LF
	dc.b	'I am looping forever to avoid damage',CR,LF
	dc.b	'that could occur if I try to exit !',CR,LF
	dc.b	NUL
;-------------------------------------
NetD_not_found_s:
	dc.b	'There is no NetD cookie in the jar !',CR,LF
	dc.b	NUL
;-------------------------------------
STiK_not_found_s:
	dc.b	'There is no STiK cookie in the jar !',CR,LF
	dc.b	NUL
;-------------------------------------
STiK_not_valid_s:
	dc.b	'The STiK cookie data is corrupt !',CR,LF
	dc.b	NUL
;-------------------------------------
driver_not_valid_s:
	dc.b	'The main STinG driver is not valid !',CR,LF
	dc.b	NUL
;-------------------------------------
layer_not_valid_s:
	dc.b	'The STinG module layer is not valid !',CR,LF
	dc.b	NUL
;-------------------------------------
server_refused_s:
	dc.b	'NetD STX refused login of DISCARD server !',CR,LF
	dc.b	NUL
;-------------------------------------
error_title_s:
	dc.b	BEL,CR,LF
	dc.b	'------------'
	M_TITLE
	dc.b	' '
	M_VERSION
	dc.b	'------------',CR,LF
	dc.b	NUL
;-------------------------------------
	EVEN
error_tail_s:
	M_TITLE
	dc.b	'installation aborted.',CR,LF
	dc.b	BEL,CR,LF,NUL
	EVEN
;----------------------------------------------------------------------------
;End of:	Non-resident data used by server
;----------------------------------------------------------------------------
data_limit:
data_size	=	data_limit-data_start
	SECTION	BSS
bss_start:
;----------------------------------------------------------------------------
		ds.l	200		;subroutine stack >= 100 longs
mystack:	ds.l	1		;top of subroutine stack
;----------------------------------------------------------------------------
bss_limit:
bss_size	=	bss_limit-bss_start
;----------------------------------------------------------------------------
initial_size	=	text_size+data_size+bss_size+$100
;----------------------------------------------------------------------------
;End of file:	DISCARD.S
;----------------------------------------------------------------------------
