;----------------------------------------------------------------------------
;File name:	TSTROM_1.S			Revision date:	2000.09.01
;Creator:	Ulf Ronald Andersson		Creation date:	2000.09.01
;(c)1995 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
	output	.APP
;----------------------------------------------------------------------------
	include	RA_JAR.I
	include	RA_APP.I
	include	RA_SIM.I
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
id_app_name_s:	dc.b	'TSTROM_1',0
		even
acc_name:	dc.b	'  Test ROMport',0
		even
;----------------------------------------------------------------------------
	SECTION	bss
;----------------------------------------------------------------------------
mystack_data:	ds.l	$100
mystack:	ds.w	1	;User defined stack (goes backwards).
message:	ds.b	16	;Message pipe.
intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
;-------------------------------------
errno:		ds.w	1
;----------------------------------------------------------------------------
	SECTION	text
;----------------------------------------------------------------------------
start:
	start_app
;----------------------------------------------------------------------------
init_app:
	rts
;----------------------------------------------------------------------------
exec_app:
	sim_aes	form_alert,#2,wanna_test_al_s(pc)
	cmp	#1,d0
	beq	terminate
make_tests:
;-------
	bsr	test_d0_loop_sub
	move.l	d0,d4			;d4 = ref loop time
	bsr	access_00_loop_sub
	move.l	d0,d5			;d5 = access 00 loop time
	bsr	access_FF_loop_sub
	move.l	d0,d6			;d6 = access FF loop time
;-------
	move.l	d4,d0
	lea	test_d0_loop_time_s(pc),a0
	bsr	ultoa_dec
;---
	move.l	d5,d0
	lea	access_00_loop_time_s(pc),a0
	bsr	ultoa_dec
;---
	move.l	d6,d0
	lea	access_FF_loop_time_s(pc),a0
	bsr	ultoa_dec
;---
	move.l	d5,d0		;d0 = loop_ms for tests at $00FA0000
	sub.l	d4,d0		;d0 = cost_ms = cost of 8*Mb accesses
	mulu	#15625,d0	;d0 = cost_ms*Million/64 = cost_ns/64
	clr	d0
	swap	d0		;d0 /= 64*Kb = cost_ns/(4*Mb) = access_ns
	lea	access_00_time_s(pc),a0
	bsr	ultoa_dec
;---
	move.l	d6,d0		;d0 = loop_ms for tests at $FFFA0000
	sub.l	d4,d0		;d0 = cost_ms = cost of 8*Mb accesses
	mulu	#15625,d0	;d0 = cost_ms*Million/64 = cost_ns/64
	clr	d0
	swap	d0		;d0 /= 64*Kb = cost_ns/(4*Mb) = access_ns
	lea	access_FF_time_s(pc),a0
	bsr	ultoa_dec
;-------
	lea	result_al_s(pc),a0
	lea	result_al_head_s(pc),a1
	bsr	strcpy
;---
	lea	test_d0_loop_res_s1(pc),a1
	bsr	strcat
	lea	test_d0_loop_time_s(pc),a1
	bsr	strcat
	lea	test_d0_loop_res_s2(pc),a1
	bsr	strcat
;---
	lea	result_al_sep_s(pc),a1
	bsr	strcat
;---
	lea	access_00_loop_res_s1(pc),a1
	bsr	strcat
	lea	access_00_loop_time_s(pc),a1
	bsr	strcat
	lea	access_00_loop_res_s2(pc),a1
	bsr	strcat
;---
	lea	result_al_sep_s(pc),a1
	bsr	strcat
;---
	lea	access_FF_loop_res_s1(pc),a1
	bsr	strcat
	lea	access_FF_loop_time_s(pc),a1
	bsr	strcat
	lea	access_FF_loop_res_s2(pc),a1
	bsr	strcat
;---
	lea	result_al_sep_s(pc),a1
	bsr	strcat
;---
	lea	access_00_res_s1(pc),a1
	bsr	strcat
	lea	access_00_time_s(pc),a1
	bsr	strcat
	lea	access_00_res_s2(pc),a1
	bsr	strcat
;---
	lea	result_al_sep_s(pc),a1
	bsr	strcat
;---
	lea	access_FF_res_s1(pc),a1
	bsr	strcat
	lea	access_FF_time_s(pc),a1
	bsr	strcat
	lea	access_FF_res_s2(pc),a1
	bsr	strcat
;---
	lea	result_al_tail_s(pc),a1
	bsr	strcat
;-------
	sim_aes	form_alert,#1,result_al_s(pc)
	cmp	#1,d0
	bne	make_tests
terminate:
	clr.l	d0
	rts
;----------------------------------------------------------------------------
test_d0_loop_sub:
	movem.l	d1-d3/a0-a3,-(sp)
	gemdos	Super,!
	move.l	d0,-(sp)
;-------
	move.l	#4*Kb,d1	;d1 = loop count 4M/1K
	move.l	(_hz_200).w,d3	;d3 = loop start time in 5*ms units
.loop:
;-----	Start of loop content to be tested
	REPT	Kb
	tst	d0		;simple, for test reference
	ENDR
;-----  End of loop content to be tested
	subq.l	#1,d1
	bne	.loop
	move.l	(_hz_200).w,d0	;d0 = loop end time in 5*ms units
	sub.l	d3,d0		;d0 = loop time in 5*ms units
	move.l	d0,d3		;d3 = loop time in 5*ms units
	asl.l	#2,d0		;d0 = loop time in 5*ms/4 units
	add.l	d0,d3		;d3 = loop time in ms units
	gemdos	Super,()
	move.l	d3,d0		;d0 = loop time in ms units
	movem.l	(sp)+,d1-d3/a0-a3
	rts
;-------------------------------------
access_00_loop_sub:
	movem.l	d1-d3/a0-a3,-(sp)
	gemdos	Super,!
	move.l	d0,-(sp)
;-------
	lea	$00FA0000,a0	;a0 -> cartridge at $00FA0000
	move.l	#4*Kb,d1	;d1 = loop count 4M/1K
	move.l	(_hz_200).w,d3	;d3 = loop start time in 5*ms units
.loop:
;-----	Start of loop content to be tested
	REPT	Kb
	tst.b	(a0)		;test one byte access of cartridge
	ENDR
;-----  End of loop content to be tested
	subq.l	#1,d1
	bne	.loop
	move.l	(_hz_200).w,d0	;d0 = loop end time in 5*ms units
	sub.l	d3,d0		;d0 = loop time in 5*ms units
	move.l	d0,d3		;d3 = loop time in 5*ms units
	asl.l	#2,d0		;d0 = loop time in 5*ms/4 units
	add.l	d0,d3		;d3 = loop time in ms units
	gemdos	Super,()
	move.l	d3,d0		;d0 = loop time in ms units
	movem.l	(sp)+,d1-d3/a0-a3
	rts
;-------------------------------------
access_FF_loop_sub:
	movem.l	d1-d3/a0-a3,-(sp)
	gemdos	Super,!
	move.l	d0,-(sp)
;-------
	lea	$FFFA0000,a0	;a0 -> cartridge at $FFFA0000
	move.l	#4*Kb,d1	;d1 = loop count 4M/1K
	move.l	(_hz_200).w,d3	;d3 = loop start time in 5*ms units
.loop:
;-----	Start of loop content to be tested
	REPT	Kb
	tst.b	(a0)		;test one byte access of cartridge
	ENDR
;-----  End of loop content to be tested
	subq.l	#1,d1
	bne	.loop
	move.l	(_hz_200).w,d0	;d0 = loop end time in 5*ms units
	sub.l	d3,d0		;d0 = loop time in 5*ms units
	move.l	d0,d3		;d3 = loop time in 5*ms units
	asl.l	#2,d0		;d0 = loop time in 5*ms/4 units
	add.l	d0,d3		;d3 = loop time in ms units
	gemdos	Super,()
	move.l	d3,d0		;d0 = loop time in ms units
	movem.l	(sp)+,d1-d3/a0-a3
	rts
;----------------------------------------------------------------------------
	include	standard\strcpy.s
	include	standard\strcat.s
	include	standard\ultoa.s
;----------------------------------------------------------------------------
	make	SIM_links
	make	JAR_links
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
wanna_test_al_s:	dc.b	'[1]['
			dc.b	'Ready to test cartridge port.|'
			dc.b	'4194304 (4 M) tests per loop,|'
			dc.b	'with 3 loops run, one tst d0,|'
			dc.b	'one accessing $00FA0000, and |'
			dc.b	'one accessing $FFFA0000.     ]'
			dc.b	'[ Cancel |  Test  ]',NUL
			EVEN
;-------------------------------------
result_al_s:		ds.b	256
;-------------------------------------
result_al_head_s:	dc.b	'[1][',NUL
result_al_sep_s:	dc.b	'|',NUL
result_al_tail_s:	dc.b	'][ Cancel | Repeat ]',NUL
;-------------------------------------
test_d0_loop_res_s1:	dc.b	'tst d0 ref used ',NUL
test_d0_loop_time_s:	ds.b	12
test_d0_loop_res_s2:	dc.b	' ms',NUL
;-------------------------------------
access_00_loop_res_s1:	dc.b	'tst $00FA0000=> ',NUL
access_00_loop_time_s:	ds.b	12
access_00_loop_res_s2:	dc.b	' ms',NUL
;-------------------------------------
access_FF_loop_res_s1:	dc.b	'tst $FFFA0000=> ',NUL
access_FF_loop_time_s:	ds.b	12
access_FF_loop_res_s2:	dc.b	' ms',NUL
;-------------------------------------
access_00_res_s1:	dc.b	'$00FA0000 cost= ',NUL
access_00_time_s:	ds.b	12
access_00_res_s2:	dc.b	' ns',NUL
;-------------------------------------
access_FF_res_s1:	dc.b	'$FFFA0000 cost= ',NUL
access_FF_time_s:	ds.b	12
access_FF_res_s2:	dc.b	' ns',NUL
			EVEN
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	TSTROM_1.S
;----------------------------------------------------------------------------
