;----------------------------------------------------------------------------
;File name:	TSTROM_2.S			Revision date:	2000.09.01
;Creator:	Ulf Ronald Andersson		Creation date:	2000.09.01
;(c)1995 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
	output	.APP
;----------------------------------------------------------------------------
	include	RA_JAR.I
	include	RA_APP.I
	include	RA_SIM.I
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
id_app_name_s:	dc.b	'TSTROM_2',0
		even
acc_name:	dc.b	'  Rate ROMport',0
		even
;----------------------------------------------------------------------------
	SECTION	bss
;----------------------------------------------------------------------------
mystack_data:	ds.l	$100
mystack:	ds.w	1	;User defined stack (goes backwards).
message:	ds.b	16	;Message pipe.
intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
;-------------------------------------
errno:		ds.w	1
copy_buf:	ds.w	2048	;NB: doubled size, for safety
;----------------------------------------------------------------------------
	SECTION	text
;----------------------------------------------------------------------------
start:
	start_app
;----------------------------------------------------------------------------
init_app:
	rts
;----------------------------------------------------------------------------
exec_app:
	sim_aes	form_alert,#2,wanna_test_al_s(pc)
	cmp	#1,d0
	beq	terminate
make_tests:
;-------
	bsr	access_00_loop_sub
	move.l	d0,d5			;d5 = access 00 loop time
	bsr	access_FF_loop_sub
	move.l	d0,d6			;d6 = access FF loop time
;-------
	move.l	d5,d0
	lea	access_00_loop_time_s(pc),a0
	bsr	ultoa_dec
;---
	move.l	d6,d0
	lea	access_FF_loop_time_s(pc),a0
	bsr	ultoa_dec
;---
	move.l	#Kd*Mb,d0	;d0 = $00FAxxxx accesses made * 1000  D_l
	move	d0,d1		;d1 = x.D_l
	clr	d0		;d0 = D_h.0
	swap	d0		;d0 = 0.Dh
	divu	d5,d0		;d0 = R_h.Q_h
	swap	d0		;d0 = Qh.R_h
	swap	d1		;d1 = D_l.0
	move	d0,d1		;d1 = D_l.R_h
	clr	d0		;d0 = Q_h.0
	swap	d1		;d1 = R_h.D_l
	divu	d5,d1		;d1 = R_l.Q_l
	move	d1,d0		;d0 = $00FAxxxx accesses made per second
	lea	access_00_rate_s(pc),a0
	bsr	ultoa_dec
;---
	move.l	#Kd*Mb,d0	;d0 = $FFFAxxxx accesses made * 1000  D_l
	move	d0,d1		;d1 = x.D_l
	clr	d0		;d0 = D_h.0
	swap	d0		;d0 = 0.Dh
	divu	d6,d0		;d0 = R_h.Q_h
	swap	d0		;d0 = Qh.R_h
	swap	d1		;d1 = D_l.0
	move	d0,d1		;d1 = D_l.R_h
	clr	d0		;d0 = Q_h.0
	swap	d1		;d1 = R_h.D_l
	divu	d6,d1		;d1 = R_l.Q_l
	move	d1,d0		;d0 = $FFFAxxxx accesses made per second
	lea	access_FF_rate_s(pc),a0
	bsr	ultoa_dec
;-------
	lea	result_al_s(pc),a0
	lea	result_al_head_s(pc),a1
	bsr	strcpy
;---
	lea	access_00_loop_res_s1(pc),a1
	bsr	strcat
	lea	access_00_loop_time_s(pc),a1
	bsr	strcat
	lea	access_00_loop_res_s2(pc),a1
	bsr	strcat
;---
	lea	result_al_sep_s(pc),a1
	bsr	strcat
;---
	lea	access_FF_loop_res_s1(pc),a1
	bsr	strcat
	lea	access_FF_loop_time_s(pc),a1
	bsr	strcat
	lea	access_FF_loop_res_s2(pc),a1
	bsr	strcat
;---
	lea	result_al_sep_s(pc),a1
	bsr	strcat
;---
	lea	access_00_res_s1(pc),a1
	bsr	strcat
	lea	access_00_rate_s(pc),a1
	bsr	strcat
	lea	access_00_res_s2(pc),a1
	bsr	strcat
;---
	lea	result_al_sep_s(pc),a1
	bsr	strcat
;---
	lea	access_FF_res_s1(pc),a1
	bsr	strcat
	lea	access_FF_rate_s(pc),a1
	bsr	strcat
	lea	access_FF_res_s2(pc),a1
	bsr	strcat
;---
	lea	result_al_tail_s(pc),a1
	bsr	strcat
;-------
	sim_aes	form_alert,#1,result_al_s(pc)
	cmp	#1,d0
	bne	make_tests
terminate:
	clr.l	d0
	rts
;----------------------------------------------------------------------------
access_00_loop_sub:
	movem.l	d1-d3/a0-a3,-(sp)
	gemdos	Super,!
	move.l	d0,-(sp)
;-------
	move.l	#Kb,d1		;d1 = loop count 1M/1K
	move.l	(_hz_200).w,d3	;d3 = loop start time in 5*ms units
.loop:
	lea	$00FA0000,a0	;a0 -> cartridge at $00FA0000
	lea	copy_buf(pc),a1	;a1 -> copy_buf for 1K Words (2 KB)
;-----	Start of loop content to be tested
	REPT	Kb
	move	(a0)+,(a1)+	;transfer a 16-bit word
	ENDR
;-----  End of loop content to be tested
	subq.l	#1,d1
	bne	.loop
	move.l	(_hz_200).w,d0	;d0 = loop end time in 5*ms units
	sub.l	d3,d0		;d0 = loop time in 5*ms units
	move.l	d0,d3		;d3 = loop time in 5*ms units
	asl.l	#2,d0		;d0 = loop time in 5*ms/4 units
	add.l	d0,d3		;d3 = loop time in ms units
	gemdos	Super,()
	move.l	d3,d0		;d0 = loop time in ms units
	movem.l	(sp)+,d1-d3/a0-a3
	rts
;-------------------------------------
access_FF_loop_sub:
	movem.l	d1-d3/a0-a3,-(sp)
	gemdos	Super,!
	move.l	d0,-(sp)
;-------
	move.l	#Kb,d1		;d1 = loop count 1M/1K
	move.l	(_hz_200).w,d3	;d3 = loop start time in 5*ms units
.loop:
	lea	$FFFA0000,a0	;a0 -> cartridge at $FFFA0000
	lea	copy_buf(pc),a1	;a1 -> copy_buf for 1K Words (2 KB)
;-----	Start of loop content to be tested
	REPT	Kb
	move	(a0)+,(a1)+	;transfer a 16-bit word
	ENDR
;-----  End of loop content to be tested
	subq.l	#1,d1
	bne	.loop
	move.l	(_hz_200).w,d0	;d0 = loop end time in 5*ms units
	sub.l	d3,d0		;d0 = loop time in 5*ms units
	move.l	d0,d3		;d3 = loop time in 5*ms units
	asl.l	#2,d0		;d0 = loop time in 5*ms/4 units
	add.l	d0,d3		;d3 = loop time in ms units
	gemdos	Super,()
	move.l	d3,d0		;d0 = loop time in ms units
	movem.l	(sp)+,d1-d3/a0-a3
	rts
;----------------------------------------------------------------------------
	include	standard\strcpy.s
	include	standard\strcat.s
	include	standard\ultoa.s
;----------------------------------------------------------------------------
	make	SIM_links
	make	JAR_links
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
wanna_test_al_s:	dc.b	'[1]['
			dc.b	'Ready to rate cartridge port.|'
			dc.b	'using move (a0)+,(a1)+ as we |'
			dc.b	'might use with ideal adapter.|'
			dc.b	'1M moves per loop, performed |'
			dc.b	'for each of 2 cartridge bases]'
			dc.b	'[ Cancel |  Rate  ]',NUL
			EVEN
;-------------------------------------
result_al_s:		ds.b	256
;-------------------------------------
result_al_head_s:	dc.b	'[1][',NUL
result_al_sep_s:	dc.b	'|',NUL
result_al_tail_s:	dc.b	'|'
			dc.b	'"aps" = accesses per second'
			dc.b	'][ Cancel | Repeat ]',NUL
;-------------------------------------
access_00_loop_res_s1:	dc.b	'$00* loop= ',NUL
access_00_loop_time_s:	ds.b	12
access_00_loop_res_s2:	dc.b	' ms',NUL
;-------------------------------------
access_FF_loop_res_s1:	dc.b	'$FF* loop= ',NUL
access_FF_loop_time_s:	ds.b	12
access_FF_loop_res_s2:	dc.b	' ms',NUL
;-------------------------------------
access_00_res_s1:	dc.b	'$00* rate= ',NUL
access_00_rate_s:	ds.b	12
access_00_res_s2:	dc.b	' aps',NUL
;-------------------------------------
access_FF_res_s1:	dc.b	'$FF* rate= ',NUL
access_FF_rate_s:	ds.b	12
access_FF_res_s2:	dc.b	' aps',NUL
			EVEN
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	TSTROM_2.S
;----------------------------------------------------------------------------
