;----------------------------------------------------------------------------
;File name:	BASE64.S			Revision date:	1999.05.29
;Created by:	Ronald Andersson		Creation date:	1999.05.29
;----------------------------------------------------------------------------
;void base64_str_enc(char *source, char *dest)
;
base64_str_enc:
.loop:
 	clr	d0
 	move.b	(a0),d0			;get 1st source byte
 	beq.s	.pad_term		;go pad terminator at end
 	lsr	#2,d0			;shift 6 high bits to bits 0..5
 	move.b	table_64(pc,d0),(a1)+	;append 1st encoded char to dest
 	move.b	(a0)+,d0		;reget 1st source byte and prep a0 for next
 	lsl	#8,d0			;shift 2 low bits to bits 8..9
 	move.b	(a0),d0			;get 2nd source byte
 	ror	#4,d0			;align 6 combined bits at bits 0..5
 	and	#$3F,d0			;isolate them from unwanted bits
 	move.b	table_64(pc,d0),(a1)+	;append 2nd encoded char to dest
 	move.b	(a0)+,d0		;reget 2nd source byte and prep a0 for next
 	beq.s	.pad_twice		;go pad two chars if source ends here
 	lsl	#8,d0			;shift 4 low bits to bits 8..11
 	move.b	(a0),d0			;get 3rd source byte
 	ror	#6,d0			;align 6 combined bits at bits 0..5
 	and	#$3F,d0			;isolate them from unwanted bits
 	move.b	table_64(pc,d0),(a1)+	;append 3rd encoded char to dest
 	move.b	(a0)+,d0		;reget 3rd source byte and prep a0 for next
 	beq.s	.pad_once		;go pad one char if source ends here
 	and	#$3F,d0			;isolate the 6 low bits in bits 0..5
 	move.b	table_64(pc,d0),(a1)+	;append 4th encoded char to dest
 	bra.s	.loop
;-------
 .pad_twice:
 	move.b	#'=',(a1)+		;pad a dummy char to dest
 .pad_once:
 	move.b	#'=',(a1)+		;pad a dummy char to dest
 .pad_term:
 	clr.b	(a1)+			;pad a string terminator to dest
 	rts				;return to caller
;-------
table_64:
	dc.b	"ABCDEFGHIJKLMNOP"
	dc.b	"QRSTUVWXYZabcdef"
	dc.b	"ghijklmnopqrstuv"
	dc.b	"wxyz0123456789+/"
;----------------------------------------------------------------------------
;End of file:	BASE64.S
;----------------------------------------------------------------------------
