;----------------------------------------------------------------------------
;File name:	EZIP_UPD.S			Revision date:	1999.06.02
;Creator:	Ulf Ronald Andersson		Creation date:	1999.05.29
;(c)1999 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
;;;huge_program		= 1	;uncomment if TEXT+DATA sections are > 32KB
;;;keep_windows		= 1	;uncomment to keep ACC vwk in main eventloop
exec_timeout		= 1000	;uncomment to enable timer in main eventloop
exec_message		= 1	;uncomment for messages in main eventloop
;----------------------------------------------------------------------------
	output	.TTP
;----------------------------------------------------------------------------
;Required header declarations:
;
	include	RA_JAR.I		;Cookie jar handling
	include	RA_AV.I			;AV/VA protocol + MP protocol
	include	RA_APP.I		;General application support
	include	RA_ARG.I		;ARGV handler
	include	RA_SIM.I		;GEM alert simulation for TOS/TTP
;
	include	sting\LAYER.I		;only used by servers/modules
	include	sting\TRANSPRT.I	;used by all STinG programs
	include	sting\DOMAIN.I		;handles domain name/ip conv.
;----------------------------------------------------------------------------
EZIP_PORT	equ	80
TOS_NORMAL	equ	0
BUF_SIZE	equ	4096
MAX_VA_ARGLEN	equ	512
STAB_DELAY	equ	200
;----------------------------------------------------------------------------
	SECTION	TEXT
;----------------------------------------------------------------------------
	start_app
;----------------------------------------------------------------------------
	IFEQ	huge_program
	SECTION	data
	ENDC
;----------------------------------------------------------------------------
acc_name:
	dc.b	'  EZ-IP update',NUL	;for ACC menu registration
	dc.b	NUL
	even
;
id_app_name_s:
	dc.b	'EZIP_UPD',NUL
	even
;----------------------------------------------------------------------------
	IFEQ	huge_program
	SECTION	BSS
	ENDC
;----------------------------------------------------------------------------
message:	ds.w	8		;evnt_mesag message pipe
intin:		ds.w	30		;30 words or more for AES/VDI
intout:		ds.w	45		;45 words or more for AES/VDI
ptsin:		ds.w	30		;30 words or more for VDI
ptsout:		ds.w	12		;12 words or more for VDI output coordinates
		ds.l	1024		;subroutine stack >= 100 longs
mystack:	ds.l	1		;top of subroutine stack
;----------------------------------------------------------------------------
	SECTION	TEXT
;----------------------------------------------------------------------------
;Start of:	init_app
;----------------------------------------------------------------------------
init_app:
	start_arg
;-------
	move.l		arg_ptr,a0
.done_arg:
;
	st		fatal_f			;assume fatal errors can happen
	gemdos		Super,0.w
	move.l		d0,d4
	eval_cookie	#"STiK"
	move.l		d0,d3			;d3 = d0 -> DRV_LIST structure
	gemdos		Super|_ind,d4
	move.l		d3,sting_drivers	;sting_drivers -> DRV_LIST structure
	ble.s		.STiK_not_found
	move.l		d3,a3			;a3 -> DRV_LIST structure
	lea		DRV_LIST_magic(a3),a0
	lea		STiKmagic_s(pc),a1
	moveq		#10-1,d0
.strcmp_loop:					;loop to test STiKmagic of DRV_LIST
	cmpm.b		(a0)+,(a1)+
	dbne		d0,.strcmp_loop
	bne.s		.STiK_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		TRANSPORT_DRIVER_s		;-(sp) = "TRANSPORT_TCPIP"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,tpl				;store pointer in 'tpl'
	ble.s		.driver_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		MODULE_DRIVER_s			;-(sp) = "MODULE_LAYER"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,stx				;store pointer in 'tpl'
	ble.s		.layer_not_valid
	clr		fatal_f
;
;Add client/server dependent init here
;
	clr.l		initerr_mess_p
	rts
;
.STiK_not_found:
	lea		STiK_not_found_al_s(pc),a0
	bra.s		.init_error
;
.STiK_not_valid:
	lea		STiK_not_valid_al_s(pc),a0
	bra.s		.init_error
;
.driver_not_valid:
	lea		driver_not_valid_al_s(pc),a0
	bra.s		.init_error
;
.layer_not_valid:
	lea		layer_not_valid_al_s(pc),a0
.init_error:
	move.l		a0,initerr_mess_p
	rts
;----------------------------------------------------------------------------
;End of:	init_app
;----------------------------------------------------------------------------
;Start of:	exec_app
;----------------------------------------------------------------------------
exec_app:
	move.l		initerr_mess_p,d3
	beq.s		no_init_err
	move.l		d3,a3
	sim_aes		form_alert,#1,(a3)
	tst		fatal_f
	bne		exit_exec_err
no_init_err:
	clr	d0			;preclear low word of d0
	tst.w	d7			;MI/PL == TOS/GEM
	bmi.s	.TOS_checked		;go keep d0 bit_3 cleared for TOS/TTP program
	bset	#3,d0			;set d0 bit_3 for GEM program
.TOS_checked:
	cmp	#1,global+2		;EQ/NE == Single/Multi-tasking AES
	beq.s	.MULTI_checked		;go keep d0 bit_2 cleared for singletasking
	bset	#2,d0			;set d0 bit_2 for multitasking
.MULTI_checked:
	tst.l	d7			;MI/PL == ACC/nonACC
	bpl.s	.ACC_checked		;go keep d0 bit_1 cleared for nonACC
	bset	#1,d0			;set d0 bit_1 for ACC
.ACC_checked:
	move	exec_ref(pc,d0),d0	;fetch a word offset to selected exec code
	jmp	exec_ref(pc,d0)	;jump to selected exec code
;-------------------------------------
exec_ref:
	dc.w	exec_TOS-exec_ref,exec_TOS-exec_ref
	dc.w	exec_TOS-exec_ref,exec_TOS-exec_ref
	dc.w	exec_single_APP-exec_ref,exec_single_ACC-exec_ref
	dc.w	exec_multi_APP-exec_ref,exec_multi_ACC-exec_ref
;-------------------------------------
exec_multi_APP:
	btst	#7,revise_type_f	;been here before ?
	bne.s	repeat_multi_APP	;then behave like an ACC this time
initial_multi_APP:
	tst.l		d3			;init_error ?
	bne		exit_exec_err		;go exit program on init errors (bad STiK etc)
	bset		#7,revise_type_f	;tell main loop to behave like ACC
	cmp		#1,arg_cnt		;any arguments for this APP
	bgt.s		repeat_multi_APP	;then start directly
	bra		exit_exec_ok		;exit to main event loop
;-------------------------------------
exec_TOS:
exec_single_APP:
exec_single_ACC:
	bsr		close_channel
	bsr		parse_args
	ble		exit_exec_ok
	bsr		resolve_EZIP_server
	bmi.s		resolve_error
	bsr		send_request
	bmi.s		send_error
	move.l		#5000,d0	
	bsr		await_EZIP_service
	move.l		d0,d3
	bsr		close_channel
	move.l		d3,d0
	bmi		wait_error
	beq		timeout_error
	bra		exit_exec_ok
;
repeat_multi_APP:
exec_multi_ACC:
	bsr		close_channel
	bsr		parse_args
	ble		exit_exec_ok
	move.l		#10000,main_timeout
	bsr		resolve_EZIP_server
	bpl.s		have_server_ip
resolve_error:
	move.b		silent_f(pc),d0
	beq		exit_exec_ok
	sim_aes		form_alert,#1,unresolved_al_s(pc)
	bra.s		exit_exec_ok
;
have_server_ip:
	bsr		send_request
	bpl.s		request_sent
send_error:
	bsr		close_channel
	move.b		silent_f(pc),d0
	beq.s		exit_exec_ok
	sim_aes		form_alert,#1,send_error_al_s(pc)
	bra.s		exit_exec_ok
;
request_sent:
	TIMER_now
	move.l		d0,send_time
	move.l		#100,main_timeout
	bra.s		exit_exec_ok
;-------------------------------------
exit_exec_err:		;jump here to exit with error code -1
	moveq		#-1,d0
exit_terminate:		;jump here to exit with error code in d0
	move.l		d0,d3
	bclr		#7,revise_type_f
;
;Add client/server dependent termination code here
;
	move.l		d3,d0
	bra.s		exit_exec_app
;-------------------------------------
exit_exec_ok:
	clr.l	d0
exit_exec_app:
	rts
;----------------------------------------------------------------------------
;End of:	exec_app
;----------------------------------------------------------------------------
;Start of:	exec_timer
;----------------------------------------------------------------------------
	IFNE	exec_timeout	;cond:	ifne exec_timeout
exec_timer:
	tst	handle
	ble	exit_exec_timer
	TIMER_elapsed	send_time
	cmp.l		#10000,d0
	blo.s		not_timed_out
	bsr		close_channel
	move.l		#10000,main_timeout
timeout_error:
	move.b		silent_f(pc),d0
	beq.s		.skip_al_1
	sim_aes		form_alert,#1,timeout_al_s(pc)
	cmp		#1,d0	;[ Ok ] button
	beq		exec_app
.skip_al_1:
	bra.s		exit_exec_timer
;
not_timed_out:
	move.l		#10,d0	
	bsr		await_EZIP_service
	beq.s		exit_exec_timer		;continue waiting
	move		d0,d3
	move.l		#10000,main_timeout
	tst		d3
	bpl.s		exit_exec_timer
wait_error:
	move.b		silent_f(pc),d0
	beq.s		exit_exec_timer
	sim_aes		form_alert,#1,wait_error_al_s(pc)
exit_exec_timer:
	clr.l		d0
	rts
	ENDC			;ends:	ifne exec_timeout
;----------------------------------------------------------------------------
;End of:	exec_timer
;----------------------------------------------------------------------------
;Start of:	exec_mesag
;----------------------------------------------------------------------------
	IFNE		exec_message
exec_mesag:
	cmp		#AC_CLOSE,message
	bne.s		.not_AC_CLOSE
	sf		keep_wind_f
	bra		exit_exec_mesag
;
.not_AC_CLOSE:
	cmp		#AP_TERM,message
	bne.s		.not_AP_TERM
	tst.l		d7
	bmi		exit_exec_mesag		;AP_TERM is not for ACCs
	clr.l		d0			;flag no error
	bra		exit_terminate
;
.not_AP_TERM:
	cmp		#VA_START,message
	bne		.not_VA_START
	st		VA_START_f
	move		message+2,AV_partner_id
	move.l		message+6,VA_START_cmd_p
;
	AV_send		PROTOKOLL,#w_VA_START+w_AV_STARTED_A,id_app_name_s
;
	clr.b	VA_arg_s		;prep empty local string
	lea	VA_arg_s(pc),a2		;a2 -> local argument area
	move.l	VA_START_cmd_p(pc),a0	;a0 -> argument on Venus
	move.l	a0,d0			;test -> argument on Venus
	ble.s	.send_AV_STARTED	;if NULL, go send reply now
	tst.b	(a0)			;test if arg string empty
	beq.s	.send_AV_STARTED	;if empty, go send reply now
	move.l		a0,a1			;a1 -> argument on Venus
	str_pass	a1
	sub.l		VA_START_cmd_p(pc),a1
	move.l		a1,d1			;d1 = length of argument
	move		#MAX_VA_ARGLEN,d0
	cmp.l		d0,d1			;argument too long ?
	blo.s		.length_ok
	move.l		d0,d1			;limit argument length
.length_ok:
	move.b		-1(a0,d1.w),d0		;save byte at termination point
	clr.b		-1(a0,d1.w)		;enforce limited termination
	move.l		a0,a1			;a1 -> argument on Venus
	lea		VA_arg_s(pc),a2		;a2 -> local argument area
	str_copy	a1,a2			;make a local copy of argument
	move.b		d0,-1(a0,d1.w)		;repair original copy
	bsr.s		scan_args
.send_AV_STARTED:
	AV_send.i	STARTED,VA_START_cmd_p
	bra		exec_app
;
.not_VA_START:
	cmp		#VA_PROTOSTATUS,message
	bne.s		.not_VA_PROTOSTATUS
	move		message+8,VA_protostatus
	move		message+6,VA_protostatus+2
	bra		exit_exec_mesag
;
.not_VA_PROTOSTATUS:
exec_mesag_extend:
;
;Add client/server dependent message event work here
;
exit_exec_mesag:
	rts
	ENDC		exec_message
;----------------------------------------------------------------------------
;End of:	exec_mesag
;----------------------------------------------------------------------------
;Start of:	subroutines
;----------------------------------------------------------------------------
scan_args:
	lea	VA_arg_s(pc),a0		;a0 -> arg string source
	lea	scanned_arg_s(pc),a1	;a1 -> arg string destination
	clr.b	(a1)+			;clear pseudo progname string
	moveq	#1,d3			;d3 = 1 to count pseudo progname
.scan_arg_next_arg:
	move.b	(a0)+,d0
	beq.s	.scan_arg_end
	cmp.b	#' ',d0
	bls.s	.scan_arg_next_arg
	addq	#1,d3			;increment arg count
	clr	d2			;unflag separator
.scan_arg_next_char:
	cmp.b	#'"',d0
	beq.s	.scan_arg_quote_1
	cmp.b	#"'",d0
	bne.s	.scan_arg_no_quote
.scan_arg_quote_1:
	move.b	(a0)+,d1
	beq.s	.scan_arg_end
	cmp.b	d0,d1
	bne.s	.scan_arg_quote_2
	cmp.b	(a0),d1
	bne.s	.scan_arg_end_quote
	addq	#1,a0			;so double quotes give quote-char
.scan_arg_quote_2:
	move.b	d1,(a1)+		;copy quoted char
	bra.s	.scan_arg_quote_1
;
.scan_arg_no_quote:
	move.b	d0,(a1)+		;copy normal char
.scan_arg_end_quote:
	move.b	(a0)+,d0
	beq.s	.scan_arg_end
	cmp.b	#' ',d0
	bhi.s	.scan_arg_next_char
	clr.b	(a1)+			;change separator from SPC to NUL at destination
	st	d2			;flag separator
	bra.s	.scan_arg_next_arg
;
.scan_arg_end:
	clr.b	(a1)			;terminate arg string
	clr.b	1(a1)			;terminate arg group
	lea	scanned_arg_s(pc),a1	;a1 -> scanned arg string
	move.l	a1,arg_ptr
	move	d3,arg_cnt
	rts
;----------------------------------------------------------------------------
parse_args:
	clr.b		verbose_f
	clr.b		silent_f
	clr.l		server_arg_p
	clr.l		auth_arg_p
	move.l		arg_ptr(pc),a3
	move		arg_cnt,d3
.opt_loop:
	str_pass	a3
	subq		#1,d3
	beq.s		.parse_end
	cmp.b		#'-',(a3)
	bne.s		.non_option
	tst.b		2(a3)
	bne.s		.non_option
	cmp.b		#'v',1(a3)
	bne.s		.non_verbose
	st		verbose_f
	bra.s		.opt_loop
;
.non_verbose:
	cmp.b		#'s',1(a3)
	bne.s		.non_option
	st		silent_f
	bra.s		.opt_loop
;
.non_option:
	move.l		a3,auth_arg_p
	str_pass	a3
	subq		#1,d3
	beq.s		.parse_end
	move.l		a3,server_arg_p
.parse_end:
	tst.l		auth_arg_p
	bne.s		.done_auth
	getvstr		EZIP_USERPASS_vn_s(pc)
	move.l		d0,a0
	str_pass	a0
	subq		#1,a0
	sub.l		d0,a0
	cmp		#3,a0
	blo.s		.error
	move.l		d0,auth_arg_p
.done_auth:
	clr.l		EZIP_server_ip
	move.l		server_arg_p(pc),d0
	bsr.s		test_EZIP_server
	bne.s		.exit
	getvstr		EZIP_SERVER_vn_s(pc)
	bsr.s		test_EZIP_server
	bne.s		.exit
	move.l		#DEF_SERVER,d0
	bsr.s		test_EZIP_server
	bne.s		.exit
.error:
	clr.l		d0
.exit:
	rts
;----------------------------------------------------------------------------
test_EZIP_server:
	is_unblank.i	d0
	beq.s		.bad_spec
	move.l		a0,a1
	str_pass	a1
	subq		#1,a1
	move.l		a1,d0
	sub.l		a0,d0
	cmp		#4,d0
	blo.s		.bad_spec
	move.l		a0,EZIP_server_s_p
	beq.s		.exit
	is_dip		(a0)
	move.l		a0,d0
	beq.s		.exit
	diptobip	(a0)
	move.l		d0,EZIP_server_ip
.exit:
	move.l		EZIP_server_s_p(pc),d0
	rts
;-------
.bad_spec:
	clr.l		d0
	rts
;----------------------------------------------------------------------------
resolve_EZIP_server:
	clr.l		d0
	tst.l		EZIP_server_ip
	bne.s		.exit
	resolve.i	EZIP_server_s_p(pc),#0,#EZIP_server_ip,#1
.exit:
	tst.l		d0
	rts		
;----------------------------------------------------------------------------
close_channel:
	tst		handle
	ble.s		.exit
	TCP_close	handle,#1,NULL
.exit:
	clr.l		handle
	rts
;----------------------------------------------------------------------------
send_request:
	TCP_open	EZIP_server_ip,#EZIP_PORT,#TOS_NORMAL,#BUF_SIZE
	move		d0,handle
	lea		POST_block_s(pc),a0
	lea		buffer(pc),a1
	str_copy	a0,a1
	move.l		auth_arg_p(pc),a0
	subq		#1,a1
	bsr		base64_str_enc
	lea		POST_tail_s(pc),a0
	lea		buffer(pc),a1
	str_conc	a0,a1
	bsr.s		send_buffer
	lea		env_data_block_s(pc),a0
	lea		buffer(pc),a1
	str_copy	a0,a1
send_buffer:
	lea		buffer(pc),a0
	move.l		a0,a1
	str_pass	a1
	subq		#1,a1			;a1 -> data string terminator
	move.l		a1,d0
	sub.l		a0,d0			;d0 = data length
	TCP_send	handle(pc),(a0),d0	;send EZIP request
	clr.b		buffer
	rts
;----------------------------------------------------------------------------
await_EZIP_service:
	move.l		d0,max_delay
	TIMER_now
	move.l		d0,start_time
	clr		rx_length
.nodata_loop:
.wait_loop:
	_appl_yield
	move		rx_length(pc),d0
	bne.s		.late_timeout
.early_timeout:
	TIMER_elapsed	start_time(pc)
	cmp.l		max_delay(pc),d0
	bhs		.timed_out
	bra.s		.done_timeout
;
.late_timeout:
	TIMER_elapsed	recv_time(pc)		;get time elapsed since reception
	cmp.l		#STAB_DELAY,d0		;sufficient to assume completion ?
	bhs.s		.done_receive
.done_timeout:
	CNbyte_count	handle
	cmp		#E_NODATA,d0
	beq		.nodata_loop		;loop on E_NODATA
	tst		d0
	bmi		.error			;break on errors
	cmp		rx_length(pc),d0	;any new data ?
	bls.s		.done_time		;if not, keep reception time
	move		d0,rx_length		;store new data length as old
	TIMER_now				;get current time
	move.l		d0,recv_time		;store as reception time
.done_time:
	bra		.wait_loop
;
.done_receive:
	move		rx_length(pc),d0	;d0 = data length
	cmp		#BUF_SIZE,d0
	blo.s		.keep_length
	move		#BUF_SIZE,d0		;limit data length
.keep_length:
	lea		EZIP_block_s(pc),a0
	clr.b		(a0)			;dummy string terminator
	clr.b		(a0,d0)			;final string terminator
	CNget_block	handle,(a0),d0
	bsr		close_channel
;-------
	move.b		verbose_f(pc),d0
	beq.s		.exit
	lea		EZIP_block_s(pc),a3
	move.l		a3,a0
	move.b		(a0)+,d0
	beq.s		.exit
	moveq		#' ',d1
.uncr_lp:
	cmp.b		d1,d0
	bhs.s		.next_uncr
	clr.b		-1(a0)
.next_uncr:
	move.b		(a0)+,d0
	bne.s		.uncr_lp
	move.l		a3,a4
	add		rx_length(pc),a4
	gemdos		Cconws,CLS_s
.show_lp_1:
	gemdos		Cconws,crlf_s
	subq		#1,a3
.show_lp_2:
	addq		#1,a3
	cmp.l		a4,a3
	bhs.s		.show_end
	cmp.b		#' ',(a3)
	blo.s		.show_lp_2
	gemdos		Cconws,(a3)
	str_pass	a3
	bra.s		.show_lp_1
;
.show_end:
.exit:
	move		rx_length(pc),d0
	rts		;d0 = button returned = 1 flagging no error
;
.timed_out:
	clr.l		d0	;flag nothing received
	rts
;
.error:
	bsr		close_channel
	moveq		#-1,d0	;flag reception error
	rts
;----------------------------------------------------------------------------
;End of:	subroutines
;----------------------------------------------------------------------------
	include	base64.s
;----------------------------------------------------------------------------
	make	SIM_links
	make	JAR_links
	make	DOMAIN_links
	make	AV_links
;----------------------------------------------------------------------------
text_limit:	SECTION	DATA
;----------------------------------------------------------------------------
STiKmagic_s:
	dc.b	'STiKmagic',NUL
TRANSPORT_DRIVER_s:
	dc.b	'TRANSPORT_TCPIP',NUL
MODULE_DRIVER_s:
	dc.b	'MODULE_LAYER',NUL
;
STiK_not_found_al_s:
	dc.b	'[3]['
	dc.b	'STinG  EZ-IP update client:  |'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is missing !]'
	dc.b	'[ Abort ]',NUL
;
STiK_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  EZ-IP update client:  |'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is corrupted!]'
	dc.b	'[ Abort ]',NUL
;
driver_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  EZ-IP update client:  |'
	dc.b	'-----------------------------|'
	dc.b	'TRANSPORT driver is missing !]'
	dc.b	'[ Abort ]',NUL
;
layer_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  EZ-IP update client:  |'
	dc.b	'-----------------------------|'
	dc.b	'MODULE driver is missing !]'
	dc.b	'[ Abort ]',NUL
	even
;
unresolved_al_s:
	dc.b	'[3]['
	dc.b	'STinG  EZ-IP update client:  |'
	dc.b	'-----------------------------|'
	dc.b	'EZ-IP server address can not |'
	dc.b	'be resolved at this time.]'
	dc.b	'[ Abort ]',NUL
;
send_error_al_s:
	dc.b	'[3]['
	dc.b	'STinG  EZ-IP update client:  |'
	dc.b	'-----------------------------|'
	dc.b	'An error occurred attempting |'
	dc.b	'to send request to the EZ-IP |'
	dc.b	'server !]'
	dc.b	'[ Abort ]',NUL
;
wait_error_al_s:
	dc.b	'[3]['
	dc.b	'STinG  EZ-IP update client:  |'
	dc.b	'-----------------------------|'
	dc.b	'An error occurred in awaiting|'
	dc.b	'reply from the EZ-IP server.]'
	dc.b	'[ Abort ]',NUL
;
timeout_al_s:
	dc.b	'[2]['
	dc.b	'STinG  EZ-IP update client:  |'
	dc.b	'-----------------------------|'
	dc.b	'EZ-IP server did not answer !|'
	dc.b	'Click  Ok to make yet another|'
	dc.b	'attempt to contact it.]'
	dc.b	'[ Ok | Cancel ]',NUL
;
DEF_SERVER:
	dc.b	'www.ez-ip.com',NUL
;
POST_block_s:
	dc.b	'POST /members/update/index.cgi HTTP/1.0',CR,LF
	dc.b	'Host: www.ez-ip.com',CR,LF
	dc.b	'Pragma: no-cache',CR,LF
	dc.b	'Cache-Control: no-cache',CR,LF
	dc.b	'User-Agent: EZIP_Upd/1.0 (for Atari STinG)',CR,LF
	dc.b	'Accept: */*',CR,LF
	dc.b	'Content-Length: 55',CR,LF
	dc.b	'Content-type: application/x-www-form-urlencoded',CR,LF
	dc.b	'Authorization: basic '
	dc.b	NUL
POST_tail_s:
	dc.b	CR,LF
	dc.b	'Cookie: newuser=YES; $path=/',CR,LF
crlf_s:
	dc.b	CR,LF
	dc.b	NUL
;
env_data_block_s:
	dc.b	'oops=&'
	dc.b	'ipaddress=&'
	dc.b	'mode=update&'
	dc.b	'ipaddress=&'
	dc.b	'wildcard=no&'
	dc.b	'mx='
env_data_block_end:
	dc.b	NUL
;
CLS_s:
	dc.b	ESC,'E',NUL
;
EZIP_USERPASS_vn_s:
	dc.b	'EZIP_USERPASS',NUL
EZIP_SERVER_vn_s:
	dc.b	'EZIP_SERVER',NUL
	EVEN
;----------------------------------------------------------------------------
data_limit:	SECTION	BSS
;----------------------------------------------------------------------------
sting_drivers:	ds.l	1	;DRV_LIST	*sting_drivers;
tpl:		ds.l	1	;TPL		*tpl;
stx:		ds.l	1	;STX		*stx;
initerr_mess_p:	ds.l	1
fatal_f:	ds.w	1
VA_START_f:	ds.w	1
VA_START_cmd_p:	ds.l	1
VA_protostatus:	ds.l	1
scanned_arg_s:	ds.b	1
VA_arg_s:	ds.b	MAX_VA_ARGLEN
		even
;
verbose_f:		ds.b	1
silent_f:		ds.b	1
real_bip:		ds.l	1
server_arg_p:		ds.l	1
EZIP_server_s_p:	ds.l	1
EZIP_server_ip:		ds.l	1
rx_length:		ds.w	1
recv_time:		ds.l	1
handle:			ds.w	1
send_time:		ds.l	1
start_time:		ds.l	1
max_delay:		ds.l	1
auth_arg_p:		ds.l	1
buffer:			ds.b	BUF_SIZE
Buffer_term:		ds.w	1
EZIP_block_s:		ds.b	BUF_SIZE
EZIP_block_term:	ds.w	1
;----------------------------------------------------------------------------
bss_limit:	END
;----------------------------------------------------------------------------
;End of file:	EZIP_UPD.S
;----------------------------------------------------------------------------
