;----------------------------------------------------------------------------
;File name:	RA_YIELD.S			Revision date:	1999.06.17
;Revised by:	Ulf Ronald Andersson		Creation date:	1999.05.15
;Revision:	1.0
;----------------------------------------------------------------------------
	output	.PRG
;----------------------------------------------------------------------------
	include	RA_SIM.I
	include	RA_JAR.I
	include	RA_XGEM.I
	include	RA_LA.I
;----------------------------------------------------------------------------
	section	TEXT
;----------------------------------------------------------------------------
rz:	;relative reference zero point
BASEPAGE	=	rz-$100
start:
	bra	install
;----------------------------------------------------------------------------
;Start of:	BIOS functions with XBRA
;----------------------------------------------------------------------------
	XGEM_BIOS_define	nu_BIOS,'Stuf'
	move.l	nu_BIOS+xb_next(pc),a0	;\/ use older bios dispatcher
	jmp	(a0)			;/\
;----------------------------------------------------------------------------
patch_XGEM_sub:				;uses d0/a0/a1
	XGEM_patch	XGEM_linked_p,XGEM_wanted_p
	rts
;----------------------------------------------------------------------------
;End of:	BIOS functions with XBRA
;----------------------------------------------------------------------------
;Start of:	XGEM functions with XBRA
;----------------------------------------------------------------------------
	XGEM_define	nu_XGEM,'RAay'
	cmp.b	#$C9,d0			;_appl_yield call
	beq.s	nu__appl_yield
use_old_xgem:
	move.l	nu_XGEM+xb_next(pc),a0
	jmp	(a0)
;
nu__appl_yield:
	move.l	(_hz_200).w,d0
	sub.l	last_yield(pc),d0
	bne.s	.check_time
	rte				;refuse yield in same tick as last
;
.check_time:
	cmp.l	#2,d0
	bhs.s	.yield_time		;refuse yield in tick immediate after
	rte
;
.yield_time:
	move.l	(_hz_200).w,last_yield
	move.b	MiNT_f(pc),d0
	bne.s	MiNT_yield		;use special code for MiNT
	moveq	#$C9,d0
	move.l	nu_XGEM+xb_next(pc),a0
	jmp	(a0)
;
MiNT_yield:
	gemdos	Syield
	rte
;----------------------------------------------------------------------------
;End of:	XGEMDOS functions with XBRA
;----------------------------------------------------------------------------
;Start of:	resident data
;----------------------------------------------------------------------------
basepage_p:	dc.l	0
XGEM_linked_p:	dc.l	-1
XGEM_wanted_p:	dc.l	nu_XGEM
last_yield:	dc.l	0
MiNT_f		dc.b	0
		EVEN
resident_end:
;----------------------------------------------------------------------------
;End of:	resident data
;----------------------------------------------------------------------------
install:
	move.l	a0,d0			;d0 -> basepage of ACC, or is NULL
	bne.s	ACC_loop		;unintentional ACC, just loop _appl_yield
	move.l	4(sp),a5		;a5 -> basepage
	lea	loc_stk_top(pc),sp	;sp -> local stack top
	move.l	a5,basepage_p		;store basepage_p
	movea.l	bp_bss_beg_p(a5),a1
	adda.l	bp_bss_len(a5),a1
	sub.l	basepage_p(pc),a1	;a1 == total RAM size
	gemdos	Mshrink,!,(a5),a1	;release unwanted RAM
	xbios	Supexec,init_supx
	tst	initialized_f
	bmi.s	init_failure
	gemdos	Cconws,init_success_s(pc)
	gemdos	Ptermres,#resident_end-BASEPAGE,!
;----------------------------------------------------------------------------
ACC_loop:
	_appl_yield
	bra.s	ACC_loop
;----------------------------------------------------------------------------
init_failure:
	gemdos	Cconws,init_failed_s(pc)
	gemdos	Pterm,#E_ERROR
;----------------------------------------------------------------------------
init_supx:
	eval_cookie	#'MiNT'
	spl	MiNT_f
	lea	(ev_bios).w,a0
	lea	nu_BIOS(pc),a1
	XB_init
	bmi.s	fail_init
	lea	(ev_xgem).w,a0
	lea	nu_XGEM(pc),a1
	XB_lift_name
	move.l	a1,XGEM_linked_p
	moveq	#E_OK,d0
	rts
;-------
fail_init:
	moveq	#E_ERROR,d0
	move.l	d0,initialized_f
	rts
;----------------------------------------------------------------------------
;End of:	Initialization routine
;----------------------------------------------------------------------------
	make	JAR_links
;----------------------------------------------------------------------------
	section	DATA
;----------------------------------------------------------------------------
initialized_f:
	dc.w	0
prog_title_s:
	dc.b	ESC,'q',' ',ESC,'K',CR,LF
	dc.b	ESC,'K',' ',ESC,'p'
	dc.b	' RA_yield  Version 1.0  1999.06.17 ',ESC,'q',CR,LF
	dc.b	NUL
	even
init_success_s:
	dc.b	'  RA_yield installation succeeded.',CR,LF
	dc.b	NUL
init_failed_s:
	dc.b	'  RA_yield installation failed.',CR,LF
	dc.b	NUL
;----------------------------------------------------------------------------
	section	BSS
;----------------------------------------------------------------------------
loc_stk_beg:
	ds.b	8192
loc_stk_top:
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	RA_YIELD.S
;----------------------------------------------------------------------------
