;----------------------------------------------------------------------------
;File name:	STING_GS.S			Revision date:	1999.11.27
;Creator:	Ulf Ronald Andersson		Creation date:	1999.11.07
;(c)1999 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
;;;huge_program		= 1	;uncomment if TEXT+DATA sections are > 32KB
;;;keep_windows		= 1	;uncomment to keep ACC vwk in main eventloop
exec_timeout		= 1000	;uncomment to enable timer in main eventloop
exec_message		= 1	;uncomment for messages in main eventloop
;----------------------------------------------------------------------------
	output	.APP
;----------------------------------------------------------------------------
;Required header declarations:
;
	include	RA_JAR.I		;Cookie jar handling
	include	RA_AV.I			;AV/VA protocol + MP protocol
	include	RA_APP.I		;General application support
	include	RA_SIM.I		;GEM alert simulation for TOS/TTP
;-------------------------------------
	include	sting\LAYER.I		;only used by servers/modules
	include	sting\TRANSPRT.I	;used by all STinG programs
	include	sting\DOMAIN.I		;handles domain name/ip conv.
;----------------------------------------------------------------------------
MAX_GS_PARTS	=	32	;max number of partners (for array sizes)
MAX_ARG		=	12	;max argc for commands (incl func name)
MAX_VA_ARGLEN	=	512	;max length of argument in VA calls
;-------------------------------------
	struct	PART_CN
	struc_p	PCN_next	;-> next PART_CN of partner, or is NULL
	int16	PCN_handle	;=  handle of connection
	d_end	PART_CN
;-------------------------------------
	struct	GP_APPD		;APP_Defined part of GS_PART structure
	struc_p	GP_cnlist	;-> first PART_CN of partner, or is NULL
	char	GP_num_l_s,14	;space for asciizz string for long number
	d_end	GP_APPD
;-------------------------------------
	include RA_GS.I			;GEMScript functions
;----------------------------------------------------------------------------
	SECTION	TEXT
;----------------------------------------------------------------------------
	start_app
;----------------------------------------------------------------------------
	IFEQ	huge_program
	SECTION	data
	ENDC
;----------------------------------------------------------------------------
acc_name:
	dc.b	'  STinG_GS plugin',NUL	;for ACC menu registration
	dc.b	NUL
	even
;
id_app_name_s:
	dc.b	'STING_GS',NUL
	even
;----------------------------------------------------------------------------
	IFEQ	huge_program
	SECTION	BSS
	ENDC
;----------------------------------------------------------------------------
message:	ds.w	8		;evnt_mesag message pipe
intin:		ds.w	30		;30 words or more for AES/VDI
intout:		ds.w	45		;45 words or more for AES/VDI
ptsin:		ds.w	30		;30 words or more for VDI
ptsout:		ds.w	12		;12 words or more for VDI output coordinates
		ds.l	1024		;subroutine stack >= 100 longs
mystack:	ds.l	1		;top of subroutine stack
;----------------------------------------------------------------------------
	SECTION	TEXT
;----------------------------------------------------------------------------
;Start of:	init_app
;----------------------------------------------------------------------------
init_app:
	clr.l		VA_arg_p
	st		fatal_f			;assume fatal errors can happen
	gemdos		Super,0.w
	move.l		d0,d4
	eval_cookie	#"STiK"
	move.l		d0,d3			;d3 = d0 -> DRV_LIST structure
	gemdos		Super|_ind,d4
	move.l		d3,sting_drivers	;sting_drivers -> DRV_LIST structure
	ble.s		.STiK_not_found
	move.l		d3,a3			;a3 -> DRV_LIST structure
	lea		DRV_LIST_magic(a3),a0
	lea		STiKmagic_s(pc),a1
	moveq		#10-1,d0
.strcmp_loop:					;loop to test STiKmagic of DRV_LIST
	cmpm.b		(a0)+,(a1)+
	dbne		d0,.strcmp_loop
	bne.s		.STiK_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		TRANSPORT_DRIVER_s		;-(sp) = "TRANSPORT_TCPIP"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,tpl				;store pointer in 'tpl'
	ble.s		.driver_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		MODULE_DRIVER_s			;-(sp) = "MODULE_LAYER"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,stx				;store pointer in 'tpl'
	ble.s		.layer_not_valid
	clr		fatal_f
;
;Add client/server dependent init here
;
	clr.l		initerr_mess_p
	rts
;
.STiK_not_found:
	lea		STiK_not_found_al_s(pc),a0
	bra.s		.init_error
;
.STiK_not_valid:
	lea		STiK_not_valid_al_s(pc),a0
	bra.s		.init_error
;
.driver_not_valid:
	lea		driver_not_valid_al_s(pc),a0
	bra.s		.init_error
;
.layer_not_valid:
	lea		layer_not_valid_al_s(pc),a0
.init_error:
	move.l		a0,initerr_mess_p
	rts
;----------------------------------------------------------------------------
;End of:	init_app
;----------------------------------------------------------------------------
;Start of:	exec_app
;----------------------------------------------------------------------------
exec_app:
	move.l		initerr_mess_p,d3
	beq.s		no_init_err
	move.l		d3,a3
	sim_aes		form_alert,#1,(a3)
	tst		fatal_f
	bne.s		exit_exec_err
no_init_err:
	clr	d0			;preclear low word of d0
	tst.w	d7			;MI/PL == TOS/GEM
	bmi.s	.TOS_checked		;go keep d0 bit_3 cleared for TOS/TTP program
	bset	#3,d0			;set d0 bit_3 for GEM program
.TOS_checked:
	cmp	#1,global+2		;EQ/NE == Single/Multi-tasking AES
	beq.s	.MULTI_checked		;go keep d0 bit_2 cleared for singletasking
	bset	#2,d0			;set d0 bit_2 for multitasking
.MULTI_checked:
	tst.l	d7			;MI/PL == ACC/nonACC
	bpl.s	.ACC_checked		;go keep d0 bit_1 cleared for nonACC
	bset	#1,d0			;set d0 bit_1 for ACC
.ACC_checked:
	move	exec_ref(pc,d0),d0	;fetch a word offset to selected exec code
	jmp	exec_ref(pc,d0)	;jump to selected exec code
;-------------------------------------
exec_ref:
	dc.w	exec_TOS-exec_ref,exec_TOS-exec_ref
	dc.w	exec_TOS-exec_ref,exec_TOS-exec_ref
	dc.w	exec_single_APP-exec_ref,exec_single_ACC-exec_ref
	dc.w	exec_multi_APP-exec_ref,exec_multi_ACC-exec_ref
;-------------------------------------
exec_multi_APP:
	btst	#7,revise_type_f	;been here before ?
	bne.s	repeat_multi_APP	;then behave like an ACC this time
initial_multi_APP:
	tst.l		d3			;init_error ?
	bne.s		exit_exec_err		;go exit program on init errors (bad STiK etc)
	bset		#7,revise_type_f	;tell main loop to behave like ACC
	bra.s		exit_exec_ok		;exit to main event loop
;-------------------------------------
exec_single_APP:
exec_TOS:
	bra.s		exit_exec_err
;-------------------------------------
exec_single_ACC:
repeat_multi_APP:
exec_multi_ACC:
	bra.s		exit_exec_ok
;-------------------------------------
exit_exec_err:		;jump here to exit with error code -1
	moveq		#-1,d0
exit_terminate:		;jump here to exit with error code in d0
	move.l		d0,d3
	bclr		#7,revise_type_f
;
;Add client/server dependent termination code here
;
	move.l		d3,d0
	bra.s		exit_exec_app
;-------------------------------------
exit_exec_ok:
	clr.l	d0
exit_exec_app:
	rts
;----------------------------------------------------------------------------
;End of:	exec_app
;----------------------------------------------------------------------------
;Start of:	exec_timer
;----------------------------------------------------------------------------
	IFNE	exec_timeout	;cond:	ifne exec_timeout
exec_timer:
exit_exec_timer:
	clr.l		d0
	rts
	ENDC			;ends:	ifne exec_timeout
;----------------------------------------------------------------------------
;End of:	exec_timer
;----------------------------------------------------------------------------
;Start of:	exec_mesag
;----------------------------------------------------------------------------
	IFNE		exec_message
exec_mesag:
	move		message,d0
	cmp		#GS_COMMAND,d0
	beq		have_GS_COMMAND
	cmp		#GS_REQUEST,d0
	beq		have_GS_REQUEST
	cmp		#GS_QUIT,d0
	beq		have_GS_QUIT
	cmp		#AC_CLOSE,d0
	bne.s		.not_AC_CLOSE
	sf		keep_wind_f
	bra		exit_exec_mesag
;-------------------------------------
.not_AC_CLOSE:
	cmp		#AP_TERM,message
	bne.s		.not_AP_TERM
	tst.l		d7
	bmi		exit_exec_mesag		;AP_TERM is not for ACCs
	clr.l		d0			;flag no error
	bra		exit_terminate
;
.not_AP_TERM:
	cmp		#VA_START,message
	bne		.not_VA_START
	st		VA_START_f
	move		message+2,AV_partner_id
	move.l		message+6,VA_START_cmd_p
;-------------------------------------
	AV_send		PROTOKOLL,#w_VA_START+w_AV_STARTED_A,id_app_name_s
;-------------------------------------
	clr.b	VA_arg_s		;prep empty local string
	lea	VA_arg_s(pc),a2		;a2 -> local argument area
	move.l	a2,VA_arg_p		;prep a pointer for future
	move.l	VA_START_cmd_p(pc),a0	;a0 -> argument on Venus
	move.l	a0,d0			;test -> argument on Venus
	ble.s	.send_AV_STARTED	;if NULL, go send reply now
	move.l		a0,a1			;a1 -> argument on Venus
	str_pass	a1
	sub.l		VA_START_cmd_p(pc),a1
	move.l		a1,d1			;d1 = length of argument
	move		#MAX_VA_ARGLEN,d0
	cmp.l		d0,d1			;argument too long ?
	blo.s		.length_ok
	move.l		d0,d1			;limit argument length
.length_ok:
	move.b		-1(a0,d1.w),d0		;save byte at termination point
	clr.b		-1(a0,d1.w)		;enforce limited termination
	move.l		a0,a1			;a1 -> argument on Venus
	lea		VA_arg_s(pc),a2		;a2 -> local argument area
	move.l		a2,VA_arg_p		;prep a pointer for future
	str_copy	a1,a2			;make a local copy of argument
	move.b		d0,-1(a0,d1.w)		;repair original copy
.send_AV_STARTED:
	AV_send.i	STARTED,VA_START_cmd_p
	bra		exec_app
;
.not_VA_START:
	cmp		#VA_PROTOSTATUS,message
	bne		not_VA_PROTOSTATUS
	move		message+8,VA_protostatus
	move		message+6,VA_protostatus+2
	bra		exit_exec_mesag
;-------------------------------------
have_GS_REQUEST:
	GS_REPLY	message			;process GS_REQUEST and send reply
;-------
	move	d0,d7				;d7 =  partner index
	bmi	exit_exec_mesag			;exit on error
	move.l	a0,a5				;a5 -> partner struct
	clr.l	GP_cnlist(a5)			;clear -> connection list
	bra	exit_exec_mesag			;back to event loop
;-------------------------------------
have_GS_QUIT:
	take_GS_QUIT	message			;process incoming GS_QUIT message
;-------
	bra	exit_exec_mesag			;back to event loop
;-------------------------------------
have_GS_COMMAND:
	take_GS_COMMAND	message			;process incoming GS_COMMAND message
;-------
	move	d0,d7				;d7 =  partner index
	bmi	exit_exec_mesag			;exit on error
	move.l	a0,a5				;a5 -> partner struct
	move.l	GP_Rx_command(a5),a3		;a3 -> command
	lea	GP_Rx_argv(a5),a4		;a4 -> argv array
;-------
	GS_parse_parm	(a3),(a4),#MAX_ARG
;-------
	move	d0,GP_Rx_argc(a5)		;store argc
	ble.s	args_are_illegal		;refuse silly calls
	move.l	(a4),a3				;a3 -> function name
;-------
	move.b	(a3)+,d0		;\
	beq.s	func_is_unknown		; \
	asl.w	#8,d0			;  \
	move.b	(a3)+,d0		;   \
	beq.s	func_is_unknown		;    \
	swap	d0			;     > d0 = characters 0..3
	move.b	(a3)+,d0		;    /
	beq.s	func_is_unknown		;   /
	asl.w	#8,d0			;  /
	move.b	(a3)+,d0		; /
	beq.s	func_is_unknown		;/
;-------
	move.b	(a3)+,d1		;\
	beq.s	func_is_unknown		; \
	asl.w	#8,d1			;  \
	move.b	(a3)+,d1		;   \
	beq.s	func_is_unknown		;    \
	swap	d1			;     > d1 = characters 4..7 (NUL padded)
	move.b	(a3)+,d1		;    /
	asl.w	#8,d1			;   /
	beq.s	.have_func_name		;  /
	move.b	(a3)+,d1		; /
.have_func_name:			;/
;-------
	jsr	interpret_func			;interpret function
	tst	d1				;normal result ?
	beq.s	.return_normally		;if so, go return normally
	cmp	#E_NOROUTINE,d1			;was function recognized
	beq.s	func_is_unknown			;else go tell GEMScript interpreter
	cmp	#E_ERROR,d1			;Parameters ok ?
	beq.s	args_are_illegal		;else go tell GEMScript interpreter
	cmp	#E_RANGE,d1			;special return pointer ?
	beq.s	.return_pointer_a3		;then go return that pointer
;-------
.return_normally:
	lea	GP_num_l_s(a5),a3		;a3 -> string buffer for (long) number
.return_pointer_a3:
	move.l	a3,GP_Tx_result(a5)		;This will be used as result string
	move	#GSACK_OK,GP_Tx_errcode(a5)	;tell GEMScript interpreter OK
	GS_ACK	d7				;by sending the GS_ACK message
	bra.s	exit_exec_mesag			;back to event loop
;-------
func_is_unknown:
	move.l	#unknown_func_zzs,GP_Tx_result(a5)	;error string
	move	#GSACK_UNKNOWN,GP_Tx_errcode(a5)	;errcode = GSACK_ERROR
	GS_ACK	d7					;send GS_ACK with errcode
	bra.s	exit_exec_mesag			;back to event loop
;-------
args_are_illegal:
	move.l	#illegal_parms_zzs,GP_Tx_result(a5)	;error string
	move	#GSACK_ERROR,GP_Tx_errcode(a5)		;errcode = GSACK_ERROR
	GS_ACK	d7					;send GS_ACK with errcode
	bra	exit_exec_mesag			;back to event loop
;-------------------------------------
not_VA_PROTOSTATUS:
exec_mesag_extend:
exit_exec_mesag:
	rts
	ENDC		;exec_message
;----------------------------------------------------------------------------
;End of:	exec_mesag
;----------------------------------------------------------------------------
;Start of:	subroutines
;----------------------------------------------------------------------------
interpret_func:
	lea	func_prefix_t(pc),a0	;a0 -> prefix table
interpret_loop_1:
	move.l	(a0)+,d2		;d2 -> next suffix table, or is NULL
	beq.s	interpret_failed	;exit with error if d2 == NULL
	cmp.l	(a0)+,d0		;is suffix table for this prefix ?
	bne.s	interpret_loop_1	;loop to find correct suffix table
	move.l	d2,a0			;a0 -> suffix table
interpret_loop_2:
	move.l	(a0)+,d2		;d2 -> next func_def, or is NULL
	beq.s	interpret_failed	;exit with error if d2 == NULL
	cmp.l	(a0)+,d1		;is func_def for this suffix ?
	bne.s	interpret_loop_2	;loop to find correct func_def
	move.l	d2,a0			;a0 -> identified func_def
	move.w	(a0)+,d2		;d2 = needed argc
	bmi.s	interpret_12_char	;if negative, go compare more chars
	cmp.w	GP_Rx_argc(a5),d2	;does the real argc match it ?
	bne.s	interpret_bad_parms	;else exit with error
	move.w	(a0)+,d4		;d4 = arg room to use on stack
	move.l	(a0)+,a1		;a1 -> function caller
	move.l	(a0)+,a3		;a3 -> argument loader
	move.w	(a0),d3			;d3 = function id_code
	jsr	(a1)			;call function caller
	moveq	#E_OK,d1		;flag function recognized
	rts				;return to caller
;-------------------------------------
interpret_12_char:
	move.l	(a4),a3			;a3 -> function name
	addq	#8,a3			;a3 -> ninth char of name
	clr.l	d1			;d1 = 0
	move.b	(a3)+,d1		;\
	beq.s	.have_four_chars	; \
	asl.w	#8,d1			;  \
	move.b	(a3)+,d1		;   \
	beq.s	.swap_four_chars	;    \
	swap	d1			;     \
	move.b	(a3)+,d1		;      \/ d1 = characters 4..7 (NUL padded)
	asl.w	#8,d1			;      /\
	beq.s	.have_four_chars	;     /
	move.b	(a3)+,d1		;    /
	swap	d1			;   /
.swap_four_chars:			;  /
	swap	d1			; /
.have_four_chars:			;/
	move.l	(a0)+,a0		;a0 -> extended suffix table
	bra.s	interpret_loop_2	;goto loop_2 for final interpretation
;-------------------------------------
interpret_failed:
	moveq	#E_NOROUTINE,d1
	rts
;-------------------------------------
pop_bad_parms:
	addq.l	#4,sp			;pop one return level
interpret_bad_parms:
	moveq	#E_ERROR,d1
	rts
;----------------------------------------------------------------------------
stx_w_func:
	jsr		(a3)			;fix arguments
	move.l		stx,a0			;a0 -> stx table
	move.l		(a0,d3),a0		;a0 -> function
	jsr		(a0)			;call function
	GS_put_w	d0,GP_num_l_s(a5)	;set word result
	add		d4,sp			;pop args off stack
	rts					;return to caller
;-------------------------------------
stx_l_func:
	jsr		(a3)			;fix arguments
	move.l		stx,a0			;a0 -> stx table
	move.l		(a0,d3),a0		;a0 -> function
	jsr		(a0)			;call function
	GS_put_l	d0,GP_num_l_s(a5)	;set long result
	add		d4,sp			;pop args off stack
	rts					;return to caller
;-------------------------------------
stx_0_func:
	jsr		(a3)			;fix arguments
	move.l		stx,a0			;a0 -> stx table
	move.l		(a0,d3),a0		;a0 -> function
	jsr		(a0)			;call function
	move.l		#'0'<<24,GP_num_l_s(a5)	;set result to E_OK
	add		d4,sp			;pop args off stack
	rts					;return to caller
;-------------------------------------
tpl_w_func:
	jsr		(a3)			;fix arguments
	move.l		tpl,a0			;a0 -> tpl table
	move.l		(a0,d3),a0		;a0 -> function
	jsr		(a0)			;call function
	GS_put_w	d0,GP_num_l_s(a5)	;set word result
	add		d4,sp			;pop args off stack
	rts					;return to caller
;-------------------------------------
tpl_l_func:
	jsr		(a3)			;fix arguments
	move.l		tpl,a0			;a0 -> tpl table
	move.l		(a0,d3),a0		;a0 -> function
	jsr		(a0)			;call function
	GS_put_l	d0,GP_num_l_s(a5)	;set long result
	add		d4,sp			;pop args off stack
	rts					;return to caller
;-------------------------------------
tpl_0_func:
	jsr		(a3)			;fix arguments
	move.l		tpl,a0			;a0 -> tpl table
	move.l		(a0,d3),a0		;a0 -> function
	jsr		(a0)			;call function
	move.l		#'0'<<24,GP_num_l_s(a5)	;set result to E_OK
	add		d4,sp			;pop args off stack
	rts					;return to caller
;-------------------------------------
peekb_func:
	GS_get_l.i	1*4(a4)			;d0 = pointer to byte
	bmi		pop_bad_parms		;exit on error
	tst.l		d0			;check pointer
	ble		pop_bad_parms		;exit on error
	cmp.l		#$800,d0		;check low range
	blo		pop_bad_parms		;exit on error
	move.l		d0,a0			;a0 -> byte
	move.b		(a0),d0			;d0 =  byte
	GS_put_b	d0,GP_num_l_s(a5)	;set byte result
	rts					;return to caller
;-------------------------------------
peekw_func:
	GS_get_l.i	1*4(a4)			;d0 = pointer to word
	bmi		pop_bad_parms		;exit on error
	tst.l		d0			;check pointer
	ble		pop_bad_parms		;exit on error
	cmp.l		#$800,d0		;check low range
	blo		pop_bad_parms		;exit on error
	move.l		d0,a0			;a0 -> word
	move.b		(a0)+,d0		;\
	lsl		#8,d0			; > d0 = safe word
	move.b		(a0)+,d0		;/
	GS_put_w	d0,GP_num_l_s(a5)	;set word result
	rts					;return to caller
;-------------------------------------
peekl_func:
	GS_get_l.i	1*4(a4)			;d0 = pointer to long
	bmi		pop_bad_parms		;exit on error
	tst.l		d0			;check pointer
	ble		pop_bad_parms		;exit on error
	cmp.l		#$800,d0		;check low range
	blo		pop_bad_parms		;exit on error
	move.l		d0,a0			;a0 -> long
	move.b		(a0)+,d0		;\
	lsl		#8,d0			; \
	move.b		(a0)+,d0		;  \
	swap		d0			;   > d0 = safe long
	move.b		(a0)+,d0		;  /
	lsl		#8,d0			; /
	move.b		(a0)+,d0		;/
	GS_put_l	d0,GP_num_l_s(a5)	;set long result
	rts					;return to caller
;-------------------------------------
peeks_func:
	GS_get_l.i	1*4(a4)			;d0 = pointer to string
	bmi		pop_bad_parms		;exit on error
	tst.l		d0			;check pointer
	ble		pop_bad_parms		;exit on error
	cmp.l		#$800,d0		;check low range
	blo		pop_bad_parms		;exit on error
	move.l		d0,a0			;a0 -> peek string
	lea		string_buf(pc),a3	;a3 -> buffer
	move		#512-1,d0		;copy max 512 bytes
.peeks_loop:
	move.b		(a0)+,(a3)+		;copy bytes
	dbeq		d0,.peeks_loop		;Until 512 copied or NUL terminator
	clr.b		(a3)+			;add primary terminator
	clr.b		(a3)+			;add secondary terminator
	lea		string_buf(pc),a3	;a3 -> copied string
	moveq		#E_RANGE,d1		;indicate special pointer
	addq		#4,sp			;pop a return level
	rts					;return to superior caller
;-------------------------------------
pokeb_func:
	GS_get_l.i	1*4(a4)			;d0 = pointer to destination
	bmi		pop_bad_parms		;exit on error
	tst.l		d0			;check pointer
	ble		pop_bad_parms		;exit on error
	cmp.l		#$800,d0		;check low range
	blo		pop_bad_parms		;exit on error
	move.l		d0,a3			;a3 -> destination
	GS_get_b.i	2*4(a4)			;d0 = byte
	move.b		d0,(a3)+		;store byte at (a3)+
	GS_put_l	a3,GP_num_l_s(a5)	;set next address as result
	rts					;return to caller
;-------------------------------------
pokew_func:
	GS_get_l.i	1*4(a4)			;d0 = pointer to destination
	bmi		pop_bad_parms		;exit on error
	tst.l		d0			;check pointer
	ble		pop_bad_parms		;exit on error
	cmp.l		#$800,d0		;check low range
	blo		pop_bad_parms		;exit on error
	move.l		d0,a3			;a3 -> destination
	GS_get_w.i	2*4(a4)			;d0 = word
	rol		#8,d0			;\
	move.b		d0,(a3)+		; \/ store word
	rol		#8,d0			; /\ at (a3)+
	move.b		d0,(a3)+		;/
	GS_put_l	a3,GP_num_l_s(a5)	;set next address as result
	rts					;return to caller
;-------------------------------------
pokel_func:
	GS_get_l.i	1*4(a4)			;d0 = pointer to destination
	bmi		pop_bad_parms		;exit on error
	tst.l		d0			;check pointer
	ble		pop_bad_parms		;exit on error
	cmp.l		#$800,d0		;check low range
	blo		pop_bad_parms		;exit on error
	move.l		d0,a3			;a3 -> destination
	GS_get_l.i	2*4(a4)			;d0 = long
	swap		d0			;\
	rol		#8,d0			; \
	move.b		d0,(a3)+		;  \
	rol		#8,d0			;   \
	move.b		d0,(a3)+		;    \/ store long
	swap		d0			;    /\ at (a3)+
	rol		#8,d0			;   /
	move.b		d0,(a3)+		;  /
	rol		#8,d0			; /
	move.b		d0,(a3)+		;/
	GS_put_l	a3,GP_num_l_s(a5)	;set next address as result
	rts					;return to caller
;-------------------------------------
pokes_func:
	GS_get_l.i	1*4(a4)			;d0 = pointer to destination
	bmi		pop_bad_parms		;exit on error
	tst.l		d0			;check pointer
	ble		pop_bad_parms		;exit on error
	cmp.l		#$800,d0		;check low range
	blo		pop_bad_parms		;exit on error
	move.l		d0,a3			;a3 -> destination
	move.l		2*4(a4),a0		;a0 -> string
.pokes_loop:
	move.b		(a0)+,(a3)+		;store bytes at (a3)+
	bne.s		.pokes_loop		;loop until NUL terminator
	GS_put_l	a3,GP_num_l_s(a5)	;set next address as result
	rts					;return to caller
;-------------------------------------
dip_to_bip:
	move.l		1*4(a4),d0		;d0 = pointer to dotted IP string
	bmi		pop_bad_parms		;exit on error
	tst.l		d0			;check pointer
	ble		pop_bad_parms		;exit on error
	cmp.l		#$800,d0		;check low range
	blo		pop_bad_parms		;exit on error
	move.l		d0,a3			;a3 -> dotted IP
	is_dip		(a3)
	move.l		a0,d0
	beq.s		.done_conv
	diptobip	(a3)
.done_conv:
	GS_put_l	d0,GP_num_l_s(a5)	;set next address as result
	rts					;return to caller
;-------------------------------------
bip_to_dip:
	GS_get_l.i	1*4(a4)			;d0 -> string destination
	bmi		pop_bad_parms		;exit on error
	tst.l		d0			;check pointer
	ble		pop_bad_parms		;exit on error
	cmp.l		#$800,d0		;check low range
	blo		pop_bad_parms		;exit on error
	move.l		d0,a3			;a3 -> string destination
	GS_get_l.i	2*4(a4)			;d0 = binary IP
	biptodip	d0,(a3)
	GS_put_l	d0,GP_num_l_s(a5)	;set terminator address as result
	rts					;return to caller
;----------------------------------------------------------------------------
fixargs_11_llbwbbwlwlw:
	move.l		(sp)+,a3
	GS_get_w.i	11*4(a4)
	move.w		d0,-(sp)
	GS_get_l.i	10*4(a4)
	move.l		d0,-(sp)
	GS_get_w.i	9*4(a4)
	move.w		d0,-(sp)
	GS_get_l.i	8*4(a4)
	move.l		d0,-(sp)
	GS_get_w.i	7*4(a4)
	move.w		d0,-(sp)
	GS_get_b.i	6*4(a4)
	move.b		d0,-(sp)
	GS_get_b.i	5*4(a4)
	move.b		d0,-(sp)
	GS_get_w.i	4*4(a4)
	move.w		d0,-(sp)
	GS_get_b.i	3*4(a4)
	move.b		d0,-(sp)
	GS_get_l.i	2*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	1*4(a4)
	move.l		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_5_wllll:
	move.l		(sp)+,a3
	GS_get_l.i	5*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	4*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	3*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	2*4(a4)
	move.l		d0,-(sp)
	GS_get_w.i	1*4(a4)
	move.w		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_5_lbblw:
	move.l		(sp)+,a3
	GS_get_w.i	5*4(a4)
	move.w		d0,-(sp)
	GS_get_l.i	4*4(a4)
	move.l		d0,-(sp)
	GS_get_b.i	3*4(a4)
	move.b		d0,-(sp)
	GS_get_b.i	2*4(a4)
	move.b		d0,-(sp)
	GS_get_l.i	1*4(a4)
	move.l		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_4_llll:
	move.l		(sp)+,a3
	GS_get_l.i	4*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	3*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	2*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	1*4(a4)
	move.l		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_4_lllw:
	move.l		(sp)+,a3
	GS_get_w.i	4*4(a4)
	move.w		d0,-(sp)
	GS_get_l.i	3*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	2*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	1*4(a4)
	move.l		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_4_lwww:
	move.l		(sp)+,a3
	GS_get_w.i	4*4(a4)
	move.w		d0,-(sp)
	GS_get_w.i	3*4(a4)
	move.w		d0,-(sp)
	GS_get_w.i	2*4(a4)
	move.w		d0,-(sp)
	GS_get_l.i	1*4(a4)
	move.l		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_4_wlwb:
	move.l		(sp)+,a3
	GS_get_b.i	4*4(a4)
	move.b		d0,-(sp)
	GS_get_w.i	3*4(a4)
	move.w		d0,-(sp)
	GS_get_l.i	2*4(a4)
	move.l		d0,-(sp)
	GS_get_w.i	1*4(a4)
	move.w		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_3_lll:
	move.l		(sp)+,a3
	GS_get_l.i	3*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	2*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	1*4(a4)
	move.l		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_3_llw:
	move.l		(sp)+,a3
	GS_get_w.i	3*4(a4)
	move.w		d0,-(sp)
	GS_get_l.i	2*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	1*4(a4)
	move.l		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_3_wlw:
	move.l		(sp)+,a3
	GS_get_w.i	3*4(a4)
	move.w		d0,-(sp)
	GS_get_l.i	2*4(a4)
	move.l		d0,-(sp)
	GS_get_w.i	1*4(a4)
	move.w		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_3_wwl:
	move.l		(sp)+,a3
	GS_get_l.i	3*4(a4)
	move.l		d0,-(sp)
	GS_get_w.i	2*4(a4)
	move.w		d0,-(sp)
	GS_get_w.i	1*4(a4)
	move.w		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_3_www:
	move.l		(sp)+,a3
	GS_get_w.i	3*4(a4)
	move.w		d0,-(sp)
	GS_get_w.i	2*4(a4)
	move.w		d0,-(sp)
	GS_get_w.i	1*4(a4)
	move.w		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_2_ll:
	move.l		(sp)+,a3
	GS_get_l.i	2*4(a4)
	move.l		d0,-(sp)
	GS_get_l.i	1*4(a4)
	move.l		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_2_lw:
	move.l		(sp)+,a3
	GS_get_w.i	2*4(a4)
	move.w		d0,-(sp)
	GS_get_l.i	1*4(a4)
	move.l		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_2_wl:
	move.l		(sp)+,a3
	GS_get_l.i	2*4(a4)
	move.l		d0,-(sp)
	GS_get_w.i	1*4(a4)
	move.w		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_2_ww:
	move.l		(sp)+,a3
	GS_get_w.i	2*4(a4)
	move.w		d0,-(sp)
	GS_get_w.i	1*4(a4)
	move.w		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_1_l:
	move.l		(sp)+,a3
	GS_get_l.i	1*4(a4)
	move.l		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_1_w:
	move.l		(sp)+,a3
	GS_get_w.i	1*4(a4)
	move.w		d0,-(sp)
	jmp		(a3)
;-------------------------------------
fixargs_0:
	rts
;----------------------------------------------------------------------------
;End of:	subroutines
;----------------------------------------------------------------------------
	make	SIM_links
	make	JAR_links
	make	DOMAIN_links
	make	AV_links
	make	GS_links
;----------------------------------------------------------------------------
text_limit:	SECTION	DATA
;----------------------------------------------------------------------------
func_prefix_t:
	dc.l	prot_suf_t,'prot'
	dc.l	TIME_suf_t,'TIME'
	dc.l	TCP__suf_t,'TCP_'
	dc.l	UDP__suf_t,'UDP_'
	dc.l	CNge_suf_t,'CNge'
	dc.l	CNby_suf_t,'CNby'
	dc.l	CNki_suf_t,'CNki'
	dc.l	KRma_suf_t,'KRma'
	dc.l	KRfr_suf_t,'KRfr'
	dc.l	KRge_suf_t,'KRge'
	dc.l	KRre_suf_t,'KRre'
	dc.l	ICMP_suf_t,'ICMP'
	dc.l	PRTC_suf_t,'PRTC'
	dc.l	IP_s_suf_t,'IP_s'
	dc.l	IP_f_suf_t,'IP_f'
	dc.l	IP_h_suf_t,'IP_h'
	dc.l	IP_d_suf_t,'IP_d'
	dc.l	reso_suf_t,'reso'
	dc.l	getv_suf_t,'getv'
	dc.l	setv_suf_t,'setv'
	dc.l	cntr_suf_t,'cntr'
	dc.l	on_p_suf_t,'on_p'
	dc.l	off__suf_t,'off_'
	dc.l	quer_suf_t,'quer'
	dc.l	chec_suf_t,'chec'
	dc.l	set__suf_t,'set_'
	dc.l	clea_suf_t,'clea'
	dc.l	get__suf_t,'get_'
	dc.l	load_suf_t,'load'
	dc.l	carr_suf_t,'carr'
	dc.l	hous_suf_t,'hous'
	dc.l	ser__suf_t,'ser_'
	dc.l	peek_suf_t,'peek'
	dc.l	poke_suf_t,'poke'
	dc.l	dip__suf_t,'dip_'
	dc.l	bip__suf_t,'bip_'
	dc.l	NULL
;-------------------------------------
prot_suf_t:
	dc.l	fd_protect_exec,'ect_'
	dc.l	NULL
;-------------------------------------
TIME_suf_t:
	dc.l	fd_TIMER_elapsed,'R_el'
	dc.l	fd_TIMER_now,'R_no'
	dc.l	fd_TIMER_call,'R_ca'
	dc.l	NULL
;-------------------------------------
TCP__suf_t:
	dc.l	fd_TCP_info,'info'
	dc.l	fd_TCP_send,'send'
	dc.l	fd_TCP_open,'open'
	dc.l	fd_TCP_close,'clos'
	dc.l	fd_TCP_wait_state,'wait'
	dc.l	fd_TCP_ack_wait,'ack_'
	dc.l	NULL
;-------------------------------------
UDP__suf_t:
	dc.l	fd_UDP_info,'info'
	dc.l	fd_UDP_send,'send'
	dc.l	fd_UDP_open,'open'
	dc.l	fd_UDP_close,'clos'
	dc.l	NULL
;-------------------------------------
CNge_suf_t:
	dc.l	fd_CNget_block,'t_bl'
	dc.l	fd_CNget_NDB,'t_ND'
	dc.l	fd_CNget_char,'t_ch'
	dc.l	fd_CNgets,'ts'<<16
	dc.l	fd_CNgetinfo,'tinf'
	dc.l	NULL
;-------------------------------------
CNby_suf_t:
	dc.l	fd_CNbyte_count,'te_c'
	dc.l	NULL
;-------------------------------------
CNki_suf_t:
	dc.l	fd_CNkick,'ck'<<16
	dc.l	NULL
;-------------------------------------
KRma_suf_t:
	dc.l	fd_KRmalloc,'lloc'
	dc.l	NULL
;-------------------------------------
KRfr_suf_t:
	dc.l	fd_KRfree,'ee'<<16
	dc.l	NULL
;-------------------------------------
KRge_suf_t:
	dc.l	fd_KRgetfree,'tfre'
	dc.l	NULL
;-------------------------------------
KRre_suf_t:
	dc.l	fd_KRrealloc,'allo'
	dc.l	NULL
;-------------------------------------
ICMP_suf_t:
	dc.l	fd_ICMP_send,'_sen'
	dc.l	fd_ICMP_handler,'_han'
	dc.l	fd_ICMP_discard,'_dis'
	dc.l	NULL
;-------------------------------------
PRTC_suf_t:
	dc.l	fd_PRTCL_lookup,'L_lo'
	dc.l	fd_PRTCL_get_parameters,'L_ge'
	dc.l	fd_PRTCL_announce,'L_an'
	dc.l	fd_PRTCL_req_rel,'L_re'
	dc.l	NULL
;-------------------------------------
IP_s_suf_t:
	dc.l	fd_IP_send,'end'<<8
	dc.l	NULL
;-------------------------------------
IP_f_suf_t:
	dc.l	fd_IP_fetch,'etch'
	dc.l	NULL
;-------------------------------------
IP_h_suf_t:
	dc.l	fd_IP_handler,'andl'
	dc.l	NULL
;-------------------------------------
IP_d_suf_t:
	dc.l	fd_IP_discard,'isca'
	dc.l	NULL
;-------------------------------------
reso_suf_t:
	dc.l	fd_resolve,'lve'<<8
	dc.l	NULL
;-------------------------------------
getv_suf_t:
	dc.l	fd_getvstr,'str'<<8
	dc.l	NULL
;-------------------------------------
setv_suf_t:
	dc.l	fd_setvstr,'str'<<8
	dc.l	NULL
;-------------------------------------
cntr_suf_t:
	dc.l	fd_cntrl_port,'l_po'
	dc.l	NULL
;-------------------------------------
on_p_suf_t:
	dc.l	fd_on_port,'ort'<<8
	dc.l	NULL
;-------------------------------------
off__suf_t:
	dc.l	fd_off_port,'port'
	dc.l	NULL
;-------------------------------------
quer_suf_t:
	dc.l	fd_query_port,'y_po'
	dc.l	fd_query_chains,'y_ch'
	dc.l	NULL
;-------------------------------------
chec_suf_t:
	dc.l	fd_check_dgram_ttl,'k_dg'
	dc.l	NULL
;-------------------------------------
set__suf_t:
	dc.l	fd_set_dgram_ttl,'dgra'
	dc.l	fd_set_flag,'flag'
	dc.l	fd_set_sysvars,'sysv'
	dc.l	fd_set_route_entry,'rout'
	dc.l	NULL
;-------------------------------------
clea_suf_t:
	dc.l	fd_clear_flag,'r_fl'
	dc.l	NULL
;-------------------------------------
get__suf_t:
	dc.l	fd_get_err_text,'err_'
	dc.l	fd_get_route_entry,'rout'
	dc.l	NULL
;-------------------------------------
load_suf_t:
	dc.l	fd_load_routing_table,'_rou'
	dc.l	NULL
;-------------------------------------
carr_suf_t:
	dc.l	fd_carrier_detect,'ier_'
	dc.l	NULL
;-------------------------------------
hous_suf_t:
	dc.l	fd_housekeep,'ekee'
	dc.l	NULL
;-------------------------------------
ser__suf_t:
	dc.l	fd_ser_enable,'enab'
	dc.l	fd_ser_disable,'disa'
	dc.l	NULL
;-------------------------------------
peek_suf_t:
	dc.l	fd_peek_byt,'_byt'
	dc.l	fd_peek_wor,'_wor'
	dc.l	fd_peek_lon,'_lon'
	dc.l	fd_peek_str,'_str'
	dc.l	NULL
;-------------------------------------
poke_suf_t:
	dc.l	fd_poke_byt,'_byt'
	dc.l	fd_poke_wor,'_wor'
	dc.l	fd_poke_lon,'_lon'
	dc.l	fd_poke_str,'_str'
	dc.l	NULL
;-------------------------------------
dip__suf_t:
	dc.l	fd_dip_to_b,'to_b'
	dc.l	NULL
;-------------------------------------
bip__suf_t:
	dc.l	fd_bip_to_d,'to_d'
	dc.l	NULL
;-------------------------------------
PRTCL_re_sufsuf_t:
	dc.l	fd_PRTCL_request,'ques'
	dc.l	fd_PRTCL_release,'leas'
	dc.l	NULL
;----------------------------------------------------------------------------
fd_def	MACRO	argc,argroom,callsub,argsub,func_id
	IFNE	(\1<0)
	dc.w	\1
	dc.l	\2
	ELSE
	dc.w	\1,\2
	dc.l	\3,\4
	dc.w	\5
	ENDC
	ENDM	;fd_def
;----------------------------------------------------------------------------
fd_protect_exec:	fd_def	3,08,stx_l_func,fixargs_2_ll,STX_protect_exec
fd_TIMER_elapsed:	fd_def	2,04,stx_l_func,fixargs_1_l,STX_TIMER_elapsed
fd_TIMER_now:		fd_def	1,00,stx_l_func,fixargs_0,STX_TIMER_now
fd_TIMER_call:		fd_def	3,06,stx_w_func,fixargs_2_lw,STX_TIMER_call
fd_TCP_info:		fd_def	2,04,tpl_w_func,fixargs_1_l,TPL_TCP_info
fd_TCP_send:		fd_def	4,08,tpl_w_func,fixargs_3_wlw,TPL_TCP_send
fd_TCP_open:		fd_def	5,10,tpl_w_func,fixargs_4_lwww,TPL_TCP_open
fd_TCP_close:		fd_def	4,08,tpl_w_func,fixargs_3_wwl,TPL_TCP_close
fd_TCP_wait_state:	fd_def	4,06,tpl_w_func,fixargs_3_www,TPL_TCP_wait_state
fd_TCP_ack_wait:	fd_def	3,04,tpl_w_func,fixargs_2_ww,TPL_TCP_ack_wait
fd_UDP_info:		fd_def	2,04,tpl_w_func,fixargs_1_l,TPL_UDP_info
fd_UDP_send:		fd_def	4,08,tpl_w_func,fixargs_3_wlw,TPL_UDP_send
fd_UDP_open:		fd_def	3,06,tpl_w_func,fixargs_2_lw,TPL_UDP_open
fd_UDP_close:		fd_def	2,02,tpl_w_func,fixargs_1_w,TPL_UDP_close
fd_CNget_block:		fd_def	4,08,tpl_w_func,fixargs_3_wlw,TPL_CNget_block
fd_CNget_NDB:		fd_def	2,02,tpl_l_func,fixargs_1_w,TPL_CNget_NDB
fd_CNget_char:		fd_def	2,02,tpl_w_func,fixargs_1_w,TPL_CNget_char
fd_CNgets:		fd_def	5,10,tpl_w_func,fixargs_4_wlwb,TPL_CNgets
fd_CNgetinfo:		fd_def	2,02,tpl_l_func,fixargs_1_w,TPL_CNgetinfo
fd_CNbyte_count:	fd_def	2,02,tpl_w_func,fixargs_1_w,TPL_CNbyte_count
fd_CNkick:		fd_def	2,02,tpl_w_func,fixargs_1_w,TPL_CNkick
fd_KRmalloc:		fd_def	2,04,tpl_l_func,fixargs_1_l,TPL_KRmalloc
fd_KRfree:		fd_def	2,04,tpl_0_func,fixargs_1_l,TPL_KRfree
fd_KRgetfree:		fd_def	2,02,tpl_l_func,fixargs_1_w,TPL_KRgetfree
fd_KRrealloc:		fd_def	3,08,tpl_l_func,fixargs_2_ll,TPL_KRrealloc
fd_ICMP_send:		fd_def	6,14,tpl_w_func,fixargs_5_lbblw,TPL_ICMP_send
fd_ICMP_handler:	fd_def	3,06,tpl_w_func,fixargs_2_lw,TPL_ICMP_handler
fd_ICMP_discard:	fd_def	2,04,tpl_0_func,fixargs_1_l,TPL_ICMP_discard
fd_PRTCL_lookup:	fd_def	3,06,stx_l_func,fixargs_2_wl,STX_PRTCL_lookup
fd_PRTCL_get_parameters: fd_def	5,16,stx_w_func,fixargs_4_llll,STX_PRTCL_get_parameters
fd_PRTCL_announce:	fd_def	2,02,stx_w_func,fixargs_1_w,STX_PRTCL_announce
fd_PRTCL_req_rel:	fd_def	-1,PRTCL_re_sufsuf_t
fd_PRTCL_request:	fd_def	3,08,stx_w_func,fixargs_2_ll,STX_PRTCL_request
fd_PRTCL_release:	fd_def	2,02,stx_0_func,fixargs_1_w,STX_PRTCL_release
fd_IP_send:		fd_def 12,30,stx_w_func,fixargs_11_llbwbbwlwlw,STX_IP_send
fd_IP_fetch:		fd_def	2,02,stx_l_func,fixargs_1_w,STX_IP_fetch
fd_IP_handler:		fd_def	4,08,stx_w_func,fixargs_3_wlw,STX_IP_handler
fd_IP_discard:		fd_def	2,04,stx_0_func,fixargs_1_l,STX_IP_discard
fd_resolve:		fd_def	5,14,tpl_w_func,fixargs_4_lllw,TPL_resolve
fd_getvstr:		fd_def	2,04,tpl_l_func,fixargs_1_l,TPL_getvstr
fd_setvstr:		fd_def	3,08,tpl_w_func,fixargs_2_ll,TPL_setvstr
fd_cntrl_port:		fd_def	4,10,tpl_w_func,fixargs_3_llw,TPL_cntrl_port
fd_on_port:		fd_def	2,04,tpl_w_func,fixargs_1_l,TPL_on_port
fd_off_port:		fd_def	2,04,tpl_0_func,fixargs_1_l,TPL_off_port
fd_query_port:		fd_def	2,04,tpl_w_func,fixargs_1_l,TPL_query_port
fd_query_chains:	fd_def	4,12,stx_0_func,fixargs_3_lll,STX_query_chains
fd_check_dgram_ttl:	fd_def	2,04,stx_w_func,fixargs_1_l,STX_check_dgram_ttl
fd_set_dgram_ttl:	fd_def	2,04,stx_0_func,fixargs_1_l,STX_set_dgram_ttl
fd_set_flag:		fd_def	2,02,tpl_w_func,fixargs_1_w,TPL_set_flag
fd_set_sysvars:		fd_def	3,04,stx_l_func,fixargs_2_ww,STX_set_sysvars
fd_set_route_entry:	fd_def	6,18,stx_w_func,fixargs_5_wllll,STX_set_route_entry
fd_clear_flag:		fd_def	2,02,tpl_0_func,fixargs_1_w,TPL_clear_flag
fd_get_err_text:	fd_def	2,02,tpl_l_func,fixargs_1_w,TPL_get_err_text
fd_get_route_entry:	fd_def	6,18,stx_w_func,fixargs_5_wllll,STX_get_route_entry
fd_load_routing_table:	fd_def	1,00,stx_w_func,fixargs_0,STX_load_routing_table
fd_carrier_detect:	fd_def	1,00,tpl_w_func,fixargs_0,TPL_carrier_detect
fd_housekeep:		fd_def	1,00,tpl_0_func,fixargs_0,TPL_housekeep
fd_ser_enable:		fd_def	1,00,tpl_0_func,fixargs_0,TPL_ser_enable
fd_ser_disable:		fd_def	1,00,tpl_0_func,fixargs_0,TPL_ser_disable
fd_peek_byt:		fd_def	2,04,peekb_func,0,0
fd_peek_wor:		fd_def	2,04,peekw_func,0,0
fd_peek_lon:		fd_def	2,04,peekl_func,0,0
fd_peek_str:		fd_def	2,04,peeks_func,0,0
fd_poke_byt:		fd_def	3,08,pokeb_func,0,0
fd_poke_wor:		fd_def	3,08,pokew_func,0,0
fd_poke_lon:		fd_def	3,08,pokel_func,0,0
fd_poke_str:		fd_def	3,08,pokes_func,0,0
fd_dip_to_b:		fd_def	2,04,dip_to_bip,0,0
fd_bip_to_d:		fd_def	2,04,bip_to_dip,0,0
;----------------------------------------------------------------------------
STiKmagic_s:
	dc.b	'STiKmagic',NUL
TRANSPORT_DRIVER_s:
	dc.b	'TRANSPORT_TCPIP',NUL
MODULE_DRIVER_s:
	dc.b	'MODULE_LAYER',NUL
;
STiK_not_found_al_s:
	dc.b	'[3]['
	dc.b	'STinG_GS GEMScript plugin 1.1|'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is missing !]'
	dc.b	'[ Abort ]',NUL
;
STiK_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG_GS GEMScript plugin 1.1|'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is corrupted!]'
	dc.b	'[ Abort ]',NUL
;
driver_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG_GS GEMScript plugin 1.1|'
	dc.b	'-----------------------------|'
	dc.b	'TRANSPORT driver is missing !]'
	dc.b	'[ Abort ]',NUL
;
layer_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG_GS GEMScript plugin 1.1|'
	dc.b	'-----------------------------|'
	dc.b	'MODULE driver is missing !]'
	dc.b	'[ Abort ]',NUL
	even
;----------------------------------------------------------------------------
illegal_parms_zzs:
	dc.b	'Illegal parameters !',NUL,NUL
;-------------------------------------
unknown_func_zzs:
	dc.b	'Unknown function !',NUL,NUL
;-------------------------------------
empty_string_zzs:
	dc.b	$01,NUL,NUL
;-------------------------------------
zero_zzs:
	dc.b	'0',NUL,NUL
;----------------------------------------------------------------------------
data_limit:	SECTION	BSS
;----------------------------------------------------------------------------
sting_drivers:	ds.l	1	;DRV_LIST	*sting_drivers;
tpl:		ds.l	1	;TPL		*tpl;
stx:		ds.l	1	;STX		*stx;
initerr_mess_p:	ds.l	1
fatal_f:	ds.w	1
VA_START_f:	ds.w	1
VA_START_cmd_p:	ds.l	1
VA_protostatus:	ds.l	1
VA_arg_p:	ds.l	1
VA_arg_s:	ds.b	MAX_VA_ARGLEN
string_buf:	ds.b	512+2
		even
;----------------------------------------------------------------------------
bss_limit:	END
;----------------------------------------------------------------------------
;End of file:	STING_GS.S
;----------------------------------------------------------------------------
