;----------------------------------------------------------------------------
;File name:	T_DAYTIM.S			Revision date:	1998.12.04
;Creator:	Ulf Ronald Andersson		Creation date:	1997.08.01
;(c)1997 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
;;;huge_program		= 1	;uncomment if TEXT+DATA sections are > 32KB
;;;keep_windows		= 1	;uncomment to keep ACC vwk in main eventloop
exec_timeout		= 1000	;uncomment to enable timer in main eventloop
exec_message		= 1	;uncomment for messages in main eventloop
;----------------------------------------------------------------------------
	output	.GTP
;----------------------------------------------------------------------------
;Required header declarations:
;
	include	RA_JAR.I		;Cookie jar handling
	include	RA_AV.I			;AV/VA protocol + MP protocol
	include	RA_APP.I		;General application support
	include	RA_ARG.I		;ARGV handler
	include	RA_SIM.I		;GEM alert simulation for TOS/TTP
;
	include	sting\LAYER.I		;only used by servers/modules
	include	sting\TRANSPRT.I	;used by all STinG programs
	include	sting\DOMAIN.I		;handles domain name/ip conv.
;----------------------------------------------------------------------------
DAY_TIME_PORT	equ	13
NET_TIME_PORT	equ	37
TOS_NORMAL	equ	0
BUF_SIZE	equ	500
MAX_VA_ARGLEN	equ	512
STAB_DELAY	equ	200
;----------------------------------------------------------------------------
	SECTION	TEXT
;----------------------------------------------------------------------------
	start_app
;----------------------------------------------------------------------------
	IFEQ	huge_program
	SECTION	data
	ENDC
;----------------------------------------------------------------------------
acc_name:
	dc.b	'  DayTime Client',NUL	;for ACC menu registration
	dc.b	NUL
	even
;
id_app_name_s:
	dc.b	'T_DAYTIM',NUL
	even
;----------------------------------------------------------------------------
	IFEQ	huge_program
	SECTION	BSS
	ENDC
;----------------------------------------------------------------------------
message:	ds.w	8		;evnt_mesag message pipe
intin:		ds.w	30		;30 words or more for AES/VDI
intout:		ds.w	45		;45 words or more for AES/VDI
ptsin:		ds.w	30		;30 words or more for VDI
ptsout:		ds.w	12		;12 words or more for VDI output coordinates
		ds.l	1024		;subroutine stack >= 100 longs
mystack:	ds.l	1		;top of subroutine stack
;----------------------------------------------------------------------------
	SECTION	TEXT
;----------------------------------------------------------------------------
;Start of:	init_app
;----------------------------------------------------------------------------
init_app:
	start_arg
;-------
	clr.l		VA_arg_p
	cmp		#2,arg_cnt
	blo.s		.done_arg
	move.l		arg_ptr,a0
	str_pass	a0
	move.l		a0,VA_arg_p
.done_arg:
;
	st		fatal_f			;assume fatal errors can happen
	gemdos		Super,0.w
	move.l		d0,d4
	eval_cookie	#"STiK"
	move.l		d0,d3			;d3 = d0 -> DRV_LIST structure
	gemdos		Super|_ind,d4
	move.l		d3,sting_drivers	;sting_drivers -> DRV_LIST structure
	ble.s		.STiK_not_found
	move.l		d3,a3			;a3 -> DRV_LIST structure
	lea		DRV_LIST_magic(a3),a0
	lea		STiKmagic_s(pc),a1
	moveq		#10-1,d0
.strcmp_loop:					;loop to test STiKmagic of DRV_LIST
	cmpm.b		(a0)+,(a1)+
	dbne		d0,.strcmp_loop
	bne.s		.STiK_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		TRANSPORT_DRIVER_s		;-(sp) = "TRANSPORT_TCPIP"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,tpl				;store pointer in 'tpl'
	ble.s		.driver_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		MODULE_DRIVER_s			;-(sp) = "MODULE_LAYER"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,stx				;store pointer in 'tpl'
	ble.s		.layer_not_valid
	clr		fatal_f
;
;Add client/server dependent init here
;
	clr.l		initerr_mess_p
	rts
;
.STiK_not_found:
	lea		STiK_not_found_al_s(pc),a0
	bra.s		.init_error
;
.STiK_not_valid:
	lea		STiK_not_valid_al_s(pc),a0
	bra.s		.init_error
;
.driver_not_valid:
	lea		driver_not_valid_al_s(pc),a0
	bra.s		.init_error
;
.layer_not_valid:
	lea		layer_not_valid_al_s(pc),a0
.init_error:
	move.l		a0,initerr_mess_p
	rts
;----------------------------------------------------------------------------
;End of:	init_app
;----------------------------------------------------------------------------
;Start of:	exec_app
;----------------------------------------------------------------------------
exec_app:
	move.l		initerr_mess_p,d3
	beq.s		no_init_err
	move.l		d3,a3
	sim_aes		form_alert,#1,(a3)
	tst		fatal_f
	bne		exit_exec_err
no_init_err:
	clr	d0			;preclear low word of d0
	tst.w	d7			;MI/PL == TOS/GEM
	bmi.s	.TOS_checked		;go keep d0 bit_3 cleared for TOS/TTP program
	bset	#3,d0			;set d0 bit_3 for GEM program
.TOS_checked:
	cmp	#1,global+2		;EQ/NE == Single/Multi-tasking AES
	beq.s	.MULTI_checked		;go keep d0 bit_2 cleared for singletasking
	bset	#2,d0			;set d0 bit_2 for multitasking
.MULTI_checked:
	tst.l	d7			;MI/PL == ACC/nonACC
	bpl.s	.ACC_checked		;go keep d0 bit_1 cleared for nonACC
	bset	#1,d0			;set d0 bit_1 for ACC
.ACC_checked:
	move	exec_ref(pc,d0),d0	;fetch a word offset to selected exec code
	jmp	exec_ref(pc,d0)	;jump to selected exec code
;-------------------------------------
exec_ref:
	dc.w	exec_TOS-exec_ref,exec_TOS-exec_ref
	dc.w	exec_TOS-exec_ref,exec_TOS-exec_ref
	dc.w	exec_single_APP-exec_ref,exec_single_ACC-exec_ref
	dc.w	exec_multi_APP-exec_ref,exec_multi_ACC-exec_ref
;-------------------------------------
exec_multi_APP:
	btst	#7,revise_type_f	;been here before ?
	bne.s	repeat_multi_APP	;then behave like an ACC this time
initial_multi_APP:
	tst.l		d3			;init_error ?
	bne		exit_exec_err		;go exit program on init errors (bad STiK etc)
	bset		#7,revise_type_f	;tell main loop to behave like ACC
	cmp		#1,arg_cnt		;any arguments for this APP
	bgt.s		repeat_multi_APP	;then start directly
	bra		exit_exec_ok		;exit to main event loop
;-------------------------------------
exec_TOS:
exec_single_APP:
exec_single_ACC:
	bsr		close_channel
	bsr		find_time_server
	bmi		exit_exec_ok
	bsr		ask_protocol
	bmi		exit_exec_ok
	bsr		resolve_time_server
	bmi.s		resolve_error
	bsr		send_request
	bmi.s		send_error
	move.l		#5000,d0	
	bsr		await_time_service
	move.l		d0,d3
	bsr		close_channel
	move.l		d3,d0
	bmi		wait_error
	beq		timeout_error
	bra		exit_exec_ok
;
repeat_multi_APP:
exec_multi_ACC:
	bsr		close_channel
	bsr		find_time_server
	bmi		exit_exec_ok
	bsr		ask_protocol
	bmi		exit_exec_ok
	move.l		#10000,main_timeout
	bsr		resolve_time_server
	bpl.s		have_server_ip
resolve_error:
	sim_aes		form_alert,#1,unresolved_al_s(pc)
	bra		exit_exec_ok
;
have_server_ip:
	bsr		send_request
	bpl.s		request_sent
send_error:
	bsr		close_channel
	sim_aes		form_alert,#1,send_error_al_s(pc)
	bra.s		exit_exec_ok
;
request_sent:
	TIMER_now
	move.l		d0,send_time
	move.l		#100,main_timeout
	bra.s		exit_exec_ok
;-------------------------------------
exec_APP_error:		;jump here to display alert (a3) and then exit
	sim_aes		form_alert,#1,(a3)	;NB: has simulation for TOS/TTP
exit_exec_err:		;jump here to exit with error code -1
	moveq		#-1,d0
exit_terminate:		;jump here to exit with error code in d0
	move.l		d0,d3
	bclr		#7,revise_type_f
;
;Add client/server dependent termination code here
;
	move.l		d3,d0
	bra.s		exit_exec_app
;-------------------------------------
exit_exec_ok:
	clr.l	d0
exit_exec_app:
	rts
;----------------------------------------------------------------------------
;End of:	exec_app
;----------------------------------------------------------------------------
;Start of:	exec_timer
;----------------------------------------------------------------------------
	IFNE	exec_timeout	;cond:	ifne exec_timeout
exec_timer:
	tst	handle
	ble	exit_exec_timer
	TIMER_elapsed	send_time
	cmp.l		#10000,d0
	blo.s		not_timed_out
	bsr		close_channel
	move.l		#10000,main_timeout
timeout_error:
	sim_aes		form_alert,#1,timeout_al_s(pc)
	cmp		#1,d0	;[ Ok ] button
	beq		exec_app
	bra.s		exit_exec_timer
;
not_timed_out:
	move.l		#10,d0	
	bsr		await_time_service
	beq.s		exit_exec_timer		;continue waiting
	move		d0,d3
	move.l		#10000,main_timeout
	tst		d3
	bpl.s		exit_exec_timer
wait_error:
	sim_aes		form_alert,#1,wait_error_al_s(pc)
exit_exec_timer:
	clr.l		d0
	rts
	ENDC			;ends:	ifne exec_timeout
;----------------------------------------------------------------------------
;End of:	exec_timer
;----------------------------------------------------------------------------
;Start of:	exec_mesag
;----------------------------------------------------------------------------
	IFNE		exec_message
exec_mesag:
	cmp		#AC_CLOSE,message
	bne.s		.not_AC_CLOSE
	sf		keep_wind_f
	bra		exit_exec_mesag
;
.not_AC_CLOSE:
	cmp		#AP_TERM,message
	bne.s		.not_AP_TERM
	tst.l		d7
	bmi		exit_exec_mesag		;AP_TERM is not for ACCs
	clr.l		d0			;flag no error
	bra		exit_terminate
;
.not_AP_TERM:
	cmp		#VA_START,message
	bne		.not_VA_START
	st		VA_START_f
	move		message+2,AV_partner_id
	move.l		message+6,VA_START_cmd_p
;
	AV_send		PROTOKOLL,#w_VA_START+w_AV_STARTED_A,id_app_name_s
;
	clr.b	VA_arg_s		;prep empty local string
	lea	VA_arg_s(pc),a2		;a2 -> local argument area
	move.l	a2,VA_arg_p		;prep a pointer for future
	move.l	VA_START_cmd_p(pc),a0	;a0 -> argument on Venus
	move.l	a0,d0			;test -> argument on Venus
	ble.s	.send_AV_STARTED	;if NULL, go send reply now
	move.l		a0,a1			;a1 -> argument on Venus
	str_pass	a1
	sub.l		VA_START_cmd_p(pc),a1
	move.l		a1,d1			;d1 = length of argument
	move		#MAX_VA_ARGLEN,d0
	cmp.l		d0,d1			;argument too long ?
	blo.s		.length_ok
	move.l		d0,d1			;limit argument length
.length_ok:
	move.b		-1(a0,d1.w),d0		;save byte at termination point
	clr.b		-1(a0,d1.w)		;enforce limited termination
	move.l		a0,a1			;a1 -> argument on Venus
	lea		VA_arg_s(pc),a2		;a2 -> local argument area
	move.l		a2,VA_arg_p		;prep a pointer for future
	str_copy	a1,a2			;make a local copy of argument
	move.b		d0,-1(a0,d1.w)		;repair original copy
.send_AV_STARTED:
	AV_send.i	STARTED,VA_START_cmd_p
	bra		exec_app
;
.not_VA_START:
	cmp		#VA_PROTOSTATUS,message
	bne.s		.not_VA_PROTOSTATUS
	move		message+8,VA_protostatus
	move		message+6,VA_protostatus+2
	bra		exit_exec_mesag
;
.not_VA_PROTOSTATUS:
exec_mesag_extend:
;
;Add client/server dependent message event work here
;
exit_exec_mesag:
	rts
	ENDC		exec_message
;----------------------------------------------------------------------------
;End of:	exec_mesag
;----------------------------------------------------------------------------
;Start of:	subroutines
;----------------------------------------------------------------------------
ask_protocol:
	sim_aes		form_alert,#1,ask_protocol_al_s(pc)
	cmp		#2,d0		;UDP button ?
	slo		TCP_f
	bhi.s		.cancel
	clr.l		d0		;flag zero for TCP/UDP buttons
	rts
;
.cancel:
	moveq		#-1,d0		;flac -1 for Cancel button
	rts
;----------------------------------------------------------------------------
find_time_server:
	clr.l		time_server_ip
	move.l		VA_arg_p(pc),d0
	bsr.s		test_time_server
	bne.s		.exit
.try_TIME_SERVER_var:
	getvstr		TIME_SERVER_vn_s(pc)
	bsr.s		test_time_server
	bne.s		.exit
	sim_aes		form_alert,#1,time_server_not_valid_al_s(pc)
	clr.l		d0
.exit:
	rts
;----------------------------------------------------------------------------
test_time_server:
	is_unblank.i	d0
	move.l		a0,time_server_s_p
	beq.s		.exit
	is_dip		(a0)
	move.l		a0,d0
	beq.s		.exit
	diptobip	(a0)
	move.l		d0,time_server_ip
.exit:
	move.l		time_server_s_p(pc),d0
	rts
;----------------------------------------------------------------------------
resolve_time_server:
	clr.l		d0
	tst.l		time_server_ip
	bne.s		.exit
	resolve.i	time_server_s_p(pc),#0,#time_server_ip,#1
.exit:
	tst.l		d0
	rts		
;----------------------------------------------------------------------------
close_channel:
	tst		handle
	ble.s		.exit
	tst		TCP_f
	beq.s		.close_udp
.close_tcp:
	TCP_close	handle,#1,!
	bra.s		.exit
;
.close_udp:
	UDP_close	handle
.exit:
	clr.l		handle
	rts
;----------------------------------------------------------------------------
send_request:
	tst		TCP_f
	beq.s		.send_UDP
	TCP_open	time_server_ip,#DAY_TIME_PORT,#TOS_NORMAL,#BUF_SIZE
	move		d0,handle
	bra.s		.exit
;
.send_UDP:
	UDP_open	time_server_ip,#DAY_TIME_PORT
	move		d0,handle
	bmi.s		.exit
	clr.l		buffer
	UDP_send	d0,buffer(pc),#0	;send empty datagram
	clr.l		d0
.exit:
	rts
;----------------------------------------------------------------------------
await_time_service:
	move.l		d0,max_delay
	TIMER_now
	move.l		d0,start_time
.nodata_loop:
	clr		rx_length
.wait_loop:
	_appl_yield
	move		rx_length(pc),d0
	bne.s		.done_timeout
	TIMER_elapsed	start_time(pc)
	cmp.l		max_delay(pc),d0
	bhs		.timed_out
.done_timeout:
	CNbyte_count	handle
	cmp		#E_LISTEN,d0
	beq		.nodata_loop
	cmp		#E_NODATA,d0
	beq		.nodata_loop		;loop on E_NODATA
	tst		d0
	bmi		.error			;break on errors
	cmp		rx_length(pc),d0	;any new data ?
	bls.s		.done_time		;if not, keep reception time
	move		d0,rx_length		;store new data length as old
	TIMER_now				;get current time
	move.l		d0,recv_time		;store as reception time
	move		rx_length(pc),d0	;d0 = data length
.done_time:
	cmp		#10,d0
	blt		.wait_loop		;loop on short reception
	TIMER_elapsed	recv_time(pc)		;get time elapsed since reception
	cmp.l		#STAB_DELAY,d0		;sufficient to assume completion
	blo		.wait_loop		;if not, keep waiting
	move		rx_length(pc),d0	;d0 = data length
;
	cmp		#256,d0
	blo.s		.keep_length
	move		#255,d0		;limit data length
.keep_length:
	lea		daytime_block_s(pc),a0
	clr.b		(a0)			;dummy string terminator
	clr.b		(a0,d0)			;final string terminator
	CNget_block	handle,(a0),d0
	bsr		close_channel
	lea		daytime_block_s(pc),a0
	lea		daytime_alert_body_s(pc),a1
	moveq		#3-1,d1			;prep for max 3 lines
.loop_1:
	move.b		#'"',(a1)+
	moveq		#27-1,d2		;prep for max 27 char/line
.loop_2:
	move.b		(a0)+,d0
	beq.s		.patch_1
	cmp.b		#' ',d0
	blo.s		.mask_char
	cmp.b		#'[',d0
	beq.s		.mask_char
	cmp.b		#'|',d0
	beq.s		.mask_char
	cmp.b		#']',d0
	bne.s		.masked_char
.mask_char:
	move.b		#'.',d0
.masked_char:
	move.b		d0,(a1)+
	dbra		d2,.loop_2
	move.b		#'"',(a1)+
	move.b		#'|',(a1)+
	dbra		d1,.loop_1
	bra.s		.patch_2
;
.patch_1:
	move.b		#'"',(a1)+
	bra.s		.patch_3
;
.patch_2:
	subq		#1,a1
.patch_3:
	lea		daytime_alert_tail_s(pc),a0
.loop_3:
	move.b		(a0)+,(a1)+
	bne		.loop_3
	sim_aes		form_alert,#1,daytime_al_s(pc)
	tst		d0
	rts		;d0 = button returned = 1 flagging no error
;
.timed_out:
	clr.l		d0	;flag no time received
	rts
;
.error:
	bsr		close_channel
	moveq		#-1,d0	;flag error received
	rts
;----------------------------------------------------------------------------
;End of:	subroutines
;----------------------------------------------------------------------------
	make	SIM_links
	make	JAR_links
	make	DOMAIN_links
	make	AV_links
;----------------------------------------------------------------------------
text_limit:	SECTION	DATA
;----------------------------------------------------------------------------
STiKmagic_s:
	dc.b	'STiKmagic',NUL
TRANSPORT_DRIVER_s:
	dc.b	'TRANSPORT_TCPIP',NUL
MODULE_DRIVER_s:
	dc.b	'MODULE_LAYER',NUL
;
STiK_not_found_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_DayTim time client: |'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is missing !]'
	dc.b	'[ Abort ]',NUL
;
STiK_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_DayTim time client: |'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is corrupted!]'
	dc.b	'[ Abort ]',NUL
;
driver_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_DayTim time client: |'
	dc.b	'-----------------------------|'
	dc.b	'TRANSPORT driver is missing !]'
	dc.b	'[ Abort ]',NUL
;
layer_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_DayTim time client: |'
	dc.b	'-----------------------------|'
	dc.b	'MODULE driver is missing !]'
	dc.b	'[ Abort ]',NUL
	even
;
;
TIME_SERVER_vn_s:
	dc.b	'TIME_SERVER',NUL
;
time_server_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_DayTim time client: |'
	dc.b	'-----------------------------|'
	dc.b	'TIME_SERVER must be specified|'
	dc.b	'in argument or STinG variable|'
	dc.b	'(use domain or dotted IP num)]'
	dc.b	'[ Abort ]',NUL
;
unresolved_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_DayTim time client: |'
	dc.b	'-----------------------------|'
	dc.b	'TIME_SERVER address could not|'
	dc.b	'be resolved at this time. It |'
	dc.b	'may be configuration error !]'
	dc.b	'[ Abort ]',NUL
;
send_error_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_DayTim time client: |'
	dc.b	'-----------------------------|'
	dc.b	'An error occurred attempting |'
	dc.b	'to send a request to the time|'
	dc.b	'server !]'
	dc.b	'[ Abort ]',NUL
;
wait_error_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_DayTim time client: |'
	dc.b	'-----------------------------|'
	dc.b	'An error occurred in awaiting|'
	dc.b	'a reply from the time server.]'
	dc.b	'[ Abort ]',NUL
;
ask_protocol_al_s:
	dc.b	'[2]['
	dc.b	'STinG  T_DayTim time client: |'
	dc.b	'-----------------------------|'
	dc.b	'Which protocol do you want to|'
	dc.b	'use on this server request ?]'
	dc.b	'[ TCP | UDP | Cancel ]',NUL
;
timeout_al_s:
	dc.b	'[2]['
	dc.b	'STinG  T_DayTim time client: |'
	dc.b	'-----------------------------|'
	dc.b	'Time server does not answer !|'
	dc.b	'Click  Ok to make yet another|'
	dc.b	'attempt to contact it.]'
	dc.b	'[ Ok | Cancel ]',NUL
;
daytime_al_s:
	dc.b	'[0]['
	dc.b	'T_DayTim server response:    |'
	dc.b	'-----------------------------|'
daytime_alert_body_s:
	ds.b	128
;
daytime_alert_tail_s:
	dc.b	'][ Ok ]',NUL
;----------------------------------------------------------------------------
data_limit:	SECTION	BSS
;----------------------------------------------------------------------------
sting_drivers:	ds.l	1	;DRV_LIST	*sting_drivers;
tpl:		ds.l	1	;TPL		*tpl;
stx:		ds.l	1	;STX		*stx;
initerr_mess_p:	ds.l	1
fatal_f:	ds.w	1
VA_START_f:	ds.w	1
VA_START_cmd_p:	ds.l	1
VA_protostatus:	ds.l	1
VA_arg_p:	ds.l	1
VA_arg_s:	ds.b	MAX_VA_ARGLEN
		even
;
time_server_s_p:	ds.l	1
time_server_ip:		ds.l	1
TCP_f:			ds.w	1
rx_length:		ds.w	1
recv_time:		ds.l	1
handle:			ds.w	1
send_time:		ds.l	1
start_time:		ds.l	1
max_delay:		ds.l	1
buffer:			ds.b	BUF_SIZE
daytime_block_s:	ds.b	256
;----------------------------------------------------------------------------
bss_limit:	END
;----------------------------------------------------------------------------
;End of file:	T_DAYTIM.S
;----------------------------------------------------------------------------
