;----------------------------------------------------------------------------
;File name:	T_RANDOM.S			Revision date:	1997.08.10
;Creator:	Ulf Ronald Andersson		Creation date:	1997.08.01
;(c)1996 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
;Purpose:	Randomizes the system time setting, to allow repeated
;		testing of time server clients that can correct this.
;----------------------------------------------------------------------------
;Required header declarations:
;
	.include	"uran\STRUCT.SH"	;PASM adapted structures
	.include	"uran\URAn_SYS.SH"	;Main system definitions
	.include	"uran\URAn_LA.SH"	;Line A variables etc
	.include	"uran\URAn_DOS.SH"	;GEMDOS, BIOS, XBIOS
	.include	"uran\URAn_GEM.SH"	;VDI & AES
	.include	"uran\URAn_APP.SH"	;General application support
	.include	"uran\URAn_AV.SH"	;AV/VA protocol + MP protocol
;
	.include	"sting\NET_TCON.SH"	;handles time conversions
;
;----------------------------------------------------------------------------
;
exec_message		= 1
;
;----------------------------------------------------------------------------
;
	.text
;
	start_app
;
;----------------------------------------------------------------------------
;
	.data
;
acc_name:
	dc.b	'  Time Randomizer',NUL	;for ACC menu registration
	dc.b	NUL
	even
;
id_app_name_s:
	dc.b	'T_RANDOM',NUL
	even
;
;----------------------------------------------------------------------------
;
	.bss
;
message:	ds.w	8		;evnt_mesag message pipe
intin:		ds.w	30		;30 words or more for AES/VDI
intout:		ds.w	45		;45 words or more for AES/VDI
ptsin:		ds.w	30		;30 words or more for VDI
ptsout:		ds.w	12		;12 words or more for VDI output coordinates
		ds.l	200		;subroutine stack >= 100 longs
mystack:	ds.l	1		;top of subroutine stack
;
;----------------------------------------------------------------------------
;
	.text
;
;----------------------------------------------------------------------------
;Start of:	init_app
;----------------------------------------------------------------------------
;
init_app:
	rts
;
;----------------------------------------------------------------------------
;End of:	init_app
;----------------------------------------------------------------------------
;Start of:	exec_app
;----------------------------------------------------------------------------
;
exec_app:
	xbios		Random		;get one 24 bit random number, but it
	add.l		d0,rand_seed	;isn't very good, so only used as seed
	bsr		rand_long	;this gives a very random longword
	lea		tcon_data(pc),a0
	move.l		d0,tcon_net_time(a0)	;simulate random network time
	tcon_net2man	;convert 32 bit number to human (separate) time format
	tcon_man2tos	;convert to TOS format (2 bitpacked words)
	tcon_tos2real	;set system time to the resulting (random) time & date
exit_terminate:
	clr.l	d0
	rts
;
;----------------------------------------------------------------------------
;End of:	exec_app
;----------------------------------------------------------------------------
;Start of:	exec_mesag
;----------------------------------------------------------------------------
;
	.ifne		exec_message
exec_mesag:
	cmp		#AC_CLOSE,message
	bne.s		.not_AC_CLOSE
	sf		keep_wind_f
	bra		exit_exec_mesag
;
.not_AC_CLOSE:
	cmp		#AP_TERM,message
	bne.s		.not_AP_TERM
	tst.l		d7
	bmi		exit_exec_mesag		;AP_TERM is not for ACCs
	clr.l		d0			;flag no error
	bra		exit_terminate
;
.not_AP_TERM:
	cmp		#VA_START,message
	bne.s		.not_VA_START
	st		VA_START_f
	move		message+2,AV_partner_id
	move.l		message+6,VA_START_cmd_p
	AV_send		PROTOKOLL,#w_VA_START+w_AV_STARTED_A,id_app_name_s
;
;Add ALL handling of the passed command line here, if you need to do some later
;you must copy it here, because the original may disappear after AV_STARTED.
;
	AV_send.i	STARTED,VA_START_cmd_p
	bra		exec_app
;
.not_VA_START:
	cmp		#VA_PROTOSTATUS,message
	bne.s		.not_VA_PROTOSTATUS
	move		message+8,VA_protostatus
	move		message+6,VA_protostatus+2
	bra		exit_exec_mesag
;
.not_VA_PROTOSTATUS:
exec_mesag_extend:
;
;Add client/server dependent message event work here
;
exit_exec_mesag:
	rts
	.endif		exec_message
;
;----------------------------------------------------------------------------
;End of:	exec_mesag
;----------------------------------------------------------------------------
;
rand_long:
	move.l	rand_seed(pc),d0
	bne.s	.seed_ok
	move.l	#'Rand',d0
.seed_ok:
	bsr.s	rand_31_long
	move.l	d0,rand_seed
	rts
;
rand_seed:
	dc.l	'Rand'
;
;----------------------------------------------------------------------------
;
rand_31_long:	;generates 32 entirely new bits from older value
	lsr.l	#1,d0		;Adjust 31-bit pseudorandom shifter
	move.l	d0,d1		;copy to d1
	ror.l	#3,d1		;shift d1 by 3 bits for 31 bit pseudorandomicity
	eor.w	d1,d0		;generate 16 new pseudorandom top bits 
	swap	d0		;align 16 new bits correctly
	roxl.w	#1,d0		;align 15 old bits correctly and get dummy bit 0
rand_31_word:	;generates 16 entirely new bits from older value
	lsr.l	#1,d0		;Adjust 31-bit pseudorandom shifter
	move.l	d0,d1		;copy to d1
	ror.l	#3,d1		;shift d1 by 3 bits for 31 bit pseudorandomicity
	eor.w	d1,d0		;generate 16 new pseudorandom top bits 
	swap	d0		;align 16 new bits correctly
	roxl.w	#1,d0		;align 15 old bits correctly and get dummy bit 0
	rts
;
;----------------------------------------------------------------------------
;
	make	GEM_links
	make	TCON_links
	make	AV_links
;
;----------------------------------------------------------------------------
;
text_limit:	.data
;
;----------------------------------------------------------------------------
;
;----------------------------------------------------------------------------
;
data_limit:	.bss
;
;----------------------------------------------------------------------------
;
tcon_data:	ds.b	sizeof_tcon
VA_START_f:	ds.w	1
VA_START_cmd_p:	ds.l	1
VA_protostatus:	ds.l	1
;
;----------------------------------------------------------------------------
bss_limit:	.end
;----------------------------------------------------------------------------
;End of file:	T_RANDOM.S
;----------------------------------------------------------------------------
