;----------------------------------------------------------------------------
;File name:	CALL_ILL.S			Revision date:	1997.01.17
;Creator:	Ulf Ronald Andersson		Creation date:	1997.01.17
;(c)1996 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
;
;;;huge_program		= 1	;uncomment if TEXT+DATA sections are > 32KB
;;;keep_windows		= 1	;uncomment to keep ACC vwk in main eventloop
;;;exec_timeout		= 100	;uncomment to enable timer in main eventloop
;;;exec_message		= 1	;uncomment for messages in main eventloop
;
;----------------------------------------------------------------------------
;
	output	.PRG
;
	include	URAn_DOS.S
	include	URAn_SIM.S
	include	URAn_LA.S
	include	URAn_AV.S
	include	URAn_XB.S
;
;----------------------------------------------------------------------------
;
	SECTION	TEXT
;
	include	URAn_APP.S
;
;----------------------------------------------------------------------------
;
	ifnd	huge_program
	SECTION	DATA
	endc
;
acc_name:	dc.b	'  Call Illegal',NUL	;for ACC menu registration
		dc.b	NUL
;
;----------------------------------------------------------------------------
;
	ifnd	huge_program
	SECTION	BSS
	endc
;
message:	ds.w	8		;evnt_mesag message pipe
intin:		ds.w	30		;30 words or more for AES/VDI
intout:		ds.w	45		;45 words or more for AES/VDI
ptsin:		ds.w	30		;30 words or more for VDI
ptsout:		ds.w	12		;12 words or more for VDI output coordinates
		ds.l	200		;subroutine stack >= 100 longs
mystack:	ds.l	1		;top of subroutine stack
;
;----------------------------------------------------------------------------
;
	SECTION	TEXT
;
;----------------------------------------------------------------------------
;	Constants, Variables, and Usage of the URAn_APP.S library
;
;rz		'relative zero' for internal references
;basepage_p	-> program's base page
;tsr_size	.L size of BASEPAGE+TEXT+DATA+BSS  (only TOS/TTP may TSR)
;progtype	.L indicates program type:
;  ...			$0000.$FFFF == TOS/TTP/boot_PRG
;  ...			$0000.ap_id == APP/GTP/non_boot_PRG
;  ...			$FFFF.ap_id == ACC
;acc_flag	is the high word of 'progtype'
;tos_flag	is the low word of 'progtype'
;bootflag	.W $FFFF == PRG booted from AUTO (also sets 'tos_flag')
;menu_id	.W menu id for an ACC, otherwise null
;g_handle	.W workstation handle for ACC/APP/GTP/non_boot_PRG
;vwk_handle	.W virtual workstation handle
;contrl		12 words for AES/VDI control data
;
;wk_x_rez \
;wk_y_rez  \/ from
;wk_pix_w  /\ opnvwk
;wk_pix_h /
;
;MiNT_p		.L NULL or -> MiNT structure
;MagX_p		.L NULL or -> MagX structure
;nAES_p		.L NULL or -> nAES structure
;Gnva_p		.L NULL or -> Gnva structure
;
;line_a_base_p	.L -> line_a variable base
;kbshift_p	.L -> kbshift byte of OS
;currbp_p_p	.L -> OS var -> current basepage
;
;NB: if symbol 'huge_program' is defined, above data is in TEXT section (else in BSS)
;NB: defining 'huge_program' also makes function calls use 'jsr' (instead of bsr)
;
;Required user routines:
;
;init_app	called for ACC/APP/GTP/non_boot_PRG to init application,
;		but doesn't need appl_init, graf_handle, or v_opnvwk,
;		nor does an ACC need menu_register.
;		Suitable use is for initialization of object trees.
;NB:  for ACC	menu_register is called between init_app and exec_app
;
;exec_app	called to execute the main application regardless of type,
;		but doesn't need v_clsvwk, or appl_exit, or ACC appl_mesag.
;		This call will be repeated for a reactivated ACC.
;		Non_acc programs should have exit code in d0 at RTS.
;		(See details at 'Exit codes:' below)
;
;	At entry to either of these two routines:
;
;		d6.W	== bootflag	\
;		d7.L	== progtype	 > See descriptions above.
;		a6.L	== rz		/
;
;Optional user routines:
;
;exec_timer	Called for ACC that has a defined constant 'exec_timeout',
;		whenever evnt_multi produces such a timer event.
;		The constant is placed as long at 'main_timeout', and may
;		there be dynamically adjusted by the program.
;
;exec_mesag	Called for ACC that has a defined constant 'exec_message',
;		whenever evnt_multi/evnt_mesag produces messages that are
;		not AC_OPEN  (such as VA_START).
;
;		If the constant 'keep_windows' is also set, the workstation
;		will not be closed at each return (you must obey AC_CLOSE).
;		This places a word == $FF00 at 'keep_wind_f', and if the top
;		byte is cleared the workstation closure is enabled again.
;
;NB:	Top bit of the word 'revise_type_f' is used for 3 purposes:
;   1:	Let ACC start 'exec_app' directly without awaiting event.
;   2:	Let APP delay 'exec_app' until an event occurs.
;   3:	Let APP loop back for more events after 'exec_app'
;The flag must be set by 'init_app' in the first two cases, and in case 3
;should be set/cleared in 'exec_app' to decide whether to exit program.
;
;Exit codes:	At exit from exec_app, d0 has the following effects
;		when the program was not started as accessory.
;
; negative	=> Pterm(d0)			=> error code exit
; 0		=> Pterm(d0)			=> error free exit
; 0x0000ADD0	=> Ptermres(tsr_size,0)		=> error free resident exit
; 0x0000ADD1	=> Ptermres(d1,0)		=> error free resident exit
; 0x0000ADD2	=> Ptermres(d1,d2)		=> error code resident exit
;
;----------------------------------------------------------------------------
;Start of:	init_app
;----------------------------------------------------------------------------
;
init_app:
	include	URAn_ARG.S
	rts
;
;----------------------------------------------------------------------------
;End of:	init_app
;----------------------------------------------------------------------------
;	URAn_ARG.S defines two variables
;
;arg_cnt	== number of strings on command line
;arg_ptr	-> NUL_separated argument strings + final NUL
;
;NB:	Both of the above include a dummy program name (first string==NUL).
;----------------------------------------------------------------------------
;Start of:	exec_app
;----------------------------------------------------------------------------
;
exec_app:
	lea	progname_s(pc),a0
	bsr	get_path_tail_s
	gemdos	Pexec,!,progpath_s(pc),progtail_s,!
;
	move.l	#result_num_s,conv_p
	bsr.s	convlong
	move.b	#' ',result_al_tail_s
	sim_aes	form_alert,#1,result_al_s
	clr.l	d0
exit_exec_app:
	rts
;
;----------------------------------------------------------------------------
;End of:	exec_app
;----------------------------------------------------------------------------
;Start of:	exec_timer
;----------------------------------------------------------------------------
;
	ifd	exec_timeout	;cond:	ifd exec_timeout
exec_timer:
exit_exec_timer:
	rts
	endc			;ends:	ifd exec_timeout
;
;----------------------------------------------------------------------------
;End of:	exec_timer
;----------------------------------------------------------------------------
;Start of:	exec_mesag
;----------------------------------------------------------------------------
;
	ifd	exec_message	;cond:	ifd exec_message
exec_mesag:
	cmp	#AC_CLOSE,message
	beq	exec_mesag_AC_CLOSE
;
	bra	exit_exec_mesag
;
exec_mesag_AC_CLOSE:
	sf	keep_wind_f
exit_exec_mesag:
	rts
	endc			;ends:	ifd exec_message
;
;----------------------------------------------------------------------------
;End of:	exec_mesag
;----------------------------------------------------------------------------
;
convlong:
	bsr	.convword
.convword:
	bsr	.convbyte
.convbyte:
	bsr	.conv_hex
.conv_hex:
	rol.l	#4,d0
	movem.l	d0-d2/a0-a2,-(sp)
	and	#$0F,d0
	or	#'0',d0
	cmp	#'9',d0
	bls.s	.got_hex
	add	#('A'-('9'+1)),d0
.got_hex:
	move.l	conv_p,a0
	move.b	d0,(a0)+
	clr.b	(a0)
	move.l	a0,conv_p
	movem.l	(sp)+,d0-d2/a0-a2
	rts
;
;
conv_p:
	dc.l	0
;
;
;----------------------------------------------------------------------------
;
get_path_tail_s:
	move.l	a0,-(sp)
	gem_aes	shel_read,progpath_s(pc),progtail_s(pc)
	lea	progpath_s(pc),a0
	move.l	a0,a1
	tst	d0
	beq.s	.fill_name
	move	#240-1,d1
.find_end_lp:
	move.b	(a0)+,d0
	beq.s	.fill_name
	cmp.b	#'\',d0
	dbeq	d1,.find_end_lp
	bne.s	.fill_name
	move.l	a0,a1
	dbra	d1,.find_end_lp
.fill_name:
	move.l	(sp)+,a0
.fill_name_lp:
	move.b	(a0)+,(a1)+
	bne.s	.fill_name_lp
	rts
;
;----------------------------------------------------------------------------
;
	make	AV_links
	make	SIM_links
;
;----------------------------------------------------------------------------
;
text_limit:	section	DATA
;
;----------------------------------------------------------------------------
;Enter program constant definitions below:
;
result_al_s:
	dc.b	'[1]['
	dc.b	'                             |'
	dc.b	'Result|'
	dc.b	'=$'
result_num_s:
	dc.b	'12345678'
result_al_tail_s:
	dc.b	' ][ Ok ]',NUL
	even
;
progname_s:
	dc.b	'ILLEGAL.PRG',NUL
	even
;
;----------------------------------------------------------------------------
;
data_limit:	SECTION	BSS
;
;----------------------------------------------------------------------------
;Enter program variable definitions below:
;
progpath_s:
	ds.b	256
progtail_s:
	ds.b	128
;
;----------------------------------------------------------------------------
bss_limit:	END
;----------------------------------------------------------------------------
;End of file:	CALL_ILL.S
;----------------------------------------------------------------------------
