;----------------------------------------------------------------------------
;File name:	DEBUGAID.S			Revision date:	1996.01.21
;Creator:	Ulf Ronald Andersson		Creation date:	1995.08.10
;(c)1992 by:	Ulf Ronald Andersson		All rights reserved
;Released as:	FREEWARE		(NB: commercial sales forbidden!)
;----------------------------------------------------------------------------
;
	output	.TOS
DBug_size	= 32
;
;----------------------------------------------------------------------------
;
	include	URAn_SIM.S
	include	URAn_JAR.S
	include	URAn_XB.S
	include	URAn_LA.S
;
;----------------------------------------------------------------------------
	SECTION	text
;----------------------------------------------------------------------------
;
	bra	startup
	illegal
;
;----------------------------------------------------------------------------
;
stackframe_len:		ds.w	1
err_code:		ds.l	1
temp_sr:		ds.w	1
temp_regs:		ds.l	16
;
;----------------------------------------------------------------------------
;
DBug_struct:
DBug_self_id:		dc.l	'DBug'
DBug_test_id:		dc.l	'DBug'
DBug_struct_size:	dc.l	DBug_struct_end-DBug_struct
DBug_version:		dc.w	$0100
DBug_interface:		dc.w	$0100
			dc.b	'DBug_dly'
DBug_delay:		dc.w	200
			dc.b	'DBugHold'
DBug_hold_f:		dc.w	$FF00
			dc.b	'DBugBlkT'
DBug_trap_block_t:	dcb.w	16+2,0		;1 TAS flag per trap
			dc.b	'DBugRegs'
DBug_regs:		ds.l	16
			dc.b	'DBugSstk'
DBug_ssp_stack:		ds.b	DBug_size
			dc.b	'DBugSLim'
			dc.b	'DBugUstk'
DBug_usp_stack:		ds.b	DBug_size
			dc.b	'DBugULim'
			dc.b	'DBugData'
DBug_test_data:		ds.b	$100
			dc.b	'DBugDLim'
;
;extend structure above this line
;
DBug_struct_end:	illegal
;
;----------------------------------------------------------------------------
;Start of:	'DBug' macro definitions
;----------------------------------------------------------------------------
;
DVector	macro	trap_number,trap_name,store_flag
DBug_id_\2:
	dc.b	'\2','_ID:'
	even
DBug_retad_\2:
	ds.l	1
;
	XB_define	nu_\2,'DBug'
;
DBug_entry_\2:
	tst	DBug_hold_f
	bne.s	go_old_\2
	tas	DBug_trap_block_t+2*(\1)
	bmi.s	go_old_\2
	move.l	DBug_id_\2,DBug_test_id
	sf	DBug_trap_block_t+2*(\1)+1
	ifc	'1','\1'
	bsr	DBug_store
	endc
	bsr	DBug_test
	bpl.s	.prep_postfix
	st	DBug_hold_f
	illegal
	bra.s	go_old_\2
;
.prep_postfix:
	move.l	2(sp),DBug_retad_\2
	move.l	#postfix_\2,2(sp)
go_old_\2:
nextlink_\2	= *+2
	move.l	(nu_\2+xb_next).l,jumplink_\2
jumplink_\2	= *+2
	jmp	0.l
;
postfix_\2:
	trap	#5
	st	DBug_trap_block_t+2*(\1)+1
	bsr	DBug_test
	bpl.s	.return
	st	DBug_hold_f
	illegal
.return:
	bclr	#7,DBug_trap_block_t+2*(\1)
	move.l	DBug_retad_\2,2(sp)
	rte
;
	endm	;DVector
;
;;----------------------------------------------------------------------------
;End of:	'DBug' macro definitions
;----------------------------------------------------------------------------
;Start of:	Trap 5 function with XBRA
;----------------------------------------------------------------------------
;
	XB_define	nu_trap5,'DBug'
;
	move.l	2(sp),-(sp)
	rts
;
;----------------------------------------------------------------------------
;End of:	Trap 5 function with XBRA
;----------------------------------------------------------------------------
;Start of:	BIOS functions with XBRA
;----------------------------------------------------------------------------
;
	DVector	13,bios,1
;
;----------------------------------------------------------------------------
;End of:	BIOS functions with XBRA
;----------------------------------------------------------------------------
;Start of:	XBIOS functions with XBRA
;----------------------------------------------------------------------------
;
	DVector	14,xbios,1
;
;----------------------------------------------------------------------------
;End of:	XBIOS functions with XBRA
;----------------------------------------------------------------------------
;Start of:	GEMDOS functions with XBRA
;----------------------------------------------------------------------------
;
	XB_define	fix_gemdos,'DBug'
	tst	DBug_hold_f
	bne	go_old_gemdos
	tst	DBug_trap_block_t+2*1
	bmi	go_old_gemdos
;
	btst	#5,(sp)
	beq.s	.user_args
.super_args:
	move.l	sp,a0
	add	stackframe_len(pc),a0
	bra.s	.have_args
;
.user_args:
	move.l	usp,a0
.have_args:
	move	(a0),d0
	beq.s	nu_Pterm0
	cmp	#Ptermres&$ff,d0
	blt.s	.make_test
	beq.s	nu_Ptermres
	cmp	#Pexec&$ff,d0
	blt.s	.make_test
	beq.s	nu_Pexec
	cmp	#Pterm&$ff,d0
	beq.s	nu_Pterm
.make_test:
	bra.s	DBug_entry_gemdos
;
nu_Pexec:
nu_Pterm:
nu_Ptermres:
nu_Pterm0:
	bra.s	go_old_gemdos
;
	DVector 1,gemdos,1
;
;----------------------------------------------------------------------------
;End of:	GEMDOS functions with XBRA
;----------------------------------------------------------------------------
;Start of:	XGEMDOS functions with XBRA
;----------------------------------------------------------------------------
;
	DVector	2,xgemdos,1
;
;----------------------------------------------------------------------------
;End of:	XGEMDOS functions with XBRA
;----------------------------------------------------------------------------
;Start of:	VBI function with XBRA
;----------------------------------------------------------------------------
;
	DVector	16,VBI,0
;
;----------------------------------------------------------------------------
;End of:	VBI function with XBRA
;----------------------------------------------------------------------------
;Start of:	timer C function with XBRA
;----------------------------------------------------------------------------
;
	DVector	17,TimC,0
;
;----------------------------------------------------------------------------
;End of:	timer C function with XBRA
;----------------------------------------------------------------------------
;Start of:	Supexec subroutine	'DBug_store'
;----------------------------------------------------------------------------
;
DBug_store:
	movem.l	d0-d7/a0-a7,DBug_regs
	lea	(sp),a0
	lea	DBug_ssp_stack,a1
	move.l	usp,a2
	lea	DBug_usp_stack,a3
	moveq	#DBug_Size/32-1,d0
.DBug_loop:
	movem.l	(a0)+,d1-d7/a4
	movem.l	d1-d7/a4,(a1)
	lea	8*4(a1),a1
	movem.l	(a2)+,d1-d7/a4
	movem.l	d1-d7/a4,(a3)
	lea	8*4(a3),a3
	dbra	d0,.DBug_loop
	movem.l	DBug_regs,d0-d7/a0-a7
	rts
;
;----------------------------------------------------------------------------
;End of:	Supexec subroutine	'DBug_store'
;----------------------------------------------------------------------------
;Start of:	Supexec subroutine	'DBug_test'
;----------------------------------------------------------------------------
;
DBug_test:
	tst	DBug_delay
	beq.s	.make_test
	subq	#1,DBug_delay
	bra.s	DBugTst_ok
;
.make_test:
	move	(hw_pal+3*2),DBug_test_data
	and	#$0777,DBug_test_data
	cmp	#$0770,DBug_test_data
	beq.s	DBugTst_ok
DBugTst_error:
	tst	negative_f
	bra.s	DBugTst_exit
;
negative_f:
	dc.w	-1
positive_f:
	dc.w	0
;
DBugTst_ok:
	tst	positive_f
DBugTst_exit:
	rts
;
;----------------------------------------------------------------------------
;End of:	Supexec subroutine	'DBug_test'
;----------------------------------------------------------------------------
;Start of:	Resident library routines
;----------------------------------------------------------------------------
;
	include XB_SUBS.S
;
	make	SIM_links
;
	_uniref	reset_old_jar
	make	JAR_links
;
;----------------------------------------------------------------------------
;End of:	Resident library routines
;----------------------------------------------------------------------------
;
resident_end:	;All code below is non-resident
;
;----------------------------------------------------------------------------
;Start of:	non-resident installation routines/data
;----------------------------------------------------------------------------
;
startup:
	include	URAn_APP.S
;
;----------------------------------------------------------------------------
;
init_app:
	include	URAN_ARG.S
	tst	acc_flag
	bne.s	.exit
	xbios	Supexec,try_install
.exit:
	rts
;
;----------------------------------------------------------------------------
;
exec_app:
	tst	acc_flag
	bne.s	acc_exit
	move.l	err_code(pc),d0
	bmi.s	error_d0
	clr.l	d2
resident_exit:
	move.l	#resident_end,d1
	sub.l	basepage_p(pc),d1
	sf	DBug_hold_f
	gemdos	Ptermres,d1,d2
;
acc_exit:
	rts
;
error_d0:
	move.l	d0,d6
	sim_aes	form_alert,#1,error_alert_s(pc)
	move.l	d6,d2
	bra.s	resident_exit
;
;----------------------------------------------------------------------------
;
eval_num:
	move.l	d1,-(sp)
	clr	d1
	clr.l	d0
.loop:
	move.b	(a4)+,d1
	beq.s	.exit
	sub	#'0',d1
	blo.s	.error
	cmp	#9,d1
	bhi.s	.error
	mulu	#10,d0
	add	d1,d0
	bra.s	.loop
;
.error:
	moveq	#-1,d0
.exit:
	movem.l	(sp)+,d1
	rts
;
;----------------------------------------------------------------------------
;
try_install:
;
	move.l	(ev_trap5).w,a0
	move.l	#.do_trap,(ev_trap5).w
	move.l	sp,d0
	trap	#5				;process exception at .do_trap
.do_trap:
	sub.l	sp,d0			;d0 = frame size
	add	d0,sp			;sp = pre_exception SSP
	move	d0,stackframe_len
	move.l	a0,(ev_trap5).w		;restore original trap5_handler
;
	edit_cookie	#'DBug',#DBug_struct
	bpl.s	.done_cookie
	make_cookie	#'DBug',#DBug_struct
	bmi.s	.error_d0
.done_cookie:
;
	lea	(ev_trap5).w,a0
	lea	nu_trap5(pc),a1
	bsr	retop_XB_name
	bmi.s	.error_d0
;
	lea	(ev_bios).w,a0
	lea	nu_bios(pc),a1
	bsr	retop_XB_name
	bmi.s	.error_d0
;
	lea	(ev_xbios).w,a0
	lea	nu_xbios(pc),a1
	bsr	retop_XB_name
	bmi.s	.error_d0
;
	lea	(ev_gemdos).w,a0
	lea	nu_gemdos(pc),a1
	bsr	retop_XB_name
	bmi.s	.error_d0
	lea	(ev_gemdos).w,a0
	lea	fix_gemdos(pc),a1
	bsr	retop_XB_name
	bmi.s	.error_d0
	move.l	#xb_next+fix_gemdos,nextlink_gemdos
;
	lea	(ev_xgemdos).w,a0
	lea	nu_xgemdos(pc),a1
	bsr	retop_XB_name
;
	lea	(ev_vbi).w,a0
	lea	nu_vbi(pc),a1
	bsr	retop_XB_name
;
	lea	(iv_time_c).w,a0
	lea	nu_TimC(pc),a1
	bsr	retop_XB_name
.error_d0:
	move.l	d0,err_code
	rts
;
;----------------------------------------------------------------------------
;
	make	SIM_links
	make	JAR_links
;
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
;
acc_name:	dc.b	'  DebugAid is no ACC !',NUL
crlf_s:		dc.b	CR,LF,NUL
	even
;
error_alert_s:
	dc.b	'[1]['
	dc.b	'DebugAid error:|'
	dc.b	'  Something has gone wrong ! ]'
	dc.b	'[ Exit ]',NUL
	even
;
;----------------------------------------------------------------------------
	SECTION	bss
;----------------------------------------------------------------------------
;
		ds.l	$1000
mystack:	ds.l	4

intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
message:	ds.b	16
;
;----------------------------------------------------------------------------
	End
;----------------------------------------------------------------------------
;End of file:	DEBUGAID.S
;----------------------------------------------------------------------------
