;----------------------------------------------------------------------------
;File name:	PASS_AV.S			Revision date:	1996.03.08
;Creator:	Ulf Ronald Andersson		Creation date:	1996.02.19
;(c)1996 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
;
;;;huge_program	= 1	;TEXT+DATA sections are > 32KB
keep_windows	= 1	;keep ACC vwk in main eventloop
exec_timeout	= 100	;10 timer events per second
exec_message	= 1	;Use exec_mesag at message events
;
;----------------------------------------------------------------------------
;
	output	.APP
;
;----------------------------------------------------------------------------
;
	include	URAn_DOS.S
	include	URAn_SIM.S
	include	URAn_LA.S
	include	URAn_AV.S
	include	URAn_XB.S
;
;----------------------------------------------------------------------------
;
	SECTION	TEXT
	_unilab	rz
;
;----------------------------------------------------------------------------
;
	ifnd	huge_program
	SECTION	DATA
	endc
;
acc_name:	dc.b	'  Disp AV',NUL	;for ACC menu registration
		even
;
;----------------------------------------------------------------------------
;
	SECTION	TEXT
;
;----------------------------------------------------------------------------
;
	include	URAn_APP.S
;
;----------------------------------------------------------------------------
;
	ifnd	huge_program
	SECTION	BSS
	endc
;
message:	ds.w	8		;evnt_mesag message pipe
intin:		ds.w	30		;30 words or more for AES/VDI
intout:		ds.w	45		;45 words or more for AES/VDI
ptsin:		ds.w	30		;30 words or more for VDI
ptsout:		ds.w	12		;12 words or more for VDI output coordinates
		ds.l	200		;subroutine stack >= 100 longs
mystack:	ds.l	1		;top of subroutine stack
;
;----------------------------------------------------------------------------
;
	SECTION	TEXT
;
;----------------------------------------------------------------------------
;	Constants, Variables, and Usage of the URAn_APP.S library
;
;rz		'relative zero' for internal references
;basepage_p	-> program's base page
;tsr_size	.L size of BASEPAGE+TEXT+DATA+BSS  (only TOS/TTP may TSR)
;progtype	.L indicates program type:
;  ...			$0000.$FFFF == TOS/TTP/boot_PRG
;  ...			$0000.ap_id == APP/GTP/non_boot_PRG
;  ...			$FFFF.ap_id == ACC
;acc_flag	is the high word of 'progtype'
;tos_flag	is the low word of 'progtype'
;app_id		alias tos_flag
;bootflag	.W $FFFF == PRG booted from AUTO (also sets 'tos_flag')
;menu_id	.W menu id for an ACC, otherwise null
;g_handle	.W workstation handle for ACC/APP/GTP/non_boot_PRG
;vwk_handle	.W virtual workstation handle
;contrl		12 words for AES/VDI control data
;
;NB: if symbol 'huge_program' is defined, above data is in TEXT section (else in BSS)
;NB: defining 'huge_program' also makes function calls use 'jsr' (instead of bsr)
;
;Required user routines:
;
;init_app	called for ACC/APP/GTP/non_boot_PRG to init application,
;		but doesn't need appl_init, graf_handle, or v_opnvwk,
;		nor does an ACC need menu_register.
;		Suitable use is for initialization of object trees.
;NB:  for ACC	menu_register is called between init_app and exec_app
;
;exec_app	called to execute the main application regardless of type,
;		but doesn't need v_clsvwk, or appl_exit, or ACC appl_mesag.
;		This call will be repeated for a reactivated ACC.
;		Non_acc programs should have exit code in d0 at RTS.
;		(See details at 'Exit codes:' below)
;
;	At entry to either of these two routines:
;
;		d6.W	== bootflag	\
;		d7.L	== progtype	 > See descriptions above.
;		a6.L	== rz		/
;
;Optional user routines:
;
;exec_timer	Called for ACC that has a defined constant 'exec_timeout',
;		whenever evnt_multi produces such a timer event.
;		The constant is placed as long at 'main_timeout', and may
;		there be dynamically adjusted by the program.
;
;exec_mesag	Called for ACC that has a defined constant 'exec_message',
;		whenever evnt_multi/evnt_mesag produces messages that are
;		not AC_OPEN  (such as VA_START).
;
;		If the constant 'keep_windows' is also set, the workstation
;		will not be closed at each return (you must obey AC_CLOSE).
;		This places a word == $FF00 at 'keep_wind_f', and if the top
;		byte is cleared the workstation closure is enabled again.
;
;NB:	Top bit of the word 'revise_type_f' is used for 3 purposes:
;   1:	Let ACC start 'exec_app' directly without awaiting event.
;   2:	Let APP delay 'exec_app' until an event occurs.
;   3:	Let APP loop back for more events after 'exec_app'
;The flag must be set by 'init_app' in the first two cases, and in case 3
;should be set/cleared in 'exec_app' to decide whether to exit program.
;
;Exit codes:	At exit from exec_app, d0 has the following effects
;		when the program was not started as accessory.
;
; negative	=> Pterm(d0)			=> error code exit
; 0		=> Pterm(d0)			=> error free exit
; 0x0000ADD0	=> Ptermres(tsr_size,0)		=> error free resident exit
; 0x0000ADD1	=> Ptermres(d1,0)		=> error free resident exit
; 0x0000ADD0	=> Ptermres(d1,d2)		=> error code resident exit
;
;----------------------------------------------------------------------------
;Start of:	init_app
;----------------------------------------------------------------------------
;
init_app:
	include	URAn_ARG.S
	cmp	#2,arg_cnt
	blo	exit_init_app
	move.l	arg_ptr(pc),a0
.loop_1:
	tst.b	(a0)+
	bne.s	.loop_1
	move.l	a0,arg_path_p
exit_init_app:
	rts
;
;----------------------------------------------------------------------------
;End of:	init_app
;----------------------------------------------------------------------------
;	URAn_ARG.S defines two variables
;
;arg_cnt	== number of strings on command line
;arg_ptr	-> NUL_separated argument strings + final NUL
;
;NB:	Both of the above include a dummy program name (first string==NUL).
;----------------------------------------------------------------------------
;Start of:	exec_app
;----------------------------------------------------------------------------
;
exec_app:
	lea	viewer_t(pc),a4
	move.l	(a4)+,d3
.find_viewer_loop:
	move.l	(a4)+,a3		;a3 -> padded name of preferred application
	VA_set_client	(a3)		;is the application accessible ?
	dbge	d3,.find_viewer_loop	;loop until found or preferences exhausted
	bge.s	.have_viewer_id
.try_servers:
	VA_set_client	?
	blt.s	exit_exec_app		;error handling can be extended here
.have_viewer_id:
	st	revise_type_f		;enable main eventloop
	st	keep_wind_f		;keep vwk across eventloops
	move	#0,state		;init timer state machine
exit_exec_app:
	clr.l	d0
	rts
;
;----------------------------------------------------------------------------
;End of:	exec_app
;----------------------------------------------------------------------------
;Start of:	exec_timer
;----------------------------------------------------------------------------
;
	ifd	exec_timeout	;cond:	ifd exec_timeout
exec_timer:
	move	state,d0
	cmp	#1,d0
	blo.s	state_00
	beq.s	state_01
	cmp	#3,d0
	blo.s	state_02
	beq.s	state_03
	cmp	#5,d0
	blo.s	state_04
	beq.s	state_05
	bra.s	exit_exec_timer
;
state_00:	;sending VA_START
	VA_send	START,(rz-$100+bp_argstring)
	blt.s	VA_error
	move	#1,state
	move	#20,time_cnt		;allow 2 seconds for response
	bra.s	exit_exec_timer
;
state_01:	;awaiting VA_START response
	subq	#1,time_cnt
	bge.s	exit_exec_timer		;keep counting until < 0
	addq	#1,time_cnt		;back counter
	blt.s	exit_exec_timer		;keep freezed until 0
VA_error:
	moveq	#E_ERROR,d0
	clr	revise_type_f		;enable program exit on time_cnt 0
	rts
;
state_02:	;Awaiting window closures
state_03:
state_04:
state_05:
exit_exec_timer:
	rts
	endc			;ends:	ifd exec_timeout
;
;----------------------------------------------------------------------------
;End of:	exec_timer
;----------------------------------------------------------------------------
;Start of:	exec_mesag
;----------------------------------------------------------------------------
;
	ifd	exec_message	;cond:	ifd exec_message
;
exec_mesag:
	move	message,d0
	cmp	#AC_CLOSE,d0
	beq.s	exec_mesag_AC_CLOSE
	cmp	#AV_ACCWINDOPEN,d0
	beq.s	exec_mesag_AV_ACCWINDOPEN
	cmp	#AV_ACCWINDCLOSED,d0
	beq.s	exec_mesag_AV_ACCWINDCLOSED
	cmp	#AV_PROTOKOLL,d0
	beq	exec_mesag_AV_PROTOKOLL
	cmp	#AV_STARTPROG,d0
	beq	exec_mesag_AV_STARTPROG
;
	bra	exit_exec_mesag
;
exec_mesag_AC_CLOSE:
	sf	keep_wind_f
	rts
;
exec_mesag_AV_ACCWINDOPEN:
	addq	#1,wind_cnt		;increment window counter
	move	#2,state
	bra	exit_exec_mesag
;
exec_mesag_AV_ACCWINDCLOSED:
	subq	#1,wind_cnt		;decrement window counter
	bne	exit_exec_mesag		;keep program state if windows remain
	moveq	#E_OK,d0
	clr	revise_type_f		;enable program exit on time_cnt 0
	rts
;
exec_mesag_AV_STARTPROG:
	move.l	5*2+message(pc),a0
	lea	arg_buff+1(pc),a1
	moveq	#$7D-1,d0
.loop:
	move.b	(a0)+,(a1)+
	dbeq	d0,.loop
	beq.s	.arg_terminated
	clr.b	(a1)+
.arg_terminated:
	lea	arg_buff+2(pc),a0
	sub.l	a0,a1
	move	a1,d0
	move.b	d0,arg_buff
	lea	arg_buff(pc),a3
	move	7*2+message(pc),d3
	bra.s	starting_prog
;
	move	#1,intin
	move	#1,intin+2
	move	#100,intin+4
	move.l	a3,addrin+4
	move.l	3*2+message(pc),addrin
	sub_aes	#shel_write
	bra.s	prog_started
;
starting_prog:
	gemdos	Pexec|_ind,#100,3*2+message(pc),a3,!
	tst.l	d0
	beq.s	prog_started
	gemdos	Pexec|_ind,!,3*2+message(pc),a3,!
prog_started:
	VA_send	PROGSTART,intout(pc),!,d3
	moveq	#E_OK,d0
	clr	revise_type_f		;enable program exit on time_cnt 0
	rts
;
exec_mesag_AV_PROTOKOLL:
	move	message+3*2,d0
	move	d0,AV_proto_f
exit_exec_mesag:
	rts
;
	endc			;ends:	ifd exec_message
;
;----------------------------------------------------------------------------
;End of:	exec_mesag
;----------------------------------------------------------------------------
;
	make	AV_links
	make	SIM_links
;
;----------------------------------------------------------------------------
;
text_limit:	section	DATA
;
;----------------------------------------------------------------------------
;Enter program constant definitions below:
;
viewer_t:
	dc.l	(viewer_t_end-viewer_t_ref)/4-1
viewer_t_ref:
	dc.l	pad8_EVER_s
	dc.l	pad8_1STG_s
	dc.l	pad8_1STV_s
	dc.l	pad8_STG_s
viewer_t_end:
;
pad8_EVER_s:
	dc.b	'EVEREST ',NUL
pad8_PCS_AV_s:
	dc.b	'PCS_AV  ',NUL
pad8_watch_it_s:
	dc.b	'WATCH_IT',NUL
pad8_STG_s:
	dc.b	'ST-GUIDE',NUL
pad8_1STG_s:
	dc.b	'1STGUIDE',NUL
pad8_1STV_s:
	dc.b	'1STVIEW ',NUL
;
STG_fname_s:
	dc.b	'C:\ST-GUIDE.ACC',NUL
my_name_s:
	dc.b	'PASS_AV ',NUL
	even
;
;----------------------------------------------------------------------------
;
data_limit:	SECTION	BSS
;
;----------------------------------------------------------------------------
;Enter program variable definitions below:
;
time_cnt:
	ds.w	1
wind_cnt:
	ds.w	1
AV_proto_done_f:
	ds.w	1
AV_proto_f:
	ds.w	1
VA_proto_f:
	ds.l	1
state:
	ds.w	1
arg_buff:
	ds.b	128
arg_path_p:
	ds.l	1
;
;----------------------------------------------------------------------------
bss_limit:	END
;----------------------------------------------------------------------------
;End of file:	PASS_AV.S
;----------------------------------------------------------------------------
