;----------------------------------------------------------------------------
;File name:		TESTARGV.S		Revision date:	2000.06.11
;Creator:		Ulf Ronald Andersson	Creation date:	2000.06.11
;(c)2000 by:		Ulf Ronald Andersson	All rights reserved
;Released as:		FREEWARE		(NB: commercial sales forbidden!)
;----------------------------------------------------------------------------
	output	.GTP
;
	include	RA_APP.I
	include	RA_SIM.I
	include	RA_ARG.I
	include	RA_JAR.I
;
	include	sting\LAYER.I
	include	sting\TRANSPRT.I
;----------------------------------------------------------------------------
	start_app
;----------------------------------------------------------------------------
;Start of:	init_app
;----------------------------------------------------------------------------
init_app:
	start_arg
;
	st		fatal_f			;assume fatal errors can happen
	gemdos		Super,0.w
	move.l		d0,d4
	eval_cookie	#"STiK"
	move.l		d0,d3			;d3 = d0 -> DRV_LIST structure
	gemdos		Super|_ind,d4
	move.l		d3,sting_drivers	;sting_drivers -> DRV_LIST structure
	ble.s		.STiK_not_found
	move.l		d3,a3			;a3 -> DRV_LIST structure
	lea		DRV_LIST_magic(a3),a0
	lea		STiKmagic_s(pc),a1
	moveq		#10-1,d0
.strcmp_loop:					;loop to test STiKmagic of DRV_LIST
	cmpm.b		(a0)+,(a1)+
	dbne		d0,.strcmp_loop
	bne.s		.STiK_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		TRANSPORT_DRIVER_s		;-(sp) = "TRANSPORT_TCPIP"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,tpl				;store pointer in 'tpl'
	ble.s		.driver_not_valid
;
	move.l		DRV_LIST_get_dftab(a3),a0	;a0 -> get_dftab function
	pea		MODULE_DRIVER_s			;-(sp) = "MODULE_LAYER"
	jsr		(a0)				;call get_dftab
	addq		#4,sp
	move.l		d0,stx				;store pointer in 'tpl'
	ble.s		.layer_not_valid
	clr		fatal_f
;
;Add client/server dependent init here
;
	clr.l		initerr_mess_p
	rts
;
.STiK_not_found:
	lea		STiK_not_found_al_s(pc),a0
	bra.s		.init_error
;
.STiK_not_valid:
	lea		STiK_not_valid_al_s(pc),a0
	bra.s		.init_error
;
.driver_not_valid:
	lea		driver_not_valid_al_s(pc),a0
	bra.s		.init_error
;
.layer_not_valid:
	lea		layer_not_valid_al_s(pc),a0
.init_error:
	move.l		a0,initerr_mess_p
	rts
;
;----------------------------------------------------------------------------
;End of:	init_app
;----------------------------------------------------------------------------
;Start of:	exec_app
;----------------------------------------------------------------------------
exec_app:
	move.l	arg_ptr(pc),a3	;a3 = arg_ptr
	move	arg_cnt(pc),d5	;d5 = arg_cnt
	cmp	#2,d5
	bge.s	.show_values
	sim_aes	form_alert,#1,no_arg_alert_s(pc)
	bra	main_exit
;
.show_values:
	subq	#1,d5			;adjust for dummy progname string
	move	d5,d0
	lea	arg_max_s(pc),a1
	bsr	convbyte
	subq	#1,d5			;prep for dbra
	clr	d3			;zero arg number
.arg_loop:				;loop start to process each arg
	tst.b	(a3)+
	bne.s	.arg_loop			;loop back to pass 1 arg string
	addq	#1,d3			;increment arg number
	lea	arg_num_s(pc),a1
	move	d3,d0
	bsr	convbyte
	getvstr	(a3)			;d0 -> STinG variable value (or "0")
	move.l	a3,a4			;a4 -> name
	lea	equsig_s(pc),a5		;a5 -> "="
	move.l	d0,a6			;a6 -> value
	clr	d4			;zero string counter
	lea	arg_s(pc),a1
	moveq	#3-1,d2
	bra.s	.line_start
;
.line_wrap:
	move.b	#'|',(a1)+
.line_start:
	moveq	#28-1,d1
.char_loop:				;loop start for each output char
	move.b	(a4)+,d0
	move.b	d0,(a1)+
	cmp.b	#' ',d0
	dbls	d1,.char_loop		;loop back until string or line ends
	bhi.s	.line_end		;branch if not string end
	subq	#1,a1			;back output ptr to terminator
	move.l	a5,a4
	move.l	a6,a5
	addq	#1,d4			;increment string counter
	cmp	#3,d4			;3 strings done yet ?
	dbhs	d1,.char_loop		;loop back until line or 3 strings end
	bhs.s	.add_tail		;branch at end of 3 strings
.line_end:
	cmp	#3,d4			;3 strings done yet ?
	dbhs	d2,.line_wrap		;loop back until 3 strs or max lines end
.add_tail:
	lea	alert_tail_s(pc),a0
.tail_loop:
	move.b	(a0)+,(a1)+
	bne.s	.tail_loop
	sim_aes	form_alert,#2,arg_alert_s(pc)
	tst	d5
	ble.s	main_exit
	dbra	d5,.arg_loop
main_exit:
	rts
;----------------------------------------------------------------------------
;End of:	exec_app
;----------------------------------------------------------------------------
convbyte:
	and	#$ff,d0
	lsl	#4,d0
	lsr.b	#4,d0
	or	#'00',d0
	cmp.b	#'9',d0
	bls.s	.dig_0_ok
	add	#7,d0
.dig_0_ok:
	cmp	#'9F',d0
	bls.s	.dig_1_ok
	add	#$700,d0
.dig_1_ok:
	ror	#8,d0
	move.b	d0,(a1)
	rol	#8,d0
	move.b	d0,1(a1)
	rts
;----------------------------------------------------------------------------
	make	SIM_links
	make	JAR_links
;----------------------------------------------------------------------------
	DATA
;----------------------------------------------------------------------------
STiKmagic_s:
	dc.b	'STiKmagic',NUL
TRANSPORT_DRIVER_s:
	dc.b	'TRANSPORT_TCPIP',NUL
MODULE_DRIVER_s:
	dc.b	'MODULE_LAYER',NUL
;
STiK_not_found_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is missing !]'
	dc.b	'[ Abort ]',NUL
;
STiK_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'The STiK cookie is corrupted!]'
	dc.b	'[ Abort ]',NUL
;
driver_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'TRANSPORT driver is missing !]'
	dc.b	'[ Abort ]',NUL
;
layer_not_valid_al_s:
	dc.b	'[3]['
	dc.b	'STinG  T_SetClk time client: |'
	dc.b	'-----------------------------|'
	dc.b	'MODULE driver is missing !]'
	dc.b	'[ Abort ]',NUL
	even
;----------------------------------------------------------------------------
acc_name:	dc.b	'  STinG getvstr 1.0',NUL
id_app_name_s:	dc.b	'GETVSTR ',NUL
		even
crlf_s:		dc.b	CR,LF,NUL
equsig_s:	dc.b	'=',NUL
;----------------------------------------------------------------------------
no_arg_alert_s:
	dc.b	'[1]['
	dc.b	'__________ getvstr __________|'
	dc.b	' Hey dude !  Why no args ?   |'
	dc.b	' This is boring...!          |'
alert_tail_s:
	dc.b	']'
	dc.b	'[   Yes   |  Right  |  Yeah   ]',NUL
;----------------------------------------------------------------------------
arg_alert_s:
	dc.b	'[1]['
	dc.b	'__________ getvstr __________|'
	dc.b	'Variable '
arg_num_s:
	dc.b		 '00 of '
arg_max_s:
	dc.b		       '00:           |'
arg_s:
	ds.b	512
	even
;----------------------------------------------------------------------------
	BSS
;----------------------------------------------------------------------------
sting_drivers:	ds.l	1	;DRV_LIST	*sting_drivers;
tpl:		ds.l	1	;TPL		*tpl;
stx:		ds.l	1	;STX		*stx;
initerr_mess_p:	ds.l	1
fatal_f:	ds.w	1
;-------
intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
message:	ds.b	16
		ds.l	$100
mystack:	ds.l	4
;
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	TESTARGV.S
;----------------------------------------------------------------------------
