;----------------------------------------------------------------------------
;File name:	GUCKSHEL.S			Revision date:	1995.08.16
;Creator:	Ulf Ronald Andersson		Creation date:	1995.03.15
;Version:	1.0
;----------------------------------------------------------------------------
;
	output	.PRG
;
	include	URAn_APP.S
;
;----------------------------------------------------------------------------
;
		data
;
acc_name:	dc.b	NUL
		even
;
;----------------------------------------------------------------------------
		bss
;
mystack_data:	ds.l	$100
mystack:	ds.w	1	;User defined stack (goes backwards).
message:	ds.b	16	;Message pipe.
intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
;
;----------------------------------------------------------------------------
;
	text
;
;----------------------------------------------------------------------------
;
init_app:
	tst	d7
	bmi.s	.TOS_init
	lea	menu1,a2
	move	rsc_obs,d2
.obfix_loop:
	gem_aes	rsrc_obfix,d2,(a2)
	dbra	d2,.obfix_loop
	nop
.TOS_init:
	rts
;
;
exec_app:
	tst	d7
	bpl.s	GEM_app
TOS_app:
GEM_app:
	gem_aes	wind_get,!,#5
	move	intout+2(pc),wx
	move	intout+4(pc),wy
	move	intout+6(pc),ww
	move	intout+8(pc),wh
	gem_aes	form_dial,#0,!,!,!,!,wx,wy,ww,wh
	gem_aes	menu_bar,#1,menu1
;
	lea	saved_pal(pc),a3
	lea	intin(pc),a4
	lea	intout(pc),a5
	moveq	#16-1,d3
.save_pal_loop:
	move	d3,(a4)
	clr	2(a4)
	sub_vdi	#vq_color,vwk_handle(pc)
	move.l	2(a5),(a3)+
	move	6(a5),(a3)+
	dbra	d3,.save_pal_loop
;
	lea	progname_s(pc),a0
	bsr	get_path_tail_s
	gemdos	Pexec,!,progpath_s(pc),progtail_s,!
;
	lea	saved_pal(pc),a3
	lea	intin(pc),a4
	lea	intout(pc),a5
	moveq	#16-1,d3
.rest_pal_loop:
	move	d3,(a4)
	move.l	(a3)+,2(a4)
	move	(a3)+,6(a4)
	sub_vdi	#vs_color,vwk_handle(pc)
	dbra	d3,.rest_pal_loop
;
	gem_aes	menu_bar,!,menu1
	gem_aes	form_dial,#3,!,!,!,!,wx,wy,ww,wh
	clr.l	d0
	rts	;This is the program exit, back to caller (or desktop)
;
;
;----------------------------------------------------------------------------
;
get_path_tail_s:
	move.l	a0,-(sp)
	gem_aes	shel_read,progpath_s(pc),progtail_s(pc)
	lea	progpath_s(pc),a0
	move.l	a0,a1
	tst	d0
	beq.s	.fill_name
	move	#240-1,d1
.find_end_lp:
	move.b	(a0)+,d0
	beq.s	.fill_name
	cmp.b	#'\',d0
	dbeq	d1,.find_end_lp
	bne.s	.fill_name
	move.l	a0,a1
	dbra	d1,.find_end_lp
.fill_name:
	move.l	(sp)+,a0
.fill_name_lp:
	move.b	(a0)+,(a1)+
	bne.s	.fill_name_lp
	rts
;
;
;----------------------------------------------------------------------------
;	LACESCAN support routines
;
	include	LACE_LIB.S
;
;----------------------------------------------------------------------------
;	Here starts the DATA area
;
	data
;
progname_s:
	dc.b	'GUCK.TTP',NUL
	even
;
	include	guckmenu.s
;
;----------------------------------------------------------------------------
;
	bss
;
progpath_s:
	ds.b	256
progtail_s:
	ds.b	128
;
wx:	ds.w	1
wy:	ds.w	1
ww	ds.w	1
wh:	ds.w	1
;
saved_pal:
	ds.w	3*16
;
;----------------------------------------------------------------------------
; End of file:	GUCKSHEL.S
;----------------------------------------------------------------------------
