;----------------------------------------------------------------------------
;File name:	Sh_LineA.S			Revision date:	1999.05.13
;Creator:	Ulf Ronald Andersson		Creation date:	1995.07.27
;(c)1995 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
;
	output	.APP
;
	include	RA_JAR.I
	include	RA_APP.I
	include	RA_SIM.I
;
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
;
id_app_name_s:	dc.b	'SH_LINEA',0
		even
acc_name:	dc.b	'  Show LineA base',0
		even
;
;----------------------------------------------------------------------------
	SECTION	bss
;----------------------------------------------------------------------------
;
mystack_data:	ds.l	$100
mystack:	ds.w	1	;User defined stack (goes backwards).
message:	ds.b	16	;Message pipe.
intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
;
;----------------------------------------------------------------------------
	SECTION	text
;----------------------------------------------------------------------------
	start_app
;
init_app:
	rts
;
;----------------------------------------------------------------------------
;
exec_app:
	dc.w	$a000
	move.l	#tstvalue_num_s,conv_p
	bsr.s	convlong
	move.b	#' ',tstvalue_al_tail_s
	sim_aes	form_alert,#1,tstvalue_al_s
	clr.l	d0
	rts
;
;----------------------------------------------------------------------------
;
convhdig:
	ror.l	#4,d0
	bra.s	_convhdig
;
convbyte:
	ror.l	#8,d0
	bra.s	_convbyte
;
convword:
	swap	d0
	bra.s	_convword
;
convlong:
	bsr	_convword
_convword:
	bsr	_convbyte
_convbyte:
	bsr	_convhdig
_convhdig:
	rol.l	#4,d0
	movem.l	d0-d2/a0-a2,-(sp)
	and	#$0F,d0
	or	#'0',d0
	cmp	#'9',d0
	bls.s	.got_hex
	add	#('A'-('9'+1)),d0
.got_hex:
	move.l	conv_p,a0
	move.b	d0,(a0)+
	clr.b	(a0)
	move.l	a0,conv_p
	movem.l	(sp)+,d0-d2/a0-a2
	rts
;
;----------------------------------------------------------------------------
;
	make	SIM_links
;
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
;
conv_p:
	dc.l	0
;
tstvalue_al_s:
	dc.b	'[1]['
	dc.b	'                             |'
	dc.b	'LINE_A base = $'
tstvalue_num_s:
	dc.b	'12345678'
tstvalue_al_tail_s:
	dc.b	' ][ Ok ]',NUL
	even
;
;
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	Sh_LineA.S
;----------------------------------------------------------------------------
