;----------------------------------------------------------------------------
;File name:	Sh_LineA.S			Revision date:	1999.05.13
;Creator:	Ulf Ronald Andersson		Creation date:	1995.07.27
;(c)1995 by:	Ulf Ronald Andersson		All rights reserved
;----------------------------------------------------------------------------
;
	output	.APP
;
	include	RA_APP.I
	include	RA_SIM.I
;
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
;
id_app_name_s:	dc.b	'SH_VIDEL',0
		even
acc_name:	dc.b	'  Show VIDEL info',0
		even
;
;----------------------------------------------------------------------------
	SECTION	bss
;----------------------------------------------------------------------------
;
mystack_data:	ds.l	$100
mystack:	ds.w	1	;User defined stack (goes backwards).
message:	ds.b	16	;Message pipe.
intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
;
;----------------------------------------------------------------------------
	SECTION	text
;----------------------------------------------------------------------------
	start_app
;
init_app:
	rts
;
;----------------------------------------------------------------------------
;
exec_app:
	gemdos	Super,!
	move.l	d0,-(sp)
	move.l	($FFFF8282).w,d0
	move.l	#val_8282_num_s,conv_p
	bsr	convlong
	move.l	($FFFF82A2).w,d0
	move.l	#val_82A2_num_s,conv_p
	bsr.s	convlong
	move.l	($FFFF82C0).w,d0
	move.l	#val_82C0_num_s,conv_p
	bsr.s	convlong
	xbios	VsetMode,?
	move.l	#val_VsetMode_num_s,conv_p
	bsr.s	convword
	move.w	($FFFF820A).w,d0
	move.l	#val_820A_num_s,conv_p
	bsr.s	convword
	gemdos	Super,()
	sim_aes	form_alert,#1,tstvalue_al_s
	clr.l	d0
	rts
;
;----------------------------------------------------------------------------
convhdig:
	swap	d0
	bra.s	_convhdig
;-------------------------------------
convbyte:
	swap	d0
	bra.s	_convbyte
;-------------------------------------
convword:
	swap	d0
	bra.s	_convword
;-------------------------------------
convlong:
	bsr	_convword
_convword:
	bsr	_convbyte
_convbyte:
	bsr	_convhdig
_convhdig:
	rol.l	#4,d0
	movem.l	d0-d2/a0-a2,-(sp)
	and	#$0F,d0
	or	#'0',d0
	cmp	#'9',d0
	bls.s	.got_hex
	add	#('A'-('9'+1)),d0
.got_hex:
	move.l	conv_p,a0
	move.b	d0,(a0)+
	move.l	a0,conv_p
	movem.l	(sp)+,d0-d2/a0-a2
	rts
;-------------------------------------
conv_term:
	move.l	a0,-(sp)
	move.l	conv_p,a0
	clr.b	(a0)+
	move.l	a0,conv_p
	move.l	(sp)+,a0
	rts
;----------------------------------------------------------------------------
;
	make	SIM_links
;
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
;
conv_p:
	dc.l	0
;
tstvalue_al_s:
	dc.b	'[1]['
;;;	dc.b	'                             |'
	dc.b	'82='
val_8282_num_s:
	dc.b	   '12345678  A2='
val_82A2_num_s:
	dc.b	                '12345678 |'
	dc.b	'C0='
val_82C0_num_s:
	dc.b	   '12345678|'
	dc.b	'Mode=$'
val_VsetMode_num_s:
	dc.b	      '1234  0A='
val_820A_num_s:
	dc.b	               '1234 '
tstvalue_al_tail_s:
	dc.b	'][ Ok ]',NUL
	even
;
;
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	Sh_LineA.S
;----------------------------------------------------------------------------
