;----------------------------------------------------------------------------
;File name:	TST_BOOT.S		Revision date:	1995.06.15
;Creator:	Ulf Ronald Andersson	Creation date:	1993.07.29
;(c)1993 by:	Ulf Ronald Andersson	All rights reserved
;----------------------------------------------------------------------------
;
	output	.APP
;
	include	URAn_APP.S
	include	URAn_SIM.S
;
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
;
acc_name:	dc.b	'  Test KB',0
		even
;
;----------------------------------------------------------------------------
	SECTION	bss
;----------------------------------------------------------------------------
;
mystack_data:	ds.l	$100
mystack:	ds.w	1	;User defined stack (goes backwards).
message:	ds.b	16	;Message pipe.
intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
;
;----------------------------------------------------------------------------
	SECTION	text
;----------------------------------------------------------------------------
;
init_app:
	rts
;
;----------------------------------------------------------------------------
;
exec_app:
	move.l	d6,d0
	move.l	#bootflag_n_s,conv_p
	bsr.s	convlong
	move.l	d7,d0
	move.l	#progtype_n_s,conv_p
	bsr.s	convlong
	sim_aes	form_alert,#1,tstvalue_al_s
	clr.l	d0
	rts
;
;----------------------------------------------------------------------------
;
convhdig:
	ror.l	#4,d0
	bra.s	_convhdig
;
convbyte:
	ror.l	#8,d0
	bra.s	_convbyte
;
convword:
	swap	d0
	bra.s	_convword
;
convlong:
	bsr	_convword
_convword:
	bsr	_convbyte
_convbyte:
	bsr	_convhdig
_convhdig:
	rol.l	#4,d0
	movem.l	d0-d2/a0-a2,-(sp)
	and	#$0F,d0
	or	#'0',d0
	cmp	#'9',d0
	bls.s	.got_hex
	add	#('A'-('9'+1)),d0
.got_hex:
	move.l	conv_p,a0
	move.b	d0,(a0)+
	move.l	a0,conv_p
	movem.l	(sp)+,d0-d2/a0-a2
	rts
;
;----------------------------------------------------------------------------
;
	make	SIM_links
;
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
;
conv_p:		dc.l	0
;
tstvalue_al_s:
	dc.b	'[1]['
	dc.b	'                             |'
	dc.b	'bootflag = $'
bootflag_n_s:
	dc.b	'12345678|'
	dc.b	'progtype = $'
progtype_n_s:
	dc.b	'12345678'
tstvalue_al_tail_s:
	dc.b	' ][ Again | Exit ]',NUL
	even
;
;
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	TST_BOOT.S
;----------------------------------------------------------------------------
