;----------------------------------------------------------------------------
;File name:	TST_GKEY.S		Revision date:	1995.06.15
;Creator:	Ulf Ronald Andersson	Creation date:	1993.07.29
;(c)1993 by:	Ulf Ronald Andersson	All rights reserved
;----------------------------------------------------------------------------
;
	output	.APP
;
	include	URAn_APP.S
	include	URAn_KEY.S
	include	URAn_SIM.S
;
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
;
acc_name:	dc.b	'  Test KB',0
		even
;
;----------------------------------------------------------------------------
	SECTION	bss
;----------------------------------------------------------------------------
;
mystack_data:	ds.l	$100
mystack:	ds.w	1	;User defined stack (goes backwards).
message:	ds.b	16	;Message pipe.
intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
;
;----------------------------------------------------------------------------
	SECTION	text
;----------------------------------------------------------------------------
;
init_app:
	rts
;
;----------------------------------------------------------------------------
;
exec_app:
	clr.l	d0
	bra.s	.first
;
.loop:
;
	gemdos	Crawcin
	gen_key
;
.first:
	move.l	#key_value_num_s,conv_p
	bsr.s	convlong
	move.l	kbshift_p(pc),a0
	move.b	(a0),d0
	move.l	#kbshift_num_s,conv_p
	bsr.s	convbyte
	sim_aes	form_alert,#1,tstvalue_al_s
	cmp	#1,d0
	beq.s	.loop
	clr.l	d0
	rts
;
;----------------------------------------------------------------------------
;
convhdig:
	ror.l	#4,d0
	bra.s	_convhdig
;
convbyte:
	ror.l	#8,d0
	bra.s	_convbyte
;
convword:
	swap	d0
	bra.s	_convword
;
convlong:
	bsr	_convword
_convword:
	bsr	_convbyte
_convbyte:
	bsr	_convhdig
_convhdig:
	rol.l	#4,d0
	movem.l	d0-d2/a0-a2,-(sp)
	and	#$0F,d0
	or	#'0',d0
	cmp	#'9',d0
	bls.s	.got_hex
	add	#('A'-('9'+1)),d0
.got_hex:
	move.l	conv_p,a0
	move.b	d0,(a0)+
	move.l	a0,conv_p
	movem.l	(sp)+,d0-d2/a0-a2
	rts
;
;----------------------------------------------------------------------------
;
	make	KEY_links
	make	SIM_links
;
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
;
conv_p:		dc.l	0
;
tstvalue_al_s:
	dc.b	'[1]['
	dc.b	'                             |'
	dc.b	'Key value = $'
key_value_num_s:
	dc.b	'12345678|'
	dc.b	'Kbshift   = $'
kbshift_num_s:
	dc.b	'12'
tstvalue_al_tail_s:
	dc.b	' ][ Again | Exit ]',NUL
	even
;
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	TST_GKEY.S
;----------------------------------------------------------------------------
