;----------------------------------------------------------------------------
;File name:	SH_APSRC.S		Revision date:	2000.12.01
;Creator:	Ulf Ronald Andersson	Creation date:	2000.12.01
;(c)2000 by:	Ulf Ronald Andersson	All rights reserved
;Released as:	FREEWARE		(NB: commercial sales forbidden!)
;----------------------------------------------------------------------------
	output	.APP
;-------
	include	RA_APP.I
	include	RA_SIM.I
;-------
skip_vq_aes	set	1
skip_nametest	set	1
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
id_app_name_s:	dc.b	'SH_APSRC',0
		even
acc_name:	dc.b	'  appl_search results',0
		even
;----------------------------------------------------------------------------
	SECTION	bss
;----------------------------------------------------------------------------
mystack_data:	ds.l	$100
mystack:	ds.w	1	;User defined stack (goes backwards).
message:	ds.b	16	;Message pipe.
intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
;----------------------------------------------------------------------------
	SECTION	text
;----------------------------------------------------------------------------
startup:
	start_app
;----------------------------------------------------------------------------
init_app:
	rts
;----------------------------------------------------------------------------
exec_app:
	clr	d3
	gem_aes	appl_search,#0,app_name_s(pc)
	cmp	#1,d0
	bne	.exit
.show_results:
	lea	al_index_s(pc),a0
	move	d3,d0
	bsr	convbyte
	addq	#1,d3
	lea	app_name_s(pc),a0
	lea	al_app_name_s(pc),a1
	moveq	#8-1,d1
.copy_str_lp:
	move.b	(a0)+,d0
	beq.s	.have_name
	move.b	d0,(a1)+
	dbra	d1,.copy_str_lp
.have_name:
	move.b	#'"',(a1)+
	tst	d1
	bmi.s	.done_name
.pad_lp:
	move.b	#' ',(a1)+
	dbra	d1,.pad_lp
.done_name:
	lea	al_apid_s(pc),a0
	move	intout+4(pc),d0
	bsr	convword
	lea	al_type_s(pc),a0
	move	intout+2(pc),d0
	bsr	convword
	sim_aes	form_alert,#1,apsrc_alert_s(pc)
	cmp	#2,d0
	beq.s	.exit
	gem_aes	appl_search,#1,app_name_s(pc)
	cmp	#1,d0
	beq	.show_results
.exit:
	clr.l	d0
	rts
;----------------------------------------------------------------------------
convhdig:
	ror.l	#4,d0
	bra.s	_convhdig
;
convbyte:
	ror.l	#8,d0
	bra.s	_convbyte
;
convword:
	swap	d0
	bra.s	_convword
;
convlong:
	bsr	_convword
_convword:
	bsr	_convbyte
_convbyte:
	bsr	_convhdig
_convhdig:
	rol.l	#4,d0
	move.l	d0,-(sp)
	and	#$0F,d0
	or	#'0',d0
	cmp	#'9',d0
	bls.s	.got_hex
	add	#('A'-('9'+1)),d0
.got_hex:
	move.b	d0,(a0)+
	move.l	(sp)+,d0
	rts
;----------------------------------------------------------------------------
	make	SIM_links
;----------------------------------------------------------------------------
	data
;----------------------------------------------------------------------------
apsrc_alert_s:
	dc.b	'[1]['
	dc.b	'__________ SH_APSRC _________|'
	dc.b	'Appl. Name 0x'
al_index_s:
	dc.b		     '00 = "'
al_app_name_s:
	dc.b			   '          |'
	dc.b	'apid = 0x'
al_apid_s:
	dc.b		 '0000  type = 0x'
al_type_s:
	dc.b				'0000 ]'
	dc.b	'[ Ok | Exit ]',NUL
	even
;----------------------------------------------------------------------------
	bss
;----------------------------------------------------------------------------
app_name_s:
	ds.b	32
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	SH_APSRC.S
;----------------------------------------------------------------------------
