;----------------------------------------------------------------------------
;File name:	SH_SHRD.S		Revision date:	2000.12.01
;Creator:	Ulf Ronald Andersson	Creation date:	2000.12.01
;(c)2000 by:	Ulf Ronald Andersson	All rights reserved
;Released as:	FREEWARE		(NB: commercial sales forbidden!)
;----------------------------------------------------------------------------
	output	.APP
;-------
	include	RA_APP.I
	include	RA_SIM.I
;-------
skip_vq_aes	set	1
skip_nametest	set	1
;----------------------------------------------------------------------------
	SECTION	data
;----------------------------------------------------------------------------
id_app_name_s:	dc.b	'SH_SHRD ',0
		even
acc_name:	dc.b	'  shel_read results',0
		even
;----------------------------------------------------------------------------
	SECTION	bss
;----------------------------------------------------------------------------
mystack_data:	ds.l	$100
mystack:	ds.w	1	;User defined stack (goes backwards).
message:	ds.b	16	;Message pipe.
intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
;----------------------------------------------------------------------------
	SECTION	text
;----------------------------------------------------------------------------
startup:
	start_app
;----------------------------------------------------------------------------
init_app:
	rts
;----------------------------------------------------------------------------
exec_app:
	gem_aes	shel_read,cmd_path_s(pc),cmd_tail_s(pc)
	lea	cmd_path_s(pc),a0
	lea	al_path_s(pc),a1
	moveq	#3,d0
	bsr	pad_al_lines
	sim_aes	form_alert,#1,path_alert_s(pc)
	lea	cmd_tail_s(pc),a0
	move.b	(a0)+,d0
	lea	argsz_num_s(pc),a0
	bsr	convbyte
	lea	cmd_tail_s(pc),a0
	tst.b	(a0)+
	bne.s	.keep_str
	clr.b	(a0)
.keep_str:
	lea	al_tail_s(pc),a1
	moveq	#3,d0
	bsr	pad_al_lines
	sim_aes	form_alert,#1,tail_alert_s(pc)
	rts
;----------------------------------------------------------------------------
;in:	a0->string  a1->buff  d0=lines  
;out:	a0 -> beyond string  a1 -> beyond pad
;
pad_al_lines:
	move.l	d3,-(sp)
	clr	d3			;d3 = progress flag
	move	d0,d2
	subq	#1,d2			;d2 = dbra line counter
.string_lp_1:
	moveq	#29-1,d1		;d1 = char counter for 29 visible
.string_lp_2:
	moveq	#'"',d0			;pad a "quote" at start
	tst	d3
	bmi.s	.fill_it		;go pad spaces after end
	beq.s	.beg_pad		;go pad starting quote
	move.b	(a0)+,d0		;d0 = char from environment string
	beq.s	.end_pad		;go pad ending quote
	cmp.b	#' ',d0
	bhi.s	.pad_it			;go pad non-NUL character
	moveq	#'.',d0			;pad ctrl-char to '.'
	bra.s	.pad_it
;-------
.fill_it:
	moveq	#' ',d0			;pad spaces after end
	bra.s	.pad_it
;
.end_pad:
	moveq	#-2,d3
.beg_pad:
	addq	#1,d3
	moveq	#'"',d0			;pad a "quote" at end
.pad_it:
	move.b	d0,(a1)+		;store alert character at (a1)+
	dbra	d1,.string_lp_2
	addq	#1,a1			;step a1 past space & newline
	dbra	d2,.string_lp_1
;
	tst	d3			;did we pass string end ?
	bmi.s	.keep_next		;if so, go store the pointer
.pass_it:
	tst.b	(a0)+
	bne.s	.pass_it
.keep_next:
	move.l	(sp)+,d3
	rts
;----------------------------------------------------------------------------
convhdig:
	ror.l	#4,d0
	bra.s	_convhdig
;
convbyte:
	ror.l	#8,d0
	bra.s	_convbyte
;
convword:
	swap	d0
	bra.s	_convword
;
convlong:
	bsr	_convword
_convword:
	bsr	_convbyte
_convbyte:
	bsr	_convhdig
_convhdig:
	rol.l	#4,d0
	move.l	d0,-(sp)
	and	#$0F,d0
	or	#'0',d0
	cmp	#'9',d0
	bls.s	.got_hex
	add	#('A'-('9'+1)),d0
.got_hex:
	move.b	d0,(a0)+
	move.l	(sp)+,d0
	rts
;----------------------------------------------------------------------------
	make	SIM_links
;----------------------------------------------------------------------------
	data
;----------------------------------------------------------------------------
path_alert_s:
	dc.b	'[1]['
	dc.b	'__________ SH_SHRD __________|'
	dc.b	'Program pathname:            |'
al_path_s:
	dc.b	'                             |'
	dc.b	'                             |'
	dc.b	'                             ]'
	dc.b	'[ Ok ]',NUL
	even
tail_alert_s:
	dc.b	'[1]['
	dc.b	'__________ SH_SHRD __________|'
	dc.b	'Arg size=$'
argsz_num_s:
	dc.b		  '00  Arg string:    |'
al_tail_s:
	dc.b	'                             |'
	dc.b	'                             |'
	dc.b	'                             ]'
	dc.b	'[ Ok ]',NUL
	even
;----------------------------------------------------------------------------
	bss
;----------------------------------------------------------------------------
cmd_path_s:
	ds.b	512
cmd_tail_s:
	ds.b	512
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	SH_SHRD.S
;----------------------------------------------------------------------------
