;----------------------------------------------------------------------------
;File name:	CONV_PAL.S		Revision date:	2001.09.02
;Created by:	Ulf Ronald Andersson	Creation date:	2001.09.02
;----------------------------------------------------------------------------
;
;
	output	.TTP
;
;
	include	RA_TOS.I
;
;
	text
;
	opt	a+
	opt	o+
	opt	p+
;
;
_max_args	= 16
;	
;
;----------------------------------------------------------------------------
;
_startup:
	move.l	4(sp),a5
	move.l	bp_bss_beg_p(a5),a0
	add.l	bp_bss_len(a5),a0
	move.l	a0,sp
	sub.l	a5,a0
	gemdos	Mshrink,!,(a5),a0
	lea	static(pc),a4
	clr	_argc-static(a4)
	lea	_argv-static(a4),a2
	lea	_argcopy-static(a4),a1
	move.l	a1,(a2)+
	clr.b	(a1)+
	lea	bp_argstring(a5),a3
	move.b	bp_arglen(a5),d7
	and	#$7F,d7
	clr	d6
	subq	#1,d7
	bmi.s	.gotargs
.getarg_lp_1:
	cmpi.b	#' ',(a3)+
	dbgt	d7,.getarg_lp_1
	ble.s	.gotargs
	subq	#1,a3
	addq	#1,d6			;_argc += 1
	move.l	a1,(a2)+		;_argv[d6] = a1
.getarg_lp_2:
	move.b	(a3)+,(a1)+
	cmpi.b	#' ',(a3)
	dble	d7,.getarg_lp_2
	bgt.s	.gotargs
	clr.b	(a1)+
	cmpi	#_max_args,d6
	blt.s	.getarg_lp_1
.gotargs:
	move.l	a4,a5
	pea	_argv-static(a5)
	move	d6,_argc-static(a5)
	move	d6,-(sp)
	bsr.s	main
	gemdos	Pterm,d0
;
;
	data
;
_argc:		ds.w	1
_argv:		ds.l	_max_args+1
_argcopy:	dcb.b	128,0
;
;
static:
;
source:		dcb.b	140,NUL
dest:		dcb.b	140,NUL
head_buf:	dcb.b	3*16,NUL
buffer:		dc.l	0
buf_size:	dc.l	0
crlf:		dc.b	CR,LF,NUL
		even
;
;
	bss
;
;
	ds.l	$100	;allow 256 longwords on minimum stack
;
;
	text
;
;
printi	macro	string
	bra.s	.skip\@
.string\@:	dc.b	\1,NUL
	even
.skip\@:
	movem.l	d0-d2/a0-a2,-(sp)
	gemdos	Cconws,.string\@(pc)
	movem.l	(sp)+,d0-d2/a0-a2
	endm	;printi
;
;
prints	macro	string
	movem.l	d0-d2/a0-a2,-(sp)
	gemdos	Cconws,\1
	movem.l	(sp)+,d0-d2/a0-a2
	endm	;prints
;
;
main:						;main(argc,argv)
	RSRESET
;NB: if locals were used they would be declared here, above .aut1
.aut1	rs.l	2
.argc	rs.w	1				;int argc;
.argv	rs.l	1				;char *argv[];
	link	a6,#-.aut1			;{
	printi	<CR,LF,'Conv_Pal: Palette file conversion starting.',CR,LF,ESC,'w'>
;
	cmpi	#1,.argc-.aut1(a6)		; if (argc>=1)
	blt	.bad_args
	move.l	.argv-.aut1(a6),a0
	move.l	4(a0),-(sp)
	pea	source-static(a5)
	bsr	strcpy				;   strcpy(source,argv[1]);
	addq	#8,sp
	move.l	.argv-.aut1(a6),a0
	move.l	4(a0),-(sp)
	pea	dest-static(a5)
	bsr	strcpy				;   strcpy(source,argv[1]);
	addq	#8,sp
;
	cmpi	#2,.argc-.aut1(a6)		; if (argc=<2)
	bgt	.bad_args
	blt.s	.got_args
	move.l	.argv-.aut1(a6),a0
	move.l	8(a0),-(sp)
	pea	dest-static(a5)
	bsr	strcpy				;   strcpy(dest,argv[2]);
	addq	#8,sp
.got_args:
;
	move.l	#1536,d0			; buf_size=1536
	move.l	d0,buf_size-static(a5)
	gemdos	Malloc,d0			; buffer=Malloc(buf_size);
	move.l	d0,buffer-static(a5)
;
	bsr	pad_file
;
	move.l	d0,d3
	bmi.s	.error_exit
	printi	<' File converted.',CR,LF>
	clr.l	d0
	bra.s	.exit
;
.error_exit:
	printi	<CR,LF,'Press a key to continue.',CR,LF>
	gemdos	Crawcin				;   Cconin();
.exit:					; }
	printi	<'Conv_Pal: Palette converter now exiting.',CR,LF>
	gemdos	Mfree|_IND,buffer-static(a5)	; Mfree(buffer);
	unlk	a6				;}
	rts
;
.bad_args:
	gemdos	Cconws,bad_args_s
	clr.l	d0
	bra	.error_exit
;
bad_args_s:
	dc.b	'Argument 1 is required = Source file name \/ Paths',CR,LF
	dc.b	'Argument 2 is optional = Destination name /\ included',CR,LF
	dc.b	'With a single argument, padded file overwrites original',CR,LF
	dc.b	NUL
	even
;
;
pad_file:	;pad_file()
	RSRESET
.source_len	rs.l	1
.dest_len	rs.l	1
.fd_source	rs.w	1
.fd_dest	rs.w	1
.aut2		rs.l	2
;NB: if arguments were used they would be declared here, below .aut2
	link	a6,#-.aut2
	gemdos	Fopen,source-static(a5),!
	move	d0,.fd_source-.aut2(a6)
	bpl.s	.open_in_ok
.open_s_error:
	printi	<"OPEN error on source = ">
	prints	source-static(a5)
	bra	.error_exit_1
;
.open_in_ok:
	gemdos	Fseek,!,.fd_source-.aut2(a6),#2
	move.l	d0,.source_len-.aut2(a6)
	bmi.s	.seek_error
	gemdos	Fseek,!,.fd_source-.aut2(a6),#0
	tst.l	d0
	bpl.s	.seek_ok
.seek_error:
	printi	<'SEEK error occurred in source file'>
	bra	.error_exit_2
;
.seek_ok:
	cmp.l	#1536,.source_len-.aut2(a6)
	beq.s	.size_ok
	cmp.l	#96,.source_len-.aut2(a6)
	beq.s	.size_ok
	printi	<'Incorrect file size'>
	bra.s	.error_exit_2
;
.size_ok:
	gemdos	Fread|_ind,.fd_source-.aut2(a6),.source_len-.aut2(a6),buffer-static(a5)
	move.l	.source_len-.aut2(a6),d1
	cmp.l	d1,d0
	beq.s	.read_ok
.read_error:
	printi	<'READ error occurred in source file'>
.error_exit_2:
	gemdos	Fclose,.fd_source-.aut2(a6)
	moveq	#-1,d0
	bra	.error_exit_1
;
.read_ok:
	gemdos	Fclose,.fd_source-.aut2(a6)
;
;	Palette buffer contains R,G,B words in range 0-1000, in VDI colour order
;
;!!! patch destination disk room test here later !!!
;
	gemdos	Fcreate,dest-static(a5),!
	move	d0,.fd_dest-.aut2(a6)
	bpl.s	.create_ok
	printi	<'CREATE error on dest = '>
	prints	dest-static(a5)
	bra	.error_exit_1
;
.create_ok:
	move.l	.source_len-.aut2(a6),d3
	lsr	#1,d3
	move	d3,d1
	move.l	buffer-static(a5),a3
	move.l	a3,a0
	move.l	a3,a1
.patch_loop_1:
	move	(a0)+,d0
	mulu	#255,d0
	add.l	#500,d0
	divu	#1000,d0
	move.b	d0,(a1)+
	subq	#1,d1
	bne.s	.patch_loop_1
;
;	Here palette buffer block uses R,G,B bytes, still in VDI order
;
	lea	head_buf-static(a5),a2	;a2 -> head_buf
	move.l	a2,a1			;a1 -> head_buf
	move.l	a3,a0			;a0 -> buffer block
	moveq	#16*3-1,d0
.patch_loop_2:
	move.b	(a0)+,(a1)+
	dbra	d0,.patch_loop_2
;
;	Here 1st 16 colours have been copied to head_buf
;
	lea	.order_t(pc),a0
	move	#16-1,d2
.patch_loop_3:
	clr	d0
	move.b	(a0,d2),d0		;d0 = VDI_ix for XBIOS_ix d1
	mulu	#3,d0			;d0 = VDI_ix byte offset
	move	d2,d1
	mulu	#3,d1			;d1 = XBIOS_ix byte offset			
	move.b	0(a2,d0),0(a3,d1)	;patch XBIOS colour R in buffer block
	move.b	1(a2,d0),1(a3,d1)	;patch XBIOS colour G in buffer block
	move.b	2(a2,d0),2(a3,d1)	;patch XBIOS colour B in buffer block
	dbra	d2,.patch_loop_3
;
;	buffer block is ready for writing
;
.write_buffer:	
	move	.fd_dest-.aut2(a6),d4
	gemdos	Fwrite,d4,d3,(a3)
	tst.l	d0
	bmi.s	.write_error
	gemdos	Fclose,d4
.exit_ok:
	clr.l	d0
	unlk	a6
	rts
;
.order_t:
	dc.b	$0,$2,$3,$6
	dc.b	$4,$7,$5,$8
	dc.b	$9,$A,$B,$E
	dc.b	$C,$F,$D,$1
;
.write_error:
	printi	<'WRITE error occurred in destination file'>
.error_exit_1:
	unlk	a6
	rts
;
;
strlen:
	movea.l	4(sp),a0
	move	#256-1,d0		;limit test
.loop:
	tst.b	(a0)+
	dbeq	d0,.loop
	subq.l	#1,a0
	sub.l	4(sp),a0
	move.l	a0,d0
	rts
;
;
strcpy:
	movea.l	4(sp),a1
	movea.l	8(sp),a0
	move	#255-1,d0		;limit move
.loop:
	move.b	(a0)+,(a1)+
	dbeq	d0,.loop
	beq.s	.exit
	clr.b	(a1)
.exit:
	rts
;
;
strcat:
	movea.l	4(sp),a1
	movea.l	8(sp),a0
	move	#255-1,d0		;limit test & move
.loop_1:
	tst.b	(a1)+
	dbeq	d0,.loop_1
	bne.s	.exit
	subq	#1,a1
.loop:
	move.b	(a0)+,(a1)+
	dbeq	d0,.loop
	beq.s	.exit
	clr.b	(a1)
.exit:
	rts
;
;
showint8:
	link	a6,#-10
	clr.l	d2
	move.w	8(a6),d2
	lea	(a6),a0
	clr.b	-(a0)
.loop_1:
	divu	#10,d2
	swap	d2
	addi.b	#'0',d2
	move.b	d2,-(a0)
	clr	d2
	swap	d2
	bne.s	.loop_1
	lea	-9(a6),a1
.loop_2:
	move.b	#' ',-(a0)
	cmpa.l	a1,a0
	bgt.s	.loop_2
	gemdos	Cconws,(a0)
	unlk	a6
	rts
;
;
get_int:
	move.l	d1,-(sp)
.loop:
	move.b	(a0)+,d1
	sub.b	#'0',d1
	blt.s	.exit
	cmp	#9,d1
	bgt.s	.exit
	mulu	#10,d0
	add	d1,d0
	bra.s	.loop
;
.exit:
	move.l	(sp)+,d1
	tst.l	d0
	rts
;
;
put_digs:
	movem.l	d1-d2/a1,-(sp)
	lea	.num_buf_end-static(a5),a1
	clr.b	-(a1)
.loop_1:
	divu	#10,d0
	swap	d0
	add	#'0',d0
	move.b	d0,-(a1)
	clr	d0
	swap	d0
	tst	d0
	bne.s	.loop_1
.loop_2:
	move.b	(a1)+,(a0)+
	bne.s	.loop_2
	subq	#1,a0
	movem.l	(sp)+,d1-d2/a1
	rts
;
.num_buf:
	ds.b	16
.num_buf_end:
;
;
	end
;----------------------------------------------------------------------------
;End of file:	PRAW_X2.S
;----------------------------------------------------------------------------
