                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                nFileHandle(0)) == NULL)
	    QuitGifError(GifFileIn, GifFileOut);
    }

    /* Open stdout for the output file: */
    if ((GifFileOut = EGifOpenFileHandle(1)) == NULL)
	QuitGifError(GifFileIn, GifFileOut);

    if (RightFlag || LeftFlag) {
	/* Dump out same screen information, but flip Screen Width/Height: */
	if (EGifPutScreenDesc(GifFileOut,
	    GifFileIn -> SHeight, GifFileIn -> SWidth,
	    GifFileIn -> SColorResolution, GifFileIn -> SBackGroundColor,
	    GifFileIn -> SBitsPerPixel, GifFileIn -> SColorMap) == GIF_ERROR)
	    QuitGifError(GifFileIn, GifFileOut);
    }
    else {
	/* Dump out exactly same screen information: */
	if (EGifPutScreenDesc(GifFileOut,
	    GifFileIn -> SWidth, GifFileIn -> SHeight,
	    GifFileIn -> SColorResolution, GifFileIn -> SBackGroundColor,
	    GifFileIn -> SBitsPerPixel, GifFileIn -> SColorMap) == GIF_ERROR)
	    QuitGifError(GifFileIn, GifFileOut);
    }

    /* Scan the content of the GIF file and load the image(s) in: */
    do {
	if (DGifGetRecordType(GifFileIn, &RecordType) == GIF_ERROR)
	    QuitGifError(GifFileIn, GifFileOut);

	switch (RecordType) {
	    case IMAGE_DESC_RECORD_TYPE:
		if (DGifGetImageDesc(GifFileIn) == GIF_ERROR)
		    QuitGifError(GifFileIn, GifFileOut);
		if (GifFileIn -> IInterlace)
		    GIF_EXIT("Cannt flip interlaced images - use GifInter first.");

		/* Put the image descriptor to out file: */
		if (RightFlag) {
		    /* Rotate to the right: */
		    if (EGifPutImageDesc(GifFileOut,
			GifFileIn -> SHeight - GifFileIn -> IHeight -
						GifFileIn -> ITop,
			GifFileIn -> ILeft,
			GifFileIn -> IHeight, GifFileIn -> IWidth,
			FALSE, GifFileIn -> IBitsPerPixel,
			GifFileIn -> IColorMap) == GIF_ERROR)
			    QuitGifError(GifFileIn, GifFileOut);
		}
		else if (LeftFlag) {
		    /* Rotate to the left: */
		    if (EGifPutImageDesc(GifFileOut,
			GifFileIn -> ITop,
			GifFileIn -> SWidth - GifFileIn -> IWidth -
						GifFileIn -> ILeft,
			GifFileIn -> IHeight, GifFileIn -> IWidth,
			FALSE, GifFileIn -> IBitsPerPixel,
			GifFileIn -> IColorMap) == GIF_ERROR)
			    QuitGifError(GifFileIn, GifFileOut);
		}
		else {
		    /* No rotation - only flipping vert. or horiz.: */
		    if (EGifPutImageDesc(GifFileOut,
			GifFileIn -> ILeft, GifFileIn -> ITop,
			GifFileIn -> IWidth, GifFileIn -> IHeight,
			FALSE, GifFileIn -> IBitsPerPixel,
			GifFileIn -> IColorMap) == GIF_ERROR)
			    QuitGifError(GifFileIn, GifFileOut);
		}

		/* Load the image (either Interlaced or not), and dump it    */
		/* fliped as requrested by Flags:			     */
		if (LoadImage(GifFileIn, &ImageBuffer) == GIF_ERROR)
		    QuitGifError(GifFileIn, GifFileOut);
		if (DumpImage(GifFileOut, ImageBuffer, GifFileIn -> IWidth,
				GifFileIn -> IHeight, FlipDirection) == GIF_ERROR)
		    QuitGifError(GifFileIn, GifFileOut);
		break;
	    case EXTENSION_RECORD_TYPE:
		/* Skip any extension blocks in file: */
		if (DGifGetExtension(GifFileIn, &ExtCode, &Extension) == GIF_ERROR)
		    QuitGifError(GifFileIn, GifFileOut);
		if (EGifPutExtension(GifFileOut, ExtCode, Extension[0],
							Extension) == GIF_ERROR)
		    QuitGifError(GifFileIn, GifFileOut);

		/* No support to more than one extension blocks, so discard: */
		while (Extension != NULL) {
		    if (DGifGetExtensionNext(GifFileIn, &Extension) == GIF_ERROR)
			QuitGifError(GifFileIn, GifFileOut);
		}
		break;
	    case TERMINATE_RECORD_TYPE:
		break;
	    default:		    /* Should be traps by DGifGetRecordType. */
		break;
	}
    }
    while (RecordType != TERMINATE_RECORD_TYPE);

    if (DGifCloseFile(GifFileIn) == GIF_ERROR)
	QuitGifError(GifFileIn, GifFileOut);
    if (EGifCloseFile(GifFileOut) == GIF_ERROR)
	QuitGifError(GifFileIn, GifFileOut);
}

/******************************************************************************
* Routine to read Image out. The image can be Non interlaced only.	      *
* The memory required to hold the image is allocate by the routine itself.    *
* Return GIF_OK if succesful, GIF_ERROR otherwise.			      *
******************************************************************************/
static int LoadImage(GifFileType *GifFile, GifRowType **ImageBufferPtr)
{
    int Size, i;
    GifRowType *ImageBuffer;

    /* Allocate the image as vector of column of rows. We cannt allocate     */
    /* the all screen at once, as this broken minded CPU can allocate up to  */
    /* 64k at a time and our image can be bigger than that:		     */
    if ((ImageBuffer = (GifRowType *)
	malloc(GifFile -> IHeight * sizeof(GifRowType *))) == NULL)
	    GIF_EXIT("Failed to allocate memory required, aborted.");

    Size = GifFile -> IWidth * sizeof(GifPixelType);/* One row size in bytes.*/
    for (i = 0; i < GifFile -> IHeight; i++) {
	/* Allocate the rows: */
	if ((ImageBuffer[i] = (GifRowType) malloc(Size)) == NULL)
	    GIF_EXIT("Failed to allocate memory required, aborted.");
    }

    *ImageBufferPtr = ImageBuffer;

    GifQprintf("\n%s: Image %d at (%d, %d) [%dx%d]:     ",
	PROGRAM_NAME, ++ImageNum, GifFile -> ILeft, GifFile -> ITop,
				 GifFile -> IWidth, GifFile -> IHeight);

    for (i = 0; i < GifFile -> IHeight; i++) {
	GifQprintf("\b\b\b\b%-4d", i);
	if (DGifGetLine(GifFile, ImageBuffer[i], GifFile -> IWidth)
		== GIF_ERROR) return GIF_ERROR;
    }

    return GIF_OK;
}

/******************************************************************************
* Routine to dump image out. The given Image buffer should always hold the    *
* image sequencially, and Width & Height hold image dimensions BEFORE flip.   *
* Image will be dumped according to FlipDirection.			      *
* Once dumped, the memory holding the image is freed.			      *
* Return GIF_OK if succesful, GIF_ERROR otherwise.			      *
******************************************************************************/
static int DumpImage(GifFileType *GifFile, GifRowType *ImageBuffer,
				int Width, int Height, int FlipDirection)
{
    int i, j, Count;
    GifRowType Line;			   /* New scan line is copied to it. */

    /* Allocate scan line that will fit both image width and height: */
    if ((Line = (GifRowType) malloc((Width > Height ? Width : Height)
						* sizeof(GifPixelType))) == NULL)
	GIF_EXIT("Failed to allocate memory required, aborted.");

    switch (FlipDirection) {
	case FLIP_RIGHT:
	    for (Count = Width, i = 0; i < Width; i++) {
		GifQprintf("\b\b\b\b%-4d", Count--);
		for (j = 0; j < Height; j++)
		    Line[j] = ImageBuffer[Height - j - 1][i];
		if (EGifPutLine(GifFile, Line, Height) == GIF_ERROR)
	    	    return GIF_ERROR;
	    }
	    break;
	case FLIP_LEFT:
	    for (i = Width - 1; i >= 0; i--) {
		GifQprintf("\b\b\b\b%-4d", i + 1);
		for (j = 0; j < Height; j++)
		    Line[j] = ImageBuffer[j][i];
		if (EGifPutLine(GifFile, Line, Height) == GIF_ERROR)
	    	    return GIF_ERROR;
	    }
	    break;
	case FLIP_HORIZ:
	    for (i = Height - 1; i >= 0; i--) {
		GifQprintf("\b\b\b\b%-4d", i);
		if (EGifPutLine(GifFile, ImageBuffer[i], Width) == GIF_ERROR)
		    return GIF_ERROR;
	    }
	    break;
	case FLIP_VERT:
	    for (Count = Height, i = 0; i < Height; i++) {
		GifQprintf("\b\b\b\b%-4d", Count--);
		for (j = 0; j < Width; j++)
		    Line[j] = ImageBuffer[i][Width - j - 1];
		if (EGifPutLine(GifFile, Line, Width) == GIF_ERROR)
	    	    return GIF_ERROR;
	    }
	    break;
    }

    /* Free the memory used for this image, and the temporary scan line: */
    for (i = 0; i < Height; i++) free((char *) ImageBuffer[i]);
    free((char *) ImageBuffer);

    free((char *) Line);

    return GIF_OK;
}

/******************************************************************************
* Close both input and output file (if open), and exit.			      *
******************************************************************************/
static void QuitGifError(GifFileType *GifFileIn, GifFileType *GifFileOut)
{
    PrintGifError();
    if (GifFileIn != NULL) DGifCloseFile(GifFileIn);
    if (GifFileOut != NULL) EGifCloseFile(GifFileOut);
    exit(1);
}
