;----------------------------------------------------------------------------
;File name:	UIS_IV.S			Revision date:	1997.01.09
;Revised by:	Ulf Ronald Andersson		Revision start:	1995.10.08
;Original by:					Creation date:	19yy.mm.dd
;Release:	Version:	4.00
;----------------------------------------------------------------------------
;Copyrights:	for original	(c) 1989 Application & Design Software
;		for revision	(c) 1995 Ulf Ronald Andersson
;UIS IV project start:
;----------------------------------------------------------------------------
;
	output	.PRG
;
;------------------------------------
;
	include	URAn_SIM.S
	include	URAn_JAR.S
	include	URAn_XB.S
	include	URAn_LA.S
;----------------------------------------------------------------------------
Version_s_const	=	'4.00'
;----------------------------------------------------------------------------
	SECTION	TEXT
;----------------------------------------------------------------------------
;
start:
basepage	=	start-$100
	bra	startup
;
;----------------------------------------------------------------------------
IVp_startup_1:
	move	la_v_cel_ht(a0),ref_char_height
	move	la_v_cel_ht(a0),char_height
	rts
;----------------------------------------------------------------------------
IVp_nu_size_test:
	jmp	nu_size_test
;----------------------------------------------------------------------------
;
end_prog_resident:
	clr	$1DE(a6)
	clr	$16E(a6)
	lea	patch_area_3-cref(a6),a0
	move.l	a0,patch_area_3_p-cref(a6)
	move.l	a0,4(a6)
	gemdos	Ptermres,(),()
;
;----------------------------------------------------------------------------
;Start of:	BIOS routine with XBRA protocol
;----------------------------------------------------------------------------
;
	XB_define	nu_bios,'UIS3'
	btst	#5,(sp)
	beq.s	go_old_bios		;skip patches for user mode calls
bios_framesize_const	= *+2		;label to patch framesize for CPU type
	lea	6(sp),a0		;a0 -> args on super stack
	cmpi.l	#((Setexc&$ff)<<16)+etvn_critic,(a0)
	bne.s	go_old_bios
nu_setexc_critic:
;from here to nu_xgemdos_code were originally 112 bytes
;The new code block is therefore padded to 112 bytes
	lea	cref(pc),a1		;4 bytes
	st	$1C(a1)			;4 bytes
	bsr.s	install_xgemdos_sub	;2 bytes
go_old_bios:
	move.l	nu_bios+xb_next(pc),a0	;;;4 bytes
	jmp	(a0)			;;;2 bytes
;;;
install_bios_sub:
	lea	(ev_bios).w,a0	;4 bytes
	lea	nu_bios(pc),a1	;4 bytes
	bra.s	force_XB	;2 bytes
;
install_xgemdos_sub:
	lea	(ev_xgemdos).w,a0	;4 bytes
	lea	nu_xgemdos(pc),a1	;4 bytes
	include	force_XB.s		;;;this subroutine takes up 50 bytes
;;;
calc_cell_xmax:
	move	la_wk_xmax(a0),d0	;4 bytes
	addq	#1,d0			;2 bytes
	divu	char_width(pc),d0	;4 bytes
	subq	#1,d0			;2 bytes
	rts				;2 bytes
;;;
critic_pad	set 112-(*-nu_setexc_critic)	;;;calculate code length difference
critic_pad	set	critic_pad-xb_size	;;;deduct 12 bytes (nu_xgemdos XBRA)
	rept	critic_pad/2	;;; \
	nop			;;;  X Pad to maintain code length
	endr			;;; /
;;;
;----------------------------------------------------------------------------
;End of:	BIOS routine with XBRA protocol
;----------------------------------------------------------------------------
;Start of:	XGEMDOS routine with XBRA protocol
;----------------------------------------------------------------------------
	XB_define	nu_xgemdos,'UIS3'
nu_xgemdos_code:
	cmp	#$C8,d0			;aes xgemdos call ?
	bne.s	go_old_xgemdos
	move.l	d1,a0			;a0 -> aespb
	move.l	(a0),a0			;a0 -> callers contrl
	cmp	#fsel_input&$ff,(a0)
	beq.s	nu_fsel_functions
	cmp	#fsel_exinput&$ff,(a0)
	beq.s	nu_fsel_functions
go_old_xgemdos:
;;;		old_xgemdos_p	= *+2
;;;		jmp	(0).l
	move.l	nu_xgemdos+xb_next(pc),a0
	jmp	(a0)
;
;------------------------------------
;
nu_fsel_functions:
	move	(sp)+,d0		;d0 = sr pulled from entry frame
	move.l	(sp)+,a0		;a0 = retadr pulled from entry frame
	pea	.T_d4(pc)		;push -> .T_d4 as new frame retadr
	move	d0,-(sp)		;repush d0 as frame sr
	rte				;exit exception to .T_d4 : a0 -> real retadr
;
;----------------------------------------------------------------------------
;End of:	XGEMDOS routine with XBRA protocol
;----------------------------------------------------------------------------
.T_d4:					;here a0 -> real retadr, with pre-call CPU state
	move.l	a0,-(sp)		;push a0 for use as subroutine return address
;from this point on, conditions are as if user made a subroutine call
;to this location, with d1 -> aespb, and d0/a0 irrelevant
;----------------------------------------------------------------------------
;Start of:	Main UIS file selector subroutine
;----------------------------------------------------------------------------
UIS_IV_sub:
	movem.l	d1-d7/a1-a6,-(sp)	;protect all regs except d0/a0
	lea	cref(pc),a6
	move.l	d1,a0			;a0 -> callers aespb
	move	$C2(a6),$174(a6)
	move.l	(a0),a1			;a1 -> callers contrl
	addq.l	#8,a1			;a1 -> contrl[4]  (saddrout)
	cmpa.l	4(a0),a1		;does a1 -> global  (error !!!)
	bne.s	T_F6
	st	$174(a6)
	bra.s	T_100
;
;------------------------------------
;
T_F6:
	cmpa.l	8(a0),a1		;does a1 -> intin  (also error !!!)
	bne.s	T_100
	st	$175(a6)
T_100:
	move.l	$10(a0),a1			;a1 -> callers addrin
	move.l	(a1)+,ref_fsel_path_p-cref(a6)
	move.l	(a1)+,ref_fsel_name_p-cref(a6)
	move.l	(a1),ref_fsel_prompt_1_p-cref(a6)
	move.l	(a1),ref_fsel_prompt_2_p-cref(a6)
	move.l	(a0),a2				;a2 -> callers contrl
	cmp	#$5B,(a2)			;opcode = fsel_exinput ?
	beq.s	T_168
;
;here opcode = fsel_input,  so prompt string is not valid
;even so, UIS will allow 2 (!!!) prompt strings (insane)
;which will be combined into one.  (but I don't see why...)
;
	cmp	#4,6(a2)			;saddrin < 4 ?
	blo.s	T_154
	moveq	#$1A,d0
	lea	$256(a6),a2
	move.l	a2,ref_fsel_prompt_1_p-cref(a6)
	move.l	a2,ref_fsel_prompt_2_p-cref(a6)
	move.l	(a1)+,a3
T_134:
	move.b	(a3)+,(a2)+
	beq.s	T_13E
	dbra	d0,T_134
	bra.s	T_150
;
;------------------------------------
;
T_13E:
	move.b	#$20,-$1(a2)
	move.l	(a1),a3
	bra.s	T_14C
;
;------------------------------------
;
T_148:
	move.b	(a3)+,(a2)+
	beq.s	T_150
T_14C:
	dbra	d0,T_148
T_150:
	clr.b	(a2)
	bra.s	T_168
;
;------------------------------------
;
T_154:
	lea	default_fsel_prompt_s(pc),a1
	move.l	a1,ref_fsel_prompt_1_p-cref(a6)
	move.l	$4A(a6),a1
	move.l	$24(a1),a1
	move.l	a1,ref_fsel_prompt_2_p-cref(a6)
T_168:
	move.l	4(a0),a1		;a1 -> global
	lea	UIS_global(pc),a0
	moveq	#15-1,d0
.copy_global_loop:
	move	(a1)+,(a0)+
	dbra	d0,.copy_global_loop
;
	bsr	wind_update_1_and_3
;
	lea	UIS_contrl(pc),a0
	move.l	#$4d0000,(a0)+		;graf_handle
	move.l	#$50000,(a0)+
	move	#0,(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
;
	move	UIS_intout(pc),ref_wk_handle-cref(a6)		;copy phys workstation handle
;;;Patch character width handling below !!!
	move.l	UIS_intout+2(pc),d0		;;;d0 = char cell width.height
	bsr	IVp_nu_size_test		;;;size unchanged ?
	beq	keep_size_settings		;;;
	nop					;;;
	nop					;;;
;;;Patch character width handling above !!!
	bsr	open_UIS_IV_PRG_rw
	bmi.s	keep_size_settings
;
	gemdos	Fseek,#patch_area_1-start+ph_size,d6,#0
	lea	patch_area_1(pc),a5
	gemdos	Fread,d6,#patch_area_1_end-patch_area_1,(a5)
	gemdos	Fseek,#patch_area_2-start+ph_size,d6,#0
	move.l	patch_area_3_p-cref(a6),a4
	gemdos	Fread,d6,#patch_area_3_end-patch_area_3,(a4)
	gemdos	Fclose,d6
;
	jsr	startup_sub_1-patch_area_2(a4)	;call startup_sub_1 loaded to patch_area_3 with a5 -> patch_area_1
;
	bsr	T_a48
	beq.s	.T_228
	bsr	T_4d32
.T_228:
	bsr	T_B66
	clr	$16E(a6)
keep_size_settings:
	move.l	ref_line_a_base_p-cref(a6),a0
	move	(a0),ref_planes-cref(a6)	;bit planes
;;;	move	la_v_cel_mx(a0),d0	;4 ;d0 = max char column on VT52 screen
	bsr	calc_cell_xmax		;;;4 ;d0 = max char column on desktop
	cmp	#79,d0
	bls.s	T_244
	moveq	#79,d0
T_244:
	move	d0,ref_max_column-cref(a6)
	addq	#1,d0
;;;		mulu	#8,d0			;BUG: should be desktop font cell width
	mulu	char_width(pc),d0	;;;new: corrects for desktop font cell width
	move.l	$56(a6),a5
	move	d0,$14(a5)
	move	d0,$2C(a5)
	lea	$10(a5),a5
	lea	$a2(a6),a0
	move.l	(a5)+,(a0)+
	move.l	(a5),(a0)
;
	lea	UIS_contrl(pc),a0
	move.l	#$680002,(a0)+		;wind_get
	move.l	#$50000,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	#0,(a0)+		;desktop window
	move	#4,(a0)			;worksize area
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
;
	lea	UIS_intout(pc),a0
	move	(a0)+,d0		;d0 = ok_flag
	lea	$178(a6),a1
	move.l	(a0)+,(a1)+		;copy xpos.ypos
	move.l	(a0),(a1)		;copy width.height
	move.l	$17C(a6),d0		;d0 = width.height
	cmp.l	$16E(a6),d0		;height == $16E(a6) ?
	beq.s	T_2d4
	move.l	d0,$16E(a6)		;$16E(a6) = height
	move.l	$32(a6),a0
	move.l	$4A(a6),a1
	moveq	#4,d1
	bset	d1,11(a0)
	bset	d1,11(a1)
	swap	d0			;d0 = height.width
	cmp	#340,d0			;width < 340 ?
;;;	jsr	check_340_d0-cref(a6)	;sub tests width*8/char_width < 340
	bhs.s	T_2CE
	bclr	d1,11(a0)
	bclr	d1,11(a1)
T_2CE:
	bsr	T_4Cd2
	bsr.s	T_2E4
T_2d4:
	bra	T_37E
;
;------------------------------------
;
T_2D8:	clr.l	$B8(a6)
	bsr	T_4Cd2
	clr	$20(a6)
T_2E4:	moveq	#8,d4
	lea	$5A(a6),a4
	lea	$32(a6),a5
	move	$B8(a6),d5
	move	$BA(a6),d6
T_2F6:	move.l	(a5),a3
	clr	$10(a3)
	clr	$12(a3)
;
	lea	UIS_contrl(pc),a0
	move.l	#$360000,(a0)+		;form_center
	move.l	#$50001,(a0)+
	move	#0,(a0)
	lea	UIS_addrin(pc),a0
	lea	(a5),a1
	move.l	(a1),(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	lea	UIS_intout(pc),a0
	move	(a0)+,d0
	lea	(a4),a1
	move.l	(a0)+,(a1)+
	move.l	(a0),(a1)
	add	d5,$10(a3)
	add	d6,$12(a3)
	add	d5,(a4)
	add	d6,2(a4)
	addq.l	#8,a4
	addq.l	#4,a5
	dbra	d4,T_2F6
	bsr	T_4CE4
	tst.l	$B8(a6)
	bne.s	T_358
	tst	$20(a6)
	beq.s	T_37C
T_358:	move.l	$5A(a6),d0
T_35C:	bmi	T_2D8
	tst	d0
	bmi.s	T_35C
	add.l	$5E(a6),d0
	sub	$17A(a6),d0
	cmp	$17E(a6),d0
T_370:	bhi	T_2D8
	swap	d0
	cmp	$17C(a6),d0
	bhi.s	T_370
T_37C:	rts
;
;----------------------------------------------------------------------------
;
T_37E:
	move	#0,$DC(a6)
	move.l	$5A(a6),d0
	move.l	d0,$166(a6)
	add.l	$5E(a6),d0
	move.l	d0,$16A(a6)
	lea	$BF(a6),a0
	orig:	cmp	#600,$16E(a6)		;width < 600 ?
;;;	jsr	check_600_16E_ia6-cref(a6)	;sub tests width*8/char_width < 600
;;;	nop
	bhs.s	T_3B4
	tst.b	(a0)
	bne.s	T_3C4
	move.b	#1,(a0)
	tst.b	-$1(a0)
	beq.s	T_3C4
	bsr	T_4d44
	bra.s	T_3C4
;
;------------------------------------
;
T_3B4:	tst.b	(a0)
	beq.s	T_3C4
	clr.b	(a0)
	tst.b	-$1(a0)
	beq.s	T_3C4
	bsr	T_4d32
T_3C4:	move.l	ref_fsel_prompt_1_p-cref(a6),a0
	bsr	T_a48
	beq.s	T_3d2
	move.l	ref_fsel_prompt_2_p-cref(a6),a0
T_3d2:	move.l	$32(a6),a1
	move.l	a0,$24(a1)
	clr.l	$AA(a6)
	bsr	T_3880
	bsr	T_372A
	bsr	T_B66
	clr	$12E(a6)
	clr	$E2(a6)
	clr	ref_bottom_bar_type-cref(a6)
	clr	$FE(a6)
	clr	$11A(a6)
	clr	$E6(a6)
	clr	$FC(a6)
	clr.b	$106(a6)
	move	#$190,$18E(a6)
	move	#-$7d0,$FA(a6)
	move	#$1B,$118(a6)
	move	#$2F,-(sp)
	trap	#1			;Tgetdta
	addq.l	#2,sp
	move.l	d0,$12A(a6)
	pea	$194(a6)
	move	#$1A,-(sp)
	trap	#1			;Fsetdta
	addq.l	#6,sp
	move.l	$32(a6),a4
	clr	$2AA(a4)
	clr	$2C2(a4)
	lea	$84(a4),a4
	move.l	(a4),a4
	move.l	ref_fsel_path_p-cref(a6),a5
	moveq	#$2E,d2
	bsr	T_3C12
	bmi.s	.T_45E
	lea	1(a5,d1),a5
	moveq	#2,d0
.T_458:
	move.b	(a5)+,(a4)+
	dbeq	d0,.T_458
.T_45E:
	clr.b	(a4)
main_form_loop:
	clr	$DA(a6)
	move	#0,$DC(a6)
	bsr	T_41BA
	bsr	T_3B62
	bsr	T_3a56
	bsr	T_3B0C
	clr	$E2(a6)
	clr	$F8(a6)
	bsr	T_28d2
	bsr	T_26F8
	bsr	objc_draw_0_2
	move	#1,$DA(a6)
T_494:
	bsr	T_3C4E
	bsr	T_42a2
T_49C:
	bsr	graf_mouse_arrow
;
	lea	UIS_contrl(pc),a0
	move.l	#$7a0000,(a0)		;v_show_c
	move	#1,6(a0)
	move	ref_wk_handle-cref(a6),12(a0)
	lea	UIS_intin(pc),a0
	move	#0,(a0)
	move.l	UIS_vdipb_p(pc),d1
	move	#$73,d0
	trap	#2			;call vdi
T_4C8:
	move	$118(a6),d2
T_4CC:
	clr.b	$1E(a6)
	clr	$22(a6)
	bsr	form_event_sub
	tst	$22(a6)
	bne	main_KEYBD_comd
T_4E0:
	move	d7,$128(a6)
	and	#$7FFF,d7
	move	d7,d0
	cmp	#$3E,d0
	bhi.s	T_4C8
	lea	T_52E(pc),a0
	moveq	#2,d2
.T_4F6:
	cmp	(a0),d0
	bls.s	.T_504
	sub	2(a0),d0
	cmp	(a0),d0
	bcc.s	.T_504
	move	(a0),d0
.T_504:
	addq.l	#4,a0
	dbra	d2,.T_4F6
	subq	#1,d0
	lsl	#1,d0
	move	0(a0,d0),d0
	bpl.s	T_52A
	movem.l	d0/a0,-(sp)
	bsr	objc_change_NORMAL
	movem.l	(sp)+,d0/a0
	tst	$FE(a6)
	bne	T_4C8
	neg.w	d0
T_52A:	jmp	0(a0,d0)
;
;------------------------------------
;
T_52E:	dc.b	$0,$5,$0,$5,$0,$19,$0,$3,$0,$1C,$0,$19,'X'
	dc.b	'TK',$4,$7,'',$A,'>$',$7,' $"x."D""'
	dc.b	'#B!z',$11,'"!!',$6,',',$10,$2,$13,'r',$13
	dc.b	'L',$11,'"',$1A,$7,' :n'
;
;----------------------------------------------------------------------------
;
form_event_sub:
	clr	-(sp)
	clr.l	-(sp)
	move	d2,-(sp)
T_57A:
	bsr	graf_mkstate_sub
	btst	#0,d0
	beq.s	T_5F8
	bsr.s	T_5C4
	bmi.s	T_57A
	tst	d7
	beq.s	T_598
	cmp	6(sp),d7
	bne.s	T_598
	bsr	objc_change_SELECTED
	bra.s	T_57A
;
;------------------------------------
;
T_598:	tst	6(sp)
	beq.s	T_5A8
	move	6(sp),d7
	bsr	objc_change_NORMAL
	bra.s	T_57A
;
;------------------------------------
;
T_5A8:	btst	#6,9(a0)
	bne	T_74C
	btst	#0,9(a0)
	beq.s	T_57A
	move	d7,6(sp)
	bsr	objc_change_SELECTED
	bra.s	T_57A
;
;------------------------------------
;
T_5C4:	moveq	#0,d4
T_5C6:	move	d6,-(sp)
	move	d5,-(sp)
	bsr	objc_find_sub
	addq.l	#4,sp
	tst	d7
	bmi.s	T_5E4
	moveq	#$18,d0
	mulu	d7,d0
	move.l	$32(a6),a0
	lea	0(a0,d0),a0
	moveq	#0,d0
	rts
;
;----------------------------------------------------------------------------
;
T_5E4:	tst	d4
	bmi.s	T_5F4
	move	#7,-(sp)
	move	#2,-(sp)
	trap	#1			;Cconout
	addq.l	#4,sp
T_5F4:	moveq	#-1,d0
	rts
;
;----------------------------------------------------------------------------
;
T_5F8:
	moveq	#-1,d4
	bsr.s	T_5C6
	bmi.s	T_60A
	tst	d7
	beq.s	T_60A
	cmp	6(sp),d7
	beq	T_74C
T_60A:
	move	6(sp),d7
	beq.s	T_618
	bsr	objc_change_NORMAL
	clr	6(sp)
T_618:
	tst	2(sp)
	bne.s	evnt_multi_loop
	move	(sp),d0
	moveq	#1,d1
	bsr	objc_edit_sub
	move	d0,4(sp)
	st	2(sp)
evnt_multi_loop:
	moveq	#$23,d0
	move.l	#$1F4,d1
	bsr	evnt_multi_sub
	btst	#b_MU_KEYBD,d0
	bne.s	have_KEYBD
	btst	#b_MU_TIMER,d0
	bne.s	have_TIMER
	btst	#b_MU_BUTTON,d0
	beq.s	evnt_multi_loop
	cmp	#1,d3
	bhi.s	T_676
	bsr	T_5C4
	bmi.s	evnt_multi_loop
	btst	#6,9(a0)
	bne	T_74C
	btst	#0,9(a0)
	beq.s	evnt_multi_loop
	bsr	objc_change_SELECTED
	move	d7,6(sp)
	bra	T_57A
;
;------------------------------------
;
T_676:	bsr	T_5C4
	bmi.s	evnt_multi_loop
	btst	#6,9(a0)
	bne.s	T_690
	btst	#0,9(a0)
	beq.s	evnt_multi_loop
	bsr	objc_change_SELECTED
T_690:	bset	#15,d7
	bra	T_74C
;
;------------------------------------
;
have_TIMER:
	tst.b	$EB(a6)
	bpl.s	evnt_multi_loop
	bsr	T_75C
	bra.s	evnt_multi_loop
;
;------------------------------------
;
have_KEYBD:
	swap	d3
	move	d3,d0
	move.b	d2,d0
	rol	#8,d0
	cmp.b	#$61,d0		;UNDO
	beq.s	T_6E6
	cmp.b	#$47,d0		;CLR/HOME
	beq.s	T_6E6
	cmp.b	#$48,d0		;Cur UP
	beq.s	T_6E6
	cmp.b	#$50,d0		;Cur DOWN
	beq.s	T_6E6
	cmp.b	#$54,d0		;F11
	bcs.s	T_6d4
	cmp.b	#$5D,d0		;F20
	bhi.s	T_6d4
	subi.b	#$19,d0
T_6d4:	cmp.b	#$44,d0		;F10
	bhi.s	T_6E0
	cmp.b	#$3B,d0		;F1
	bcc.s	T_6E6
T_6E0:	andi.b	#12,d2
	beq.s	T_6EE
T_6E6:	move	d0,$22(a6)
	moveq	#$1C,d7
	bra.s	T_74C
;
;------------------------------------
;
T_6EE:	tst	2(sp)
	bne.s	T_6F6
	bsr.s	T_75C
T_6F6:	cmp.b	#13,d3
	beq.s	T_746
	tst	(sp)
	beq.s	T_742
	cmp.b	#$1B,d3
	beq.s	T_772
	cmp.b	#8,d3
	beq.s	T_784
	cmp.b	#9,d3
	beq	T_7E6
	move	d3,d0
	lsr	#8,d0
	cmp.b	#$4B,d0
	beq	T_7F6
	cmp.b	#$4D,d0
	beq	T_806
	cmp.b	#$53,d0
	beq	T_7BA
	move	(sp),d0
	move	4(sp),d2
	move	#2,d1
	bsr	objc_edit_sub
	move	d0,4(sp)
T_742:	bra	evnt_multi_loop
;
;------------------------------------
;
T_746:	moveq	#$1C,d7
	bsr	objc_change_SELECTED
T_74C:	tst	2(sp)
	beq.s	T_754
	bsr.s	T_75C
T_754:	addq.l	#8,sp
	bsr	graf_mkstate_sub
	rts
;
;----------------------------------------------------------------------------
;End of:	Main UIS file selector subroutine
;----------------------------------------------------------------------------
;
T_75C:	move	4(sp),d0
	move	8(sp),d2
	move	#3,d1
	bsr	objc_edit_sub
	not.b	6(sp)
	rts
;
;----------------------------------------------------------------------------
;
T_772:	bsr.s	T_75C
	lea	$1d4(a6),a5
	clr.b	(a5)
	move	(sp),d7
	bsr	T_3926
T_780:	bra	T_618
;
;------------------------------------
;
T_784:	tst	4(sp)
	beq.s	T_780
	bsr.s	T_75C
	moveq	#$18,d0
	mulu	(sp),d0
	move.l	$32(a6),a0
	move.l	12(a0,d0),a0
	move.l	(a0),a0
	move	4(sp),d0
	lea	-1(a0,d0),a0
T_7a2:	move.b	1(a0),(a0)+
	bne.s	T_7a2
	move	(sp),d0
	moveq	#0,d1
	bsr	objc_draw_d0_d1
	subq	#1,4(sp)
T_7B4:	bsr.s	T_75C
T_7B6:	bra	evnt_multi_loop
;
;------------------------------------
;
T_7BA:	bsr.s	T_75C
	moveq	#$18,d0
	mulu	(sp),d0
	move.l	$32(a6),a0
	move.l	12(a0,d0),a0
	move.l	(a0),a0
	move	4(sp),d0
	lea	0(a0,d0),a0
	tst.b	(a0)
	beq.s	T_7B4
T_7d6:	move.b	1(a0),(a0)+
	bne.s	T_7d6
	move	(sp),d0
	moveq	#0,d1
	bsr	objc_draw_d0_d1
	bra.s	T_7B4
;
;------------------------------------
;
T_7E6:	bsr	T_75C
	moveq	#$1B,d0
	cmp	(sp),d0
	bne.s	T_7F2
	moveq	#11,d0
T_7F2:	move	d0,(sp)
	bra.s	T_780
;
;------------------------------------
;
T_7F6:	tst	4(sp)
	beq.s	T_7B6
	bsr	T_75C
	subq	#1,4(sp)
	bra.s	T_7B4
;
;------------------------------------
;
T_806:	moveq	#$18,d0
	mulu	(sp),d0
	move.l	$32(a6),a0
	move.l	12(a0,d0),a0
	move.l	(a0),a0
	move	4(sp),d0
	tst.b	0(a0,d0)
	beq.s	T_7B6
	bsr	T_75C
	addq	#1,4(sp)
	bra.s	T_7B4
;
;----------------------------------------------------------------------------
;
objc_edit_sub:
	tst	d0
	beq.s	.T_868
	lea	UIS_contrl(pc),a0
	move.l	#$2E0004,(a0)+		;objc_edit
	move.l	#$20001,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	d0,(a0)+
	move	d3,(a0)+
	move	d2,(a0)+
	move	d1,(a0)
	lea	UIS_addrin(pc),a0
	lea	$32(a6),a1
	move.l	(a1),(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	move	UIS_intout(pc),d1
	move	UIS_intout+2(pc),d0
.T_868:
	rts
;
;----------------------------------------------------------------------------
;
evnt_multi_sub:
	lea	UIS_contrl(pc),a0
	move.l	#$190010,(a0)+		;evnt_multi
	move.l	#$70001,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	d0,(a0)+
	move	#2,(a0)+
	move.l	#$10001,(a0)
	swap	d1
	move.l	d1,$18(a0)		;store timeout
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	lea	UIS_intout(pc),a0
	move	(a0)+,d0
	move	(a0)+,d5
	move	(a0)+,d6
	move	(a0)+,d1
	move	(a0)+,d2
	move.l	(a0),d3
	rts
;
;----------------------------------------------------------------------------
;
evnt_timed_kb_sub:	movem.l	d3/d5-d6,-(sp)
	moveq	#$21,d0
	moveq	#1,d1
	bsr.s	evnt_multi_sub
	btst	#0,d0
	beq.s	T_8DA
	move.l	d3,d0
	move	d2,d0
	ror.l	#8,d0
	lsr	#8,d0
	cmp.b	#$61,d0
	bcs.s	T_8DC
	cmp.b	#$7A,d0
	bhi.s	T_8DC
	andi.b	#$DF,d0
	bra.s	T_8DC
;
;------------------------------------
;
T_8DA:	moveq	#0,d0
T_8DC:	movem.l	(sp)+,d3/d5-d6
	rts
;
;----------------------------------------------------------------------------
;
	bsr	graf_mkstate_sub
	btst	#0,d0
	bne	T_C46
	bsr	T_2B80
	clr	$DE(a6)
	clr	$DA(a6)
	move	#6,$DC(a6)
	moveq	#1,d7
	tst	$C2(a6)
	beq.s	T_90C
	bsr	objc_change_SELECTED
T_90C:	moveq	#6,d7
	add	$B4(a6),d7
	bsr	objc_change_SELECTED
	moveq	#12,d7
	add	$B6(a6),d7
	bsr	objc_change_SELECTED
	moveq	#15,d7
	add	$BC(a6),d7
	bsr	objc_change_SELECTED
	moveq	#$12,d7
	add.b	$BE(a6),d7
	bsr	objc_change_SELECTED
	moveq	#$16,d7
	add	$C0(a6),d7
	bsr	objc_change_SELECTED
	moveq	#$19,d7
	clr	d0
	move.b	$C4(a6),d0
	bsr	objc_change_d0
	addq	#1,d7
	clr	d0
	move.b	$C5(a6),d0
	bsr	objc_change_d0
	bsr	objc_draw_0_2
	move	#1,$DA(a6)
T_960:	clr	d2
	lea	$4A(a6),a3
	bsr	form_do_sub
	cmp	#1,d7
	beq	T_a56
	cmp	#10,d7
	bls.s	T_9DE
	cmp	#13,d7
	bls.s	T_9EA
	cmp	#$10,d7
	bls.s	T_9F4
	cmp	#$14,d7
	bls.s	T_9FE
	cmp	#$17,d7
	bls	T_a24
	cmp	#$1A,d7
	bls	T_a2E
	cmp	#$1B,d7
	beq	T_a64
	cmp	#$1C,d7
	bne.s	T_960
	bsr	objc_change_NORMAL
	move	#0,$DC(a6)
	btst	#0,$DF(a6)
	beq.s	T_9d6
	bsr	T_30F0
	bsr	T_a48
	bne.s	T_9CA
	bsr	T_4d44
	bra.s	T_9CE
;
;------------------------------------
;
T_9CA:	bsr	T_4d32
T_9CE:	bsr	T_2D8
T_9d2:	bsr	T_30F8
T_9d6:	bsr	T_B66
	bra	main_form_loop
;
;------------------------------------
;
T_9DE:	sub	#6,d7
	move	d7,$B4(a6)
T_9E6:	bra	T_960
;
;------------------------------------
;
T_9EA:	sub	#12,d7
	move	d7,$B6(a6)
	bra.s	T_9E6
;
;------------------------------------
;
T_9F4:	sub	#15,d7
	move	d7,$BC(a6)
	bra.s	T_9E6
;
;------------------------------------
;
T_9FE:	sub	#$12,d7
	move.b	$BE(a6),d0
	move.b	d7,$BE(a6)
	tst.b	$BF(a6)
	bne.s	T_9E6
	tst.b	d7
	beq.s	T_a1A
	tst.b	d0
	bne.s	T_9E6
	bra.s	T_a1E
;
;------------------------------------
;
T_a1A:	tst.b	d0
	beq.s	T_9E6
T_a1E:	addq.b	#1,$DF(a6)
	bra.s	T_9E6
;
;------------------------------------
;
T_a24:	sub	#$16,d7
	move	d7,$C0(a6)
	bra.s	T_9E6
;
;------------------------------------
;
T_a2E:	move	d7,d0
	sub	#$19,d0
	lea	$C4(a6),a0
	eori.b	#1,0(a0,d0)
	move.b	0(a0,d0),d0
T_a42:	bsr	objc_change_d0
	bra.s	T_9E6
;
;------------------------------------
;
T_a48:
	cmpi.b	#1,$BF(a6)
	beq.s	T_a54
	tst.b	$BE(a6)
T_a54:
	rts
;
;------------------------------------
;
T_a56:	not.w	$C2(a6)
	move	$C2(a6),d0
	and	#1,d0
	bra.s	T_a42
;
;------------------------------------
;
T_a64:	move	$DE(a6),-(sp)
	clr	$DA(a6)
	move	#1,$DC(a6)
	bsr	T_13AC
	move	#1,$DA(a6)
	move	#6,$DC(a6)
	move	(sp)+,$DE(a6)
	lea	$194(a6),a0
	move.l	$B4(a6),(a0)+
	move.l	$BC(a6),(a0)+
	clr.b	-$1(a0)
	move.l	$C0(a6),(a0)+
	move.l	$C4(a6),(a0)+
	move.l	$C8(a6),(a0)+
	move.l	$CC(a6),(a0)+
	move.b	$EB(a6),(a0)+
	clr.b	(a0)+
	move.l	$B8(a6),(a0)+
	move	$20(a6),(a0)+
	move.l	$32(a6),a1
	move.l	$9C(a1),a1
	moveq	#15,d0
.T_ABE:	move.b	(a1)+,(a0)+
	dbra	d0,.T_ABE
	move.l	$36(a6),a1
	move.l	$144(a1),a1
	move.l	(a1),a1
.T_ACE:	move.b	(a1)+,(a0)+
	bne.s	.T_ACE
.T_Ad2:
	bsr.s	open_UIS_IV_PRG_rw
	bmi.s	.T_B42
	gemdos	Fseek,#patch_area_4-start+ph_size,d6,#0
	gemdos	Fwrite,d6,#patch_area_4_end-patch_area_4,patch_area_4(pc)
	gemdos	Fseek,#patch_area_5-start+ph_size,d6,#0
	gemdos	Fwrite,d6,#patch_area_5_end-patch_area_5,$194(a6)
	gemdos	Fclose,d6
.T_B38:
	moveq	#$1B,d7
	bsr	objc_change_NORMAL
	bra	T_960
;
;------------------------------------
;
.T_B42:	lea	cant_find_UIS_IV_PRG_alst(pc),a2
	bsr	T_39BE
	subq	#1,d0
	beq	.T_Ad2
	bra.s	.T_B38
;
;----------------------------------------------------------------------------
;
open_UIS_IV_PRG_rw:
	gemdos	Fopen,basepage+bp_arglen(pc),#2
	move	d0,d6
	rts
;
;----------------------------------------------------------------------------
;
T_B66:	movem.l	d0-d1,-(sp)
	moveq	#1,d0
	bsr	T_a48
	beq.s	T_B80
	cmpi.b	#2,$BE(a6)
	blo.s	T_B80
	moveq	#3,d0
	add	$C0(a6),d0
T_B80:	move	d0,$2E(a6)
	tst	$C0(a6)
	beq.s	T_BA8
	move	char_height(pc),d0
	moveq	#12,d1
	tst.b	$1F(a6)
	beq.s	T_B9A
	add	$20(a6),d1
T_B9A:	mulu	d1,d0
	divu	#6,d0
	move	#6,$30(a6)
	bra.s	T_BBA
;
;------------------------------------
;
T_BA8:	move	char_height(pc),$30(a6)
	moveq	#12,d0
	tst.b	$1F(a6)
	beq.s	T_BBA
	add	$20(a6),d0
T_BBA:	move	d0,$2A(a6)
	mulu	$2E(a6),d0
	move	d0,$2C(a6)
	movem.l	(sp)+,d0-d1
	rts
;
;----------------------------------------------------------------------------
;
	lea	$1d4(a6),a0
	move.l	$5A(a6),(a0)+
	move	$5E(a6),(a0)+
	move	$90(a6),(a0)
;
	lea	UIS_contrl(pc),a0
	move.l	#$460004,(a0)+		;graf_rubberbox
	move.l	#$30000,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	lea	$1d4(a6),a1
	move.l	(a1)+,(a0)+
	move.l	(a1),(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	lea	UIS_intout(pc),a0
	move	(a0)+,d0
	move	(a0)+,d5
	move	(a0),d6
	sub	$90(a6),d6
	ext.l	d6
	divu	char_height(pc),d6
	tst.b	$1F(a6)
	beq.s	T_C2A
	cmp	$20(a6),d6
	bne.s	T_C2E
T_C26:	bra	T_4C8
;
;------------------------------------
;
T_C2A:	tst	d6
	beq.s	T_C26
T_C2E:	move	d6,-(sp)
	bsr	T_3726
	bsr	T_4Cd2
	move	(sp)+,$20(a6)
	beq.s	T_C42
	bsr	T_4CE4
T_C42:	bra	T_9d2
;
;------------------------------------
;
T_C46:
	lea	UIS_contrl(pc),a0
	move.l	#$470008,(a0)+		;graf_dragbox
	move.l	#$30000,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	$5E(a6),(a0)+
	move	$60(a6),(a0)+
	move	$5A(a6),(a0)+
	move	$5C(a6),(a0)+
	lea	$178(a6),a1
	move.l	(a1)+,(a0)+
	move.l	(a1),(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	lea	UIS_intout(pc),a0
	move	(a0)+,d0
	move	(a0)+,d5
	move	(a0),d6
	move.l	$32(a6),a0
	btst	#4,11(a0)
	beq.s	T_C9E
	cmp	#8,d5
	bcc.s	T_C9E
	moveq	#8,d5
T_C9E:	sub	$5A(a6),d5
	and	#-$8,d5
	sub	$5C(a6),d6
	tst	d5
	bne.s	T_CB4
	tst	d6
	beq	T_d34
T_CB4:	bsr	T_3726
	lea	$1A8(a6),a5
	moveq	#8,d7
	lea	$5A(a6),a4
	move.l	(a4),(a5)
	move.l	4(a4),d0
	add.l	(a4),d0
	subi.l	#$10001,d0
	move.l	d0,4(a5)
	lea	$32(a6),a3
T_CD8:	move.l	(a3),a2
	add	d5,$10(a2)
	add	d6,$12(a2)
	add	d5,(a4)
	add	d6,2(a4)
	addq.l	#8,a4
	addq.l	#4,a3
	dbra	d7,T_CD8
	add	d5,$B8(a6)
	add	d6,$BA(a6)
	tst.l	$AA(a6)
	beq.s	T_d0C
	bsr	T_372A
	bsr	objc_draw_0_2
	bsr	T_3E94
	bra.s	T_d34
;
;------------------------------------
;
T_d0C:	lea	$5A(a6),a4
	move.l	(a4),8(a5)
	move.l	4(a4),d0
	add.l	(a4),d0
	subi.l	#$10001,d0
	move.l	d0,12(a5)
	bsr	graf_mouse_hide
	bsr	vro_cpyfm_194_ia6
	bsr	graf_mouse_show
	bsr	T_3828
T_d34:	bra	T_4C8
;
;------------------------------------
;
	tst	$128(a6)
	bmi.s	T_DB6
	cmp	#5,d7
	bne.s	T_d7E
	btst	#1,$12F(a6)
	beq.s	T_d7E
	lea	choose_extension_s(pc),a5
	bsr	T_E48
	cmp	#$18,d0
	beq	T_3408
	lsl	#2,d0
	lea	T_5B66(pc),a0
	pea	0(a0,d0)
	bsr	T_3C28
	move.l	ref_fsel_path_p-cref(a6),a0
T_d6E:	move.b	(a4)+,(a0)+
	bne.s	T_d6E
	lea	-$2(a0),a1
	move.l	(sp)+,a0
T_d78:	move.b	(a0)+,(a1)+
	bne.s	T_d78
	bra.s	T_Da0
;
;------------------------------------
;
T_d7E:	bsr	T_3C28
	move.l	ref_fsel_path_p-cref(a6),a0
T_D86:	move.b	(a4)+,(a0)+
	bne.s	T_D86
	cmp	#15,d7
	beq.s	T_DA8
	cmp	#10,d7
	beq	T_Da0
	lea	-$2(a0),a5
	bsr	T_3922
T_Da0:	bsr	T_3B10
	bra	T_2658
;
;------------------------------------
;
T_DA8:	lea	-$4(a0),a0
	lea	$2550(a6),a1
T_DB0:	move.b	(a1)+,(a0)+
	bne.s	T_DB0
	bra.s	T_Da0
;
;------------------------------------
;
T_DB6:	tst	$FE(a6)
	bne	T_4C8
	cmp	#10,d7
	beq.s	T_d7E
	move	d7,$DE(a6)
	moveq	#11,d7
	lea	$2550(a6),a5
	bsr	T_3922
T_Dd2:	lea	$2550(a6),a5
	moveq	#$5C,d2
	bsr	T_3C12
	bmi.s	T_DE2
	lea	0(a5,d1),a5
T_DE2:	moveq	#$2E,d2
	bsr	T_3C12
	bpl.s	T_DEE
	move	d0,d1
	subq	#1,d1
T_DEE:	lea	1(a5,d1),a5
	clr.b	3(a5)
	move	$DE(a6),d7
	cmp	#5,d7
	beq.s	T_E26
	clr	$DA(a6)
	bsr	T_3926
	bsr	objc_offset_sub
	lea	$1d4(a6),a2
	move	d3,(a2)
	move	d4,2(a2)
	move.l	#$180010,4(a2)
	bsr	T_3586
T_E22:	bra	T_4C8
;
;------------------------------------
;
T_E26:	move.l	a5,-(sp)
	lea	replace_extension_s(pc),a5
	bsr.s	T_E48
	move.l	(sp)+,a1
	cmp	#$18,d0
	beq.s	T_E44
	lsl	#2,d0
	lea	T_5B66(pc),a0
	lea	0(a0,d0),a0
T_E40:	move.b	(a1)+,(a0)+
	bne.s	T_E40
T_E44:	bra	T_3408
;
;------------------------------------
;
T_E48:	move.l	$32(a6),a0
	bclr	#7,$5F1(a0)
	lea	$630(a0),a0
	move.l	a0,-(sp)
	clr	$DA(a6)
	moveq	#$40,d7
	bsr	T_3926
	moveq	#$3F,d0
	moveq	#1,d1
	bsr	objc_draw_d0_d1
	move	#1,$DA(a6)
	moveq	#$42,d7
	moveq	#0,d6
	lea	T_5B66(pc),a4
T_E78:	move.l	d6,d0
	divu	#5,d0
	move.l	d0,d1
	mulu	char_height(pc),d0
	swap	d1
	lsl	#5,d1
	move.l	(sp),a0
	move	d1,$10(a0)
	move	d0,$12(a0)
	move.l	a4,a5
	addq.l	#4,a4
	bsr	T_3926
	addq	#1,d6
	cmp	#$19,d6
	bcs.s	T_E78
	moveq	#$41,d7
	bsr	objc_offset_sub
	move.l	(sp)+,a3
	lea	-$18(a3),a3
	move	(a3),-(sp)
	move.l	2(a3),-(sp)
	move.l	$10(a3),-(sp)
	move	d3,$10(a3)
	move	d4,$12(a3)
	moveq	#-1,d0
	move	d0,(a3)
	move.l	d0,2(a3)
	move.l	a3,-(sp)
	move.l	sp,a3
	moveq	#0,d2
	bsr	form_do_sub
	move.l	(sp)+,a3
	move.l	(sp)+,$10(a3)
	move.l	(sp)+,2(a3)
	move	(sp)+,(a3)
	moveq	#$41,d7
	bsr	T_2944
	sub	d3,d5
	sub	d4,d6
	ext.l	d5
	ext.l	d6
	divu	char_height(pc),d6
	mulu	#5,d6
	divu	#$20,d5
	add	d5,d6
	move	d6,-(sp)
	moveq	#$3F,d7
	bsr	objc_offset_sub
	move.l	$32(a6),a0
	lea	$5E8(a0),a0
	bset	#7,9(a0)
	lea	$1d4(a6),a2
	move	d3,(a2)
	move	d4,2(a2)
	move.l	$14(a0),4(a2)
	bsr	T_3596
	bsr.s	evnt_button_sub
	move	(sp)+,d0
	rts
;
;----------------------------------------------------------------------------
;
evnt_button_sub:
	lea	UIS_contrl(pc),a0
	move.l	#$150003,(a0)+		;evnt_button
	move.l	#$50000,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	#1,(a0)+
	move	#1,(a0)+
	move	#0,(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	lea	UIS_intout(pc),a0
	move	(a0)+,d0
	lea	$1d4(a6),a1
	move.l	(a0)+,(a1)+
	move	(a0)+,(a1)+
	move	(a0),d0
	rts
;
;----------------------------------------------------------------------------
;
T_F6A:	tst	$FE(a6)
	bne	T_E22
	moveq	#11,d2
	bra	T_4CC
;
;------------------------------------
;
	tst	$128(a6)
	bpl.s	T_F6A
	bsr	T_2944
	sub	d3,d5
	lsr	#3,d5
	add	$F6(a6),d5
	move.l	ref_fsel_path_p-cref(a6),a0
	move.l	a0,a5
	moveq	#0,d0
T_F92:	addq	#1,d0
	tst.b	(a0)+
	bne.s	T_F92
	cmp	d0,d5
	bcc.s	T_F6A
	lea	0(a5,d5),a5
	moveq	#$5C,d2
	bsr	T_3C12
	bmi.s	T_F6A
	lea	1(a5,d1),a4
T_FAC:	cmpi.b	#$5C,(a5)+
	bne.s	T_FAC
	cmpa.l	a4,a5
	beq	T_F6A
	bra	T_2654
;
;------------------------------------
;
T_FBC:	bsr	T_1990
	move.l	ref_fsel_name_p-cref(a6),a5
	rts
;
;----------------------------------------------------------------------------
;
T_FC6:	bsr.s	T_FBC
	moveq	#$2E,d2
	bra	T_3C12
;
;------------------------------------
;
T_FCE:	sub	d3,d5
	cmp	#$40,d5
	bcc.s	T_FFC
	bsr.s	T_FC6
	bmi.s	T_1010
	tst	d1
	bne.s	T_FEE
T_FDE:	move.b	0(a5,d0),1(a5,d0)
	dbra	d0,T_FDE
	move.b	#$2A,(a5)
	bra.s	T_1014
;
;------------------------------------
;
T_FEE:	lea	0(a5,d1),a4
	move.b	#$2A,(a5)+
	bsr	T_2600
	bra.s	T_1014
;
;------------------------------------
;
T_FFC:	bsr.s	T_FC6
	bpl.s	T_1004
	move	d0,d1
	beq.s	T_1010
T_1004:	lea	0(a5,d1),a5
	bsr	T_3C06
	bra.s	T_1014
;
;------------------------------------
;
	bsr.s	T_FBC
T_1010:	bsr	T_3C02
T_1014:	bsr	T_3a56
	bsr	T_2B80
	bra	T_4C8
;
;------------------------------------
;
graf_mouse_show:
	move	#$101,d0
	bra.s	graf_mouse_d0
;
;------------------------------------
;
graf_mouse_hide:
	move	#$100,d0
	bra.s	graf_mouse_d0
;
;------------------------------------
;
graf_mouse_arrow:
	moveq	#0,d0
	bra.s	graf_mouse_d0
;
;------------------------------------
;
graf_mouse_busybee:
	moveq	#2,d0
	bra.s	graf_mouse_d0
;
;------------------------------------
;
graf_mouse_pointhand:
	moveq	#3,d0
graf_mouse_d0:
	lea	UIS_contrl(pc),a0
	move.l	#$4E0001,(a0)+		;graf_mouse
	move.l	#$10001,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	d0,(a0)
	lea	UIS_addrin(pc),a0
	lea	$1d4(a6),a1
	move.l	a1,(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	move	UIS_intout(pc),d0
	rts
;
;----------------------------------------------------------------------------
;
	clr	$DA(a6)
	bsr	T_1384
	move	#1,$DC(a6)
	moveq	#2,d7
	add	$C6(a6),d7
	bsr	objc_change_SELECTED
	moveq	#5,d7
	add	$C8(a6),d7
	bsr	objc_change_SELECTED
	moveq	#-1,d7
	add	$CA(a6),d7
	bsr	objc_change_SELECTED
	moveq	#-$45,d7
	add	$CC(a6),d7
	bsr	objc_change_SELECTED
	moveq	#15,d7
	add	$CE(a6),d7
	bsr	objc_change_SELECTED
	tst.b	$d0(a6)
	bne.s	T_10C0
	moveq	#15,d7
	bsr	objc_change_SELECTED
	moveq	#$10,d7
	bsr	objc_change_DISABLED
	clr	$CE(a6)
T_10C0:	lea	$130(a6),a5
	clr.b	(a5)
	moveq	#$11,d7
	bsr	T_3926
	bsr	objc_draw_0_2
	move	#1,$DA(a6)
T_10d6:	moveq	#$11,d2
	lea	$36(a6),a3
	bsr	form_do_sub
	cmp	#3,d7
	bls.s	T_110C
	cmp	#6,d7
	bls.s	T_1116
	cmp	#9,d7
	bls.s	T_1120
	cmp	#13,d7
	bls.s	T_112A
	cmp	#$10,d7
	bls.s	T_1134
	cmp	#$16,d7
	bne.s	T_1144
	bsr	objc_change_NORMAL
	bra	main_form_loop
;
;------------------------------------
;
T_110C:	sub	#2,d7
	move	d7,$C6(a6)
	bra.s	T_10d6
;
;------------------------------------
;
T_1116:	sub	#5,d7
	move	d7,$C8(a6)
	bra.s	T_10d6
;
;------------------------------------
;
T_1120:	add	#1,d7
	move	d7,$CA(a6)
T_1128:	bra.s	T_10d6
;
;------------------------------------
;
T_112A:	add	#$45,d7
	move	d7,$CC(a6)
	bra.s	T_1128
;
;------------------------------------
;
T_1134:	tst.b	$d0(a6)
	beq.s	T_1128
	sub	#15,d7
	move	d7,$CE(a6)
	bra.s	T_1128
;
;------------------------------------
;
T_1144:	cmp	#$15,d7
	bne.s	T_1128
	bsr	T_134E
	bsr	T_139A
	bsr	graf_mouse_busybee
	lea	$194(a6),a0
	move	$CA(a6),d0
	move	d0,(a0)
	subq	#6,(a0)+
	clr	(a0)+
	moveq	#1,d2
T_1166:	moveq	#1,d1
T_1168:	move	d1,(a0)+
	addq	#1,d1
	cmp	d0,d1
	bls.s	T_1168
	dbra	d2,T_1166
	moveq	#0,d7
T_1176:	moveq	#0,d6
T_1178:	move	#-$1a1B,-(sp)
	move.l	#-$789ABCDF,-(sp)
	move	#1,-(sp)
	tst	$CE(a6)
	beq.s	T_118E
	neg.w	(sp)
T_118E:	move	d6,-(sp)
	move	d7,-(sp)
	move	$CA(a6),-(sp)
	move	$C6(a6),-(sp)
	clr.l	-(sp)
	tst	$CE(a6)
	beq.s	T_11B8
	lea	$196(a6),a0
	move	(a0),d0
	subq	#1,(a0)
	bpl.s	T_11B0
	move	-$2(a0),(a0)
T_11B0:	lsl	#2,d0
	lea	2(a0,d0),a0
	move.l	a0,(sp)
T_11B8:	move.l	patch_area_3_p-cref(a6),-(sp)
	move	#10,-(sp)
	trap	#14			;Flopfmt
	tst	d0
	bpl.s	T_11CC
	move	#10,(sp)
	trap	#14			;Flopfmt
T_11CC:	lea	$1A(sp),sp
	tst	d0
	bpl.s	T_11E0
T_11d4:	lea	format_error_alst(pc),a2
	bsr	T_39BE
	bra	T_1324
;
;------------------------------------
;
T_11E0:	bsr	T_2CAA
	cmp.b	#$61,d0
	bne.s	T_11FE
	lea	cancel_this_operation_alst(pc),a2
	bsr	T_39BE
	cmp	#1,d0
	beq	T_1324
	bsr	graf_mouse_busybee
T_11FE:	addq	#1,d6
	cmp	$C8(a6),d6
	beq	T_1178
	move	d7,d0
	addq	#1,d0
	bsr	T_1350
	addq	#1,d7
	cmp	$DE(a6),d7
	bcs	T_1176
	move	d7,d6
	subq	#2,d6
	moveq	#1,d4
	moveq	#0,d5
	moveq	#1,d7
	bsr	T_12CE
	tst	d0
	bmi.s	T_11d4
	move.l	patch_area_3_p-cref(a6),a0
	move	#$500,d0
T_1234:	clr.l	(a0)+
	dbra	d0,T_1234
	move	$CA(a6),d4
	move	$C8(a6),d5
	moveq	#0,d6
	moveq	#1,d7
T_1246:	bsr	T_12d2
	dbra	d5,T_1246
	move	$C8(a6),d5
	moveq	#1,d6
T_1254:	bsr	T_12d2
	dbra	d5,T_1254
	move	$C8(a6),d6
	addq	#2,d6
	move.l	patch_area_3_p-cref(a6),a5
	move.l	#$1000000,d7
	move	#0,-(sp)
	move	d6,-(sp)
	move.l	d7,-(sp)
	pea	(a5)
	move	#$12,-(sp)
	trap	#14			;Protobt
	lea	14(sp),sp
	move	$CA(a6),d0
	rol	#8,d0
	move	d0,$18(a5)
	rol	#8,d0
	tst	$C8(a6)
	beq.s	T_1294
	lsl	#1,d0
T_1294:	mulu	$DE(a6),d0
	move.b	d0,$13(a5)
	lsr	#8,d0
	move.b	d0,$14(a5)
	move.l	#-$14916FB0,(a5)
	move.b	#$F9,$15(a5)
	move	#$55AA,$1FE(a5)
	move	#$1FE,d0
	moveq	#0,d1
T_12BA:	add	0(a5,d0),d1
	subq	#2,d0
	bpl.s	T_12BA
	cmp	#$1234,d1
	bne.s	T_12F0
	addq	#8,$1E(a5)
	bra.s	T_12F0
;
;------------------------------------
;
T_12CE:	moveq	#8,d0
	bra.s	T_12d4
;
;------------------------------------
;
T_12d2:	moveq	#9,d0
T_12d4:	move	d4,-(sp)
	move	d5,-(sp)
	move	d6,-(sp)
	move	d7,-(sp)
	move	$C6(a6),-(sp)
	clr.l	-(sp)
	move.l	patch_area_3_p-cref(a6),-(sp)
	move	d0,-(sp)
	trap	#14
	lea	$14(sp),sp
	rts
;
;----------------------------------------------------------------------------
;
T_12F0:	move.l	#-$6000100,$200(a5)
	move.l	$200(a5),$C00(a5)
	moveq	#7,d4
	moveq	#0,d5
	moveq	#0,d6
	moveq	#1,d7
	bsr.s	T_12d2
	bsr	T_1384
	move.b	$C7(a6),d0
	addi.b	#$41,d0
	moveq	#$11,d7
	bsr	T_35d6
	move	$C6(a6),d7
	bsr	T_32EE
	bsr.s	T_1336
T_1324:	moveq	#$15,d7
	bsr	objc_change_NORMAL
	bsr	graf_mouse_arrow
	moveq	#$12,d0
	bsr.s	T_1380
	bra	T_10d6
;
;------------------------------------
;
T_1336:	move.l	d5,d2
	bsr	T_416E
	lea	disk_room_available_num_s(pc),a0
	moveq	#8,d1
	bsr	T_1BF4
	lea	disk_room_available_alst(pc),a2
	bra	T_39BE
;
;------------------------------------
;
T_134E:	moveq	#0,d0
T_1350:	moveq	#0,d1
	bsr.s	T_1388
	tst	d0
	bne.s	T_1360
T_1358:	moveq	#$12,d0
	bsr.s	T_1380
	moveq	#$14,d0
	bra.s	T_1380
;
;------------------------------------
;
T_1360:	move	$14(a5),d1
	subq	#4,d1
	mulu	#1000,d1
	divu	$DE(a6),d1
	mulu	d0,d1
	divu	#1000,d1
	cmp	#2,d1
	bcs.s	T_1358
	move	d1,$2C(a5)
	moveq	#$13,d0
T_1380:	bra	T_394C
;
;------------------------------------
;
T_1384:	move	#$80,d1
T_1388:	move.l	$36(a6),a5
	lea	$1B0(a5),a5
	move.b	d1,$21(a5)
	move.b	d1,$39(a5)
	rts
;
;----------------------------------------------------------------------------
;
T_139A:	bsr.s	T_13AC
	move	$CC(a6),d0
	cmp	#$52,d0
	beq.s	T_13AA
T_13a6:	move	d0,$DE(a6)
T_13AA:	rts
;
;----------------------------------------------------------------------------
;
T_13AC:	move.l	$36(a6),a0
	move.l	$144(a0),a0
	move.l	(a0),a0
	moveq	#0,d0
T_13B8:	tst.b	(a0)
	beq.s	T_13C8
	mulu	#10,d0
	add.b	(a0)+,d0
	subi.b	#$30,d0
	bra.s	T_13B8
;
;------------------------------------
;
T_13C8:	tst	d0
	beq.s	T_13D8
	cmp	#$14,d0
	bhi.s	T_13a6
	mulu	#10,d0
	bra.s	T_13a6
;
;------------------------------------
;
T_13D8:	lea	T_76CB(pc),a5
	move	#$52,$DE(a6)
	moveq	#13,d7
	bra	T_3926
;
;------------------------------------
;
T_13E8:	bsr	T_4036
	lea	$25E2(a6),a0
	lsl	#1,d5
	move	0(a0,d5),d5
	move.l	patch_area_3_p-cref(a6),a5
	lea	8(a5,d5),a5
	tst.b	13(a5)
	bmi.s	T_140A
	moveq	#13,d7
	bra	objc_change_SELECTED
;
;------------------------------------
;
T_140A:	rts
;
;----------------------------------------------------------------------------
;
T_140C:	move	#-$7d0,$FA(a6)
	bsr	T_2B74
T_1416:	bra	T_4C8
;
;------------------------------------
;
T_141A:	move	$FA(a6),d5
	bmi.s	T_142C
	swap	d6
	move	d5,d6
	add	$E2(a6),d5
	bsr.s	T_13E8
	swap	d6
T_142C:	move	d6,d5
	add	$E2(a6),d5
	cmp	$F8(a6),d5
	bcc.s	T_140C
	move	d6,$FA(a6)
	bsr.s	T_13E8
	btst	#4,13(a5)
	bne.s	T_1452
	tst	$FE(a6)
	bne.s	T_1452
	move.l	a5,-(sp)
	bsr.s	T_1492
	move.l	(sp)+,a5
T_1452:	moveq	#13,d7
	tst	$FE(a6)
	bne.s	T_147A
	bsr	T_2944
	move.l	d7,d0
	swap	d0
	and	#3,d0
	bne	T_16E2
	btst	#21,d7
	bne	T_16E2
	btst	#20,d7
	bne	T_14d6
T_147A:	btst	#4,13(a5)
	bne.s	T_149E
	tst	$128(a6)
	bpl.s	T_1416
	tst	$FE(a6)
T_148C:	bne.s	T_1416
	bra	T_18DA
;
;------------------------------------
;
T_1492:	move.l	ref_fsel_name_p-cref(a6),a4
T_1496:	move.b	(a5)+,(a4)+
	bne.s	T_1496
	bra	T_3a56
;
;------------------------------------
;
T_149E:	tst.b	$1E(a6)
	bne.s	T_148C
	move.l	a5,-(sp)
	bsr	T_3a16
	bsr	T_2606
	move.l	(sp)+,a4
	move.l	a3,a5
	cmpa.l	ref_fsel_path_p-cref(a6),a5
	beq.s	T_14C0
	cmpi.b	#$5C,-$1(a5)
	beq.s	T_14C4
T_14C0:	move.b	#$5C,(a5)+
T_14C4:	move.b	(a4)+,(a5)+
	bne.s	T_14C4
	move.b	#$5C,-$1(a5)
	lea	$130(a6),a4
	bra	T_2654
;
;------------------------------------
;
T_14d6:	tst.b	13(a5)
	bpl	T_1562
	move.l	a5,$1d4(a6)
	bsr	T_1758
	move	$FA(a6),$104(a6)
	moveq	#0,d6
	lea	$2550(a6),a4
	move	#-$1,(a4)+
T_14F6:	move	d6,d0
	add	$E2(a6),d0
	cmp	$F8(a6),d0
	bcc.s	T_157A
	lea	$25E2(a6),a0
	lsl	#1,d0
	move	0(a0,d0),d0
	move.l	patch_area_3_p-cref(a6),a5
	lea	8(a5,d0),a5
	tst.b	13(a5)
	bpl.s	T_1532
	bsr	T_4036
	bsr	objc_offset_sub
	move	d3,(a4)+
	move	d4,(a4)+
	addq	#1,$2550(a6)
	cmp	#$23,$2550(a6)
	beq.s	T_157A
T_1532:	addq	#1,d6
	cmp	$2C(a6),d6
	bcs.s	T_14F6
	bra.s	T_157A
;
;------------------------------------
;
	bsr	T_2B80
	tst	$FE(a6)
	bne	T_4C8
	moveq	#$1B,d7
	bsr	T_2944
	tst	$128(a6)
	bmi	T_FCE
	btst	#20,d7
	beq	T_4C8
	bsr	objc_change_SELECTED
T_1562:	move.l	a5,$1d4(a6)
	bsr	T_1758
	move	d7,$104(a6)
	lea	$2550(a6),a5
	move	#0,(a5)+
	move	d3,(a5)+
	move	d4,(a5)
T_157A:	moveq	#$18,d0
	mulu	d7,d0
	move.l	$32(a6),a5
	lea	$14(a5,d0),a5
	movem.w	(a5)+,d5-d6
	bsr	T_4B50
	clr	$22(a6)
	move	$104(a6),d7
	cmp	#$1B,d7
	bne.s	T_15a0
	bsr	objc_change_NORMAL
T_15a0:	tst	$FE(a6)
	beq.s	T_161C
	cmp	#10,$FE(a6)
	bcs.s	T_1628
	cmp	#15,$FE(a6)
	beq.s	T_1628
	tst.b	$24d5(a6)
	bpl.s	T_15C2
	bsr	T_3310
	beq.s	T_161C
T_15C2:	clr	$18C(a6)
	move	$FE(a6),d7
	cmp	#$21,d7
	beq	T_1D8E
	cmp	#$20,d7
	beq	T_1F0C
	cmp	#$16,d7
	beq	T_1FF8
	cmp	#$11,d7
	beq	T_20B4
	cmp	#$19,d7
	beq	T_2B98
	lea	T_764F(pc),a5
	moveq	#4,d7
	bsr	T_3926
	bsr	objc_change_SELECTED
	move.l	$32(a6),a0
	and	#$1F7,$290(a0)
	and	#$1F7,$110(a0)
	clr	$118(a6)
	moveq	#0,d0
	bsr	T_186E
	bra.s	T_1624
;
;------------------------------------
;
T_161C:	clr	$FE(a6)
	bsr	T_2B80
T_1624:	bra	T_4C8
;
;------------------------------------
;
T_1628:	move	$FE(a6),d7
	move	d7,$DE(a6)
	clr	$FE(a6)
	bsr	objc_change_NORMAL
	tst.b	$24d4(a6)
	bne.s	T_1624
	tst.b	$24d5(a6)
	bmi.s	T_1624
	lea	$2550(a6),a5
	bsr	T_1994
	move	$DE(a6),d7
	cmp	#15,d7
	beq	T_d7E
	bra	T_Dd2
;
;------------------------------------
;
T_165C:	move	d7,$FE(a6)
	bsr	objc_change_SELECTED
	tst	$10A(a6)
	bne.s	T_16B2
	tst	$FA(a6)
	bpl.s	T_1694
T_1670:	moveq	#$1B,d7
	lea	$2550(a6),a5
	bsr	T_3922
	tst.b	$2550(a6)
	bne.s	T_168E
	move	$FE(a6),d7
	clr	$FE(a6)
	bsr	objc_change_NORMAL
	bra.s	T_1624
;
;------------------------------------
;
T_168E:	bsr	T_1758
	bra.s	T_16d6
;
;------------------------------------
;
T_1694:	move	$FA(a6),d0
	add	$E2(a6),d0
	add	d0,d0
	lea	$25E2(a6),a0
	move	0(a0,d0),d0
	move.l	patch_area_3_p-cref(a6),a5
	lea	8(a5,d0),a5
	bsr.s	T_16DA
	bra.s	T_16d6
;
;------------------------------------
;
T_16B2:	move.l	patch_area_3_p-cref(a6),a5
	addq.l	#8,a5
	move	$F8(a6),d0
	beq.s	T_1670
	subq	#1,d0
T_16C0:	tst.b	13(a5)
	bmi.s	T_16d0
	lea	$16(a5),a5
	dbra	d0,T_16C0
	bra.s	T_1670
;
;------------------------------------
;
T_16d0:	bsr.s	T_16DA
	bsr	T_2B80
T_16d6:	bra	T_15a0
;
;------------------------------------
;
T_16DA:	move.l	a5,$1d4(a6)
	bra	T_1758
;
;------------------------------------
;
T_16E2:	not.w	$FA(a6)
	bchg	#7,13(a5)
	beq.s	T_16FE
	moveq	#13,d7
	move.l	$100(a6),a0
	bset	#0,11(a0)
	bsr	objc_change_NORMAL
T_16FE:	bsr.s	T_1704
	bra	T_4C8
;
;------------------------------------
;
T_1704:	clr	$10A(a6)
	move.l	patch_area_3_p-cref(a6),a5
	move	$F8(a6),d5
	beq.s	T_173A
	subq	#1,d5
	moveq	#0,d4
T_1716:	tst.b	$15(a5)
	bpl.s	T_1730
	addq	#1,$10A(a6)
	btst	#4,$15(a5)
	bne.s	T_1730
	move.l	4(a5),d0
	bsr	T_33E2
T_1730:	lea	$16(a5),a5
	dbra	d5,T_1716
	move.l	d4,d2
T_173A:	beq	T_3B0C
	bsr	T_416E
	move.l	a1,a4
	bsr	T_19B0
	lea	$130(a6),a5
	bra	T_3B26
;
;------------------------------------
;
T_1750:	lea	$2550(a6),a4
	clr	d7
	bra.s	T_1764
;
;------------------------------------
;
T_1758:	lea	$24d2(a6),a4
	clr	$140(a6)
	clr	$162(a6)
T_1764:	movem.w	d3-d4/d7,-(sp)
	bsr	T_42D8
	move	d7,4(a4)
	movem.w	(sp)+,d3-d4/d7
	move.l	ref_fsel_path_p-cref(a6),a5
	moveq	#$5C,d2
	bsr	T_3C12
	bpl.s	T_1786
	moveq	#$3A,d2
	bsr	T_3C12
T_1786:	addq	#1,d1
	move	d1,(a4)
	move	d1,$116(a6)
	lea	6(a4),a3
	bra.s	T_179A
;
;------------------------------------
;
T_1794:	move.b	0(a5,d1),0(a3,d1)
T_179A:	dbra	d1,T_1794
	tst	d7
	beq.s	T_1802
	move	(a4),d0
	move	d0,$114(a6)
	lea	0(a3,d0),a5
	clr	2(a4)
	cmp	#$1B,d7
	beq	T_1994
	move.b	#1,3(a4)
	move.l	$1d4(a6),a2
	move.b	13(a2),d1
	bpl.s	T_17CC
	move.b	d1,3(a4)
T_17CC:	cmp.b	#$10,d1
	bne.s	T_17E8
	move	#$100,2(a4)
	tst	d0
	beq.s	T_17E8
	cmpi.b	#$3A,-$1(a5)
	bne.s	T_17E8
	move.b	#$5C,(a5)+
T_17E8:	move.b	(a2)+,(a5)+
	bne.s	T_17E8
	tst.b	2(a4)
	beq.s	T_1802
	move.b	#$5C,-$1(a5)
	move.l	a5,d0
	sub.l	a3,d0
	move	d0,(a4)
	bra	T_3C02
;
;------------------------------------
;
T_1802:	rts
;
;----------------------------------------------------------------------------
;
T_1804:	moveq	#-1,d0
	bsr.s	T_183C
	bclr	#3,$291(a0)
	bclr	#7,$129(a0)
	bra.s	T_1826
;
;------------------------------------
;
T_1816:	moveq	#-1,d0
	bsr.s	T_183C
	bclr	#7,$291(a0)
	bclr	#7,$2A9(a0)
T_1826:	bclr	#7,$2C1(a0)
	bclr	#3,$111(a0)
	bclr	#7,9(a0)
	rts
;
;----------------------------------------------------------------------------
;
T_183A:	moveq	#0,d0
T_183C:	move.l	$32(a6),a0
	bset	#3,$291(a0)
	bset	#3,$111(a0)
	moveq	#$23,d1
T_184E:	cmp	#13,d1
	beq.s	T_1868
	moveq	#$18,d2
	mulu	d1,d2
	bclr	#7,9(a0,d2)
	tst	d0
	beq.s	T_1868
	bset	#7,9(a0,d2)
T_1868:	dbra	d1,T_184E
	rts
;
;----------------------------------------------------------------------------
;
T_186E:	move.l	$32(a6),a0
	lea	$2d0(a0),a0
	moveq	#3,d1
T_1878:	move.b	d0,9(a0)
	lea	$18(a0),a0
	dbra	d1,T_1878
	rts
;
;----------------------------------------------------------------------------
;
	tst	$FE(a6)
	beq.s	T_18a6
	bsr	objc_change_NORMAL
	move	$FE(a6),d7
	cmp	#3,d7
	beq.s	T_18a2
	cmp	#$20,d7
	bne	T_1B26
T_18a2:	bra	T_1A9A
;
;------------------------------------
;
T_18a6:	clr	$DE(a6)
	bra.s	T_18E6
;
;------------------------------------
;
	tst	$FE(a6)
	beq.s	T_18DA
	clr	$22(a6)
	bsr	objc_change_NORMAL
	move	$FE(a6),d7
	cmp	#3,d7
	beq	T_1a3A
	cmp	#$1E,d7
	beq	T_1B4C
	cmp	#$1F,d7
	beq	T_1d3A
	bra	T_1F44
;
;------------------------------------
;
T_18DA:
	moveq	#$1C,d7
	bsr	objc_change_SELECTED
	move	#1,$DE(a6)
T_18E6:
	bsr	T_1990
	bsr	T_2B80
	gemdos	Fsetdta|_ind,$12A(a6)
	bsr	T_3726
	lea	$166(a6),a4
	tst.b	$174(a6)
	bne.s	.T_1918
	tst.b	$175(a6)
	beq.s	.T_1954
	move.l	#$800080,(a4)
	move.l	(a4),4(a4)
.T_1918:
	move.l	(a4),d0
	sub.l	d0,4(a4)
	lea	UIS_contrl(pc),a0
	move.l	#$330009,(a0)+		;form_dial
	move.l	#$10001,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	#3,(a0)+		;release area
	lea	(a4),a1
	move.l	(a1)+,(a0)+
	move.l	(a1),(a0)+
	lea	(a4),a1
	move.l	(a1)+,(a0)+
	move.l	(a1),(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	move	UIS_intout(pc),d0
.T_1954:
	bsr	T_386A
	bsr	T_300E
	clr	d5
	bsr	wind_update_d5_2_plus_d5
	move.l	(sp),a0
	move.l	12(a0),a0
	move	#1,(a0)+
	move	$DE(a6),(a0)
	movem.l	(sp)+,d1-d7/a1-a6
	rts
;
;----------------------------------------------------------------------------
;
T_1976:	tst	$11A(a6)
	bpl.s	T_198E
	move.l	$11C(a6),a0
	clr	$11A(a6)
T_1984:	pea	(a0)
	move	#$49,-(sp)
	trap	#1			;Mfree
	addq.l	#6,sp
T_198E:	rts
;
;----------------------------------------------------------------------------
;
T_1990:	move.l	ref_fsel_name_p-cref(a6),a5
T_1994:	moveq	#$1B,d7
T_1996:	move.l	a5,a4
	bsr	T_3922
T_199C:	lea	12(a4),a5
	moveq	#3,d0
T_19a2:	move.b	-(a5),1(a5)
	dbra	d0,T_19a2
	move.b	#$2E,8(a4)
T_19B0:	cmpi.b	#$20,(a4)
	bne.s	T_19C0
	move.l	a4,a5
T_19B8:	move.b	1(a5),(a5)+
	bne.s	T_19B8
	bra.s	T_19B0
;
;------------------------------------
;
T_19C0:	tst.b	(a4)+
	bne.s	T_19B0
	cmpi.b	#$2E,-$2(a4)
	bne.s	T_19d0
	clr.b	-$2(a4)
T_19d0:	rts
;
;----------------------------------------------------------------------------
;
T_19d2:	move.l	a5,a4
T_19d4:	cmpi.b	#$5C,(a4)+
	beq.s	T_19E2
	tst.b	-$1(a4)
	bne.s	T_19d4
	rts
;
T_19E2:	addq	#1,d7
	bra.s	T_19d4
;
;----------------------------------------------------------------------------
;
	move	d7,$FE(a6)
	bsr	objc_change_SELECTED
	moveq	#0,d7
	move.l	ref_fsel_path_p-cref(a6),a5
	bsr.s	T_19d2
	cmpi.b	#$3A,1(a5)
	beq.s	T_1a12
	lea	$2550(a6),a5
	gemdos	Dgetpath,(a5),#0
	bsr.s	T_19d2
T_1a12:	cmp	#9,d7
	bcs.s	T_1a24
	lea	folder_nesting_limit_alst(pc),a2
	bsr	T_39BE
	bra	T_1B02
;
;------------------------------------
;
T_1a24:	bsr	T_2B74
	lea	T_761B(pc),a5
T_1a2C:	moveq	#$1A,d7
	bsr	T_3926
	bsr	T_1816
	bra	T_4C8
;
;------------------------------------
;
T_1a3A:	bsr	T_183A
	bsr	T_2606
	lea	$24D8(a6),a5
	move.l	ref_fsel_path_p-cref(a6),a4
T_1a4A:	cmpa.l	a4,a3
	beq.s	T_1a52
	move.b	(a4)+,(a5)+
	bra.s	T_1a4A
;
;------------------------------------
;
T_1a52:	cmpa.l	ref_fsel_path_p-cref(a6),a4
	beq.s	T_1a64
	cmpi.b	#$5C,-$1(a5)
	beq.s	T_1a64
	move.b	#$5C,(a5)+
T_1a64:	bsr	T_1994
	lea	$24D8(a6),a5
	moveq	#0,d0
T_1a6E:	addq	#1,d0
	tst.b	(a5)+
	bne.s	T_1a6E
	move	d0,$24d2(a6)
	bsr	graf_mouse_busybee
	lea	$24d2(a6),a5
	move	#-$1,$18C(a6)
	clr	$10C(a6)
	bsr	T_2324
	tst	$10C(a6)
	bpl	T_1A9A
	bsr	T_253A
T_1A9A:	bsr	T_183A
	lea	T_7628(pc),a5
	moveq	#$1A,d7
T_1Aa4:	cmp	#0,$DC(a6)
	beq.s	T_1AE4
	movem.l	d7/a5,-(sp)
	lea	UIS_contrl(pc),a0
	move.l	#$180002,(a0)+		;evnt_timer
	move.l	#$10000,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move.l	#1000<<16,(a0)		;1 second delay
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	lea	$82(a6),a2
	bsr	T_3586
	movem.l	(sp)+,d7/a5
T_1AE4:	bsr	T_3926
	bsr	objc_change_NORMAL
	clr.b	$106(a6)
	move	#-$7d0,$FA(a6)
	bsr	T_2B74
	clr	$18C(a6)
	clr	$108(a6)
T_1B02:	bsr	T_3a16
	move	$FE(a6),d7
	beq.s	T_1B10
	bsr	objc_change_NORMAL
T_1B10:	move	#$190,$18E(a6)
	bsr	T_3C4E
	clr	$FE(a6)
	bsr	T_1704
	bra	T_49C
;
;------------------------------------
;
T_1B26:	move.l	$32(a6),a0
	or	#8,$290(a0)
	or	#8,$110(a0)
	moveq	#$41,d0
	bsr	T_186E
	move	#$1B,$118(a6)
	lea	T_7642(pc),a5
	moveq	#4,d7
	bra	T_1Aa4
;
;------------------------------------
;
T_1B4C:	bsr	T_1CEA
	bsr	T_23FE
	lea	$24d2(a6),a5
	lea	$2550(a6),a4
	move	4(a5),d0
	cmp	4(a4),d0
	beq	T_1C10
	clr	$10C(a6)
	move.l	$180(a6),$188(a6)
T_1B72:	bsr	T_22BE
	beq.s	T_1B8A
	bsr	T_1d62
	bne.s	T_1B26
	tst.b	$24d5(a6)
	bpl.s	T_1B8A
	tst	$10C(a6)
	bpl.s	T_1B72
T_1B8A:	move	$10C(a6),d2
	bmi.s	T_1BC0
	bne.s	T_1Bd2
T_1B92:	bsr	T_2402
	clr	$112(a6)
	move.l	$188(a6),$180(a6)
	move	#0,$DC(a6)
	bsr	T_4360
T_1BAA:	bsr	T_22BE
	beq.s	T_1BBC
	bsr	T_1Dd4
	bmi.s	T_1BBC
	tst.b	$24d5(a6)
	bmi.s	T_1BAA
T_1BBC:	bra	T_1B26
;
;------------------------------------
;
T_1BC0:	cmp	#-$2,$10C(a6)
	beq.s	T_1BBC
	lea	move_copy_aborted_on_conflict_alst(pc),a2
	bsr	T_39BE
	bra.s	T_1BBC
;
;------------------------------------
;
T_1Bd2:	bsr	T_416E
	lea	name_conflict_count_num_s(pc),a0
	addq.l	#5,a1
	moveq	#3,d1
	bsr.s	T_1BF4
	lea	name_conflict_delete_query_alst(pc),a2
	bsr	T_39BE
	cmp	#2,d0
	beq	T_1B26
	bra	T_1B92
;
;------------------------------------
;
T_1BF4:	move.b	(a1)+,d0
	beq.s	T_1C06
	cmp.b	#$20,d0
	beq.s	T_1BF4
	move.b	d0,(a0)+
	dbra	d1,T_1BF4
	rts
;
;----------------------------------------------------------------------------
;
T_1C06:	move.b	#$20,(a0)+
	dbra	d1,T_1C06
	rts
;
;----------------------------------------------------------------------------
;
T_1C10:	clr	$10C(a6)
	bsr	T_22BE
	beq.s	T_1C42
	bsr	T_23FE
	move	#1,$108(a6)
	tst.b	$24d4(a6)
	bne.s	T_1C46
	bsr	T_446C
	bsr	T_253A
T_1C32:	bmi.s	T_1C42
	tst	$10C(a6)
	bmi	T_1BC0
	tst.b	$24d5(a6)
	bmi.s	T_1C10
T_1C42:	bra	T_1B26
;
;------------------------------------
;
T_1C46:	bsr	T_1d08
	bmi.s	T_1C42
	bsr.s	T_1C50
	bra.s	T_1C32
;
;------------------------------------
;
T_1C50:	bsr	T_241E
	lea	$2550(a6),a4
	move	(a4),d7
T_1C5A:	move.b	6(a5,d0),6(a4,d7)
	cmpi.b	#$2A,6(a5,d0)
	beq.s	T_1C6E
	addq	#1,d0
	addq	#1,d7
	bra.s	T_1C5A
;
;------------------------------------
;
T_1C6E:	move	d0,(a5)
	move	d7,(a4)
	cmp	#1,$108(a6)
	bne.s	T_1CB6
	tst.b	$d1(a6)
	bpl.s	T_1CB6
	clr.b	5(a5,d0)
	clr.b	5(a4,d7)
	pea	$2556(a6)
	pea	$24D8(a6)
	clr	-(sp)
	move	#$56,-(sp)
	trap	#1			;Frename
	lea	12(sp),sp
	move	(a5),d1
	move.b	#$5C,5(a5,d1)
	move.b	#$5C,5(a4,d7)
	tst.l	d0
	bmi.s	T_1CB6
	bsr	T_43BA
	moveq	#0,d0
	rts
;
;----------------------------------------------------------------------------
;
T_1CB6:	clr.b	5(a4,d7)
	move.l	a4,a5
	bsr	T_2324
	bmi.s	T_1CE8
T_1CC2:	bsr	T_446C
	tst	$10C(a6)
	bmi.s	T_1CE8
	bsr	T_243C
	bmi.s	T_1CE8
	bne.s	T_1CC2
	tst	$108(a6)
	beq.s	T_1CE8
	bsr	T_2402
	move	#-$1,$18C(a6)
	bra	T_1Dd4
;
;------------------------------------
;
T_1CE8:	rts
;
;----------------------------------------------------------------------------
;
T_1CEA:	bsr	T_3E68
	bsr	T_221C
	bsr	T_1750
	bsr.s	T_1d08
	beq.s	T_1d00
	addq.l	#4,sp
	bra	T_1B26
;
;------------------------------------
;
T_1d00:	bsr	T_4360
	bra	graf_mouse_busybee
;
;------------------------------------
;
T_1d08:	lea	$24D8(a6),a5
	tst.b	-$4(a5)
	beq.s	T_1d36
	move	-$6(a5),d0
	lea	$2556(a6),a4
	cmp	-$6(a4),d0
	bhi.s	T_1d36
	subq	#1,d0
T_1d22:	cmpm.b	(a5)+,(a4)+
	bne.s	T_1d36
	dbra	d0,T_1d22
	lea	move_copy_operation_illegal_alst(pc),a2
	bsr	T_39BE
	moveq	#-1,d0
	rts
;
;----------------------------------------------------------------------------
;
T_1d36:	moveq	#0,d0
	rts
;
;----------------------------------------------------------------------------
;
T_1d3A:	bsr.s	T_1CEA
	clr	$10C(a6)
T_1d40:	bsr	T_22BE
	beq.s	T_1d5E
	bsr	T_1d08
	bmi.s	T_1d5E
	bsr.s	T_1d62
	bmi.s	T_1d5E
	tst	$10C(a6)
	bmi	T_1BC0
	tst.b	$24d5(a6)
	bmi.s	T_1d40
T_1d5E:	bra	T_1B26
;
;------------------------------------
;
T_1d62:	clr	$108(a6)
	lea	$24d2(a6),a5
	tst.b	2(a5)
	bne.s	T_1d78
	bsr	T_446C
	bra	T_253A
;
;------------------------------------
;
T_1d78:	bra	T_1C50
;
;------------------------------------
;
T_1d7C:	ext.l	d2
	bsr	T_416E
	move.l	4(a1),(a4)
	move.b	8(a1),4(a4)
	rts
;
;----------------------------------------------------------------------------
;
T_1D8E:	bsr	T_3E68
	bsr	T_221C
	move	$180(a6),d2
	lea	Delete_folder_count_s(pc),a4
	bsr.s	T_1d7C
	move	$182(a6),d2
	lea	Delete_file_count_s(pc),a4
	bsr.s	T_1d7C
	lea	Delete_certain_query_alst(pc),a2
	bsr	T_39BE
	cmp	#2,d0
	beq.s	T_1Dd0
	bsr	T_1750
	bsr	T_4360
T_1DC0:	bsr	T_22BE
	beq.s	T_1Dd0
	bsr.s	T_1Dd4
	bmi.s	T_1Dd0
	tst.b	$24d5(a6)
	bmi.s	T_1DC0
T_1Dd0:	bra	T_1B26
;
;------------------------------------
;
T_1Dd4:	move	#-$1,$108(a6)
	lea	$24d2(a6),a5
	tst.b	2(a5)
	bne.s	T_1DEC
	bsr	T_446C
	bra	T_253A
;
;------------------------------------
;
T_1DEC:	bsr	T_446C
	bsr	T_243C
	bmi.s	T_1E18
	bne.s	T_1DEC
	move	$24d2(a6),d0
	add	#$24d7,d0
	clr.b	0(a6,d0)
	pea	$24D8(a6)
	move	#$3A,-(sp)
	trap	#1			;Ddelete
	addq.l	#6,sp
	move	d0,d1
	bsr	T_43BA
	move	d1,d0
T_1E18:	clr	$18C(a6)
	tst	d0
	rts
;
;----------------------------------------------------------------------------
;
	move	d7,$FE(a6)
	bsr	objc_change_SELECTED
	bsr	T_3E68
	bsr	T_1990
	move.l	ref_fsel_name_p-cref(a6),a0
	tst.b	(a0)
	beq	T_1EC4
	moveq	#0,d7
	bsr	T_1758
	move	#$100,2(a4)
	move	(a4),d0
	lea	6(a4,d0),a5
	tst	d0
	beq.s	T_1E5E
	cmpi.b	#$5C,-$1(a5)
	bne.s	T_1E5E
	bsr	T_3C02
	bra.s	T_1E64
;
;------------------------------------
;
T_1E5E:	addq	#1,(a4)
	bsr	T_3BFE
T_1E64:	bsr	T_1750
	move	#4,$108(a6)
	clr	$10C(a6)
T_1E72:	lea	$24D8(a6),a5
	move	$24d2(a6),d0
	clr.b	0(a5,d0)
	bsr	T_3a1A
	lea	$24D8(a6),a5
	move	$24d2(a6),d0
	move.b	#$2A,0(a5,d0)
	bsr	T_2CAA
	cmp.b	#$61,d0
	bne.s	T_1EA8
	lea	cancel_this_operation_alst(pc),a2
	bsr	T_39BE
	cmp	#1,d0
	beq.s	T_1EC4
T_1EA8:	bsr	T_446C
	tst	$10C(a6)
	bmi.s	T_1EC4
	bne.s	T_1EC8
	bsr	T_243C
	bmi.s	T_1EC4
	bne.s	T_1E72
	lea	no_file_match_found_alst(pc),a2
	bsr	T_39BE
T_1EC4:	bra	T_1B02
;
;------------------------------------
;
T_1EC8:	clr	$E6(a6)
	lea	$24D8(a6),a5
	move	$24d2(a6),d0
	lea	0(a5,d0),a5
	bsr	T_1492
	move.l	ref_fsel_path_p-cref(a6),a5
	moveq	#$5C,d2
	bsr	T_3C12
	bpl.s	T_1EEE
	moveq	#$3A,d2
	bsr	T_3C12
T_1EEE:	lea	1(a5,d1),a5
	lea	$24D8(a6),a4
	move	-$6(a4),d0
	lea	0(a4,d0),a3
T_1EFE:	move.b	(a5)+,(a3)+
	bne.s	T_1EFE
	move.l	ref_fsel_path_p-cref(a6),a5
T_1F06:	move.b	(a4)+,(a5)+
	bne.s	T_1F06
	bra.s	T_1EC4
;
;------------------------------------
;
T_1F0C:	bsr	T_3E68
	tst.b	$24d5(a6)
	bmi	T_1B26
	tst.b	$24d4(a6)
	beq.s	T_1F3C
	move	$FA(a6),d0
	add	$E2(a6),d0
	lsl	#1,d0
	lea	$25E2(a6),a0
	move	0(a0,d0),d0
	move.l	patch_area_3_p-cref(a6),a5
	lea	8(a5,d0),a5
	bsr	T_3a5A
T_1F3C:	lea	T_7635(pc),a5
	bra	T_1a2C
;
;------------------------------------
;
T_1F44:	bsr	T_183A
	lea	T_7628(pc),a5
	moveq	#$1A,d7
	bsr	T_3926
	bsr	T_1990
	lea	$24d2(a6),a0
	tst.b	2(a0)
	beq.s	T_1F7A
	tst.b	$d1(a6)
	beq.s	T_1F7A
	move	(a0),d0
	clr.b	5(a0,d0)
	clr	$18C(a6)
	move.l	#$10000,$180(a6)
	bra.s	T_1F7E
;
;------------------------------------
;
T_1F7A:	bsr	T_221C
T_1F7E:	bsr	T_4360
T_1F82:	move	#2,$108(a6)
	lea	$24d2(a6),a5
	lea	$2550(a6),a4
	move.l	(a5)+,(a4)+
	move	(a5)+,(a4)+
T_1F94:	move.b	(a5)+,(a4)+
	bne.s	T_1F94
	lea	$24d2(a6),a5
	tst.b	2(a5)
	bne.s	T_1FAE
	bsr	T_446C
	bsr	T_253A
T_1FAA:	bra	T_1B26
;
;------------------------------------
;
T_1FAE:	bsr	T_2424
	move.l	ref_fsel_name_p-cref(a6),a0
	lea	6(a5,d0),a1
T_1FBA:	addq	#1,d0
	move.b	(a0)+,(a1)+
	bne.s	T_1FBA
	move	d0,(a5)
	tst.b	$d1(a6)
	beq.s	T_1FDE
	pea	$2556(a6)
	pea	$24D8(a6)
	clr	-(sp)
	move	#$56,-(sp)
	trap	#1			;Frename
	lea	12(sp),sp
	bra.s	T_1FAA
;
;------------------------------------
;
T_1FDE:	bsr	T_2324
	bmi.s	T_1FAA
	move	#1,$108(a6)
	bsr	T_23FE
	clr	$10C(a6)
	bsr	T_1CC2
	bra.s	T_1FAA
;
;------------------------------------
;
T_1FF8:	bsr	T_3E68
	clr	$DA(a6)
	move	#4,$DC(a6)
	moveq	#5,d7
T_2008:	bsr	objc_change_NORMAL
	addq	#1,d7
	cmp	#10,d7
	bcs.s	T_2008
	lea	$24d2(a6),a5
	move	(a5),d0
	lea	6(a5,d0),a5
	lea	$130(a6),a4
	moveq	#1,d1
	bsr	T_3a6C
	lea	$130(a6),a5
	moveq	#3,d7
	bsr	T_3926
	bsr	T_357C
	bsr	T_42a2
	cmp	#10,$DE(a6)
	bne	T_1B26
	clr	d1
	move.l	$42(a6),a0
	lea	$E3(a0),a0
	moveq	#4,d0
T_2050:	lsl	#1,d1
	tst.b	(a0)
	beq.s	T_2058
	addq	#1,d1
T_2058:	lea	-$18(a0),a0
	dbra	d0,T_2050
	move	d1,$B2(a6)
	beq.s	T_2090
	bsr	T_221C
	bsr	T_4360
	move	#3,$108(a6)
	move	#1,$2550(a6)
	move.b	#$5C,$2556(a6)
T_2080:	bsr	T_22BE
	beq.s	T_2090
	bsr.s	T_2094
	bmi.s	T_2090
	tst.b	$24d5(a6)
	bmi.s	T_2080
T_2090:	bra	T_1B26
;
;------------------------------------
;
T_2094:	tst.b	$24d4(a6)
	bne.s	T_20a2
	bsr	T_446C
	bra	T_253A
;
;------------------------------------
;
T_20a2:	bsr	T_43BA
T_20a6:	bsr	T_446C
	bsr	T_243C
	bmi.s	T_20B2
	bne.s	T_20a6
T_20B2:	rts
;
;----------------------------------------------------------------------------
;
T_20B4:	bsr	T_3E68
	moveq	#$11,d7
	lea	$24d2(a6),a5
	tst.b	2(a5)
	beq.s	T_20CC
	bsr	objc_change_NORMAL
	bra	T_3426
;
;------------------------------------
;
T_20CC:	cmpi.b	#1,3(a5)
	beq	T_2118
	bsr	T_221C
	moveq	#3,d7
	lea	$18C(a6),a4
T_20E0:	move.l	-(a4),d2
	cmp	#1,d7
	bhi.s	T_20EE
	lea	2(a4),a4
	ext.l	d2
T_20EE:	bsr	T_416E
	move	d7,d0
	mulu	#$15,d0
	lea	room_needed_alst(pc),a0
	lea	0(a0,d0),a0
	moveq	#8,d0
T_2102:	move.b	(a1)+,(a0)+
	dbra	d0,T_2102
	dbra	d7,T_20E0
	lea	room_needed_alst(pc),a2
	bsr	T_39BE
T_2114:	bra	T_1B26
;
;------------------------------------
;
T_2118:	move	#7,-(sp)
	pea	$24D8(a6)
	move	#$4E,-(sp)
	trap	#1			;Fsfirst
	addq.l	#8,sp
	tst	d0
	bne.s	T_2114
	move	#7,$DC(a6)
	clr	$DA(a6)
	lea	$1B2(a6),a5
	lea	$130(a6),a4
	moveq	#0,d1
	bsr	T_3a6C
	lea	$130(a6),a5
	moveq	#2,d7
	bsr	T_3926
	move.l	$1AE(a6),d2
	moveq	#4,d7
	moveq	#1,d4
	bsr	T_359E
	lea	$1AA(a6),a3
	lea	$1C0(a6),a4
	bsr	T_40F4
	lea	$1C0(a6),a5
	moveq	#6,d7
	bsr	T_3926
	moveq	#8,d7
T_2172:	bsr	objc_change_NORMAL
	addq	#1,d7
	cmp	#13,d7
	bcs.s	T_2172
	moveq	#8,d7
	btst	#0,$1A9(a6)
	beq.s	T_218A
	addq	#1,d7
T_218A:	bsr	objc_change_SELECTED
	moveq	#10,d7
	btst	#1,$1A9(a6)
	beq.s	T_219A
	addq	#1,d7
T_219A:	bsr	objc_change_SELECTED
	bsr	T_357C
	cmp	#13,$DE(a6)
	bne	T_1B26
	move.l	$4E(a6),a4
	moveq	#0,d7
	tst.b	$CB(a4)
	bne.s	T_21BA
	addq	#1,d7
T_21BA:	tst.b	$FB(a4)
	bne.s	T_21C2
	addq	#2,d7
T_21C2:	move	d7,-(sp)
	move	#1,-(sp)
	pea	$24D8(a6)
	move	#$43,-(sp)
	trap	#1			;Fattrib
	lea	10(sp),sp
	tst.b	$12B(a4)
	beq.s	T_21E0
	bsr	T_46a0
T_21E0:	move	#7,$DC(a6)
	moveq	#2,d7
	move.l	ref_fsel_name_p-cref(a6),a5
	bsr	T_1996
	move	#0,$DC(a6)
	lea	$24d2(a6),a5
	move	(a5),d0
	lea	6(a5,d0),a5
	move.l	ref_fsel_name_p-cref(a6),a4
T_2204:	cmpm.b	(a5)+,(a4)+
	bne.s	T_2212
	tst.b	-$1(a5)
	bne.s	T_2204
	bra	T_1B26
;
;------------------------------------
;
T_2212:	move	#-$1,$18C(a6)
	bra	T_1F82
;
;------------------------------------
;
T_221C:	clr	$18C(a6)
	lea	$24D8(a6),a0
	lea	$2550(a6),a1
	move.l	a1,a5
T_222A:	move.b	(a0)+,(a1)+
	bne.s	T_222A
	move	$24d2(a6),d0
	lea	0(a5,d0),a5
	tst.b	$24d5(a6)
	bpl	T_2284
	move	$10A(a6),d7
	subq	#1,d7
	move.l	$10E(a6),a4
T_2248:	move	d7,d0
	mulu	#14,d0
	lea	0(a4,d0),a0
	btst	#4,13(a0)
	beq.s	T_227E
	move.l	a5,a1
T_225C:	move.b	(a0)+,(a1)+
	bne.s	T_225C
	movem.l	d7/a4-a5,-(sp)
	moveq	#0,d3
	bsr	T_3626
	add	d6,$180(a6)
	add	d7,$182(a6)
	add.l	d5,$184(a6)
	add.l	d4,$188(a6)
	movem.l	(sp)+,d7/a4-a5
T_227E:	dbra	d7,T_2248
	rts
;
;----------------------------------------------------------------------------
;
T_2284:	tst.b	$24d4(a6)
	beq.s	T_2292
	clr.b	-$1(a5)
	moveq	#0,d3
	bra.s	T_229E
;
;------------------------------------
;
T_2292:	moveq	#0,d6
	moveq	#1,d7
	tst.b	$24d5(a6)
	bne.s	T_22a2
	moveq	#-1,d3
T_229E:	bsr	T_3626
T_22a2:	move	d6,$180(a6)
	move	d7,$182(a6)
	move.l	d5,$184(a6)
	move.l	d4,$188(a6)
	tst.b	$24d4(a6)
	beq.s	T_22BC
	addq	#1,$180(a6)
T_22BC:	rts
;
;----------------------------------------------------------------------------
;
T_22BE:	lea	$24d2(a6),a4
	tst.b	3(a4)
	bpl.s	T_2320
	move	$116(a6),$2550(a6)
	move	$114(a6),d0
	move	d0,(a4)
	lea	6(a4,d0),a5
	move	$112(a6),d7
	addq	#1,$112(a6)
	cmp	$10A(a6),d7
	beq.s	T_2322
	move.l	$10E(a6),a0
	mulu	#14,d7
	lea	0(a0,d7),a0
	clr.b	2(a4)
	btst	#4,13(a0)
	beq.s	T_2304
	move.b	#1,2(a4)
T_2304:	move.b	(a0)+,(a5)+
	bne.s	T_2304
	tst.b	2(a4)
	beq.s	T_2320
	move.b	#$5C,-$1(a5)
	move.l	a5,d0
	sub.l	a4,d0
	move	d0,(a4)
	subq	#6,(a4)
	bsr	T_3C02
T_2320:	moveq	#-1,d0
T_2322:	rts
;
;----------------------------------------------------------------------------
;
T_2324:	move	#$17,-(sp)
	pea	6(a5)
	move	#$4E,-(sp)
	trap	#1			;Fsfirst
	addq.l	#8,sp
	tst	d0
	beq.s	T_2358
	pea	6(a5)
	move	#$39,-(sp)
	trap	#1			;Dcreate
	addq.l	#6,sp
	tst	d0
	bmi	T_23F6
T_234A:	bsr	T_43BA
	move	(a5),d0
	move.b	#$5C,5(a5,d0)
	rts
;
;----------------------------------------------------------------------------
;
T_2358:	cmpi.b	#$10,$1A9(a6)
	bne.s	T_23a0
	tst.b	$163(a6)
	bne.s	T_234A
	move	$162(a6),d0
	rol	#8,d0
	move	d0,$162(a6)
	move	(a5),-(sp)
	bsr	T_2428
	move.l	a5,-(sp)
	lea	6(a5,d0),a5
	lea	T_7677(pc),a0
	move	#$C0,d0
	bsr	T_47C6
	move	$162(a6),d0
	rol	#8,d0
	move	d0,$162(a6)
	move.l	(sp)+,a5
	move	(sp)+,d0
	tst.b	$163(a6)
	beq.s	T_23C4
	move	d0,(a5)
	bra.s	T_234A
;
;------------------------------------
;
T_23a0:	bsr	T_2428
	move.l	a5,-(sp)
	move	$162(a6),-(sp)
	clr	$162(a6)
	lea	6(a5,d0),a5
	lea	T_7677(pc),a0
	move	#$80,d0
	bsr	T_47C6
	move	(sp)+,$162(a6)
	move.l	(sp)+,a5
T_23C4:	lea	$130(a6),a1
	move	(a5),d0
	lea	6(a5,d0),a2
	moveq	#0,d1
	tst.b	(a1)
	beq.s	T_23F6
T_23d4:	cmpm.b	(a1)+,(a2)+
	beq.s	T_23DA
	moveq	#-1,d1
T_23DA:	addq	#1,(a5)
	move.b	-$1(a1),-$1(a2)
	bne.s	T_23d4
	move	$DE(a6),d0
	cmp	#6,d0
	bne	T_23F6
	tst	d1
	bmi	T_2324
T_23F6:	move	#-$1,$10C(a6)
	rts
;
;----------------------------------------------------------------------------
;
T_23FE:	clr	d0
	bra.s	T_2404
;
;------------------------------------
;
T_2402:	moveq	#-1,d0
T_2404:	lea	$24d2(a6),a5
	lea	$25CE(a6),a4
	move	(a5),d1
	lea	6(a5,d1),a5
	tst	d0
	beq.s	T_2418
	exg	a5,a4
T_2418:	move.b	(a5)+,(a4)+
	bne.s	T_2418
	rts
;
;----------------------------------------------------------------------------
;
T_241E:	lea	$24d2(a6),a5
	bra.s	T_2428
;
;------------------------------------
;
T_2424:	lea	$2550(a6),a5
T_2428:	move	(a5),d0
	subq	#2,d0
T_242C:	cmpi.b	#$5C,6(a5,d0)
	dbeq	d0,T_242C
	addq	#1,d0
	move	d0,(a5)
	rts
;
;----------------------------------------------------------------------------
;
T_243C:	cmp	#-$21,d0
	beq.s	T_244A
	cmp	#-$31,d0
	bne	T_253A
T_244A:	tst.b	d7
	beq	T_2502
	addq	#1,$140(a6)
	move	$140(a6),d0
	add	#$141,d0
	move.b	d7,0(a6,d0)
T_2460:	move	$140(a6),d0
	add	#$141,d0
	move.b	0(a6,d0),d7
	beq	T_24FA
	subq.b	#1,0(a6,d0)
	lea	$24d2(a6),a4
	move	(a4),d6
	lea	6(a4,d6),a5
	bsr	T_3C02
	move	#$10,-(sp)
	pea	6(a4)
	move	#$4E,-(sp)
	trap	#1			;Fsfirst
	addq.l	#8,sp
	bra.s	T_249C
;
;------------------------------------
;
T_2494:	move	#$4F,-(sp)
	trap	#1			;Fsnext
	addq.l	#2,sp
T_249C:	tst	d0
	bne.s	T_2460
	cmpi.b	#$10,$1A9(a6)
	bne.s	T_2494
	lea	$1B2(a6),a1
	cmpi.b	#$2E,(a1)
	beq.s	T_2494
	subq.b	#1,d7
	bne.s	T_2494
	lea	6(a4,d6),a5
	lea	$2550(a6),a2
	move	(a2),d0
	lea	6(a2,d0),a3
T_24C4:	addq	#1,(a4)
	addq	#1,(a2)
	move.b	(a1),(a3)+
	move.b	(a1)+,(a5)+
	bne.s	T_24C4
	move.b	#$5C,-$1(a5)
	bsr	T_3C02
	cmp	#-$1,$108(a6)
	beq.s	T_24F2
	cmp	#3,$108(a6)
	bcc.s	T_24EE
	move.l	a2,a5
	bra	T_2324
;
;------------------------------------
;
T_24EE:	bsr	T_43BA
T_24F2:	move.b	#$5C,-$1(a3)
T_24F8:	rts
;
;----------------------------------------------------------------------------
;
T_24FA:	subq	#1,$140(a6)
	beq.s	T_24F8
	bra.s	T_2508
;
;------------------------------------
;
T_2502:	tst	$140(a6)
	beq.s	T_24F8
T_2508:	move	$24d2(a6),d0
	add	#$24d7,d0
	clr.b	0(a6,d0)
	bsr	T_241E
	bsr	T_2424
	cmp	#-$1,$108(a6)
	bne	T_2460
	pea	$24D8(a6)
	move	#$3A,-(sp)
	trap	#1			;Ddelete
	addq.l	#6,sp
	bsr	T_43BA
	bra	T_2460
;
;------------------------------------
;
T_253A:	cmp	#-$21,d0
	beq.s	T_2570
	cmp	#-$31,d0
	beq.s	T_2570
	tst	d0
	beq.s	T_2570
	lea	not_enough_room_alst(pc),a2
	cmp	#-$27,d0
	beq.s	T_2568
	lea	access_impossible_alst(pc),a2
	cmp	#-$24,d0
	beq.s	T_2568
	lea	bad_pathname_alst(pc),a2
	cmp	#-$22,d0
	bne.s	T_256C
T_2568:	bsr	T_39BE
T_256C:	moveq	#-1,d0
	rts
;
;----------------------------------------------------------------------------
;
T_2570:	moveq	#0,d0
	rts
;
;----------------------------------------------------------------------------
;
	move.l	$32(a6),a5
	mulu	#$18,d7
	move.b	12(a5,d7),d7
	subi.b	#$41,d7
	ext.w	d7
	move	d7,$EC(a6)
	btst	#1,$12F(a6)
	beq.s	T_25a0
	cmp	#1,d7
	bhi.s	T_25a0
	move	d7,ref_mediach_flag-cref(a6)
	st	$128(a6)
T_25a0:	move.l	ref_fsel_path_p-cref(a6),a4
	lea	$2550(a6),a5
	bsr.s	T_2600
	move	$EC(a6),d0
	addi.b	#$41,d0
	lea	$1DE(a6),a4
	move.l	ref_fsel_path_p-cref(a6),a5
	tst	$128(a6)
	bmi.s	T_25CC
	cmp.b	(a4),d0
	bne.s	T_25CC
	move	$1DC(a6),$E6(a6)
	bra.s	T_25E6
;
;------------------------------------
;
T_25CC:	bsr.s	T_2606
	move.l	ref_fsel_path_p-cref(a6),a5
	move.b	$ED(a6),(a5)
	addi.b	#$41,(a5)+
	move.b	#$3A,(a5)+
	move.b	#$5C,(a5)+
	lea	$130(a6),a4
T_25E6:	bsr.s	T_2600
	lea	$2550(a6),a4
	lea	$1DE(a6),a5
	bsr.s	T_2600
	move	$E2(a6),$1DC(a6)
	bsr	T_42a2
	bra	T_Da0
;
;------------------------------------
;
T_2600:	move.b	(a4)+,(a5)+
	bne.s	T_2600
	rts
;
;----------------------------------------------------------------------------
;
T_2606:	bsr.s	T_2624
	bmi.s	T_261A
T_260A:	lea	1(a5,d1),a5
T_260E:	lea	$130(a6),a4
	move.l	a5,a3
T_2614:	move.b	(a5)+,(a4)+
	bne.s	T_2614
	rts
;
;----------------------------------------------------------------------------
;
T_261A:	moveq	#$3A,d2
	bsr	T_3C12
	bpl.s	T_260A
	bra.s	T_260E
;
;------------------------------------
;
T_2624:	bsr	T_3B60
	move.l	ref_fsel_path_p-cref(a6),a5
	move.l	a5,a4
	moveq	#$5C,d2
	bra	T_3C12
;
;------------------------------------
;
	bsr	objc_change_NORMAL
T_2638:	bsr.s	T_2624
	bmi.s	T_26a0
	beq.s	T_2660
	lea	0(a5,d1),a4
	clr.b	(a4)
	bsr	T_3C12
	move.b	#$5C,(a4)
	tst	d1
	bmi.s	T_26a0
	lea	0(a5,d1),a5
T_2654:	move.b	(a4)+,(a5)+
	bne.s	T_2654
T_2658:	bsr	T_3a16
	bra	T_29DA
;
;------------------------------------
;
T_2660:	addq.l	#1,a5
T_2662:	lea	$130(a6),a4
T_2666:	move.b	(a5)+,(a4)+
	bne.s	T_2666
	move.l	ref_fsel_path_p-cref(a6),a5
	move	#$19,-(sp)
	trap	#1			;Dgetdrv
	addq.l	#2,sp
	addi.b	#'A',d0
	move.b	d0,(a5)+
	move.b	#':',(a5)+
	subi.b	#'A'-1,d0
	gemdos	Dgetpath,(a5),d0
T_2690:	tst.b	(a5)+
	bne.s	T_2690
	move.b	#$5C,-$1(a5)
	lea	$130(a6),a4
	bra.s	T_2654
;
;------------------------------------
;
T_26a0:	moveq	#$3A,d2
	bsr	T_3C12
	bmi.s	T_2662
	lea	1(a5,d1),a5
	cmpa.l	a5,a4
	bhi.s	T_2654
	bra	T_4C8
;
;------------------------------------
;
	tst	$128(a6)
	bmi.s	T_26D8
	addq	#1,ref_bottom_bar_type-cref(a6)
	cmp	#3,ref_bottom_bar_type-cref(a6)
	bls.s	T_26DE
T_26C6:	clr	ref_bottom_bar_type-cref(a6)
	bra.s	T_26DE
;
;------------------------------------
;
	tst	$128(a6)
	bmi.s	T_26C6
	subq	#1,ref_bottom_bar_type-cref(a6)
	bpl.s	T_26DE
T_26D8:	move	#3,ref_bottom_bar_type-cref(a6)
T_26DE:	bsr.s	T_26F8
	bsr	T_3E94
	move	$FA(a6),d6
	bmi.s	T_26F4
	move	d6,d5
	add	$E2(a6),d5
	bsr	T_13E8
T_26F4:	bra	T_4C8
;
;------------------------------------
;
T_26F8:	bsr	T_a48
	beq.s	T_270A
	lea	bottom_bar_null_s(pc),a5
	cmp	#1,$2E(a6)
	beq.s	T_272A
T_270A:	move	ref_bottom_bar_type-cref(a6),d0
	lea	bottom_bar_name_s(pc),a5
	subq	#1,d0
	bmi.s	T_272A
	lea	bottom_bar_size_s(pc),a5
	subq	#1,d0
	bmi.s	T_272A
	lea	bottom_bar_date_s(pc),a5
	subq	#1,d0
	bmi.s	T_272A
	lea	bottom_bar_time_s(pc),a5
T_272A:	moveq	#$18,d7
	bra	T_3926
;
;------------------------------------
;
	bsr	T_1976
	bsr	malloc_query
	move.l	d0,d2
	add.l	$AA(a6),d2
	bsr	T_416E
	move.l	a1,a5
T_2744:	cmpi.b	#$20,(a5)+
	beq.s	T_2744
	subq.l	#1,a5
	bsr.s	T_272A
T_274E:	bsr	graf_mkstate_sub
	btst	#0,d0
	bne.s	T_274E
	bsr.s	T_26F8
	bra.s	T_26F4
;
;------------------------------------
;
T_275C:	moveq	#$14,d7
	bsr	T_2944
	move	$2C(a6),d0
	cmp	d4,d6
	bcs.s	T_27BC
	move.l	$32(a6),a0
	add	$1F6(a0),d4
	cmp	d4,d6
	bhi.s	T_278E
	move	d7,$128(a6)
	bra	T_287C
;
;------------------------------------
;
T_277E:	move	#1000,d6
	tst	$128(a6)
	bmi	T_28B6
	move	$2E(a6),d0
T_278E:	move	$F8(a6),d1
	add	$2E(a6),d1
	subq	#1,d1
	sub	$2C(a6),d1
	ble.s	T_27d4
	cmp	$E2(a6),d1
	bls.s	T_27d4
	add	$E2(a6),d0
T_27A8:	cmp	d1,d0
	bls.s	T_27CA
	sub	$2E(a6),d0
	bra.s	T_27A8
;
;------------------------------------
;
T_27B2:	tst	$128(a6)
	bmi.s	T_27C8
	move	$2E(a6),d0
T_27BC:	move	$E2(a6),d1
	beq.s	T_27d4
	exg	d0,d1
	sub	d1,d0
	bpl.s	T_27CA
T_27C8:	moveq	#0,d0
T_27CA:	bsr	T_286C
	bsr	T_3E70
	bsr.s	T_2826
T_27d4:	move	$128(a6),d7
	and	#$7FFF,d7
	cmp	#$14,d7
	beq.s	T_2822
	cmp	#12,d7
	beq.s	T_27EC
	cmp	#$1C,d7
T_27EC:	beq.s	T_286A
	bsr	T_2944
	btst	#20,d7
	beq.s	T_2822
	moveq	#$18,d0
	mulu	d7,d0
	move.l	$32(a6),a0
	sub	d3,d5
	cmp	$14(a0,d0),d5
	bcc.s	T_2822
	sub	d4,d6
	cmp	$16(a0,d0),d6
	bcc.s	T_2822
	cmp	#$10,d7
	beq.s	T_27B2
	cmp	#$12,d7
	beq	T_277E
	bra	T_275C
;
;------------------------------------
;
T_2822:	bra	T_4C8
;
;------------------------------------
;
T_2826:	moveq	#0,d6
	move	$F8(a6),d0
	sub	$2C(a6),d0
	ble.s	T_283C
	move	$E2(a6),d6
	mulu	#1000,d6
	divu	d0,d6
T_283C:	move.l	$32(a6),a5
	lea	$1DA(a5),a5
	move	4(a5),d5
	sub	$1C(a5),d5
	mulu	d5,d6
	beq.s	T_285A
	divu	#1000,d6
	cmp	d5,d6
	bls.s	T_285A
	move	d5,d6
T_285A:	move	d6,$18(a5)
	moveq	#$13,d0
	moveq	#1,d1
	tst	$DA(a6)
	bne	objc_draw_d0_d1
T_286A:	rts
;
;----------------------------------------------------------------------------
;
T_286C:	ext.l	d0
	divu	$2E(a6),d0
	mulu	$2E(a6),d0
	move	d0,$E2(a6)
	rts
;
;----------------------------------------------------------------------------
;
T_287C:	lea	UIS_contrl(pc),a0
	move.l	#$4C0003,(a0)+		;graf_slidebox
	move.l	#$10001,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	#$13,(a0)+
	move	#$14,(a0)+
	move	#1,(a0)
	lea	UIS_addrin(pc),a0
	move.l	$32(a6),(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	move	UIS_intout(pc),d6
T_28B6:	move	$F8(a6),d0
	add	$2E(a6),d0
	subq	#1,d0
	sub	$2C(a6),d0
	ble	T_4C8
	mulu	d6,d0
	divu	#1000,d0
	bra	T_27CA
;
;------------------------------------
;
T_28d2:	move.l	$32(a6),a5
	lea	$1DE(a5),a5
	move	(a5),d0
	move	$F8(a6),d1
	cmp	$2C(a6),d1
	bls.s	T_290A
	ext.l	d0
	move.l	d0,d2
	ext.l	d1
	divu	$2E(a6),d1
	divu	d1,d0
	lsr	#1,d1
	swap	d1
	cmp.l	d1,d0
	bcs.s	T_28FC
	addq	#1,d0
T_28FC:	mulu	$2A(a6),d0
	divu	char_width(pc),d2	;;;is this a chacter width ???
	cmp	d2,d0
	bcc.s	T_290A
	move	d2,d0
T_290A:	move	d0,$18(a5)
	bra	T_2826
;
;------------------------------------
;
graf_mkstate_sub:
	lea	UIS_contrl(pc),a0
	move.l	#$4F0000,(a0)+		;graf_mkstate
	move.l	#$50000,(a0)+
	move	#0,(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	lea	UIS_intout(pc),a0
	move	(a0)+,d0
	move	(a0)+,d5
	move	(a0)+,d6
	move	(a0)+,d0
	move	(a0),d1
	move	d0,$12E(a6)
	rts
;
;----------------------------------------------------------------------------
;
T_2944:	bsr.s	graf_mkstate_sub
	lsl	#4,d0
	or	d0,d1
	swap	d7
	move	d1,d7
	swap	d7
objc_offset_sub:
	bsr	T_390C
	lea	UIS_contrl(pc),a0
	move.l	#$2C0001,(a0)+		;objc_offset
	move.l	#$30001,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	d7,(a0)
	lea	UIS_addrin(pc),a0
	lea	(a3),a1
	move.l	(a1),(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	move	UIS_intout(pc),d0
	move	UIS_intout+2(pc),d3
	move	UIS_intout+4(pc),d4
	rts
;
;----------------------------------------------------------------------------
;
T_298E:	moveq	#12,d7
	bsr.s	T_2944
	sub	d3,d5
	sub	d4,d6
	move	d6,d4
	moveq	#0,d6
	clr	-(sp)
T_299C:	bsr	T_4036
	cmp	$12(a0),d4
	bcs.s	T_29C2
	cmp	$10(a0),d5
	bcs.s	T_29C2
	move.l	$10(a0),d3
	add.l	$14(a0),d3
	cmp	d3,d4
	bcc.s	T_29C2
	swap	d3
	cmp	d3,d5
	bcc.s	T_29C2
	addq	#1,(sp)
	bra.s	T_29CA
;
;------------------------------------
;
T_29C2:	addq	#1,d6
	cmp	$2C(a6),d6
	bcs.s	T_299C
T_29CA:	tst	(sp)+
	rts
;
;----------------------------------------------------------------------------
;
	bsr	T_3B60
T_29d2:	bsr	T_42a2
	bsr	T_2B80
T_29DA:	bsr	T_3C4E
	bra	T_4C8
;
;------------------------------------
;
	bsr	T_2B80
	bsr.s	T_298E
	bne	T_141A
	tst	$FE(a6)
	bne.s	T_29d2
	bsr	T_2944
	btst	#20,d7
	beq.s	T_29d2
	lea	$2550(a6),a5
	clr	(a5)+
	clr.l	(a5)+
	move	d4,(a5)+
	move	d5,(a5)+
	move	d6,(a5)+
	movem.w	d5-d6,-(sp)
	bsr	T_2B40
	move	d0,(a5)
	bsr	graf_mouse_pointhand
T_2a18:	bsr	T_4B20
	move	#12,d7
	bsr	objc_offset_sub
	lea	$1d4(a6),a0
	move	d3,(a0)
	move	d4,2(a0)
	addq.l	#2,(a0)
	move.l	$32(a6),a1
	move.l	$134(a1),d0
	add.l	(a0)+,d0
	subi.l	#$20004,d0
	move.l	d0,(a0)
	bsr	T_4AEA
T_2a46:	move.l	$2558(a6),d0
	lea	$194(a6),a0
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move	(sp),-$4(a0)
	move	(sp),(a0)+
	move	2(sp),(a0)+
	move.l	d0,(a0)+
	move	2(sp),-$2(a0)
	move.l	d0,(a0)
	bsr	T_4BE6
	movem.w	(sp)+,d3-d4
T_2a6E:	bsr	graf_mkstate_sub
	btst	#0,d0
	beq.s	T_2AF0
	cmp	d3,d5
	bne.s	T_2A80
	cmp	d4,d6
	beq.s	T_2A8A
T_2A80:	movem.w	d5-d6,-(sp)
	bsr	T_4C76
	bra.s	T_2a46
;
;------------------------------------
;
T_2A8A:	move	char_height(pc),d0
	move	$30(a6),d2
	move	d2,d1
	lsr	#1,d0
	add	$2556(a6),d0
	cmp	d0,d6
	bls.s	T_2ACC
	mulu	$2A(a6),d1
	add	d1,d0
	cmp	d0,d6
	bcs.s	T_2a6E
	move	$E2(a6),d0
	add	$2C(a6),d0
	cmp	$F8(a6),d0
	bcc.s	T_2a6E
	sub	d2,$255A(a6)
	movem.w	d5-d6,-(sp)
	bsr.s	T_2AE2
	bsr	T_277E
T_2AC4:	bsr	graf_mouse_show
	bra	T_2a18
;
;------------------------------------
;
T_2ACC:	tst	$E2(a6)
	beq.s	T_2a6E
	add	d2,$255A(a6)
	movem.w	d5-d6,-(sp)
	bsr.s	T_2AE2
	bsr	T_27B2
	bra.s	T_2AC4
;
;------------------------------------
;
T_2AE2:	move	#12,$128(a6)
	bsr	T_4C1E
	bra	graf_mouse_hide
;
;------------------------------------
;
T_2AF0:	bsr	T_4C1E
	bsr.s	T_2B40
	move	$255C(a6),d1
	cmp	d1,d0
	bcc.s	T_2B00
	exg	d1,d0
T_2B00:	add	$2E(a6),d0
	subq	#1,d0
	sub	d1,d0
T_2B08:	cmp	$F8(a6),d1
	bcc.s	T_2B34
	move	d1,d2
	lsl	#1,d2
	lea	$25E2(a6),a0
	move	0(a0,d2),d2
	move.l	patch_area_3_p-cref(a6),a5
	tst.b	$15(a5,d2)
	bmi.s	T_2B2E
	ori.b	#$80,$15(a5,d2)
	addq	#1,$10A(a6)
T_2B2E:	addq	#1,d1
	dbra	d0,T_2B08
T_2B34:	bsr	T_3E94
	bsr	graf_mouse_arrow
	bra	T_16FE
;
;------------------------------------
;
T_2B40:	clr	d0
	move	char_height(pc),d1
	lsr	#1,d1
	move	d6,d3
	sub	$2556(a6),d3
	cmp	d1,d3
	bgt.s	T_2B58
	add	d1,$255A(a6)
	bra.s	T_2B6E
;
;------------------------------------
;
T_2B58:	move	$2A(a6),d2
	subq	#2,d2
T_2B5E:	add	$30(a6),d1
	cmp	d1,d3
	bls.s	T_2B6E
	add	$2E(a6),d0
	dbra	d2,T_2B5E
T_2B6E:	add	$E2(a6),d0
	rts
;
;----------------------------------------------------------------------------
;
T_2B74:	move.l	ref_fsel_name_p-cref(a6),a5
	clr.b	(a5)
	moveq	#$1B,d7
	bsr	T_3926
T_2B80:	tst	$FA(a6)
	bmi.s	T_2B8C
	moveq	#13,d7
	bsr	objc_change_NORMAL
T_2B8C:	move	#-$7d0,$FA(a6)
	rts
;
;----------------------------------------------------------------------------
;
T_2B94:	bra	T_1B26
;
;------------------------------------
;
T_2B98:	bsr	T_3E66
	tst.b	$24d4(a6)
	bne.s	T_2B94
	cmpi.b	#1,$24d5(a6)
	bne.s	T_2B94
	lea	print_or_show_file_alst(pc),a2
	bsr	T_39BE
	move	d0,-(sp)
	bsr	T_3E94
	move	(sp)+,d0
	cmp	#3,d0
	beq.s	T_2B94
	subq	#1,d0
	move.b	d0,$E0(a6)
	beq.s	T_2BCE
	bsr	T_3104
	beq.s	T_2B94
T_2BCE:
	gemdos	Fopen,$24D8(a6),#0
	move.l	d0,d7
	bmi.s	T_2B94
	tst.b	$E0(a6)
	bne.s	T_2BEC
	bsr	T_2EF4
T_2BEC:	clr	$22(a6)
	gemdos	Fseek,#0,d7,#2			;Fseek to EOF
	move.l	d0,d6				;d6 = file length
	ble	T_2C8C
	gemdos	Fseek,#0,d7,#0			;Fseek to BOF
	move.l	patch_area_3_p-cref(a6),a5
	moveq	#$28,d3
T_2C28:	move	$18E(a6),d5
	mulu	#$16,d5
	cmp	#$A8C,d5
	bls.s	T_2C3A
	move	#$A8C,d5
T_2C3A:	cmp.l	d5,d6
	bhi.s	T_2C40
	move.l	d6,d5
T_2C40:
	gemdos	Fread,d7,d5,(a5)
	tst.l	d0
	bmi.s	T_2C76
	sub.l	d5,d6
	move.l	a5,a4
T_2C58:	move.b	(a4)+,d0
	beq.s	T_2C68
	bsr.s	T_2CC8
	tst	d0
	beq.s	T_2C8C
	tst	$22(a6)
	bne.s	T_2C7C
T_2C68:	bsr.s	T_2C9E
	beq.s	T_2C76
	subq.l	#1,d5
	bne.s	T_2C58
	tst.l	d6
	bne.s	T_2C28
	bra.s	T_2C7C
;
;------------------------------------
;
T_2C76:
	move	#$51,$22(a6)
T_2C7C:
	tst.b	$E0(a6)
	ble.s	T_2C8C
	tst.b	$C4(a6)
	beq.s	T_2C8C
	moveq	#12,d0
	bsr.s	T_2CC8
T_2C8C:	move	d7,-(sp)
	move	#$3E,-(sp)
	trap	#1			;Fclose
	addq.l	#4,sp
	bsr	T_3046
	bra	T_1B26
;
;------------------------------------
;
T_2C9E:	tst.b	$E0(a6)
	bmi.s	T_2CC6
	subq	#1,d3
	bne.s	T_2CC6
	moveq	#$28,d3
T_2CAA:	bsr	evnt_timed_kb_sub
T_2CAE:	cmp.b	#3,d0
	beq.s	T_2CC6
	cmp.b	#$51,d0
	beq.s	T_2CC6
	swap	d0
	cmp.b	#1,d0
	beq.s	T_2CC6
	cmp.b	#$61,d0
T_2CC6:	rts
;
;----------------------------------------------------------------------------
;
T_2CC8:	tst.b	$E0(a6)
	bgt	T_3296
	movem.l	d5-d7/a4-a5,-(sp)
	cmpi.b	#$FF,$E0(a6)
	beq.s	T_2d2E
	move	d0,-(sp)
	tst.b	$E0(a6)
	beq.s	T_2CEA
	addq.b	#1,$E0(a6)
	bra.s	T_2CEE
;
;------------------------------------
;
T_2CEA:	bsr	T_3094
T_2CEE:	lea	$142(a6),a5
	clr	(a5)
	move.l	$56(a6),a0
	clr	$2A(a0)
	clr	2(a5)
	clr	4(a5)
	clr	6(a5)
	clr.b	8(a5)
	move.l	$178(a6),d0
	add.l	$17C(a6),d0
	cmp.l	$a6(a6),d0
	bne.s	T_2d28
	pea	T_76B2(pc)
	move	#9,-(sp)
	trap	#1			;Cconws
	addq.l	#6,sp
	bra.s	T_2d2C
;
;------------------------------------
;
T_2d28:	st	8(a5)
T_2d2C:	move	(sp)+,d0
T_2d2E:	lea	$142(a6),a5
	lea	$2550(a6),a3
	move	2(a5),d1
	cmp.b	#10,d0
	beq.s	T_2Da0
	cmpi.b	#13,6(a5)
	beq.s	T_2d78
	cmp.b	#13,d0
	beq.s	T_2D9C
	cmp.b	#9,d0
	beq.s	T_2D80
	cmp.b	#$20,d0
	bcc.s	T_2d5E
	move.b	#$20,d0
T_2d5E:
	cmp	ref_max_column-cref(a6),d1
	bhi.s	T_2d78
	move.b	d0,0(a3,d1)
	addq	#1,2(a5)
T_2d6C:	move.b	d0,6(a5)
T_2d70:	movem.l	(sp)+,d5-d7/a4-a5
	moveq	#-1,d0
	rts
;
;----------------------------------------------------------------------------
;
T_2d78:	move	d0,-(sp)
	bsr.s	T_2DE8
	move	(sp)+,d0
	bra.s	T_2d2E
;
;------------------------------------
;
T_2D80:
	cmp	ref_max_column-cref(a6),d1
	bhi.s	T_2d6C
	move.b	#$20,0(a3,d1)
	addq	#1,d1
	addq	#1,2(a5)
	move	d1,d2
	and	#7,d2
	bne.s	T_2D80
	bra.s	T_2d6C
;
;------------------------------------
;
T_2D9C:	bsr.s	T_2Da4
	bra.s	T_2d70
;
;------------------------------------
;
T_2Da0:	bsr.s	T_2DE8
	bra.s	T_2d70
;
;------------------------------------
;
T_2Da4:
	cmp	ref_max_column-cref(a6),d1
	bhi.s	T_2DB4
	move.b	#$20,0(a3,d1)
	addq	#1,d1
	bra.s	T_2Da4
;
;------------------------------------
;
T_2DB4:	clr.b	0(a3,d1)
T_2DB8:	clr	2(a5)
	move.b	#13,6(a5)
	tst.b	8(a5)
	bne.s	T_2DE0
T_2DC8:	moveq	#0,d0
	move.b	(a3)+,d0
	beq.s	T_2DDE
	bios	Bconout,#2,d0
	bra.s	T_2DC8
;
;------------------------------------
;
T_2DDE:	rts
;
;----------------------------------------------------------------------------
;
T_2DE0:	moveq	#1,d0
	moveq	#0,d1
	bra	objc_draw_d0_d1
;
;------------------------------------
;
T_2DE8:	cmpi.b	#13,6(a5)
	beq.s	T_2DF2
	bsr.s	T_2Da4
T_2DF2:	addq	#1,4(a5)
	cmp	#$17,(a5)
	bhi	T_2E88
	move.l	$56(a6),a0
	move	char_height(pc),d0
	add	d0,$2A(a0)
	addq	#1,(a5)
	cmp	#$18,(a5)
	bne	T_2E80
T_2E14:	moveq	#1,d5
	bra.s	T_2E46
;
;------------------------------------
;
T_2E18:	tst	d5
	beq.s	T_2E46
	lea	$2550(a6),a3
	move.l	a3,a0
	lea	T_76a6(pc),a1
T_2E26:	move.b	(a1)+,(a0)+
	bne.s	T_2E26
	tst.b	8(a5)
	bne.s	T_2E3A
	bsr.s	T_2DB8
	lea	T_76AD(pc),a3
	bsr.s	T_2DC8
	bra.s	T_2E40
;
;------------------------------------
;
T_2E3A:	moveq	#6,d1
	bsr	T_2Da4
T_2E40:	lea	$142(a6),a5
	moveq	#0,d5
T_2E46:	bsr	vq_mouse_sub
	btst	#1,d1
	bne.s	T_2E72
	moveq	#13,d0
	btst	#0,d1
	bne.s	T_2E78
	bsr	evnt_timed_kb_sub
	tst.l	d0
	beq.s	T_2E18
	cmp.b	#13,d0
	beq.s	T_2E78
	cmp.b	#$20,d0
	beq.s	T_2E78
	bsr	T_2CAE
	bne.s	T_2E18
T_2E72:
	moveq	#$51,d0
	move	d0,$22(a6)
T_2E78:
	move.b	d0,7(a5)
	clr	4(a5)
T_2E80:
	move.b	#10,6(a5)
	rts
;
;----------------------------------------------------------------------------
;
T_2E88:	tst.b	8(a5)
	beq.s	T_2E94
	bsr.s	T_2EAA
	lea	$142(a6),a5
T_2E94:	cmpi.b	#$20,7(a5)
	bne	T_2E14
	cmp	#$17,4(a5)
	bcc	T_2E14
	bra.s	T_2E80
;
;------------------------------------
;
T_2EAA:	lea	$1A8(a6),a5
	move	char_height(pc),d5
	lea	$a2(a6),a0
	move	(a0),(a5)
	move	(a0),8(a5)
	move	2(a0),2(a5)
	add	d5,2(a5)
	move	2(a0),10(a5)
	move	4(a0),d0
	add	(a0),d0
	move	d0,4(a5)
	move	d0,12(a5)
	move	6(a0),d0
	add	2(a0),d0
	subq	#1,d0
	move	d0,6(a5)
	move	d0,14(a5)
	sub	d5,14(a5)
	bra	vro_cpyfm_194_ia6
;
;------------------------------------
;
T_2EF4:	move	$178(a6),d0
	add	$17C(a6),d0
	cmp	$a6(a6),d0
	bne.s	T_2F2A
	tst.l	$16(a6)
	bmi.s	T_2F2A
	bne.s	T_2F2C
;
	bios	Setexc,#evn_trap9,(-1).l
;
	move.l	d0,a0
	cmp	#$00DC,-(a0)
	beq.s	T_2F2C
	moveq	#-1,d0
	move.l	d0,$16(a6)
T_2F2A:
	rts
;
;----------------------------------------------------------------------------
;
T_2F2C:	bsr	T_1976
	move.l	ref_line_a_base_p-cref(a6),a0
	move	la_v_cel_my(a0),ref_v_cel_my-cref(a6)
	moveq	#0,d0
	move	$17A(a6),d0
	add	$17E(a6),d0
	divu	char_height(pc),d0
	subq	#1,d0
	move	d0,-$2A(a0)
	cmp	#24,d0
	beq.s	T_2F64
	bsr	T_386A
	st	$174(a6)
	lea	$178(a6),a2
	bsr	T_3856
T_2F64:
;
	pea	T_2F2C(pc)
	move	#-$2400,-(sp)
	trap	#9
	move.l	d0,$16(a6)
	move.l	d0,2(sp)
	trap	#9
	addq.l	#6,sp
;
	move.l	patch_area_3_p-cref(a6),a0
	lea	$A8C(a0),a0
	move.l	sp,-(a0)
	move.l	a0,sp
	move.l	d7,-(sp)
	st	$1D(a6)
	bsr	T_3094
;
	xbios	Cursconf,#1,#0		;show VT52 cursor
	move.l	(sp),d0
	lea	$24D8(a6),a0
	move.l	$16(a6),a1
	jsr	(a1)
	lea	cref(pc),a6
	tst.l	d0
	beq.s	T_2FCC
	move.l	$16(a6),a1
	move.l	(sp),d0
	lea	$24D8(a6),a0
	move.l	#'_HEX',-(sp)
	jsr	(a1)
	lea	cref(pc),a6
	addq.l	#4,sp
T_2FCC:	move.l	(sp)+,d7
	move.l	(sp),sp
	move.l	d0,-(sp)
	clr.b	$1D(a6)
	xbios	Cursconf,#0,#0		;hide VT52 cursor
;
	move.l	ref_line_a_base_p-cref(a6),a0
	move	ref_v_cel_my-cref(a6),la_v_cel_my(a0)
	tst.l	(sp)+
	beq.s	T_2FFA
	subq.b	#1,$E0(a6)
	rts
;
;----------------------------------------------------------------------------
;
T_2FFA:	addq.l	#4,sp
	move	d7,-(sp)
	move	#$3E,-(sp)
	trap	#1			;Fclose
	addq.l	#4,sp
	bsr	T_307A
	bra	T_1B26
;
;------------------------------------
;
T_300E:	bsr	evnt_timed_kb_sub
	tst	d0
	bne.s	T_300E
T_3016:	rts
;
;----------------------------------------------------------------------------
;
vq_mouse_sub:
	lea	UIS_contrl(pc),a0
	move.l	#$7C0000,(a0)		;vq_mouse
	move	#0,6(a0)
	move	ref_wk_handle-cref(a6),12(a0)
	move.l	UIS_vdipb_p(pc),d1
	move	#$73,d0
	trap	#2			;call vdi
	move	UIS_intout(pc),d1
	move	UIS_ptsout(pc),d0
	move	UIS_ptsout+2(pc),d0
	rts
;
;----------------------------------------------------------------------------
;
T_3046:	tst.b	$E0(a6)
	bpl.s	T_3016
	bsr.s	T_300E
	cmpi.b	#$51,$23(a6)
	beq.s	T_307A
	lea	T_7694(pc),a4
T_305A:	move.b	(a4)+,d0
	beq.s	T_3064
	bsr	T_2CC8
	bra.s	T_305A
;
;------------------------------------
;
T_3064:
	clr	$22(a6)
	bsr.s	vq_mouse_sub
	move	d1,d6
T_306C:	bsr.s	vq_mouse_sub
	cmp	d1,d6
	bne.s	T_307A
	bsr	T_2CAA
	tst	d0
	beq.s	T_306C
T_307A:	bsr	graf_mouse_show
	bsr	graf_mkstate_sub
	bsr.s	T_30F0
	moveq	#-1,d4
	bsr.s	T_30B0
	move	#0,$DC(a6)
	bsr.s	T_30F8
T_3090:	bra	objc_draw_0_2
;
;------------------------------------
;
T_3094:	bsr	graf_mouse_hide
	subq.b	#1,$E0(a6)
	clr.b	$2550(a6)
	bsr.s	T_30F0
	move	#9,$DC(a6)
	bsr.s	T_30F8
	moveq	#0,d4
	bsr.s	T_30B0
	bra.s	T_3090
;
;----------------------------------------------------------------------------
;
T_30B0:
	tst.b	$174(a6)
	beq.s	.T_30EE
	move.l	#$17d4,$AA(a6)
	move.l	patch_area_3_p-cref(a6),a0
	lea	$A8C(a0),a0
	move.l	a0,$AE(a6)
	bsr	graf_mouse_hide
	lea	$1d4(a6),a2
	clr.l	(a2)
	move	ref_max_column-cref(a6),d0
	addq	#1,d0		;d0 = total columns (limited to 80)
	lsl	#3,d0
	swap	d0
	move	$17A(a6),d0
	move.l	d0,4(a2)
	bsr	T_3740
	clr.l	$AA(a6)
.T_30EE:
	rts
;
;----------------------------------------------------------------------------
;
T_30F0:	bsr	T_4ADA
	bra	T_3726
;
;------------------------------------
;
T_30F8:	bsr	T_3880
	bsr	T_372A
	bra	T_3828
;
;------------------------------------
;
T_3104:	clr.b	$E1(a6)
	tst.b	$C5(a6)
	beq.s	T_3112
	st	$E1(a6)
T_3112:	move	#$11,-(sp)
	trap	#1			;Cprnos
	addq.l	#2,sp
	tst.l	d0
	bne.s	T_3132
	lea	printer_missing_alst(pc),a2
	bsr	T_39BE
	move	d0,-(sp)
	bsr	T_3E94
	cmp	#2,(sp)+
	bne.s	T_3104
T_3132:	rts
;
;----------------------------------------------------------------------------
;
	tst	$22(a6)
	bne	T_165C
	bsr	objc_change_SELECTED
	bsr.s	T_3104
	beq	T_327A
	bsr	T_42D8
	addi.b	#'A',d7
	lea	T_75BD(pc),a4
	move.b	d7,(a4)
	lea	T_75AC(pc),a4
	bsr	T_3288
	lea	T_75F2(pc),a4
	move.b	d7,(a4)
	move.b	#'\',2(a4)
	move	#8,-(sp)
	pea	(a4)
	move	#$4E,-(sp)
	trap	#1			;Fsfirst
	addq.l	#8,sp
	lea	T_75C3(pc),a4
	tst	d0
	bne.s	T_3182
	lea	$1B2(a6),a4
T_3182:	bsr	T_3288
	bsr	T_3284
	lea	T_75CC(pc),a4
	bsr	T_3288
	cmpi.b	#$3A,1(a5)
	beq.s	T_31CE
	lea	T_75F2(pc),a4
	clr.b	2(a4)
	bsr	T_3288
	cmpi.b	#'\',(a5)
	beq.s	T_31CE
	lea	$194(a6),a4
	move	d7,d0
	sub	#'A'-1,d0
	gemdos	Dgetpath,(a4),d0
	bsr	T_3288
	lea	T_75FE(pc),a4
	bsr	T_3288
T_31CE:	move.l	a5,a4
	bsr	T_3288
	bsr	T_3284
	bsr	T_3284
	moveq	#0,d6
T_31DE:	bsr	T_2CAA
	beq	T_326A
	cmp	$F8(a6),d6
	bcc.s	T_323E
	lea	$194(a6),a4
	move	d6,d0
	lsl	#1,d0
	lea	$25E2(a6),a0
	move	0(a0,d0),d0
	move.l	patch_area_3_p-cref(a6),a3
	lea	0(a3,d0),a3
	tst	$10A(a6)
	beq.s	T_3210
	tst.b	$15(a3)
	bpl.s	T_3238
T_3210:	swap	d6
	addq	#1,d6
	swap	d6
	bsr	T_40B2
	lea	$194(a6),a4
	cmpi.b	#$20,$14(a4)
	bne.s	T_3234
	move.l	#$3C444952,14(a4)
	move.b	#$3E,$12(a4)
T_3234:	bsr.s	T_3288
	bsr.s	T_3284
T_3238:	addq	#1,d6
	bra	T_31DE
;
;------------------------------------
;
T_323E:	bsr.s	T_3284
	bsr	T_32EA
	swap	d6
	move	d6,d2
	ext.l	d2
	bsr	T_416E
	move.l	a1,a4
	bsr.s	T_3288
	lea	T_75DB(pc),a4
	bsr.s	T_3288
	move.l	d5,d2
	bsr	T_416E
	move.l	a1,a4
	bsr.s	T_3288
	lea	T_75E6(pc),a4
	bsr.s	T_3288
	bsr.s	T_3284
T_326A:	lea	T_75FC(pc),a4
	tst.b	$C4(a6)
	beq.s	T_3278
	bsr.s	T_3288
	bra.s	T_327A
;
;------------------------------------
;
T_3278:	bsr.s	T_3284
T_327A:	moveq	#$19,d7
	bsr	objc_change_NORMAL
	bra	T_4C8
;
;------------------------------------
;
T_3284:	lea	T_75F9(pc),a4
T_3288:	move.b	(a4)+,d0
	beq.s	T_32E8
	bsr.s	T_3296
	tst	d0
	bmi.s	T_3288
	addq.l	#4,sp
	bra.s	T_327A
;
;------------------------------------
;
T_3296:	tst.b	$E1(a6)
	beq.s	T_32AE
	clr.b	$E1(a6)
	move	d0,-(sp)
	bsr.s	T_32DC
	bsr.s	T_32DC
	bsr.s	T_32DC
	bsr.s	T_32DC
	bsr.s	T_32DC
	move	(sp)+,d0
T_32AE:	and	#$FF,d0
	cmp.b	#13,d0
	beq.s	T_32DE
	cmp.b	#10,d0
	bne.s	T_32CA
	tst.b	$C5(a6)
	beq.s	T_32DE
	st	$E1(a6)
	bra.s	T_32DE
;
;------------------------------------
;
T_32CA:	cmp.b	#9,d0
	beq.s	T_32DE
	cmp.b	#12,d0
	beq.s	T_32DE
	cmp.b	#$20,d0
	bcc.s	T_32DE
T_32DC:	moveq	#$20,d0
T_32DE:	move	d0,-(sp)
	move	#5,-(sp)
	trap	#1			;Cprnout
	addq.l	#4,sp
T_32E8:	rts
;
;----------------------------------------------------------------------------
;
T_32EA:	bsr	T_42D8
T_32EE:	addq	#1,d7
	move	d7,-(sp)
	pea	$130(a6)
	move	#$36,-(sp)
	trap	#1			;Dfree
	addq.l	#8,sp
	lea	$130(a6),a0
	move	10(a0),d5
	mulu	14(a0),d5
	mulu	2(a0),d5
	rts
;
;----------------------------------------------------------------------------
;
T_3310:	move	$10A(a6),d7
	beq.s	T_32E8
	clr	$FC(a6)
	cmp	#$11,$FE(a6)
	bne.s	T_3346
	move	$F8(a6),d0
	move.l	patch_area_3_p-cref(a6),a0
	lea	$25E2(a6),a1
	bra.s	T_3342
;
;------------------------------------
;
T_3330:	move	(a1)+,d1
	btst	#7,$15(a0,d1)
	beq.s	T_3342
	st	$FC(a6)
	not.w	-$2(a1)
T_3342:	dbra	d0,T_3330
T_3346:	move.l	patch_area_3_p-cref(a6),a5
	move.l	a5,a4
	move.l	a5,a3
	move	$F8(a6),d6
	subq	#1,d6
	moveq	#0,d5
	moveq	#0,d4
	moveq	#0,d3
T_335A:	move.b	$15(a5),d0
	bpl.s	T_338A
	moveq	#1,d1
	swap	d1
	btst	#4,d0
	bne.s	T_3378
	add.l	4(a5),d5
	move.l	4(a5),d0
	bsr	T_33E2
	moveq	#1,d1
T_3378:	add.l	d1,d3
	lea	8(a5),a0
	moveq	#13,d0
T_3380:	move.b	(a0)+,(a4)+
	dbra	d0,T_3380
	subq	#1,d7
	beq.s	T_339C
T_338A:	lea	$16(a5),a5
	dbra	d6,T_335A
	move	$10A(a6),d0
	sub	d7,d0
	move	d0,$10A(a6)
T_339C:	suba.l	a3,a4
	move	a4,d0
	move	#$2260,d1
	sub	d0,d1
	lea	0(a3,d1),a4
	move.l	a4,$10E(a6)
	subq	#1,d0
T_33B0:	move.b	(a3)+,(a4)+
	dbra	d0,T_33B0
	divu	#$16,d1
	move	d1,$18E(a6)
	clr	$112(a6)
	move.l	d5,$184(a6)
	move.l	d4,$188(a6)
	move.l	d3,$180(a6)
	bsr	T_3E68
	cmp	#$11,$FE(a6)
	beq.s	T_33DE
	bsr	T_3C4E
T_33DE:	moveq	#-1,d0
	rts
;
;----------------------------------------------------------------------------
;
T_33E2:	divu	#$400,d0
	swap	d0
	tst	d0
	beq.s	T_33F2
	addi.l	#$10000,d0
T_33F2:	swap	d0
	mulu	#$400,d0
	add.l	d0,d4
	rts
;
;----------------------------------------------------------------------------
;
T_33FC:	bsr	graf_mouse_busybee
	bsr	T_32EA
	bsr	T_1336
T_3408:	bsr	T_3E94
	bra	T_4C8
;
;------------------------------------
;
	tst	$22(a6)
	bne	T_165C
	bsr	objc_change_NORMAL
	tst	$FE(a6)
	bne.s	T_33FC
	bsr	T_3E66
T_3426:	bsr	graf_mouse_busybee
	clr	$DA(a6)
	move	#2,$DC(a6)
	bsr	T_42D8
	lea	T_75F2(pc),a5
	move.b	d7,(a5)
	addi.b	#$41,(a5)
	clr.b	2(a5)
	moveq	#3,d7
	bsr	T_3926
	move.b	#$5C,-$1(a5)
	move.l	ref_fsel_path_p-cref(a6),a5
	cmp	#$11,$FE(a6)
	bne.s	T_3466
	lea	$24D8(a6),a5
	clr	$FE(a6)
T_3466:	lea	$2550(a6),a4
	move.l	a4,a3
T_346C:	move.b	(a5)+,(a4)+
	bne.s	T_346C
T_3470:	cmpa.l	a4,a3
	beq.s	T_348A
	cmpi.b	#$5C,-$1(a4)
	beq.s	T_3488
	cmpi.b	#$3A,-$1(a4)
	beq.s	T_348A
	subq.l	#1,a4
	bra.s	T_3470
;
;------------------------------------
;
T_3488:	subq.l	#1,a4
T_348A:	clr.b	(a4)
	move.l	a3,a5
	moveq	#$5C,d2
	bsr	T_3C12
	bmi.s	T_34a6
	lea	1(a5,d1),a5
	pea	T_7614(pc)
	move	#-$1,$108(a6)
	bra.s	T_34CE
;
;------------------------------------
;
T_34a6:	pea	T_7600(pc)
	move	#1,$108(a6)
	move	#8,-(sp)
	pea	T_75F2(pc)
	move	#$4E,-(sp)
	trap	#1			;Fsfirst
	addq.l	#8,sp
	lea	$1B2(a6),a5
	tst	d0
	bpl.s	T_34CE
	clr	$108(a6)
	clr.b	(a5)
T_34CE:	lea	$130(a6),a4
	moveq	#0,d1
	bsr	T_3a6C
	lea	$130(a6),a5
	moveq	#5,d7
	bsr	T_3926
	move.l	(sp)+,a5
	moveq	#1,d7
	bsr	T_3926
	move.b	#$20,-$1(a3)
	moveq	#4,d7
	bsr	T_3926
	moveq	#0,d3
	bsr	T_3626
	move.l	d4,d5
	moveq	#4,d4
	move.l	d7,d2
	moveq	#9,d7
	bsr	T_359E
	move.l	d6,d2
	moveq	#7,d7
	bsr	T_359E
	moveq	#1,d4
	bsr	T_1976
	bsr	malloc_query
	move.l	d0,d2
	add.l	$AA(a6),d2
	moveq	#15,d7
	bsr	T_359E
	moveq	#0,d4
	move.l	d5,d2
	moveq	#11,d7
	bsr	T_359E
	move.l	$3A(a6),a5
	lea	$78(a5),a5
	and	#$1F7,8(a5)
	tst	$108(a6)
	bne.s	T_354A
	or	#8,8(a5)
T_354A:	bsr	T_32EA
	moveq	#0,d4
	move.l	d5,d2
	moveq	#13,d7
	bsr	T_359E
	bsr	T_357C
	tst	$108(a6)
	bne.s	T_3578
	move	#2,$DC(a6)
	move.b	T_75F2(pc),d0
	moveq	#5,d7
	bsr	T_35d6
	move	#0,$DC(a6)
T_3578:	bra	T_494
;
;------------------------------------
;
T_357C:	bsr.s	T_35C0
	move	d7,$DE(a6)
	bsr	T_390C
T_3586:	move	#0,$DC(a6)
	lea	$32(a6),a3
	move	#1,$DA(a6)
T_3596:	moveq	#0,d0
	moveq	#2,d1
	bra	objc_draw_d0_d1_raw
;
;------------------------------------
;
T_359E:	bsr	T_416E
	move.l	a1,a5
	moveq	#8,d0
T_35a6:	cmpi.b	#$20,0(a5,d0)
	bne.s	T_35B4
	move.b	#$5F,0(a5,d0)
T_35B4:	dbra	d0,T_35a6
	lea	0(a5,d4),a5
	bra	T_3926
;
;------------------------------------
;
T_35C0:	bsr	objc_draw_0_2
	bsr	graf_mouse_arrow
	bsr	T_390C
	clr	d2
	bsr	form_do_sub
	bra	objc_change_NORMAL
;
;------------------------------------
;
T_35d6:	lea	$130(a6),a5
	move.b	d0,(a5)+
	move.b	#$3A,(a5)+
	move.b	#$5C,(a5)+
	bsr	T_3922
	lea	$133(a6),a4
	tst.b	(a4)
	beq.s	T_3612
	bsr	T_199C
	move	#8,-(sp)
	pea	$130(a6)
	move	#$3C,-(sp)
	trap	#1			;Fcreate
	addq.l	#8,sp
	tst	d0
	bmi.s	T_3612
	move	d0,-(sp)
	move	#$3E,-(sp)
	trap	#1			;Fclose
	addq.l	#4,sp
T_3612:	rts
;
;----------------------------------------------------------------------------
;
T_3614:	lea	$2550(a6),a5
	moveq	#-1,d2
	bsr	T_3C12
	lea	0(a5,d0),a5
	bra	T_3BFE
;
;------------------------------------
;
T_3626:	moveq	#0,d6
	moveq	#0,d7
	moveq	#0,d5
	moveq	#0,d4
	move.l	patch_area_3_p-cref(a6),a4
	move.b	#$FE,(a4)+
T_3636:	move.b	#$FF,(a4)+
	clr	-(sp)
	moveq	#7,d0
	tst	d3
	bmi.s	T_3646
	bsr.s	T_3614
	moveq	#$17,d0
T_3646:	move	d0,-(sp)
	pea	$2550(a6)
	move	#$4E,-(sp)
	trap	#1			;Fsfirst
	addq.l	#8,sp
	bra.s	T_365E
;
;------------------------------------
;
T_3656:	move	#$4F,-(sp)
	trap	#1			;Fsnext
	addq.l	#2,sp
T_365E:	tst	d0
	bne.s	T_3690
	addq	#1,(sp)
	cmpi.b	#$10,$1A9(a6)
	beq.s	T_367C
	add.l	$1AE(a6),d5
	move.l	$1AE(a6),d0
	bsr	T_33E2
	addq.l	#1,d7
	bra.s	T_3656
;
;------------------------------------
;
T_367C:	cmpi.b	#$2E,$1B2(a6)
	beq.s	T_3656
	addq.l	#1,d6
	lea	$1B2(a6),a5
T_368A:	move.b	(a5)+,(a4)+
	bne.s	T_368A
	bra.s	T_3656
;
;------------------------------------
;
T_3690:	move	(sp)+,d0
	tst	d3
	bmi.s	T_36B6
	tst.b	$2556(a6)
	beq.s	T_36B6
	ext.l	d0
	divu	#$20,d0
	swap	d0
	tst	d0
	beq.s	T_36AE
	addi.l	#$10000,d0
T_36AE:	swap	d0
	mulu	#$400,d0
	add.l	d0,d4
T_36B6:	tst.b	-(a4)
	bpl.s	T_36d2
	cmpi.b	#$FE,-(a4)
	beq.s	T_36d0
	lea	$2550(a6),a5
	moveq	#$5C,d2
	bsr	T_3C12
	clr.b	0(a5,d1)
	bra.s	T_36B6
;
;------------------------------------
;
T_36d0:	rts
;
;------------------------------------
;
T_36d2:	tst.b	-(a4)
	bgt.s	T_36d2
	addq.l	#1,a4
	lea	$2550(a6),a5
	moveq	#$5C,d2
	bsr	T_3C12
	lea	1(a5,d1),a5
	move.l	a4,a3
T_36E8:	move.b	(a3)+,(a5)+
	bne.s	T_36E8
	move.b	#$FF,(a4)+
	bra	T_3636
;
;----------------------------------------------------------------------------
;
form_do_sub:
	lea	UIS_contrl(pc),a0
	move.l	#$320001,(a0)+		;form_do
	move.l	#$10001,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	d2,(a0)
	lea	UIS_addrin(pc),a0
	lea	(a3),a1
	move.l	(a1),(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	move	UIS_intout(pc),d7
	rts
;
;----------------------------------------------------------------------------
;
T_3726:	moveq	#-1,d4
	bra.s	T_372C
;
;------------------------------------
;
T_372A:	moveq	#0,d4
T_372C:	tst.l	$AA(a6)
	bne.s	T_3738
	st	$174(a6)
	rts
;
;----------------------------------------------------------------------------
;
T_3738:	bsr	graf_mouse_hide
	bsr	T_390C
T_3740:	move.l	(a2),d0
	move.l	d0,d2
	andi.l	#$F0000,d2
	move.l	4(a2),d1
	subi.l	#$10001,d1
	move.l	d1,d3
	add.l	d0,d1
	add.l	d2,d3
	tst	d4
	beq.s	T_3762
	exg	d0,d2
	exg	d1,d3
T_3762:	lea	$1CC(a6),a5
	movem.l	d0-d3,-(a5)
	lea	$1A8(a6),a3
	move.l	$AE(a6),(a3)+
	move	4(a2),d0
	lsr	#4,d0
	tst	$DC(a6)
	bne.s	T_3780
	addq	#2,d0
T_3780:	move	d0,4(a3)
	lsl	#4,d0
	move	d0,(a3)+
	move	6(a2),(a3)+
	addq.l	#2,a3
	clr	(a3)+
	move	ref_planes-cref(a6),(a3)+
	clr.l	(a3)+
	clr	(a3)+
	move	d4,d0
	lea	$1A8(a6),a3
	bsr.s	vro_cpyfm_a3_194_ia6
	bra	graf_mouse_show
;
;------------------------------------
;
vro_cpyfm_194_ia6:
	lea	$194(a6),a3
vro_cpyfm_a3_194_ia6:
	lea	$194(a6),a4
	clr.l	(a4)
	tst	d0
	beq.s	.vro_cpyfm_a3_a4
	exg	a3,a4
.vro_cpyfm_a3_a4:
	lea	UIS_contrl(pc),a0
	move.l	#$6d0004,(a0)		;vro_cpyfm
	move	#1,6(a0)
	move	ref_wk_handle-cref(a6),12(a0)
	lea	(a4),a1
	move.l	a1,14(a0)
	lea	(a3),a1
	move.l	a1,$12(a0)
	lea	UIS_intin(pc),a0
	move	#3,(a0)
	lea	UIS_ptsin(pc),a0
	lea	(a5),a1
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1),(a0)
	move.l	UIS_vdipb_p(pc),d1
	move	#$73,d0
	trap	#2			;call vdi
	rts
;
;----------------------------------------------------------------------------
;
wind_update_1_and_3:
	moveq	#1,d5			;d5 = 1
wind_update_d5_2_plus_d5:
	bsr.s	wind_update_d5		;call aes wind_update(d5)
	addq	#2,d5			;d5 +=2
wind_update_d5:
	lea	UIS_contrl(pc),a0
	move.l	#$6B0001,(a0)+		;wind_update
	move.l	#$10000,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	d5,(a0)			;begend = d5
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	move	UIS_intout(pc),d0
	rts
;
;----------------------------------------------------------------------------
;
T_3828:	bsr	T_390C
	move	(a2),d0
	cmp	$166(a6),d0
	bcc.s	T_3838
	move	d0,$166(a6)
T_3838:	move	2(a2),d0
	cmp	$168(a6),d0
	bcc.s	T_3846
	move	d0,$168(a6)
T_3846:	move	4(a2),d0
	add	(a2),d0
	cmp	$16A(a6),d0
	bls.s	T_3856
	move	d0,$16A(a6)
T_3856:	move	6(a2),d0
	add	2(a2),d0
	cmp	$16C(a6),d0
	bls.s	T_3868
	move	d0,$16C(a6)
T_3868:	rts
;
;----------------------------------------------------------------------------
;
T_386A:	bsr	T_1976
	tst.l	$AA(a6)
	beq.s	T_3868
	clr.l	$AA(a6)
	move.l	$AE(a6),a0
	bra	T_1984
;
;------------------------------------
;
T_3880:	tst.b	$174(a6)
	bne.s	T_386A
	bsr	T_390C
	move	4(a2),d7
	lsr	#4,d7
	tst	$DC(a6)
	bne.s	T_3898
	addq	#2,d7
T_3898:	lsl	#1,d7
	mulu	ref_planes-cref(a6),d7
	mulu	6(a2),d7
	cmp.l	$AA(a6),d7
	bls.s	T_3868
	bsr.s	T_386A
	bsr	malloc_query
	cmp.l	d0,d7
	bhi.s	T_38C4
	move.l	d7,d0
	bsr	malloc_d0
	tst.l	d0
	beq.s	T_38C4
	move.l	d0,$AE(a6)
	move.l	d7,$AA(a6)
T_38C4:	rts
;
;----------------------------------------------------------------------------
;
objc_draw_0_2:
	moveq	#0,d0
	moveq	#2,d1
objc_draw_d0_d1:
	bsr.s	T_390C
objc_draw_d0_d1_raw:
	lea	UIS_contrl(pc),a0
	move.l	#$2a0006,(a0)+		;objc_draw
	move.l	#$10001,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	d0,(a0)+
	move	d1,(a0)+
	lea	(a2),a1
	move.l	(a1)+,(a0)+
	move.l	(a1),(a0)
	lea	UIS_addrin(pc),a0
	lea	(a3),a1
	move.l	(a1),(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
T_3900:
	move.l	$100(a6),a0
	bset	#7,9(a0)
	rts
;
;----------------------------------------------------------------------------
;
T_390C:	lea	$52(a6),a2
	lea	$2E(a6),a3
	move	$DC(a6),d2
T_3918:	addq.l	#8,a2
	addq.l	#4,a3
	dbra	d2,T_3918
	rts
;
;----------------------------------------------------------------------------
;
T_3922:	moveq	#-1,d0
	bra.s	T_3928
;
;------------------------------------
;
T_3926:	moveq	#0,d0
T_3928:	bsr	T_390C
	move.l	(a3),a3
	moveq	#$18,d1
	mulu	d7,d1
	move	6(a3,d1),d2
	move.l	12(a3,d1),a3
	cmp	#$1C,d2
	beq.s	T_3942
	move.l	(a3),a3
T_3942:	tst	d0
	bne.s	T_3958
T_3946:	move.b	(a5)+,(a3)+
	bne.s	T_3946
T_394A:	move	d7,d0
T_394C:	tst	$DA(a6)
	beq.s	T_395C
	clr	d1
	bra	objc_draw_d0_d1
;
;------------------------------------
;
T_3958:	move.b	(a3)+,(a5)+
	bne.s	T_3958
T_395C:	rts
;
;----------------------------------------------------------------------------
;
objc_change_SELECTED:
	moveq	#1,d0
	bra.s	objc_change_d0
;
;------------------------------------
;
objc_change_DISABLED:
	moveq	#8,d0
	bra.s	objc_change_d0
;
;------------------------------------
;
objc_change_NORMAL:
	moveq	#0,d0
objc_change_d0:
	bsr	T_390C
	bsr.s	T_39B2
	lea	UIS_contrl(pc),a0
	move.l	#$2F0008,(a0)+		;objc_change
	move.l	#$10001,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	d7,(a0)+
	move	#0,(a0)+
	lea	(a2),a1
	move.l	(a1)+,(a0)+
	move.l	(a1),(a0)+
	move	d0,(a0)+
	move	$DA(a6),(a0)
	lea	UIS_addrin(pc),a0
	lea	(a3),a1
	move.l	(a1),(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	move	UIS_intout(pc),d0
	bra	T_3900
;
;------------------------------------
;
T_39B2:	move.l	$100(a6),a0
	bclr	#7,9(a0)
	rts
;
;----------------------------------------------------------------------------
;
T_39BE:	movem.l	d6-d7/a3,-(sp)
	move	$DC(a6),-(sp)
	move	#8,$DC(a6)
	moveq	#7,d0
	move.l	$52(a6),a0
	lea	$18(a0),a0
T_39d6:	bclr	#7,9(a0)
	move.l	a2,12(a0)
	tst.b	(a2)
	bne.s	T_39EA
	bset	#7,9(a0)
T_39EA:	tst.b	(a2)+
	bne.s	T_39EA
	lea	$18(a0),a0
	dbra	d0,T_39d6
	bsr	T_35C0
	move	(sp)+,$DC(a6)
	bsr	T_390C
	lea	$9A(a6),a2
	bsr	T_3596
	move	d7,d0
	sub	#5,d0
	movem.l	(sp)+,d6-d7/a3
	rts
;
;----------------------------------------------------------------------------
;
T_3a16:	move.l	ref_fsel_path_p-cref(a6),a5
T_3a1A:	move.l	a5,a4
T_3a1C:	tst.b	(a5)+
	bne	T_3a1C
	moveq	#$24,d0
	bsr	T_a48
	beq.s	T_3a2C
	moveq	#$40,d0
T_3a2C:	subq.l	#1,a5
	cmpa.l	a4,a5
	beq	T_3a46
	dbra	d0,T_3a2C
T_3a38:	cmpi.b	#$5C,(a5)+
	bne	T_3a38
	subq.l	#1,a5
	bra	T_3a1A
;
;------------------------------------
;
T_3a46:	move.l	a5,d0
	sub.l	ref_fsel_path_p-cref(a6),d0
	move	d0,$F6(a6)
	moveq	#11,d7
	bra	T_3926
;
;------------------------------------
;
T_3a56:	move.l	ref_fsel_name_p-cref(a6),a5
T_3a5A:	lea	$130(a6),a4
	moveq	#0,d1
	bsr.s	T_3a6C
	lea	$130(a6),a5
	moveq	#$1B,d7
	bra	T_3926
;
;------------------------------------
;
T_3a6C:	moveq	#7,d0
T_3a6E:	cmpi.b	#$2E,(a5)
	beq.s	T_3A9A
	move.b	(a5)+,(a4)+
	beq.s	T_3A98
	dbra	d0,T_3a6E
T_3A7C:	moveq	#3,d0
	tst	d1
	bne.s	T_3A8E
	subq	#1,d0
	cmpi.b	#$2E,(a5)+
	beq	T_3A8E
	subq.l	#1,a5
T_3A8E:	move.b	(a5)+,(a4)+
	beq.s	T_3A98
	dbra	d0,T_3A8E
	clr.b	(a4)+
T_3A98:	rts
;
;----------------------------------------------------------------------------
;
T_3A9A:	move.b	#$20,(a4)+
	dbra	d0,T_3A9A
	bra	T_3A7C
;
;------------------------------------
;
T_3Aa6:	clr	d1
T_3AA8:	tst	d1
	bne.s	T_3AB6
	cmpi.b	#$2E,(a1)
	beq.s	T_3AE2
	tst.b	(a1)
	beq.s	T_3AE2
T_3AB6:	cmpm.b	(a0)+,(a1)+
	beq.s	T_3Ad4
	cmpi.b	#$3F,-$1(a0)
	beq.s	T_3Ad4
	cmpi.b	#$2A,-$1(a0)
	beq.s	T_3Ad4
	cmpi.b	#$2A,-$2(a0)
	bne.s	T_3AE0
	subq.l	#1,a0
T_3Ad4:	tst.b	-$1(a1)
	beq.s	T_3AE0
	tst.b	-$1(a0)
	bne.s	T_3AA8
T_3AE0:	rts
;
;----------------------------------------------------------------------------
;
T_3AE2:	moveq	#1,d1
	cmpi.b	#$2E,(a0)
	bne.s	T_3AF2
	tst.b	(a1)
	bne.s	T_3AB6
	addq.l	#1,a0
	bra.s	T_3AB6
;
;------------------------------------
;
T_3AF2:	move.b	(a0)+,d0
	beq.s	T_3B04
	cmp.b	#$2A,d0
	beq.s	T_3AE2
	cmp.b	#$3F,d0
	beq.s	T_3AE2
	rts
;
;----------------------------------------------------------------------------
;
T_3B04:	tst.b	(a1)+
	beq.s	T_3AE0
	tst.b	(a1)
	rts
;
;----------------------------------------------------------------------------
;
T_3B0C:	bsr	T_3B4E
T_3B10:	move.l	ref_fsel_path_p-cref(a6),a5
	moveq	#$5C,d2
	bsr	T_3C12
	bpl.s	T_3B22
	moveq	#$3A,d2
	bsr	T_3C12
T_3B22:	lea	1(a5,d1),a5
T_3B26:	bsr	T_390C
	move.l	(a3),a3
	move.l	$174(a3),a3
	move.l	(a3),a3
	move.b	#$20,(a3)+
	moveq	#11,d0
T_3B38:	tst.b	(a5)
	beq.s	T_3B42
	move.b	(a5)+,(a3)+
	dbra	d0,T_3B38
T_3B42:	move.b	#$20,(a3)+
	clr.b	(a3)
	moveq	#15,d7
	bra	T_394A
;
;------------------------------------
;
T_3B4E:	move.l	ref_fsel_path_p-cref(a6),a5
	move	$F6(a6),d0
	lea	0(a5,d0),a5
	moveq	#11,d7
	bra	T_3922
;
;------------------------------------
;
T_3B60:	bsr.s	T_3B4E
T_3B62:	bsr.s	T_3B68
	bra	T_3a16
;
;------------------------------------
;
T_3B68:	move.l	ref_fsel_path_p-cref(a6),a5
	cmpi.b	#$3A,1(a5)
	bne.s	T_3Ba6
	cmpi.b	#$5C,2(a5)
	beq.s	T_3B90
	moveq	#2,d0
	moveq	#$5C,d1
T_3B80:	move.b	0(a5,d0),d2
	move.b	d1,0(a5,d0)
	beq.s	T_3Ba6
	move.b	d2,d1
	addq	#1,d0
	bra.s	T_3B80
;
;------------------------------------
;
T_3B90:	cmpi.b	#$5C,3(a5)
	bne.s	T_3Ba6
	moveq	#3,d0
T_3B9A:	move.b	1(a5,d0),0(a5,d0)
	beq.s	T_3Ba6
	addq	#1,d0
	bra.s	T_3B9A
;
;------------------------------------
;
T_3Ba6:	moveq	#$5C,d2
	bsr	T_3C12
	bpl.s	T_3Bd4
	moveq	#$3A,d2
	bsr	T_3C12
	bpl.s	T_3BE0
	tst.b	(a5)
	beq.s	T_3BEC
T_3BBA:	moveq	#$2E,d2
	bsr	T_3C12
	bmi.s	T_3BCE
	lea	1(a5,d1),a5
	tst.b	(a5)
	beq	T_3C0A
	rts
;
;----------------------------------------------------------------------------
;
T_3BCE:	lea	0(a5,d0),a5
	bra.s	T_3C06
;
;------------------------------------
;
T_3Bd4:	lea	1(a5,d1),a5
	tst.b	(a5)
	beq.s	T_3C02
	bra	T_3BBA
;
;------------------------------------
;
T_3BE0:	lea	1(a5,d1),a5
	tst.b	(a5)
	beq.s	T_3BFE
	bra	T_3BBA
;
;------------------------------------
;
T_3BEC:	move	#$19,-(sp)
	trap	#1			;Dgetdrv
	addq.l	#2,sp
	addi.b	#$41,d0
	move.b	d0,(a5)+
	move.b	#$3A,(a5)+
T_3BFE:	move.b	#$5C,(a5)+
T_3C02:	move.b	#$2A,(a5)+
T_3C06:	move.b	#$2E,(a5)+
T_3C0A:	move.b	#$2A,(a5)+
	clr.b	(a5)
	rts
;
;----------------------------------------------------------------------------
;
T_3C12:	moveq	#-1,d0
T_3C14:	move	d0,d1
T_3C16:	addq	#1,d0
	cmp.b	0(a5,d0),d2
	beq.s	T_3C14
	tst.b	0(a5,d0)
	bne.s	T_3C16
	tst	d1
	rts
;
;----------------------------------------------------------------------------
;
T_3C28:	move.l	patch_area_3_p-cref(a6),a5
	move.l	a5,a4
	move.l	ref_fsel_path_p-cref(a6),a1
T_3C32:	move.b	(a1)+,(a5)+
	bne.s	T_3C32
T_3C36:	cmpa.l	a4,a5
	beq.s	T_3C02
	cmpi.b	#$5C,-$1(a5)
	beq.s	T_3C02
	cmpi.b	#$3A,-$1(a5)
	beq.s	T_3BFE
	subq.l	#1,a5
	bra.s	T_3C36
;
;------------------------------------
;
T_3C4E:	bsr	T_3B0C
	move	$E6(a6),$E2(a6)
	clr	$E6(a6)
	tst	$FE(a6)
	bne.s	T_3C66
	clr	$10A(a6)
T_3C66:	bsr.s	T_3C28
	move.l	ref_fsel_path_p-cref(a6),a5
	moveq	#$5C,d2
	bsr	T_3C12
	bpl.s	T_3C7A
	moveq	#$3A,d2
	bsr	T_3C12
T_3C7A:	lea	1(a5,d1),a3
	clr	d7
	move	#$17,-(sp)
	pea	(a4)
	move	#$4E,-(sp)
	trap	#1			;Fsfirst
	addq.l	#8,sp
	bra.s	T_3C98
;
;------------------------------------
;
T_3C90:	move	#$4F,-(sp)
	trap	#1			;Fsnext
	addq.l	#2,sp
T_3C98:	tst	d0
	bne.s	T_3CF8
	lea	$1AA(a6),a2
	cmpi.b	#$10,-$1(a2)
	bne.s	T_3CB2
	cmpi.b	#$2E,8(a2)
	beq.s	T_3C90
	bra.s	T_3CCE
;
;------------------------------------
;
T_3CB2:	tst	$B6(a6)
	beq.s	T_3CC2
	move.b	-$1(a2),d0
	andi.b	#6,d0
	bne.s	T_3C90
T_3CC2:	lea	8(a2),a1
	move.l	a3,a0
	bsr	T_3Aa6
	bne.s	T_3C90
T_3CCE:	cmp	$18E(a6),d7
	bcc.s	T_3CE4
	moveq	#$14,d0
T_3Cd6:	move.b	(a2)+,(a4)+
	dbra	d0,T_3Cd6
	move.b	$1A9(a6),(a4)+
	addq	#1,d7
	bra.s	T_3C90
;
;------------------------------------
;
T_3CE4:	cmp	#$190,$18E(a6)
	bcs.s	T_3CF8
	lea	folder_file_count_limit_alst(pc),a2
	bsr	T_39BE
	move	$18E(a6),d7
T_3CF8:	move	d7,$F8(a6)
	tst	$FC(a6)
	bne	T_3E0E
T_3d04:	move	$F8(a6),d7
	lea	$25E2(a6),a0
	move	#$18F,d0
	moveq	#0,d1
T_3d12:	move	d1,(a0)+
	add	#$16,d1
	dbra	d0,T_3d12
	tst	$B4(a6)
T_3d20:	beq	T_3E0E
	move	d7,d6
T_3d26:	lsr	#1,d6
	beq.s	T_3d20
	move	d7,d5
	sub	d6,d5
	moveq	#0,d4
T_3d30:	swap	d5
	move	d4,d5
T_3d34:	lea	$25E2(a6),a4
	move	d5,d0
	lsl	#1,d0
	lea	0(a4,d0),a4
	move	(a4),d0
	move	d6,d1
	lsl	#1,d1
	move	0(a4,d1),d1
	move.l	patch_area_3_p-cref(a6),a1
	lea	0(a1,d0),a0
	lea	0(a1,d1),a1
	move.b	$15(a0),d2
	andi.b	#$7F,d2
	move.b	$15(a1),d0
	andi.b	#$7F,d0
	cmp.b	d0,d2
	beq.s	T_3D82
	btst	#4,d0
	bne	T_3DF6
	btst	#4,d2
	beq.s	T_3D82
T_3d78:	addq	#1,d4
	swap	d5
	cmp	d5,d4
	beq.s	T_3d26
	bra.s	T_3d30
;
;------------------------------------
;
T_3D82:	move	$B4(a6),d0
	cmp	#4,d0
	beq.s	T_3DB4
	subq	#1,d0
	beq.s	T_3DE4
	subq	#1,d0
	beq.s	T_3DA8
	btst	#4,d2
	bne.s	T_3DE4
	move.l	4(a0),d0
	cmp.l	4(a1),d0
T_3Da2:	bcs.s	T_3DF6
	beq.s	T_3DE4
T_3Da6:	bra.s	T_3d78
;
;------------------------------------
;
T_3DA8:	move.l	(a0),d0
	swap	d0
	move.l	(a1),d1
	swap	d1
	cmp.l	d1,d0
	bra.s	T_3Da2
;
;------------------------------------
;
T_3DB4:	lea	8(a0),a2
	lea	8(a1),a3
T_3DBC:	cmpi.b	#$2E,(a2)+
	beq.s	T_3DCA
	tst.b	-$1(a2)
	bne.s	T_3DBC
	subq.l	#1,a2
T_3DCA:	cmpi.b	#$2E,(a3)+
	beq.s	T_3DD8
	tst.b	-$1(a3)
	bne.s	T_3DCA
	subq.l	#1,a3
T_3DD8:	cmpm.b	(a3)+,(a2)+
	bhi.s	T_3DF6
	bcs.s	T_3Da6
	tst.b	-$1(a2)
	bne.s	T_3DD8
T_3DE4:	addq.l	#8,a0
	addq.l	#8,a1
T_3DE8:	cmpm.b	(a1)+,(a0)+
	bhi.s	T_3DF6
	bcs.s	T_3Da6
	tst.b	-$1(a0)
	bne.s	T_3DE8
	bra.s	T_3Da6
;
;------------------------------------
;
T_3DF6:	move	(a4),d0
	move	d6,d1
	lsl	#1,d1
	move	0(a4,d1),(a4)
	move	d0,0(a4,d1)
	sub	d6,d5
	bpl	T_3d34
	bra	T_3d78
;
;------------------------------------
;
T_3E0E:	move	$E2(a6),d0
	beq.s	T_3E2A
	sub	$2C(a6),d7
	bmi.s	T_3E28
	cmp	d7,d0
	bls.s	T_3E2A
	move	d7,d0
	add	$2E(a6),d0
	subq	#1,d0
	bra.s	T_3E2A
;
;------------------------------------
;
T_3E28:	clr	d0
T_3E2A:	bsr	T_286C
	move	#-$2,$E4(a6)
	tst	$FC(a6)
	beq.s	T_3E60
	move	$F8(a6),d0
	move.l	patch_area_3_p-cref(a6),a0
	lea	$25E2(a6),a1
	bra.s	T_3E58
;
;------------------------------------
;
T_3E48:	move	(a1)+,d1
	bpl.s	T_3E58
	not.w	d1
	move	d1,-$2(a1)
	ori.b	#$80,$15(a0,d1)
T_3E58:	dbra	d0,T_3E48
	clr	$FC(a6)
T_3E60:	bsr.s	T_3E70
	bra	T_28d2
;
;------------------------------------
;
T_3E66:	bsr.s	T_3E94
T_3E68:	move	$E2(a6),$E6(a6)
	rts
;
;----------------------------------------------------------------------------
;
T_3E70:	move	$E2(a6),d5
	move	$E4(a6),d6
	cmp	d6,d5
	beq.s	T_3EB2
	bsr	T_2B80
	sub	$2E(a6),d5
	cmp	d6,d5
	beq.s	T_3EBE
	add	$2E(a6),d5
	add	$2E(a6),d5
	cmp	d6,d5
	beq.s	T_3EBA
T_3E94:	bsr	graf_mouse_hide
	moveq	#0,d6
	move	$2C(a6),d6
T_3E9E:	subq	#1,d6
T_3Ea0:	swap	d6
	bsr	T_3F38
	addq	#1,d6
	swap	d6
	dbra	d6,T_3Ea0
	bsr	graf_mouse_show
T_3EB2:	move	$E2(a6),$E4(a6)
	rts
;
;----------------------------------------------------------------------------
;
T_3EBA:	moveq	#8,d6
	bra.s	T_3ECA
;
;------------------------------------
;
T_3EBE:	move	$2C(a6),d6
	sub	$2E(a6),d6
	swap	d6
	clr	d6
T_3ECA:	move.l	d6,-(sp)
	move	$2C(a6),d6
	subq	#1,d6
	bsr	T_4036
	move.l	(sp)+,d6
	lea	$1A8(a6),a5
	move	char_height(pc),d5
	lsr	#1,d5
	moveq	#12,d7
	bsr	objc_offset_sub
	addq	#8,d3
	add	d5,d4
	move	d3,(a5)
	move	d3,8(a5)
	move	d4,2(a5)
	move	d4,10(a5)
	move	#13,d7
	bsr	objc_offset_sub
	move.l	$100(a6),a0
	add	$14(a0),d3
	subq	#1,d4
	move	d3,4(a5)
	move	d3,12(a5)
	move	d4,6(a5)
	move	d4,14(a5)
	move	$30(a6),d5
	add	d5,2(a5,d6)
	add	d5,6(a5,d6)
	move	$2E(a6),d6
	bsr	graf_mouse_hide
	bsr	vro_cpyfm_194_ia6
	bra	T_3E9E
;
;------------------------------------
;
T_3F38:	bsr	T_4036
	lea	$194(a6),a4
	move	$E2(a6),d0
	add	d6,d0
	cmp	$F8(a6),d0
	bcc	T_4002
	lsl	#1,d0
	lea	$25E2(a6),a0
	move	0(a0,d0),d0
	move.l	patch_area_3_p-cref(a6),a3
	lea	0(a3,d0),a3
	moveq	#7,d0
	btst	#4,$15(a3)
	bne.s	T_3F76
	moveq	#8,d0
	btst	#0,$15(a3)
	bne.s	T_3F76
	moveq	#$20,d0
T_3F76:	move.b	d0,(a4)+
	move.b	#$20,(a4)+
	bsr	T_40B2
	clr	d0
	move.b	$15(a3),d1
	bpl.s	T_3F8C
	bset	#0,d0
T_3F8C:	andi.b	#6,d1
	beq.s	T_3F96
	bset	#3,d0
T_3F96:	move.l	$100(a6),a0
	move.b	d0,11(a0)
T_3F9E:	lea	$194(a6),a5
	bsr	T_a48
	beq.s	T_3FBE
	cmp	#1,$2E(a6)
	bhi.s	T_3FBE
	clr.b	$2B(a5)
T_3FB4:	bsr	T_39B2
	moveq	#13,d0
	bra	T_394C
;
;------------------------------------
;
T_3FBE:	move	ref_bottom_bar_type-cref(a6),d1
	beq.s	T_3FFC
	cmpi.b	#7,(a5)
	bne.s	T_3Fd0
	cmp	#1,d1
	beq.s	T_3FFC
T_3Fd0:	moveq	#13,d0
	lea	1(a5),a0
T_3Fd6:	move.b	#$20,(a0)+
	dbra	d0,T_3Fd6
	moveq	#15,d0
	subq	#1,d1
	beq.s	T_3FEC
	moveq	#$19,d0
	subq	#1,d1
	beq.s	T_3FEC
	moveq	#$23,d0
T_3FEC:	lea	0(a5,d0),a1
	lea	4(a5),a0
	moveq	#7,d0
T_3FF6:	move.b	(a1)+,(a0)+
	dbra	d0,T_3FF6
T_3FFC:	clr.b	15(a5)
	bra.s	T_3FB4
;
;------------------------------------
;
T_4002:	moveq	#$2A,d0
T_4004:	move.b	#$5F,0(a4,d0)
	dbra	d0,T_4004
	move	#$2020,(a4)
	move.b	#$2E,10(a4)
	move.b	#$20,14(a4)
	move.l	#$5F20205F,$16(a4)
	move.l	$16(a4),$20(a4)
	move.b	#$20,$28(a4)
	bra	T_3F9E
;
;------------------------------------
;
T_4036:	move.l	$100(a6),a0
	move.l	12(a0),a0
	move	#3,12(a0)
	moveq	#8,d1
	tst	$C0(a6)
	beq.s	T_4054
	move	#5,12(a0)
	moveq	#6,d1
T_4054:	move.l	$100(a6),a0
	clr.b	11(a0)
	clr	8(a0)
	move	$30(a6),$16(a0)
	move	#$10,$10(a0)
	move	d6,d0
	bsr	T_a48
	beq.s	T_4098
	cmp	#1,$2E(a6)
	bhi.s	T_4082
	mulu	#$2B,d1
	bra.s	T_409C
;
;------------------------------------
;
T_4082:	ext.l	d0
	divu	$2E(a6),d0
	move.l	d0,d2
	swap	d2
	mulu	#15,d2
	mulu	d1,d2
	addq	#8,d2
	move	d2,$10(a0)
T_4098:	mulu	#15,d1
T_409C:	move	d1,$14(a0)
	mulu	$30(a6),d0
	move	char_height(pc),d1
	lsr	#1,d1
	add	d1,d0
	move	d0,$12(a0)
	rts
;
;----------------------------------------------------------------------------
;
T_40B2:	lea	8(a3),a5
	lea	13(a4),a2
	moveq	#-1,d1
	bsr	T_3a6C
	subq.l	#1,a4
T_40C2:	cmpa.l	a2,a4
	beq.s	T_40CC
	move.b	#$20,(a4)+
	bra.s	T_40C2
;
;------------------------------------
;
T_40CC:	move.l	4(a3),d2
	bsr	T_416E
	addq.l	#1,a1
	moveq	#7,d0
T_40D8:	move.b	(a1)+,(a4)+
	btst	#4,$15(a3)
	beq.s	T_40E8
	move.b	#$20,-$1(a4)
T_40E8:	dbra	d0,T_40D8
	move.b	#$20,(a4)+
	move.b	#$20,(a4)+
T_40F4:	move	2(a3),d3
	move	d3,d1
	lsr	#5,d1
	and	#15,d1
	bsr.s	T_4164
	move.b	#$2D,(a4)+
	move	d3,d1
	and	#$1F,d1
	bsr.s	T_4164
	move.b	#$2D,(a4)+
	move	d3,d1
	rol	#7,d1
	and	#$7F,d1
	add	#$50,d1
	bsr.s	T_4164
	move.b	#$20,(a4)+
	move.b	#$20,(a4)+
	move	(a3),d3
	move	d3,d1
	rol	#5,d1
	and	#$1F,d1
	moveq	#$61,d4
	cmp	#12,d1
	bcs.s	T_4140
	moveq	#$70,d4
	sub	#12,d1
T_4140:	tst	d1
	bne.s	T_4146
	moveq	#12,d1
T_4146:	bsr.s	T_4164
	move.b	#$3A,(a4)+
	move	d3,d1
	lsr	#5,d1
	and	#$3F,d1
	bsr.s	T_4164
	move.b	#$20,(a4)+
	move.b	d4,(a4)+
	move.b	#$6D,(a4)+
	clr.b	(a4)+
	rts
;
;----------------------------------------------------------------------------
;
T_4164:	moveq	#1,d0
	addq.l	#2,a4
	move.l	a4,a0
	ext.l	d1
	bra.s	T_418E
;
;------------------------------------
;
T_416E:	lea	$139(a6),a0
	clr.b	(a0)
	move.l	d2,d1
	moveq	#8,d0
	bsr.s	T_418E
	moveq	#7,d0
	move.l	a0,a1
T_417E:	cmpi.b	#$30,(a0)
	bne.s	T_418C
	move.b	#$20,(a0)+
	dbra	d0,T_417E
T_418C:	rts
;
;----------------------------------------------------------------------------
;
T_418E:	move.l	d2,-(sp)
T_4190:	move.l	d1,d2
	clr	d1
	swap	d1
	beq.s	T_41a4
	divu	#10,d1
	swap	d1
	swap	d2
	move	d1,d2
	swap	d2
T_41a4:	divu	#10,d2
	move	d2,d1
	swap	d2
	addi.b	#'0',d2
	move.b	d2,-(a0)
	dbra	d0,T_4190
	move.l	(sp)+,d2
	rts
;
;----------------------------------------------------------------------------
;
T_41BA:	move.l	$32(a6),a5
	lea	$360(a5),a5
	move.l	a5,a4
	move.l	a5,a3
	bios	Drvmap
	move.l	d0,d6
	moveq	#0,d2
	moveq	#$19,d1
T_41d4:	move.b	#$90,9(a4)
	clr	10(a4)
	move.b	#$20,12(a4)
	lea	$18(a4),a4
	lsr.l	#1,d0
	bcc.s	T_41EE
	addq	#1,d2
T_41EE:	dbra	d1,T_41d4
	move	d2,d0
	cmp	#9,d2
	bls.s	T_420C
	cmp	#$12,d2
	bls.s	T_4206
	move	#9,d2
	bra.s	T_420C
;
;------------------------------------
;
T_4206:	lsr	#1,d2
	bcc.s	T_420C
	addq	#1,d2
T_420C:	move	d2,d4
	swap	d4
	clr	d4
	moveq	#$19,d5
	moveq	#$41,d3
T_4216:	lsr.l	#1,d6
	bcc.s	T_4238
	move.b	d3,12(a5)
	move.b	#$51,9(a5)
	lea	$18(a5),a5
	subq	#1,d2
	bne.s	T_4238
	add	#$D8,d4
	lea	0(a3,d4),a5
	move.l	d4,d2
	swap	d2
T_4238:	addq	#1,d3
	dbra	d5,T_4216
	btst	#0,d0
	beq.s	T_4256
	cmp	#9,d0
	bls.s	T_4256
	cmp	#$12,d0
	bcc.s	T_4256
	bclr	#7,9(a5)
T_4256:	tst.b	$EA(a6)
	beq.s	T_4278
	bpl.s	T_426A
	addq	#8,-$8(a3)
	sub	#15,-$4(a3)
	bra.s	T_4274
;
;------------------------------------
;
T_426A:	subq	#8,-$8(a3)
	add	#15,-$4(a3)
T_4274:	clr.b	$EA(a6)
T_4278:	cmp	#9,d0
	bls.s	T_4294
	cmp	#$12,d0
	bls.s	T_42a2
	subq	#8,-$8(a3)
	add	#15,-$4(a3)
	subq.b	#1,$EA(a6)
	bra.s	T_42a2
;
;------------------------------------
;
T_4294:	addq	#8,-$8(a3)
	sub	#15,-$4(a3)
	addq.b	#1,$EA(a6)
T_42a2:	moveq	#$24,d7
T_42a4:	bsr	objc_change_NORMAL
	addq	#1,d7
	cmp	#$3D,d7
	bls.s	T_42a4
	bsr.s	T_42D8
	move	d7,$EC(a6)
	move	d7,d6
	add	#$41,d6
	moveq	#$24,d7
	move.l	$32(a6),a5
	lea	$360(a5),a5
T_42C6:	cmp.b	12(a5),d6
	beq.s	T_42d4
	lea	$18(a5),a5
	addq	#1,d7
	bra.s	T_42C6
;
;------------------------------------
;
T_42d4:	bra	objc_change_SELECTED
;
;------------------------------------
;
T_42D8:
	gemdos	Dgetdrv
	move	d0,d7
	move.l	ref_fsel_path_p-cref(a6),a5
	cmpi.b	#':',1(a5)
	bne.s	T_4312
	move.b	(a5),d6
	subi.b	#'A',d6
	cmp.b	#$19,d6
	bhi.s	T_4314
	ext.w	d6
	bios	Drvmap
	move	d6,d1
	beq	T_430C
	lsr.l	d1,d0
T_430C:	lsr.b	#1,d0
	bcc.s	T_4314
	move	d6,d7
T_4312:	rts
;
;----------------------------------------------------------------------------
;
T_4314:	move.b	d7,(a5)
	addi.b	#'A',(a5)
	move	d7,-(sp)
	move	#11,d7
	bsr	T_3926
	move	(sp)+,d7
	rts
;
;----------------------------------------------------------------------------
;
T_4328:	cmp	#4,$108(a6)
	beq.s	T_435E
	movem.l	d4-d7/a3-a5,-(sp)
	move	$DC(a6),-(sp)
	move	#0,$DC(a6)
	bsr	T_3a1A
	tas.b	$106(a6)
	bmi.s	T_4356
	lea	T_765C(pc),a5
	moveq	#4,d7
	bsr	T_3926
	bsr	objc_change_SELECTED
T_4356:	move	(sp)+,$DC(a6)
	movem.l	(sp)+,d4-d7/a3-a5
T_435E:	rts
;
;----------------------------------------------------------------------------
;
T_4360:	cmp	#4,$108(a6)
	beq.s	T_43B8
	cmp	#5,$DC(a6)
	beq.s	T_43B8
	tst	$18C(a6)
	bmi.s	T_43B8
	movem.l	d1/d4-d7/a2-a5,-(sp)
	move	#5,$DC(a6)
	clr	$DA(a6)
	bsr	T_439C
	bsr	T_43a4
	move	#1,$DA(a6)
	bsr	objc_draw_0_2
	movem.l	(sp)+,d1/d4-d7/a2-a5
	rts
;
;----------------------------------------------------------------------------
;
T_439C:	move	$182(a6),d2
	moveq	#5,d7
	bra.s	T_43AA
;
;------------------------------------
;
T_43a4:	move	$180(a6),d2
	moveq	#3,d7
T_43AA:	ext.l	d2
	bsr	T_416E
	lea	5(a1),a5
	bra	T_3926
;
;------------------------------------
;
T_43B8:	rts
;
;----------------------------------------------------------------------------
;
T_43BA:	moveq	#-1,d0
	bra.s	T_43C0
;
;------------------------------------
;
T_43BE:	moveq	#0,d0
T_43C0:	cmp	#4,$108(a6)
	beq.s	T_43B8
	tst	$18C(a6)
	bmi.s	T_43B8
	cmp	#5,$DC(a6)
	beq.s	T_43DE
	move	d0,-(sp)
	bsr	T_4360
	move	(sp)+,d0
T_43DE:	movem.l	d1/d4-d7/a2-a5,-(sp)
	tst	d0
	beq.s	T_43F8
	tst	$180(a6)
	beq.s	T_43F2
	subq	#1,$180(a6)
	bsr.s	T_43a4
T_43F2:	movem.l	(sp)+,d1/d4-d7/a2-a5
	rts
;
;------------------------------------
;
T_43F8:	tst	$182(a6)
	beq.s	T_43F2
	subq	#1,$182(a6)
	bsr.s	T_439C
	bra.s	T_43F2
;
;----------------------------------------------------------------------------
;
;T_4406:
malloc_query:
	moveq	#-1,d0
;T_4408:
malloc_d0:
	gemdos	Malloc,d0
	rts
;
;----------------------------------------------------------------------------
; The routine above was shortened by removing a gemdos patch, that violated
; modern programming rules.  This made 28 bytes room for the routines below
;----------------------------------------------------------------------------
malloc_pad_start:
;
check_600_16E_ia6:	;sub tests width*8/char_width < 340
;;;	orig:	cmp	#600,$16E(a6)	;width < 600 ?
	move	$16E(a6),d0		;4
	ext.l	d0			;2
	asl.l	#3,d0			;2
	divu	char_width(pc),d0	;4
	cmp	#600,d0			;4
	rts				;2
;
check_340_d0:		;sub tests width*8/char_width < 340
;;;	orig:	cmp	#340,d0			;width < 340 ?
	cmp	#340,d0		;4 ;
	rts			;2 ;
;
malloc_pad	set 28-(*-malloc_pad_start)	;calculate code length difference
	rept	malloc_pad/2			;\
	nop					; X Pad to maintain code length
	endr					;/
;
;----------------------------------------------------------------------------
;
T_4430:	tst	$11A(a6)
	bmi.s	T_4454
	bne.s	T_4456
	bsr.s	malloc_query
	cmp.l	#$2710,d0
	blo.s	T_4456
	move.l	d0,$120(a6)
	bsr.s	malloc_d0
	tst.l	d0
	beq.s	T_4456
	move.l	d0,$11C(a6)
	st	$11A(a6)
T_4454:	rts
;
;----------------------------------------------------------------------------
;
T_4456:	move.l	patch_area_3_p-cref(a6),$11C(a6)
	moveq	#$16,d0
	mulu	$18E(a6),d0
	move.l	d0,$120(a6)
	st	$11B(a6)
	rts
;
;----------------------------------------------------------------------------
;
T_446C:	bsr	T_4360
	bsr	graf_mouse_busybee
	move.l	#-1,$124(a6)
	tst	$108(a6)
	bne.s	T_4484
	bsr.s	T_4430
T_4484:	clr	-(sp)
	lea	$24D8(a6),a5
	lea	$2556(a6),a4
	move	$24d2(a6),d5
	move	$2550(a6),d4
	move	#$17,-(sp)
	pea	(a5)
	move	#$4E,-(sp)
	trap	#1			;Fsfirst
	addq.l	#8,sp
	bra.s	T_44C2
;
;------------------------------------
;
T_44a6:	bsr	T_43BE
	moveq	#-$31,d0
	tst.b	-$3(a5)
	beq.s	T_44BA
	bpl.s	T_44C6
	tst.b	-$4(a5)
	beq.s	T_44C6
T_44BA:	move	#$4F,-(sp)
	trap	#1			;Fsnext
	addq.l	#2,sp
T_44C2:	tst	d0
	beq.s	T_44CA
T_44C6:	move	(sp)+,d7
	rts
;
;----------------------------------------------------------------------------
;
T_44CA:	lea	$1B2(a6),a1
	move.b	$1A9(a6),d6
	andi.b	#$17,d6
	ext.w	d6
	btst	#4,d6
	beq.s	T_44E8
	cmpi.b	#$2E,(a1)
	beq.s	T_44BA
	addq	#1,(sp)
	bra.s	T_44BA
;
;------------------------------------
;
T_44E8:	lea	0(a5,d5),a3
	lea	0(a4,d4),a2
T_44F0:	move.b	(a1),(a3)+
	move.b	(a1)+,(a2)+
	bne.s	T_44F0
	bsr	T_4328
	cmp	#4,$108(a6)
	beq.s	T_451C
	bsr	T_2CAA
	cmp.b	#$61,d0
	bne.s	T_451C
	lea	cancel_this_operation_alst(pc),a2
	bsr	T_39BE
	cmp	#1,d0
	beq	T_48BE
T_451C:	move	$108(a6),d0
	beq	T_45B4
	bmi.s	T_455C
	cmp	#2,d0
	beq	T_49B8
	cmp	#3,$108(a6)
	beq	T_4966
	cmp	#4,d0
	beq	T_4a58
	bsr	T_4792
	tst	d1
	bmi.s	T_4558
	pea	(a4)
	move	#$41,-(sp)
	trap	#1			;Fdelete
	addq.l	#6,sp
	tst	d0
	bmi	T_44C6
T_4558:	bra	T_4a08
;
;------------------------------------
;
T_455C:	btst	#0,d6
	beq	T_45a0
	cmp	#$21,$FE(a6)
	bne	T_458C
	lea	locked_file_name_s(pc),a0
	lea	$1B2(a6),a1
	moveq	#11,d1
	bsr	T_1BF4
	lea	locked_file_delete_query_alst(pc),a2
	bsr	T_39BE
	cmp	#2,d0
	beq	T_44a6
T_458C:	move	#0,-(sp)
	move	#1,-(sp)
	pea	(a5)
	move	#$43,-(sp)
	trap	#1			;Fattrib
	lea	10(sp),sp
T_45a0:	pea	(a5)
	move	#$41,-(sp)
	trap	#1			;Fdelete
	addq.l	#6,sp
	tst	d0
	bmi	T_44C6
	bra	T_44a6
;
;------------------------------------
;
T_45B4:	move.l	$11C(a6),a3
	move.l	$1AE(a6),d7
	cmp.l	$120(a6),d7
	bls	T_4748
	move	#0,-(sp)
	pea	(a5)
	move	#$3D,-(sp)
	trap	#1			;Fopen
	addq.l	#8,sp
	move	d0,$124(a6)
	bmi	T_44C6
	pea	(a3)
	move.l	$120(a6),-(sp)
	move	$124(a6),-(sp)
	move	#$3F,-(sp)
	trap	#1			;Fread
	lea	12(sp),sp
	tst.l	d0
	bmi	T_46F6
	bsr	T_4792
	bmi	T_46F6
T_45FC:	pea	(a3)
	move.l	$120(a6),-(sp)
	move	$126(a6),-(sp)
	move	#$40,-(sp)
	trap	#1			;Fwrite
	lea	12(sp),sp
	tst.l	d0
	bmi	T_46F6
	cmp.l	$120(a6),d0
	bcs	T_46F4
	sub.l	$120(a6),d7
	cmp.l	$120(a6),d7
	bls.s	T_4644
	pea	(a3)
	move.l	$120(a6),-(sp)
	move	$124(a6),-(sp)
	move	#$3F,-(sp)
	trap	#1			;Fread
	lea	12(sp),sp
	tst.l	d0
	bmi	T_46F6
	bra.s	T_45FC
;
;------------------------------------
;
T_4644:	pea	(a3)
	move.l	d7,-(sp)
	move	$124(a6),-(sp)
	move	#$3F,-(sp)
	trap	#1			;Fread
	lea	12(sp),sp
	tst.l	d0
	bmi	T_46F6
	move	$124(a6),-(sp)
	move	#$3E,-(sp)
	trap	#1			;Fclose
	addq.l	#4,sp
	move	#-$1,$124(a6)
T_466E:	pea	(a3)
	move.l	d7,-(sp)
	move	$126(a6),-(sp)
	move	#$40,-(sp)
	trap	#1			;Fwrite
	lea	12(sp),sp
	tst.l	d0
	bmi.s	T_46F6
	cmp.l	d7,d0
	bcs.s	T_46F4
	move	$126(a6),-(sp)
	move	#$3E,-(sp)
	trap	#1			;Fclose
	addq.l	#4,sp
	move	#-$1,$126(a6)
	bsr.s	T_46BE
	bra	T_44a6
;
;------------------------------------
;
T_46a0:	move	#$2C,-(sp)
	trap	#1			;Tgettime
	addq.l	#2,sp
	move	d0,$1AA(a6)
	move	#$2A,-(sp)
	trap	#1			;Tgetdate
	addq.l	#2,sp
	move	d0,$1AC(a6)
	lea	$24D8(a6),a4
	bra.s	T_46C4
;
;------------------------------------
;
T_46BE:	tst	$BC(a6)
	bne.s	T_46F2
T_46C4:	move	#0,-(sp)
	pea	(a4)
	move	#$3D,-(sp)
	trap	#1			;Fopen
	addq.l	#8,sp
	move	d0,d7
	move	#1,-(sp)
	move	d7,-(sp)
	pea	$1AA(a6)
	move	#$57,-(sp)
	trap	#1			;Fdatime
	lea	10(sp),sp
	move	d7,-(sp)
	move	#$3E,-(sp)
	trap	#1			;Fclose
	addq.l	#4,sp
T_46F2:	rts
;
;----------------------------------------------------------------------------
;
T_46F4:	moveq	#-$27,d0
T_46F6:	move	d0,d7
	tst	$124(a6)
	bmi.s	T_470A
	move	$124(a6),-(sp)
	move	#$3E,-(sp)
	trap	#1			;Fclose
	addq.l	#4,sp
T_470A:	tst	$126(a6)
	bmi.s	T_473A
	move	$126(a6),-(sp)
	move	#$3E,-(sp)
	trap	#1			;Fclose
	addq.l	#4,sp
	move	#0,-(sp)
	move	#1,-(sp)
	pea	(a4)
	move	#$43,-(sp)
	trap	#1			;Fattrib
	lea	10(sp),sp
	pea	(a4)
	move	#$41,-(sp)
	trap	#1			;Fdelete
	addq.l	#6,sp
T_473A:	move.l	#-1,$124(a6)
	move.l	d7,d0
	bra	T_44C6
;
;------------------------------------
;
T_4748:	move	#0,-(sp)
	pea	(a5)
	move	#$3D,-(sp)
	trap	#1			;Fopen
	addq.l	#8,sp
	move	d0,$124(a6)
	bmi	T_44C6
	pea	(a3)
	move.l	d7,-(sp)
	move	$124(a6),-(sp)
	move	#$3F,-(sp)
	trap	#1			;Fread
	lea	12(sp),sp
	tst.l	d0
	bmi	T_46F6
	move	$124(a6),-(sp)
	move	#$3E,-(sp)
	trap	#1			;Fclose
	addq.l	#4,sp
	move	#-$1,$124(a6)
	bsr.s	T_4792
	bmi	T_44C6
	bra	T_466E
;
;------------------------------------
;
T_4792:	move	#0,-(sp)
	pea	(a4)
	move	#$3D,-(sp)
	trap	#1			;Fopen
	addq.l	#8,sp
	moveq	#-1,d1
	tst	d0
	bmi	T_4894
	move	d0,-(sp)
	move	#$3E,-(sp)
	trap	#1			;Fclose
	addq.l	#4,sp
	movem.l	d4-d7/a3-a5,-(sp)
	lea	0(a4,d4),a5
	moveq	#5,d0
	lea	T_7669(pc),a0
	bsr.s	T_47C6
	bra	T_4866
;
;------------------------------------
;
T_47C6:	move.l	a0,-(sp)
	move.l	$3E(a6),a0
	bclr	#6,d0
	beq.s	T_47DA
	move	d0,$B0(a0)
	moveq	#5,d0
	bra.s	T_47DE
;
;------------------------------------
;
T_47DA:	move	d0,$B0(a0)
T_47DE:	bset	#5,d0
	move	d0,$C8(a0)
	move	#3,$DC(a6)
	clr	$DA(a6)
	lea	$130(a6),a4
	moveq	#0,d1
	bsr	T_3a6C
	lea	$130(a6),a5
	moveq	#4,d7
	bsr	T_3926
	lea	$1B2(a6),a5
	lea	$130(a6),a4
	moveq	#1,d1
	bsr	T_3a6C
	lea	$130(a6),a5
	moveq	#3,d7
	bsr	T_3926
	move.l	(sp)+,a5
	moveq	#2,d7
	bsr	T_3926
	move	#6,$DE(a6)
	tst.b	$162(a6)
	bne.s	T_483C
	bsr	T_357C
	bsr	T_42a2
	bsr	graf_mouse_busybee
T_483C:	move	#3,$DC(a6)
	moveq	#4,d7
	lea	$130(a6),a5
	bsr	T_1996
	move	#0,$DC(a6)
	cmp	#8,$DE(a6)
	bne.s	T_4864
	move	#6,$DE(a6)
	st	$162(a6)
T_4864:	rts
;
;----------------------------------------------------------------------------
;
T_4866:	movem.l	(sp)+,d4-d7/a3-a5
	lea	$130(a6),a1
	lea	0(a4,d4),a2
	moveq	#0,d1
T_4874:	cmpm.b	(a1)+,(a2)+
	beq.s	T_487A
	moveq	#-1,d1
T_487A:	move.b	-$1(a1),-$1(a2)
	bne.s	T_4874
	move	$DE(a6),d0
	cmp	#6,d0
	bne	T_492A
	tst	d1
	bmi	T_4792
T_4894:	tst	d1
	bmi	T_490C
	lea	named_file_already_exists_alst(pc),a2
	cmp	#2,$108(a6)
	beq.s	T_48B8
	move.l	a4,a0
	move.l	a5,a1
T_48AA:	cmpm.b	(a0)+,(a1)+
	bne.s	T_48C8
	tst.b	-$1(a0)
	bne.s	T_48AA
	lea	move_copy_file_to_itself_alst(pc),a2
T_48B8:	bsr	T_39BE
	addq.l	#4,sp
T_48BE:	move	#-$2,$10C(a6)
	bra	T_4938
;
;------------------------------------
;
T_48C8:	move	#0,-(sp)
	move	#0,-(sp)
	pea	(a4)
	move	#$43,-(sp)
	trap	#1			;Fattrib
	lea	10(sp),sp
	tst	d0
	bmi	T_490C
	btst	#0,d0
	beq	T_490C
	lea	name_conflict_file_locked_alst(pc),a2
	bsr	T_39BE
	cmp	#2,d0
	beq.s	T_492A
	move	#0,-(sp)
	move	#1,-(sp)
	pea	(a4)
	move	#$43,-(sp)
	trap	#1			;Fattrib
	lea	10(sp),sp
T_490C:	bsr	T_4360
	cmp	#1,$108(a6)
	bcc.s	T_4928
	move	d6,-(sp)
	pea	(a4)
	move	#$3C,-(sp)
	trap	#1			;Fcreate
	addq.l	#8,sp
	move	d0,$126(a6)
T_4928:	rts
;
;----------------------------------------------------------------------------
;
T_492A:	addq.l	#4,sp
	cmp	#5,d0
	bne.s	T_4944
T_4932:	move	#-$1,$10C(a6)
T_4938:	clr	(sp)
	clr	$140(a6)
	moveq	#-$31,d0
	bra	T_46F6
;
;------------------------------------
;
T_4944:	addq	#1,$10C(a6)
	tst	$124(a6)
	bmi	T_44a6
	move	$124(a6),-(sp)
	move	#$3E,-(sp)
	trap	#1			;Fclose
	addq.l	#4,sp
	move	#-$1,$124(a6)
	bra	T_44a6
;
;------------------------------------
;
T_4966:	move	$B2(a6),d0
	and	#3,d0
	beq.s	T_4978
	subq	#1,d0
	and	#-$2,d6
	or	d0,d6
T_4978:	move	$B2(a6),d0
	and	#12,d0
	beq.s	T_498E
	lsr	#2,d0
	and	#2,d0
	and	#-$3,d6
	or	d0,d6
T_498E:	move	d6,-(sp)
	move	#1,-(sp)
	pea	(a5)
	move	#$43,-(sp)
	trap	#1			;Fattrib
	lea	10(sp),sp
	tst	d0
	bmi.s	T_49B4
	btst	#4,$B3(a6)
	beq.s	T_49B4
	bsr	T_46a0
	lea	$2556(a6),a4
T_49B4:	bra	T_4a4E
;
;------------------------------------
;
T_49B8:	move.l	ref_fsel_name_p-cref(a6),a0
	lea	0(a4,d4),a1
	cmpi.b	#$2A,(a0)
	bne.s	T_49DA
	addq.l	#2,a0
T_49C8:	cmpi.b	#$2E,(a1)+
	beq.s	T_49DA
	tst.b	-$1(a1)
	bne.s	T_49C8
	move.b	#$2E,-$1(a1)
T_49DA:	move.b	(a0)+,(a1)+
	bne.s	T_49DA
	cmpi.b	#$2A,-$2(a1)
	bne.s	T_4a04
	lea	-$2(a1),a1
	lea	0(a5,d5),a0
T_49EE:	cmpi.b	#$2E,(a0)+
	beq.s	T_4a00
	tst.b	-$1(a1)
	bne.s	T_49EE
	clr.b	-$1(a1)
	bra.s	T_4a04
;
;------------------------------------
;
T_4a00:	move.b	(a0)+,(a1)+
	bne.s	T_4a00
T_4a04:	bsr	T_4792
T_4a08:	btst	#0,d6
	beq.s	T_4a22
	move	#0,-(sp)
	move	#1,-(sp)
	pea	(a5)
	move	#$43,-(sp)
	trap	#1			;Fattrib
	lea	10(sp),sp
T_4a22:	pea	(a4)
	pea	(a5)
	clr	-(sp)
	move	#$56,-(sp)
	trap	#1			;Frename
	lea	12(sp),sp
	tst	d0
	bmi.s	T_4a4E
	btst	#0,d6
	beq.s	T_4a4E
	move	d6,-(sp)
	move	#1,-(sp)
	pea	(a4)
	move	#$43,-(sp)
	trap	#1			;Fattrib
	lea	10(sp),sp
T_4a4E:	tst	d0
	bmi	T_44C6
	bra	T_44a6
;
;------------------------------------
;
T_4a58:	lea	0(a5,d5),a1
	move.l	ref_fsel_name_p-cref(a6),a0
	bsr	T_3Aa6
	bne	T_44a6
	lea	0(a5,d5),a1
	lea	file_match_found_alst(pc),a0
	moveq	#11,d1
	bsr	T_1BF4
	lea	file_match_found_alst(pc),a2
	bsr	T_39BE
	cmp	#3,d0
	beq	T_4932
	cmp	#2,d0
	beq	T_44a6
	move	#1,$10C(a6)
	bra	T_4938
;
;----------------------------------------------------------------------------
;
objc_find_sub:
	lea	UIS_contrl(pc),a0
	move.l	#$2B0004,(a0)+		;objc_find
	move.l	#$10001,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	#0,(a0)+
	move	#2,(a0)+
	move	4(sp),(a0)+
	move	6(sp),(a0)
	lea	UIS_addrin(pc),a0
	lea	$32(a6),a1
	move.l	(a1),(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	move	UIS_intout(pc),d7
	rts
;
;----------------------------------------------------------------------------
;
T_4ADA:	bsr	T_390C
	lea	$1d4(a6),a0
	move.l	(a2),(a0)+
	move.l	(a2)+,d0
	move.l	(a2),(a0)
	add.l	d0,(a0)
T_4AEA:	lea	UIS_contrl(pc),a0
	move.l	#$810002,(a0)		;vs_clip
	move	#1,6(a0)
	move	ref_wk_handle-cref(a6),12(a0)
	lea	UIS_intin(pc),a0
	move	#1,(a0)
	lea	UIS_ptsin(pc),a0
	lea	$1d4(a6),a1
	move.l	(a1)+,(a0)+
	move.l	(a1),(a0)
	move.l	UIS_vdipb_p(pc),d1
	move	#$73,d0
	trap	#2			;call vdi
	rts
;
;----------------------------------------------------------------------------
;
T_4B20:	lea	UIS_contrl(pc),a0
	move.l	#$200000,(a0)		;vswr_mode
	move	#1,6(a0)
	move	ref_wk_handle-cref(a6),12(a0)
	lea	UIS_intin(pc),a0
	move	#3,(a0)
	move.l	UIS_vdipb_p(pc),d1
	move	#$73,d0
	trap	#2			;call vdi
	move	#-$5556,d3
	bra	T_4C24
;
;------------------------------------
;
T_4B50:	bsr.s	T_4B20
	bsr	T_4ADA
	lea	$194(a6),a5
	subq	#1,d5
	subq	#2,d6
	clr.l	(a5)+
	move	d5,(a5)+
	clr	(a5)+
	move	d5,(a5)+
	move	d6,(a5)+
	clr	(a5)+
	move	d6,(a5)+
	clr.l	(a5)
	bsr	graf_mkstate_sub
	movem.w	d5-d6,-(sp)
	bra	T_4BF8
;
;------------------------------------
;
T_4B7A:	lea	$2550(a6),a5
	move	(a5)+,d0
T_4B80:	add	d5,(a5)+
	add	d6,(a5)+
	dbra	d0,T_4B80
	bsr	objc_find_sub
	cmp	$FE(a6),d7
	beq.s	T_4BF8
	move	d7,-(sp)
	bsr.s	T_4Bd6
	move	(sp)+,d7
	tst	d7
	bmi.s	T_4BF8
	cmp	#5,d7
	bcs.s	T_4BF8
	cmp	#9,d7
	bls.s	T_4BCC
	cmp	#$16,d7
	beq.s	T_4BCC
	cmp	#$19,d7
	beq.s	T_4BCC
	cmp	#$11,d7
	beq.s	T_4BCC
	cmp	#15,d7
	beq.s	T_4BCC
	cmp	#$1E,d7
	bcs.s	T_4BF8
	cmp	#$21,d7
	bhi.s	T_4BF8
T_4BCC:	move	d7,$FE(a6)
	bsr	objc_change_SELECTED
	bra.s	T_4BF8
;
;------------------------------------
;
T_4Bd6:	move	$FE(a6),d7
	beq.s	T_4BE4
	bsr	objc_change_NORMAL
	clr	$FE(a6)
T_4BE4:	rts
;
;----------------------------------------------------------------------------
;
T_4BE6:	bsr	T_4C76
	bsr.s	T_4BEE
	nop
T_4BEE:	move	#$25,-(sp)
	trap	#14			;Vsync
	addq.l	#2,sp
	rts
;
;----------------------------------------------------------------------------
;
T_4BF8:	bsr.s	T_4BE6
	movem.w	(sp)+,d3-d4
T_4BFE:	bsr	graf_mkstate_sub
	btst	#0,d0
	beq.s	T_4C1E
	cmp	d3,d5
	bne.s	T_4C10
	cmp	d4,d6
	beq.s	T_4BFE
T_4C10:	movem.w	d5-d6,-(sp)
	sub	d3,d5
	sub	d4,d6
	bsr.s	T_4C76
	bra	T_4B7A
;
;----------------------------------------------------------------------------
;
T_4C1E:
	bsr	T_4C76
	moveq	#-1,d3
T_4C24:
	lea	UIS_contrl(pc),a0
	move.l	#$100001,(a0)		;vsl_width
	move	#0,6(a0)
	move	ref_wk_handle-cref(a6),12(a0)
	lea	UIS_ptsin(pc),a0
	move	#2,(a0)+
	clr	(a0)
	move.l	UIS_vdipb_p(pc),d1
	move	#$73,d0
	trap	#2			;vdi
	lea	UIS_contrl(pc),a0	
	move.l	#$710000,(a0)		;vsl_udsty
	move	#1,6(a0)
	move	ref_wk_handle-cref(a6),12(a0)
	lea	UIS_intin(pc),a0
	move	d3,(a0)
	move.l	UIS_vdipb_p(pc),d1
	move	#$73,d0
	trap	#2			;call vdi
	rts
;
;----------------------------------------------------------------------------
;
T_4C76:	bsr	graf_mouse_hide
	lea	$2550(a6),a5
	move	(a5)+,d4
T_4C80:	lea	$194(a6),a4
	moveq	#4,d3
	move.l	(a5),d0
T_4C88:	add.l	d0,(a4)+
	dbra	d3,T_4C88
	lea	UIS_contrl(pc),a0
	move.l	#$60005,(a0)		;v_pline
	clr	6(a0)
	move	ref_wk_handle-cref(a6),12(a0)
	lea	UIS_ptsin(pc),a0
	lea	$194(a6),a1
	moveq	#5,d0
T_4CAC:	move.l	(a1)+,(a0)+
	dbra	d0,T_4CAC
	move.l	UIS_vdipb_p(pc),d1
	move	#$73,d0
	trap	#2			;call vdi
	lea	$194(a6),a4
	moveq	#4,d3
	move.l	(a5)+,d0
T_4CC4:	sub.l	d0,(a4)+
	dbra	d3,T_4CC4
	dbra	d4,T_4C80
	bra	graf_mouse_show
;
;------------------------------------
;
T_4Cd2:
	move	$20(a6),d0
	beq.s	T_4d30
	tst.b	$1F(a6)
	beq.s	T_4d30
	clr.b	$1F(a6)
	bra.s	T_4CF4
;
;------------------------------------
;
T_4CE4:	move	$20(a6),d0
	beq.s	T_4d30
	tst.b	$1F(a6)
	bne.s	T_4d30
	st	$1F(a6)
T_4CF4:	mulu	char_height(pc),d0
	tst.b	$1F(a6)
	bne.s	T_4d00
	neg.w	d0
T_4d00:	move.l	$32(a6),a0
	add	d0,$16(a0)
	add	d0,$136(a0)
	add	d0,$1DE(a0)
	add	d0,$1C2(a0)
	add	d0,$20A(a0)
	add	d0,$222(a0)
	add	d0,$23A(a0)
	add	d0,$252(a0)
	add	d0,$26A(a0)
	add	d0,$5E2(a0)
	add	d0,$60(a6)
T_4d30:	rts
;
;----------------------------------------------------------------------------
;
T_4d32:	move	#$E0,d7
	moveq	#$1C,d6
	move	#$140,d5
	moveq	#-$70,d4
	move.l	ref_fsel_prompt_2_p-cref(a6),a5
	bra.s	T_4d54
;
;------------------------------------
;
T_4d44:	move	#-$E0,d7
	moveq	#-$1c,d6
	move	#$90,d5
	moveq	#$70,d4
	move.l	ref_fsel_prompt_1_p-cref(a6),a5
T_4d54:	move.l	$32(a6),a3
	lea	$108(a3),a4
	add	d7,$14(a4)
	move.l	12(a4),a0
	moveq	#2,d0
T_4d66:	move.l	(a0)+,a1
	move.b	$25(a1),$24(a1)
	tst	d7
	bpl.s	T_4d76
	clr.b	$24(a1)
T_4d76:	dbra	d0,T_4d66
	add	d6,12(a0)
	add	d6,14(a0)
	add	d7,$17C(a3)
	add	d7,$254(a3)
	move	d5,$2C(a3)
	move.l	a5,$24(a3)
	add	d7,$134(a3)
	add	d4,$10(a3)
	add	d7,$14(a3)
	lea	$18(a3),a3
	moveq	#$40,d0
T_4Da4:	cmp	#$80,$10(a3)
	bcs.s	T_4DB0
	add	d7,$10(a3)
T_4DB0:	lea	$18(a3),a3
	dbra	d0,T_4Da4
	lea	$5A(a6),a0
	add	d4,(a0)
	add	d7,4(a0)
	rts
;
;----------------------------------------------------------------------------
;
T_4DC4:	clr	$12E(a6)
	st	$1E(a6)
	moveq	#0,d5
	move	$FA(a6),d6
	bpl.s	T_4DE2
	not.w	d6
	cmp	$2C(a6),d6
	bcs.s	T_4DE2
	moveq	#0,d6
	bra	T_4E6C
;
;------------------------------------
;
T_4DE2:	move	d6,-(sp)
	cmpi.b	#$48,$23(a6)
	bne.s	T_4E02
	subq	#1,d6
	bpl.s	T_4E20
	moveq	#0,d6
	tst	$E2(a6)
	beq.s	T_4E20
	subq	#1,d5
	add	$2E(a6),d6
T_4DFE:	subq	#1,d6
	bra.s	T_4E20
;
;------------------------------------
;
T_4E02:
	addq	#1,d6
	move	d6,d0
	add	$E2(a6),d0
	cmp	$F8(a6),d0
	bcc.s	T_4DFE
	cmp	$2C(a6),d6
	bcs.s	T_4E20
	subq	#1,d6
	addq	#1,d5
	sub	$2E(a6),d6
	addq	#1,d6
T_4E20:
	move.b	$22(a6),d1
	andi.b	#3,d1
	beq.s	T_4E56
	move	d6,d0
	bsr.s	T_4E70
	move.b	(a0),d1
	move	(sp),d0
	bsr.s	T_4E72
	tst.b	d1
	bpl.s	T_4E44
	bclr	#7,(a0)
	beq.s	T_4E56
	move	(sp),$FA(a6)
	bra.s	T_4E56
;
;------------------------------------
;
T_4E44:	bset	#7,(a0)
	bne.s	T_4E56
	tst	$FA(a6)
	bpl.s	T_4E56
	moveq	#13,d7
	bsr	objc_change_SELECTED
T_4E56:	addq.l	#2,sp
	move	d6,-(sp)
	tst	d5
	beq.s	T_4E6A
	bpl.s	T_4E66
	bsr	T_27B2
	bra.s	T_4E6A
;
;------------------------------------
;
T_4E66:	bsr	T_277E
T_4E6A:	move	(sp)+,d6
T_4E6C:	bra	T_141A
;
;------------------------------------
;
T_4E70:	add	d5,d0
T_4E72:	add	$E2(a6),d0
	add	d0,d0
	lea	$25E2(a6),a0
	move	0(a0,d0),d0
	move.l	patch_area_3_p-cref(a6),a0
	lea	$15(a0,d0),a0
	rts
;
;----------------------------------------------------------------------------
;
main_KEYBD_comd:
	move	d7,$128(a6)
	move	$22(a6),d6
	cmp.b	#$1C,d6			;RETURN ?
	bne.s	T_4EAC
	move	$FA(a6),d6
	bpl.s	T_4EA8
	not.w	d6
	cmp	$2C(a6),d6
	bhi	T_4C8
T_4EA8:
	bra	T_141A
;
;------------------------------------
;
T_4EAC:
	cmp.b	#$61,d6			;UNDO ?
	bne.s	T_4EC4
	tst	$FE(a6)
	bne.s	T_4EC0
	btst	#10,d6
	beq	T_29DA
T_4EC0:
	moveq	#$1D,d7
	bra.s	T_4F14
;
;------------------------------------
;
T_4EC4:
	cmp.b	#1,d6			;ESCAPE ?
	beq	T_2638
	moveq	#$10,d7
	cmp.b	#$47,d6			;CLR/HOME ?
	bne.s	T_4EDE
	and	#$300,d6
	beq.s	T_4F10
	moveq	#$12,d7
	bra.s	T_4F10
;
;------------------------------------
;
T_4EDE:
	cmp.b	#$48,d6			;Cur UP ?
	beq.s	T_4EEC
	moveq	#$12,d7
	cmp.b	#$50,d6			;Cur DOWN ?
	bne.s	T_4F18
T_4EEC:
	btst	#10,d6
	bne	T_4DC4
	and	#$300,d6
	beq.s	T_4F14
	move	$2C(a6),d0
	move	#$14,$128(a6)
	cmp	#$10,d7
	beq	T_27BC
	bra	T_278E
;
;------------------------------------
;
T_4F10:
	bset	#15,d7
T_4F14:
	bra	T_4E0
;
;------------------------------------
;
T_4F18:
	cmp.b	#$3B,d6			;F1 ?
	bcc	T_4FEE
	btst	#11,d6
	beq.s	T_4F48
	moveq	#$19,d0			;BUG? $19 (should be 19 = $13)
	lea	T_7703(pc),a0
T_4F2C:
	cmp.b	(a0)+,d6
	beq.s	T_4F36
	dbra	d0,T_4F2C
	bra.s	T_4F48
;
;------------------------------------
;
T_4F36:	move	d0,$EC(a6)
	and	#$300,d6
	beq.s	T_4F44
	st	$128(a6)
T_4F44:	bra	T_25a0
;
;------------------------------------
;
T_4F48:	btst	#10,d6
	beq	T_4FEA
	lea	T_771E(pc),a0
	tst	$FE(a6)
	beq.s	T_4F62
	cmp.b	-(a0),d6
	bne.s	T_4F94
	moveq	#$1D,d7
	bra.s	T_4F8C
;
;------------------------------------
;
T_4F62:	moveq	#$11,d7
	cmp.b	(a0)+,d6
	beq.s	T_4F8C
	moveq	#$16,d7
	cmp.b	(a0)+,d6
	beq.s	T_4F8C
	moveq	#$19,d7
	cmp.b	(a0)+,d6
	beq.s	T_4F8C
	moveq	#$1E,d7
	cmp.b	(a0)+,d6
	beq.s	T_4F8C
	moveq	#$1F,d7
	cmp.b	(a0)+,d6
	beq.s	T_4F8C
	moveq	#$20,d7
	cmp.b	(a0)+,d6
	beq.s	T_4F8C
	moveq	#$21,d7
	cmp.b	(a0),d6
	bne.s	T_4F94
T_4F8C:	bsr	objc_change_SELECTED
	bra	T_4E0
;
;------------------------------------
;
T_4F94:	lea	T_7725(pc),a0
	moveq	#0,d0
	cmp.b	(a0)+,d6
	beq.s	T_4FC0
	addq	#1,d0
	cmp.b	(a0)+,d6
	beq.s	T_4FC0
	addq	#1,d0
	cmp.b	(a0)+,d6
	beq.s	T_4FC0
	addq	#1,d0
	cmp.b	(a0)+,d6
	beq.s	T_4FC0
	addq	#1,d0
	cmp.b	(a0)+,d6
	beq.s	T_4FC0
	cmp.b	(a0)+,d6
	bne.s	T_4FEA
	not.b	$EB(a6)
	bra.s	T_4FEA
;
;------------------------------------
;
T_4FC0:	move	$B4(a6),d1
	cmp	d0,d1
	beq.s	T_4FEA
	move	d0,$B4(a6)
	add	#6,d1
	mulu	#$18,d1
	move.l	$4A(a6),a0
	clr	10(a0,d1)
	bsr	T_3d04
	bra.s	T_4FEA
;
;------------------------------------
;
T_4FE2:	bsr	T_3E94
	bsr	T_28d2
T_4FEA:	bra	T_4C8
;
;------------------------------------
;
T_4FEE:	move	d6,d0
	lsr	#8,d0
	and	#$FF,d6
	sub	#$3B,d6
T_4FFA:	cmp	#9,d6
	bhi.s	T_4FE2
	mulu	#$7A,d6
	lea	T_56a2(pc),a4
	move	d0,d1
	and	#3,d1
	beq.s	T_5014
	lea	-$4C4(a4),a4
T_5014:	lea	2(a4,d6),a4
	move.l	ref_fsel_path_p-cref(a6),a5
	andi.b	#12,d0
	cmp.b	#12,d0
	beq.s	T_5036
	tst.b	(a4)
	beq.s	T_4FE2
	bsr	T_2600
	bsr	T_42a2
	bra	T_Da0
;
;------------------------------------
;
T_5036:	exg	a5,a4
	bsr	T_2600
	bra.s	T_4FE2
;
;------------------------------------
;
	move.l	$32(a6),a0
	lea	$1DE(a0),a0
	move	(a0),$18(a0)
	clr	$14(a0)
	moveq	#$14,d0
	bsr	T_394C
	move.l	#$C0001,$2C(a6)
	move	$C0(a6),-(sp)
	clr	$C0(a6)
	move	char_height(pc),$30(a6)
	bsr	graf_mkstate_sub
	and	#3,d1
	move	d1,-(sp)
	moveq	#0,d6
	lea	pick_a_path_s(pc),a0
T_507A:	bsr	T_512A
	cmp	#11,d6
	beq.s	T_509E
	move	d6,d0
	subq	#1,d0
	mulu	#$7A,d0
	lea	T_56a2(pc),a0
	tst	(sp)
	beq.s	T_5098
	lea	-$4C4(a0),a0
T_5098:	lea	0(a0,d0),a0
	bra.s	T_507A
;
;------------------------------------
;
T_509E:	lea	T_77d4(pc),a0
T_50a2:	bsr	T_512A
	lea	bottom_bar_null_s(pc),a0
	moveq	#12,d0
	add	$20(a6),d0
	cmp	d0,d6
	bcs.s	T_50a2
	bsr	T_1804
T_50B8:	bsr	T_3900
T_50BC:	moveq	#0,d2
	clr	$22(a6)
	bsr	form_event_sub
	tst	$22(a6)
	bne.s	T_50BC
	cmp	#$1C,d7
	beq.s	T_50D8
	cmp	#$1D,d7
	bne.s	T_50E0
T_50D8:	bsr	objc_change_NORMAL
	moveq	#10,d6
	bra.s	T_50F0
;
;------------------------------------
;
T_50E0:	bsr	T_298E
	beq.s	T_50B8
	subq	#1,d6
	bmi.s	T_50B8
	moveq	#13,d7
	bsr	objc_change_SELECTED
T_50F0:	swap	d6
	clr	d6
T_50F4:	lea	bottom_bar_null_s(pc),a0
	bsr.s	T_512A
	cmp	#12,d6
	bcs.s	T_50F4
	swap	d6
	move	2(sp),$C0(a6)
	bsr	T_B66
	bsr	T_183A
	moveq	#0,d0
	tst	(sp)
	beq.s	T_5118
	moveq	#3,d0
T_5118:	addq.l	#4,sp
	btst	#1,$12F(a6)
	beq.s	T_5126
	or	#12,d0
T_5126:	bra	T_4FFA
;
;------------------------------------
;
T_512A:	lea	$194(a6),a1
	move.b	#$20,(a1)+
	moveq	#14,d2
	bsr	T_a48
	beq.s	T_513C
	moveq	#$2A,d2
T_513C:	move.b	(a0)+,d0
	beq.s	T_5160
	move.b	d0,(a1)+
	dbra	d2,T_513C
T_5146:	move.b	#$20,(a1)+
	clr.b	(a1)
	bsr	T_4036
	addq	#1,d6
	subq	#8,$10(a0)
	add	#$10,$14(a0)
	bra	T_3FB4
;
;------------------------------------
;
T_5160:	move.b	#$20,(a1)+
	dbra	d2,T_5160
	bra.s	T_5146
;
;----------------------------------------------------------------------------
;Start of:	Bugged keyboard reset routine	(disabled)
;----------------------------------------------------------------------------
;
;;;	idiocy_start:
;;;	iorec_idiocy_plus_8_a	= *+2	;-	\
;;;		move	$1234.w,-(sp)	;4 bytes \
;;;	idiotic_sub_p	= *+2		;-	  \
;;;		jsr	$12345678	;6 bytes   \
;;;	iorec_idiocy_plus_8_b	= *+2	;-	    \
;;;		move	$1234.w,d0	;4 bytes     \
;;;		cmp	(sp)+,d0	;2 bytes      \
;;;		beq.s	.T_51A8		;2 bytes       \
;;;	iorec_idiocy	= *+2		;-		\
;;;		move.l	$1234.w,a0	;4 bytes	 \
;;;		move	0(a0,d0),d0	;4 bytes	  \
;;;		cmp.b	#$53,d0		;4 bytes	   \
;;;		bne.s	.T_51A8		;2 bytes	    \ / old idiocy
;;;	half_addr_idiocy	= *+2	;-		     X  using 64 bytes
;;;		move.b	$1234.w,d0	;4 bytes	    / \ (disabled)
;;;		andi.b	#15,d0		;4 bytes	   /
;;;		cmp.b	#12,d0		;4 bytes	  /
;;;		bcs.s	.T_51A8		;2 bytes	 /
;;;		beq.s	.T_51a2		;2 bytes	/
;;;		clr.l	(resvalid).w	;4 bytes       /
;;;		clr.l	(memvalid).w	;4 bytes      /
;;;	.T_51a2:			;-	     /
;;;		move.l	(ev_reset).w,a0 ;4 bytes    /
;;;		jmp	(a0)		;2 bytes   /
;;;					;-	  /
;;;	.T_51A8:			;-	 /
;;;		rts			;2 bytes/
;;;
idiocy_start:
nu_size_test:			;;;new subroutine, adapts UIS to font widths
	lea	char_width(pc),a0		;4
	cmp	char_height(pc),d0	;4 ;height unchanged ?
	bne.s	.settings_changed		;2 ;else go update settings
	swap	d0				;2
	cmp	(a0),d0				;2 ;width unchanged ?
	beq.s	.exit_rts			;2 ;if so, go exit flagging EQ
	swap	d0				;2
.settings_changed:				;-
	move	d0,ref_char_height-cref(a6)	;4 ;update height
	nop	;;;;
	nop	;;;;
;;;;	swap	d0				;2
	move.l	d0,(a0)				;2 ;update width.height, flagging NE
.exit_rts:					;-
	rts					;2 ;exit to caller, with flags
;;;
char_width:
	dc.w	8	;default character width = 8 pixels
char_height:		;;;;
	dc.w	8	;default character height = 8 pixels
;;;
mulu_char_width_ia0_d1:
	move	(a0),d1			;2
	mulu	char_width(pc),d1	;4 bytes
	move	d1,(a0)			;2 bytes
	rts				;2 bytes
;;;
idiocy_pad	set 64-(*-idiocy_start)	;;;calculate code length difference
idiocy_pad	set	idiocy_pad-12	;;;deduct 12 bytes (hdv_mediach XBRA)
idiocy_pad	set	idiocy_pad-12	;;;deduct 12 bytes (resvector XBRA)
	rept	idiocy_pad/2	;;; \
	nop			;;;  X Pad to maintain code length
	endr			;;; /
;;;
;----------------------------------------------------------------------------
;End of:	Bugged keyboard reset routine	(disabled)
;----------------------------------------------------------------------------
;Start of:	new 'hdv_mediach' routine with XBRA
;----------------------------------------------------------------------------
;
	XB_define	nu_mediach,'UIS3'
	lea	cref(pc),a0
	move	ref_mediach_flag-cref(a0),d0
	bmi.s	.go_old_mediach
	cmp	4(sp),d0
	bne.s	.go_old_mediach
	st	ref_mediach_flag-cref(a0)
	moveq	#2,d0
	rts
;
.go_old_mediach:
	move.l	nu_mediach+xb_next(pc),a0
	jmp	(a0)
;
;----------------------------------------------------------------------------
;End of:	new 'hdv_mediach' routine with XBRA
;----------------------------------------------------------------------------
;Start of:	new 'resvector' routine with XBRA
;----------------------------------------------------------------------------
;
	XB_define	nu_resvector,'UIS3'
	clr.l	(_cookies).w
old_resvalid	= *+2
	move.l	#$12345678,(resvalid).w
	move.l	nu_resvector+xb_next(pc),(resvector).w
	nop
	jmp	(a6)
;
;----------------------------------------------------------------------------
;End of:	new 'resvector' routine with XBRA
;----------------------------------------------------------------------------
;Start of:	'patch_area_4'
;----------------------------------------------------------------------------
patch_area_4:
	ds.w	610
;
;----------------------------------------------------------------------------
;
T_56a2:
	ds.w	610
;
;----------------------------------------------------------------------------
;
T_5B66:
	dc.b	'PRG',$0,'TOS',$0,'TTP',$0,'ACC',$0,'APP',$0
	dc.b	'DOC',$0,'STW',$0,'WP',$0,$0,'TXT',$0,'ASC',$0
	dc.b	'S',$0,$0,$0,'BAS',$0,'C',$0,$0,$0,'PAS',$0
	dc.b	'OBJ',$0,'RSC',$0,'DAT',$0,'INF',$0,'SYS',$0
	dc.b	'DEF',$0,'WRK',$0,'GFA',$0,'PRX',$0,'ACX',$0
	dc.b	'---',$0
;
patch_area_4_end:
;----------------------------------------------------------------------------
;End of:	'patch_area_4'
;----------------------------------------------------------------------------
;Start of:	'patch_area_1'
;----------------------------------------------------------------------------
patch_area_1:	;T_5BCA:
	dc.w	$0
reloc_object_t_offs:
	dc.w	reloc_object_t-patch_area_1	;$7EA
reloc_tedinfo_offs:
	dc.w	reloc_tedinfo_t-patch_area_1	;$646
	dc.w	reloc_tedinfo_t-patch_area_1	;$646
	dc.w	reloc_tedinfo_t-patch_area_1	;$646
	dc.w	$0
reloc_string_t_offs:
	dc.w	reloc_string_t-patch_area_1	;$24
	dc.w	reloc_tedinfo_t-patch_area_1	;$646
	dc.w	$0
reloc_pointer_t_offs:
	dc.w	reloc_pointer_t-patch_area_1	;$19BA
reloc_object_count:
	dc.w	(reloc_object_t_end-reloc_object_t)/24	;$BE
	dc.w	$A
reloc_tedinfo_count:
	dc.w	(reloc_tedinfo_t_end-reloc_tedinfo_t)/28	;15
	dc.w	$0
	dc.w	$0
	dc.w	$0
	dc.w	$0
patch_area_1_end_offs:
	dc.w	patch_area_1_end-patch_area_1	;$19E2
;
reloc_string_t:		;offs: $24
rel_null_1_s:		;offs: $24
	dc.b	$0
rel_format_s:		;offs: $25
	dc.b	'Format',$0
rel_folder_s:		;offs: $2C
	dc.b	'Folder',$0
rel_directory_s:	;offs: $33
	dc.b	'Directory:  ',$0
rel_null_2_s:		;offs: $40
	dc.b	$0
rel_null_3_s:		;offs: $41
	dc.b	$0
;
	dc.b	'TXT',$0
	dc.b	'PAS',$0
	dc.b	'DOC',$0
	dc.b	'ASM',$0
	dc.b	'ASC',$0
	dc.b	'*',$0
	dc.b	'________________________________________________________________',$0
	dc.b	'________________________________________________________________',$0
	dc.b	'PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP',$0
	dc.b	$0,$0,$0
	dc.b	' FILENAME.EXT ',$0,$0,$0
	dc.b	'12345678',$0,$0,$0
	dc.b	'Selection:  ',$0,$0,$0
	dc.b	'___________',$0
	dc.b	'________.___',$0
	dc.b	'FFFFFFFFFFF',$0
	dc.b	'OK',$0,'Cancel',$0
	dc.b	'Move',$0
	dc.b	'Copy',$0
	dc.b	'Rename',$0
	dc.b	'Delete',$0
	dc.b	'Find',$0
	dc.b	'Choose an extension',$0
	dc.b	'EXT',$0
	dc.b	'Format floppy',$0
	dc.b	'A',$0
	dc.b	'B',$0
	dc.b	'Number of sides',$0
	dc.b	'1',$0
	dc.b	'2',$0
	dc.b	'Sectors per track',$0
	dc.b	'9',$0
	dc.b	'10',$0
	dc.b	'Number of tracks',$0
	dc.b	'80',$0
	dc.b	'81',$0
	dc.b	'82',$0
	dc.b	'__',$0
	dc.b	'99',$0
	dc.b	'Twister format',$0
	dc.b	'OFF',$0
	dc.b	'ON',$0
	dc.b	'___________',$0
	dc.b	'Disk Label        ________.___',$0
	dc.b	'FFFFFFFFFFF',$0
	dc.b	'Press Undo to cancel',$0
	dc.b	'FORMAT',$0
	dc.b	'EXIT',$0
	dc.b	'  DISK INFORMATION',$0
	dc.b	'Drive Identifier:',$0,'A:',$0
	dc.b	' Disk Label:',$0,'___________',$0,'_______'
	dc.b	'_.___',$0,'FFFFFFFFFFF',$0,'Number of fold'
	dc.b	'ers:',$0,'_____',$0,'Number of Items:',$0,'_'
	dc.b	'____',$0,'Bytes Used:',$0,'_________',$0,'B'
	dc.b	'ytes Available:',$0,'_________',$0,'Ram Fr'
	dc.b	'ee:',$0,'12345678',$0,'OK',$0,'FILE OPERAT'
	dc.b	'ION NAME CONFLICT',$0,'Current Name:',$0,'_'
	dc.b	'_______.___',$0,'___________',$0,'Conflict'
	dc.b	' Name:  ________.___',$0,'FFFFFFFFFFF',$0,'C'
	dc.b	'ancel',$0,'OK',$0,'Skip',$0,'Ignore curren'
	dc.b	't conflicts',$0,'MULTIPLE FILE ATTRIBUTE C'
	dc.b	'HANGE',$0,'File mask:',$0,'________.___',$0
	dc.b	'Read/Write',$0,'Read-Only',$0,'Show',$0,'H'
	dc.b	'ide',$0,'Touch',$0,'OK',$0,'Cancel',$0
	dc.b	'Count of Folders/Files',$0
	dc.b	'Folders to go:',$0
	dc.b	'0001',$0,$0,$0
	dc.b	'Files to go:',$0
	dc.b	'0001',$0,$0,$0
	dc.b	"Press 'Undo' to cancel",$0
	dc.b	'Universal Item Selector IV ',$0
	dc.b	'v 4.00 Copyright  1989 by',$0		;;;;include version_s_const here
	dc.b	'Application & Design Software',$0
	dc.b	'Sort By:',$0
	dc.b	'None',$0
	dc.b	'Name',$0
	dc.b	'Date',$0
	dc.b	'Size',$0
	dc.b	'Type',$0
	dc.b	'Show Hidden:',$0
	dc.b	'Yes',$0
	dc.b	'No',$0
	dc.b	'Copies date:',$0
	dc.b	'Same',$0
	dc.b	'New',$0
	dc.b	'UIS width:',$0
	dc.b	'12',$0
	dc.b	'12W',$0
	dc.b	'36',$0
	dc.b	'Font size:',$0
	dc.b	'Large',$0
	dc.b	'Small',$0
	dc.b	'Print cntrl:',$0
	dc.b	'FF',$0
	dc.b	'Indent',$0
	dc.b	'Save defaults',$0
	dc.b	'Exit',$0
	dc.b	' ITEM INFORMATION',$0
	dc.b	'FILENAMEEXT',$0
	dc.b	'Name:  ________.___',$0
	dc.b	'FFFFFFFFFFF',$0
	dc.b	'Size in bytes:',$0
	dc.b	'12345678',$0
	dc.b	'Last modified:',$0
	dc.b	'11-22-33  01:19 am',$0
	dc.b	'Read/Write',$0
	dc.b	'Read-Only',$0
	dc.b	'Show',$0
	dc.b	'Hide',$0
	dc.b	'Touch',$0
	dc.b	'OK',$0
	dc.b	'Cancel',$0
	dc.b	$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0
reloc_string_t_end:
;
reloc_tedinfo_t:	;offs: $646
rel_directory_ted:	;offs: $646
	dc.l	rel_directory_s-patch_area_1	;$33
	dc.l	rel_null_2_s-patch_area_1	;$40
	dc.l	rel_null_3_s-patch_area_1	;$41
	dc.w	3,6,0,$1180
	dc.w	0,-1,13,1
;
	dc.b	$0,$0
	dc.b	$0,$58,$0,$0,$0,$99,$0,$0,$0,$DA,$0,$3,$0,$6
	dc.b	$0,$0,$11,$80,$0,$0,$FF,$FF,$0,$41,$0,$41,$0
	dc.b	$0,$1,$1B,$0,$0,$1,$1C,$0,$0,$1,$1D,$0,$3,$0
	dc.b	$6,$0,$0,$11,$80,$0,$0,$FF,$FF,$0,$1,$0,$1,$0
	dc.b	$0,$1,$1E,$0,$0,$1,$2D,$0,$0,$1,$2E,$0,$3,$0
	dc.b	$6,$0,$2,$11,$A1,$0,$0,$FF,$FF,$0,$F,$0,$1,$0
	dc.b	$0,$1,$2F,$0,$0,$1,$38,$0,$0,$1,$39,$0,$3,$0
	dc.b	$6,$0,$2,$11,$80,$0,$0,$FF,$FF,$0,$9,$0,$1,$0
	dc.b	$0,$1,$3A,$0,$0,$1,$47,$0,$0,$1,$48,$0,$3,$0
	dc.b	$6,$0,$0,$11,$80,$0,$0,$FF,$FF,$0,$D,$0,$1,$0
	dc.b	$0,$1,$49,$0,$0,$1,$55,$0,$0,$1,$62,$0,$3,$0
	dc.b	$6,$0,$0,$11,$80,$0,$0,$FF,$FF,$0,$C,$0,$D,$0
	dc.b	$0,$2,$1,$0,$0,$2,$4,$0,$0,$2,$7,$0,$3,$0,$6
	dc.b	$0,$2,$11,$80,$0,$0,$FF,$FF,$0,$3,$0,$3,$0,$0
	dc.b	$2,$20,$0,$0,$2,$2C,$0,$0,$2,$4B,$0,$3,$0,$6
	dc.b	$0,$0,$11,$80,$0,$0,$FF,$FF,$0,$C,$0,$1F,$0
	dc.b	$0,$2,$AD,$0,$0,$2,$B9,$0,$0,$2,$C6,$0,$3,$0
	dc.b	$6,$0,$0,$11,$80,$0,$0,$FF,$FF,$0,$C,$0,$D,$0
	dc.b	$0,$3,$81,$0,$0,$3,$8D,$0,$0,$3,$AA,$0,$3,$0
	dc.b	$6,$0,$0,$11,$80,$0,$0,$FF,$FF,$0,$C,$0,$1D
	dc.b	$0,$0,$4,$6A,$0,$0,$4,$6F,$0,$0,$4,$70,$0,$3
	dc.b	$0,$6,$0,$0,$11,$80,$0,$0,$FF,$FF,$0,$5,$0,$1
	dc.b	$0,$0,$4,$7E,$0,$0,$4,$83,$0,$0,$4,$84,$0,$3
	dc.b	$0,$6,$0,$0,$11,$80,$0,$0,$FF,$FF,$0,$5,$0,$1
	dc.b	$0,$0,$5,$A6,$0,$0,$5,$B2,$0,$0,$5,$C6,$0,$3
	dc.b	$0,$6,$0,$0,$11,$80,$0,$0,$FF,$FF,$0,$C,$0,$14
	dc.b	$0,$0,$6,$43,$0,$0,$6,$44,$0,$0,$6,$45,$0,$3
	dc.b	$0,$6,$0,$0,$11,$80,$0,$0,$FF,$FF,$0,$1,$0,$1
reloc_tedinfo_t_end:
;
reloc_object_t:		;offs: $7EA
	dc.w	-1,1,63
	dc.w	G_BOX,NONE,OUTLINED
	dc.l	$00021100
	dc.w	0,0,40,21
;obj 001
	dc.w	2,-1,-1
	dc.w	G_STRING,TOUCHEXIT,NORMAL
	dc.l	rel_null_1_s-patch_area_1	;$24
	dc.w	2,1,18,1
;obj 002
	dc.w	3,-1,-1
	dc.w	G_BUTTON,SELECTABLE|EXIT,NORMAL
	dc.l	rel_format_s-patch_area_1	;$25
	dc.w	22,1,7,1
;obj 003
	dc.w	4,-1,-1
	dc.w	G_BUTTON,SELECTABLE|EXIT,NORMAL
	dc.l	rel_folder_s-patch_area_1	;$2C
	dc.w	31,1,7,1
;obj 004
	dc.w	5,-1,-1
	dc.w	G_TEXT,TOUCHEXIT,NORMAL
	dc.l	rel_directory_ted-patch_area_1	;$646
	dc.w	2,3,12,1
;obj 005
	dc.b	$0,$6,$FF
	dc.b	$FF,$FF,$FF,$0,$1C,$0,$40,$0,$0,$0,$0,$0,$42
	dc.b	$0,$11,$0,$3,$0,$3,$0,$1,$0,$7,$FF,$FF,$FF,$FF
	dc.b	$0,$1C,$0,$40,$0,$0,$0,$0,$0,$46,$0,$15,$0,$3
	dc.b	$0,$3,$0,$1,$0,$8,$FF,$FF,$FF,$FF,$0,$1C,$0
	dc.b	$40,$0,$0,$0,$0,$0,$4A,$0,$19,$0,$3,$0,$3,$0
	dc.b	$1,$0,$9,$FF,$FF,$FF,$FF,$0,$1C,$0,$40,$0,$0
	dc.b	$0,$0,$0,$4E,$0,$1D,$0,$3,$0,$3,$0,$1,$0,$A
	dc.b	$FF,$FF,$FF,$FF,$0,$1C,$0,$40,$0,$0,$0,$0,$0
	dc.b	$52,$0,$21,$0,$3,$0,$3,$0,$1,$0,$B,$FF,$FF,$FF
	dc.b	$FF,$0,$1C,$0,$40,$0,$0,$0,$0,$0,$56,$0,$25
	dc.b	$0,$3,$0,$1,$0,$1,$0,$C,$FF,$FF,$FF,$FF,$0,$1D
	dc.b	$0,$48,$0,$0,$0,$0,$6,$62,$0,$2,$0,$4,$0,$40
	dc.b	$0,$1,$0,$E,$0,$D,$0,$D,$0,$14,$0,$40,$0,$0
	dc.b	$0,$FF,$11,$0,$0,$2,$0,$6,$0,$13,$0,$D,$0,$C
	dc.b	$FF,$FF,$FF,$FF,$0,$15,$0,$0,$0,$0,$0,$0,$6
	dc.b	$7E,$0,$2,$0,$1,$0,$F,$0,$1,$0,$F,$FF,$FF,$FF
	dc.b	$FF,$0,$1B,$0,$5,$0,$0,$5,$FF,$11,$0,$0,$2,$0
	dc.b	$5,$0,$2,$0,$1,$0,$10,$FF,$FF,$FF,$FF,$0,$16
	dc.b	$0,$40,$0,$0,$0,$0,$6,$9A,$0,$4,$0,$5,$0,$11
	dc.b	$0,$1,$0,$11,$FF,$FF,$FF,$FF,$0,$1B,$0,$40,$0
	dc.b	$0,$1,$FF,$11,$0,$0,$15,$0,$6,$0,$2,$0,$2,$0
	dc.b	$12,$FF,$FF,$FF,$FF,$0,$1B,$0,$5,$0,$0,$3F,$FF
	dc.b	$11,$0,$0,$15,$0,$5,$0,$2,$0,$1,$0,$13,$FF,$FF
	dc.b	$FF,$FF,$0,$1B,$0,$40,$0,$0,$2,$FF,$11,$0,$0
	dc.b	$15,$0,$11,$0,$2,$0,$2,$0,$15,$0,$14,$0,$14
	dc.b	$0,$14,$0,$40,$0,$0,$0,$FF,$11,$11,$0,$15,$0
	dc.b	$8,$0,$2,$0,$9,$0,$13,$FF,$FF,$FF,$FF,$0,$14
	dc.b	$0,$40,$0,$0,$0,$FF,$11,$0,$0,$0,$0,$0,$0,$2
	dc.b	$0,$1,$0,$16,$FF,$FF,$FF,$FF,$0,$1B,$0,$40,$0
	dc.b	$0,$3,$FF,$11,$0,$0,$11,$0,$13,$0,$4,$0,$1,$0
	dc.b	$17,$FF,$FF,$FF,$FF,$0,$1B,$0,$0,$0,$0,$8,$FF
	dc.b	$11,$0,$0,$15,$0,$13,$0,$2,$0,$1,$0,$18,$FF
	dc.b	$FF,$FF,$FF,$0,$1B,$0,$40,$0,$0,$4,$FF,$11,$0
	dc.b	$0,$4,$0,$13,$0,$4,$0,$1,$0,$19,$FF,$FF,$FF
	dc.b	$FF,$0,$16,$0,$40,$0,$0,$0,$0,$6,$B6,$0,$8,$0
	dc.b	$13,$0,$9,$0,$1,$0,$1A,$FF,$FF,$FF,$FF,$0,$1B
	dc.b	$0,$5,$0,$0,$50,$FF,$11,$0,$0,$2,$0,$13,$0,$2
	dc.b	$0,$1,$0,$1B,$FF,$FF,$FF,$FF,$0,$15,$0,$40,$0
	dc.b	$0,$0,$0,$6,$D2,$0,$1A,$0,$6,$0,$C,$0,$1,$0
	dc.b	$1C,$FF,$FF,$FF,$FF,$0,$1D,$0,$48,$0,$0,$0,$0
	dc.b	$6,$EE,$0,$1A,$0,$7,$0,$C,$0,$1,$0,$1D,$FF,$FF
	dc.b	$FF,$FF,$0,$1A,$0,$7,$0,$0,$0,$0,$1,$6E,$0,$19
	dc.b	$0,$9,$0,$7,$0,$1,$0,$1E,$FF,$FF,$FF,$FF,$0
	dc.b	$1A,$0,$5,$0,$0,$0,$0,$1,$71,$0,$19,$0,$B,$0
	dc.b	$7,$0,$1,$0,$1F,$FF,$FF,$FF,$FF,$0,$1A,$0,$41
	dc.b	$0,$0,$0,$0,$1,$78,$0,$19,$0,$D,$0,$7,$0,$1
	dc.b	$0,$20,$FF,$FF,$FF,$FF,$0,$1A,$0,$41,$0,$0,$0
	dc.b	$0,$1,$7D,$0,$19,$0,$F,$0,$7,$0,$1,$0,$21,$FF
	dc.b	$FF,$FF,$FF,$0,$1A,$0,$41,$0,$0,$0,$0,$1,$82
	dc.b	$0,$19,$0,$11,$0,$7,$0,$1,$0,$22,$FF,$FF,$FF
	dc.b	$FF,$0,$1A,$0,$41,$0,$0,$0,$0,$1,$89,$0,$19
	dc.b	$0,$13,$0,$7,$0,$1,$0,$23,$FF,$FF,$FF,$FF,$0
	dc.b	$1A,$0,$41,$0,$0,$0,$0,$1,$90,$0,$22,$0,$9,$0
	dc.b	$4,$0,$1,$0,$3E,$0,$24,$0,$3D,$0,$14,$0,$0,$0
	dc.b	$0,$0,$1,$1,$0,$0,$21,$0,$B,$0,$6,$0,$9,$0,$25
	dc.b	$FF,$FF,$FF,$FF,$0,$1B,$0,$51,$0,$0,$41,$FF
	dc.b	$11,$0,$0,$0,$0,$0,$0,$2,$0,$1,$0,$26,$FF,$FF
	dc.b	$FF,$FF,$0,$1B,$0,$51,$0,$0,$42,$FF,$11,$0,$0
	dc.b	$0,$0,$1,$0,$2,$0,$1,$0,$27,$FF,$FF,$FF,$FF
	dc.b	$0,$1B,$0,$51,$0,$0,$43,$FF,$11,$0,$0,$0,$0
	dc.b	$2,$0,$2,$0,$1,$0,$28,$FF,$FF,$FF,$FF,$0,$1B
	dc.b	$0,$51,$0,$0,$44,$FF,$11,$0,$0,$0,$0,$3,$0,$2
	dc.b	$0,$1,$0,$29,$FF,$FF,$FF,$FF,$0,$1B,$0,$51,$0
	dc.b	$0,$45,$FF,$11,$0,$0,$0,$0,$4,$0,$2,$0,$1,$0
	dc.b	$2A,$FF,$FF,$FF,$FF,$0,$1B,$0,$51,$0,$0,$46
	dc.b	$FF,$11,$0,$0,$0,$0,$5,$0,$2,$0,$1,$0,$2B,$FF
	dc.b	$FF,$FF,$FF,$0,$1B,$0,$51,$0,$0,$47,$FF,$11
	dc.b	$0,$0,$0,$0,$6,$0,$2,$0,$1,$0,$2C,$FF,$FF,$FF
	dc.b	$FF,$0,$1B,$0,$51,$0,$0,$48,$FF,$11,$0,$0,$0
	dc.b	$0,$7,$0,$2,$0,$1,$0,$2D,$FF,$FF,$FF,$FF,$0
	dc.b	$1B,$0,$51,$0,$0,$49,$FF,$11,$0,$0,$0,$0,$8
	dc.b	$0,$2,$0,$1,$0,$2E,$FF,$FF,$FF,$FF,$0,$1B,$0
	dc.b	$51,$0,$0,$4A,$FF,$11,$0,$0,$2,$0,$0,$0,$2,$0
	dc.b	$1,$0,$2F,$FF,$FF,$FF,$FF,$0,$1B,$0,$51,$0,$0
	dc.b	$4B,$FF,$11,$0,$0,$2,$0,$1,$0,$2,$0,$1,$0,$30
	dc.b	$FF,$FF,$FF,$FF,$0,$1B,$0,$51,$0,$0,$4C,$FF
	dc.b	$11,$0,$0,$2,$0,$2,$0,$2,$0,$1,$0,$31,$FF,$FF
	dc.b	$FF,$FF,$0,$1B,$0,$51,$0,$0,$4D,$FF,$11,$0,$0
	dc.b	$2,$0,$3,$0,$2,$0,$1,$0,$32,$FF,$FF,$FF,$FF
	dc.b	$0,$1B,$0,$51,$0,$0,$4E,$FF,$11,$0,$0,$2,$0
	dc.b	$4,$0,$2,$0,$1,$0,$33,$FF,$FF,$FF,$FF,$0,$1B
	dc.b	$0,$51,$0,$0,$4F,$FF,$11,$0,$0,$2,$0,$5,$0,$2
	dc.b	$0,$1,$0,$34,$FF,$FF,$FF,$FF,$0,$1B,$0,$51,$0
	dc.b	$0,$50,$FF,$11,$0,$0,$2,$0,$6,$0,$2,$0,$1,$0
	dc.b	$35,$FF,$FF,$FF,$FF,$0,$1B,$0,$51,$0,$0,$51
	dc.b	$FF,$11,$0,$0,$2,$0,$7,$0,$2,$0,$1,$0,$36,$FF
	dc.b	$FF,$FF,$FF,$0,$1B,$0,$51,$0,$0,$52,$FF,$11
	dc.b	$0,$0,$2,$0,$8,$0,$2,$0,$1,$0,$37,$FF,$FF,$FF
	dc.b	$FF,$0,$1B,$0,$51,$0,$0,$53,$FF,$11,$0,$0,$4
	dc.b	$0,$0,$0,$2,$0,$1,$0,$38,$FF,$FF,$FF,$FF,$0
	dc.b	$1B,$0,$51,$0,$0,$54,$FF,$11,$0,$0,$4,$0,$1
	dc.b	$0,$2,$0,$1,$0,$39,$FF,$FF,$FF,$FF,$0,$1B,$0
	dc.b	$51,$0,$0,$55,$FF,$11,$0,$0,$4,$0,$2,$0,$2,$0
	dc.b	$1,$0,$3A,$FF,$FF,$FF,$FF,$0,$1B,$0,$51,$0,$0
	dc.b	$56,$FF,$11,$0,$0,$4,$0,$3,$0,$2,$0,$1,$0,$3B
	dc.b	$FF,$FF,$FF,$FF,$0,$1B,$0,$51,$0,$0,$57,$FF
	dc.b	$11,$0,$0,$4,$0,$4,$0,$2,$0,$1,$0,$3C,$FF,$FF
	dc.b	$FF,$FF,$0,$1B,$0,$51,$0,$0,$58,$FF,$11,$0,$0
	dc.b	$4,$0,$5,$0,$2,$0,$1,$0,$3D,$FF,$FF,$FF,$FF
	dc.b	$0,$1B,$0,$51,$0,$0,$59,$FF,$11,$0,$0,$4,$0
	dc.b	$6,$0,$2,$0,$1,$0,$23,$FF,$FF,$FF,$FF,$0,$1B
	dc.b	$0,$51,$0,$0,$5A,$FF,$11,$0,$0,$4,$0,$7,$0,$2
	dc.b	$0,$1,$0,$3F,$FF,$FF,$FF,$FF,$0,$14,$0,$40,$0
	dc.b	$0,$0,$0,$1,$0,$0,$27,$0,$14,$0,$1,$0,$1,$0
	dc.b	$0,$0,$40,$0,$41,$0,$14,$0,$0,$0,$0,$0,$FF,$11
	dc.b	$0,$0,$11,$0,$4,$0,$15,$0,$8,$0,$41,$FF,$FF
	dc.b	$FF,$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$1,$95,$0,$1
	dc.b	$0,$1,$0,$13,$0,$1,$0,$3F,$0,$42,$0,$42,$0,$14
	dc.b	$0,$40,$0,$0,$0,$1,$1,$0,$0,$1,$0,$3,$0,$13
	dc.b	$0,$5,$0,$41,$FF,$FF,$FF,$FF,$0,$1C,$0,$20,$0
	dc.b	$0,$0,$0,$1,$A9,$0,$0,$0,$0,$0,$3,$0,$1,$FF
	dc.b	$FF,$0,$1,$0,$16,$0,$14,$0,$0,$0,$10,$0,$2,$11
	dc.b	$0,$0,$0,$0,$0,$0,$24,$0,$13,$0,$4,$0,$2,$0
	dc.b	$3,$0,$1C,$0,$0,$0,$0,$0,$0,$1,$AD,$0,$3,$0
	dc.b	$1,$0,$1E,$0,$1,$0,$3,$FF,$FF,$FF,$FF,$0,$1A
	dc.b	$0,$51,$0,$0,$0,$0,$1,$BB,$0,$13,$0,$0,$0,$5
	dc.b	$0,$1,$0,$1,$FF,$FF,$FF,$FF,$0,$1A,$0,$51,$0
	dc.b	$0,$0,$0,$1,$BD,$0,$19,$0,$0,$0,$5,$0,$1,$0
	dc.b	$7,$0,$5,$0,$6,$0,$1C,$0,$0,$0,$0,$0,$0,$1,$BF
	dc.b	$0,$3,$0,$3,$0,$1E,$0,$1,$0,$6,$FF,$FF,$FF,$FF
	dc.b	$0,$1A,$0,$51,$0,$0,$0,$0,$1,$CF,$0,$13,$0,$0
	dc.b	$0,$5,$0,$1,$0,$4,$FF,$FF,$FF,$FF,$0,$1A,$0
	dc.b	$51,$0,$0,$0,$0,$1,$D1,$0,$19,$0,$0,$0,$5,$0
	dc.b	$1,$0,$A,$0,$8,$0,$9,$0,$1C,$0,$0,$0,$0,$0,$0
	dc.b	$1,$D3,$0,$3,$0,$5,$0,$1E,$0,$1,$0,$9,$FF,$FF
	dc.b	$FF,$FF,$0,$1A,$0,$51,$0,$0,$0,$0,$1,$E5,$0
	dc.b	$13,$0,$0,$0,$5,$0,$1,$0,$7,$FF,$FF,$FF,$FF
	dc.b	$0,$1A,$0,$51,$0,$0,$0,$0,$1,$E7,$0,$19,$0,$0
	dc.b	$0,$5,$0,$1,$0,$E,$0,$B,$0,$D,$0,$1C,$0,$0,$0
	dc.b	$0,$0,$0,$1,$EA,$0,$3,$0,$7,$0,$1E,$0,$1,$0
	dc.b	$C,$FF,$FF,$FF,$FF,$0,$1A,$0,$51,$0,$0,$0,$0
	dc.b	$1,$FB,$0,$13,$0,$0,$0,$3,$0,$1,$0,$D,$FF,$FF
	dc.b	$FF,$FF,$0,$1A,$0,$51,$0,$0,$0,$0,$1,$FE,$0
	dc.b	$17,$0,$0,$0,$3,$0,$1,$0,$A,$FF,$FF,$FF,$FF
	dc.b	$0,$1E,$0,$59,$0,$0,$0,$0,$7,$A,$0,$1B,$0,$0
	dc.b	$0,$3,$0,$1,$0,$11,$0,$F,$0,$10,$0,$1C,$0,$0
	dc.b	$0,$0,$0,$0,$2,$A,$0,$3,$0,$9,$0,$1E,$0,$1,$0
	dc.b	$10,$FF,$FF,$FF,$FF,$0,$1A,$0,$51,$0,$0,$0,$0
	dc.b	$2,$19,$0,$13,$0,$0,$0,$5,$0,$1,$0,$E,$FF,$FF
	dc.b	$FF,$FF,$0,$1A,$0,$51,$0,$0,$0,$0,$2,$1D,$0
	dc.b	$19,$0,$0,$0,$5,$0,$1,$0,$12,$FF,$FF,$FF,$FF
	dc.b	$0,$1D,$0,$8,$0,$0,$0,$0,$7,$26,$0,$3,$0,$B
	dc.b	$0,$1E,$0,$1,$0,$15,$0,$13,$0,$14,$0,$14,$0
	dc.b	$0,$0,$0,$0,$FE,$11,$0,$0,$3,$0,$E,$0,$1E,$0
	dc.b	$1,$0,$14,$FF,$FF,$FF,$FF,$0,$14,$0,$0,$0,$0
	dc.b	$0,$FF,$11,$11,$0,$0,$0,$0,$0,$2,$0,$1,$0,$12
	dc.b	$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$2
	dc.b	$57,$0,$5,$0,$0,$0,$14,$0,$1,$0,$16,$FF,$FF
	dc.b	$FF,$FF,$0,$1A,$0,$5,$0,$0,$0,$0,$2,$6C,$0,$3
	dc.b	$0,$11,$0,$8,$0,$1,$0,$0,$FF,$FF,$FF,$FF,$0
	dc.b	$1A,$0,$27,$0,$0,$0,$0,$2,$73,$0,$19,$0,$11
	dc.b	$0,$8,$0,$1,$FF,$FF,$0,$1,$0,$10,$0,$14,$0,$0
	dc.b	$0,$10,$0,$2,$11,$0,$0,$0,$0,$0,$0,$24,$0,$C
	dc.b	$0,$2,$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0,$0
	dc.b	$0,$2,$78,$0,$2,$0,$1,$0,$12,$0,$1,$0,$3,$FF
	dc.b	$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$2,$8B
	dc.b	$0,$3,$0,$3,$0,$11,$0,$1,$0,$4,$FF,$FF,$FF,$FF
	dc.b	$0,$1C,$0,$0,$0,$0,$0,$0,$2,$9D,$0,$16,$0,$3
	dc.b	$0,$2,$0,$1,$0,$5,$FF,$FF,$FF,$FF,$0,$1C,$0
	dc.b	$0,$0,$0,$0,$0,$2,$A0,$0,$8,$0,$4,$0,$C,$0,$1
	dc.b	$0,$6,$FF,$FF,$FF,$FF,$0,$1D,$0,$8,$0,$0,$0
	dc.b	$0,$7,$42,$0,$16,$0,$4,$0,$C,$0,$1,$0,$7,$FF
	dc.b	$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$2,$D2
	dc.b	$0,$2,$0,$5,$0,$12,$0,$1,$0,$8,$FF,$FF,$FF,$FF
	dc.b	$0,$1C,$0,$0,$0,$0,$0,$0,$2,$E5,$0,$1A,$0,$5
	dc.b	$0,$5,$0,$1,$0,$9,$FF,$FF,$FF,$FF,$0,$1C,$0
	dc.b	$0,$0,$0,$0,$0,$2,$EB,$0,$4,$0,$6,$0,$10,$0
	dc.b	$1,$0,$A,$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0
	dc.b	$0,$0,$2,$FC,$0,$1A,$0,$6,$0,$5,$0,$1,$0,$B
	dc.b	$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$3
	dc.b	$2,$0,$9,$0,$7,$0,$B,$0,$1,$0,$C,$FF,$FF,$FF
	dc.b	$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$3,$E,$0,$16,$0
	dc.b	$7,$0,$9,$0,$1,$0,$D,$FF,$FF,$FF,$FF,$0,$1C
	dc.b	$0,$0,$0,$0,$0,$0,$3,$18,$0,$4,$0,$8,$0,$10
	dc.b	$0,$1,$0,$E,$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0
	dc.b	$0,$0,$0,$3,$29,$0,$16,$0,$8,$0,$9,$0,$1,$0
	dc.b	$F,$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0,$0,$0
	dc.b	$3,$33,$0,$2,$0,$A,$0,$9,$0,$1,$0,$10,$FF,$FF
	dc.b	$FF,$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$3,$3D,$0,$C
	dc.b	$0,$A,$0,$8,$0,$1,$0,$0,$FF,$FF,$FF,$FF,$0,$1A
	dc.b	$0,$27,$0,$0,$0,$0,$3,$46,$0,$1A,$0,$A,$0,$7
	dc.b	$0,$1,$FF,$FF,$0,$1,$0,$8,$0,$14,$0,$0,$0,$10
	dc.b	$0,$2,$11,$0,$0,$0,$0,$0,$0,$24,$0,$A,$0,$2
	dc.b	$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$3
	dc.b	$49,$0,$4,$0,$1,$0,$1C,$0,$1,$0,$3,$FF,$FF,$FF
	dc.b	$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$3,$66,$0,$5,$0
	dc.b	$3,$0,$D,$0,$1,$0,$4,$FF,$FF,$FF,$FF,$0,$1C
	dc.b	$0,$0,$0,$0,$0,$0,$3,$74,$0,$14,$0,$3,$0,$C
	dc.b	$0,$1,$0,$5,$FF,$FF,$FF,$FF,$0,$1D,$0,$8,$0
	dc.b	$0,$0,$0,$7,$5E,$0,$4,$0,$4,$0,$1C,$0,$1,$0
	dc.b	$6,$FF,$FF,$FF,$FF,$0,$1A,$0,$5,$0,$0,$0,$0
	dc.b	$3,$B6,$0,$3,$0,$6,$0,$8,$0,$1,$0,$7,$FF,$FF
	dc.b	$FF,$FF,$0,$1A,$0,$7,$0,$0,$0,$0,$3,$BD,$0,$E
	dc.b	$0,$6,$0,$8,$0,$1,$0,$8,$FF,$FF,$FF,$FF,$0,$1A
	dc.b	$0,$5,$0,$0,$0,$0,$3,$C0,$0,$19,$0,$6,$0,$8
	dc.b	$0,$1,$0,$0,$FF,$FF,$FF,$FF,$0,$1A,$0,$25,$0
	dc.b	$0,$0,$0,$3,$C5,$0,$3,$0,$8,$0,$1E,$0,$1,$FF
	dc.b	$FF,$0,$1,$0,$B,$0,$14,$0,$0,$0,$10,$0,$2,$11
	dc.b	$0,$0,$0,$0,$0,$0,$24,$0,$C,$0,$2,$FF,$FF,$FF
	dc.b	$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$3,$DE,$0,$3,$0
	dc.b	$1,$0,$1E,$0,$1,$0,$3,$FF,$FF,$FF,$FF,$0,$1C
	dc.b	$0,$0,$0,$0,$0,$0,$3,$FD,$0,$3,$0,$3,$0,$A,$0
	dc.b	$1,$0,$4,$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0
	dc.b	$0,$0,$4,$8,$0,$10,$0,$3,$0,$C,$0,$1,$0,$7,$0
	dc.b	$5,$0,$6,$0,$14,$0,$0,$0,$0,$0,$1,$1,$0,$0,$2
	dc.b	$0,$5,$0,$C,$0,$3,$0,$6,$FF,$FF,$FF,$FF,$0,$1A
	dc.b	$0,$11,$0,$0,$0,$0,$4,$15,$0,$0,$0,$0,$0,$C
	dc.b	$0,$1,$0,$4,$FF,$FF,$FF,$FF,$0,$1A,$0,$11,$0
	dc.b	$0,$0,$0,$4,$20,$0,$0,$0,$2,$0,$C,$0,$1,$0,$8
	dc.b	$FF,$FF,$FF,$FF,$0,$1A,$0,$11,$0,$0,$0,$0,$4
	dc.b	$2A,$0,$11,$0,$5,$0,$7,$0,$1,$0,$9,$FF,$FF,$FF
	dc.b	$FF,$0,$1A,$0,$11,$0,$0,$0,$0,$4,$2F,$0,$11
	dc.b	$0,$7,$0,$7,$0,$1,$0,$A,$FF,$FF,$FF,$FF,$0,$1A
	dc.b	$0,$1,$0,$0,$0,$0,$4,$34,$0,$1B,$0,$5,$0,$7
	dc.b	$0,$1,$0,$B,$FF,$FF,$FF,$FF,$0,$1A,$0,$7,$0
	dc.b	$0,$0,$0,$4,$3A,$0,$2,$0,$A,$0,$8,$0,$1,$0,$0
	dc.b	$FF,$FF,$FF,$FF,$0,$1A,$0,$25,$0,$0,$0,$0,$4
	dc.b	$3D,$0,$1B,$0,$A,$0,$7,$0,$1,$FF,$FF,$0,$1,$0
	dc.b	$6,$0,$14,$0,$0,$0,$10,$0,$2,$11,$0,$0,$0,$0
	dc.b	$0,$0,$24,$0,$9,$0,$2,$FF,$FF,$FF,$FF,$0,$1C
	dc.b	$0,$0,$0,$0,$0,$0,$4,$44,$0,$7,$0,$1,$0,$16
	dc.b	$0,$1,$0,$3,$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0
	dc.b	$0,$0,$0,$4,$5B,$0,$8,$0,$3,$0,$E,$0,$1,$0,$4
	dc.b	$FF,$FF,$FF,$FF,$0,$15,$0,$0,$0,$0,$0,$0,$7
	dc.b	$7A,$0,$18,$0,$3,$0,$4,$0,$1,$0,$5,$FF,$FF,$FF
	dc.b	$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$4,$71,$0,$A,$0
	dc.b	$5,$0,$C,$0,$1,$0,$6,$FF,$FF,$FF,$FF,$0,$15
	dc.b	$0,$0,$0,$0,$0,$0,$7,$96,$0,$18,$0,$5,$0,$4
	dc.b	$0,$1,$0,$0,$FF,$FF,$FF,$FF,$0,$1C,$0,$20,$0
	dc.b	$0,$0,$0,$4,$85,$0,$7,$0,$7,$0,$16,$0,$1,$FF
	dc.b	$FF,$0,$1,$0,$1C,$0,$14,$0,$0,$0,$10,$0,$2,$11
	dc.b	$0,$0,$0,$0,$0,$0,$24,$0,$15,$0,$2,$FF,$FF,$FF
	dc.b	$FF,$0,$1C,$0,$41,$0,$0,$0,$0,$4,$9C,$0,$4,$0
	dc.b	$1,$0,$1C,$0,$1,$0,$3,$FF,$FF,$FF,$FF,$0,$1C
	dc.b	$0,$0,$0,$0,$0,$0,$4,$B9,$0,$5,$0,$2,$0,$1A
	dc.b	$0,$1,$0,$4,$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0
	dc.b	$0,$0,$0,$4,$D4,$0,$3,$0,$3,$0,$1D,$0,$1,$0
	dc.b	$B,$0,$5,$0,$A,$0,$14,$0,$0,$0,$0,$0,$FF,$1
	dc.b	$0,$0,$2,$0,$5,$0,$20,$0,$2,$0,$6,$FF,$FF,$FF
	dc.b	$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$4,$F2,$0,$4,$0
	dc.b	$0,$0,$8,$0,$1,$0,$7,$FF,$FF,$FF,$FF,$0,$1A
	dc.b	$0,$51,$0,$0,$0,$0,$4,$FB,$0,$4,$0,$1,$0,$8
	dc.b	$0,$1,$0,$8,$FF,$FF,$FF,$FF,$0,$1A,$0,$51,$0
	dc.b	$0,$0,$0,$5,$0,$0,$E,$0,$0,$0,$8,$0,$1,$0,$9
	dc.b	$FF,$FF,$FF,$FF,$0,$1A,$0,$51,$0,$0,$0,$0,$5
	dc.b	$5,$0,$18,$0,$0,$0,$8,$0,$1,$0,$A,$FF,$FF,$FF
	dc.b	$FF,$0,$1A,$0,$51,$0,$0,$0,$0,$5,$A,$0,$E,$0
	dc.b	$1,$0,$8,$0,$1,$0,$4,$FF,$FF,$FF,$FF,$0,$1A
	dc.b	$0,$51,$0,$0,$0,$0,$5,$F,$0,$18,$0,$1,$0,$8
	dc.b	$0,$1,$0,$E,$0,$C,$0,$D,$0,$1C,$0,$0,$0,$0,$0
	dc.b	$0,$5,$14,$0,$2,$0,$8,$0,$20,$0,$1,$0,$D,$FF
	dc.b	$FF,$FF,$FF,$0,$1A,$0,$51,$0,$0,$0,$0,$5,$21
	dc.b	$0,$E,$0,$0,$0,$8,$0,$1,$0,$B,$FF,$FF,$FF,$FF
	dc.b	$0,$1A,$0,$51,$0,$0,$0,$0,$5,$25,$0,$18,$0,$0
	dc.b	$0,$8,$0,$1,$0,$11,$0,$F,$0,$10,$0,$1C,$0,$0
	dc.b	$0,$0,$0,$0,$5,$28,$0,$2,$0,$A,$0,$20,$0,$1
	dc.b	$0,$10,$FF,$FF,$FF,$FF,$0,$1A,$0,$51,$0,$0,$0
	dc.b	$0,$5,$35,$0,$E,$0,$0,$0,$8,$0,$1,$0,$E,$FF
	dc.b	$FF,$FF,$FF,$0,$1A,$0,$51,$0,$0,$0,$0,$5,$3A
	dc.b	$0,$18,$0,$0,$0,$8,$0,$1,$0,$15,$0,$12,$0,$14
	dc.b	$0,$1C,$0,$0,$0,$0,$0,$0,$5,$3E,$0,$4,$0,$C
	dc.b	$0,$1E,$0,$1,$0,$13,$FF,$FF,$FF,$FF,$0,$1A,$0
	dc.b	$51,$0,$0,$0,$0,$5,$49,$0,$C,$0,$0,$0,$4,$0
	dc.b	$1,$0,$14,$FF,$FF,$FF,$FF,$0,$1A,$0,$51,$0,$0
	dc.b	$0,$0,$5,$4C,$0,$12,$0,$0,$0,$5,$0,$1,$0,$11
	dc.b	$FF,$FF,$FF,$FF,$0,$1A,$0,$51,$0,$0,$0,$0,$5
	dc.b	$50,$0,$19,$0,$0,$0,$5,$0,$1,$0,$18,$0,$16,$0
	dc.b	$17,$0,$1C,$0,$0,$0,$0,$0,$0,$5,$53,$0,$4,$0
	dc.b	$E,$0,$1E,$0,$1,$0,$17,$FF,$FF,$FF,$FF,$0,$1A
	dc.b	$0,$51,$0,$0,$0,$0,$5,$5E,$0,$C,$0,$0,$0,$8
	dc.b	$0,$1,$0,$15,$FF,$FF,$FF,$FF,$0,$1A,$0,$51,$0
	dc.b	$0,$0,$0,$5,$64,$0,$16,$0,$0,$0,$8,$0,$1,$0
	dc.b	$1B,$0,$19,$0,$1A,$0,$1C,$0,$0,$0,$0,$0,$0,$5
	dc.b	$6A,$0,$2,$0,$10,$0,$21,$0,$1,$0,$1A,$FF,$FF
	dc.b	$FF,$FF,$0,$1A,$0,$41,$0,$0,$0,$0,$5,$77,$0
	dc.b	$E,$0,$0,$0,$8,$0,$1,$0,$18,$FF,$FF,$FF,$FF
	dc.b	$0,$1A,$0,$41,$0,$0,$0,$0,$5,$7A,$0,$18,$0,$0
	dc.b	$0,$8,$0,$1,$0,$1C,$FF,$FF,$FF,$FF,$0,$1A,$0
	dc.b	$5,$0,$0,$0,$0,$5,$81,$0,$2,$0,$13,$0,$E,$0
	dc.b	$1,$0,$0,$FF,$FF,$FF,$FF,$0,$1A,$0,$27,$0,$0
	dc.b	$0,$0,$5,$8F,$0,$1A,$0,$13,$0,$8,$0,$1,$FF,$FF
	dc.b	$0,$1,$0,$E,$0,$14,$0,$0,$0,$10,$0,$2,$11,$0
	dc.b	$0,$0,$0,$0,$0,$24,$0,$E,$0,$2,$FF,$FF,$FF,$FF
	dc.b	$0,$1C,$0,$0,$0,$0,$0,$0,$5,$94,$0,$2,$0,$1
	dc.b	$0,$11,$0,$1,$0,$3,$FF,$FF,$FF,$FF,$0,$1D,$0
	dc.b	$8,$0,$0,$0,$0,$7,$B2,$0,$A,$0,$3,$0,$13,$0
	dc.b	$1,$0,$4,$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0
	dc.b	$0,$0,$5,$D2,$0,$1,$0,$4,$0,$E,$0,$1,$0,$5,$FF
	dc.b	$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$5,$E1
	dc.b	$0,$11,$0,$4,$0,$8,$0,$1,$0,$6,$FF,$FF,$FF,$FF
	dc.b	$0,$1C,$0,$0,$0,$0,$0,$0,$5,$EA,$0,$1,$0,$5
	dc.b	$0,$E,$0,$1,$0,$7,$FF,$FF,$FF,$FF,$0,$1C,$0
	dc.b	$0,$0,$0,$0,$0,$5,$F9,$0,$11,$0,$5,$0,$12,$0
	dc.b	$1,$0,$A,$0,$8,$0,$9,$0,$14,$0,$0,$0,$0,$0,$1
	dc.b	$1,$0,$0,$2,$0,$7,$0,$C,$0,$3,$0,$9,$FF,$FF
	dc.b	$FF,$FF,$0,$1A,$0,$11,$0,$0,$0,$0,$6,$C,$0,$0
	dc.b	$0,$0,$0,$C,$0,$1,$0,$7,$FF,$FF,$FF,$FF,$0,$1A
	dc.b	$0,$11,$0,$0,$0,$0,$6,$17,$0,$0,$0,$2,$0,$C
	dc.b	$0,$1,$0,$B,$FF,$FF,$FF,$FF,$0,$1A,$0,$11,$0
	dc.b	$0,$0,$0,$6,$21,$0,$11,$0,$7,$0,$7,$0,$1,$0
	dc.b	$C,$FF,$FF,$FF,$FF,$0,$1A,$0,$11,$0,$0,$0,$0
	dc.b	$6,$26,$0,$11,$0,$9,$0,$7,$0,$1,$0,$D,$FF,$FF
	dc.b	$FF,$FF,$0,$1A,$0,$1,$0,$0,$0,$0,$6,$2B,$0,$1B
	dc.b	$0,$7,$0,$7,$0,$1,$0,$E,$FF,$FF,$FF,$FF,$0,$1A
	dc.b	$0,$7,$0,$0,$0,$0,$6,$31,$0,$2,$0,$C,$0,$8,$0
	dc.b	$1,$0,$0,$FF,$FF,$FF,$FF,$0,$1A,$0,$25,$0,$0
	dc.b	$0,$0,$6,$34,$0,$1A,$0,$C,$0,$8,$0,$1,$FF,$FF
	dc.b	$0,$1,$0,$8,$0,$14,$0,$0,$0,$10,$0,$2,$11,$0
	dc.b	$0,$0,$0,$0,$0,$24,$0,$9,$0,$2,$FF,$FF,$FF,$FF
	dc.b	$0,$1C,$0,$0,$0,$0,$0,$0,$6,$3B,$0,$3,$0,$1
	dc.b	$0,$1E,$0,$1,$0,$3,$FF,$FF,$FF,$FF,$0,$1C,$0
	dc.b	$0,$0,$0,$0,$0,$6,$3C,$0,$3,$0,$2,$0,$1E,$0
	dc.b	$1,$0,$4,$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0
	dc.b	$0,$0,$6,$3D,$0,$3,$0,$3,$0,$1E,$0,$1,$0,$5
	dc.b	$FF,$FF,$FF,$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$6
	dc.b	$3E,$0,$3,$0,$4,$0,$1E,$0,$1,$0,$6,$FF,$FF,$FF
	dc.b	$FF,$0,$1C,$0,$0,$0,$0,$0,$0,$6,$3F,$0,$3,$0
	dc.b	$5,$0,$1E,$0,$1,$0,$7,$FF,$FF,$FF,$FF,$0,$1A
	dc.b	$0,$7,$0,$0,$0,$0,$6,$40,$0,$19,$0,$7,$0,$8
	dc.b	$0,$1,$0,$8,$FF,$FF,$FF,$FF,$0,$1A,$0,$5,$0
	dc.b	$0,$0,$0,$6,$41,$0,$E,$0,$7,$0,$8,$0,$1,$0,$0
	dc.b	$FF,$FF,$FF,$FF,$0,$1A,$0,$25,$0,$0,$0,$0,$6
	dc.b	$42,$0,$3,$0,$7,$0,$8,$0,$1,$FF,$FF,$0,$1,$0
	dc.b	$1,$0,$14,$0,$0,$0,$0,$0,$0,$11,$0,$0,$0,$0
	dc.b	$0,$0,$50,$0,$19
	dc.w	0,-1,-1
	dc.w	G_TEXT,LASTOB,NORMAL
	dc.l	$7CE
	dc.w	0,24,80,1
reloc_object_t_end:
;
reloc_pointer_t:	;offs: $19BA
	dc.l	reloc_object_t-patch_area_1	;$7EA
	dc.l	$E32
	dc.l	$105A
	dc.l	$11F2
	dc.l	$12CA
	dc.l	$13EA
	dc.l	$1492
	dc.l	$174A
	dc.l	$18B2
	dc.l	$198A
;
patch_area_1_end:	;T_75AC	;offs: $19E2
;
;----------------------------------------------------------------------------
;End of:	'patch_area_1'
;----------------------------------------------------------------------------
;
T_75AC:	dc.b	' Volume in drive '
T_75BD:	dc.b	'A is ',$0
T_75C3:	dc.b	'un-named',$0
T_75CC:	dc.b	' Directory of ',$0
T_75DB:	dc.b	' file(s)  ',$0
T_75E6:	dc.b	' bytes free',$0
T_75F2:	dc.b	'A:\*.*',$0
T_75F9:	dc.b	CR,LF,$0
T_75FC:	dc.b	$C,$0
T_75FE:	dc.b	'\',$0
T_7600:	dc.b	'  DISK',$0,' Disk Label:',$0
T_7614:	dc.b	'FOLDER',$0
T_761B:	dc.b	'Folder Name:',$0
T_7628:	dc.b	'Selection:  ',$0
T_7635:	dc.b	'New Name:   ',$0
T_7642:	dc.b	'Directory:  ',$0
T_764F:	dc.b	'Destination:',$0
T_765C:	dc.b	'Now doing...',$0
T_7669:	dc.b	'Current Name:',$0
T_7677:	dc.b	' Folder Name:',$0
default_fsel_prompt_s:
	dc.b	'Universal IV ',$0
T_7694:	dc.b	CR,LF,LF,'-End of file-',$D,$0
T_76a6:	dc.b	'-More-',$0
T_76AD:	dc.b	$1B,'Y8 ',$0
T_76B2:	dc.b	$1B,'E',$1B,'v',$0
bottom_bar_name_s:
	dc.b	'Name',$0
bottom_bar_size_s:
	dc.b	'Size',$0
bottom_bar_date_s:
	dc.b	'Date',$0
bottom_bar_time_s:
	dc.b	'Time'
bottom_bar_null_s:
	dc.b	$0
T_76CB:
	dc.b	'82',$0
pick_a_path_s:
	dc.b	'Pick a path:',$0
choose_extension_s:
	dc.b	'Choose an extension',$0
replace_extension_s:
	dc.b	' Replace extension ',$0
T_7703:	dc.b	',',$15,'-',$11,'/',$16,$14,$1F,$13,$10,$19
	dc.b	$18,'12&%$',$17,'#"!',$12,' .0',$1E,$10
T_771E:	dc.b	'5+',$19,'2.',$13,'-'
T_7725:	dc.b	$18,'1 ',$1F,$14,$D
disk_room_available_alst:
	dc.b	$0
	dc.b	'This disk has '
disk_room_available_num_s:
	dc.b		      '000000000',$0
	dc.b	'bytes available for use.',$0
	dc.b	$0
	dc.b	$0
	dc.b	'OK',$0,$0,$0
format_error_alst:
	dc.b	'Format error. Is the disk',$0
	dc.b	'write protected? If not, the',$0
	dc.b	'disk may be bad, or you are',$0
	dc.b	'formatting too many tracks.',$0
	dc.b	$0
T_77d4:
	dc.b	'Cancel',$0,$0,$0
folder_file_count_limit_alst:
	dc.b	$0
	dc.b	'Filename buffer full.',$0
	dc.b	'The UIS filename buffer is',$0
	dc.b	'large enough for 400 files.',$0
	dc.b	$0
	dc.b	'OK',$0,$0,$0
move_copy_operation_illegal_alst:
	dc.b	$0
	dc.b	'The folder move/copy opera-',$0
	dc.b	'tion you have attempted is',$0
	dc.b	'illegal.',$0
	dc.b	$0
	dc.b	'Cancel',$0,$0,$0
move_copy_file_to_itself_alst:
	dc.b	$0
	dc.b	'You are trying to move/copy',$0
	dc.b	'a file to itself.',$0
	dc.b	$0
	dc.b	$0
	dc.b	'Cancel',$0,$0,$0
named_file_already_exists_alst:
	dc.b	$0
	dc.b	'A file already exists with',$0
	dc.b	'the name you entered.',$0
	dc.b	$0
	dc.b	$0
	dc.b	'Cancel',$0,$0,$0
folder_nesting_limit_alst:
	dc.b	$0
	dc.b	'Folders may be nested only',$0
	dc.b	'8 levels deep.',$0
	dc.b	$0
	dc.b	$0
	dc.b	'Cancel',$0,$0,$0,$0
Delete_certain_query_alst:
Delete_folder_count_s:
	dc.b	'xxxxx Folders  ',$0
Delete_file_count_s:
	dc.b	'xxxxx Files',$0
	dc.b	'Are you sure you want to',$0
	dc.b	'perform this delete? Click',$0
	dc.b	'on Cancel to abort.',$0
	dc.b	'OK',$0,'Cancel',$0,$0
printer_missing_alst:
	dc.b	$0
	dc.b	'The printer is either not',$0
	dc.b	'turned on or is off line.',$0
	dc.b	$0
	dc.b	$0
	dc.b	'Retry',$0,'Cancel',$0,$0
not_enough_room_alst:
	dc.b	$0
	dc.b	"The disk doesn't have enough",$0
	dc.b	'room for this operation.',$0
	dc.b	$0
	dc.b	$0
	dc.b	'Cancel',$0,$0,$0
access_impossible_alst:
	dc.b	$0
	dc.b	'Access not possible. TOS',$0
	dc.b	'terminated the operation.',$0
	dc.b	$0
	dc.b	$0
	dc.b	'Cancel',$0,$0,$0
bad_pathname_alst:
	dc.b	$0
	dc.b	'Bad pathname. The pathname',$0
	dc.b	'entered is not acceptable.',$0
	dc.b	$0
	dc.b	$0
	dc.b	'Cancel',$0,$0,$0
name_conflict_file_locked_alst:
	dc.b	'Name conflicted file is',$0
	dc.b	'locked. Click on Skip to',$0
	dc.b	'skip this copy/move or OK',$0
	dc.b	'to do the copy/move anyway.',$0
	dc.b	$0
	dc.b	'OK',$0,'Skip',$0,$0
room_needed_alst:
	dc.b	'     xxxx Folders   ',$0
	dc.b	'     xxxx Files     ',$0
	dc.b	'xxxxxxxxx Bytes used',$0
	dc.b	'xxxxxxxxx Bytes needed',$0
	dc.b	$0
	dc.b	'OK',$0,$0,$0
file_match_found_alst:
	dc.b	'filename.ext',$0
	dc.b	'Was found in the path shown',$0
	dc.b	'above. Click on Use to move',$0
	dc.b	'to this path, Next to find',$0
	dc.b	'next matching file.',$0
	dc.b	'Use',$0,'Next',$0,'Cancel',$0
locked_file_delete_query_alst:
	dc.b	'Locked file found!',$0
	dc.b	'File '
locked_file_name_s:
	dc.b	'xxxxxxxx.xxx has been',$0
	dc.b	'locked from deletion. Click',$0
	dc.b	'on Skip to keep this file,',$0
	dc.b	'Delete to unlock & delete.',$0
	dc.b	'Delete',$0,'Skip',$0,$0
name_conflict_delete_query_alst:
	dc.b	'Files skipped due to name',$0
	dc.b	'conflicts: '
name_conflict_count_num_s:
	dc.b	'0000 - Click OK',$0
	dc.b	'to delete original files',$0
	dc.b	'(including any skipped), or',$0
	dc.b	'Cancel to stop the delete.',$0
	dc.b	'OK',$0,'Cancel',$0,$0
move_copy_aborted_on_conflict_alst:
	dc.b	$0
	dc.b	'Move/Copy operation aborted',$0
	dc.b	'during a name conflict.',$0
	dc.b	$0
	dc.b	$0
	dc.b	'OK',$0,$0,$0
no_file_match_found_alst:
	dc.b	$0
	dc.b	'A file matching the search',$0
	dc.b	'criteria was not found.',$0
	dc.b	$0
	dc.b	$0
	dc.b	'OK',$0,$0,$0
cancel_this_operation_alst:
	dc.b	$0
	dc.b	$0
	dc.b	'Cancel this operation?',$0
	dc.b	$0
	dc.b	$0
	dc.b	'Cancel',$0,'Continue',$0,$0
print_or_show_file_alst:
	dc.b	$0
	dc.b	$0
	dc.b	'Print or show file?',$0
	dc.b	$0
	dc.b	$0
	dc.b	'Show',$0,'Print',$0,'Cancel',$0
cant_find_UIS_IV_PRG_alst:
	dc.b	$0
	dc.b	"Can't find UIS_IV.PRG  where",$0
	dc.b	'it was booted from. You need',$0
	dc.b	'to re-insert your boot disk.',$0
	dc.b	$0
	dc.b	'Retry',$0,'Cancel',$0,$0,$0
;
;----------------------------------------------------------------------------
;
UIS_intin:
	ds.w	16
UIS_intout:
	ds.w	7
UIS_ptsin:
	ds.l	5
UIS_ptsout:
	ds.l	1
UIS_addrin:
	ds.l	3
UIS_addrout:
	ds.l	1
UIS_aespb_p:
	ds.l	1	;-> UIS_aespb
UIS_vdipb_p:
	ds.l	1	;-> UIS_vdipb
UIS_aespb:
	ds.l	1	;-> UIS_contrl
	ds.l	1	;-> UIS_global
	ds.l	1	;-> UIS_intin
	ds.l	1	;-> UIS_intout
	ds.l	1	;-> UIS_addrin
	ds.l	1	;-> UIS_addrout
UIS_vdipb:
	ds.l	1	;-> UIS_contrl
	ds.l	1	;-> UIS_intin
	ds.l	1	;-> UIS_ptsin
	ds.l	1	;-> UIS_intout
	ds.l	1	;-> UIS_ptsout
UIS_contrl:
	ds.w	20
UIS_global:
	ds.w	15
;
;----------------------------------------------------------------------------
;Start of:	runtime 'cref' relative definitions
;----------------------------------------------------------------------------
cref:	;central reference point for indexed addressing [usually via(a6)]
;	;this was originally T_7F14
;NB:	This means that the startup code below will be overwritten, and
;	used for variable storage once the startup is completed.
;	Some constants are predefined, but may be relocated for runtime...!
;
ref_vernum_s		= cref+$00	; 1 L  Version number as 4 ascii (X.YY)
ref_line_a_base_p	= cref+$10	; 1 ->	line_a variable base
;
ref_v_cel_my		= cref+$14	;temp storage of la_v_cel_my
;
ref_char_height		= cref+$1A	; 1 w	character height
;
ref_mediach_flag	= cref+$28	; 1 w	forces media change
;
ref_fsel_prompt_1_p	= cref+$D2	; 1 ->  prompt string 1
ref_fsel_prompt_2_p	= cref+$D6	; 1 ->  prompt string 2
;
ref_bottom_bar_type	= cref+$E8	; 1 w	0..3
;
ref_fsel_path_p		= cref+$EE	; 1 ->  callers path string
ref_fsel_name_p		= cref+$F2	; 1 ->  callers name string
;
ref_wk_handle		= cref+$164	; 1 w	screen physical workstation handle
;
ref_planes		= cref+$172	; 1 w	bit planes  (from la_planes)
;
ref_max_column		= cref+$176	; 1 w	max column (limited to 79)
;
ref_cell_xmax		= cref+$176	; 1 w	max column in char rows
;
;----------------------------------------------------------------------------
;
startup:
	move.l	4(sp),a5		;a5 -> basepage
	move.l	bp_textlen(a5),d0
	add.l	bp_bss_len(a5),d0
	addi.l	#$100,d0		;d0 = program space incl BSS and basepage
	lea	0(a5,d0.l),sp		;sp -> top of bss section
	clr	-(sp)			;push zero word on stack (for Ptermres ?)
	move.l	d0,-(sp)		;push program space need on stack (for Ptermres ?)
	move.l	sp,a0			;save sp in a0
	lea	UIS_contrl(pc),sp
	pea	UIS_ptsout(pc)		;\
	pea	UIS_intout(pc)		; \
	pea	UIS_ptsin(pc)		;  X init UIS_vdipb
	pea	UIS_intin(pc)		; /
	pea	UIS_contrl(pc)		;/
	pea	UIS_addrout(pc)		;\
	pea	UIS_addrin(pc)		; \
	pea	UIS_intout(pc)		;  \/ init
	pea	UIS_intin(pc)		;  /\ UIS_aespb
	pea	UIS_global(pc)		; /
	pea	UIS_contrl(pc)		;/
	pea	UIS_vdipb(pc)		;init UIS_vdipb_p
	pea	UIS_aespb(pc)		;init UIS_aespb_p
	move.l	a0,sp			;restore sp from a0
	lea	cref(pc),a6		;a6 -> cref  for internal references
	move.l	#version_s_const,d0	;d0 = version number as 4 ACSII
	move.l	d0,ref_vernum_s-cref(a6)
	lea	install_UIS_query_vernum_s(pc),a0
	bsr.s	.T_7F94					;patch UIS_query version number
	lea	UIS_boot_message_vernum_s(pc),a0
	bsr.s	.T_7F94					;patch UIS_boot version number
	linea	#0			;a0 -> line_a variable base
	move.l	a0,ref_line_a_base_p-cref(a6)
;;;;	move	la_v_cel_ht(a0),ref_char_height-cref(a6)
	jsr	(IVp_startup_1).l
	bra	startup_1
;
;------------------------------------
;
.T_7F94:	moveq	#3,d1
.T_7F96:	rol.l	#8,d0
	move.b	d0,(a0)+
	dbra	d1,.T_7F96
	rts
;
;----------------------------------------------------------------------------
far_ref_start:
;;;
;;;bra_end_prog_resident:
;;;	bra	end_prog_resident	;4
;;;
;;;------------------------------------
;;;
;;;lea_basepage_plus_bp_arglen_a5:
;;;		lea	start(pc),a5	;4
;;;		sub	#$80,a5		;4
;;;		rts			;2
;;;
;;;------------------------------------
;;;lea_install_bios_sub_a1:
;;;	lea	install_bios_sub(pc),a1	;4
;;;	rts				;2
;;;
;;;------------------------------------
;;;
;;;lea_bios_framesize_const_a0:
;;;	lea	bios_framesize_const(pc),a0	;4
;;;	rts					;2
;;;
;;;------------------------------------
;;;
;;;lea_install_xgemdos_sub_a0:
;;;	lea	install_xgemdos_sub(pc),a0	;4
;;;	rts					;2
;;;
;;;------------------------------------
;;;
;;;go_force_XB:
;;;	bra	force_XB	;4
;;;	nop			;2
;;;
;--------------------------------------
;--------------------------------------
idiocy_pad	set	38-(*-far_ref_start)	;;;calculate code length difference
	rept	idiocy_pad/2	;;; \
	nop			;;;  X Pad to maintain code length
	endr			;;; /
;;;
;----------------------------------------------------------------------------
;Start of:	'patch_area_2'
;----------------------------------------------------------------------------
patch_area_2:
;NB:	This area is copied (from file) to patch_area_3,
;	when file selector is called after a change of character size.
;	This will normally be due to a resolution change.
;	All code in this area must be position independent...!
;
;This subroutine is called here at startup, with a5 -> patch_area_1
;patch_area_3 copy is called at char size change, with a5 -> patch_area_1
;
startup_sub_1:
	move.l	a5,d7		;d7 = a5 -> patch_area_1
	move	reloc_tedinfo_offs-patch_area_1(a5),d0
	lea	0(a5,d0),a4	;a4 -> first tedinfo to relocate
	move	reloc_tedinfo_count-patch_area_1(a5),d0
	subq	#1,d0
.loop_1:
	add.l	d7,(a4)		;\
	add.l	d7,4(a4)	; X relocate 3 consecutive pointers of 'tedinfo' structure
	add.l	d7,8(a4)	;/
	lea	28(a4),a4	;step a4 28 bytes to next 'tedinfo' structure
	dbra	d0,.loop_1
;
	move	reloc_object_t_offs-patch_area_1(a5),d0
	lea	0(a5,d0),a4	;a4 -> first object to relocate
	move	reloc_object_count-patch_area_1(a5),d0
	subq	#1,d0
.loop_2:
	cmp	#G_BOX,6(a4)
	beq.s	.T_800A
	cmp	#G_BOXCHAR,6(a4)
	beq.s	.T_800A
	add.l	d7,12(a4)	;relocate ptr unless object is G_BOX or G_BOXCHAR
.T_800A:
	lea	24(a4),a4	;step a4 24 bytes to next object in reloc_object_t
	dbra	d0,.loop_2
;
	move	reloc_pointer_t_offs-patch_area_1(a5),d0
	lea	0(a5,d0),a4	;a4 -> first pointer to relocate
	lea	50(a6),a0	;a0 -> cref+50
	moveq	#10-1,d0	;prep to relocate 10 pointers
.loop_3:
	add.l	d7,(a4)		;relocate a pointer
	move.l	(a4)+,(a0)+	;and copy it into the table at 'cref+50'
	dbra	d0,.loop_3
;
	move	ref_char_height-cref(a6),d7	;d7 = character cell height
	move	reloc_object_t_offs-patch_area_1(a5),d0
	lea	0(a5,d0),a4	;a4 -> first object in table
	move	reloc_object_count-patch_area_1(a5),d0
	subq	#1,d0
loop_4:				;loop target to fix object coordinates and sizes
;;;		moveq	#8,d1		;2 \
;;;		mulu	16(a4),d1	;4  X Fix object xpos by 8 pixels/char
;;;		move	d1,16(a4)	;4 /
	lea	16(a4),a0			;;;4 \/ Fix object xpos
	jsr	mulu_char_width_ia0_d1-cref(a6)	;;;4 /\ by font cell width
	nop					;;;2
	move	d7,d1		;2 \
	mulu	18(a4),d1	;4  X Fix object ypos by font cell height
	move	d1,18(a4)	;4 /
;;;		moveq	#8,d1		;2 \
;;;		mulu	20(a4),d1	;4  X Fix object width by 8 pixels/char
;;;		move	d1,20(a4)	;4 /
	lea	20(a4),a0			;;;4 \/ Fix object width
	jsr	mulu_char_width_ia0_d1-cref(a6)	;;;4 /\ by font cell width
	nop					;;;2
	move	d7,d1		;2 \
	mulu	22(a4),d1	;4  X Fix object height by font cell height
	move	d1,22(a4)	;4 /
	cmp	#G_BOX,6(a4)
	beq.s	T_808C
	cmp	#G_BOXCHAR,6(a4)
	beq.s	T_808C
	cmp	#G_BOXTEXT,6(a4)
	bne.s	T_80B4
	move.l	12(a4),a3
	move	$16(a3),d1
	bpl.s	T_80B4
	neg	d1
	move	d1,$16(a3)
	bra.s	T_8098
;
T_808C:	move.b	13(a4),d1
	bpl.s	T_80B4
	neg.b	d1
	move.b	d1,13(a4)
T_8098:	ext	d1
	tst	$10(a4)
	beq.s	T_80AA
	tst	$12(a4)
patch_area_3_p:			;NB: this ptr must be initialized by startup
	beq.s	T_80AA
	sub	d1,$12(a4)
T_80AA:	lsl	#1,d1
	add	d1,$14(a4)
	add	d1,$16(a4)
T_80B4:	lea	$18(a4),a4	;step a4 -> next object in table
	dbra	d0,loop_4
	move.l	50(a6),a3
	subi.l	#$20002,$5E4(a3)
	bset	#7,$5F1(a3)
	lea	$360(a3),a4
	move	#$20,-$4(a4)
	addq	#8,-$8(a4)
	subq	#4,-$6(a4)
	addq	#8,-$2(a4)
	addq	#1,$2A(a4)
	addq	#2,$42(a4)
	addq	#3,$5A(a4)
	addq	#4,$72(a4)
	addq	#5,$8A(a4)
	addq	#6,$a2(a4)
	addq	#7,$BA(a4)
	addq	#8,$d2(a4)
	addq	#2,$102(a4)
	addq	#3,$11A(a4)
	addq	#4,$132(a4)
	addq	#5,$14A(a4)
	addq	#6,$162(a4)
	addq	#7,$17A(a4)
	addq	#8,$192(a4)
	add	#9,$1AA(a4)
	addq	#2,$1DA(a4)
	addq	#3,$1F2(a4)
	addq	#4,$20A(a4)
	addq	#5,$222(a4)
	addq	#6,$23A(a4)
	addq	#7,$252(a4)
	addq	#8,$26A(a4)
	moveq	#$19,d0
T_8144:	subq	#1,$14(a4)
	lea	$18(a4),a4
	dbra	d0,T_8144
	addq	#1,$178(a3)
	subq	#2,$17C(a3)
	addq	#2,$344(a3)
	lea	$60(a3),a4
	moveq	#7,d0
	move	d7,d1
	lsr	#1,d1
T_8166:	sub	d1,$12(a4)
	lea	$18(a4),a4
	dbra	d0,T_8166
	sub	d1,$282(a3)
	addq	#1,$132(a3)
	subq	#1,$136(a3)
	move	d7,d0
	lsr	#2,d0
	lea	$108(a3),a4
;----------------------------------------------------------------------------
;Start of:	'patch_area_3'		;NB: overlaps patch_area 2
;----------------------------------------------------------------------------
patch_area_3:
	add	d0,$12(a4)
	sub	#$E0,$14(a4)
	move.l	12(a4),a0
	moveq	#2,d0
T_8196:
	move.l	(a0)+,a1
	clr.b	$24(a1)
	dbra	d0,T_8196
	move	#$25,12(a0)
	move	#$25,14(a0)
	lea	$138(a3),a0
	move.l	a0,$100(a6)
	or	#$80,8(a0)
	lea	$194(a6),a1
	move.l	12(a0),a0
	move.l	a1,(a0)
	move	#15,$18(a0)
	move.l	$36(a6),a3
	lea	$1B0(a3),a3
	subq	#2,$10(a3)
	addq	#2,$28(a3)
	addq	#1,$2A(a3)
	addq	#2,$42(a3)
	move.l	$4A(a6),a3
	subq	#2,$2A(a3)
	addq	#4,$58(a3)
	move	d7,d0
	lsr	#1,d0
	add	d0,$8E(a3)
	add	d0,$a2(a3)
	add	d0,$EA(a3)
	add	d0,$102(a3)
	add	d0,$11A(a3)
	add	d0,$162(a3)
	add	d0,$1AA(a3)
	add	d0,$20A(a3)
	add	d0,$252(a3)
	move.l	$56(a6),a3
	move.l	$24(a3),a3
	lea	$2550(a6),a0
	move.l	a0,(a3)
	clr.b	$EA(a6)
	move.l	T_8276(pc),$B8(a6)
	move	T_827A(pc),$20(a6)
	clr.b	$1F(a6)
	lea	T_827C(pc),a0
	move.l	$32(a6),a1
	move.l	$9C(a1),a1
	moveq	#15,d0
T_8246:	move.b	(a0)+,(a1)+
	dbra	d0,T_8246
	move.l	$36(a6),a1
	move.l	$144(a1),a1
	move.l	(a1),a1
T_8256:	move.b	(a0)+,(a1)+
	bne.s	T_8256
	rts
;
;----------------------------------------------------------------------------
;Start of:	'patch_area_5'		;NB: overlaps patch_areas 2 & 3
;----------------------------------------------------------------------------
patch_area_5:
	dc.b	$0,$4,$0,$1,$0,$0,$1,$0,$0,$0,$0,$0,$1,$1,$0
	dc.b	$0,$0,$1,$0,$A,$0,'P',$0,$0,'',$0
T_8276:
	dc.b	$0,$0,$0,$0
T_827A:
	dc.b	$0,$0
T_827C:
	dc.b	'EX1',$0,'EX2',$0,'EX3',$0,'EX4',$0
	dc.b	'82',$0,$0
;
patch_area_5_end:
;----------------------------------------------------------------------------
;End of:	'patch_area_5'		;NB: overlaps patch_areas 2 & 3
;----------------------------------------------------------------------------
patch_area_2_end:
;----------------------------------------------------------------------------
;End of:	'patch_area_2'		;NB: overlaps patch_areas 3 & 5
;----------------------------------------------------------------------------
;
startup_1:
	lea	patch_area_1(pc),a5
	bsr	startup_sub_1
	lea	patch_area_5(pc),a0
	move.l	(a0)+,$B4(a6)
	move.l	(a0)+,$BC(a6)
	move.l	(a0)+,$C0(a6)
	move.l	(a0)+,$C4(a6)
	move.l	(a0)+,$C8(a6)
	move.l	(a0)+,$CC(a6)
	move.b	(a0),$EB(a6)
	bsr	T_a48
	beq.s	T_82CE
	move.l	$4A(a6),a0
	move.l	$24(a0),a0
	move.l	a0,ref_fsel_prompt_2_p-cref(a6)
	bsr	T_4d32
T_82CE:	bsr	T_B66
	xbios	Supexec,fix_framesize_d0_is_os_version(pc)
	clr	$d0(a6)
	cmp	#$102,d0
	bcs.s	T_82F6
	st	$d0(a6)
	cmp	#$104,d0
	bcs.s	T_82F6
	addq.b	#1,$d1(a6)
T_82F6:	clr.l	$16(a6)
	clr	$22(a6)
	bsr	T_8498
	st	ref_mediach_flag-cref(a6)
	xbios	Supexec,install_UIS_cookie(pc)
	add.l	d0,(sp)
	btst	#0,$d1(a6)
;;;		bne.s	skipped_idiot	;old conditional branch
	bra.s	skipped_idiot		;new mandatory branch
;;;
;;; Here follows a code segment originally intended to install a keyboard handler
;;; that would implement warm and cold reset commands (Alt-Ctl-Del & Alt-Ctl-Sh-Del).
;;; The installation was BUGGED and extremely dependent on an old TOS-version.
;;; All modern TOS have keyboard commands for reset anyway, so this one is scrapped.
;;;
;;;		xbios	Iorec,#1			;12 \
;;;		lea	iorec_idiocy(pc),a0		; 4  \
;;;		move	d0,(a0)				; 2   \
;;;		addq	#8,d0				; 2    \/ old 32 byte idiocy
;;;		lea	iorec_idiocy_plus_8_a(pc),a0	; 4    /\ for bugged KB reset
;;;		move	d0,(a0)				; 2   /
;;;		lea	iorec_idiocy_plus_8_b(pc),a0	; 4  /
;;;		move	d0,(a0)				; 2 /
;;;
;;;		xbios	Kbdvbase		; 8 \
;;;		move.l	d0,a3			; 2  \
;;;		bios	Kbshift,#$93		;12   \
;;;		move	d0,d5			; 2    \/ another 52 bytes idiocy
;;;		suba.l	a2,a2			; 2    /\ for bugged keyboard reset
;;;		move	4(a0),a2		; 4   /
;;;		xbios	Supexec,T_83AA(pc)	;12  /
;;;		bios	Kbshift,d5		;10 /
;;;
idiocy_pad	set 84		;;;calculate code length difference
	rept	idiocy_pad/2	;;; \
	nop			;;;  X Pad to maintain code length
	endr			;;; /
;;;
;;;
skipped_idiot:
	lea	T_56a2(pc),a0
	move	#$3120,d0
T_8378:	move	d0,(a0)
	move	d0,-$4C4(a0)
	lea	$7A(a0),a0
	add	#$100,d0
	cmp	#$3920,d0
	bls.s	T_8378
	move	#$3020,(a0)
	move	#$3020,-$4C4(a0)
	lea	$25E2(a6),a0
	move.l	a0,8(a6)
	lea	$F8(a6),a0
	move.l	a0,12(a6)
	jmp	end_prog_resident-cref(a6)
;
;----------------------------------------------------------------------------
;;;
;;;	T_83AA:						;- \
;;;		move.l	a2,d0				;2  \
;;;		bmi.s	.T_83C8				;2   \
;;;		cmpi.b	#$93,(a2)			;4    \
;;;		bne.s	.T_83C8				;2     \
;;;		lea	idiotic_sub_p(pc),a0		;4      \ / old 32 byte
;;;		move.l	$20(a3),(a0)			;4       X  sub (bugged) installing
;;;		subq.l	#idiotic_sub_p-idiocy_start,a0	;2      / \ keyboard reset (redundant)
;;;		move.l	a0,$20(a3)			;4     /
;;;		lea	half_addr_idiocy(pc),a0		;4    /
;;;		move	a2,(a0)				;2   /
;;;	.T_83C8:					;-  /
;;;		rts					;2 /
;;;
idiocy_pad	set	32		;;;total bytes to pad
	rept	idiocy_pad/2	;;; \
	nop			;;;  X Pad to maintain code length
	endr			;;; /
;;;
;----------------------------------------------------------------------------
;Start of:	Cookie installation subroutine
;----------------------------------------------------------------------------
;
install_UIS_cookie:
	lea	cref(pc),a6		;a6 -> cref
	lea	(hdv_mediach).w,a0	;\
	lea	nu_mediach(pc),a1	; \ / new 16 byte routine
	jsr	force_XB-cref(a6)	;  X  installing
	nop				; / \ 'nu_mediach'
	nop				;/
	moveq	#0,d0
.retry_install_cookie:
	move.l	(_cookies).w,d1		;d1 -> cookie jar
	beq.s	.cookies_were_absent
	move.l	d1,a0			;a0 -> cookie jar
	moveq	#1,d1			;d1 = 1  as cookie counter
.test_cookie_loop:
	tst.l	(a0)			;null cookie ?  (sizer)
	beq.s	.sizer_cookie_found
	cmpi.l	#'OS-M',(a0)		;'OS-M' cookie ?  (what the heck is...)
	bne.s	.T_83FA
	tas.b	$d1(a6)
.T_83FA:
	cmpi.l	#'UIS3',(a0)		;'UIS3' cookie ?  (that's us folks)
	bne.s	.test_next_cookie
	move.l	a6,4(a0)		;link that cookie to our 'cref' (???)
	bra.s	.go_done_cookie		;BUG: may be double install (see make_new_jar etc.)
;
;------------------------------------
;
.test_next_cookie:
	addq.l	#8,a0
	addq.l	#1,d1
	bra.s	.test_cookie_loop
;
;------------------------------------
;
.sizer_cookie_found:
	cmp.l	4(a0),d1		;compare d1 (cookies found) to cells available
	bhs.s	.make_new_jar
	move.l	#'UIS3',(a0)+		;install 'UIS3' cookie  (replaces old sizer)
	move.l	(a0),d1			;d1 = old sizer value
	move.l	a6,(a0)+		;link new 'UIS3' cookie to our 'cref'
	clr.l	(a0)+			;install new sizer cookie
	move.l	d1,(a0)			;with unchanged sizer value
.go_done_cookie:
	bra.s	done_cookie
;
;------------------------------------
;
.make_new_jar:
	addq.l	#8,d1			;d1 = new jar size  (8 cookies larger)
	move.l	d1,d0
	lsl.l	#3,d0			;d0 = bytes needed for new cookie jar
	lea	$2902(a6),a0		;a0 -> new cookie jar
	move.l	(_cookies).w,a1		;a1 -> old cookie jar
	move.l	a0,(_cookies).w		;install new cookie jar (a bit early...)
.copy_jar_loop:
	move.l	(a1)+,(a0)+		;copy another old cookie to new jar
	beq.s	.sizer_cookie_copied
	move.l	(a1)+,(a0)+		;copy another old value to new jar
	bra.s	.copy_jar_loop
;
.sizer_cookie_copied:
	move.l	d1,(a0)
	bra.s	.retry_install_cookie	;stupid method! (weakens safety)
;
;------------------------------------
;
.cookies_were_absent:
	lea	$2902(a6),a0
	move.l	#$80,d0
	move.l	a0,(_cookies).w		;_p_cookies
patch_area_3_end:
;----------------------------------------------------------------------------
;End of:	'patch_area_3'
;----------------------------------------------------------------------------
	move.l	#'UIS3',(a0)+
	move.l	a6,(a0)+
	clr.l	(a0)+
	moveq	#$10,d1
	move.l	d1,(a0)
	lea	old_resvalid(pc),a0
	move.l	(resvalid).w,(a0)
	lea	(resvector).w,a0		;\
	lea	nu_resvector(pc),a1		; \/ new routine
	jsr	force_XB-cref(a6)		; /\ installing resvector
	nop					;/
	move.l	#$31415926,(resvalid).w
done_cookie:
	rts
;
;----------------------------------------------------------------------------
;End of:	Cookie installation subroutine
;----------------------------------------------------------------------------
;
fix_framesize_d0_is_os_version:
	tst	(_longframe).w
	beq.s	.T_848E
	lea	cref(pc),a0
	move	#8,bios_framesize_const-cref(a0)
.T_848E:
	move.l	(_sysbase).w,a0
	move	2(a0),d0
	rts
;
;----------------------------------------------------------------------------
;
T_8498:
;;;;	lea	basepage+bp_arglen-cref(a6),a5
	lea	basepage+bp_arglen,a5		;;;;
	move.l	a5,a0
	lea	boot_AUTO_UIS_IV_PRG_s(pc),a1
.T_84a2:
	move.b	(a1)+,(a0)+
	bne.s	.T_84a2
	gemdos	Dgetdrv
	move	d0,d7
	addi.b	#$41,d0
	move.b	d0,(a5)
	clr.b	$1C(a6)
	lea	UIS_intout(pc),a0
	clr	(a0)
	lea	UIS_contrl(pc),a0
	move.l	#$340001,(a0)+		;form_alert
	move.l	#$10001,(a0)+
	move	#0,(a0)
	lea	UIS_intin(pc),a0
	move	#1,(a0)
	lea	UIS_addrin(pc),a0
	lea	install_UIS_query_al_s(pc),a1
	move.l	a1,(a0)
	move.l	UIS_aespb_p(pc),d1
	move	#$C8,d0
	trap	#2			;call aes
	move	UIS_intout(pc),d0
	tst	d0
	beq.s	.T_8536
	cmp	#2,d0
	bne.s	.T_8504
	clr	-(sp)
	trap	#1			;Pterm0
	addq.l	#2,sp
;
;------------------------------------
;
.T_8504:
	st	$1C(a6)
	lea	install_xgemdos_sub-cref(a6),a0
	xbios	Supexec,(a0)
	addq.l	#2,a5
	addq	#1,d7
	gemdos	Dgetpath,(a5),d7
.T_8526:
	tst.b	(a5)+
	bne.s	.T_8526
	subq.l	#1,a5
	lea	root_UIS_IV_PRG_s(pc),a0
.T_8530:
	move.b	(a0)+,(a5)+
	bne.s	.T_8530
	bra.s	.T_8542
;
;------------------------------------
;
.T_8536:
	gemdos	Cconws,UIS_boot_message_s(pc)
.T_8542:
	xbios	Supexec,.T_8550(pc)
	rts
;
;------------------------------------
;
.T_8550:
	lea	cref(pc),a6
	lea	install_bios_sub-cref(a6),a1
	jsr	(a1)
;;;;	nop
	nop
	nop
	nop
	nop
	nop
	nop
	move.l	(ev_gemdos).w,$24(a6)	;BUG: illegal vector use (elsewhere)
	rts
;
;----------------------------------------------------------------------------
;
boot_AUTO_UIS_IV_PRG_s:
	dc.b	'A:\AUTO'
root_UIS_IV_PRG_s:
	dc.b	'\UIS_IV.PRG',NUL,NUL
install_UIS_query_al_s:
	dc.b	'[0]['
	dc.b	'|'
	dc.b	'Universal Item Selector IV   |'
	dc.b	'version '
install_UIS_query_vernum_s:
	dc.b		'     Rev: 1.0   1989|'
	dc.b	'Application & Design Software|'
	dc.b	']'
	dc.b	'[Install|Cancel]',NUL
UIS_boot_message_s:
	dc.b	ESC,'E',CR,LF
	dc.b	'  ***********************************',CR,LF
	dc.b	'  *  Universal Item Selector IV    *',CR,LF
	dc.b	'  *  version '
UIS_boot_message_vernum_s:
	dc.b		     '     Copyright  1989  *',CR,LF
	dc.b	'  *  Application & Design Software  *',CR,LF
	dc.b	'  * Grants Pass, OR  (503) 476-0071 *',CR,LF
	dc.b	"  * Revision:      (9'th Jan 1997)  *",CR,LF
	dc.b	'  *    by:    Ulf Ronald Andersson  *',CR,LF
	dc.b	'  ***********************************',CR,LF
	dc.b	LF,$0
;----------------------------------------------------------------------------
	SECTION	BSS
;----------------------------------------------------------------------------
;
	ds.b	$20E2		;stack & variables [ref'd via (a6)]
;
;----------------------------------------------------------------------------
	End
;----------------------------------------------------------------------------
;End of file:	UIS_IV.S
;----------------------------------------------------------------------------
