;----------------------------------------------------------------------------
;File name:	RUN_CIV.S		Revision date:	1999.03.01
;Created by:	Anatsu Ronara		Creation date:	1993.10.01
;----------------------------------------------------------------------------
	include	RA_LA.I
	include	RA_XB.I
	include	RA_TOS.I
	include	RA_GEM.I
;----------------------------------------------------------------------------
XB_cpu_mode	set	2
;----------------------------------------------------------------------------
unlottery_LEVEL	= 8	;wonders lottery allowed for lower levels only
max_lotteries	= 5     ;max wonder lotteries per turn
;----------------------------------------------------------------------------
;
	text
;
init_prog:
	move.l	sp,a5
	lea	stack_top(pc),sp
	move.l	4(a5),a5		;a5 -> basepage
	move.l	bp_textlen(a5),d0
	add.l	bp_datalen(a5),d0
	add.l	bp_bss_len(a5),d0
	addi.l	#$100,d0
	gemdos	Mshrink,!,(a5),d0
;
	xbios	Iorec,#1
	move.l	d0,kb_iorec_p
	xbios	Keytbl,?,?,?
	move.l	d0,keytbl_ptp
	gemdos	Super,!
	move.l	d0,-(sp)
	move.l	(phystop).w,lim_adr
;*********; Here starts TOS identification/adaption
	move.l	(_sysbase).w,a0
	move	2(a0),TOS_version
	move.l	os_selfbeg_p(a0),a0
	move.l	$24(a0),a1	;->kbshift variable in modern TOS >= 1.4
	cmp	#$0104,2(a0)	;check OS version
	bhs.s	insta_OS
;this is an init of kbshift_p, valid for TOS <= TOS 1.04
	move.l	keytbl_ptp,a1
	subq	#1,a1		;NB: This assumes Kbshift stored at Keytbl-1.
;				;NB: All early TOS have Kbshift data there !!!
insta_OS:
	move.l	a1,kbshift_p
	movem.l	(hw_pal).w,d0-d3/a0-a3
	movem.l	d0-d3/a0-a3,saved_pal
	move.l	(_v_bas_ad).w,saved_v_bas_ad
	gemdos	Super,()
;
	xbios	Getrez
	move	d0,entry_rez
;
	gemdos	Super,!
	move.l	d0,-(sp)
	tst	(_longframe).w
	sne	longframe_f
	gemdos	Super,()
;
	clr	initpath_f
restart_loop:
	clr	restart_f
	clr	quit_cmd_f
	lea	null_s(pc),a0
	gemdos	Pexec,#3,game_name_s(pc),(a0),(a0)	;Load civilization
	tst.l	d0
	bmi	main_exit
;
	move.l	d0,a0
	add	#$100,a0		;a0 -> program base address
;
	lea	CivPatch_tb(pc),a1
.patch_loop_1:
	move.l	(a1),d0
	cmp.l	#-1,d0
	beq.s	.patch_known
	add.l	a0,d0
	move.l	d0,(a1)+
	bra.s	.patch_loop_1
;
.patch_known:
	lea	patches_tb(pc),a0
.patch_loop_2:
	move.l	(a0)+,a1
	cmp	#-1,a1
	beq.s	.patch_defined
	move.l	(a0)+,a2
	move.l	(a2),(a1)
	bra.s	.patch_loop_2
;
.patch_defined:
	move	jsr_code(pc),d2
	move	jmp_code(pc),d3
	move	rts_code(pc),d4
;
	move.l	CivP_illegal_fix,a1
	move	d4,(a1)
;
	move.l	CivP_hut_scr_fix_1(pc),a0	;a0 -> new branch destination
	move.l	CivP_hut_scr_fix_2(pc),a1	;a1 -> branch opcode
	addq	#2,a1				;a1 -> branch offset
	sub.l	a1,a0				;a0 = new branch offset
	move	a0,(a1)				;store new branch offset
;-------
	lea	nu_hut_rnd_fix(pc),a0
	move.l	CivP_hut_rnd_fix(pc),a1
	move	d2,(a1)
	move.l	a0,2(a1)
;-------
	lea	nu_hut_adv_fix(pc),a0
	move.l	CivP_hut_adv_fix(pc),a1
	move	d2,(a1)
	move.l	a0,2(a1)
;
	lea	nu__rand(pc),a0
	move.l	CivP__rand(pc),a1
	move	d3,(a1)+
	move.l	a0,(a1)
;-------
	lea	nu_pollute_diff_fix(pc),a0
	move.l	CivP_pollute_diff_fix(pc),a1
	move.l	a0,2(a1)
;
	lea	nu_stratshow(pc),a0
	move.l	CivP_stratshow(pc),a1
	move.l	a0,2(a1)
;
	move.l	CivP_page_2_show(pc),a1		;in debug info page (F3)
	move.l	CivP__WaitForIt(pc),8(a1)	;change _getch to _WaitForIt
;
	lea	ol_slam_patch(pc),a0		;slam_patch will avoid the
	move.l	CivP_slam_patch(pc),a1		;bombing _KillKing calls 
	move.b	(a1),(a0)			;get original branch code
	lea	nu_slam_patch(pc),a0
	move.b	(a0),(a1)			;set absolute branch
	st	nu_slam_f
;
	lea	nu_rev_bug_patch(pc),a0
	move.l	CivP_rev_bug_patch(pc),a1
	move.l	a0,2(a1)
;
	lea	nu_lottery_fix_1(pc),a0
	move.l	CivP_lottery_fix_1(pc),a1
	move	d2,(a1)+
	move.l	a0,(a1)
;
	lea	nu_pre_drive_fix(pc),a0
	move.l	CivP_pre_drive_fix(pc),a1
	move.l	a0,2(a1)			;replace _DoMenu by nu_pre_drive_fix
;
	lea	nu_new_drive_fix(pc),a0
	move.l	CivP_new_drive_fix(pc),a1
	move	d2,(a1)+
	move.l	a0,(a1)
;
	lea	nu_old_drive_fix,a0
	move.l	CivP_old_drive_fix_1,a1
	move.l	a0,2(a1)
	move.l	CivP_old_drive_fix_2,a1
	move.l	a0,2(a1)
;
	lea	nu_new_fame_fix,a0
	move.l	CivP_new_fame_fix_1,a1
	move.l	a0,2(a1)
	move.l	CivP_new_fame_fix_2,a1
	move.l	a0,2(a1)
;
	lea	nu_old_fame_fix,a0
	move.l	CivP_old_fame_fix_1,a1
	move.l	a0,2(a1)
	move.l	CivP_old_fame_fix_2,a1
	move.l	a0,2(a1)
;
	lea	nu_new_replay_fix,a0
	move.l	CivP_new_replay_fix,a1
	move.l	a0,2(a1)
;
	lea	nu_old_fame_fix,a0
	move.l	CivP_old_replay_fix,a1
	move.l	a0,2(a1)
;
	lea	new_Diffs(pc),a0
	move.l	CivP__Diffs_ref_1(pc),a1
	move.l	a0,2(a1)
	move.l	CivP__Diffs_ref_2(pc),a1
	move.l	a0,2(a1)
	move.l	CivP__Diffs_ref_3(pc),a1
	move.l	a0,2(a1)
;
	lea	nu_famediff_fix(pc),a0
	move.l	CivP_famediff_fix_1(pc),a1
	move	d3,(a1)+
	move.l	a0,(a1)
;
	lea	nu_izdiff_menu_s(pc),a0
	move.l	CivP_izdiff_menu_fix(pc),a1
	move.l	a0,2(a1)
;
	lea	nu_DiffPic_fix(pc),a0
	move.l	CivP_DiffPic_fix_1(pc),a1
	move.l	a0,2(a1)
	move.l	CivP_DiffPic_fix_2(pc),a1
	move.l	a0,2(a1)
	move.l	CivP_DiffPic_fix_3(pc),a1
	move.l	a0,2(a1)
;
	lea	nu_citydiff_fix_1(pc),a0
	move.l	CivP_citydiff_fix_1(pc),a1
	move	d2,(a1)+
	move.l	a0,(a1)
;
	lea	nu_citydiff_fix_2(pc),a0
	move.l	CivP_citydiff_fix_2(pc),a1
	move	d2,(a1)+
	move.l	a0,(a1)
;
	lea	nu_text_fix_1(pc),a0
	move.l	CivP_text_fix_1(pc),a1
	move	d3,(a1)+
	move.l	a0,(a1)
;
	lea	nu_text_fix_2(pc),a0
	move.l	CivP_text_fix_2(pc),a1
	move	d3,(a1)+
	move.l	a0,(a1)
;
	lea	nu_attitude_fix_1(pc),a0
	move.l	CivP_attitude_fix_1(pc),a1
	move	d2,(a1)+
	move.l	a0,(a1)
;
	lea	nu_app_init_fix(pc),a0
	move.l	CivP_app_init_fix(pc),a1
	move	d2,(a1)+
	move.l	a0,(a1)
;
	lea	nu_app_exit_fix(pc),a0
	move.l	CivP_app_exit_fix_1(pc),a1
	move	d2,(a1)+
	move.l	a0,(a1)
	move.l	CivP_app_exit_fix_2(pc),a1
	move	d2,(a1)+
	move.l	a0,(a1)
;
	lea	nu_application_fix(pc),a0
	move.l	CivP_application_fix(pc),a1
	move	d2,(a1)+
	move.l	a0,(a1)
;
	move.l	CivP_save_abort_fix_1(pc),a1
	move.l	CivP_save_abort_fix_2(pc),d0
	sub.l	CivP_save_abort_fix_3(pc),d0
	add	d0,2(a1)
;
	cmp	#$0104,TOS_version
	blo.s	.no_restart_menu
	lea	nu_quit_menu_s(pc),a0
	move.l	CivP_quit_menu_fix_1(pc),a1
	move.l	a0,2(a1)
.no_restart_menu:
;
	lea	nu_quit_menu_fix_2(pc),a0
	move.l	CivP_quit_menu_fix_2(pc),a1
	move	d2,(a1)+
	move.l	a0,(a1)
;
	lea	nu__ShowSprite2_fix1(pc),a0
	move.l	CivP__ShowSprite2_fix1(pc),a1
	move	d3,(a1)+
	move.l	a0,(a1)
;
	lea	nu__ShowSprite2_fix2(pc),a0
	move.l	CivP__ShowSprite2_fix2(pc),a1
	move	d3,(a1)+
	move.l	a0,(a1)
;
	move.l	saved_v_bas_ad(pc),a0
	lea	32000-15(a0),a0
	move.l	CivP_mouse_shower_fix(pc),a1
	move.l	a0,2(a1)			;this patches an immediate ptr_value
;
.patches_done:
	tst	initpath_f
	bne.s	.paths_known
	gemdos	Dgetdrv
	move	d0,old_drive
	move	d0,new_drive
	gemdos	Dgetpath,old_path_s,!
	gemdos	Dsetpath,civ_save_s
	gemdos	Dgetpath,new_path_s,!
	gemdos	Dsetpath,old_path_s
	st	initpath_f
.paths_known:
	clr	new_drive_f
.variables_done:
	xbios	Kbdvbase
	move.l	d0,a1					; a1 = addr(kbdvbase)
	XB_install	nu_ikbd_vec(pc),32(a1)
	XB_install	nu_timer(pc),(etv_timer).w
	XB_install	nu_VBI(pc),(ev_VBI).w
;
	lea	null_s(pc),a0
	move.l	Civ_bp_p(pc),A1
	cmp	#$0104,TOS_version
	blo.s	.old_PEXEC
.new_PEXEC:
	gemdos	Pexec,#6,(a0),(a1),(a0)			;Run civilization
	bra.s	.civ_exited
;
.old_PEXEC:
	gemdos	Pexec,#4,(a0),(a1),(a0)			;Run civilization
.civ_exited:
;
	bsr	blank_pal
	bsr	blank_log
;
	xbios	Kbdvbase
	move.l	d0,a1					;a1 = addr(kbdvbase)
	XB_remove	nu_ikbd_vec(pc),32(a1)
	XB_remove	nu_timer(pc),(etv_timer).w
	XB_remove	nu_VBI(pc),(ev_VBI).w
;
	move.l	Civ_tp_p(pc),a0		;a0 -> program base address
	lea	CivPatch_tb(pc),a1
.unpatch_loop_1:
	move.l	(a1),d0
	cmp.l	#-1,d0
	beq.s	.un_patched
	sub.l	a0,d0
	move.l	d0,(a1)+
	bra.s	.unpatch_loop_1
;
.un_patched:
	cmp	#$0104,TOS_version
	blo.s	.no_restart
	tst	restart_f
	bne	restart_loop
.no_restart:
;
	bsr	GEM_own_fix
	sub_aes	#appl_init
	tst	d0
	bpl.s	.normal_exit
	gemdos	Cconws,odd_exit_s(pc)
	clr.l	d0
	bra.s	main_exit
;
.normal_exit:
	bsr	unbutton
	sub_aes	#appl_exit
	clr.l	d0
main_exit:
	xbios	Setpalette,saved_pal(pc)
	xbios	Vsync
	tst.l	d7
	bpl.s	exit_ok
	gemdos	Cconws,game_name_s(pc)
	gemdos	Cconws,errmess_s(pc)
	gemdos	Crawcin
exit_ok:
	gemdos	Pterm,d7				;Return to desktop
;
;============================================================================
;
ref_l	=	$C0DEC0DE
;
patch	macro	location,pointer
ptc\@	=	*+(\1)
	section	DATA
	dc.l	ptc\@,\2
	section	TEXT
	endm
;
;
	section	DATA
patches_tb:
	section	TEXT
;
;
scpy	macro	areg1,areg2
.scpy_\@:
	move.b	(\1)+,(\2)+
	bne.s	.scpy_\@
	endm
;----------------------------------------------------------------------------
nu_hut_adv_fix:
	cmp	d1,d0
	bge.s	.exit
	move.l	d0,-(sp)
	move.b	ref_l,d0
	patch	-4,kbshift_p
	and	#$E,d0
	cmp	#$E,d0
	beq.s	.pull_d0_exit
	move.l	(sp)+,d0
	addq	#4,sp			;pop unwanted return address
	jmp	ref_l
	patch	-4,CivP_hut_val_metal
;-------
.pull_d0_exit:
	move.l	(sp)+,d0
.exit:
	rts
;----------------------------------------------------------------------------
nu_hut_rnd_fix:
	move.b	ref_l,d0
	patch	-4,kbshift_p
	and	#$E,d0
	move	.hut_rnd_t(pc,d0),d0
	bmi.s	.goto_rnd
	and.l	#7,d0
	bne.s	.exit
	cmp	#4,-14(a6)
	bgt.s	.exit
	move	#5,-14(a6)	;patch city distance for 'advanced tribe'
.exit:
	rts
;-------
.hut_rnd_t:
	dc.w	-1,1,2,3,4,-1,-1,0
;-------
.goto_rnd:
	jmp	ref_l
	patch	-4,CivP__rnd
;----------------------------------------------------------------------------
randomize_fix:
	jsr	randomize
	move.l	d0,randseed
nu__rand:
	move.l	randseed,d0
	beq.s	randomize_fix
	jsr	rand_31_steps_112
	move.l	d0,randseed
	and.l	#$7FFF,d0
	rts
;-------
randseed:
	dc.l	0
;----------------------------------------------------------------------------
randomize:
	movem.l	d1-d3/a0-a2,-(sp)
	clr.l	d3
.loop:
	xbios	Supexec,get_hz_200
	eor.l	d0,d3
	gemdos	Tgettime
	swap	d0
	clr	d0
	eor.l	d0,d3
	beq.s	.loop
	bsr.s	rand_31_steps_112
	movem.l	(sp)+,d1-d3/a0-a2
	rts
;----------------------------------------------------------------------------
get_hz_200:
	move.l	(_hz_200).w,d0
	rts
;----------------------------------------------------------------------------
rand_31_steps_112:
	move.l	d0,d1
	lsr.l	#3,d1
	eor.l	d1,d0
	rol.l	#3,d0
	roxr.l	#4,d0
	rol.l	#4,d0
rand_31_steps_84:
	move.l	d0,d1
	lsr.l	#3,d1
	eor.l	d1,d0
	rol.l	#3,d0
	roxr.l	#4,d0
	rol.l	#4,d0
rand_31_steps_56:
	move.l	d0,d1
	lsr.l	#3,d1
	eor.l	d1,d0
	rol.l	#3,d0
	roxr.l	#4,d0
	rol.l	#4,d0
rand_31_steps_28:
	move.l	d0,d1
	lsr.l	#3,d1
	eor.l	d1,d0
	rol.l	#3,d0
	roxr.l	#4,d0
	rol.l	#4,d0
	rts
;----------------------------------------------------------------------------
nu_pollute_diff_fix:
	btst	#1,ref_l		;<Left_shift> pressed ?
	patch	-4,kbshift_p
	bne.s	.no_pollution		;if so, go ignore pollution
	tst	d1
	ble.s	.no_tolerance
	jmp	ref_l
	patch	-4,CivP__rnd
;
.no_tolerance:
	clr.l	d0
	rts
;
.no_pollution:
	addq	#6,sp		;pop return address and word argument
	jmp	ref_l
	patch	-4,CivP_pollute_done	;skip past pollution code
;----------------------------------------------------------------------------
nu_slam_patch:
	bra.s	nu_slam_patch		;only opcode used
ol_slam_patch:
	bra.s	nu_slam_patch		;only opcode changed
;----------------------------------------------------------------------------
nu_stratshow:
	jsr	ref_l
	patch	-4,CivP__StratMap
	jsr	ref_l
	patch	-4,CivP__WaitForIt
	rts
;----------------------------------------------------------------------------
nu_rev_bug_patch:
	link	a6,#0
	move	12(a6),d0
	bmi.s	.patch_it
	move	16(a6),d1
	bmi.s	.patch_it
	add	d1,d0		;d0 = pixel X directly to the right of block
	bvs.s	.patch_it
	cmp	#320,d0
	bls.s	.patched	;unsigned lower than or same as 320 is ok
.patch_it:
	move	16(a6),d1
	move	12(a6),d0
	bpl.s	.keep_X1_1
	add	d0,d1
	clr	d0
.keep_X1_1:
	cmp	#320,d0
	blo.s	.keep_X1_2
	moveq	#1,d1
	move	#319,d0
.keep_X1_2:
	tst	d1
	bpl.s	.keep_W_1
	moveq	#1,d1
.keep_W_1:
	move	d0,d2
	add	d1,d2
	cmp	#320,d2
	bls.s	.store_patch
	move	#320,d1
	sub	d0,d1
.store_patch:
	move	d0,12(a6)	;store safeguarded X1
	move	d1,16(a6)	;store safeguarded W
.patched:
	unlk	a6
	jmp	ref_l
	patch	-4,CivP__ChangeColor
;----------------------------------------------------------------------------
nu_lottery_fix_1:
	cmp	d0,d4
	beq.s	.skip_it
	cmp	#unlottery_LEVEL,ref_l
	patch	-4,CivP__Diff
	bhs.s	.skip_it
	cmp	#max_lotteries,d6
	bhs.s	.skip_it
	btst	#3,ref_l		;<Alternate> pressed ?
	patch	-4,kbshift_p
	bne.s	.skip_it		;if so, go skip past lottery code
	rts
;
.skip_it:
	addq	#4,sp			;pop unwanted return address
	jmp	ref_l
	patch	-4,CivP_lottery_fix_2
;----------------------------------------------------------------------------
nu_pre_drive_fix:
	move	#1,ref_l
	patch	-4,CivP__NoWait
	jmp	ref_l
	patch	-4,CivP__DoMenu
;----------------------------------------------------------------------------
nu_new_drive_fix:		;entry d0.l -> drive letter
	movem.l	d0-d6/a0-a6,-(sp)
	st	new_drive_f
	bsr	nu_fsel_patch
	move.l	d0,d7
	move	new_drive(pc),d0
	add	#'A',d0
	move.l	(sp),a0
	move.b	d0,(a0)
	movem.l	(sp)+,d0-d6/a0-a6
	MOVEA.L	D0,A5		;\ Replace the patched code
	MOVEQ	#7,D0		;/ except for the bug "EXT.L D0"
	rts
;
;returns d0 -> drivestring  d7 = drivecode or -1 to break
;----------------------------------------------------------------------------
GEM_civ_fix:
	lea	ref_l,a0
	patch	-4,CivP___AESpb
	move.l	4(a0),aes_pb+4
	move	ref_l,d0
	patch	-4,CivP__handle
	move	d0,g_handle
	rts
;----------------------------------------------------------------------------
GEM_own_fix:
	lea	global(pc),a0
	move.l	a0,aes_pb+4
	rts
;----------------------------------------------------------------------------
unbutton:
	movem.l	d0-d4/a0-a4,-(sp)
	move	#3,intin
	sub_aes	#wind_update
	xbios	Vsync
;
	xbios	Kbdvbase
	move.l	d0,a0
	move.l	16(a0),a4
;
.unkey_loop:
	gemdos	Cconis
	tst.l	d0
	beq.s	.no_keys
	gemdos	Crawcin
	bra.s	.unkey_loop
;
.no_keys:
.release_buttons:
	move	#MU_BUTTON|MU_TIMER,intin
	move	#1,intin+2
	move	#3,intin+4
	move	#0,intin+6
	move	#10,intin+28
	move	#10>>16,intin+30
	sub_aes	#evnt_multi
	move	intout+6,d4
	and	#3,d4
	bne.s	.release_buttons
;
.unbutt_exit:
	xbios	Vsync
	move	#2,intin
	sub_aes	#wind_update
	movem.l	(sp)+,d0-d4/a0-a4
	rts
;----------------------------------------------------------------------------
pack_sim:
	xbios	Vsync
	gemdos	Super|_ind,#1
	tst.l	d0
	bne.s	.super_mode
	gemdos	Super,!
.super_mode:
	move.l	d0,-(sp)
	movem.l	d3-d7/a3-a6,-(sp)
	move.l	a3,a0
	jsr	(a4)
	movem.l	(sp)+,d3-d7/a3-a6
	gemdos	Super,()
	xbios	Vsync
	rts
;----------------------------------------------------------------------------
nu_fsel_patch:
	movem.l	d1-d7/a0-a2,-(sp)
	bsr	GEM_civ_fix
;
;;;	bsr	unbutton
;
; reinstall GEM's mouse mover
	move.l	ref_l,d0
	patch	-4,CivP__oldmove
	move.l	d0,contrl+14
	sub_vdi	#vex_motv,g_handle
	move.l	contrl+18(pc),game_motv
;
	bsr	unbutton
;
; show GEM mouse
	move	#$101,intin
	clr.l	addrin
	sub_aes	#graf_mouse
	move	#$101,intin
	clr.l	addrin
	sub_aes	#graf_mouse
;
	moveq	#-1,d7			;start with 'break' code in d7
	moveq	#3-1,d6
	move	new_drive(pc),d0
	lea	new_path_s(pc),a0
.retry_d0_a0:
	move	d0,new_drive
	lea	new_path_s(pc),a1
	scpy	a0,a1
	gemdos	Dsetdrv,new_drive(pc)
	gemdos	Dsetpath,new_path_s(pc)
	tst.l	d0
	bmi.s	.got_error
	lea	new_path_s(pc),a0
	lea	fsel_drive_path_s(pc),a1
	move	new_drive(pc),d0
	add	#'A',d0
	move.b	d0,(a1)+
	move.b	#':',(a1)+
	scpy	a0,a1
	lea	slash_stars_s(pc),a0
	subq	#1,a1
	cmp.b	#'\',-1(a1)
	bne.s	.need_slash
	subq	#1,a1
.need_slash:
	scpy	a0,a1
	clr.b	fsel_filename_s
	lea	addrin(pc),a1
	move.l	#fsel_drive_path_s,(a1)+
	move.l	#fsel_filename_s,(a1)+
	move.l	#fsel_prompt_s,(a1)+
;
	addq	#1,keep_pal_f			;block palette refresher
	xbios	Setpalette,saved_pal(pc)	;restore GEM palette
	xbios	Vsync
;
	bsr	try_fsel_exinput
;
	move.l	d0,-(sp)
	subq	#1,keep_pal_f			;unblock palette refresher
	xbios	Vsync
	move.l	(sp)+,d0
;
	tst	d0
	bne.s	.not_error
.got_error:
	swap	d0
	tst	d0
	beq	.exit
	gemdos	Dgetdrv
	lea	slash_s(pc),a0
	dbra	d6,.retry_d0_a0
	bra.s	.exit
;
.not_error:
	swap	d0
	tst	d0
	beq.s	.exit
	lea	fsel_drive_path_s(pc),a0
	clr	d0
	move.b	(a0)+,d0
	beq.s	.got_error
	cmp.b	#':',(a0)+
	bne.s	.got_error
	sub	#'A',d0
	blt.s	.got_error
	move	d0,new_drive
	lea	new_path_s(pc),a1
	scpy	a0,a1
.seek_end:
	cmp.b	#'\',-(a1)
	bne.s	.seek_end
	clr.b	(a1)
	gemdos	Dsetdrv,new_drive(pc)
	gemdos	Dsetpath,new_path_s(pc)
	tst.l	d0
	bmi.s	.got_error
	gemdos	Fopen,fame_dta_s,!
	tst.l	d0
	bmi	.got_error
	gemdos	Fclose,d0
	move	new_drive(pc),d7
	ext.l	d7
.exit:
;
; hide GEM mouse
	move	#$100,intin
	clr.l	addrin
	sub_aes	#graf_mouse
	move	#$100,intin
	clr.l	addrin
	sub_aes	#graf_mouse
;
	bsr	unbutton
;
; reinstall Civilization mouse mover
	move.l	game_motv(pc),contrl+14
	sub_vdi	#vex_motv,g_handle
;
;;;	bsr	unbutton
;
	move.l	d7,d0
	movem.l	(sp)+,d1-d7/a0-a2
	rts
;----------------------------------------------------------------------------
try_fsel_exinput:
	move.l	#'FSEL',d0
	bsr.s	seek_cookie_d0
	bpl.s	use_new_selector
	cmp	#$0104,TOS_version
	blt.s	use_old_selector
use_new_selector:
	sub_aes	#fsel_exinput
	rts
;
use_old_selector:
	sub_aes	#fsel_input
	rts
;----------------------------------------------------------------------------
seek_cookie_d0:
	movem.l	d1-d7/a0-a6,-(sp)
	move.l	d0,d3
	gemdos	Super|_ind,#1
	tst.l	d0
	bne.s	.super_mode
	gemdos	Super,!
.super_mode:
	move.l	d0,d7
	moveq	#-34,d0		;prep 'path not found' error
	move.l	(_cookies).w,d1
	beq.s	super_return
	move.l	d1,a0
	moveq	#-33,d0		;prep 'file not found' error
.seek_cookie_loop:
	tst.l	(a0)
	beq.s	super_return
	cmp.l	(a0),d3
	beq.s	.seek_cookie_found
	addq.l	#8,a0
	bra.s	.seek_cookie_loop
;
.seek_cookie_found:
	move.l	a0,d0
super_return:
	exg	d0,d7
	gemdos	Super|_ind,d0
	move.l	d7,d0
	movem.l	(sp)+,d1-d7/a0-a6
	rts
;----------------------------------------------------------------------------
nu_old_drive_fix:
	movem.l	d0-d7/a0-a6,-(sp)
	clr	new_drive_f
	gemdos	Dsetdrv,old_drive(pc)
	gemdos	Dsetpath,old_path_s(pc)
	movem.l	(sp)+,d0-d7/a0-a6
	pea	null_s
	jsr	ref_l		;Replace the patched 'jsr _ChangeDir'
	patch	-4,CivP__ChangeDir
	addq	#4,sp
	rts
;----------------------------------------------------------------------------
nu_new_fame_fix:
nu_new_replay_fix:
	movem.l	d0-d7/a0-a6,-(sp)
	st	new_drive_f
	gemdos	Dsetdrv,new_drive(pc)
	gemdos	Dsetpath,new_path_s(pc)
	movem.l	(sp)+,d0-d7/a0-a6
	jmp	ref_l
	patch	-4,CivP__open
;----------------------------------------------------------------------------
nu_old_fame_fix:
nu_old_replay_fix:
	move	4(sp),d0
	move	d0,-(sp)
jsr_code:
	jsr	ref_l
	patch	-4,CivP__close
	addq	#2,sp
	movem.l	d0-d7/a0-a6,-(sp)
	clr	new_drive_f
	gemdos	Dsetdrv,old_drive(pc)
	gemdos	Dsetpath,old_path_s(pc)
	movem.l	(sp)+,d0-d7/a0-a6
rts_code:
	rts
;----------------------------------------------------------------------------
nu_famediff_fix:
	cmp	#8,d0
	bhs.s	.skip_it
	asl	#2,d0
	lea	diff_lev_s_t(pc),a0
	move.l	(a0,d0),a0
	lea	ref_l,a1
	patch	-4,CivP__XEB
.getend_loop:
	tst.b	(a1)+
	bne.s	.getend_loop
	subq	#1,a1
	scpy	a0,a1
.skip_it:
jmp_code:
	jmp	ref_l
	patch	-4,CivP_famediff_fix_2
;----------------------------------------------------------------------------
nu_DiffPic_fix:
	cmp	#5,ref_l
	patch	-4,CivP__Diff
	bhs.s	.skip_it
	jmp	ref_l
	patch	-4,CivP__RectCopy
;
.skip_it:
	rts
;----------------------------------------------------------------------------
nu_citydiff_fix_1:
	tst	-124(a6)
	bne.s	.ok
	move	#1,-124(a6)
.ok:
	tst	d6
	beq.s	.exit
	move.l	#ref_l,(sp)
	patch	-4,CivP_citydiff_fix_1x
.exit:
	move.l	d7,d0
	rts
;----------------------------------------------------------------------------
nu_citydiff_fix_2:
	sub	d3,d4
	move	d4,-92(a6)
	bne.s	.ok
	moveq	#2,d4
.ok:
	rts
;----------------------------------------------------------------------------
nu_text_fix_1:
	cmp.l	lim_adr,a0
	bhs.s	nu_text_error_1
	and.l	#-2,d0
	jmp	ref_l
	patch	-4,CivP_text_fix_1_ret
;
nu_text_error_1:
	illegal
	jmp	ref_l
	patch	-4,CivP_text_fix_exit
;----------------------------------------------------------------------------
nu_text_fix_2:
	cmp.l	lim_adr,a0
	bhs.s	nu_text_error_2
	move.l	d7,-(sp)
	moveq	#0,d0
	move.b	(a1),d0
	jmp	ref_l
	patch	-4,CivP_text_fix_2_ret
;
nu_text_error_2:
	illegal
	jmp	ref_l
	patch	-4,CivP_text_fix_exit
;----------------------------------------------------------------------------
nu_attitude_fix_1:
	cmp	#190,d5
	bls.s	.not_full
	jsr	ref_l
	patch	-4,CivP__WaitForIt
	moveq	#9,d0
	move	d0,-(sp)
	pea	ref_l
	patch	-4,CivP_atti_survey_2_s
	jsr	ref_l
	patch	-4,CivP__ContinueReport
	addq	#6,sp
	moveq	#32,d5
.not_full:
	move.l	(sp)+,d0
	pea	ref_l
	patch	-4,CivP_atti_population_s
	move.l	d0,-(sp)
	rts
;----------------------------------------------------------------------------
nu_quit_menu_fix_2:
	cmp	#2,d0
	seq	restart_f
	beq.s	.got_quit
	cmp	#1,d0
	bne.s	.not_quit
.got_quit:
	st	quit_cmd_f
	bsr	blank_civ
	add.l	#10,(sp)
.not_quit:
	rts
;----------------------------------------------------------------------------
nu_app_init_fix:
	jsr	ref_l
	patch	-4,CivP_@_AESif
	movem.l	d0-d7/a0-a6,-(sp)
	bsr	GEM_civ_fix
	move	#3,intin
	sub_aes	#wind_update
	tst	entry_rez
	bne.s	.keep_pal
	bsr.s	blank_pal
.keep_pal:
	move	#$100,intin
	clr.l	addrin
	sub_aes	#graf_mouse
	tst	entry_rez
	bne.s	.keep_screen
	bsr	blank_log
.keep_screen:
	movem.l	(sp)+,d0-d7/a0-a6
	rts
;----------------------------------------------------------------------------
nu_app_exit_fix:
	movem.l	d0-d7/a0-a6,-(sp)
	bsr	GEM_civ_fix
	tst	quit_cmd_f
	beq.s	.no_blanks
	bsr	blank_civ
.no_blanks:
	move	#$101,intin
	clr.l	addrin
	sub_aes	#graf_mouse
	move	#2,intin
	sub_aes	#wind_update
	movem.l	(sp)+,d0-d7/a0-a6
	jsr	ref_l
	patch	-4,CivP_@_AESif
	rts
;----------------------------------------------------------------------------
blank_pal:
	movem.l	d0-d2/a0-a2,-(sp)
	gemdos	Super|_ind,#1
	tst.l	d0
	bne.s	.super_mode
	gemdos	Super,!
.super_mode:
	move.l	d0,-(sp)
;
	lea	(hw_pal).w,a1
	rept	8
	clr.l	(a1)+
	endr
;
	gemdos	Super,()
	movem.l	(sp)+,d0-d2/a0-a2
	rts
;----------------------------------------------------------------------------
blank_log:
	movem.l	d0-d4/a0-a4,-(sp)
	xbios	Logbase
	move.l	d0,a4
	add	#32000,a4
	clr.l	d0
	clr.l	d1
	clr.l	d2
	clr.l	d3
	move.l	d0,a0
	move.l	d0,a1
	move.l	d0,a2
	move.l	d0,a3
;
	move	#200-1,d4
.blank_loop:
	movem.l	d0-d3/a0-a3,-(a4)
	movem.l	d0-d3/a0-a3,-(a4)
	movem.l	d0-d3/a0-a3,-(a4)
	movem.l	d0-d3/a0-a3,-(a4)
	movem.l	d0-d3/a0-a3,-(a4)
	dbra	d4,.blank_loop
	movem.l	(sp)+,d0-d4/a0-a4
	rts
;----------------------------------------------------------------------------
blank_civ:
	bsr	blank_pal
	move.l	a0,-(sp)
	lea	ref_l,a0
	patch	-4,CivP__gem_pal
	rept	8
	clr.l	(a0)+
	endr
	move.l	(sp)+,a0
	bsr.s	blank_log
	rts
;----------------------------------------------------------------------------
nu_application_fix:
	jsr	ref_l
	patch	-4,CivP_app_init_sub
	tst.l	d0
	beq.s	.ok
	move.l	#$4CFFFF,-(sp)
	trap	#1		;gemdos	Pterm,#-1
;
.ok:
	rts
;----------------------------------------------------------------------------
nu__ShowSprite2_fix1:
	pea	(a0)
	tst.l	(sp)+
	ble.s	.skip_sprite
	move	d0,ref_l
	patch	-4,CivP_sprite_planes
	lea	32000-15(a1),a4
	jmp	ref_l
	patch	-4,CivP__ShowSprite2_fix1_ret
;
.skip_sprite:
	jmp	ref_l
	patch	-4,CivP__ShowSprite2_exit
;----------------------------------------------------------------------------
nu__ShowSprite2_fix2:
	move	ref_l,d2
	patch	-4,CivP_sprite_planes
	cmpa.l	a4,a3			;nb: sprite drawing bombs unless a3 < a4
	blo.s	.ok_do_it
	jmp	ref_l
	patch	-4,CivP__ShowSprite2_exit
;
.ok_do_it:
	jmp	ref_l
	patch	-4,CivP__ShowSprite2_fix2_ret
;============================================================================
	XB_define	nu_VBI,'CivF'
	push_ex		post_VBI
	XB_gonext_d	nu_VBI
;
post_VBI:
	tst	keep_pal_f
	bne.s	.exit_direct
	movem.l	a0/a1,-(sp)
	ori	#$0700,SR
	lea	(hw_pal).w,a0
	lea	pal_save_t(pc),a1
	tst.b	1(a0)
	bne.s	.restore_pal
.save_pal:
	rept	8
	move.l	(a0)+,(a1)+
	endr
	movem.l	(sp)+,a0/a1
	rte
;
.restore_pal:
	btst	#5,(sp)
	bne.s	.exit
	rept	8
	move.l	(a1)+,(a0)+
	endr
.exit:
	movem.l	(sp)+,a0/a1
.exit_direct:
	rte
;============================================================================
	XB_define	nu_ikbd_vec,'CivF'
	XB_donext_d	nu_ikbd_vec(pc)
	bra.s		CivF_key_code
;----------------------------------------------------------------------------
	XB_define	nu_timer,'CivF'
	move		4(sp),-(sp)	;copy argument
	XB_donext_d	nu_timer(pc)
	addq.l	#2,sp
CivF_key_code:
	move	SR,-(sp)
	move.l	kb_iorec_p(pc),a0
	move	io_tail_ix(a0),d1	;tail index
	cmp	old_tail_ix(pc),d1	;test if changed
	beq	.return
	or	#$0700,SR
	move	io_tail_ix(a0),d1	;tail index
	move	d1,old_tail_ix		;save tail index at old_tail_ix
	cmp	io_head_ix(a0),d1
	beq	.return			;exit if same index as head and tail
	move.l	kbshift_p(pc),a1
	move.b	(a1),d2			;New! get kbshifts (** TOS independent **)
	and	#$0F,d2			;keep Alt,Control,LShift,RShift
	btst	#3,d2
	beq.s	.return			;not command without Alt
	move.l	io_buffer_p(a0),a2	;get address of io-buffer
	move	(a2,d1),d0		;get 1'st word for this key = key code
	and	#$7F,d0			;mask key code
.try_comd:	;This routine handles <ALT> keys, possible commands
	move.l	keytbl_ptp,a2
	move.l	8(a2),a2		;a2 -> current capslock keytable
	move.b	(a2,d0),d0		;get ascii code
	cmp	#'D',d0			;D debug toggle ?
	beq.s	.flip_debug
	cmp	#'Z',d0			;Z debug toggle ?
	beq.s	.flip_debug
	cmp	#'K',d0			;K _KillKing toggle ?
	beq.s	.flip_kill
	bra.s	.return
;
.flip_debug:				;Alt-D or Alt-Z
	cmp	#8,d2			;demand Alt only
	bne.s	.return
	move.l	CivP__debug(pc),a1
	not	(a1)		;invert debug flag
	clr	d0
	bra.s	.put_comd
;
.flip_kill:
	cmp	#8,d2			;demand Alt only
	bne.s	.return
	tst.b	nu_slam_f
	beq.s	.set_nu_slam
.set_ol_slam:
	move.b	ol_slam_patch(pc),d0
	bra.s	.set_slam
;
.set_nu_slam:
	move.b	nu_slam_patch(pc),d0
.set_slam:
	move.l	CivP_slam_patch(pc),a1
	move.b	d0,(a1)			;set the branch code
	not.b	nu_slam_f
.put_comd:
	move.l	kb_iorec_p(pc),a0
	move	d0,kbd_comd
	subq	#4,d1
	bge.s	.tail_shrunk
	move	io_size_ix(a0),d1
	subq	#4,d1
.tail_shrunk:
	move	d1,io_tail_ix(a0)
	move	d1,old_tail_ix
.return:
	move	(sp)+,SR
	rts
;
;
	make	GEM_links
;----------------------------------------------------------------------------
	SECTION	DATA
;----------------------------------------------------------------------------
patches_end:
	dc.l	-1	;marks end of table
;
white:
	dc.w	$0777
black:
	dc.w	$0000
null_s:
	dc.l	0
;
slash_s:
	dc.b	'\',NUL
	even
slash_stars_s:
	dc.b	'\*.*',NUL
civ_save_s:
	dc.b	'CIV_SAVE\',NUL
	even
game_name_s:
	dc.b	'GAME.PRG',NUL
	even
fame_dta_s:
	dc.b	'FAME.DTA',NUL
	even
fsel_prompt_s:
	dc.b	'Choose path (files ignored)',0
	even
;
chief_s:
	dc.b	'Chief',NUL
	even
lord_s:
	dc.b	'Lord',NUL
	even
prince_s:
	dc.b	'Prince',NUL
	even
king_s:
	dc.b	'King',NUL
	even
emperor_s:
	dc.b	'Emperor',NUL
	even
oryoshi_s:
	dc.b	'Oryoshi',NUL
	even
shogun_s:
	dc.b	'Shogun',NUL
	even
mikado_s:
	dc.b	'Mikado',NUL
	even
;
new_Diffs:
	dc.l	chief_s
	dc.l	lord_s
	dc.l	prince_s
	dc.l	king_s
	dc.l	emperor_s
	dc.l	oryoshi_s
	dc.l	shogun_s
	dc.l	mikado_s
;
chief_lev_s:
	dc.b	' (Chieftan)',NUL
	even
lord_lev_s:
	dc.b	' (Warlord)',NUL
	even
prince_lev_s:
	dc.b	' (Prince)',NUL
	even
king_lev_s:
	dc.b	' (King)',NUL
	even
emperor_lev_s:
	dc.b	' (Emperor)',NUL
	even
oryoshi_lev_s:
	dc.b	' (Oryoshi)',NUL
	even
shogun_lev_s:
	dc.b	' (Shogun)',NUL
	even
mikado_lev_s:
	dc.b	' (Mikado)',NUL
	even
;
diff_lev_s_t:
	dc.l	chief_lev_s
	dc.l	lord_lev_s
	dc.l	prince_lev_s
	dc.l	king_lev_s
	dc.l	emperor_lev_s
	dc.l	oryoshi_lev_s
	dc.l	shogun_lev_s
	dc.l	mikado_lev_s
	even
;
nu_izdiff_menu_s:
L1CA1:
	dc.b	'Difficulty Level...',$0A
	dc.b	' Chieftain (easiest)',$0A
	dc.b	' Warlord',$0A
	dc.b	' Prince',$0A
	dc.b	' King',$0A
	dc.b	' Emperor',$0A
	dc.b	' Oryoshi',$0A
	dc.b	' Shogun',$0A
	dc.b	' Mikado (toughest)',$0A,$00,$00
	even
;
;
nu_quit_menu_s:
	dc.b	'Are you sure you',$0A
	dc.b	'want to Quit ?',$0A
	dc.b	' No,  Play Game',$0A
	dc.b	' Yes, Quit Game',$0A
	dc.b	' Start New Game',$0A
	dc.b	$00,$00
	even
;
;
butt_set_s:
	dc.b	$FA,$00,$00
	even
;
butt_clr_s:
	dc.b	$F8,$00,$00
	even
;
butt_fix_s:
	dc.b	$F8,$00,$00
	even
;
;
errmess_s:
	dc.b	CR,LF
	dc.b	'failed to load properly.',CR,LF
	dc.b	'Press a key to exit.',CR,LF
	dc.b	CR,LF,NUL
	even
;
odd_exit_s:
	dc.b	CR,LF
	dc.b	'Failed to debounce mouse on exit.'
	dc.b	CR,LF,NUL
	even
;
;----------------------------------------------------------------------------
;
CivPatch_tb:
Civ_bp_p:		dc.l	-$100
Civ_tp_p:		dc.l	0
CivP_application_fix:	dc.l	$00274
CivP_illegal_fix:	dc.l	$0033E
CivP__DoMenu:		dc.l	$00340
CivP__Events:		dc.l	$020DC
CivP_lottery_fix_1:	dc.l	$0232C
CivP_lottery_fix_2:	dc.l	$02638
CivP_page_2_show:	dc.l	$07A50
CivP_quit_menu_fix_1:	dc.l	$080BC
CivP_quit_menu_fix_2:	dc.l	$080E6
CivP_hut_rnd_fix:	dc.l	$0C122
CivP_hut_adv_fix:	dc.l	$0C1C4
CivP_hut_scr_fix_1:	dc.l	$0C31E
CivP_hut_scr_fix_2:	dc.l	$0C3D8
CivP_hut_val_metal:	dc.l	$0C3E0
CivP_citydiff_fix_1:	dc.l	$10DE4
CivP_citydiff_fix_1x:	dc.l	$10E1A
CivP_citydiff_fix_2:	dc.l	$14136
CivP_rev_bug_patch:	dc.l	$16106
CivP_pollute_diff_fix:	dc.l	$187AA
CivP_pollute_done:	dc.l	$188C4
CivP__WaitForIt:	dc.l	$19AB6
CivP__rnd:		dc.l	$29054
CivP__rand:		dc.l	$29074
CivP_new_fame_fix_1:	dc.l	$2D11E
CivP_old_fame_fix_1:	dc.l	$2D152
CivP_new_fame_fix_2:	dc.l	$2D174
CivP_old_fame_fix_2:	dc.l	$2D1A8
CivP__Diffs_ref_1:	dc.l	$2D370
CivP_famediff_fix_1:	dc.l	$2D544
CivP_famediff_fix_2:	dc.l	$2D5CC
CivP_izdiff_menu_fix:	dc.l	$2E79A
CivP_DiffPic_fix_1:	dc.l	$2E886
CivP_DiffPic_fix_2:	dc.l	$2E9C8
CivP_DiffPic_fix_3:	dc.l	$2F1C6
CivP_new_replay_fix:	dc.l	$38B42
CivP_slam_patch:	dc.l	$39542
CivP_old_replay_fix:	dc.l	$39602
CivP_stratshow:		dc.l	$3A140
CivP__StratMap:		dc.l	$3A154
CivP_load_drive_q:	dc.l	$3AA92
CivP_old_drive_fix_1:	dc.l	$3AB90
CivP__Diffs_ref_2:	dc.l	$3AC94
CivP_save_drive_q:	dc.l	$3AE8E
CivP_save_abort_fix_1:	dc.l	$3AE9A
CivP_save_abort_fix_2:	dc.l	$3B02A
CivP_old_drive_fix_2:	dc.l	$3B030
CivP_save_abort_fix_3:	dc.l	$3B038
CivP__Diffs_ref_3:	dc.l	$3B0A4
CivP__SaveDrive:	dc.l	$3B216
CivP_pre_drive_fix:	dc.l	$3B35E
CivP_new_drive_fix:	dc.l	$3B388
CivP__ContinueReport:	dc.l	$3EFFA
CivP_attitude_fix_1:	dc.l	$40D60
CivP_app_init_sub:	dc.l	$4CC36
CivP_app_init_fix:	dc.l	$4CC3C
CivP_app_exit_fix_1:	dc.l	$4CC62
CivP__ShowPage:		dc.l	$4D200
CivP__RectCopy:		dc.l	$4D5F2
CivP__GoodBye:		dc.l	$4DD78
CivP_app_exit_fix_2:	dc.l	$4DDE8
CivP__ChangeDir:	dc.l	$4DE90
CivP_mouse_background:	dc.l	$4E66C
CivP_sprite_planes:	dc.l	$4E81E
CivP_text_fix_exit:	dc.l	$56C76
CivP_text_fix_1:	dc.l	$56CA8
CivP_text_fix_1_ret:	dc.l	$56CAE
CivP_text_fix_2:	dc.l	$56E2E
CivP_text_fix_2_ret:	dc.l	$56E34
CivP_mouse_shower_fix:	dc.l	$57358
CivP__ChangeColor:	dc.l	$5737E
CivP__ShowSprite2:	dc.l	$5790A
CivP__ShowSprite2_fix1:	dc.l	$57962
CivP__ShowSprite2_fix1_ret:
			dc.l	$57968
CivP__ShowSprite2_fix2:	dc.l	$579B8
CivP__ShowSprite2_fix2_ret:
			dc.l	$579BE
CivP__ShowSprite2_exit:	dc.l	$57A6C
CivP__main:		dc.l	$58C5C
CivP__showmouse:	dc.l	$58EB0
CivP__hidemouse:	dc.l	$58ED0
CivP_@_AESif:		dc.l	$5C480
CivP__close:		dc.l	$5CC5C
CivP__exit:		dc.l	$5D3F4
CivP___exit:		dc.l	$5E242
CivP__open:		dc.l	$5F7E0
CivP_atti_survey_2_s:	dc.l	$631EA
CivP_atti_population_s:	dc.l	$631FC
CivP__gem_pal:		dc.l	$642DA
CivP___AESpb:		dc.l	$66BDC
CivP___VDIpb:		dc.l	$66BF4
CivP__NoWait:		dc.l	$676B4
CivP__myseed:		dc.l	$67720
CivP__handle:		dc.l	$6D7A8
CivP__XEB		dc.l	$6D81E
CivP__oldmove:		dc.l	$6E7D8
CivP__debug:		dc.l	$738E0
CivP__Diff:		dc.l	$738EE
			dc.l	-1	;marks end of table
;
;
;----------------------------------------------------------------------------
;
	SECTION	BSS
;
TOS_version:		ds.w	1
entry_rez:		ds.w	1
longframe_f:		ds.w	1
;
colorptr_save:		ds.l	1
pal_save_t:		ds.w	16	;Civ-palette used to refresh hardware
keep_pal_f:		ds.w	1	;non-zero to block palette refreshing
;
keytbl_ptp:		ds.l	1
kbshift_p:		ds.l	1
kb_iorec_p:		ds.l	1
kbd_comd:		ds.w	1
old_tail_ix:		ds.w	1
;
saved_pal:		ds.w	16	;original GEM palette
;
saved_v_bas_ad:		ds.l	1
;
initpath_f:		ds.w	1
restart_f:		ds.w	1
quit_cmd_f:		ds.w	1
nu_slam_f:		ds.w	1
;
old_drive:		ds.w	1
new_drive:		ds.w	1
old_path_s:		ds.b	128
new_path_s:		ds.b	128
new_drive_f		ds.w	1
;
lim_adr:		ds.l	1	;copy of 'phystop' to test screen ads
;
civ_mb_state:		ds.w	1
game_motv:		ds.l	1
g_handle:		ds.w	1
contrl:			ds.w	12
;
message:		ds.b	16	;Message pipe.
intin:			ds.w	30
ptsin:			ds.w	30
ptsout:			ds.w	12
intout:			ds.w	45
;
fsel_drive_path_s:	ds.b	130
fsel_filename_s:	ds.b	16
;
stack_loc:		ds.b	$800
stack_top:
;
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	RUN_CIV.S
;----------------------------------------------------------------------------
