;----------------------------------------------------------------------------
;File name:	CSB_2_LD.S			Revision date:	2000.02.02
;Revised by:	Ronald Andersson		Revision start:	2000.01.06
;----------------------------------------------------------------------------
;Purpose:	Loader for Chaos Strikes Back utility program
;----------------------------------------------------------------------------
	include	RA_TOS.I
	include	RA_JAR.I
;----------------------------------------------------------------------------
SWOOSH_TIME	=	1000	;milliseconds for 'swoosh' effects
;----------------------------------------------------------------------------
	TEXT
;----------------------------------------------------------------------------
start_1:
	jmp	(start_2).l
	illegal
;----------------------------------------------------------------------------
BP	=	start_1-$100
;----------------------------------------------------------------------------
start_2:
	movea.l	a7,a5
	movea.l	$0004(a5),a5			; a5 -> own basepage in TPA
	lea	loc_stk_top(pc),sp
	lea	program_end,a1
	sub.l	a5,a1
	gemdos	Mshrink,!,(a5),a1
;-------------------------------------
	xbios	Getrez
	tst	d0				;ST_L ?
	beq.s	.have_rez			;no change needed for ST_L
.test_TT_H:
	cmp	#6,d0				;TT_H ?
	bne.s	.test_ST_H			;else check other possibilities
;-------
	eval_cookie	#'_MCH'
;-------
	swap	d0
	tst	d0
	bmi.s	.bad_rez			;TT_H change impossible on unknown systems
	cmp	#3,d0
	beq.s	.set_rez			;TT_H change possible on F030
	bra.s	.bad_rez
;-------
.test_ST_H:
	cmp	#2,d0				;ST_H ?
	bne.s	.set_rez			;change possible if not ST_H
;-------
	eval_cookie	#'_MCH'
;-------
	swap	d0
	tst	d0
	bmi.s	.bad_rez			;ST_H change impossible on unknown systems
	cmp	#2,d0
	bgt.s	.set_rez			;ST_H change possible if not ST/STe
.bad_rez:				;here rez change to ST_L is impossible
	gemdos	Cconws,weird_rez_s(pc)
	gemdos	Crawcin
	gemdos	Pterm,?
;-------
.set_rez:
	xbios	Logbase
	move.l	d0,a3
	xbios	Physbase
	move.l	d0,d3
	xbios.i	Setscreen,a3,d3,!
.have_rez:
;-------------------------------------
	suba.l	a4,a4
	lea	inf_buffer(pc),a3
	gemdos	Fopen,program_INF_s(pc),!
	move	d0,d3				;d3 = handle or err_code
	bgt.s	.have_inf_file
	gemdos	Fopen,auto_program_INF_s(pc),!
	move	d0,d3				;d3 = handle or err_code
	ble	.done_inf_file
	lea	inf_path_buff(pc),a4		;a4 -> inf_path_buff
.have_inf_file:
	gemdos	Fread,d3,#128,(a3)
	exg	d0,d3
	gemdos	Fclose,d0
	tst	d3
	ble	.done_inf_file
.skip_space_loop:
	move.b	(a3)+,d0
	beq	.done_inf_file
	cmp.b	#' ',d0
	beq.s	.skip_space_loop
	cmp.b	#HT,d0
	beq.s	.skip_space_loop
	subq	#1,a3			;a3 -> first non-blank INF char
;-------
	move.l	a4,d0			;test path setting needs
	ble.s	.have_base_path
	gemdos	Dgetdrv
	move	d0,drive_code
	add.b	#'a',d0
	move.b	d0,drive_char
	gemdos	Dgetpath,(a4),!
	cmp.b	#'\',(a4)
	beq.s	.pad_drive
	tst.b	(a4)
	beq.s	.pad_drive_and_slash
	cmp.b	#':',1(a4)
	beq.s	.pad_done
.pad_drive_and_slash:
	move.b	#'\',-(a4)
.pad_drive:
	move.b	#':',-(a4)
	move.b	drive_char(pc),-(a4)
.pad_done:
	move.l	a4,a1
.pass_path:
	tst.b	(a1)+
	bne.s	.pass_path
	subq	#2,a1			;a1 -> last non-term char in path
	cmp.b	#'\',(a1)+
	beq.s	.have_end_slash
	move.b	#'\',(a1)+
.have_end_slash:
	lea	auto_s(pc),a0
.copy_auto_loop:
	move.b	(a0)+,(a1)+
	bne.s	.copy_auto_loop
.have_base_path:
	move.b	(a3),d0			;d0 = first non-blank INF char
	and	#$DF,d0
	cmp	#'Z',d0
	bhi.s	.setup_path
	sub	#'A',d0
	blt.s	.setup_path
	cmp.b	#':',1(a3)
	bne.s	.setup_path
	gemdos	Dsetdrv,d0
	bra.s	.done_base_path
;-------
.setup_path:
	move.l	a4,d0			;test path setting needs
	ble.s	.done_base_path
	gemdos	Dsetpath,(a4)		;first set base path of INF
.done_base_path:
	move.l	a3,a0
.term_loop:
	cmp.b	#' ',(a0)+
	bhi.s	.term_loop
	clr.b	-(a0)
	gemdos	Dsetpath,(a3)		;set real path found in INF  (rel?)
.done_inf_file:
;-------------------------------------
	xbios	Supexec,run_swoosh_supx(pc)
;-------------------------------------
	move.l	sp,a1
	sub.l	a5,a1
	gemdos	Mshrink,!,(a5),a1
	gemdos	Pexec,!,game_fname_s(pc),NUL_s(pc),NUL_s(pc)
	gemdos	Pterm0
;----------------------------------------------------------------------------
run_overlay_copy:
	addq	#3,d0
	lsr	#2,d0				;d0 = count of longs rounded up
	lea	overlay_base(pc),a1
	add	#$01FF,a1
	move.l	a1,d1
	and	#-$0200,d1			;d1 rounded up to even page no.
	move.l	d1,a1				;a1 = rounded address
	bra.s	.copy_next
;-------
.copy_loop:					;loop start to copy routine
	move.l	(a0)+,(a1)+			;copy one long of routine
.copy_next:
	dbra	d0,.copy_loop			;loop back for entire routine
	move.l	d1,a1
	jmp	(a1)				;jump to copied routine
;----------------------------------------------------------------------------
run_swoosh_supx:
	lea	(hw_pal).w,a0
	moveq	#(16/2)-1,d0
.clear_palette_loop:
	clr.l	(a0)+
	dbra	d0,.clear_palette_loop
	movem.l	d3-d7/a3-a6,-(sp)
	clr.l	d3
	move.l	(_hz_200).w,d0
	add.l	#SWOOSH_TIME/5,d0
	move.l	d0,swoosh_end_time
	lea	swoosh_base(pc),a0
	move	#swoosh_size,d0
	bsr	run_overlay_copy
.swoosh_delay:
	move.l	(_hz_200).w,d0
	cmp.l	swoosh_end_time(pc),d0
	blo.s	.swoosh_delay
	movem.l	(sp)+,d3-d7/a3-a6
	bsr	clear_CPU_cache
	rts
;----------------------------------------------------------------------------
weird_rez_s:
	dc.b	CR,LF,BEL,CR,LF
	dc.b	"Sorry!  I can't reach ST_Low resolution.",CR,LF
	dc.b	'The CSB utilities can not be launched.',CR,LF
	dc.b	CR,LF
	dc.b	'Press any key to continue boot without CSB.',CR,LF
	dc.b	CR,LF,BEL,CR,LF
	dc.b	NUL
;-------
auto_s:			dc.b	'auto',NUL
auto_program_INF_s:	dc.b	'auto\'
program_INF_s:		dc.b	'csb_2_ld.inf',NUL
;-------
	EVEN
;----------------------------------------------------------------------------
	make	JAR_links
;----------------------------------------------------------------------------
swoosh_base:
	include	SWOOSH.S
swoosh_end:
swoosh_size	=	(swoosh_end-swoosh_base)
	dc.l	0
;----------------------------------------------------------------------------
clear_CPU_cache:
	move.l	d0,-(a7)			; 2F00		     /
	move.l	a0,-(a7)			; 2F08		     /
	move.l	_cookies.w,d0			; 203805A0	      8
	beq.s	done_clear_cache		; 6732		     g2
	movea.l	d0,a0				; 2040		      @
L00BD4:
	move.l	(a0),d0				; 2010		      
	beq.s	done_clear_cache		; 672C		     g,
	addq.l	#8,a0				; 5088		     P
	cmpi.l	#$5F435055,d0			; 0C805F435055	     _CPU
	bne.s	L00BD4				; 66F2		     f
	move	-(a0),d0			; 3020		     0 
	cmpi	#$0014,d0			; 0C400014	     @
	bcs.s	done_clear_cache		; 651A		     e
	cmpi	#$0028,d0			; 0C400028	     @(
	bcc.s	clear_cache_040			; 640E		     d
	movec	cacr,d0				; 4E7A0002	     Nz
	ori	#$0808,d0			; 00400808	     @
	movec	d0,cacr				; 4E7B0002	     N{
	bra.s	done_clear_cache		; 6006		     `

clear_cache_040:
	dc.w	$F478				; F478		     x
	dc.w	$F498				; F498		     
	nop					; 4E71		     Nq
done_clear_cache:
	movea.l	(a7)+,a0			; 205F		      _
	move.l	(a7)+,d0			; 201F		      
	rts					; 4E75		     Nu
;----------------------------------------------------------------------------
game_fname_s:
	dc.b	'utility.prg',$00
	even
;----------------------------------------------------------------------------
	BSS
;----------------------------------------------------------------------------
NUL_s:			ds.b	2048
loc_stk_top:
;-------
swoosh_end_time:	ds.l	1
;-------
drive_code:		ds.w	1
drive_char:		ds.w	1
inf_path_pad:		ds.b	4
inf_path_buff:		ds.b	130
inf_buffer:		ds.b	130
;-------
overlay_base:		ds.b	64*1024
program_end:
;----------------------------------------------------------------------------
	end	
;----------------------------------------------------------------------------
;End of file:	CSB_2_LD.S
;----------------------------------------------------------------------------
