;----------------------------------------------------------------------------
; File name:	EL2_EDIT.S			Revision date:	1999.07.20
; Revised by:	Ulf Ronald Andersson		Revision start:	1998.06.18
;----------------------------------------------------------------------------
; qed-asmpar 4 0006  $dsdr:z:1161,m:4
;desert	drain v1.52   680x0er disassembler  18.06.1998 05:45:02
;datei:	el2_edit.prg   6650 bytes
;text:	 2728	$00aa8
;data:	 3842	$00f02
;bss:  113038  $01b98e
;----------------------------------------------------------------------------
	OUTPUT	.TOS
;----------------------------------------------------------------------------
	TEXT
;----------------------------------------------------------------------------
t_beg:
	move.l	4(sp),a5
	move.l	a5,basepage_p
	lea	loc_stk_top,sp
	lea	b_end,a0
	sub.l	a5,a0
	pea	(a0)
	pea	(a5)
	clr	-(sp)
	move	#$4a,-(sp)
	trap	#1
	add	#12,sp
	pea	init_supx
	move	#$26,-(sp)
	trap	#14
	addq	#6,sp
do_main_menu:
	lea	main_menu_s(pc),a0
	bsr.s	Cconws_sub
	tst.b	d_19a6
	beq.s	t_6e
	lea	d_b88(pc),a0
	bsr.s	Cconws_sub
	lea	b_1d30a,a0
	bsr.s	Cconws_sub
	lea	d_ba9(pc),a0
	bsr.s	Cconws_sub
	movea.l	ship_obj_p(pc),a0
	lea	$f6(a0),a0
	bsr.s	Cconws_sub
t_6e:
	bsr.s	Crawcin_sub
	swap	d0
	sf	dumpfile_f
	cmp.w	#$3b,d0		;F1 ?
	beq	do_load_file
	cmp.w	#$3c,d0		;F2 ?
	beq.s	do_edit_menu
	cmp.w	#$3d,d0		;F3 ?
	beq	do_save_file
	st	dumpfile_f
	cmp.w	#$3e,d0		;F4 ?
	beq	do_load_file
	cmp.w	#$3f,d0		;F5 ?
	beq	do_save_file
	cmp.w	#1,d0		;ESC ?
	bne.s	t_6e
do_exit_program:
	clr.w	-(sp)
	trap	#1			 ;pterm0
;----------------------------------------------------------------------------
Cconws_sub:
	pea	(a0)
	move.w	#9,-(sp)
	trap	#1			 ;cconws
	addq.l	#6,sp
	rts
;----------------------------------------------------------------------------
Crawcin_sub:
	move.w	#7,-(sp)
	trap	#1			 ;crawcin
	addq.l	#2,sp
	move.l	kbshift_p,a0
	move.b	(a0),kbshift_word+1
	rts
;----------------------------------------------------------------------------
do_edit_menu:
	tst.b	d_19a6
	beq.s	t_6e
	lea	edit_menu_s(pc),a0
	bsr.s	Cconws_sub
t_d2:	bsr.s	Crawcin_sub
	swap	d0
	cmp.w	#1,d0			;ESC ?
	beq	do_main_menu
	cmp.w	#$3b,d0			;F1 ?
	beq	do_equipment_menu
	cmp.w	#$3c,d0			;F2 ?
	beq	do_drive_menu
	cmp.w	#$3d,d0			;F3 ?
	beq	do_gun_menu
	cmp.w	#$3e,d0			;F4 ?
	beq	do_missile_menu
	cmp.w	#$3f,d0			;F5 ?
	beq	do_shield_baysize_menu
	cmp.w	#$40,d0			;F6 ?
	beq	do_money_menu
	cmp.w	#$41,d0			;F7 ?
	beq	do_thrustor_menu
	cmp.w	#$42,d0			;F8 ?
	beq.s	do_shipreg
	cmp.w	#$43,d0			;F9 ?
	beq.s	do_ship_index_menu
	bra.s	t_d2
;----------------------------------------------------------------------------
do_shipreg:
	lea	shipreg_prompt_s(pc),a0
	bsr	Cconws_sub
	pea	d_199c(pc)
	move.w	#10,-(sp)
	trap	#1			 ;cconrs
	addq.l	#6,sp
	lea	d_c05(pc),a0
	bsr	Cconws_sub
	lea	d_199e(pc),a0
	moveq	#0,d0
	move.b	-$1(a0),d0
	beq	do_edit_menu
	movea.l	ship_obj_p(pc),a5
	lea	$f6(a5),a5
	clr.b	0(a5,d0.w)
t_142:	move.b	(a0)+,(a5)+
	subq.w	#1,d0
	bne.s	t_142
	bra	do_edit_menu
;----------------------------------------------------------------------------
do_ship_index_menu:
	move.b	ship_objix,d0
	lea	ship_objix_hex_s(pc),a0
	bsr	conv_byte_to_hex
	move.l	ship_obj_p(pc),a5
	move	$1C(a5),d0
	lea	ship_typeix_hex_s(pc),a0
	bsr	conv_word_to_hex
	lea	ship_index_menu_s(pc),a0
	bsr	Cconws_sub
	pea	ship_index_buff(pc)
	move.w	#10,-(sp)
	trap	#1			 ;cconrs
	addq.l	#6,sp
	bra	do_edit_menu
;----------------------------------------------------------------------------
do_missile_menu:
	lea	missile_menu_s(pc),a0
	bsr	Cconws_sub
	clr.w	b_19d6
t_15a:
	move.w	b_19d6(pc),d7
	move.b	d7,d0
	addi.b	#'1',d0
	lea	Pylon_number_s(pc),a0
	move.b	d0,$13(a0)
	bsr	Cconws_sub
	movea.l	ship_obj_p(pc),a5
	lea	$ac(a5),a4
	move.b	0(a4,d7.w),d0
	tst.b	d0
	beq.s	t_186
	addq.w	#1,d0
	bclr	#7,d0
t_186:
	lea	Mis_row_select_s(pc),a0
	addi.b	#$29,d0
	move.b	d0,2(a0)
	move.b	d0,7(a0)
	bsr	Cconws_sub
t_19a:
	bsr	Crawcin_sub
	swap	d0
	cmp.w	#$4b,d0			;cur_left ?
	bne.s	t_1ce
	tst.w	b_19d6
	beq.s	t_19a
	subq.w	#1,b_19d6
t_1b4:
	bsr.s	deselect_mis_row
	bra.s	t_15a
;-------
deselect_mis_row:
	lea	Mis_row_deselect_s(pc),a0
	move.b	d_1953(pc),2(a0)
	move.b	d_1958(pc),7(a0)
	bsr	Cconws_sub
	rts
;-------
t_1ce:
	cmp.w	#$4d,d0			;cur_right ?
	bne.s	t_1e6
	cmpi.w	#7,b_19d6
	bge.s	t_19a
	addq.w	#1,b_19d6
	bra.s	t_1b4
;-------
t_1e6:
	cmp.w	#$48,d0			;cur_up ?
	bne.s	t_21a
	tst.b	0(a4,d7.w)
	beq.s	t_19a
	bsr.s	deselect_mis_row
	lea	Mis_row_select_s(pc),a0
	subq.b	#1,2(a0)
	subq.b	#1,7(a0)
	bsr	Cconws_sub
	subq.b	#1,0(a4,d7.w)
	cmpi.b	#$7f,0(a4,d7.w)
	bne	t_15a
	clr.b	0(a4,d7.w)
	bra	t_15a
;-------
t_21a:	cmp.w	#$50,d0			;cur_down ?
	bne.s	t_254
	cmpi.b	#$85,0(a4,d7.w)
	beq	t_19a
	bsr.s	deselect_mis_row
	lea	Mis_row_select_s(pc),a0
	addq.b	#1,2(a0)
	addq.b	#1,7(a0)
	bsr	Cconws_sub
	addq.b	#1,0(a4,d7.w)
	cmpi.b	#1,0(a4,d7.w)
	bne	t_19a
	move.b	#$80,0(a4,d7.w)
	bra	t_19a
;-------
t_254:	cmp.w	#1,d0
	beq	do_edit_menu
	bra	t_19a
;----------------------------------------------------------------------------
do_shield_baysize_menu:
	clr.b	d_19a7
	lea	shield_baysize_menu_s(pc),a0
	bsr	Cconws_sub
t_26e:
	movea.l	ship_obj_p(pc),a5
	moveq	#0,d0
	move.w	$b6(a5),d0		;get shield capacity to d0
	move.w	d0,$b4(a5)		;charge the shields fully
	lsr.w	#6,d0			;calculate shield count
	lea	shields_num_s(pc),a0
	divu	#$3e8,d0
	addi.b	#'0',d0
	move.b	d0,(a0)+
	clr.w	d0
	swap	d0
	divu	#$64,d0
	addi.b	#'0',d0
	move.b	d0,(a0)+
	clr.w	d0
	swap	d0
	divu	#10,d0
	addi.b	#'0',d0
	move.b	d0,(a0)+
	swap	d0
	addi.b	#'0',d0
	move.b	d0,(a0)+
	moveq	#0,d0
	move.w	baysize,d0
	cmp.l	#30000,d0
	ble.s	t_2c6
	move.w	#30000,d0
	move.w	d0,baysize
t_2c6:
	lea	baysize_num_s(pc),a0
	divu	#$2710,d0
	addi.b	#'0',d0
	move.b	d0,(a0)+
	clr.w	d0
	swap	d0
	divu	#$3e8,d0
	addi.b	#'0',d0
	move.b	d0,(a0)+
	clr.w	d0
	swap	d0
	divu	#$64,d0
	addi.b	#'0',d0
	move.b	d0,(a0)+
	clr.w	d0
	swap	d0
	divu	#10,d0
	addi.b	#'0',d0
	move.b	d0,(a0)+
	swap	d0
	addi.b	#'0',d0
	move.b	d0,(a0)+
	lea	shields_baysize_s(pc),a0
	bsr	Cconws_sub
t_30e:
	lea	d_1780(pc),a0
	tst.b	d_19a7
	bne.s	t_328
	move.b	#$41,3(a0)
	move.b	#$5c,11(a0)
	bra.s	t_334
;-------
t_328:
	move.b	#$5c,3(a0)
	move.b	#$41,11(a0)
t_334:
	bsr	Cconws_sub
t_338:
	bsr	Crawcin_sub
	swap	d0
	and	#$FF,d0
	cmp.w	#$4b,d0		;cur_left ?
	bne.s	t_34c
	clr.b	d_19a7
	bra.s	t_30e
;-------
t_34c:
	cmp.w	#$4d,d0		;cur_right ?
	bne.s	t_35a
	st	d_19a7
	bra.s	t_30e
;-------
t_35a:
	cmp.w	#$48,d0		;cur_up ?
	bne.s	t_38a
	tst.b	d_19a7
	bne.s	t_378
	tst.w	$b6(a5)
	ble.s	t_338
	move	#-640,d0
	btst	#1,kbshift_word+1
	bne.s	add_shields_d0
	moveq	#-64,d0
	bra.s	add_shields_d0
;
t_378:
	tst.w	baysize
	ble.s	t_338
	moveq	#-100,d0
	btst	#0,kbshift_word+1
	bne.s	add_baysize_d0
	moveq	#-10,d0
	btst	#1,kbshift_word+1
	bne.s	add_baysize_d0
	moveq	#-1,d0
	bra.s	add_baysize_d0
;-------
t_38a:
	cmp.w	#$50,d0		;cur_down ?
	bne.s	t_3be
	tst.b	d_19a7
	bne.s	t_3aa
	cmpi.w	#(500<<6),$b6(a5)
	bge	t_338
	move	#640,d0
	btst	#1,kbshift_word+1
	bne.s	add_shields_d0
	moveq	#64,d0
add_shields_d0:
	add.w	d0,$b6(a5)
	bra	t_26e
;
t_3aa:
	cmpi.w	#30000,baysize
	bge	t_338
	moveq	#100,d0
	btst	#0,kbshift_word+1
	bne.s	add_baysize_d0
	moveq	#10,d0
	btst	#1,kbshift_word+1
	bne.s	add_baysize_d0
	moveq	#1,d0
add_baysize_d0:
	add	d0,baysize
	bra	t_26e
;-------
t_3be:
	cmp.w	#$32,d0			;'M' ?
	bne.s	t_3d8
	move.w	#(500<<6),$b6(a5)	;Maximize shields
	move.w	#30000,baysize		;Maximize baysize
	bra	t_26e
;-------
t_3d8:
	cmp.w	#1,d0			;ESC ?
	beq	do_edit_menu
	bra	t_338
;----------------------------------------------------------------------------
do_money_menu:
	move.l	#1000000000,money
	lea	money_menu_s(pc),a0
	bsr	Cconws_sub
	bsr	Crawcin_sub
	bra	do_edit_menu
;----------------------------------------------------------------------------
do_thrustor_menu:
	move.l	#60*545,d0		;d0 = Positive thrustor value
	move.l	d0,d1
	neg.l	d1			;d1 = Negative thrustor value
	movea.l	ship_obj_p(pc),a5
	lea	$92(a5),a0		;Index data stored with ship 'object'
	move.w	d0,(a0)+		;Maximize positive X thrust \ Sideways
	move.w	d1,(a0)+		;Maximize negative X thrust / turns
	move.w	d0,(a0)+		;Maximize positive Y thrust \ Vertical
	move.w	d1,(a0)+		;Maximize negative Y thrust / turns
	move.w	d0,(a0)+		;Maximize positive Z thrust Main boost
	move.w	d1,(a0)+		;Maximize negative Z thrust Retro boost
	lea	dump_ref+$846e,a0	;Index extra copy of the table
	move.w	d0,(a0)+		;Maximize positive X thrust \ Sideways
	move.w	d1,(a0)+		;Maximize negative X thrust / turns
	move.w	d0,(a0)+		;Maximize positive Y thrust \ Vertical
	move.w	d1,(a0)+		;Maximize negative Y thrust / turns
	move.w	d0,(a0)+		;Maximize positive Z thrust Main boost
	move.w	d1,(a0)+		;Maximize negative Z thrust Retro boost
	lea	dump_ref+$AEA2,a0	;Index longs MainG and RetroG
	move.l	d0,(a0)+		;Maximize MainG
	move.l	d1,(a0)+		;Maximize RetroG
	lea	thrustor_menu_s(pc),a0
	bsr	Cconws_sub
	bsr	Crawcin_sub
	bra	do_edit_menu
;----------------------------------------------------------------------------
do_drive_menu:
	lea	drive_menu_s(pc),a0
	bsr	Cconws_sub
	lea	drive_type_s_t(pc),a6
	moveq	#0,d7
t_40c:
	lea	preselect_drive_row_s(pc),a0
	move.b	d7,2(a0)
	addi.b	#$27,2(a0)
	bsr	Cconws_sub
	movea.l	a6,a0
	bsr	Cconws_sub
t_424:
	tst.b	(a6)+
	bne.s	t_424
	addq.w	#1,d7
	cmp.w	#15,d7
	bne.s	t_40c
	movea.l	ship_obj_p(pc),a5
	move.b	$a6(a5),d7
t_438:
	lea	select_drive_row_s(pc),a0
	move.b	d7,2(a0)
	addi.b	#$27,2(a0)
	move.b	2(a0),7(a0)
	bsr	Cconws_sub
t_450:
	bsr	Crawcin_sub
	swap	d0
	cmp.w	#$48,d0			;cur_up ?
	bne.s	t_47c
	tst.w	d7
	beq.s	t_450
	lea	deselect_drive_row_s(pc),a0
	move.b	d_1349(pc),2(a0)
	move.b	2(a0),7(a0)
	bsr	Cconws_sub
	subq.w	#1,d7
t_476:
	move.b	d7,$a6(a5)
	bra.s	t_438
;-------
t_47c:
	cmp.w	#$50,d0			;cur_down ?
	bne.s	t_4a0
	cmp.w	#14,d7
	bge.s	t_450
	lea	deselect_drive_row_s(pc),a0
	move.b	d_1349(pc),2(a0)
	move.b	2(a0),7(a0)
	bsr	Cconws_sub
	addq.w	#1,d7
	bra.s	t_476
;-------
t_4a0:
	cmp.w	#1,d0			;ESC ?
	beq	do_edit_menu
	bra.s	t_450
;----------------------------------------------------------------------------
do_gun_menu:
	lea	gun_menu_s(pc),a0
	bsr	Cconws_sub
	clr.w	b_19d4
	moveq	#0,d6
t_4ba:
	lea	gun_type_s_t(pc),a6
	moveq	#0,d7
t_4c0:
	move.w	d6,d0
	mulu	#$14,d0
	addi.w	#$22,d0
	lea	d_1224(pc),a0
	move.b	d0,3(a0)
	move.b	d7,d0
	addi.w	#$28,d0
	move.b	d0,2(a0)
	bsr	Cconws_sub
	movea.l	a6,a0
	bsr	Cconws_sub
t_4e6:
	tst.b	(a6)+
	bne.s	t_4e6
	addq.w	#1,d7
	cmp.w	#10,d7
	bne.s	t_4c0
	addq.w	#1,d6
	cmp.w	#4,d6
	bne.s	t_4ba
	movea.l	ship_obj_p,a5
t_500:
	lea	d_1257(pc),a0
	bsr	Cconws_sub
	move.b	$a7(a5),d7
	moveq	#4,d6
	sub.b	d7,d6
	tst.b	d7
	beq.s	t_520
t_514:
	lea	available_s(pc),a0
	bsr	Cconws_sub
	subq.b	#1,d7
	bne.s	t_514
t_520:
	tst.b	d6
	beq.s	t_530
t_524:
	lea	unavailable_s(pc),a0
	bsr	Cconws_sub
	subq.b	#1,d6
	bne.s	t_524
t_530:
	move.w	b_19d4(pc),d7
	move.w	d7,d0
	mulu	#$14,d0
	addi.w	#$26,d0
	lea	d_123f(pc),a0
	move.b	d0,3(a0)
	bsr	Cconws_sub
	moveq	#0,d5
	lea	$a8(a5),a4
t_550:
	move.b	(a4)+,d0
	moveq	#0,d1
	lea	gun_type_token_t(pc),a0
t_558:
	cmpa.l	#gun_type_token_t_end,a0
	beq.s	t_568
	cmp.b	(a0)+,d0
	beq.s	t_56e
	addq.w	#1,d1
	bra.s	t_558
;
t_568:
	moveq	#0,d1
	move.b	d1,-$1(a4)	;repatch illegal tokens to zero
t_56e:
	addi.b	#$28,d1
	lea	d_1229(pc),a0
	move.w	d5,d0
	mulu	#$14,d0
	addi.b	#$21,d0
	move.b	d1,2(a0)
	move.b	d1,7(a0)
	move.b	d0,3(a0)
	addi.b	#$12,d0
	move.b	d0,8(a0)
	bsr	Cconws_sub
	addq.w	#1,d5
	cmp.w	#4,d5
	bne.s	t_550
t_5a0:
	bsr	Crawcin_sub
	swap	d0
	cmp.w	#$4b,d0			;cur_left
	bne.s	t_5c8
	tst.w	d7
	beq.s	t_5a0
	subq.w	#1,b_19d4
t_5b6:
	lea	d_124b(pc),a0
	move.b	d_1242(pc),3(a0)
	bsr	Cconws_sub
	bra	t_530
;-------
t_5c8:
	cmp.w	#$4d,d0			;cur_right
	bne.s	t_5dc
	cmp.w	#3,d7
	beq.s	t_5a0
	addq.w	#1,b_19d4
	bra.s	t_5b6
;-------
t_5dc:
	cmp.w	#$48,d0			;cur_up
	bne.s	t_63e
	lea	0(a5,d7.w),a4
	move.b	$a8(a4),d0
	bne.s	.move_up
	move.b	d7,$a7(a5)
	bra	t_500
;
.move_up:
	lea	gun_type_token_t(pc),a0
t_5f0:
	cmp.b	(a0)+,d0
	bne.s	t_5f0
	move.b	-$2(a0),$a8(a4)
t_5fa:
	move.b	d7,d0
	addq.b	#1,d0
	cmp.b	$a7(a5),d0
	ble.s	t_608
	move.b	d0,$a7(a5)
t_608:
	suba.l	#gun_type_token_t,a0
	move.l	a0,d1
	addi.b	#$27,d1
	move.w	d7,d0
	mulu	#$14,d0
	addi.b	#$21,d0
	lea	d_1234(pc),a0
	move.b	d1,2(a0)
	move.b	d0,3(a0)
	move.b	d1,7(a0)
	addi.b	#$12,d0
	move.b	d0,8(a0)
	bsr	Cconws_sub
	bra	t_500
;-------
t_63e:
	cmp.w	#$50,d0			;cur_down ?
	bne.s	t_662
	lea	0(a5,d7.w),a4
	move.b	$a8(a4),d0
	cmp.b	#$cf,d0			;large plasma acc ?
	beq	t_5a0
	lea	gun_type_token_t(pc),a0
t_658:	cmp.b	(a0)+,d0
	bne.s	t_658
	move.b	(a0),$a8(a4)
	bra.s	t_5fa
;-------
t_662:
	cmp.w	#1,d0
	beq	do_edit_menu
	bra	t_5a0
;----------------------------------------------------------------------------
do_equipment_menu:
	lea	equipment_menu_s(pc),a0
	bsr	Cconws_sub
	move.w	#1,b_19d2
t_67e:
	movea.l	ship_obj_p,a5
	move.l	$9e(a5),d6
	moveq	#1,d7
	lea	equipment_s_t(pc),a6
t_68e:
	btst	d7,d6
	beq.s	t_698
	lea	Fitted_s(pc),a0
	bra.s	t_69c
;
t_698:
	lea	Not_fitted_s(pc),a0
t_69c:
	move.b	d7,2(a0)
	addi.b	#$22,2(a0)
	move.b	2(a0),d_10c8
	bsr	Cconws_sub
	lea	d_10c6(pc),a0
	bsr	Cconws_sub
	movea.l	a6,a0
	bsr	Cconws_sub
	lea	d_c4b(pc),a0
	bsr	Cconws_sub
t_6c8:
	tst.b	(a6)+
	bne.s	t_6c8
	addq.w	#1,d7
	cmp.w	#$13,d7
	bne.s	t_68e
	move.w	b_19d2(pc),d7
t_6d8:
	move.b	d7,d5
	addi.b	#$22,d5
	lea	d_1219(pc),a0
	move.b	d5,2(a0)
	move.b	d5,7(a0)
	bsr	Cconws_sub
	bsr	Crawcin_sub
	swap	d0
	cmp.w	#$48,d0			;cur_up ?
	bne.s	t_714
	cmp.w	#1,d7
	beq.s	t_6d8
	subq.w	#1,d7
t_702:
	lea	d_120e(pc),a0
	move.b	d5,2(a0)
	move.b	d5,7(a0)
	bsr	Cconws_sub
	bra.s	t_6d8
;-------
t_714:
	cmp.w	#$50,d0			;cur_down ?
	bne.s	t_724
	cmp.w	#$12,d7
	beq.s	t_6d8
	addq.w	#1,d7
	bra.s	t_702
;-------
t_724:
	cmp.w	#$4b,d0			;cur_left ?
	bne.s	t_73a
	bset	d7,d6
t_72c:
	move.l	d6,$9e(a5)
	move.w	d7,b_19d2
	bra	t_67e
;-------
t_73a:	cmp.w	#$4d,d0			;cur_right ?
	bne.s	t_744
	bclr	d7,d6
	bra.s	t_72c
;-------
t_744:
	cmp.w	#1,d0			;ESC ?
	beq	do_edit_menu
	bra.s	t_6d8
;----------------------------------------------------------------------------
prompt_filename:
	lea	filename_prompt_s(pc),a0
	bsr	Cconws_sub
	lea	Cconrs_bf(pc),a0
	move.b	#12,(a0)
	pea	(a0)
	move.w	#10,-(sp)
	trap	#1			 ;cconrs
	addq.l	#6,sp
	lea	Cconrs_bf+2(pc),a0
	tst.b	-$1(a0)
	beq.s	t_776
t_76c:	move.b	(a0)+,(a6)+
	subq.b	#1,Cconrs_bf+1
	bne.s	t_76c
t_776:	clr.b	(a6)+
	lea	d_c05(pc),a0
	bsr	Cconws_sub
	rts
;----------------------------------------------------------------------------
do_save_file:
	tst.b	d_19a6
	beq	t_6e
	lea	b_19c5(pc),a6
	bsr.s	prompt_filename
	lea	b_19c5(pc),a6
	tst.b	(a6)
	beq	do_main_menu
	lea	b_1d30a,a0
	lea	b_19e1e,a1
	moveq	#7,d0
t_7aa:
	move.b	(a6),(a0)+
	move.b	(a6)+,(a1)
	andi.b	#$df,(a1)+
	dbra	d0,t_7aa
	clr.b	(a0)+
	clr.b	(a1)+
	lea	file_bf(pc),a4
	move.w	#$11,(a4)+
	movea.l	a4,a1
	lea	patch_bf,a0
	move.w	#33005,d0	;block 1 is 33006 bytes
t_7ce:
	move.b	(a0)+,(a1)+
	dbeq	d0,t_7ce
	bne.s	t_7fc
	subq.w	#1,d0
	bcs.s	t_7fc
	tst.b	dumpfile_f
	bne.s	t_7ce		;skip RLE encoding block 1 for dumpfiles
t_7da:
	moveq	#0,d1
t_7dc:
	move.b	(a0)+,d2
	bne.s	t_7ee
	addq.b	#1,d1
	dbeq	d0,t_7dc
	bne.s	t_7fa
	subq.b	#1,d1
	subq.w	#1,d0
	bcs.s	t_7fa
t_7ee:
	move.b	d1,(a1)+
	move.b	d2,(a1)+
	dbeq	d0,t_7ce
	beq.s	t_7da
	bra.s	t_7fc
;
t_7fa:
	move.b	d1,(a1)+
t_7fc:
	move.w	#$20b,d0	;block 2 is 524 bytes
t_800:
	move.b	(a0)+,(a1)+
	dbra	d0,t_800
;
	move.w	#$3661,d0	;block 3 is 13922 bytes
t_80a:
	move.b	(a0)+,(a1)+
	dbeq	d0,t_80a
	bne.s	t_838
	subq.w	#1,d0
	bcs.s	t_838
	tst.b	dumpfile_f
	bne.s	t_80a		;skip RLE encoding block 2 for dumpfiles
t_816:
	moveq	#0,d1
t_818:
	move.b	(a0)+,d2
	bne.s	t_82a
	addq.b	#1,d1
	dbeq	d0,t_818
	bne.s	t_836
	subq.b	#1,d1
	subq.w	#1,d0
	bcs.s	t_836
t_82a:
	move.b	d1,(a1)+
	move.b	d2,(a1)+
	dbeq	d0,t_80a
	beq.s	t_816
	bra.s	t_838
;
t_836:
	move.b	d1,(a1)+
t_838:
	move.l	a1,d1
	sub.l	a4,d1
	btst	#0,d1
	beq.s	t_846
	addq.l	#1,d1
	addq.l	#1,a1
t_846:
	bsr	crc_encode
	move.l	d0,(a1)+
	addq.l	#6,d1
	subq.l	#2,a4
	move.l	d1,d7
;----- physical save start -----
	clr.w	-(sp)
	pea	b_19c5(pc)
	move.w	#$3c,-(sp)
	trap	#1			 ;fcreate
	addq.l	#8,sp
	move.w	d0,-(sp)
	pea	file_bf
	move.l	d7,-(sp)
	move.w	d0,-(sp)
	move.w	#$40,-(sp)
	trap	#1			 ;fwrite
	lea	12(sp),sp
	move.w	#$3e,-(sp)
	trap	#1			 ;fclose
	addq.l	#4,sp
;----- physical save end -----
	bra	do_main_menu
;----------------------------------------------------------------------------
do_load_error:
	lea	load_error_s(pc),a0
	bsr	Cconws_sub
	bsr	Crawcin_sub
	bra	do_main_menu
;----------------------------------------------------------------------------
do_load_file:
	sf	d_19a6
	lea	file_bf(pc),a0
t_8b6:
	clr.l	(a0)+
	cmpa.l	#patch_bf,a0
	bne.s	t_8b6
	lea	b_19b8(pc),a6
	bsr	prompt_filename
	tst.b	b_19b8
	beq	do_main_menu
;----- physical load start -----
	clr.w	-(sp)
	pea	b_19b8(pc)
	move.w	#$3d,-(sp)
	trap	#1			 ;fopen
	addq.l	#8,sp
	tst.w	d0
	bmi.s	do_load_error
	move.w	d0,-(sp)
	pea	file_bf(pc)
	pea	$10000
	move.w	d0,-(sp)
	move.w	#$3f,-(sp)
	trap	#1			 ;fread
	lea	12(sp),sp
	move.l	d0,d7
	move.w	#$3e,-(sp)
	trap	#1			 ;fclose
	addq.l	#4,sp
;----- physical load end -----
	move.l	d7,d1
	lea	file_bf(pc),a4
	subq.l	#6,d1
	cmpi.w	#$11,(a4)+
	bne	do_load_error
	movea.l	a4,a1
	bsr	crc_decode
	cmp.l	0(a1,d1.l),d0
	bne	do_load_error
;
	moveq	#0,d2
	lea	patch_bf,a0
	move.w	#33005,d0	;block 1 is 33006 bytes
	tst.b	dumpfile_f
	beq.s	t_930		;RLE encode block 1 for non-dumpfiles
.dump_fix_1:
	move.b	(a1)+,(a0)+
	dbra	d0,.dump_fix_1
	bra.s	t_950
;
t_930:
	move.b	(a1)+,(a0)+
	dbeq	d0,t_930
	bne.s	t_950
	move.b	(a1)+,d1
	andi.w	#$ff,d1
	sub.w	d1,d0
	bcs.s	t_950
	subq.w	#1,d1
	bmi.s	t_94c
t_946:
	move.b	d2,(a0)+
	dbra	d1,t_946
t_94c:
	dbra	d0,t_930
t_950:
	move.w	#$20b,d0		;block 2 is 524 bytes
t_954:
	move.b	(a1)+,(a0)+
	dbra	d0,t_954
;
	moveq	#0,d2
	move.w	#$3661,d0		;block 3 is 13922 bytes
	tst.b	dumpfile_f
	beq.s	t_960		;RLE encode block 3 for non-dumpfiles
.dump_fix_2:
	move.b	(a1)+,(a0)+
	dbra	d0,.dump_fix_2
	bra.s	t_980
;
t_960:
	move.b	(a1)+,(a0)+
	dbeq	d0,t_960
	bne.s	t_980
	move.b	(a1)+,d1
	andi.w	#$ff,d1
	sub.w	d1,d0
	bcs.s	t_980
	subq.w	#1,d1
	bmi.s	t_97c
t_976:
	move.b	d2,(a0)+
	dbra	d1,t_976
t_97c:
	dbra	d0,t_960
t_980:
	moveq	#$74,d0
	clr	d1
	move.b	ship_objix,d1	;index, orig max was 114
	ble.s	.have_offset
	move	d1,d0
	mulu	#$11E,d0
	sub.w	#$4A,d0
.have_offset:
	lea	patch_bf,a0
	adda.w	d0,a0
	move.l	a0,ship_obj_p
	st	d_19a6
	bra	do_main_menu
;----------------------------------------------------------------------------
crc_encode:
	tst.b	dumpfile_f
	bne.s	crc_clear
	movea.l	a4,a2
	move.l	d1,d3
	lsr.l	#1,d3
	move.l	#$12350fd4,d0
.loop:
	move.w	(a2),d2
	eor.w	d0,(a2)+
	ext.l	d2
	add.l	d2,d0
	rol.l	#1,d0
	subq.l	#1,d3
	bne.s	.loop
	rts
;----------------------------------------------------------------------------
crc_decode:
	tst.b	dumpfile_f
	bne.s	crc_clear
	movea.l	a4,a2
	move.l	d1,d3
	lsr.l	#1,d3
	move.l	#$12350fd4,d0
.loop:
	eor.w	d0,(a2)
	move.w	(a2)+,d2
	ext.l	d2
	add.l	d2,d0
	rol.l	#1,d0
	subq.l	#1,d3
	bne.s	.loop
	rts
;----------------------------------------------------------------------------
crc_clear:
	clr.l	d0
	rts
;----------------------------------------------------------------------------
init_supx:
	move.l	$4f2.w,a0
	move.l	8(a0),a0
	move.l	$24(a0),kbshift_p
	rts
;----------------------------------------------------------------------------
conv_long_to_hex:
	swap	d0
	bsr.s	conv_word_to_hex
	swap	d0
conv_word_to_hex:
	ror.w	#8,d0
	bsr.s	conv_byte_to_hex
	rol.w	#8,d0
conv_byte_to_hex:
	ror.b	#4,d0
	bsr.s	conv_nybble_to_hex
	rol.b	#4,d0
conv_nybble_to_hex:
	move.l	d0,-(sp)
	and	#$F,d0
	add	#'0',d0
	cmp	#'9',d0
	bls.s	.store_hex
	add	#(('A'-$A)-'0'),d0
.store_hex:
	move.b	d0,(a0)+
	move.l	(sp)+,d0
	rts
;----------------------------------------------------------------------------
t_end:
;----------------------------------------------------------------------------
	DATA
;----------------------------------------------------------------------------
d_beg:
dumpfile_f:
	dc.w	0
;-------------------------------------
main_menu_s:
	dc.b	$1B,'f',$1B,'E',$1B,'Y&:'
	dc.b	'The Pompey Pirates present:'
	dc.b	$1B,'Y(3',"Frontier - Elite II commander file editor"
	dc.b	$1B,'Y*7',"    Written by Alien's Ghost (spook!)"
	dc.b	$1B,'Y,=',"F1 ... Load commander"
	dc.b	$1B,'Y-=',"F2 ... Edit commander"
	dc.b	$1B,'Y.=',"F3 ... Save commander"
	dc.b	$1B,'Y/=',"F4 .... Load dumpfile"
	dc.b	$1B,'Y0=',"F5 .... Save dumpfile"
	dc.b	$1B,'Y1=',"Esc ............ Quit"
	dc.b	0
d_b88:
	dc.b	$1B,'Y12Currently loaded: Commander ',$0
d_ba9:
	dc.b	', ',$0
;-------------------------------------
filename_prompt_s:
	dc.b	$1B,'E',$1B,'Y*+Enter commander file name ('
	dc.b	'stick to numbers and letters!):',$1B,'Y,A['
	dc.b	'            ]',$1B,'Y,B',$1B,'e',$0
d_c05:
	dc.b	$1B,'f',$0
load_error_s:
	dc.b	$1B,'E',$1B,'Y,*Error : file not found, not'
	dc.b	' a commander file, or corrupted.',$7,$0
d_c4b:
	dc.b	$D,$A,$0
;-------------------------------------
edit_menu_s:
	dc.b	$1B,'E'
	dc.b	$1B,'Y)>Select what to edit:'
	dc.b	$1B,'Y+<F1 ........... Equipment'
	dc.b	$1B,'Y,<F2 ............... Drive'
	dc.b	$1B,'Y-<F3 ................ Guns'
	dc.b	$1B,'Y.<F4 ............ Missiles'
	dc.b	$1B,'Y/<F5 . Shields / Cargo bay'
	dc.b	$1B,'Y0<F6 .... 100,000,000 Cash'
	dc.b	$1B,'Y1<F7 ....... 60G Thrustors'
	dc.b	$1B,'Y2<F8 ... Ship registration'
	dc.b	$1B,'Y3<F9 ... Ship object index'
	dc.b	$0
;-------------------------------------
ship_index_menu_s:
	dc.b	$1B,'E'
	dc.b	$1B,'Y)<Current ship object index = $'
ship_objix_hex_s:
	dc.b	'00'
	dc.b	$1B,'Y+<Current ship type index = $'
ship_typeix_hex_s:
	dc.b	'0000'
	dc.b	$1B,'Y,<Enter a modification command.'
	dc.b	$1B,'Y,<(Enter empty line to exit.)'
	dc.b	$0
ship_index_buff:
	dc.b	30,0
	ds.b	30
;-------------------------------------
equipment_menu_s:
	dc.b	$1B,'E',$1B,'Y!',$27,'Use cursor up/down to'
	dc.b	' select item, cursor left/right to fit/rem'
	dc.b	'ove.',$1B,'Y6"Remember, this stuff',$27,'s'
	dc.b	' mass is no longer a problem. You can have'
	dc.b	' it all even',$1B,'Y7"if your ship is a pu'
	dc.b	'ny little shuttle craft... I haven',$27,'t'
	dc.b	' lost my touch, eh?',$0
;-------------------------------------
drive_menu_s:
	dc.b	$1B,'E',$1B,'Y"#Use cursor up/down to selec'
	dc.b	't drive; bear in mind that range and fuel '
	dc.b	'usage',$1B,'Y##depend on the mass of your '
	dc.b	'ship so rather than give a big ship an adv'
	dc.b	'anced',$1B,'Y$#drive, you',$27,'re better '
	dc.b	'off giving a really small ship a good driv'
	dc.b	'e. Remember,',$1B,'Y%-with this program th'
	dc.b	'e mass of the drive doesn',$27,'t matter!',$0
;-------------------------------------
gun_menu_s:
	dc.b	$1B,'E',$1B,'Y"!Use cursor left/right to se'
	dc.b	'lect mounting, cursor up/down to select th'
	dc.b	'e type of',$1B,'Y#"weapon you want there. '
	dc.b	'If you put a weapon on an unavailable moun'
	dc.b	'ting, that',$1B,'Y$!mounting will become a'
	dc.b	'vailable... shuttle craft with plasma accs'
	dc.b	'.? No problem!',$1B,'Y&',$27,'Front       '
	dc.b	'        Rear              Top turret      '
	dc.b	'   Bottom turret',$0
;-------------------------------------
money_menu_s:
	dc.b	$1B,'E',$1B,'Y,:You now have C100,000,000.0!',$0
;-------------------------------------
thrustor_menu_s:
	dc.b	$1B,'E',$1B,'Y,:You now have 60G Thrustors !',$0
;-------------------------------------
Not_fitted_s:
	dc.b	$1B,'Y',$0,'O: Not fitted',$D,$0
Fitted_s:
	dc.b	$1B,'Y',$0,'O:     Fitted',$D,$0
d_10c6:
	dc.b	$1B,'Y'
d_10c8:
	dc.b	$0,'5',$0
equipment_s_t:
	dc.b	'Cargo Bay Life Support',$0
	dc.b	'Scanner',$0
	dc.b	'E.C.M. System',$0
	dc.b	'Fuel Scoop',$0
	dc.b	'Automatic Pilot',$0
	dc.b	'Radar Mapper',$0
	dc.b	'Naval E.C.M. System',$0
	dc.b	'Hyperspace Cloud Analyser',$0
	dc.b	'Fighter Launch Device',$0
	dc.b	'Energy Bomb',$0
	dc.b	'Escape Capsule',$0
	dc.b	'Energy Booster Unit',$0
	dc.b	'Cargo Scoop Conversion',$0
	dc.b	'Atmospheric Shielding',$0
	dc.b	'Hull Auto-Repair System',$0
	dc.b	'Laser Cooling Booster',$0
	dc.b	'Auto Refueller',$0
	dc.b	'Military Cameras',$0
d_120e:
	dc.b	$1B,'Y',$0,'3 ',$1B,'Y',$0,'\ ',$0
d_1219:
	dc.b	$1B,'Y',$0,'3>',$1B,'Y',$0,'\<',$0
d_1224:
	dc.b	$1B,'Y',$0,$0,$0
d_1229:
	dc.b	$1B,'Y',$0,$0,'>',$1B,'Y',$0,$0,'<',$0
d_1234:
	dc.b	$1B,'Y',$0,$0,' ',$1B,'Y',$0,$0,' ',$0
d_123f:
	dc.b	$1B,'Y5'
d_1242:
	dc.b	$0,'^ ^ ^ ^',$0
d_124b:
	dc.b	$1B,'Y5',$0,'       ',$0
d_1257:
	dc.b	$1B,'Y3 ',$0
available_s:
	dc.b	'     Available      ',$0
unavailable_s:
	dc.b	'    Unavailable     ',$0
gun_type_token_t:
	dc.b	$0,$88,$91,$9a,$a1,$aa,$b3,$bc,$c6,$cf
gun_type_token_t_end:
gun_type_s_t:
	dc.b	'    No weapon',$0
	dc.b	' 1MW Pulse Laser',$0
	dc.b	' 5MW Pulse Laser',$0
	dc.b	'30MW Mining Laser',$0
	dc.b	' 1MW Beam Laser',$0
	dc.b	' 4MW Beam Laser',$0
	dc.b	'20MW Beam Laser',$0
	dc.b	'100MW Beam Laser',$0
	dc.b	'Small Plasma Acc.',$0
	dc.b	'Large Plasma Acc.',$0
preselect_drive_row_s:
	dc.b	$1B,'Y'
	dc.b	$0		;dummy, replaced by row code
	dc.b	'='
	dc.b	$0		;string terminator
deselect_drive_row_s:
	dc.b	$1B,'Y'
	dc.b	$0		;dummy, replaced by row code
	dc.b	'; ',$1B,'Y'
	dc.b	$0		;dummy, replaced by row code
	dc.b	'T '
	dc.b	$0		;string terminator
select_drive_row_s:
	dc.b	$1B,'Y'
d_1349:
	dc.b	$0		;dummy, replaced by row code
	dc.b	';>',$1B,'Y'
	dc.b	$0		;dummy, replaced by row code
	dc.b	'T<'
	dc.b	$0		;string terminator
drive_type_s_t:
	dc.b	'       No drive',$0
	dc.b	' Interplanetary Drive',$0
	dc.b	'  Class 1 Hyperdrive',$0
	dc.b	'  Class 2 Hyperdrive',$0
	dc.b	'  Class 3 Hyperdrive',$0
	dc.b	'  Class 4 Hyperdrive',$0
	dc.b	'  Class 5 Hyperdrive',$0
	dc.b	'  Class 6 Hyperdrive',$0
	dc.b	'  Class 7 Hyperdrive',$0
	dc.b	'  Class 8 Hyperdrive',$0
	dc.b	'Class 1 Military Drive',$0
	dc.b	'Class 2 Military Drive',$0
	dc.b	'Class 3 Military Drive',$0
	dc.b	'Class 4 Military Drive',$0
	dc.b	'Class 8 Military Drive',$0
shield_baysize_menu_s:
	dc.b	$1B,'E'
	dc.b	$1B,"Y%'",'Cursor left/right to select item, cursor up/down to change amount.'
	dc.b	$1B,'Y&!Note that cargo capacity cannot exceed 32767, and if you manage to do that by'
	dc.b	$1B,"Y' ",'removing items of equipment, the game will think you have no remaining capacity'
	dc.b	$1B,'Y("','so just run this option again and it will automatically bring your capacity'
	dc.b	$1B,'Y)$','down to 30000 tons once more. Pressing M maximises both these settings.'
	dc.b	$1B,'Y0 ',"Also note that past a certain amount shield generators lose effectiveness. I've"
	dc.b	$1B,'Y1"','imposed an arbitrary limit of 500; the game will let you buy more, but wraps'
	dc.b	$1B,'Y2!',"round to zero if you buy another one, and doesn't recharge them properly when"
	dc.b	$1B,'Y3"','you have so many of them anyway. Experiment to find the best amount for you.'
	dc.b	$0
shields_baysize_s:
	dc.b	$1B,'Y,.Shield generators: '
shields_num_s:
	dc.b	'0000       Cargo capacity: '
baysize_num_s:
	dc.b	'00000t',$0
d_1780:
	dc.b	$1B,'Y.A^^^^',$1B,'Y.\    ',$0
missile_menu_s:
	dc.b	$1B,'E'
	dc.b	$1B,'Y%&','Cursor left/right to select missile pylon, up/down to select weapon.'
	dc.b	$1B,'Y)C','No weapon'
	dc.b	$1B,'Y*B','Dummy Mine'
	dc.b	$1B,'Y+@','Proximity Mine'
	dc.b	$1B,'Y,@','Homing Missile'
	dc.b	$1B,'Y-A','Smart Missile'
	dc.b	$1B,'Y.A','Naval Missile'
	dc.b	$1B,'Y/@','Nuclear Missile'
	dc.b	$1B,'Y1"','Of course, nukes only work in the appropriate mission, so visiting a certain'
	dc.b	$1B,'Y2$','area of Earth beginning with I and ending with raq is pointless. Damn it!'
	dc.b	$1B,'Y3"','Note that you can load up all eight pylons, no matter how few your ship has.'
Pylon_number_s:
	dc.b	$1B,'Y',$27,'@Pylon number : 0',$0
Mis_row_select_s:
	dc.b	$1B,'Y'
d_1953:
	dc.b	$0		;dummy, replaced by row code
	dc.b	'>>',$1B,'Y'
d_1958:
	dc.b	$0		;dummy, replaced by row code
	dc.b	'P<'
	dc.b	$0		;string terminator
Mis_row_deselect_s:
	dc.b	$1B,'Y'
	dc.b	$0		;dummy, replaced by row code
	dc.b	'> ',$1B,'Y'
	dc.b	$0		;dummy, replaced by row code
	dc.b	'P '
	dc.b	$0		;string terminator
shipreg_prompt_s:
	dc.b	$1B,'E',$1B,'Y+:Enter new ship registration'
	dc.b	':',$1B,'Y-D[      ]',$1B,'Y-E',$1B,'e',$0
d_199c:	dc.b	$6,$0
d_199e:	dc.b	$0,$0,$0,$0,$0,$0,$0
d_19a5:	dc.b	$0		;not used, was rez flag before revision
d_19a6:	dc.b	$0
d_19a7:	dc.b	$0
	EVEN
d_end:
;----------------------------------------------------------------------------
	BSS
;----------------------------------------------------------------------------
b_beg:
basepage_p:	ds.l	1
kbshift_p:	ds.l	1
kbshift_word:	ds.w	1
Cconrs_bf:	ds.w	8	;16
b_19b8:		ds.b	13	;=13
b_19c5:		ds.b	13	;=13
b_19d2:		ds.w	1	;=2
b_19d4:		ds.w	1	;=2
b_19d6:		ds.w	1	;=2
ship_obj_p:	ds.l	1	;=4
file_bf:	ds.b	$00FFFE	;=65534
dump_ref:	ds.w	1	;=2
patch_bf:	ds.l	8419	;=33676 (was b_119dc)
ship_objix:	ds.l	16	;=64	dump_ref+$838e
money:		ds.l	1	;=4	dump_ref+$83ce
baysize:	ds.w	57	;=114	dump_ref+$83d2
b_19e1e:	ds.l	3387	;=13548	dump_ref+$8444
b_1d30a:	ds.w	23	;=46	dump_ref+$b930
dump_end:			;dump_ref+$b95e
		ds.b	8192
loc_stk_top:
		ds.b	16
b_end:
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	EL2_EDIT.S
;----------------------------------------------------------------------------
