;----------------------------------------------------------------------------
;;;module_A0:	;Base address of module A0 (was originally X811EA)
;----------------------------------------------------------------------------
;------- offs $00
	dc.b	'h',$00
	dc.w	$0000
;------- offs $04
	rts
	dc.w	$0000
;------- offs $08
	bra.w	hyper_misjump		;accessed as "jmp $0008(a?)"
;------- offs $0C
	rts
	dc.w	$0000
;------- offs $10
	rts
	dc.w	$0000
;------- offs $14
	rts
	dc.w	$0000
;------- offs $18
	rts
	dc.w	$0000
;------- offs $1C
	rts
	dc.w	$0000
;------- offs $20
	bra.w	hyper_calc		;accessed as "jmp $0020(a?)"
;------- offs $24
	rts
	dc.w	$0000
;------- offs $28 == o_disp_ms_xxxx,  absent here as mod A0 has no strings
	rts
	dc.w	$0000
;------- offs $2C
	rts
	dc.w	$0000
;----------------------------------------------------------------------------
	IFNE	NEW_hype_calc
;----------------------------------------------------------------------------
hyper_calc_mod_beg:			;was originally L8121A
;-------------------------------------
hyper_calc_lim:			;accessed as "jmp $0030(a?)"
hyper_calc:				;was originally L8121A
	tst 	d0		;2
	beq.w	L81442		;4
	move.l	a3,-(a7)	;2
	cmp 	#$0003,d0	;4
	beq.w	ship_range_hype	;4
	cmp 	#$0004,d0	;4
	beq.w	L81440		;4
	move 	d0,-(a7)	;2
	move 	$005A(a0),d0	;4
	jsr 	$0348(a5)	;4	;find_shipdata_d0_a3
	adda 	$001C(a3),a3	;4
	move 	$0006(a3),d4	;4	;d4 = shipmass
	move 	(a7)+,d0	;2
	moveq	#$00,d5		;2
	move.b	$00A6(a0),d5	;4	;d5 = drive
	asl 	#3,d5		;2	;d5 = drive *8
	movem.l	drive_info_t(pc,d5),d2-d3	;6
	move.l	d2,d5		;2	;d5 = d2 = drive_range
	bsr.w	divx_mass_d2	;4	;d2 = drive_range / shipmass = ship_range
	tst.l 	d1		;2	;distance != 0 ?
	beq.w	L81364		;4
	and.l	#$0000FFFF,d1	;6	;limit unsigned d1 = word value in long
	cmp.l 	d1,d2		;2	;ship_range >= distance ?
	bcs.w	L81364		;4
	mulu 	d1,d4		;2	;d4 = mass * distance
	move.l	d4,d1		;2	;d1 = mass * distance
	divu	#$4E21,d4	;4	;div d4 by 20,001  (rounding forced down)
	addq 	#1,d4		;2	;round up
	ext.l	d4		;2	;here d4 = fuel_need
	bsr.w	triptime_d5d1	;4	;d1 = (dist*mass*7<<11)/(drive_range>>5)
	move.b	$005D(a0),d5	;4
	cmp.b	$029E(a6),d5	;4	;shipobjix == d5 ?  (player ship ?)
	bne.w	L81352		;4
	move.b	$00A6(a0),d5	;4	;d5 = drive
	cmpi.b	#dd_M1_index,d5	;4	;drive < M1_drive
	bcc.w	hypercalc_Mil	;4
hypercalc_Hyd:
	move 	$0318(a6),d5	;4	;d5 = hydrogen_fuel
	cmp 	d5,d4		;2	;fuel_need <= hydrogen_fuel ?
	bhi.w	L81366		;4
	cmp 	#$0002,d0	;4	;pre_calc jump ?
	bne.w	L81342		;4
	sub 	d4,$0318(a6)	;4	;hydrogen_fuel -= d4
	sub 	d4,$02E6(a6)	;4	;cargo_mass -= d4
	sub 	d4,d5		;2	;d5 -= d4
	bra.w	L81342		;4
;-------------------------------------
;Partial byte count of hyper_calc	;156
;-------------------------------------
drive_info_t:				;was originally X812B2
;-------
drive_info_entry	MACRO
dd_\<$dd_ix>_di_hyper:
	dc_dd.l	hyper
dd_\<$dd_ix>_di_mass:
	dc_dd.w	mass
	dc_dd.w	ms_code
dd_ix		set	dd_ix+1
	ENDM
;-------
dd_ix	set	0
	repeat	15,<drive_info_entry>
;-------
	dd_ref	M1,di_hyper,di_M1_hyper
	dd_ref	M2,di_hyper,di_M2_hyper
	dd_ref	M3,di_hyper,di_M3_hyper
	dd_ref	H4,di_hyper,di_H4_hyper
	dd_ref	H5,di_hyper,di_H5_hyper
	dd_ref	H6,di_hyper,di_H6_hyper
	dd_ref	H7,di_hyper,di_H7_hyper
;-------
	dd_ref	M1,di_mass,di_M1_mass
	dd_ref	M2,di_mass,di_M2_mass
	dd_ref	M3,di_mass,di_M3_mass
	dd_ref	H4,di_mass,di_H4_mass
	dd_ref	H5,di_mass,di_H5_mass
	dd_ref	H6,di_mass,di_H6_mass
	dd_ref	H7,di_mass,di_H7_mass
;-------------------------------------
;Partial byte count of drive_info_t	;120
;-------------------------------------
hypercalc_Mil:				;was originally L8132A
	move 	$031A(a6),d5	;4	;d5 = military_fuel
	cmp 	d5,d4		;2	;fuel_need <= military_fuel ?
	bhi.s	L81366		;2
	cmp 	#$0002,d0	;4	;pre_calc jump ?
	bne.s	L81342		;2
	sub 	d4,$031A(a6)	;4	;military_fuel -= d4
	add 	d4,$032C(a6)	;4	;radioactives += d4
	sub 	d4,d5		;2	;d5 -= d4
L81342:
	mulu 	#$4E21,d5	;4	;d5 = fuel_remains * 20,001
	exg	d2,d5		;2	;\
	bsr.s	divx_mass_d2	;2	; > d5 = fuel_remains*20,001/shipmass,  rem_range
	exg	d2,d5		;2	;/
	cmp.l 	d2,d5		;2	;rem_range >= ship_range ?
	bcs.s	.fix_rem_range	;2
	move.l 	d2,d5		;2	;d5 = ship_range,  d5 will be the range after the jump
.fix_rem_range:
	cmp.l	#$00007FFF,d5	;6
	blo.s	L8136A		;2
	move	#$7FFF,d5	;4	;limit d5 to max positive short word
	bra.s	L8136A		;2
;-------
L81352:
	cmp.b	$00ED(a0),d4	;4
	bhi.s	L81366		;2
	cmp 	#$0002,d0	;4
	bne.s	L8136A		;2
	sub.b	d4,$00ED(a0)	;4
	bra.s	L8136A		;2
;-------
L81364:	moveq	#-$01,d4	;2
L81366:	moveq	#$00,d5		;2
	moveq	#-$01,d0	;2
L8136A:	movea.l	(a7)+,a3	;2
	rts			;2
;-------------------------------------
;Partial byte count of hypercalc_Mil	;82
;-------------------------------------
divx_mass_d2:
	move.l	d0,-(sp)		;2
	tst	6(a3)			;4	;shipmass != 0 ?
	beq.s	.set_max		;2
	move.l	d2,d0			;2	;d0 = d2 = x1.x0
	clr	d2			;2	;d2 = x1.0
	swap	d2			;2	;d2 = 0.x1
	divu	6(a3),d2		;4	;d2 = r1.q1
	swap	d2			;2	;d2 = q1.r1
	swap	d0			;2	;d0 = x0.x1
	move	d2,d0			;2	;d0 = x0.r1
	swap	d0			;2	;d0 = r1.x0
	divu	6(a3),d0		;4	;d0 = r0.q0
	move	d0,d2			;2	;d2 = q1.q0
	bra.s	.use_d2			;2
;-------
.set_max:
	moveq	#-1,d2			;2
	lsr.l	#1,d2			;2	;d2 = $7FFFFFFF
.use_d2:
	move.l	(sp)+,d0		;2
	rts				;2
;-------------------------------------
;Partial byte count of divx_d4_d5d2	;42
;-------------------------------------
ship_range_hype:		;for hyper_calc(3,...)
	move 	d1,d0			;2
	jsr 	$0348(a5)		;4	;find_shipdata_d0_a3
	adda 	$001C(a3),a3		;4	;a3 -> ship data details
	lea	di_H4_hyper(pc),a2	;4	;a2 -> H4 drive details
	bsr.s	calc_range_a2a3		;2	;d0 = range with H4 drive
	move.l	d0,d4			;2	;d4 = range with H4 drive
	bsr.s	calc_range_a2a3		;2	;d0 = range with H5 drive
	move.l	d0,d5			;2	;d5 = range with H5 drive
	bsr.s	calc_range_a2a3		;2	;d0 = range with H6 drive
	move.l	d0,d6			;2	;d6 = range with H6 drive
	bsr.s	calc_range_a2a3		;2	;d0 = range with H7 drive
	move.l	d0,d7			;2	;d7 = range with H7 drive
	lea	di_M1_hyper(pc),a2	;4	;a2 -> M1 drive details
	bsr.s	calc_range_a2a3		;2	;d0 = range with M1 drive
	move.l	d0,d3			;2	;d3 = range with M1 drive
	bsr.s	calc_range_a2a3		;2	;d0 = range with M2 drive
	move.l	d0,d2			;2	;d2 = range with M2 drive
	bsr.s	calc_range_a2a3		;2	;d0 = range with M3 drive
	move.l	d3,d1			;2	;d1 = range with M1 drive
	move.l	d0,d3			;2	;d3 = range with M3 drive
	bra.s	L8136A			;2	;exit to caller
;-------------------------------------
;Partial byte count of ship_range_hype	;50
;-------------------------------------
calc_range_a2a3:
	movem.l	(a2)+,d0/d1		;4	;d0 = raw_range,  d1 =mass.ms_
	swap	d1			;2	;d1 = mass
	cmp 	$0008(a3),d1		;4	;mass < ship load capacity ?
	bcc.s	.zero_result		;2	;if not, zero result
	divu	$0006(a3),d0		;4	;d0 = raw_range/shipmass
	cmp 	#300,d0			;4	;d7 < 3.00 ly ?
	bcc.s	.keep_result		;2	;if not, keep result
.zero_result:
	moveq	#$00,d0			;2	;result = 0
.keep_result:
	and.l	#$0000FFFF,d0		;6	;convert unsigned to long

L81440:
	rts				;2	;return to caller
;-------------------------------------
;Partial byte count of calc_range_a2a3	;32
;-------------------------------------
triptime_d5d1:		;at entry d5 = drive_range  d1 = distance*shipmass
	movem.l	d0/d2/d3,-(sp)	;4	;push d0/d2/d3
;-------
	bsr.w	RA_ufloat_f0	;4	;   f0 = distance*shipmass
	move.l	d5,d3		;4	;\/ f1 = drive_range
	bsr.w	RA_ufloat_f1	;4	;/
	bsr.w	RA_div		;4	;   f0 = f0/f1 = distance/shiprange
	move.l	#7<<16,d3	;6	;\/ f1 = days_per_week<<16
	bsr.w	RA_ufloat_f1	;4	;/
	bsr.w	RA_mul		;4	;   f0 = time needed for the trip
	bsr.w	RA_uint_f0	;4	;   d1 = time needed for the trip
;-------
	movem.l	(sp)+,d0/d2/d3	;4	;pull d0/d2/d3
	rts			;2	;return to caller
;-------------------------------------
;Partial byte count of triptime_d5d1	;62
;----------------------------------------------------------------------------
;Block start was ship_range_hype, originally at L8121A
;Next label was originally L81442
;Original byte count  = 552
;Reused byte count    = 526
;remaining byte count = 026
;-------------------------------------
hyper_calc_mod_end:
hyper_calc_mod_size	= (hyper_calc_mod_end-hyper_calc_mod_beg)
	sz_pad	ship_range_hype,552,hyper_calc_mod_size
;----------------------------------------------------------------------------
	ELSE
;----------------------------------------------------------------------------
hyper_calc:			;was originally L8121A
	tst 	d0
	beq.w	L81442
	move.l	a3,-(a7)
	cmp 	#$0003,d0
	beq.w	ship_range_hype
	cmp 	#$0004,d0
	beq.w	L81440
	move 	d0,-(a7)
	move 	$005A(a0),d0
	jsr 	$0348(a5)		;find_shipdata_d0_a3
	adda 	$001C(a3),a3
	move 	$0006(a3),d4	;d4 = shipmass
	move 	(a7)+,d0
	moveq	#$00,d5
	move.b	$00A6(a0),d5	;d5 = drive
	asl 	#3,d5		;d5 = drive *8
	movem.l	drive_info_t(pc,d5),d2-d3
	divu	d4,d2		;d2 = drive_range / shipmass = ship_range
	ext.l	d2
	cmp 	d1,d2		;ship_range >= distance ?
	bcs.w	L81364
	tst 	d1		;distance != 0 ?
	beq.w	L81364
	mulu 	d1,d4		;d4 = mass * distance
	divu	#$4E21,d4	;div d4 by 20,001  (rounding forced down)
	addq 	#1,d4		;round up
	ext.l	d4		;here d4 = fuel_need
	ext.l	d1
	swap	d1		;d1 = distance<<16
	subq.l	#1,d1
	divu	d2,d1		;d1 = distance<<16 / ship_range == trip_weeks<<16
	mulu 	#$0007,d1	;d1 = 7*(distance<<16 / ship_range) == trip_days<<16
	move.b	$005D(a0),d5
	cmp.b	$029E(a6),d5	;shipobjix == d5 ?  (player ship ?)
	bne.w	L81352
	move.b	$00A6(a0),d5	;d5 = drive
	cmpi.b	#$0A,d5		;drive < M1_drive
	bcc.w	hypercalc_Mil
	move 	$0318(a6),d5	;d5 = hydrogen_fuel
	cmp 	d5,d4		;fuel_need <= hydrogen_fuel ?
	bhi.w	L81366
	cmp 	#$0002,d0	;pre_calc jump ?
	bne.w	L81342
	sub 	d4,$0318(a6)	;hydrogen_fuel -= d4
	sub 	d4,$02E6(a6)	;cargo_mass -= d4
	sub 	d4,d5		;d5 -= d4
	bra.w	L81342
;-------------------------------------
drive_info_t:
	dc.w	$0000,$0000	;0		No drive = no range
	dc.w	$0000,$9C4A	;000,ms_No_Drive
	dc.w	$0000,$0000	;0		Interplanetary = no range
	dc.w	$0004,$9887	;004,ms_IP_Drive
hype_M1_range:
	dc.w	$0000,$4E20	;1*1*200*100	Hyper 1
hype_M1_mass:
	dc.w	$0006,$988A	;006,ms_H1_Drive
hype_M2_range:
	dc.w	$0001,$3880	;2*2*200*100	Hyper 2
hype_M2_mass:
	dc.w	$000C,$9893	;012,ms_H2_Drive
hype_M3_range:
	dc.w	$0002,$BF20	;3*3*200*100	Hyper 3
hype_M3_mass:
	dc.w	$0018,$9895	;024,ms_H3_Drive
hype_H4_range:
	dc.w	$0004,$E200	;4*4*200*100	Hyper 4
hype_H4_mass:
	dc.w	$0050,$9897	;080,ms_H4_Drive
hype_H5_range:
	dc.w	$0007,$A120	;5*5*200*100	Hyper 5
hype_H5_mass:
	dc.w	$0096,$989A	;150,ms_H5_Drive
hype_H6_range:
	dc.w	$000A,$FC80	;6*6*200*100	Hyper 6
hype_H6_mass:
	dc.w	$00FA,$989D	;250,ms_H6_Drive
hype_H7_range:
	dc.w	$000E,$F420	;7*7*200*100	Hyper 7
hype_H7_mass:
	dc.w	$0190,$989F	;400,ms_H7_Drive
	dc.w	$0018,$B820	;9*9*200*100	Hyper 8 (works like 9)
	dc.w	$0258,$9C0C	;600,ms_H8_Drive
	dc.w	$0000,$4E20	;1*1*200*100	Military 1
	dc.w	$0006,$9896	;006,ms_M1_Drive
	dc.w	$0001,$3880	;2*2*200*100	Military 2
	dc.w	$000C,$9898	;012,ms_M2_Drive
	dc.w	$0002,$BF20	;3*3*200*100	Military 3
	dc.w	$0018,$989C	;024,ms_M3_Drive
	dc.w	$0004,$E200	;4*4*200*100	Military 4
	dc.w	$002A,$9C0D	;042,ms_M4_Drive
	dc.w	$0018,$B820	;9*9*200*100	Military 8 ("Unknown")
	dc.w	$0000,$8612	;000,ms_Unknown
;-------------------------------------
hypercalc_Mil:				;was originally L8132A
	move 	$031A(a6),d5	;d5 = military_fuel
	cmp 	d5,d4		;fuel_need <= military_fuel ?
	bhi.s	L81366
	cmp 	#$0002,d0	;4	;pre_calc jump ?
	bne.s	L81342
	sub 	d4,$031A(a6)	;military_fuel -= d4
	add 	d4,$032C(a6)	;radioactives += d4
	sub 	d4,d5		;d5 -= d4
L81342:
	mulu 	#$4E21,d5	;d5 = fuel_remains * 20,001
	divu	$0006(a3),d5	;d5 = fuel_remains*20,001/shipmass,  rem_range
	cmp 	d2,d5		;rem_range >= ship_range ?
	bcs.s	L8136A
	move 	d2,d5		;d5 = ship_range,  d5 will be the range after the jump
	bra.s	L8136A

L81352:	cmp.b	$00ED(a0),d4
	bhi.s	L81366
	cmp 	#$0002,d0
	bne.s	L8136A
	sub.b	d4,$00ED(a0)
	bra.s	L8136A

L81364:	moveq	#-$01,d4
L81366:	moveq	#$00,d5
	moveq	#-$01,d0
L8136A:	movea.l	(a7)+,a3
	rts
;-------------------------------------
ship_range_hype:		;originally L8136E
	move 	d1,d0
	jsr 	$0348(a5)		;find_shipdata_d0_a3
	adda 	$001C(a3),a3
;-------
	move 	hype_M1_mass(pc),d1	;d1 = mass of M1 drive
	cmp 	$0008(a3),d1
	bcc.s	L81390
	move.l	hype_M1_range(pc),d1	;d1 = 1*1*200*100
	divu	$0006(a3),d1
	cmp 	#$012C,d1		;d1 < 3.00 ly ?
	bcc.s	L81392
L81390:	moveq	#$00,d1
L81392:	ext.l	d1
;-------
	move 	hype_M2_mass(pc),d2	;d2 = mass of M2 drive
	cmp 	$0008(a3),d2
	bcc.s	L813AC
	move.l	hype_M2_range(pc),d2	;d2 = 2*2*200*100
	divu	$0006(a3),d2
	cmp 	#$012C,d2		;d2 < 3.00 ly ?
	bcc.s	L813AE
L813AC:	moveq	#$00,d2
L813AE:	ext.l	d2
;-------
	move 	hype_M3_mass(pc),d3	;d3 = mass of M3 drive
	cmp 	$0008(a3),d3
	bcc.s	L813C8
	move.l	hype_M3_range(pc),d3	;d3 = 3*3*200*100
	divu	$0006(a3),d3
	cmp 	#$012C,d3		;d3 < 3.00 ly ?
	bcc.s	L813CA
L813C8:	moveq	#$00,d3
L813CA:	ext.l	d3
;-------
	move 	hype_H4_mass(pc),d4	;d4 = mass of H4 drive
	cmp 	$0008(a3),d4
	bcc.s	L813E4
	move.l	hype_H4_range(pc),d4	;d4 = 4*4*200*100
	divu	$0006(a3),d4
	cmp 	#$012C,d4		;d4 < 3.00 ly ?
	bcc.s	L813E6
L813E4:	moveq	#$00,d4
L813E6:	ext.l	d4
;-------
	move 	hype_H5_mass(pc),d5	;d5 = mass of H5 drive
	cmp 	$0008(a3),d5
	bcc.s	L81400
	move.l	hype_H5_range(pc),d5	;d5 = 5*5*200*100
	divu	$0006(a3),d5
	cmp 	#$012C,d5		;d5 < 3.00 ly ?
	bcc.s	L81402
L81400:	moveq	#$00,d5
L81402:	ext.l	d5
;-------
	move 	hype_H6_mass(pc),d6	;d6 = mass of H6 drive
	cmp 	$0008(a3),d6
	bcc.s	L8141C
	move.l	hype_H6_range(pc),d6	;d6 = 6*6*200*100
	divu	$0006(a3),d6
	cmp 	#$012C,d6		;d6 < 3.00 ly ?
	bcc.s	L8141E
L8141C:	moveq	#$00,d6
L8141E:	ext.l	d6
;-------
	move 	hype_H7_mass(pc),d7	d7 = mass of H7 drive
	cmp 	$0008(a3),d7
	bcc.s	L81438
	move.l	hype_H7_range(pc),d7	;d7 = 7*7*200*100
	divu	$0006(a3),d7
	cmp 	#$012C,d7		;d7 < 3.00 ly ?
	bcc.s	L8143A
L81438:	moveq	#$00,d7
L8143A:	ext.l	d7
;-------
	bra.w	L8136A
;
L81440:	rts
;
;Next label was originally L81442
;----------------------------------------------------------------------------
	ENDC
;----------------------------------------------------------------------------
L81442:				;for hyper_calc(0,...)
	moveq	#$00,d0
	movea.l	$001C(a6),a1
	jsr 	$0020(a1)
	movem.l	$020C(a6),d4-d5
	move.l	$0344(a6),$0340(a6)
	move.l	$0348(a6),$0344(a6)
	move.l	$02D6(a6),$0348(a6)
	move.l	d6,$02D6(a6)
	lea 	-$0F44(a7),a7
	movea.l	a7,a0
	movem.l	d0-d7/a0/a2-a4,-(a7)
	moveq	#$00,d2
	movea.l	$000C(a6),a1
	jsr 	$0020(a1)
	moveq	#$00,d0
	move.b	$0299(a6),d0
	move 	d0,$28AE(a6)
	moveq	#$00,d1
	move.b	$027A(a6),d0
	subi 	#$000C,d0
	bpl.s	L814A4
	move 	d0,d1
	neg 	d1
	asl 	#3,d1
	mulu 	$026C(a6),d1
	swap	d1
	mulu 	$026C(a6),d1
	swap	d1
L814A4:	move.b	d1,$3429(a6)
	clr.b	$037C(a6)
	movem.l	(a7)+,d0-d7/a0/a2-a4
	moveq	#$01,d2
	movea.l	$000C(a6),a1
	jsr 	$0020(a1)
	lea 	$0F44(a7),a7
	rts

hyper_misjump:
	cmpi.b	#$00,$02C0(a6)
	beq.s	L814D2
	cmpi.b	#$48,$02C0(a6)		;Take_Off mode ?
	beq.s	L814D2
L814D0:	rts

L814D2:	tst.b	$03D1(a6)
	beq.s	L814D0
	cmpi.l	#$00B71B00,$02B4(a6)	;$02B4(a6) >= 12,000,000 ?
	bcs.s	L814D0
;-------------------------------------
	IFNE	(NEW_dispute&NEW_mandate)
;-------------------------------------
	bsr.w	allegiance_x1_d0	;d0 = allegiance
;-------------------------------------
	ELSE
;-------------------------------------
	move 	o_allegiance(a6),d0	;d0 = allegiance
;-------------------------------------
	ENDC
;-------------------------------------
	asl 	#2,d0
	move.l	o_fine_owed(a6),d1	;d1 = fine_owed
	lea 	o_fines_owed_t(a6),a0	;a0 -> fines_owed_t
	move.l	d1,$00(a0,d0)		;fines_owed_t[allegiance] = fine_owed
	move.l	$0414(a6),d1		;d1 = distance
	move 	d1,$363E(a6)
	move.l	$0424(a6),$034C(a6)
	movea.l	$02A2(a6),a0		;a0 = shipobj_p
	moveq	#$02,d0
	bsr.w	hyper_calc		;hyper_calc(2,distance,...) real jump
	tst 	d0
	bmi.s	L814D0
	move.l	d1,$363A(a6)
	clr.l	$008C(a0)
	clr 	$0090(a0)
	move 	d5,$0330(a6)		;hyper_range = d5
	movem.l	$020C(a6),d2-d3
	swap	d1
	move.l	d1,d0
	ext.l	d1
	add.l	d0,d2
	addx.l	d1,d3
	movem.l	d2-d3,$0258(a6)
	move.b	#$08,$02C0(a6)		;shipmode = 8  hyperspacing
	moveq	#$01,d0
	jsr 	$01C2(a5)
	movea.l	$3882(a6),a4		;a4 -> commander_bk1
	clr 	$0254(a6)
	jsr 	$01FE(a5)
	movea.l	$02A2(a6),a0		;a0 = shipobj_p
	moveq	#$4F,d0
	jsr 	$0210(a5)
	clr.b	$0044(a0)
	clr.b	$0045(a0)
	clr.b	$02C4(a6)
	clr.b	$02DC(a6)
	clr.b	$0119(a0)
	move 	#$2000,d0
	jsr 	$001E(a5)		;randmult_d0
	ori 	#$4000,d0
	move 	d0,d6
	moveq	#$33,d7
	bsr.w	L816CC
	movem.l	d0-d1,-(a7)
	moveq	#$13,d0
	moveq	#$02,d1
	jsr 	$017A(a5)
	movem.l	(a7)+,d0-d1
	jsr 	$0018(a5)		;randmash_d0d1
	cmp 	#-$0200,d0
	bhi.s	L815FE
	tst.b	$400E(a6)
	bne.s	L81604
	tst.b	$4010(a6)
	bne.s	L81604
	moveq	#$13,d0
	jsr 	$01C2(a5)
	bsr.w	L81442
	moveq	#$02,d0
	jsr 	$01C2(a5)
	move.l	#$7FFF0033,$04AC(a6)
	move.b	#$72,$049F(a6)
	move.l	$363A(a6),$02D2(a6)
	move.l	#$0F880000,$3892(a6)
	move 	#$0012,$3896(a6)
;-------------------------------------
	IFNE	(NEW_dispute&NEW_mandate)
;-------------------------------------
	bsr.w	allegiance_x1_d0	;d0 = allegiance
;-------------------------------------
	ELSE
;-------------------------------------
	move 	o_allegiance(a6),d0		;d0 = allegiance
;-------------------------------------
	ENDC
;-------------------------------------
	asl 	#2,d0			;d0 = allegiance*4
	move.l	o_fine_owed(a6),d1	;d1 = fine_owed
	lea 	o_fines_owed_t(a6),a0	;a0 -> fines_owed_t
	move.l	$00(a0,d0),o_fine_owed(a6)	;fine_owed=fines_owed_t[allegiance]
	rts

X815EE:	dc.b	$02,$02,$02,$02,$02,$02,$02,$02
	dc.b	$02,$02,$02,$03,$03,$04,$05,$06

L815FE:	move 	#-$6752,-(a7)
	bra.s	L81608

L81604:	move 	#-$6751,-(a7)
L81608:	jsr 	$0018(a5)			; randmash_d0d1
	andi 	#$000F,d0
	moveq	#$00,d1
	move.b	X815EE(pc,d0),d1
	moveq	#$14,d0
	jsr 	$01C2(a5)
	move 	(a7)+,d0
	cmp.b	#$00,d1
	beq.s	L8166A
	cmp.b	#$01,d1
	beq.s	L81668
	cmp.b	#$03,d1
	beq.s	L8165C
	cmp.b	#$05,d1
	beq.s	L8163C
	cmp.b	#$06,d1
	beq.s	L81660
L8163C:	moveq	#-$01,d7
	movea.l	$006C(a6),a1
	jsr 	$0020(a1)
L81646:	move.l	$363A(a6),$02D2(a6)
	move.l	#$0F880000,$3892(a6)
	move 	#$0012,$3896(a6)
	rts

L8165C:	bsr.s	hypersmash_drive
	bra.s	L8163C

L81660:	move.b	$029E(a6),d0			; d0 = shipobjix
	jmp 	$01D4(a5)

L81668:	bsr.s	hypersmash_drive
L8166A:	moveq	#-$01,d7
	movea.l	$006C(a6),a1
	jsr 	$0020(a1)
	bsr.w	L81442
	moveq	#$02,d0
	jsr 	$01C2(a5)
	move 	#$5600,d6
	moveq	#$39,d7
	move.l	$0414(a6),d0
	beq.s	L81692
	move 	d0,d6
	mulu 	#$0151,d6
	moveq	#$3F,d7
L81692:	movea.l	$02A2(a6),a0
	bsr.s	L816CC
	bra.s	L81646

hypersmash_drive:
	moveq	#$00,d0
	move.b	$00A6(a0),d0		;d0 = drive index
	asl 	#3,d0
	lea 	drive_info_t(pc),a1
	move 	$04(a1,d0),d0		;d0 = drive mass
	subi 	#$0004,d0		;d0 -= Interplanetary drive mass
	bmi.s	L816BC			;treat negative as zero
	add 	d0,$032E(a6)
	add 	d0,$02E6(a6)		;cargo_mass += d0
	add 	d0,$02E2(a6)		; baysize += d0
L816BC:	move.b	#$01,$00A6(a0)
	clr 	$0330(a6)		;hyper_range = 0
	move 	#$98B0,d0
	rts

L816CC:	jsr 	$0018(a5)			; randmash_d0d1
	movea.l	a0,a1
	jsr 	$0240(a5)
	clr.b	$0013(a0)
	moveq	#$00,d0
	moveq	#$00,d1
	moveq	#$00,d2
	move.l	d0,$008A(a0)
	move 	d0,$008E(a0)
	movem.l	d0-d2,$0062(a0)
	movem.l	d0-d2,$00C6(a0)
	move.l	d0,$0350(a6)
	rts
;----------------------------------------------------------------------------
;Next label was originally L816FA
;----------------------------------------------------------------------------
