;----------------------------------------------------------------------------
; File name:	BBS.S				Revision date:	1993.09.03
; Revised by:	Ulf Ronald Andersson		Revision start:	1993.08.27
; Created by:	Michtron
; Purpose:	Source code for Michtron 3.0
;----------------------------------------------------------------------------
;
;
	output	.TOS
;
	nolist
;
	include	URAn_DOS.S
;
	text
;
;
;L0:
start_0:
	move.l	sp,pg_entry_sp
	move.l	4(sp),a5
	move.l	a5,pg_basepage_p
	move.l	a5,d0
	add.l	#$100,d0
	move.l	d0,pg_textbeg_p
	add.l	bp_textlen(a5),d0
	move.l	d0,pg_databeg_p
	add.l	bp_datalen(a5),d0
	move.l	d0,a0
	add.l	bp_bss_len(a5),d0
;L32:
.clear_bss:
	move.b	#0,(a0)+
	cmp.l	a0,d0
	bgt.s	.clear_bss
	move.l	d0,L3E7BE
	add.l	#$19000,d0
	cmp.l	sp,d0
	bgt	.ram_error
	move.l	pg_entry_sp,d0
	sub.l	#$800,d0
	move.l	d0,sp
	sub.l	#$200,d0
	move.l	d0,L3E7C2
	move.l	sp,d0
	sub.l	d0,pg_entry_sp
	sub.l	a5,d0
	gemdos	Mshrink,!,(a5),d0
	bios	Setexc,#(etv_critic/4),LF2
	gemdos	Super,!
	move.l	d0,pg_entry_ssp
	move	USP,sp			;Isn't this redundant after Super(0)?
	move.b	(conterm).w,pg_entry_conterm
	andi.b	#$FD,(conterm).w
	jsr	start_1
	move.b	pg_entry_conterm,(conterm).w
	gemdos	Super|_ind,pg_entry_ssp
.LCE:
.exit:
	gemdos	Pterm,!
;
;
.LD6:
.ram_error:
zzSTkeep	set	1
	gemdos	Cconws,out_of_mem_s
zzSTkeep	set	0
.LE2:
	gemdos	Crawcin
	cmp.b	#CR,d0
	bne.s	.LE2
	bra.s	.exit
;
;
;----------------------------------------------------------------------------
;	new etv_critic handler
;
LF2:
	move	4(sp),L18192
	addq	#1,L1819A
	move	#1,taskdos_err_f
	moveq	#0,d0
	rts
;
;
;----------------------------------------------------------------------------
; Func	-------------------------------
;
L10C:
	link	a6,#0
	move.l	8(a6),a0
	move	12(a6),d0
	move	14(a6),d1
	bra	L122
;
L120:
	move.b	d1,(a0)+
L122:
	dbra	d0,L120
	unlk	a6
	rts
;
;
;L12A:
move_bytes:
	move.l	4(sp),a0
	move.l	8(sp),a1
	move	12(sp),d0
	sub	#1,d0
.L13A:
	move.b	(a1)+,(a0)+
	dbra	d0,.L13A
	rts
;
;
;L142:
mask_interrupts:
	move	SR,d0
	or	#$700,SR
	rts
;
;
;L14A:
force_interrupts:
	and	#$F8FF,SR
	rts
;
;
;L150:
set_statusreg:
	move	4(sp),SR
	rts
;
;
L156:
	move.l	4(sp),a0
	move.l	8(sp),a1
	move	SR,-(sp)
	or	#$700,SR
	movem.l	d2-d7/a2-a6,-(sp)
	move.l	sp,(a0)
	move.l	(a1),sp
	movem.l	(sp)+,d2-d7/a2-a6
	rte
;
;
L172:	;Unref.
	move.l	sp,d0
	rts
;
;
L176:
	move.l	4(sp),a0
	move.l	sp,(a0)+
	move.l	a6,(a0)+
	move.l	(sp),(a0)+
	movem.l	d2-d7/a2-a5,(a0)
	clr.l	d0
	rts
;
;
L188:
	move.l	4(sp),a0
	move	8(sp),d0
	ext.l	d0
	move.l	(a0)+,sp
	move.l	(a0)+,a6
	move.l	(a0)+,(sp)
	movem.l	(a0),d2-d7/a2-a5
	rts
;
L19E:
	moveq	#7,d6
L1A0:
	roxl.b	#1,d1
	roxl.w	#1,d0
	bcc.s	L1AA
	eori	#$1021,d0
L1AA:
	dbra	d6,L1A0
	rts
;
;
; Func	-------------------------------
;
L1B0:
	link	a6,#0
	movem.l	d6-d7,-(sp)
	moveq	#0,d0
	move	12(a6),d7
	move.l	8(a6),a0
	bra.s	L1C8
;
L1C4:
	move.b	(a0)+,d1
	bsr.s	L19E
L1C8:
	dbra	d7,L1C4
	moveq	#0,d1
	bsr.s	L19E
	moveq	#0,d1
	bsr.s	L19E
	movem.l	(sp)+,d6-d7
	unlk	a6
	rts
;
;
; Sub.	-------------------------------
;
L1DC:
	move	4(sp),d0
	rol.w	#8,d0
	rts
;
;
; Sub.	-------------------------------
;
L1E4:	;Unref.
	move.l	4(sp),d0
	rol.w	#8,d0
	swap	d0
	rol.w	#8,d0
	rts
;
;
; Data	-------------------------------
;
;L1F0:
bbs_palette_bbs_s:
	dc.b	'\bbs\palette.bbs',NUL
	even
;L202:
palette_bbs_fh:
	dc.w	0
;L204:
start_rez:
	dc.w	0
;L206:
bbs_rez:
	dc.w	0
L208:
	dcb.w	5,0
;
	dc.b	'COLORS'
	even
L218:
	dc.w	$0777,$0700,$0007,$0000
	dc.b	'ENDCOLORS'
	even
;
L22A:
physbase_p:
	dc.l	0
;
;
; Sound	-------------------------------
;
L22E:
	include	SND_22E.S
;
;
; Sub.	-------------------------------
;
zzDUMBcomp	set	1
;
L24C:
	move.l	a0,-(sp)
	xbios	Dosound,L22E
	move.l	(sp)+,a0
	rts
;
zzDUMBcomp	set	0
;
; Data	-------------------------------
;
;L262:
lineoffs_t:
	dc.w	00*1280,01*1280,02*1280,03*1280
	dc.w	04*1280,05*1280,06*1280,07*1280
	dc.w	08*1280,09*1280,10*1280,11*1280
	dc.w	12*1280,13*1280,14*1280,15*1280
	dc.w	16*1280,17*1280,18*1280,19*1280
	dc.w	20*1280,21*1280,22*1280,23*1280
	dc.w	24*1280
;
;
L294:
	movem.l	d0-d7/a0-a6,-(sp)
	xbios	Getrez
	move	d0,start_rez
	tst	d0
	bne	L2B0
	move	#1,d0
L2B0:
	move	d0,bbs_rez
	xbios	Setscreen,?,?,d0
	nop
zzSToff	set	2
	xbios	Cursconf,!,()			;Hide cursor
zzSToff	set	0
;
zzDUMBcomp	set	1
;
	gemdos	Fopen,bbs_palette_bbs_s,!
	move	d0,palette_bbs_fh
	tst	d0
	bmi	L34A
	gemdos	Fread,d0,#10,L208
	cmp.l	#$A,d0
	bne	L33A
	lea	L208,a0
	lea	L218,a1
	move	(a0)+,d0
	cmp	bbs_rez,d0
	bne	L33A
	move	(a0)+,(a1)+
	move	(a0)+,(a1)+
	move	(a0)+,(a1)+
	move	(a0)+,(a1)+
L33A:
	gemdos	Fclose,palette_bbs_fh
;
zzDUMBcomp	set	0
;
L34A:
	movem.l	d3/a3,-(sp)
	lea	L218,a3
	clr	d3
L356:
	xbios	Setcolor,d3,(a3)
	move	d0,(a3)+
	add	#1,d3
	cmp	#4,d3
	blt.s	L356
	movem.l	(sp)+,d3/a3
	xbios	Physbase
	move.l	d0,physbase_p
	movem.l	(sp)+,d0-d7/a0-a6
	rts
;
;
L386:
	movem.l	d0-d7/a0-a6,-(sp)
	xbios	Setscreen,?,?,start_rez
	nop
	lea	L218,a3
	clr	d3
L3B0:
	xbios	Setcolor,d3,(a3)
	move	d0,(a3)+
	add	#1,d3
	cmp	#4,d3
	blt.s	L3B0
	movem.l	(sp)+,d0-d7/a0-a6
	rts
;
;
;L3CE:
calc_offset_text_screenad:
	move.l	a1,-(sp)
	ext.l	d0
	divs	#160,d0
	lsl.w	#1,d0		;d0 = (text_offset/160)*2
	lea	lineoffs_t,a1
	move	0(a1,d0.w),a1	;a1 -> screenad of text row #
	swap	d0
	lsr.w	#1,d0		;d0 = column index in above row
	cmpi	#2,start_rez	;Hi-rez ?
	beq	.L40A		;Go .L40A for hi-rez, stay for med-rez
	move	d0,d1
	and	#$FFFE,d1
	adda	d1,a1
	adda	d1,a1
	move	d0,d1
	and	#1,d1
	adda	d1,a1
	move.l	a1,d0
	move.l	(sp)+,a1
	rts
;
.L40A:
	adda	d0,a1
	move.l	a1,d0		;d0 = a1 -> screenad for text offset
	move.l	(sp)+,a1
	rts
;
;
;L412:
calc_indexed_text_screenad:
	move	(a0),d1		;d1 = a0[0]  (text row #)
	lsl.w	#1,d1
	lea	lineoffs_t,a1
	move	0(a1,d1.w),a1
	adda.l	physbase_p,a1	;a1 -> text row base address on screen
	cmpi	#2,start_rez	;Hi-rez ?
	beq	.L44C		;Go .L44C for hi-rez, but stay for med-rez
	move	2(a0),d1	;d1 = a0[1]  (text column #)
	and	#$FFFE,d1	;d1 = truncated to even column #
	adda	d1,a1
	adda	d1,a1		;a1 -> bitplane 0 of 16 pix group
	move	2(a0),d1	;d1 = a0[1]  (text column #)
	and	#1,d1
	adda	d1,a1		;a1 += 1 if column # is odd
	move.l	a1,a0		;a0 = a1  (-> text positioned screen address)
	rts
;
.L44C:
	adda	2(a0),a1	;a1 += a0[1]  (row base + column #)
	move.l	a1,a0		;a0 = a1  (-> text positioned screen address)
	rts
;
;
;L454:
trans_screen_out_d0:
	cmp	#$720,d0
	bne.s	screen_out_d0
	cmpi	#2,start_rez
	beq.s	.L4DC
	bra.s	.L4A6
;
;L466:
screen_out_d0:
	cmpi	#2,start_rez		;Hi-rez ?
	beq	.L4AE			;Go .L4AE for hi-rez, stay for med-rez
	movem.l	d2-d3/a0-a1,-(sp)
	move	d0,d2
	and	#$700,d2
	seq	d2
	lea	LF9E,a1			;patch font_1_ptr here
	and	#$7F,d0			;patch font_1_limit here
	lsl.w	#3,d0
	adda	d0,a1
	move	#160,d1			;d1 = bytes/line
	moveq	#8-1,d0			;d0 = font height
.L492:
	move.b	(a1)+,d3
	eor.b	d2,d3
	move.b	d3,(a0)
	move.b	d3,2(a0)
	adda	d1,a0
	dbra	d0,.L492		;loop for each line of char
	movem.l	(sp)+,d2-d3/a0-a1
.L4A6:
	adda	d4,a0
	eori	#2,d4
	rts
;
.L4AE:
	movem.l	d2-d3/a0-a1,-(sp)
	move	d0,d2
	and	#$700,d2
	seq	d2
	lea	L79E,a1			;patch font_2_ptr here
	and	#$7F,d0			;patch font_2_limit here
	lsl.w	#4,d0
	adda	d0,a1
	moveq	#80,d1			;d1 = bytes/line
	moveq	#16-1,d0		;d0 = font height
.L4CC:
	move.b	(a1)+,d3
	eor.b	d2,d3
	move.b	d3,(a0)
	adda	d1,a0
	dbra	d0,.L4CC		;loop for each line of char
	movem.l	(sp)+,d2-d3/a0-a1
.L4DC:
	adda	#1,a0
	rts
;
;
;L4E2:
invert_char:
	cmpi	#2,start_rez	;Hi-rez ?
	beq.s	.L500		;go .L500 for hi-rez, stay for med-rez
	move	#160,d1		;d1=bytes/line
	moveq	#8-1,d0		;d0=font height - 1
.L4F2:
	not.b	(a0)		;invert 8 pix on bitplane 0
	not.b	2(a0)		;invert 8 pix on bitplane 1
	adda	d1,a0		;step to next scanline
	dbra	d0,.L4F2	;loop
	rts
;
.L500:
	moveq	#80,d1		;d1=bytes/line
	moveq	#16-1,d0	;d0=font height - 1
.L504:
	not.b	(a0)		;invert 8 pix on the monoplane
	adda	d1,a0		;step to next scanline
	dbra	d0,.L504	;loop
	rts
;
;
; Sub.	-------------------------------
;
L50E:
	move.l	4(sp),a0
	move.l	8(sp),a1
	move	#$6DF,d1
.L51A:
	move	(a1)+,d0
	move.b	d0,(a0)+
	dbra	d1,.L51A
	rts
;
;
; Func	-------------------------------
;
;L524:
transfer_screen:
	link	a6,#0
	movem.l	d0-d7/a0-a5,-(sp)
	move.l	physbase_p,a0
	adda	#$F00,a0		;add offset for top 3 text rows
	moveq	#0,d1
	move	#$370-1,d0		;(screen_size-offset)/32-1
L53C:
	move.l	d1,(a0)+
	move.l	d1,(a0)+
	move.l	d1,(a0)+
	move.l	d1,(a0)+
	move.l	d1,(a0)+
	move.l	d1,(a0)+
	move.l	d1,(a0)+
	move.l	d1,(a0)+
	dbra	d0,L53C
	move.l	8(a6),a0
	lea	22(a0),a2
	move.l	physbase_p,a0
	adda	#$F00,a0		;add offset for top 3 text rows
	move	#22-1,d3		;prep d3 to move 22 lines
.L566:
	move.l	a0,-(sp)
	move	#80-1,d2		;prep d2 to move 80 char/line
	move	#1,d4
.L570:
	move	(a2)+,d0
	bsr	trans_screen_out_d0
	dbra	d2,.L570		;loop to complete a line
	move.l	(sp)+,a0
	adda	#$500,a0
	dbra	d3,.L566		;loop to complete all lines
	move.l	8(a6),a0
	bsr	calc_indexed_text_screenad
	adda	#$F00,a0		;add offset for top 3 text rows
	bsr	invert_char		;show cursor
	movem.l	(sp)+,d0-d7/a0-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L59C:
	link	a6,#0
	movem.l	d0-d7/a0-a5,-(sp)
	lea	8(a6),a0
	bsr	calc_indexed_text_screenad
	move	14(a6),d0
	move.b	13(a6),d0
	bsr	screen_out_d0
	movem.l	(sp)+,d0-d7/a0-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5C0:
	link	a6,#0
	movem.l	d0-d7/a0-a5,-(sp)
L5C8:
	move.l	14(a6),a0
	tst.b	(a0)
	beq	L5F8
	lea	8(a6),a0
	bsr	calc_indexed_text_screenad
	move	12(a6),d0
	move.l	14(a6),a1
	move.b	(a1),d0
	bsr	screen_out_d0
	addi.l	#1,14(a6)
	addi	#1,10(a6)
	bra.s	L5C8
;
L5F8:
	movem.l	(sp)+,d0-d7/a0-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L600:
	link	a6,#0
	movem.l	d0-d7/a0-a5,-(sp)
	tst	20(a6)
	beq	L67E
	move.l	physbase_p,a0
	adda	#$F00,a0		;add offset for top 3 text rows
	move.l	a0,a1
	move	12(a6),d0
	bsr	calc_offset_text_screenad
	adda	d0,a1
	move	14(a6),d0
	bsr	calc_offset_text_screenad
	adda	d0,a0
	move	16(a6),d1
	move	d1,d0
	subq	#1,d1
	cmp.l	a1,a0
	bgt	L662
	lsl.w	#4,d0
	adda	d0,a0
	adda	d0,a1
L644:
	move.l	-(a0),-(a1)
	move.l	-(a0),-(a1)
	move.l	-(a0),-(a1)
	move.l	-(a0),-(a1)
	dbra	d1,L644
	moveq	#0,d0
	moveq	#79,d1
L654:
	move.l	d0,-(a1)
	move.l	d0,-(a1)
	move.l	d0,-(a1)
	move.l	d0,-(a1)
	dbra	d1,L654
	bra.s	L67E
;
L662:
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	dbra	d1,L662
	moveq	#0,d0
	moveq	#79,d1
L672:
	move.l	d0,(a1)+
	move.l	d0,(a1)+
	move.l	d0,(a1)+
	move.l	d0,(a1)+
	dbra	d1,L672
L67E:
	move.l	8(a6),a1
	lea	22(a1),a1
	move.l	a1,a0
	adda	12(a6),a1
	adda	14(a6),a0
	move	16(a6),d1
	cmp.l	a1,a0
	bgt	L6C0
	move	d1,d0
	add	d0,d0
	adda	d0,a0
	adda	d1,a1
	subq	#1,d1
L6A4:
	move	-(a0),-(a1)
	dbra	d1,L6A4
	move	#$4F,d1
	move	18(a6),d0
L6B2:
	move	d0,-(a1)
	dbra	d1,L6B2
	movem.l	(sp)+,d0-d7/a0-a5
	unlk	a6
	rts
;
;
L6C0:
	subq	#1,d1
L6C2:
	move	(a0)+,(a1)+
	dbra	d1,L6C2
	move	#$4F,d1
	move	18(a6),d0
L6D0:
	move	d0,(a1)+
	dbra	d1,L6D0
	movem.l	(sp)+,d0-d7/a0-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6DE:
	link	a6,#0
	movem.l	d0-d7/a0-a5,-(sp)
	tst	18(a6)
	beq	L716
	move.l	physbase_p,a0
	adda	#$F00,a0		;add offset for top 3 text rows
	move	12(a6),d0
	bsr	calc_offset_text_screenad
	adda	d0,a0
	moveq	#0,d0
	move	14(a6),d1
	subq	#1,d1
L70A:
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	dbra	d1,L70A
L716:
	move.l	8(a6),a0
	lea	22(a0),a0
	adda	12(a6),a0
	move	14(a6),d1
	subq	#1,d1
	move	16(a6),d0
L72C:
	move	d0,(a0)+
	dbra	d1,L72C
	movem.l	(sp)+,d0-d7/a0-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L73A:
user_conout_0:
	link	a6,#0
	movem.l	d0-d7/a0-a5,-(sp)
	tst	16(a6)
	beq	.L766
	move.l	physbase_p,a0
	adda	#$F00,a0		;add offset for top 3 text rows
	move	12(a6),d0
	bsr	calc_offset_text_screenad
	adda	d0,a0
	move	14(a6),d0
	bsr	screen_out_d0
.L766:
	move.l	8(a6),a0
	lea	22(a0),a0
	adda	12(a6),a0
	move	14(a6),(a0)
	movem.l	(sp)+,d0-d7/a0-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L77E:
invert_cursor:
	link	a6,#0
	movem.l	d0-d7/a0-a5,-(sp)
	lea	8(a6),a0
	bsr	calc_indexed_text_screenad
	adda	#$F00,a0		;add offset for top 3 text rows
	bsr	invert_char
	movem.l	(sp)+,d0-d7/a0-a5
	unlk	a6
	rts
;
;
;
; Hires font	-----------------------
;
L79E:
	include	BBS_HFNT.S
;
;
; Medres font	-----------------------
;
LF9E:
	include	BBS_MFNT.S
;
;
; Func	-------------------------------
;
;L139E:
task_Fclose:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
zzSToff	set	2
	gemdos	Fclose,8(a6)
zzSToff	set	0
	move	d0,-2(a6)
	tst	taskdos_err_f
	beq	.L13DA
	clr	taskdos_err_f
	move	#$FFE2,-2(a6)
.L13DA:
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L13EE:
task_Fopen:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
zzSToff	set	2
	gemdos	Fopen|_ind,8(a6),12(a6)
zzSToff	set	0
	move	d0,-2(a6)
	tst	taskdos_err_f
	beq	.L142E
	clr	taskdos_err_f
	move	#$FFE2,-2(a6)
.L142E:
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1442:
task_Fcreate:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
zzSToff	set	2
	gemdos	Fcreate|_ind,8(a6),!
zzSToff	set	0
	move	d0,-2(a6)
	tst	taskdos_err_f
	beq	.L1480
	clr	taskdos_err_f
	move	#$FFE2,-2(a6)
.L1480:
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1494:
task_Fdelete:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
zzSToff	set	4
	gemdos	Fdelete|_ind,8(a6)
zzSToff	set	0
	move	d0,-2(a6)
	tst	taskdos_err_f
	beq	.L14D0
	clr	taskdos_err_f
	move	#$FFE2,-2(a6)
.L14D0:
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L14E4:
task_Frename:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
zzSToff	set	4
	gemdos	Frename|_ind,!,8(a6),12(a6)
zzSToff	set	0
	move	d0,-2(a6)
	tst	taskdos_err_f
	beq	.L1526
	clr	taskdos_err_f
	move	#$FFE2,-2(a6)
.L1526:
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L153A:
task_Fseek:
	link	a6,#-8
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
zzSToff	set	2
	gemdos	Fseek,10(a6),8(a6),14(a6)
zzSToff	set	0
	move.l	d0,-4(a6)
	tst	taskdos_err_f
	beq	.L1580
	clr	taskdos_err_f
	move.l	#$FFFFFFFF,-4(a6)
.L1580:
	move	L468CA,(sp)
	jsr	L3852
	move.l	-4(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1594:
task_Fread:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
	move.l	10(a6),(sp)
	move	14(a6),a0
	move.l	a0,-(sp)
	move	8(a6),-(sp)
	move	#$3F,-(sp)	;gemdos Fread|_ind,8(a6),(long)14(a6),10(a6)
	trap	#1
	addq.l	#8,sp
	move	d0,-2(a6)
	tst	taskdos_err_f
	beq	.L15DA
	clr	taskdos_err_f
	move	#$FFE2,-2(a6)
.L15DA:
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L15EE:
task_Fwrite:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
	move.l	10(a6),(sp)
	move	14(a6),a0
	move.l	a0,-(sp)
	move	8(a6),-(sp)
	move	#$40,-(sp)	;gemdos	Fwrite|_ind,8(a6),(long)14(a6),10(a6)
	trap	#1
	addq.l	#8,sp
	move	d0,-2(a6)
	tst	taskdos_err_f
	beq	.L1634
	clr	taskdos_err_f
	move	#$FFE2,-2(a6)
.L1634:
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1648:
task_Tgettime:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
zzSToff	set	2
	gemdos	Tgettime
zzSToff	set	0
	move	d0,-2(a6)
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	move	#$B,d1
	lsr.w	d1,d0
	and	#$1F,d0
	move.l	8(a6),a1
	move	d0,(a1)
	move	-2(a6),d0
	lsr.w	#5,d0
	and	#$3F,d0
	move.l	12(a6),a1
	move	d0,(a1)
	move	-2(a6),d0
	and	#$1F,d0
	lsl.w	#1,d0
	move.l	16(a6),a1
	move	d0,(a1)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L16A6:
task_Tsettime:
	link	a6,#-8
	move	8(a6),d0
	and	#$1F,d0
	move	#$B,d1
	asl.w	d1,d0
	move	10(a6),d1
	and	#$3F,d1
	asl.w	#5,d1
	add	d1,d0
	move	12(a6),d1
	asr.w	#1,d1
	and	#$1F,d1
	add	d1,d0
	move	d0,-2(a6)
	move	L468CA,(sp)
	jsr	L3976
zzSToff	set	2
	gemdos	Tsettime,-2(a6)
zzSToff	set	0
	move	d0,-4(a6)
	move	L468CA,(sp)
	jsr	L3852
	move	-4(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1704:
task_Tgetdate:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
zzSToff	set	2
	gemdos	Tgetdate
zzSToff	set	0
	move	d0,-2(a6)
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	lsr.w	#5,d0
	and	#$F,d0
	move.l	8(a6),a1
	move	d0,(a1)
	move	-2(a6),d0
	and	#$1F,d0
	move.l	12(a6),a1
	move	d0,(a1)
	move	-2(a6),d0
	move	#9,d1
	lsr.w	d1,d0
	and	#$7F,d0
	add	#$7BC,d0
	move.l	16(a6),a1
	move	d0,(a1)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1764:
task_Tsetdate:
	link	a6,#-8
	move	12(a6),d0
	add	#$F844,d0
	and	#$7F,d0
	move	#9,d1
	asl.w	d1,d0
	move	8(a6),d1
	and	#$F,d1
	asl.w	#5,d1
	add	d1,d0
	move	10(a6),d1
	and	#$1F,d1
	add	d1,d0
	move	d0,-4(a6)
	move	L468CA,(sp)
	jsr	L3976
zzSToff	set	2
	gemdos	Tsetdate,-4(a6)
zzSToff	set	0
	move	d0,-2(a6)
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L17C4:
task_Fsetdta:
	link	a6,#-4
	move	L468CA,(sp)
	jsr	L3976
zzSToff	set	4
	gemdos	Fsetdta|_ind,8(a6)
zzSToff	set	0
	move	L468CA,(sp)
	jsr	L3852
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L17F0:
task_Fsfirst:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
zzSToff	set	2
	gemdos	Fsfirst|_ind,8(a6),12(a6)
zzSToff	set	0
	tst.l	d0
	beq	.L1822
	clr	d0
	bra	.L1826
;
.L1822:
	move	#1,d0
.L1826:
	move	d0,-2(a6)
	tst	taskdos_err_f
	beq	.L1840
	clr	d0
	move	d0,-2(a6)
	move	d0,taskdos_err_f
.L1840:
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1854:
task_Fsnext:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
zzSToff	set	2
	gemdos	Fsnext
zzSToff	set	0
	tst.l	d0
	beq	.L187C
	clr	d0
	bra	.L1880
;
.L187C:
	move	#1,d0
.L1880:
	move	d0,-2(a6)
	tst	taskdos_err_f
	beq	.L189A
	clr	d0
	move	d0,-2(a6)
	move	d0,taskdos_err_f
.L189A:
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L18AE:
task_Dcreate:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
zzSToff	set	4
	gemdos	Dcreate|_ind,10(a6)
zzSToff	set	0
	move	d0,-2(a6)
	tst	taskdos_err_f
	beq	.L18EA
	clr	taskdos_err_f
	move	#$FFE2,-2(a6)
.L18EA:
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L18FE:	;Unref.
	link	a6,#-8
	move	L468CA,(sp)
	jsr	L3976
	move	#$19,(sp)
	trap	#1
	move	d0,-2(a6)
	move	8(a6),(sp)
	subi	#1,(sp)
	move	#$E,-(sp)
	trap	#1
	addq.l	#2,sp
	clr	taskdos_err_f
	move.l	10(a6),(sp)
	move	#$3B,-(sp)
	trap	#1
	addq.l	#2,sp
	move	d0,-4(a6)
	tst	taskdos_err_f
	beq	.L1954
	clr	taskdos_err_f
	move	#$FFE2,-4(a6)
.L1954:
	move	-2(a6),(sp)
	move	#$E,-(sp)
	trap	#1
	addq.l	#2,sp
	move	L468CA,(sp)
	jsr	L3852
	move	-4(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1974:	;Unref.
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
zzSToff	set	2
	gemdos	Dgetpath|_ind,10(a6),8(a6)
zzSToff	set	0
	move	d0,-2(a6)
	tst	taskdos_err_f
	beq	.L19BA
	clr	taskdos_err_f
	move	#$FFE2,-2(a6)
	move.l	10(a6),a0
	clr.b	(a0)
.L19BA:
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L19CE:
task_Dgetdrv:
	link	a6,#-6
	move	L468CA,(sp)
	jsr	L3976
zzSToff	set	2
	gemdos	Dgetdrv
zzSToff	set	0
	move	d0,-2(a6)
	move	L468CA,(sp)
	jsr	L3852
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L19FC:
task_Fgetdatime:
	link	a6,#-8
	move	L468CA,(sp)
	jsr	L3976
	clr	(sp)
	move	8(a6),-(sp)
	move.l	a6,-(sp)
	subi.l	#4,(sp)
	move	#$57,-(sp)	;gemdos Fdatime|_ind,-4(a6),8(a6),!
	trap	#1
	addq.l	#8,sp
	move.l	14(a6),a0
	move	-4(a6),(a0)
	move.l	10(a6),a0
	move	-2(a6),(a0)
	move	L468CA,(sp)
	jsr	L3852
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1A42:
task_Fsetdatime:
	link	a6,#-8
	move	L468CA,(sp)
	jsr	L3976
	move	12(a6),-4(a6)
	move	10(a6),-2(a6)
	move	#1,(sp)
	move	8(a6),-(sp)
	move.l	a6,-(sp)
	subi.l	#4,(sp)
	move	#$57,-(sp)	;gemdos Fdatime|_ind,-4(a6),8(a6),#1
	trap	#1
	addq.l	#8,sp
	move	L468CA,(sp)
	jsr	L3852
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1A86:	;Unref.
	link	a6,#0
	gemdos	Fclose,8(a6)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1A9A:	;Unref.
	link	a6,#0
	gemdos	Fopen|_ind,8(a6),12(a6)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1AB2:	;Unref.
	link	a6,#0
	gemdos	Fcreate|_ind,8(a6),!
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1AC8:
task_Dfree:
	link	a6,#-16
	movem.l	d5-d7,-(sp)
	move	L468CA,(sp)
	jsr	L3976
	clr	taskdos_err_f
	move	8(a6),(sp)
	move.l	a6,-(sp)
	addi.l	#$FFFFFFF0,(sp)
	move	#$36,-(sp)	;gemdos Dfree|_ind,-16(a6),8(a6)
	trap	#1
	addq	#6,sp
	move	d0,d7
	lea	-16(a6),a0
	move.l	10(a6),a1
	moveq	#3,d1
.L1B02:
	move.l	(a0)+,d0
	move	d0,(a1)+
	dbra	d1,.L1B02
	tst	taskdos_err_f
	beq	.L1B1C
	clr	taskdos_err_f
	moveq	#-30,d7
.L1B1C:
	move	L468CA,(sp)
	jsr	L3852
	move	d7,d0
	tst.l	(sp)+
	movem.l	(sp)+,d6-d7
	unlk	a6
	rts
;
;
;----------------------------------------------------------------------------
;	BIOS function interpreter
;
L1B34:
	addq	#1,L181DE
	move	(sp),d0
	lea	6(sp),a0
	btst	#13,d0
	bne.s	.L1B48
	move	USP,a0
.L1B48:
	lea	32(a0),a0
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	pea	.L1B6A(pc)
	move	SR,-(sp)
	move.l	old_bios_p,a0
	jmp	(a0)
;
.L1B6A:
	lea	32(sp),sp
	subq	#1,L181DE
	rte
;
;
;----------------------------------------------------------------------------
;	XBIOS function interpreter
;
L1B76:
	addq	#1,L181DE
	move	(sp),d0
	lea	6(sp),a0
	btst	#13,d0
	bne.s	L1B8A
	move	USP,a0
L1B8A:
	lea	32(a0),a0
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	move.l	-(a0),-(sp)
	pea	L1BAE
	move	SR,-(sp)
	move.l	old_xbios_p,a0
	jmp	(a0)
;
L1BAE:
	lea	32(sp),sp
	subq	#1,L181DE
	rte
;
;
;----------------------------------------------------------------------------
;
;
L1BBA:
	moveq	#1,d0
	move	d0,L181DC
	rts
;
L1BC4:
	moveq	#0,d0
	move	d0,L181DC
	rts
;
;
;----------------------------------------------------------------------------
;	Timer A interrupt routine (Multitask clock)
;
L1BCE:
	or	#$700,SR
	bclr	#5,$FFFFFA0F.w
	movem.l	d0-d7/a0-a6,-(sp)
	subi	#1,L181D6
	bpl.s	L1BFA
	jsr	L4164
	jsr	tx_polls_r
	move	#$32,L181D6
L1BFA:
	tst	L181DE
	bne.s	L1C38
	tst	L181DC
	bne.s	L1C38
	subq	#1,L181DA
	bpl.s	L1C32
	move	#5,L181DA
	tst	L3673E
	beq.s	L1C32
	move.l	L315E2,a0
	subq	#1,(a0)
	bpl.s	L1C32
	jsr	L3B00
L1C32:
	jsr	L34EE
L1C38:
	movem.l	(sp)+,d0-d7/a0-a6
	rte
;
;
;----------------------------------------------------------------------------
;
;
; Sub.	-------------------------------
;
;L1C3E:
use_bbs_vectors_1:
zzDUMBcomp	set	1
	bios	Setexc,#(ev_xbios/4),?
	move.l	d0,old_xbios_p
	bios	Setexc,#(ev_xbios/4),L1B76
	bios	Setexc,#(ev_bios/4),?
	move.l	d0,old_bios_p
	bios	Setexc,#(ev_bios/4),L1B34
zzDUMBcomp	set	0
	bios	Setexc,#(iv_time_a/4),?
	move.l	d0,old_iv_time_a_p
	xbios	Xbtimer,!,#7,#$F6,L1BCE
	nop
	lea	$FFFFFA01.w,a0
	bset	#5,6(a0)		;set MFP IERA to allow timer A IRQ
	rts
;
;
; Sub.	-------------------------------
;
;L1CDA:
use_old_vectors_1:
	lea	$FFFFFA01.w,a0
	bclr	#5,18(a0)		;set MFP IMRA to prevent timer A IRQ
zzDUMBcomp	set	1
	bios	Setexc|_ind,#(ev_bios/4),old_bios_p
	bios	Setexc|_ind,#(ev_xbios/4),old_xbios_p
zzDUMBcomp	set	0
	bios	Setexc|_ind,#(iv_time_a/4),old_iv_time_a_p
	rts
;
;
; Sub.	-------------------------------
;
L1D20:
	move	8(a6),d0
	lsl.w	#2,d0
	lea	L181E0,a0
	move.l	0(a0,d0.w),a0
	lea	L181F8,a2
	move.l	0(a2,d0.w),a2
	rts
;
;
; Sub.	-------------------------------
;
L1D3C:
	move	8(a0),d2
	move	6(a0),d1
	cmp	d1,d2
	bhi.s	.L1D4C
	add	4(a0),d2
.L1D4C:
	sub	d1,d2
	rts
;
;
; Sub.	-------------------------------
;
L1D50:
	move	SR,-(sp)
	or	#$700,SR
	btst	#0,32(a0)
	beq.s	.L1D64
	tst.b	31(a0)
	bne.s	.L1D7C
.L1D64:
	btst	#7,44(a2)
	beq.s	.L1D7C
	move	20(a0),d2
	cmp	22(a0),d2
	bne.s	.L1D7C
	move.b	d1,46(a2)
	bra.s	.L1D98
;
.L1D7C:
	move	22(a0),d2
	addq	#1,d2
	and	#$1FF,d2
	cmp	20(a0),d2	;buffer full ?
	beq.s	.L1DA0
	move.l	14(a0),a1
	move.b	d1,0(a1,d2.w)	;store word char d1 in buffer
	move	d2,22(a0)
.L1D98:
	move	(sp)+,SR
	and	#$FE,CCR	;clear carry
	rts
;
.L1DA0:
	move	(sp)+,SR
	or	#1,CCR		;set carry
	rts
;
;
; Sub.	-------------------------------
;
L1DA8:
	move	SR,-(sp)
	or	#$700,SR
	move	22(a0),d2
	addq	#1,d2
	and	#$1FF,d2
	cmp	20(a0),d2
	beq.s	.L1DD6
	move.l	14(a0),a1
	move.b	d1,0(a1,d2.w)
	move	d2,22(a0)
	tst.b	17416(a2)
	move	(sp)+,SR
	and	#$FE,CCR
	rts
;
.L1DD6:
	move	(sp)+,SR
	or	#1,CCR
	rts
;
;
; Sub.	-------------------------------
;
L1DDE:
	move	SR,-(sp)
	or	#$700,SR
	move	6(a0),d2
	cmp	8(a0),d2
	beq	L1E04
	addq	#1,d2
	and	#$1FF,d2
	move.l	0(a0),a1
	moveq	#0,d0
	move.b	0(a1,d2.w),d0
	move	d2,6(a0)
L1E04:
	move	(sp)+,SR
	rts
;
L1E08:
	move	SR,-(sp)
	or	#$700,SR
	move	6(a0),d1
	cmp	8(a0),d1
	beq.s	L1E34
	addq	#1,d1
	and	#$1FF,d1
	move.l	0(a0),a1
	moveq	#0,d0
	move.b	0(a1,d1.w),d0
	move	d1,6(a0)
	move	(sp)+,SR
	and	#$FE,CCR
	bra.s	L1E3A
;
L1E34:
	move	(sp)+,SR
	or	#1,CCR
L1E3A:
	btst	#0,32(a0)
	beq.s	L1E5C
	tst.b	30(a0)
	beq.s	L1E5C
	bsr	L1D3C
	cmp	10(a0),d2
	bne.s	L1E5C
	moveq	#17,d1
	bsr	L1D50
	clr.b	30(a0)
L1E5C:
	rts
;
L1E5E:
	move	SR,-(sp)
	or	#$700,SR
	move	6(a0),d2
	cmp	8(a0),d2
	beq.s	L1E8A
	addq	#1,d2
	and	#$1FF,d2
	move.l	0(a0),a1
	moveq	#0,d0
	move.b	0(a1,d2.w),d0
	move	d2,6(a0)
	move	(sp)+,SR
	and	#$FE,CCR
	bra.s	L1E90
;
L1E8A:
	move	(sp)+,SR
	or	#1,CCR
L1E90:
	btst	#0,32(a0)
	beq.s	L1EB8
	tst.b	30(a0)
	beq.s	L1EB8
	bsr	L1D3C
	cmp	10(a0),d2
	bne.s	L1EB8
	move.b	#17,33(a0)
	tst.b	17416(a2)
	move.b	#0,30(a0)
L1EB8:
	rts
;
;
;----------------------------------------------------------------------------
;
;
;L1EBA:
new_kb_handler:
	pea	L1EC6(pc)
	move.l	old_kb_handler_p,-(sp)
	rts
;
L1EC6:
	move	SR,-(sp)
	or	#$700,SR
	movem.l	d0-d2/a0-a2,-(sp)
	tst	L182E0
	bne	L1F80
L1EDA:
	move.l	kb_iorec_p,a0
	move	6(a0),d1
	cmp	8(a0),d1
	beq	L1F80
	addq	#4,d1
	cmp	4(a0),d1
	bcs.s	L1EF6
	moveq	#0,d1
L1EF6:
	move	d1,6(a0)
	move.l	0(a0),a1
	move.l	0(a1,d1.w),d0
	tst	d0
	bne	L1F16
	lsr.l	#8,d0
	move	d0,-(sp)
	jsr	L6E1C
	addq	#2,sp
	bra.s	L1EDA
;
L1F16:
	move	L468CC,d1
	cmp	#5,d1
	bhi.s	L1EDA
	lsl.w	#2,d1
	lea	L181E0,a0
	move.l	0(a0,d1.w),a0
	btst	#0,32(a0)
	beq.s	L1F5E
	cmp.b	#19,d0
	bne.s	L1F44
	move.b	#60,31(a0)
	bra.s	L1EDA
;
L1F44:
	cmp.b	#17,d0
	bne.s	L1F5E
	clr.b	31(a0)
	lea	tx_poll_t,a0
	move.l	0(a0,d1.w),a0
	jsr	(a0)
	bra	L1EDA
;
L1F5E:
	move	8(a0),d2
	addq	#1,d2
	and	#$1FF,d2
	cmp	6(a0),d2
	beq	L1EDA
	move.l	0(a0),a2
	move.b	d0,0(a2,d2.w)
	move	d2,8(a0)
	bra	L1EDA
;
L1F80:
	movem.l	(sp)+,d0-d2/a0-a2
	rte
;
;
;----------------------------------------------------------------------------
;
;
;L1F86:
new_iv_v24rreq:
	movem.l	d0-d2/a0-a2,-(sp)
	lea	L18232,a0
	lea	$FFFFFA01.w,a2
	move.b	42(a2),28(a0)
	btst	#7,28(a0)
	beq.s	L2014
	move.b	46(a2),d0
	btst	#0,32(a0)
	beq.s	L1FCA
	cmp.b	#19,d0
	bne	L1FBE
	move.b	#60,31(a0)
	bra.s	L2014
;
L1FBE:
	cmp.b	#17,d0
	bne.s	L1FCA
	clr.b	31(a0)
	bra.s	L200A
;
L1FCA:
	move	8(a0),d1
	addq	#1,d1
	and	#$1FF,d1
	cmp	6(a0),d1
	beq.s	L2014
	move.l	0(a0),a1
	move.b	d0,0(a1,d1.w)
	move	d1,8(a0)
	bsr	L1D3C
	cmp	12(a0),d2
	bne.s	L2014
	btst	#0,32(a0)
	beq.s	L2014
	tst.b	30(a0)
	bne.s	L2014
	move.b	#255,30(a0)
	move.b	#19,33(a0)
L200A:
	tst.b	44(a2)
	bpl.s	L2014
	bsr	transmit_mod1
L2014:
	bclr	#4,14(a2)
	movem.l	(sp)+,d0-d2/a0-a2
	rte
;
;
;----------------------------------------------------------------------------
;
;
;L2020:
new_iv_v24treq:
	movem.l	d0-d2/a0-a2,-(sp)
	lea	L18232,a0
	lea	$FFFFFA01.w,a2
	bsr	transmit_mod1
	bclr	#2,14(a2)
	movem.l	(sp)+,d0-d2/a0-a2
	rte
;
;
;----------------------------------------------------------------------------
;
;
;L203E:
transmit_mod1:
	tst.b	31(a0)
	sne	d0
	and.b	32(a0),d0
	and.b	#1,d0
	bne.s	.L2086
	move.b	33(a0),d0
	beq.s	.L205A
	clr.b	33(a0)
	bra.s	.L2076
;
.L205A:
	move	20(a0),d2
	cmp	22(a0),d2
	beq.s	.L2086
	addq	#1,d2
	and	#$1FF,d2
	move	d2,20(a0)
	move.l	14(a0),a1
	move.b	0(a1,d2.w),d0
.L2076:
	tst.b	44(a2)
	bpl.s	.L2076
	move.b	44(a2),29(a0)
	move.b	d0,46(a2)	;Transmit data to Modem 1
.L2086:
	rts
;
;
;----------------------------------------------------------------------------
;
;
;L2088:
new_iv_v24rerr:
	movem.l	d0-d0/a0-a1,-(sp)
	lea	L18232,a0
	lea	$FFFFFA01.w,a1
	move.b	42(a1),28(a0)
	move.b	46(a1),d0
	bclr	#3,14(a1)
	movem.l	(sp)+,d0-d0/a0-a1
	rte
;
;
;----------------------------------------------------------------------------
;
;
;L20AC:
new_iv_v24terr:
	movem.l	a0-a1,-(sp)
	lea	L18232,a0
	lea	$FFFFFA01.w,a1
	move.b	44(a1),29(a0)
	bclr	#1,14(a1)
	movem.l	(sp)+,a0-a1
	rte
;
;
;----------------------------------------------------------------------------
;	Modem 1 Ring interrupt
;
;L20CC:
new_iv_v24ring:
	movem.l	d0-d4/a0-a2,-(sp)
	or	#$2700,SR
L20D4:
	moveq	#8,d4
	moveq	#0,d3
L20D8:
	move.l	d4,d0
	lsr.l	#3,d0
	btst	d0,L182FE
	beq.s	L210A
	move.l	#L181E0,a0
	move.l	0(a0,d4.w),a0
	move.l	#L181F8,a2
	move.l	0(a2,d4.w),a2
	move.b	8704(a2),d1
	btst	#0,d1
	bne.s	L2122
	btst	#2,d1
	bne	L21A6
L210A:
	addq	#4,d4
	cmp	#$10,d4
	bne.s	L20D8
	tst	d3
	bne.s	L20D4
	bclr	#6,$FFFFFA0F.w
	movem.l	(sp)+,d0-d4/a0-a2
	rte
;
L2122:
	moveq	#1,d3
	and.b	#224,d1
	beq.s	L2130
	tst.b	17536(a2)
	bra.s	L210A
;
L2130:
	move.b	9728(a2),d0
	btst	#0,32(a0)
	beq.s	L215C
	cmp.b	#17,d0
	bne.s	L214E
	move.b	#0,31(a0)
	tst.b	17416(a2)
	bra.s	L210A
;
L214E:
	cmp.b	#19,d0
	bne.s	L215C
	move.b	#60,31(a0)
	bra.s	L210A
;
L215C:
	move	8(a0),d2
	addq	#1,d2
	and	#$1FF,d2
	cmp	6(a0),d2
	beq.s	L210A
	move.l	0(a0),a1
	move.b	d0,0(a1,d2.w)
	move	d2,8(a0)
	bsr	L1D3C
	cmp	12(a0),d2
	bne.s	L210A
	btst	#0,32(a0)
	beq.s	L210A
	tst.b	30(a0)
	bne	L210A
	move.b	#255,30(a0)
	move.b	#19,33(a0)
	tst.b	17416(a2)
	bra	L210A
;
L21A6:
	moveq	#1,d3
	btst	#0,32(a0)
	beq.s	L21C6
	moveq	#0,d0
	move.b	33(a0),d0
	clr.b	33(a0)
	tst.b	d0
	bne.s	L21E4
	tst.b	31(a0)
	bne	L21F2
L21C6:
	move	20(a0),d2
	cmp	22(a0),d2
	beq.s	L21F2
	addq	#1,d2
	and	#$1FF,d2
	move	d2,20(a0)
	move.l	14(a0),a1
	moveq	#0,d0
	move.b	0(a1,d2.w),d0
L21E4:
	lsl.w	#1,d0
	add	#$4600,d0
	move.b	0(a2,d0.w),d0
	bra	L210A
;
L21F2:
	tst.b	17424(a2)
	bra	L210A
;
;
;----------------------------------------------------------------------------
;
;
L21FA:
	move	#$80,d6
	btst	#0,d7
	bne	L220A
	or	#$20,d6
L220A:
	btst	#3,d7
	beq	L2222
	or	#4,d6
	btst	#4,d7
	beq	L2222
	or	#2,d6
L2222:
	or	#8,d6
	btst	#2,d7
	beq	L2232
	or	#$10,d6
L2232:
	and	#$E0,d7
	move	#1,d5
	cmp	#$E0,d7
	beq	L225E
	move	#7,d5
	cmp	#$80,d7
	beq	L225E
	move	#4,d5
	cmp	#$A0,d7
	beq	L225E
	move	#9,d5
L225E:
	rts
;
;
L2260:
	tst.b	17504(a2)
	tst.b	17472(a2)
	tst.b	17536(a2)
	tst.b	17424(a2)
	rts
;
;
L2272:
	lea	$FB0001.l,a2
	bsr.s	L2260
	lea	$FB1001.l,a2
	bsr.s	L2260
	lea	$FA0001.l,a2
	bsr.s	L2260
	lea	$FA1001.l,a2
	bsr.s	L2260
	bios	Setexc,#(iv_v24ring/4),?
	move.l	d0,old_iv_v24ring_p
	bset	#6,$FFFFFA03.w
	xbios	Mfpint,#((iv_v24ring-$100)/4),new_iv_v24ring
	lea	L18254,a0
	lea	$FB0001.l,a2
	move	#$83,d7
	bsr	L291E
	lea	L18276,a0
	lea	$FB1001.l,a2
	move	#$83,d7
	bsr	L291E
	lea	L18298,a0
	lea	$FA0001.l,a2
	move	#$83,d7
	bsr	L291E
	lea	L182BA,a0
	lea	$FA1001.l,a2
	move	#$83,d7
	bsr	L291E
	rts
;
;
;----------------------------------------------------------------------------
;	Table driven multitasked TX polling
;
;L2314:
tx_poll_t:
	dc.l	tx_poll_cons	;poll console (dummy)
	dc.l	tx_poll_mod1	;poll Modem 1
	dc.l	tx_poll_mod2	;poll Modem 2
	dc.l	tx_poll_mod3	;poll Modem 3
	dc.l	tx_poll_mod4	;poll Modem 4
	dc.l	tx_poll_mod5	;poll Modem 5
;
;
;L232C:
tx_polls_r:
	moveq	#0,d0		;modem index = 0
.L232E:
	move.l	d0,-(sp)	;push modem index
	lea	L181E0,a0	;a0 = L181E0 -> table of ptrs to modem structures
	move.l	0(a0,d0.w),a0	;a0 -> modem structure
	tst.b	31(a0)
	beq.s	.L2356		;skip inactive modems
	subi.b	#1,31(a0)	;countdown per modem
	bne	.L2356		;skip modems awaiting countdown
	lea	tx_poll_t,a0	;a0 = tx_poll_t -> table of ptrs to tx_poll routines
	move.l	0(a0,d0.w),a0	;a0 -> tx_poll routine
	jsr	(a0)
.L2356:
	move.l	(sp)+,d0	;pull modem index
	addq	#4,d0		;step modem index
	cmp	#$18,d0
	bne.s	.L232E
	rts
;
;
;L2362:
tx_poll_cons:
	rts
;
;
;L2364:
tx_poll_mod1:
	lea	L18232,a0
	lea	$FFFFFA01.w,a2
	tst.b	44(a2)
	bpl.s	L2378
	bsr	transmit_mod1
L2378:
	rts
;
;
;L237A:
tx_poll_mod2:
	lea	$FB0001.l,a0
	tst.b	17416(a0)
	rts
;
;
;L2386:
tx_poll_mod3:
	lea	$FB1001.l,a0
	tst.b	17416(a0)
	rts
;
;
;L2392:
tx_poll_mod4:
	lea	$FA0001.l,a0
	tst.b	17416(a0)
	rts
;
;
;L239E:
tx_poll_mod5:
	lea	$FA1001.l,a0
	tst.b	17416(a0)
	rts
;
;
;----------------------------------------------------------------------------
;	Table driven character output
;
L23AA:
	dc.l	L23D4
	dc.l	L2420
	dc.l	L246A
	dc.l	L24B4
	dc.l	L24FE
	dc.l	L2548
;
;
L23C2:
	move	4(sp),d0
	lsl.w	#2,d0
	lea	L23AA,a0
	move.l	0(a0,d0.w),a0
	jmp	(a0)
;
;
;
; Func	-------------------------------
;
L23D4:
	link	a6,#0
L23D8:
	bsr	L1D20
	btst	#0,32(a0)
	beq.s	L2400
	tst.b	31(a0)
	beq.s	L2400
	bsr	dcd_poll_cons
	beq	L241A
	move	#1,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L23D8
;
L2400:
	btst	#1,32(a0)
	beq	L241A
	move	10(a6),-(sp)
	move	8(a6),-(sp)
	jsr	user_conout_2
	addq	#4,sp
L241A:
	moveq	#1,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2420:
	link	a6,#0
L2424:
	bsr	L1D20
	move	10(a6),d1
	bsr	L1D50
	bcc	L244A
	bsr	dcd_poll_mod1
	beq	L2464
	move	#1,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L2424
;
L244A:
	btst	#1,32(a0)
	beq	L2464
	move	10(a6),-(sp)
	move	8(a6),-(sp)
	jsr	user_conout_2
	addq	#4,sp
L2464:
	moveq	#1,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L246A:
	link	a6,#0
L246E:
	bsr	L1D20
	move	10(a6),d1
	bsr	L1DA8
	bcc	L2494
	bsr	dcd_poll_mod2
	beq	L24AE
	move	#1,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L246E
;
L2494:
	btst	#1,32(a0)
	beq	L24AE
	move	10(a6),-(sp)
	move	8(a6),-(sp)
	jsr	user_conout_2
	addq	#4,sp
L24AE:
	moveq	#1,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L24B4:
	link	a6,#0
L24B8:
	bsr	L1D20
	move	10(a6),d1
	bsr	L1DA8
	bcc	L24DE
	bsr	dcd_poll_mod3
	beq	L24F8
	move	#1,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L24B8
;
L24DE:
	btst	#1,32(a0)
	beq	L24F8
	move	10(a6),-(sp)
	move	8(a6),-(sp)
	jsr	user_conout_2
	addq	#4,sp
L24F8:
	moveq	#1,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L24FE:
	link	a6,#0
L2502:
	bsr	L1D20
	move	10(a6),d1
	bsr	L1DA8
	bcc	L2528
	bsr	dcd_poll_mod4
	beq	L2542
	move	#1,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L2502
;
L2528:
	btst	#1,32(a0)
	beq	L2542
	move	10(a6),-(sp)
	move	8(a6),-(sp)
	jsr	user_conout_2
	addq	#4,sp
L2542:
	moveq	#1,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2548:
	link	a6,#0
L254C:
	bsr	L1D20
	move	10(a6),d1
	bsr	L1DA8
	bcc	L2572
	bsr	dcd_poll_mod5
	beq	L258C
	move	#1,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L254C
;
L2572:
	btst	#1,32(a0)
	beq	L258C
	move	10(a6),-(sp)
	move	8(a6),-(sp)
	jsr	user_conout_2
	addq	#4,sp
L258C:
	moveq	#1,d0
	unlk	a6
	rts
;
;
;----------------------------------------------------------------------------
;
;
L2592:
	dc.l	L25C4
	dc.l	L25EE
	dc.l	L2618
	dc.l	L2642
	dc.l	L266E
	dc.l	L269A
L25AA:
	move	4(sp),d0
	lsl.w	#2,d0
	lea	L2592,a0
	move.l	0(a0,d0.w),a0
	jmp	(a0)
;
L25BC:
	moveq	#-1,d0
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L25C4:
	link	a6,#0
	move.l	a3,-(sp)
	bsr	L1D20
L25CE:
	lea	6(a0),a1
	lea	8(a0),a3
	cmpm	(a1)+,(a3)+
	bne	L25E4
	bsr	dcd_poll_cons
	beq.s	L25BC
	bra.s	L25CE
;
L25E4:
	bsr	L1DDE
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L25EE:
	link	a6,#0
	move.l	a3,-(sp)
	bsr	L1D20
L25F8:
	lea	6(a0),a1
	lea	8(a0),a3
	cmpm	(a1)+,(a3)+
	bne	L260E
	bsr	dcd_poll_mod1
	beq.s	L25BC
	bra.s	L25F8
;
L260E:
	bsr	L1E08
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2618:
	link	a6,#0
	move.l	a3,-(sp)
	bsr	L1D20
L2622:
	lea	6(a0),a1
	lea	8(a0),a3
	cmpm	(a1)+,(a3)+
	bne	L2638
	bsr	dcd_poll_mod2
	beq.s	L25BC
	bra.s	L2622
;
L2638:
	bsr	L1E5E
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2642:
	link	a6,#0
	move.l	a3,-(sp)
	bsr	L1D20
L264C:
	lea	6(a0),a1
	lea	8(a0),a3
	cmpm	(a1)+,(a3)+
	bne	L2664
	bsr	dcd_poll_mod3
	beq	L25BC
	bra.s	L264C
;
L2664:
	bsr	L1E5E
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L266E:
	link	a6,#0
	move.l	a3,-(sp)
	bsr	L1D20
L2678:
	lea	6(a0),a1
	lea	8(a0),a3
	cmpm	(a1)+,(a3)+
	bne	L2690
	bsr	dcd_poll_mod4
	beq	L25BC
	bra.s	L2678
;
L2690:
	bsr	L1E5E
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L269A:
	link	a6,#0
	move.l	a3,-(sp)
	bsr	L1D20
L26A4:
	lea	6(a0),a1
	lea	8(a0),a3
	cmpm	(a1)+,(a3)+
	bne	L26BC
	bsr	dcd_poll_mod5
	beq	L25BC
	bra.s	L26A4
;
L26BC:
	bsr	L1E5E
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
;----------------------------------------------------------------------------
;
;
; Func	-------------------------------
;
L26C6:
	link	a6,#0
	bsr	L1D20
	moveq	#-1,d0
	lea	6(a0),a1
	lea	8(a0),a2
	cmpm	(a1)+,(a2)+
	bne.s	L26DE
	moveq	#0,d0
L26DE:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L26E2:
	link	a6,#0
	bsr	L1D20
	moveq	#-1,d0
	move	8(a0),d2
	addq	#1,d2
	and	#$1FF,d2
	cmp	6(a0),d2
	bne	L2700
	moveq	#0,d0
L2700:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2704:
	link	a6,#0
	move.l	a3,-(sp)
	bsr	L1D20
	moveq	#1,d0
	lea	20(a0),a1
	lea	22(a0),a3
	cmpm	(a1)+,(a3)+
	beq	L2720
	moveq	#0,d0
L2720:
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
;----------------------------------------------------------------------------
;	Table driven DCD polling
;
L2726:
	dc.l	dcd_poll_cons	;dcd_poll console (simulated)
	dc.l	dcd_poll_mod1	;dcd_poll Modem 1
	dc.l	dcd_poll_mod2	;dcd_poll Modem 2
	dc.l	dcd_poll_mod3	;dcd_poll Modem 3
	dc.l	dcd_poll_mod4	;dcd_poll Modem 4
	dc.l	dcd_poll_mod5	;dcd_poll Modem 5
;
;L273E:
dcd_poll_r:
	move	4(sp),d0
	lsl.w	#2,d0
	lea	L2726,a0
	move.l	0(a0,d0.w),a0
	jmp	(a0)
;
;L2750:
dcd_poll_cons:
	moveq	#0,d0
	move	L3E746,d0
	rts
;
;L275A:
dcd_poll_mod1:
	lea	$FFFFFA01.w,a1
	moveq	#0,d0
	move.b	(a1),d0
	and.b	#2,d0
	eori.b	#2,d0
	lsr.b	#1,d0
	rts
;
;L276E:
dcd_poll_mod2:
	lea	$FB0001.l,a1
	moveq	#0,d0
	move.b	14848(a1),d0
	not.b	d0
	and.b	#1,d0
	rts
;
;L2782:
dcd_poll_mod3:
	lea	$FB0001.l,a1
	moveq	#0,d0
	move.b	14848(a1),d0
	not.b	d0
	lsr.b	#1,d0
	and.b	#1,d0
	rts
;
;L2798:
dcd_poll_mod4:
	lea	$FA0001.l,a1
	moveq	#0,d0
	move.b	14848(a1),d0
	not.b	d0
	and.b	#1,d0
	rts
;
;L27AC:
dcd_poll_mod5:
	lea	$FA0001.l,a1
	moveq	#0,d0
	move.b	14848(a1),d0
	not.b	d0
	lsr.b	#1,d0
	and.b	#1,d0
	rts
;
;
;----------------------------------------------------------------------------
;	Table driven RTS output
;
;L27C2:
rts_out_t:
	dc.l	rts_out_cons
	dc.l	rts_out_mod1
	dc.l	rts_out_mod2
	dc.l	rts_out_mod3
	dc.l	rts_out_mod4
	dc.l	rts_out_mod5
;
;L27DA:
rts_out_r:
	move	4(sp),d0
	lsl.w	#2,d0
	lea	rts_out_t,a1
	move.l	0(a1,d0.w),a1
	move	6(sp),d0
	jmp	(a1)
;
;L27F0:
rts_out_cons:
	rts
;
;
;L27F2:
rts_out_mod1:
	move	SR,-(sp)
	or	#$700,SR
	lea	$FF8800.l,a0
	move.b	#14,(a0)
	move.b	2(a0),d1
	tst	d0
	beq.s	L2810
	and.b	#239,d1
	bra.s	L2814
;
L2810:
	or.b	#16,d1
L2814:
	move.b	d1,2(a0)
	move	(sp)+,SR
	rts
;
;
;L281C:
rts_out_mod2:
	move	#$5C02,d1
	tst	d0
	bne.s	L2836
	move	#$5E02,d1
	bra.s	L2836
;
;
;L282A:
rts_out_mod3:
	move	#$5C04,d1
	tst	d0
	bne.s	L2836
	move	#$5E04,d1
L2836:
	lea	$FB0001.l,a0
	tst.b	0(a0,d1.w)
	rts
;
;
;L2842:
rts_out_mod4:
	move	#$5C02,d1
	tst	d0
	bne.s	L285C
	move	#$5E02,d1
	bra.s	L285C
;
;L2850:
rts_out_mod5:
	move	#$5C04,d1
	tst	d0
	bne.s	L285C
	move	#$5E04,d1
L285C:
	lea	$FA0001.l,a0
	tst.b	0(a0,d1.w)
	rts
;
;
;----------------------------------------------------------------------------
;
;
L2868:
	dc.l	L28AC
	dc.l	L28AE
	dc.l	L28B2
	dc.l	L28B2
	dc.l	L28B2
	dc.l	L28B2
;
;
; Func	-------------------------------
;
L2880:
	link	a6,#0
	bsr	L1D20
	move	8(a6),d0
	lsl.w	#2,d0
	lea	L2868,a1
	move.l	0(a1,d0.w),a1
	move	10(a6),d0
	move.b	#0,31(a0)
	move.b	d0,32(a0)
	jsr	(a1)
	unlk	a6
	rts
;
;
L28AC:
	rts
;
;
L28AE:
	bra	tx_poll_mod1
;
;
L28B2:
	tst.b	17416(a2)
	rts
;
;
; Data	-------------------------------
;
L28B8:
	dc.l	L28FA	;config console (dummy)
	dc.l	L28FC	;config modem 1
	dc.l	L291E	;config modem 2
	dc.l	L291E	;config modem 3
	dc.l	L291E	;config modem 4
	dc.l	L291E	;config modem 5
;
;
; Func	-------------------------------
;
L28D0:
	link	a6,#0
	movem.l	d2-d7,-(sp)
	bsr	L1D20
	move	8(a6),d0
	lsl.w	#2,d0
	lea	L28B8,a1
	move.l	0(a1,d0.w),a1
	move	10(a6),d7
	jsr	(a1)
	movem.l	(sp)+,d2-d7
	unlk	a6
	rts
;
;
L28FA:
	rts
;
;
L28FC:
	move	#-1,-(sp)
	move	#-1,-(sp)
	move	#-1,-(sp)
	bsr	L21FA
	xbios	Rsconf,d5,!,d6,(),(),()
	rts
;
;
L291E:
	bsr	L21FA
	tst.b	17440(a2)
	move.b	#0,31(a0)
	move	d6,d1
	lsr.b	#5,d1
	and.b	#3,d1
	moveq	#0,d0
	move.b	d1,d0
	move	d6,d1
	lsl.b	#1,d1
	and.b	#4,d1
	or.b	d1,d0
	move	d6,d1
	lsl.b	#2,d1
	and.b	#16,d1
	or.b	d1,d0
	eori.b	#$17,d0
	lsl.w	#1,d0
	add	#$4000,d0
	tst.b	0(a2,d0.w)
	move	d6,d1
	moveq	#0,d0
	move.b	#0,d0
	btst	#3,d1
	beq.s	L296C
	move.b	#7,d0
L296C:
	lsr.w	#1,d1
	and.b	#8,d1
	or.b	d1,d0
	lsl.w	#1,d0
	add	#$4000,d0
	tst.b	0(a2,d0.w)
	moveq	#0,d0
	bset	#6,d0
	bset	#4,d0
	move	d0,d1
	lsl.w	#1,d1
	or	d1,d0
	lsl.w	#1,d0
	add	#$5A00,d0
	move.l	a2,d1
	bclr	#12,d1
	move.l	d1,a0
	tst.b	0(a0,d0.w)
	tst.b	17632(a2)
	move.l	a2,d0
	and.l	#$FFEFFF,d0
	move.l	d0,a0
	tst.b	18688(a0)
	moveq	#0,d1
	move.b	d5,d1
	move.l	#L182FF,a0
	move.b	0(a0,d1.w),d0
	lsl.w	#1,d0
	add	#$4200,d0
	tst.b	0(a2,d0.w)
	tst.b	17410(a2)
	tst.b	17416(a2)
	rts
;
;
; Func	-------------------------------
;
L29D4:
	link	a6,#0
	movem.l	d0-d7/a0-a5,-(sp)
zzDUMBcomp	set	1
	xbios	Iorec,#1
zzDUMBcomp	set	0
	move.l	d0,kb_iorec_p
	xbios	Kbdvbase
	move.l	d0,a0
	move.l	32(a0),old_kb_handler_p
	move.l	#new_kb_handler,32(a0)
	move	8(a6),d0
	btst	#0,d0
	beq	L2A9E
	bios	Setexc,#(iv_v24rerr/4),new_iv_v24rerr
	move.l	d0,old_iv_v24rerr_p
	bios	Setexc,#(iv_v24terr/4),new_iv_v24terr
	move.l	d0,old_iv_v24terr_p
	bios	Setexc,#(iv_v24treq/4),new_iv_v24treq
	move.l	d0,old_iv_v24treq_p
	bios	Setexc,#(iv_v24rreq/4),new_iv_v24rreq
	move.l	d0,old_iv_v24rreq_p
	lea	$FFFFFA01.w,a0
	bclr	#6,6(a0)
	bclr	#0,8(a0)
	bclr	#1,8(a0)
	bclr	#2,8(a0)
	bclr	#3,8(a0)
	bclr	#4,8(a0)
L2A9E:
	move	8(a6),d0
	move.b	d0,L182FE
	and	#$1E,d0
	beq	L2AB4
	bsr	L2272
L2AB4:
	movem.l	(sp)+,d0-d7/a0-a5
	unlk	a6
	rts
;
L2ABC:
	lea	$FFFFFA01.w,a0
	bclr	#6,6(a0)
	move.l	old_iv_v24ring_p,d0
	beq	L2ADE
	bios	Setexc|_ind,#(iv_v24ring/4),d0
L2ADE:
	move.l	old_iv_v24treq_p,d0
	beq	L2AF6
	bios	Setexc|_ind,#(iv_v24treq/4),d0
L2AF6:
	move.l	old_iv_v24rreq_p,d0
	beq	L2B0E
	bios	Setexc|_ind,#(iv_v24rreq/4),d0
L2B0E:
	move.l	old_iv_v24rerr_p,d0
	beq	L2B26
	bios	Setexc|_ind,#(iv_v24rerr/4),d0
L2B26:
	move.l	old_iv_v24terr_p,d0
	beq	L2B3E
	bios	Setexc|_ind,#(iv_v24terr/4),d0
L2B3E:
	xbios	Kbdvbase
	move.l	d0,a0
	move.l	old_kb_handler_p,32(a0)
	rts
;
;
; Func	-------------------------------
;
L2B52:
	link	a6,#-12
	move	L1EA00,d0
	addq	#1,L1EA00
	move	d0,-10(a6)
	move	L1EA00,d0
	addq	#1,L1EA00
	move	d0,-12(a6)
	move	-10(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	addi.l	#$1EB48,d0
	move.l	d0,-4(a6)
	move	-12(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	addi.l	#$1EB48,d0
	move.l	d0,-8(a6)
	move.l	-4(a6),a0
	move	-12(a6),2(a0)
	move.l	-4(a6),a0
	moveq	#-1,d0
	move	d0,4(a0)
	move.l	-4(a6),a0
	move	#$8000,(a0)
	move.l	-8(a6),a0
	moveq	#-1,d0
	move	d0,2(a0)
	move.l	-8(a6),a0
	move	-10(a6),4(a0)
	move.l	-8(a6),a0
	move	#$7FFF,(a0)
	move	-10(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2BDA:
	link	a6,#-8
	move	10(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	addi.l	#$1EB48,d0
	move.l	d0,-4(a6)
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	addi.l	#$1EB48,d0
	move.l	d0,-8(a6)
	move.l	-8(a6),a0
	move	10(a6),2(a0)
	move.l	-4(a6),a1
	move.l	-8(a6),a0
	move	4(a1),4(a0)
	move.l	-4(a6),a0
	move	4(a0),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move	8(a6),(a0)
	move.l	-4(a6),a0
	move	8(a6),4(a0)
	move	8(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2C44:
	link	a6,#-4
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	addi.l	#$1EB48,d0
	move.l	d0,-4(a6)
	move.l	-4(a6),a0
	move	4(a0),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move.l	-4(a6),a1
	move	2(a1),(a0)
	move.l	-4(a6),a0
	move	2(a0),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4C,a0
	adda.l	d0,a0
	move.l	-4(a6),a1
	move	4(a1),(a0)
	move	8(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2C9A:
	link	a6,#-4
	clr	-4(a6)
L2CA2:
	cmpi	#$F,-4(a6)
	bge.s	L2CE6
	move	L1E9FE,d0
	subq	#1,L1E9FE
	move	d0,-2(a6)
	bgt.s	L2CC4
	moveq	#14,d0
	move	d0,L1E9FE
L2CC4:
	move	-2(a6),d0
	muls	#$2C,d0
	lea	L2C0E4,a0
	adda.l	d0,a0
	cmpi.b	#2,(a0)
	bne.s	L2CE0
	move	-2(a6),d0
	bra.s	L2CE8
;
L2CE0:
	addq	#1,-4(a6)
	bra.s	L2CA2
;
L2CE6:
	moveq	#-1,d0
L2CE8:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2CEC:
	link	a6,#-2
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move	(a0),d0
	move	d0,-2(a6)
	cmpi	#$F,d0
	bge.s	L2D1A
	move	-2(a6),-(sp)
	jsr	L2C44
	addq	#2,sp
	bra.s	L2D1C
;
L2D1A:
	moveq	#-1,d0
L2D1C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2D20:
	link	a6,#-2
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4C,a0
	adda.l	d0,a0
	move	(a0),d0
	move	d0,-2(a6)
	cmpi	#$F,d0
	bge.s	L2D4E
	move	-2(a6),-(sp)
	jsr	L2C44
	addq	#2,sp
	bra.s	L2D50
;
L2D4E:
	moveq	#-1,d0
L2D50:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2D54:
	link	a6,#-6
	jsr	mask_interrupts
	move	d0,-2(a6)
	move	8(a6),d0
	bne.s	L2D78
L2D68:
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	clr.l	d0
	bra.s	L2DC2
;
L2D78:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	L3E7C2,a0
	suba.l	d0,a0
	cmp.l	L3E7BE,a0
	bls.s	L2D68
	move	8(a6),d1
	ext.l	d1
	lsl.l	#1,d1
	move.l	L3E7C2,d0
	sub.l	d1,d0
	move.l	d0,L3E7C2
	move.l	L3E7C2,d0
	addq.l	#2,d0
	move.l	d0,-6(a6)
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	move.l	-6(a6),d0
L2DC2:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2DC6:
	link	a6,#-4
	move	10(a6),d0
L2DCE:
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move	(a0),-2(a6)
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB48,a0
	adda.l	d0,a0
	move	(a0),d0
	cmp	12(a6),d0
	bge.s	L2DFC
	move	-2(a6),d0
	bra.s	L2DCE
;
L2DFC:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move	-2(a6),(a0)
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4C,a1
	adda.l	d0,a1
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4C,a0
	adda.l	d0,a0
	move	(a0),d0
	move	d0,-4(a6)
	move	d0,(a1)
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB48,a0
	adda.l	d0,a0
	move	12(a6),(a0)
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move	8(a6),(a0)
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4C,a0
	adda.l	d0,a0
	move	8(a6),(a0)
	moveq	#1,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2E7A:
	link	a6,#-4
	move.l	a5,-(sp)
	move	8(a6),d0
	ble.s	L2E8E
	cmpi	#$F,8(a6)
	blt.s	L2E92
L2E8E:
	moveq	#-1,d0
	bra.s	L2ECA
;
L2E92:
	move	8(a6),d0
	muls	#$2C,d0
	addi.l	#$2C0E4,d0
	move.l	d0,a5
	moveq	#3,d0
	move.b	d0,(a5)
	move	2(a5),-(sp)
	move	L1EA04,-(sp)
	move	8(a6),-(sp)
	jsr	L2DC6
	addq	#6,sp
	move	10(a6),d0
	beq.s	L2EC8
	jsr	L34EE
L2EC8:
	moveq	#1,d0
L2ECA:
	move.l	(sp)+,a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2ED0:
	link	a6,#-4
	clr	-4(a6)
L2ED8:
	cmpi	#$28,-4(a6)
	bge.s	L2F36
	move	L1EA02,d0
	subq	#1,L1EA02
	move	d0,-2(a6)
	move	L1EA02,d0
	bge.s	L2F00
	moveq	#39,d0
	move	d0,L1EA02
L2F00:
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EA08,a0
	adda.l	d0,a0
	cmpi.b	#1,(a0)
	bne.s	L2F30
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EA08,a0
	adda.l	d0,a0
	moveq	#2,d0
	move.b	d0,(a0)
	move	-2(a6),d0
	bra.s	L2F38
;
L2F30:
	addq	#1,-4(a6)
	bra.s	L2ED8
;
L2F36:
	moveq	#-1,d0
L2F38:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2F3C:
	link	a6,#0
	jsr	L3360
	move	d0,-(sp)
	jsr	L336E
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L2F54:
	link	a6,#-4
	move	10(a6),-4(a6)
	move	10(a6),d0
L2F62:
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move	(a0),-2(a6)
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB48,a0
	adda.l	d0,a0
	move	(a0),d0
	cmp	12(a6),d0
	bge.s	L2FAC
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB48,a0
	adda.l	d0,a0
	move	(a0),d0
	sub	d0,12(a6)
	move	-2(a6),-4(a6)
	move	-2(a6),d0
	bra.s	L2F62
;
L2FAC:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move	-2(a6),(a0)
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4C,a0
	adda.l	d0,a0
	move	-4(a6),(a0)
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB48,a0
	adda.l	d0,a0
	move	12(a6),(a0)
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move	8(a6),(a0)
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4C,a0
	adda.l	d0,a0
	move	8(a6),(a0)
	cmpi	#$F,-2(a6)
	bge.s	L302E
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB48,a0
	adda.l	d0,a0
	move	12(a6),d0
	sub	d0,(a0)
L302E:
	moveq	#1,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3034:
use_bbs_vectors_2:
	link	a6,#-12
	clr	L3E74C
	moveq	#14,d0
	move	d0,L1E9FE
	moveq	#39,d0
	move	d0,L1EA02
	moveq	#15,d0
	move	d0,L1EA00
	clr	-2(a6)
.L305A:
	cmpi	#$F,-2(a6)
	bge.s	.L307C
	move	-2(a6),d0
	muls	#$2C,d0
	lea	L2C0E4,a0
	adda.l	d0,a0
	moveq	#2,d0
	move.b	d0,(a0)
	addq	#1,-2(a6)
	bra.s	.L305A
;
.L307C:
	move.l	#L2C0E4,-8(a6)
	move.l	-8(a6),a0
	moveq	#1,d0
	move.b	d0,(a0)
	clr	-4(a6)
.L3090:
	cmpi	#$10,-4(a6)
	bge.s	.L30B4
	move.l	-8(a6),a0
	adda	-4(a6),a0
	move	-4(a6),a1
	adda.l	#L187C8,a1
	move.b	(a1),10(a0)
	addq	#1,-4(a6)
	bra.s	.L3090
;
.L30B4:
	move.l	-8(a6),a0
	clr	26(a0)
	clr	L1EE60
	clr	-2(a6)
.L30C6:
	cmpi	#$28,-2(a6)
	bge.s	.L3104
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EA08,a0
	adda.l	d0,a0
	move.l	a0,-12(a6)
	moveq	#1,d0
	move.b	d0,(a0)
	jsr	L2B52
	move.l	-12(a6),a0
	move	d0,4(a0)
	addq	#1,d0
	move.l	-12(a6),a0
	move	d0,6(a0)
	addq	#1,-2(a6)
	bra.s	.L30C6
;
.L3104:
	jsr	L2B52
	move	d0,L1EA04
	addq	#1,d0
	move	d0,L1EA06
	clr	L3673E
	jsr	L2B52
	move	d0,L1EE64
	jsr	use_bbs_vectors_1
	moveq	#1,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L3136:
start_1:
	link	a6,#0
	jsr	mask_interrupts
	jsr	use_bbs_vectors_2
	jsr	force_interrupts
	clr	-(sp)
	clr	-(sp)
	pea	L187D1
	moveq	#20,d0
	move	d0,-(sp)
	move	#$400,-(sp)
	pea	L3D9E
	jsr	init_bbs
	adda	#$10,sp
	move	d0,-(sp)
	jsr	start_bbs
	addq	#2,sp
.L3178:
	move	L3E74C,d0
	bne.s	.L3178
	jsr	use_old_vectors_1
	unlk	a6
	rts				;NB: This leads to Pterm
;
;
; Func	-------------------------------
;
L318A:
	link	a6,#-8
	jsr	mask_interrupts
	move	d0,-8(a6)
	move	8(a6),d0
	ble.s	L31C6
	cmpi	#$F,8(a6)
	bge.s	L31C6
	move	10(a6),d0
	ble.s	L31C6
	move	8(a6),d0
	muls	#$2C,d0
	lea	L2C0E4,a0
	adda.l	d0,a0
	move.l	a0,-6(a6)
	cmpi.b	#2,(a0)
	bne.s	L31D6
L31C6:
	move	-8(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#-1,d0
	bra.s	L31FA
;
L31D6:
	move.l	-6(a6),a0
	move	2(a0),-2(a6)
	move.l	-6(a6),a0
	move	10(a6),2(a0)
	move	-8(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	move	-2(a6),d0
L31FA:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L31FE:
init_bbs:
	link	a6,#-26
	move.l	a5,-(sp)
	jsr	mask_interrupts
	move	d0,-6(a6)
	cmpi	#$28,12(a6)
	blt.s	.L3240
	move	12(a6),-(sp)
	jsr	L2D54
	addq	#2,sp
	move.l	d0,-18(a6)
	beq.s	.L3240
	jsr	L2C9A
	move	d0,-8(a6)
	cmpi	#$FFFF,d0
	beq.s	.L3240
	cmpi	#1,14(a6)
	bge.s	.L3252
.L3240:
	move	-6(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#-1,d0
	bra	.exit_init_bbs
;
.L3252:
	addq	#1,L3E74C
	move	-8(a6),d0
	muls	#$2C,d0
	addi.l	#$2C0E4,d0
	move.l	d0,-4(a6)
	move.l	-4(a6),a0
	moveq	#6,d0
	move.b	d0,(a0)
	clr	-10(a6)
.L3276:
	cmpi	#$10,-10(a6)
	bge.s	.L329A
	move.l	-4(a6),a0
	adda	-10(a6),a0
	move	-10(a6),a1
	adda.l	16(a6),a1
	move.b	(a1),10(a0)
	beq.s	.L329A
	addq	#1,-10(a6)
	bra.s	.L3276
;
.L329A:
	move.l	-4(a6),a0
	move	14(a6),2(a0)
	move	12(a6),d0
	subq	#4,d0
	ext.l	d0
	lsl.l	#1,d0
	add.l	-18(a6),d0
	move.l	d0,-22(a6)
	move.l	-4(a6),a0
	move	20(a6),26(a0)
	move	20(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	add.l	a6,d0
	addi.l	#$16,d0
	move.l	d0,-14(a6)
.L32D4:
	move	20(a6),d0
	ble.s	.L32F2
	subq.l	#2,-22(a6)
	move.l	-22(a6),a0
	subq.l	#2,-14(a6)
	move.l	-14(a6),a1
	move	(a1),(a0)
	subq	#1,20(a6)
	bra.s	.L32D4
;
.L32F2:
	move	12(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	add.l	-18(a6),d0
	move.l	-4(a6),a0
	move.l	d0,36(a0)
	move.l	-4(a6),a0
	move	12(a6),40(a0)
	move.l	-4(a6),a0
	move.l	-18(a6),32(a0)
	move.l	-22(a6),a5
	move.l	#L2F3C,-(a5)
	move.l	8(a6),-(a5)
	move.l	a5,-22(a6)
	subq.l	#2,-22(a6)
	move.l	-22(a6),a0
	move	#$2000,(a0)
	move.l	-22(a6),a5
	suba	#$2C,a5
	move.l	-4(a6),a0
	move.l	a5,28(a0)
	move	-6(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	move	-8(a6),d0
;L335A:
.exit_init_bbs:
	move.l	(sp)+,a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3360:
	link	a6,#0
	move	L1EE60,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L336E:
	link	a6,#-6
	jsr	mask_interrupts
	move	d0,-6(a6)
	move	8(a6),d0
	ble.s	L33A4
	cmpi	#$F,8(a6)
	bge.s	L33A4
	move	8(a6),d0
	muls	#$2C,d0
	lea	L2C0E4,a0
	adda.l	d0,a0
	move.l	a0,-4(a6)
	cmpi.b	#2,(a0)
	bne.s	L33B4
L33A4:
	move	-6(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#-1,d0
	bra.s	L3420
;
L33B4:
	subq	#1,L3E74C
	move.l	-4(a6),a0
	move.b	(a0),d0
	ext.w	d0
	subq	#1,d0
	cmpi	#6,d0
	bhi.s	L340A
	lsl.w	#2,d0
	move	d0,a0
	adda.l	#L18312,a0
	move.l	(a0),a0
	jmp	(a0)
;
L33D8:
	bra.s	L3412
;
L33DA:
	move.l	-4(a6),a0
	moveq	#2,d0
	move.b	d0,(a0)
	jsr	L34EE
L33E8:
	move.l	-4(a6),a0
	move	4(a0),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EA0A,a0
	adda.l	d0,a0
	addq	#1,(a0)
L33FE:
	move	8(a6),-(sp)
	jsr	L2C44
	addq	#2,sp
L340A:
	move.l	-4(a6),a0
	moveq	#2,d0
	move.b	d0,(a0)
L3412:
	move	-6(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#1,d0
L3420:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3424:
	link	a6,#-8
	jsr	mask_interrupts
	move	d0,-8(a6)
	move	L1EE60,d0
	muls	#$2C,d0
	addi.l	#$2C0E4,d0
	move.l	d0,-4(a6)
	move.l	-4(a6),a0
	move	8(a0),d0
	bne.s	L345E
	move.l	-4(a6),a0
	moveq	#4,d0
	move.b	d0,(a0)
	jsr	L34EE
L345E:
	move.l	-4(a6),a0
	move	6(a0),-6(a6)
	move.l	-4(a6),a0
	clr	8(a0)
	move	-8(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	move	-6(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3484:
	link	a6,#-4
	jsr	mask_interrupts
	move	d0,-2(a6)
	move	L1EE60,d0
	muls	#$2C,d0
	lea	L2C0EC,a0
	adda.l	d0,a0
	move	(a0),d0
	beq.s	L34D4
	move	L1EE60,d0
	muls	#$2C,d0
	lea	L2C0EC,a0
	adda.l	d0,a0
	clr	(a0)
	move	L1EE60,d0
	muls	#$2C,d0
	lea	L2C0EA,a0
	adda.l	d0,a0
	move	(a0),-4(a6)
	bra.s	L34DA
;
L34D4:
	moveq	#1,d0
	move	d0,-4(a6)
L34DA:
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	move	-4(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L34EE:
	link	a6,#-8
	movem.l	a4-a5,(sp)
	move	L1EE60,d0
	muls	#$2C,d0
	addi.l	#$2C0E4,d0
	move.l	d0,a5
	move.l	a5,a0
	cmpi.b	#1,(a0)
	bne.s	L3544
	move	L1EA06,d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4C,a0
	adda.l	d0,a0
	move	(a0),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB48,a0
	adda.l	d0,a0
	move	(a0),d0
	cmp	2(a5),d0
	bge.s	L3544
	moveq	#1,d0
	move	d0,L1EE62
	moveq	#-1,d0
	bra.s	L35B2
;
L3544:
	cmpi.b	#1,(a5)
	bne.s	L3566
	moveq	#3,d0
	move.b	d0,(a5)
	move	2(a5),-(sp)
	move	L1EA04,-(sp)
	move	L1EE60,-(sp)
	jsr	L2DC6
	addq	#6,sp
L3566:
	move	L1EA06,-(sp)
	jsr	L2D20
	addq	#2,sp
	move	d0,L1EE60
	move	L1EE60,d0
	muls	#$2C,d0
	addi.l	#$2C0E4,d0
	move.l	d0,a4
	moveq	#1,d0
	move.b	d0,(a4)
	move	42(a4),L3E74E
	moveq	#1,d0
	move	d0,L1EE62
	pea	28(a4)
	pea	28(a5)
	jsr	L156
	addq	#8,sp
	moveq	#1,d0
L35B2:
	movem.l	(sp),a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L35BA:
start_bbs:
	link	a6,#-8
	jsr	mask_interrupts
	move	d0,-2(a6)
	move	8(a6),d0
	ble.s	L35F0
	cmpi	#$F,8(a6)
	bge.s	L35F0
	move	8(a6),d0
	muls	#$2C,d0
	lea	L2C0E4,a0
	adda.l	d0,a0
	move.l	a0,-6(a6)
	cmpi.b	#6,(a0)
	beq.s	L3600
L35F0:
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#-1,d0
	bra.s	L362A
;
L3600:
	move.l	-6(a6),a0
	move	2(a0),-8(a6)
	moveq	#1,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L2E7A
	addq	#4,sp
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	move	-8(a6),d0
L362A:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L362E:
	link	a6,#-4
	jsr	mask_interrupts
	move	d0,-2(a6)
	move	8(a6),d0
	blt.s	L3652
	jsr	L2ED0
	move	d0,-4(a6)
	cmpi	#$FFFF,d0
	bne.s	L3662
L3652:
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#-1,d0
	bra.s	L3686
;
L3662:
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EA0A,a0
	adda.l	d0,a0
	move	8(a6),(a0)
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	move	-4(a6),d0
L3686:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L368A:
	link	a6,#-8
	jsr	mask_interrupts
	move	d0,-2(a6)
	move	8(a6),d0
	blt.s	L36BC
	cmpi	#$28,8(a6)
	bge.s	L36BC
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EA08,a0
	adda.l	d0,a0
	cmpi.b	#1,(a0)
	bne.s	L36CC
L36BC:
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#-1,d0
	bra.s	L373E
;
L36CC:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	addi.l	#$1EA08,d0
	move.l	d0,-8(a6)
	move.l	-8(a6),a0
	moveq	#1,d0
	move.b	d0,(a0)
	move.l	-8(a6),a1
	move	4(a1),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	cmpi	#$F,(a0)
	bge.s	L3730
L3700:
	move.l	-8(a6),a0
	move	4(a0),-(sp)
	jsr	L2CEC
	addq	#2,sp
	move	d0,-4(a6)
	cmpi	#$FFFF,d0
	beq.s	L372A
	clr	-(sp)
	move	-4(a6),-(sp)
	jsr	L2E7A
	addq	#4,sp
	bra.s	L3700
;
L372A:
	jsr	L34EE
L3730:
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#1,d0
L373E:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3742:
	link	a6,#-6
	jsr	mask_interrupts
	move	d0,-6(a6)
	move	8(a6),d0
	ble.s	L3782
	cmpi	#$F,8(a6)
	bge.s	L3782
	move	8(a6),d0
	muls	#$2C,d0
	lea	L2C0E4,a0
	adda.l	d0,a0
	move.l	a0,-4(a6)
	cmpi.b	#2,(a0)
	beq.s	L3782
	move.l	-4(a6),a0
	move	8(a0),d0
	beq.s	L3792
L3782:
	move	-6(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#-1,d0
	bra.s	L37CC
;
L3792:
	move.l	-4(a6),a0
	move	10(a6),6(a0)
	move.l	-4(a6),a0
	addq	#1,8(a0)
	move.l	-4(a6),a0
	cmpi.b	#4,(a0)
	bne.s	L37BE
	moveq	#1,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L2E7A
	addq	#4,sp
L37BE:
	move	-6(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#1,d0
L37CC:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L37D0:
	link	a6,#-6
	jsr	mask_interrupts
	move	d0,-6(a6)
	move	8(a6),d0
	ble.s	L3806
	cmpi	#$F,8(a6)
	bge.s	L3806
	move	8(a6),d0
	muls	#$2C,d0
	lea	L2C0E4,a0
	adda.l	d0,a0
	move.l	a0,-4(a6)
	cmpi.b	#2,(a0)
	bne.s	L3816
L3806:
	move	-6(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#-1,d0
	bra.s	L384E
;
L3816:
	move.l	-4(a6),a0
	move	10(a6),6(a0)
	move.l	-4(a6),a0
	addq	#1,8(a0)
	move.l	-4(a6),a0
	cmpi.b	#4,(a0)
	bne.s	L3840
	clr	-(sp)
	move	8(a6),-(sp)
	jsr	L2E7A
	addq	#4,sp
L3840:
	move	-6(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#1,d0
L384E:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3852:
	link	a6,#-10
	movem.l	d7-d7/a5-a5,(sp)
	move	8(a6),d7
	jsr	mask_interrupts
	move	d0,-2(a6)
	move	d7,d0
	blt.s	L3888
	cmpi	#$28,d7
	bge.s	L3888
	move	d7,d0
	ext.l	d0
	lsl.l	#3,d0
	addi.l	#$1EA08,d0
	move.l	d0,a5
	move.l	a5,a0
	cmpi.b	#1,(a0)
	bne.s	L3898
L3888:
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#-1,d0
	bra.s	L38CC
;
L3898:
	move	2(a5),d0
	addq	#1,2(a5)
	move	d0,d0
	bge.s	L38BE
	moveq	#1,d0
	move	d0,-(sp)
	move	4(a5),-(sp)
	jsr	L2CEC
	addq	#2,sp
	move	d0,-(sp)
	jsr	L2E7A
	addq	#4,sp
L38BE:
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#1,d0
L38CC:
	movem.l	(sp),d7-d7/a5-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L38D4:
	link	a6,#-8
	jsr	mask_interrupts
	move	d0,-6(a6)
	move	8(a6),d0
	ble.s	L391A
	cmpi	#$F,8(a6)
	bge.s	L391A
	move	8(a6),d0
	beq.s	L391A
	move	8(a6),d0
	muls	#$2C,d0
	lea	L2C0E4,a0
	adda.l	d0,a0
	move.l	a0,-4(a6)
	cmpi.b	#1,(a0)
	beq.s	L392A
	move.l	-4(a6),a0
	cmpi.b	#3,(a0)
	beq.s	L392A
L391A:
	move	-6(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#-1,d0
	bra.s	L3972
;
L392A:
	move.l	-4(a6),a0
	cmpi.b	#3,(a0)
	bne.s	L394A
	move	8(a6),-(sp)
	jsr	L2C44
	addq	#2,sp
	move.l	-4(a6),a0
	moveq	#6,d0
	move.b	d0,(a0)
	bra.s	L3958
;
L394A:
	move.l	-4(a6),a0
	moveq	#6,d0
	move.b	d0,(a0)
	jsr	L34EE
L3958:
	move.l	-4(a6),a0
	move	2(a0),-8(a6)
	move	-6(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	move	-8(a6),d0
L3972:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3976:
	link	a6,#-10
	movem.l	a4-a5,(sp)
	jsr	mask_interrupts
	move	d0,-2(a6)
	move	8(a6),d0
	blt.s	L39AE
	cmpi	#$28,8(a6)
	bge.s	L39AE
	move	8(a6),d0
	ext.l	d0
	lsl.l	#3,d0
	addi.l	#$1EA08,d0
	move.l	d0,a5
	move.l	a5,a0
	cmpi.b	#1,(a0)
	bne.s	L39BE
L39AE:
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#-1,d0
	bra.s	L3A08
;
L39BE:
	subq	#1,2(a5)
	bge.s	L39FA
	move	L1EE60,d0
	muls	#$2C,d0
	addi.l	#$2C0E4,d0
	move.l	d0,a4
	move.l	a4,a0
	moveq	#7,d0
	move.b	d0,(a0)
	move	8(a6),4(a4)
	move	6(a5),-(sp)
	move	L1EE60,-(sp)
	jsr	L2BDA
	addq	#4,sp
	jsr	L34EE
L39FA:
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	moveq	#1,d0
L3A08:
	movem.l	(sp),a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3A10:
	link	a6,#-2
	move	8(a6),d0
	bge.s	L3A20
	moveq	#-1,d0
	bra	L3AA6
;
L3A20:
	move	8(a6),d0
	bne.s	L3A2E
	jsr	L34EE
	bra.s	L3AA4
;
L3A2E:
	jsr	mask_interrupts
	move	d0,-2(a6)
	move	8(a6),-(sp)
	move	L1EE64,-(sp)
	move	L1EE60,-(sp)
	jsr	L2F54
	addq	#6,sp
	moveq	#1,d0
	move	d0,L3673E
	move	L1EE64,d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move	(a0),d0
	ext.l	d0
	lsl.l	#3,d0
	addi.l	#$1EB48,d0
	move.l	d0,L315E2
	move	L1EE60,d0
	muls	#$2C,d0
	lea	L2C0E4,a0
	adda.l	d0,a0
	moveq	#5,d0
	move.b	d0,(a0)
	jsr	L34EE
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
L3AA4:
	moveq	#1,d0
L3AA6:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3AAA:
	link	a6,#0
	move	8(a6),d0
	bge.s	L3AB8
	moveq	#-1,d0
	bra.s	L3AFC
;
L3AB8:
	move	8(a6),d0
	bne.s	L3AC6
	jsr	L34EE
	bra.s	L3AFA
;
L3AC6:
	cmpi	#$3E8,8(a6)
	blt.s	L3AE2
	move	#$2710,-(sp)
	jsr	L3A10
	addq	#2,sp
	subi	#$3E8,8(a6)
	bra.s	L3AC6
;
L3AE2:
	move	8(a6),d0
	ble.s	L3AFA
	move	8(a6),d0
	muls	#$A,d0
	move	d0,-(sp)
	jsr	L3A10
	addq	#2,sp
L3AFA:
	moveq	#1,d0
L3AFC:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3B00:
	link	a6,#0
L3B04:
	move	L1EE64,d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	cmpi	#$F,(a0)
	bge.s	L3B5C
	move	L1EE64,d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move	(a0),d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB48,a0
	adda.l	d0,a0
	move	(a0),d0
	bgt.s	L3B5C
	clr	-(sp)
	move	L1EE64,-(sp)
	jsr	L2CEC
	addq	#2,sp
	move	d0,-(sp)
	jsr	L2E7A
	addq	#4,sp
	bra.s	L3B04
;
L3B5C:
	move	L1EE64,d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	cmpi	#$F,(a0)
	bge.s	L3B78
	moveq	#1,d0
	bra.s	L3B7A
;
L3B78:
	clr	d0
L3B7A:
	move	d0,L3673E
	beq.s	L3BA6
	move	L1EE64,d0
	ext.l	d0
	lsl.l	#3,d0
	lea	L1EB4A,a0
	adda.l	d0,a0
	move	(a0),d0
	ext.l	d0
	lsl.l	#3,d0
	addi.l	#$1EB48,d0
	move.l	d0,L315E2
L3BA6:
	jsr	L34EE
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3BB0:
	link	a6,#-2
	jsr	mask_interrupts
	move	d0,-2(a6)
	move	8(a6),d0
	add	d0,L18942
	move	L18942,8(a6)
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	move	8(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3BE4:
	link	a6,#-54
	moveq	#1,d0
	move	d0,-4(a6)
L3BEE:
	move	-4(a6),d0
	beq	L3CF6
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	clr	-(sp)
	jsr	L3BB0
	addq	#2,sp
	move	d0,d0
	bne.s	L3C14
	subq	#1,-4(a6)
L3C14:
	move	L18964,d0
	bne.s	L3C26
	cmpi	#$A,L468CC
	bne.s	L3BEE
L3C26:
	clr	L18964
	move.l	#L2C0E4,-54(a6)
	clr	-2(a6)
L3C38:
	cmpi	#$F,-2(a6)
	bge.s	L3BEE
	jsr	L1BBA
	moveq	#44,d0
	move	d0,-(sp)
	move.l	-54(a6),-(sp)
	pea	-50(a6)
	jsr	move_bytes
	adda	#$A,sp
	move	L3E74C,-6(a6)
	jsr	L1BC4
	cmpi.b	#2,-50(a6)
	bne.s	L3C84
L3C72:
	addq	#1,-2(a6)
	move.l	-54(a6),a0
	adda	#$2C,a0
	move.l	a0,-54(a6)
	bra.s	L3C38
;
L3C84:
	move	-2(a6),d0
	bne.s	L3CA0
	move	-6(a6),-(sp)
	pea	L18C26
	moveq	#10,d0
	move	d0,-(sp)
	jsr	L64FC
	addq	#8,sp
L3CA0:
	move.l	-22(a6),d0
	sub.l	-18(a6),d0
	move.l	d0,-(sp)
	move.l	-22(a6),-(sp)
	move.l	-14(a6),-(sp)
	move.l	-18(a6),-(sp)
	move	-42(a6),-(sp)
	move	-44(a6),-(sp)
	move	-46(a6),-(sp)
	move	-48(a6),-(sp)
	move.b	-50(a6),d0
	ext.w	d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18944,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	pea	-40(a6)
	pea	L18C88
	moveq	#10,d0
	move	d0,-(sp)
	jsr	L64FC
	adda	#$26,sp
	bra	L3C72
;
L3CF6:
	move	8(a6),-(sp)
	jsr	start_bbs
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3D06:
	link	a6,#0
	jsr	L3360
	move	d0,-(sp)
	jsr	L38D4
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3D1E:
	link	a6,#-4
	clr	-(sp)
	pea	L18CC0
	jsr	task_Fopen
	addq	#6,sp
	move	d0,-2(a6)
	bge.s	L3D4C
	pea	L18CCB
	clr	-(sp)
	jsr	L64FC
	addq	#6,sp
L3D48:
	moveq	#1,d0
	bra.s	L3D9A
;
L3D4C:
	move	#$574,-(sp)
	pea	L468CE
	move	-2(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move	d0,-4(a6)
	cmpi	#$574,-4(a6)
	bge.s	L3D8C
	pea	L18CE5
	clr	-(sp)
	jsr	L64FC
	addq	#6,sp
	move	-2(a6),-(sp)
	jsr	task_Fclose
	addq	#2,sp
	bra.s	L3D48
;
L3D8C:
	move	-2(a6),-(sp)
	jsr	task_Fclose
	addq	#2,sp
	clr	d0
L3D9A:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L3D9E:
	link	a6,#-34
	move.l	#L18D07,-10(a6)
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L362E
	addq	#2,sp
	move	d0,L468CA
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L362E
	addq	#2,sp
	move	d0,L2C0A6
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L362E
	addq	#2,sp
	move	d0,L36744
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L362E
	addq	#2,sp
	move	d0,L46E42
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L362E
	addq	#2,sp
	move	d0,L36742
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L362E
	addq	#2,sp
	move	d0,L467C6
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L362E
	addq	#2,sp
	move	d0,L467C8
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L362E
	addq	#2,sp
	move	d0,L2C0A8
	clr	-2(a6)
L3E3E:
	cmpi	#$14,-2(a6)
	bge.s	L3E60
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76A,a0
	adda.l	d0,a0
	moveq	#-1,d0
	move	d0,(a0)
	addq	#1,-2(a6)
	bra.s	L3E3E
;
L3E60:
	jsr	L72C2
	clr	-2(a6)
L3E6A:
	cmpi	#80,-2(a6)
	bge.s	L3E90
	move	#$700,-(sp)
	moveq	#45,d0
	move	d0,-(sp)
	move	-2(a6),-(sp)
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L59C
	addq	#8,sp
	addq	#1,-2(a6)
	bra.s	L3E6A
;
L3E90:
	moveq	#2,d0
	move	d0,-(sp)
	move	L315FA,-(sp)
	jsr	L37D0
	addq	#4,sp
	pea	L188B0
	clr	-(sp)
	jsr	L64FC
	addq	#6,sp
	pea	L18D15
	clr	-(sp)
	jsr	L64FC
	addq	#6,sp
	jsr	L3D1E
	move	d0,d0
	beq.s	L3EDC
	moveq	#10,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra	L4132
;
L3EDC:
	jsr	L70B4
	jsr	LCC12
	move	d0,d0
	beq.s	L3F0A
	pea	L18D36
	clr	-(sp)
	jsr	L64FC
	addq	#6,sp
	moveq	#10,d0
	move	d0,-(sp)
	jsr	L3AAA
	bra	L412A
;
L3F0A:
	pea	L18D68
	clr	-(sp)
	jsr	L64FC
	addq	#6,sp
	clr.b	L315E6
	move.l	#L188B0,L2C0AC
	clr	L3E7BA
	pea	L188B0
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	pea	L188B0
	jsr	L1B0
	addq	#6,sp
	move	d0,-12(a6)
	jsr	L3360
	move	d0,-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	pea	L18D7B
	moveq	#20,d0
	move	d0,-(sp)
	move	#$400,-(sp)
	pea	L3BE4
	jsr	init_bbs
	adda	#$10,sp
	move	d0,-4(a6)
	move	d0,-(sp)
	jsr	start_bbs
	addq	#2,sp
	jsr	L43D4
	move.l	-10(a6),L2DFBA
	clr	-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	pea	L18D88
	moveq	#20,d0
	move	d0,-(sp)
	move	#$2000,-(sp)
	pea	L4584
	jsr	init_bbs
	adda	#$10,sp
	move	d0,-34(a6)
	move	d0,-(sp)
	jsr	start_bbs
	addq	#2,sp
	move	-34(a6),d0
	blt.s	L3FE2
	move	-34(a6),d0
	muls	#$2C,d0
	lea	L2C10E,a0
	adda.l	d0,a0
	clr	(a0)
L3FE2:
	moveq	#1,d0
	move	d0,-2(a6)
L3FE8:
	cmpi	#3,-2(a6)
	bgt	L40A4
	move	-2(a6),-(sp)
	pea	L18D90
	move	-2(a6),-(sp)
	jsr	L64FC
	addq	#8,sp
	move	-2(a6),a0
	adda.l	#L46B27,a0
	move.b	(a0),d0
	bne.s	L401C
L4016:
	addq	#1,-2(a6)
	bra.s	L3FE8
;
L401C:
	move	-2(a6),d0
	muls	#$1016,d0
	lea	L2DFBA,a0
	adda.l	d0,a0
	move.l	-10(a6),(a0)
	move	-2(a6),-(sp)
	pea	L18DAF
	pea	-32(a6)
	jsr	L16E2A
	adda	#$A,sp
	move	-12(a6),d0
	cmp	L18968,d0
	bne.s	L4086
	move	-2(a6),-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	pea	-32(a6)
	moveq	#20,d0
	move	d0,-(sp)
	move	#$2000,-(sp)
	pea	L4584
	jsr	init_bbs
	adda	#$10,sp
	move	d0,-34(a6)
	move	d0,-(sp)
	jsr	start_bbs
	addq	#2,sp
L4086:
	move	-34(a6),d0
	blt.s	L4016
	move	-34(a6),d0
	muls	#$2C,d0
	lea	L2C10E,a0
	adda.l	d0,a0
	move	-2(a6),(a0)
	bra	L4016
;
L40A4:
	clr	-(sp)
	clr	-(sp)
	pea	L18DB8
	moveq	#20,d0
	move	d0,-(sp)
	move	#$400,-(sp)
	pea	L4252
	jsr	init_bbs
	adda	#$10,sp
	move	d0,-6(a6)
	move	d0,-(sp)
	jsr	start_bbs
	addq	#2,sp
	moveq	#4,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	moveq	#-1,d0
	move	d0,-(sp)
	jsr	L3BB0
	addq	#2,sp
	move	-4(a6),d0
	ble.s	L4104
	jsr	L3360
	move	d0,-(sp)
	jsr	L38D4
	addq	#2,sp
	bra.s	L4120
;
L4104:
	clr	-(sp)
	jsr	L3BB0
	addq	#2,sp
	move	d0,d0
	beq.s	L4120
	moveq	#5,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L4104
;
L4120:
	move	-6(a6),-(sp)
	jsr	L336E
L412A:
	addq	#2,sp
	jsr	L7116
L4132:
	jsr	L73B6
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L413C:
	link	a6,#-2
	jsr	mask_interrupts
	move	d0,-2(a6)
	move.l	8(a6),a0
	move	12(a6),2968(a0)
	move	-2(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4164:
	link	a6,#0
	clr	-(sp)
	jsr	L6F0E
	addq	#2,sp
	move	d0,L2DFB2
	subq	#1,L2E122
	move	L2DFAC,d0
	beq.s	L419A
	move	L2D5AC,d0
	beq.s	L4194
	subq	#1,L2D5AC
L4194:
	addq	#1,L2DFB0
L419A:
	move.b	L46B28,d0
	beq.s	L41D6
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L6F0E
	addq	#2,sp
	move	d0,L2EFC8
	subq	#1,L2F138
	move	L2EFC2,d0
	beq.s	L41D6
	move	L2E5C2,d0
	beq.s	L41D0
	subq	#1,L2E5C2
L41D0:
	addq	#1,L2EFC6
L41D6:
	move.b	L46B29,d0
	beq.s	L4212
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L6F0E
	addq	#2,sp
	move	d0,L2FFDE
	subq	#1,L3014E
	move	L2FFD8,d0
	beq.s	L4212
	move	L2F5D8,d0
	beq.s	L420C
	subq	#1,L2F5D8
L420C:
	addq	#1,L2FFDC
L4212:
	move.b	L46B2A,d0
	beq.s	L424E
	moveq	#3,d0
	move	d0,-(sp)
	jsr	L6F0E
	addq	#2,sp
	move	d0,L30FF4
	subq	#1,L31164
	move	L30FEE,d0
	beq.s	L424E
	move	L305EE,d0
	beq.s	L4248
	subq	#1,L305EE
L4248:
	addq	#1,L30FF2
L424E:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4252:
	link	a6,#-118
	clr	-12(a6)
	clr	-10(a6)
	moveq	#3,d0
	move	d0,-14(a6)
L4264:
	move	-14(a6),d0
	beq.s	L427E
	move	-14(a6),a0
	adda.l	#L46B27,a0
	move.b	(a0),d0
	bne.s	L427E
	subq	#1,-14(a6)
	bra.s	L4264
;
L427E:
	move	L3E758,d0
	bge.s	L428A
	moveq	#1,d0
	bra.s	L428C
;
L428A:
	clr	d0
L428C:
	move	d0,-8(a6)
	beq.s	L4298
	clr	L3E758
L4298:
	clr	-4(a6)
	cmpi	#1,-14(a6)
	ble.s	L42B6
	addq	#1,-10(a6)
	move	-10(a6),d0
	cmp	-14(a6),d0
	ble.s	L42B6
	clr	-10(a6)
L42B6:
	clr	-2(a6)
L42BA:
	cmpi	#1,-2(a6)
	bgt	L43B4
	cmpi	#2,L3E74C
	ble	L43B4
	move	-10(a6),d0
	add	-2(a6),d0
	cmp	-14(a6),d0
	ble.s	L42E2
	clr	d0
	bra.s	L42EA
;
L42E2:
	move	-2(a6),d0
	add	-10(a6),d0
L42EA:
	muls	#$1016,d0
	addi.l	#$2D58A,d0
	move.l	d0,-18(a6)
	jsr	mask_interrupts
	move	d0,-6(a6)
	move	-8(a6),d0
	beq.s	L4310
	move.l	-18(a6),a0
	clr	2602(a0)
L4310:
	move.l	-18(a6),a0
	cmpi	#1,2602(a0)
	ble.s	L4328
	addq	#1,-4(a6)
	move.l	-18(a6),a0
	subq	#1,2602(a0)
L4328:
	move	-6(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	move.l	-18(a6),a0
	move	34(a0),-(sp)
	move.l	-18(a6),a0
	move	2598(a0),-(sp)
	move.l	-18(a6),a0
	move.l	2608(a0),-(sp)
	move.l	-18(a6),a0
	pea	2612(a0)
	move.l	-18(a6),a0
	pea	2(a0)
	move.l	-18(a6),a0
	move	2602(a0),d0
	beq.s	L436A
	moveq	#67,d0
	bra.s	L4376
;
L436A:
	move.l	-18(a6),a0
	move	32(a0),d0
	addi	#$30,d0
L4376:
	move	d0,-(sp)
	move.l	-18(a6),a0
	move.l	2604(a0),-(sp)
	pea	L18DC3
	pea	-118(a6)
	jsr	L16E2A
	adda	#$1E,sp
	pea	-118(a6)
	move	#$700,-(sp)
	clr	-(sp)
	move	-2(a6),-(sp)
	jsr	L5C0
	adda	#$A,sp
	addq	#1,-2(a6)
	bra	L42BA
;
L43B4:
	move	-4(a6),d0
	beq.s	L43C0
	jsr	L24C
L43C0:
	moveq	#3,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra	L427E
;
L43D0:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L43D4:
	link	a6,#-8
	clr	-6(a6)
L43DC:
	cmpi	#4,-6(a6)
	bge	L4580
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L2D57A,a0
	adda.l	d0,a0
	move	-6(a6),d0
	muls	#$1016,d0
	addi.l	#$2D58A,d0
	move.l	d0,(a0)
	move.l	d0,-4(a6)
	move	-6(a6),d0
	bne.s	L441C
	move.l	-4(a6),a0
	move.l	#L18DEB,2604(a0)
L441C:
	cmpi	#1,-6(a6)
	bne.s	L4430
	move.l	-4(a6),a0
	move.l	#L18DF3,2604(a0)
L4430:
	cmpi	#2,-6(a6)
	bne.s	L4444
	move.l	-4(a6),a0
	move.l	#L18DFB,2604(a0)
L4444:
	cmpi	#3,-6(a6)
	bne.s	L4458
	move.l	-4(a6),a0
	move.l	#L18E03,2604(a0)
L4458:
	cmpi	#4,-6(a6)
	bne.s	L446C
	move.l	-4(a6),a0
	move.l	#L18E0B,2604(a0)
L446C:
	cmpi	#5,-6(a6)
	bne.s	L4480
	move.l	-4(a6),a0
	move.l	#L18E13,2604(a0)
L4480:
	cmpi	#6,-6(a6)
	bne.s	L4494
	move.l	-4(a6),a0
	move.l	#L18E1B,2604(a0)
L4494:
	cmpi	#7,-6(a6)
	bne.s	L44A8
	move.l	-4(a6),a0
	move.l	#L18E23,2604(a0)
L44A8:
	cmpi	#8,-6(a6)
	bne.s	L44BC
	move.l	-4(a6),a0
	move.l	#L18E2B,2604(a0)
L44BC:
	move.l	-4(a6),a0
	clr.b	2612(a0)
	move.l	-4(a6),a0
	move.l	#L18E33,2608(a0)
	move.l	-4(a6),a0
	clr	2594(a0)
	move.l	-4(a6),a0
	clr	2596(a0)
	move.l	-4(a6),a0
	clr	2974(a0)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#5,d0
	addi.l	#$3E7C6,d0
	move.l	-4(a6),a0
	move.l	d0,2894(a0)
	move.l	-4(a6),a0
	move	-6(a6),(a0)
	pea	L18E42
	move.l	-4(a6),a0
	pea	2(a0)
	jsr	L11FEC
	addq	#8,sp
	clr	-8(a6)
L4522:
	cmpi	#$1A,-8(a6)
	bge.s	L4554
	move	-8(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	-4(a6),a0
	clr.b	194(a0)
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	-4(a6),a0
	clr	142(a0)
	addq	#1,-8(a6)
	bra.s	L4522
;
L4554:
	clr	-8(a6)
L4558:
	cmpi	#4,-8(a6)
	bge.s	L4578
	move	-8(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	-4(a6),a0
	clr.b	2274(a0)
	addq	#1,-8(a6)
	bra.s	L4558
;
L4578:
	addq	#1,-6(a6)
	bra	L43DC
;
L4580:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4584:
	link	a6,#-18
	move.l	a3,-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3BB0
	addq	#2,sp
	move	8(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L2D57A,a0
	adda.l	d0,a0
	move.l	(a0),-4(a6)
	move.l	-4(a6),-(sp)
	jsr	L16E58
	addq	#4,sp
	move.l	-4(a6),a0
	pea	2902(a0)
	jsr	L176
	addq	#4,sp
	move	d0,-6(a6)
	move.l	-4(a6),-(sp)
	jsr	L707E
	addq	#4,sp
	move.l	-4(a6),a0
	clr	2594(a0)
	move	-6(a6),d0
	beq	L4692
	clr	-8(a6)
L45EA:
	cmpi	#$14,-8(a6)
	bge.s	L4648
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76A,a3
	adda.l	d0,a3
	jsr	L3360
	cmp	(a3),d0
	bne.s	L4642
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76C,a0
	adda.l	d0,a0
	move	(a0),-10(a6)
	ble.s	L4642
	move	-10(a6),-(sp)
	jsr	task_Fclose
	addq	#2,sp
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76A,a0
	adda.l	d0,a0
	moveq	#-1,d0
	move	d0,(a0)
L4642:
	addq	#1,-8(a6)
	bra.s	L45EA
;
L4648:
	cmpi	#7,-6(a6)
	beq.s	L465C
	move.l	-4(a6),-(sp)
	jsr	L17268
	addq	#4,sp
L465C:
	move.l	-4(a6),-(sp)
	jsr	LD844
	addq	#4,sp
	move.l	-4(a6),-(sp)
	jsr	LDB7C
	addq	#4,sp
	jsr	L4992
	moveq	#12,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	user_conout_2
	addq	#4,sp
	move.l	-4(a6),a0
	clr.b	2612(a0)
L4692:
	cmpi	#7,-6(a6)
	beq.s	L46B4
	clr	-(sp)
	move	8(a6),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move.l	-4(a6),-(sp)
	jsr	L170AE
	addq	#4,sp
L46B4:
	moveq	#3,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move	L3E7BA,d0
	beq.s	L46E8
	move.l	-4(a6),a0
	move.l	#L18E49,2608(a0)
	moveq	#-1,d0
	move	d0,-(sp)
	jsr	L3BB0
	addq	#2,sp
	bra	L47C0
;
L46E8:
	move.l	-4(a6),a0
	move	#$B4,34(a0)
	move.l	-4(a6),a0
	move	#$B4,2978(a0)
	pea	-14(a6)
	jsr	L47FA
	addq	#4,sp
	move	d0,d0
	beq.s	L4772
	move	8(a6),-(sp)
	move.l	-14(a6),-(sp)
	pea	L18E59
	jsr	L6526
	adda	#$A,sp
	move.l	-14(a6),-(sp)
	pea	L18E79
	jsr	L63E0
	addq	#8,sp
	pea	L18E99
	jsr	L63E0
	addq	#4,sp
	move.l	-4(a6),-(sp)
	jsr	sys_sysdump_func
	addq	#4,sp
	move.l	-4(a6),a0
	move	(a0),-(sp)
	jsr	L6D5A
	addq	#2,sp
	moveq	#6,d0
	move	d0,-(sp)
	move.l	-4(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
L4772:
	moveq	#12,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	user_conout_2
	addq	#4,sp
	move.l	L2C0AC,-(sp)
	jsr	L63E0
	addq	#4,sp
	move.l	-4(a6),-(sp)
	jsr	L7050
	addq	#4,sp
	move.l	-4(a6),-(sp)
	jsr	L105CC
	addq	#4,sp
	move.l	-4(a6),-(sp)
	jsr	LC83A
	addq	#4,sp
	move.l	-4(a6),-(sp)
	jsr	L4D02
	addq	#4,sp
L47C0:
	moveq	#1,d0
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L47C8:
	link	a6,#0
	move	8(a6),d0
	beq.s	L47E8
	moveq	#2,d0
	move	d0,-(sp)
	move.l	14(a6),-(sp)
	jsr	task_Fopen
	addq	#6,sp
	move.l	10(a6),a0
	move	d0,(a0)
L47E8:
	move.l	10(a6),a0
	move	(a0),d0
	bgt.s	L47F4
	moveq	#1,d0
	bra.s	L47F6
;
L47F4:
	clr	d0
L47F6:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L47FA:
	link	a6,#-8
	moveq	#1,d0
	move	d0,-4(a6)
	move	L36742,-(sp)
	jsr	L3976
	addq	#2,sp
	addq	#1,L18966
	move.l	L1886C,-8(a6)
	move.l	-8(a6),-(sp)
	pea	L2C0B6
	cmpi	#1,L18966
	bne.s	L483A
	moveq	#1,d0
	move	d0,-(sp)
	bra.s	L483C
;
L483A:
	clr	-(sp)
L483C:
	jsr	L47C8
	adda	#$A,sp
	move	d0,d0
	bne	L4958
	move.l	L18870,-8(a6)
	move.l	-8(a6),-(sp)
	pea	L2C0B8
	cmpi	#1,L18966
	bne.s	L486E
	moveq	#1,d0
	move	d0,-(sp)
	bra.s	L4870
;
L486E:
	clr	-(sp)
L4870:
	jsr	L47C8
	adda	#$A,sp
	move	d0,d0
	bne	L4958
	move.l	L18860,-8(a6)
	move.l	-8(a6),-(sp)
	pea	L2C0B0
	cmpi	#1,L18966
	bne.s	L48A2
	moveq	#1,d0
	move	d0,-(sp)
	bra.s	L48A4
;
L48A2:
	clr	-(sp)
L48A4:
	jsr	L47C8
	adda	#$A,sp
	move	d0,d0
	bne	L4958
	cmpi	#1,L18966
	bne.s	L48DC
	move	#$2002,-(sp)
	pea	L46E44
	move	L2C0B0,-(sp)
	jsr	task_Fread
	addq	#8,sp
	cmpi	#$2002,d0
	bne.s	L4958
L48DC:
	move.l	L18864,-8(a6)
	move.l	-8(a6),-(sp)
	pea	L2C0B2
	cmpi	#1,L18966
	bne.s	L48FE
	moveq	#1,d0
	move	d0,-(sp)
	bra.s	L4900
;
L48FE:
	clr	-(sp)
L4900:
	jsr	L47C8
	adda	#$A,sp
	move	d0,d0
	bne.s	L4958
	cmpi	#1,L18966
	bne.s	L4922
	jsr	L9D5E
	move	d0,d0
	bne.s	L4958
L4922:
	move.l	L18868,-8(a6)
	move.l	-8(a6),-(sp)
	pea	L2C0B4
	cmpi	#1,L18966
	bne.s	L4944
	moveq	#1,d0
	move	d0,-(sp)
	bra.s	L4946
;
L4944:
	clr	-(sp)
L4946:
	jsr	L47C8
	adda	#$A,sp
	move	d0,d0
	bne.s	L4958
	clr	-4(a6)
L4958:
	move	L2C0B6,-2(a6)
	ble.s	L4974
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
L4974:
	move	L36742,-(sp)
	jsr	L3852
	addq	#2,sp
	move.l	8(a6),a0
	move.l	-8(a6),(a0)
	move	-4(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4992:
	link	a6,#0
	move	L36742,-(sp)
	jsr	L3976
	addq	#2,sp
	subq	#1,L18966
	bne	L4A3A
	move	L2C0B0,d0
	ble.s	L49C4
	move	L2C0B0,-(sp)
	jsr	task_Fclose
	addq	#2,sp
L49C4:
	clr	L2C0B0
	move	L2C0B2,d0
	ble.s	L49E0
	move	L2C0B2,-(sp)
	jsr	task_Fclose
	addq	#2,sp
L49E0:
	clr	L2C0B2
	move	L2C0B4,d0
	ble.s	L49FC
	move	L2C0B4,-(sp)
	jsr	task_Fclose
	addq	#2,sp
L49FC:
	clr	L2C0B4
	move	L2C0B6,d0
	ble.s	L4A18
	move	L2C0B6,-(sp)
	jsr	task_Fclose
	addq	#2,sp
L4A18:
	clr	L2C0B6
	move	L2C0B8,d0
	ble.s	L4A34
	move	L2C0B8,-(sp)
	jsr	task_Fclose
	addq	#2,sp
L4A34:
	clr	L2C0B6
L4A3A:
	move	L36742,-(sp)
	jsr	L3852
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4A4C:
	link	a6,#-4
	jsr	L3360
	move	d0,-4(a6)
	move	L2C0A8,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-2(a6)
L4A6C:
	cmpi	#$14,-2(a6)
	bge.s	L4AC0
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76A,a0
	adda.l	d0,a0
	move	(a0),d0
	cmp	-4(a6),d0
	bne.s	L4ABA
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76C,a0
	adda.l	d0,a0
	move	8(a6),d0
	cmp	(a0),d0
	bne.s	L4ABA
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76A,a0
	adda.l	d0,a0
	moveq	#-1,d0
	move	d0,(a0)
	bra.s	L4AC0
;
L4ABA:
	addq	#1,-2(a6)
	bra.s	L4A6C
;
L4AC0:
	move	L2C0A8,-(sp)
	jsr	L3852
	addq	#2,sp
	move	8(a6),-(sp)
	jsr	task_Fclose
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4ADE:
	link	a6,#-8
	move.l	a3,-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	task_Fopen
	addq	#6,sp
	move	d0,-2(a6)
	ble.s	L4B6A
	move	L2C0A8,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-4(a6)
L4B0C:
	cmpi	#$14,-4(a6)
	bge.s	L4B5C
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76A,a0
	adda.l	d0,a0
	move	(a0),d0
	bge.s	L4B56
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76A,a3
	adda.l	d0,a3
	jsr	L3360
	move	d0,(a3)
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76C,a0
	adda.l	d0,a0
	move	-2(a6),(a0)
	bra.s	L4B5C
;
L4B56:
	addq	#1,-4(a6)
	bra.s	L4B0C
;
L4B5C:
	move	L2C0A8,-(sp)
	jsr	L3852
	addq	#2,sp
L4B6A:
	move	-2(a6),d0
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4B74:
	link	a6,#-8
	move.l	a3,-(sp)
	move.l	8(a6),-(sp)
	jsr	task_Fcreate
	addq	#4,sp
	move	d0,-2(a6)
	ble.s	L4BFC
	move	L2C0A8,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-4(a6)
L4B9E:
	cmpi	#$14,-4(a6)
	bge.s	L4BEE
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76A,a0
	adda.l	d0,a0
	move	(a0),d0
	bge.s	L4BE8
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76A,a3
	adda.l	d0,a3
	jsr	L3360
	move	d0,(a3)
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E76C,a0
	adda.l	d0,a0
	move	-2(a6),(a0)
	bra.s	L4BEE
;
L4BE8:
	addq	#1,-4(a6)
	bra.s	L4B9E
;
L4BEE:
	move	L2C0A8,-(sp)
	jsr	L3852
	addq	#2,sp
L4BFC:
	move	-2(a6),d0
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4C06:
	link	a6,#-4
	move.l	10(a6),a0
	clr.b	(a0)
	clr	-2(a6)
.L4C14:
	move	-2(a6),d0
	cmp	14(a6),d0
	bge	.L4CF4
	move.l	16(a6),a0
	move	(a0),d0
	bgt.s	.L4C56
	move	#$200,-(sp)
	move.l	16(a6),d0
	addq.l	#6,d0
	move.l	16(a6),a0
	move.l	d0,2(a0)
	move.l	d0,-(sp)
	move	8(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move.l	16(a6),a0
	move	d0,(a0)
	bgt.s	.L4C56
	moveq	#-1,d0
	bra	.L4CFE
;
.L4C56:
	move.l	16(a6),a0
	move.l	2(a0),a0
	move.b	(a0),d0
	ext.w	d0
.L4C62:
	andi	#$7F,d0		;patch editld_limit_here
	move	d0,-4(a6)
	move.l	16(a6),a0
	addq.l	#1,2(a0)
	move.l	16(a6),a0
	subq	#1,(a0)
	cmpi	#$1A,-4(a6)
	bne.s	.L4C9A
	move.l	16(a6),a0
	clr	(a0)
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	8(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	bra.s	.L4CF4
;
.L4C9A:
	cmpi	#$D,-4(a6)
	beq	.L4C14
	cmpi	#9,-4(a6)
	bne.s	.L4CC6
.L4CAC:
	move.l	10(a6),a0
	addq.l	#1,10(a6)
	moveq	#32,d0
	move.b	d0,(a0)
	addq	#1,-2(a6)
	move	-2(a6),d0
	andi	#7,d0
	bne.s	.L4CAC
.L4CC6:
	cmpi	#$A,-4(a6)
	bne.s	.L4CD4
	addq	#1,-2(a6)
	bra.s	.L4CF4
;
.L4CD4:
	cmpi	#$20,-4(a6)
	blt	.L4C14
	addq	#1,-2(a6)
	move.l	10(a6),a0
	addq.l	#1,10(a6)
	move	-4(a6),d0
	move.b	d0,(a0)
	bra	.L4C14
;
.L4CF4:
	move.l	10(a6),a0
	clr.b	(a0)
	move	-2(a6),d0
.L4CFE:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4D02:
	link	a6,#0
	move.l	8(a6),a0
	clr	2990(a0)
L4D0E:
	pea	L18EB0
	move.l	8(a6),-(sp)
	jsr	L10558
	addq	#8,sp
	move	d0,d0
	beq.s	L4D0E
	pea	L18EB5
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	blt.s	L4D5A
	pea	L18ECE
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),-(sp)
	jsr	L14378
L4D56:
	addq	#4,sp
	bra.s	L4D0E
;
L4D5A:
	pea	L18EF3
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),-(sp)
	jsr	LC9B2
	bra.s	L4D56
;
L4D74:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4D78:
	link	a6,#0
	move.l	8(a6),a0
	move	46(a0),d0
	bne.s	L4D90
	move.l	8(a6),a0
	moveq	#1,d0
	move	d0,46(a0)
L4D90:
	move	12(a6),d0
	cmp	L2C0BA,d0
	bgt.s	L4DE4
	cmpi	#1,12(a6)
	blt.s	L4DE4
	move	12(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#5,d0
	lea	L4691E,a0
	adda.l	d0,a0
	move.b	(a0),d0
	beq.s	L4DE4
	move	12(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a1
	adda.l	d0,a1
	move.l	8(a6),a0
	move	46(a0),d0
	and	(a1),d0
	bne.s	L4DE8
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	bge.s	L4DE8
L4DE4:
	clr	d0
	bra.s	L4DEA
;
L4DE8:
	moveq	#1,d0
L4DEA:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4DEE:
	link	a6,#-2
	move.l	8(a6),a0
	move.l	#L18F1D,2608(a0)
L4DFE:
	pea	L18F28
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#-3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-2(a6)
	blt.s	L4EAC
	move	-2(a6),d0
	beq.s	L4EA0
	move	-2(a6),d0
	cmp	L2C0BA,d0
	bgt.s	L4E56
	move	-2(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#5,d0
	lea	L4691E,a0
	adda.l	d0,a0
	move.b	(a0),d0
	bne.s	L4E66
L4E56:
	pea	L18F66
	jsr	L63E0
L4E62:
	addq	#4,sp
	bra.s	L4DFE
;
L4E66:
	move	-2(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L4D78
	addq	#6,sp
	move	d0,d0
	beq.s	L4E8A
	move	-2(a6),d0
	subq	#1,d0
	move.l	8(a6),a0
	move	d0,2970(a0)
	bra.s	L4EAC
;
L4E8A:
	move	-2(a6),-(sp)
	pea	L18F7E
	jsr	L63E0
	addq	#6,sp
L4E9C:
	bra	L4DFE
;
L4EA0:
	move.l	8(a6),-(sp)
	jsr	L4EB2
	bra.s	L4E62
;
L4EAC:
	clr	d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4EB2:
	link	a6,#-8
	pea	L18FA6
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-4(a6)
L4ECA:
	move	-4(a6),d0
	cmp	L2C0BA,d0
	bgt	L4F7C
	move	-4(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L4D78
	addq	#6,sp
	move	d0,d0
	beq.s	L4EF0
	moveq	#42,d0
	bra.s	L4EF2
;
L4EF0:
	moveq	#32,d0
L4EF2:
	move	d0,-2(a6)
	move.l	8(a6),a0
	move	-4(a6),d0
	subq	#1,d0
	cmp	48(a0),d0
	bne.s	L4F0A
	moveq	#68,d0
	bra.s	L4F0E
;
L4F0A:
	move	-2(a6),d0
L4F0E:
	move	d0,-2(a6)
	move	-4(a6),d0
	andi	#1,d0
	beq.s	L4F28
	move	-4(a6),d0
	cmp	L2C0BA,d0
	bne.s	L4F30
L4F28:
	pea	L18FF0
	bra.s	L4F36
;
L4F30:
	pea	L18FF2
L4F36:
	move	-4(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#5,d0
	lea	L4691E,a0
	adda.l	d0,a0
	move.l	a0,-8(a6)
	move.b	(a0),d0
	beq.s	L4F56
	move.l	-8(a6),-(sp)
	bra.s	L4F5C
;
L4F56:
	pea	L18FE3
L4F5C:
	move	-2(a6),-(sp)
	move	-4(a6),-(sp)
	pea	L18FD1
	jsr	L63E0
	adda	#$10,sp
	addq	#1,-4(a6)
	bra	L4ECA
;
L4F7C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4F80:
	link	a6,#0
	move	L36740,d0
	beq.s	L4FA6
	pea	L18FF3
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	moveq	#31,d0
	move	d0,2602(a0)
	bra.s	L4FB4
;
L4FA6:
	pea	L19031
	jsr	L63E0
	addq	#4,sp
L4FB4:
	clr	d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L4FBA:
	link	a6,#-118
	move.l	8(a6),a0
	move.l	#L1905C,2608(a0)
	pea	L19062
	jsr	L63E0
	addq	#4,sp
	pea	L1906D
	jsr	L63E0
	addq	#4,sp
	clr	-4(a6)
L4FEA:
	cmpi	#4,-4(a6)
	bge.s	L504E
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L2D57A,a0
	adda.l	d0,a0
	move.l	(a0),-114(a6)
	move.l	-114(a6),a0
	move	2974(a0),d0
	beq.s	L5048
	move.l	-114(a6),a0
	move	2596(a0),d0
	beq.s	L5048
	move.l	8(a6),a1
	move.l	-114(a6),a0
	move	(a0),d0
	cmp	(a1),d0
	beq.s	L5048
	move.l	-114(a6),a0
	pea	2(a0)
	move.l	-114(a6),a0
	move	2974(a0),-(sp)
	pea	L19088
	jsr	L63E0
	adda	#$A,sp
L5048:
	addq	#1,-4(a6)
	bra.s	L4FEA
;
L504E:
	pea	L19090
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#-2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-2(a6)
	move	-2(a6),d0
	bne.s	L5088
	moveq	#1,d0
	move	d0,-2(a6)
L5088:
	move	-2(a6),d0
	blt	L5282
	cmpi	#4,-2(a6)
	bgt	L5282
	move	-2(a6),-(sp)
	pea	L190B1
	jsr	L63E0
	addq	#6,sp
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move.l	8(a6),a0
	move	-2(a6),2974(a0)
	moveq	#1,d0
	move	d0,-8(a6)
	clr	-10(a6)
L50D2:
	move.l	8(a6),a0
	move	2600(a0),d0
	beq	L525C
	move	-10(a6),d0
	bne	L525C
	move	-8(a6),d0
	bne.s	L513E
	move	-2(a6),-(sp)
	pea	L190DA
	jsr	L63E0
	addq	#6,sp
	clr	-(sp)
	moveq	#78,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	bne.s	L5154
	pea	L190DF
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L11FEC
	addq	#8,sp
	moveq	#1,d0
	move	d0,-10(a6)
	bra.s	L5154
;
L513E:
	pea	L190E8
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L11FEC
	addq	#8,sp
L5154:
	clr	-8(a6)
	pea	L190F0
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	L5182
	move.l	8(a6),-(sp)
	jsr	L5286
	addq	#4,sp
	bra	L50D2
;
L5182:
	pea	L190F8
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	L51B4
	pea	-118(a6)
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	sys_who_func
	adda	#$A,sp
	bra	L50D2
;
L51B4:
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L11FCA
	addq	#4,sp
	move	d0,d0
	beq	L50D2
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L190FD
	pea	-110(a6)
	jsr	L16E2A
	adda	#$10,sp
	pea	-110(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-6(a6)
	clr	-4(a6)
L5202:
	cmpi	#4,-4(a6)
	bge	L50D2
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L2D57A,a0
	adda.l	d0,a0
	move.l	(a0),-114(a6)
	move.l	-114(a6),a0
	move	2600(a0),d0
	beq.s	L5256
	move.l	-114(a6),a0
	move	2974(a0),d0
	cmp	-2(a6),d0
	bne.s	L5256
	move.l	-114(a6),a0
	move	2596(a0),d0
	beq.s	L5256
	move	-6(a6),-(sp)
	pea	-110(a6)
	move	-4(a6),-(sp)
	jsr	L6D80
	addq	#8,sp
L5256:
	addq	#1,-4(a6)
	bra.s	L5202
;
L525C:
	move.l	8(a6),a0
	clr	2974(a0)
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	moveq	#3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DDC
	addq	#4,sp
L5282:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5286:
	link	a6,#-62
	pea	-62(a6)
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	sys_who_func
	adda	#$A,sp
	move	d0,-2(a6)
	move.l	8(a6),a0
	move.l	#L19114,2608(a0)
	move	-2(a6),-(sp)
	pea	L1911B
	jsr	L63E0
	addq	#6,sp
	clr	-(sp)
	moveq	#-2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-4(a6)
	move	-4(a6),d0
	blt	L53C8
	move	-4(a6),d0
	cmp	-2(a6),d0
	bgt	L53C8
	move.l	8(a6),a0
	move	-4(a6),d0
	cmp	(a0),d0
	bne.s	L5312
	pea	L1914D
	jsr	L63E0
	addq	#4,sp
	bra	L53C8
;
L5312:
	move.l	8(a6),a0
	move	(a0),d1
	muls	#80,d1
	move	-4(a6),d0
	muls	#$1016,d0
	add.l	d1,d0
	addi.l	#$2DE6C,d0
	move.l	d0,-58(a6)
	move.l	-58(a6),a0
	move.b	(a0),d0
	beq.s	L534C
	move	-4(a6),-(sp)
	pea	L1916B
L5342:
	jsr	L63E0
	addq	#6,sp
	bra.s	L53C8
;
L534C:
	move	-4(a6),d0
	muls	#$1016,d0
	lea	L2DFAE,a0
	adda.l	d0,a0
	move	(a0),d0
	bne.s	L536C
	move	-4(a6),-(sp)
	pea	L19192
	bra.s	L5342
;
L536C:
	pea	L191B3
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#50,d0
	move	d0,-(sp)
	pea	-54(a6)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq.s	L53C8
	pea	-54(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,d0
	beq.s	L53C8
	pea	-54(a6)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L191BD
	move.l	-58(a6),-(sp)
	jsr	L16E2A
	adda	#$10,sp
L53C8:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L53CC:
	link	a6,#-10
	move.l	8(a6),a0
	move	L468CC,d0
	cmp	(a0),d0
	bne.s	L541E
	move.l	8(a6),a0
	move	2602(a0),d0
	beq.s	L53F0
	move	L3E758,d0
	bgt.s	L53FA
L53F0:
	cmpi	#2,L3E758
	bne.s	L541E
L53FA:
	move.l	8(a6),a0
	clr	2594(a0)
	move.l	8(a6),-(sp)
	jsr	sys_enterchat_func
	addq	#4,sp
	move.l	8(a6),a0
	moveq	#1,d0
	move	d0,2594(a0)
	moveq	#1,d0
	bra	L54A6
;
L541E:
	clr	-6(a6)
	moveq	#1,d0
	move	d0,-4(a6)
	clr	-2(a6)
L542C:
	cmpi	#4,-2(a6)
	bge.s	L548E
	move	-2(a6),d0
	muls	#80,d0
	add.l	8(a6),d0
	addi.l	#$8E2,d0
	move.l	d0,-10(a6)
	move.l	-10(a6),a0
	move.b	(a0),d0
	beq.s	L5488
	move	-4(a6),d0
	beq.s	L5466
	pea	L1924A
	jsr	L63E0
	addq	#4,sp
L5466:
	move.l	-10(a6),-(sp)
	pea	L1925B
	jsr	L63E0
	addq	#8,sp
	move.l	-10(a6),a0
	clr.b	(a0)
	clr	-4(a6)
	moveq	#1,d0
	move	d0,-6(a6)
L5488:
	addq	#1,-2(a6)
	bra.s	L542C
;
L548E:
	move	-6(a6),d0
	beq.s	L54A2
	pea	L19263
	jsr	L63E0
	addq	#4,sp
L54A2:
	move	-6(a6),d0
L54A6:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L54AA:
	link	a6,#0
	move.l	12(a6),-(sp)
	move.l	8(a6),a0
	move	2970(a0),d0
	ext.l	d0
	lsl.l	#5,d0
	addi.l	#$4691E,d0
	move.l	d0,-(sp)
	move.l	8(a6),a0
	move	2970(a0),d0
	addq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	34(a0),-(sp)
	pea	L19266
	jsr	L63E0
	adda	#$10,sp
	pea	L19282
	jsr	L63E0
	addq	#4,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L54FC:
	link	a6,#0
	cmpi	#$41,8(a6)
	blt.s	L551A
	cmpi	#$5A,8(a6)
	bgt.s	L551A
	move	8(a6),d0
	addi	#$20,d0
	bra.s	L551E
;
L551A:
	move	8(a6),d0
L551E:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5522:
	link	a6,#0
	cmpi	#$61,8(a6)
	blt.s	L5540
	cmpi	#$7A,8(a6)
	bgt.s	L5540
	move	8(a6),d0
	subi	#$20,d0
	bra.s	L5544
;
L5540:
	move	8(a6),d0
L5544:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5548:
	link	a6,#0
	cmpi	#$20,8(a6)
	bne.s	L5558
	moveq	#1,d0
	bra.s	L555A
;
L5558:
	clr	d0
L555A:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L555E:
	link	a6,#0
	cmpi	#$30,8(a6)
	blt.s	L5572
	cmpi	#$39,8(a6)
	ble.s	L5592
L5572:
	cmpi	#$61,8(a6)
	blt.s	L5582
	cmpi	#$66,8(a6)
	ble.s	L5592
L5582:
	cmpi	#$41,8(a6)
	blt.s	L5596
	cmpi	#$46,8(a6)
	bgt.s	L5596
L5592:
	moveq	#1,d0
	bra.s	L5598
;
L5596:
	clr	d0
L5598:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L559C:
	link	a6,#-14
	movem.l	d3-d3/a4-a5,(sp)
	move.l	8(a6),a5
	move.l	12(a6),a4
L55AC:
	move.b	(a4),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move	d0,d3
	move.b	(a5),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	sub	d3,d0
	move	d0,-2(a6)
	bne.s	L55E0
	move.b	(a5),d0
	bne.s	L55DA
	clr	d0
	bra.s	L55E4
;
L55DA:
	addq.l	#1,a5
	addq.l	#1,a4
	bra.s	L55AC
;
L55E0:
	move	-2(a6),d0
L55E4:
	movem.l	(sp),d3-d3/a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L55EC:
	link	a6,#-14
	movem.l	d3-d3/a4-a5,(sp)
	move.l	8(a6),a5
	move.l	12(a6),a4
	clr	-2(a6)
L5600:
	move.b	(a5),d0
	beq.s	L5630
	move.b	(a4),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move	d0,d3
	move.b	(a5),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	sub	d3,d0
	move	d0,-2(a6)
	bne.s	L5630
	addq.l	#1,a5
	addq.l	#1,a4
	bra.s	L5600
;
L5630:
	move	-2(a6),d0
	movem.l	(sp),d3-d3/a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L563C:
	link	a6,#-4
	move.l	8(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	ext.l	d0
	add.l	8(a6),d0
	move.l	d0,-4(a6)
L5656:
	move.l	-4(a6),a0
	cmp.l	8(a6),a0
	bls.s	L568A
	move.l	-4(a6),a0
	cmpi.b	#$5C,-1(a0)
	beq.s	L568A
	move.l	-4(a6),a0
	cmpi.b	#$2F,-1(a0)
	beq.s	L568A
	move.l	-4(a6),a0
	cmpi.b	#$3A,-1(a0)
	beq.s	L568A
	subq.l	#1,-4(a6)
	bra.s	L5656
;
L568A:
	move.l	-4(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5692:
	link	a6,#-4
	clr	-2(a6)
L569A:
	move	-2(a6),d0
	cmp	16(a6),d0
	bge.s	L56BE
	move	-2(a6),d0
	addq	#1,-2(a6)
	ext.l	d0
	lsl.l	#2,d0
	move.l	d0,a0
	adda.l	8(a6),a0
	move.l	#L1928D,(a0)
	bra.s	L569A
;
L56BE:
	clr	-2(a6)
L56C2:
	move	-2(a6),d0
	cmp	16(a6),d0
	bge	L57AE
L56CE:
	move.l	12(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5548
	addq	#2,sp
	move	d0,d0
	beq.s	L56EA
	addq.l	#1,12(a6)
	bra.s	L56CE
;
L56EA:
	move.l	12(a6),a0
	move.b	(a0),d0
	beq	L57AE
	move	-2(a6),d0
	addq	#1,-2(a6)
	ext.l	d0
	lsl.l	#2,d0
	move.l	d0,a0
	adda.l	8(a6),a0
	move.l	12(a6),(a0)
	move.l	12(a6),a0
	cmpi.b	#$27,(a0)
	beq.s	L571E
	move.l	12(a6),a0
	cmpi.b	#$22,(a0)
	bne.s	L5770
L571E:
	move.l	12(a6),a0
	cmpi.b	#$5C,-1(a0)
	beq.s	L5770
	move.l	12(a6),a0
	move.b	(a0),-4(a6)
	move	-2(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#2,d0
	move.l	d0,a0
	adda.l	8(a6),a0
	addq.l	#1,(a0)
L5744:
	addq.l	#1,12(a6)
	move.l	12(a6),a0
	move.b	(a0),d0
	beq.s	L5794
	move.b	-4(a6),d1
	ext.w	d1
	move.l	12(a6),a0
	move.b	(a0),d0
	ext.w	d0
	cmp	d1,d0
	bne.s	L5744
	move.l	12(a6),a0
	cmpi.b	#$5C,-1(a0)
	beq.s	L5744
	bra.s	L5794
;
L5770:
	move.l	12(a6),a0
	move.b	(a0),d0
	beq.s	L5794
	move.l	12(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5548
	addq	#2,sp
	move	d0,d0
	bne.s	L5794
	addq.l	#1,12(a6)
	bra.s	L5770
;
L5794:
	move.l	12(a6),a0
	move.b	(a0),-4(a6)
	move.l	12(a6),a0
	addq.l	#1,12(a6)
	clr.b	(a0)
	move.b	-4(a6),d0
	bne	L56C2
L57AE:
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L57B6:
	link	a6,#-124
	move.l	8(a6),-(sp)
	pea	-100(a6)
	jsr	L11FEC
	addq	#8,sp
	moveq	#5,d0
	move	d0,-(sp)
	pea	-100(a6)
	pea	-120(a6)
	jsr	L5692
	adda	#$A,sp
	move	d0,-124(a6)
	move.l	-120(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	moveq	#1,d0
	move	d0,-122(a6)
L57FA:
	move	-122(a6),d0
	cmp	-124(a6),d0
	bge.s	L5838
	pea	L1928E
	move.l	8(a6),-(sp)
	jsr	L1206E
	addq	#8,sp
	move	-122(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	move.l	d0,a0
	adda.l	a6,a0
	move.l	-120(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	L1206E
	addq	#8,sp
	addq	#1,-122(a6)
	bra.s	L57FA
;
L5838:
	move	-124(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5840:
	link	a6,#-10
	moveq	#81,d0
	move.b	d0,-10(a6)
	cmpi	#1,16(a6)
	bne.s	L5858
	moveq	#89,d0
	move.b	d0,-10(a6)
L5858:
	move	16(a6),d0
	bne.s	L5864
	moveq	#78,d0
	move.b	d0,-10(a6)
L5864:
	move.b	-10(a6),d0
	ext.w	d0
	move	d0,-(sp)
	move.l	12(a6),-(sp)
	pea	L19290
	jsr	L63E0
	adda	#$A,sp
	clr	-4(a6)
L5884:
	move	-4(a6),d0
	bne	L594C
	move.l	8(a6),-(sp)
	jsr	L6F7A
	addq	#4,sp
	move	d0,-2(a6)
	moveq	#1,d0
	move	d0,-4(a6)
	move	-2(a6),-(sp)
	jsr	L5522
	addq	#2,sp
	move	d0,-(sp)
	pea	L192A3
	jsr	L120D4
	addq	#6,sp
	cmpi	#3,d0
	bhi.s	L5934
	lsl.w	#2,d0
	move	d0,a0
	adda.l	#L1832E,a0
	move.l	(a0),a0
	jmp	(a0)
;
L58D2:
	bra.s	L5884
;
L58D4:
	clr	16(a6)
	move.l	#L192A8,-8(a6)
	bra.s	L5884
;
L58E2:
	moveq	#1,d0
	move	d0,16(a6)
	move.l	#L192AB,-8(a6)
	bra.s	L5884
;
L58F2:
	moveq	#-1,d0
	move	d0,16(a6)
	move.l	#L192AF,-8(a6)
	bra.s	L5884
;
L5902:
	cmpi	#$FFFF,16(a6)
	bne.s	L5916
	move.l	#L192B4,-8(a6)
	bra	L5884
;
L5916:
	cmpi	#1,16(a6)
	bne.s	L5926
	move.l	#L192B9,d0
	bra.s	L592C
;
L5926:
	move.l	#L192BD,d0
L592C:
	move.l	d0,-8(a6)
	bra	L5884
;
L5934:
	clr	-4(a6)
	moveq	#7,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L662E
	addq	#6,sp
	bra	L5884
;
L594C:
	move.l	-8(a6),-(sp)
	jsr	L63E0
	addq	#4,sp
	move	16(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5960:
	link	a6,#-104
	clr	-(sp)
	move	16(a6),-(sp)
	move.l	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	bne.s	L5986
	moveq	#-1,d0
	bra.s	L59C8
;
L5986:
	move.l	12(a6),-(sp)
	pea	-100(a6)
	jsr	L11FEC
	addq	#8,sp
	moveq	#1,d0
	move	d0,-(sp)
	pea	-100(a6)
	pea	-104(a6)
	jsr	L5692
	adda	#$A,sp
	move.l	-104(a6),-(sp)
	move.l	12(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	move.l	12(a6),-(sp)
	jsr	L12092
	addq	#4,sp
L59C8:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L59CC:
	link	a6,#-16
	move.l	12(a6),-16(a6)
	move.l	8(a6),a0
	move	(a0),-8(a6)
	clr	-2(a6)
	clr	-12(a6)
	clr	-10(a6)
	move	16(a6),d0
	bge.s	.L5A00
	move	16(a6),d0
	neg	d0
	move	d0,16(a6)
	moveq	#1,d0
	move	d0,-10(a6)
.L5A00:
	subq	#1,16(a6)
.L5A04:
	move	-2(a6),d0
	cmp	16(a6),d0
	bge.s	.L5A12
	moveq	#1,d0
	bra.s	.L5A14
;
.L5A12:
	clr	d0
.L5A14:
	move	d0,-6(a6)
	move.l	8(a6),-(sp)
	jsr	L6F7A
	addq	#4,sp
	move	d0,-4(a6)
	move.l	8(a6),-(sp)
	jsr	L5C60
	addq	#4,sp
.L5A34:				;patch serin_filter here
	cmpi	#$20,-4(a6)
	blt.s	.L5AB0
	cmpi	#$7F,-4(a6)
.L5A42:
	bge.s	.L5AB0		;patch serin_bxx to beq here
	clr	-12(a6)
	move	-6(a6),d0
	beq.s	.L5A6C
	move	-10(a6),d0
	beq.s	.L5A7E
	cmpi	#'-',-4(a6)
	beq.s	.L5A7E
	cmpi	#'0',-4(a6)
	blt.s	.L5A6C
	cmpi	#'9',-4(a6)
	ble.s	.L5A7E
.L5A6C:
	moveq	#BEL,d0
	move	d0,-(sp)
	move	-8(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	bra.s	.L5A04
;
.L5A7E:
	move	18(a6),d0
	beq.s	.L5A8A
	moveq	#'#',d0
	move	d0,-(sp)
	bra.s	.L5A8E
;
.L5A8A:
	move	-4(a6),-(sp)
.L5A8E:
	move	-8(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	move.l	-16(a6),a0
	addq.l	#1,-16(a6)
	move	-4(a6),d0
	move.b	d0,(a0)
	addq	#1,-2(a6)
	bra	.L5A04
;
.L5AB0:
	cmpi	#8,-4(a6)
	beq.s	.L5AC0
	cmpi	#$7F,-4(a6)
	bne.s	.L5B3A
.L5AC0:
	move	-2(a6),d0
	beq.s	.L5B0E
	clr	-12(a6)
	moveq	#8,d0
	move	d0,-(sp)
	move	-8(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#' ',d0
	move	d0,-(sp)
	move	-8(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#8,d0
	move	d0,-(sp)
	move	-8(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	subq	#1,-2(a6)
	subq.l	#1,-16(a6)
	move.l	-16(a6),a0
	moveq	#32,d0
	move.b	d0,(a0)
	bra	.L5A04
;
.L5B0E:
	addq	#1,-12(a6)
	move	-12(a6),d0
	cmpi	#$1D,d0
	ble	.L5A6C
	move.l	L18196,-(sp)
	pea	L192C0
	jsr	L63E0
	addq	#8,sp
	clr	-12(a6)
	bra	.L5A6C
;
.L5B3A:
	cmpi	#CR,-4(a6)
	bne.s	.L5B66
	moveq	#13,d0
	move	d0,-(sp)
	move	-8(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	move.l	-16(a6),a0
	clr.b	(a0)
	move.l	12(a6),-(sp)
	jsr	L12092
	addq	#4,sp
	bra.s	.exit
;
.L5B66:
	cmpi	#ESC,-4(a6)
	beq.s	.L5B78
	cmpi	#($1F&'C'),-4(a6)
	bne	.L5A04
.L5B78:
	moveq	#'^',d0
	move	d0,-(sp)
	move	-8(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#'C',d0
	move	d0,-(sp)
	move	-8(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#CR,d0
	move	d0,-(sp)
	move	-8(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	move.l	-16(a6),a0
	clr.b	(a0)
	moveq	#-1,d0
.L5BB0:
.exit:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5BB4:
	link	a6,#-2
	move	12(a6),d0
	bne.s	L5BCC
	move.l	8(a6),-(sp)
	jsr	L1219C
	addq	#4,sp
	bra.s	L5C2A
;
L5BCC:
	clr	-2(a6)
L5BD0:
	move.l	8(a6),a0
	move.b	(a0),d0
	beq.s	L5C2A
	move	-2(a6),d0
	beq.s	L5BF8
	move.l	8(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L54FC
	addq	#2,sp
	move.l	8(a6),a0
	move.b	d0,(a0)
	bra.s	L5C16
;
L5BF8:
	move.l	8(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move.l	8(a6),a0
	move.b	d0,(a0)
	moveq	#1,d0
	move	d0,-2(a6)
L5C16:
	move.l	8(a6),a0
	cmpi.b	#$20,(a0)
	bne.s	L5C24
	clr	-2(a6)
L5C24:
	addq.l	#1,8(a6)
	bra.s	L5BD0
;
L5C2A:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5C2E:
	link	a6,#0
L5C32:
	move.l	8(a6),a0
	move.b	(a0),d0
	beq.s	L5C5A
	move.l	8(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5548
	addq	#2,sp
	move	d0,d0
	bne.s	L5C54
	moveq	#1,d0
	bra.s	L5C5C
;
L5C54:
	addq.l	#1,8(a6)
	bra.s	L5C32
;
L5C5A:
	clr	d0
L5C5C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5C60:
	link	a6,#-2
	move.l	8(a6),a0
	move	34(a0),d0
	move	d0,-2(a6)
	cmpi	#$78,d0
	ble.s	L5C82
	move.l	8(a6),a0
	clr	2992(a0)
	bra	L5D26
;
L5C82:
	move.l	8(a6),a0
	move	2594(a0),d0
	beq	L5D26
	move.l	8(a6),a0
	move	2992(a0),d0
	bne.s	L5CC6
	pea	L192C4
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	moveq	#1,d0
	move	d0,2992(a0)
	cmpi	#$1E,-2(a6)
	bge.s	L5CC6
	move.l	8(a6),a0
	moveq	#30,d0
	move	d0,34(a0)
	move	d0,-2(a6)
L5CC6:
	move	-2(a6),d0
	bne.s	L5D26
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2(a0)
	jsr	L5BB4
	addq	#6,sp
	pea	L192EE
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	pea	2(a0)
	pea	L19319
	jsr	L63E0
	addq	#8,sp
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D5A
	addq	#2,sp
	moveq	#3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
L5D26:
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5D2E:
	link	a6,#-4
	move.l	a5,-(sp)
	move.l	8(a6),a5
	cmpi.b	#$23,(a5)
	beq.s	L5D44
	cmpi.b	#$20,(a5)
	bne.s	L5D60
L5D44:
	move.b	(a5),d0
	beq.s	L5D60
	cmpi.b	#$20,(a5)
	bne.s	L5D5C
L5D4E:
	cmpi.b	#$20,(a5)
	bne.s	L5D58
	addq.l	#1,a5
	bra.s	L5D4E
;
L5D58:
	move.l	a5,d0
	bra.s	L5D64
;
L5D5C:
	addq.l	#1,a5
	bra.s	L5D44
;
L5D60:
	move.l	8(a6),d0
L5D64:
	move.l	(sp)+,a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5D6A:
	link	a6,#-12
	movem.l	d7-d7/a4-a5,(sp)
	move.l	8(a6),a5
	move.l	12(a6),a4
	move	16(a6),d7
	cmp.l	a5,a4
	bls.s	L5D90
L5D82:
	move	d7,d0
	ble.s	L5DAA
	move.b	(a4),(a5)
	addq.l	#1,a5
	addq.l	#1,a4
	subq	#1,d7
	bra.s	L5D82
;
L5D90:
	move	d7,d0
	subq	#1,d0
	adda	d0,a5
	move	d7,d0
	subq	#1,d0
	adda	d0,a4
L5D9C:
	move	d7,d0
	ble.s	L5DAA
	move.b	(a4),(a5)
	subq.l	#1,a5
	subq.l	#1,a4
	subq	#1,d7
	bra.s	L5D9C
;
L5DAA:
	movem.l	(sp),d7-d7/a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5DB2:
	link	a6,#0
	move	12(a6),-(sp)
	pea	L1932E
	jsr	L63E0
	addq	#6,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5DCC:
	link	a6,#0
	move	8(a6),d0
	andi	#3,d0
	bne.s	L5DEE
	move	8(a6),d0
	andi.l	#$FFFF,d0
	divu	#$64,d0
	swap	d0
	move	d0,d0
	bne.s	L5E02
L5DEE:
	move	8(a6),d0
	andi.l	#$FFFF,d0
	divu	#$190,d0
	swap	d0
	move	d0,d0
	bne.s	L5E06
L5E02:
	moveq	#1,d0
	bra.s	L5E08
;
L5E06:
	clr	d0
L5E08:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5E0C:
	link	a6,#-6
	move	#$7BC,-6(a6)
L5E16:
	move	-6(a6),d0
	cmp	12(a6),d0
	bcc.s	L5E3A
	move	-6(a6),-(sp)
	jsr	L5DCC
	addq	#2,sp
	addi	#$16D,d0
	add	d0,10(a6)
	addq	#1,-6(a6)
	bra.s	L5E16
;
L5E3A:
	move	12(a6),-(sp)
	jsr	L5DCC
	addq	#2,sp
	move	d0,-4(a6)
	moveq	#1,d0
	move	d0,-2(a6)
L5E50:
	move	-2(a6),d0
	cmp	8(a6),d0
	bcc.s	L5E80
	move	-2(a6),d1
	ext.l	d1
	lsl.l	#1,d1
	move	-4(a6),d0
	muls	#$1A,d0
	add.l	d1,d0
	lea	L191C6,a0
	adda.l	d0,a0
	move	(a0),d0
	add	d0,10(a6)
	addq	#1,-2(a6)
	bra.s	L5E50
;
L5E80:
	move	10(a6),d0
	addq	#1,d0
	andi.l	#$FFFF,d0
	divu	#7,d0
	swap	d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5E96:
	link	a6,#-6
	move	12(a6),d0
	lsr.w	#5,d0
	andi	#$F,d0
	move	d0,-2(a6)
	move	12(a6),d0
	andi	#$1F,d0
	move	d0,-4(a6)
	move	12(a6),d0
	lsr.w	#8,d0
	lsr.w	#1,d0
	andi	#$7F,d0
	move	d0,-6(a6)
	move	14(a6),d0
	beq.s	L5F30
	move	-6(a6),d0
	addi	#$7BC,d0
	move	d0,-(sp)
	move	-4(a6),-(sp)
	move	-2(a6),d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#2,d0
	lea	L19216,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	move	-6(a6),d0
	addi	#$7BC,d0
	move	d0,-(sp)
	move	-4(a6),-(sp)
	move	-2(a6),-(sp)
	jsr	L5E0C
	addq	#6,sp
	ext.l	d0
	lsl.l	#2,d0
	lea	L191FA,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	pea	L193C2
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L16E2A
	adda	#$14,sp
	bra.s	L5F4C
;
L5F30:
	move	12(a6),-(sp)
	pea	L193D1
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L16E2A
	adda	#$A,sp
L5F4C:
	move	16(a6),d0
	beq.s	L5F68
	move.l	8(a6),a0
	pea	2638(a0)
	pea	L193D5
	jsr	L63E0
	addq	#8,sp
L5F68:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5F6C:
	link	a6,#-12
	movem.l	d5-d7,(sp)
	move	8(a6),d0
L5F78:
	ext.l	d0
	divs	#2,d0
	move	d0,d7
	move	d7,d0
	ble.s	L5FCE
	move	d7,d6
L5F86:
	cmp	8(a6),d6
	bge.s	L5FCA
	move	d6,d0
	sub	d7,d0
	move	d0,d5
L5F92:
	move	d5,d0
	blt.s	L5FC6
	move	d5,d0
	add	d7,d0
	move	d0,-(sp)
	move	d5,-(sp)
	move.l	10(a6),-(sp)
	move.l	14(a6),a0
	jsr	(a0)
	addq	#8,sp
	move	d0,d0
	ble.s	L5FC6
	move	d5,d0
	add	d7,d0
	move	d0,-(sp)
	move	d5,-(sp)
	move.l	10(a6),-(sp)
	move.l	18(a6),a0
	jsr	(a0)
	addq	#8,sp
	sub	d7,d5
	bra.s	L5F92
;
L5FC6:
	addq	#1,d6
	bra.s	L5F86
;
L5FCA:
	move	d7,d0
	bra.s	L5F78
;
L5FCE:
	movem.l	(sp),d5-d7
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L5FD6:
	link	a6,#-8
	movem.l	a4-a5,(sp)
	move	12(a6),d0
	muls	#$18,d0
	add.l	8(a6),d0
	move.l	d0,a5
	move	14(a6),d0
	muls	#$18,d0
	add.l	8(a6),d0
	move.l	d0,a4
	move.b	(a4),d1
	ext.w	d1
	move.b	(a5),d0
	ext.w	d0
	cmp	d1,d0
	bne.s	L6018
	pea	10(a4)
	pea	10(a5)
	jsr	L559C
	addq	#8,sp
	bra.s	L6022
;
L6018:
	move.b	(a5),d1
	ext.w	d1
	move.b	(a4),d0
	ext.w	d0
	sub	d1,d0
L6022:
	movem.l	(sp),a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L602A:
	link	a6,#-8
	movem.l	a4-a5,(sp)
	move	12(a6),d0
	muls	#$18,d0
	add.l	8(a6),d0
	move.l	d0,a5
	move	14(a6),d0
	muls	#$18,d0
	add.l	8(a6),d0
	move.l	d0,a4
	move.b	(a4),d1
	ext.w	d1
	move.b	(a5),d0
	ext.w	d0
	cmp	d1,d0
	beq.s	L6066
	move.b	(a5),d1
	ext.w	d1
	move.b	(a4),d0
	ext.w	d0
	sub	d1,d0
	bra.s	L608A
;
L6066:
	move	4(a5),d0
	cmp	4(a4),d0
	beq.s	L607A
	move	4(a4),d0
	sub	4(a5),d0
	bra.s	L608A
;
L607A:
	pea	10(a4)
	pea	10(a5)
	jsr	L559C
	addq	#8,sp
L608A:
	movem.l	(sp),a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6092:
	link	a6,#-8
	movem.l	a4-a5,(sp)
	move	12(a6),d0
	muls	#$18,d0
	add.l	8(a6),d0
	move.l	d0,a5
	move	14(a6),d0
	muls	#$18,d0
	add.l	8(a6),d0
	move.l	d0,a4
	move.b	(a4),d1
	ext.w	d1
	move.b	(a5),d0
	ext.w	d0
	cmp	d1,d0
	beq.s	L60CE
	move.b	(a5),d1
	ext.w	d1
	move.b	(a4),d0
	ext.w	d0
	sub	d1,d0
	bra.s	L60F2
;
L60CE:
	move	2(a5),d0
	cmp	2(a4),d0
	beq.s	L60E2
	move	2(a5),d0
	sub	2(a4),d0
	bra.s	L60F2
;
L60E2:
	pea	10(a4)
	pea	10(a5)
	jsr	L559C
	addq	#8,sp
L60F2:
	movem.l	(sp),a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L60FA:
	link	a6,#-32
	movem.l	a4-a5,(sp)
	move	12(a6),d0
	muls	#$18,d0
	add.l	8(a6),d0
	move.l	d0,a5
	move	14(a6),d0
	muls	#$18,d0
	add.l	8(a6),d0
	move.l	d0,a4
	moveq	#24,d0
	move	d0,-(sp)
	move.l	a5,-(sp)
	pea	-24(a6)
	jsr	L5D6A
	adda	#$A,sp
	moveq	#24,d0
	move	d0,-(sp)
	move.l	a4,-(sp)
	move.l	a5,-(sp)
	jsr	L5D6A
	adda	#$A,sp
	moveq	#24,d0
	move	d0,-(sp)
	pea	-24(a6)
	move.l	a4,-(sp)
	jsr	L5D6A
	adda	#$A,sp
	movem.l	(sp),a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6160:
	link	a6,#-4
	cmpi	#1,14(a6)
	bne.s	L6176
	move.l	#L602A,-4(a6)
	bra.s	L6190
;
L6176:
	cmpi	#2,14(a6)
	bne.s	L6188
	move.l	#L6092,-4(a6)
	bra.s	L6190
;
L6188:
	move.l	#L5FD6,-4(a6)
L6190:
	pea	L60FA
	move.l	-4(a6),-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move	12(a6),-(sp)
	jsr	L5F6C
	adda	#$E,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L61B4:
	link	a6,#-16
	pea	L193D8
	jsr	L63E0
	addq	#4,sp
	pea	L193FC
	move.l	8(a6),-(sp)
	jsr	L6A98
	addq	#8,sp
	move	d0,-8(a6)
	cmpi	#$1B,d0
	beq	L63A2
	cmpi	#3,-8(a6)
	beq	L63A2
	move	-8(a6),d0
	move.l	#L1833E,a0
	move	#4,d1
	bra.s	L6200
;
L61FE:
	addq	#4,a0
L6200:
	cmp	(a0)+,d0
	dbeq	d1,L61FE
	move.l	(a0),a0
	jmp	(a0)
;
L620A:
	bra.s	L6238
;
L620C:
	clr	-8(a6)
	move.l	#L19403,-16(a6)
	bra.s	L6238
;
L621A:
	moveq	#1,d0
	move	d0,-8(a6)
	move.l	#L19408,-16(a6)
	bra.s	L6238
;
L622A:
	moveq	#2,d0
	move	d0,-8(a6)
	move.l	#L1940D,-16(a6)
L6238:
	move.l	-16(a6),-(sp)
	jsr	L63E0
	addq	#4,sp
	move.l	12(a6),-(sp)
	pea	L19412
	jsr	L63E0
	addq	#8,sp
	move	-8(a6),-(sp)
	move	16(a6),-(sp)
	move.l	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L69CA
	adda	#$C,sp
	move	d0,-2(a6)
	beq	L638E
	move.l	8(a6),a0
	move.l	2894(a0),-12(a6)
	clr	-4(a6)
L6286:
	move	-4(a6),d0
	cmp	-2(a6),d0
	bge	L637A
	move	-4(a6),d0
	addq	#1,d0
	ext.l	d0
	divs	#$14,d0
	swap	d0
	move	d0,d0
	bne.s	L62E4
	pea	L19447
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),-(sp)
	jsr	L6F7A
	addq	#4,sp
	move	d0,-6(a6)
	cmpi	#$1B,d0
	beq	L637A
	cmpi	#3,-6(a6)
	beq	L637A
	moveq	#13,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L662E
	addq	#6,sp
L62E4:
	move.l	-12(a6),a0
	pea	10(a0)
	pea	L19457
	jsr	L63E0
	addq	#8,sp
	move.l	-12(a6),a0
	btst	#4,(a0)
	beq.s	L630C
	pea	L1945E
	bra.s	L6340
;
L630C:
	move.l	-12(a6),a0
	move.l	6(a0),d0
	beq.s	L633A
	move.l	-12(a6),a0
	move.l	6(a0),d0
	addi.l	#$3FF,d0
	asr.l	#8,d0
	asr.l	#2,d0
	move	d0,-(sp)
	pea	L19466
	jsr	L63E0
	addq	#6,sp
	bra.s	L6348
;
L633A:
	pea	L1946C
L6340:
	jsr	L63E0
	addq	#4,sp
L6348:
	move.l	-12(a6),a0
	move	2(a0),-(sp)
	move.l	-12(a6),a0
	move	4(a0),-(sp)
	pea	L19474
	jsr	L63E0
	addq	#8,sp
	move.l	-12(a6),a0
	adda	#$18,a0
	move.l	a0,-12(a6)
	addq	#1,-4(a6)
	bra	L6286
;
L637A:
	move	-4(a6),-(sp)
	pea	L1947B
	jsr	L63E0
	addq	#6,sp
	bra.s	L63A2
;
L638E:
	move.l	L1892C,-(sp)
	pea	L1948E
	jsr	L63E0
	addq	#8,sp
L63A2:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L63A6:
	link	a6,#0
	cmpi	#$A,12(a6)
	bne.s	L63C2
	move.l	8(a6),a0
	move.l	(a0),a0
	moveq	#13,d0
	move.b	d0,(a0)
	move.l	8(a6),a0
	addq.l	#1,(a0)
L63C2:
	move.l	8(a6),a0
	move.l	(a0),a0
	move	12(a6),d0
	move.b	d0,(a0)
	move.l	8(a6),a0
	addq.l	#1,(a0)
	move.l	8(a6),a0
	move.l	(a0),a0
	clr.b	(a0)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L63E0:
	link	a6,#-208
	move	L3E74E,d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L2D57A,a0
	adda.l	d0,a0
	move.l	(a0),-208(a6)
	lea	-200(a6),a0
	move.l	a0,-204(a6)
	move.l	-204(a6),a0
	clr.b	(a0)
	move.l	-204(a6),-(sp)
	moveq	#-1,d0
	move	d0,-(sp)
	pea	L63A6
	pea	12(a6)
	move.l	8(a6),-(sp)
	jsr	L16696
	adda	#$12,sp
	move.l	-208(a6),a0
	move	2600(a0),d0
	bne.s	L6446
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-208(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
L6446:
	move.l	-204(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	move.l	-204(a6),-(sp)
	move.l	-208(a6),a0
	move	(a0),-(sp)
	jsr	L6D80
	addq	#8,sp
	move.l	-208(a6),a0
	move	2600(a0),d0
	bne.s	L6484
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-208(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
L6484:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6488:
	link	a6,#-208
	lea	-200(a6),a0
	move.l	a0,-204(a6)
	move.l	-204(a6),a0
	clr.b	(a0)
	move.l	-204(a6),-(sp)
	moveq	#-1,d0
	move	d0,-(sp)
	pea	L63A6
	pea	14(a6)
	move.l	10(a6),-(sp)
	jsr	L16696
	adda	#$12,sp
	clr	-208(a6)
	move.l	-204(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-206(a6)
	ble.s	L64F4
	move	-206(a6),-(sp)
	move.l	-204(a6),-(sp)
	move	8(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmp	-206(a6),d0
	beq.s	L64EE
	moveq	#1,d0
	bra.s	L64F0
;
L64EE:
	clr	d0
L64F0:
	move	d0,-208(a6)
L64F4:
	move	-208(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L64FC:
	link	a6,#0
	pea	L19492
	move	8(a6),-(sp)
	pea	user_conout_2
	pea	14(a6)
	move.l	10(a6),-(sp)
	jsr	L16696
	adda	#$12,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6526:
	link	a6,#-264
	move	L3E74E,d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L2D57A,a0
	adda.l	d0,a0
	move.l	(a0),-4(a6)
	lea	-260(a6),a0
	move.l	a0,-264(a6)
	jsr	L6988
	move	d0,-(sp)
	jsr	L6944
	move	d0,-(sp)
	move.l	-4(a6),a0
	pea	2(a0)
	pea	L19493
	move.l	-264(a6),-(sp)
	jsr	L16E2A
	adda	#$10,sp
L6574:
	move.l	-264(a6),a0
	move.b	(a0),d0
	beq.s	L6582
	addq.l	#1,-264(a6)
	bra.s	L6574
;
L6582:
	move.l	-264(a6),-(sp)
	moveq	#-1,d0
	move	d0,-(sp)
	pea	L63A6
	pea	12(a6)
	move.l	8(a6),-(sp)
	jsr	L16696
	adda	#$12,sp
	move.l	-264(a6),-(sp)
	pea	L194A0
	moveq	#5,d0
	move	d0,-(sp)
	jsr	L64FC
	adda	#$A,sp
	move	L2C0B6,d0
	ble.s	L65FE
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	move.l	-264(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	move.l	-264(a6),-(sp)
	move	L2C0B6,-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
L65FE:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6602:
	link	a6,#0
	pea	L194A3
	move.l	8(a6),a0
	move	(a0),-(sp)
	pea	L6DC4
	pea	16(a6)
	move.l	12(a6),-(sp)
	jsr	L16696
	adda	#$12,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L662E:
	link	a6,#0
	move	12(a6),-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DC4
	addq	#4,sp
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	L6662
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
L6662:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6666:
	link	a6,#-204
	clr	-2(a6)
	clr.b	-204(a6)
	pea	-204(a6)
	moveq	#-1,d0
	move	d0,-(sp)
	pea	L63A6
	pea	16(a6)
	move.l	12(a6),-(sp)
	jsr	L16696
	adda	#$12,sp
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-4(a6)
	bge.s	L66C6
	move.l	8(a6),-(sp)
	jsr	L4B74
	addq	#4,sp
	move	d0,-4(a6)
L66C6:
	move	-4(a6),d0
	ble.s	L671E
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	-4(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	pea	-204(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-2(a6)
	move	-2(a6),-(sp)
	pea	-204(a6)
	move	-4(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmp	-2(a6),d0
	beq.s	L670C
	moveq	#1,d0
	bra.s	L670E
;
L670C:
	clr	d0
L670E:
	move	d0,-2(a6)
	move	-4(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
L671E:
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-4(a6),d0
	blt.s	L6738
	move	-2(a6),d0
	beq.s	L6760
L6738:
	move	-2(a6),d0
	beq.s	L6746
	pea	L194C1
	bra.s	L674C
;
L6746:
	pea	L194C7
L674C:
	move.l	8(a6),-(sp)
	pea	L194A4
	jsr	L6526
	adda	#$C,sp
L6760:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L6764:
sys_enterchat_func:
	link	a6,#-18
	clr	-2(a6)
	clr	-4(a6)
	move.l	8(a6),a0
	move	(a0),-(sp)
	pea	L194CE
	pea	-18(a6)
	jsr	L16E2A
	adda	#$A,sp
	move.l	8(a6),a0
	clr	2602(a0)
	cmpi	#2,L3E758
	bne.s	L67A4
	pea	L194DB
	bra.s	L67AA
;
L67A4:
	pea	L194FC
L67AA:
	jsr	L63E0
	addq	#4,sp
	clr	L3E758
	pea	L19524
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	clr.b	2738(a0)
L67CE:
	move.l	8(a6),a0
	pea	2738(a0)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L11FEC
	addq	#8,sp
	move.l	8(a6),a0
	pea	2738(a0)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L14F72
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	L6918
	move	-2(a6),d0
	beq.s	L682E
	move.l	8(a6),a0
	pea	2638(a0)
	pea	L1953F
	move	-4(a6),-(sp)
	jsr	L6488
	adda	#$A,sp
L682E:
	pea	L19543
	jsr	L63E0
	addq	#4,sp
	move	-2(a6),d0
	bne.s	L67CE
	pea	L19545
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne	L67CE
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	moveq	#2,d0
	move	d0,-(sp)
	pea	-18(a6)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-4(a6)
	bge.s	L6892
	pea	-18(a6)
	jsr	L4B74
	addq	#4,sp
	move	d0,-4(a6)
L6892:
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-4(a6),d0
	ble	L67CE
	moveq	#1,d0
	move	d0,-2(a6)
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	-4(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	jsr	L6988
	move	d0,-(sp)
	jsr	L6944
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L1954D
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L16E2A
	adda	#$10,sp
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	pea	2638(a0)
	move	-4(a6),-(sp)
	jsr	L6488
	addq	#6,sp
	bra	L67CE
;
L6918:
	move	-2(a6),d0
	beq.s	L692A
	move	-4(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
L692A:
	move.l	8(a6),a0
	clr	2602(a0)
	pea	L1957D
	jsr	L63E0
	addq	#4,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6944:
	link	a6,#-6
	pea	-6(a6)
	pea	-4(a6)
	pea	-2(a6)
	jsr	task_Tgetdate
	adda	#$C,sp
	move	-4(a6),d2
	andi	#$1F,d2
	move	-6(a6),d1
	subi	#$7BC,d1
	andi	#$7F,d1
	lsl.w	#8,d1
	lsl.w	#1,d1
	move	-2(a6),d0
	andi	#$F,d0
	lsl.w	#5,d0
	add	d1,d0
	add	d2,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6988:
	link	a6,#-6
	pea	-6(a6)
	pea	-4(a6)
	pea	-2(a6)
	jsr	task_Tgettime
	adda	#$C,sp
	move	-4(a6),d2
	andi	#$3F,d2
	lsl.w	#5,d2
	move	-6(a6),d1
	asr.w	#1,d1
	andi	#$1F,d1
	move	-2(a6),d0
	andi	#$1F,d0
	lsl.w	#8,d0
	lsl.w	#3,d0
	add	d1,d0
	add	d2,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L69CA:
	link	a6,#-50
	move.l	8(a6),a0
	move.l	2894(a0),-50(a6)
	clr	-46(a6)
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	pea	-44(a6)
	jsr	task_Fsetdta
	addq	#4,sp
	move	16(a6),-(sp)
	move.l	12(a6),-(sp)
	jsr	task_Fsfirst
	addq	#6,sp
	move	d0,d0
	beq.s	L6A6E
L6A0A:
	move.b	-23(a6),d0
	ext.w	d0
	andi	#$10,d0
	move.l	-50(a6),a0
	move.b	d0,(a0)
	move.l	-50(a6),a0
	move	-22(a6),2(a0)
	move.l	-50(a6),a0
	move	-20(a6),4(a0)
	move.l	-50(a6),a0
	move.l	-18(a6),6(a0)
	pea	-14(a6)
	move.l	-50(a6),a0
	pea	10(a0)
	jsr	L11FEC
	addq	#8,sp
	move.l	-50(a6),a0
	adda	#$18,a0
	move.l	a0,-50(a6)
	addq	#1,-46(a6)
	cmpi	#$155,-46(a6)
	beq.s	L6A6E
	jsr	task_Fsnext
	move	d0,d0
	bne.s	L6A0A
L6A6E:
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	18(a6),-(sp)
	move	-46(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L6160
	addq	#8,sp
	move	-46(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6A98:
	link	a6,#-8
	move.l	a5,-(sp)
L6A9E:
	move.l	8(a6),-(sp)
	jsr	L6F7A
	addq	#4,sp
	move	d0,-2(a6)
	move	-2(a6),-(sp)
	jsr	L54FC
	addq	#2,sp
	move	d0,-2(a6)
	move.l	12(a6),a5
L6AC2:
	move.b	(a5),d0
	ext.w	d0
	move	d0,-4(a6)
	beq.s	L6AE0
	move	-2(a6),d0
	cmp	-4(a6),d0
	bne.s	L6ADC
	move	-2(a6),d0
	bra.s	L6AF2
;
L6ADC:
	addq.l	#1,a5
	bra.s	L6AC2
;
L6AE0:
	moveq	#7,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L662E
	addq	#6,sp
	bra.s	L6A9E
;
L6AF2:
	move.l	(sp)+,a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6AF8:
	link	a6,#-2
	move.l	8(a6),-(sp)
	jsr	L6F3A
	addq	#4,sp
	move	d0,-2(a6)
	move	12(a6),d0
	beq.s	L6B1A
	cmpi	#$20,-2(a6)
	beq.s	L6B32
L6B1A:
	cmpi	#$1B,-2(a6)
	beq.s	L6B32
	cmpi	#3,-2(a6)
	beq.s	L6B32
	cmpi	#$F,-2(a6)
	bne.s	L6B42
L6B32:
	move.l	8(a6),-(sp)
	jsr	L707E
	addq	#4,sp
	moveq	#1,d0
	bra.s	L6B44
;
L6B42:
	clr	d0
L6B44:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6B48:
	link	a6,#-8
	movem.l	d7-d7/a5-a5,(sp)
	move.l	8(a6),a0
	move.l	(a0),a5
	moveq	#0,d7
	move.b	(a5),d0
	beq.s	L6B90
L6B5C:
	cmpi.b	#$30,(a5)
	blt.s	L6B7C
	cmpi.b	#$39,(a5)
	bgt.s	L6B7C
	move	d7,d0
	muls	#$A,d0
	move	d0,d7
	move.b	(a5)+,d0
	ext.w	d0
	subi	#$30,d0
	add	d0,d7
	bra.s	L6B5C
;
L6B7C:
	move.b	(a5),d0
	beq.s	L6B94
	cmpi.b	#$30,(a5)
	blt.s	L6B8C
	cmpi.b	#$39,(a5)
	ble.s	L6B94
L6B8C:
	addq.l	#1,a5
	bra.s	L6B7C
;
L6B90:
	move	12(a6),d7
L6B94:
	move.l	8(a6),a0
	move.l	a5,(a0)
	move	d7,d0
	movem.l	(sp),d7-d7/a5-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6BA4:
	link	a6,#-2
L6BA8:
	move	L2C0BA,-(sp)
	move.l	12(a6),-(sp)
	pea	L1957F
	jsr	L63E0
	adda	#$A,sp
	clr	-(sp)
	moveq	#50,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	bne.s	L6BE8
	clr	d0
	bra.s	L6C44
;
L6BE8:
	move.l	8(a6),a0
	cmpi.b	#$3F,2638(a0)
	bne.s	L6C02
	move.l	8(a6),-(sp)
	jsr	L4EB2
L6BFE:
	addq	#4,sp
	bra.s	L6BA8
;
L6C02:
	move.l	8(a6),-(sp)
	jsr	LA6D8
	addq	#4,sp
	move	d0,-2(a6)
	bne.s	L6C20
	move.l	8(a6),a0
	move	46(a0),-2(a6)
	bra.s	L6C2C
;
L6C20:
	move.l	8(a6),a0
	move	46(a0),d0
	and	d0,-2(a6)
L6C2C:
	move	-2(a6),d0
	bne.s	L6C40
	pea	L195AF
	jsr	L63E0
	bra.s	L6BFE
;
L6C40:
	move	-2(a6),d0
L6C44:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6C48:
	link	a6,#-24
	movem.l	d3-d7,(sp)
	move	8(a6),d0
	lsr.w	#8,d0
	lsr.w	#1,d0
	andi	#$7F,d0
	addi	#$7BC,d0
	swap	d0
	clr	d0
	swap	d0
	move.l	d0,d6
	move	8(a6),d0
	lsr.w	#5,d0
	andi	#$F,d0
	swap	d0
	clr	d0
	swap	d0
	move.l	d0,d5
	move	8(a6),d0
	andi	#$1F,d0
	swap	d0
	clr	d0
	swap	d0
	move.l	d0,d4
	cmpi.l	#2,d5
	ble.s	L6C96
	subq.l	#3,d5
	bra.s	L6C9E
;
L6C96:
	addi.l	#9,d5
	subq.l	#1,d6
L6C9E:
	moveq	#100,d0
	move.l	d0,-(sp)
	move.l	d6,-(sp)
	jsr	L1806E
	addq	#8,sp
	move.l	d0,d7
	moveq	#100,d0
	move.l	d0,-(sp)
	move.l	d6,-(sp)
	jsr	L180BE
	addq	#8,sp
	move.l	d0,d6
	moveq	#5,d0
	move.l	d0,-(sp)
	pea	$99.l
	move.l	d5,-(sp)
	jsr	L1812E
	addq	#8,sp
	addq.l	#2,d0
	move.l	d0,-(sp)
	jsr	L1806E
	addq	#8,sp
	move.l	d0,-4(a6)
	pea	$5B5.l
	move.l	d6,-(sp)
	jsr	L1812E
	addq	#8,sp
	move.l	d0,d3
	asr.l	#2,d3
	pea	$23AB1.l
	move.l	d7,-(sp)
	jsr	L1812E
	addq	#8,sp
	asr.l	#2,d0
	add.l	d3,d0
	add.l	-4(a6),d0
	add.l	d4,d0
	addi.l	#$1A431F,d0
	movem.l	(sp),d3-d7
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6D1E:
	link	a6,#-4
	move.l	d3,-(sp)
	move	10(a6),-(sp)
	jsr	L6C48
	addq	#2,sp
	move.l	d0,d3
	move	8(a6),-(sp)
	jsr	L6C48
	addq	#2,sp
	sub.l	d3,d0
	move.l	(sp)+,d3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6D46:
	link	a6,#0
	move	8(a6),-(sp)
	jsr	L2704
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6D5A:
	link	a6,#0
L6D5E:
	move	8(a6),-(sp)
	jsr	L2704
	addq	#2,sp
	move	d0,d0
	bne.s	L6D7C
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L6D5E
;
L6D7C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6D80:
	link	a6,#-8
	movem.l	d7-d7/a5-a5,(sp)
	move.l	10(a6),a5
	move	14(a6),d7
.L6D90:
	move	d7,d0
	subq	#1,d7
	move	d0,d0
	beq.s	.L6DBC
	move	8(a6),-(sp)
	jsr	dcd_poll_r
	addq	#2,sp
	move	d0,d0
	beq.s	.L6DBC
	move.b	(a5)+,d0
	ext.w	d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L23C2
	addq	#4,sp
	bra.s	.L6D90
;
.L6DBC:
	movem.l	(sp),d7-d7/a5-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6DC4:
	link	a6,#0
	move	10(a6),-(sp)
	move	8(a6),-(sp)
	jsr	L23C2
	addq	#4,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6DDC:
	link	a6,#0
	move	10(a6),-(sp)
	move	8(a6),-(sp)
	jsr	L2880
	addq	#4,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6DF4:
	link	a6,#0
	move	8(a6),-(sp)
	jsr	L26C6
	addq	#2,sp
	move	d0,d0
	beq.s	L6E16
	move	8(a6),-(sp)
	jsr	L25AA
	addq	#2,sp
	bra.s	L6E18
;
L6E16:
	moveq	#-1,d0
L6E18:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6E1C:
	link	a6,#0
	cmpi	#$3B00,8(a6)
	bne.s	L6E52
	move	L468CC,d0
	bne.s	L6E48
	move.b	L3E746,d0
	bne.s	L6E3C
	moveq	#1,d0
	bra.s	L6E3E
;
L6E3C:
	clr	d0
L6E3E:
	move.b	d0,L3E746
	bra	L6F0A
;
L6E48:
	clr	L3173C
	bra	L6EF8
;
L6E52:
	cmpi	#$3C00,8(a6)	; < F1 ?
	blt.s	L6E76
	cmpi	#$4400,8(a6)	; > F10 ?
	bgt.s	L6E76
	move	8(a6),d0
	subi	#$3B00,d0
	asr.w	#8,d0
L6E6C:
	move	d0,L3173C
	bra	L6EF8
;
L6E76:
	cmpi	#$5400,8(a6)	; < F11 ?
	blt.s	L6E96
	cmpi	#$5800,8(a6)	; > F15 ?
	bgt.s	L6E96
	move	8(a6),d0
	subi	#$5400,d0
	asr.w	#8,d0
	addi	#$A,d0
	bra.s	L6E6C
;
L6E96:
	cmpi	#$5D00,8(a6)	; != F20 ?
	bne.s	L6EA8
	moveq	#1,d0
	move	d0,L3E7BA
	bra.s	L6EF8
;
L6EA8:
	cmpi	#$5900,8(a6)	; != F16 ?
	bne.s	L6EBC
	moveq	#1,d0
	move	d0,L36740
	moveq	#1,d0
	bra.s	L6EF2
;
L6EBC:
	cmpi	#$5A00,8(a6)	; != F17 ?
	bne.s	L6ED0
	moveq	#1,d0
	move	d0,L36740
	moveq	#2,d0
	bra.s	L6EF2
;
L6ED0:
	cmpi	#$5B00,8(a6)	; != F18 ?
	bne.s	L6EE2
	moveq	#1,d0
	move	d0,L36740
	bra.s	L6EF0
;
L6EE2:
	cmpi	#$5C00,8(a6)	; != F19 ?
	bne.s	L6F0A
	clr	L36740
L6EF0:
	moveq	#-1,d0
L6EF2:
	move	d0,L3E758
L6EF8:
	moveq	#1,d0
	move	d0,-(sp)
	move	L315FA,-(sp)
	jsr	L37D0
	addq	#4,sp
L6F0A:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6F0E:
	link	a6,#0
	move	8(a6),-(sp)
	jsr	dcd_poll_r
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6F22:
	link	a6,#0
	move	10(a6),-(sp)
	move	8(a6),-(sp)
	jsr	L28D0
	addq	#4,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6F3A:
	link	a6,#0
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	L6F5C
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
L6F5C:
	move.l	8(a6),-(sp)
	jsr	L5C60
	addq	#4,sp
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DF4
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L6F7A:
	link	a6,#-4
	move.l	8(a6),a0
	move	2978(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	L413C
	addq	#6,sp
	move.l	8(a6),a0
	move	(a0),-2(a6)
	clr	-4(a6)
L6F9E:
	move	-2(a6),-(sp)
	jsr	L26C6
	addq	#2,sp
	move	d0,d0
	bne	L7040
	move.l	8(a6),-(sp)
	jsr	L5C60
	addq	#4,sp
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	L6FDC
	moveq	#2,d0
L6FC8:
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
	bra.s	L6F9E
;
L6FDC:
	move.l	8(a6),a0
	cmpi	#$3C,2968(a0)
	bgt.s	L6F9E
	move	-4(a6),d0
	bne.s	L7004
	moveq	#1,d0
	move	d0,-4(a6)
	pea	L195EA
	jsr	L63E0
	addq	#4,sp
	bra.s	L6F9E
;
L7004:
	move.l	8(a6),a0
	move	2968(a0),d0
	bge.s	L6F9E
	move.l	8(a6),a0
	move	2596(a0),d0
	beq.s	L702E
	move.l	8(a6),a0
	pea	2(a0)
	pea	L1963C
	jsr	L63E0
	addq	#8,sp
L702E:
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D5A
	addq	#2,sp
	moveq	#4,d0
	bra.s	L6FC8
;
L7040:
	move	-2(a6),-(sp)
	jsr	L25AA
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L7050:
	link	a6,#-2
	move.l	8(a6),a0
	move	(a0),-2(a6)
L705C:
	move	-2(a6),-(sp)
	jsr	L26C6
	addq	#2,sp
	move	d0,d0
	beq.s	L707A
	move	-2(a6),-(sp)
	jsr	L25AA
	addq	#2,sp
	bra.s	L705C
;
L707A:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L707E:
	link	a6,#0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L7086:
	link	a6,#0
	move	12(a6),d0
	bne.s	L709E
	move.l	8(a6),a1
	move	(a1),a0
	adda.l	#L3E746,a0
	clr.b	(a0)
L709E:
	move	12(a6),-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	rts_out_r
	addq	#4,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L70B4:
	link	a6,#-4
	clr	-2(a6)
L70BC:
	cmpi	#4,-2(a6)
	bge.s	L70D6
	move	-2(a6),a0
	adda.l	#L3E746,a0
	clr.b	(a0)
	addq	#1,-2(a6)
	bra.s	L70BC
;
L70D6:
	clr	-2(a6)
	clr	-4(a6)
L70DE:
	cmpi	#3,-2(a6)
	bge.s	L7106
	move	-2(a6),a0
	adda.l	#L46B28,a0
	move.b	(a0),d0
	beq.s	L7100
	moveq	#1,d0
	move	-2(a6),d2
	lsl.w	d2,d0
	or	d0,-4(a6)
L7100:
	addq	#1,-2(a6)
	bra.s	L70DE
;
L7106:
	move	-4(a6),-(sp)
	jsr	L29D4
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L7116:
	link	a6,#0
	jsr	L2ABC
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L7124:
	link	a6,#0
	moveq	#2,d0
	move	d0,-(sp)
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2E0E0,d0
	move.l	d0,-(sp)
	jsr	L188
	addq	#6,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L7148:
	link	a6,#0
	move	L1EE66,-(sp)
	jsr	L3976
	addq	#2,sp
	move	12(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L2BDF2,a0
	adda.l	d0,a0
	move.l	(a0),a0
	pea	22(a0)
	move.l	8(a6),-(sp)
	jsr	L50E
	addq	#8,sp
	move	L1EE66,-(sp)
	jsr	L3852
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L718E:
	link	a6,#-8
	clr	-4(a6)
L7196:
	move	L1965E,d0
	bne	L72BE
	jsr	L3424
	move	d0,-2(a6)
	cmpi	#$A,-2(a6)
	beq	L72BE
	move	L1EE66,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L3173C,d0
	cmp	L468CC,d0
	bne.s	L71D8
	cmpi	#2,-2(a6)
	bne.s	L7224
L71D8:
	move	L3173C,d0
	move	d0,L468CC
	ext.l	d0
	lsl.l	#2,d0
	lea	L2BDF2,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	jsr	transfer_screen
	addq	#4,sp
	move	L468CC,d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18874,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	move	#$700,-(sp)
	moveq	#68,d0
	move	d0,-(sp)
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L5C0
	adda	#$A,sp
L7224:
	move	L1EE66,-(sp)
	jsr	L3852
	addq	#2,sp
	move	L3E7BA,d0
	beq.s	L7260
	move	-4(a6),d0
	bne.s	L7260
	pea	L19660
	move	#$7000,-(sp)
	moveq	#16,d0
	move	d0,-(sp)
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L5C0
	adda	#$A,sp
	addq	#1,-4(a6)
L7260:
	move	L36740,d0
	bne.s	L7272
	move.l	#L19690,-8(a6)
	bra.s	L72A2
;
L7272:
	cmpi	#1,L3E758
	bne.s	L7286
	move.l	#L196A0,-8(a6)
	bra.s	L72A2
;
L7286:
	cmpi	#2,L3E758
	bne.s	L729A
	move.l	#L196B0,-8(a6)
	bra.s	L72A2
;
L729A:
	move.l	#L196C0,-8(a6)
L72A2:
	move.l	-8(a6),-(sp)
	move	#$7000,-(sp)
	clr	-(sp)
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L5C0
	adda	#$A,sp
	bra	L7196
;
L72BE:
	unlk	a6
	rts
;
; Func	-------------------------------
;
L72C2:
	link	a6,#-6
	move.l	a5,-(sp)
	jsr	L294
	clr	L468CC
	clr	L3173C
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L362E
	addq	#2,sp
	move	d0,L1EE66
	clr	-2(a6)
L72F0:
	cmpi	#$F,-2(a6)
	bge	L737E
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L2BDF2,a0
	adda.l	d0,a0
	move	-2(a6),d0
	muls	#$DD6,d0
	addi.l	#$1EE68,d0
	move.l	d0,a5
	move.l	d0,(a0)
	clr	2(a5)
	clr	(a5)
	move	#$700,4(a5)
	move	L468CC,d0
	cmp	-2(a6),d0
	bne.s	L733A
	moveq	#1,d0
	move	d0,-(sp)
	bra.s	L733C
;
L733A:
	clr	-(sp)
L733C:
	move	4(a5),d0
	addi	#$20,d0
	move	d0,-(sp)
	move	#$6E0,-(sp)
	clr	-(sp)
	move.l	a5,-(sp)
	jsr	L6DE
	adda	#$C,sp
	moveq	#1,d0
	move	d0,6(a5)
	clr	8(a5)
	clr	12(a5)
	clr	10(a5)
	clr	16(a5)
	clr	18(a5)
	clr	20(a5)
	addq	#1,-2(a6)
	bra	L72F0
;
L737E:
	clr	-(sp)
	clr	-(sp)
	pea	L196D0
	moveq	#20,d0
	move	d0,-(sp)
	move	#$400,-(sp)
	pea	L718E
	jsr	init_bbs
	adda	#$10,sp
	move	d0,L315FA
	move	d0,-(sp)
	jsr	start_bbs
	addq	#2,sp
	move.l	(sp)+,a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L73B6:
	link	a6,#0
	moveq	#1,d0
	move	d0,L1965E
	moveq	#10,d0
	move	d0,-(sp)
	move	L315FA,-(sp)
	jsr	L37D0
	addq	#4,sp
	jsr	L386
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L73DE:
user_conout_2:
	link	a6,#0
	move	L1EE66,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L3173C,d0
	cmp	L468CC,d0
	beq.s	.L7420
	move	L3173C,d0
	move	d0,L468CC
	ext.l	d0
	lsl.l	#2,d0
	lea	L2BDF2,a0
	adda.l	d0,a0		;a0 -> one of six terminal buffers
	move.l	(a0),-(sp)
	jsr	transfer_screen
	addq	#4,sp
.L7420:
	move	10(a6),-(sp)	;push char to output
	move	8(a6),d0
	cmp	L468CC,d0
	bne.s	.L7436
	moveq	#1,d0
	move	d0,-(sp)	;push flag
	bra.s	.L7438
;
.L7436:
	clr	-(sp)		;push flag
.L7438:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L2BDF2,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)	;push ->
	jsr	user_conout_1
	addq	#8,sp
	move	L1EE66,-(sp)
	jsr	L3852
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;	void	user_conout_1(BUF *conbuf,word ch,word flag);
;
L7464:
user_conout_1:
	link	a6,#-12
	movem.l	d6-d7/a5,(sp)
	move.l	8(a6),a5		;->
	move	12(a6),d7		;flag
	move	14(a6),d6		;char to output
	move	d7,d0			;flag
	beq.s	L748A
	move	2(a5),-(sp)
	move	(a5),-(sp)
	jsr	invert_cursor
	addq	#4,sp
L748A:
	andi	#$FF,d6
L748E:					;patch conout_filter here
	cmpi	#$20,d6
	blt.s	L7508
L7494:
	cmpi	#$7F,d6			;patch conout_limit here
	bgt.s	L7508
	move	d7,-(sp)		;push flag	
	move	4(a5),d0
	add	d6,d0
	move	d0,-(sp)		;push char
	move	(a5),d0
	muls	#80,d0			;d0 = 80 * row #
	add	2(a5),d0
	lsl.w	#1,d0			;d0 = 2 * (80 * row_# + column_#)
	move	d0,-(sp)		;push text offset
	move.l	a5,-(sp)		;push ->
	jsr	user_conout_0
	lea	10(sp),sp
	addq	#1,2(a5)
	move	2(a5),d0
	cmpi	#79,d0			;line full ?
	ble	L75AC
L74CE:
	clr	2(a5)
	addq	#1,(a5)
	move	(a5),d0
	cmpi	#21,d0			;screen full ?
	ble	L75AC
	moveq	#21,d0
	move	d0,(a5)
	move	d7,-(sp)
	move	4(a5),d0
	addi	#$20,d0
	move	d0,-(sp)
	move	#$690,-(sp)
	move	#$A0,-(sp)
	clr	-(sp)
	move.l	a5,-(sp)
	jsr	L600
	adda	#$E,sp
	bra	L75AC
;
L7508:
	cmpi	#$B,d6
	bne.s	L7518
	clr	2(a5)
	clr	(a5)
	bra	L75AC
;
L7518:
	cmpi	#$C,d6
	bne.s	L754A
	clr	2(a5)
	clr	(a5)
	move	#$700,4(a5)
	move	d7,-(sp)
	move	4(a5),d0
	addi	#$20,d0
	move	d0,-(sp)
	move	#$6E0,-(sp)
	clr	-(sp)
	move.l	a5,-(sp)
	jsr	L6DE
	adda	#$C,sp
	bra.s	L75AC
;
L754A:
	cmpi	#7,d6
	bne.s	L7564
	move	d7,d0
	beq.s	L75AC
	move	L468CC,d0
	bne.s	L75AC
	jsr	L24C
	bra.s	L75AC
;
L7564:
	cmpi	#$D,d6
	bne.s	L7570
	clr	2(a5)
	bra.s	L75AC
;
L7570:
	cmpi	#$A,d6
	beq	L74CE
	cmpi	#8,d6
	bne.s	L758A
	move	2(a5),d0
	beq.s	L75AC
	subq	#1,2(a5)
	bra.s	L75AC
;
L758A:
	cmpi	#9,d6
	bne.s	L75AC
L7590:
	move	2(a5),d0
	addq	#8,d0
	andi	#$FFF8,d0
	move	d0,2(a5)
	cmpi	#$4F,2(a5)
	ble.s	L75AC
	moveq	#79,d0
	move	d0,2(a5)
L75AC:
	move	d7,d0
	beq.s	L75BE
	move	2(a5),-(sp)
	move	(a5),-(sp)
	jsr	invert_cursor
	addq	#4,sp
L75BE:
	movem.l	(sp),d6-d7/a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L75C6:
	link	a6,#-8
	pea	$1D0.l
	move	8(a6),d0
	addi	#$FFFF,d0
	swap	d0
	clr	d0
	swap	d0
	move.l	d0,-(sp)
	jsr	L1812E
	addq	#8,sp
	move.l	d0,-8(a6)
	move	L467C8,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	move.l	-8(a6),-(sp)
	move	L2C0B8,d0
	move	d0,-2(a6)
	move	d0,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	#$1D0,-(sp)
	move.l	10(a6),-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	cmpi	#$1D0,d0
	beq.s	L7632
	moveq	#1,d0
	bra.s	L7634
;
L7632:
	clr	d0
L7634:
	move	d0,-4(a6)
	move	L467C8,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-4(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L764E:
	link	a6,#-8
	moveq	#1,d0
	move	d0,-(sp)
	move.l	10(a6),a0
	pea	14(a0)
	jsr	L5BB4
	addq	#6,sp
	clr	-(sp)
	move.l	10(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	pea	$1D0.l
	move	8(a6),d0
	addi	#$FFFF,d0
	swap	d0
	clr	d0
	swap	d0
	move.l	d0,-(sp)
	jsr	L1812E
	addq	#8,sp
	move.l	d0,-8(a6)
	move	L467C8,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	move.l	-8(a6),-(sp)
	move	L2C0B8,d0
	move	d0,-2(a6)
	move	d0,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	#$1D0,-(sp)
	move.l	10(a6),-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmpi	#$1D0,d0
	beq.s	L76DC
	moveq	#1,d0
	bra.s	L76DE
;
L76DC:
	clr	d0
L76DE:
	move	d0,-4(a6)
	move	L467C8,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-4(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L76F8:
	link	a6,#-2
	move	L467C8,-(sp)
	jsr	L3976
	addq	#2,sp
	pea	$1D0.l
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	L2C0B8,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	d0,-(sp)
	jsr	L1806E
	addq	#8,sp
	move	d0,-2(a6)
	move	L467C8,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L7748:
	link	a6,#-4
	clr	-2(a6)
	clr	-4(a6)
L7754:
	move	-4(a6),d0
	bne.s	L7782
	cmpi	#$A,-2(a6)
	bge.s	L7782
	move.l	10(a6),a0
	move	(a0),d0
	cmp	8(a6),d0
	bne.s	L7778
	move	-2(a6),d0
	addq	#1,d0
	move	d0,-4(a6)
L7778:
	addq	#1,-2(a6)
	addq.l	#2,10(a6)
	bra.s	L7754
;
L7782:
	cmpi	#$A,-2(a6)
	bge.s	L77A6
	move.l	10(a6),a0
	move	(a0),d0
	cmp	8(a6),d0
	bne.s	L779C
	move.l	10(a6),a0
	clr	(a0)
L779C:
	addq	#1,-2(a6)
	addq.l	#2,10(a6)
	bra.s	L7782
;
L77A6:
	move	-4(a6),d0
	subq	#1,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L77B0:
	link	a6,#-4
	clr	-2(a6)
	clr	-4(a6)
L77BC:
	move	8(a6),d0
	beq.s	L77EE
	cmpi	#$A,-2(a6)
	bge.s	L77EE
	move.l	10(a6),a0
	move	(a0),d0
	bne.s	L77E0
	addq	#1,-4(a6)
	move.l	10(a6),a0
	move	8(a6),(a0)
	bra.s	L77E4
;
L77E0:
	addq	#1,-4(a6)
L77E4:
	addq	#1,-2(a6)
	addq.l	#2,10(a6)
	bra.s	L77BC
;
L77EE:
	cmpi	#$A,-2(a6)
	bge.s	L780C
	move.l	10(a6),a0
	move	(a0),d0
	beq.s	L7802
	addq	#1,-4(a6)
L7802:
	addq	#1,-2(a6)
	addq.l	#2,10(a6)
	bra.s	L77EE
;
L780C:
	move	-4(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L7814:
	link	a6,#0
	move.l	18(a6),-(sp)
	move	16(a6),-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	move	14(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L196EC,a0
	adda.l	d0,a0
	move.l	(a0),a0
	jsr	(a0)
	adda	#$C,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L7844:
	link	a6,#-6
	move.l	8(a6),a0
	move	2966(a0),d0
	andi	#$E0,d0
	move	d0,-2(a6)
	cmpi	#$E0,-2(a6)
	bne.s	L7868
	move	#$368,-4(a6)
	bra.s	L788A
;
L7868:
	cmpi	#$80,-2(a6)
	bne.s	L7874
	moveq	#109,d0
	bra.s	L7886
;
L7874:
	cmpi	#$A0,-2(a6)
	bne.s	L7884
	move	#$DA,-4(a6)
	bra.s	L788A
;
L7884:
	moveq	#27,d0
L7886:
	move	d0,-4(a6)
L788A:
	move	-4(a6),d0
	ext.l	d0
	move.l	d0,-(sp)
	move.l	12(a6),-(sp)
	jsr	L1806E
	addq	#8,sp
	move	d0,-6(a6)
	move	-6(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L78AA:
	link	a6,#-4
	move	12(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L19700,a0
	adda.l	d0,a0
	move	(a0),d0
	ext.l	d0
	move.l	d0,-4(a6)
	clr	-(sp)
	move.l	18(a6),-(sp)
L78CC:
	jsr	L5BB4
	addq	#6,sp
	move.l	18(a6),-(sp)
	pea	L1979E
	jsr	L63E0
	addq	#8,sp
	move.l	14(a6),d0
	addi.l	#$3FF,d0
	asr.l	#8,d0
	asr.l	#2,d0
	move	d0,-(sp)
	pea	L197AE
	jsr	L63E0
	addq	#6,sp
	pea	-4(a6)
	move.l	-4(a6),d0
	add.l	14(a6),d0
	subq.l	#1,d0
	move.l	d0,-(sp)
	jsr	L18068
	addq	#8,sp
	move.l	d0,-(sp)
	pea	L197C3
	jsr	L63E0
	addq	#8,sp
	move.l	-4(a6),d0
	add.l	14(a6),d0
	move.l	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L7844
	addq	#8,sp
	addi	#$3B,d0
	andi.l	#$FFFF,d0
	divu	#$3C,d0
	move	d0,-(sp)
	pea	L197D2
	jsr	L63E0
	addq	#6,sp
	move	12(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L1884C,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	pea	L197EA
	jsr	L63E0
	addq	#8,sp
	pea	L197F8
	jsr	L63E0
	addq	#4,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L7992:
	link	a6,#0
	clr	-(sp)
	move.l	14(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	move.l	14(a6),-(sp)
	move	12(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L1884C,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	pea	L1981B
	jsr	L63E0
	adda	#$C,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L79CE:
	link	a6,#-2
	move	14(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18838,a1
	adda.l	d0,a1
	move.l	8(a6),a0
	move.l	(a1),2608(a0)
	pea	L1983E
	jsr	L63E0
	addq	#4,sp
	clr	-2(a6)
L79FC:
	cmpi	#$10,-2(a6)
	bge.s	L7A44
	move.l	8(a6),-(sp)
	jsr	L6F3A
	addq	#4,sp
	cmpi	#$20,d0
	beq.s	L7A44
	moveq	#7,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L662E
	addq	#6,sp
	move.l	8(a6),-(sp)
	jsr	L7050
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	addq	#1,-2(a6)
	bra.s	L79FC
;
L7A44:
	move	14(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18838,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	move	12(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L1884C,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	pea	L1984E
	jsr	L63E0
	adda	#$C,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L7A7C:
	link	a6,#-2
	move	12(a6),d0
	beq.s	L7A8E
	pea	L1989F
	bra.s	L7A94
;
L7A8E:
	pea	L198A9
L7A94:
	pea	L19857
	jsr	L63E0
	addq	#8,sp
	move	12(a6),d0
	beq.s	L7AB0
	pea	L198B0
	bra.s	L7AB6
;
L7AB0:
	pea	L198B9
L7AB6:
	move.l	8(a6),-(sp)
	jsr	L6A98
	addq	#8,sp
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move	d0,-(sp)
	pea	L198AA
	jsr	L120D4
	addq	#6,sp
	move	d0,-2(a6)
	move	-2(a6),d0
	bge.s	L7AEE
	pea	L198C1
	bra.s	L7B00
;
L7AEE:
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L1884C,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
L7B00:
	jsr	L63E0
	addq	#4,sp
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L7B10:
	link	a6,#-554
	move.l	8(a6),a0
	move.l	2894(a0),-554(a6)
	move.l	8(a6),a0
	move.l	#L198C6,2608(a0)
	moveq	#1,d0
	move	d0,-538(a6)
	move.l	8(a6),a0
	move	2970(a0),-548(a6)
	clr	-(sp)
	move	#$1D0,-(sp)
	pea	-464(a6)
	jsr	L10C
	addq	#8,sp
	move.b	L46E22,d0
	bne	L7C28
L7B56:
	pea	L198D3
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#-3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-548(a6)
	cmpi	#$FFFF,d0
	beq	L8024
	move	-548(a6),d0
	bne.s	L7B9E
	move.l	8(a6),a0
	move	2970(a0),-548(a6)
	bra.s	L7BA2
;
L7B9E:
	subq	#1,-548(a6)
L7BA2:
	move	-548(a6),d0
	blt.s	L7BB4
	move	-548(a6),d0
	cmp	L2C0BA,d0
	blt.s	L7BC4
L7BB4:
	pea	L198EB
	jsr	L63E0
	addq	#4,sp
	bra.s	L7B56
;
L7BC4:
	move	-548(a6),d0
	ext.l	d0
	lsl.l	#5,d0
	addi.l	#$4691E,d0
	move.l	d0,-468(a6)
	move.l	8(a6),a1
	move	-548(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	and	46(a1),d0
	bne.s	L7C08
	move.l	-468(a6),-(sp)
	pea	L19903
L7BFC:
	jsr	L63E0
	addq	#8,sp
	bra	L7B56
;
L7C08:
	move	-548(a6),d0
	ext.l	d0
	lsl.l	#5,d0
	lea	L46C22,a0
	adda.l	d0,a0
	move.b	(a0),d0
	bne.s	L7C28
	move.l	-468(a6),-(sp)
	pea	L19926
	bra.s	L7BFC
;
L7C28:
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	L7A7C
	addq	#6,sp
	move	d0,-544(a6)
	blt	L8024
L7C3E:
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-468(a6)
	pea	L1994C
	jsr	L63E0
	addq	#4,sp
	moveq	#13,d0
	move	d0,-(sp)
	move.l	-468(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L5960
	adda	#$A,sp
	cmpi	#$FFFF,d0
	beq	L8024
	move.l	-468(a6),a0
	move.b	(a0),d0
	beq	L8024
	move.l	-468(a6),-(sp)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-468(a6)
	move	L467C8,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-546(a6)
L7CA4:
	cmpi	#$10,-546(a6)
	bge.s	L7D0A
	move	-546(a6),d0
	ext.l	d0
	lsl.l	#5,d0
	lea	L46C22,a0
	adda.l	d0,a0
	move.l	a0,-472(a6)
	move.b	(a0),d0
	bne.s	L7CCA
L7CC4:
	addq	#1,-546(a6)
	bra.s	L7CA4
;
L7CCA:
	move.l	-472(a6),-(sp)
	pea	-536(a6)
	jsr	L11FEC
	addq	#8,sp
	move.l	-468(a6),-(sp)
	pea	-536(a6)
	jsr	L1206E
	addq	#8,sp
	clr	-(sp)
	pea	-536(a6)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-540(a6)
	ble.s	L7CC4
	move	-540(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
L7D0A:
	cmpi	#$10,-546(a6)
	beq.s	L7D16
	moveq	#1,d0
	bra.s	L7D18
;
L7D16:
	clr	d0
L7D18:
	move	d0,-542(a6)
	move	-542(a6),d0
	bne.s	L7D72
	move.b	L46E22,d0
	beq.s	L7D72
	pea	L46E22
	pea	-536(a6)
	jsr	L11FEC
	addq	#8,sp
	move.l	-468(a6),-(sp)
	pea	-536(a6)
	jsr	L1206E
	addq	#8,sp
	clr	-(sp)
	pea	-536(a6)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-540(a6)
	ble.s	L7D72
	moveq	#1,d0
	move	d0,-542(a6)
	move	-540(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
L7D72:
	move	-542(a6),d0
	bne.s	L7DBC
	move.b	L46E22,d0
	bne.s	L7DAC
	move	-548(a6),d0
	ext.l	d0
	lsl.l	#5,d0
	addi.l	#$46C22,d0
	move.l	d0,-(sp)
	pea	-536(a6)
	jsr	L11FEC
	addq	#8,sp
	move.l	-468(a6),-(sp)
	pea	-536(a6)
	jsr	L1206E
	addq	#8,sp
L7DAC:
	pea	-536(a6)
	jsr	L4B74
	addq	#4,sp
	move	d0,-540(a6)
L7DBC:
	move	L467C8,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-542(a6),d0
	beq.s	L7DE2
	pea	L19963
	jsr	L63E0
	addq	#4,sp
	bra	L7C3E
;
L7DE2:
	move	-540(a6),d0
	bge.s	L7DFE
	pea	-536(a6)
	pea	L19984
	jsr	L63E0
	addq	#8,sp
	bra	L7C3E
;
L7DFE:
	move.l	L196DC,-(sp)
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	moveq	#5,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L14DAE
	addq	#8,sp
	move	d0,d0
	ble.s	L7DFE
	clr	-546(a6)
L7E28:
	cmpi	#5,-546(a6)
	bge.s	L7E5C
	move	-546(a6),d0
	muls	#80,d0
	add.l	-554(a6),d0
	move.l	d0,-(sp)
	move	-546(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	a6,a0
	pea	-400(a0)
	jsr	L11FEC
	addq	#8,sp
	addq	#1,-546(a6)
	bra.s	L7E28
;
L7E5C:
	pea	-536(a6)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-(sp)
	move	-544(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L7992
	adda	#$A,sp
	move.l	8(a6),a0
	move	34(a0),-550(a6)
	pea	-536(a6)
	clr	-(sp)
	move	-544(a6),-(sp)
	move	-540(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L7814
	adda	#$E,sp
	move	d0,-538(a6)
	move.l	8(a6),a0
	move	2984(a0),d0
	bne.s	L7EBA
	move.l	8(a6),a0
	move	-550(a6),34(a0)
L7EBA:
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	-540(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	d0,-426(a6)
	move	-540(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move	-538(a6),d0
	beq.s	L7EEA
	pea	L199CA
	bra.s	L7EEE
;
L7EEA:
	pea	-400(a6)
L7EEE:
	pea	-536(a6)
	move.l	8(a6),a0
	pea	2(a0)
	move	-538(a6),d0
	bne.s	L7F08
	pea	L199C0
	bra.s	L7F0E
;
L7F08:
	pea	L199C5
L7F0E:
	pea	L1999C
	jsr	L6526
	adda	#$14,sp
	move	-538(a6),d0
	beq.s	L7F48
	pea	-536(a6)
	jsr	task_Fdelete
	addq	#4,sp
	move	-538(a6),-(sp)
	move	-544(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L79CE
	addq	#8,sp
	bra	L800E
;
L7F48:
	pea	-400(a6)
	pea	-536(a6)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L199D6
	moveq	#6,d0
	move	d0,-(sp)
	jsr	L64FC
	adda	#$12,sp
	pea	-536(a6)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-(sp)
	pea	-464(a6)
	jsr	L11FEC
	addq	#8,sp
	move.l	8(a6),a0
	pea	2(a0)
	pea	-450(a6)
	jsr	L11FEC
	addq	#8,sp
	jsr	L6944
	move	d0,-430(a6)
	jsr	L6988
	move	d0,-428(a6)
	clr	-422(a6)
	clr	-420(a6)
	move	-548(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),-418(a6)
	moveq	#1,d0
	move	d0,-416(a6)
	pea	-464(a6)
	jsr	L84F2
	addq	#4,sp
	move	-538(a6),-(sp)
	move	-544(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L79CE
	addq	#8,sp
	move.l	8(a6),a0
	pea	2(a0)
	pea	L199EF
	jsr	L63E0
	addq	#8,sp
	move.l	8(a6),a0
	addq	#1,50(a0)
L800E:
	move.l	8(a6),-(sp)
	jsr	LF400
	addq	#4,sp
	move	-538(a6),d0
	bne.s	L8024
	moveq	#1,d0
	bra.s	L8026
;
L8024:
	clr	d0
L8026:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L802A:
	link	a6,#-80
	move.l	8(a6),a0
	move.l	#L19A09,2608(a0)
	moveq	#1,d0
	move	d0,-70(a6)
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	L7A7C
	addq	#6,sp
	move	d0,-76(a6)
	bge.s	L805A
L8054:
	clr	d0
	bra	L828C
;
L805A:
	moveq	#1,d0
	move	d0,-78(a6)
	move.l	12(a6),-(sp)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-4(a6)
	move.l	-4(a6),a0
	move.b	(a0),d0
	bne.s	L80CC
	clr	-78(a6)
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-4(a6)
	pea	L19A1C
	jsr	L63E0
	addq	#4,sp
	moveq	#13,d0
	move	d0,-(sp)
	move.l	-4(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L5960
	adda	#$A,sp
	cmpi	#$FFFF,d0
	beq.s	L8054
	move.l	-4(a6),a0
	move.b	(a0),d0
	beq.s	L8054
	move.l	-4(a6),-(sp)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-4(a6)
L80CC:
	moveq	#49,d0
	move	d0,-(sp)
	move.l	12(a6),-(sp)
	pea	-68(a6)
	jsr	L12008
	adda	#$A,sp
	move	-78(a6),d0
	bne.s	L80F8
	move.l	-4(a6),-(sp)
	pea	-68(a6)
	jsr	L1206E
	addq	#8,sp
L80F8:
	move	L467C8,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-74(a6)
	clr	-(sp)
	pea	-68(a6)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-72(a6)
	ble.s	L8132
	move	-72(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	moveq	#1,d0
	move	d0,-74(a6)
	bra.s	L8142
;
L8132:
	pea	-68(a6)
	jsr	L4B74
	addq	#4,sp
	move	d0,-72(a6)
L8142:
	move	L467C8,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-74(a6),d0
	beq.s	L8170
	pea	L19A33
	jsr	L63E0
	addq	#4,sp
L8164:
	move	-78(a6),d0
	beq	L805A
	bra	L8054
;
L8170:
	move	-72(a6),d0
	bge.s	L818A
	pea	-68(a6)
	pea	L19A54
	jsr	L63E0
	addq	#8,sp
	bra.s	L8164
;
L818A:
	pea	-68(a6)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-(sp)
	move	-76(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L7992
	adda	#$A,sp
	move.l	8(a6),a0
	move	34(a0),-80(a6)
	pea	-68(a6)
	clr	-(sp)
	move	-76(a6),-(sp)
	move	-72(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L7814
	adda	#$E,sp
	move	d0,-70(a6)
	move.l	8(a6),a0
	move	2984(a0),d0
	bne.s	L81E8
	move.l	8(a6),a0
	move	-80(a6),34(a0)
L81E8:
	move	-72(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move	-70(a6),d0
	beq.s	L8202
	pea	L19A9E
	bra.s	L8208
;
L8202:
	pea	L19AAA
L8208:
	pea	-68(a6)
	move.l	8(a6),a0
	pea	2(a0)
	move	-70(a6),d0
	bne.s	L8222
	pea	L19A94
	bra.s	L8228
;
L8222:
	pea	L19A99
L8228:
	pea	L19A6C
	jsr	L6526
	adda	#$14,sp
	move	-70(a6),d0
	beq.s	L8260
	pea	-68(a6)
	jsr	task_Fdelete
	addq	#4,sp
L824A:
	move	-70(a6),-(sp)
	move	-76(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L79CE
	addq	#8,sp
	bra.s	L8282
;
L8260:
	pea	-68(a6)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L19AB3
	moveq	#6,d0
	move	d0,-(sp)
	jsr	L64FC
	adda	#$E,sp
	bra.s	L824A
;
L8282:
	move	-70(a6),d0
	bne	L8054
	moveq	#1,d0
L828C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L8290:
	link	a6,#-550
	move.l	a3,-(sp)
	move.l	#L19ACC,-468(a6)
	move.l	8(a6),a0
	move.l	#L19AFE,2608(a0)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L7A7C
	addq	#6,sp
	move	d0,-540(a6)
	cmpi	#$FFFF,d0
	beq	L8380
	moveq	#49,d0
	move	d0,-(sp)
	move.l	12(a6),-(sp)
	pea	-532(a6)
	jsr	L12008
	adda	#$A,sp
	pea	-532(a6)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-536(a6)
	move.l	-536(a6),a0
	move.b	(a0),d0
	bne.s	L834C
	pea	L19B0D
	jsr	L63E0
	addq	#4,sp
	moveq	#13,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L5960
	adda	#$A,sp
	cmpi	#$FFFF,d0
	beq.s	L8380
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L563C
	addq	#4,sp
	move.l	d0,a0
	move.l	a0,-536(a6)
	move.b	(a0),d0
	beq.s	L8380
	move.l	-536(a6),-(sp)
	pea	-532(a6)
	jsr	L1206E
	addq	#8,sp
L834C:
	clr	-(sp)
	pea	-532(a6)
	jsr	L5BB4
	addq	#6,sp
	clr	-(sp)
	pea	-532(a6)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-538(a6)
	bgt.s	L8386
	move.l	-536(a6),-(sp)
	pea	L19B21
L8378:
	jsr	L63E0
	addq	#8,sp
L8380:
	clr	d0
	bra	L84EC
;
L8386:
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	-538(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	d0,-546(a6)
	move.l	8(a6),a0
	move	2986(a0),d0
	beq.s	L83E2
	move.l	8(a6),a0
	move	34(a0),d0
	beq.s	L83CA
	move.l	8(a6),a3
	move.l	-546(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L7844
	addq	#8,sp
	cmp	34(a3),d0
	bls.s	L83E2
L83CA:
	move	-538(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move.l	-468(a6),-(sp)
	pea	L19B40
	bra.s	L8378
;
L83E2:
	clr	-(sp)
	clr.l	-(sp)
	move	-538(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	-536(a6),-(sp)
	move.l	-546(a6),-(sp)
	move	-540(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L78AA
	adda	#$E,sp
	pea	-532(a6)
	moveq	#1,d0
	move	d0,-(sp)
	move	-540(a6),-(sp)
	move	-538(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L7814
	adda	#$E,sp
	move	d0,-542(a6)
	pea	-532(a6)
	move.l	8(a6),a0
	pea	2(a0)
	move	-542(a6),d0
	bne.s	L8448
	pea	L19B61
	bra.s	L844E
;
L8448:
	pea	L19B66
L844E:
	pea	L19B45
	jsr	L6526
	adda	#$10,sp
	move	-542(a6),d0
	bne.s	L84C2
	pea	-532(a6)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L19B6B
	moveq	#7,d0
	move	d0,-(sp)
	jsr	L64FC
	adda	#$E,sp
	move	16(a6),d0
	beq.s	L84AE
	pea	-464(a6)
	move	16(a6),-(sp)
	jsr	L75C6
	addq	#6,sp
	addq	#1,-422(a6)
	pea	-464(a6)
	move	16(a6),-(sp)
	jsr	L764E
	addq	#6,sp
L84AE:
	move.l	8(a6),a0
	addq	#1,52(a0)
	move.l	8(a6),-(sp)
	jsr	LF400
	addq	#4,sp
L84C2:
	move	-538(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move	-542(a6),-(sp)
	move	-540(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L79CE
	addq	#8,sp
	move	-542(a6),d0
	bne	L8380
	moveq	#1,d0
L84EC:
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L84F2:
	link	a6,#-4
	move	L467C8,-(sp)
	jsr	L3976
	addq	#2,sp
	pea	$1D0.l
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	L2C0B8,d0
	move	d0,-4(a6)
	move	d0,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	d0,-(sp)
	jsr	L1806E
	addq	#8,sp
	addq	#1,d0
	move	d0,-2(a6)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	14(a0)
	jsr	L5BB4
	addq	#6,sp
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	move	#$1D0,-(sp)
	move.l	8(a6),-(sp)
	move	-4(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmpi	#$1D0,d0
	beq.s	L8582
	clr	-2(a6)
	pea	L19B7B
	jsr	L6526
	addq	#4,sp
L8582:
	move	L467C8,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L8598:
	link	a6,#-4
	move.l	14(a6),a0
	move	44(a0),d0
	blt.s	L85B2
	move.l	14(a6),a0
	cmpi	#4,44(a0)
	ble.s	L85BC
L85B2:
	move.l	14(a6),a0
	moveq	#4,d0
	move	d0,44(a0)
L85BC:
	move	20(a6),d0
	beq.s	L861E
	move.l	14(a6),a0
	pea	64(a0)
	move.l	14(a6),a0
	move	34(a0),-(sp)
	move.l	14(a6),a0
	move	42(a0),-(sp)
	move.l	14(a6),a0
	move.l	38(a0),-(sp)
	move.l	14(a6),-(sp)
	move	12(a6),-(sp)
	move	22(a6),d0
	beq.s	L85F4
	moveq	#66,d0
	bra.s	L85F6
;
L85F4:
	moveq	#32,d0
L85F6:
	move	d0,-(sp)
	move.l	14(a6),a0
	move	48(a0),d0
	beq.s	L8606
	moveq	#72,d0
	bra.s	L8608
;
L8606:
	moveq	#32,d0
L8608:
	move	d0,-(sp)
	pea	L19B9F
	jsr	L63E0
	adda	#$1A,sp
	bra	L8764
;
L861E:
	move	22(a6),d0
	beq.s	L862C
	pea	L19BF6
	bra.s	L8632
;
L862C:
	pea	L19C03
L8632:
	move.l	14(a6),a0
	move	48(a0),d0
	beq.s	L8644
	pea	L19BEC
	bra.s	L864A
;
L8644:
	pea	L19BF5
L864A:
	move.l	14(a6),a0
	move	36(a0),-(sp)
	move.l	14(a6),a0
	move	34(a0),-(sp)
	move.l	14(a6),a0
	move.l	38(a0),-(sp)
	move.l	14(a6),-(sp)
	move	12(a6),-(sp)
	pea	L19BC1
	jsr	L63E0
	adda	#$1A,sp
	move.l	14(a6),a0
	pea	14(a0)
	pea	L19C04
	jsr	L63E0
	addq	#8,sp
	pea	L19C15
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	14(a6),a0
	move	46(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA492
	adda	#$A,sp
	move.l	14(a6),a0
	move	42(a0),-(sp)
	pea	L19C24
	jsr	L63E0
	addq	#6,sp
	move	18(a6),d0
	beq.s	L86FC
	move.l	14(a6),a0
	move	44(a0),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18808,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	pea	L19C3D
	jsr	L63E0
	addq	#8,sp
L86FC:
	pea	L19C4E
	jsr	L63E0
	addq	#4,sp
	clr	-4(a6)
L870E:
	cmpi	#5,-4(a6)
	bge.s	L8730
	move	-4(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	14(a6),a0
	move.b	64(a0),d0
	beq.s	L8730
	addq	#1,-4(a6)
	bra.s	L870E
;
L8730:
	clr	-2(a6)
L8734:
	move	-2(a6),d0
	cmp	-4(a6),d0
	bge.s	L8764
	move	-2(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	14(a6),a0
	pea	64(a0)
	pea	L19C5C
	jsr	L63E0
	addq	#8,sp
	addq	#1,-2(a6)
	bra.s	L8734
;
L8764:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L8768:
	link	a6,#0
	move.l	14(a6),a0
	move	12(a6),d0
	and	46(a0),d0
	bne.s	L877E
L877A:
	clr	d0
	bra.s	L87A8
;
L877E:
	move.l	8(a6),a1
	move.l	14(a6),a0
	move	44(a0),d0
	cmp	32(a1),d0
	bgt.s	L877A
	move.l	14(a6),a0
	move	48(a0),d0
	beq.s	L87A6
	move.l	8(a6),a0
	cmpi	#3,32(a0)
	blt.s	L877A
L87A6:
	moveq	#1,d0
L87A8:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L87AC:
	link	a6,#-10
	move.l	a3,-(sp)
	move.l	12(a6),-4(a6)
L87B8:
	move.l	-4(a6),a0
	move.b	(a0),d0
	beq.s	L87D0
	move.l	-4(a6),a0
	cmpi.b	#$2E,(a0)
	beq.s	L87D0
	addq.l	#1,-4(a6)
	bra.s	L87B8
;
L87D0:
	move.l	-4(a6),a0
	move.b	(a0),d0
	beq.s	L87DC
	addq.l	#1,-4(a6)
L87DC:
	pea	L19C60
	move.l	8(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	clr	-6(a6)
L87F2:
	move.l	12(a6),a0
	move.b	(a0),d0
	beq.s	L8852
	move.l	12(a6),a0
	cmpi.b	#$2E,(a0)
	beq.s	L8852
	cmpi	#8,-6(a6)
	bge.s	L8852
	move	-6(a6),a3
	adda.l	8(a6),a3
	move.l	12(a6),a0
	addq.l	#1,12(a6)
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move.b	d0,(a3)
	cmpi	#$2A,d0
	bne.s	L884C
L8832:
	cmpi	#8,-6(a6)
	bge.s	L884C
	move	-6(a6),a0
	adda.l	8(a6),a0
	moveq	#63,d0
	move.b	d0,(a0)
	addq	#1,-6(a6)
	bra.s	L8832
;
L884C:
	addq	#1,-6(a6)
	bra.s	L87F2
;
L8852:
	moveq	#9,d0
	move	d0,-6(a6)
L8858:
	move.l	-4(a6),a0
	move.b	(a0),d0
	beq.s	L88AE
	cmpi	#$C,-6(a6)
	bge.s	L88AE
	move	-6(a6),a3
	adda.l	8(a6),a3
	move.l	-4(a6),a0
	addq.l	#1,-4(a6)
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move.b	d0,(a3)
	cmpi	#$2A,d0
	bne.s	L88A8
L888E:
	cmpi	#$C,-6(a6)
	bge.s	L88A8
	move	-6(a6),a0
	adda.l	8(a6),a0
	moveq	#63,d0
	move.b	d0,(a0)
	addq	#1,-6(a6)
	bra.s	L888E
;
L88A8:
	addq	#1,-6(a6)
	bra.s	L8858
;
L88AE:
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L88B4:
	link	a6,#-20
	move.l	12(a6),-(sp)
	pea	-18(a6)
	jsr	L87AC
	addq	#8,sp
	clr	-2(a6)
L88CC:
	cmpi	#$C,-2(a6)
	bge.s	L890A
	move	-2(a6),a0
	adda.l	8(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move.b	d0,-20(a6)
	cmpi	#$3F,d0
	bne.s	L88F0
L88EA:
	addq	#1,-2(a6)
	bra.s	L88CC
;
L88F0:
	move.l	a6,a0
	adda	-2(a6),a0
	move.b	-18(a0),d1
	ext.w	d1
	move.b	-20(a6),d0
	ext.w	d0
	cmp	d1,d0
	beq.s	L88EA
	clr	d0
	bra.s	L8926
;
L890A:
	pea	-9(a6)
	pea	L19C6D
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	beq.s	L8924
	moveq	#1,d0
	bra.s	L8926
;
L8924:
	moveq	#2,d0
L8926:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L892A:
	link	a6,#0
	move	14(a6),d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	move.l	d0,a1
	adda.l	8(a6),a1
	move	12(a6),d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	8(a6),a0
	move	(a0),d0
	cmp	(a1),d0
	beq.s	L898A
	move	12(a6),d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	move.l	d0,a1
	adda.l	8(a6),a1
	move	14(a6),d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	8(a6),a0
	move	(a0),d0
	cmp	(a1),d0
	bcc.s	L8986
	moveq	#1,d0
	bra.s	L898C
;
L8986:
	moveq	#-1,d0
	bra.s	L898C
;
L898A:
	clr	d0
L898C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L8990:
	link	a6,#-2
	move	12(a6),d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	8(a6),a0
	move	(a0),-2(a6)
	move	12(a6),d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	8(a6),a0
	move	14(a6),d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	move.l	d0,a1
	adda.l	8(a6),a1
	move	(a1),(a0)
	move	14(a6),d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	8(a6),a0
	move	-2(a6),(a0)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L89EA:
	link	a6,#-536
	move.l	a3,-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-532(a6)
	jsr	L76F8
	move	d0,-506(a6)
	bne.s	L8A1E
	move.l	L1892C,-(sp)
	move.l	L196E8,-(sp)
	jsr	L63E0
	addq	#8,sp
	bra	L931A
;
L8A1E:
	clr	-498(a6)
L8A22:
	cmpi	#$A,-498(a6)
	bge.s	L8A40
	move	-498(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	clr	-528(a0)
	addq	#1,-498(a6)
	bra.s	L8A22
;
L8A40:
	move.l	8(a6),-(sp)
	jsr	L9654
	addq	#4,sp
	pea	L19C71
	jsr	L63E0
	addq	#4,sp
	moveq	#13,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L5960
	adda	#$A,sp
	cmpi	#$FFFF,d0
	beq	L931A
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-468(a6)
	move.l	-468(a6),a0
	move.b	(a0),d0
	beq.s	L8A9E
	move.l	-468(a6),-(sp)
	bra.s	L8AA4
;
L8A9E:
	pea	L19C86
L8AA4:
	pea	-484(a6)
	jsr	L87AC
	addq	#8,sp
	move.l	8(a6),a0
	move	122(a0),-504(a6)
	beq.s	L8AD0
	move	-504(a6),-(sp)
	move.l	L196E0,-(sp)
	jsr	L63E0
	addq	#6,sp
	bra.s	L8AD4
;
L8AD0:
	addq	#1,-504(a6)
L8AD4:
	move	-504(a6),-(sp)
	move	-506(a6),-(sp)
	move.l	L196E4,-(sp)
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-502(a6)
	cmpi	#$FFFF,d0
	beq	L931A
	pea	L19C8A
	move.l	8(a6),-(sp)
	jsr	L6BA4
	addq	#8,sp
	move	d0,-500(a6)
	beq	L931A
	pea	L19C90
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	clr	-(sp)
	move	-500(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA492
	adda	#$A,sp
	clr	-(sp)
	pea	L19CAB
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-490(a6)
	cmpi	#$FFFF,d0
	beq	L931A
	moveq	#1,d0
	move	d0,-(sp)
	pea	L19CC5
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-494(a6)
	cmpi	#$FFFF,d0
	beq	L931A
	move	-502(a6),d0
	bne.s	L8BA4
	move	-504(a6),-502(a6)
L8BA4:
	clr	-496(a6)
	moveq	#1,d0
	move	d0,-488(a6)
	move	-502(a6),-504(a6)
L8BB4:
	cmpi	#1,-504(a6)
	bcs	L92D4
	move	-504(a6),d0
	cmp	-506(a6),d0
	bhi	L92D4
	move.l	8(a6),-(sp)
	jsr	L5C60
	addq	#4,sp
	move.l	8(a6),a0
	move.l	#L19CDA,2608(a0)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L6AF8
	addq	#6,sp
	move	d0,d0
	bne	L92D4
	addq	#1,-496(a6)
	move	-496(a6),d0
	cmpi	#$F,d0
	ble.s	L8C18
	pea	L19CEB
	jsr	L63E0
	addq	#4,sp
	clr	-496(a6)
L8C18:
	pea	-464(a6)
	move	-504(a6),-(sp)
	jsr	L75C6
	addq	#6,sp
	move	d0,d0
	beq.s	L8C38
L8C2C:
	move	-488(a6),d0
	add	d0,-504(a6)
	bra	L8BB4
;
L8C38:
	pea	-464(a6)
	move	-500(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L8768
	adda	#$A,sp
	move	d0,d0
	beq.s	L8C2C
	pea	-464(a6)
	pea	-484(a6)
	jsr	L88B4
	addq	#8,sp
	move	d0,-492(a6)
	beq.s	L8C2C
	move.l	8(a6),a0
	move	-504(a6),d0
	cmp	122(a0),d0
	bls.s	L8C80
	move.l	8(a6),a0
	move	-504(a6),122(a0)
L8C80:
	move	-504(a6),-508(a6)
	pea	-528(a6)
	move	-504(a6),-(sp)
	jsr	L7748
	addq	#6,sp
	move	d0,d0
	blt.s	L8C9E
	moveq	#1,d0
	bra.s	L8CA0
;
L8C9E:
	clr	d0
L8CA0:
	move	d0,-498(a6)
	move	-494(a6),d0
	bne.s	L8CE4
	clr	-496(a6)
	move	-498(a6),-(sp)
	move	-490(a6),-(sp)
	move.l	8(a6),a0
	cmpi	#3,32(a0)
	blt.s	L8CC8
	moveq	#1,d0
	move	d0,-(sp)
	bra.s	L8CCA
;
L8CC8:
	clr	-(sp)
L8CCA:
	pea	-464(a6)
	move	-504(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L8598
	adda	#$10,sp
	bra	L8C2C
;
L8CE4:
	clr	-496(a6)
	clr	-488(a6)
	move	-498(a6),-(sp)
	move	-490(a6),-(sp)
	move.l	8(a6),a0
	cmpi	#3,32(a0)
	blt.s	L8D06
	moveq	#1,d0
	move	d0,-(sp)
	bra.s	L8D08
;
L8D06:
	clr	-(sp)
L8D08:
	pea	-464(a6)
	move	-504(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L8598
	adda	#$10,sp
	move	-498(a6),d0
	bne.s	L8D2C
	pea	L19D0F
	bra.s	L8D32
;
L8D2C:
	pea	L19D11
L8D32:
	pea	L19CF0
	jsr	L63E0
	addq	#8,sp
	cmpi	#1,-492(a6)
	ble.s	L8D56
	pea	L19D15
	jsr	L63E0
	addq	#4,sp
L8D56:
	move.l	8(a6),a0
	cmpi	#3,32(a0)
	blt.s	L8D92
	move	-416(a6),d0
	beq.s	L8D70
	pea	L19D33
	bra.s	L8D76
;
L8D70:
	pea	L19D39
L8D76:
	pea	L19D23
	jsr	L63E0
	addq	#8,sp
	pea	L19D41
	jsr	L63E0
	addq	#4,sp
L8D92:
	move.l	#L19D7F,-468(a6)
	move.l	8(a6),a0
	cmpi	#3,32(a0)
	blt.s	L8DB0
	move.l	#L19D8A,-468(a6)
	bra.s	L8DDE
;
L8DB0:
	pea	-450(a6)
	move.l	8(a6),a0
	pea	2(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	L8DDE
	move.l	#L19D9D,-468(a6)
	pea	L19DA9
	jsr	L63E0
	addq	#4,sp
L8DDE:
	pea	L19DB1
	jsr	L63E0
	addq	#4,sp
	move.l	-468(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L6A98
	addq	#8,sp
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move	d0,-(sp)
	pea	L19DC0
	jsr	L120D4
L8E14:
	addq	#6,sp
	move	d0,-486(a6)
	bge.s	L8E2E
	pea	L19DD1
	jsr	L63E0
	addq	#4,sp
	bra	L92D4
;
L8E2E:
	move	-486(a6),d0
	cmpi	#$F,d0
	bhi	L8C2C
	lsl.w	#2,d0
	move	d0,a0
	adda.l	#L1835C,a0
	move.l	(a0),a0
	jmp	(a0)
;
L8E48:
	bra	L8C2C
;
L8E4C:
	pea	L19DD6
	jsr	L63E0
	addq	#4,sp
	moveq	#-1,d0
L8E5C:
	move	d0,-488(a6)
	bra	L8C2C
;
L8E64:
	pea	L19DE0
L8E6A:
	jsr	L63E0
L8E70:
	addq	#4,sp
L8E72:
	moveq	#1,d0
	bra.s	L8E5C
;
L8E76:
	move	-416(a6),d0
	beq.s	L8E84
	pea	L19DEF
	bra.s	L8E8A
;
L8E84:
	pea	L19DF4
L8E8A:
	pea	L19DE6
	jsr	L63E0
	addq	#8,sp
	move	-416(a6),d0
	bne.s	L8EA2
	moveq	#1,d0
	bra.s	L8EA4
;
L8EA2:
	clr	d0
L8EA4:
	move	d0,-416(a6)
L8EA8:
	pea	-464(a6)
	move	-504(a6),-(sp)
	jsr	L764E
L8EB6:
	addq	#6,sp
	bra	L8C2C
;
L8EBC:
	pea	L19DFB
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#50,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	L8C2C
	move.l	8(a6),a3
	move.l	8(a6),-(sp)
	jsr	LA6D8
	addq	#4,sp
	and	46(a3),d0
	move	d0,-418(a6)
L8F06:
	beq	L8C2C
	bra.s	L8EA8
;
L8F0C:
	pea	L19E0F
	jsr	L63E0
	addq	#4,sp
	clr	-422(a6)
	bra.s	L8EA8
;
L8F20:
	pea	L19E1C
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#20,d0
	move	d0,-(sp)
	pea	-450(a6)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move.b	-450(a6),d0
	bra.s	L8F06
;
L8F4C:
	move.l	L196DC,-(sp)
	jsr	L63E0
	addq	#4,sp
	clr	-498(a6)
L8F5E:
	cmpi	#5,-498(a6)
	bge.s	L8FC2
	move	-498(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	a6,a0
	move.b	-400(a0),d0
	beq.s	L8FC2
	move	-498(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	a6,a0
	pea	-400(a0)
	move	-498(a6),d0
	muls	#80,d0
	add.l	-532(a6),d0
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
	move	-498(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	a6,a0
	pea	-400(a0)
	pea	L19E28
	jsr	L63E0
	addq	#8,sp
	addq	#1,-498(a6)
	bra.s	L8F5E
;
L8FC2:
	cmpi	#5,-498(a6)
	bge.s	L8FEC
	pea	L19E2C
	move	-498(a6),d0
	muls	#80,d0
	add.l	-532(a6),d0
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
	addq	#1,-498(a6)
	bra.s	L8FC2
;
L8FEC:
	clr	-(sp)
	moveq	#5,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L14DAE
	addq	#8,sp
	move	d0,d0
	ble	L8C2C
	clr	-498(a6)
L9008:
	cmpi	#5,-498(a6)
	bge.s	L904E
	move	-498(a6),d0
	muls	#80,d0
	add.l	-532(a6),d0
	move.l	d0,-(sp)
	move	-498(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	a6,a0
	pea	-400(a0)
	jsr	L11FEC
	addq	#8,sp
	move	-498(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	a6,a0
	move.b	-400(a0),d0
	beq.s	L904E
	addq	#1,-498(a6)
	bra.s	L9008
;
L904E:
	cmpi	#5,-498(a6)
	bge	L8EA8
	move	-498(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	a6,a0
	clr.b	-400(a0)
	addq	#1,-498(a6)
	bra.s	L904E
;
L906E:
	move.l	L1AEAA,-(sp)
	pea	L19E2D
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	moveq	#-3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-420(a6)
	blt	L8C2C
	cmpi	#4,-420(a6)
	bgt	L8C2C
	bra	L8EA8
;
L90B4:
	pea	L19E36
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	move	2994(a0),d0
	beq.s	L90DE
	pea	L19E3C
L90D2:
	jsr	L63E0
L90D8:
	addq	#4,sp
	bra	L8C2C
;
L90DE:
	clr	-(sp)
	pea	-464(a6)
	move	-504(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L97D0
	adda	#$C,sp
	bra	L8C2C
;
L90FA:
	pea	L19E53
	jsr	L63E0
	addq	#4,sp
	cmpi	#1,-492(a6)
	ble	L8C2C
	moveq	#1,d0
	move	d0,-(sp)
	pea	-464(a6)
	move	-504(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L983E
	adda	#$C,sp
	move	d0,d0
	beq	L8C2C
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L1637C
	addq	#8,sp
	pea	L19E5F
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),-(sp)
	jsr	L6F7A
	bra	L90D8
;
L9162:
	moveq	#1,d0
	move	d0,-(sp)
	pea	L19E6F
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	cmpi	#1,d0
	bne	L8C2C
	clr	-418(a6)
	pea	-464(a6)
	move	-504(a6),-(sp)
	jsr	L764E
	addq	#6,sp
	moveq	#1,d0
	move	d0,-(sp)
	pea	-464(a6)
	move	-504(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L983E
	adda	#$C,sp
	move	d0,d0
	beq	L8E72
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	task_Fdelete
	bra	L8E70
;
L91C8:
	pea	-464(a6)
	pea	L19EA4
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	moveq	#14,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move.l	8(a6),a0
	move.b	2638(a0),d0
	beq.s	L9214
	move.l	8(a6),a0
	pea	2638(a0)
	pea	-464(a6)
	jsr	L11FEC
	addq	#8,sp
L9214:
	moveq	#1,d0
	move	d0,-(sp)
	pea	-464(a6)
	move	-504(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L983E
	adda	#$C,sp
	move	d0,d0
	bra	L8F06
;
L9234:
	move.l	8(a6),a0
	move	2994(a0),d0
	beq.s	L9248
	pea	L19EB5
	bra	L90D2
;
L9248:
	pea	-528(a6)
	move	-504(a6),-(sp)
	jsr	L7748
	addq	#6,sp
	move	d0,-498(a6)
	bge.s	L92B2
	pea	-528(a6)
	move	-504(a6),-(sp)
	jsr	L77B0
	addq	#6,sp
	move	d0,-498(a6)
	pea	L19ED2
	jsr	L63E0
	addq	#4,sp
	pea	-528(a6)
	move	-504(a6),-(sp)
	jsr	L7748
	addq	#6,sp
	move	d0,d0
	bge.s	L92A8
	moveq	#10,d0
	move	d0,-(sp)
	pea	L19EDF
	jsr	L63E0
	bra	L8EB6
;
L92A8:
	pea	L19F0F
	bra	L8E6A
;
L92B2:
	pea	L19F33
	jsr	L63E0
	addq	#4,sp
	move	-498(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	clr	-528(a0)
	bra	L8E72
;
L92D4:
	pea	-528(a6)
	clr	-(sp)
	jsr	L77B0
	addq	#6,sp
	move	d0,-496(a6)
	ble.s	L930C
	pea	-528(a6)
	pea	-464(a6)
	move.l	8(a6),-(sp)
	jsr	L9320
	adda	#$C,sp
	move	d0,d0
	bne.s	L931A
	move	-508(a6),-502(a6)
	bra	L8BA4
;
L930C:
	pea	L19F43
	jsr	L63E0
	addq	#4,sp
L931A:
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L9320:
	link	a6,#-38
	move.l	a3,-(sp)
	move.l	#L19F63,-20(a6)
	move.l	#L19F87,-24(a6)
	move.l	#L19FAC,-28(a6)
	pea	L8990
	pea	L892A
	move.l	16(a6),-(sp)
	moveq	#10,d0
	move	d0,-(sp)
	jsr	L5F6C
	adda	#$E,sp
	clr.l	-8(a6)
	clr	-12(a6)
	clr	-14(a6)
	clr	-32(a6)
L936C:
	cmpi	#$A,-32(a6)
	bge	L942C
	move	-32(a6),d0
	bne.s	L93A2
	pea	L19FC0
	jsr	L63E0
	addq	#4,sp
	move.l	-20(a6),-(sp)
	jsr	L63E0
	addq	#4,sp
	move.l	-24(a6),-(sp)
	jsr	L63E0
	addq	#4,sp
L93A2:
	move	-32(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	16(a6),a0
	move	(a0),-16(a6)
	beq.s	L93CA
	move.l	12(a6),-(sp)
	move	-16(a6),-(sp)
	jsr	L75C6
	addq	#6,sp
	move	d0,d0
	beq.s	L93D0
L93CA:
	addq	#1,-32(a6)
	bra.s	L936C
;
L93D0:
	move.l	12(a6),a0
	move.l	38(a0),d0
	addi.l	#$80,d0
	asr.l	#7,d0
	move.l	d0,-4(a6)
	add.l	d0,-8(a6)
	move.l	12(a6),a0
	move.l	38(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	L7844
	addq	#8,sp
	addi	#$3B,d0
	move	d0,-10(a6)
	add	d0,-12(a6)
	move	-10(a6),-(sp)
	move.l	-4(a6),-(sp)
	move.l	12(a6),-(sp)
	move	-16(a6),-(sp)
	move.l	-28(a6),-(sp)
	jsr	L63E0
	adda	#$10,sp
	addq	#1,-14(a6)
	bra.s	L93CA
;
L942C:
	move.l	-24(a6),-(sp)
	jsr	L63E0
	addq	#4,sp
	move	-12(a6),-(sp)
	move.l	-8(a6),-(sp)
	pea	L19FCD
	move	-14(a6),-(sp)
	move.l	-28(a6),-(sp)
	jsr	L63E0
	adda	#$10,sp
	move	-14(a6),-(sp)
	pea	L19FD4
	jsr	L63E0
	addq	#6,sp
	clr	-(sp)
	pea	L1A005
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-32(a6)
	move	-32(a6),d0
	bne.s	L9490
	clr	d0
	bra	L964E
;
L9490:
	cmpi	#1,-32(a6)
	bne	L964C
	move.l	L1893E,-(sp)
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),-(sp)
	jsr	L154C8
	addq	#4,sp
	clr	-34(a6)
	clr	-32(a6)
L94BC:
	cmpi	#$A,-32(a6)
	bge	L960C
	move	-32(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	16(a6),a0
	move	(a0),-16(a6)
	beq.s	L94EE
	move.l	12(a6),-(sp)
	move	-16(a6),-(sp)
	jsr	L75C6
	addq	#6,sp
	move	d0,d0
	beq.s	L94F4
L94EE:
	addq	#1,-32(a6)
	bra.s	L94BC
;
L94F4:
	clr	-(sp)
	move.l	12(a6),-(sp)
	move	-16(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L983E
	adda	#$C,sp
	move	d0,d0
	beq.s	L94EE
	move.l	8(a6),a0
	move	2986(a0),d0
	beq.s	L9542
	move.l	8(a6),a0
	move	34(a0),d0
	beq.s	L94EE
	move.l	8(a6),a3
	move.l	12(a6),a0
	move.l	38(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	L7844
	addq	#8,sp
	cmp	34(a3),d0
	bhi.s	L94EE
L9542:
	clr	-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L15572
	adda	#$A,sp
	move	d0,-34(a6)
	bne	L960C
	clr	-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-30(a6)
	ble	L94EE
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L1A043
	moveq	#7,d0
	move	d0,-(sp)
	jsr	L64FC
	adda	#$E,sp
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L1A053
	jsr	L6526
	adda	#$C,sp
	move.l	12(a6),-(sp)
	move	-16(a6),-(sp)
	jsr	L75C6
	addq	#6,sp
	move.l	12(a6),a0
	addq	#1,42(a0)
	move.l	12(a6),-(sp)
	move	-16(a6),-(sp)
	jsr	L764E
	addq	#6,sp
	move.l	8(a6),a0
	addq	#1,52(a0)
	move.l	8(a6),-(sp)
	jsr	LF400
	addq	#4,sp
	move	-30(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	bra	L94EE
;
L960C:
	move	-34(a6),d0
	bne.s	L9628
	clr	-(sp)
	pea	L1A073
	move.l	8(a6),-(sp)
	jsr	L15572
	adda	#$A,sp
L9628:
	move.l	8(a6),-(sp)
	jsr	L15536
	addq	#4,sp
	move	-34(a6),-(sp)
	moveq	#4,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L79CE
	addq	#8,sp
	moveq	#1,d0
	bra.s	L964E
;
L964C:
	moveq	#-1,d0
L964E:
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L9654:
	link	a6,#-2
	jsr	L76F8
	move	d0,-2(a6)
	move.l	8(a6),a0
	move	122(a0),d0
	cmp	-2(a6),d0
	bls.s	L9678
	move.l	8(a6),a0
	clr	122(a0)
L9678:
	move.l	8(a6),a0
	move	-2(a6),d0
	sub	122(a0),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L9688:
	link	a6,#-468
	jsr	L76F8
	move	d0,-468(a6)
	bne.s	L96B0
	move.l	L1892C,-(sp)
	move.l	L196E8,-(sp)
	jsr	L63E0
	addq	#8,sp
	bra	L97CC
;
L96B0:
	move.l	8(a6),a0
	move	2994(a0),d0
	beq.s	L96CC
	pea	L1A074
	jsr	L63E0
	addq	#4,sp
	bra	L97CC
;
L96CC:
	move.l	8(a6),a0
	move.l	#L1A097,2608(a0)
	move	-468(a6),-(sp)
	pea	L1A0AB
	jsr	L63E0
	addq	#6,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-466(a6)
	cmpi	#$FFFF,d0
	beq	L97CC
	move	-466(a6),d0
	beq	L97CC
	move	-466(a6),d0
	cmp	-468(a6),d0
	bls.s	L9734
	pea	L1A0D8
	jsr	L63E0
	addq	#4,sp
	bra.s	L96CC
;
L9734:
	pea	-464(a6)
	move	-466(a6),-(sp)
	jsr	L75C6
	addq	#6,sp
	move	d0,d0
	bne.s	L9766
	pea	-464(a6)
	move.l	8(a6),a0
	move	46(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	L8768
	adda	#$A,sp
	move	d0,d0
	bne.s	L977C
L9766:
	move	-466(a6),-(sp)
	pea	L1A0EC
	jsr	L63E0
	addq	#6,sp
	bra	L96CC
;
L977C:
	clr	-(sp)
	clr	-(sp)
	move.l	8(a6),a0
	cmpi	#3,32(a0)
	blt.s	L9792
	moveq	#1,d0
	move	d0,-(sp)
	bra.s	L9794
;
L9792:
	clr	-(sp)
L9794:
	pea	-464(a6)
	move	-466(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L8598
	adda	#$10,sp
	moveq	#1,d0
	move	d0,-(sp)
	pea	-464(a6)
	move	-466(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L97D0
	adda	#$C,sp
	cmpi	#$FFFF,d0
	bne	L96CC
L97CC:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L97D0:
	link	a6,#-2
	clr	-2(a6)
	move	18(a6),d0
	beq.s	L97FE
	clr	-(sp)
	pea	L1A10C
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-2(a6)
	cmpi	#1,d0
	bne.s	L9836
L97FE:
	moveq	#1,d0
	move	d0,-(sp)
	move.l	14(a6),-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L983E
	adda	#$C,sp
	move	d0,d0
	beq.s	L9836
	move	12(a6),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L8290
	adda	#$A,sp
L9836:
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L983E:
	link	a6,#-8
	move	L467C8,-(sp)
	jsr	L3976
	addq	#2,sp
	moveq	#-1,d0
	move	d0,-2(a6)
L9856:
	cmpi	#$10,-2(a6)
	bge	L98FA
	cmpi	#$FFFF,-2(a6)
	bne.s	L987C
	lea	L46E22,a0
	move.l	a0,-8(a6)
	move.b	(a0),d0
	bne.s	L9894
L9876:
	addq	#1,-2(a6)
	bra.s	L9856
;
L987C:
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#5,d0
	lea	L46C22,a0
	adda.l	d0,a0
	move.l	a0,-8(a6)
	move.b	(a0),d0
	beq.s	L9876
L9894:
	move.l	-8(a6),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L11FEC
	addq	#8,sp
	move.l	14(a6),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L1206E
	addq	#8,sp
	clr	-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-4(a6)
	ble.s	L9876
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	-4(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	14(a6),a0
	move.l	d0,38(a0)
	move	-4(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
L98FA:
	move	L467C8,-(sp)
	jsr	L3852
	addq	#2,sp
	cmpi	#$10,-2(a6)
	beq.s	L9914
	moveq	#1,d0
	bra.s	L9916
;
L9914:
	clr	d0
L9916:
	move	d0,-2(a6)
	move	-2(a6),d0
	bne.s	L9956
	move.l	14(a6),-(sp)
	move	12(a6),-(sp)
	pea	L1A121
	jsr	L6526
	adda	#$A,sp
	move	18(a6),d0
	beq.s	L9956
	move.l	14(a6),-(sp)
	move	12(a6),-(sp)
	pea	L1A13E
	jsr	L63E0
	adda	#$A,sp
L9956:
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L995E:
	link	a6,#-68
	move.l	8(a6),a0
	move.l	#L1A160,2608(a0)
	moveq	#49,d0
	move	d0,-(sp)
	move.l	12(a6),-(sp)
	pea	-64(a6)
	jsr	L12008
	adda	#$A,sp
	pea	-64(a6)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-68(a6)
	move.l	-68(a6),a0
	move.b	(a0),d0
	bne.s	L99FE
	pea	L1A171
	jsr	L63E0
	addq	#4,sp
	moveq	#13,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L5960
	adda	#$A,sp
	cmpi	#$FFFF,d0
	beq.s	L9A12
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-68(a6)
	move.l	-68(a6),a0
	move.b	(a0),d0
	beq.s	L99EC
	move.l	-68(a6),-(sp)
	bra.s	L99F2
;
L99EC:
	pea	L1A186
L99F2:
	pea	-64(a6)
	jsr	L1206E
	addq	#8,sp
L99FE:
	clr	-(sp)
	pea	-64(a6)
	move.l	8(a6),-(sp)
	jsr	L61B4
	adda	#$A,sp
L9A12:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
sys_pack_func:
	link	a6,#-544
	pea	L1A18A
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	pea	L1A1CC
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	cmpi	#1,d0
	bne	L9C04
	move.l	L18870,d0
	move.l	d0,-536(a6)
	move.l	d0,-(sp)
	pea	L1A1E4
	jsr	L63E0
	addq	#8,sp
	move.l	-536(a6),-(sp)
	pea	-532(a6)
	jsr	L11FEC
	addq	#8,sp
	pea	-532(a6)
	jsr	L11FCA
	addq	#4,sp
	ext.l	d0
	add.l	a6,d0
	subi.l	#$214,d0
	move.l	d0,-468(a6)
L9A8A:
	move.l	a6,d0
	subi.l	#$214,d0
	move.l	-468(a6),a0
	subq.l	#1,-468(a6)
	cmp.l	d0,a0
	bls.s	L9AA8
	move.l	-468(a6),a0
	cmpi.b	#$2E,(a0)
	bne.s	L9A8A
L9AA8:
	pea	L1A1F1
	move.l	-468(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	pea	-532(a6)
	jsr	L4B74
	addq	#4,sp
	move	d0,-538(a6)
	bge.s	L9ADA
	pea	-532(a6)
	pea	L1A1F6
	bra	L9BFC
;
L9ADA:
	move	L467C8,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	clr.l	-(sp)
	move	L2C0B8,d0
	move	d0,-544(a6)
	move	d0,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	clr	-540(a6)
	clr	-542(a6)
L9B08:
	move	-540(a6),d0
	bne.s	L9B54
	move	#$1D0,-(sp)
	pea	-464(a6)
	move	-544(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	cmpi	#$1D0,d0
	bne.s	L9B54
	move	-418(a6),d0
	bne.s	L9B34
	addq	#1,-542(a6)
	bra.s	L9B08
;
L9B34:
	move	#$1D0,-(sp)
	pea	-464(a6)
	move	-538(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmpi	#$1D0,d0
	beq.s	L9B08
	addq	#1,-540(a6)
	bra.s	L9B08
;
L9B54:
	move	-540(a6),d0
	bne.s	L9BCC
	move	-544(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move	-538(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move.l	-536(a6),-(sp)
	jsr	task_Fdelete
	addq	#4,sp
	move.l	-536(a6),-(sp)
	pea	-532(a6)
	jsr	task_Frename
	addq	#8,sp
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-536(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,L2C0B8
	move	L467C8,-(sp)
	jsr	L3852
	addq	#2,sp
	move.l	-536(a6),-(sp)
	move	-542(a6),-(sp)
	pea	L1A208
	jsr	L63E0
	adda	#$A,sp
	bra.s	L9C04
;
L9BCC:
	move	-538(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	pea	-532(a6)
	jsr	task_Fdelete
	addq	#4,sp
	move	L467C8,-(sp)
	jsr	L3852
	addq	#2,sp
	move.l	-536(a6),-(sp)
	pea	L1A228
L9BFC:
	jsr	L63E0
	addq	#8,sp
L9C04:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L9C08:
	link	a6,#-6
	move	8(a6),d0
	addi	#$FFFF,d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#8,d0
	lsl.l	#1,d0
	addi.l	#$1200,d0
	move.l	d0,-4(a6)
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	move.l	-4(a6),-(sp)
	move	L2C0B2,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	#$200,-(sp)
	move.l	10(a6),-(sp)
	move	L2C0B2,-(sp)
	jsr	task_Fread
	addq	#8,sp
	cmpi	#$200,d0
	beq.s	L9C6A
	moveq	#1,d0
	bra.s	L9C6C
;
L9C6A:
	clr	d0
L9C6C:
	move	d0,-6(a6)
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-6(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L9C86:
	link	a6,#-6
	move	8(a6),d0
	addi	#$FFFF,d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#8,d0
	lsl.l	#1,d0
	addi.l	#$1200,d0
	move.l	d0,-4(a6)
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	move.l	-4(a6),-(sp)
	move	L2C0B2,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	#$200,-(sp)
	move.l	10(a6),-(sp)
	move	L2C0B2,-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmpi	#$200,d0
	beq.s	L9CE8
	moveq	#1,d0
	bra.s	L9CEA
;
L9CE8:
	clr	d0
L9CEA:
	move	d0,-6(a6)
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-6(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L9D04:
	link	a6,#0
	cmpi	#$400,L2C378
	bls.s	L9D1E
	move	L2C378,d0
	addi	#$FBFF,d0
	bra.s	L9D20
;
L9D1E:
	moveq	#1,d0
L9D20:
	move	d0,L2D37A
L9D26:
	move	L2D37A,d0
	cmp	L2C378,d0
	bhi.s	L9D5A
	move	L2D37A,d0
	andi	#$3FF,d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	lea	L2C37A,a0
	adda.l	d0,a0
	move	(a0),d0
	bne.s	L9D5A
	addq	#1,L2D37A
	bra.s	L9D26
;
L9D5A:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L9D5E:
	link	a6,#-6
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	clr.l	-(sp)
	move	L2C0B2,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	#$1200,-(sp)
	pea	L2C378
	move	L2C0B2,-(sp)
	jsr	task_Fread
	addq	#8,sp
	cmpi	#$1200,d0
	beq.s	L9DA4
	moveq	#1,d0
	bra.s	L9DA6
;
L9DA4:
	clr	d0
L9DA6:
	move	d0,-2(a6)
	jsr	L9D04
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	L2C0B2,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	subi.l	#$1200,d0
	move.l	d0,-6(a6)
	pea	$200.l
	move.l	-6(a6),-(sp)
	jsr	L1806E
	addq	#8,sp
	move	d0,L1A242
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L9DFC:
	link	a6,#-2
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	clr.l	-(sp)
	move	L2C0B2,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	#$1200,-(sp)
	pea	L2C378
	move	L2C0B2,-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmpi	#$1200,d0
	beq.s	L9E42
	moveq	#1,d0
	bra.s	L9E44
;
L9E42:
	clr	d0
L9E44:
	move	d0,-2(a6)
	jsr	L9D04
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L9E64:
	link	a6,#-40
	move.l	8(a6),a0
	move.l	2894(a0),-8(a6)
	move	12(a6),d0
	beq.s	L9EB8
	move	12(a6),d0
	andi	#$3FF,d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	lea	L2C37A,a0
	adda.l	d0,a0
	move	(a0),-4(a6)
	beq.s	L9EB8
	move.l	-8(a6),-(sp)
	move	-4(a6),-(sp)
	jsr	L9C08
	addq	#6,sp
	move	d0,d0
	bne.s	L9EB8
	move.l	-8(a6),a0
	move	12(a6),d0
	cmp	32(a0),d0
	beq.s	L9EBE
L9EB8:
	clr	d0
	bra	L9F4E
;
L9EBE:
	move	14(a6),d0
	bne	L9F4A
	clr	-2(a6)
L9ECA:
	cmpi	#$10,-2(a6)
	bge.s	L9EF6
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a1
	adda.l	-8(a6),a1
	move	(a1),-40(a0)
	addq	#1,-2(a6)
	bra.s	L9ECA
;
L9EF6:
	moveq	#1,d0
	move	d0,-2(a6)
L9EFC:
	cmpi	#$10,-2(a6)
	bge.s	L9F4A
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-40(a0),d0
	beq.s	L9F4A
	move	#$200,d0
	ext.l	d0
	add.l	d0,-8(a6)
	move.l	-8(a6),d0
	move.l	d0,-(sp)
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-40(a0),-(sp)
	jsr	L9C08
	addq	#6,sp
	move	d0,d0
	bne	L9EB8
	addq	#1,-2(a6)
	bra.s	L9EFC
;
L9F4A:
	move	-4(a6),d0
L9F4E:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L9F52:
	link	a6,#-518
	move	8(a6),d0
	andi	#$3FF,d0
	move	d0,-516(a6)
	move	8(a6),d0
	beq.s	L9F9C
	move	-516(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2C37A,a0
	adda.l	d0,a0
	move	(a0),-518(a6)
	beq.s	L9F9C
	pea	-512(a6)
	move	-518(a6),-(sp)
	jsr	L9C08
	addq	#6,sp
	move	d0,d0
	bne.s	L9F9C
	move	8(a6),d0
	cmp	-480(a6),d0
	beq.s	L9FA2
L9F9C:
	clr	d0
	bra	LA054
;
L9FA2:
	clr	-480(a6)
	move	-516(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2C37A,a0
	adda.l	d0,a0
	clr	(a0)
	moveq	#5,d0
	move	d0,-470(a6)
	pea	-512(a6)
	move	-518(a6),-(sp)
	jsr	L9C86
	addq	#6,sp
	clr	-514(a6)
L9FD2:
	cmpi	#$10,-514(a6)
	bge.s	LA02E
	move	-514(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-512(a0),-518(a6)
	beq.s	LA028
	move	-518(a6),d0
	addi	#$FFFF,d0
	lsr.w	#4,d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	lea	L2CB7A,a1
	adda.l	d0,a1
	move	-518(a6),d0
	addi	#$FFFF,d0
	andi	#$F,d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	or	d0,(a1)
LA028:
	addq	#1,-514(a6)
	bra.s	L9FD2
;
LA02E:
	move	-512(a6),-518(a6)
	beq.s	LA046
	move	-518(a6),d0
	addi	#$FFFF,d0
	lsr.w	#4,d0
	move	d0,L1A240
LA046:
	move	10(a6),d0
	beq.s	LA052
	jsr	L9DFC
LA052:
	moveq	#1,d0
LA054:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LA058:
	link	a6,#-16
	movem.l	d5-d7/a5-a5,(sp)
	move	L1A242,d0
	asr.w	#4,d0
	move	d0,d5
	blt.s	LA072
	cmpi	#$400,d5
	ble.s	LA076
LA072:
	move	#$400,d5
LA076:
	move	L1A240,d0
	move	d0,d7
	ext.l	d0
	lsl.l	#1,d0
	addi.l	#$2CB7A,d0
	move.l	d0,a5
LA08A:
	cmp	d5,d7
	bge.s	LA0C8
	move	(a5),d0
	bne.s	LA098
	addq	#1,d7
	addq.l	#2,a5
	bra.s	LA08A
;
LA098:
	moveq	#0,d6
LA09A:
	cmpi	#$10,d6
	bge.s	LA10A
	move	d6,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a5),d0
	and	(a0),d0
	beq.s	LA0C4
LA0B4:
	move	d7,L1A240
	move	d7,d0
	lsl.w	#4,d0
	add	d6,d0
	addq	#1,d0
	bra.s	LA10C
;
LA0C4:
	addq	#1,d6
	bra.s	LA09A
;
LA0C8:
	clr	d7
	clr	d0
	ext.l	d0
	lsl.l	#1,d0
	addi.l	#$2CB7A,d0
	move.l	d0,a5
LA0D8:
	cmp	L1A240,d7
	bge.s	LA10A
	move	(a5),d0
	bne.s	LA0EA
	addq	#1,d7
	addq.l	#2,a5
	bra.s	LA0D8
;
LA0EA:
	moveq	#0,d6
LA0EC:
	cmpi	#$10,d6
	bge.s	LA10A
	move	d6,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a5),d0
	and	(a0),d0
	bne.s	LA0B4
	addq	#1,d6
	bra.s	LA0EC
;
LA10A:
	clr	d0
LA10C:
	movem.l	(sp),d5-d7/a5-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LA114:
	link	a6,#-542
	pea	L1A244
	jsr	L63E0
	addq	#4,sp
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L2D37A,d0
	addi	#$FFFF,d0
	move	d0,-22(a6)
	addq	#1,L2C378
	move	L2C378,d0
	move	d0,-24(a6)
	clr	-(sp)
	move	-22(a6),d0
	addq	#1,-22(a6)
	move	d0,-(sp)
	jsr	L9F52
	addq	#4,sp
	clr	-10(a6)
LA16A:
	cmpi	#$10,-10(a6)
	bge.s	LA188
	move	-10(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	12(a6),a0
	clr	(a0)
	addq	#1,-10(a6)
	bra.s	LA16A
;
LA188:
	move.l	12(a6),a0
	move	-24(a6),32(a0)
	move.l	12(a6),a0
	clr	36(a0)
	jsr	L6988
	move.l	12(a6),a0
	move	d0,40(a0)
	jsr	L6944
	move.l	12(a6),a0
	move	d0,38(a0)
	move.l	12(a6),a0
	clr	44(a0)
	move.l	12(a6),a0
	move	16(a6),116(a0)
	move.l	8(a6),a0
	move.l	2894(a0),-30(a6)
	move.l	12(a6),d0
	addi.l	#$9C,d0
	move.l	d0,-4(a6)
	move	#$164,-20(a6)
	clr	-16(a6)
	clr	-18(a6)
	clr	-12(a6)
LA1F2:
	move	-12(a6),d0
	cmp	16(a6),d0
	bge	LA33C
	move	-12(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	-30(a6),a0
	move.l	a0,-8(a6)
	move.b	(a0),d0
	beq	LA33C
	move.l	-8(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	addq	#1,d0
	move	d0,-14(a6)
LA228:
	move	-14(a6),d0
	subq	#1,-14(a6)
	move	d0,d0
	beq	LA334
	move.l	-4(a6),a0
	addq.l	#1,-4(a6)
	move.l	-8(a6),a1
	addq.l	#1,-8(a6)
	move.b	(a1),(a0)
	moveq	#1,d0
	move	d0,-18(a6)
	subq	#1,-20(a6)
	bne.s	LA228
	move.l	8(a6),a0
	move	2972(a0),d0
	beq.s	LA282
	move	L1A242,d0
	asr.w	#4,d0
	move	d0,-(sp)
	move	L1A240,-(sp)
	pea	L1A251
	move.l	8(a6),-(sp)
	jsr	L6602
	adda	#$C,sp
LA282:
	jsr	LA058
	move	d0,-26(a6)
	bne.s	LA2A4
	clr	-(sp)
	move	-22(a6),d0
	addq	#1,-22(a6)
	move	d0,-(sp)
	jsr	L9F52
	addq	#4,sp
	bra.s	LA282
;
LA2A4:
	move	-16(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	12(a6),a0
	move	-26(a6),(a0)
	move	-26(a6),d0
	addi	#$FFFF,d0
	lsr.w	#4,d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	lea	L2CB7A,a1
	adda.l	d0,a1
	move	-26(a6),d0
	addi	#$FFFF,d0
	andi	#$F,d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	not	d0
	and	d0,(a1)
	clr	-18(a6)
	move	-16(a6),d0
	beq.s	LA30C
	pea	-542(a6)
	move	-26(a6),-(sp)
	jsr	L9C86
	addq	#6,sp
LA30C:
	addq	#1,-16(a6)
	lea	-542(a6),a0
	move.l	a0,-4(a6)
	move	#$200,-20(a6)
	clr	-(sp)
	move	#$200,-(sp)
	pea	-542(a6)
	jsr	L10C
	addq	#8,sp
	bra	LA228
;
LA334:
	addq	#1,-12(a6)
	bra	LA1F2
;
LA33C:
	move	-18(a6),d0
	beq	LA402
	cmpi	#$10,-16(a6)
	bge	LA402
	move.l	8(a6),a0
	move	2972(a0),d0
	beq.s	LA37C
	move	L1A242,d0
	asr.w	#4,d0
	move	d0,-(sp)
	move	L1A240,-(sp)
	pea	L1A279
	move.l	8(a6),-(sp)
	jsr	L6602
	adda	#$C,sp
LA37C:
	jsr	LA058
	move	d0,-26(a6)
	bne.s	LA39E
	clr	-(sp)
	move	-22(a6),d0
	addq	#1,-22(a6)
	move	d0,-(sp)
	jsr	L9F52
	addq	#4,sp
	bra.s	LA37C
;
LA39E:
	move	-16(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	12(a6),a0
	move	-26(a6),(a0)
	move	-26(a6),d0
	addi	#$FFFF,d0
	lsr.w	#4,d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	lea	L2CB7A,a1
	adda.l	d0,a1
	move	-26(a6),d0
	addi	#$FFFF,d0
	andi	#$F,d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	not	d0
	and	d0,(a1)
	move	-16(a6),d0
	beq.s	LA402
	pea	-542(a6)
	move	-26(a6),-(sp)
	jsr	L9C86
	addq	#6,sp
LA402:
	move.l	12(a6),a0
	move	(a0),-26(a6)
	move.l	12(a6),-(sp)
	move	-26(a6),-(sp)
	jsr	L9C86
	addq	#6,sp
	move	-24(a6),d0
	andi	#$3FF,d0
	swap	d0
	clr	d0
	swap	d0
	lsl.l	#1,d0
	lea	L2C37A,a0
	adda.l	d0,a0
	move	-26(a6),(a0)
	jsr	L9DFC
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	move.l	12(a6),a0
	pea	86(a0)
	move.l	12(a6),a0
	pea	46(a0)
	move.l	12(a6),a0
	pea	66(a0)
	move	-24(a6),-(sp)
	pea	L1A2A1
	moveq	#9,d0
	move	d0,-(sp)
	jsr	L64FC
	adda	#$14,sp
	move	-24(a6),-(sp)
	pea	L1A2BA
	jsr	L63E0
	addq	#6,sp
	moveq	#1,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LA492:
	link	a6,#-26
	clr	-24(a6)
	clr	-26(a6)
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-4(a6)
	move	12(a6),d0
	bne.s	LA4C8
	pea	L1A2CD
	move.l	-4(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	bra	LA644
;
LA4C8:
	clr	-22(a6)
LA4CC:
	cmpi	#$10,-22(a6)
	bge.s	LA518
	move.l	a6,a1
	adda	-22(a6),a1
	move	-22(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	and	12(a6),d0
	beq.s	LA4F6
	moveq	#1,d0
	bra.s	LA4F8
;
LA4F6:
	clr	d0
LA4F8:
	move.b	d0,-20(a1)
	beq.s	LA512
	addq	#1,-24(a6)
	move	-26(a6),d0
	bne.s	LA512
	move	-22(a6),d0
	addq	#1,d0
	move	d0,-26(a6)
LA512:
	addq	#1,-22(a6)
	bra.s	LA4CC
;
LA518:
	moveq	#1,d0
	move	d0,-22(a6)
LA51E:
	cmpi	#$F,-22(a6)
	bge.s	LA55C
	move.l	a6,a0
	adda	-22(a6),a0
	move.b	-21(a0),d0
	beq.s	LA556
	move.l	a6,a0
	adda	-22(a6),a0
	move.b	-20(a0),d0
	beq.s	LA556
	move.l	a6,a0
	adda	-22(a6),a0
	move.b	-19(a0),d0
	beq.s	LA556
	move.l	a6,a0
	adda	-22(a6),a0
	moveq	#45,d0
	move.b	d0,-20(a0)
LA556:
	addq	#1,-22(a6)
	bra.s	LA51E
;
LA55C:
	clr	-22(a6)
LA560:
	cmpi	#$10,-22(a6)
	bge	LA5F2
	move.l	a6,a0
	adda	-22(a6),a0
	cmpi.b	#$2D,-20(a0)
	bne.s	LA598
	move.l	-4(a6),a0
	addq.l	#1,-4(a6)
	moveq	#45,d0
	move.b	d0,(a0)
LA584:
	move.l	a6,a0
	adda	-22(a6),a0
	cmpi.b	#$2D,-19(a0)
	bne.s	LA5EA
	addq	#1,-22(a6)
	bra.s	LA584
;
LA598:
	move.l	a6,a0
	adda	-22(a6),a0
	move.b	-20(a0),d0
	beq.s	LA5EA
	move	-22(a6),d0
	addq	#1,d0
	move	d0,-(sp)
	pea	L1A2D4
	move.l	-4(a6),-(sp)
	jsr	L16E2A
	adda	#$A,sp
	addq.l	#1,-4(a6)
	move.l	-4(a6),a0
	move.b	(a0),d0
	beq.s	LA5D0
	addq.l	#1,-4(a6)
LA5D0:
	move.l	a6,a0
	adda	-22(a6),a0
	cmpi.b	#$2D,-19(a0)
	beq.s	LA5EA
	move.l	-4(a6),a0
	addq.l	#1,-4(a6)
	moveq	#44,d0
	move.b	d0,(a0)
LA5EA:
	addq	#1,-22(a6)
	bra	LA560
;
LA5F2:
	move.l	-4(a6),a0
	cmpi.b	#$2C,-1(a0)
	bne.s	LA602
	subq.l	#1,-4(a6)
LA602:
	move.l	-4(a6),a0
	clr.b	(a0)
	move	14(a6),d0
	beq.s	LA644
	cmpi	#1,-24(a6)
	ble.s	LA61E
	pea	L1A2DD
	bra.s	LA630
;
LA61E:
	move	-26(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#5,d0
	addi.l	#$4691E,d0
	move.l	d0,-(sp)
LA630:
	pea	L1A2D7
	move.l	-4(a6),-(sp)
	jsr	L16E2A
	adda	#$C,sp
LA644:
	move	16(a6),d0
	beq.s	LA660
	move.l	8(a6),a0
	pea	2638(a0)
	pea	L1A2E6
	jsr	L63E0
	addq	#8,sp
LA660:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LA664:
	link	a6,#-8
	clr	-2(a6)
	move.l	8(a6),a0
	move.l	(a0),-8(a6)
LA674:
	move.l	-8(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5548
	addq	#2,sp
	move	d0,d0
	beq.s	LA690
	addq.l	#1,-8(a6)
	bra.s	LA674
;
LA690:
	move.l	-8(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-4(a6)
	cmpi	#$30,d0
	blt.s	LA6C8
	cmpi	#$39,-4(a6)
	bgt.s	LA6C8
	move	-2(a6),d0
	muls	#$A,d0
	move	d0,-2(a6)
	move	-4(a6),d0
	subi	#$30,d0
	add	d0,-2(a6)
	addq.l	#1,-8(a6)
	bra.s	LA690
;
LA6C8:
	move.l	8(a6),a0
	move.l	-8(a6),(a0)
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LA6D8:
	link	a6,#-10
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-4(a6)
	clr	-10(a6)
LA6EE:
	move.l	-4(a6),a0
	move.b	(a0),d0
	beq	LA798
	pea	-4(a6)
	jsr	LA664
	addq	#4,sp
	move	d0,-6(a6)
	move	d0,-8(a6)
	move.l	-4(a6),a0
	cmpi.b	#$2D,(a0)
	bne.s	LA72A
	addq.l	#1,-4(a6)
	pea	-4(a6)
	jsr	LA664
	addq	#4,sp
	move	d0,-8(a6)
LA72A:
	cmpi	#1,-6(a6)
	blt.s	LA798
	cmpi	#$10,-6(a6)
	bgt.s	LA798
	cmpi	#1,-8(a6)
	blt.s	LA798
	cmpi	#$10,-8(a6)
	bgt.s	LA798
	move	-8(a6),d0
	cmp	-6(a6),d0
	blt.s	LA798
LA754:
	move	-6(a6),d0
	cmp	-8(a6),d0
	bgt.s	LA77C
	move	-6(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	or	d0,-10(a6)
	addq	#1,-6(a6)
	bra.s	LA754
;
LA77C:
	move.l	-4(a6),a0
	cmpi.b	#$20,(a0)
	beq.s	LA790
	move.l	-4(a6),a0
	cmpi.b	#$2C,(a0)
	bne.s	LA798
LA790:
	addq.l	#1,-4(a6)
	bra	LA6EE
;
LA798:
	move	-10(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LA7A0:
	link	a6,#-6
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L2C378,-2(a6)
	move	L2D37A,-4(a6)
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	move.l	8(a6),a0
	move	44(a0),d0
	cmp	-2(a6),d0
	bls.s	LA7E6
	move.l	8(a6),a0
	clr	44(a0)
LA7E6:
	move.l	8(a6),a0
	move	44(a0),d0
	cmp	-4(a6),d0
	bls.s	LA7FE
	move.l	8(a6),a0
	move	44(a0),-4(a6)
LA7FE:
	move	-4(a6),d0
	cmp	-2(a6),d0
	bls.s	LA80C
	clr	d0
	bra.s	LA82A
;
LA80C:
	move	-2(a6),d0
	sub	-4(a6),d0
	move	d0,-6(a6)
	cmpi	#$400,-6(a6)
	bcc.s	LA826
	move	-6(a6),d0
	bra.s	LA82A
;
LA826:
	move	#$400,d0
LA82A:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LA82E:
	link	a6,#-2
	move.l	20(a6),a0
	clr	(a0)
	move	12(a6),d0
	beq.s	LA858
	move.l	16(a6),a0
	cmpi	#5,42(a0)
	beq.s	LA858
	move.l	16(a6),a0
	move	32(a0),d0
	cmp	14(a6),d0
	beq.s	LA85E
LA858:
	clr	d0
	bra	LA966
;
LA85E:
	move.l	16(a6),a1
	move.l	8(a6),a0
	move	46(a0),d0
	and	34(a1),d0
	beq.s	LA858
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	bge.s	LA888
	move.l	16(a6),a0
	cmpi	#3,42(a0)
	beq.s	LA858
LA888:
	move.l	16(a6),a0
	pea	46(a0)
	move.l	8(a6),a0
	pea	2(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	LA8A8
	moveq	#1,d0
	bra.s	LA8AA
;
LA8A8:
	clr	d0
LA8AA:
	move	d0,-2(a6)
	beq.s	LA8EA
	move.l	16(a6),-(sp)
	move	12(a6),-(sp)
	jsr	L9C08
	addq	#6,sp
	move.l	16(a6),a0
	moveq	#1,d0
	move	d0,44(a0)
	move.l	16(a6),a0
	move	14(a6),d0
	cmp	32(a0),d0
	bne.s	LA858
	move.l	16(a6),-(sp)
	move	12(a6),-(sp)
	jsr	L9C86
	addq	#6,sp
	bra.s	LA910
;
LA8EA:
	move.l	16(a6),a0
	pea	66(a0)
	move.l	8(a6),a0
	pea	2(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	LA90A
	moveq	#1,d0
	bra.s	LA90C
;
LA90A:
	clr	d0
LA90C:
	move	d0,-2(a6)
LA910:
	move.l	16(a6),a0
	cmpi	#4,42(a0)
	bne.s	LA922
	moveq	#1,d0
	move	d0,-2(a6)
LA922:
	move	-2(a6),d0
	bne.s	LA942
	move.l	16(a6),a0
	cmpi	#1,42(a0)
	bne.s	LA942
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	blt	LA858
LA942:
	move.l	16(a6),a0
	cmpi	#2,42(a0)
	bne.s	LA95C
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	blt	LA858
LA95C:
	move.l	20(a6),a0
	move	-2(a6),(a0)
	moveq	#1,d0
LA966:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LA96A:
	link	a6,#-244
	move.l	22(a6),a0
	clr.l	(a0)
	move	20(a6),d0
	beq.s	LA9DC
	move	12(a6),-(sp)
	pea	L1A2EA
	pea	-22(a6)
	jsr	L16E2A
	adda	#$A,sp
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	pea	-22(a6)
	jsr	L4B74
	addq	#4,sp
	move	d0,-224(a6)
	bge.s	LA9CE
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	pea	-22(a6)
	pea	L1A2F6
	bra	LB01C
;
LA9CE:
	clr	-236(a6)
	move.l	#task_Fwrite,-244(a6)
	bra.s	LA9F2
;
LA9DC:
	moveq	#1,d0
	move	d0,-236(a6)
	move.l	8(a6),a0
	move	(a0),-224(a6)
	move.l	#L6D80,-244(a6)
LA9F2:
	move.l	14(a6),a0
	move	116(a0),-230(a6)
	move.l	14(a6),d0
	addi.l	#$9C,d0
	move.l	d0,-4(a6)
	move.l	-4(a6),a0
	cmpi.b	#6,(a0)
	bne	LAAA0
	move.l	-4(a6),a0
	move.b	1(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	cmpi	#$20,d0
	bne.s	LAAA0
	move.l	-4(a6),a0
	move.b	2(a0),d0
	beq.s	LAAA0
	move.l	-4(a6),d0
	addq.l	#2,d0
	move.l	22(a6),a0
	move.l	d0,(a0)
	clr	-(sp)
	move.l	22(a6),a0
	move.l	(a0),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-238(a6)
	bge.s	LAA64
	move.l	22(a6),a0
	clr.l	(a0)
	bra.s	LAA90
;
LAA64:
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	-238(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	addi.l	#$3FF,d0
	asr.l	#8,d0
	asr.l	#2,d0
	move	d0,-240(a6)
	move	-238(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
LAA90:
	subq	#1,-230(a6)
LAA94:
	move.l	-4(a6),a0
	addq.l	#1,-4(a6)
	move.b	(a0),d0
	bne.s	LAA94
LAAA0:
	clr	-226(a6)
	move	18(a6),d0
	beq.s	LAAF0
	move.l	14(a6),a0
	pea	86(a0)
	move.l	14(a6),a0
	pea	46(a0)
	move.l	14(a6),a0
	move	44(a0),d0
	beq.s	LAAC8
	moveq	#42,d0
	bra.s	LAACA
;
LAAC8:
	moveq	#32,d0
LAACA:
	move	d0,-(sp)
	move.l	14(a6),a0
	pea	66(a0)
	move	12(a6),-(sp)
	pea	L1A30C
	pea	-222(a6)
	jsr	L16E2A
	adda	#$18,sp
	bra	LAF06
;
LAAF0:
	move.l	14(a6),a0
	move	40(a0),-(sp)
	move.l	14(a6),a0
	move	38(a0),-(sp)
	move.l	14(a6),a0
	move	42(a0),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18820,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	move	12(a6),-(sp)
	pea	L1A327
	pea	-222(a6)
	jsr	L16E2A
	adda	#$12,sp
	pea	-222(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	pea	-222(a6)
	move	-224(a6),-(sp)
	move.l	-244(a6),a0
	jsr	(a0)
	addq	#8,sp
	move	-236(a6),d0
	beq.s	LAB70
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	LAB70
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
LAB70:
	move.l	14(a6),a0
	pea	66(a0)
	pea	L1A341
	pea	-222(a6)
	jsr	L16E2A
	adda	#$C,sp
	pea	-222(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	pea	-222(a6)
	move	-224(a6),-(sp)
	move.l	-244(a6),a0
	jsr	(a0)
	addq	#8,sp
	move	-236(a6),d0
	beq.s	LABCE
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	LABCE
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
LABCE:
	move.l	14(a6),a0
	move	44(a0),d0
	beq.s	LABE0
	pea	L1A360
	bra.s	LABE6
;
LABE0:
	pea	L1A364
LABE6:
	move.l	14(a6),a0
	pea	46(a0)
	pea	L1A34F
	pea	-222(a6)
	jsr	L16E2A
	adda	#$10,sp
	pea	-222(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	pea	-222(a6)
	move	-224(a6),-(sp)
	move.l	-244(a6),a0
	jsr	(a0)
	addq	#8,sp
	move	-236(a6),d0
	beq.s	LAC44
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	LAC44
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
LAC44:
	move.l	14(a6),a0
	pea	86(a0)
	pea	L1A365
	pea	-222(a6)
	jsr	L16E2A
	adda	#$C,sp
	pea	-222(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	pea	-222(a6)
	move	-224(a6),-(sp)
	move.l	-244(a6),a0
	jsr	(a0)
	addq	#8,sp
	move	-236(a6),d0
	beq.s	LACA2
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	LACA2
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
LACA2:
	pea	L1A373
	pea	-222(a6)
	jsr	L16E2A
	addq	#8,sp
	pea	-222(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	pea	-222(a6)
	move	-224(a6),-(sp)
	move.l	-244(a6),a0
	jsr	(a0)
	addq	#8,sp
	move	-236(a6),d0
	beq.s	LACF6
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	LACF6
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
LACF6:
	clr	-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a1
	move.l	14(a6),a0
	move	34(a0),d0
	and	46(a1),d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	LA492
	adda	#$A,sp
	move.l	8(a6),a0
	pea	2638(a0)
	pea	L1A37F
	pea	-222(a6)
	jsr	L16E2A
	adda	#$C,sp
	pea	-222(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	pea	-222(a6)
	move	-224(a6),-(sp)
	move.l	-244(a6),a0
	jsr	(a0)
	addq	#8,sp
	move	-236(a6),d0
	beq.s	LAD7A
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	LAD7A
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
LAD7A:
	move.l	14(a6),a0
	move	36(a0),-228(a6)
	beq	LAE0E
	cmpi	#1,-228(a6)
	ble.s	LAD98
	pea	L1A39E
	bra.s	LAD9E
;
LAD98:
	pea	L1A3A2
LAD9E:
	move	-228(a6),-(sp)
	cmpi	#1,-228(a6)
	ble.s	LADB2
	pea	L1A397
	bra.s	LADB8
;
LADB2:
	pea	L1A39B
LADB8:
	pea	L1A383
	pea	-222(a6)
	jsr	L16E2A
	adda	#$12,sp
	pea	-222(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	pea	-222(a6)
	move	-224(a6),-(sp)
	move.l	-244(a6),a0
	jsr	(a0)
	addq	#8,sp
	move	-236(a6),d0
	beq.s	LAE0E
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	LAE0E
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
LAE0E:
	move	-226(a6),d0
	bne	LAEF4
	move	-230(a6),d0
	subq	#1,-230(a6)
	move	d0,d0
	ble	LAEF4
	move.l	-4(a6),-8(a6)
	moveq	#80,d0
	move	d0,-232(a6)
LAE30:
	move	-232(a6),d0
	subq	#1,-232(a6)
	move	d0,d0
	beq.s	LAE48
	move.l	-8(a6),a0
	addq.l	#1,-8(a6)
	move.b	(a0),d0
	bne.s	LAE30
LAE48:
	move	-232(a6),d0
	beq	LAEF4
	move.l	-4(a6),-(sp)
	pea	L1A3A4
	pea	-222(a6)
	jsr	L16E2A
	adda	#$C,sp
	pea	-222(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	pea	-222(a6)
	move	-224(a6),-(sp)
	move.l	-244(a6),a0
	jsr	(a0)
	addq	#8,sp
	move	-236(a6),d0
	beq.s	LAEAA
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	LAEAA
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
LAEAA:
	move.l	-8(a6),-4(a6)
	move	20(a6),d0
	bne	LAE0E
	move.l	8(a6),-(sp)
	jsr	L6F3A
	addq	#4,sp
	move	d0,-234(a6)
	cmpi	#3,d0
	beq.s	LAEE6
	cmpi	#$20,-234(a6)
	beq.s	LAEE6
	cmpi	#$F,-234(a6)
	beq.s	LAEE6
	cmpi	#$1B,-234(a6)
	bne.s	LAEEA
LAEE6:
	moveq	#1,d0
	bra.s	LAEEC
;
LAEEA:
	clr	d0
LAEEC:
	move	d0,-226(a6)
	bra	LAE0E
;
LAEF4:
	pea	L1A3A8
	pea	-222(a6)
	jsr	L16E2A
	addq	#8,sp
LAF06:
	pea	-222(a6)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-(sp)
	pea	-222(a6)
	move	-224(a6),-(sp)
	move.l	-244(a6),a0
	jsr	(a0)
	addq	#8,sp
	move	-236(a6),d0
	beq.s	LAF48
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	LAF48
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
LAF48:
	move	20(a6),d0
	bne.s	LAF70
	move.l	22(a6),a0
	move.l	(a0),d0
	beq.s	LAF70
	move	-240(a6),-(sp)
	move.l	22(a6),a0
	move.l	(a0),-(sp)
	pea	L1A3AA
	jsr	L63E0
	adda	#$A,sp
LAF70:
	move	20(a6),d0
	bne.s	LAFC8
	move	-226(a6),d0
	bne.s	LAFC8
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D46
	addq	#2,sp
	move	d0,d0
	bne.s	LAFC8
	move.l	8(a6),-(sp)
	jsr	L6F3A
	addq	#4,sp
	move	d0,-234(a6)
	cmpi	#3,d0
	beq.s	LAFBC
	cmpi	#$20,-234(a6)
	beq.s	LAFBC
	cmpi	#$F,-234(a6)
	beq.s	LAFBC
	cmpi	#$1B,-234(a6)
	bne.s	LAFC0
LAFBC:
	moveq	#1,d0
	bra.s	LAFC2
;
LAFC0:
	clr	d0
LAFC2:
	move	d0,-226(a6)
	bra.s	LAF70
;
LAFC8:
	move	-226(a6),d0
	beq.s	LAFF2
	move.l	8(a6),-(sp)
	jsr	L707E
	addq	#4,sp
	cmpi	#$1B,-234(a6)
	beq.s	LAFEA
	cmpi	#3,-234(a6)
	bne.s	LAFEE
LAFEA:
	moveq	#-1,d0
	bra.s	LB026
;
LAFEE:
	moveq	#1,d0
	bra.s	LB026
;
LAFF2:
	move	20(a6),d0
	beq.s	LB024
	move	-224(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	pea	-22(a6)
	pea	L1A3DB
LB01C:
	jsr	L63E0
	addq	#8,sp
LB024:
	clr	d0
LB026:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LB02A:
	link	a6,#-88
	move.l	a3,-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-4(a6)
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L2C378,-70(a6)
	move	L2D37A,-72(a6)
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	move.l	8(a6),a0
	cmpi	#3,32(a0)
	blt.s	LB076
	moveq	#1,d0
	bra.s	LB078
;
LB076:
	clr	d0
LB078:
	move	d0,-54(a6)
	move	-70(a6),d0
	bne.s	LB08C
	pea	L1A3F6
	bra	LBC18
;
LB08C:
	move	16(a6),d0
	bne	LB440
	move	12(a6),d0
	beq.s	LB0B8
	move.l	8(a6),a0
	move	44(a0),d0
	addq	#1,d0
	move	d0,-74(a6)
	cmp	-70(a6),d0
	bls.s	LB0B8
	pea	L1A418
	bra	LBC18
;
LB0B8:
	move	12(a6),d0
	bne.s	LB134
	move.l	8(a6),a0
	move	44(a0),-74(a6)
	beq.s	LB0DE
	move	-74(a6),-(sp)
	pea	L1A436
	jsr	L63E0
	addq	#6,sp
	bra.s	LB0E4
;
LB0DE:
	move	-72(a6),-74(a6)
LB0E4:
	move	-74(a6),-(sp)
	move	-70(a6),-(sp)
	move	-72(a6),-(sp)
	pea	L1A44D
	jsr	L63E0
	adda	#$A,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-68(a6)
	cmpi	#$FFFF,d0
	beq	LBC20
	move	-68(a6),d0
	beq.s	LB134
	move	-68(a6),-74(a6)
LB134:
	move	-74(a6),d0
	cmp	-72(a6),d0
	bcc.s	LB144
	move	-72(a6),-74(a6)
LB144:
	pea	L1A488
	move.l	8(a6),-(sp)
	jsr	L6BA4
	addq	#8,sp
	move	d0,-76(a6)
	beq	LBC20
	pea	L1A48D
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	clr	-(sp)
	move	-76(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA492
	adda	#$A,sp
	moveq	#1,d0
	move	d0,-(sp)
	pea	L1A4A7
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-44(a6)
	move	d0,-48(a6)
	cmpi	#$FFFF,d0
	beq	LBC20
	move	-44(a6),d0
	bne.s	LB1D6
	moveq	#1,d0
	move	d0,-(sp)
	pea	L1A4BF
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-48(a6)
	cmpi	#$FFFF,d0
	beq	LBC20
LB1D6:
	clr	-(sp)
	pea	L1A4DF
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-46(a6)
	cmpi	#$FFFF,d0
	beq	LBC20
	pea	L1A500
	jsr	L63E0
	addq	#4,sp
LB206:
	clr	-82(a6)
	clr	d0
	move	d0,-84(a6)
	move	d0,-68(a6)
LB214:
	move.l	8(a6),-(sp)
	jsr	L6F3A
	addq	#4,sp
	move	d0,-66(a6)
	cmpi	#3,d0
	beq	LBC20
	cmpi	#$1B,-66(a6)
	beq	LBC20
	move.l	8(a6),-(sp)
	jsr	L5C60
	addq	#4,sp
	addq	#1,-68(a6)
	move	-68(a6),d0
	cmpi	#$F,d0
	ble.s	LB262
	pea	L1A538
	jsr	L63E0
	addq	#4,sp
	clr	-68(a6)
LB262:
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L2C378,-70(a6)
	move	L2D37A,-72(a6)
	move	-74(a6),d0
	cmp	-72(a6),d0
	bcc.s	LB290
	move	-72(a6),-74(a6)
LB290:
	move	-74(a6),d0
	cmp	-70(a6),d0
	bls.s	LB2B2
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	pea	L1A53D
	bra	LBC18
;
LB2B2:
	move	-74(a6),-(sp)
	pea	L1A55C
	pea	-34(a6)
	jsr	L16E2A
	adda	#$A,sp
	move.l	8(a6),a0
	lea	-34(a6),a1
	move.l	a1,2608(a0)
	moveq	#1,d0
	move	d0,-(sp)
	move	-74(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L9E64
	addq	#8,sp
	move	d0,-80(a6)
	pea	-50(a6)
	move.l	-4(a6),-(sp)
	move	-74(a6),-(sp)
	move	-80(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA82E
	adda	#$10,sp
	move	d0,-52(a6)
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	move.l	8(a6),a0
	move	-74(a6),d0
	cmp	44(a0),d0
	bls.s	LB336
	move.l	8(a6),a0
	move	-74(a6),44(a0)
LB336:
	move	-52(a6),d0
	beq.s	LB356
	move	-50(a6),d0
	bne.s	LB348
	move	-46(a6),d0
	bne.s	LB356
LB348:
	move.l	-4(a6),a0
	move	34(a0),d0
	and	-76(a6),d0
	bne.s	LB35E
LB356:
	addq	#1,-74(a6)
	bra	LB214
;
LB35E:
	clr	-68(a6)
	move	14(a6),-56(a6)
	moveq	#1,d0
	move	d0,-64(a6)
LB36E:
	move	-64(a6),d0
	beq.s	LB3C6
	clr	-64(a6)
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	move	-56(a6),-(sp)
	move	-74(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L9E64
	addq	#8,sp
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	move.l	-4(a6),a0
	move	-74(a6),d0
	cmp	32(a0),d0
	beq	LB4B8
	pea	L1A56B
	jsr	L63E0
	addq	#4,sp
LB3C6:
	move.l	8(a6),a0
	cmpi	#3,32(a0)
	ble.s	LB356
	move.l	-4(a6),a0
	cmpi	#3,42(a0)
	bne	LB356
	moveq	#1,d0
	move	d0,-(sp)
	pea	L1A6E0
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-66(a6)
	cmpi	#$FFFF,-66(a6)
	beq	LBC20
	cmpi	#1,-66(a6)
	bne	LB356
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	moveq	#1,d0
	move	d0,-(sp)
	move	-74(a6),-(sp)
	jsr	L9F52
	addq	#4,sp
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	bra	LB356
;
LB440:
	moveq	#1,d0
	move	d0,-44(a6)
	move	d0,-48(a6)
	clr	-46(a6)
	move.l	8(a6),a0
	move	46(a0),-76(a6)
	move	-70(a6),-(sp)
	move	-72(a6),-(sp)
	pea	L1A503
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-74(a6)
	move	-74(a6),d0
	cmp	-72(a6),d0
	bcs	LBC20
	move	-74(a6),d0
	cmp	-70(a6),d0
	bls	LB206
	bra	LBC20
;
LB4AA:
	cmpi	#$FFFF,-66(a6)
	bne	LB9F6
	bra	LBC20
;
LB4B8:
	pea	-38(a6)
	clr	-(sp)
	move	-56(a6),-(sp)
	move.l	-4(a6),-(sp)
	move	-74(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA96A
	adda	#$12,sp
	move	d0,-58(a6)
	blt	LBC20
	move	-58(a6),d0
	bne	LB36E
	clr	-82(a6)
	move.l	-4(a6),a0
	cmpi.b	#$23,86(a0)
	bne.s	LB50C
	move.l	-4(a6),a0
	pea	87(a0)
	jsr	L12092
	addq	#4,sp
	move	d0,-82(a6)
LB50C:
	move	-44(a6),d0
	bne.s	LB51E
	move	-48(a6),d0
	beq.s	LB522
	move	-50(a6),d0
	beq.s	LB522
LB51E:
	moveq	#1,d0
	bra.s	LB524
;
LB522:
	clr	d0
LB524:
	move	d0,-62(a6)
LB528:
	move	-62(a6),d0
	beq	LB36E
	clr	-62(a6)
	move	-82(a6),d0
	beq.s	LB542
	pea	L1A5AF
	bra.s	LB548
;
LB542:
	pea	L1A5B7
LB548:
	move	-84(a6),d0
	beq.s	LB556
	pea	L1A5AB
	bra.s	LB55C
;
LB556:
	pea	L1A5AE
LB55C:
	pea	L1A597
	jsr	L63E0
	adda	#$C,sp
	move.l	8(a6),a0
	move	32(a0),d0
	ble.s	LB584
	pea	L1A5B8
	jsr	L63E0
	addq	#4,sp
LB584:
	pea	L1A5C1
	jsr	L63E0
	addq	#4,sp
	move	-56(a6),d0
	beq.s	LB5A6
	pea	L1A5CA
	jsr	L63E0
	addq	#4,sp
LB5A6:
	move	-54(a6),d0
	bne.s	LB5BE
	move	-50(a6),d0
	beq.s	LB5CC
	move.l	-4(a6),a0
	cmpi	#4,42(a0)
	beq.s	LB5CC
LB5BE:
	pea	L1A5D2
	jsr	L63E0
	addq	#4,sp
LB5CC:
	pea	L1A5DC
	jsr	L63E0
	addq	#4,sp
	move	-54(a6),d0
	beq.s	LB5EE
	pea	L1A5E4
	jsr	L63E0
	addq	#4,sp
LB5EE:
	move	-54(a6),d0
	beq.s	LB626
	move.l	-4(a6),a0
	cmpi	#3,42(a0)
	bgt.s	LB626
	move.l	-4(a6),a0
	move	42(a0),d0
	beq.s	LB612
	pea	L1A601
	bra.s	LB618
;
LB612:
	pea	L1A607
LB618:
	pea	L1A5F7
	jsr	L63E0
	addq	#8,sp
LB626:
	move.l	-38(a6),d0
	beq.s	LB63A
	pea	L1A610
	jsr	L63E0
	addq	#4,sp
LB63A:
	clr	-60(a6)
LB63E:
	move	-60(a6),d0
	bne	LB528
	pea	L1A618
	move.l	8(a6),-(sp)
	jsr	L6A98
	addq	#8,sp
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move	d0,-58(a6)
	moveq	#1,d0
	move	d0,-60(a6)
	move	-58(a6),d0
	move.l	#L1839C,a0
	move	#$11,d1
	bra.s	LB67E
;
LB67C:
	addq	#4,a0
LB67E:
	cmp	(a0)+,d0
	dbeq	d1,LB67C
	move.l	(a0),a0
	jmp	(a0)
;
LB688:
	bra.s	LB63E
;
LB68A:
	move.l	-38(a6),d0
	bne.s	LB6A2
LB690:
	moveq	#7,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L662E
	addq	#6,sp
	bra.s	LB63A
;
LB6A2:
	clr	-(sp)
	move.l	-38(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L8290
	adda	#$A,sp
	pea	L1A62B
LB6BC:
	jsr	L63E0
	addq	#4,sp
LB6C4:
	moveq	#1,d0
	move	d0,-64(a6)
	bra	LB63E
;
LB6CE:
	cmpi	#$58,-58(a6)
	beq.s	LB6E4
	pea	L1A62D
	jsr	L63E0
	addq	#4,sp
LB6E4:
	move	-84(a6),d0
	beq.s	LB6F6
	move	-84(a6),d0
	addi	#$FFFF,d0
	move	d0,-74(a6)
LB6F6:
	move	-84(a6),d0
	bne.s	LB704
	move	16(a6),d0
	bne	LBC20
LB704:
	clr	-82(a6)
	clr	-84(a6)
	bra	LB63E
;
LB710:
	pea	L1A632
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-82(a6)
	cmpi	#$FFFF,d0
	beq.s	LB74A
	move	-82(a6),d0
	bne.s	LB754
LB74A:
	moveq	#1,d0
	move	d0,-62(a6)
	bra	LB63E
;
LB754:
	move	-82(a6),d0
	beq	LB690
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	moveq	#1,d0
	move	d0,-(sp)
	move	-82(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L9E64
	addq	#8,sp
	move	d0,-80(a6)
	pea	-50(a6)
	move.l	-4(a6),-(sp)
	move	-82(a6),-(sp)
	move	-80(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA82E
	adda	#$10,sp
	move	d0,-50(a6)
	move	-50(a6),d0
	bne.s	LB7E4
	moveq	#1,d0
	move	d0,-(sp)
	move	-74(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L9E64
	addq	#8,sp
	move	d0,-80(a6)
	pea	-50(a6)
	move.l	-4(a6),-(sp)
	move	-74(a6),-(sp)
	move	-80(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA82E
	adda	#$10,sp
	move	d0,-52(a6)
LB7E4:
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-52(a6),d0
	beq	LB63E
	move	-50(a6),d0
	bne.s	LB828
	cmpi	#80,-58(a6)
	bne.s	LB810
	pea	L1A660
	bra.s	LB816
;
LB810:
	pea	L1A66A
LB816:
	pea	L1A646
	jsr	L63E0
	addq	#8,sp
	bra	LB74A
;
LB828:
	cmpi	#80,-58(a6)
	bne.s	LB83E
	pea	L1A66B
	jsr	L63E0
	addq	#4,sp
LB83E:
	move	-84(a6),d0
	bne.s	LB84A
	move	-74(a6),-84(a6)
LB84A:
	move	-82(a6),d0
	addi	#$FFFF,d0
	move	d0,-74(a6)
	bra	LB63E
;
LB85A:
	move.l	8(a6),a0
	move	32(a0),d0
	ble	LB690
	pea	L1A674
	jsr	L63E0
	addq	#4,sp
	move.l	-4(a6),a0
	pea	86(a0)
	jsr	L5D2E
	addq	#4,sp
	move.l	d0,-(sp)
	move	-74(a6),-(sp)
	pea	L1A67A
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L16E2A
	adda	#$E,sp
	move.l	8(a6),a0
	clr.b	2667(a0)
	move.l	-4(a6),a0
	move	42(a0),d0
	beq.s	LB8C6
	move.l	-4(a6),a0
	cmpi	#4,42(a0)
	beq.s	LB8C6
	moveq	#1,d0
	move	d0,-(sp)
	bra.s	LB8C8
;
LB8C6:
	clr	-(sp)
LB8C8:
	move.l	-4(a6),a0
	move	34(a0),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	-4(a6),a0
	pea	66(a0)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	LBC28
	adda	#$12,sp
	move	d0,d0
	beq	LB63E
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	move.l	-4(a6),-(sp)
	move	-80(a6),-(sp)
	jsr	L9C08
	addq	#6,sp
	move.l	-4(a6),a0
	addq	#1,36(a0)
	move.l	-4(a6),a0
	move	-74(a6),d0
	cmp	32(a0),d0
	bne	LBB22
	move.l	-4(a6),-(sp)
	move	-80(a6),-(sp)
	jsr	L9C86
	addq	#6,sp
	clr	-(sp)
	move	-74(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L9E64
	addq	#8,sp
	move	d0,d0
	beq.s	LB958
	moveq	#1,d0
	bra.s	LB95A
;
LB958:
	clr	d0
LB95A:
	move	d0,-62(a6)
LB95E:
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	bra	LB63E
;
LB970:
	pea	L1A681
	bra	LB6BC
;
LB97A:
	move	-56(a6),d0
	beq	LB690
	pea	L1A687
	jsr	L63E0
	addq	#4,sp
	clr	-56(a6)
	bra	LB6C4
;
LB998:
	move	-54(a6),d0
	bne.s	LB9B4
	move	-50(a6),d0
	beq	LB690
	move.l	-4(a6),a0
	cmpi	#4,42(a0)
	beq	LB690
LB9B4:
	pea	L1A68C
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	blt.s	LB9F6
	moveq	#1,d0
	move	d0,-(sp)
	pea	L1A693
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-66(a6)
	move	-66(a6),d0
	bne	LB4AA
	bra	LB63E
;
LB9F6:
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	move.l	-4(a6),-(sp)
	move	-80(a6),-(sp)
	jsr	L9C08
	addq	#6,sp
	move.l	-4(a6),a0
	move	-74(a6),d0
	cmp	32(a0),d0
	bne	LB95E
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	blt.s	LBA4E
	move.l	-4(a6),a0
	moveq	#5,d0
	move	d0,42(a0)
	moveq	#1,d0
	move	d0,-(sp)
	move	-74(a6),-(sp)
	jsr	L9F52
	addq	#4,sp
	bra	LB95E
;
LBA4E:
	move.l	-4(a6),a0
	moveq	#3,d0
	move	d0,42(a0)
LBA58:
	move.l	-4(a6),-(sp)
	move	-80(a6),-(sp)
	jsr	L9C86
	addq	#6,sp
	bra	LB95E
;
LBA6C:
	move	-54(a6),d0
	beq	LBB2A
	moveq	#1,d0
	move	d0,-62(a6)
	move.l	8(a6),a0
	move	2970(a0),d0
	addq	#1,d0
	move	d0,-(sp)
	pea	L1A6A2
	jsr	L63E0
	addq	#6,sp
	clr	-(sp)
	moveq	#50,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LB63E
	move.l	8(a6),a3
	move.l	8(a6),-(sp)
	jsr	LA6D8
	addq	#4,sp
	and	46(a3),d0
	move	d0,-78(a6)
	bne.s	LBAEA
	move.l	8(a6),a1
	move	2970(a1),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),-78(a6)
LBAEA:
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	move.l	-4(a6),-(sp)
	move	-80(a6),-(sp)
	jsr	L9C08
	addq	#6,sp
	move.l	-4(a6),a0
	move	-78(a6),34(a0)
	move.l	-4(a6),a0
	move	-74(a6),d0
	cmp	32(a0),d0
	beq	LBA58
LBB22:
	clr	-62(a6)
	bra	LB95E
;
LBB2A:
	clr	-60(a6)
	moveq	#7,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L662E
	addq	#6,sp
	bra	LB63E
;
LBB42:
	move	-54(a6),d0
	beq.s	LBB2A
	move.l	-4(a6),a0
	cmpi	#3,42(a0)
	bgt.s	LBB2A
	moveq	#1,d0
	move	d0,-62(a6)
	move.l	-4(a6),a0
	move	42(a0),d0
	beq.s	LBB6C
	pea	L1A6C5
	bra.s	LBB72
;
LBB6C:
	pea	L1A6CA
LBB72:
	pea	L1A6BD
	jsr	L63E0
	addq	#8,sp
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	move.l	-4(a6),-(sp)
	move	-80(a6),-(sp)
	jsr	L9C08
	addq	#6,sp
	move.l	-4(a6),a0
	move	42(a0),d0
	beq.s	LBBAC
	clr	d0
	bra.s	LBBAE
;
LBBAC:
	moveq	#1,d0
LBBAE:
	move.l	-4(a6),a0
	move	d0,42(a0)
	move.l	-4(a6),a0
	move	-74(a6),d0
	cmp	32(a0),d0
	bne	LBB22
	bra	LBA58
;
LBBCA:
	move	-54(a6),d0
	beq	LBB2A
	pea	L1A6D2
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-62(a6)
	pea	-42(a6)
	moveq	#1,d0
	move	d0,-(sp)
	clr	-(sp)
	move.l	-4(a6),-(sp)
	move	-74(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA96A
	adda	#$12,sp
	bra	LB63E
;
LBC0A:
	move	-74(a6),d0
	beq	LB63E
	pea	L1A6D9
LBC18:
	jsr	L63E0
	addq	#4,sp
LBC20:
	clr	d0
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LBC28:
	link	a6,#-520
	clr	-(sp)
	move	#$200,-(sp)
	pea	-512(a6)
	jsr	L10C
	addq	#8,sp
	move	12(a6),d0
	bne.s	LBC52
	move.l	8(a6),a0
	move.l	#L1A70B,2608(a0)
	bra.s	LBC74
;
LBC52:
	cmpi	#1,12(a6)
	bne.s	LBC68
	move.l	8(a6),a0
	move.l	#L1A716,2608(a0)
	bra.s	LBC74
;
LBC68:
	move.l	8(a6),a0
	move.l	#L1A721,2608(a0)
LBC74:
	move.l	8(a6),a0
	pea	2(a0)
	pea	-446(a6)
	jsr	L11FEC
	addq	#8,sp
	pea	L1A734
	pea	-466(a6)
	jsr	L11FEC
	addq	#8,sp
	pea	L1A738
	pea	-426(a6)
	jsr	L11FEC
	addq	#8,sp
	clr	-470(a6)
	move.l	8(a6),a1
	move	2970(a1),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),-478(a6)
	cmpi	#1,12(a6)
	bne.s	LBD1A
	move.l	14(a6),-(sp)
	pea	-466(a6)
	jsr	L11FEC
	addq	#8,sp
	move.l	18(a6),-(sp)
	pea	-426(a6)
	jsr	L11FEC
	addq	#8,sp
	move.l	8(a6),a0
	move	46(a0),d0
	and	22(a6),d0
	move	d0,-478(a6)
	bne.s	LBD1A
	move.l	8(a6),a1
	move	2970(a1),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),-478(a6)
LBD1A:
	cmpi	#1,12(a6)
	ble.s	LBD3A
	moveq	#2,d0
	move	d0,-470(a6)
	pea	L1A73D
	pea	-466(a6)
	jsr	L11FEC
	addq	#8,sp
LBD3A:
	move	12(a6),d0
	beq.s	LBD48
	cmpi	#1,12(a6)
	ble.s	LBD4C
LBD48:
	clr	d0
	bra.s	LBD4E
;
LBD4C:
	moveq	#1,d0
LBD4E:
	move	d0,-516(a6)
LBD52:
	pea	L1A743
	jsr	L63E0
	addq	#4,sp
	move	-516(a6),d0
	bne	LBFE8
	move.l	8(a6),a0
	pea	2(a0)
	pea	L1A745
	jsr	L63E0
	addq	#8,sp
	cmpi	#1,12(a6)
	ble.s	LBD92
	pea	-466(a6)
	pea	L1A753
	bra.s	LBDFA
;
LBD92:
	pea	L1A761
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#20,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	bne.s	LBDC8
LBDC2:
	clr	d0
	bra	LC1B6
;
LBDC8:
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L11FCA
	addq	#4,sp
	move	d0,d0
	beq.s	LBDF0
	move.l	8(a6),a0
	pea	2638(a0)
	pea	-466(a6)
	jsr	L11FEC
	bra.s	LBE00
;
LBDF0:
	pea	-466(a6)
	pea	L1A76D
LBDFA:
	jsr	L63E0
LBE00:
	addq	#8,sp
	pea	L1A77A
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#30,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq.s	LBDC2
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L11FCA
	addq	#4,sp
	move	d0,d0
	beq.s	LBE5A
	move.l	8(a6),a0
	pea	2638(a0)
	pea	-426(a6)
	jsr	L11FEC
	bra.s	LBE6A
;
LBE5A:
	pea	-426(a6)
	pea	L1A786
	jsr	L63E0
LBE6A:
	addq	#8,sp
	cmpi	#1,12(a6)
	ble.s	LBE9E
	pea	L1A793
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	clr	-(sp)
	move	-478(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA492
	adda	#$A,sp
	bra	LBFE8
;
LBE9E:
	move.l	8(a6),a0
	move	2970(a0),d0
	addq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	cmpi	#9,2970(a0)
	bge.s	LBEBE
	pea	L1A7AD
	bra.s	LBEC4
;
LBEBE:
	pea	L1A7AF
LBEC4:
	pea	L1A79F
	jsr	L63E0
	adda	#$A,sp
	clr	-(sp)
	moveq	#50,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-518(a6)
	cmpi	#$FFFF,d0
	beq	LBDC2
	move.l	8(a6),a0
	cmpi.b	#$3F,2638(a0)
	bne.s	LBF16
	move.l	8(a6),-(sp)
	jsr	L4EB2
LBF12:
	addq	#4,sp
	bra.s	LBE9E
;
LBF16:
	move.l	8(a6),a0
	cmpi	#3,32(a0)
	bge.s	LBFA0
	move	-518(a6),d0
	bne.s	LBF36
	move.l	8(a6),a0
	move	2970(a0),d0
	addq	#1,d0
	move	d0,-518(a6)
LBF36:
	cmpi	#1,-518(a6)
	blt.s	LBF46
	cmpi	#$10,-518(a6)
	ble.s	LBF54
LBF46:
	pea	L1A7B0
LBF4C:
	jsr	L63E0
	bra.s	LBF12
;
LBF54:
	move	-518(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a1
	adda.l	d0,a1
	move.l	8(a6),a0
	move	46(a0),d0
	and	(a1),d0
	bne.s	LBF88
	move	-518(a6),-(sp)
	pea	you_dont_have_access_to_sig_x_1_s
	jsr	L63E0
	addq	#6,sp
	bra	LBE9E
;
LBF88:
	move	-518(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),-478(a6)
	bra.s	LBFE8
;
LBFA0:
	move.l	8(a6),-(sp)
	jsr	LA6D8
	addq	#4,sp
	move	d0,-478(a6)
	bne.s	LBFCC
	move.l	8(a6),a1
	move	2970(a1),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),-478(a6)
	bra.s	LBFD8
;
LBFCC:
	move.l	8(a6),a0
	move	46(a0),d0
	and	d0,-478(a6)
LBFD8:
	move	-478(a6),d0
	bne.s	LBFE8
	pea	L1A7DF
	bra	LBF4C
;
LBFE8:
	clr	-516(a6)
	cmpi	#1,12(a6)
	bgt.s	LBFF8
	clr	-470(a6)
LBFF8:
	moveq	#1,d0
	move	d0,-(sp)
	pea	-446(a6)
	jsr	L5BB4
	addq	#6,sp
	moveq	#1,d0
	move	d0,-(sp)
	pea	-466(a6)
	jsr	L5BB4
	addq	#6,sp
	pea	L1A80C
	pea	-466(a6)
	jsr	L12034
	addq	#8,sp
	move	d0,d0
	bne.s	LC052
	pea	L1A816
	pea	-466(a6)
	jsr	L11FEC
	addq	#8,sp
	move.l	8(a6),a0
	cmpi	#3,32(a0)
	blt.s	LC052
	moveq	#4,d0
	move	d0,-470(a6)
LC052:
	pea	-446(a6)
	pea	L1A81A
	jsr	L63E0
	addq	#8,sp
	pea	-466(a6)
	pea	L1A829
	jsr	L63E0
	addq	#8,sp
	pea	-426(a6)
	pea	L1A837
	jsr	L63E0
	addq	#8,sp
	pea	L1A845
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	move	-478(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA492
	adda	#$A,sp
	cmpi	#4,-470(a6)
	bne.s	LC0C8
	pea	L1A851
LC0BE:
	jsr	L63E0
	addq	#4,sp
	bra.s	LC116
;
LC0C8:
	cmpi	#1,12(a6)
	ble.s	LC0D8
	pea	L1A874
	bra.s	LC0BE
;
LC0D8:
	move	24(a6),d0
	beq.s	LC0E4
	moveq	#1,d0
	move	d0,-(sp)
	bra.s	LC0E6
;
LC0E4:
	clr	-(sp)
LC0E6:
	pea	L1A893
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-514(a6)
	cmpi	#$FFFF,d0
	beq	LBDC2
	move	-514(a6),d0
	beq.s	LC110
	moveq	#1,d0
	bra.s	LC112
;
LC110:
	clr	d0
LC112:
	move	d0,-470(a6)
LC116:
	moveq	#1,d0
	move	d0,-(sp)
	pea	L1A8A4
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-514(a6)
	cmpi	#$FFFF,d0
	beq	LBDC2
	move	-514(a6),d0
	beq	LBD52
	pea	L1A8B7
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	32(a0),d0
	beq.s	LC162
	moveq	#99,d0
	bra.s	LC164
;
LC162:
	moveq	#10,d0
LC164:
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L14DAE
	addq	#8,sp
	move	d0,-520(a6)
	bgt.s	LC18A
	pea	L1A8B9
	jsr	L63E0
	addq	#4,sp
	bra	LBDC2
;
LC18A:
	move.l	8(a6),a0
	move	32(a0),d0
	bne.s	LC1A0
	move	-470(a6),d0
	bne.s	LC1A0
	moveq	#1,d0
	move	d0,-470(a6)
LC1A0:
	move	-520(a6),-(sp)
	pea	-512(a6)
	move.l	8(a6),-(sp)
	jsr	LA114
	adda	#$A,sp
LC1B6:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LC1BA:
	link	a6,#0
	move.l	8(a6),a0
	move.l	#L1A8D8,2608(a0)
	clr	-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	LB02A
	adda	#$A,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LC1E4:
	link	a6,#0
	move.l	8(a6),a0
	move.l	#L1A8E2,2608(a0)
	clr	-(sp)
	clr	-(sp)
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	LB02A
	adda	#$A,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LC20C:
	link	a6,#0
	move.l	8(a6),a0
	move.l	#L1A8EC,2608(a0)
	moveq	#1,d0
	move	d0,-(sp)
	clr	-(sp)
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	LB02A
	adda	#$A,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LC236:
	link	a6,#0
	move.l	8(a6),a0
	move.l	#L1A8FC,2608(a0)
	clr	-(sp)
	clr	-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	LB02A
	adda	#$A,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LC260:
	link	a6,#0
	move.l	8(a6),a0
	move.l	#L1A905,2608(a0)
	move.l	8(a6),a0
	move	32(a0),d0
	ble.s	LC2B0
	clr	-(sp)
	move.l	8(a6),a0
	move	2970(a0),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	pea	L1A913
	pea	L1A910
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	LBC28
	adda	#$12,sp
	bra.s	LC2BE
;
LC2B0:
	pea	L1A91B
	jsr	L63E0
	addq	#4,sp
LC2BE:
	clr	d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;LC2C4:
sys_mailstat_func:
	link	a6,#-10
	pea	L1A936
	jsr	L63E0
	addq	#4,sp
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-4(a6)
	clr	-2(a6)
LC2EC:
	move	-2(a6),d0
	cmp	L1A242,d0
	bge.s	LC32E
	move	-2(a6),d0
	andi	#$F,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a1
	adda.l	d0,a1
	move	-2(a6),d0
	asr.w	#4,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2CB7A,a0
	adda.l	d0,a0
	move	(a0),d0
	and	(a1),d0
	bne.s	LC328
	addq	#1,-4(a6)
LC328:
	addq	#1,-2(a6)
	bra.s	LC2EC
;
LC32E:
	clr	-6(a6)
	clr	-2(a6)
LC336:
	cmpi	#$400,-2(a6)
	bge.s	LC35C
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2C37A,a0
	adda.l	d0,a0
	move	(a0),d0
	beq.s	LC356
	addq	#1,-6(a6)
LC356:
	addq	#1,-2(a6)
	bra.s	LC336
;
LC35C:
	move	L2C378,-8(a6)
	move	L2D37A,-10(a6)
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	pea	L1A94E
	jsr	L63E0
	addq	#4,sp
	move	-10(a6),-(sp)
	pea	L1A959
	jsr	L63E0
	addq	#6,sp
	move	-8(a6),-(sp)
	pea	L1A970
	jsr	L63E0
	addq	#6,sp
	move	-6(a6),-(sp)
	move	L1A242,-(sp)
	move	-4(a6),-(sp)
	pea	L1A987
	jsr	L63E0
	adda	#$A,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LC3CE:
	link	a6,#-112
	move.l	8(a6),a0
	move.l	#L1A9B4,2608(a0)
	move.l	8(a6),a0
	move.l	2894(a0),-4(a6)
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L2C378,-110(a6)
	move	L2D37A,-112(a6)
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	move.l	8(a6),a0
	move	44(a0),d0
	addq	#1,d0
	move	d0,-108(a6)
	cmp	-110(a6),d0
	bls.s	LC43A
	pea	L1A9BF
	jsr	L63E0
	addq	#4,sp
	bra	LC776
;
LC43A:
	move	-108(a6),d0
	cmp	-112(a6),d0
	bcc.s	LC44A
	move	-112(a6),-108(a6)
LC44A:
	clr	-8(a6)
LC44E:
	cmpi	#$10,-8(a6)
	bge.s	LC48E
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a2
	adda.l	a6,a2
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a1
	adda.l	a6,a1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	clr	-106(a0)
	clr	d0
	move	d0,-74(a1)
	move	d0,-42(a2)
	addq	#1,-8(a6)
	bra.s	LC44E
;
LC48E:
	clr	-6(a6)
	pea	L1A9DD
	jsr	L63E0
	addq	#4,sp
LC4A0:
	addq	#1,-6(a6)
	move	-6(a6),d0
	cmpi	#$F,d0
	ble.s	LC4C0
	pea	L1A9F2
	jsr	L63E0
	addq	#4,sp
	clr	-6(a6)
LC4C0:
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L2C378,-110(a6)
	move	L2D37A,-112(a6)
	move	-108(a6),d0
	cmp	-112(a6),d0
	bcc.s	LC4EE
	move	-112(a6),-108(a6)
LC4EE:
	move	-108(a6),d0
	cmp	-110(a6),d0
	bls	LC6A0
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	pea	L1A9F7
	jsr	L63E0
	addq	#4,sp
	clr	-8(a6)
LC51A:
	move	-8(a6),d0
	cmp	L2C0BA,d0
	bge.s	LC542
	move	-8(a6),d0
	addq	#1,d0
	move	d0,-(sp)
	pea	L1AA02
	jsr	L63E0
	addq	#6,sp
	addq	#1,-8(a6)
	bra.s	LC51A
;
LC542:
	pea	L1AA06
	jsr	L63E0
	addq	#4,sp
	clr	-8(a6)
LC554:
	move	-8(a6),d0
	cmp	L2C0BA,d0
	bgt.s	LC574
	pea	L1AA19
	jsr	L63E0
	addq	#4,sp
	addq	#1,-8(a6)
	bra.s	LC554
;
LC574:
	pea	L1AA1E
	jsr	L63E0
	addq	#4,sp
	clr	-8(a6)
	clr	-10(a6)
LC58A:
	move	-8(a6),d0
	cmp	L2C0BA,d0
	bge.s	LC5CE
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-42(a0),-(sp)
	pea	L1AA29
	jsr	L63E0
	addq	#6,sp
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-42(a0),d0
	add	d0,-10(a6)
	addq	#1,-8(a6)
	bra.s	LC58A
;
LC5CE:
	move	-10(a6),-(sp)
	pea	L1AA2D
	jsr	L63E0
	addq	#6,sp
	clr	-8(a6)
	clr	-10(a6)
LC5E8:
	move	-8(a6),d0
	cmp	L2C0BA,d0
	bge.s	LC62C
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-74(a0),-(sp)
	pea	L1AA3B
	jsr	L63E0
	addq	#6,sp
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-74(a0),d0
	add	d0,-10(a6)
	addq	#1,-8(a6)
	bra.s	LC5E8
;
LC62C:
	move	-10(a6),-(sp)
	pea	L1AA3F
	jsr	L63E0
	addq	#6,sp
	clr	-8(a6)
	clr	-10(a6)
LC646:
	move	-8(a6),d0
	cmp	L2C0BA,d0
	bge.s	LC68A
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-106(a0),-(sp)
	pea	L1AA4D
	jsr	L63E0
	addq	#6,sp
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-106(a0),d0
	add	d0,-10(a6)
	addq	#1,-8(a6)
	bra.s	LC646
;
LC68A:
	move	-10(a6),-(sp)
	pea	L1AA51
	jsr	L63E0
	addq	#6,sp
	bra	LC776
;
LC6A0:
	move	-108(a6),-(sp)
	pea	L1AA57
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L16E2A
	adda	#$A,sp
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	8(a6),a0
	move.l	d0,2608(a0)
	moveq	#1,d0
	move	d0,-(sp)
	move	-108(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L9E64
	addq	#8,sp
	move	d0,d0
	beq.s	LC760
	move.l	-4(a6),a0
	move	34(a0),-(sp)
	jsr	LC77A
	addq	#2,sp
	move	d0,-8(a6)
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	addq	#1,-42(a0)
	move.l	-4(a6),a0
	pea	46(a0)
	move.l	8(a6),a0
	pea	2(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	LC736
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	addq	#1,-74(a0)
LC736:
	pea	L1AA68
	move.l	-4(a6),a0
	pea	46(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	LC760
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	addq	#1,-106(a0)
LC760:
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	addq	#1,-108(a6)
	bra	LC4A0
;
LC776:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LC77A:
	link	a6,#-2
	clr	-2(a6)
LC782:
	cmpi	#$10,-2(a6)
	bge.s	LC79E
	move	8(a6),d0
	andi	#1,d0
	bne.s	LC79E
	addq	#1,-2(a6)
	lsr	8(a6)
	bra.s	LC782
;
LC79E:
	cmpi	#$10,-2(a6)
	bne.s	LC7AA
	moveq	#1,d0
	bra.s	LC7AE
;
LC7AA:
	move	-2(a6),d0
LC7AE:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LC7B2:
	link	a6,#-10
	move.l	8(a6),a0
	move.l	2894(a0),-4(a6)
	move.l	8(a6),a0
	move.l	#L1AA6C,2608(a0)
	move	L36744,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L9E64
	addq	#8,sp
	move	d0,-6(a6)
	move	L36744,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-6(a6),d0
	beq.s	LC834
	move.l	-4(a6),a0
	move	12(a6),d0
	cmp	32(a0),d0
	bne.s	LC834
	pea	-10(a6)
	clr	-(sp)
	clr	-(sp)
	move.l	-4(a6),-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA96A
	adda	#$12,sp
	moveq	#1,d0
	bra.s	LC836
;
LC834:
	clr	d0
LC836:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LC83A:
	link	a6,#-2
	move.l	8(a6),a0
	move.l	2604(a0),-(sp)
	pea	L1AA78
	jsr	L63E0
	addq	#8,sp
	move.l	8(a6),a0
	move.l	#L1AA89,2608(a0)
	moveq	#3,d0
	move	d0,-2(a6)
LC866:
	move	-2(a6),d0
	subq	#1,-2(a6)
	move	d0,d0
	beq	LC902
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D5A
	addq	#2,sp
	move.l	8(a6),-(sp)
	jsr	L7050
	addq	#4,sp
	pea	L1AA8F
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),-(sp)
	jsr	LDC7E
	addq	#4,sp
	move	d0,d0
	beq.s	LC866
	move.l	8(a6),a0
	moveq	#1,d0
	move	d0,2986(a0)
	move.l	8(a6),a0
	move	d0,2984(a0)
	move.l	8(a6),a0
	move	d0,2988(a0)
	move.l	8(a6),a0
	move	d0,2594(a0)
	move.l	8(a6),a0
	clr	2976(a0)
	move.l	8(a6),a0
	clr	2996(a0)
	move.l	8(a6),a0
	clr	2994(a0)
	move.l	8(a6),-(sp)
	jsr	LF400
	addq	#4,sp
	pea	L1AA9C
	jsr	L63E0
	addq	#4,sp
	bra.s	LC932
;
LC902:
	pea	L1AA9E
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D5A
	addq	#2,sp
	moveq	#5,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
LC932:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;LC936:
sys_bye_func:
	link	a6,#-2
	move.l	8(a6),a0
	move.l	#L1AACD,2608(a0)
	clr	-(sp)
	pea	L1AAD5
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-2(a6)
	cmpi	#$FFFF,d0
	beq.s	LC9AE
	move	-2(a6),d0
	beq.s	LC9A2
	clr	-(sp)
	move.l	8(a6),a0
	move	2970(a0),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	pea	L1AB16
	pea	L1AB10
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	LBC28
	adda	#$12,sp
LC9A2:
	move.l	8(a6),-(sp)
	jsr	LC9B2
	addq	#4,sp
LC9AE:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LC9B2:
	link	a6,#0
	move.l	8(a6),a0
	move.l	#L1AB1E,2608(a0)
	move.l	8(a6),a0
	move	2598(a0),d0
	addi	#$3B,d0
	move	d0,-(sp)
	pea	L1AB25
	jsr	L63E0
	addq	#6,sp
	pea	L468CE
	pea	L1AB3D
	jsr	L63E0
	addq	#8,sp
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D5A
	addq	#2,sp
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LCA18:
	link	a6,#-4
	move.l	8(a6),a0
	move	32(a0),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18808,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L468CE
	pea	L1AB5D
	jsr	L63E0
	adda	#$10,sp
	move.l	8(a6),a0
	move	42(a0),d0
	beq	LCAF6
	move.l	8(a6),a0
	move	38(a0),-(sp)
	jsr	L6944
	move	d0,-(sp)
	jsr	L6D1E
	addq	#4,sp
	move	d0,-4(a6)
	move.l	8(a6),a0
	move	42(a0),-(sp)
	pea	L1AB7A
	jsr	L63E0
	addq	#6,sp
	move	-4(a6),d0
	ble.s	LCAA6
	move	-4(a6),-(sp)
	pea	L1AB95
	jsr	L63E0
	addq	#6,sp
LCAA6:
	pea	L1ABA4
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	38(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	L5E96
	adda	#$A,sp
	pea	L1ABA8
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	move	40(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	L5DB2
	addq	#6,sp
	bra.s	LCB04
;
LCAF6:
	pea	L1ABAC
	jsr	L63E0
	addq	#4,sp
LCB04:
	move.l	8(a6),a0
	move	34(a0),-2(a6)
	move	-2(a6),d0
	andi.l	#$FFFF,d0
	divu	#$3C,d0
	andi.l	#$FFFF,d0
	divu	#$3C,d0
	swap	d0
	move	d0,-(sp)
	move	-2(a6),d0
	andi.l	#$FFFF,d0
	divu	#$E10,d0
	move	d0,-(sp)
	pea	L1ABC5
	jsr	L63E0
	addq	#8,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LCB4C:
	link	a6,#-2
	move.l	8(a6),-(sp)
	jsr	LA7A0
	addq	#4,sp
	move	d0,-2(a6)
	bne.s	LCB72
	pea	L1AC02
	jsr	L63E0
	addq	#4,sp
	bra.s	LCB84
;
LCB72:
	move	-2(a6),-(sp)
	pea	L1AC13
	jsr	L63E0
	addq	#6,sp
LCB84:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LCB88:
	link	a6,#-2
	move.l	8(a6),-(sp)
	jsr	L9654
	addq	#4,sp
	move	d0,-2(a6)
	bne.s	LCBAE
	pea	L1AC26
	jsr	L63E0
	addq	#4,sp
	bra.s	LCBC0
;
LCBAE:
	move	-2(a6),-(sp)
	pea	L1AC38
	jsr	L63E0
	addq	#6,sp
LCBC0:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LCBC4:
	link	a6,#-20
	move	L467C6,-(sp)
	jsr	L3976
	addq	#2,sp
	pea	L315E6
	pea	-20(a6)
	jsr	L11FEC
	addq	#8,sp
	move	L467C6,-(sp)
	jsr	L3852
	addq	#2,sp
	move.b	-20(a6),d0
	beq.s	LCC0E
	pea	-20(a6)
	pea	L1AC4C
	jsr	L63E0
	addq	#8,sp
LCC0E:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LCC12:
	link	a6,#-554
	moveq	#16,d0
	move	d0,L2C0BA
LCC1E:
	move	L2C0BA,d0
	ble.s	LCC46
	move	L2C0BA,d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#5,d0
	lea	L4691E,a0
	adda.l	d0,a0
	move.b	(a0),d0
	bne.s	LCC46
	subq	#1,L2C0BA
	bra.s	LCC1E
;
LCC46:
	move	L2C0BA,d0
	bne.s	LCC68
	addq	#1,L2C0BA
	pea	L1AC70
	pea	L4691E
	jsr	L11FEC
	addq	#8,sp
LCC68:
	move.b	L46C0E,d0
	bne.s	LCC84
	pea	L1AC78
	pea	L46C0E
	jsr	L11FEC
	addq	#8,sp
LCC84:
	clr	-4(a6)
LCC88:
	move	-4(a6),d0
	cmp	L2C0BA,d0
	bge	LCD68
	clr	-(sp)
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#5,d0
	addi.l	#$46C22,d0
	move.l	d0,-554(a6)
	move.l	d0,-(sp)
	jsr	L5BB4
	addq	#6,sp
	move.l	-554(a6),a0
	move.b	(a0),d0
	beq	LCD5A
	move.l	-554(a6),a0
	cmpi.b	#$41,(a0)
	blt	LCD5A
	move.l	-554(a6),a0
	cmpi.b	#80,(a0)
	bgt	LCD5A
	move.l	-554(a6),a0
	cmpi.b	#$3A,1(a0)
	bne.s	LCD5A
	move.l	-554(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	subq	#1,d0
	move	d0,a0
	adda.l	-554(a6),a0
	cmpi.b	#$5C,(a0)
	bne.s	LCD5A
	move.l	-554(a6),-(sp)
	pea	L1AC81
	clr	-(sp)
	jsr	L64FC
	adda	#$A,sp
	move.l	-554(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	subq	#1,d0
	move	d0,a0
	adda.l	-554(a6),a0
	clr.b	(a0)
	move.l	-554(a6),-(sp)
	move.l	-554(a6),a0
	move.b	(a0),d0
	ext.w	d0
	subi	#$40,d0
	move	d0,-(sp)
	jsr	task_Dcreate
	addq	#6,sp
	move.l	-554(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	move	d0,a0
	adda.l	-554(a6),a0
	moveq	#92,d0
	move.b	d0,(a0)
	bra.s	LCD60
;
LCD5A:
	move.l	-554(a6),a0
	clr.b	(a0)
LCD60:
	addq	#1,-4(a6)
	bra	LCC88
;
LCD68:
	clr	-(sp)
	move.l	#L46E22,d0
	move.l	d0,-554(a6)
	move.l	d0,-(sp)
	jsr	L5BB4
	addq	#6,sp
	move.l	-554(a6),a0
	move.b	(a0),d0
	beq	LCE24
	move.l	-554(a6),a0
	cmpi.b	#$41,(a0)
	blt	LCE24
	move.l	-554(a6),a0
	cmpi.b	#80,(a0)
	bgt	LCE24
	move.l	-554(a6),a0
	cmpi.b	#$3A,1(a0)
	bne.s	LCE24
	move.l	-554(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	subq	#1,d0
	move	d0,a0
	adda.l	-554(a6),a0
	cmpi.b	#$5C,(a0)
	bne.s	LCE24
	move.l	-554(a6),-(sp)
	pea	L1AC9E
	clr	-(sp)
	jsr	L64FC
	adda	#$A,sp
	move.l	-554(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	subq	#1,d0
	move	d0,a0
	adda.l	-554(a6),a0
	clr.b	(a0)
	move.l	-554(a6),-(sp)
	move.l	-554(a6),a0
	move.b	(a0),d0
	ext.w	d0
	subi	#$40,d0
	move	d0,-(sp)
	jsr	task_Dcreate
	addq	#6,sp
	move.l	-554(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	move	d0,a0
	adda.l	-554(a6),a0
	moveq	#92,d0
	move.b	d0,(a0)
	bra.s	LCE2A
;
LCE24:
	move.l	-554(a6),a0
	clr.b	(a0)
LCE2A:
	move.b	L46B26,d0
	ext.w	d0
	move	d0,-(sp)
	move.l	L18860,-(sp)
	jsr	LD290
	addq	#6,sp
	move.l	d0,-554(a6)
	move.l	-554(a6),-(sp)
	pea	L1ACB9
	clr	-(sp)
	jsr	L64FC
	adda	#$A,sp
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-554(a6),-(sp)
	jsr	task_Fopen
	addq	#6,sp
	move	d0,-2(a6)
	bgt.s	LCED6
	move.l	-554(a6),-(sp)
	jsr	LD2EE
	addq	#4,sp
	move	d0,d0
	bne	LD28A
	move.l	-554(a6),-(sp)
	jsr	task_Fcreate
	addq	#4,sp
	move	d0,-2(a6)
	blt	LD28A
	clr	L46E44
	move	#$2002,-(sp)
	pea	L46E44
	move	-2(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmpi	#$2002,d0
	beq.s	LCED6
LCEBA:
	move	-2(a6),-(sp)
	jsr	task_Fclose
	addq	#2,sp
	move.l	-554(a6),-(sp)
	jsr	task_Fdelete
	addq	#4,sp
	bra	LD28A
;
LCED6:
	move	-2(a6),-(sp)
	jsr	task_Fclose
	addq	#2,sp
	moveq	#1,d0
	move	d0,-8(a6)
	move.b	L46B27,d0
	ext.w	d0
	move	d0,-(sp)
	move.l	L18864,-(sp)
	jsr	LD290
	addq	#6,sp
	move.l	d0,-554(a6)
	move.l	-554(a6),-(sp)
	pea	L1ACD5
	clr	-(sp)
	jsr	L64FC
	adda	#$A,sp
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-554(a6),-(sp)
	jsr	task_Fopen
	addq	#6,sp
	move	d0,L2C0B2
	ble	LCFF0
	jsr	L9D5E
	pea	$200.l
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	L2C0B2,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	subi.l	#$1200,d0
	move.l	d0,-(sp)
	jsr	L1806E
	addq	#8,sp
	move	d0,-4(a6)
LCF68:
	addq	#1,-4(a6)
	move	-4(a6),d0
	cmp	L46B20,d0
	bgt	LD0BC
	move	-8(a6),d0
	beq.s	LCF94
	pea	L1ACF2
	clr	-(sp)
	jsr	L64FC
	addq	#6,sp
	clr	-8(a6)
LCF94:
	move	-4(a6),-(sp)
	pea	L1ACF4
	clr	-(sp)
	jsr	L64FC
	addq	#8,sp
	pea	-550(a6)
	move	-4(a6),-(sp)
	jsr	L9C86
	addq	#6,sp
	move	d0,d0
	bne	LD0BC
	move	-4(a6),d0
	subq	#1,d0
	asr.w	#4,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2CB7A,a1
	adda.l	d0,a1
	move	-4(a6),d0
	subq	#1,d0
	andi	#$F,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	or	d0,(a1)
	bra	LCF68
;
LCFF0:
	move.l	-554(a6),-(sp)
	jsr	LD2EE
	addq	#4,sp
	move	d0,d0
	bne	LD28A
	move.l	-554(a6),-(sp)
	jsr	task_Fcreate
	addq	#4,sp
	move	d0,L2C0B2
	blt	LD28A
	pea	L1AD0C
	clr	-(sp)
	jsr	L64FC
	addq	#6,sp
	clr	-(sp)
	move	#$1200,-(sp)
	pea	L2C378
	jsr	L10C
	addq	#8,sp
	jsr	L9DFC
	moveq	#1,d0
	move	d0,-4(a6)
LD048:
	move	-4(a6),d0
	cmp	L46B20,d0
	bgt.s	LD0BC
	move	-4(a6),-(sp)
	pea	L1AD0E
	clr	-(sp)
	jsr	L64FC
	addq	#8,sp
	pea	-550(a6)
	move	-4(a6),-(sp)
	jsr	L9C86
	addq	#6,sp
	move	d0,d0
	beq.s	LD088
	cmpi	#$28,-4(a6)
	ble	LD254
	bra.s	LD0BC
;
LD088:
	move	-4(a6),d0
	subq	#1,d0
	asr.w	#4,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2CB7A,a1
	adda.l	d0,a1
	move	-4(a6),d0
	subq	#1,d0
	andi	#$F,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	or	d0,(a1)
	addq	#1,-4(a6)
	bra.s	LD048
;
LD0BC:
	jsr	L9DFC
	move	L2C0B2,-(sp)
	jsr	task_Fclose
	addq	#2,sp
	move.b	L46B26,d0
	ext.w	d0
	move	d0,-(sp)
	move.l	L18868,-(sp)
	jsr	LD290
	addq	#6,sp
	move.l	d0,-554(a6)
	move.l	-554(a6),-(sp)
	pea	L1AD31
	clr	-(sp)
	jsr	L64FC
	adda	#$A,sp
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-554(a6),-(sp)
	jsr	task_Fopen
	addq	#6,sp
	move	d0,-2(a6)
	bgt	LD19E
	move.l	-554(a6),-(sp)
	jsr	LD2EE
	addq	#4,sp
	move	d0,d0
	bne	LD28A
	move.l	-554(a6),-(sp)
	jsr	task_Fcreate
	addq	#4,sp
	move	d0,-2(a6)
	blt	LD28A
	moveq	#28,d0
	move	d0,-6(a6)
	clr	-10(a6)
	clr	-(sp)
	move	-6(a6),-(sp)
	pea	-38(a6)
	jsr	L10C
	addq	#8,sp
	moveq	#2,d0
	move	d0,-(sp)
	pea	-10(a6)
	move	-2(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	clr	-4(a6)
LD174:
	cmpi	#$64,-4(a6)
	bge.s	LD19E
	move	-6(a6),-(sp)
	pea	-38(a6)
	move	-2(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmp	-6(a6),d0
	bne	LCEBA
	addq	#1,-4(a6)
	bra.s	LD174
;
LD19E:
	move	-2(a6),-(sp)
	jsr	task_Fclose
	addq	#2,sp
	move.b	L46B26,d0
	ext.w	d0
	move	d0,-(sp)
	move.l	L1886C,-(sp)
	jsr	LD290
	addq	#6,sp
	move.l	d0,-554(a6)
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-554(a6),-(sp)
	jsr	task_Fopen
	addq	#6,sp
	move	d0,-2(a6)
	bge.s	LD1F0
	move.l	-554(a6),-(sp)
	jsr	task_Fcreate
	addq	#4,sp
	move	d0,-2(a6)
	blt	LD28A
LD1F0:
	move	-2(a6),-(sp)
	jsr	task_Fclose
	addq	#2,sp
	move.b	L46B26,d0
	ext.w	d0
	move	d0,-(sp)
	move.l	L18870,-(sp)
	jsr	LD290
	addq	#6,sp
	move.l	d0,-554(a6)
	move.l	-554(a6),-(sp)
	pea	L1AD50
	clr	-(sp)
	jsr	L64FC
	adda	#$A,sp
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-554(a6),-(sp)
	jsr	task_Fopen
	addq	#6,sp
	move	d0,-2(a6)
	ble.s	LD268
	move	-2(a6),-(sp)
	jsr	task_Fclose
	addq	#2,sp
LD250:
	clr	d0
	bra.s	LD28C
;
LD254:
	pea	L1AD25
	clr	-(sp)
	jsr	L64FC
	addq	#6,sp
	bra	LCEBA
;
LD268:
	move.l	-554(a6),-(sp)
	jsr	LD2EE
	addq	#4,sp
	move	d0,d0
	bne.s	LD28A
	move.l	-554(a6),-(sp)
	jsr	task_Fcreate
	addq	#4,sp
	move	d0,-2(a6)
	bge.s	LD250
LD28A:
	moveq	#1,d0
LD28C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LD290:
	link	a6,#-4
	move.l	#L1AD6C,-4(a6)
	move.l	8(a6),a0
	cmpi.b	#$78,(a0)
	bne.s	LD2B4
	move	12(a6),d0
	addi	#$41,d0
	move.l	8(a6),a0
	move.b	d0,(a0)
LD2B4:
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	move.l	8(a6),a1
	move.l	-4(a6),a0
	move.b	(a1),(a0)
	move.l	-4(a6),-(sp)
	move.l	8(a6),a0
	move.b	(a0),d0
	ext.w	d0
	subi	#$40,d0
	move	d0,-(sp)
	jsr	task_Dcreate
	addq	#6,sp
	move.l	8(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LD2EE:
	link	a6,#-2
	move.b	L1AC62,d0
	bne.s	LD2FE
LD2FA:
	clr	d0
	bra.s	LD366
;
LD2FE:
	move.l	8(a6),-(sp)
	pea	L1AD73
	clr	-(sp)
	jsr	L64FC
	adda	#$A,sp
LD314:
	clr	-(sp)
	jsr	L6DF4
	addq	#2,sp
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move	d0,-2(a6)
	cmpi	#$59,d0
	beq.s	LD33A
	cmpi	#$4E,-2(a6)
	bne.s	LD314
LD33A:
	cmpi	#$59,-2(a6)
	bne.s	LD354
	pea	L1AD9A
	clr	-(sp)
	jsr	L64FC
	addq	#6,sp
	bra.s	LD2FA
;
LD354:
	pea	L1ADA0
	clr	-(sp)
	jsr	L64FC
	addq	#6,sp
	moveq	#1,d0
LD366:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LD36A:
	link	a6,#-148
	clr	-2(a6)
	move	L46E44,d0
LD378:
	subq	#1,d0
	move	d0,-4(a6)
LD37E:
	move	-2(a6),d0
	cmp	-4(a6),d0
	bgt.s	LD3F0
	move	-4(a6),d0
	add	-2(a6),d0
	ext.l	d0
	divs	#2,d0
	move	d0,-8(a6)
	pea	-148(a6)
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LD9D2
	addq	#6,sp
	move	d0,d0
	bne.s	LD3F0
	pea	-148(a6)
	move.l	8(a6),-(sp)
	move.l	12(a6),a0
	jsr	(a0)
	addq	#8,sp
	move	d0,-6(a6)
	bge.s	LD3D8
	move	-8(a6),d0
	bra.s	LD378
;
LD3D8:
	move	-6(a6),d0
	ble.s	LD3EA
	move	-8(a6),d0
	addq	#1,d0
	move	d0,-2(a6)
	bra.s	LD37E
;
LD3EA:
	move	-8(a6),d0
	bra.s	LD3F2
;
LD3F0:
	moveq	#-1,d0
LD3F2:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LD3F6:
	link	a6,#-154
	cmpi	#$1000,L46E44
	blt.s	LD40A
	moveq	#-1,d0
	bra	LD512
;
LD40A:
	move	L46E44,d0
	addq	#1,d0
	move	d0,-2(a6)
	move.l	8(a6),-(sp)
	move	-2(a6),-(sp)
	jsr	LDA68
	addq	#6,sp
	move	d0,d0
	beq.s	LD430
	moveq	#-2,d0
	bra	LD512
;
LD430:
	clr	-4(a6)
	clr	-8(a6)
	move	L46E44,d0
LD43E:
	subq	#1,d0
	move	d0,-6(a6)
LD444:
	move	-4(a6),d0
	cmp	-6(a6),d0
	bgt.s	LD4BA
	move	-6(a6),d0
	add	-4(a6),d0
	ext.l	d0
	divs	#2,d0
	move	d0,-8(a6)
	pea	-154(a6)
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LD9D2
	addq	#6,sp
	move	d0,d0
	beq.s	LD488
	moveq	#-3,d0
	bra	LD512
;
LD488:
	pea	-154(a6)
	move.l	8(a6),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,-10(a6)
	bge.s	LD4A4
	move	-8(a6),d0
	bra.s	LD43E
;
LD4A4:
	move	-10(a6),d0
	ble.s	LD4B6
	move	-8(a6),d0
	addq	#1,d0
	move	d0,-4(a6)
	bra.s	LD444
;
LD4B6:
	moveq	#-4,d0
	bra.s	LD512
;
LD4BA:
	move	L46E44,-6(a6)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	addi.l	#$46E46,d0
	move.l	d0,-14(a6)
LD4D4:
	move	-6(a6),d0
	cmp	-4(a6),d0
	ble.s	LD4F4
	move.l	-14(a6),a1
	move.l	-14(a6),a0
	move	-2(a1),(a0)
	subq.l	#2,-14(a6)
	subq	#1,-6(a6)
	bra.s	LD4D4
;
LD4F4:
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	-2(a6),(a0)
	addq	#1,L46E44
	move	-4(a6),d0
LD512:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LD516:
	link	a6,#-160
	clr.l	-20(a6)
	clr	-2(a6)
	move	L46E44,d0
LD528:
	subq	#1,d0
	move	d0,-4(a6)
LD52E:
	move	-2(a6),d0
	cmp	-4(a6),d0
	bgt	LD654
	move	-4(a6),d0
	add	-2(a6),d0
	ext.l	d0
	divs	#2,d0
	move	d0,-6(a6)
	pea	-160(a6)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),d0
	move	d0,-10(a6)
	move	d0,-(sp)
	jsr	LD9D2
	addq	#6,sp
	move	d0,d0
	bne	LD654
	pea	-160(a6)
	move.l	8(a6),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,-8(a6)
	bge.s	LD592
	move	-6(a6),d0
	bra.s	LD528
;
LD592:
	move	-8(a6),d0
	ble.s	LD5A4
	move	-6(a6),d0
	addq	#1,d0
	move	d0,-2(a6)
	bra.s	LD52E
;
LD5A4:
	move	L46E44,-4(a6)
	pea	-160(a6)
	move	-4(a6),-(sp)
	jsr	LD9D2
	addq	#6,sp
	move	d0,d0
	bne	LD654
	pea	-160(a6)
	move	-10(a6),-(sp)
	jsr	LDA68
	addq	#6,sp
	move	d0,d0
	bne.s	LD654
	clr	-12(a6)
LD5DA:
	move	-12(a6),d0
	cmp	-4(a6),d0
	bge.s	LD618
	move	-12(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),d0
	cmp	-4(a6),d0
	bne.s	LD612
	move	-12(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	-10(a6),(a0)
	bra.s	LD618
;
LD612:
	addq	#1,-12(a6)
	bra.s	LD5DA
;
LD618:
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	addi.l	#$46E46,d0
	move.l	d0,-16(a6)
LD62A:
	move	-6(a6),d0
	cmp	-4(a6),d0
	bge.s	LD64A
	move.l	-16(a6),a1
	move.l	-16(a6),a0
	move	2(a1),(a0)
	addq	#1,-6(a6)
	addq.l	#2,-16(a6)
	bra.s	LD62A
;
LD64A:
	subq	#1,L46E44
	clr	d0
	bra.s	LD656
;
LD654:
	moveq	#-1,d0
LD656:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LD65A:
	link	a6,#-18
	move.l	8(a6),a0
	move.l	#L1ADA6,2608(a0)
	move	L467C6,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-4(a6)
	move	L2C0B4,-2(a6)
	ble.s	LD6CC
	clr	-(sp)
	clr.l	-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	moveq	#2,d0
	move	d0,-(sp)
	pea	-4(a6)
	move	-2(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move	#$AF0,-6(a6)
	move	-6(a6),-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move	d0,-8(a6)
LD6CC:
	move	L467C6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	blt.s	LD6F0
	move	-4(a6),d0
	beq.s	LD6F0
	move	-8(a6),d0
	cmp	-6(a6),d0
	beq.s	LD702
LD6F0:
	pea	L1ADB3
	jsr	L63E0
	addq	#4,sp
	bra	LD840
;
LD702:
	move	-4(a6),-12(a6)
	cmpi	#$64,-4(a6)
	bls.s	LD71A
	move	-4(a6),d0
	addi	#$FF9D,d0
	bra.s	LD71C
;
LD71A:
	moveq	#1,d0
LD71C:
	move	d0,-14(a6)
	move	-12(a6),-(sp)
	move	-14(a6),-(sp)
	pea	L1ADD0
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-10(a6)
	cmpi	#$FFFF,d0
	beq	LD840
	move	-10(a6),d0
	bne.s	LD77C
	cmpi	#$14,-12(a6)
	bls.s	LD776
	move	-12(a6),d0
	addi	#$FFEC,d0
	bra.s	LD778
;
LD776:
	moveq	#1,d0
LD778:
	move	d0,-10(a6)
LD77C:
	move	-10(a6),d0
	cmp	-14(a6),d0
	bcc.s	LD78C
	move	-14(a6),-10(a6)
LD78C:
	move	-10(a6),-4(a6)
LD792:
	move	-4(a6),d0
	cmp	-12(a6),d0
	bhi	LD840
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L6AF8
	addq	#6,sp
	move	d0,d0
	bne	LD840
	move	-4(a6),d0
	cmp	-10(a6),d0
	bne.s	LD7DA
	pea	L1AE0E
	jsr	L63E0
	addq	#4,sp
	pea	L1AE47
	jsr	L63E0
	addq	#4,sp
LD7DA:
	move.l	8(a6),a0
	move	-4(a6),d0
	addi	#$FFFF,d0
	andi.l	#$FFFF,d0
	divu	#$64,d0
	swap	d0
	mulu	#$1C,d0
	swap	d0
	clr	d0
	swap	d0
	add.l	2894(a0),d0
	move.l	d0,-18(a6)
	move.l	-18(a6),a0
	move	26(a0),-(sp)
	move.l	-18(a6),a0
	move	24(a0),-(sp)
	move.l	-18(a6),a0
	move	22(a0),-(sp)
	move.l	-18(a6),a0
	pea	2(a0)
	move	-4(a6),-(sp)
	pea	L1AE81
	jsr	L63E0
	adda	#$10,sp
	addq	#1,-4(a6)
	bra	LD792
;
LD840:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LD844:
	link	a6,#-40
	lea	-32(a6),a0
	move.l	a0,-36(a6)
	move	L467C6,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-4(a6)
	move	L2C0B4,-2(a6)
	ble	LD9C0
	move.l	8(a6),a0
	move	2596(a0),d0
	beq	LD9C0
	clr	-(sp)
	clr.l	-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	moveq	#2,d0
	move	d0,-(sp)
	pea	-4(a6)
	move	-2(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	clr	-(sp)
	moveq	#28,d0
	move	d0,-(sp)
	move.l	-36(a6),-(sp)
	jsr	L10C
	addq	#8,sp
	move.l	8(a6),a0
	pea	2(a0)
	move.l	-36(a6),a0
	pea	2(a0)
	jsr	L11FEC
	addq	#8,sp
	jsr	L6944
	move.l	-36(a6),a0
	move	d0,22(a0)
	jsr	L6988
	move.l	-36(a6),a0
	move	d0,24(a0)
	move.l	8(a6),a1
	move.l	-36(a6),a0
	move	2598(a1),26(a0)
	move.l	8(a6),a0
	move	2988(a0),d0
	beq	LD98C
	move.l	8(a6),a0
	pea	2(a0)
	pea	L315E6
	jsr	L11FEC
	addq	#8,sp
	moveq	#28,d0
	move.l	d0,-(sp)
	move	-4(a6),d0
	andi.l	#$FFFF,d0
	divu	#$64,d0
	swap	d0
	swap	d0
	clr	d0
	swap	d0
	move.l	d0,-(sp)
	jsr	L1812E
	addq	#8,sp
	addq.l	#2,d0
	move.l	d0,-40(a6)
	clr	-(sp)
	move.l	-40(a6),-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	moveq	#28,d0
	move	d0,-(sp)
	move.l	-36(a6),-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	clr	-(sp)
	clr.l	-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	addq	#1,-4(a6)
	moveq	#2,d0
	move	d0,-(sp)
	pea	-4(a6)
	move	-2(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
LD98C:
	move.l	-36(a6),a0
	move	26(a0),-(sp)
	move.l	-36(a6),a0
	move	24(a0),-(sp)
	move.l	-36(a6),a0
	move	22(a0),-(sp)
	move.l	-36(a6),a0
	pea	2(a0)
	pea	L1AE99
	moveq	#8,d0
	move	d0,-(sp)
	jsr	L64FC
	adda	#$10,sp
LD9C0:
	move	L467C6,-(sp)
	jsr	L3852
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LD9D2:
	link	a6,#-6
	move	L2C0B0,d0
	ble.s	LD9E4
	move	8(a6),d0
	bne.s	LD9E8
LD9E4:
	moveq	#1,d0
	bra.s	LDA64
;
LD9E8:
	pea	$8C.l
	move	8(a6),d0
	subq	#1,d0
	ext.l	d0
	move.l	d0,-(sp)
	jsr	L1812E
	addq	#8,sp
	addi.l	#$2002,d0
	move.l	d0,-6(a6)
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	move.l	-6(a6),-(sp)
	move	L2C0B0,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	#$8C,-(sp)
	move.l	10(a6),-(sp)
	move	L2C0B0,-(sp)
	jsr	task_Fread
	addq	#8,sp
	cmpi	#$8C,d0
	beq.s	LDA4C
	moveq	#1,d0
	bra.s	LDA4E
;
LDA4C:
	clr	d0
LDA4E:
	move	d0,-2(a6)
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
LDA64:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LDA68:
	link	a6,#-6
	move	L2C0B0,d0
	ble.s	LDA7A
	move	8(a6),d0
	bne.s	LDA7E
LDA7A:
	moveq	#1,d0
	bra.s	LDAFA
;
LDA7E:
	pea	$8C.l
	move	8(a6),d0
	subq	#1,d0
	ext.l	d0
	move.l	d0,-(sp)
	jsr	L1812E
	addq	#8,sp
	addi.l	#$2002,d0
	move.l	d0,-6(a6)
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	move.l	-6(a6),-(sp)
	move	L2C0B0,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	#$8C,-(sp)
	move.l	10(a6),-(sp)
	move	L2C0B0,-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmpi	#$8C,d0
	beq.s	LDAE2
	moveq	#1,d0
	bra.s	LDAE4
;
LDAE2:
	clr	d0
LDAE4:
	move	d0,-2(a6)
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
LDAFA:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LDAFE:
	link	a6,#-2
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L46E44,-2(a6)
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LDB2E:
	link	a6,#0
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	clr.l	-(sp)
	move	L2C0B0,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	#$2002,-(sp)
	pea	L46E44
	move	L2C0B0,-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LDB7C:
	link	a6,#-6
	move.l	8(a6),a0
	clr	2594(a0)
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move.l	8(a6),a0
	move	2596(a0),d0
	beq.s	LDC02
	move.l	8(a6),a0
	addq	#1,42(a0)
	jsr	L6944
	move.l	8(a6),a0
	move	d0,38(a0)
	jsr	L6988
	move.l	8(a6),a0
	move	d0,40(a0)
	pea	L559C
	move.l	8(a6),a0
	pea	2(a0)
	jsr	LD36A
	addq	#8,sp
	move	d0,-2(a6)
	blt.s	LDC02
	move.l	8(a6),a0
	pea	2(a0)
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LDA68
	addq	#6,sp
LDC02:
	move.l	8(a6),a0
	clr	2970(a0)
	move.l	8(a6),a0
	clr	2596(a0)
	clr	d0
	move.l	8(a6),a0
	move	d0,2602(a0)
	move.l	8(a6),a0
	move	d0,2972(a0)
	move.l	8(a6),a0
	move	(a0),-6(a6)
	clr	-4(a6)
LDC30:
	cmpi	#4,-4(a6)
	bge.s	LDC6C
	move	-4(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	8(a6),a0
	clr.b	2274(a0)
	move	-6(a6),d1
	muls	#80,d1
	move	-4(a6),d0
	muls	#$1016,d0
	add.l	d1,d0
	lea	L2DE6C,a0
	adda.l	d0,a0
	clr.b	(a0)
	addq	#1,-4(a6)
	bra.s	LDC30
;
LDC6C:
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LDC7E:
	link	a6,#-12
	move.l	8(a6),a0
	clr	2596(a0)
	move.l	8(a6),a0
	clr	2598(a0)
	clr	-(sp)
	moveq	#20,d0
	move	d0,-(sp)
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-12(a6)
	move.l	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LDF50
	pea	L1AEF8
	move.l	-12(a6),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	beq.s	LDCEA
	pea	L1AEFC
	move.l	-12(a6),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	LDCFC
LDCEA:
	pea	L1AF00
	jsr	L63E0
	addq	#4,sp
	bra	LDF50
;
LDCFC:
	move.l	8(a6),a0
	clr	2594(a0)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L57B6
	addq	#4,sp
	cmpi	#1,d0
	blt	LDF50
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	pea	L559C
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	LD36A
	addq	#8,sp
	move	d0,-6(a6)
	move	-6(a6),d0
	blt.s	LDD6C
	move.l	8(a6),a0
	pea	2(a0)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LD9D2
	addq	#6,sp
LDD6C:
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-6(a6),d0
	bge.s	LDD90
	move.l	8(a6),-(sp)
	jsr	LDF56
	addq	#4,sp
	bra	LDF52
;
LDD90:
	moveq	#2,d0
	move	d0,-2(a6)
LDD96:
	move	-2(a6),d0
	subq	#1,-2(a6)
	move	d0,d0
	beq	LDF50
	pea	L1AF14
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	moveq	#10,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move.l	8(a6),a0
	pea	22(a0)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne	LDF28
	move.l	8(a6),a0
	move	36(a0),d0
	bne.s	LDE04
	move.l	8(a6),a0
	move	L46B22,36(a0)
LDE04:
	jsr	L6944
	move	d0,-8(a6)
	move.l	8(a6),a0
	move	-8(a6),d0
	cmp	38(a0),d0
	beq.s	LDE2A
	move.l	8(a6),a1
	move.l	8(a6),a0
	move	36(a1),34(a0)
LDE2A:
	move.l	8(a6),a1
	move.l	8(a6),a0
	move	34(a0),d0
	cmp	36(a1),d0
	ble.s	LDE4A
	move.l	8(a6),a1
	move.l	8(a6),a0
	move	36(a1),34(a0)
LDE4A:
	move.l	8(a6),a0
	move	48(a0),d0
	move.l	8(a6),a0
	move	d0,2970(a0)
	cmp	L2C0BA,d0
	bgt.s	LDE7E
	move.l	8(a6),a0
	move	2970(a0),d0
	addq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L4D78
	addq	#6,sp
	move	d0,d0
	bne.s	LDE8E
LDE7E:
	move.l	8(a6),a0
	clr	2970(a0)
	move.l	8(a6),a0
	clr	48(a0)
LDE8E:
	moveq	#1,d0
	move	d0,-4(a6)
LDE94:
	cmpi	#$10,-4(a6)
	bge.s	LDED2
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#5,d0
	lea	L4691E,a0
	adda.l	d0,a0
	move.b	(a0),d0
	bne.s	LDECC
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	not	d0
	move.l	8(a6),a0
	and	d0,46(a0)
LDECC:
	addq	#1,-4(a6)
	bra.s	LDE94
;
LDED2:
	move.l	8(a6),a0
	move	46(a0),d0
	bne.s	LDEE6
	move.l	8(a6),a0
	moveq	#1,d0
	move	d0,46(a0)
LDEE6:
	move.l	8(a6),a0
	moveq	#1,d0
	move	d0,2596(a0)
	move.l	8(a6),a0
	moveq	#1,d0
	move	d0,2594(a0)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2(a0)
	jsr	L5BB4
	addq	#6,sp
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	bne.s	LDF24
	move.l	8(a6),a0
	move	#$FFFF,46(a0)
LDF24:
	moveq	#1,d0
	bra.s	LDF52
;
LDF28:
	pea	L1AF20
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	pea	2(a0)
	pea	L1AF33
	jsr	L6526
	addq	#8,sp
	bra	LDD96
;
LDF50:
	clr	d0
LDF52:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LDF56:
	link	a6,#-12
	move.l	8(a6),d0
	addq.l	#2,d0
	move.l	d0,-4(a6)
	clr	-(sp)
	move	#$8C,-(sp)
	move.l	-4(a6),-(sp)
	jsr	L10C
	addq	#8,sp
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L5BB4
	addq	#6,sp
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	-4(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	move.l	-4(a6),-(sp)
	pea	L1AF4E
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L16E2A
	adda	#$C,sp
	clr	-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	cmpi	#1,d0
	beq.s	LDFDE
LDFD8:
	clr	d0
	bra	LE310
;
LDFDE:
	move.l	-4(a6),a0
	move	L46B24,30(a0)
	move	L46B22,d0
	move.l	-4(a6),a0
	move	d0,34(a0)
	move.l	-4(a6),a0
	move	d0,32(a0)
	move.l	-4(a6),a0
	clr	36(a0)
	move.l	-4(a6),a0
	clr	38(a0)
	move.l	-4(a6),a0
	clr	40(a0)
	move.l	-4(a6),a0
	clr	42(a0)
	move.l	-4(a6),a0
	moveq	#1,d0
	move	d0,44(a0)
	clr	-8(a6)
LE02E:
	cmpi	#$10,-8(a6)
	bge.s	LE066
	move	-8(a6),a0
	adda.l	#L468EE,a0
	btst	#2,(a0)
	beq.s	LE060
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	move.l	-4(a6),a0
	or	d0,44(a0)
LE060:
	addq	#1,-8(a6)
	bra.s	LE02E
;
LE066:
	move.l	-4(a6),a0
	clr	46(a0)
	move.l	-4(a6),a0
	clr	50(a0)
	move.l	-4(a6),a0
	clr	48(a0)
	moveq	#1,d0
	move	d0,-(sp)
	pea	L1AF81
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-6(a6)
	cmpi	#$FFFF,d0
	beq	LDFD8
	move	-6(a6),d0
	bne.s	LE0F8
	pea	L1AF9D
	jsr	L63E0
	addq	#4,sp
	move.l	-4(a6),a0
	clr	30(a0)
	move.l	8(a6),a0
	moveq	#1,d0
	move	d0,2594(a0)
	move	L46C0C,d0
	move.l	-4(a6),a0
	move	d0,34(a0)
	move.l	-4(a6),a0
	move	d0,32(a0)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L1AFC1
	jsr	L6526
	addq	#8,sp
	bra	LE30E
;
LE0F8:
	pea	L1AFDD
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#10,d0
	move	d0,-(sp)
	move.l	-4(a6),d0
	addi.l	#$14,d0
	move.l	d0,-12(a6)
	move.l	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move.l	-12(a6),-(sp)
	jsr	L5C2E
	addq	#4,sp
	move	d0,d0
	beq.s	LE0F8
LE13A:
	pea	L1AFFE
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#20,d0
	move	d0,-(sp)
	move.l	-4(a6),d0
	addi.l	#$34,d0
	move.l	d0,-12(a6)
	move.l	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move.l	-12(a6),-(sp)
	jsr	L5C2E
	addq	#4,sp
	move	d0,d0
	beq.s	LE13A
LE17C:
	pea	L1B01E
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#16,d0
	move	d0,-(sp)
	move.l	-4(a6),d0
	addi.l	#$48,d0
	move.l	d0,-12(a6)
	move.l	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move.l	-12(a6),-(sp)
	jsr	L5C2E
	addq	#4,sp
	move	d0,d0
	beq.s	LE17C
LE1BE:
	pea	L1B03E
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#6,d0
	move	d0,-(sp)
	move.l	-4(a6),d0
	addi.l	#$58,d0
	move.l	d0,-12(a6)
	move.l	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move.l	-12(a6),-(sp)
	jsr	L5C2E
	addq	#4,sp
	move	d0,d0
	beq.s	LE1BE
LE200:
	pea	L1B05E
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#12,d0
	move	d0,-(sp)
	move.l	-4(a6),d0
	addi.l	#$5E,d0
	move.l	d0,-12(a6)
	move.l	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move.l	-12(a6),-(sp)
	jsr	L5C2E
	addq	#4,sp
	move	d0,d0
	beq.s	LE200
LE242:
	pea	L1B07E
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#14,d0
	move	d0,-(sp)
	move.l	-4(a6),d0
	addi.l	#$6A,d0
	move.l	d0,-12(a6)
	move.l	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move.l	-12(a6),-(sp)
	jsr	L5C2E
	addq	#4,sp
	move	d0,d0
	beq.s	LE242
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move.l	-4(a6),-(sp)
	jsr	LD3F6
	addq	#4,sp
	move	d0,-8(a6)
	move	-8(a6),d0
	blt.s	LE2AE
	jsr	LDB2E
LE2AE:
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-8(a6),d0
	bge.s	LE2E4
	move	-8(a6),-(sp)
	pea	L1B09E
	jsr	L6526
	addq	#6,sp
	pea	L1B0C7
	jsr	L63E0
	addq	#4,sp
	bra.s	LE2EE
;
LE2E4:
	move.l	8(a6),a0
	moveq	#1,d0
	move	d0,2596(a0)
LE2EE:
	move.l	8(a6),a0
	pea	2(a0)
	pea	L1B0FA
	jsr	L6526
	addq	#8,sp
	move.l	8(a6),a0
	moveq	#1,d0
	move	d0,2594(a0)
LE30E:
	moveq	#1,d0
LE310:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LE314:
	link	a6,#0
	moveq	#1,d0
	move	d0,-(sp)
	move.l	12(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	pea	L1B113
	jsr	L63E0
	addq	#4,sp
	move.l	12(a6),-(sp)
	pea	L1B115
	jsr	L63E0
	addq	#8,sp
	move.l	12(a6),a0
	move	30(a0),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18808,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	pea	L1B12C
	jsr	L63E0
	addq	#8,sp
	move.l	12(a6),a0
	pea	52(a0)
	pea	L1B143
	jsr	L63E0
	addq	#8,sp
	move.l	12(a6),a0
	pea	72(a0)
	pea	L1B15A
	jsr	L63E0
	addq	#8,sp
	move.l	12(a6),a0
	pea	88(a0)
	pea	L1B171
	jsr	L63E0
	addq	#8,sp
	move.l	12(a6),a0
	pea	94(a0)
	pea	L1B188
	jsr	L63E0
	addq	#8,sp
	move.l	12(a6),a0
	pea	106(a0)
	pea	L1B19F
	jsr	L63E0
	addq	#8,sp
	move	16(a6),d0
	beq.s	LE3EA
	move.l	12(a6),a0
	pea	20(a0)
	bra.s	LE3F0
;
LE3EA:
	pea	L1B1D3
LE3F0:
	pea	L1B1B6
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	clr	-(sp)
	move.l	12(a6),a0
	move	44(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA492
	adda	#$A,sp
	move.l	8(a6),a0
	pea	2638(a0)
	pea	L1B1D4
	jsr	L63E0
	addq	#8,sp
	move.l	12(a6),a0
	move	34(a0),-(sp)
	pea	L1B1EB
	jsr	L63E0
	addq	#6,sp
	move.l	12(a6),a0
	move	42(a0),-(sp)
	pea	L1B202
	jsr	L63E0
	addq	#6,sp
	move.l	12(a6),a0
	move	120(a0),-(sp)
	pea	L1B219
	jsr	L63E0
	addq	#6,sp
	move.l	12(a6),a0
	move	46(a0),d0
	ext.l	d0
	lsl.l	#5,d0
	addi.l	#$4691E,d0
	move.l	d0,-(sp)
	move.l	12(a6),a0
	move	46(a0),d0
	addq	#1,d0
	move	d0,-(sp)
	pea	L1B230
	jsr	L63E0
	adda	#$A,sp
	move.l	12(a6),a0
	move	48(a0),-(sp)
	pea	L1B24C
	jsr	L63E0
	addq	#6,sp
	move.l	12(a6),a0
	move	50(a0),-(sp)
	pea	L1B263
	jsr	L63E0
	addq	#6,sp
	move.l	12(a6),a0
	move	40(a0),-(sp)
	pea	L1B27A
	jsr	L63E0
	addq	#6,sp
	move.l	12(a6),a0
	move	38(a0),-(sp)
	move.l	12(a6),a0
	move	36(a0),-(sp)
	pea	L1B291
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	clr	-(sp)
	move.l	12(a6),a0
	move	122(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA492
	adda	#$A,sp
	move.l	8(a6),a0
	pea	2638(a0)
	pea	L1B2AE
	jsr	L63E0
	addq	#8,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LE534:
	link	a6,#-4
	move.l	8(a6),a0
	move.l	#L1B2C6,2608(a0)
	move.l	8(a6),a0
	move	2596(a0),d0
	beq	LE6EC
	clr	-2(a6)
LE554:
	move	-2(a6),d0
	bne	LE6EC
	clr	-(sp)
	move.l	8(a6),a0
	pea	22(a0)
	jsr	L5BB4
	addq	#6,sp
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2(a0)
	move.l	8(a6),-(sp)
	jsr	LE314
	adda	#$A,sp
	pea	L1B2D2
	jsr	L63E0
	addq	#4,sp
	pea	L1B2FC
	move.l	8(a6),-(sp)
	jsr	L6A98
	addq	#8,sp
	move	d0,-(sp)
	pea	L1B2F9
	jsr	L120D4
	addq	#6,sp
	tst	d0
	beq.s	LE5DA
	cmpi	#1,d0
	beq	LE68E
	pea	L1B3D0
	jsr	L63E0
	addq	#4,sp
LE5D2:
	addq	#1,-2(a6)
	bra	LE554
;
LE5DA:
	move	L2C0BA,-(sp)
	pea	L1B303
	jsr	L63E0
	addq	#6,sp
	clr	-(sp)
	moveq	#-3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-4(a6)
	cmpi	#$FFFF,d0
	beq.s	LE5D2
	move	-4(a6),d0
	ble.s	LE65E
	move	-4(a6),d0
	cmp	L2C0BA,d0
	bgt.s	LE65E
	move	-4(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L4D78
	addq	#6,sp
	move	d0,d0
	beq.s	LE65E
	move	-4(a6),d0
	subq	#1,d0
	move.l	8(a6),a0
	move	d0,48(a0)
	move	-4(a6),-(sp)
	pea	L1B324
LE652:
	jsr	L63E0
	addq	#6,sp
	bra	LE554
;
LE65E:
	move	-4(a6),d0
	ble.s	LE67C
	move	-4(a6),d0
	cmp	L2C0BA,d0
	bgt.s	LE67C
	move	-4(a6),-(sp)
	pea	you_dont_have_access_to_sig_x_2_s
	bra.s	LE652
;
LE67C:
	pea	L1B35F
LE682:
	jsr	L63E0
	addq	#4,sp
	bra	LE554
;
LE68E:
	pea	L1B378
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#10,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq.s	LE6C8
	move.l	8(a6),a0
	move.b	2638(a0),d0
	bne.s	LE6D0
LE6C8:
	pea	L1B398
	bra.s	LE682
;
LE6D0:
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),a0
	pea	22(a0)
	jsr	L11FEC
	addq	#8,sp
	bra	LE554
;
LE6EC:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LE6F0:
	link	a6,#-8
	clr	-6(a6)
LE6F8:
	cmpi	#4,-6(a6)
	bge.s	LE772
	move	-6(a6),d0
	muls	#$1016,d0
	addi.l	#$2D58C,d0
	move.l	d0,-4(a6)
	move.l	8(a6),-(sp)
	move.l	-4(a6),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	LE76C
	jsr	mask_interrupts
	move	d0,-8(a6)
	move	#$8C,-(sp)
	move.l	8(a6),-(sp)
	move.l	-4(a6),-(sp)
	jsr	move_bytes
	adda	#$A,sp
	move	-8(a6),-(sp)
	jsr	set_statusreg
	addq	#2,sp
	move.l	8(a6),a0
	move	34(a0),d0
	move.l	-4(a6),a0
	move	d0,34(a0)
	move.l	-4(a6),a0
	move	d0,32(a0)
	bra.s	LE772
;
LE76C:
	addq	#1,-6(a6)
	bra.s	LE6F8
;
LE772:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;LE776:
sys_user_func:
	link	a6,#-172
	move.l	a3,-(sp)
	clr	-168(a6)
	move.l	#L1B3D6,-162(a6)
	lea	-148(a6),a0
	move.l	a0,-152(a6)
LE790:
	jsr	LDAFE
	move	d0,-4(a6)
	move	-4(a6),-(sp)
	pea	L1B3FA
	jsr	L63E0
	addq	#6,sp
	move	12(a6),d0
	bne.s	LE7EC
	pea	L1B404
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#20,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-6(a6)
	cmpi	#$FFFF,d0
	bne	LE886
	bra	LF3FA
;
LE7EC:
	pea	L1B410
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	LE814
	moveq	#1,d0
	move	d0,-168(a6)
	move.l	8(a6),a0
	clr.b	2638(a0)
	bra.s	LE886
;
LE814:
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L11FEC
	addq	#8,sp
	moveq	#1,d0
	move	d0,-6(a6)
LE830:
	move	-6(a6),d0
	cmp	12(a6),d0
	bge.s	LE876
	pea	L1B415
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L1206E
	addq	#8,sp
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	move.l	d0,a0
	adda.l	14(a6),a0
	move.l	(a0),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L1206E
	addq	#8,sp
	addq	#1,-6(a6)
	bra.s	LE830
;
LE876:
	move.l	8(a6),a0
	clr.b	2658(a0)
	clr	12(a6)
	clr	-6(a6)
LE886:
	move.l	8(a6),a0
	move.b	2638(a0),d0
	bne.s	LE896
	moveq	#1,d0
	move	d0,-6(a6)
LE896:
	pea	L1B417
	jsr	L63E0
	addq	#4,sp
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move	-6(a6),d0
	beq.s	LE8BE
	clr	-6(a6)
	bra.s	LE920
;
LE8BE:
	pea	L55EC
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	LD36A
	addq	#8,sp
	move	d0,-6(a6)
LE8D8:
	move	-6(a6),d0
	ble.s	LE920
	move.l	-152(a6),-(sp)
	move	-6(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LD9D2
	addq	#6,sp
	move	d0,d0
	bne.s	LE920
	move.l	-152(a6),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L55EC
	addq	#8,sp
	move	d0,d0
	bne.s	LE920
	subq	#1,-6(a6)
	bra.s	LE8D8
;
LE920:
	move	-6(a6),d0
	blt.s	LE944
	move.l	-152(a6),-(sp)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LD9D2
	addq	#6,sp
LE944:
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-6(a6),d0
	bge.s	LE96A
	pea	L1B419
	jsr	L63E0
	addq	#4,sp
	bra	LE790
;
LE96A:
	clr	-156(a6)
LE96E:
	move.l	-152(a6),a0
	move	30(a0),d0
	blt.s	LE984
	move.l	-152(a6),a0
	cmpi	#4,30(a0)
	ble.s	LE98C
LE984:
	move.l	-152(a6),a0
	clr	30(a0)
LE98C:
	move.l	8(a6),a1
	move.l	-152(a6),a0
	move	30(a0),d0
	cmp	32(a1),d0
	blt.s	LE9AA
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	bne.s	LE9AE
LE9AA:
	moveq	#1,d0
	bra.s	LE9B0
;
LE9AE:
	clr	d0
LE9B0:
	move	d0,-158(a6)
	move	-156(a6),d0
	bne	LEA52
	move	-168(a6),d0
	beq	LEA52
	move.l	-152(a6),a0
	move	30(a0),d0
	beq	LEA52
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L46E44,-4(a6)
	addq	#1,-6(a6)
	move	-6(a6),d0
	cmp	-4(a6),d0
	blt.s	LE9FC
	moveq	#-1,d0
	move	d0,-6(a6)
	bra.s	LEA1A
;
LE9FC:
	move.l	-152(a6),-(sp)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LD9D2
	addq	#6,sp
LEA1A:
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-6(a6),d0
	bge.s	LEA38
	pea	L1B42A
	bra	LF3F2
;
LEA38:
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L6AF8
	addq	#6,sp
	move	d0,d0
	beq	LE96E
	bra	LF3FA
;
LEA52:
	move	-158(a6),-(sp)
	move.l	-152(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LE314
	adda	#$A,sp
	move	-158(a6),d0
	beq.s	LEA76
	pea	L1B461
	bra.s	LEA7C
;
LEA76:
	pea	L1B474
LEA7C:
	pea	L1B441
	jsr	L63E0
	addq	#8,sp
	clr	-154(a6)
LEA8E:
	move	-154(a6),d0
	bne	LE96E
	move	-4(a6),d0
	bgt.s	LEAA6
	pea	L1B475
	bra	LF3F2
;
LEAA6:
	moveq	#1,d0
	move	d0,-154(a6)
	pea	L1B499
	move.l	8(a6),-(sp)
	jsr	L6A98
	addq	#8,sp
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move.l	#L18450,a0
	move	#8,d1
	bra.s	LEAD6
;
LEAD4:
	addq	#4,a0
LEAD6:
	cmp	(a0)+,d0
	dbeq	d1,LEAD4
LEADC:
	move.l	(a0),a0
	jmp	(a0)
;
LEAE0:
	move	-154(a6),d0
	bne.s	LEA8E
	moveq	#7,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L662E
	addq	#6,sp
	bra.s	LEA8E
;
LEAF8:
	move	-158(a6),d0
	beq	LEB8A
	moveq	#1,d0
	move	d0,-(sp)
	pea	L1B4A2
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	cmpi	#1,d0
	bne.s	LEAE0
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move.l	-152(a6),-(sp)
	jsr	LD516
	addq	#4,sp
	jsr	LDB2E
	move	-6(a6),d0
	cmp	L46E44,d0
	blt.s	LEB56
	move	L46E44,d0
	subq	#1,d0
	move	d0,-6(a6)
LEB56:
	move.l	-152(a6),-(sp)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LD9D2
	addq	#6,sp
	clr	-156(a6)
LEB78:
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	bra	LEAE0
;
LEB8A:
	clr	-154(a6)
	bra	LEAE0
;
LEB92:
	move	-158(a6),d0
	beq.s	LEB8A
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-166(a6)
	pea	L1B4BC
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#-3,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-8(a6)
	cmpi	#$FFFF,d0
	beq	LEAE0
	move	-8(a6),d0
	subq	#1,d0
	cmpi	#$11,d0
	bhi	LEAE0
	lsl.w	#2,d0
	move	d0,a0
	adda.l	#L18408,a0
	bra	LEADC
;
LEBF4:
	pea	L1B4D1
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#20,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	jsr	L57B6
	addq	#4,sp
	cmpi	#1,d0
	blt	LEAE0
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	pea	L559C
	move.l	-166(a6),-(sp)
	jsr	LD36A
	addq	#8,sp
	move	d0,d0
	blt.s	LEC78
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	pea	L1B4DD
	jsr	L63E0
	addq	#4,sp
	bra.s	LECD8
;
LEC78:
	move.l	-152(a6),-(sp)
	jsr	LD516
	addq	#4,sp
	jsr	LDB2E
	move.l	-166(a6),-(sp)
	move.l	-152(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	moveq	#1,d0
	move	d0,-(sp)
	move.l	-152(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	move.l	-152(a6),-(sp)
	jsr	LD3F6
	addq	#4,sp
	move	d0,-6(a6)
	move	-6(a6),d0
	blt.s	LECC6
	jsr	LDB2E
LECC6:
	clr	-156(a6)
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
LECD8:
	move	-6(a6),d0
	bge	LEAE0
	move	-6(a6),-(sp)
	pea	L1B507
	jsr	L63E0
	addq	#6,sp
	bra	LF3FA
;
LECF6:
	move.l	L1AEAA,-(sp)
	pea	L1B548
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	moveq	#-2,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),a0
	cmpi.b	#$30,(a0)
	blt	LEAE0
	move.l	8(a6),a1
	move.l	-166(a6),a0
	move.b	(a0),d0
	ext.w	d0
	subi	#$30,d0
	cmp	32(a1),d0
	bgt	LEAE0
	move.l	-166(a6),a0
	move.b	(a0),d0
	ext.w	d0
	subi	#$30,d0
	move.l	-152(a6),a0
	move	d0,30(a0)
LED62:
	moveq	#1,d0
	move	d0,-156(a6)
	bra	LEAE0
;
LED6C:
	pea	L1B54C
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#20,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	move.l	-152(a6),a0
	pea	52(a0)
LEDA6:
	jsr	L11FEC
	addq	#8,sp
	bra.s	LED62
;
LEDB0:
	pea	L1B557
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#16,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	move.l	-152(a6),a0
	pea	72(a0)
	bra.s	LEDA6
;
LEDEC:
	pea	L1B55F
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#6,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	move.l	-152(a6),a0
	pea	88(a0)
	bra	LEDA6
;
LEE2A:
	pea	L1B568
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#12,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	move.l	-152(a6),a0
	pea	94(a0)
	bra	LEDA6
;
LEE68:
	pea	L1B573
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#14,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	move.l	-152(a6),a0
	pea	106(a0)
	bra	LEDA6
;
LEEA6:
	pea	L1B57C
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#10,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	move.l	-152(a6),a0
	pea	20(a0)
	bra	LEDA6
;
LEEE4:
	pea	L1B588
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#50,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	8(a6),a3
	move.l	8(a6),-(sp)
	jsr	LA6D8
	addq	#4,sp
	and	46(a3),d0
	move	d0,-2(a6)
	bne.s	LEF30
	addq	#1,-2(a6)
LEF30:
	move.l	-152(a6),a0
	move	-2(a6),44(a0)
	bra	LED62
;
LEF3E:
	move.l	8(a6),a0
	cmpi	#3,32(a0)
	ble.s	LEF50
	move	#$222,d0
	bra.s	LEF5E
;
LEF50:
	move.l	8(a6),a0
	move	36(a0),d0
	ext.l	d0
	divs	#$3C,d0
LEF5E:
	move	d0,-154(a6)
	move	-154(a6),-(sp)
	pea	L1B592
	jsr	L63E0
	addq	#6,sp
	clr	-(sp)
	moveq	#-4,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-8(a6)
	cmpi	#$FFFF,d0
	beq	LEAE0
	move	-8(a6),d0
	ble.s	LEFA8
	move	-8(a6),d0
	cmp	-154(a6),d0
	ble.s	LEFAE
LEFA8:
	move	-154(a6),-8(a6)
LEFAE:
	move	-8(a6),d0
	muls	#$3C,d0
	move.l	-152(a6),a0
	move	d0,34(a0)
	move.l	-152(a6),a0
	move	d0,32(a0)
	bra	LED62
;
LEFCA:
	pea	L1B59F
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	jsr	L12092
	addq	#4,sp
	move.l	-152(a6),a0
	move	d0,42(a0)
	bra	LED62
;
LF010:
	pea	L1B5AF
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	jsr	L12092
	addq	#4,sp
	move.l	-152(a6),a0
	move	d0,120(a0)
	bra	LED62
;
LF056:
	pea	L1B5C0
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#-3,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-8(a6)
	cmpi	#$FFFF,d0
	beq	LEAE0
	cmpi	#1,-8(a6)
	blt	LEAE0
	cmpi	#$10,-8(a6)
	bgt	LEAE0
	move	-8(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a1
	adda.l	d0,a1
	move.l	-152(a6),a0
	move	44(a0),d0
	and	(a1),d0
	beq	LEAE0
	move	-8(a6),d0
	subq	#1,d0
	move.l	-152(a6),a0
	move	d0,46(a0)
	bra	LED62
;
LF0CE:
	pea	L1B5CF
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	jsr	L12092
	addq	#4,sp
	move.l	-152(a6),a0
	move	d0,48(a0)
	bra	LED62
;
LF114:
	pea	L1B5E4
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	jsr	L12092
	addq	#4,sp
	move.l	-152(a6),a0
	move	d0,50(a0)
	bra	LED62
;
LF15A:
	pea	L1B5FB
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	-166(a6),-(sp)
	jsr	L12092
	addq	#4,sp
	move.l	-152(a6),a0
	move	d0,40(a0)
	bra	LED62
;
LF1A0:
	pea	L1B60E
	jsr	L63E0
	addq	#4,sp
	move.l	-152(a6),a0
	clr	38(a0)
	move.l	-152(a6),a0
	clr	36(a0)
	bra	LED62
;
LF1C2:
	pea	L1B623
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#50,d0
	move	d0,-(sp)
	move.l	-166(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LEAE0
	move.l	8(a6),-(sp)
	jsr	LA6D8
	addq	#4,sp
	move.l	-152(a6),a0
	move	d0,122(a0)
	bra	LED62
;
LF208:
	pea	L1B630
	jsr	L63E0
	addq	#4,sp
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move	-156(a6),d0
	beq.s	LF26C
	pea	L559C
	move.l	-152(a6),-(sp)
	jsr	LD36A
	addq	#8,sp
	move	d0,-6(a6)
	blt.s	LF26C
	move.l	-152(a6),-(sp)
	jsr	LE6F0
	addq	#4,sp
	move.l	-152(a6),-(sp)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LDA68
	addq	#6,sp
LF26C:
	clr	-156(a6)
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-6(a6),d0
	blt	LF3EE
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L46E44,-4(a6)
	addq	#1,-6(a6)
	move	-6(a6),d0
	cmp	-4(a6),d0
	blt.s	LF2B4
	move	-4(a6),d0
	subq	#1,d0
	move	d0,-6(a6)
LF2B4:
	move.l	-152(a6),-(sp)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LD9D2
	addq	#6,sp
	bra	LEB78
;
LF2D6:
	pea	L1B635
	jsr	L63E0
	addq	#4,sp
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move	-156(a6),d0
	beq.s	LF33A
	pea	L559C
	move.l	-152(a6),-(sp)
	jsr	LD36A
	addq	#8,sp
	move	d0,-6(a6)
	blt.s	LF33A
	move.l	-152(a6),-(sp)
	jsr	LE6F0
	addq	#4,sp
	move.l	-152(a6),-(sp)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LDA68
	addq	#6,sp
LF33A:
	clr	-156(a6)
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-6(a6),d0
	blt	LF3EE
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move	-6(a6),d0
	ble	LF2B4
	subq	#1,-6(a6)
	bra	LF2B4
;
LF372:
	pea	L1B63E
	jsr	L63E0
	addq	#4,sp
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move	-156(a6),d0
	beq.s	LF3D6
	pea	L559C
	move.l	-152(a6),-(sp)
	jsr	LD36A
	addq	#8,sp
	move	d0,-6(a6)
	blt.s	LF3D6
	move.l	-152(a6),-(sp)
	jsr	LE6F0
	addq	#4,sp
	move.l	-152(a6),-(sp)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LDA68
	addq	#6,sp
LF3D6:
	clr	-156(a6)
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-6(a6),d0
	bge.s	LF3FA
LF3EE:
	move.l	-162(a6),-(sp)
LF3F2:
	jsr	L63E0
	addq	#4,sp
LF3FA:
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LF400:
	link	a6,#-6
	move.l	8(a6),a0
	move	(a0),-2(a6)
	beq	LF68C
	addi	#$A,-2(a6)
	move.l	8(a6),d0
	addq.l	#2,d0
	move.l	d0,-6(a6)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	-6(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	pea	L1B643
	move	-2(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	move.l	-6(a6),-(sp)
	pea	L1B647
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	move.l	-6(a6),a0
	move	30(a0),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18808,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	pea	L1B654
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	move.l	-6(a6),a0
	pea	52(a0)
	pea	L1B662
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	move.l	-6(a6),a0
	pea	72(a0)
	pea	L1B671
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	move.l	-6(a6),a0
	pea	88(a0)
	pea	L1B67E
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	move.l	-6(a6),a0
	pea	94(a0)
	pea	L1B68C
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	move.l	-6(a6),a0
	pea	106(a0)
	pea	L1B69B
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	move.l	-6(a6),a0
	pea	20(a0)
	pea	L1B6A9
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	clr	-(sp)
	clr	-(sp)
	move.l	-6(a6),a0
	move	44(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA492
	adda	#$A,sp
	move.l	8(a6),a0
	pea	2638(a0)
	pea	L1B6BF
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	move.l	-6(a6),a0
	move	34(a0),-(sp)
	pea	L1B6CE
	move	-2(a6),-(sp)
	jsr	L64FC
	addq	#8,sp
	move.l	-6(a6),a0
	move	42(a0),-(sp)
	pea	L1B6E3
	move	-2(a6),-(sp)
	jsr	L64FC
	addq	#8,sp
	move.l	-6(a6),a0
	move	120(a0),-(sp)
	pea	L1B6F8
	move	-2(a6),-(sp)
	jsr	L64FC
	addq	#8,sp
	move.l	-6(a6),a0
	move	46(a0),d0
	ext.l	d0
	lsl.l	#5,d0
	addi.l	#$4691E,d0
	move.l	d0,-(sp)
	move.l	-6(a6),a0
	move	46(a0),d0
	addq	#1,d0
	move	d0,-(sp)
	pea	L1B70D
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$C,sp
	move.l	-6(a6),a0
	move	48(a0),-(sp)
	pea	L1B725
	move	-2(a6),-(sp)
	jsr	L64FC
	addq	#8,sp
	move.l	-6(a6),a0
	move	50(a0),-(sp)
	pea	L1B736
	move	-2(a6),-(sp)
	jsr	L64FC
	addq	#8,sp
	move.l	-6(a6),a0
	move	40(a0),-(sp)
	pea	L1B749
	move	-2(a6),-(sp)
	jsr	L64FC
	addq	#8,sp
	move.l	-6(a6),a0
	move	38(a0),-(sp)
	move.l	-6(a6),a0
	move	36(a0),-(sp)
	pea	L1B75E
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	clr	-(sp)
	clr	-(sp)
	move.l	-6(a6),a0
	move	122(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA492
	adda	#$A,sp
	move.l	8(a6),a0
	pea	2638(a0)
	pea	L1B773
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
LF68C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LF690:
	link	a6,#-152
	lea	-148(a6),a0
	move.l	a0,-152(a6)
	pea	L1B786
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#20,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	LF904
	move.l	8(a6),a0
	move.b	2638(a0),d0
	bne.s	LF6DC
	moveq	#1,d0
	bra.s	LF6DE
;
LF6DC:
	clr	d0
LF6DE:
	move	d0,-8(a6)
	clr	-6(a6)
	clr	-2(a6)
	move	-8(a6),d0
	bne.s	LF76E
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	pea	L55EC
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	LD36A
	addq	#8,sp
	move	d0,-2(a6)
LF718:
	move	-2(a6),d0
	ble.s	LF760
	move.l	-152(a6),-(sp)
	move	-2(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LD9D2
	addq	#6,sp
	move	d0,d0
	bne.s	LF760
	move.l	-152(a6),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L55EC
	addq	#8,sp
	move	d0,d0
	bne.s	LF760
	subq	#1,-2(a6)
	bra.s	LF718
;
LF760:
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
LF76E:
	pea	L1B7AE
	jsr	L63E0
	addq	#4,sp
	pea	L1B7FF
	jsr	L63E0
	addq	#4,sp
LF78A:
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L46E44,-4(a6)
	move.l	-152(a6),-(sp)
	move	-2(a6),d0
	addq	#1,-2(a6)
	ext.l	d0
	lsl.l	#1,d0
	lea	L46E46,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	jsr	LD9D2
	addq	#6,sp
	move	-2(a6),d0
	cmp	-4(a6),d0
	ble.s	LF7D2
	moveq	#-1,d0
	move	d0,-2(a6)
LF7D2:
	move	-8(a6),d0
	bne.s	LF7F6
	move.l	-152(a6),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L55EC
	addq	#8,sp
	move	d0,d0
	beq.s	LF7F6
	moveq	#-1,d0
	move	d0,-2(a6)
LF7F6:
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	blt	LF8F2
	moveq	#1,d0
	move	d0,-(sp)
	move.l	-152(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	moveq	#1,d0
	move	d0,-(sp)
	move.l	-152(a6),a0
	pea	72(a0)
	jsr	L5BB4
	addq	#6,sp
	clr	-(sp)
	move.l	-152(a6),a0
	pea	88(a0)
	jsr	L5BB4
	addq	#6,sp
	move.l	-152(a6),-(sp)
	pea	L1B850
	jsr	L63E0
	addq	#8,sp
	move.l	-152(a6),a0
	move	30(a0),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18808,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	pea	L1B857
	jsr	L63E0
	addq	#8,sp
	move.l	-152(a6),a0
	pea	72(a0)
	pea	L1B85D
	jsr	L63E0
	addq	#8,sp
	move.l	-152(a6),a0
	pea	88(a0)
	pea	L1B863
	jsr	L63E0
	addq	#8,sp
	move.l	-152(a6),a0
	move	38(a0),-(sp)
	move.l	-152(a6),a0
	move	36(a0),-(sp)
	pea	L1B868
	jsr	L63E0
	addq	#8,sp
	move.l	-152(a6),a0
	move	40(a0),-(sp)
	pea	L1B86F
	jsr	L63E0
	addq	#6,sp
	addq	#1,-6(a6)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L6AF8
	addq	#6,sp
	move	d0,d0
	beq	LF78A
LF8F2:
	move	-6(a6),-(sp)
	pea	L1B873
	jsr	L63E0
	addq	#6,sp
LF904:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LF908:
	link	a6,#0
	move.l	12(a6),-(sp)
	move.l	8(a6),a0
	pea	2(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	LF928
	moveq	#1,d0
	bra.s	LF92A
;
LF928:
	clr	d0
LF92A:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LF92E:
	link	a6,#0
	moveq	#15,d0
	move	d0,-(sp)
	move.l	12(a6),-(sp)
	move.l	8(a6),a0
	pea	2612(a0)
	jsr	L12008
	adda	#$A,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LF950:
	link	a6,#0
	move	12(a6),d0
	bne.s	LF95E
	addq	#1,12(a6)
LF95E:
	jsr	L10618
	ext.l	d0
	divs	12(a6),d0
	swap	d0
	addq	#1,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LF972:
	link	a6,#-4
	move.l	a3,-(sp)
	move.l	8(a6),a3
	jsr	L6944
	cmp	38(a3),d0
	bne.s	LF98C
	moveq	#1,d0
	bra.s	LF98E
;
LF98C:
	clr	d0
LF98E:
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LF994:
	link	a6,#0
	move	12(a6),d0
	ble.s	LF9B6
	cmpi	#$222,12(a6)
	bge.s	LF9B6
	move	12(a6),d0
	muls	#$3C,d0
	move.l	8(a6),a0
	move	d0,34(a0)
LF9B6:
	move.l	8(a6),a0
	move	34(a0),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LF9C2:
	link	a6,#0
	move	12(a6),d0
	muls	#$3C,d0
	move	d0,12(a6)
	move.l	8(a6),a0
	move	34(a0),d0
	add	12(a6),d0
	ble.s	LF9EC
	move.l	8(a6),a0
	move	12(a6),d0
	add	d0,34(a0)
LF9EC:
	move.l	8(a6),a0
	move	34(a0),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LF9F8:
	link	a6,#0
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LC7B2
	addq	#6,sp
	move	d0,d0
	bne.s	LFA30
	move	12(a6),-(sp)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L1BA1C
	jsr	L6526
	adda	#$A,sp
	clr	d0
	bra.s	LFA32
;
LFA30:
	moveq	#1,d0
LFA32:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFA36:
	link	a6,#-8
	move.l	12(a6),-(sp)
	pea	L1BA41
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	pea	-6(a6)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-8(a6)
	pea	L1BA44
	jsr	L63E0
	addq	#4,sp
	move	-8(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFA7E:
	link	a6,#0
	move.l	8(a6),a0
	move	32(a0),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFA8E:
	link	a6,#-2
	clr	-(sp)
	move.l	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L8290
	adda	#$A,sp
	move	d0,-2(a6)
	pea	L1BA46
	jsr	L63E0
	addq	#4,sp
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFAC0:
	link	a6,#-2
	move.l	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L802A
	addq	#8,sp
	move	d0,-2(a6)
	pea	L1BA48
	jsr	L63E0
	addq	#4,sp
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFAEE:
	link	a6,#0
	move.l	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L995E
	addq	#8,sp
	pea	L1BA4A
	jsr	L63E0
	addq	#4,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFB14:
	link	a6,#-2
	move	#$2580,-2(a6)
	move.l	8(a6),a0
	move	(a0),d0
	beq.s	LFB6A
	move.l	8(a6),a0
	move	2966(a0),d0
	andi	#$E0,d0
	move.l	#L18486,a0
	move	#4,d1
	bra.s	LFB40
;
LFB3E:
	addq	#4,a0
LFB40:
	cmp	(a0)+,d0
	dbeq	d1,LFB3E
	move.l	(a0),a0
	jmp	(a0)
;
LFB4A:
	bra.s	LFB6A
;
LFB4C:
	move	#$12C,-2(a6)
	bra.s	LFB6A
;
LFB54:
	move	#$4B0,-2(a6)
	bra.s	LFB6A
;
LFB5C:
	move	#$960,-2(a6)
	bra.s	LFB6A
;
LFB64:
	move	#$2580,-2(a6)
LFB6A:
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFB72:
	link	a6,#-4
	move.l	12(a6),-4(a6)
	pea	-4(a6)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	sys_diskfree_func
	adda	#$A,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFB96:
	link	a6,#0
	cmpi	#1,12(a6)
	blt.s	LFBC8
	cmpi	#$10,12(a6)
	bgt.s	LFBC8
	move	12(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a1
	adda.l	d0,a1
	move.l	8(a6),a0
	move	124(a0),d0
	and	(a1),d0
	bne.s	LFBCC
LFBC8:
	clr	d0
	bra.s	LFBCE
;
LFBCC:
	moveq	#1,d0
LFBCE:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFBD2:
	link	a6,#0
	cmpi	#1,12(a6)
	blt.s	LFC02
	cmpi	#$10,12(a6)
	bgt.s	LFC02
	move	12(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	move.l	8(a6),a0
	or	d0,124(a0)
LFC02:
	move.l	8(a6),a0
	move	124(a0),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFC0E:
	link	a6,#0
	cmpi	#1,12(a6)
	blt.s	LFC40
	cmpi	#$10,12(a6)
	bgt.s	LFC40
	move	12(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	not	d0
	move.l	8(a6),a0
	and	d0,124(a0)
LFC40:
	move.l	8(a6),a0
	move	124(a0),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFC4C:
	link	a6,#0
	cmpi	#1,12(a6)
	blt.s	LFC7E
	cmpi	#$10,12(a6)
	bgt.s	LFC7E
	move	12(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a1
	adda.l	d0,a1
	move.l	8(a6),a0
	move	46(a0),d0
	and	(a1),d0
	bne.s	LFC82
LFC7E:
	clr	d0
	bra.s	LFC84
;
LFC82:
	moveq	#1,d0
LFC84:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFC88:
	link	a6,#0
	cmpi	#1,12(a6)
	blt.s	LFCB8
	cmpi	#$10,12(a6)
	bgt.s	LFCB8
	move	12(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	move.l	8(a6),a0
	or	d0,46(a0)
LFCB8:
	move.l	8(a6),a0
	move	46(a0),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFCC4:
	link	a6,#0
	cmpi	#1,12(a6)
	blt.s	LFCF6
	cmpi	#$10,12(a6)
	bgt.s	LFCF6
	move	12(a6),d0
	subq	#1,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	(a0),d0
	not	d0
	move.l	8(a6),a0
	and	d0,46(a0)
LFCF6:
	move.l	8(a6),a0
	move	46(a0),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFD02:
	link	a6,#0
	clr	-(sp)
	move.l	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L10444
	adda	#$A,sp
	move	d0,d0
	bge.s	LFD34
	move.l	12(a6),-(sp)
	pea	L1BA4C
	jsr	L6526
	addq	#8,sp
	clr	d0
	bra.s	LFD36
;
LFD34:
	moveq	#1,d0
LFD36:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFD3A:
	link	a6,#0
	move.l	12(a6),-(sp)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L1BA60
	jsr	L6526
	adda	#$C,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFD5E:
	link	a6,#-2
	move.l	12(a6),-(sp)
	pea	L1BA68
	jsr	L63E0
	addq	#8,sp
	move.l	8(a6),-(sp)
	jsr	L7050
	addq	#4,sp
	move.l	8(a6),-(sp)
	jsr	L6F7A
	addq	#4,sp
	move	d0,-2(a6)
	pea	L1BA6C
	jsr	L63E0
	addq	#4,sp
	cmpi	#$1B,-2(a6)
	beq.s	LFDAE
	cmpi	#3,-2(a6)
	bne.s	LFDB2
LFDAE:
	moveq	#1,d0
	bra.s	LFDB4
;
LFDB2:
	clr	d0
LFDB4:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFDB8:
	link	a6,#0
	move	12(a6),-(sp)
	jsr	L5522
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFDCC:
	link	a6,#0
	move	12(a6),-(sp)
	jsr	L54FC
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFDE0:
	link	a6,#-6
	clr	-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	andi	#$1F,d0
	lsl.w	#8,d0
	lsl.w	#3,d0
	move	d0,-4(a6)
	clr	-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	andi	#$3F,d0
	lsl.w	#5,d0
	add	d0,-4(a6)
	clr	-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	andi	#$1F,d0
	lsl.w	#8,d0
	lsl.w	#3,d0
	move	d0,-2(a6)
	clr	-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	andi	#$3F,d0
	lsl.w	#5,d0
	add	d0,-2(a6)
	jsr	L6988
	move	d0,-6(a6)
	move	-6(a6),d0
	cmp	-4(a6),d0
	bcs.s	LFE66
	move	-6(a6),d0
	cmp	-2(a6),d0
	bls.s	LFE6A
LFE66:
	clr	d0
	bra.s	LFE6C
;
LFE6A:
	moveq	#1,d0
LFE6C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFE70:
	link	a6,#-6
	moveq	#1,d0
	move	d0,-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	andi	#$F,d0
	lsl.w	#5,d0
	move	d0,-2(a6)
	moveq	#1,d0
	move	d0,-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	andi	#$1F,d0
	add	d0,-2(a6)
	moveq	#80,d0
	move	d0,-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	move	d0,-6(a6)
	cmpi	#80,-6(a6)
	bge.s	LFECC
	move	-6(a6),d0
	addi	#$7D0,d0
	bra.s	LFED4
;
LFECC:
	move	-6(a6),d0
	addi	#$76C,d0
LFED4:
	move	d0,-6(a6)
	move	-6(a6),d0
	subi	#$7BC,d0
	andi	#$7F,d0
	lsl.w	#8,d0
	lsl.w	#1,d0
	add	d0,-2(a6)
	move.l	8(a6),a0
	move	-2(a6),d0
	cmp	38(a0),d0
	bcc.s	LFEFE
LFEFA:
	clr	d0
	bra.s	LFF4E
;
LFEFE:
	clr	-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	andi	#$1F,d0
	lsl.w	#8,d0
	lsl.w	#3,d0
	move	d0,-4(a6)
	clr	-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	andi	#$3F,d0
	lsl.w	#5,d0
	add	d0,-4(a6)
	move.l	8(a6),a0
	move	-2(a6),d0
	cmp	38(a0),d0
	bne.s	LFF4C
	move.l	8(a6),a0
	move	-4(a6),d0
	cmp	40(a0),d0
	bcs.s	LFEFA
LFF4C:
	moveq	#1,d0
LFF4E:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFF52:
	link	a6,#-4
	moveq	#1,d0
	move	d0,-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	andi	#$F,d0
	lsl.w	#5,d0
	move	d0,-2(a6)
	moveq	#1,d0
	move	d0,-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	andi	#$1F,d0
	add	d0,-2(a6)
	moveq	#80,d0
	move	d0,-(sp)
	pea	12(a6)
	jsr	L6B48
	addq	#6,sp
	move	d0,-4(a6)
	cmpi	#80,-4(a6)
	bge.s	LFFAE
	move	-4(a6),d0
	addi	#$7D0,d0
	bra.s	LFFB6
;
LFFAE:
	move	-4(a6),d0
	addi	#$76C,d0
LFFB6:
	move	d0,-4(a6)
	move	-4(a6),d0
	subi	#$7BC,d0
	andi	#$7F,d0
	lsl.w	#8,d0
	lsl.w	#1,d0
	add	d0,-2(a6)
	jsr	L6944
	cmp	-2(a6),d0
	beq.s	LFFDE
	clr	d0
	bra.s	LFFE0
;
LFFDE:
	moveq	#1,d0
LFFE0:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
LFFE4:
	link	a6,#-4
LFFE8:
	moveq	#1,d0
	move	d0,-2(a6)
LFFEE:
	move	-2(a6),d0
	beq.s	L10004
	move.l	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L54AA
	addq	#8,sp
L10004:
	clr	-2(a6)
	move.l	8(a6),-(sp)
	jsr	L6F7A
	addq	#4,sp
	move	d0,-4(a6)
	cmpi	#$D,-4(a6)
	bne.s	L10026
	moveq	#63,d0
	move	d0,-4(a6)
L10026:
	move.l	8(a6),-(sp)
	jsr	L53CC
	addq	#4,sp
	move	d0,d0
	bne.s	LFFE8
	move	-4(a6),-(sp)
	move.l	16(a6),-(sp)
	jsr	L10514
	addq	#6,sp
	move	d0,d0
	bne.s	L1005C
	moveq	#7,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L662E
	addq	#6,sp
	bra.s	LFFEE
;
L1005C:
	move	-4(a6),-(sp)
	jsr	L5522
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1006C:
	link	a6,#0
	move.l	16(a6),-(sp)
	pea	L1BA6E
	move.l	12(a6),-(sp)
	jsr	L6666
	adda	#$C,sp
	clr	d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1008E:
	link	a6,#-2
L10092:
	move.l	8(a6),-(sp)
	jsr	L6F7A
	addq	#4,sp
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move	d0,-2(a6)
	move.l	8(a6),-(sp)
	jsr	L53CC
	addq	#4,sp
	move	d0,d0
	beq.s	L100C2
	clr	-2(a6)
	bra.s	L100E8
;
L100C2:
	move	-2(a6),-(sp)
	move.l	12(a6),-(sp)
	jsr	L10514
	addq	#6,sp
	move	d0,d0
	bne.s	L100E8
	moveq	#7,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L662E
	addq	#6,sp
	bra.s	L10092
;
L100E8:
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L100F0:
	link	a6,#-2
	move.l	8(a6),a0
	move	2996(a0),-2(a6)
	ble.s	L1010C
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
L1010C:
	move.l	12(a6),a0
	move.b	(a0),d0
	bne.s	L10120
	move.l	8(a6),a0
	moveq	#-1,d0
	move	d0,2996(a0)
	bra.s	L1014A
;
L10120:
	clr	-(sp)
	move.l	12(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move.l	8(a6),a0
	move	d0,2996(a0)
	bge.s	L1014A
	move.l	12(a6),-(sp)
	pea	L1BA72
	jsr	L1067E
	addq	#8,sp
L1014A:
	move.l	12(a6),-(sp)
	move.l	8(a6),a0
	pea	3002(a0)
	jsr	L11FEC
	addq	#8,sp
	move.l	8(a6),a0
	clr.l	2998(a0)
	move.l	8(a6),a0
	move	2996(a0),d0
	ble.s	L10180
	move.l	8(a6),a0
	move	2996(a0),-(sp)
	jsr	L4A4C
	addq	#2,sp
L10180:
	move.l	8(a6),a0
	clr	3082(a0)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1018C:
	link	a6,#-16
	move.l	8(a6),a0
	move	2996(a0),d0
	bge.s	.L101A8
	pea	L1BA8D
	jsr	L1067E
	addq	#4,sp
.L101A8:
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	move.l	12(a6),-12(a6)
	move.l	-12(a6),a0
	clr.b	(a0)
	clr	-6(a6)
	clr	-4(a6)
	move.l	8(a6),d0
	addi.l	#$C0A,d0
	move.l	d0,-16(a6)
.L101D8:
	cmpi	#$4F,-6(a6)
	bge	.L1032A
	cmpi	#$FFFF,-4(a6)
	beq	.L1032A
	move.l	-16(a6),a0
	move	(a0),d0
	bgt	.L10294
	clr	-(sp)
	move.l	8(a6),a0
	pea	3002(a0)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-2(a6)
	move	-2(a6),d0
	ble.s	.L1028E
	move.l	8(a6),a0
	move.l	2998(a0),d0
	bge.s	.L10224
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	bra.s	.L1022E
;
.L10224:
	clr	-(sp)
	move.l	8(a6),a0
	move.l	2998(a0),-(sp)
.L1022E:
	move	-2(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	#$200,-(sp)
	move.l	-16(a6),d0
	addq.l	#6,d0
	move.l	-16(a6),a0
	move.l	d0,2(a0)
	move.l	d0,-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move.l	-16(a6),a0
	move	d0,(a0)
	moveq	#1,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	8(a6),a0
	move.l	d0,2998(a0)
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move.l	-16(a6),a0
	move	(a0),d0
	bgt.s	.L10294
.L1028E:
	moveq	#-1,d0
	move	d0,-4(a6)
.L10294:
	move.l	-16(a6),a0
	move.l	2(a0),a0
	move.b	(a0),d0
	ext.w	d0
.L102A0:
	andi	#$7F,d0			;patch ext1ld_limit here
	move	d0,-8(a6)
	move.l	-16(a6),a0
	addq.l	#1,2(a0)
	move.l	-16(a6),a0
	subq	#1,(a0)
	cmpi	#$1A,-8(a6)
	bne.s	.L102D0
	move.l	-16(a6),a0
	clr	(a0)
	move.l	8(a6),a0
	moveq	#-1,d0
	move.l	d0,2998(a0)
	bra.s	.L1032A
;
.L102D0:
	cmpi	#CR,-8(a6)
	beq	.L101D8
	cmpi	#HT,-8(a6)
	bne.s	.L102FC
.L102E2:
	move.l	-12(a6),a0
	addq.l	#1,-12(a6)
	moveq	#32,d0
	move.b	d0,(a0)
	addq	#1,-6(a6)
	move	-6(a6),d0
	andi	#7,d0
	bne.s	.L102E2
.L102FC:
	cmpi	#LF,-8(a6)
	bne.s	.L1030A
	addq	#1,-6(a6)
	bra.s	.L1032A
;
.L1030A:
	cmpi	#$20,-8(a6)
	blt	.L101D8
	addq	#1,-6(a6)
	move.l	-12(a6),a0
	addq.l	#1,-12(a6)
	move	-8(a6),d0
	move.b	d0,(a0)
	bra	.L101D8
;
.L1032A:
	move.l	-12(a6),a0
	clr.b	(a0)
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	cmpi	#$FFFF,-4(a6)
	bne.s	.L1034A
	moveq	#-1,d0
	bra.s	.L10356
;
.L1034A:
	move.l	12(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
.L10356:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1035A:
	link	a6,#-2
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-(sp)
	move.l	12(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-2(a6)
	ble.s	L1038C
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
L1038C:
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	ble.s	L103A4
	moveq	#1,d0
	bra.s	L103A6
;
L103A4:
	clr	d0
L103A6:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L103AA:
	link	a6,#0
	move.l	12(a6),-(sp)
	jsr	task_Fdelete
	addq	#4,sp
	move	d0,d0
	bne.s	L103C2
	moveq	#1,d0
	bra.s	L103C4
;
L103C2:
	clr	d0
L103C4:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L103C8:
	link	a6,#0
	jsr	L6944
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L103D6:
	link	a6,#-4
	move.l	d3,-(sp)
	move	14(a6),-(sp)
	jsr	L6C48
	addq	#2,sp
	move.l	d0,d3
	move	12(a6),-(sp)
	jsr	L6C48
	addq	#2,sp
	sub.l	d3,d0
	move.l	(sp)+,d3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L103FE:
	link	a6,#-2
	move	L46E42,-(sp)
	jsr	L3976
	addq	#2,sp
	pea	L559C
	move.l	12(a6),-(sp)
	jsr	LD36A
	addq	#8,sp
	move	d0,-2(a6)
	move	L46E42,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	blt.s	L1043E
	moveq	#1,d0
	bra.s	L10440
;
L1043E:
	clr	d0
L10440:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L10444:
	link	a6,#-10
	move.l	8(a6),a0
	move	(a0),-8(a6)
	clr	-(sp)
	move.l	12(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-2(a6)
	bge.s	L1046A
	moveq	#-1,d0
	bra	L10510
;
L1046A:
	clr	-6(a6)
L1046E:
	move	-6(a6),d0
	bne.s	L104F0
	move	#$100,-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move	d0,-4(a6)
	ble.s	L104F0
	move	-4(a6),-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move	-8(a6),-(sp)
	jsr	L6D80
	addq	#8,sp
L104AA:
	move	-6(a6),d0
	bne.s	L1046E
	move	-8(a6),-(sp)
	jsr	L6D46
	addq	#2,sp
	move	d0,d0
	bne.s	L1046E
	move	16(a6),d0
	beq.s	L104E8
	move.l	8(a6),-(sp)
	jsr	L6F3A
	addq	#4,sp
	move	d0,-10(a6)
	cmpi	#3,d0
	beq.s	L104E4
	cmpi	#$1B,-10(a6)
	bne.s	L104E8
L104E4:
	moveq	#1,d0
	bra.s	L104EA
;
L104E8:
	clr	d0
L104EA:
	move	d0,-6(a6)
	bra.s	L104AA
;
L104F0:
	move	-6(a6),d0
	beq.s	L10502
	move.l	8(a6),-(sp)
	jsr	L7050
	addq	#4,sp
L10502:
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	moveq	#1,d0
L10510:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L10514:
	link	a6,#0
	move	12(a6),-(sp)
	jsr	L5522
	addq	#2,sp
	move	d0,12(a6)
L10528:
	move.l	8(a6),a0
	move.b	(a0),d0
	beq.s	L10552
	move.l	8(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	cmp	12(a6),d0
	bne.s	L1054C
	moveq	#1,d0
	bra.s	L10554
;
L1054C:
	addq.l	#1,8(a6)
	bra.s	L10528
;
L10552:
	clr	d0
L10554:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L10558:
	link	a6,#-26
	move.l	12(a6),-(sp)
	move.b	L46B26,d0
	ext.w	d0
	addi	#$41,d0
	move	d0,-(sp)
	pea	L1BAA1
	pea	-26(a6)
	jsr	L16E2A
	adda	#$E,sp
	pea	-26(a6)
	jsr	L1219C
	addq	#4,sp
	move.l	8(a6),a0
	move	(a0),d0
	ext.l	d0
	lsl.l	#6,d0
	addi.l	#$2BFA6,d0
	move.l	d0,-(sp)
	jsr	L176
	addq	#4,sp
	move	d0,d0
	beq.s	L105B0
L105AC:
	moveq	#1,d0
	bra.s	L105C8
;
L105B0:
	pea	-26(a6)
	jsr	L10796
	addq	#4,sp
	move	d0,d0
	bne.s	L105AC
	jsr	L10E18
	clr	d0
L105C8:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L105CC:
	link	a6,#-20
	move.b	L46B26,d0
	ext.w	d0
	addi	#$41,d0
	move	d0,-(sp)
	pea	L1BAB0
	pea	-20(a6)
	jsr	L16E2A
	adda	#$A,sp
	clr	-(sp)
	pea	-20(a6)
	move.l	8(a6),-(sp)
	jsr	L10444
	adda	#$A,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1060A:
	link	a6,#0
	jsr	L24C
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L10618:
	link	a6,#-4
	move.l	d3,-(sp)
	move.l	L1BA18,d0
	bne.s	L1064E
	jsr	L6988
	move	d0,d3
	jsr	L6944
	move	L18640,d2
	swap	d0
	clr	d0
	swap	d0
	lsl.l	d2,d0
	move	d3,-(sp)
	clr	-(sp)
	add.l	(sp)+,d0
	move.l	d0,L1BA18
L1064E:
	pea	$BB40E62D.l
	move.l	L1BA18,-(sp)
	jsr	L1815A
	addq	#8,sp
	addq.l	#1,d0
	move.l	d0,L1BA18
	move.l	L1BA18,d0
	asr.l	#8,d0
	andi.l	#$7FFF,d0
	move.l	(sp)+,d3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1067E:
	link	a6,#0
	pea	L1BAC4
	jsr	L63E0
	addq	#4,sp
	move	20(a6),-(sp)
	move	18(a6),-(sp)
	move	16(a6),-(sp)
	move	14(a6),-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L63E0
	adda	#$E,sp
	move	L3E74E,d0
	muls	#80,d0
	addi.l	#$315FC,d0
	move.l	d0,-(sp)
	pea	L1BAD9
	jsr	L63E0
	addq	#8,sp
	moveq	#-1,d0
	move	d0,-(sp)
	move	L3E74E,d0
	ext.l	d0
	lsl.l	#6,d0
	addi.l	#$2BFA6,d0
	move.l	d0,-(sp)
	jsr	L188
	addq	#6,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L106F4:
	link	a6,#0
	move	8(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E75A,a1
	adda.l	d0,a1
	move	8(a6),d0
	ext.l	d0
	lsl.l	#6,d0
	lea	L4680A,a0
	adda.l	d0,a0
	cmp.l	(a1),a0
	bhi.s	L1072A
	pea	L1BAE2
	jsr	L1067E
	addq	#4,sp
L1072A:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E75A,a1
	adda.l	d0,a1
	move.l	(a1),a0
	addq.l	#2,(a1)
	move	10(a6),(a0)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L10746:
	link	a6,#0
	move	8(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E75A,a1
	adda.l	d0,a1
	move	8(a6),d0
	ext.l	d0
	lsl.l	#6,d0
	lea	L467CA,a0
	adda.l	d0,a0
	cmp.l	(a1),a0
	bne.s	L1077C
	pea	L1BAF1
	jsr	L1067E
	addq	#4,sp
L1077C:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E75A,a1
	adda.l	d0,a1
	subq.l	#2,(a1)
	move.l	(a1),a0
	move	(a0),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L10796:
	link	a6,#-24
	movem.l	d3-d3/a5-a5,(sp)
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-2(a6)
	bge.s	L107B8
	moveq	#1,d0
	bra	L10A40
;
L107B8:
	move.l	8(a6),-(sp)
	move	L3E74E,d0
	move	d0,-4(a6)
	muls	#80,d0
	addi.l	#$315FC,d0
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
	move	-4(a6),d0
	muls	#$A,d0
	addi.l	#$2C0BC,d0
	move.l	d0,-16(a6)
	moveq	#10,d0
	move	d0,-(sp)
	move.l	-16(a6),-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	cmpi	#$A,d0
	beq.s	L10820
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	pea	L1BB01
	jsr	L1067E
	addq	#4,sp
L10820:
	move.l	-16(a6),a0
	cmpi.b	#$4D,(a0)
	bne.s	L1089E
	move.l	-16(a6),a0
	cmpi.b	#$43,1(a0)
	bne.s	L1089E
	move.l	-16(a6),a0
	cmpi.b	#$4C,2(a0)
	bne.s	L1089E
	move.l	-16(a6),a0
	cmpi.b	#$33,3(a0)
	bne.s	L1089E
	move.l	-16(a6),a0
	move	6(a0),-(sp)
	jsr	L1DC
	addq	#2,sp
	move.l	-16(a6),a0
	move	d0,6(a0)
	blt.s	L1089E
	move.l	-16(a6),a0
	cmpi	#$800,6(a0)
	bge.s	L1089E
	move.l	-16(a6),a0
	move	8(a0),-(sp)
	jsr	L1DC
	addq	#2,sp
	move.l	-16(a6),a0
	move	d0,8(a0)
	cmpi	#1,d0
	blt.s	L1089E
	move.l	-16(a6),a0
	cmpi	#$100,8(a0)
	blt.s	L108B8
L1089E:
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	pea	L1BB19
	jsr	L1067E
	addq	#4,sp
L108B8:
	move.l	-16(a6),a0
	move	4(a0),-(sp)
	jsr	L1DC
	addq	#2,sp
	move.l	-16(a6),a0
	move	d0,4(a0)
	cmpi	#$9C8,d0
	beq.s	L108F0
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	pea	L1BB2D
	jsr	L1067E
	addq	#4,sp
L108F0:
	move.l	-16(a6),a0
	move	6(a0),d3
	lsl.w	#1,d3
	move.l	-16(a6),a0
	move	6(a0),d0
	lsl.w	#1,d0
	move	d0,-(sp)
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	addi.l	#$3173E,d0
	move.l	d0,-12(a6)
	move.l	d0,-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	cmp	d3,d0
	beq.s	L10946
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	pea	L1BB49
	jsr	L1067E
	addq	#4,sp
L10946:
	move.l	-16(a6),a0
	move	6(a0),-6(a6)
L10950:
	move	-6(a6),d0
	subq	#1,-6(a6)
	move	d0,d0
	ble.s	L10976
	move.l	-12(a6),a0
	move	(a0),-(sp)
	jsr	L1DC
	addq	#2,sp
	move.l	-12(a6),a0
	move	d0,(a0)
	addq.l	#2,-12(a6)
	bra.s	L10950
;
L10976:
	move	#$2000,-(sp)
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#5,d0
	addi.l	#$36746,d0
	move.l	d0,a5
	move.l	d0,-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	cmpi	#$2000,d0
	bne.s	L109A4
	moveq	#1,d0
	bra.s	L109A6
;
L109A4:
	clr	d0
L109A6:
	move	d0,-6(a6)
	beq.s	L109C6
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	pea	L1BB62
	jsr	L1067E
	addq	#4,sp
L109C6:
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	clr	-8(a6)
L109D6:
	move.l	-16(a6),a0
	move	-8(a6),d0
	cmp	8(a0),d0
	bge.s	L10A0C
	move	-8(a6),d1
	ext.l	d1
	lsl.l	#2,d1
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#2,d0
	add.l	d1,d0
	lea	L3573E,a0
	adda.l	d0,a0
	move.l	a5,(a0)
L10A02:
	move.b	(a5)+,d0
	bne.s	L10A02
	addq	#1,-8(a6)
	bra.s	L109D6
;
L10A0C:
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L3E75A,a0
	adda.l	d0,a0
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#6,d0
	addi.l	#$467CA,d0
	move.l	d0,(a0)
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L3E750,a0
	adda.l	d0,a0
	clr	(a0)
	clr	d0
L10A40:
	movem.l	(sp),d3-d3/a5-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L10A48:
	link	a6,#-6
	clr	-2(a6)
	move	10(a6),d0
	bge.s	L10ABC
	move	10(a6),d0
	neg	d0
	move	d0,10(a6)
	cmpi	#1,10(a6)
	blt.s	L10A80
	move	8(a6),d0
	muls	#$A,d0
	lea	L2C0C4,a0
	adda.l	d0,a0
	move	10(a6),d0
	cmp	(a0),d0
	blt.s	L10A92
L10A80:
	move	10(a6),-(sp)
	pea	L1BB77
	jsr	L1067E
	addq	#6,sp
L10A92:
	move	10(a6),d1
	ext.l	d1
	lsl.l	#2,d1
	move	8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#2,d0
	add.l	d1,d0
	lea	L3573E,a0
	adda.l	d0,a0
	move.l	(a0),-6(a6)
	moveq	#-1,d0
L10AB4:
	move	d0,-2(a6)
	bra	L10E08
;
L10ABC:
	cmpi	#$1A,10(a6)
	bge.s	L10AEA
	moveq	#80,d0
	move	d0,-2(a6)
	move	10(a6),d1
	muls	#80,d1
	move	8(a6),d0
	muls	#$1016,d0
	add.l	d1,d0
	addi.l	#$2D64C,d0
L10AE2:
	move.l	d0,-6(a6)
	bra	L10E08
;
L10AEA:
	move	10(a6),d0
	subi	#$1A,d0
	cmpi	#$27,d0
	bhi	L10DF6
	lsl.w	#2,d0
	move	d0,a0
	adda.l	#L184A4,a0
	move.l	(a0),a0
	jmp	(a0)
;
L10B08:
	bra	L10E08
;
L10B0C:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5C0,d0
L10B1A:
	move.l	d0,-6(a6)
	moveq	#20,d0
	bra.s	L10AB4
;
L10B22:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2E120,d0
	bra.s	L10AE2
;
L10B32:
	move.l	#L36740,-6(a6)
	bra	L10E08
;
L10B3E:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5D4,d0
L10B4C:
	move.l	d0,-6(a6)
	moveq	#16,d0
	bra	L10AB4
;
L10B56:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2DFAC,d0
	bra	L10AE2
;
L10B68:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2E124,d0
	bra	L10AE2
;
L10B7A:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2E126,d0
	bra	L10AE2
;
L10B8C:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5BA,d0
	bra	L10AE2
;
L10B9E:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2E134,d0
	bra	L10AE2
;
L10BB0:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5BE,d0
	bra	L10AE2
;
L10BC2:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D606,d0
	bra	L10AE2
;
L10BD4:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2E12C,d0
	bra	L10AE2
;
L10BE6:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5B0,d0
	bra	L10AE2
;
L10BF8:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D604,d0
	bra	L10AE2
;
L10C0A:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5B6,d0
	bra	L10AE2
;
L10C1C:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2E136,d0
	bra	L10AE2
;
L10C2E:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5B2,d0
	bra	L10AE2
;
L10C40:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5AA,d0
	bra	L10AE2
;
L10C52:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2E138,d0
	bra	L10AE2
;
L10C64:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D58A,d0
	bra	L10AE2
;
L10C76:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5B4,d0
	bra	L10AE2
;
L10C88:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5A0,d0
	move.l	d0,-6(a6)
	moveq	#10,d0
	bra	L10AB4
;
L10CA0:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5F6,d0
	move.l	d0,-6(a6)
	moveq	#14,d0
	bra	L10AB4
;
L10CB8:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5AC,d0
	bra	L10AE2
;
L10CCA:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5B8,d0
	bra	L10AE2
;
L10CDC:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5E4,d0
	move.l	d0,-6(a6)
	moveq	#6,d0
	bra	L10AB4
;
L10CF4:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5AE,d0
	bra	L10AE2
;
L10D06:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2DFBE,d0
	bra	L10B4C
;
L10D18:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2E132,d0
	bra	L10AE2
;
L10D2A:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5BC,d0
	bra	L10AE2
;
L10D3C:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D58C,d0
	bra	L10B1A
;
L10D4E:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D5EA,d0
	move.l	d0,-6(a6)
	moveq	#12,d0
	bra	L10AB4
;
L10D66:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D60A,d0
	bra	L10AE2
;
L10D78:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D60C,d0
	bra	L10AE2
;
L10D8A:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D60E,d0
	bra	L10AE2
;
L10D9C:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D610,d0
	bra	L10AE2
;
L10DAE:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D612,d0
	bra	L10AE2
;
L10DC0:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D614,d0
	bra	L10AE2
;
L10DD2:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2D616,d0
	bra	L10AE2
;
L10DE4:
	move	8(a6),d0
	muls	#$1016,d0
	addi.l	#$2E13C,d0
	bra	L10AE2
;
L10DF6:
	move	10(a6),-(sp)
	pea	L1BB9E
	jsr	L1067E
	addq	#6,sp
L10E08:
	move.l	12(a6),a0
	move	-2(a6),(a0)
	move.l	-6(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L10E18:
	link	a6,#-152
	move	L3E74E,d0
	move	d0,-8(a6)
	ext.l	d0
	lsl.l	#2,d0
	lea	L2D57A,a0
	adda.l	d0,a0
	move.l	(a0),-4(a6)
	move	-8(a6),d0
	muls	#80,d0
	addi.l	#$315FC,d0
	move.l	-4(a6),a0
	move.l	d0,2608(a0)
L10E4C:
	clr	-14(a6)
	moveq	#1,d0
	move	d0,-6(a6)
L10E56:
	move.l	-4(a6),a0
	move	32(a0),d0
	blt.s	L10E6C
	move.l	-4(a6),a0
	cmpi	#4,32(a0)
	ble.s	L10E74
L10E6C:
	move.l	-4(a6),a0
	clr	32(a0)
L10E74:
	move	-6(a6),d0
	blt.s	L10E92
	move	-8(a6),d0
	muls	#$A,d0
	lea	L2C0C2,a0
	adda.l	d0,a0
	move	-6(a6),d0
	cmp	(a0),d0
	blt.s	L10EA4
L10E92:
	move	-6(a6),-(sp)
	pea	L1BBBA
	jsr	L1067E
	addq	#6,sp
L10EA4:
	move.l	-4(a6),a0
	move	2600(a0),d0
	bne.s	L10EC2
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-4(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
L10EC2:
	move.l	-4(a6),-(sp)
	jsr	L5C60
	addq	#4,sp
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-10(a6)
	move	-10(a6),d0
	asr.w	#6,d0
	move	d0,-12(a6)
	andi	#$3F,-10(a6)
	move	-10(a6),d0
	subq	#1,d0
	cmpi	#$3E,d0
	bhi	L11FAE
	lsl.w	#2,d0
	move	d0,a0
	adda.l	#L18544,a0
	move.l	(a0),a0
	jmp	(a0)
;
L10F1E:
	bra	L10E56
;
L10F22:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-18(a6),d0
	add	-16(a6),d0
L10F4A:
	move	d0,-(sp)
L10F4C:
	move	-8(a6),-(sp)
	jsr	L106F4
L10F56:
	addq	#4,sp
	bra	L10E56
;
L10F5C:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-18(a6),d0
	and	-16(a6),d0
	bra.s	L10F4A
;
L10F86:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	not	d0
	bra.s	L10F4A
;
L10F9E:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-18(a6),d0
	bne.s	L10FD2
	pea	L1BBCD
	jsr	L1067E
	addq	#4,sp
L10FD2:
	move	-16(a6),d0
	ext.l	d0
	divs	-18(a6),d0
	bra	L10F4A
;
L10FE0:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	cmp	-18(a6),d0
L11008:
	bne.s	L11010
L1100A:
	moveq	#1,d0
	bra	L10F4A
;
L11010:
	clr	-(sp)
	bra	L10F4C
;
L11016:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	cmp	-18(a6),d0
	blt.s	L11010
	bra.s	L1100A
;
L11042:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	cmp	-18(a6),d0
	ble.s	L11010
	bra.s	L1100A
;
L1106E:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	cmp	-18(a6),d0
	bgt	L11010
	bra	L1100A
;
L1109E:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	beq	L11010
L110C6:
	move	-18(a6),d0
L110CA:
	beq	L11010
	bra	L1100A
;
L110D2:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	bne	L1100A
	bra.s	L110C6
;
L110FC:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	cmp	-18(a6),d0
	bge	L11010
	bra	L1100A
;
L1112C:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-18(a6),d0
	bne.s	L11160
	pea	L1BBDC
	jsr	L1067E
	addq	#4,sp
L11160:
	move	-16(a6),d0
	ext.l	d0
	divs	-18(a6),d0
	swap	d0
	bra	L10F4A
;
L11170:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-18(a6),d0
	muls	-16(a6),d0
	bra	L10F4A
;
L1119C:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	cmp	-18(a6),d0
	bra	L110CA
;
L111C8:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	neg	d0
	bra	L10F4A
;
L111E2:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	bra	L11008
;
L111FA:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-18(a6),d0
	or	-16(a6),d0
	bra	L10F4A
;
L11226:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	move	-18(a6),d2
	lsl.w	d2,d0
	bra	L10F4A
;
L11254:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	move	-18(a6),d2
	asr.w	d2,d0
	bra	L10F4A
;
L11282:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	sub	-18(a6),d0
	bra	L10F4A
;
L112AE:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-18(a6),d0
	move	-16(a6),d2
	eor	d2,d0
	bra	L10F4A
;
L112DC:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L106F4
	addq	#4,sp
	move	-12(a6),d0
	bge.s	L11316
	move	-12(a6),-(sp)
	pea	L1BBEC
	jsr	L1067E
	addq	#6,sp
	bra.s	L1134E
;
L11316:
	cmpi	#$1A,-12(a6)
	bge.s	L11334
	move	-12(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	-4(a6),a0
	move	-16(a6),142(a0)
	bra.s	L1134E
;
L11334:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,a0
	move	-16(a6),(a0)
L1134E:
	cmpi	#$1C,-12(a6)
	bne	L10E56
	moveq	#-1,d0
	move	d0,L3E758
	moveq	#1,d0
	move	d0,-(sp)
	move	L315FA,-(sp)
	jsr	L37D0
	bra	L10F56
;
L11374:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L106F4
	addq	#4,sp
	pea	-20(a6)
	move	-16(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-68(a6)
	move	-20(a6),-(sp)
	move.l	-64(a6),-(sp)
L113CC:
	move.l	-68(a6),-(sp)
	jsr	L12008
L113D6:
	adda	#$A,sp
	bra	L10E56
;
L113DE:
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	bra	L10F4C
;
L11404:
	move	-12(a6),d0
	blt.s	L11428
	cmpi	#$43,-12(a6)
	bge.s	L11428
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B886,a0
	adda.l	d0,a0
	cmpi	#$19,(a0)
	beq.s	L1143A
L11428:
	move	-12(a6),-(sp)
	pea	L1BC06
	jsr	L1067E
	addq	#6,sp
L1143A:
	move.l	-4(a6),-(sp)
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B888,a0
	adda.l	d0,a0
	move.l	(a0),a0
	move.l	a0,-152(a6)
	jsr	(a0)
	addq	#4,sp
L11458:
	move	d0,-(sp)
	move	-8(a6),-(sp)
	jsr	L106F4
L11464:
	addq	#4,sp
L11466:
	move	-8(a6),d0
	muls	#80,d0
	addi.l	#$315FC,d0
	move.l	-4(a6),a0
	move.l	d0,2608(a0)
	bra	L10E56
;
L11480:
	move	-12(a6),d0
	blt.s	L114A4
	cmpi	#$43,-12(a6)
	bge.s	L114A4
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B886,a0
	adda.l	d0,a0
	cmpi	#$1A,(a0)
	beq.s	L114B6
L114A4:
	move	-12(a6),-(sp)
	pea	L1BC1E
	jsr	L1067E
	addq	#6,sp
L114B6:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-(sp)
	move.l	-4(a6),-(sp)
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B888,a0
	adda.l	d0,a0
	move.l	(a0),a0
	move.l	a0,-152(a6)
	jsr	(a0)
	addq	#6,sp
	bra	L11458
;
L114E6:
	move	-12(a6),d0
	blt.s	L1150A
	cmpi	#$43,-12(a6)
	bge.s	L1150A
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B886,a0
	adda.l	d0,a0
	cmpi	#$1B,(a0)
	beq.s	L1151C
L1150A:
	move	-12(a6),-(sp)
	pea	L1BC39
	jsr	L1067E
	addq	#6,sp
L1151C:
	pea	-20(a6)
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	move.l	-64(a6),-(sp)
L11556:
	move.l	-4(a6),-(sp)
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B888,a0
	adda.l	d0,a0
	move.l	(a0),a0
	move.l	a0,-152(a6)
	jsr	(a0)
	addq	#8,sp
	bra	L11458
;
L11578:
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-16(a6)
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-18(a6)
	move	-12(a6),d0
	blt.s	L115E4
	cmpi	#$43,-12(a6)
	bge.s	L115E4
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B886,a0
	adda.l	d0,a0
	cmpi	#$1C,(a0)
	beq.s	L115F6
L115E4:
	move	-12(a6),-(sp)
	pea	L1BC54
	jsr	L1067E
	addq	#6,sp
L115F6:
	pea	-20(a6)
	move	-16(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	pea	-20(a6)
	move	-18(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-68(a6)
	move.l	-68(a6),-(sp)
	move.l	-64(a6),-(sp)
	move.l	-4(a6),-(sp)
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B888,a0
	adda.l	d0,a0
	move.l	(a0),a0
	move.l	a0,-152(a6)
	jsr	(a0)
	adda	#$C,sp
	bra	L11458
;
L11652:
	move	-6(a6),d1
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-6(a6)
	bra	L10E56
;
L11676:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,d0
	beq.s	L11652
L11686:
	addq	#1,-6(a6)
	bra	L10E56
;
L1168E:
	move	-14(a6),d0
	beq	L11FC6
	subq	#1,-14(a6)
	move	-14(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-60(a0),-6(a6)
	bra	L10E56
;
L116B0:
	move	-14(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	a6,a0
	move	-6(a6),d0
	addq	#1,d0
	move	d0,-60(a0)
	addq	#1,-14(a6)
	move	-14(a6),d0
	cmpi	#$14,d0
	blt	L11652
	pea	L1BC70
	jsr	L1067E
	addq	#4,sp
	bra	L11652
;
L116E8:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	bra	L10E56
;
L116F8:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-(sp)
	pea	L1BC87
	jsr	L63E0
	addq	#6,sp
	bra	L10E56
;
L11718:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	move.l	-64(a6),-(sp)
	pea	L1BC8B
	jsr	L63E0
L11740:
	addq	#8,sp
	bra	L10E56
;
L11746:
	move	-12(a6),d0
	blt.s	L1176A
	cmpi	#$43,-12(a6)
	bge.s	L1176A
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B886,a0
	adda.l	d0,a0
	cmpi	#$24,(a0)
	beq.s	L1177C
L1176A:
	move	-12(a6),-(sp)
	pea	L1BC8E
	jsr	L1067E
	addq	#6,sp
L1177C:
	move.l	-4(a6),-(sp)
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B888,a0
	adda.l	d0,a0
	move.l	(a0),a0
	move.l	a0,-152(a6)
	jsr	(a0)
	bra	L11464
;
L1179C:
	move	-12(a6),d0
	blt.s	L117C0
	cmpi	#$43,-12(a6)
	bge.s	L117C0
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B886,a0
	adda.l	d0,a0
	cmpi	#$25,(a0)
	beq.s	L117D2
L117C0:
	move	-12(a6),-(sp)
	pea	L1BCA6
	jsr	L1067E
	addq	#6,sp
L117D2:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-(sp)
	move.l	-4(a6),-(sp)
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B888,a0
	adda.l	d0,a0
	move.l	(a0),a0
	move.l	a0,-152(a6)
	jsr	(a0)
	addq	#6,sp
	bra	L11466
;
L11802:
	move	-12(a6),d0
	blt.s	L11826
	cmpi	#$43,-12(a6)
	bge.s	L11826
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B886,a0
	adda.l	d0,a0
	cmpi	#$26,(a0)
	beq.s	L11838
L11826:
	move	-12(a6),-(sp)
	pea	L1BCC1
	jsr	L1067E
	addq	#6,sp
L11838:
	pea	-20(a6)
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	move.l	-64(a6),-(sp)
	move.l	-4(a6),-(sp)
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B888,a0
	adda.l	d0,a0
	move.l	(a0),a0
	move.l	a0,-152(a6)
	jsr	(a0)
	addq	#8,sp
	bra	L11466
;
L11894:
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-16(a6)
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-18(a6)
	move	-12(a6),d0
	blt.s	L11900
	cmpi	#$43,-12(a6)
	bge.s	L11900
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B886,a0
	adda.l	d0,a0
	cmpi	#$27,(a0)
	beq.s	L11912
L11900:
	move	-12(a6),-(sp)
	pea	L1BCDC
	jsr	L1067E
	addq	#6,sp
L11912:
	pea	-20(a6)
	move	-16(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	pea	-20(a6)
	move	-18(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-68(a6)
	move.l	-68(a6),-(sp)
	move.l	-64(a6),-(sp)
	move.l	-4(a6),-(sp)
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B888,a0
	adda.l	d0,a0
	move.l	(a0),a0
	move.l	a0,-152(a6)
	jsr	(a0)
	adda	#$C,sp
	bra	L11466
;
L1196E:
	move	-12(a6),d0
	bge.s	L11988
	move	-12(a6),-(sp)
	pea	L1BCF8
	jsr	L1067E
	addq	#6,sp
	bra.s	L119C0
;
L11988:
	cmpi	#$1A,-12(a6)
	bge.s	L119A6
	move	-12(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	move.l	d0,a0
	adda.l	-4(a6),a0
	move	142(a0),-16(a6)
	bra.s	L119C0
;
L119A6:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,a0
	move	(a0),-16(a6)
L119C0:
	move	-16(a6),-(sp)
	bra	L10F4C
;
L119C8:
	move	-12(a6),-(sp)
	bra	L10F4C
;
L119D0:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-18(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L106F4
	addq	#4,sp
	bra.s	L119C0
;
L11A02:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	addq	#1,-16(a6)
L11A16:
	move	-16(a6),d0
	bra	L10F4A
;
L11A1E:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	subq	#1,-16(a6)
	bra.s	L11A16
;
L11A34:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	move.l	-64(a6),-(sp)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-64(a6)
	move.l	d0,-68(a6)
L11A60:
	move.l	-68(a6),a0
	move.b	(a0),d0
	beq.s	L11A78
	move.l	-68(a6),a0
	cmpi.b	#$2E,(a0)
	beq.s	L11A78
	addq.l	#1,-68(a6)
	bra.s	L11A60
;
L11A78:
	move.l	-68(a6),a0
	clr.b	(a0)
	move.l	-64(a6),-(sp)
	move.b	L46B26,d0
	ext.w	d0
	addi	#$41,d0
	move	d0,-(sp)
	pea	L1BD10
	move.l	-4(a6),a0
	pea	2638(a0)
	jsr	L16E2A
	adda	#$E,sp
	move.l	-4(a6),a0
	pea	2638(a0)
	jsr	L1219C
	addq	#4,sp
	move.l	-4(a6),a0
	pea	2638(a0)
	jsr	L10796
	addq	#4,sp
	move	d0,d0
	beq	L10E4C
	move.l	-4(a6),a0
	pea	2638(a0)
	pea	L1BD1F
	jsr	L1067E
	addq	#8,sp
	bra	L10E4C
;
L11AE8:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,d0
	beq	L11686
	bra	L11652
;
L11AFE:
	pea	-20(a6)
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-68(a6)
	move.l	-64(a6),-(sp)
	move.l	-68(a6),-(sp)
	jsr	L559C
	addq	#8,sp
	bra	L10F4A
;
L11B60:
	pea	-20(a6)
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-68(a6)
	move.l	-68(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-16(a6)
L11BBE:
	move	-16(a6),d0
	cmp	-20(a6),d0
	bge.s	L11BE0
	move	-16(a6),a0
	adda.l	-68(a6),a0
	move.l	-64(a6),a1
	addq.l	#1,-64(a6)
	move.b	(a1),(a0)
	addq	#1,-16(a6)
	bra.s	L11BBE
;
L11BE0:
	move	-16(a6),d0
	subq	#1,d0
	move	d0,a0
L11BE8:
	adda.l	-68(a6),a0
	clr.b	(a0)
	bra	L10E56
;
L11BF2:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	move.l	-64(a6),-(sp)
	jsr	L12092
L11C14:
	addq	#4,sp
	bra	L10F4A
;
L11C1A:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	move.l	-64(a6),a0
	move.b	(a0),d0
	ext.w	d0
	andi	#$FF,d0
	bra	L10F4A
;
L11C42:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-(sp)
	jsr	L1219C
	bra	L10F56
;
L11C62:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-(sp)
	jsr	L12170
	bra	L10F56
;
L11C82:
	pea	-20(a6)
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-68(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	bge.s	L11CF4
	pea	L1BD34
	jsr	L1067E
	addq	#4,sp
L11CF4:
	move.l	-64(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	sub	-16(a6),d0
	move	d0,-16(a6)
	move	-20(a6),-(sp)
	move	-16(a6),d0
	ext.l	d0
	add.l	-64(a6),d0
	move.l	d0,-(sp)
	bra	L113CC
;
L11D1C:
	pea	-20(a6)
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-68(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-16(a6),d0
	bge.s	L11D8E
	pea	L1BD52
	jsr	L1067E
	addq	#4,sp
L11D8E:
	move	-20(a6),-(sp)
	move.l	-64(a6),-(sp)
	move.l	-68(a6),-(sp)
	jsr	L12008
	adda	#$A,sp
	move	-16(a6),d0
	cmp	-20(a6),d0
	bge	L10E56
	move	-16(a6),a0
	bra	L11BE8
;
L11DB8:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	move.l	-64(a6),-(sp)
	jsr	L11FCA
	bra	L11C14
;
L11DDE:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-(sp)
	pea	L1BD6F
L11DF2:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-(sp)
	jsr	L16E2A
	bra	L113D6
;
L11E12:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-(sp)
	pea	L1BD72
	bra.s	L11DF2
;
L11E28:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	move.l	-64(a6),-(sp)
	pea	L1BD75
	jsr	L63E0
	addq	#8,sp
	clr	-16(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-20(a6)
	bge.s	L11E78
	moveq	#1,d0
	move	d0,-16(a6)
	move	-20(a6),d0
	neg	d0
	move	d0,-20(a6)
L11E78:
	move	-20(a6),d0
	beq.s	L11E86
	cmpi	#$4F,-20(a6)
	ble.s	L11E94
L11E86:
	pea	L1BD78
	jsr	L1067E
	addq	#4,sp
L11E94:
	move	-16(a6),-(sp)
	move	-20(a6),d0
	addq	#1,d0
	move	d0,-(sp)
	pea	-148(a6)
	move.l	-4(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-16(a6)
	pea	-20(a6)
	move	-6(a6),d1
	addq	#1,-6(a6)
	ext.l	d1
	lsl.l	#1,d1
	move	-8(a6),d0
	ext.l	d0
	lsl.l	#8,d0
	lsl.l	#4,d0
	add.l	d1,d0
	lea	L3173E,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-68(a6)
	move	-20(a6),-(sp)
	pea	-148(a6)
	move.l	-68(a6),-(sp)
	jsr	L12008
	adda	#$A,sp
	bra	L119C0
;
L11F06:
	pea	-20(a6)
	move	-12(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	L10A48
	addq	#8,sp
	move.l	d0,-64(a6)
	cmpi	#80,-20(a6)
	beq.s	L11F34
	pea	L1BD8F
	jsr	L1067E
	addq	#4,sp
L11F34:
	move.l	-64(a6),-(sp)
	move.l	-4(a6),-(sp)
	jsr	L1018C
	addq	#8,sp
	move	d0,-16(a6)
	bra	L119C0
;
L11F4C:
	move	-12(a6),d0
	blt.s	L11F70
	cmpi	#$43,-12(a6)
	bge.s	L11F70
	move	-12(a6),d0
	muls	#6,d0
	lea	L1B886,a0
	adda.l	d0,a0
	cmpi	#$3F,(a0)
	beq.s	L11F82
L11F70:
	move	-12(a6),-(sp)
	pea	L1BDA5
	jsr	L1067E
	addq	#6,sp
L11F82:
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-16(a6)
	move	-8(a6),-(sp)
	jsr	L10746
	addq	#2,sp
	move	d0,-18(a6)
	move	-18(a6),-(sp)
	move	-16(a6),-(sp)
	bra	L11556
;
L11FAE:
	move	-12(a6),-(sp)
	move	-10(a6),-(sp)
	pea	L1BDC1
	jsr	L1067E
	bra	L11740
;
L11FC6:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L11FCA:
	link	a6,#-8
	movem.l	d7-d7/a5-a5,(sp)
	move.l	8(a6),a5
	moveq	#0,d7
L11FD8:
	move.b	(a5),d0
	beq.s	L11FE2
	addq	#1,d7
	addq.l	#1,a5
	bra.s	L11FD8
;
L11FE2:
	move	d7,d0
	movem.l	(sp),d7-d7/a5-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L11FEC:
	link	a6,#-8
	movem.l	a4-a5,(sp)
	move.l	8(a6),a5
	move.l	12(a6),a4
L11FFC:
	move.b	(a4)+,(a5)+
	bne.s	L11FFC
	movem.l	(sp),a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L12008:
	link	a6,#0
	move	16(a6),-(sp)
	move.l	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L5D6A
	adda	#$A,sp
	move	16(a6),d0
	subq	#1,d0
	move	d0,a0
	adda.l	8(a6),a0
	clr.b	(a0)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L12034:
	link	a6,#-10
	movem.l	a4-a5,(sp)
	move.l	8(a6),a5
	move.l	12(a6),a4
L12044:
	move.b	(a4),d1
	ext.w	d1
	move.b	(a5),d0
	ext.w	d0
	sub	d1,d0
	move	d0,-2(a6)
	bne.s	L12062
	move.b	(a5),d0
	bne.s	L1205C
	clr	d0
	bra.s	L12066
;
L1205C:
	addq.l	#1,a5
	addq.l	#1,a4
	bra.s	L12044
;
L12062:
	move	-2(a6),d0
L12066:
	movem.l	(sp),a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1206E:
	link	a6,#-8
	movem.l	a4-a5,(sp)
	move.l	8(a6),a5
	move.l	12(a6),a4
L1207E:
	move.b	(a5),d0
	beq.s	L12086
	addq.l	#1,a5
	bra.s	L1207E
;
L12086:
	move.b	(a4)+,(a5)+
	bne.s	L12086
	movem.l	(sp),a4-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L12092:
	link	a6,#-8
	movem.l	d7-d7/a5-a5,(sp)
	move.l	8(a6),a5
	moveq	#0,d7
L120A0:
	cmpi.b	#$20,(a5)
	bne.s	L120AA
	addq.l	#1,a5
	bra.s	L120A0
;
L120AA:
	cmpi.b	#$30,(a5)
	blt.s	L120CA
	cmpi.b	#$39,(a5)
	bgt.s	L120CA
	move	d7,d0
	muls	#$A,d0
	move	d0,d7
	move.b	(a5)+,d0
	ext.w	d0
	subi	#$30,d0
	add	d0,d7
	bra.s	L120AA
;
L120CA:
	move	d7,d0
	movem.l	(sp),d7-d7/a5-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L120D4:
	link	a6,#-2
	clr	-2(a6)
L120DC:
	move.l	8(a6),a0
	move.b	(a0),d0
	beq.s	L12102
	move.l	8(a6),a0
	addq.l	#1,8(a6)
	move.b	(a0),d0
	ext.w	d0
	cmp	12(a6),d0
	bne.s	L120FC
	move	-2(a6),d0
	bra.s	L12104
;
L120FC:
	addq	#1,-2(a6)
	bra.s	L120DC
;
L12102:
	moveq	#-1,d0
L12104:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L12108:
	link	a6,#-12
	movem.l	a3-a5,(sp)
	move.l	8(a6),a5
	move.l	12(a6),a4
	move.l	16(a6),a3
L1211C:
	move.b	(a4)+,(a5)+
	bne.s	L1211C
	subq.l	#1,a5
L12122:
	move.b	(a3)+,(a5)+
	bne.s	L12122
	movem.l	(sp),a3-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1212E:
	link	a6,#-2
	moveq	#-1,d0
	move	d0,-2(a6)
L12138:
	move.l	12(a6),a0
	move.b	(a0),d0
	beq.s	L12160
	move.l	12(a6),a0
	addq.l	#1,12(a6)
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L120D4
	addq	#6,sp
	move	d0,-2(a6)
	blt.s	L12138
L12160:
	move	-2(a6),d0
	bge.s	L1216A
	clr	d0
	bra.s	L1216C
;
L1216A:
	moveq	#1,d0
L1216C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L12170:
	link	a6,#-4
	move.l	a5,-(sp)
	move.l	8(a6),a5
L1217A:
	move.b	(a5),d0
	beq.s	L12192
	cmpi.b	#$41,(a5)
	blt.s	L1218E
	cmpi.b	#$5A,(a5)
	bgt.s	L1218E
	addi.b	#$20,(a5)
L1218E:
	addq.l	#1,a5
	bra.s	L1217A
;
L12192:
	move.l	8(a6),d0
	move.l	(sp)+,a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1219C:
	link	a6,#-4
	move.l	a5,-(sp)
	move.l	8(a6),a5
L121A6:
	move.b	(a5),d0
	beq.s	L121BE
	cmpi.b	#$61,(a5)
	blt.s	L121BA
	cmpi.b	#$7A,(a5)
	bgt.s	L121BA
	subi.b	#$20,(a5)
L121BA:
	addq.l	#1,a5
	bra.s	L121A6
;
L121BE:
	move.l	8(a6),d0
	move.l	(sp)+,a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L121C8:
	link	a6,#-4
	move.l	8(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	ext.l	d0
	add.l	8(a6),d0
	subq.l	#1,d0
	move.l	d0,-4(a6)
	move.l	-4(a6),a0
	cmp.l	8(a6),a0
	bcs.s	L12210
	move.l	-4(a6),a0
	cmpi.b	#$5C,(a0)
	beq.s	L1220C
	move.l	-4(a6),a0
	cmpi.b	#$2F,(a0)
	beq.s	L1220C
	move.l	-4(a6),a0
	cmpi.b	#$3A,(a0)
	bne.s	L12210
L1220C:
	moveq	#1,d0
	bra.s	L12212
;
L12210:
	clr	d0
L12212:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L12216:
	link	a6,#0
L1221A:
	move.l	8(a6),a0
	move.b	(a0),d0
	beq.s	L12232
	move.l	8(a6),a0
	cmpi.b	#$2E,(a0)
	beq.s	L12232
	addq.l	#1,8(a6)
	bra.s	L1221A
;
L12232:
	move.l	8(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1223A:
	link	a6,#0
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	move.l	8(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	cmpi	#2,d0
	blt.s	L1227E
	move.l	8(a6),a0
	cmpi.b	#$3A,1(a0)
	bne.s	L1227E
	move.l	8(a6),a0
	cmpi.b	#$41,(a0)
	blt.s	L1227E
	move.l	8(a6),a0
	cmpi.b	#80,(a0)
	ble.s	L12286
L1227E:
	jsr	task_Dgetdrv
	bra.s	L12292
;
L12286:
	move.l	8(a6),a0
	move.b	(a0),d0
	ext.w	d0
	subi	#$41,d0
L12292:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L12296:
	link	a6,#0
	move.l	12(a6),-(sp)
	pea	L1BF0C
	jsr	L63E0
	addq	#8,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L122B0:
	link	a6,#0
	move	12(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a1
	adda.l	d0,a1
	move.l	8(a6),a0
	move	46(a0),d0
	and	(a1),d0
	beq.s	L122D4
	clr	d0
	bra.s	L122EC
;
L122D4:
	move	12(a6),d0
	addq	#1,d0
	move	d0,-(sp)
	pea	you_dont_have_access_to_sig_x_3_s
	jsr	L63E0
	addq	#6,sp
	moveq	#1,d0
L122EC:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L122F0:
	link	a6,#-4
	jsr	L6944
	move	d0,-2(a6)
	jsr	L6988
	move	d0,-4(a6)
	pea	today_is_s
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	move	-2(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L5E96
	adda	#$A,sp
	move	-4(a6),-(sp)
	pea	time_is_x_s
	jsr	L63E0
	addq	#6,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L12346:
sys_sysdump_func:
	link	a6,#-2
	pea	sys_system_status_dump_s
	jsr	L63E0
	addq	#4,sp
	move.l	L1886C,-(sp)
	move	L2C0B6,-(sp)
	pea	L1BF66
	jsr	L63E0
	adda	#$A,sp
	move.l	L18860,-(sp)
	move	L2C0B0,-(sp)
	pea	L1BF85
	jsr	L63E0
	adda	#$A,sp
	move.l	L18864,-(sp)
	move	L2C0B2,-(sp)
	pea	L1BFA4
	jsr	L63E0
	adda	#$A,sp
	move.l	L18868,-(sp)
	move	L2C0B4,-(sp)
	pea	L1BFC3
	jsr	L63E0
	adda	#$A,sp
	clr	-2(a6)
L123CC:
	move	-2(a6),d0
	cmp	L2C0BA,d0
	bge.s	L1240E
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#5,d0
	addi.l	#$46C22,d0
	move.l	d0,-(sp)
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#5,d0
	addi.l	#$4691E,d0
	move.l	d0,-(sp)
	pea	L1BFE3
	jsr	L63E0
	adda	#$C,sp
	addq	#1,-2(a6)
	bra.s	L123CC
;
L1240E:
	pea	L46E22
	pea	L1BFFF
	jsr	L63E0
	addq	#8,sp
	pea	L1C014
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#30,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	pea	L46C0E
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	L12472
	move.l	8(a6),-(sp)
	jsr	sys_terminate_func
	addq	#4,sp
L12472:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L12476:
sys_terminate_func:
	link	a6,#-4
	move.l	#L1C021,-4(a6)
	move.l	-4(a6),-(sp)
	pea	L1C031
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	move.l	-4(a6),-(sp)
	jsr	L11FCA
	addq	#4,sp
	addq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move.l	-4(a6),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	L124EA
	moveq	#1,d0
	move	d0,L3E7BA
	pea	L1C054
	jsr	L63E0
	addq	#4,sp
L124EA:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L124EE:
sys_date_func:
	link	a6,#-10
	move	12(a6),d0
	beq	L125BA
	cmpi	#1,12(a6)
	beq.s	L12518
	pea	L1C08F
	move.l	8(a6),-(sp)
	jsr	L12296
	addq	#8,sp
	bra	L125C6
;
L12518:
	move.l	14(a6),a0
	move.l	(a0),-10(a6)
	pea	-6(a6)
	pea	-4(a6)
	pea	-2(a6)
	jsr	task_Tgetdate
	adda	#$C,sp
	move	-2(a6),-(sp)
	pea	-10(a6)
	jsr	L6B48
	addq	#6,sp
	move	d0,-2(a6)
	move	-4(a6),-(sp)
	pea	-10(a6)
	jsr	L6B48
	addq	#6,sp
	move	d0,-4(a6)
	move	-6(a6),d0
	ext.l	d0
	divs	#$64,d0
	swap	d0
	move	d0,-(sp)
	pea	-10(a6)
	jsr	L6B48
	addq	#6,sp
	move	d0,-6(a6)
	cmpi	#80,-6(a6)
	bge.s	L1258E
	move	-6(a6),d0
	addi	#$7D0,d0
	bra.s	L12596
;
L1258E:
	move	-6(a6),d0
	addi	#$76C,d0
L12596:
	move	d0,-(sp)
	move	-4(a6),-(sp)
	move	-2(a6),-(sp)
	jsr	task_Tsetdate
	addq	#6,sp
	move	d0,d0
	beq.s	L125BA
	pea	L1C0A3
	jsr	L63E0
	addq	#4,sp
L125BA:
	move.l	8(a6),-(sp)
	jsr	L122F0
	addq	#4,sp
L125C6:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L125CA:
sys_time_func:
	link	a6,#-8
	move	12(a6),d0
	beq.s	L12640
	cmpi	#1,12(a6)
	beq.s	L125F0
	pea	L1C0B1
	move.l	8(a6),-(sp)
	jsr	L12296
	addq	#8,sp
	bra.s	L1264C
;
L125F0:
	move.l	14(a6),a0
	move.l	(a0),-8(a6)
	clr	-(sp)
	pea	-8(a6)
	jsr	L6B48
	addq	#6,sp
	move	d0,-2(a6)
	clr	-(sp)
	pea	-8(a6)
	jsr	L6B48
	addq	#6,sp
	move	d0,-4(a6)
	clr	-(sp)
	move	-4(a6),-(sp)
	move	-2(a6),-(sp)
	jsr	task_Tsettime
	addq	#6,sp
	move	d0,d0
	beq.s	L12640
	pea	L1C0C1
	jsr	L63E0
	addq	#4,sp
L12640:
	move.l	8(a6),-(sp)
	jsr	L122F0
	addq	#4,sp
L1264C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L12650:
sys_activity_func:
	link	a6,#-16
	move	L2C0B6,d0
	bgt.s	L12666
	pea	L1C0CF
	bra	L12828
;
L12666:
	pea	L1C0EC
	jsr	L63E0
	addq	#4,sp
	clr.l	-12(a6)
	clr	-4(a6)
L1267C:
	move	-4(a6),d0
	bne	L12782
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	moveq	#1,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	L2C0B6,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	d0,-8(a6)
	clr	-(sp)
	move.l	-12(a6),-(sp)
	move	L2C0B6,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	#$2000,-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move	L2C0B6,-(sp)
	jsr	task_Fread
	addq	#8,sp
	move	d0,-2(a6)
	moveq	#1,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	L2C0B6,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	d0,-12(a6)
	clr	-(sp)
	move.l	-8(a6),-(sp)
	move	L2C0B6,-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	ble.s	L12782
	move.l	8(a6),a0
	move.l	2894(a0),-16(a6)
L12726:
	move	-4(a6),d0
	bne	L1267C
	move	-2(a6),d0
	ble	L1267C
	cmpi	#80,-2(a6)
	bge.s	L12744
	move	-2(a6),-(sp)
	bra.s	L12748
;
L12744:
	moveq	#80,d0
	move	d0,-(sp)
L12748:
	move.l	-16(a6),-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D80
	addq	#8,sp
	subi	#80,-2(a6)
	move.l	-16(a6),a0
	adda	#80,a0
	move.l	a0,-16(a6)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L6AF8
	addq	#6,sp
	move	d0,-4(a6)
	bra.s	L12726
;
L12782:
	move	-4(a6),d0
	beq.s	L12794
	move.l	8(a6),-(sp)
	jsr	L707E
	addq	#4,sp
L12794:
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	blt.s	L1281C
	move.l	-12(a6),d0
	beq.s	L1281C
	clr	-(sp)
	pea	L1C10D
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	cmpi	#1,d0
	bne.s	L1281C
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	move	L2C0B6,-(sp)
	jsr	L4A4C
	addq	#2,sp
	move.l	L1886C,-(sp)
	jsr	task_Fcreate
	addq	#4,sp
	move	d0,L2C0B6
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	L2C0B6,d0
	bge.s	L1281C
	move.l	L1886C,-(sp)
	pea	L1C124
	jsr	L63E0
	addq	#8,sp
L1281C:
	move.l	-12(a6),d0
	bne.s	L12830
	pea	L1C138
L12828:
	jsr	L63E0
	addq	#4,sp
L12830:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L12834:
	link	a6,#-2
	move.l	12(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move	d0,-(sp)
	pea	L1C152
	jsr	L120D4
	addq	#6,sp
	move	d0,-2(a6)
	bge.s	L12872
	move.l	12(a6),-(sp)
	pea	L1C158
	jsr	L63E0
	addq	#8,sp
L12872:
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1287A:
sys_upload_func:
	link	a6,#-10
	cmpi	#2,12(a6)
	beq.s	L1289A
	pea	L1C16A
	move.l	8(a6),-(sp)
	jsr	L12296
	bra	L129FA
;
L1289A:
	move.l	14(a6),a0
	move.l	4(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	L12834
	addq	#8,sp
	move	d0,-6(a6)
	blt	L129FC
	cmpi	#4,-6(a6)
	bne.s	L128D0
	pea	L1C17F
	jsr	L63E0
	addq	#4,sp
	bra	L129FC
;
L128D0:
	move.l	14(a6),a0
	move.l	(a0),-4(a6)
	clr	-(sp)
	move.l	-4(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	clr	-(sp)
	move.l	-4(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-8(a6)
	ble.s	L12936
	move	-8(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move.l	-4(a6),-(sp)
	pea	L1C1A1
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	pea	L1C1B0
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	cmpi	#1,d0
	bne	L129FC
L12936:
	move.l	-4(a6),-(sp)
	jsr	L4B74
	addq	#4,sp
	move	d0,-8(a6)
	bgt.s	L1295C
	move.l	-4(a6),-(sp)
	pea	L1C1B1
	jsr	L63E0
	bra	L129FA
;
L1295C:
	move.l	-4(a6),-(sp)
	move	-6(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L7992
	adda	#$A,sp
	move.l	-4(a6),-(sp)
	clr	-(sp)
	move	-6(a6),-(sp)
	move	-8(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L7814
	adda	#$E,sp
	move	d0,-10(a6)
	move	-8(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move.l	-4(a6),-(sp)
	move	-10(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18838,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	move	-6(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L1884C,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	pea	L1C1C5
	jsr	L6526
	adda	#$10,sp
	move	-10(a6),d0
	beq.s	L129E8
	move.l	-4(a6),-(sp)
	jsr	task_Fdelete
	addq	#4,sp
L129E8:
	move	-10(a6),-(sp)
	move	-6(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L79CE
L129FA:
	addq	#8,sp
L129FC:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L12A00:
sys_download_func:
	link	a6,#-14
	cmpi	#2,12(a6)
	beq.s	L12A20
	pea	L1C1E3
	move.l	8(a6),-(sp)
	jsr	L12296
	bra	L12AFA
;
L12A20:
	move.l	14(a6),a0
	move.l	4(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	L12834
	addq	#8,sp
	move	d0,-6(a6)
	blt	L12AFC
	move.l	14(a6),a0
	move.l	(a0),-4(a6)
	clr	-(sp)
	move.l	-4(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	clr	-(sp)
	move.l	-4(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-8(a6)
	bgt.s	L12A7A
	move.l	-4(a6),-(sp)
	pea	L1C1FA
	jsr	L63E0
	bra	L12AFA
;
L12A7A:
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	-8(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	d0,-14(a6)
	clr	-(sp)
	clr.l	-(sp)
	move	-8(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	-4(a6),-(sp)
	move.l	-14(a6),-(sp)
	move	-6(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L78AA
	adda	#$E,sp
	move.l	-4(a6),-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	move	-8(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L7814
	adda	#$E,sp
	move	d0,-10(a6)
	move	-8(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move	-10(a6),-(sp)
	move	-6(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L79CE
L12AFA:
	addq	#8,sp
L12AFC:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L12B00:
sys_dir_func:
	link	a6,#-4
	move	12(a6),d0
	bne.s	L12B18
	addq	#1,12(a6)
	move.l	14(a6),a0
	move.l	#L1C207,(a0)
L12B18:
	cmpi	#1,12(a6)
	beq.s	L12B34
	pea	L1C20B
	move.l	8(a6),-(sp)
	jsr	L12296
	addq	#8,sp
	bra.s	L12BA8
;
L12B34:
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	jsr	L11FEC
	addq	#8,sp
	move.l	8(a6),a0
	move.l	2894(a0),-4(a6)
	move.l	-4(a6),-(sp)
	jsr	L121C8
	addq	#4,sp
	move	d0,d0
	beq.s	L12B76
	pea	L1C223
	move.l	-4(a6),-(sp)
	jsr	L1206E
	addq	#8,sp
L12B76:
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L11FEC
	addq	#8,sp
	moveq	#16,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L61B4
	adda	#$A,sp
L12BA8:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L12BAC:
sys_upldir_func:
	link	a6,#-4
	move	12(a6),d0
	bne.s	L12BC4
	addq	#1,12(a6)
	move.l	14(a6),a0
	move.l	#L1C227,(a0)
L12BC4:
	cmpi	#1,12(a6)
	beq.s	L12BE0
	pea	L1C22B
	move.l	8(a6),-(sp)
	jsr	L12296
	addq	#8,sp
	bra.s	L12C54
;
L12BE0:
	move.b	L46E22,d0
	bne.s	L12BF8
	pea	L1C246
	jsr	L63E0
	addq	#4,sp
	bra.s	L12C54
;
L12BF8:
	pea	L46E22
	move.l	8(a6),a0
	move.l	2894(a0),d0
	move.l	d0,-4(a6)
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	move.l	-4(a6),-(sp)
	jsr	L1206E
	addq	#8,sp
	move.l	-4(a6),-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L11FEC
	addq	#8,sp
	moveq	#16,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L61B4
	adda	#$A,sp
L12C54:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L12C58:
sys_edit_func:
	link	a6,#-22
	move.l	8(a6),a0
	clr	3600(a0)
	move.l	8(a6),a0
	move.l	2894(a0),-22(a6)
	cmpi	#1,12(a6)
	beq.s	L12C8C
	pea	L1C25F
	move.l	8(a6),-(sp)
	jsr	L12296
L12C86:
	addq	#8,sp
	bra	L12ED2
;
L12C8C:
	clr	-(sp)
	move.l	14(a6),a0
	move.l	(a0),d0
	move.l	d0,-18(a6)
	move.l	d0,-(sp)
	jsr	L5BB4
	addq	#6,sp
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	clr	-4(a6)
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-18(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-2(a6)
	bge.s	L12CE0
	moveq	#1,d0
	move	d0,-4(a6)
	move.l	-18(a6),-(sp)
	jsr	L4B74
	addq	#4,sp
	move	d0,-2(a6)
L12CE0:
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	bge.s	L12D06
	move.l	-18(a6),-(sp)
	pea	L1C26D
L12CFE:
	jsr	L63E0
	bra.s	L12C86
;
L12D06:
	move	-4(a6),d0
	beq.s	L12D32
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move.l	-18(a6),-(sp)
	pea	L1C281
	jsr	L63E0
	addq	#8,sp
	moveq	#1,d0
	move	d0,-(sp)
	bra	L12DC0
;
L12D32:
	clr	-8(a6)
L12D36:
	cmpi	#$63,-8(a6)
	bgt.s	L12D54
	move	-8(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	-22(a6),a0
	clr.b	(a0)
	addq	#1,-8(a6)
	bra.s	L12D36
;
L12D54:
	clr	-8(a6)
L12D58:
	cmpi	#$63,-8(a6)
	bge.s	L12DB2
	move.l	8(a6),a0
	pea	3600(a0)
	moveq	#78,d0
	move	d0,-(sp)
	move	-8(a6),d0
	muls	#80,d0
	add.l	-22(a6),d0
	move.l	d0,-14(a6)
	move.l	d0,-(sp)
	move	-2(a6),-(sp)
	jsr	L4C06
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq.s	L12DB2
	move.l	-14(a6),a0
	move.b	(a0),d0
	bne.s	L12DAC
	pea	L1C28D
	move.l	-14(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
L12DAC:
	addq	#1,-8(a6)
	bra.s	L12D58
;
L12DB2:
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	clr	-(sp)
L12DC0:
	moveq	#99,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L14DAE
	addq	#8,sp
	move	d0,-6(a6)
	move	-6(a6),d0
	beq	L12EC0
	move.l	-18(a6),-(sp)
	move	-6(a6),-(sp)
	pea	L1C28F
	jsr	L63E0
	adda	#$A,sp
	move	L2C0A6,-(sp)
	jsr	L3976
	addq	#2,sp
	move.l	-18(a6),-(sp)
	jsr	L4B74
	addq	#4,sp
	move	d0,-2(a6)
	move	L2C0A6,-(sp)
	jsr	L3852
	addq	#2,sp
	move	-2(a6),d0
	bge.s	L12E34
	move.l	-18(a6),-(sp)
	pea	L1C2A7
	bra	L12CFE
;
L12E34:
	clr	-8(a6)
L12E38:
	move	-8(a6),d0
	cmp	-6(a6),d0
	bge.s	L12E9E
	move	-8(a6),d0
	muls	#80,d0
	add.l	-22(a6),d0
	move.l	d0,-14(a6)
	move.l	d0,-(sp)
	jsr	L11FCA
	addq	#4,sp
	move	d0,-10(a6)
	move	-10(a6),-(sp)
	move.l	-14(a6),-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmp	-10(a6),d0
	beq.s	L12E82
	moveq	#-1,d0
	move	d0,-8(a6)
	bra.s	L12E9E
;
L12E82:
	moveq	#2,d0
	move	d0,-(sp)
	pea	L1C2C9
	move	-2(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	addq	#1,-8(a6)
	bra.s	L12E38
;
L12E9E:
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	cmpi	#$FFFF,-8(a6)
	bne.s	L12ED2
	move.l	-18(a6),-(sp)
	pea	L1C2CC
	bra	L12CFE
;
L12EC0:
	move	-4(a6),d0
	beq.s	L12ED2
	move.l	-18(a6),-(sp)
	jsr	task_Fdelete
	addq	#4,sp
L12ED2:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L12ED6:
sys_diskfree_func:
	link	a6,#-16
	move	12(a6),d0
	ble.s	L12EE8
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	bra.s	L12EEE
;
L12EE8:
	pea	L1C2E6
L12EEE:
	jsr	L1223A
	addq	#4,sp
	move	d0,-6(a6)
	pea	-16(a6)
	move	-6(a6),d0
	addq	#1,d0
	move	d0,-(sp)
	jsr	task_Dfree
	addq	#6,sp
	move	d0,d0
	bge.s	L12F32
	move	-6(a6),d0
	addi	#$41,d0
	move	d0,-(sp)
	pea	L1C2E7
	jsr	L63E0
	addq	#6,sp
	clr	-8(a6)
	bra	L12FCA
;
L12F32:
	moveq	#0,d0
	move	-10(a6),d0
	move.l	d0,-(sp)
	moveq	#0,d0
	move	-12(a6),d0
	move.l	d0,-(sp)
	jsr	L1812E
	addq	#8,sp
	move.l	d0,-4(a6)
	move	-6(a6),d0
	addi	#$41,d0
	move	d0,-(sp)
	pea	L1C301
	jsr	L63E0
	addq	#6,sp
	move.l	-4(a6),-(sp)
	moveq	#0,d0
	move	-14(a6),d0
	move.l	d0,-(sp)
	jsr	L1815A
	addq	#8,sp
	move.l	d0,-(sp)
	pea	L1C315
	jsr	L63E0
	addq	#8,sp
	move.l	-4(a6),-(sp)
	moveq	#0,d0
	move	-16(a6),d0
	move.l	d0,-(sp)
	jsr	L1815A
	addq	#8,sp
	move.l	d0,-(sp)
	pea	L1C332
	jsr	L63E0
	addq	#8,sp
	move.l	-4(a6),-(sp)
	moveq	#0,d0
	move	-16(a6),d0
	move.l	d0,-(sp)
	jsr	L1815A
	addq	#8,sp
	lsr.l	#8,d0
	lsr.l	#2,d0
	move	d0,-8(a6)
L12FCA:
	move	-8(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L12FD2:
sys_chat_func:
	link	a6,#0
	move	12(a6),d0
	ble.s	L13020
	pea	L1BDD6
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	beq.s	L13020
	pea	L1BDDA
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	beq.s	L13020
	pea	L1C350
	move.l	8(a6),-(sp)
	jsr	L12296
	addq	#8,sp
	bra.s	L13096
;
L13020:
	move	12(a6),d0
	ble.s	L1305C
	pea	L1BDD6
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	L13042
	moveq	#1,d0
	bra.s	L13044
;
L13042:
	clr	d0
L13044:
	move	d0,L36740
	moveq	#1,d0
	move	d0,-(sp)
	move	L315FA,-(sp)
	jsr	L37D0
	addq	#4,sp
L1305C:
	move	L36740,d0
	beq.s	L1306C
	pea	L1BDD6
	bra.s	L13072
;
L1306C:
	pea	L1BDDA
L13072:
	move	12(a6),d0
	beq.s	L13080
	pea	L1C36E
	bra.s	L13086
;
L13080:
	pea	L1C372
L13086:
	pea	L1C360
	jsr	L63E0
	adda	#$C,sp
L13096:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1309A:
sys_debug_func:
	link	a6,#0
	move	12(a6),d0
	ble.s	L130E8
	pea	L1BDD6
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	beq.s	L130E8
	pea	L1BDDA
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	beq.s	L130E8
	pea	L1C37C
	move.l	8(a6),-(sp)
	jsr	L12296
	addq	#8,sp
	bra.s	L13150
;
L130E8:
	move	12(a6),d0
	ble.s	L13114
	pea	L1BDD6
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	L1310A
	moveq	#1,d0
	bra.s	L1310C
;
L1310A:
	clr	d0
L1310C:
	move.l	8(a6),a0
	move	d0,2972(a0)
L13114:
	move.l	8(a6),a0
	move	2972(a0),d0
	beq.s	L13126
	pea	L1BDD6
	bra.s	L1312C
;
L13126:
	pea	L1BDDA
L1312C:
	move	12(a6),d0
	beq.s	L1313A
	pea	L1C39C
	bra.s	L13140
;
L1313A:
	pea	L1C3A0
L13140:
	pea	L1C38D
	jsr	L63E0
	adda	#$C,sp
L13150:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L13154:
sys_addfiles_func:
	link	a6,#-506
	move.l	8(a6),a0
	move.l	2894(a0),-506(a6)
	cmpi	#1,12(a6)
	beq.s	L13180
	pea	L1C3AA
	move.l	8(a6),-(sp)
	jsr	L12296
L1317A:
	addq	#8,sp
	bra	L13490
;
L13180:
	pea	L1C3BC
	pea	-488(a6)
	jsr	L11FEC
	addq	#8,sp
	moveq	#1,d0
	move	d0,-500(a6)
	clr	-494(a6)
	move.l	8(a6),a0
	move.l	2894(a0),-468(a6)
	clr	-(sp)
	clr	-(sp)
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	L69CA
	adda	#$C,sp
	move	d0,-490(a6)
	bne.s	L131D8
	move.l	L1892C,-(sp)
	pea	L1C3C2
	jsr	L63E0
	bra.s	L1317A
;
L131D8:
	clr	-(sp)
	pea	L1C3CF
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-496(a6)
	cmpi	#$FFFF,d0
	beq	L13490
L131FA:
	move	-490(a6),d0
	beq	L13490
	move.l	-468(a6),a0
	move.l	6(a0),-(sp)
	move.l	-468(a6),a0
	pea	10(a0)
	pea	L1C3EA
	jsr	L63E0
	adda	#$C,sp
	moveq	#1,d0
	move	d0,-(sp)
	pea	L1C3FB
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-492(a6)
	cmpi	#$FFFF,d0
	beq	L13490
	cmpi	#1,-492(a6)
	bne	L1347C
	clr	-(sp)
	move	#$1D0,-(sp)
	pea	-464(a6)
	jsr	L10C
	addq	#8,sp
	move.l	-468(a6),a0
	pea	10(a0)
	pea	-464(a6)
	jsr	L11FEC
	addq	#8,sp
	pea	-488(a6)
	pea	L1C3FC
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	moveq	#20,d0
	move	d0,-(sp)
	pea	-450(a6)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move.b	-450(a6),d0
	bne.s	L132B0
	pea	-488(a6)
	pea	-450(a6)
	bra.s	L132B8
;
L132B0:
	pea	-450(a6)
	pea	-488(a6)
L132B8:
	jsr	L11FEC
	addq	#8,sp
	move	-496(a6),d0
	beq.s	L132CE
	jsr	L6944
	bra.s	L132D6
;
L132CE:
	move.l	-468(a6),a0
	move	4(a0),d0
L132D6:
	move	d0,-430(a6)
	move	-496(a6),d0
	beq.s	L132E8
	jsr	L6988
	bra.s	L132F0
;
L132E8:
	move.l	-468(a6),a0
	move	2(a0),d0
L132F0:
	move	d0,-428(a6)
	move.l	-468(a6),a0
	move.l	6(a0),-426(a6)
	clr	-422(a6)
	clr	-416(a6)
L13306:
	move	-494(a6),-(sp)
	move.l	L1AEAA,-(sp)
	pea	L1C40E
	jsr	L63E0
	adda	#$A,sp
	clr	-(sp)
	moveq	#-2,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	move	d0,-420(a6)
	cmpi	#$FFFF,d0
	beq	L13490
	move.l	8(a6),a0
	move.b	2638(a0),d0
	bne.s	L13358
	move	-494(a6),-420(a6)
L13358:
	move	-420(a6),-494(a6)
	move	-420(a6),d0
	blt.s	L13306
	cmpi	#4,-420(a6)
	bgt.s	L13306
	pea	L1C424
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	move	-500(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	LA492
	adda	#$A,sp
	pea	L1C42F
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#50,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2638(a0)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	L13490
	move.l	8(a6),-(sp)
	jsr	LA6D8
	addq	#4,sp
	move	d0,-418(a6)
	bne.s	L133E0
	move	-500(a6),-418(a6)
	bra.s	L133E6
;
L133E0:
	move	-418(a6),-500(a6)
L133E6:
	clr	-498(a6)
L133EA:
	cmpi	#5,-498(a6)
	bge.s	L13416
	pea	L1C43F
	move	-498(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	a6,a0
	pea	-400(a0)
	jsr	L11FEC
	addq	#8,sp
	addq	#1,-498(a6)
	bra.s	L133EA
;
L13416:
	pea	L1C440
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	moveq	#80,d0
	move	d0,-(sp)
	pea	-400(a6)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq.s	L13490
	pea	-464(a6)
	jsr	L84F2
	addq	#4,sp
	move	d0,-502(a6)
	bne.s	L13464
	pea	L1C44F
	jsr	L63E0
	addq	#4,sp
	bra.s	L1347C
;
L13464:
	move	-502(a6),-(sp)
	pea	-464(a6)
	pea	L1C467
	jsr	L63E0
	adda	#$A,sp
L1347C:
	subq	#1,-490(a6)
	move.l	-468(a6),a0
	adda	#$18,a0
	move.l	a0,-468(a6)
	bra	L131FA
;
L13490:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L13494:
sys_move_func:
	link	a6,#-150
	cmpi	#2,12(a6)
	beq.s	L134B6
	pea	L1C47E
	move.l	8(a6),-(sp)
	jsr	L12296
L134B0:
	addq	#8,sp
	bra	L13814
;
L134B6:
	move.l	8(a6),a0
	move.l	2894(a0),-150(a6)
	moveq	#49,d0
	move	d0,-(sp)
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	pea	-82(a6)
	jsr	L12008
	adda	#$A,sp
	pea	-82(a6)
	jsr	L121C8
	addq	#4,sp
	move	d0,d0
	beq.s	L134FA
	pea	L1C499
	pea	-82(a6)
	jsr	L1206E
	addq	#8,sp
L134FA:
	moveq	#49,d0
	move	d0,-(sp)
	move.l	14(a6),a0
	move.l	4(a0),-(sp)
	pea	-146(a6)
	jsr	L12008
	adda	#$A,sp
	pea	-146(a6)
	jsr	L121C8
	addq	#4,sp
	move	d0,d0
	bne.s	L13536
	pea	L1C49D
L1352A:
	jsr	L63E0
	addq	#4,sp
	bra	L13814
;
L13536:
	clr	-(sp)
	clr	-(sp)
	pea	-82(a6)
	move.l	8(a6),-(sp)
	jsr	L69CA
	adda	#$C,sp
	move	d0,-6(a6)
	bne.s	L13568
	move.l	L1892C,-(sp)
	pea	L1C4BF
	jsr	L63E0
	bra	L134B0
;
L13568:
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	jsr	L1223A
	addq	#4,sp
	move.b	d0,-16(a6)
	move.l	14(a6),a0
	move.l	4(a0),-(sp)
	jsr	L1223A
	addq	#4,sp
	move.b	d0,-18(a6)
	move	-6(a6),d0
	muls	#$18,d0
	move	d0,-10(a6)
	move.l	8(a6),a0
	move	-10(a6),d0
	ext.l	d0
	add.l	2894(a0),d0
	move.l	d0,-14(a6)
	move	#$2000,d0
	sub	-10(a6),d0
	move	d0,-10(a6)
	cmpi	#$200,-10(a6)
	bge.s	L135DA
	move.b	-18(a6),d1
	ext.w	d1
	move.b	-16(a6),d0
	ext.w	d0
	cmp	d1,d0
	beq.s	L135DA
	pea	L1C4C8
	bra	L1352A
;
L135DA:
	move.b	-18(a6),d1
	ext.w	d1
	move.b	-16(a6),d0
	ext.w	d0
	cmp	d1,d0
	beq.s	L135FC
	move	-10(a6),-(sp)
	pea	L1BDDE
	jsr	L63E0
	addq	#6,sp
L135FC:
	move	-6(a6),d0
	beq	L13814
	moveq	#49,d0
	move	d0,-(sp)
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	pea	-82(a6)
	jsr	L12008
	adda	#$A,sp
	moveq	#49,d0
	move	d0,-(sp)
	move.l	14(a6),a0
	move.l	4(a0),-(sp)
	pea	-146(a6)
	jsr	L12008
	adda	#$A,sp
	move.l	-150(a6),a0
	pea	10(a0)
	pea	-82(a6)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
	move.l	-150(a6),a0
	pea	10(a0)
	pea	-146(a6)
	jsr	L1206E
	addq	#8,sp
	pea	-146(a6)
	pea	-82(a6)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	L1369E
	pea	L1C4DE
L13682:
	jsr	L63E0
	addq	#4,sp
L1368A:
	subq	#1,-6(a6)
	move.l	-150(a6),a0
	adda	#$18,a0
	move.l	a0,-150(a6)
	bra	L135FC
;
L1369E:
	pea	-146(a6)
	pea	-82(a6)
	pea	L1C507
	jsr	L63E0
	adda	#$C,sp
	pea	L1C535
	move.l	8(a6),-(sp)
	jsr	L6A98
	addq	#8,sp
	move.l	#L18642,a0
	move	#6,d1
	bra.s	L136D6
;
L136D4:
	addq	#4,a0
L136D6:
	cmp	(a0)+,d0
	dbeq	d1,L136D4
	move.l	(a0),a0
	jmp	(a0)
;
L136E0:
	bra.s	L1368A
;
L136E2:
	pea	L1C53C
	jsr	L63E0
	addq	#4,sp
	move.b	-18(a6),d1
	ext.w	d1
	move.b	-16(a6),d0
	ext.w	d0
	cmp	d1,d0
	bne.s	L13730
	pea	-146(a6)
	jsr	task_Fdelete
	addq	#4,sp
	pea	-146(a6)
	pea	-82(a6)
	jsr	task_Frename
	addq	#8,sp
	move	d0,d0
	beq.s	L13752
	pea	L1C540
	jsr	L63E0
	addq	#4,sp
	bra.s	L13752
;
L13730:
	moveq	#1,d0
	move	d0,-(sp)
	move	-10(a6),-(sp)
	move.l	-14(a6),-(sp)
	pea	-146(a6)
	pea	-82(a6)
	move.l	8(a6),-(sp)
	jsr	L13A82
	adda	#$14,sp
L13752:
	move.b	L18930,d0
	beq	L1368A
	clr	-(sp)
	pea	-146(a6)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-8(a6)
	ble	L1368A
	pea	-4(a6)
	pea	-2(a6)
	move	-8(a6),-(sp)
	jsr	task_Fgetdatime
	adda	#$A,sp
	clr	-(sp)
	move	-2(a6),-(sp)
	move	-8(a6),-(sp)
	jsr	task_Fsetdatime
	addq	#6,sp
	move	-8(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	bra	L1368A
;
L137AA:
	pea	L1C55A
	bra	L13682
;
L137B4:
	moveq	#1,d0
	move	d0,-(sp)
	pea	L1C55D
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	cmpi	#1,d0
	bne	L1368A
	pea	-82(a6)
	jsr	task_Fdelete
	addq	#4,sp
	move	d0,d0
	beq	L1368A
	pea	-82(a6)
	pea	L1C565
	jsr	L63E0
	addq	#8,sp
	bra	L1368A
;
L137FC:
	pea	L1C57B
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-6(a6)
	bra	L1368A
;
L13814:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L13818
sys_alert_func:
	link	a6,#0
	move.l	8(a6),a0
	moveq	#30,d0
	move	d0,2602(a0)
	pea	L1C580
	jsr	L63E0
	addq	#4,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L13838:
sys_type_func:
	link	a6,#0
	cmpi	#1,12(a6)
	beq.s	L13858
	pea	L1C595
	move.l	8(a6),-(sp)
	jsr	L12296
	addq	#8,sp
	bra.s	L1387A
;
L13858:
	move.l	14(a6),a0
	move.l	#L1C5A3,4(a0)
	move.l	14(a6),-(sp)
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	sys_download_func
	adda	#$A,sp
L1387A:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1387E:
sys_copy_func:
	link	a6,#-536
	cmpi	#2,12(a6)
	beq.s	L138A0
	pea	L1C5A5
	move.l	8(a6),-(sp)
	jsr	L12296
L1389A:
	addq	#8,sp
	bra	L13A7E
;
L138A0:
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-516(a6)
	move.l	8(a6),d0
	addi.l	#$ACE,d0
	move.l	d0,-520(a6)
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	move.l	-516(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	move.l	14(a6),a0
	move.l	4(a0),-(sp)
	move.l	-520(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	clr	-(sp)
	move.l	-516(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	clr	-(sp)
	move.l	-520(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	move.l	8(a6),a0
	move.l	2894(a0),-536(a6)
	clr	-(sp)
	clr	-(sp)
	move.l	-516(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L69CA
	adda	#$C,sp
	move	d0,-530(a6)
	bne.s	L1393A
	move.l	L1892C,-(sp)
	pea	L1C5BD
	jsr	L63E0
	bra	L1389A
;
L1393A:
	clr	-532(a6)
	move.l	-520(a6),-(sp)
	jsr	L121C8
	addq	#4,sp
	move	d0,d0
	bne.s	L1396E
	cmpi	#1,-530(a6)
	ble.s	L13968
	pea	L1C5C6
	jsr	L63E0
	addq	#4,sp
	bra	L13A7E
;
L13968:
	moveq	#1,d0
	move	d0,-532(a6)
L1396E:
	move	-530(a6),d0
	muls	#$18,d0
	move	d0,-526(a6)
	move.l	8(a6),a0
	move	-526(a6),d0
	ext.l	d0
	add.l	2894(a0),d0
	move.l	d0,-524(a6)
	move	#$2000,d0
	sub	-526(a6),d0
	move	d0,-526(a6)
	cmpi	#$200,-526(a6)
	bge.s	L139AE
	lea	-512(a6),a0
	move.l	a0,-524(a6)
	move	#$200,-526(a6)
L139AE:
	move	-526(a6),-(sp)
	pea	L1BDDE
	jsr	L63E0
	addq	#6,sp
L139C0:
	move	-530(a6),d0
	beq	L13A7E
	move.l	-536(a6),a0
	pea	10(a0)
	move.l	-516(a6),-(sp)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
	move	-532(a6),d0
	bne.s	L13A0A
	move.l	-536(a6),a0
	pea	10(a0)
	move.l	-520(a6),-(sp)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
L13A0A:
	move.l	-520(a6),-(sp)
	move.l	-516(a6),-(sp)
	pea	L1C5DA
	jsr	L63E0
	adda	#$C,sp
	clr	-(sp)
	pea	L1C5EA
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-528(a6)
	cmpi	#$FFFF,d0
	beq.s	L13A7E
	cmpi	#1,-528(a6)
	bne.s	L13A6A
	clr	-(sp)
	move	-526(a6),-(sp)
	move.l	-524(a6),-(sp)
	move.l	-520(a6),-(sp)
	move.l	-516(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L13A82
	adda	#$14,sp
L13A6A:
	subq	#1,-530(a6)
	move.l	-536(a6),a0
	adda	#$18,a0
	move.l	a0,-536(a6)
	bra	L139C0
;
L13A7E:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L13A82:
	link	a6,#-8
	clr	-(sp)
	move.l	12(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-2(a6)
	bgt.s	L13AB2
	move.l	12(a6),-(sp)
	pea	L1C5EB
L13AA4:
	jsr	L63E0
	addq	#8,sp
L13AAC:
	clr	d0
	bra	L13B82
;
L13AB2:
	move.l	16(a6),-(sp)
	jsr	L4B74
	addq	#4,sp
	move	d0,-4(a6)
	bgt.s	L13ADC
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move.l	16(a6),-(sp)
	pea	L1C5FF
	bra.s	L13AA4
;
L13ADC:
	clr	-6(a6)
L13AE0:
	move	24(a6),-(sp)
	move.l	20(a6),-(sp)
	move	-2(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move	d0,-8(a6)
	ble.s	L13B20
	move	-8(a6),-(sp)
	move.l	20(a6),-(sp)
	move	-4(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmp	-8(a6),d0
	beq.s	L13B18
	moveq	#1,d0
	bra.s	L13B1A
;
L13B18:
	clr	d0
L13B1A:
	move	d0,-6(a6)
	beq.s	L13AE0
L13B20:
	move	-2(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move	-4(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move	-8(a6),d0
	bge.s	L13B60
	pea	L1C615
L13B44:
	move.l	8(a6),-(sp)
	jsr	L6602
	addq	#8,sp
	move.l	16(a6),-(sp)
	jsr	task_Fdelete
	addq	#4,sp
	bra	L13AAC
;
L13B60:
	move	-6(a6),d0
	beq.s	L13B6E
	pea	L1C62E
	bra.s	L13B44
;
L13B6E:
	move	26(a6),d0
	beq.s	L13B80
	move.l	12(a6),-(sp)
	jsr	task_Fdelete
	addq	#4,sp
L13B80:
	moveq	#1,d0
L13B82:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L13B86:
sys_screen_func:
	link	a6,#-1774
	cmpi	#1,12(a6)
	bne.s	L13BB2
	move.l	14(a6),a0
	move.l	(a0),-(sp)
	jsr	L12092
	addq	#4,sp
	move	d0,-2(a6)
	cmpi	#1,d0
	blt.s	L13BB2
	cmpi	#$F,-2(a6)
	ble.s	L13C16
L13BB2:
	clr	-2(a6)
L13BB6:
	cmpi	#$F,-2(a6)
	bge.s	L13C04
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L18874,a0
	adda.l	d0,a0
	move.l	(a0),-1774(a6)
L13BD2:
	move.l	-1774(a6),a0
	cmpi.b	#$2D,(a0)
	bne.s	L13BE2
	addq.l	#1,-1774(a6)
	bra.s	L13BD2
;
L13BE2:
	move.l	-1774(a6),-(sp)
	move	-2(a6),d0
	addq	#1,d0
	move	d0,-(sp)
	pea	L1C64B
	jsr	L63E0
	adda	#$A,sp
	addq	#1,-2(a6)
	bra.s	L13BB6
;
L13C04:
	pea	L1C653
	jsr	L63E0
	addq	#4,sp
	bra	L13CD4
;
L13C16:
	move	-2(a6),d0
	subq	#1,d0
	move	d0,-(sp)
	pea	-1766(a6)
	jsr	L7148
	addq	#6,sp
	clr	-4(a6)
L13C2E:
	cmpi	#$16,-4(a6)
	bge.s	L13C7E
	move	-4(a6),d0
	muls	#80,d0
	add.l	a6,d0
	subi.l	#$6E6,d0
	move.l	d0,-1770(a6)
	move.l	-1770(a6),d0
	addi.l	#$4F,d0
	move.l	d0,-1774(a6)
L13C58:
	move.l	-1774(a6),a0
	cmp.l	-1770(a6),a0
	bcs.s	L13C78
	move.l	-1774(a6),a0
	cmpi.b	#$20,(a0)
	bne.s	L13C78
	move.l	-1774(a6),a0
	clr.b	(a0)
	subq.l	#1,-1774(a6)
	bra.s	L13C58
;
L13C78:
	addq	#1,-4(a6)
	bra.s	L13C2E
;
L13C7E:
	moveq	#21,d0
	move	d0,-6(a6)
L13C84:
	move	-6(a6),d0
	blt.s	L13CA2
	move	-6(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	a6,a0
	move.b	-1766(a0),d0
	bne.s	L13CA2
	subq	#1,-6(a6)
	bra.s	L13C84
;
L13CA2:
	clr	-4(a6)
L13CA6:
	move	-4(a6),d0
	cmp	-6(a6),d0
	bgt.s	L13CD4
	move	-4(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	a6,a0
	pea	-1766(a0)
	pea	L1C664
	jsr	L63E0
	addq	#8,sp
	addq	#1,-4(a6)
	bra.s	L13CA6
;
L13CD4:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L13CD8:
sys_delete_func:
	link	a6,#-16
	cmpi	#1,12(a6)
	beq.s	L13CFA
	pea	L1C66C
	move.l	8(a6),-(sp)
	jsr	L12296
L13CF4:
	addq	#8,sp
	bra	L13E26
;
L13CFA:
	move.l	14(a6),a0
	move.l	(a0),d0
	move.l	d0,-8(a6)
	move.l	d0,-(sp)
	jsr	L121C8
	addq	#4,sp
	move	d0,d0
	beq.s	L13D24
	pea	L1C67C
	move.l	-8(a6),-(sp)
	jsr	L1206E
	addq	#8,sp
L13D24:
	clr	-(sp)
	clr	-(sp)
	move.l	-8(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L69CA
	adda	#$C,sp
	move	d0,-2(a6)
	bne.s	L13D54
	move.l	L1892C,-(sp)
	pea	L1C680
	jsr	L63E0
	bra.s	L13CF4
;
L13D54:
	move.l	8(a6),a0
	move.l	2894(a0),-16(a6)
	move.l	-8(a6),-(sp)
	jsr	L563C
	addq	#4,sp
	move.l	d0,a0
	clr.b	(a0)
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-12(a6)
L13D7C:
	move	-2(a6),d0
	beq	L13E26
	move.l	-8(a6),-(sp)
	move.l	-12(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	move.l	-16(a6),a0
	pea	10(a0)
	move.l	-12(a6),-(sp)
	jsr	L1206E
	addq	#8,sp
	clr	-(sp)
	move.l	-12(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	move.l	-16(a6),a0
	move	2(a0),-(sp)
	move.l	-16(a6),a0
	move	4(a0),-(sp)
	move.l	-16(a6),a0
	pea	10(a0)
	pea	L1C68B
	jsr	L63E0
	adda	#$C,sp
	clr	-(sp)
	pea	L1C69F
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-4(a6)
	cmpi	#$FFFF,d0
	beq.s	L13E26
	cmpi	#1,-4(a6)
	bne.s	L13E12
	move.l	-12(a6),-(sp)
	jsr	task_Fdelete
	addq	#4,sp
L13E12:
	subq	#1,-2(a6)
	move.l	-16(a6),a0
	adda	#$18,a0
	move.l	a0,-16(a6)
	bra	L13D7C
;
L13E26:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L13E2A:
sys_listarc_func:
	link	a6,#-16
	cmpi	#1,12(a6)
	beq.s	L13E4C
	pea	L1C6A0
	move.l	8(a6),-(sp)
	jsr	L12296
L13E46:
	addq	#8,sp
	bra	L13F88
;
L13E4C:
	move.l	14(a6),a0
	move.l	(a0),d0
	move.l	d0,-8(a6)
	move.l	d0,-(sp)
	jsr	L121C8
	addq	#4,sp
	move	d0,d0
	beq.s	L13E76
	pea	L1C6B1
	move.l	-8(a6),-(sp)
	jsr	L1206E
	addq	#8,sp
L13E76:
	pea	L1C6B7
	move.l	-8(a6),-(sp)
	jsr	L12216
	addq	#4,sp
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
	clr	-(sp)
	clr	-(sp)
	move.l	-8(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L69CA
	adda	#$C,sp
	move	d0,-2(a6)
	bne.s	L13EC2
	move.l	L1892C,-(sp)
	pea	L1C6BC
	jsr	L63E0
	bra.s	L13E46
;
L13EC2:
	move.l	8(a6),a0
	move.l	2894(a0),-16(a6)
	move.l	-8(a6),-(sp)
	jsr	L563C
	addq	#4,sp
	move.l	d0,a0
	clr.b	(a0)
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-12(a6)
L13EEA:
	move	-2(a6),d0
	beq	L13F88
	move.l	-8(a6),-(sp)
	move.l	-12(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	move.l	-16(a6),a0
	pea	10(a0)
	move.l	-12(a6),-(sp)
	jsr	L1206E
	addq	#8,sp
	clr	-(sp)
	move.l	-12(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	move.l	-16(a6),a0
	pea	10(a0)
	pea	L1C6C8
	jsr	L63E0
	addq	#8,sp
	moveq	#1,d0
	move	d0,-(sp)
	pea	L1C6DC
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	move	d0,-4(a6)
	cmpi	#$FFFF,d0
	beq.s	L13F88
	cmpi	#1,-4(a6)
	bne.s	L13F74
	move.l	-12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L1637C
	addq	#8,sp
L13F74:
	subq	#1,-2(a6)
	move.l	-16(a6),a0
	adda	#$18,a0
	move.l	a0,-16(a6)
	bra	L13EEA
;
L13F88:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L13F8C:
sys_rename_func:
	link	a6,#-8
	cmpi	#2,12(a6)
	beq.s	L13FAE
	pea	L1C6DD
	move.l	8(a6),-(sp)
	jsr	L12296
	addq	#8,sp
	bra	L14042
;
L13FAE:
	clr	-(sp)
	move.l	14(a6),a0
	move.l	(a0),d0
	move.l	d0,-4(a6)
	move.l	d0,-(sp)
	jsr	L5BB4
	addq	#6,sp
	clr	-(sp)
	move.l	14(a6),a0
	move.l	4(a0),d0
	move.l	d0,-8(a6)
	move.l	d0,-(sp)
	jsr	L5BB4
	addq	#6,sp
	move.l	-8(a6),-(sp)
	jsr	L121C8
	addq	#4,sp
	move	d0,d0
	beq.s	L14006
	move.l	-4(a6),-(sp)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-(sp)
	move.l	-8(a6),-(sp)
	jsr	L1206E
	addq	#8,sp
L14006:
	move.l	-8(a6),-(sp)
	move.l	-4(a6),-(sp)
	jsr	task_Frename
	addq	#8,sp
	move	d0,d0
	beq.s	L1402A
	move.l	-8(a6),-(sp)
	move.l	-4(a6),-(sp)
	pea	L1C6F6
	bra.s	L14038
;
L1402A:
	move.l	-8(a6),-(sp)
	move.l	-4(a6),-(sp)
	pea	L1C711
L14038:
	jsr	L63E0
	adda	#$C,sp
L14042:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L14046:
sys_hello_func:
	link	a6,#0
	moveq	#7,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	pea	2902(a0)
	jsr	L188
	addq	#6,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L14062:
sys_batch_func:
	link	a6,#-8
	cmpi	#1,12(a6)
	bge.s	L14082
	pea	L1C722
	move.l	8(a6),-(sp)
	jsr	L12296
	bra	L14188
;
L14082:
	move.l	L1893E,-(sp)
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),-(sp)
	jsr	L154C8
	addq	#4,sp
	clr	-2(a6)
	clr	-4(a6)
L140A4:
	move	-2(a6),d0
	bne	L1414E
	move	-4(a6),d0
	cmp	12(a6),d0
	bge	L1414E
	move	-4(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	move.l	d0,a0
	adda.l	14(a6),a0
	move.l	(a0),-(sp)
	jsr	L1219C
	addq	#4,sp
	move.l	d0,-8(a6)
	moveq	#63,d0
	move	d0,-(sp)
	move.l	-8(a6),-(sp)
	jsr	L120D4
	addq	#6,sp
	move	d0,d0
	bge.s	L140FC
	moveq	#42,d0
	move	d0,-(sp)
	move.l	-8(a6),-(sp)
	jsr	L120D4
	addq	#6,sp
	move	d0,d0
	blt.s	L14102
L140FC:
	addq	#1,-4(a6)
	bra.s	L140A4
;
L14102:
	clr	-(sp)
	move.l	-8(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L15572
	adda	#$A,sp
	move	d0,-2(a6)
	bne.s	L140FC
	move.l	8(a6),a0
	addq	#1,52(a0)
	move.l	8(a6),-(sp)
	jsr	LF400
	addq	#4,sp
	move.l	-8(a6),-(sp)
	move.l	8(a6),a0
	pea	2(a0)
	pea	L1C73C
	jsr	L6526
	adda	#$C,sp
	bra.s	L140FC
;
L1414E:
	move	-2(a6),d0
	bne.s	L1416A
	clr	-(sp)
	pea	L1C75C
	move.l	8(a6),-(sp)
	jsr	L15572
	adda	#$A,sp
L1416A:
	move.l	8(a6),-(sp)
	jsr	L15536
	addq	#4,sp
	move	-2(a6),-(sp)
	moveq	#4,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L79CE
L14188:
	addq	#8,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L1418E:
sys_cls_func:
	link	a6,#0
	pea	L1C75D
	jsr	L63E0
	addq	#4,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L141A4:
sys_who_func:
	link	a6,#-4
	moveq	#3,d0
	move	d0,-4(a6)
L141AE:
	move	-4(a6),d0
	beq.s	L141C8
	move	-4(a6),a0
	adda.l	#L46B27,a0
	move.b	(a0),d0
	bne.s	L141C8
	subq	#1,-4(a6)
	bra.s	L141AE
;
L141C8:
	pea	L1C75F
	jsr	L63E0
	addq	#4,sp
	clr	-2(a6)
L141DA:
	move	-2(a6),d0
	cmp	-4(a6),d0
	bgt	L14278
	move	-2(a6),d0
	beq.s	L14200
	move	-2(a6),a0
	adda.l	#L46B27,a0
	move.b	(a0),d0
	bne.s	L14200
L141FA:
	addq	#1,-2(a6)
	bra.s	L141DA
;
L14200:
	move	-2(a6),d0
	muls	#$1016,d0
	lea	L2DFBA,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	move	-2(a6),d0
	muls	#$1016,d0
	addi.l	#$2DFBE,d0
	move.l	d0,-(sp)
	move	-2(a6),d0
	muls	#$1016,d0
	lea	L2DFAE,a0
	adda.l	d0,a0
	move	(a0),d0
	beq.s	L1423E
	pea	L1C7DA
	bra.s	L14244
;
L1423E:
	pea	L1C7E6
L14244:
	move	-2(a6),d0
	muls	#$1016,d0
	addi.l	#$2D58C,d0
	move.l	d0,-(sp)
	move	-2(a6),d0
	muls	#$1016,d0
	lea	L2DFB6,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	pea	L1C7BD
	jsr	L63E0
	adda	#$18,sp
	bra.s	L141FA
;
L14278:
	move	-4(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L14280:
sys_critical_func:
	link	a6,#0
	move	L1819A,-(sp)
	pea	L1C7F2
	jsr	L63E0
	addq	#6,sp
	move	L1819A,d0
	beq.s	L142C4
	moveq	#1,d0
	move	d0,-(sp)
	pea	L1C813
	move.l	8(a6),-(sp)
	jsr	L5840
	adda	#$A,sp
	cmpi	#1,d0
	bne.s	L142C4
	clr	L1819A
L142C4:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
;L142C8:
sys_exit_func:
	link	a6,#0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
sys_help_func:
	link	a6,#-12
	move.l	8(a6),a0
	move	32(a0),d0
	addi	#$30,d0
	move.b	d0,-10(a6)
	pea	sys_available_commands_s
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	move	d0,-12(a6)
	move.l	#sys_sysop_shell_struct,-4(a6)
.L14300:
	move.l	-4(a6),a0
	move.l	(a0),d0
	beq.s	.L14364
	move.l	-4(a6),a0
	move.l	(a0),-8(a6)
	move.l	-8(a6),a0
	addq.l	#1,-8(a6)
	move.b	(a0),d1
	ext.w	d1
	move.b	-10(a6),d0
	ext.w	d0
	cmp	d1,d0
	bge.s	.L1432C
.L14326:
	addq.l	#8,-4(a6)
	bra.s	.L14300
;
.L1432C:
	move	-12(a6),d0
	ext.l	d0
	divs	#7,d0
	swap	d0
	move	d0,d0
	beq.s	.L14344
	pea	L1C93D
	bra.s	.L1434A
;
.L14344:
	pea	L1C93E
.L1434A:
	move.l	-8(a6),-(sp)
	pea	L1C935
	jsr	L63E0
	adda	#$C,sp
	addq	#1,-12(a6)
	bra.s	.L14326
;
.L14364:
	pea	L1C940
	jsr	L63E0
	addq	#4,sp
	clr	d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L14378:
	link	a6,#-192
	move.l	8(a6),a0
	addq	#1,2976(a0)
	move	2976(a0),d0
	cmpi	#2,d0
	bgt	.L14526
	move.l	8(a6),-(sp)
	jsr	L122F0
	addq	#4,sp
	clr	-6(a6)
.L143A0:
	move	-6(a6),d0
	bne	.L14526
	move.l	8(a6),a0
	move.l	#sys_sysop_shell_s,2608(a0)
	move.l	8(a6),a0
	move	32(a0),d0
	addi	#$30,d0
	move.b	d0,-146(a6)
	move.l	8(a6),a0
	cmpi	#1,2976(a0)
	ble.s	.L143D8
	pea	L1C95C
	bra.s	.L143DE
;
.L143D8:
	pea	L1C95F
.L143DE:
	pea	sys_x_command_s
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	moveq	#60,d0
	move	d0,-(sp)
	pea	-136(a6)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	.L14526
	clr	-8(a6)
	moveq	#10,d0
	move	d0,-(sp)
	pea	-136(a6)
	pea	-190(a6)
	jsr	L5692
	adda	#$A,sp
	move	d0,-192(a6)
	bne.s	.L14438
	move.l	#sys_help_s,-190(a6)
	addq	#1,-192(a6)
.L14438:
	clr	-8(a6)
	move.l	#sys_sysop_shell_struct,-4(a6)
.L14444:
	move.l	-4(a6),a0
	move.l	(a0),d0
	beq.s	.L1449A
	move.l	-4(a6),a0
	move.l	(a0),-144(a6)
	move.l	-144(a6),a0
	addq.l	#1,-144(a6)
	move.b	(a0),d1
	ext.w	d1
	move.b	-146(a6),d0
	ext.w	d0
	cmp	d1,d0
	bge.s	.L14470
.L1446A:
	addq.l	#8,-4(a6)
	bra.s	.L14444
;
.L14470:
	move.l	-144(a6),-(sp)
	move.l	-190(a6),-(sp)
	jsr	L55EC
	addq	#8,sp
	move	d0,d0
	bne.s	.L1446A
	move.l	-144(a6),-140(a6)
	addq	#1,-8(a6)
	move.l	-4(a6),a0
	move.l	4(a0),-150(a6)
	bra.s	.L1446A
;
.L1449A:
	move	-8(a6),d0
	bne.s	.L144B6
	pea	-136(a6)
	pea	sys_unknown_command_x_s
	jsr	L63E0
	addq	#8,sp
	bra	.L143A0
;
.L144B6:
	cmpi	#1,-8(a6)
	ble.s	.L144D0
	pea	sys_please_be_more_specific_s
	jsr	L63E0
	addq	#4,sp
	bra	.L143A0
;
.L144D0:
	cmpi	#1,-8(a6)
	bne	.L143A0
	pea	L1C993
	jsr	L63E0
	addq	#4,sp
	pea	-186(a6)
	move	-192(a6),d0
	subq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	move.l	-150(a6),a0
	jsr	(a0)
	adda	#$A,sp
	pea	sys_exit_s
	move.l	-140(a6),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	.L1451C
	moveq	#1,d0
	bra.s	.L1451E
;
.L1451C:
	clr	d0
.L1451E:
	move	d0,-6(a6)
	bra	.L143A0
;
.L14526:
	move.l	8(a6),a0
	subq	#1,2976(a0)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L14532:
	link	a6,#-186
	lea	-52(a6),a0
	move.l	a0,-12(a6)
	move.l	12(a6),-(sp)
	pea	-180(a6)
	jsr	L11FEC
	addq	#8,sp
	moveq	#10,d0
	move	d0,-(sp)
	pea	-180(a6)
	move.l	-12(a6),-(sp)
	jsr	L5692
	adda	#$A,sp
	move	d0,-186(a6)
	bne.s	.L1457A
	move.l	8(a6),-(sp)
	jsr	L14378
.L14574:
	addq	#4,sp
	bra	.L14668
;
.L1457A:
	move.l	#sys_sysop_shell_struct,-8(a6)
.L14582:
	move.l	-8(a6),a0
	move.l	(a0),-184(a6)
	beq	.L14654
	addq.l	#1,-184(a6)
	move.l	-184(a6),d0
	move.l	d0,-(sp)
	move.l	-12(a6),a0
	move.l	(a0),-(sp)
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne	.L1464C
	cmpi	#1,-186(a6)
	bgt.s	.L14602
	move.l	-184(a6),-(sp)
	pea	sys_argument_for_x_s
	jsr	L63E0
	addq	#8,sp
	clr	-(sp)
	moveq	#60,d0
	move	d0,-(sp)
	pea	-180(a6)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	.L14668
	moveq	#10,d0
	move	d0,-(sp)
	pea	-180(a6)
	move.l	-12(a6),-(sp)
	jsr	L5692
	adda	#$A,sp
	move	d0,-186(a6)
	bra.s	.L1460A
;
.L14602:
	subq	#1,-186(a6)
	addq.l	#4,-12(a6)
.L1460A:
	pea	L1C9AE
	jsr	L63E0
	addq	#4,sp
	move	-186(a6),d0
	ble.s	.L1463C
	move.l	-12(a6),-(sp)
	move	-186(a6),-(sp)
	move.l	8(a6),-(sp)
	move.l	-8(a6),a0
	move.l	4(a0),a0
	move.l	a0,-4(a6)
	jsr	(a0)
	adda	#$A,sp
.L1463C:
	pea	L1C9B0
	jsr	L63E0
	bra	.L14574
;
.L1464C:
	addq.l	#8,-8(a6)
	bra	.L14582
;
.L14654:
	move.l	-12(a6),a0
	move.l	(a0),-(sp)
	pea	sys_sysopshell_bad_operand_s
	jsr	L63E0
	addq	#8,sp
.L14668:
	clr	d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1466E:
	link	a6,#-8
	clr	-2(a6)
	move.l	8(a6),a0
	move.l	(a0),-8(a6)
L1467E:
	move.l	-8(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5548
	addq	#2,sp
	move	d0,d0
	beq.s	L1469A
	addq.l	#1,-8(a6)
	bra.s	L1467E
;
L1469A:
	move.l	-8(a6),a0
	addq.l	#1,-8(a6)
	move.b	(a0),d0
	ext.w	d0
	move	d0,-4(a6)
	cmpi	#$30,d0
	blt.s	L146D2
	cmpi	#$39,-4(a6)
	bgt.s	L146D2
	move	-2(a6),d0
	muls	#$A,d0
	move	d0,-2(a6)
	move	-4(a6),d0
	subi	#$30,d0
	add	d0,-2(a6)
	bra.s	L1469A
;
L146D2:
	move.l	8(a6),a0
	move.l	-8(a6),(a0)
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L146E2:
	link	a6,#-8
	move	16(a6),d0
	bne.s	L1470A
	move.l	12(a6),-(sp)
	move.l	12(a6),-(sp)
	pea	edit_there_are_no_lines_to_x_s
	jsr	L63E0
	adda	#$C,sp
L14704:
	clr	d0
	bra	L14808
;
L1470A:
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-8(a6)
	move	16(a6),-(sp)
	move.l	12(a6),-(sp)
	pea	edit_which_lines_1_x_s
	jsr	L63E0
	adda	#$A,sp
	clr	-(sp)
	moveq	#-6,d0
	move	d0,-(sp)
	move.l	-8(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq.s	L14704
	pea	-8(a6)
	jsr	L1466E
	addq	#4,sp
	move	d0,-2(a6)
	move.l	18(a6),a0
	move	d0,(a0)
	move	-2(a6),d0
	bne.s	L14786
	move	26(a6),d0
	beq	L147F4
	move.l	18(a6),a0
	moveq	#1,d0
	move	d0,(a0)
	move.l	22(a6),a0
	move	16(a6),(a0)
	bra	L14806
;
L14786:
	cmpi	#1,-2(a6)
	blt.s	L14798
	move	-2(a6),d0
	cmp	16(a6),d0
	ble.s	L147A4
L14798:
	move.l	#edit_invalid_line_number_1_s,12(a6)
	bra	L1470A
;
L147A4:
	move	-2(a6),d0
	move	d0,-4(a6)
	move.l	22(a6),a0
	move	d0,(a0)
	move.l	-8(a6),a0
	cmpi.b	#$2D,-1(a0)
	bne.s	L14806
	pea	-8(a6)
	jsr	L1466E
	addq	#4,sp
	move	d0,-4(a6)
	move.l	22(a6),a0
	move	d0,(a0)
	move	-4(a6),d0
	cmp	-2(a6),d0
	blt.s	L147E8
	move	-4(a6),d0
	cmp	16(a6),d0
	ble.s	L14806
L147E8:
	move.l	#edit_invalid_high_range_number_s,12(a6)
	bra	L1470A
;
L147F4:
	pea	edit_no_defaults_here_s
	jsr	L63E0
	addq	#4,sp
	bra	L14704
;
L14806:
	moveq	#1,d0
L14808:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1480C:
	link	a6,#-8
	moveq	#1,d0
	move	d0,-(sp)
	pea	-4(a6)
	pea	-2(a6)
	move	12(a6),-(sp)
	pea	edit_list_s
	move.l	8(a6),-(sp)
	jsr	L146E2
	adda	#$14,sp
	move	d0,d0
	beq.s	L1488A
	move.l	8(a6),a0
	move.l	2894(a0),-8(a6)
L14842:
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L6AF8
	addq	#6,sp
	move	d0,d0
	bne.s	L1488A
	move	-2(a6),d0
	cmp	-4(a6),d0
	bgt.s	L1488A
	move	-2(a6),d0
	subq	#1,d0
	muls	#80,d0
	add.l	-8(a6),d0
	move.l	d0,-(sp)
	move	-2(a6),-(sp)
	pea	L1CA55
	jsr	L63E0
	adda	#$A,sp
	addq	#1,-2(a6)
	bra.s	L14842
;
L1488A:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1488E:
	link	a6,#-8
	clr	-(sp)
	pea	-4(a6)
	pea	-2(a6)
	move	12(a6),-(sp)
	pea	edit_delete_s
	move.l	8(a6),-(sp)
	jsr	L146E2
	adda	#$14,sp
	move	d0,d0
	beq.s	L148FC
	move.l	8(a6),a0
	move.l	2894(a0),-8(a6)
L148C2:
	move	-4(a6),d0
	cmp	14(a6),d0
	bgt.s	L148FC
	move	-4(a6),d0
	muls	#80,d0
	add.l	-8(a6),d0
	move.l	d0,-(sp)
	move	-2(a6),d0
	subq	#1,d0
	muls	#80,d0
	add.l	-8(a6),d0
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
	addq	#1,-4(a6)
	addq	#1,-2(a6)
	bra.s	L148C2
;
L148FC:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L14900:
	link	a6,#-10
	move.l	8(a6),a0
	move.l	2894(a0),-10(a6)
	pea	edit_edit_s
	jsr	L63E0
	addq	#4,sp
	move	12(a6),d0
	beq	L14A18
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-4(a6)
	move	12(a6),-(sp)
	pea	edit_which_line_1_x_s
	jsr	L63E0
	addq	#6,sp
	clr	-(sp)
	moveq	#-3,d0
	move	d0,-(sp)
	move.l	-4(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	L14A26
	pea	-4(a6)
	jsr	L1466E
	addq	#4,sp
	move	d0,-6(a6)
	cmpi	#1,-6(a6)
	blt.s	L14986
	move	-6(a6),d0
	cmp	12(a6),d0
	ble.s	L14990
L14986:
	pea	edit_invalid_line_number_2_s
	bra	L14A1E
;
L14990:
	move	-6(a6),-(sp)
	move	-6(a6),d0
	subq	#1,d0
	muls	#80,d0
	add.l	-10(a6),d0
	move.l	d0,-(sp)
	move	-6(a6),-(sp)
	pea	edit_old_line_x_y_z_s
	jsr	L63E0
	adda	#$C,sp
	clr	-(sp)
	moveq	#76,d0
	move	d0,-(sp)
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-4(a6)
	move.l	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	bne.s	L149EA
	pea	edit_old_line_was_not_changed_s
	bra.s	L14A1E
;
L149EA:
	move.l	-4(a6),a0
	move.b	(a0),d0
	beq.s	L149F8
	move.l	-4(a6),-(sp)
	bra.s	L149FE
;
L149F8:
	pea	L1CAC8
L149FE:
	move	-6(a6),d0
	subq	#1,d0
	muls	#80,d0
	add.l	-10(a6),d0
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
	bra.s	L14A26
;
L14A18:
	pea	edit_there_are_no_lines_to_edit_s
L14A1E:
	jsr	L63E0
	addq	#4,sp
L14A26:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L14A2A:
	link	a6,#-22
	move.l	8(a6),a0
	clr	3600(a0)
	move.l	8(a6),a0
	move.l	2894(a0),-22(a6)
	clr	-2(a6)
	clr	-6(a6)
	move	14(a6),d0
	bne	L14AD8
	pea	edit_insert_s
	jsr	L63E0
	addq	#4,sp
	move	12(a6),d0
	beq.s	L14AD8
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-16(a6)
	move	12(a6),-(sp)
	pea	edit_after_which_line_0_x_s
	jsr	L63E0
	addq	#6,sp
	clr	-(sp)
	moveq	#-3,d0
	move	d0,-(sp)
	move.l	-16(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L59CC
	adda	#$C,sp
	cmpi	#$FFFF,d0
	bne.s	L14AA8
	clr	d0
	bra	L14DAA
;
L14AA8:
	pea	-16(a6)
	jsr	L1466E
	addq	#4,sp
	move	d0,-4(a6)
	move	-4(a6),d0
	bge.s	L14AC2
	clr	-4(a6)
L14AC2:
	move	-4(a6),d0
	cmp	12(a6),d0
	ble.s	L14AD2
	move	12(a6),-4(a6)
L14AD2:
	move	-4(a6),12(a6)
L14AD8:
	pea	edit_esc_or_3_blank_ends_insert_s
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	clr.b	2738(a0)
	clr	-8(a6)
L14AF2:
	addq	#1,12(a6)
	move	12(a6),d0
	cmp	16(a6),d0
	bgt	L14D4A
	move.l	8(a6),a0
	pea	2738(a0)
	move.l	8(a6),a0
	pea	2638(a0)
	jsr	L11FEC
	addq	#8,sp
	move	12(a6),-(sp)
	pea	L1CB37
	jsr	L63E0
	addq	#6,sp
	move	-8(a6),d0
	beq.s	L14B92
	move.l	8(a6),a0
	clr.b	2738(a0)
	move.l	8(a6),a0
	pea	3600(a0)
	moveq	#78,d0
	move	d0,-(sp)
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-12(a6)
	move.l	d0,-(sp)
	move	-8(a6),-(sp)
	jsr	L4C06
	adda	#$C,sp
	cmpi	#$FFFF,d0
	bne.s	L14B7C
	move	-8(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	clr	-8(a6)
	bra.s	L14B92
;
L14B7C:
	move.l	8(a6),a0
	pea	2638(a0)
	pea	L1CB3E
	jsr	L63E0
	addq	#8,sp
L14B92:
	move	-8(a6),d0
	bne.s	L14BC6
	move.l	8(a6),a0
	pea	2738(a0)
	move.l	8(a6),d0
	addi.l	#$A4E,d0
	move.l	d0,-12(a6)
	move.l	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L14F72
	adda	#$C,sp
	cmpi	#$FFFF,d0
	beq	L14D4A
L14BC6:
	move	-8(a6),d0
	bne	L14CB6
	move.l	-12(a6),a0
	cmpi.b	#$2F,(a0)
	beq.s	L14BE4
	move.l	-12(a6),a0
	cmpi.b	#$2A,(a0)
	bne	L14CB6
L14BE4:
	move.l	-12(a6),a0
	move.b	1(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L5522
	addq	#2,sp
	move.b	d0,-18(a6)
	cmpi	#$53,d0
	bne.s	L14C12
	moveq	#1,d0
	move	d0,-6(a6)
	move.l	-12(a6),a0
	clr.b	(a0)
	bra	L14D4A
;
L14C12:
	cmpi.b	#$46,-18(a6)
	bne.s	L14C4C
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	blt.s	L14C4C
	move.l	-12(a6),a0
	moveq	#6,d0
	move.b	d0,(a0)
	move.l	-12(a6),a0
	moveq	#32,d0
	move.b	d0,1(a0)
	clr	-(sp)
	move.l	-12(a6),a0
	pea	1(a0)
	jsr	L5BB4
	addq	#6,sp
	bra.s	L14CB6
;
L14C4C:
	cmpi.b	#$4C,-18(a6)
	bne.s	L14CB6
	move.l	8(a6),a0
	cmpi	#4,32(a0)
	blt.s	L14CB6
	move.l	8(a6),a0
	clr.b	2738(a0)
	move.l	-12(a6),a0
	addq.l	#1,-12(a6)
	clr.b	(a0)
	addq.l	#1,-12(a6)
	clr	-(sp)
	move.l	-12(a6),-(sp)
	jsr	L5BB4
	addq	#6,sp
	clr	-(sp)
	move.l	-12(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-8(a6)
	bge.s	L14CAE
	clr	-8(a6)
	move.l	-12(a6),-(sp)
	pea	edit_load_x_failed_s
	jsr	L63E0
	addq	#8,sp
L14CAE:
	subq	#1,12(a6)
	bra	L14AF2
;
L14CB6:
	move.l	-12(a6),a0
	move.b	(a0),d0
	bne.s	L14CE6
	pea	L1CB54
	move.l	-12(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	move	-8(a6),d0
	bne.s	L14CEA
	addq	#1,-2(a6)
	move	-2(a6),d0
	cmpi	#2,d0
	ble.s	L14CEA
	bra.s	L14D4A
;
L14CE6:
	clr	-2(a6)
L14CEA:
	move	16(a6),d0
	subq	#1,d0
	move	d0,-4(a6)
L14CF4:
	move	-4(a6),d0
	cmp	12(a6),d0
	blt.s	L14D2A
	move	-4(a6),d0
	subq	#1,d0
	muls	#80,d0
	add.l	-22(a6),d0
	move.l	d0,-(sp)
	move	-4(a6),d0
	muls	#80,d0
	add.l	-22(a6),d0
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
	subq	#1,-4(a6)
	bra.s	L14CF4
;
L14D2A:
	move.l	-12(a6),-(sp)
	move	12(a6),d0
	subq	#1,d0
	muls	#80,d0
	add.l	-22(a6),d0
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
	bra	L14AF2
;
L14D4A:
	move	16(a6),d0
	subq	#1,d0
	move	d0,-4(a6)
L14D54:
	move	-4(a6),d0
	blt.s	L14D90
	move	-4(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	-22(a6),a0
	move.l	a0,-12(a6)
	move.b	(a0),d0
	beq.s	L14D84
	move.l	-12(a6),a0
	cmpi.b	#$20,(a0)
	bne.s	L14D90
	move.l	-12(a6),a0
	move.b	1(a0),d0
	bne.s	L14D90
L14D84:
	move.l	-12(a6),a0
	clr.b	(a0)
	subq	#1,-4(a6)
	bra.s	L14D54
;
L14D90:
	move	-8(a6),d0
	beq.s	L14DA6
	move	-8(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	clr	-8(a6)
L14DA6:
	move	-6(a6),d0
L14DAA:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L14DAE:
	link	a6,#-10
	move.l	8(a6),a0
	move.l	2894(a0),-10(a6)
	clr	-2(a6)
	move	14(a6),d0
	beq.s	L14E06
	clr	-6(a6)
L14DCA:
	move	-6(a6),d0
	cmp	12(a6),d0
	bgt.s	L14DEA
	move	-6(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	-10(a6),a0
	clr.b	(a0)
	addq	#1,-6(a6)
	bra.s	L14DCA
;
L14DEA:
	move	12(a6),-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	L14A2A
	adda	#$A,sp
	move	d0,-2(a6)
L14E06:
	move	12(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	-10(a6),a0
	clr.b	(a0)
	clr	-4(a6)
L14E1A:
	move	-4(a6),d0
	cmp	12(a6),d0
	bge.s	L14E3C
	move	-4(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	-10(a6),a0
	move.b	(a0),d0
	beq.s	L14E3C
	addq	#1,-4(a6)
	bra.s	L14E1A
;
L14E3C:
	move	-2(a6),d0
	bne	L14F36
	clr	-4(a6)
L14E48:
	move	-4(a6),d0
	cmp	12(a6),d0
	bge.s	L14E6A
	move	-4(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	-10(a6),a0
	move.b	(a0),d0
	beq.s	L14E6A
	addq	#1,-4(a6)
	bra.s	L14E48
;
L14E6A:
	move	-4(a6),-(sp)
	pea	edit_menu_s
	jsr	L63E0
	addq	#6,sp
	pea	edit_menu_cmds_2_s
	move.l	8(a6),-(sp)
	jsr	L6A98
	addq	#8,sp
	ext.w	d0
	move	d0,-(sp)
	pea	edit_menu_cmds_1_s
	jsr	L120D4
	addq	#6,sp
	cmpi	#5,d0
	bhi.s	L14E3C
	lsl.w	#2,d0
	move	d0,a0
	adda.l	#L1866C,a0
	move.l	(a0),a0
	jmp	(a0)
;
L14EB4:
	bra.s	L14E3C
;
L14EB6:
	move	-4(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L1480C
L14EC4:
	addq	#6,sp
	bra	L14E3C
;
L14ECA:
	move	12(a6),-(sp)
	move	-4(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L1488E
	addq	#8,sp
	bra	L14E3C
;
L14EE2:
	move	-4(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L14900
	bra.s	L14EC4
;
L14EF2:
	move	12(a6),-(sp)
	clr	-(sp)
	move	-4(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L14A2A
	adda	#$A,sp
L14F0A:
	move	d0,-2(a6)
	bra	L14E3C
;
L14F12:
	pea	edit_quit_s
	jsr	L63E0
	addq	#4,sp
	clr	d0
	bra.s	L14F6E
;
L14F24:
	pea	edit_save_s
	jsr	L63E0
	addq	#4,sp
	moveq	#1,d0
	bra.s	L14F0A
;
L14F36:
	pea	L1CBAA
	jsr	L63E0
	addq	#4,sp
	clr	-4(a6)
L14F48:
	move	-4(a6),d0
	cmp	12(a6),d0
	bge.s	L14F6A
	move	-4(a6),d0
	muls	#80,d0
	move.l	d0,a0
	adda.l	-10(a6),a0
	move.b	(a0),d0
	beq.s	L14F6A
	addq	#1,-4(a6)
	bra.s	L14F48
;
L14F6A:
	move	-4(a6),d0
L14F6E:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L14F72:
	link	a6,#-18
	move.l	12(a6),-14(a6)
	move.l	8(a6),a0
	move	(a0),-6(a6)
	clr	-2(a6)
	move.l	16(a6),a0
	clr.b	(a0)
.L14F8E:
	move.l	-14(a6),a0
	move.b	(a0),d0
	beq.s	.L14FB6
	addq	#1,-2(a6)
	move.l	-14(a6),a0
	addq.l	#1,-14(a6)
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	bra.s	.L14F8E
;
.L14FB6:
	cmpi	#75,-2(a6)
	blt	.L150A0
	move.l	-14(a6),a0
	clr.b	(a0)
.L14FC6:
	move	-2(a6),d0
	ble.s	.L14FE2
	move.l	-14(a6),a0
	cmpi.b	#$20,-1(a0)
	beq.s	.L14FE2
	subq	#1,-2(a6)
	subq.l	#1,-14(a6)
	bra.s	.L14FC6
;
.L14FE2:
	move	-2(a6),d0
	beq.s	.L15016
	move.l	-14(a6),d0
	subq.l	#1,d0
	move.l	d0,-18(a6)
	move	-2(a6),d0
	subq	#1,d0
	move	d0,-10(a6)
.L14FFC:
	move	-10(a6),d0
	blt.s	.L15016
	move.l	-18(a6),a0
	cmpi.b	#$20,(a0)
	bne.s	.L15016
	subq.l	#1,-18(a6)
	subq	#1,-10(a6)
	bra.s	.L14FFC
;
.L15016:
	move	-2(a6),d0
	beq.s	.L1508A
	move	-10(a6),d0
	ble.s	.L1508A
	move.l	-18(a6),a0
	clr.b	1(a0)
	move.l	-14(a6),a0
	clr.b	-1(a0)
	move.l	-14(a6),-(sp)
	move.l	16(a6),-(sp)
	jsr	L11FEC
	addq	#8,sp
	move	-2(a6),-8(a6)
.L15048:
	cmpi	#75,-8(a6)
	bgt.s	.L15066
	moveq	#8,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	addq	#1,-8(a6)
	bra.s	.L15048
;
.L15066:
	move	-2(a6),-8(a6)
.L1506C:
	cmpi	#75,-8(a6)
	bgt.s	.L1508A
	moveq	#32,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	addq	#1,-8(a6)
	bra.s	.L1506C
;
.L1508A:
	moveq	#CR,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#1,d0
	bra	.L15208
;
.L150A0:
	move.l	8(a6),-(sp)
	jsr	L6F7A
	addq	#4,sp
	move	d0,-4(a6)
	move.l	8(a6),-(sp)
	jsr	L5C60
	addq	#4,sp
.L150BC:			;patch conin_filter here
	cmpi	#$20,-4(a6)
	blt.s	.L150F2
	cmpi	#$7F,-4(a6)
.L150CA:			;patch conin_bxx to beq here
	bge.s	.L150F2
	move	-4(a6),-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	move.l	-14(a6),a0
	addq.l	#1,-14(a6)
	move	-4(a6),d0
	move.b	d0,(a0)
	addq	#1,-2(a6)
	bra	.L14FB6
;
.L150F2:
	cmpi	#HT,-4(a6)
	bne.s	.L1512E
	cmpi	#70,-2(a6)
	bge.s	.L1512E
.L15102:
	move.l	-14(a6),a0
	addq.l	#1,-14(a6)
	moveq	#32,d0
	move.b	d0,(a0)
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	addq	#1,-2(a6)
	move	-2(a6),d0
	andi	#3,d0
	bne.s	.L15102
	bra	.L14FB6
;
.L1512E:
	cmpi	#8,-4(a6)
	beq.s	.L1513E
	cmpi	#$7F,-4(a6)
	bne.s	.L1519C
.L1513E:
	move	-2(a6),d0
	beq.s	.L15188
	moveq	#8,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#32,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#8,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	subq	#1,-2(a6)
	subq.l	#1,-14(a6)
	move.l	-14(a6),a0
	moveq	#32,d0
	move.b	d0,(a0)
	bra	.L14FB6
;
.L15188:
	moveq	#7,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	bra	.L14FB6
;
.L1519C:
	cmpi	#$D,-4(a6)
	bne.s	.L151BE
	moveq	#13,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	move.l	-14(a6),a0
	clr.b	(a0)
	clr	d0
	bra.s	.L15208
;
.L151BE:
	cmpi	#ESC,-4(a6)
	beq.s	.L151D0
	cmpi	#3,-4(a6)
	bne	.L14FB6
.L151D0:
	moveq	#94,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#67,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#13,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	move.l	-14(a6),a0
	clr.b	(a0)
	moveq	#-1,d0
.L15208:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1520C:
	link	a6,#-12
	move.l	8(a6),a0
	move	(a0),-6(a6)
	move	14(a6),d0
	beq	L15386
	move.l	8(a6),a0
	move.l	#ascii_send_s,2608(a0)
	moveq	#3,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move.l	16(a6),-(sp)
	pea	press_key_when_ready_to_receive_s
	jsr	L63E0
	addq	#8,sp
	moveq	#120,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L413C
	addq	#6,sp
L1525E:
	move	-6(a6),-(sp)
	jsr	L6DF4
	addq	#2,sp
	move	d0,-4(a6)
	cmpi	#$FFFF,d0
	bne.s	L15288
	move.l	8(a6),a0
	move	2968(a0),d0
	ble.s	L15288
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	L1525E
L15288:
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	L15298
L15292:
	moveq	#2,d0
	bra	L154C4
;
L15298:
	cmpi	#$FFFF,-4(a6)
	bne.s	L152A6
L152A0:
	moveq	#3,d0
	bra	L154C4
;
L152A6:
	pea	L1CBE4
	jsr	L63E0
	addq	#4,sp
	moveq	#18,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	clr	-8(a6)
L152C8:
	move	-8(a6),d0
	bne	L15362
	move	#$2000,-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),d0
	move.l	d0,-12(a6)
	move.l	d0,-(sp)
	move	12(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move	d0,-2(a6)
	ble.s	L15362
L152F4:
	move	-2(a6),d0
	ble.s	L152C8
	move	-8(a6),d0
	bne.s	L152C8
	cmpi	#$400,-2(a6)
	ble.s	L1530E
	move	#$400,-(sp)
	bra.s	L15312
;
L1530E:
	move	-2(a6),-(sp)
L15312:
	move.l	-12(a6),-(sp)
	move	-6(a6),-(sp)
	jsr	L6D80
	addq	#8,sp
	move	-6(a6),-(sp)
	jsr	L6DF4
	addq	#2,sp
	move	d0,-4(a6)
	cmpi	#3,d0
	beq.s	L15348
	cmpi	#$F,-4(a6)
	beq.s	L15348
	cmpi	#$1B,-4(a6)
	bne.s	L1534E
L15348:
	moveq	#1,d0
	move	d0,-8(a6)
L1534E:
	subi	#$400,-2(a6)
	move.l	-12(a6),a0
	adda	#$400,a0
	move.l	a0,-12(a6)
	bra.s	L152F4
;
L15362:
	moveq	#26,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#20,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	bra	L154C2
;
L15386:
	move.l	8(a6),a0
	move.l	#ascii_receive_s,2608(a0)
L15392:
	move.l	8(a6),a0
	move	2600(a0),d0
	beq.s	L153BA
	move	-6(a6),-(sp)
	jsr	L6D46
	addq	#2,sp
	move	d0,d0
	bne.s	L153BA
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L15392
;
L153BA:
	moveq	#3,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DDC
	addq	#4,sp
	pea	send_upload_now_ctrl_z_to_end_s
	jsr	L63E0
	addq	#4,sp
	move.l	8(a6),a0
	move.l	2894(a0),-12(a6)
	clr	-2(a6)
L153E6:
	moveq	#120,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L413C
	addq	#6,sp
L153F6:
	move.l	8(a6),a0
	move	2968(a0),d0
	ble.s	L15420
	move.l	8(a6),a0
	move	2600(a0),d0
	beq.s	L15420
	move	-6(a6),-(sp)
	jsr	L6DF4
	addq	#2,sp
	move	d0,-4(a6)
	cmpi	#$FFFF,d0
	beq.s	L153F6
L15420:
	move.l	8(a6),a0
	move	2600(a0),d0
	beq	L15292
	cmpi	#$FFFF,-4(a6)
	beq	L152A0
	move.l	-12(a6),a0
	addq.l	#1,-12(a6)
	move	-4(a6),d0
	move.b	d0,(a0)
	addq	#1,-2(a6)
	cmpi	#$2000,-2(a6)
	beq.s	L15458
	cmpi	#$1A,-4(a6)
	bne.s	L154B8
L15458:
	moveq	#19,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	move	-2(a6),-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move	12(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmp	-2(a6),d0
	beq.s	L1549A
	moveq	#17,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#4,d0
	bra.s	L154C4
;
L1549A:
	moveq	#17,d0
	move	d0,-(sp)
	move	-6(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	clr	-2(a6)
	move.l	8(a6),a0
	move.l	2894(a0),-12(a6)
L154B8:
	cmpi	#$1A,-4(a6)
	bne	L153E6
L154C2:
	clr	d0
L154C4:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L154C8:
	link	a6,#0
L154CC:
	move.l	8(a6),a0
	move	2600(a0),d0
	beq.s	L154F6
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D46
	addq	#2,sp
	move	d0,d0
	bne.s	L154F6
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L154CC
;
L154F6:
	clr	-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move.l	8(a6),a0
	move	2966(a0),d0
	andi	#$E0,d0
	ori	#3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6F22
	addq	#4,sp
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L15536:
	link	a6,#0
	moveq	#3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move.l	8(a6),a0
	move	2966(a0),-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6F22
	addq	#4,sp
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L15572:
	link	a6,#-24
	clr	-(sp)
	move	#$80,-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),d0
	move.l	d0,-4(a6)
	move.l	d0,-(sp)
	jsr	L10C
	addq	#8,sp
	move.l	12(a6),a0
	move.b	(a0),d0
	beq	L1563E
	move	16(a6),d0
	beq	L15798
	move	16(a6),-10(a6)
L155AA:
	move.l	12(a6),-(sp)
	jsr	L563C
	addq	#4,sp
	move.l	d0,-8(a6)
L155BA:
	move.l	-8(a6),a0
	move.b	(a0),d0
	beq.s	L155F6
	move.l	-8(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L54FC
	addq	#2,sp
	move.l	-4(a6),a0
	move.b	d0,(a0)
	move.l	-4(a6),a0
	cmpi.b	#$5C,(a0)
	bne.s	L155EC
	move.l	-4(a6),a0
	moveq	#47,d0
	move.b	d0,(a0)
L155EC:
	addq.l	#1,-8(a6)
	addq.l	#1,-4(a6)
	bra.s	L155BA
;
L155F6:
	move.l	-4(a6),a0
	addq.l	#1,-4(a6)
	clr.b	(a0)
	moveq	#2,d0
	move	d0,-(sp)
	clr.l	-(sp)
	move	-10(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	d0,-24(a6)
	clr	-(sp)
	clr.l	-(sp)
	move	-10(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	move.l	-24(a6),-(sp)
	pea	L1CC22
	move.l	-4(a6),-(sp)
	jsr	L16E2A
	adda	#$C,sp
L1563E:
	move	#$80,-12(a6)
	clr	-14(a6)
	move.l	12(a6),a0
	move.b	(a0),d0
	beq.s	L15656
	move.l	12(a6),-(sp)
	bra.s	L1565C
;
L15656:
	pea	end_of_batch_s
L1565C:
	pea	ymodem_send_x_s
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L64FC
	adda	#$A,sp
	move.l	12(a6),a0
	move.b	(a0),d0
	beq.s	L1569C
	move.l	-24(a6),d0
	addi.l	#$80,d0
	asr.l	#7,d0
	move	d0,-(sp)
	pea	x_blocks_s
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L64FC
	addq	#8,sp
L1569C:
	move.l	8(a6),a0
	move	(a0),d0
	bne.s	L156A8
	moveq	#1,d0
	bra.s	L156AA
;
L156A8:
	clr	d0
L156AA:
	move	d0,-16(a6)
	clr	-20(a6)
	moveq	#120,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L413C
	addq	#6,sp
L156C2:
	move.l	8(a6),a0
	move	2968(a0),d0
	ble.s	L15720
	move	-16(a6),d0
	bne.s	L15720
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	L156E2
	moveq	#2,d0
	move	d0,-16(a6)
L156E2:
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DF4
	addq	#2,sp
	move	d0,-18(a6)
	cmpi	#$FFFF,d0
	beq.s	L156C2
	cmpi	#$43,-18(a6)
	beq.s	L15720
	cmpi	#$18,-18(a6)
	bne.s	L15718
	cmpi	#$18,-20(a6)
	bne.s	L15718
	moveq	#1,d0
	move	d0,-16(a6)
L15718:
	move	-18(a6),-20(a6)
	bra.s	L156C2
;
L15720:
	cmpi	#$FFFF,-18(a6)
	bne.s	L1572E
	moveq	#3,d0
	move	d0,-16(a6)
L1572E:
	move	-16(a6),d0
	bne.s	L1575A
	pea	-14(a6)
	pea	-12(a6)
	clr	-(sp)
	clr	-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move.l	8(a6),-(sp)
	jsr	L15E0C
	adda	#$14,sp
	move	d0,-16(a6)
L1575A:
	move.l	12(a6),a0
	move.b	(a0),d0
	beq.s	L15792
	move	-16(a6),d0
	bne.s	L15780
	moveq	#4,d0
	move	d0,-(sp)
	move	-10(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L15BA8
	addq	#8,sp
	move	d0,-16(a6)
L15780:
	move	16(a6),d0
	bne.s	L15792
	move	-10(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
L15792:
	move	-16(a6),d0
	bra.s	L157B0
;
L15798:
	clr	-(sp)
	move.l	12(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-10(a6)
	bge	L155AA
	moveq	#1,d0
L157B0:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L157B4:
	link	a6,#-2
	move	14(a6),d0
	beq.s	L157C6
	move.l	#ymodem_send_s,d0
	bra.s	L157CC
;
L157C6:
	move.l	#ymodem_recv_s,d0
L157CC:
	move.l	8(a6),a0
	move.l	d0,2608(a0)
	move.l	8(a6),-(sp)
	jsr	L154C8
	addq	#4,sp
	move	12(a6),-(sp)
	move.l	16(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L15572
	adda	#$A,sp
	move	d0,-2(a6)
	bne.s	L15816
	clr	-(sp)
	pea	L1CC69
	move.l	8(a6),-(sp)
	jsr	L15572
	adda	#$A,sp
	move	d0,-2(a6)
L15816:
	move.l	8(a6),-(sp)
	jsr	L15536
	addq	#4,sp
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1582A:
	link	a6,#-2
	move.l	8(a6),a0
	move	(a0),d0
	bne.s	L1583C
	moveq	#1,d0
	bra	L15924
;
L1583C:
	move	14(a6),d0
	beq.s	L1584A
	move.l	#xmodem_send_s,d0
	bra.s	L15850
;
L1584A:
	move.l	#xmodem_recv_s,d0
L15850:
	move.l	8(a6),a0
	move.l	d0,2608(a0)
L15858:
	move.l	8(a6),a0
	move	2600(a0),d0
	beq.s	L15882
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D46
	addq	#2,sp
	move	d0,d0
	bne.s	L15882
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L15858
;
L15882:
	clr	-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move.l	8(a6),a0
	move	2966(a0),d0
	andi	#$E0,d0
	ori	#3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6F22
	addq	#4,sp
	move	14(a6),d0
	beq.s	L158CE
	moveq	#1,d0
	move	d0,-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L15BA8
	addq	#8,sp
	bra.s	L158E8
;
L158CE:
	move.l	L18850,-(sp)
	clr	-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L15F6C
	adda	#$C,sp
L158E8:
	move	d0,-2(a6)
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	moveq	#3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move.l	8(a6),a0
	move	2966(a0),-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6F22
	addq	#4,sp
	move	-2(a6),d0
L15924:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L15928:
	link	a6,#-2
	move.l	8(a6),a0
	move	(a0),d0
	bne.s	L1593A
	moveq	#1,d0
	bra	L15A24
;
L1593A:
	move	14(a6),d0
	beq.s	L15948
	move.l	#crc_xmodem_send_s,d0
	bra.s	L1594E
;
L15948:
	move.l	#crc_xmodem_recv_s,d0
L1594E:
	move.l	8(a6),a0
	move.l	d0,2608(a0)
L15956:
	move.l	8(a6),a0
	move	2600(a0),d0
	beq.s	L15980
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D46
	addq	#2,sp
	move	d0,d0
	bne.s	L15980
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L15956
;
L15980:
	clr	-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move.l	8(a6),a0
	move	2966(a0),d0
	andi	#$E0,d0
	ori	#3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6F22
	addq	#4,sp
	move	14(a6),d0
	beq.s	L159CC
	moveq	#2,d0
	move	d0,-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L15BA8
	addq	#8,sp
	bra.s	L159E8
;
L159CC:
	move.l	L18854,-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L15F6C
	adda	#$C,sp
L159E8:
	move	d0,-2(a6)
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	moveq	#3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move.l	8(a6),a0
	move	2966(a0),-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6F22
	addq	#4,sp
	move	-2(a6),d0
L15A24:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L15A28:
	link	a6,#-2
	move.l	8(a6),a0
	move	(a0),d0
	bne.s	L15A3A
	moveq	#1,d0
	bra	L15B24
;
L15A3A:
	move	14(a6),d0
	beq.s	L15A48
	move.l	#x1k_xmodem_send_s,d0
	bra.s	L15A4E
;
L15A48:
	move.l	#x1k_xmodem_recv_s,d0
L15A4E:
	move.l	8(a6),a0
	move.l	d0,2608(a0)
L15A56:
	move.l	8(a6),a0
	move	2600(a0),d0
	beq.s	L15A80
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D46
	addq	#2,sp
	move	d0,d0
	bne.s	L15A80
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L15A56
;
L15A80:
	clr	-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move.l	8(a6),a0
	move	2966(a0),d0
	andi	#$E0,d0
	ori	#3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6F22
	addq	#4,sp
	move	14(a6),d0
	beq.s	L15ACC
	moveq	#3,d0
	move	d0,-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L15BA8
	addq	#8,sp
	bra.s	L15AE8
;
L15ACC:
	move.l	L18858,-(sp)
	moveq	#1,d0
	move	d0,-(sp)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L15F6C
	adda	#$C,sp
L15AE8:
	move	d0,-2(a6)
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	moveq	#3,d0
	move	d0,-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move.l	8(a6),a0
	move	2966(a0),-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6F22
	addq	#4,sp
	move	-2(a6),d0
L15B24:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L15B28:
	link	a6,#-4
	move.l	8(a6),a0
	move	(a0),-4(a6)
	move	12(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L413C
	addq	#6,sp
L15B44:
	move	-4(a6),-(sp)
	jsr	L6DF4
	addq	#2,sp
	move	d0,-2(a6)
	cmpi	#$FFFF,d0
	bne.s	L15B6E
	move.l	8(a6),a0
	move	2600(a0),d0
	beq.s	L15B6E
	move.l	8(a6),a0
	move	2968(a0),d0
	bgt.s	L15B44
L15B6E:
	move	-2(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L15B76:
	link	a6,#-2
	clr.b	-2(a6)
L15B7E:
	move	12(a6),d0
	subq	#1,12(a6)
	move	d0,d0
	beq.s	L15B9A
	move.l	8(a6),a0
	addq.l	#1,8(a6)
	move.b	(a0),d0
	add.b	d0,-2(a6)
	bra.s	L15B7E
;
L15B9A:
	move.b	-2(a6),d0
	ext.w	d0
	andi	#$FF,d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L15BA8:
	link	a6,#-30
	moveq	#1,d0
	move	d0,-10(a6)
	move	d0,-28(a6)
	move.l	8(a6),a0
	move	(a0),-24(a6)
	cmpi	#3,14(a6)
	beq.s	L15BCE
	cmpi	#4,14(a6)
	bne.s	L15BD2
L15BCE:
	moveq	#1,d0
	bra.s	L15BD4
;
L15BD2:
	clr	d0
L15BD4:
	move	d0,-30(a6)
	clr	-14(a6)
	move	14(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L1884C,a0
	adda.l	d0,a0
	move.l	(a0),-8(a6)
	move.l	-8(a6),-(sp)
	pea	x_send_wait_s
	move	-24(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	move	#$2000,-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move	12(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move	d0,-16(a6)
	clr	-20(a6)
	moveq	#120,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L413C
	addq	#6,sp
L15C38:
	move.l	8(a6),a0
	move	2968(a0),d0
	ble.s	L15C9E
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	L15C52
L15C4C:
	moveq	#2,d0
	bra	L15E08
;
L15C52:
	move	-24(a6),-(sp)
	jsr	L6DF4
	addq	#2,sp
	move	d0,-18(a6)
	cmpi	#$FFFF,d0
	beq.s	L15C38
	cmpi	#1,14(a6)
	bne.s	L15C78
	cmpi	#$15,-18(a6)
	beq.s	L15C9E
L15C78:
	cmpi	#$43,-18(a6)
	beq.s	L15C9E
	cmpi	#$18,-18(a6)
	bne.s	L15C96
	cmpi	#$18,-20(a6)
	bne.s	L15C96
	moveq	#1,d0
	bra	L15E08
;
L15C96:
	move	-18(a6),-20(a6)
	bra.s	L15C38
;
L15C9E:
	cmpi	#$FFFF,-18(a6)
	beq	L15E06
	cmpi	#$15,-18(a6)
	bne.s	L15CB6
	moveq	#1,d0
	move	d0,-14(a6)
L15CB6:
	cmpi	#1,14(a6)
	bne.s	L15CDC
	cmpi	#$43,-18(a6)
	bne.s	L15CDC
	moveq	#2,d0
	move	d0,14(a6)
	ext.l	d0
	lsl.l	#2,d0
	lea	L1884C,a0
	adda.l	d0,a0
	move.l	(a0),-8(a6)
L15CDC:
	move	-16(a6),d0
	bgt.s	L15D02
	move	#$2000,-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move	12(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move	d0,-16(a6)
	ble	L15DB8
L15D02:
	move.l	8(a6),a0
	move.l	2894(a0),-4(a6)
L15D0C:
	move	-16(a6),d0
	ble.s	L15CDC
	move	#$80,-26(a6)
	move	-30(a6),d0
	beq.s	L15D2C
	cmpi	#$380,-16(a6)
	ble.s	L15D2C
	move	#$400,-26(a6)
L15D2C:
	cmpi	#$80,-26(a6)
	ble.s	L15D38
	moveq	#42,d0
	bra.s	L15D3A
;
L15D38:
	moveq	#32,d0
L15D3A:
	move	d0,-(sp)
	move	-28(a6),-(sp)
	move.l	-8(a6),-(sp)
	pea	x_send_y_z_s
	move	-24(a6),-(sp)
	jsr	L64FC
	adda	#$E,sp
	pea	-30(a6)
	pea	-26(a6)
	move	-14(a6),-(sp)
	move	-10(a6),-(sp)
	move.l	-4(a6),-(sp)
	move.l	8(a6),-(sp)
	jsr	L15E0C
	adda	#$14,sp
	move	d0,-12(a6)
	move	-12(a6),d0
	beq.s	L15D8A
	move	-12(a6),d0
	bra.s	L15E08
;
L15D8A:
	move	-26(a6),d0
	sub	d0,-16(a6)
	move.l	-4(a6),a0
	adda	-26(a6),a0
	move.l	a0,-4(a6)
	addq	#1,-10(a6)
	cmpi	#$400,-26(a6)
	bne.s	L15DAE
	moveq	#8,d0
	bra.s	L15DB0
;
L15DAE:
	moveq	#1,d0
L15DB0:
	add	d0,-28(a6)
	bra	L15D0C
;
L15DB8:
	moveq	#10,d0
	move	d0,-22(a6)
L15DBE:
	move	-22(a6),d0
	beq.s	L15DFC
	moveq	#4,d0
	move	d0,-(sp)
	move	-24(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#10,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L15B28
	addq	#6,sp
	cmpi	#6,d0
	beq.s	L15DFC
	move.l	8(a6),a0
	move	2600(a0),d0
	beq	L15C4C
	subq	#1,-22(a6)
	bra.s	L15DBE
;
L15DFC:
	move	-22(a6),d0
	beq.s	L15E06
	clr	d0
	bra.s	L15E08
;
L15E06:
	moveq	#3,d0
L15E08:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L15E0C:
	link	a6,#-14
	move.l	8(a6),a0
	move	(a0),-4(a6)
	move	18(a6),d0
	beq.s	L15E26
	move.l	#L15B76,d0
	bra.s	L15E2C
;
L15E26:
	move.l	#L1B0,d0
L15E2C:
	move.l	d0,-10(a6)
	move.l	20(a6),a0
	move	(a0),-12(a6)
	clr	-2(a6)
L15E3C:
	cmpi	#$A,-2(a6)
	bge	L15F66
	move.l	24(a6),a0
	move	(a0),d0
	beq.s	L15E6A
	cmpi	#5,-2(a6)
	bne.s	L15E6A
	move.l	24(a6),a0
	clr	(a0)
	move	#$80,d0
	move.l	20(a6),a0
	move	d0,(a0)
	move	d0,-12(a6)
L15E6A:
	move	-2(a6),d0
	beq.s	L15E78
	cmpi	#5,-2(a6)
	bne.s	L15E8C
L15E78:
	move	-12(a6),-(sp)
	move.l	12(a6),-(sp)
	move.l	-10(a6),a0
	jsr	(a0)
	addq	#6,sp
	move	d0,-14(a6)
L15E8C:
	cmpi	#$80,-12(a6)
	ble.s	L15E98
	moveq	#2,d0
	bra.s	L15E9A
;
L15E98:
	moveq	#1,d0
L15E9A:
	move	d0,-(sp)
	move	-4(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	move	16(a6),-(sp)
	move	-4(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	move	16(a6),d0
	not	d0
	move	d0,-(sp)
	move	-4(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	move	-12(a6),-(sp)
	move.l	12(a6),-(sp)
	move	-4(a6),-(sp)
	jsr	L6D80
	addq	#8,sp
	move	18(a6),d0
	bne.s	L15EFA
	move	-14(a6),d0
	asr.w	#8,d0
	move	d0,-(sp)
	move	-4(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
L15EFA:
	move	-14(a6),-(sp)
	move	-4(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
L15F0A:
	move	-4(a6),-(sp)
	jsr	L6DF4
	addq	#2,sp
	cmpi	#$FFFF,d0
	bne.s	L15F0A
	moveq	#10,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L15B28
	addq	#6,sp
	move	d0,-6(a6)
	cmpi	#6,-6(a6)
	bne.s	L15F3C
	clr	d0
	bra.s	L15F68
;
L15F3C:
	cmpi	#$18,-6(a6)
	bne.s	L15F5E
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L15B28
	addq	#6,sp
	cmpi	#$18,d0
	bne.s	L15F5E
	moveq	#1,d0
	bra.s	L15F68
;
L15F5E:
	addq	#1,-2(a6)
	bra	L15E3C
;
L15F66:
	moveq	#3,d0
L15F68:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L15F6C:
	link	a6,#-44
	moveq	#1,d0
	move	d0,-2(a6)
	move	d0,-18(a6)
	clr	-12(a6)
	move.l	8(a6),a0
	move.l	2894(a0),-34(a6)
	move.l	8(a6),a0
	move	(a0),-14(a6)
	moveq	#1,d0
	move	d0,-22(a6)
	move	14(a6),d0
	beq.s	L15FA0
	moveq	#67,d0
	bra.s	L15FA2
;
L15FA0:
	moveq	#21,d0
L15FA2:
	move	d0,-10(a6)
	move	14(a6),d0
	beq.s	L15FB4
	move.l	#L1B0,d0
	bra.s	L15FBA
;
L15FB4:
	move.l	#L15B76,d0
L15FBA:
	move.l	d0,-42(a6)
	move.l	16(a6),-(sp)
	pea	x_received_awaiting_shake_s
	move	-14(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
L15FD6:
	clr	-16(a6)
	clr	-20(a6)
L15FDE:
	cmpi	#$14,-16(a6)
	bge	L160C4
	move	-10(a6),-(sp)
	move	-14(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	moveq	#5,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L15B28
	addq	#6,sp
	move	d0,-8(a6)
	cmpi	#1,-8(a6)
	beq	L160C4
	cmpi	#2,-8(a6)
	bne.s	L16026
	move	14(a6),d0
	bne	L160C4
L16026:
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	L16036
	moveq	#2,d0
	bra	L16326
;
L16036:
	cmpi	#4,-8(a6)
	bne.s	L1608E
	clr	-16(a6)
L16042:
	cmpi	#5,-16(a6)
	bge.s	L16060
	moveq	#6,d0
	move	d0,-(sp)
	move	-14(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	addq	#1,-16(a6)
	bra.s	L16042
;
L16060:
	move	-12(a6),d0
	ble	L16324
	move	-12(a6),-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move	12(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmp	-12(a6),d0
	beq	L16324
L16088:
	moveq	#4,d0
	bra	L16326
;
L1608E:
	cmpi	#$18,-8(a6)
	bne.s	L160A4
	cmpi	#$18,-20(a6)
	bne.s	L160A4
	moveq	#1,d0
	bra	L16326
;
L160A4:
	cmpi	#$FFFF,-8(a6)
	beq.s	L160BC
	move	-16(a6),d0
	beq.s	L160BC
	move	-8(a6),-20(a6)
	subq	#1,-16(a6)
L160BC:
	addq	#1,-16(a6)
	bra	L15FDE
;
L160C4:
	cmpi	#$14,-16(a6)
	bne.s	L160D2
	moveq	#3,d0
	bra	L16326
;
L160D2:
	move	-22(a6),d0
	beq.s	L160EE
	pea	received_s
	move	-14(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	clr	-22(a6)
L160EE:
	cmpi	#1,-8(a6)
	bne.s	L160FC
	move	#$80,d0
	bra.s	L16100
;
L160FC:
	move	#$400,d0
L16100:
	move	d0,-30(a6)
	moveq	#21,d0
	move	d0,-10(a6)
	cmpi	#$80,-30(a6)
	ble.s	L16116
	moveq	#42,d0
	bra.s	L16118
;
L16116:
	moveq	#32,d0
L16118:
	move	d0,-(sp)
	move	-18(a6),-(sp)
	move.l	16(a6),-(sp)
	pea	x_receive_y_z_s
	move	-14(a6),-(sp)
	jsr	L64FC
	adda	#$E,sp
	moveq	#4,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L15B28
	addq	#6,sp
	move	d0,-24(a6)
	moveq	#4,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L15B28
	addq	#6,sp
	move	d0,-26(a6)
	move.l	-34(a6),-38(a6)
	clr	-28(a6)
L16168:
	move	-28(a6),d0
	cmp	-30(a6),d0
	bge.s	L161A0
	moveq	#4,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L15B28
	addq	#6,sp
	move	d0,-8(a6)
	cmpi	#$FFFF,d0
	beq.s	L161A0
	move.l	-38(a6),a0
	addq.l	#1,-38(a6)
	move	-8(a6),d0
	move.b	d0,(a0)
	addq	#1,-28(a6)
	bra.s	L16168
;
L161A0:
	cmpi	#$FFFF,-8(a6)
	bne.s	L161BE
	pea	timeout_during_block_s
L161AE:
	move	-14(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	bra	L15FD6
;
L161BE:
	move	14(a6),d0
	beq.s	L161D8
	moveq	#4,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L15B28
	addq	#6,sp
	move	d0,-6(a6)
L161D8:
	moveq	#4,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L15B28
	addq	#6,sp
	move	d0,-4(a6)
	move	-26(a6),d1
	andi	#$FF,d1
	move	-24(a6),d0
	not	d0
	andi	#$FF,d0
	cmp	d1,d0
	beq.s	L1620A
	pea	bad_block_complement_s
	bra.s	L161AE
;
L1620A:
	move	-30(a6),-(sp)
	move.l	-34(a6),-(sp)
	move.l	-42(a6),a0
	jsr	(a0)
	addq	#6,sp
	move	d0,-44(a6)
	move	14(a6),d0
	beq.s	L1623E
	move	-6(a6),d0
	lsl.w	#8,d0
	add	-4(a6),d0
	cmp	-44(a6),d0
	beq.s	L16252
	pea	bad_crc_s
	bra	L161AE
;
L1623E:
	move	-4(a6),d0
	cmp	-44(a6),d0
	beq.s	L16252
	pea	bad_checksum_s
	bra	L161AE
;
L16252:
	move	-2(a6),d0
	subq	#1,d0
	andi	#$FF,d0
	cmp	-24(a6),d0
	bne.s	L1627E
	pea	duplicate_block_s
	move	-14(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	moveq	#6,d0
	move	d0,-10(a6)
	bra	L15FD6
;
L1627E:
	move	-2(a6),d0
	andi	#$FF,d0
	cmp	-24(a6),d0
	beq.s	L16296
	pea	block_sequence_error_s
	bra	L161AE
;
L16296:
	moveq	#6,d0
	move	d0,-10(a6)
	addq	#1,-2(a6)
	move	-30(a6),d0
	add	d0,-12(a6)
	move.l	-34(a6),a0
	adda	-30(a6),a0
	move.l	a0,-34(a6)
	cmpi	#$400,-30(a6)
	bne.s	L162C0
	moveq	#8,d0
	bra.s	L162C2
;
L162C0:
	moveq	#1,d0
L162C2:
	add	d0,-18(a6)
	cmpi	#$1C00,-12(a6)
	ble	L15FD6
	move	-12(a6),-(sp)
	move.l	8(a6),a0
	move.l	2894(a0),-(sp)
	move	12(a6),-(sp)
	jsr	task_Fwrite
	addq	#8,sp
	cmp	-12(a6),d0
	beq.s	L16312
	clr	-28(a6)
L162F2:
	cmpi	#$F,-28(a6)
	bge	L16088
	moveq	#24,d0
	move	d0,-(sp)
	move	-14(a6),-(sp)
	jsr	L6DC4
	addq	#4,sp
	addq	#1,-28(a6)
	bra.s	L162F2
;
L16312:
	clr	-12(a6)
	move.l	8(a6),a0
	move.l	2894(a0),-34(a6)
	bra	L15FD6
;
L16324:
	clr	d0
L16326:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1632A:
	link	a6,#-10
	movem.l	d7-d7/a5-a5,(sp)
	move.l	8(a6),a5
	moveq	#0,d7
L16338:
	move	12(a6),d0
	ext.l	d0
	divs	#2,d0
	cmp	d7,d0
	ble.s	L16374
	move	d7,a0
	adda.l	a5,a0
	move.b	(a0),-2(a6)
	move	d7,a0
	adda.l	a5,a0
	move	12(a6),d0
	sub	d7,d0
	subq	#1,d0
	move	d0,a1
	adda.l	a5,a1
	move.b	(a1),(a0)
	move	12(a6),d0
	sub	d7,d0
	subq	#1,d0
	move	d0,a0
	adda.l	a5,a0
	move.b	-2(a6),(a0)
	addq	#1,d7
	bra.s	L16338
;
L16374:
	movem.l	(sp),d7-d7/a5-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1637C:
	link	a6,#-52
	move.l	8(a6),a0
	move.l	#arc_listing_s,2608(a0)
	clr.l	-40(a6)
	clr.l	d0
	move.l	d0,-32(a6)
	move.l	d0,-36(a6)
	clr	-(sp)
	move.l	12(a6),-(sp)
	jsr	L4ADE
	addq	#6,sp
	move	d0,-46(a6)
	bge.s	L163C6
	move.l	12(a6),-(sp)
	pea	could_not_find_archive_file_x_s
L163B8:
	jsr	L63E0
	addq	#8,sp
	clr	d0
	bra	L16638
;
L163C6:
	clr	-48(a6)
L163CA:
	move	#$100,-44(a6)
L163D0:
	subq	#1,-44(a6)
	beq.s	L163FC
	moveq	#1,d0
	move	d0,-(sp)
	pea	-52(a6)
	move	-46(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move	d0,-42(a6)
	cmpi	#1,d0
	bne.s	L163FC
	cmpi.b	#$1A,-52(a6)
	bne.s	L163D0
L163FC:
	move	-44(a6),d0
	bne.s	L1641A
	move	-46(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move.l	12(a6),-(sp)
	pea	archive_x_is_bad_s
	bra.s	L163B8
;
L1641A:
	move	-48(a6),d0
	bne.s	L1644E
	move.l	12(a6),-(sp)
	pea	archive_x_s
	jsr	L63E0
	addq	#8,sp
	pea	L1CE6B
	jsr	L63E0
	addq	#4,sp
	pea	L1CEB5
	jsr	L63E0
	addq	#4,sp
L1644E:
	cmpi	#1,-42(a6)
	bne	L165CA
	moveq	#1,d0
	move	d0,-(sp)
	pea	-52(a6)
	move	-46(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	cmpi	#1,d0
	bne	L165CA
	move.b	-52(a6),d0
	beq	L165CA
	cmpi.b	#1,-52(a6)
	bne.s	L164A0
	moveq	#23,d0
	move	d0,-(sp)
	pea	-27(a6)
	move	-46(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
	move.l	-14(a6),-4(a6)
	bra.s	L164B4
;
L164A0:
	moveq	#27,d0
	move	d0,-(sp)
	pea	-27(a6)
	move	-46(a6),-(sp)
	jsr	task_Fread
	addq	#8,sp
L164B4:
	moveq	#4,d0
	move	d0,-(sp)
	pea	-14(a6)
	jsr	L1632A
	addq	#6,sp
	moveq	#2,d0
	move	d0,-(sp)
	pea	-10(a6)
	jsr	L1632A
	addq	#6,sp
	moveq	#2,d0
	move	d0,-(sp)
	pea	-8(a6)
	jsr	L1632A
	addq	#6,sp
	moveq	#2,d0
	move	d0,-(sp)
	pea	-6(a6)
	jsr	L1632A
	addq	#6,sp
	moveq	#4,d0
	move	d0,-(sp)
	pea	-4(a6)
	jsr	L1632A
	addq	#6,sp
	move.b	-52(a6),d0
	blt.s	L16512
	cmpi.b	#8,-52(a6)
	ble.s	L16516
L16512:
	clr.b	-52(a6)
L16516:
	move.l	-4(a6),d0
	beq.s	L16542
	pea	-4(a6)
	moveq	#100,d0
	move.l	d0,-(sp)
	move.l	-14(a6),-(sp)
	jsr	L1812E
	addq	#8,sp
	move.l	d0,-(sp)
	jsr	L18068
	addq	#8,sp
	move.l	d0,d1
	moveq	#100,d0
	sub.l	d1,d0
	bra.s	L16544
;
L16542:
	clr	d0
L16544:
	move	d0,-50(a6)
	clr.b	-15(a6)
	move	-6(a6),-(sp)
	move	-8(a6),-(sp)
	move	-10(a6),-(sp)
	move.l	-14(a6),-(sp)
	move	-50(a6),-(sp)
	move.b	-52(a6),d0
	ext.w	d0
	ext.l	d0
	lsl.l	#2,d0
	lea	packtype_s_p_a,a0
	adda.l	d0,a0
	move.l	(a0),-(sp)
	move.l	-4(a6),-(sp)
	pea	-27(a6)
	pea	L1CF00
	jsr	L63E0
	adda	#$1C,sp
	move.l	-14(a6),d0
	add.l	-36(a6),d0
	move.l	d0,-36(a6)
	move.l	-32(a6),d0
	addq.l	#1,d0
	move.l	d0,-32(a6)
	move.l	-4(a6),d0
	add.l	-40(a6),d0
	move.l	d0,-40(a6)
	moveq	#1,d0
	move	d0,-(sp)
	move.l	-14(a6),-(sp)
	move	-46(a6),-(sp)
	jsr	task_Fseek
	addq	#8,sp
	addq	#1,-48(a6)
	bra	L163CA
;
L165CA:
	move	-46(a6),-(sp)
	jsr	L4A4C
	addq	#2,sp
	move.l	-40(a6),d0
	beq.s	L16602
	pea	-40(a6)
	moveq	#100,d0
	move.l	d0,-(sp)
	move.l	-36(a6),-(sp)
	jsr	L1812E
	addq	#8,sp
	move.l	d0,-(sp)
	jsr	L18068
	addq	#8,sp
	move.l	d0,d1
	moveq	#100,d0
	sub.l	d1,d0
	bra.s	L16604
;
L16602:
	clr	d0
L16604:
	move	d0,-50(a6)
	pea	L1CF2C
	jsr	L63E0
	addq	#4,sp
	move.l	-36(a6),-(sp)
	move	-50(a6),-(sp)
	move.l	-40(a6),-(sp)
	move.l	-32(a6),-(sp)
	pea	total_x_y_z_t_s
	jsr	L63E0
	adda	#$12,sp
	moveq	#1,d0
L16638:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1663C:
	link	a6,#-8
	movem.l	d7-d7/a5-a5,(sp)
	move.l	8(a6),a5
	moveq	#0,d7
L1664A:
	move.b	(a5)+,d0
	beq.s	L16652
	addq	#1,d7
	bra.s	L1664A
;
L16652:
	move	d7,d0
	movem.l	(sp),d7-d7/a5-a5
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L1665C:
	link	a6,#0
	cmpi	#$A,12(a6)
	bne.s	L16678
	move.l	8(a6),a0
	move.l	(a0),a0
	moveq	#13,d0
	move.b	d0,(a0)
	move.l	8(a6),a0
	addq.l	#1,(a0)
L16678:
	move.l	8(a6),a0
	move.l	(a0),a0
	move	12(a6),d0
	move.b	d0,(a0)
	move.l	8(a6),a0
	addq.l	#1,(a0)
	move.l	8(a6),a0
	move.l	(a0),a0
	clr.b	(a0)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L16696:
	link	a6,#-90
L1669A:
	move.l	8(a6),a0
	addq.l	#1,8(a6)
	move.b	(a0),-2(a6)
	beq	L16E26
	cmpi.b	#$25,-2(a6)
	beq.s	L166E6
	cmpi	#$FFFF,20(a6)
	bne.s	L166D0
	move.b	-2(a6),d0
	ext.w	d0
	move	d0,-(sp)
	pea	22(a6)
	move.l	16(a6),a0
	jsr	(a0)
	addq	#6,sp
	bra.s	L1669A
;
L166D0:
	move.b	-2(a6),d0
	ext.w	d0
	move	d0,-(sp)
	move	20(a6),-(sp)
	move.l	16(a6),a0
	jsr	(a0)
	addq	#4,sp
	bra.s	L1669A
;
L166E6:
	clr.b	-84(a6)
	clr	d0
	move.b	d0,-82(a6)
	move.b	d0,-80(a6)
	move.b	d0,-88(a6)
	move.b	d0,-86(a6)
	move.b	d0,-90(a6)
	clr	-52(a6)
	clr	-50(a6)
L16708:
	move.b	-90(a6),d0
	bne	L167D4
	move.l	8(a6),a0
	addq.l	#1,8(a6)
	move.b	(a0),d0
	ext.w	d0
	move.b	d0,-2(a6)
	move.l	#L18684,a0
	move	#$17,d1
	bra.s	L1672E
;
L1672C:
	addq	#4,a0
L1672E:
	cmp	(a0)+,d0
	dbeq	d1,L1672C
	move.l	(a0),a0
	jmp	(a0)
;
L16738:
	bra.s	L16708
;
L1673A:
	moveq	#1,d0
	move.b	d0,-80(a6)
	bra.s	L16708
;
L16742:
	moveq	#1,d0
	move.b	d0,-82(a6)
	bra.s	L16708
;
L1674A:
	move.b	-2(a6),d0
	ext.w	d0
	subi	#$30,d0
	move	d0,-48(a6)
L16758:
	move.l	8(a6),a0
	addq.l	#1,8(a6)
	move.b	(a0),d0
	ext.w	d0
	move.b	d0,-2(a6)
	cmpi	#$30,d0
	blt.s	L16792
	cmpi.b	#$39,-2(a6)
	bgt.s	L16792
	move	-48(a6),d0
	muls	#$A,d0
	move	d0,-48(a6)
	move.b	-2(a6),d0
	ext.w	d0
	subi	#$30,d0
	add	d0,-48(a6)
	bra.s	L16758
;
L16792:
	move.b	-2(a6),d0
	beq	L16E26
	move.b	-88(a6),d0
	beq.s	L167A8
	move	-48(a6),-52(a6)
	bra.s	L167AE
;
L167A8:
	move	-48(a6),-50(a6)
L167AE:
	subq.l	#1,8(a6)
	bra	L16708
;
L167B6:
	moveq	#1,d0
	move.b	d0,-90(a6)
	bra	L16708
;
L167C0:
	moveq	#1,d0
	move.b	d0,-86(a6)
	bra	L16708
;
L167CA:
	moveq	#1,d0
	move.b	d0,-88(a6)
	bra	L16708
;
L167D4:
	clr	-56(a6)
	clr	-54(a6)
	lea	-22(a6),a0
	move.l	a0,-46(a6)
	move.b	-2(a6),d0
	ext.w	d0
	move.l	#L18714,a0
	move	#$A,d1
	bra.s	L167F8
;
L167F6:
	addq	#4,a0
L167F8:
	cmp	(a0)+,d0
	dbeq	d1,L167F6
	move.l	(a0),a0
	jmp	(a0)
;
L16802:
	bra	L16942
;
L16806:
	move.l	12(a6),a0
	addq.l	#2,12(a6)
	move	(a0),d0
	ext.w	d0
	ext.w	d0
	move.b	d0,-22(a6)
	bra	L1693E
;
L1681C:
	moveq	#10,d0
	move	d0,-64(a6)
	move.b	-86(a6),d0
	beq.s	L16860
	move.l	12(a6),a0
	move.l	(a0),-70(a6)
	addq.l	#4,12(a6)
	move.l	-70(a6),d0
	bge.s	L16856
	move.l	-70(a6),d0
	neg.l	d0
	move.l	d0,-70(a6)
	move	-54(a6),d0
	addq	#1,-54(a6)
	move	d0,a0
	adda.l	a6,a0
	moveq	#45,d0
	move.b	d0,-22(a0)
L16856:
	move.l	-70(a6),-78(a6)
	bra	L16942
;
L16860:
	move.l	12(a6),a0
	addq.l	#2,12(a6)
	move	(a0),-58(a6)
	move	-58(a6),d0
	bge.s	L1688E
	move	-58(a6),d0
	neg	d0
	move	d0,-58(a6)
	move	-54(a6),d0
	addq	#1,-54(a6)
	move	d0,a0
	adda.l	a6,a0
	moveq	#45,d0
	move.b	d0,-22(a0)
L1688E:
	move	-58(a6),-62(a6)
	bra	L16942
;
L16898:
	move.l	12(a6),a0
	addq.l	#2,12(a6)
	move	(a0),-62(a6)
	bra	L16942
;
L168A8:
	moveq	#8,d0
	move	d0,-64(a6)
	move.l	#$1FFFFFFF,-74(a6)
	move.b	-86(a6),d0
	beq.s	L16898
L168BC:
	move.l	12(a6),a0
	move.l	(a0),-78(a6)
L168C4:
	addq.l	#4,12(a6)
	bra.s	L16942
;
L168CA:
	moveq	#10,d0
	move	d0,-64(a6)
	move.b	-86(a6),d0
	bne	L16E26
	bra.s	L16898
;
L168DA:
	moveq	#16,d0
	move	d0,-64(a6)
	move.l	#$FFFFFFF,-74(a6)
	move.b	-86(a6),d0
	bne.s	L168BC
	bra.s	L16898
;
L168F0:
	move.l	12(a6),a0
	move.l	(a0),-46(a6)
L168F8:
	move.l	-46(a6),a0
	move.b	(a0),-2(a6)
	beq.s	L16928
	cmpi.b	#$61,-2(a6)
	blt.s	L16922
	cmpi.b	#$7A,-2(a6)
	bgt.s	L16922
	move.b	-2(a6),d0
	ext.w	d0
	subi	#$20,d0
	move.l	-46(a6),a0
	move.b	d0,(a0)
L16922:
	addq.l	#1,-46(a6)
	bra.s	L168F8
;
L16928:
	moveq	#115,d0
	move.b	d0,-2(a6)
L1692E:
	move.l	12(a6),a0
	move.l	(a0),-46(a6)
	bra.s	L168C4
;
L16938:
	move.b	-2(a6),-22(a6)
L1693E:
	clr.b	-21(a6)
L16942:
	cmpi.b	#$48,-2(a6)
	bne	L169EE
	move	-62(a6),d0
	andi.l	#$FFFF,d0
	divu	#$E10,d0
	move	d0,-66(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	swap	d0
	addi	#$30,d0
	move.b	d0,-22(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	swap	d0
	addi	#$30,d0
	move.b	d0,-21(a6)
	moveq	#58,d0
	move.b	d0,-20(a6)
	move	-62(a6),d0
	andi.l	#$FFFF,d0
	divu	#$3C,d0
	andi.l	#$FFFF,d0
	divu	#$3C,d0
	swap	d0
	move	d0,-66(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	addi	#$30,d0
	move.b	d0,-19(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	swap	d0
	addi	#$30,d0
	move.b	d0,-18(a6)
	clr.b	-17(a6)
L169EE:
	cmpi.b	#$44,-2(a6)
	bne	L16AD8
	move	-62(a6),d0
	lsr.w	#5,d0
	andi	#$F,d0
	move	d0,-66(a6)
	cmpi	#9,-66(a6)
	bls.s	L16A12
	moveq	#49,d0
	bra.s	L16A14
;
L16A12:
	moveq	#32,d0
L16A14:
	move.b	d0,-22(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	swap	d0
	addi	#$30,d0
	move.b	d0,-21(a6)
	moveq	#45,d0
	move.b	d0,-20(a6)
	move	-62(a6),d0
	andi	#$1F,d0
	move	d0,-66(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	swap	d0
	addi	#$30,d0
	move.b	d0,-19(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	swap	d0
	addi	#$30,d0
	move.b	d0,-18(a6)
	moveq	#45,d0
	move.b	d0,-17(a6)
	move	-62(a6),d0
	lsr.w	#8,d0
	lsr.w	#1,d0
	andi	#$7F,d0
	addi	#$7BC,d0
	move	d0,-66(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	swap	d0
	addi	#$30,d0
	move.b	d0,-16(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	swap	d0
	addi	#$30,d0
	move.b	d0,-15(a6)
	clr.b	-14(a6)
	bra	L16D0A
;
L16AD8:
	cmpi.b	#$54,-2(a6)
	bne	L16BAC
	move	-62(a6),d0
	lsr.w	#8,d0
	lsr.w	#3,d0
	andi	#$1F,d0
	andi.l	#$FFFF,d0
	divu	#$C,d0
	swap	d0
	move	d0,-66(a6)
	move	-66(a6),d0
	bne.s	L16B0A
	moveq	#12,d0
	move	d0,-66(a6)
L16B0A:
	cmpi	#9,-66(a6)
	bls.s	L16B16
	moveq	#49,d0
	bra.s	L16B18
;
L16B16:
	moveq	#32,d0
L16B18:
	move.b	d0,-22(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	swap	d0
	addi	#$30,d0
	move.b	d0,-21(a6)
	moveq	#58,d0
	move.b	d0,-20(a6)
	move	-62(a6),d0
	lsr.w	#5,d0
	andi	#$3F,d0
	move	d0,-66(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	swap	d0
	addi	#$30,d0
	move.b	d0,-19(a6)
	move	-66(a6),d0
	andi.l	#$FFFF,d0
	divu	#$A,d0
	swap	d0
	addi	#$30,d0
	move.b	d0,-18(a6)
	move	-62(a6),d0
	lsr.w	#8,d0
	lsr.w	#3,d0
	andi	#$1F,d0
	cmpi	#$C,d0
	bcs.s	L16B98
	moveq	#112,d0
	bra.s	L16B9A
;
L16B98:
	moveq	#97,d0
L16B9A:
	move.b	d0,-17(a6)
	moveq	#109,d0
	move.b	d0,-16(a6)
	clr.b	-15(a6)
	bra	L16D0A
;
L16BAC:
	cmpi.b	#$64,-2(a6)
	beq.s	L16BCE
	cmpi.b	#$6F,-2(a6)
	beq.s	L16BCE
	cmpi.b	#$75,-2(a6)
	beq.s	L16BCE
	cmpi.b	#$78,-2(a6)
	bne	L16D0A
L16BCE:
	move	-52(a6),d0
	bne	L16E26
	move.b	-86(a6),d0
	beq	L16C66
L16BDE:
	move.l	-78(a6),d0
	beq	L16CAA
	moveq	#0,d0
	move	-64(a6),d0
	move.l	d0,-(sp)
	move.l	-78(a6),-(sp)
	jsr	L180BE
	addq	#8,sp
	move	d0,-60(a6)
	move	-60(a6),d0
	bge.s	L16C0C
	move	-64(a6),d0
	add	d0,-60(a6)
L16C0C:
	move	-56(a6),d0
	addq	#1,-56(a6)
	move	d0,a0
	adda.l	a6,a0
	move	-60(a6),a1
	adda.l	#hex_digits_s,a1
	move.b	(a1),-42(a0)
	cmpi	#$A,-64(a6)
	bne.s	L16C48
	moveq	#0,d0
	move	-64(a6),d0
	move.l	d0,-(sp)
	move.l	-78(a6),-(sp)
	jsr	L1806E
	addq	#8,sp
	move.l	d0,-78(a6)
	bra.s	L16BDE
;
L16C48:
	move	-64(a6),d0
	lsr.w	#3,d0
	addq	#2,d0
	move.l	-78(a6),d1
	asr.l	d0,d1
	move.l	d1,-78(a6)
	move.l	-74(a6),d0
	and.l	d0,-78(a6)
	bra	L16BDE
;
L16C66:
	move	-62(a6),d0
	beq.s	L16CAA
	move	-62(a6),d0
	andi.l	#$FFFF,d0
	divu	-64(a6),d0
	swap	d0
	move	d0,-60(a6)
	move	-56(a6),d0
	addq	#1,-56(a6)
	move	d0,a0
	adda.l	a6,a0
	move	-60(a6),a1
	adda.l	#hex_digits_s,a1
	move.b	(a1),-42(a0)
	moveq	#0,d0
	move	-62(a6),d0
	divu	-64(a6),d0
	move	d0,-62(a6)
	bra.s	L16C66
;
L16CAA:
	move	-56(a6),d0
	subq	#1,-56(a6)
	move	d0,d0
	beq.s	L16CE8
	move.b	-84(a6),d0
	bne.s	L16CC8
	move.l	a6,a0
	adda	-56(a6),a0
	move.b	-42(a0),d0
	beq.s	L16CAA
L16CC8:
	move	-54(a6),d0
	addq	#1,-54(a6)
	move	d0,a0
	adda.l	a6,a0
	move.l	a6,a1
	adda	-56(a6),a1
	move.b	-42(a1),-22(a0)
	moveq	#1,d0
	move.b	d0,-84(a6)
	bra.s	L16CAA
;
L16CE8:
	move.b	-84(a6),d0
	bne.s	L16D00
	move	-54(a6),d0
	addq	#1,-54(a6)
	move	d0,a0
	adda.l	a6,a0
	moveq	#48,d0
	move.b	d0,-22(a0)
L16D00:
	move.l	a6,a0
	adda	-54(a6),a0
	clr.b	-22(a0)
L16D0A:
	move.l	-46(a6),-(sp)
	jsr	L1663C
	addq	#4,sp
	move	d0,d1
	move	-50(a6),d0
	sub	d1,d0
	move	d0,-58(a6)
	move	-52(a6),d0
	bne.s	L16D38
	move.l	-46(a6),-(sp)
	jsr	L1663C
	addq	#4,sp
	move	d0,-52(a6)
L16D38:
	move	-58(a6),d0
	ble.s	L16D90
	move.b	-80(a6),d0
	bne.s	L16D90
L16D44:
	move	-58(a6),d0
	subq	#1,-58(a6)
	move	d0,d0
	beq.s	L16D90
	cmpi	#$FFFF,20(a6)
	bne.s	L16D74
	move.b	-82(a6),d0
	beq.s	L16D62
	moveq	#48,d0
	bra.s	L16D64
;
L16D62:
	moveq	#32,d0
L16D64:
	move	d0,-(sp)
	pea	22(a6)
	move.l	16(a6),a0
	jsr	(a0)
	addq	#6,sp
	bra.s	L16D44
;
L16D74:
	move.b	-82(a6),d0
	beq.s	L16D7E
	moveq	#48,d0
	bra.s	L16D80
;
L16D7E:
	moveq	#32,d0
L16D80:
	move	d0,-(sp)
	move	20(a6),-(sp)
	move.l	16(a6),a0
	jsr	(a0)
	addq	#4,sp
	bra.s	L16D44
;
L16D90:
	move.l	-46(a6),a0
	addq.l	#1,-46(a6)
	move.b	(a0),-2(a6)
	beq.s	L16DDC
	move	-52(a6),d0
	beq.s	L16DDC
	cmpi	#$FFFF,20(a6)
	bne.s	L16DC2
	move.b	-2(a6),d0
	ext.w	d0
	move	d0,-(sp)
	pea	22(a6)
	move.l	16(a6),a0
	jsr	(a0)
	addq	#6,sp
	bra.s	L16DD6
;
L16DC2:
	move.b	-2(a6),d0
	ext.w	d0
	move	d0,-(sp)
	move	20(a6),-(sp)
	move.l	16(a6),a0
	jsr	(a0)
	addq	#4,sp
L16DD6:
	subq	#1,-52(a6)
	bra.s	L16D90
;
L16DDC:
	move	-58(a6),d0
	ble	L1669A
	move.b	-80(a6),d0
	beq	L1669A
L16DEC:
	move	-58(a6),d0
	subq	#1,-58(a6)
	move	d0,d0
	beq	L1669A
	cmpi	#$FFFF,20(a6)
	bne.s	L16E14
	moveq	#32,d0
	move	d0,-(sp)
	pea	22(a6)
	move.l	16(a6),a0
	jsr	(a0)
	addq	#6,sp
	bra.s	L16DEC
;
L16E14:
	moveq	#32,d0
	move	d0,-(sp)
	move	20(a6),-(sp)
	move.l	16(a6),a0
	jsr	(a0)
	addq	#4,sp
	bra.s	L16DEC
;
L16E26:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L16E2A:
	link	a6,#0
	move.l	8(a6),a0
	clr.b	(a0)
	move.l	8(a6),-(sp)
	moveq	#-1,d0
	move	d0,-(sp)
	pea	L1665C
	pea	16(a6)
	move.l	12(a6),-(sp)
	jsr	L16696
	adda	#$12,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L16E58:
	link	a6,#-44
	move.l	a3,-(sp)
	move.l	8(a6),a0
	move.l	#modem_init_s,2608(a0)
	move.l	8(a6),a0
	move	(a0),-2(a6)
	move	-2(a6),d0
	muls	#80,d0
	lea	L2BE46,a0
	adda.l	d0,a0
	clr.b	(a0)
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF86,a0
	adda.l	d0,a0
	move	#$12C,(a0)
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF96,a2
	adda.l	d0,a2
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF9E,a1
	adda.l	d0,a1
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF8E,a0
	adda.l	d0,a0
	clr	(a0)
	clr	d0
	move	d0,(a1)
	move	d0,(a2)
	move	-2(a6),d0
	beq	L16FE4
	move	-2(a6),a0
	adda.l	#L46B27,a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-4(a6)
	move	-4(a6),d0
	andi	#2,d0
	beq.s	L16F08
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF86,a0
	adda.l	d0,a0
	move	#$4B0,(a0)
L16F08:
	move	-4(a6),d0
	andi	#4,d0
	beq.s	L16F26
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF86,a0
	adda.l	d0,a0
	move	#$960,(a0)
L16F26:
	move	-4(a6),d0
	andi	#8,d0
	beq.s	L16F44
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF86,a0
	adda.l	d0,a0
	move	#$2580,(a0)
L16F44:
	move	-2(a6),d0
	subq	#1,d0
	muls	#$1C,d0
	addi.l	#$46B2C,d0
	move.l	d0,-(sp)
	move.l	a6,d0
	subi.l	#$24,d0
	move.l	d0,-40(a6)
	move.l	d0,-(sp)
	jsr	L11FEC
	addq	#8,sp
L16F6C:
	move.l	-40(a6),a0
	move.b	(a0),d0
	beq.s	L16F84
	move.l	-40(a6),a0
	cmpi.b	#$2C,(a0)
	beq.s	L16F84
	addq.l	#1,-40(a6)
	bra.s	L16F6C
;
L16F84:
	move.l	-40(a6),a0
	move.b	(a0),d0
	beq.s	L16F96
	move.l	-40(a6),a0
	addq.l	#1,-40(a6)
	clr.b	(a0)
L16F96:
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF8E,a3
	adda.l	d0,a3
	pea	-36(a6)
	pea	autobaud_s
	jsr	L559C
	addq	#8,sp
	move	d0,d0
	bne.s	L16FC0
	moveq	#1,d0
	bra.s	L16FC2
;
L16FC0:
	clr	d0
L16FC2:
	move	d0,(a3)
	beq.s	L16FE4
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF9E,a3
	adda.l	d0,a3
	move.l	-40(a6),-(sp)
	jsr	L12092
	addq	#4,sp
	move	d0,(a3)
L16FE4:
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF8E,a0
	adda.l	d0,a0
	move	(a0),d0
	beq.s	L17006
	move	-2(a6),-(sp)
	jsr	L17018
	addq	#2,sp
	bra.s	L17012
;
L17006:
	move.l	8(a6),-(sp)
	jsr	L17C0E
	addq	#4,sp
L17012:
	move.l	(sp)+,a3
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17018:
	link	a6,#0
	pea	sending_modem_init_1_s
	move	8(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF86,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	8(a6),-(sp)
	jsr	L17500
	addq	#4,sp
	clr	-(sp)
	move	8(a6),-(sp)
	jsr	L17B80
	addq	#4,sp
	moveq	#13,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L23C2
	addq	#4,sp
	moveq	#50,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L17B80
	addq	#4,sp
	pea	hayes_ate0v0m0x1s0_eq_0_s
	move	8(a6),-(sp)
	jsr	L17434
	addq	#6,sp
	move	8(a6),-(sp)
	jsr	L175C0
	addq	#2,sp
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE3E,a0
	adda.l	d0,a0
	clr	(a0)
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L170AE:
	link	a6,#-4
	move.l	8(a6),a0
	move.l	#waiting_for_call_s,2608(a0)
	move.l	8(a6),a0
	move	(a0),-2(a6)
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF8E,a0
	adda.l	d0,a0
	move	(a0),d0
	bne.s	L170EA
	move.l	8(a6),-(sp)
	jsr	L17C6C
	addq	#4,sp
	bra	L17264
;
L170EA:
	move	L3E7BA,d0
	bne	L17264
	move.l	8(a6),a0
	move.l	2604(a0),-(sp)
	move.l	waiting_for_a_call_on_x_p,-(sp)
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF96,a0
	adda.l	d0,a0
	clr	(a0)
	clr	-4(a6)
L17126:
	move	L3E7BA,d0
	bne	L171D0
	cmpi	#$70,-4(a6)
	bge	L171D0
	moveq	#8,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L413C
	addq	#6,sp
L1714A:
	move	L3E7BA,d0
	bne.s	L17174
	move.l	8(a6),a0
	move	2968(a0),d0
	ble.s	L17174
	pea	-4(a6)
	move	-2(a6),-(sp)
	jsr	L17608
	addq	#6,sp
	move	d0,d0
	ble.s	L1714A
	bra	L17264
;
L17174:
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF96,a0
	adda.l	d0,a0
	move	(a0),d0
	beq.s	L171B6
	pea	ring_count_reset_s
	move	-2(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	move.l	8(a6),a0
	move.l	2604(a0),-(sp)
	move.l	waiting_for_a_call_on_x_p,-(sp)
	move	-2(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
L171B6:
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF96,a0
	adda.l	d0,a0
	clr	(a0)
	addq	#1,-4(a6)
	bra	L17126
;
L171D0:
	move	L3E7BA,d0
	bne	L170EA
	move	-2(a6),-(sp)
	pea	waking_up_modem_x_s
	move	-2(a6),-(sp)
	jsr	L64FC
	addq	#8,sp
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF86,a1
	adda.l	d0,a1
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE36,a0
	adda.l	d0,a0
	move	(a0),d0
	cmp	(a1),d0
	beq.s	L17242
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF86,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	-2(a6),-(sp)
	jsr	L17500
	addq	#4,sp
	clr	-(sp)
	move	-2(a6),-(sp)
	jsr	L17B80
	addq	#4,sp
L17242:
	move	-2(a6),-(sp)
	jsr	L175C0
	addq	#2,sp
	move	d0,d0
	beq	L170EA
	move	-2(a6),-(sp)
	jsr	L17018
	addq	#2,sp
	bra	L170EA
;
L17264:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17268:
	link	a6,#-2
	move.l	8(a6),a0
	move.l	#hangup_code_s,2608(a0)
	move.l	8(a6),a0
	move	(a0),-2(a6)
	clr	-(sp)
	move	-2(a6),-(sp)
	jsr	L6DDC
	addq	#4,sp
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF8E,a0
	adda.l	d0,a0
	move	(a0),d0
	bne.s	L172B0
	move.l	8(a6),-(sp)
	jsr	L17EB0
	addq	#4,sp
	bra.s	L172BC
;
L172B0:
	move	-2(a6),-(sp)
	jsr	L172C0
	addq	#2,sp
L172BC:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L172C0:
	link	a6,#-2
L172C4:
	move	L3E7BA,d0
	bne	L17430
	move	8(a6),-(sp)
	jsr	L6D5A
	addq	#2,sp
	clr	-(sp)
	move	8(a6),-(sp)
	jsr	L17B80
	addq	#4,sp
	moveq	#20,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L17B80
	addq	#4,sp
	moveq	#13,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L23C2
	addq	#4,sp
	clr	-(sp)
	move	8(a6),-(sp)
	jsr	rts_out_r
	addq	#4,sp
	moveq	#10,d0
	move	d0,-2(a6)
L1731C:
	move	-2(a6),d0
	subq	#1,-2(a6)
	move	d0,d0
	beq.s	L17344
	moveq	#10,d0
	move	d0,-(sp)
	jsr	L17BE6
	addq	#2,sp
	move	8(a6),-(sp)
	jsr	L6F0E
	addq	#2,sp
	move	d0,d0
	bne.s	L1731C
L17344:
	moveq	#1,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	rts_out_r
	addq	#4,sp
	moveq	#10,d0
	move	d0,-(sp)
	jsr	L17BE6
	addq	#2,sp
	move	8(a6),-(sp)
	jsr	L6F0E
	addq	#2,sp
	move	d0,d0
	beq	L173F4
	moveq	#1,d0
	move	d0,-2(a6)
L17378:
	move	-2(a6),d0
	addq	#1,-2(a6)
	move	d0,d0
	beq.s	L173F4
	clr	-(sp)
	move	8(a6),-(sp)
	jsr	L17B80
	addq	#4,sp
	pea	hayes_plusplusplus_s
	move	8(a6),-(sp)
	jsr	L17434
	addq	#6,sp
	move	8(a6),-(sp)
	jsr	L6F0E
	addq	#2,sp
	move	d0,d0
	beq.s	L173F4
	pea	hayes_ath0_s
	move	8(a6),-(sp)
	jsr	L17434
	addq	#6,sp
	move	8(a6),-(sp)
	jsr	L6F0E
	addq	#2,sp
	move	d0,d0
	beq.s	L173F4
	cmpi	#5,-2(a6)
	ble.s	L17378
	pea	modem_can_not_disconnect
	move	8(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	bra	L172C4
;
L173F4:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF86,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	8(a6),-(sp)
	jsr	L17500
	addq	#4,sp
	move	8(a6),-(sp)
	jsr	L175C0
	addq	#2,sp
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE3E,a0
	adda.l	d0,a0
	clr	(a0)
L17430:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17434:
	link	a6,#-6
	move	8(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L2D57A,a0
	adda.l	d0,a0
	move.l	(a0),-4(a6)
	pea	command_s
	move	8(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	move.l	10(a6),-(sp)
	move	8(a6),-(sp)
	jsr	L174B2
	addq	#6,sp
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-4(a6),-(sp)
	jsr	L413C
	addq	#6,sp
L1747E:
	move.l	-4(a6),a0
	move	2968(a0),d0
	ble.s	L174AA
	move	8(a6),-(sp)
	jsr	L17A16
	addq	#2,sp
	move	d0,-6(a6)
	move	-6(a6),d0
	blt.s	L1747E
	moveq	#50,d0
	move	d0,-(sp)
	jsr	L17BE6
	addq	#2,sp
L174AA:
	move	-6(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L174B2:
	link	a6,#0
.L174B6:
	move.l	10(a6),a0
	move.b	(a0),d0
	beq.s	.L174FC
	move.l	10(a6),a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	user_conout_2
	addq	#4,sp
	move.l	10(a6),a0
	addq.l	#1,10(a6)
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L23C2
	addq	#4,sp
	moveq	#2,d0
	move	d0,-(sp)
	jsr	L17BE6
	addq	#2,sp
	bra.s	.L174B6
;
.L174FC:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17500:
	link	a6,#-2
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF86,a0
	adda.l	d0,a0
	move	10(a6),d0
	cmp	(a0),d0
	bls.s	L17530
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF86,a0
	adda.l	d0,a0
	move	(a0),10(a6)
L17530:
	move	10(a6),d0
	move.l	#L18756,a0
	move	#4,d1
	bra.s	L17542
;
L17540:
	addq	#4,a0
L17542:
	cmp	(a0)+,d0
	dbeq	d1,L17540
	move.l	(a0),a0
	jmp	(a0)
;
L1754C:
	bra.s	L17584
;
L1754E:
	move	L187D8,-2(a6)
	bra.s	L17584
;
L17558:
	move	L187DA,-2(a6)
	bra.s	L17584
;
L17562:
	move	L187DC,-2(a6)
	bra.s	L17584
;
L1756C:
	move	L187DE,-2(a6)
	bra.s	L17584
;
L17576:
	move	L187D8,-2(a6)
	move	#$12C,10(a6)
L17584:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE36,a0
	adda.l	d0,a0
	move	10(a6),(a0)
	move	8(a6),d0
	muls	#$1016,d0
	lea	L2E120,a0
	adda.l	d0,a0
	move	-2(a6),d0
	move	d0,(a0)
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L6F22
	addq	#4,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L175C0:
	link	a6,#-2
	moveq	#3,d0
	move	d0,-2(a6)
L175CA:
	move	-2(a6),d0
	subq	#1,-2(a6)
	move	d0,d0
	beq.s	L175F0
	pea	hayes_at_s
	move	8(a6),-(sp)
	jsr	L17434
	addq	#6,sp
	move	d0,d0
	blt.s	L175CA
	clr	d0
	bra.s	L17604
;
L175F0:
	pea	modem_is_not_responding_s
	move	8(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	moveq	#1,d0
L17604:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17608:
	link	a6,#-6
	move	8(a6),-(sp)
	jsr	L6F0E
	addq	#2,sp
	move	d0,d0
	bne.s	L17644
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE3E,a0
	adda.l	d0,a0
	cmpi	#1,(a0)
	bne.s	L17644
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE3E,a0
	adda.l	d0,a0
	clr	(a0)
L17644:
	move	8(a6),-(sp)
	jsr	L17A16
	addq	#2,sp
	move	d0,-6(a6)
	move	-6(a6),d0
	blt	L17842
	move	8(a6),d0
	ext.l	d0
	lsl.l	#2,d0
	lea	L2D57A,a0
	adda.l	d0,a0
	move.l	(a0),-4(a6)
	move	-6(a6),-(sp)
	move	8(a6),-(sp)
	jsr	L17858
	addq	#4,sp
	addq	#1,d0
	cmpi	#2,d0
	bhi	L17842
	lsl.w	#2,d0
	move	d0,a0
	adda.l	#L18774,a0
	move.l	(a0),a0
	jmp	(a0)
;
L17698:
	bra	L17842
;
L1769C:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF96,a0
	adda.l	d0,a0
	clr	(a0)
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE3E,a0
	adda.l	d0,a0
	clr	(a0)
	moveq	#2,d0
	move	d0,-(sp)
	move.l	-4(a6),-(sp)
	jsr	L413C
	addq	#6,sp
L176D0:
	move.l	-4(a6),a0
	move	2968(a0),d0
	ble.s	L1770A
	move	8(a6),-(sp)
	jsr	L6F0E
	addq	#2,sp
	move	d0,d0
	beq.s	L176D0
	moveq	#100,d0
	move	d0,-(sp)
	jsr	L17BE6
	addq	#2,sp
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE3E,a0
	adda.l	d0,a0
	moveq	#1,d0
	move	d0,(a0)
L1770A:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE3E,a0
	adda.l	d0,a0
	move	(a0),d0
	bne	L17842
	move.l	10(a6),a0
	moveq	#112,d0
L17726:
	move	d0,(a0)
	bra	L17842
;
L1772C:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF96,a0
	adda.l	d0,a0
	clr	(a0)
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE3E,a0
	adda.l	d0,a0
	clr	(a0)
	bra	L17842
;
L17754:
	cmpi	#2,-6(a6)
	bne.s	L1772C
	move.l	10(a6),a0
	moveq	#105,d0
	move	d0,(a0)
	moveq	#8,d0
	move	d0,-(sp)
	move.l	-4(a6),-(sp)
	jsr	L413C
	addq	#6,sp
	pea	incoming_call_s
	move	8(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF9E,a1
	adda.l	d0,a1
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF96,a0
	adda.l	d0,a0
	addq	#1,(a0)
	move	(a0),d0
	cmp	(a1),d0
	blt.s	L1780A
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF96,a0
	adda.l	d0,a0
	clr	(a0)
	moveq	#20,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L17B80
	addq	#4,sp
	pea	answering_now_s
	move	8(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	pea	hayes_ata_s
	move	8(a6),-(sp)
	jsr	L174B2
	addq	#6,sp
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE3E,a0
	adda.l	d0,a0
	moveq	#-1,d0
	bra	L17726
;
L1780A:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF9E,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BF96,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	pea	ring_x_of_y_s
	move	8(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
L17842:
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE3E,a0
	adda.l	d0,a0
	move	(a0),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17858:
	link	a6,#-88
	moveq	#-1,d0
	move	d0,-88(a6)
	move.l	#L1D106,-84(a6)
	move	10(a6),d0
	cmpi	#$11,d0
	bhi	L1796A
	lsl.w	#2,d0
	move	d0,a0
	adda.l	#L18780,a0
	move.l	(a0),a0
	jmp	(a0)
;
L17884:
	bra	L17980
;
L17888:
	moveq	#1,d0
	move	d0,-88(a6)
	move	#$12C,-86(a6)
	bra	L17980
;
L17898:
	moveq	#1,d0
	move	d0,-88(a6)
	move	#$4B0,-86(a6)
	bra	L17980
;
L178A8:
	moveq	#1,d0
	move	d0,-88(a6)
	move	#$258,-86(a6)
	bra	L17980
;
L178B8:
	moveq	#1,d0
	move	d0,-88(a6)
	move	#$960,-86(a6)
	bra	L17980
;
L178C8:
	moveq	#1,d0
	move	d0,-88(a6)
	move	#$2580,-86(a6)
	bra	L17980
;
L178D8:
	pea	ringing_s
	bra	L17970
;
L178E2:
	moveq	#1,d0
	move	d0,-88(a6)
	move	#$4B0,-86(a6)
	move.l	#_arq_1_s,-84(a6)
	bra	L17980
;
L178FA:
	moveq	#1,d0
	move	d0,-88(a6)
	move	#$960,-86(a6)
	move.l	#_arq_2_s,-84(a6)
	bra.s	L17980
;
L17910:
	moveq	#1,d0
	move	d0,-88(a6)
	move	#$2580,-86(a6)
	move.l	#_arq_3_s,-84(a6)
	bra.s	L17980
;
L17926:
	pea	ring_s
	bra.s	L17970
;
L1792E:
	pea	no_answer_s
	bra.s	L17970
;
L17936:
	pea	no_carrier_s
	bra.s	L17970
;
L1793E:
	pea	no_dial_tone_s
	bra.s	L17970
;
L17946:
	pea	busy_s
	bra.s	L17970
;
L1794E:
	pea	format_error_s
L17954:
	pea	-80(a6)
	jsr	L11FEC
	addq	#8,sp
	bra.s	L17980
;
L17962:
	pea	voice_detected_s
	bra.s	L17954
;
L1796A:
	pea	L1D166
L17970:
	pea	-80(a6)
	jsr	L11FEC
	addq	#8,sp
	clr	-88(a6)
L17980:
	cmpi	#1,-88(a6)
	bne.s	L179D2
	move	-86(a6),-(sp)
	move	8(a6),-(sp)
	jsr	L17500
	addq	#4,sp
	moveq	#20,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L17B80
	addq	#4,sp
	move.l	-84(a6),-(sp)
	move	8(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L2BE36,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	pea	connected_at_x_y_s
	pea	-80(a6)
	jsr	L16E2A
	adda	#$E,sp
L179D2:
	move.b	-80(a6),d0
	beq.s	L179F0
	pea	-80(a6)
	pea	modem_x_s
	move	8(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
L179F0:
	move	-88(a6),d0
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L179F8:
	link	a6,#0
	cmpi	#$30,8(a6)
	blt.s	L17A10
	cmpi	#$39,8(a6)
	bgt.s	L17A10
	moveq	#1,d0
	bra.s	L17A12
;
L17A10:
	clr	d0
L17A12:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17A16:
	link	a6,#-2
	move	8(a6),-(sp)
	jsr	L6DF4
	addq	#2,sp
	move	d0,-2(a6)
	cmpi	#$FFFF,d0
	beq	L17B7A
	move	8(a6),d0
	muls	#80,d0
	lea	L2BE46,a0
	adda.l	d0,a0
	move.b	(a0),d1
	ext.w	d1
	move	8(a6),d0
	muls	#80,d0
	move.l	d0,-(sp)
	move	d1,d0
	ext.l	d0
	add.l	d0,(sp)
	move.l	(sp)+,d0
	lea	L2BE47,a0
	adda.l	d0,a0
	move	-2(a6),d0
	andi	#$7F,d0
	move.b	d0,(a0)
	move	8(a6),d0
	muls	#80,d0
	lea	L2BE46,a1
	adda.l	d0,a1
	move.b	(a1),d1
	ext.w	d1
	move	8(a6),d0
	muls	#80,d0
	move.l	d0,-(sp)
	move	d1,d0
	ext.l	d0
	add.l	d0,(sp)
	move.l	(sp)+,d0
	lea	L2BE47,a0
	adda.l	d0,a0
	cmpi.b	#$D,(a0)
	beq.s	L17AB4
	move	8(a6),d0
	muls	#80,d0
	lea	L2BE46,a0
	adda.l	d0,a0
	cmpi.b	#$46,(a0)
	ble.s	L17AF8
L17AB4:
	move	8(a6),d0
	muls	#80,d0
	lea	L2BE46,a0
	adda.l	d0,a0
	move.b	(a0),d0
	ble	L17B4A
	move	8(a6),d0
	muls	#80,d0
	lea	L2BE46,a0
	adda.l	d0,a0
	clr.b	(a0)
	move	8(a6),d0
	muls	#80,d0
	addi.l	#$2BE47,d0
	move.l	d0,-(sp)
	jsr	L12092
	addq	#4,sp
	bra	L17B7C
;
L17AF8:
	move	8(a6),d0
	muls	#80,d0
	lea	L2BE46,a0
	adda.l	d0,a0
	move.b	(a0),d1
	ext.w	d1
	move	8(a6),d0
	muls	#80,d0
	move.l	d0,-(sp)
	move	d1,d0
	ext.l	d0
	add.l	d0,(sp)
	move.l	(sp)+,d0
	lea	L2BE47,a0
	adda.l	d0,a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-(sp)
	jsr	L179F8
	addq	#2,sp
	move	d0,d0
	beq.s	L17B4A
	move	8(a6),d0
	muls	#80,d0
	lea	L2BE46,a0
	adda.l	d0,a0
	addq.b	#1,(a0)
L17B4A:
	move	8(a6),d0
	muls	#80,d0
	lea	L2BE46,a0
	adda.l	d0,a0
	move.b	(a0),d1
	ext.w	d1
	move	8(a6),d0
	muls	#80,d0
	move.l	d0,-(sp)
	move	d1,d0
	ext.l	d0
	add.l	d0,(sp)
	move.l	(sp)+,d0
	lea	L2BE47,a0
	adda.l	d0,a0
	clr.b	(a0)
L17B7A:
	moveq	#-1,d0
L17B7C:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17B80:
	link	a6,#0
	move	10(a6),d0
	beq.s	L17BD0
	move	10(a6),d0
	muls	#$A,d0
	ext.l	d0
	divs	#$64,d0
	addq	#1,d0
	move	d0,10(a6)
L17B9E:
	move	8(a6),-(sp)
	jsr	L6DF4
	addq	#2,sp
	cmpi	#$FFFF,d0
	bne.s	L17B9E
	move	10(a6),-(sp)
	jsr	L3A10
	addq	#2,sp
	move	8(a6),-(sp)
	jsr	L6DF4
	addq	#2,sp
	cmpi	#$FFFF,d0
	bne.s	L17B9E
	bra.s	L17BE2
;
L17BD0:
	move	8(a6),-(sp)
	jsr	L6DF4
	addq	#2,sp
	cmpi	#$FFFF,d0
	bne.s	L17BD0
L17BE2:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17BE6:
	link	a6,#0
	move	8(a6),d0
	muls	#$A,d0
	ext.l	d0
	divs	#$64,d0
	addq	#1,d0
	move	d0,8(a6)
	move	8(a6),-(sp)
	jsr	L3A10
	addq	#2,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17C0E:
	link	a6,#-2
	move.l	8(a6),a0
	move	(a0),-2(a6)
	beq.s	L17C68
	pea	sending_modem_init_2_s
	move	-2(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	move	L187D8,d0
	move.l	8(a6),a0
	move	d0,2966(a0)
	move	d0,-(sp)
	move	-2(a6),-(sp)
	jsr	L6F22
	addq	#4,sp
	move	-2(a6),d0
	subq	#1,d0
	muls	#$1C,d0
	addi.l	#$46B2C,d0
	move.l	d0,-(sp)
	move	-2(a6),-(sp)
	jsr	L17F66
	addq	#6,sp
L17C68:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17C6C:
	link	a6,#-10
	move.l	8(a6),a0
	move	(a0),-10(a6)
	move.l	8(a6),a0
	move.l	2604(a0),-(sp)
	move.l	waiting_for_a_call_on_x_p,-(sp)
	move	-10(a6),-(sp)
	jsr	L64FC
	adda	#$A,sp
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L7086
	addq	#6,sp
	move.l	8(a6),-(sp)
	jsr	L707E
	addq	#4,sp
L17CB0:
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	move.l	8(a6),a0
	move	2600(a0),d0
	bne.s	L17CCE
	move	L3E7BA,d0
	beq.s	L17CB0
L17CCE:
	move	L3E7BA,d0
	bne	L17EAC
	move	-10(a6),d0
	beq	L17EAC
	pea	call_detected_s
	move	-10(a6),-(sp)
	jsr	L64FC
	addq	#6,sp
	moveq	#1,d0
	move	d0,-2(a6)
	move	-10(a6),a0
	adda.l	#L46B27,a0
	move.b	(a0),d0
	ext.w	d0
	move	d0,-8(a6)
	move.l	8(a6),-(sp)
	jsr	L7050
	addq	#4,sp
	moveq	#10,d0
	move	d0,-4(a6)
L17D1C:
	move	-4(a6),d0
	subq	#1,-4(a6)
	move	d0,d0
	beq	L17EAC
	move.l	8(a6),a0
	move	2600(a0),d0
	beq	L17EAC
	move	L3E7BA,d0
	bne	L17EAC
	move.l	8(a6),a0
	move.l	#detecting_caller_s,2608(a0)
	move	-2(a6),d0
	bge.s	L17D58
	moveq	#3,d0
	move	d0,-2(a6)
L17D58:
	move	-2(a6),d0
	blt.s	L17D1C
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187E8,a0
	adda.l	d0,a0
	move	-8(a6),d0
	and	(a0),d0
	bne.s	L17D7C
L17D76:
	subq	#1,-2(a6)
	bra.s	L17D58
;
L17D7C:
	move.l	8(a6),a0
	move	2600(a0),d0
	beq.s	L17D1C
	move.l	8(a6),-(sp)
	jsr	L707E
	addq	#4,sp
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187D8,a1
	adda.l	d0,a1
	move.l	8(a6),a0
	move	(a1),2966(a0)
	move.l	8(a6),a0
	move	2966(a0),-(sp)
	move	-10(a6),-(sp)
	jsr	L6F22
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	move.l	8(a6),-(sp)
	jsr	L707E
	addq	#4,sp
	moveq	#19,d0
	move	d0,-(sp)
	pea	press_return_s
	move	-10(a6),-(sp)
	jsr	L6D80
	addq	#8,sp
L17DEC:
	move	-10(a6),-(sp)
	jsr	L6D46
	addq	#2,sp
	move	d0,d0
	beq.s	L17DEC
	moveq	#2,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L413C
	addq	#6,sp
L17E0C:
	move.l	8(a6),a0
	move	2968(a0),d0
	ble	L17D76
	move.l	8(a6),a0
	move	2600(a0),d0
	beq	L17D76
	move	-10(a6),-(sp)
	jsr	L6DF4
	addq	#2,sp
	move	d0,-6(a6)
	move	-6(a6),d0
	andi	#$7F,d0
	cmpi	#$D,d0
	bne.s	L17E0C
	cmpi	#$D,-6(a6)
	bne.s	L17E5E
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187D8,a0
	adda.l	d0,a0
	move	(a0),d0
	bra.s	L17E78
;
L17E5E:
	move	-2(a6),d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187D8,a0
	adda.l	d0,a0
	move	(a0),d0
	andi	#$FFFE,d0
	ori	#$18,d0
L17E78:
	move.l	8(a6),a0
	move	d0,2966(a0)
	move.l	8(a6),a0
	move	2966(a0),-(sp)
	move	-10(a6),-(sp)
	jsr	L6F22
	addq	#4,sp
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	move.l	8(a6),-(sp)
	jsr	L707E
	addq	#4,sp
L17EAC:
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17EB0:
	link	a6,#0
	move.l	8(a6),-(sp)
	jsr	L7050
	addq	#4,sp
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	L7086
	addq	#6,sp
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L6D5A
	addq	#2,sp
	move.l	8(a6),a0
	move	(a0),d0
	beq.s	L17F06
	move.l	8(a6),a0
	move	(a0),d0
	subq	#1,d0
	muls	#$1C,d0
	addi.l	#$46B9C,d0
	move.l	d0,-(sp)
	move.l	8(a6),a0
	move	(a0),-(sp)
	jsr	L17F66
	addq	#6,sp
L17F06:
	moveq	#2,d0
L17F08:
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	move.l	8(a6),a0
	move	2600(a0),d0
	beq.s	L17F52
	move	L3E7BA,d0
	bne.s	L17F52
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	L7086
	addq	#6,sp
	pea	please_discon_s
	jsr	L63E0
	addq	#4,sp
	clr	-(sp)
	move.l	8(a6),-(sp)
	jsr	L7086
	addq	#6,sp
	moveq	#5,d0
	bra.s	L17F08
;
L17F52:
	moveq	#1,d0
	move	d0,-(sp)
	move.l	8(a6),-(sp)
	jsr	L7086
	addq	#6,sp
	unlk	a6
	rts
;
;
; Func	-------------------------------
;
L17F66:
	link	a6,#-4
L17F6A:
	move.l	10(a6),a0
	addq.l	#1,10(a6)
	move.b	(a0),d0
	ext.w	d0
	move	d0,-2(a6)
	beq	L18064
	clr	-4(a6)
L17F82:
	cmpi	#$3E8,-4(a6)
	bge.s	L17F90
	addq	#1,-4(a6)
	bra.s	L17F82
;
;
L17F90:
	cmpi	#$5C,-2(a6)
	beq.s	L17FA0
	cmpi	#$2F,-2(a6)
	bne.s	L17FAE
L17FA0:
	moveq	#1,d0
	move	d0,-(sp)
	jsr	L3AAA
	addq	#2,sp
	bra.s	L17F6A
;
;
L17FAE:
	cmpi	#$7E,-2(a6)
	bne.s	L18000
	move.l	10(a6),a0
	addq.l	#1,10(a6)
	move.b	(a0),d0
	ext.w	d0
	move	d0,-2(a6)
	beq	L18064
	cmpi	#$30,-2(a6)
	blt.s	L17F6A
	cmpi	#$33,-2(a6)
	bgt.s	L17F6A
	move	-2(a6),d0
	subi	#$30,d0
	ext.l	d0
	lsl.l	#1,d0
	lea	L187D8,a0
	adda.l	d0,a0
	move	(a0),-(sp)
	move	8(a6),-(sp)
	jsr	L6F22
	addq	#4,sp
	bra	L17F6A
;
L18000:
	cmpi	#$5E,-2(a6)
	bne.s	L1804C
	move.l	10(a6),a0
	addq.l	#1,10(a6)
	move.b	(a0),d0
	ext.w	d0
	move	d0,-2(a6)
	beq.s	L18064
	cmpi	#$41,-2(a6)
	blt	L17F6A
	cmpi	#$5A,-2(a6)
	bgt	L17F6A
L1802E:
	move	-2(a6),d0
	subi	#$40,d0
	move	d0,-(sp)
	move	8(a6),-(sp)
	jsr	L23C2
	addq	#4,sp
	move	d0,d0
	bne	L17F6A
	bra.s	L1802E
;
L1804C:
	move	-2(a6),-(sp)
	move	8(a6),-(sp)
	jsr	L23C2
	addq	#4,sp
	move	d0,d0
	bne	L17F6A
	bra.s	L1804C
;
L18064:
	unlk	a6
	rts
;
L18068:
	move.l	8(sp),a1
	bra.s	L18072
;
L1806E:
	lea	8(sp),a1
L18072:
	move.l	4(sp),d1
	bpl.s	L1807A
	neg.l	d1
L1807A:
	move.l	(a1),d2
	bpl.s	L18080
	neg.l	d2
L18080:
	lea	L18088(pc),a0
	bra	L18102
;
L18088:
	tst.b	4(sp)
	bpl.s	L18096
	neg.l	d1
	tst.b	(a1)
	bmi.s	L1809C
	bra.s	L1809A
;
L18096:
	tst.b	(a1)
	bpl.s	L1809C
L1809A:
	neg.l	d0
L1809C:
	rts
;
L1809E:
	move.l	8(sp),d2
	bra.s	L180AA
;
L180A4:
	move.l	8(sp),a0
	move.l	(a0),d2
L180AA:
	move.l	4(sp),d1
	lea	L180B6(pc),a0
	bra	L18102
;
L180B6:
	rts
;
L180B8:
	move.l	8(sp),a1
	bra.s	L180C2
;
L180BE:
	lea	8(sp),a1
L180C2:
	move.l	(a1),d2
	bpl.s	L180C8
	neg.l	d2
L180C8:
	move.l	4(sp),d1
	bpl.s	L180D0
	neg.l	d1
L180D0:
	lea	L180D8(pc),a0
	bra	L18102
;
L180D8:
	move.l	d1,d0
	beq.s	L180E4
	tst.b	4(sp)
	bpl.s	L180E4
	neg.l	d0
L180E4:
	rts
;
L180E6:
	move.l	8(sp),d2
	bra.s	L180F2
;
L180EC:
	move.l	8(sp),a0
	move.l	(a0),d2
L180F2:
	move.l	4(sp),d1
	lea	L180FE(pc),a0
	bra	L18102
;
L180FE:
	move.l	d1,d0
	rts
;
L18102:
	moveq	#-1,d0
	tst.l	d2
	bne.s	L1810E
	moveq	#0,d0
	jmp	(a0)
;
L1810C:
	lsr.l	#1,d0
L1810E:
	cmp.l	d2,d1
	bls.s	L18118
	lsl.l	#1,d2
	bcc.s	L1810C
L18116:
	roxr.l	#1,d2
L18118:
	sub.l	d2,d1
	bcc.s	L1811E
	add.l	d2,d1
L1811E:
	roxl.l	#1,d0
	bcc.s	L18116
	not.l	d0
	jmp	(a0)
;
L18126:
	move.l	8(sp),a0
	move.l	(a0),d1
	bra.s	L18132
;
L1812E:
	move.l	8(sp),d1
L18132:
	move.l	d1,d0
	bpl.s	L18138
	neg.l	d1
L18138:
	move.l	4(sp),d2
	bpl.s	L18142
	neg.l	d2
	neg.l	d0
L18142:
	move.l	d0,a2
	lea	L1814A(pc),a0
	bra.s	L18162
;
L1814A:
	move.l	a2,d1
	bpl.s	L18150
	neg.l	d0
L18150:
	rts
;
L18152:
	move.l	8(sp),a0
	move.l	(a0),d1
	bra.s	L1815E
;
L1815A:
	move.l	8(sp),d1
L1815E:
	move.l	(sp)+,a0
	move.l	(sp),d2
L18162:
	move	d1,d0
	mulu	d2,d0
	move.l	d0,a1
	move	d1,d0
	swap	d1
	mulu	d2,d1
	swap	d2
	mulu	d2,d0
	add.l	d1,d0
	swap	d0
	clr	d0
	add.l	a1,d0
	jmp	(a0)
;
;
;----------------------------------------------------------------------------
;
	data
;
;----------------------------------------------------------------------------
;	starts at offset $1817C
;
L1817C:
pg_basepage_p:		dc.l	0	;Unref
L18180:
pg_databeg_p:		dc.l	0	;Unref
L18184:
pg_textbeg_p:		dc.l	0	;Unref
L18188:
pg_entry_sp:		dc.l	0
L1818C:
pg_entry_ssp:		dc.l	0
L18190:
taskdos_err_f:		dc.w	0
L18192:		dc.w	0	;Single writeref
L18194:
pg_entry_conterm:	dc.b	0,0
L18196:		dc.l	$0000D903	;Single readref
L1819A:		dc.b	0,0
L1819C:
out_of_mem_s:		dc.b	ESC,'E'
			dc.b	'Fatal: Out of memory!',CR,LF,LF
			dc.b	'Press ',ESC,'p',' RETURN ',ESC,'q',NUL
			even
L181CA:
old_bios_p:		dc.l	0
L181CE:
old_xbios_p:		dc.l	0
L181D2:
old_iv_time_a_p:	dc.l	0
L181D6:	dc.w	0
	dc.w	0
L181DA:	dc.w	0
L181DC:	dc.w	0
L181DE:	dc.w	0
;
L181E0:	dc.l	L18210
	dc.l	L18232
	dc.l	L18254
	dc.l	L18276
	dc.l	L18298
	dc.l	L182BA
;
L181F8:	dc.b	$FF,$FF,$FA,1,$FF,$FF,$FA,1,0,$FB,0,1,0,$FB,$10,1
	dc.b	0,$FA,0,1,0,$FA,$10,1
;
L18210:	dc.l	L1D1FE
	dc.b	2,0,0,0,0,0,0,$80,1,$80
	dc.l	L1DDFE
	dc.b	2,0,0,0,0,0,0,$80,1,$80,0,0,0,0,1,0
;
L18232:	dc.l	L1D3FE
	dc.b	2,0,0,0,0,0,0,$80,1,$80
	dc.l	L1DFFE
	dc.b	2,0,0,0,0,0,0,$80,1,$80,0,0,0,0,1,0
;
L18254:	dc.l	L1D5FE
	dc.b	2,0,0,0,0,0,0,$80,1,$80
	dc.l	L1E1FE
	dc.b	2,0,0,0,0,0,0,$80,1,$80,0,0,0,0,1,0
;
L18276:	dc.l	L1D7FE
	dc.b	2,0,0,0,0,0,0,$80,1,$80
	dc.l	L1E3FE
	dc.b	2,0,0,0,0,0,0,$80,1,$80,0,0,0,0,1,0
;
L18298:	dc.l	L1D9FE
	dc.b	2,0,0,0,0,0,0,$80,1,$80
	dc.l	L1E5FE
	dc.b	2,0,0,0,0,0,0,$80,1,$80,0,0,0,0,1,0
;
L182BA:	dc.l	L1DBFE
	dc.b	2,0,0,0,0,0,0,$80,1,$80
	dc.l	L1E7FE
	dc.b	2,0,0,0,0,0,0,$80,1,$80,0,0,0,0,1,0
	dc.b	0,0,0,0
L182E0:
	dc.w	0
L182E2:
old_kb_handler_p:
	dc.l	0
L182E6:
kb_iorec_p:
	dc.l	0
L182EA:
old_iv_v24treq_p:
	dc.l	0
L182EE:
old_iv_v24rreq_p:
	dc.l	0
L182F2:
old_iv_v24ring_p:
	dc.l	0
L182F6:
old_iv_v24rerr_p:
	dc.l	0
L182FA:
old_iv_v24terr_p:
	dc.l	0
L182FE:	dc.b	0
L182FF:	dc.b	$CC,$BB,$99
	dc.b	'f'
	dc.b	$88
	dc.b	'w'
	dc.b	$AA
	dc.b	'fUDf3"'
	dc.b	$11,0
	dc.b	'f'
	dc.b	$0,0,0
;
L18312:	dc.l	L33DA
	dc.l	L340A
	dc.l	L33FE
	dc.l	L340A
	dc.l	L33FE
	dc.l	L340A
	dc.l	L33E8
;
L1832E:	dc.l	L58D4
	dc.l	L58E2
	dc.l	L58F2
	dc.l	L5902
;
L1833E:	dc.b	0,$D
	dc.l	L620C
	dc.b	0
	dc.b	'd'
	dc.l	L621A
	dc.b	0
	dc.b	'n'
	dc.l	L620C
	dc.b	0
	dc.b	't'
	dc.l	L622A
	dc.b	0,$D
	dc.l	L6238
;
L1835C:	dc.l	L8E4C
	dc.l	L8E64
	dc.l	L8E64
	dc.l	L8E64
	dc.l	L8E76
	dc.l	L8EBC
	dc.l	L8F0C
	dc.l	L8F20
	dc.l	L8F4C
	dc.l	L906E
	dc.l	L90B4
	dc.l	L90FA
	dc.l	L9162
	dc.l	L91C8
	dc.l	L8E64
	dc.l	L9234
;
L1839C:	dc.b	0,3
	dc.l	LB63E
	dc.b	0,$D
	dc.l	LB6CE
	dc.b	0,$F
	dc.l	LB63E
	dc.b	0,$1B
	dc.l	LBC0A
	dc.b	0
	dc.b	' '
	dc.l	LB6CE
	dc.b	0
	dc.b	'A'
	dc.l	LB970
	dc.b	0
	dc.b	'C'
	dc.l	LBA6C
	dc.b	0
	dc.b	'D'
	dc.l	LB998
	dc.b	0
	dc.b	'J'
	dc.l	LB710
	dc.b	0
	dc.b	'M'
	dc.l	LBB42
	dc.b	0
	dc.b	'N'
	dc.l	LB6CE
	dc.b	0
	dc.b	'P'
	dc.l	LB754
	dc.b	0
	dc.b	'Q'
	dc.l	LBC0A
	dc.b	0
	dc.b	'R'
	dc.l	LB85A
	dc.b	0
	dc.b	'S'
	dc.l	LB97A
	dc.b	0
	dc.b	'W'
	dc.l	LBBCA
	dc.b	0
	dc.b	'X'
	dc.l	LB68A
	dc.b	0,3
	dc.l	LB63E
;
L18408:	dc.l	LEBF4
	dc.l	LECF6
	dc.l	LED6C
	dc.l	LEDB0
	dc.l	LEDEC
	dc.l	LEE2A
	dc.l	LEE68
	dc.l	LEEA6
	dc.l	LEEE4
	dc.l	LEF3E
	dc.l	LEFCA
	dc.l	LF010
	dc.l	LF056
	dc.l	LF0CE
	dc.l	LF114
	dc.l	LF15A
	dc.l	LF1A0
	dc.l	LF1C2
;
L18450:	dc.b	0,3
	dc.l	LF372
	dc.b	0,$D
	dc.l	LF208
	dc.b	0,$1B
	dc.l	LF372
	dc.b	0
	dc.b	'C'
	dc.l	LEB92
	dc.b	0
	dc.b	'D'
	dc.l	LEAF8
	dc.b	0
	dc.b	'N'
	dc.l	LF208
	dc.b	0
	dc.b	'P'
	dc.l	LF2D6
	dc.b	0
	dc.b	'Q'
	dc.l	LF372
	dc.b	0,3
	dc.l	LEAE0
;
L18486:	dc.b	0
	dc.b	'@'
	dc.l	LFB4C
	dc.b	0,$80
	dc.l	LFB54
	dc.b	0,$A0
	dc.l	LFB5C
	dc.b	0,$E0
	dc.l	LFB64
	dc.b	0
	dc.b	'@'
	dc.l	LFB6A
;
L184A4:	dc.l	L10B0C
	dc.l	L10B22
	dc.l	L10B32
	dc.l	L10B3E
	dc.l	L10B56
	dc.l	L10B68
	dc.l	L10B7A
	dc.l	L10B8C
	dc.l	L10B9E
	dc.l	L10BB0
	dc.l	L10BC2
	dc.l	L10BD4
	dc.l	L10BE6
	dc.l	L10BF8
	dc.l	L10C0A
	dc.l	L10C1C
	dc.l	L10C2E
	dc.l	L10C40
	dc.l	L10C52
	dc.l	L10C64
	dc.l	L10C76
	dc.l	L10C88
	dc.l	L10CA0
	dc.l	L10CB8
	dc.l	L10CCA
	dc.l	L10CDC
	dc.l	L10CF4
	dc.l	L10D06
	dc.l	L10D18
	dc.l	L10D2A
	dc.l	L10D3C
	dc.l	L10D4E
	dc.l	L10D66
	dc.l	L10D78
	dc.l	L10D8A
	dc.l	L10D9C
	dc.l	L10DAE
	dc.l	L10DC0
	dc.l	L10DD2
	dc.l	L10DE4
;
L18544:	dc.l	L10F22
	dc.l	L10F5C
	dc.l	L10F86
	dc.l	L10F9E
	dc.l	L10FE0
	dc.l	L11016
	dc.l	L11042
	dc.l	L1106E
	dc.l	L1109E
	dc.l	L110D2
	dc.l	L110FC
	dc.l	L1112C
	dc.l	L11170
	dc.l	L1119C
	dc.l	L111C8
	dc.l	L111E2
	dc.l	L111FA
	dc.l	L11226
	dc.l	L11254
	dc.l	L11282
	dc.l	L112AE
	dc.l	L112DC
	dc.l	L11374
	dc.l	L113DE
	dc.l	L11404
	dc.l	L11480
	dc.l	L114E6
	dc.l	L11578
	dc.l	L11652
	dc.l	L11676
	dc.l	L1168E
	dc.l	L116B0
	dc.l	L116E8
	dc.l	L116F8
	dc.l	L11718
	dc.l	L11746
	dc.l	L1179C
	dc.l	L11802
	dc.l	L11894
	dc.l	L1196E
	dc.l	L119C8
	dc.l	L119D0
	dc.l	L11A02
	dc.l	L11A1E
	dc.l	L11A34
	dc.l	L119C8
	dc.l	L11AE8
	dc.l	L11AFE
	dc.l	L11B60
	dc.l	L11BF2
	dc.l	L11C42
	dc.l	L11C62
	dc.l	L11D1C
	dc.l	L11C82
	dc.l	L11DB8
	dc.l	L11DDE
	dc.l	L11E28
	dc.l	L11C1A
	dc.l	L11E12
	dc.l	L11F06
	dc.l	L11FAE
	dc.l	L11FAE
	dc.l	L11F4C
;
L18640:	dc.b	0,$10
L18642:	dc.b	0,3
	dc.l	L137FC
	dc.b	0,$1B
	dc.l	L137FC
	dc.b	0
	dc.b	'd'
	dc.l	L137B4
	dc.b	0
	dc.b	'n'
	dc.l	L137AA
	dc.b	0
	dc.b	'q'
	dc.l	L137FC
	dc.b	0
	dc.b	'y'
	dc.l	L136E2
	dc.b	0,3
	dc.l	L1368A
;
L1866C:	dc.l	L14EB6
	dc.l	L14ECA
	dc.l	L14EE2
	dc.l	L14EF2
	dc.l	L14F12
	dc.l	L14F24
;
L18684:	dc.b	0
	dc.b	'-'
	dc.l	L1673A
	dc.b	0
	dc.b	'.'
	dc.l	L167CA
	dc.b	0
	dc.b	'0'
	dc.l	L16742
	dc.b	0
	dc.b	'1'
	dc.l	L1674A
	dc.b	0
	dc.b	'2'
	dc.l	L1674A
	dc.b	0
	dc.b	'3'
	dc.l	L1674A
	dc.b	0
	dc.b	'4'
	dc.l	L1674A
	dc.b	0
	dc.b	'5'
	dc.l	L1674A
	dc.b	0
	dc.b	'6'
	dc.l	L1674A
	dc.b	0
	dc.b	'7'
	dc.l	L1674A
	dc.b	0
	dc.b	'8'
	dc.l	L1674A
	dc.b	0
	dc.b	'9'
	dc.l	L1674A
	dc.b	0
	dc.b	'D'
	dc.l	L167B6
	dc.b	0
	dc.b	'H'
	dc.l	L167B6
	dc.b	0
	dc.b	'S'
	dc.l	L167B6
	dc.b	0
	dc.b	'T'
	dc.l	L167B6
	dc.b	0
	dc.b	'c'
	dc.l	L167B6
	dc.b	0
	dc.b	'd'
	dc.l	L167B6
	dc.b	0
	dc.b	'l'
	dc.l	L167C0
	dc.b	0
	dc.b	'o'
	dc.l	L167B6
	dc.b	0
	dc.b	's'
	dc.l	L167B6
	dc.b	0
	dc.b	'u'
	dc.l	L167B6
	dc.b	0
	dc.b	'x'
	dc.l	L167B6
	dc.b	0
	dc.b	'-'
	dc.l	L167B6
;
L18714:	dc.b	0
	dc.b	'D'
	dc.l	L16898
	dc.b	0
	dc.b	'H'
	dc.l	L16898
	dc.b	0
	dc.b	'S'
	dc.l	L168F0
	dc.b	0
	dc.b	'T'
	dc.l	L16898
	dc.b	0
	dc.b	'c'
	dc.l	L16806
	dc.b	0
	dc.b	'd'
	dc.l	L1681C
	dc.b	0
	dc.b	'o'
	dc.l	L168A8
	dc.b	0
	dc.b	's'
	dc.l	L1692E
	dc.b	0
	dc.b	'u'
	dc.l	L168CA
	dc.b	0
	dc.b	'x'
	dc.l	L168DA
	dc.b	0
	dc.b	'D'
	dc.l	L16938
;
L18756:	dc.b	1
	dc.b	','
	dc.l	L1754E
	dc.b	4,$B0
	dc.l	L17558
	dc.b	9
	dc.b	'`'
	dc.l	L17562
;
	dc.b	'%'
	dc.b	$80
	dc.l	L1756C
	dc.b	1
	dc.b	','
	dc.l	L17576
;
L18774:	dc.l	L1772C
	dc.l	L17754
	dc.l	L1769C
;
L18780:	dc.l	L1796A
	dc.l	L17888
	dc.l	L17926
	dc.l	L17936
	dc.l	L1794E
	dc.l	L17898
	dc.l	L1793E
	dc.l	L17946
	dc.l	L1792E
	dc.l	L178A8
	dc.l	L178B8
	dc.l	L178D8
	dc.l	L17962
	dc.l	L178C8
	dc.l	L1796A
	dc.l	L178E2
	dc.l	L178FA
	dc.l	L17910
;
L187C8:	dc.b	'NullProc'
	dc.b	$0
L187D1:	dc.b	'Bootup',NUL
L187D8:	dc.b	0
	dc.b	'C'
L187DA:	dc.b	0,$83
L187DC:	dc.b	0,$A3
L187DE:	dc.b	0,$E3,1
	dc.b	','
	dc.b	$4,$B0,9
	dc.b	'`%'
	dc.b	$80
L187E8:	dc.b	0,1,0,2,0,4,0,8,0,$10,0
	dc.b	' '
	dc.b	$0
	dc.b	'@'
	dc.b	$0,$80,1,0,2,0,4,0,8,0,$10,0
	dc.b	' '
	dc.b	$0
	dc.b	'@'
	dc.b	$0,$80,0
;
L18808:	dc.l	L1896A
	dc.l	L18977
	dc.l	L18982
	dc.l	L1898D
	dc.l	L18993
	dc.l	L18999
;
L18820:	dc.l	L189A2
	dc.l	L189A7
	dc.l	L189AF
	dc.l	L189C1
	dc.l	L189CA
	dc.l	L189CE
;
L18838:	dc.l	L189D4
	dc.l	L189E6
	dc.l	L189F0
	dc.l	L189FD
	dc.l	L18A05
;
L1884C:	dc.l	L18A15
;
L18850:	dc.l	L18A1B
;
L18854:	dc.l	L18A22
;
L18858:	dc.l	L18A2D
	dc.l	L18A37
;
L18860:	dc.l	L18A3E
;
L18864:	dc.l	L18A61
;
L18868:	dc.l	L18A84
;
L1886C:	dc.l	L18AA7
;
L18870:	dc.l	L18ACA
;
L18874:	dc.l	L18AED
	dc.l	L18AFA
	dc.l	L18B07
	dc.l	L18B14
	dc.l	L18B21
	dc.l	L18B2E
	dc.l	L18B3B
	dc.l	L18B48
	dc.l	L18B55
	dc.l	L18B62
	dc.l	L18B6F
	dc.l	L18B7C
	dc.l	L18B89
	dc.l	L18B96
	dc.l	L18BA3
;
L188B0:	dc.b	$A
	dc.b	'MichTron Multi-User BBS.     Version 3.0 By Timothy Purves.'
	dc.b	$A
	dc.b	'Copyright (c) MichTron Inc. 1985-1989. All rights reserved.'
	dc.b	$A,$A,0,0
;
L1892C:	dc.l	L18BB0
;
L18930:	dc.b	'<FILE-STAMP>'
	dc.b	$0,0
;
L1893E:	dc.l	L18BBB
;
L18942:	dc.b	0,1
;
L18944:	dc.l	L18BE6
	dc.l	L18BEE
	dc.l	L18BF6
	dc.l	L18BFE
	dc.l	L18C06
	dc.l	L18C0E
	dc.l	L18C16
	dc.l	L18C1E
;
L18964:	dc.b	0,1
L18966:	dc.b	0,0
L18968:	dc.b	'q'
	dc.b	$C5
L1896A:	dc.b	'Unregistered'
	dc.b	$0
L18977:	dc.b	'Registered'
	dc.b	$0
L18982:	dc.b	'Asst Sysop'
	dc.b	$0
L1898D:	dc.b	'Sysop'
	dc.b	$0
L18993:	dc.b	'Wizop'
	dc.b	$0
L18999:	dc.b	'MichTron'
	dc.b	$0
L189A2:	dc.b	'Open'
	dc.b	$0
L189A7:	dc.b	'Private'
	dc.b	$0
L189AF:	dc.b	'Private to Sysop'
	dc.b	$7,0
L189C1:	dc.b	'Deleted'
	dc.b	$7,0
L189CA:	dc.b	'All'
	dc.b	$0
L189CE:	dc.b	'Freed'
	dc.b	$0
L189D4:	dc.b	'Normal Completion'
	dc.b	$0
L189E6:	dc.b	'ABORTED'
	dc.b	$7
	dc.b	'!'
	dc.b	$0
L189F0:	dc.b	'Lost Carrier'
	dc.b	$0
L189FD:	dc.b	'Timeout'
	dc.b	$0
L18A05:	dc.b	'Disk Space Full'
	dc.b	$0
L18A15:	dc.b	'ASCII'
	dc.b	$0
L18A1B:	dc.b	'XMODEM'
	dc.b	$0
L18A22:	dc.b	'XMODEM-CRC'
	dc.b	$0
L18A2D:	dc.b	'XMODEM-1K'
	dc.b	$0
L18A37:	dc.b	'YMODEM'
	dc.b	$0
L18A3E:	dc.b	'x:\bbs\userlog.bbs'
	dc.b	$0
	dc.b	'---------------'
	dc.b	$0
L18A61:	dc.b	'x:\bbs\mail.bbs'
	dc.b	$0
	dc.b	'------------------'
	dc.b	$0
L18A84:	dc.b	'x:\bbs\lastcall.bbs'
	dc.b	$0
	dc.b	'--------------'
	dc.b	$0
L18AA7:	dc.b	'x:\bbs\activity.bbs'
	dc.b	$0
	dc.b	'--------------'
	dc.b	$0
L18ACA:	dc.b	'x:\bbs\download.bbs'
	dc.b	$0
	dc.b	'--------------'
	dc.b	$0
L18AED:	dc.b	'-----CONSOLE'
	dc.b	$0
L18AFA:	dc.b	'-----MODEM 1'
	dc.b	$0
L18B07:	dc.b	'-----MODEM 2'
	dc.b	$0
L18B14:	dc.b	'-----MODEM 3'
	dc.b	$0
L18B21:	dc.b	'-----MODEM 4'
	dc.b	$0
L18B2E:	dc.b	'----ACTIVITY'
	dc.b	$0
L18B3B:	dc.b	'-----UPLOADS'
	dc.b	$0
L18B48:	dc.b	'---DOWNLOADS'
	dc.b	$0
L18B55:	dc.b	'-LASTCALLERS'
	dc.b	$0
L18B62:	dc.b	'--------MAIL'
	dc.b	$0
L18B6F:	dc.b	'-------TASKS'
	dc.b	$0
L18B7C:	dc.b	'---PROFILE 1'
	dc.b	$0
L18B89:	dc.b	'---PROFILE 2'
	dc.b	$0
L18B96:	dc.b	'---PROFILE 3'
	dc.b	$0
L18BA3:	dc.b	'---PROFILE 4'
	dc.b	$0
L18BB0:	dc.b	'No file(s)'
	dc.b	$0
L18BBB:	dc.b	$A,$A
	dc.b	'Please Switch to YMODEM BATCH receive'
	dc.b	$7,$A,$A,0
L18BE6:	dc.b	'       '
	dc.b	$0
L18BEE:	dc.b	'Current'
	dc.b	$0
L18BF6:	dc.b	'Free   '
	dc.b	$0
L18BFE:	dc.b	'Ready  '
	dc.b	$0
L18C06:	dc.b	'Receive'
	dc.b	$0
L18C0E:	dc.b	'Asleep '
	dc.b	$0
L18C16:	dc.b	'Suspend'
	dc.b	$0
L18C1E:	dc.b	'Waiting'
	dc.b	$0
L18C26:	dc.b	$B,$A
	dc.b	'%d Task(s) active'
	dc.b	$A,$A
	dc.b	'Name            Status  Prio Sema Msg  Rec  LowStack HiStack  Stack    Free'
	dc.b	$A,0
L18C88:	dc.b	'%-16.16s%s %04x %04x %04x %04x %08lx %08lx %08lx %08lx'
	dc.b	$A,0
L18CC0:	dc.b	'config.bbs'
	dc.b	$0
L18CCB:	dc.b	$A
	dc.b	'CONFIG.BBS was not found'
	dc.b	$0
L18CE5:	dc.b	$A
	dc.b	'CONFIG.BBS was the wrong version'
	dc.b	$0
L18D07:	dc.b	'Task Disabled'
	dc.b	$0
L18D15:	dc.b	$A
	dc.b	'Checking files and directories'
	dc.b	$A,0
L18D36:	dc.b	'File Creation ERROR'
	dc.b	$7,$A
	dc.b	'Program will now terminate.'
	dc.b	$A,0
L18D68:	dc.b	$A
	dc.b	'Checks complete'
	dc.b	$A,$A,0
L18D7B:	dc.b	'Multi-Tasker'
	dc.b	$0
L18D88:	dc.b	'Console'
	dc.b	$0
L18D90:	dc.b	$A,$A
	dc.b	'No modem attached to port %d'
	dc.b	$0
L18DAF:	dc.b	'Modem %d'
	dc.b	$0
L18DB8:	dc.b	'BBS Status'
	dc.b	$0
L18DC3:	dc.b	'%s [%c] %-20.20s%-15.15s %-20.20s %H/%H'
	dc.b	$0
L18DEB:	dc.b	'Console'
	dc.b	$0
L18DF3:	dc.b	'Modem 1'
	dc.b	$0
L18DFB:	dc.b	'Modem 2'
	dc.b	$0
L18E03:	dc.b	'Modem 3'
	dc.b	$0
L18E0B:	dc.b	'Modem 4'
	dc.b	$0
L18E13:	dc.b	'Modem 5'
	dc.b	$0
L18E1B:	dc.b	'Modem 6'
	dc.b	$0
L18E23:	dc.b	'Modem 7'
	dc.b	$0
L18E2B:	dc.b	'Modem 8'
	dc.b	$0
L18E33:	dc.b	'System startup'
	dc.b	$0
L18E42:	dc.b	'<None>'
	dc.b	$0
L18E49:	dc.b	'Task terminated'
	dc.b	$0
L18E59:	dc.b	'Error opening file %s, port %d'
	dc.b	$A,0
L18E79:	dc.b	$A
	dc.b	'Critical error opening file %s'
	dc.b	$0
L18E99:	dc.b	$A
	dc.b	'Attempting recovery'
	dc.b	$A,$A,0
L18EB0:	dc.b	'main'
	dc.b	$0
L18EB5:	dc.b	$A
	dc.b	'Load of MAIN.MCL failed'
	dc.b	$0
L18ECE:	dc.b	', Wizop detected entering SysopShell'
	dc.b	$0
L18EF3:	dc.b	', Sorry but you will now be disconnected!'
	dc.b	$0
L18F1D:	dc.b	'Sig change'
	dc.b	$0
L18F28:	dc.b	$A
	dc.b	'Enter Sig selection [RETURN for list, [ESC] for no change]: '
	dc.b	$0
L18F66:	dc.b	$A
	dc.b	'Invalid Sig selection'
	dc.b	$A,0
L18F7E:	dc.b	7,$A
	dc.b	'Sorry, you'
	dc.b	$27
	dc.b	're not cleared for Sig %d'
	dc.b	$A,0
L18FA6:	dc.b	$A,$A
	dc.b	'[*] = Cleared Sigs  [D] = Your default'
	dc.b	$A,$A,0
L18FD1:	dc.b	'%2d [%c] %-31s %s'
	dc.b	$0
L18FE3:	dc.b	'Not assigned'
	dc.b	$0
L18FF0:	dc.b	$A,0
L18FF2:	dc.b	0
L18FF3:	dc.b	$A
	dc.b	'The Sysop is being paged. He will break in, if he can chat.'
	dc.b	$A,0
L19031:	dc.b	$A
	dc.b	'The Sysop is not able to Chat right now.'
	dc.b	$A,0
L1905C:	dc.b	'Rooms'
	dc.b	$0
L19062:	dc.b	$A
	dc.b	'Room User'
	dc.b	$0
L1906D:	dc.b	$A
	dc.b	'==== ===================='
	dc.b	$0
L19088:	dc.b	$A
	dc.b	'%4d %s'
	dc.b	$0
L19090:	dc.b	$A,$A
	dc.b	'Enter which room 1 to 4 [1] : '
	dc.b	$0
L190B1:	dc.b	$A,$A
	dc.b	'Entering room %d, press [ESC] to exit'
	dc.b	$A,0
L190DA:	dc.b	$A
	dc.b	'%d>'
	dc.b	$0
L190DF:	dc.b	'Has Left'
	dc.b	$0
L190E8:	dc.b	'Is here'
	dc.b	$0
L190F0:	dc.b	'/NOTIFY'
	dc.b	$0
L190F8:	dc.b	'/WHO'
	dc.b	$0
L190FD:	dc.b	$A
	dc.b	'[%s] %s'
	dc.b	$A,0
	dc.b	'lots a space'
	dc.b	$0
L19114:	dc.b	'Notify'
	dc.b	$0
L1911B:	dc.b	$A
	dc.b	'Notify: User on which modem (0=console to %d) : '
	dc.b	$0
L1914D:	dc.b	7,$A,$A
	dc.b	'You can'
	dc.b	$27
	dc.b	't notify yourself!'
	dc.b	$0
L1916B:	dc.b	7,$A,$A
	dc.b	'You have already notified modem %d.'
	dc.b	$0
L19192:	dc.b	7,$A,$A
	dc.b	'There is no user on modem %d.'
	dc.b	$0
L191B3:	dc.b	$A
	dc.b	'Notify: '
	dc.b	$0
L191BD:	dc.b	'[%s] %s'
	dc.b	$0,0
L191C6:	dc.b	0,0,0,$1F,0,$1C,0,$1F,0,$1E,0,$1F,0,$1E,0,$1F
	dc.b	0,$1F,0,$1E,0,$1F,0,$1E,0,$1F,0,0,0,$1F,0,$1D
	dc.b	0,$1F,0,$1E,0,$1F,0,$1E,0,$1F,0,$1F,0,$1E,0,$1F
	dc.b	0,$1E,0,$1F
;
L191FA:	dc.l	L19332
	dc.l	L19339
	dc.l	L19340
	dc.l	L19348
	dc.l	L19352
	dc.l	L1935B
	dc.l	L19362
;
L19216:	dc.l	L1936B
	dc.l	L1936C
	dc.l	L19374
	dc.l	L1937D
	dc.l	L19383
	dc.l	L19389
	dc.l	L1938D
	dc.l	L19392
	dc.l	L19397
	dc.l	L1939E
	dc.l	L193A8
	dc.l	L193B0
	dc.l	L193B9
;
L1924A:	dc.b	$A,$A
	dc.b	'** NOTICES **'
	dc.b	$7,0
L1925B:	dc.b	$A
	dc.b	'%-.79s'
	dc.b	$0
L19263:	dc.b	$A,7,0
L19266:	dc.b	$A,$A
	dc.b	'[Time Left %H] %d. %s %s'
	dc.b	$A,0
L19282:	dc.b	'Command ? '
	dc.b	$0
L1928D:	dc.b	0
L1928E:	dc.b	' '
	dc.b	$0
L19290:	dc.b	'%s (Y,N,Q) [%c] ? '
	dc.b	$0
L192A3:	dc.b	'NYQ'
	dc.b	$D,0
L192A8:	dc.b	'No'
	dc.b	$0
L192AB:	dc.b	'Yes'
	dc.b	$0
L192AF:	dc.b	'Quit'
	dc.b	$0
L192B4:	dc.b	'Quit'
	dc.b	$0
L192B9:	dc.b	'Yes'
	dc.b	$0
L192BD:	dc.b	'No'
	dc.b	$0
L192C0:	dc.b	'%ld'
	dc.b	$0
L192C4:	dc.b	$A,$A
	dc.b	'Warning: You are almost out of time!'
	dc.b	$A,$A,7,0
L192EE:	dc.b	$A,$A
	dc.b	"Sorry, you've run out of time for today!"
	dc.b	$0
L19319:	dc.b	$A
	dc.b	'Logging off %s...'
	dc.b	$A,$A,0
L1932E:	dc.b	'%T '
	dc.b	$0
L19332:	dc.b	'Sunday'
	dc.b	$0
L19339:	dc.b	'Monday'
	dc.b	$0
L19340:	dc.b	'Tuesday'
	dc.b	$0
L19348:	dc.b	'Wednesday'
	dc.b	$0
L19352:	dc.b	'Thursday'
	dc.b	$0
L1935B:	dc.b	'Friday'
	dc.b	$0
L19362:	dc.b	'Saturday'
	dc.b	$0
L1936B:	dc.b	0
L1936C:	dc.b	'January'
	dc.b	$0
L19374:	dc.b	'February'
	dc.b	$0
L1937D:	dc.b	'March'
	dc.b	$0
L19383:	dc.b	'April'
	dc.b	$0
L19389:	dc.b	'May'
	dc.b	$0
L1938D:	dc.b	'June'
	dc.b	$0
L19392:	dc.b	'July'
	dc.b	$0
L19397:	dc.b	'August'
	dc.b	$0
L1939E:	dc.b	'September'
	dc.b	$0
L193A8:	dc.b	'October'
	dc.b	$0
L193B0:	dc.b	'November'
	dc.b	$0
L193B9:	dc.b	'December'
	dc.b	$0
L193C2:	dc.b	'%s, %s %d, %d '
	dc.b	$0
L193D1:	dc.b	'%D '
	dc.b	$0
L193D5:	dc.b	'%s'
	dc.b	$0
L193D8:	dc.b	$A
	dc.b	'Show by [N]ame [D]ate [T]ime: [N] '
	dc.b	$0
L193FC:	dc.b	'ndt'
	dc.b	$D,$1B,3,0
L19403:	dc.b	'Name'
	dc.b	$0
L19408:	dc.b	'Date'
	dc.b	$0
L1940D:	dc.b	'Time'
	dc.b	$0
L19412:	dc.b	$A,$A
	dc.b	'Directory of %s'
	dc.b	$A
	dc.b	'Filename      size    date   time'
	dc.b	$A,0
L19447:	dc.b	$D
	dc.b	'Press any key '
	dc.b	$0
L19457:	dc.b	'%-12s '
	dc.b	$0
L1945E:	dc.b	'<DIR>  '
	dc.b	$0
L19466:	dc.b	'%5dk '
	dc.b	$0
L1946C:	dc.b	'-empty-'
	dc.b	$0
L19474:	dc.b	'%D %T'
	dc.b	$A,0
L1947B:	dc.b	$A
	dc.b	'%d file(s) listed'
	dc.b	$0
L1948E:	dc.b	$A
	dc.b	'%s'
	dc.b	$0
L19492:	dc.b	0
L19493:	dc.b	'%-20s%D %T: '
	dc.b	$0
L194A0:	dc.b	'%s'
	dc.b	$0
L194A3:	dc.b	0
L194A4:	dc.b	'LOGFILE ERROR: %s during %s'
	dc.b	$A,0
L194C1:	dc.b	'Write'
	dc.b	$0
L194C7:	dc.b	'Create'
	dc.b	$0
L194CE:	dc.b	'Chat%02d.txt'
	dc.b	$0
L194DB:	dc.b	$A,$A
	dc.b	'Sysop has moved you into chat'
	dc.b	$7,0
L194FC:	dc.b	$A,$A
	dc.b	'Sysop has answered your chat request'
	dc.b	$7,0
L19524:	dc.b	$A
	dc.b	'Press [ESC] to end chat'
	dc.b	$A,$A,0
L1953F:	dc.b	'%s'
	dc.b	$A,0
L19543:	dc.b	$A,0
L19545:	dc.b	'/record'
	dc.b	$0
L1954D:	dc.b	$A,$A
	dc.b	'** Recording of chat with %s on %D at %T **'
	dc.b	$A,$A,0
L1957D:	dc.b	$A,0
L1957F:	dc.b	$A
	dc.b	'Show %s in which Sig(s) (? for list) [1-%d] : '
	dc.b	$0
L195AF:	dc.b	$A
	dc.b	'You have not selected any Sigs to which you have access'
	dc.b	$7,0,0
L195EA:	dc.b	$A,$A,7
	dc.b	'You have been idle for too long - Please respond or you will be logged off.'
	dc.b	$7,$A,$A,0
L1963C:	dc.b	$A,$A,7
	dc.b	'%s logged off for inactivity'
	dc.b	$A,$A,0
L1965E:	dc.b	0,0
L19660:	dc.b	' System will terminate when all ports are idle '
	dc.b	$0
L19690:	dc.b	' Chat disabled '
	dc.b	$0
L196A0:	dc.b	' Chat answered '
	dc.b	$0
L196B0:	dc.b	' Chat forced   '
	dc.b	$0
L196C0:	dc.b	' Chat enabled  '
	dc.b	$0
L196D0:	dc.b	'CRT Manager'
	dc.b	$0
;
L196DC:	dc.l	L1970A
;
L196E0:	dc.l	L19737
;
L196E4:	dc.l	L1974F
;
L196E8:	dc.l	L1978A
;
L196EC:	dc.l	L1520C
	dc.l	L1582A
	dc.l	L15928
	dc.l	L15A28
	dc.l	L157B4
;
L19700:	dc.b	0,1,0,$80,0,$80,0,$80,0,$80
L1970A:	dc.b	$A,$A
	dc.b	'Please Enter up to 5 lines of description'
	dc.b	$A,0
L19737:	dc.b	$A
	dc.b	'Last download read: %u'
	dc.b	$0
L1974F:	dc.b	$A
	dc.b	'Downloads range from 1 to %u.'
	dc.b	$A
	dc.b	'Start at what number? [%u] '
	dc.b	$0
L1978A:	dc.b	$A
	dc.b	'%s in the download'
	dc.b	$0
L1979E:	dc.b	$A,$A,$A
	dc.b	'File    : %s'
	dc.b	$0
L197AE:	dc.b	$A
	dc.b	'Size    : %uK bytes'
	dc.b	$0
L197C3:	dc.b	$A
	dc.b	'Blocks  : %ld'
	dc.b	$0
L197D2:	dc.b	$A
	dc.b	'Time    : %d minute(s)'
	dc.b	$0
L197EA:	dc.b	$A
	dc.b	'Protocol: %s'
	dc.b	$0
L197F8:	dc.b	$A,$A
	dc.b	'Please start your transfer now'
	dc.b	$A,$A,0
L1981B:	dc.b	$A,$A
	dc.b	'Please go to %s'
	dc.b	$A
	dc.b	'to transmit %s'
	dc.b	$A,$A,0
L1983E:	dc.b	$A,$A
	dc.b	'Press [SPACE]'
	dc.b	$0
L1984E:	dc.b	$D
	dc.b	'%s: %s'
	dc.b	$A,0
L19857:	dc.b	$A
	dc.b	'Transfer protocol:'
	dc.b	$A
	dc.b	'[A]scii [X]modem Xmodem-[C]RC Xmodem-1[K] %s[Q]uit '
	dc.b	$0
L1989F:	dc.b	'[Y]modem '
	dc.b	$0
L198A9:	dc.b	0
L198AA:	dc.b	'AXCKY'
	dc.b	$0
L198B0:	dc.b	3,$1B
	dc.b	'axckyq'
	dc.b	$0
L198B9:	dc.b	3,$1B
	dc.b	'axckq'
	dc.b	$0
L198C1:	dc.b	'Quit'
	dc.b	$0
L198C6:	dc.b	'Upload files'
	dc.b	$0
L198D3:	dc.b	$A
	dc.b	'Enter Sig for upload: '
	dc.b	$0
L198EB:	dc.b	$A
	dc.b	'Invalid Sig Selection'
	dc.b	$7,0
L19903:	dc.b	$A
	dc.b	'You don'
	dc.b	$27
	dc.b	't have access the %s Sig'
	dc.b	$7,0
L19926:	dc.b	$A
	dc.b	'%s Sig does not have an upload area'
	dc.b	$7,0
L1994C:	dc.b	$A
	dc.b	'Filename for upload: '
	dc.b	$0
L19963:	dc.b	7,$A
	dc.b	'That filename already in use!'
	dc.b	$A,0
L19984:	dc.b	7,$A
	dc.b	'Illegal filename! %s'
	dc.b	$A,0
L1999C:	dc.b	'%s UPLOAD User: %-20s %s'
	dc.b	$A
	dc.b	'Desc: %s'
	dc.b	$A,$A,0
L199C0:	dc.b	'GOOD'
	dc.b	$0
L199C5:	dc.b	'BAD '
	dc.b	$0
L199CA:	dc.b	'was deleted'
	dc.b	$0
L199D6:	dc.b	$A
	dc.b	'User: %-20s %s'
	dc.b	$A
	dc.b	'Desc: %s'
	dc.b	$0
L199EF:	dc.b	'Thanks for the upload %s'
	dc.b	$A,0
L19A09:	dc.b	'Upload files [MCL]'
	dc.b	$0
L19A1C:	dc.b	$A
	dc.b	'Filename for upload: '
	dc.b	$0
L19A33:	dc.b	7,$A
	dc.b	'That filename already in use!'
	dc.b	$A,0
L19A54:	dc.b	7,$A
	dc.b	'Illegal filename! %s'
	dc.b	$A,0
L19A6C:	dc.b	'%s MCL UPLOAD User: %-20s %s'
	dc.b	$A
	dc.b	'Desc: %s'
	dc.b	$A,$A,0
L19A94:	dc.b	'GOOD'
	dc.b	$0
L19A99:	dc.b	'BAD '
	dc.b	$0
L19A9E:	dc.b	'was deleted'
	dc.b	$0
L19AAA:	dc.b	'From MCL'
	dc.b	$0
L19AB3:	dc.b	$A
	dc.b	'User: %-20s %s'
	dc.b	$A
	dc.b	'From MCL'
	dc.b	$0
L19ACC:	dc.b	"You don't have enough time to download this file"
	dc.b	$7,0
L19AFE:	dc.b	'Download files'
	dc.b	$0
L19B0D:	dc.b	$A
	dc.b	'File to download: '
	dc.b	$0
L19B21:	dc.b	$A
	dc.b	'Cannot locate %s to download'
	dc.b	$A,0
L19B40:	dc.b	$A,$A
	dc.b	'%s'
	dc.b	$0
L19B45:	dc.b	'%s DOWNLOAD User: %-20s %s'
	dc.b	$A,0
L19B61:	dc.b	'GOOD'
	dc.b	$0
L19B66:	dc.b	'BAD '
	dc.b	$0
L19B6B:	dc.b	$A
	dc.b	'User: %-20s %s'
	dc.b	$0
L19B7B:	dc.b	'Error writing to \BBS\DOWNLOAD.BBS'
	dc.b	$A,0
L19B9F:	dc.b	$A
	dc.b	'%c%c%5u %-12s %9ld %5u %D %-.30s'
	dc.b	$0
L19BC1:	dc.b	$A,$A
	dc.b	'File       : %u %s %ld bytes %D %T %s %s'
	dc.b	$0
L19BEC:	dc.b	'[Hidden]'
	dc.b	$0
L19BF5:	dc.b	0
L19BF6:	dc.b	'Batch-Marked'
	dc.b	$0
L19C03:	dc.b	0
L19C04:	dc.b	$A
	dc.b	'Uploader   : %s'
	dc.b	$0
L19C15:	dc.b	$A
	dc.b	'Sig(s)     : '
	dc.b	$0
L19C24:	dc.b	'Downloaded : %d time(s)'
	dc.b	$A,0
L19C3D:	dc.b	'Level      : %s'
	dc.b	$A,0
L19C4E:	dc.b	'Description:'
	dc.b	$A,0
L19C5C:	dc.b	$A
	dc.b	'%s'
	dc.b	$0
L19C60:	dc.b	'        .   '
	dc.b	$0
L19C6D:	dc.b	'ARC'
	dc.b	$0
L19C71:	dc.b	$A
	dc.b	'Search mask: [*.*] '
	dc.b	$0
L19C86:	dc.b	'*.*'
	dc.b	$0
L19C8A:	dc.b	'files'
	dc.b	$0
L19C90:	dc.b	$A,$A
	dc.b	'Showing files in Sig(s) '
	dc.b	$0
L19CAB:	dc.b	$A
	dc.b	'Show files in short form'
	dc.b	$0
L19CC5:	dc.b	$A
	dc.b	'Pause between files'
	dc.b	$0
L19CDA:	dc.b	'Download listing'
	dc.b	$0
L19CEB:	dc.b	'+'
	dc.b	$8
	dc.b	' '
	dc.b	$8,0
L19CF0:	dc.b	$A,$A
	dc.b	'[P]rev [N]ext [B]atch-%sark '
	dc.b	$0
L19D0F:	dc.b	'M'
	dc.b	$0
L19D11:	dc.b	'Unm'
	dc.b	$0
L19D15:	dc.b	'[A]rclisting '
	dc.b	$0
L19D23:	dc.b	'[Z]ap [M]ake-%s'
	dc.b	$0
L19D33:	dc.b	'Open '
	dc.b	$0
L19D39:	dc.b	'Hidden '
	dc.b	$0
L19D41:	dc.b	'[S]ig(s) '
	dc.b	$A
	dc.b	'[C]ount-Reset [F]ilename [U]ploader [D]esc [L]evel '
	dc.b	$0
L19D7F:	dc.b	3,$1B,$D
	dc.b	'qpnxab '
	dc.b	$0
L19D8A:	dc.b	3,$1B,$D
	dc.b	'qpnmscudlxazfb '
	dc.b	$0
L19D9D:	dc.b	3,$1B,$D
	dc.b	'dqpnxab '
	dc.b	$0
L19DA9:	dc.b	'[D]esc '
	dc.b	$0
L19DB1:	dc.b	'[X]mit [Q]uit '
	dc.b	$0
L19DC0:	dc.b	'PN'
	dc.b	$D,$D
	dc.b	'MSCUDLXAZF B'
	dc.b	$0
L19DD1:	dc.b	'Quit'
	dc.b	$0
L19DD6:	dc.b	'Previous'
	dc.b	$A,0
L19DE0:	dc.b	'Next'
	dc.b	$A,0
L19DE6:	dc.b	'Make %s'
	dc.b	$A,0
L19DEF:	dc.b	'Open'
	dc.b	$0
L19DF4:	dc.b	'Hidden'
	dc.b	$0
L19DFB:	dc.b	'Sig(s)'
	dc.b	$A
	dc.b	'Enter Sigs: '
	dc.b	$0
L19E0F:	dc.b	'Count-Reset'
	dc.b	$A,0
L19E1C:	dc.b	$A
	dc.b	'Uploader: '
	dc.b	$0
L19E28:	dc.b	$A
	dc.b	'%s'
	dc.b	$0
L19E2C:	dc.b	0
L19E2D:	dc.b	'Level'
	dc.b	$A
	dc.b	'%s'
	dc.b	$0
L19E36:	dc.b	'Xmit'
	dc.b	$A,0
L19E3C:	dc.b	$A
	dc.b	'Is currently disabled'
	dc.b	$0
L19E53:	dc.b	'Arclisting'
	dc.b	$A,0
L19E5F:	dc.b	$A
	dc.b	'Press any key '
	dc.b	$0
L19E6F:	dc.b	'Zap'
	dc.b	$A,$A
	dc.b	'Zap will remove the file from the disk, ZAP it '
	dc.b	$0
L19EA4:	dc.b	$A
	dc.b	'Filename: [%s] '
	dc.b	$0
L19EB5:	dc.b	'Batch'
	dc.b	$A,$A
	dc.b	'Is currently disabled'
	dc.b	$0
L19ED2:	dc.b	'Batch-Mark'
	dc.b	$A,$A,0
L19EDF:	dc.b	'Cannot mark, %d files is the batch mark limit'
	dc.b	$7,$A,0
L19F0F:	dc.b	'File is marked for Batch download'
	dc.b	$7,$A,0
L19F33:	dc.b	'Batch-Unmarked'
	dc.b	$A,0
L19F43:	dc.b	$A,$A
	dc.b	'***** End of downloads *****'
	dc.b	$A,0
L19F63:	dc.b	$A
	dc.b	'Number Filename      Blocks   Time'
	dc.b	$0
L19F87:	dc.b	$A
	dc.b	'====== ============= ======== ====='
	dc.b	$0
L19FAC:	dc.b	$A
	dc.b	' %5u %-13s %8ld %H'
	dc.b	$0
L19FC0:	dc.b	$A,$A
	dc.b	'Batch List'
	dc.b	$0
L19FCD:	dc.b	'Totals'
	dc.b	$0
L19FD4:	dc.b	$A,$A
	dc.b	'%d file(s) marked and ready for batch download'
	dc.b	$0
L1A005:	dc.b	$A
	dc.b	'[Y] to download [N] to continue marking [Q] to abort marking'
	dc.b	$0
L1A043:	dc.b	$A
	dc.b	'User: %-20s %s'
	dc.b	$0
L1A053:	dc.b	'YMODEM DOWNLOAD User: %-20s %s'
	dc.b	$A,0
L1A073:	dc.b	0
L1A074:	dc.b	$A
	dc.b	'Downloading is currently disabled'
	dc.b	$0
L1A097:	dc.b	'Individual download'
	dc.b	$0
L1A0AB:	dc.b	$A,$A
	dc.b	'Downloads range from 1 to %u.'
	dc.b	$A
	dc.b	'Which one : '
	dc.b	$0
L1A0D8:	dc.b	$A,$A
	dc.b	'Number too Large'
	dc.b	$7,0
L1A0EC:	dc.b	$A,$A
	dc.b	'Don'
	dc.b	$27
	dc.b	't have access to file %u'
	dc.b	$7,0
L1A10C:	dc.b	$A,$A
	dc.b	'Download this file'
	dc.b	$0
L1A121:	dc.b	'Cannot locate file # %u, %s'
	dc.b	$A,0
L1A13E:	dc.b	$A,$A
	dc.b	'File #%u, %s Cannot be located'
	dc.b	$A,0
L1A160:	dc.b	'Download catalog'
	dc.b	$0
L1A171:	dc.b	$A
	dc.b	'Search mask: [*.*] '
	dc.b	$0
L1A186:	dc.b	'*.*'
	dc.b	$0
L1A18A:	dc.b	$A
	dc.b	'Packing should be run when no other users are using the download'
	dc.b	$0
L1A1CC:	dc.b	$A
	dc.b	'Continue with Packing '
	dc.b	$0
L1A1E4:	dc.b	$A
	dc.b	'Packing %s'
	dc.b	$A,0
L1A1F1:	dc.b	'.TMP'
	dc.b	$0
L1A1F6:	dc.b	'Cannot create %s'
	dc.b	$A,0
L1A208:	dc.b	$A
	dc.b	'%u files were removed from %s'
	dc.b	$A,0
L1A228:	dc.b	$A
	dc.b	'Disk full Packing %s'
	dc.b	$7,$A,0
L1A240:	dc.b	0,0
L1A242:	dc.b	0,0
L1A244:	dc.b	$A,$A
	dc.b	'Saving....'
	dc.b	$0
L1A251:	dc.b	$A
	dc.b	'Freefat(1): Lastalloc = %d, Limit = %d'
	dc.b	$0
L1A279:	dc.b	$A
	dc.b	'Freefat(2): Lastalloc = %d, Limit = %d'
	dc.b	$0
L1A2A1:	dc.b	$A
	dc.b	'%6u: %-20.20s%-20.20s%s'
	dc.b	$0
L1A2BA:	dc.b	'Message %u saved'
	dc.b	$A,$A,0
L1A2CD:	dc.b	'(None)'
	dc.b	$0
L1A2D4:	dc.b	'%d'
	dc.b	$0
L1A2D7:	dc.b	' (%s)'
	dc.b	$0
L1A2DD:	dc.b	'Multiple'
	dc.b	$0
L1A2E6:	dc.b	'%s'
	dc.b	$A,0
L1A2EA:	dc.b	'MSG%05u.TXT'
	dc.b	$0
L1A2F6:	dc.b	$A
	dc.b	'Create of %s Failed'
	dc.b	$A,0
L1A30C:	dc.b	$A
	dc.b	'%6u: %-20.20s%c%-20.20s%s'
	dc.b	$0
L1A327:	dc.b	$A,$A
	dc.b	'Message : %u [%s] %D %T'
	dc.b	$0
L1A341:	dc.b	$A
	dc.b	'From    : %s'
	dc.b	$0
L1A34F:	dc.b	$A
	dc.b	'To      : %s %s'
	dc.b	$0
L1A360:	dc.b	'(x)'
	dc.b	$0
L1A364:	dc.b	0
L1A365:	dc.b	$A
	dc.b	'Subject : %s'
	dc.b	$0
L1A373:	dc.b	$A
	dc.b	'Sig(s)  : '
	dc.b	$0
L1A37F:	dc.b	'%s'
	dc.b	$A,0
L1A383:	dc.b	'There %s %d repl%s'
	dc.b	$A,0
L1A397:	dc.b	'are'
	dc.b	$0
L1A39B:	dc.b	'is'
	dc.b	$0
L1A39E:	dc.b	'ies'
	dc.b	$0
L1A3A2:	dc.b	'y'
	dc.b	$0
L1A3A4:	dc.b	$A
	dc.b	'%s'
	dc.b	$0
L1A3A8:	dc.b	$A,0
L1A3AA:	dc.b	7,$A,$A
	dc.b	'File -> %s <- (%uK) attached to this message'
	dc.b	$A,0
L1A3DB:	dc.b	$A
	dc.b	'Message saved in file %s'
	dc.b	$A,0
L1A3F6:	dc.b	$A
	dc.b	'***** No messages on file *****'
	dc.b	$A,0
L1A418:	dc.b	$A
	dc.b	'***** No new messages *****'
	dc.b	$A,0
L1A436:	dc.b	$A
	dc.b	'Last message read: %u'
	dc.b	$0
L1A44D:	dc.b	$A
	dc.b	'Messages range from %u to %u.'
	dc.b	$A
	dc.b	'Start at what number? [%u] '
	dc.b	$0
L1A488:	dc.b	'mail'
	dc.b	$0
L1A48D:	dc.b	$A,$A
	dc.b	'Showing mail in Sig(s) '
	dc.b	$0
L1A4A7:	dc.b	$A
	dc.b	'Pause between messages'
	dc.b	$0
L1A4BF:	dc.b	$A
	dc.b	'Pause If letter TO or FROM you'
	dc.b	$0
L1A4DF:	dc.b	$A
	dc.b	'Show only mail addressed to you'
	dc.b	$0
L1A500:	dc.b	$A,$A,0
L1A503:	dc.b	$A
	dc.b	'Messages range from %u to %u.'
	dc.b	$A
	dc.b	'Read message number? '
	dc.b	$0
L1A538:	dc.b	'+'
	dc.b	$8
	dc.b	' '
	dc.b	$8,0
L1A53D:	dc.b	$A,$A
	dc.b	'***** End of messages *****'
	dc.b	$A,0
L1A55C:	dc.b	'Read mail - %u'
	dc.b	$0
L1A56B:	dc.b	$A,$A
	dc.b	'Message has been removed by another user'
	dc.b	$A,0
L1A597:	dc.b	$A
	dc.b	'%s%s[N]ext [J]ump '
	dc.b	$0
L1A5AB:	dc.b	'* '
	dc.b	$0
L1A5AE:	dc.b	0
L1A5AF:	dc.b	'[P]rev '
	dc.b	$0
L1A5B7:	dc.b	0
L1A5B8:	dc.b	'[R]eply '
	dc.b	$0
L1A5C1:	dc.b	'[A]gain '
	dc.b	$0
L1A5CA:	dc.b	'[S]how '
	dc.b	$0
L1A5D2:	dc.b	'[D]elete '
	dc.b	$0
L1A5DC:	dc.b	'[Q]uit '
	dc.b	$0
L1A5E4:	dc.b	$A
	dc.b	'[C]hange [W]rite '
	dc.b	$0
L1A5F7:	dc.b	'[M]ake-%s'
	dc.b	$0
L1A601:	dc.b	'Open '
	dc.b	$0
L1A607:	dc.b	'Private '
	dc.b	$0
L1A610:	dc.b	'[X]mit '
	dc.b	$0
L1A618:	dc.b	$F,$D
	dc.b	' nrasdcopmjx'
	dc.b	$1B,3
	dc.b	'qw'
	dc.b	$0
L1A62B:	dc.b	$A,0
L1A62D:	dc.b	'Next'
	dc.b	$0
L1A632:	dc.b	'Jump to message #: '
	dc.b	$0
L1A646:	dc.b	'%s'
	dc.b	$A
	dc.b	'Message not available'
	dc.b	$7,0
L1A660:	dc.b	'Previous '
	dc.b	$0
L1A66A:	dc.b	0
L1A66B:	dc.b	'Previous'
	dc.b	$0
L1A674:	dc.b	'Reply'
	dc.b	$0
L1A67A:	dc.b	'#%u %s'
	dc.b	$0
L1A681:	dc.b	'Again'
	dc.b	$0
L1A687:	dc.b	'Show'
	dc.b	$0
L1A68C:	dc.b	'Delete'
	dc.b	$0
L1A693:	dc.b	$A
	dc.b	'Are you sure '
	dc.b	$0
L1A6A2:	dc.b	'Change'
	dc.b	$A
	dc.b	'Which SIG(s) [%d]: '
	dc.b	$0
L1A6BD:	dc.b	'Make %s'
	dc.b	$0
L1A6C5:	dc.b	'Open'
	dc.b	$0
L1A6CA:	dc.b	'Private'
	dc.b	$0
L1A6D2:	dc.b	'Write'
	dc.b	$A,0
L1A6D9:	dc.b	'Quit'
	dc.b	$A,$A,0
L1A6E0:	dc.b	$A
	dc.b	'Message is marked for deletion. Delete it'
	dc.b	$0
L1A70B:	dc.b	'Leave mail'
	dc.b	$0
L1A716:	dc.b	'Reply mail'
	dc.b	$0
L1A721:	dc.b	'Leave private mail'
	dc.b	$0
L1A734:	dc.b	'ALL'
	dc.b	$0
L1A738:	dc.b	'NONE'
	dc.b	$0
L1A73D:	dc.b	'Sysop'
	dc.b	$0
L1A743:	dc.b	$A,0
L1A745:	dc.b	$A
	dc.b	'From    : %s'
	dc.b	$0
L1A753:	dc.b	$A
	dc.b	'To      : %s'
	dc.b	$0
L1A761:	dc.b	$A
	dc.b	'To      : '
	dc.b	$0
L1A76D:	dc.b	'To      : %s'
	dc.b	$0
L1A77A:	dc.b	$A
	dc.b	'Subject : '
	dc.b	$0
L1A786:	dc.b	'Subject : %s'
	dc.b	$0
L1A793:	dc.b	$A
	dc.b	'Sig(s)  : '
	dc.b	$0
L1A79F:	dc.b	$A
	dc.b	'Sig %s[%d]: '
	dc.b	$0
L1A7AD:	dc.b	' '
	dc.b	$0
L1A7AF:	dc.b	0
L1A7B0:	dc.b	$A
	dc.b	'Invalid Sig'
	dc.b	$7,0
;L1A7BE:
you_dont_have_access_to_sig_x_1_s:
	dc.b	$A
	dc.b	"You don't have access to Sig %d"
	dc.b	$0
L1A7DF:	dc.b	$A
	dc.b	"You don't have access to any of those Sigs"
	dc.b	$7,0
L1A80C:	dc.b	'Sysop All'
	dc.b	$0
L1A816:	dc.b	'All'
	dc.b	$0
L1A81A:	dc.b	$A,$A
	dc.b	'From    : %s'
	dc.b	$0
L1A829:	dc.b	$A
	dc.b	'To      : %s'
	dc.b	$0
L1A837:	dc.b	$A
	dc.b	'Subject : %s'
	dc.b	$0
L1A845:	dc.b	$A
	dc.b	'Sig     : '
	dc.b	$0
L1A851:	dc.b	$A,$A
	dc.b	'Broadcast message from the Sysop'
	dc.b	$0
L1A874:	dc.b	$A,$A
	dc.b	'Private message to the Sysop'
	dc.b	$0
L1A893:	dc.b	$A,$A
	dc.b	'Private letter'
	dc.b	$0
L1A8A4:	dc.b	$A,$A
	dc.b	'Is this correct '
	dc.b	$0
L1A8B7:	dc.b	$A,0
L1A8B9:	dc.b	$A,7
	dc.b	'Empty messages are not saved'
	dc.b	$0
L1A8D8:	dc.b	'Scan mail'
	dc.b	$0
L1A8E2:	dc.b	'Read mail'
	dc.b	$0
L1A8EC:	dc.b	'Individual mail'
	dc.b	$0
L1A8FC:	dc.b	'New mail'
	dc.b	$0
L1A905:	dc.b	'Leave mail'
	dc.b	$0
L1A910:	dc.b	'to'
	dc.b	$0
L1A913:	dc.b	'subject'
	dc.b	$0
L1A91B:	dc.b	$A
	dc.b	'Registered users only !'
	dc.b	$7,$A,0
L1A936:	dc.b	$A
	dc.b	'Analyzing Mail File...'
	dc.b	$0
L1A94E:	dc.b	'Completed'
	dc.b	$A,0
L1A959:	dc.b	$A
	dc.b	'First   Message is %u'
	dc.b	$0
L1A970:	dc.b	$A
	dc.b	'Highest Message is %u'
	dc.b	$0
L1A987:	dc.b	$A
	dc.b	'%u of %u Blocks used for %u active messages'
	dc.b	$0
L1A9B4:	dc.b	'Mail chart'
	dc.b	$0
L1A9BF:	dc.b	$A
	dc.b	'***** No new messages *****'
	dc.b	$A,0
L1A9DD:	dc.b	$A
	dc.b	'Scanning for mail .'
	dc.b	$0
L1A9F2:	dc.b	'+'
	dc.b	$8
	dc.b	' '
	dc.b	$8,0
L1A9F7:	dc.b	$A
	dc.b	'SIG Area:'
	dc.b	$0
L1AA02:	dc.b	'%4d'
	dc.b	$0
L1AA06:	dc.b	' Total'
	dc.b	$A
	dc.b	'-----------'
	dc.b	$0
L1AA19:	dc.b	'----'
	dc.b	$0
L1AA1E:	dc.b	$A
	dc.b	'New Mail:'
	dc.b	$0
L1AA29:	dc.b	'%4d'
	dc.b	$0
L1AA2D:	dc.b	'%4d'
	dc.b	$A
	dc.b	'To You  :'
	dc.b	$0
L1AA3B:	dc.b	'%4d'
	dc.b	$0
L1AA3F:	dc.b	'%4d'
	dc.b	$A
	dc.b	'To ALL  :'
	dc.b	$0
L1AA4D:	dc.b	'%4d'
	dc.b	$0
L1AA51:	dc.b	'%4d'
	dc.b	$A,$A,0
L1AA57:	dc.b	'Scanning mail-%u'
	dc.b	$0
L1AA68:	dc.b	'all'
	dc.b	$0
L1AA6C:	dc.b	'Force read'
	dc.b	$0,0
L1AA78:	dc.b	$A
	dc.b	'Logged on to %s'
	dc.b	$0
L1AA89:	dc.b	'Logon'
	dc.b	$0
L1AA8F:	dc.b	$A,$A
	dc.b	'Username: '
	dc.b	$0
L1AA9C:	dc.b	$A,0
L1AA9E:	dc.b	$A,$A,$A
	dc.b	'Excessive errors - Connection terminating'
	dc.b	$7,$A,0
L1AACD:	dc.b	'Log off'
	dc.b	$0
L1AAD5:	dc.b	$A,$A
	dc.b	'Would you like to leave a private message for the SysOp '
	dc.b	$0
L1AB10:	dc.b	'sysop'
	dc.b	$0
L1AB16:	dc.b	'private'
	dc.b	$0
L1AB1E:	dc.b	'Hangup'
	dc.b	$0
L1AB25:	dc.b	$A,$A
	dc.b	'Total connect time %H'
	dc.b	$0
L1AB3D:	dc.b	$A
	dc.b	'Thank you for calling the %s'
	dc.b	$A,$A,0
L1AB5D:	dc.b	$A,$A
	dc.b	'Welcome to the %s.'
	dc.b	$A,$A
	dc.b	'%s, %s'
	dc.b	$0
L1AB7A:	dc.b	$A
	dc.b	'%d call(s)'
	dc.b	$A
	dc.b	'Last time was '
	dc.b	$0
L1AB95:	dc.b	'%d day(s) ago '
	dc.b	$0
L1ABA4:	dc.b	'on '
	dc.b	$0
L1ABA8:	dc.b	'at '
	dc.b	$0
L1ABAC:	dc.b	$A
	dc.b	'This is your first call'
	dc.b	$0
L1ABC5:	dc.b	$A,$A
	dc.b	'Your account has %d hour(s) %d minute(s) remaining today.'
	dc.b	$A,0
L1AC02:	dc.b	$A
	dc.b	'No new messages'
	dc.b	$0
L1AC13:	dc.b	$A
	dc.b	'%u new message(s)'
	dc.b	$0
L1AC26:	dc.b	$A
	dc.b	'No new downloads'
	dc.b	$0
L1AC38:	dc.b	$A
	dc.b	'%u new download(s)'
	dc.b	$0
L1AC4C:	dc.b	$A
	dc.b	'Last Caller was: %s'
	dc.b	$A,0
L1AC62:	dc.b	'ASK ON ERROR?'
	dc.b	$0
L1AC70:	dc.b	'Default'
	dc.b	$0
L1AC78:	dc.b	'SHUTDOWN'
	dc.b	$0
L1AC81:	dc.b	$A
	dc.b	'Checking Download folder %s'
	dc.b	$0
L1AC9E:	dc.b	$A
	dc.b	'Checking Upload folder %s'
	dc.b	$0
L1ACB9:	dc.b	$A
	dc.b	'Checking %s, User Log file'
	dc.b	$0
L1ACD5:	dc.b	$A
	dc.b	'Checking %s, Mail Data file'
	dc.b	$0
L1ACF2:	dc.b	$A,0
L1ACF4:	dc.b	$D
	dc.b	'Extending Mail file %d'
	dc.b	$0
L1AD0C:	dc.b	$A,0
L1AD0E:	dc.b	$D
	dc.b	'Creating Mail file %d'
	dc.b	$0
L1AD25:	dc.b	' DISK FULL '
	dc.b	$0
L1AD31:	dc.b	$A
	dc.b	'Checking %s, Last Caller file'
	dc.b	$0
L1AD50:	dc.b	$A
	dc.b	'Checking %s, Download file'
	dc.b	$0
L1AD6C:	dc.b	'x:\BBS'
	dc.b	$0
L1AD73:	dc.b	$A,$A
	dc.b	'ERROR!'
	dc.b	$7
	dc.b	' %s not found create (Y/N) ? '
	dc.b	$0
L1AD9A:	dc.b	'Yes'
	dc.b	$A,$A,0
L1ADA0:	dc.b	'NO!'
	dc.b	$A,$A,0
L1ADA6:	dc.b	'Last callers'
	dc.b	$0
L1ADB3:	dc.b	$A
	dc.b	'No history of last callers'
	dc.b	$A,0
L1ADD0:	dc.b	$A
	dc.b	'History file ranges from %u to %u'
	dc.b	$A
	dc.b	'[RETURN] to see last 20 : '
	dc.b	$0
L1AE0E:	dc.b	$A
	dc.b	'Number  Caller Name           Date      Time     Online'
	dc.b	$0
L1AE47:	dc.b	$A
	dc.b	'======  ====================  ========  =======  ======'
	dc.b	$A,0
L1AE81:	dc.b	'%6u  %-20s  %D  %T  %H'
	dc.b	$A,0
L1AE99:	dc.b	$A
	dc.b	'%-20s %D %T  %H'
	dc.b	$0

L1AEAA:	dc.l	L1AEAE

L1AEAE:	dc.b	'0 = Unregistered, 1 = Registered, 2 = Asst SysOp, 3 = SysOp, 4 = WizOp : '
	dc.b	$0
L1AEF8:	dc.b	'all'
	dc.b	$0
L1AEFC:	dc.b	'new'
	dc.b	$0
L1AF00:	dc.b	$A,7
	dc.b	'Invalid Username'
	dc.b	$A,0
L1AF14:	dc.b	$A
	dc.b	'Password: '
	dc.b	$0
L1AF20:	dc.b	$A,7
	dc.b	'Invalid Password'
	dc.b	$0
L1AF33:	dc.b	'Invalid Logon Attempt: %s'
	dc.b	$A,0
L1AF4E:	dc.b	$A,$A
	dc.b	"Can't locate you in the user log"
	dc.b	$A
	dc.b	'Is %s your name'
	dc.b	$0
L1AF81:	dc.b	$A
	dc.b	'Would you like to register'
	dc.b	$0
L1AF9D:	dc.b	$A,$A
	dc.b	'Ok, but you can only look around'
	dc.b	$A,0
L1AFC1:	dc.b	'New user (just looking) %s'
	dc.b	$A,0
L1AFDD:	dc.b	$A,$A
	dc.b	'What password do you want   : '
	dc.b	$0
L1AFFE:	dc.b	$A
	dc.b	'What is your street address : '
	dc.b	$0
L1B01E:	dc.b	$A
	dc.b	'What city do you live in    : '
	dc.b	$0
L1B03E:	dc.b	$A
	dc.b	'What state do you live in   : '
	dc.b	$0
L1B05E:	dc.b	$A
	dc.b	'What is your zip code       : '
	dc.b	$0
L1B07E:	dc.b	$A
	dc.b	'What is your phone number   : '
	dc.b	$0
L1B09E:	dc.b	'Disk full while expanding userfile (%d)'
	dc.b	$A,0
L1B0C7:	dc.b	$A,$A
	dc.b	"Sorry, I don't have room on the disk to save you"
	dc.b	$0
L1B0FA:	dc.b	'New user registered: %s'
	dc.b	$A,0
L1B113:	dc.b	$C,0
L1B115:	dc.b	$A
	dc.b	' 1. Name:          %s'
	dc.b	$0
L1B12C:	dc.b	$A
	dc.b	' 2. Level:         %s'
	dc.b	$0
L1B143:	dc.b	$A
	dc.b	' 3. Address:       %s'
	dc.b	$0
L1B15A:	dc.b	$A
	dc.b	' 4. City:          %s'
	dc.b	$0
L1B171:	dc.b	$A
	dc.b	' 5. State:         %s'
	dc.b	$0
L1B188:	dc.b	$A
	dc.b	' 6. ZipCode:       %s'
	dc.b	$0
L1B19F:	dc.b	$A
	dc.b	' 7. Phone:         %s'
	dc.b	$0
L1B1B6:	dc.b	$A
	dc.b	' 8. Password:      -> %s <-'
	dc.b	$0
L1B1D3:	dc.b	0
L1B1D4:	dc.b	$A
	dc.b	' 9. Sig(s):        %s'
	dc.b	$0
L1B1EB:	dc.b	$A
	dc.b	'10. TimeAllocated: %H'
	dc.b	$0
L1B202:	dc.b	$A
	dc.b	'11. Last msg read: %u'
	dc.b	$0
L1B219:	dc.b	$A
	dc.b	'12. Last dwn read: %u'
	dc.b	$0
L1B230:	dc.b	$A
	dc.b	'13. Default Sig:   %d (%s)'
	dc.b	$0
L1B24C:	dc.b	$A
	dc.b	'14. Upload(s):     %d'
	dc.b	$0
L1B263:	dc.b	$A
	dc.b	'15. Download(s):   %d'
	dc.b	$0
L1B27A:	dc.b	$A
	dc.b	'16. NumberCall(s): %d'
	dc.b	$0
L1B291:	dc.b	$A
	dc.b	'17. LastDay:       %D at %T'
	dc.b	$0
L1B2AE:	dc.b	$A
	dc.b	'18. UserFlag(s)    %s'
	dc.b	$A,0
L1B2C6:	dc.b	'User modify'
	dc.b	$0
L1B2D2:	dc.b	$A,$A
	dc.b	'[P]assword, [D]efault Sig, [Q]uit : '
	dc.b	$0
L1B2F9:	dc.b	'dp'
	dc.b	$0
L1B2FC:	dc.b	'dpq'
	dc.b	$D,3,$1B,0
L1B303:	dc.b	'Default Sig'
	dc.b	$A
	dc.b	'Sig number (1-%d) : '
	dc.b	$0
L1B324:	dc.b	$A,$A
	dc.b	'Default Sig set to %d'
	dc.b	$0
;L1B33C:
you_dont_have_access_to_sig_x_2_s:
	dc.b	$A,$A
	dc.b	"You don't have access to Sig %d"
	dc.b	$7,0
L1B35F:	dc.b	$A,$A
	dc.b	'Invalid Sig selection'
	dc.b	$7,0
L1B378:	dc.b	'Password change'
	dc.b	$A
	dc.b	'New password : '
	dc.b	$0
L1B398:	dc.b	$A,$A
	dc.b	'Empty password is not allowed! Old password retained'
	dc.b	$7,0
L1B3D0:	dc.b	'Save'
	dc.b	$A,0
L1B3D6:	dc.b	7,$A
	dc.b	'That user was changed or removed'
	dc.b	$A,0
L1B3FA:	dc.b	$A
	dc.b	'%d users'
	dc.b	$0
L1B404:	dc.b	$A
	dc.b	'Username: '
	dc.b	$0
L1B410:	dc.b	'scan'
	dc.b	$0
L1B415:	dc.b	' '
	dc.b	$0
L1B417:	dc.b	$A,0
L1B419:	dc.b	$A
	dc.b	'User not found'
	dc.b	$7,0
L1B42A:	dc.b	$A,$A
	dc.b	'End of Userlog scan'
	dc.b	$A,0
L1B441:	dc.b	$A
	dc.b	'%s[N]ext  [P]rev  [Q]uit: [N] '
	dc.b	$0
L1B461:	dc.b	'[D]elete [C]hange '
	dc.b	$0
L1B474:	dc.b	0
L1B475:	dc.b	7,$A
	dc.b	'Critical error! No users on file'
	dc.b	$A,0
L1B499:	dc.b	'dcnpq'
	dc.b	$D,3,$1B,0
L1B4A2:	dc.b	'Delete'
	dc.b	$A,7,$A
	dc.b	'Delete this user'
	dc.b	$0
L1B4BC:	dc.b	'Change which line : '
	dc.b	$0
L1B4D1:	dc.b	$A
	dc.b	'Username: '
	dc.b	$0
L1B4DD:	dc.b	$A
	dc.b	'There already is a user with that name'
	dc.b	$7,$A,0
L1B507:	dc.b	$A
	dc.b	'Error occured renaming that user - user has been removed (%d)'
	dc.b	$7,$A,0
L1B548:	dc.b	$A
	dc.b	'%s'
	dc.b	$0
L1B54C:	dc.b	$A
	dc.b	'Address: '
	dc.b	$0
L1B557:	dc.b	$A
	dc.b	'City: '
	dc.b	$0
L1B55F:	dc.b	$A
	dc.b	'State: '
	dc.b	$0
L1B568:	dc.b	$A
	dc.b	'ZipCode: '
	dc.b	$0
L1B573:	dc.b	$A
	dc.b	'Phone: '
	dc.b	$0
L1B57C:	dc.b	$A
	dc.b	'Password: '
	dc.b	$0
L1B588:	dc.b	$A
	dc.b	'Sig(s): '
	dc.b	$0
L1B592:	dc.b	$A
	dc.b	'Time [%d]: '
	dc.b	$0
L1B59F:	dc.b	$A
	dc.b	'Last Message: '
	dc.b	$0
L1B5AF:	dc.b	$A
	dc.b	'Last Download: '
	dc.b	$0
L1B5C0:	dc.b	$A
	dc.b	'Default Sig: '
	dc.b	$0
L1B5CF:	dc.b	$A
	dc.b	'Number of Uploads: '
	dc.b	$0
L1B5E4:	dc.b	$A
	dc.b	'Number of Downloads: '
	dc.b	$0
L1B5FB:	dc.b	$A
	dc.b	'Number of Calls: '
	dc.b	$0
L1B60E:	dc.b	$A
	dc.b	'Date and Time reset'
	dc.b	$0
L1B623:	dc.b	$A
	dc.b	'UserFlags: '
	dc.b	$0
L1B630:	dc.b	'Next'
	dc.b	$0
L1B635:	dc.b	'Previous'
	dc.b	$0
L1B63E:	dc.b	'Quit'
	dc.b	$0
L1B643:	dc.b	$C,$A,$A,0
L1B647:	dc.b	$A,9,9
	dc.b	'Name:'
	dc.b	$9,9
	dc.b	'%s'
	dc.b	$0
L1B654:	dc.b	$A,9,9
	dc.b	'Level:'
	dc.b	$9,9
	dc.b	'%s'
	dc.b	$0
L1B662:	dc.b	$A,9,9
	dc.b	'Address:'
	dc.b	$9
	dc.b	'%s'
	dc.b	$0
L1B671:	dc.b	$A,9,9
	dc.b	'City:'
	dc.b	$9,9
	dc.b	'%s'
	dc.b	$0
L1B67E:	dc.b	$A,9,9
	dc.b	'State:'
	dc.b	$9,9
	dc.b	'%s'
	dc.b	$0
L1B68C:	dc.b	$A,9,9
	dc.b	'ZipCode:'
	dc.b	$9
	dc.b	'%s'
	dc.b	$0
L1B69B:	dc.b	$A,9,9
	dc.b	'Phone:'
	dc.b	$9,9
	dc.b	'%s'
	dc.b	$0
L1B6A9:	dc.b	$A,9,9
	dc.b	'Password:'
	dc.b	$9
	dc.b	'-> %s <-'
	dc.b	$0
L1B6BF:	dc.b	$A,9,9
	dc.b	'Sig(s):'
	dc.b	$9,9
	dc.b	'%s'
	dc.b	$0
L1B6CE:	dc.b	$A,9,9
	dc.b	'TimeAllocated:'
	dc.b	$9
	dc.b	'%H'
	dc.b	$0
L1B6E3:	dc.b	$A,9,9
	dc.b	'Last msg read:'
	dc.b	$9
	dc.b	'%u'
	dc.b	$0
L1B6F8:	dc.b	$A,9,9
	dc.b	'Last dwn read:'
	dc.b	$9
	dc.b	'%u'
	dc.b	$0
L1B70D:	dc.b	$A,9,9
	dc.b	'Default Sig:'
	dc.b	$9
	dc.b	'%d (%s)'
	dc.b	$0
L1B725:	dc.b	$A,9,9
	dc.b	'Upload(s):'
	dc.b	$9
	dc.b	'%d'
	dc.b	$0
L1B736:	dc.b	$A,9,9
	dc.b	'Download(s):'
	dc.b	$9
	dc.b	'%d'
	dc.b	$0
L1B749:	dc.b	$A,9,9
	dc.b	'NumberCall(s):'
	dc.b	$9
	dc.b	'%d'
	dc.b	$0
L1B75E:	dc.b	$A,9,9
	dc.b	'LastDay:'
	dc.b	$9
	dc.b	'%D at %T'
	dc.b	$0
L1B773:	dc.b	$A,9,9
	dc.b	'UserFlag(s):'
	dc.b	$9
	dc.b	'%s'
	dc.b	$0
L1B786:	dc.b	$A
	dc.b	'Username [RETURN for entire listing]: '
	dc.b	$0
L1B7AE:	dc.b	$A
	dc.b	'Username            Access Level   City            State Date     Time    Calls'
	dc.b	$0
L1B7FF:	dc.b	$A
	dc.b	'=================== ============== =============== ===== ======== ======= ====='
	dc.b	$0
L1B850:	dc.b	$A
	dc.b	'%-20s'
	dc.b	$0
L1B857:	dc.b	'%-15s'
	dc.b	$0
L1B85D:	dc.b	'%-16s'
	dc.b	$0
L1B863:	dc.b	'%-6s'
	dc.b	$0
L1B868:	dc.b	'%D %T '
	dc.b	$0
L1B86F:	dc.b	'%5u'
	dc.b	$0
L1B873:	dc.b	$A,$A
	dc.b	'%u Users Listed'
	dc.b	$0,0
L1B886:	dc.b	0
	dc.b	'$'

L1B888:	dc.l	sys_alert_func
	dc.b	0,$19
	dc.l	LFB14
	dc.b	0
	dc.b	'$'
	dc.l	L1060A
	dc.b	0
	dc.b	'&'
	dc.l	LFAEE
	dc.b	0
	dc.b	'$'
	dc.l	sys_enterchat_func
	dc.b	0
	dc.b	'$'
	dc.l	L4F80
	dc.b	0,$1B
	dc.l	LFA36
	dc.b	0,$1B
	dc.l	LFB72
	dc.b	0
	dc.b	'$'
	dc.l	LF690
	dc.b	0,$1B
	dc.l	LFA8E
	dc.b	0
	dc.b	'$'
	dc.l	L7050
	dc.b	0,$1A
	dc.l	LF9F8
	dc.b	0
	dc.b	'$'
	dc.l	LC9B2
	dc.b	0
	dc.b	'$'
	dc.l	sys_hello_func
	dc.b	0
	dc.b	'$'
	dc.l	LCA18
	dc.b	0
	dc.b	'$'
	dc.l	L9688
	dc.b	0
	dc.b	'$'
	dc.l	LC20C
	dc.b	0,$19
	dc.l	L6F3A
	dc.b	0
	dc.b	'$'
	dc.l	L4FBA
	dc.b	0,$1B
	dc.l	L1008E
	dc.b	0
	dc.b	'$'
	dc.l	LD65A
	dc.b	0
	dc.b	'$'
	dc.l	LC260
	dc.b	0,$1B
	dc.l	LFD02
	dc.b	0
	dc.b	'$'
	dc.l	L89EA
	dc.b	0
	dc.b	'&'
	dc.l	LFD3A
	dc.b	0,$27
	dc.l	L1006C
	dc.b	0,$1B
	dc.l	LF908
	dc.b	0
	dc.b	'$'
	dc.l	sys_bye_func
	dc.b	0
	dc.b	'$'
	dc.l	LC3CE
	dc.b	0
	dc.b	'$'
	dc.l	LC236
	dc.b	0
	dc.b	'$'
	dc.l	L5286
	dc.b	0,$1B
	dc.l	LFD5E
	dc.b	0
	dc.b	'$'
	dc.l	LE534
	dc.b	0,$1C
	dc.l	LFFE4
	dc.b	0,$1A
	dc.l	LF950
	dc.b	0,$1B
	dc.l	LFDE0
	dc.b	0
	dc.b	'$'
	dc.l	LC1E4
	dc.b	0,$1A
	dc.l	LFC0E
	dc.b	0,$1A
	dc.l	LFCC4
	dc.b	0,$19
	dc.l	LF972
	dc.b	0
	dc.b	'$'
	dc.l	LC1BA
	dc.b	0,$1A
	dc.l	LF994
	dc.b	0,$1A
	dc.l	LFBD2
	dc.b	0,$1A
	dc.l	LFC88
	dc.b	0
	dc.b	'$'
	dc.l	LCBC4
	dc.b	0
	dc.b	'$'
	dc.l	LCB4C
	dc.b	0
	dc.b	'$'
	dc.l	LCB88
	dc.b	0
	dc.b	'$'
	dc.l	L122F0
	dc.b	0
	dc.b	'$'
	dc.l	L4EB2
	dc.b	0
	dc.b	'$'
	dc.l	L4DEE
	dc.b	0
	dc.b	'&'
	dc.l	L14532
	dc.b	0
	dc.b	'&'
	dc.l	LF92E
	dc.b	0,$1A
	dc.l	LFDCC
	dc.b	0,$1A
	dc.l	LFDB8
	dc.b	0,$1B
	dc.l	LFAC0
	dc.b	0
	dc.b	'$'
	dc.l	L7B10
	dc.b	0,$1B
	dc.l	LFE70
	dc.b	0,$19
	dc.l	LFA7E
	dc.b	0,$1A
	dc.l	LFB96
	dc.b	0,$1A
	dc.l	LFC4C
	dc.b	0
	dc.b	'$'
	dc.l	sys_who_func
	dc.b	0
	dc.b	'&'
	dc.l	L100F0
	dc.b	0,$1B
	dc.l	L1035A
	dc.b	0,$1B
	dc.l	L103AA
	dc.b	0,$19
	dc.l	L103C8
	dc.b	0
	dc.b	'?'
	dc.l	L103D6
	dc.b	0,$1B
	dc.l	L103FE

L1BA18:	dc.b	0,0,0,0
L1BA1C:	dc.b	'%s: Force_read of Message %u failed'
	dc.b	$A,0
L1BA41:	dc.b	'%s'
	dc.b	$0
L1BA44:	dc.b	$A,0
L1BA46:	dc.b	$A,0
L1BA48:	dc.b	$A,0
L1BA4A:	dc.b	$A,0
L1BA4C:	dc.b	'List: %s not found'
	dc.b	$A,0
L1BA60:	dc.b	'%s: %s'
	dc.b	$A,0
L1BA68:	dc.b	$A
	dc.b	'%s'
	dc.b	$0
L1BA6C:	dc.b	$A,0
L1BA6E:	dc.b	'%s'
	dc.b	$A,0
L1BA72:	dc.b	'Open() file not found [%s]'
	dc.b	$0
L1BA8D:	dc.b	'Read() without open'
	dc.b	$0
L1BAA1:	dc.b	'%c:\bbs\%s.mcl'
	dc.b	$0
L1BAB0:	dc.b	'%c:\bbs\welcome.msg'
	dc.b	$0
L1BAC4:	dc.b	$A
	dc.b	'MCL runtime error ['
	dc.b	$0
L1BAD9:	dc.b	'] in %s'
	dc.b	$A,0
L1BAE2:	dc.b	'Stack Overflow'
	dc.b	$0
L1BAF1:	dc.b	'Stack Underflow'
	dc.b	$0
L1BB01:	dc.b	'Unexpected EOF [header]'
	dc.b	$0
L1BB19:	dc.b	'Invalid file format'
	dc.b	$0
L1BB2D:	dc.b	'file does not match version'
	dc.b	$0
L1BB49:	dc.b	'Unexpected EOF [program]'
	dc.b	$0
L1BB62:	dc.b	'String pool overflow'
	dc.b	$0
L1BB77:	dc.b	'Bad offset for GetSysVar %d [literals]'
	dc.b	$0
L1BB9E:	dc.b	'Bad offset for GetSysVar %d'
	dc.b	$0
L1BBBA:	dc.b	'PC out of range %d'
	dc.b	$0
L1BBCD:	dc.b	'Divide by Zero'
	dc.b	$0
L1BBDC:	dc.b	'Modulus by Zero'
	dc.b	$0
L1BBEC:	dc.b	'Bad offset (AssignNum) %d'
	dc.b	$0
L1BC06:	dc.b	'Bad offset (Funcall) %d'
	dc.b	$0
L1BC1E:	dc.b	'Bad offset (FuncallNum) %d'
	dc.b	$0
L1BC39:	dc.b	'Bad offset (FuncallStr) %d'
	dc.b	$0
L1BC54:	dc.b	'Bad offset (FuncallStr2) %d'
	dc.b	$0
L1BC70:	dc.b	'Gosub'
	dc.b	$27
	dc.b	's nested to deep'
	dc.b	$0
L1BC87:	dc.b	'%u '
	dc.b	$0
L1BC8B:	dc.b	'%s'
	dc.b	$0
L1BC8E:	dc.b	'Bad offset (Procall) %d'
	dc.b	$0
L1BCA6:	dc.b	'Bad offset (ProcallNum) %d'
	dc.b	$0
L1BCC1:	dc.b	'Bad offset (ProcallStr) %d'
	dc.b	$0
L1BCDC:	dc.b	'Bad offset (ProcallStr2) %d'
	dc.b	$0
L1BCF8:	dc.b	'Bad offset (PushNum) %d'
	dc.b	$0
L1BD10:	dc.b	'%c:\bbs\%s.mcl'
	dc.b	$0
L1BD1F:	dc.b	'Execute of %s failed'
	dc.b	$0
L1BD34:	dc.b	'Right() lenght less that zero'
	dc.b	$0
L1BD52:	dc.b	'Left() lenght less that zero'
	dc.b	$0
L1BD6F:	dc.b	'%u'
	dc.b	$0
L1BD72:	dc.b	'%c'
	dc.b	$0
L1BD75:	dc.b	'%s'
	dc.b	$0
L1BD78:	dc.b	'Input() invalid lenght'
	dc.b	$0
L1BD8F:	dc.b	'Read() invalid lenght'
	dc.b	$0
L1BDA5:	dc.b	'Bad offset (FuncallNum2) %d'
	dc.b	$0
L1BDC1:	dc.b	'Bad opcode (%d) [%d]'
	dc.b	$0
L1BDD6:	dc.b	'ON'
	dc.b	$0,0
L1BDDA:	dc.b	'OFF'
	dc.b	$0
L1BDDE:	dc.b	'%d byte cache buffer'
	dc.b	$0,0

;L1BDF4:
sys_sysop_shell_struct:
	dc.l	sys_2_activity_s
	dc.l	sys_activity_func
	dc.l	sys_4_addfiles_s
	dc.l	sys_addfiles_func
	dc.l	sys_2_alert_s
	dc.l	sys_alert_func
	dc.l	sys_4_batch_s
	dc.l	sys_batch_func
	dc.l	sys_0_bye_s
	dc.l	sys_bye_func
	dc.l	sys_4_chat_s
	dc.l	sys_chat_func
	dc.l	sys_4_cls_s
	dc.l	sys_cls_func
	dc.l	sys_4_copy_s
	dc.l	sys_copy_func
	dc.l	sys_4_critical_s
	dc.l	sys_critical_func
	dc.l	sys_2_date_s
	dc.l	sys_date_func
	dc.l	sys_4_debug_s
	dc.l	sys_debug_func
	dc.l	sys_4_delete_s
	dc.l	sys_delete_func
	dc.l	sys_4_dir_s
	dc.l	sys_dir_func
	dc.l	sys_4_diskfree_s
	dc.l	sys_diskfree_func
	dc.l	sys_3_download_s
	dc.l	sys_download_func
	dc.l	sys_4_edit_s
	dc.l	sys_edit_func
	dc.l	sys_0_enterchat_s
	dc.l	sys_enterchat_func
	dc.l	sys_0_exit_s
	dc.l	sys_exit_func
	dc.l	sys_0_hello_s
	dc.l	sys_hello_func
	dc.l	sys_0_help_s
	dc.l	sys_help_func
	dc.l	sys_0_listarc_s
	dc.l	sys_listarc_func
	dc.l	sys_4_mailstat_s
	dc.l	sys_mailstat_func
	dc.l	sys_3_move_s
	dc.l	sys_move_func
	dc.l	sys_4_pack_s
	dc.l	sys_pack_func
	dc.l	sys_4_rename_s
	dc.l	sys_rename_func
	dc.l	sys_4_screen_s
	dc.l	sys_screen_func
	dc.l	sys_4_sysdump_s
	dc.l	sys_sysdump_func
	dc.l	sys_4_terminate_s
	dc.l	sys_terminate_func
	dc.l	sys_2_time_s
	dc.l	sys_time_func
	dc.l	sys_4_type_s
	dc.l	sys_type_func
	dc.l	sys_3_upldir_s
	dc.l	sys_upldir_func
	dc.l	sys_3_user_s
	dc.l	sys_user_func
	dc.l	sys_4_upload_s
	dc.l	sys_upload_func
	dc.l	sys_4_who_s
	dc.l	sys_who_func
	dc.l	0
	dc.l	sys_exit_func
;
L1BF0C:
	dc.b	'Usage: %s'
	dc.b	$7,0
;L1BF17:
you_dont_have_access_to_sig_x_3_s:
	dc.b	"You don't have Access to Sig %d"
	dc.b	$0
;L1BF37:
today_is_s:
	dc.b	$A
	dc.b	'Today is '
	dc.b	$0
;L1BF42:
time_is_x_s:
	dc.b	' Time is %T'
	dc.b	$A,0
;L1BF4F:
sys_system_status_dump_s:
	dc.b	$A,$A
	dc.b	'System status dump'
	dc.b	$A,$A,0
L1BF66:
	dc.b	$A
	dc.b	'Errorlog   file ptr = %2d, %s'
	dc.b	$0
L1BF85:
	dc.b	$A
	dc.b	'Userlog    file ptr = %2d, %s'
	dc.b	$0
L1BFA4:
	dc.b	$A
	dc.b	'Maildata   file ptr = %2d, %s'
	dc.b	$0
L1BFC3:
	dc.b	$A
	dc.b	'Lastcaller file ptr = %2d, %s'
	dc.b	$A,0
L1BFE3:
	dc.b	$A
	dc.b	'%-32s Download path ->%s<-'
	dc.b	$0
L1BFFF:
	dc.b	$A,$A
	dc.b	'Upload path ->%s<-'
	dc.b	$0
L1C014:
	dc.b	$A,$A
	dc.b	'Password: '
	dc.b	$0
L1C021:
	dc.b	'System Shutdown'
	dc.b	$0
L1C031:
	dc.b	$A,$A
	dc.b	'To shutdown the BBS type'
	dc.b	$A,$A
	dc.b	'"%s"'
	dc.b	$A
	dc.b	':'
	dc.b	$0
L1C054:
	dc.b	7,$A,$A,$A
	dc.b	'When all users have logged off, the BBS will shutdown'
	dc.b	$A,0
L1C08F:
	dc.b	'Date month/day/year'
	dc.b	$0
L1C0A3:
	dc.b	7
	dc.b	'Invalid date'
	dc.b	$0
L1C0B1:
	dc.b	'Time hours:mins'
	dc.b	$0
L1C0C1:
	dc.b	7
	dc.b	'Invalid time'
	dc.b	$0
L1C0CF:
	dc.b	$A
	dc.b	'Activity file was not Open'
	dc.b	$A,0
L1C0EC:
	dc.b	$A
	dc.b	'Press [SPACE] to stop listing'
	dc.b	$A,$A,0
L1C10D:
	dc.b	$A,$A
	dc.b	'Purge activity file '
	dc.b	$0
L1C124:
	dc.b	$A
	dc.b	'Error creating %s'
	dc.b	$A,0
L1C138:
	dc.b	$A
	dc.b	'Activity file is empty'
	dc.b	$A,$A,0
L1C152:
	dc.b	'AXCKY'
	dc.b	$0
L1C158:
	dc.b	'Invalid Mode "%s"'
	dc.b	$0
L1C16A:
	dc.b	'Upload filename mode'
	dc.b	$0
L1C17F:
	dc.b	'YMODEM upload not yet implemented'
	dc.b	$0
L1C1A1:
	dc.b	$A
	dc.b	'Overwrite %s '
	dc.b	$0
L1C1B0:
	dc.b	0
L1C1B1:
	dc.b	'Could not create %s'
	dc.b	$0
L1C1C5:
	dc.b	'%s: SYSOP Upload %s File: %s'
	dc.b	$A,0
L1C1E3:
	dc.b	'Download filename mode'
	dc.b	$0
L1C1FA:
	dc.b	'%s Not found'
	dc.b	$0
L1C207:
	dc.b	'*.*'
	dc.b	$0
L1C20B:
	dc.b	'Dir [filename|filemask]'
	dc.b	$0
L1C223:
	dc.b	'*.*'
	dc.b	$0
L1C227:
	dc.b	'*.*'
	dc.b	$0
L1C22B:
	dc.b	'UplDir [filename|filemask]'
	dc.b	$0
L1C246:
	dc.b	'No upload path defined'
	dc.b	$7,$A,0
L1C25F:
	dc.b	'Edit filename'
	dc.b	$0
L1C26D:
	dc.b	'Could not create %s'
	dc.b	$0
L1C281:
	dc.b	'New file %s'
	dc.b	$0
L1C28D:
	dc.b	' '
	dc.b	$0
L1C28F:
	dc.b	$A
	dc.b	'Writing %d lines to %s'
	dc.b	$0
L1C2A7:
	dc.b	$A
	dc.b	'Fatal error! - File %s was lost!'
	dc.b	$0
L1C2C9:
	dc.b	$D,$A,0
L1C2CC:
	dc.b	$A
	dc.b	'Disk is full, writing %s'
	dc.b	$0
L1C2E6:
	dc.b	0
L1C2E7:
	dc.b	$A
	dc.b	'Disk Error on drive %c:'
	dc.b	$A,0
L1C301:
	dc.b	$A
	dc.b	'Disk Usage of %c:'
	dc.b	$A,0
L1C315:
	dc.b	'%9ld bytes total disk space'
	dc.b	$A,0
L1C332:
	dc.b	'%9ld bytes available on disk'
	dc.b	$A,0
L1C350:
	dc.b	'Chat [on]|[off]'
	dc.b	$0
L1C360:
	dc.b	'Chat is %s %s'
	dc.b	$0
L1C36E:
	dc.b	'now'
	dc.b	$0
L1C372:
	dc.b	'currently'
	dc.b	$0
L1C37C:
	dc.b	'Debug [on]|[off]'
	dc.b	$0
L1C38D:
	dc.b	'Debug is %s %s'
	dc.b	$0
L1C39C:
	dc.b	'now'
	dc.b	$0
L1C3A0:
	dc.b	'currently'
	dc.b	$0
L1C3AA:
	dc.b	'Addfiles pathmask'
	dc.b	$0
L1C3BC:
	dc.b	'Sysop'
	dc.b	$0
L1C3C2:
	dc.b	'Addfiles: %s'
	dc.b	$0
L1C3CF:
	dc.b	$A
	dc.b	'Use System Date and time '
	dc.b	$0
L1C3EA:
	dc.b	$A
	dc.b	'Add file %s %ld'
	dc.b	$0
L1C3FB:
	dc.b	0
L1C3FC:
	dc.b	$A
	dc.b	'Uploader [%s] : '
	dc.b	$0
L1C40E:
	dc.b	$A
	dc.b	'Access level'
	dc.b	$A
	dc.b	'%s[%d] '
	dc.b	$0
L1C424:
	dc.b	$A
	dc.b	'Default: '
	dc.b	$0
L1C42F:
	dc.b	'Which Sig(s) : '
	dc.b	$0
L1C43F:
	dc.b	0
L1C440:
	dc.b	$A
	dc.b	'Description:'
	dc.b	$A,0
L1C44F:
	dc.b	$A,$A
	dc.b	'Error file not added'
	dc.b	$A,0
L1C467:
	dc.b	$A,$A
	dc.b	'%s added as file %u'
	dc.b	$A,0
L1C47E:
	dc.b	'Move \spath\[mask] \dpath\'
	dc.b	$0
L1C499:
	dc.b	'*.*'
	dc.b	$0
L1C49D:
	dc.b	'Move: Destination must be a path'
	dc.b	$7,0
L1C4BF:
	dc.b	'Move: %s'
	dc.b	$0
L1C4C8:
	dc.b	'Move: Too many files'
	dc.b	$7,0
L1C4DE:
	dc.b	$A,$A
	dc.b	'Move: Error files have the same NAME!'
	dc.b	$7,0
L1C507:
	dc.b	$A,$A
	dc.b	'Move %s -> %s'
	dc.b	$A
	dc.b	'[Y]es [N]o [D]elete [Q]uit : '
	dc.b	$0
L1C535:
	dc.b	'yndq'
	dc.b	$1B,3,0
L1C53C:
	dc.b	'Yes'
	dc.b	$0
L1C540:
	dc.b	$A
	dc.b	'Could not relocate file'
	dc.b	$7,0
L1C55A:
	dc.b	'No'
	dc.b	$0
L1C55D:
	dc.b	7
	dc.b	'Delete'
	dc.b	$0
L1C565:
	dc.b	$A
	dc.b	'Delete of %s failed'
	dc.b	$7,0
L1C57B:
	dc.b	'Quit'
	dc.b	$0
L1C580:
	dc.b	'Sysop is being paged'
	dc.b	$0
L1C595:
	dc.b	'Type filename'
	dc.b	$0
L1C5A3:
	dc.b	'A'
	dc.b	$0
L1C5A5:
	dc.b	'Copy source destination'
	dc.b	$0
L1C5BD:
	dc.b	'Copy: %s'
	dc.b	$0
L1C5C6:
	dc.b	'Illegal destination'
	dc.b	$0
L1C5DA:
	dc.b	$A,$A
	dc.b	'%s -> %s'
	dc.b	$A
	dc.b	'Copy'
	dc.b	$0
L1C5EA:
	dc.b	0
L1C5EB:
	dc.b	$A
	dc.b	'Could not open %s'
	dc.b	$7,0
L1C5FF:
	dc.b	$A
	dc.b	'Could not create %s'
	dc.b	$7,0
L1C615:
	dc.b	'Source disk read error!'
	dc.b	$7,0
L1C62E:
	dc.b	$A,$A
	dc.b	'Destination disk is full!'
	dc.b	$7,0
L1C64B:
	dc.b	'%2d %s'
	dc.b	$A,0
L1C653:
	dc.b	$A
	dc.b	'Usage: Screen #'
	dc.b	$0
L1C664:
	dc.b	'%-.80s'
	dc.b	$A,0
L1C66C:
	dc.b	'Delete filename'
	dc.b	$0
L1C67C:
	dc.b	'*.*'
	dc.b	$0
L1C680:
	dc.b	'Delete: %s'
	dc.b	$0
L1C68B:
	dc.b	$A
	dc.b	'Delete %-13s %D %T'
	dc.b	$0
L1C69F:
	dc.b	0
L1C6A0:
	dc.b	'Listarc filename'
	dc.b	$0
L1C6B1:
	dc.b	'*.ARC'
	dc.b	$0
L1C6B7:
	dc.b	'.ARC'
	dc.b	$0
L1C6BC:
	dc.b	'Listarc: %s'
	dc.b	$0
L1C6C8:
	dc.b	$A
	dc.b	'List Archive %-13s'
	dc.b	$0
L1C6DC:
	dc.b	0
L1C6DD:
	dc.b	'Rename filename filename'
	dc.b	$0
L1C6F6:
	dc.b	'Could not rename %s to %s'
	dc.b	$7,0
L1C711:
	dc.b	'%s renamed to %s'
	dc.b	$0
L1C722:
	dc.b	'batch filename [filename]'
	dc.b	$0
L1C73C:
	dc.b	'YMODEM DOWNLOAD User: %-20s %s'
	dc.b	$A,0
L1C75C:
	dc.b	0
L1C75D:
	dc.b	$C,0
L1C75F:
	dc.b	$A
	dc.b	'Users On-Line'
	dc.b	$A
	dc.b	'======== =================== =========== ================ ==================='
	dc.b	$A,0
L1C7BD:
	dc.b	'%s: %-20s%s %-16.16s%20.20s'
	dc.b	$A,0
L1C7DA:
	dc.b	'On-Line    '
	dc.b	$0
L1C7E6:
	dc.b	'Last caller'
	dc.b	$0
L1C7F2:
	dc.b	$A
	dc.b	'%d critical errors have occured'
	dc.b	$0
L1C813:
	dc.b	$A
	dc.b	'Clear count '
	dc.b	$0
;L1C821:
sys_2_activity_s:
	dc.b	'2Activity'
	dc.b	$0
;L1C82B:
sys_4_addfiles_s:
	dc.b	'4Addfiles'
	dc.b	$0
;L1C835:
sys_2_alert_s:
	dc.b	'2Alert'
	dc.b	$0
;L1C83C:
sys_4_batch_s:
	dc.b	'4Batch'
	dc.b	$0
;L1C843:
sys_0_bye_s:
	dc.b	'0Bye'
	dc.b	$0
;L1C848:
sys_4_chat_s:
	dc.b	'4Chat'
	dc.b	$0
;L1C84E:
sys_4_cls_s:
	dc.b	'4Cls'
	dc.b	$0
;L1C853:
sys_4_copy_s:
	dc.b	'4Copy'
	dc.b	$0
;L1C859:
sys_4_critical_s:
	dc.b	'4Critical'
	dc.b	$0
;L1C863:
sys_2_date_s:
	dc.b	'2Date'
	dc.b	$0
;L1C869:
sys_4_debug_s:
	dc.b	'4Debug'
	dc.b	$0
;L1C870:
sys_4_delete_s:
	dc.b	'4Delete'
	dc.b	$0
;L1C878:
sys_4_dir_s:
	dc.b	'4Dir'
	dc.b	$0
;L1C87D:
sys_4_diskfree_s:
	dc.b	'4Diskfree'
	dc.b	$0
;L1C887:
sys_3_download_s:
	dc.b	'3Download'
	dc.b	$0
;L1C891:
sys_4_edit_s:
	dc.b	'4Edit'
	dc.b	$0
;L1C897:
sys_0_enterchat_s:
	dc.b	'0Enterchat'
	dc.b	$0
;L1C8A2:
sys_0_exit_s:
	dc.b	'0Exit'
	dc.b	$0
;L1C8A8:
sys_0_hello_s:
	dc.b	'0Hello'
	dc.b	$0
;L1C8AF:
sys_0_help_s:
	dc.b	'0Help'
	dc.b	$0
;L1C8B5:
sys_0_listarc_s:
	dc.b	'0Listarc'
	dc.b	$0
;L1C8BE:
sys_4_mailstat_s:
	dc.b	'4Mailstat'
	dc.b	$0
;L1C8C8:
sys_3_move_s:
	dc.b	'3Move'
	dc.b	$0
;L1C8CE:
sys_4_pack_s:
	dc.b	'4Pack'
	dc.b	$0
;L1C8D4:
sys_4_rename_s:
	dc.b	'4Rename'
	dc.b	$0
;L1C8DC:
sys_4_screen_s:
	dc.b	'4Screen'
	dc.b	$0
;L1C8E4:
sys_4_sysdump_s:
	dc.b	'4Sysdump'
	dc.b	$0
;L1C8ED:
sys_4_terminate_s:
	dc.b	'4Terminate'
	dc.b	$0
;L1C8F8:
sys_2_time_s:
	dc.b	'2Time'
	dc.b	$0
;L1C8FE:
sys_4_type_s:
	dc.b	'4Type'
	dc.b	$0
;L1C904:
sys_3_upldir_s:
	dc.b	'3Upldir'
	dc.b	$0
;L1C90C:
sys_3_user_s:
	dc.b	'3User'
	dc.b	$0
;L1C912:
sys_4_upload_s:
	dc.b	'4Upload'
	dc.b	$0
;L1C91A:
sys_4_who_s:
	dc.b	'4Who'
	dc.b	$0
;L1C91F:
sys_available_commands_s:
	dc.b	'Available Commands:'
	dc.b	$A,$A,0
L1C935:
	dc.b	'%-10s%s'
	dc.b	$0
L1C93D:
	dc.b	0
L1C93E:
	dc.b	$A,0
L1C940:
	dc.b	$A,0
;L1C942:
sys_sysop_shell_s:
	dc.b	'Sysop shell'
	dc.b	$0
;L1C94E:
sys_x_command_s:
	dc.b	$A,$A
	dc.b	'%sCommand: '
	dc.b	$0
L1C95C:
	dc.b	'* '
	dc.b	$0
L1C95F:
	dc.b	0
;L1C960:
sys_help_s:
	dc.b	'help'
	dc.b	$0
;L1C965:
sys_unknown_command_x_s:
	dc.b	$A
	dc.b	'Unknown Command %s'
	dc.b	$7,0
;L1C97A:
sys_please_be_more_specific_s:
	dc.b	$A
	dc.b	'Please be more specific'
	dc.b	$0
L1C993:	dc.b	$A,$A,0
;L1C996:
sys_exit_s:
	dc.b	'exit'
	dc.b	$0
;L1C99B:
sys_argument_for_x_s:
	dc.b	$A
	dc.b	'Argument for %s: '
	dc.b	$0
L1C9AE:
	dc.b	$A,0
L1C9B0:
	dc.b	$A,0
;L1C9B2:
sys_sysopshell_bad_operand_s:
	dc.b	$A
	dc.b	'Sysopshell: Bad operand '
	dc.b	$0
;L1C9CC:
edit_there_are_no_lines_to_x_s:
	dc.b	'%s'
	dc.b	$A
	dc.b	'There are no lines to %s'
	dc.b	$0
;L1C9E8:
edit_which_lines_1_x_s:
	dc.b	'%s'
	dc.b	$A
	dc.b	'Which line(s) (1-%d) : '
	dc.b	$0
;L1CA03:
edit_no_defaults_here_s:
	dc.b	$A,7
	dc.b	'No defaults allowed here'
	dc.b	$0
;L1CA1E:
edit_invalid_line_number_1_s:
	dc.b	$A,7
	dc.b	'Invalid line number'
	dc.b	$0
;L1CA34:
edit_invalid_high_range_number_s:
	dc.b	$A,7
	dc.b	'Invalid high range number'
	dc.b	$0
;L1CA50:
edit_list_s:
	dc.b	'List'
	dc.b	$0
L1CA55:
	dc.b	$A
	dc.b	'%2d: %s'
	dc.b	$0
;L1CA5E:
edit_delete_s:
	dc.b	'Delete'
	dc.b	$0
;L1CA65:
edit_edit_s:
	dc.b	'Edit'
	dc.b	$A,0
;L1CA6B:
edit_which_line_1_x_s:
	dc.b	'Which line (1-%d) : '
	dc.b	$0
;L1CA80:
edit_invalid_line_number_2_s:
	dc.b	$A
	dc.b	'Invalid Line number'
	dc.b	$7,0
;L1CA96:
edit_old_line_x_y_z_s:
	dc.b	$A
	dc.b	'Old line'
	dc.b	$A
	dc.b	'%2d: %s'
	dc.b	$A
	dc.b	'%2d: '
	dc.b	$0
;L1CAAE:
edit_old_line_was_not_changed_s:
	dc.b	$A
	dc.b	'Old line was not changed'
	dc.b	$0
L1CAC8:
	dc.b	' '
	dc.b	$0
;L1CACA:
edit_there_are_no_lines_to_edit_s:
	dc.b	'There are no lines to edit'
	dc.b	$7,0
;L1CAE6:
edit_insert_s:
	dc.b	'Insert'
	dc.b	$A,0
;L1CAEE:
edit_after_which_line_0_x_s:
	dc.b	'After which line (0-%d) : '
	dc.b	$0
;L1CB09:
edit_esc_or_3_blank_ends_insert_s:
	dc.b	$A
	dc.b	'[ESC] or 3 blank lines will end insert mode'
	dc.b	$A,0
L1CB37:
	dc.b	$A
	dc.b	'%2d: '
	dc.b	$0
L1CB3E:
	dc.b	'%s'
	dc.b	$0
;L1CB41:
edit_load_x_failed_s:
	dc.b	$A
	dc.b	'Load of %s Failed'
	dc.b	$0
L1CB54:
	dc.b	' '
	dc.b	$0
;L1CB56:
edit_menu_s:
	dc.b	$A,$A
	dc.b	'[%d] [L]ist [D]elete [E]dit [I]nsert [S]ave [Q]uit : '
	dc.b	$0
;L1CB8E:
edit_menu_cmds_1_s:
	dc.b	'ldeiqs'
	dc.b	$0
;L1CB95:
edit_menu_cmds_2_s:
	dc.b	'ldeiqs'
	dc.b	$0
;L1CB9C:
edit_quit_s:
	dc.b	'Quit'
	dc.b	$A,$A,0
;L1CBA3:
edit_save_s:
	dc.b	'Save'
	dc.b	$A,$A,0
L1CBAA:	dc.b	$A,0
;L1CBAC:
ascii_send_s:
	dc.b	'ASCII send'
	dc.b	$0
;L1CBB7:
press_key_when_ready_to_receive_s:
	dc.b	$A
	dc.b	'Press any key when ready to receive %s ... '
	dc.b	$0
L1CBE4:
	dc.b	$A,$A,0
;L1CBE7:
ascii_receive_s:
	dc.b	'ASCII Receive'
	dc.b	$0
;L1CBF5:
send_upload_now_ctrl_z_to_end_s:
	dc.b	$A
	dc.b	'Send the upload now, CNTRL-Z ends upload'
	dc.b	$A,$A,0,0
L1CC22:
	dc.b	'%ld'
	dc.b	$0
;L1CC26:
ymodem_send_x_s:
	dc.b	$A
	dc.b	'YMODEM Send %s'
	dc.b	$0
;L1CC36:
end_of_batch_s:
	dc.b	'END OF BATCH'
	dc.b	$0
;L1CC43:
x_blocks_s:
	dc.b	' %u Blocks'
	dc.b	$0
;L1CC4E:
ymodem_send_s:
		dc.b	'YMODEM send',NUL
;L1CC5A:
ymodem_recv_s:
	dc.b	'YMODEM receive',NUL
L1CC69:
	dc.b	NUL
;L1CC6A:
xmodem_send_s:
	dc.b	'XMODEM send',NUL
;L1CC76:
xmodem_recv_s:
	dc.b	'XMODEM receive',NUL
;L1CC85:
crc_xmodem_send_s:
	dc.b	'XMODEM-CRC send',NUL
;L1CC95:
crc_xmodem_recv_s:
	dc.b	'XMODEM-CRC receive',NUL
;L1CCA8:
x1k_xmodem_send_s:
	dc.b	'XMODEM-1k send',NUL
;L1CCB7:
x1k_xmodem_recv_s:
	dc.b	'XMODEM-1k receive',NUL
;L1CCC9:
x_send_wait_s:
	dc.b	LF,'%s send - Wait',NUL
;L1CCD9:
x_send_y_z_s:
	dc.b	$D
	dc.b	'%s send - %5u %c '
	dc.b	$0
;L1CCEC:
x_received_awaiting_shake_s:
	dc.b	$A
	dc.b	'%s receive - Waiting for handshake '
	dc.b	$0
;L1CD11:
received_s:
	dc.b	'Received'
	dc.b	$A,$A,0
;L1CD1C:
x_receive_y_z_s:
	dc.b	$D
	dc.b	'%s receive - %5u %c '
	dc.b	$0
;L1CD32:
timeout_during_block_s:
	dc.b	'- Timeout durring block'
	dc.b	$A,0
;L1CD4B:
bad_block_complement_s:
	dc.b	'- Bad block complement'
	dc.b	$A,0
;L1CD63:
bad_crc_s:
	dc.b	'- Bad CRC'
	dc.b	$A,0
;L1CD6E:
bad_checksum_s:
	dc.b	'- Bad Checksum'
	dc.b	$A,0
;L1CD7E:
duplicate_block_s:
	dc.b	'- Duplicate block'
	dc.b	$A,0
;L1CD91:
block_sequence_error_s:
	dc.b	'- Block sequence error'
	dc.b	$A,0,0
;
;L1CDAA:
packtype_s_p_a:
	dc.l	unknown_s
	dc.l	L1CDD7
	dc.l	L1CDE0
	dc.l	packed_s
	dc.l	squeezed_s
	dc.l	crunched_1_s
	dc.l	crunched_2_s
	dc.l	crunched_3_s
	dc.l	crunched_4_s
;
;L1CDCE:
unknown_s:
	dc.b	'Unknown '
	dc.b	$0
L1CDD7:
	dc.b	'   --   '
	dc.b	$0
L1CDE0:
	dc.b	'   --   '
	dc.b	$0
;L1CDE9:
packed_s:
	dc.b	' Packed '
	dc.b	$0
;L1CDF2:
squeezed_s:
	dc.b	'Squeezed'
	dc.b	$0
;L1CDFB:
crunched_1_s:
	dc.b	'crunched'
	dc.b	$0
;L1CE04:
crunched_2_s:
	dc.b	'crunched'
	dc.b	$0
;L1CE0D:
crunched_3_s:
	dc.b	'crunched'
	dc.b	$0
;L1CE16:
crunched_4_s:
	dc.b	'Crunched'
	dc.b	$0
;L1CE1F:
arc_listing_s:
	dc.b	'Arc listing'
	dc.b	$0
;L1CE2B:
could_not_find_archive_file_x_s:
	dc.b	$A
	dc.b	'Could not find ARCHIVE file %s'
	dc.b	$0
;L1CE4B:
archive_x_is_bad_s:
	dc.b	$A
	dc.b	'Archive %s is bad'
	dc.b	$0
;L1CE5E:
archive_x_s:
	dc.b	$A
	dc.b	'Archive %s:'
	dc.b	$0
L1CE6B:
	dc.b	$A
	dc.b	'Name          Length    Stowage    SF   Size now  Date      Time     CRC'
	dc.b	$0
L1CEB5:
	dc.b	$A
	dc.b	'============  ========  ========  ====  ========  ========  =======  ===='
	dc.b	$0
L1CF00:
	dc.b	$A
	dc.b	'%-12s  %8ld  %s  %3d%%  %8ld  %D  %T  %04x'
	dc.b	$0
L1CF2C:
	dc.b	$A
	dc.b	'        ====  ========            ====  ========'
	dc.b	$0
;L1CF5E:
total_x_y_z_t_s:
	dc.b	$A
	dc.b	'Total %6ld  %8ld            %3d%%  %8ld'
	dc.b	$0,0
;L1CF88:
hex_digits_s:
	dc.b	'0123456789ABCDEF'
	dc.b	$0,0
;L1CF9A:
hayes_ate0v0m0x1s0_eq_0_s:
	dc.b	'ATE0V0M0X1S0=0'
	dc.b	$D,0
	dc.b	'--Use this space if needed---------'
	dc.b	$0
;
;L1CFCE:
waiting_for_a_call_on_x_p:
	dc.l	waiting_for_a_call_on_x_s
;
;L1CFD2:
modem_init_s:
	dc.b	'Modem initialization'
	dc.b	$0
;L1CFE7:
autobaud_s:
	dc.b	'AUTOBAUD'
	dc.b	$0
;L1CFF0:
sending_modem_init_1_s:
	dc.b	$C,$A
	dc.b	'Sending modem initialization codes'
	dc.b	$A,0
;L1D016:
waiting_for_a_call_on_x_s:
	dc.b	$A,$A
	dc.b	'Waiting for a call on %s '
	dc.b	$0
;L1D032:
waiting_for_call_s:
	dc.b	'Waiting for call'
	dc.b	$0
;L1D043:
ring_count_reset_s:
	dc.b	$C,$A
	dc.b	'Ring Count reset'
	dc.b	$0
;L1D056:
waking_up_modem_x_s:
	dc.b	$C,$A
	dc.b	'Waking up Modem %d.'
	dc.b	$A,0
;L1D06D:
hangup_code_s:
	dc.b	'Hangup code'
	dc.b	$0
;L1D079:
hayes_plusplusplus_s:
	dc.b	'+++'
	dc.b	$0
;L1D07D:
hayes_ath0_s:
	dc.b	'ATH0'
	dc.b	$D,0
;L1D083:
modem_can_not_disconnect:
	dc.b	$A
	dc.b	'Cannot make the modem disconnect!'
	dc.b	$A,0
;L1D0A7:
command_s:
	dc.b	$A
	dc.b	'Command: '
	dc.b	$0
;L1D0B2:
hayes_at_s:
	dc.b	'AT'
	dc.b	$D,0
;L1D0B6:
modem_is_not_responding_s:
	dc.b	$A
	dc.b	'Modem is not responding.'
	dc.b	$A,0
;L1D0D1:
incoming_call_s:
	dc.b	$A
	dc.b	'Incoming call'
	dc.b	$0
;L1D0E0:
answering_now_s:
	dc.b	' Answering now. '
	dc.b	$0
;L1D0F1:
hayes_ata_s:
	dc.b	'ATA'
	dc.b	$D,0
;L1D0F6:
ring_x_of_y_s:
	dc.b	' Ring %d of %d.'
	dc.b	$0
L1D106:
	dc.b	0
;L1D107:
ringing_s:
	dc.b	'Ringing'
	dc.b	$0
;L1D10F:
_arq_1_s:
	dc.b	'/ARQ'
	dc.b	$0
;L1D114:
_arq_2_s:
	dc.b	'/ARQ'
	dc.b	$0
;L1D119:
_arq_3_s:
	dc.b	'/ARQ'
	dc.b	$0
;L1D11E:
ring_s:
	dc.b	'Ring'
	dc.b	$0
;L1D123:
no_answer_s:
	dc.b	'No Answer'
	dc.b	$0
;L1D12D:
no_carrier_s:
	dc.b	'No Carrier'
	dc.b	$0
;L1D138:
no_dial_tone_s:
	dc.b	'No Dial Tone'
	dc.b	$0
;L1D145:
busy_s:
	dc.b	'Busy'
	dc.b	$0
;L1d14A:
format_error_s:
	dc.b	'Format error'
	dc.b	$0
;L1D157:
voice_detected_s:
	dc.b	'Voice detected'
	dc.b	$0
L1D166:
	dc.b	0
;L1D167:
connected_at_x_y_s:
	dc.b	'Connected at %d %s'
	dc.b	$0
;L1D17A:
modem_x_s:
	dc.b	$A
	dc.b	'Modem: "%s"'
	dc.b	$0
;L1D187:
sending_modem_init_2_s:
	dc.b	$C,$A
	dc.b	'Sending modem initialization codes'
	dc.b	$A,0
;L1D1AD:
call_detected_s:
	dc.b	$A,$A
	dc.b	'Call detected'
	dc.b	$A,0
;L1D1BE:
detecting_caller_s:
	dc.b	'Detecting caller'
	dc.b	$0
;L1D1CF:
press_return_s:
	dc.b	$D,$A
	dc.b	'Press [RETURN]'
	dc.b	$7,$D,$A,0
;L1D1E3:
please_discon_s:
	dc.b	$A,7
	dc.b	'Please disconnect now !'
	dc.b	$7,0
;
;
;----------------------------------------------------------------------------
;
	section	bss
;
;----------------------------------------------------------------------------
;	starts at offset $1D1FE:
;
L1D1FE:		ds.b	512
L1D3FE:		ds.b	512
L1D5FE:		ds.b	512
L1D7FE:		ds.b	512
L1D9FE:		ds.b	512
L1DBFE:		ds.b	512
L1DDFE:		ds.b	512
L1DFFE:		ds.b	512
L1E1FE:		ds.b	512
L1E3FE:		ds.b	512
L1E5FE:		ds.b	512
L1E7FE:		ds.b	512
L1E9FE:		ds.b	2
L1EA00:		ds.b	2
L1EA02:		ds.b	2
L1EA04:		ds.b	2
L1EA06:		ds.b	2
L1EA08:		ds.b	2
L1EA0A:		ds.b	318
L1EB48:		ds.b	2
L1EB4A:		ds.b	2
L1EB4C:		ds.b	788
L1EE60:		ds.b	2
L1EE62:		ds.b	2
L1EE64:		ds.b	2
L1EE66:		ds.b	53132
L2BDF2:		ds.b	68
L2BE36:		ds.b	8
L2BE3E:		ds.b	8
L2BE46:		ds.b	1
L2BE47:		ds.b	319
L2BF86:		ds.b	8
L2BF8E:		ds.b	8
L2BF96:		ds.b	8
L2BF9E:		ds.b	264
L2C0A6:		ds.b	2
L2C0A8:		ds.b	4
L2C0AC:		ds.b	4
L2C0B0:		ds.b	2
L2C0B2:		ds.b	2
L2C0B4:		ds.b	2
L2C0B6:		ds.b	2
L2C0B8:		ds.b	2
L2C0BA:		ds.b	8
L2C0C2:		ds.b	2
L2C0C4:		ds.b	32
L2C0E4:		ds.b	6
L2C0EA:		ds.b	2
L2C0EC:		ds.b	34
L2C10E:		ds.b	618
L2C378:		ds.b	2
L2C37A:		ds.b	2048
L2CB7A:		ds.b	2048
L2D37A:		ds.b	512
L2D57A:		ds.b	50
L2D5AC:		ds.b	2240
L2DE6C:		ds.b	320
L2DFAC:		ds.b	2
L2DFAE:		ds.b	2
L2DFB0:		ds.b	2
L2DFB2:		ds.b	4
L2DFB6:		ds.b	4
L2DFBA:		ds.b	358
L2E120:		ds.b	2
L2E122:		ds.b	1184
L2E5C2:		ds.b	2560
L2EFC2:		ds.b	4
L2EFC6:		ds.b	2
L2EFC8:		ds.b	368
L2F138:		ds.b	1184
L2F5D8:		ds.b	2560
L2FFD8:		ds.b	4
L2FFDC:		ds.b	2
L2FFDE:		ds.b	368
L3014E:		ds.b	1184
L305EE:		ds.b	2560
L30FEE:		ds.b	4
L30FF2:		ds.b	2
L30FF4:		ds.b	368
L31164:		ds.b	1150
L315E2:		ds.b	4
L315E6:		ds.b	20
L315FA:		ds.b	322
L3173C:		ds.b	2
L3173E:		ds.b	16384
L3573E:		ds.b	4096
L3673E:		ds.b	2
L36740:		ds.b	2
L36742:		ds.b	2
L36744:		ds.b	32770
L3E746:		ds.b	6
L3E74C:		ds.b	2
L3E74E:		ds.b	2
L3E750:		ds.b	8
L3E758:		ds.b	2
L3E75A:		ds.b	16
L3E76A:		ds.b	2
L3E76C:		ds.b	78
L3E7BA:		ds.b	4
L3E7BE:		ds.b	4
L3E7C2:		ds.b	32772
L467C6:		ds.b	2
L467C8:		ds.b	2
L467CA:		ds.b	64
L4680A:		ds.b	192
L468CA:		ds.b	2
L468CC:		ds.b	2
L468CE:		ds.b	32
L468EE:		ds.b	48
L4691E:		ds.b	514
L46B20:		ds.b	2
L46B22:		ds.b	2
L46B24:		ds.b	2
L46B26:		ds.b	1
L46B27:		ds.b	1
L46B28:		ds.b	1
L46B29:		ds.b	1
L46B2A:		ds.b	226
L46C0C:		ds.b	2
L46C0E:		ds.b	20
L46C22:		ds.b	512
L46E22:		ds.b	32
L46E42:		ds.b	2
L46E44:		ds.b	2
L46E46:		ds.b	8192
;
;
	end
;
;
;----------------------------------------------------------------------------
;	End of file:	BBS.TOS
