;----------------------------------------------------------------------------
;File name:	PCHROME4.S			Revision date:	1996.04.18
;Revised by:	Ulf Ronald Andersson		Revision start:	1995.06.20
;----------------------------------------------------------------------------
;Desert	Drain V1.41   68000er Disassembler  21.06.1995 22:56:20
;DATEI:	PCHROME4.ORG   69572 Bytes
;TEXT:	44366	$0AD4E
;DATA:	23822	$05D0E
;BSS:  368164  $059E24
;----------------------------------------------------------------------------
;
	include	URAn_DOS.S
	include	URAn_LA.S
;
;----------------------------------------------------------------------------
;
	SECTION	TEXT
;
;----------------------------------------------------------------------------
;
huge_program	=	1
;
	include	URAn_APP.S
	include	Lace_Lib.S
	include	Path_Lib.S
;
;----------------------------------------------------------------------------
;	Arrays required by URAn_APP.S
;
acc_name:	ds.w	1	;name string for ACC menu registration
message:	ds.w	8	;16 bytes or more as evnt_mesag message pipe
intin:		ds.w	30	;30 words or more for AES/VDI input  integers
intout:		ds.w	45	;45 words or more for AES/VDI output integers
ptsin:		ds.w	30	;30 words or more for VDI input  coordinates
ptsout:		ds.w	12	;12 words or more for VDI output coordinates
		ds.l	200
mystack:	;(at end of) subroutine stack >= 100 longs
;
;----------------------------------------------------------------------------
;
entrylace_f:	ds.w	1
;
main_path_s:	ds.b	128
arg_ext_l:	ds.l	1
next_arg:	ds.w	1
;
;----------------------------------------------------------------------------
;
init_APP:
	include	URAn_ARG.S
	lea	main_path_s,a1
	clr.b	(a1)
	cmp	#2,arg_cnt
	blt.s	.no_arg
	move.l	arg_ptr(pc),a0
.loop_0:
	tst.b	(a0)+
	bne.s	.loop_0
	lea	main_path_s,a1
.loop_1:
	move.l	a0,a2	;possible start of name part
	move.l	a1,a3	;possible end of pure path
.loop_2:
	move.b	(a0)+,d0
	move.b	d0,(a1)+
	beq.s	.end_path
	cmp.b	#'\',d0
	bne.s	.loop_2
	bra.s	.loop_1
;
.end_path:
	move.l	a2,a0	;start of name part
	lea	fsel_filename_s,a1
	suba.l	a2,a2
.loop_3:
	move.b	(a0)+,d0
	move.b	d0,(a1)+
	beq.s	.end_name
	cmp.b	#'.',d0
	bne.s	.loop_3
	move.l	a0,a2	;a2 -> pure extension
	bra.s	.loop_3
;
.end_name:
	move.l	a2,d0
	beq.s	.no_name
	lea	arg_ext_l,a1
	lea	-1(a2),a0
	moveq	#4-1,d0
.loop_4:
	move.b	(a0)+,(a1)+
	dbra	d0,.loop_4
	move	#2,next_arg
	bra.s	.exit
;
.no_arg:
	lea	main_path_s,a0
	move.l	a0,d0
	bsr	get_path
.no_name:
	clr	next_arg
.exit:
	lea	main_path_s,a0
	bsr	fix_path		;ensures a full path incl drivespec
	rts
;
;----------------------------------------------------------------------------
;
exec_APP:
	linea	#10			;hidem
;
	lea	clrblk_1_beg,A0
	move.l	#(clrblk_end-clrblk_1_beg)/4-1,D0
.clear_loop:
	clr.l	(A0)+
	subq.l	#1,D0
	bpl.s	.clear_loop
;
	move.l	SP,entry_USP
	gemdos	Super,!		;D0 = SSP,  SSP = USP
	move.l	d0,entry_SSP
	sub	#$100,SP	;reserve 256 bytes for temp sub usage
;
	move.l	(_sysbase).w,a0
	move.l	os_selfbeg_p(a0),a0
	move.l	os_version(a0),d0
	move.l	d0,TOS_version
;
	bsr	sync_fall_supx
	shi	entrylace_f
	bsr	small_lace_supx
	bsr	sync_lace_supx
;
	clr.b	STE_video_f
	cmpi.b	#$FF,$FFFF820d	;vbaselo
	sne	STE_video_f
	jsr	save_screenrez
	jsr	save_interrupt
	jsr	fix_type_paths
	jsr	T_8FAA
	jsr	T_8B56
;
	bsr	main_loop
;
	jsr	T_8B94
	jsr	rest_interrupt
	jsr	rest_screenrez
;
	tst	entrylace_f
	beq.s	.keep_small
	bsr	large_lace_supx
.keep_small:
	bsr	sync_lace_supx
	movea.l	entry_USP,SP		;restore SSP = USP of entry
	gemdos	Super|_ind,entry_SSP	;exit super mode & restore old SSP
	linea	#9			;showm
	linea	#9			;showm
	linea	#9			;showm
	linea	#9			;showm
	rts
;
;----------------------------------------------------------------------------
;
main_loop:
	lea	B_10F38,A0
	jsr	set_a0pi_color
	lea	clrblk_2_beg,A0
	move.l	#(clrblk_end-clrblk_2_beg)/4-1,D0
.clear_loop:
	clr.l	(A0)+
	subq.l	#1,D0
	bpl.s	.clear_loop
	tst	next_arg
	ble.s	.use_main_form
	move.l	arg_ext_l,d0
	moveq	#1,d1
	cmp.l	#'.TGA',d0
	beq.s	.use_arg
	moveq	#2,d1
	cmp.l	#'.RAW',d0
	beq.s	.use_arg
	moveq	#3,d1
	cmp.l	#'.GIF',d0
	beq.s	.use_arg
	moveq	#4,d1
	cmp.l	#'.IFF',d0
	beq.s	.use_arg
	moveq	#5,d1
	cmp.l	#'.PI1',d0
	bne.s	.use_main_form
.use_arg:
	move	d1,click_object
	bra.s	.done_main_form
;
.use_main_form:
	bsr	main_form_sub
	cmpi	#9,click_object
	beq	QuitProg_jump
	cmpi	#6,click_object
	beq	help_command
.done_main_form:
	move	click_object,src_file_obj
	jsr	set_path_s_src
	bsr	dest_form_sub
	move	click_object,dest_file_obj
	sf	dither_type
	cmpi	#1,dest_file_obj
	beq.s	ask_C_H_F
	cmpi	#3,dest_file_obj
	beq.s	ask_C_H_F
;src_file_type is defined as... 0=TGA  1=IFF  2=GIF  3=RAW  4=PI1
	cmpi.b	#0,src_file_type	;TGA src
	beq.s	ask_C_H_F
	cmpi.b	#2,src_file_type	;GIF src
	beq.s	ask_C_H_F
	cmpi.b	#3,src_file_type	;RAW src
	bne.s	skip_C_H_F
;
;NB: original assumed that all IFF's have 320x200 format, which is false !!!
;
ask_C_H_F:
	bsr	C_H_F_form_sub
	cmpi	#2,click_object
	bne.s	T_136
	move.b	#1,dither_type
T_136:
	cmpi	#3,click_object
	bne.s	skip_C_H_F
	move.b	#2,dither_type
skip_C_H_F:
	sf	legal_colour_f
	cmpi	#1,dest_file_obj
	beq.s	T_162
	cmpi	#2,dest_file_obj
	bne.s	T_174
T_162:
	bsr	legal_form_sub
	cmpi	#1,click_object
	seq	legal_colour_f
T_174:
	sf	flicker_free_f
	cmpi	#5,dest_file_obj
	beq.s	T_196
	cmpi	#6,dest_file_obj
	bne.s	T_1A8
	tst.b	sync_command
	beq.s	T_1A8
T_196:
	bsr	optim_form_sub
	cmpi	#2,click_object
	seq	flicker_free_f
T_1A8:
	move.b	#0,mouse_work_f
	move	#2,vbi_counter
T_1B8:
	tst	vbi_counter
	bne.s	T_1B8
	jsr	clear_32000_i_T_8D64
	jsr	copy_32000_i_T_8D64_i_T_8D68
	move	src_file_obj(PC),click_object
;
	jsr	fsel_and_load		;select and load file
	tst	intout+2
	beq	main_loop
	tst.l	D0
	bne	load_error
;
	lea	B_10F38,A0
	jsr	set_a0pi_color
	cmpi.b	#2,src_file_type	;GIF src ?
	bne	unscaled_noGIF
	move.l	#B_1C678,D_10A54
	cmpi	#320,orig_width
	blt.s	.cut_GIF
	cmpi	#200,orig_height
	blt.s	.cut_GIF
	cmpi	#320,orig_width
	bne.s	.ask_scale
	cmpi	#200,orig_height
	beq	squash_GIF
.ask_scale:
	bsr	scale_form_sub
	movem.l	B_10F38,D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	cmpi	#1,click_object		;squash GIF ?
	beq	squash_GIF
.cut_GIF:
	bsr	cut_gif_calc
	movem.l	T_161E,D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	clr	T_402
	clr	T_404
	jsr	empty_keyboard
.cut_gif_move:
	move	orig_width(pc),D1
	addi	#15,D1
	andi	#-$10,D1
	lsr	#1,D1
	move	D1,D2
	mulu	T_404(pc),D1
	movea.l	D_10A54,A0
	move	T_402(pc),D0
	lsr	#4,D0
	lsl	#3,D0
	adda	D0,A0
	adda.l	D1,A0
	movea.l	T_8D68,A1
	move	#200-1,D0
.cut_move_loop:
	movea.l	A0,A2
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	move.l	(A2)+,(A1)+
	adda	D2,A0
	dbra	D0,.cut_move_loop
.cut_gif_loop:
	addq	#1,vbi_counter
.key_delay:
	tst	vbi_counter
	bne.s	.key_delay
	bsr	Crawio_sub	;d0 = ascii, or -1 if no key pressed
	tst.b	D0
	bmi.s	.cut_gif_loop
	cmp.b	#CR,D0		;Return/Enter ?
	beq	cut_GIF_execute		;perform cut on Return/Enter
	cmp.b	#' ',D0		;spacebar ?
	beq	cut_GIF_execute		;perform cut on spacebar
	cmp.b	#'S',D0		;'S' ?
	beq	cut_GIF_execute		;perform cut on 'S'
	cmp.b	#'s',D0		;'s' ?
	beq	cut_GIF_execute		;perform cut on 's'
	cmp.b	#ESC,d0		;Escape ?
	beq.s	.escape_cut	;Escape => Exit without save
	swap	d0		;d0 = scancode
	cmp.b	#$61,d0		;UNDO ?
	beq.s	.escape_cut	;UNDO => Exit without save
	cmp.b	#$48,D0		;cur_up ?
	beq.s	.cut_GIF_move_up
	cmp.b	#$50,D0		;cur_down ?
	beq.s	.cut_GIF_move_down
	cmp.b	#$4B,D0		;cur_left ?
	beq.s	.cut_GIF_move_left
	cmp.b	#$4D,D0		;cur_right ?
	beq.s	.cut_GIF_move_right
	bra.s	.cut_gif_loop	;loop back for new key
;
.escape_cut:
	clr.b	T_E36
	bra	display_done
;
.cut_GIF_move_up:
	subq	#1,T_404
	bpl.s	.T_338
	clr	T_404
.T_338:
	bra	.cut_gif_move
;
.cut_GIF_move_down:
	addq	#1,T_404
	move	orig_height(pc),D0
	subi	#$C8,D0
	cmp.w	T_404(pc),D0
	bge.s	.T_35A
	move	D0,T_404
.T_35A:
	bra	.cut_gif_move
;
.cut_GIF_move_left:
	subi	#$10,T_402
	bpl.s	.T_36E
	clr	T_402
.T_36E:
	bra	.cut_gif_move
;
.cut_GIF_move_right:
	addi	#$10,T_402
	move	orig_width(pc),D0
	subi	#320,D0
	cmp.w	T_402(pc),D0
	bge.s	.T_392
	move	D0,T_402
.T_392:
	bra	.cut_gif_move
;
cut_GIF_execute:
	bsr	cut_GIF_sub
	bra.s	done_scale_GIF
;
squash_GIF:
	bsr	squash_GIF_sub
done_scale_GIF:
	move.b	#3,src_file_type	;simulate RAW src
	move.l	#B_4B480,D_10A54
unscaled_noGIF:
	cmpi.b	#0,src_file_type	;TGA src ?
	bne	T_3C6			;if so, keep src_file_type
	move.b	#3,src_file_type	;simulate RAW src
T_3C6:
	move.b	#0,mouse_work_f
	bsr	T_E38
	jsr	T_8BA6
	bsr	display_image
	jsr	T_8BB6
display_done:
	lea	B_10F38,A0
	jsr	set_a0pi_color
	tst.b	T_E36
	beq	main_loop
	jsr	fsel_and_save
	bra	main_loop
;
T_402:
	dc.w	$0000			;
T_404:
	dc.w	$0000			;
;
;----------------------------------------------------------------------------
;
QuitProg_jump:
	rts
;
;----------------------------------------------------------------------------
;
help_command:
	lea	B_10F38,A0
	jsr	set_a0pi_color
	clr.b	mouse_work_f
	move	#1,vbi_counter
T_426:
	tst	vbi_counter
	bne.s	T_426
	move.b	#1,$FFFF8260.w		;shiftmd
	clr.b	mouse_work_f
	move	#1,vbi_counter
T_442:
	tst	vbi_counter
	bne.s	T_442
	movem.l	B_10F38,D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	move.b	#1,$FFFF8260.w		;shiftmd
	move	#1,vbi_counter
T_466:
	tst	vbi_counter
	bne.s	T_466
	move.b	#0,$FFFF8260.w		;shiftmd
	jsr	clear_32000_i_T_8D64
	jsr	copy_32000_i_T_8D64_i_T_8D68
	lea	ICE_block_13,A0
	movea.l	T_8D64,A1
	jsr	ICE_unpack
	movea.l	T_8D64,A0
	jsr	FORM_unpack
	jsr	set_FORM_color
T_4A4:
	bsr	Crawio_sub
	cmp.b	#$20,D0
	bne.s	T_4A4
	lea	B_10F38,A0
	jsr	set_a0pi_color
	move	#1,vbi_counter
T_4C2:
	tst	vbi_counter
	bne.s	T_4C2
	move.b	#0,$FFFF8260.w		;shiftmd
	bra	main_loop
;
;----------------------------------------------------------------------------
;
main_form_sub:
	clr.b	mouse_work_f
	move.l	#main_frect_t,mouse_rect_ptp
	clr.b	mouse_work_f
	move	#1,vbi_counter
T_4F2:
	tst	vbi_counter
	bne.s	T_4F2
	movem.l	B_10F38,D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	move.b	#1,$FFFF8260.w		;shiftmd
	move	#1,vbi_counter
T_516:
	tst	vbi_counter
	bne.s	T_516
	move.b	#0,$FFFF8260.w		;shiftmd
	jsr	clear_32000_i_T_8D64
	jsr	copy_32000_i_T_8D64_i_T_8D68
	lea	ICE_block_5,A0
	movea.l	T_8D64,A1
	jsr	ICE_unpack
	movea.l	T_8D64,A0
	jsr	FORM_unpack
	jsr	set_FORM_color
	move.b	#1,mouse_work_f
T_55C:
	clr	click_object
T_562:
	tst	click_object
	beq.s	T_562
	cmpi	#7,click_object
	bne.s	T_5A6
	move.b	#2,sync_command
	move	#1,vbi_counter
T_584:
	tst	vbi_counter
	bne.s	T_584
	not.w	(hw_pal).w		;color0
	move	#1,vbi_counter
T_598:
	tst	vbi_counter
	bne.s	T_598
	not.w	(hw_pal).w		;color0
	bra.s	T_55C
;
T_5A6:
	cmpi	#8,click_object
	bne.s	T_5E4
	move.b	#0,sync_command
	move	#1,vbi_counter
T_5C0:
	tst	vbi_counter
	bne.s	T_5C0
	not.w	(hw_pal).w		;color0
	move	#1,vbi_counter
T_5D4:
	tst	vbi_counter
	bne.s	T_5D4
	not.w	(hw_pal).w		;color0
	bra	T_55C
;
T_5E4:
	rts
;
;----------------------------------------------------------------------------
;
dest_form_sub:
	clr.b	mouse_work_f
	move.l	#dest_frect_t,mouse_rect_ptp
	pea	ICE_block_7
	move	#1,vbi_counter
.T_712:
	tst	vbi_counter
	bne.s	.T_712
	movem.l	B_10F38,D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	move.b	#1,$FFFF8260.w		;shiftmd
	move	#1,vbi_counter
.T_736:
	tst	vbi_counter
	bne.s	.T_736
	move.b	#0,$FFFF8260.w		;shiftmd
	jsr	clear_32000_i_T_8D64
	jsr	copy_32000_i_T_8D64_i_T_8D68
	move.l	(sp)+,a0
	movea.l	T_8D64,A1
	jsr	ICE_unpack
	movea.l	T_8D64,A0
	jsr	FORM_unpack
	jsr	set_FORM_color
T_774:
	move.b	#1,mouse_work_f
	clr	click_object
T_782:
	tst	click_object
	beq.s	T_782
	rts
;
;----------------------------------------------------------------------------
;
C_H_F_form_sub:
	clr.b	mouse_work_f
	move.l	#C_H_F_frect_t,mouse_rect_ptp
	clr.b	mouse_work_f
	move	#1,vbi_counter
T_7AA:
	tst	vbi_counter
	bne.s	T_7AA
	movem.l	B_10F38,D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	move.b	#1,$FFFF8260.w		;shiftmd
	move	#1,vbi_counter
T_7CE:
	tst	vbi_counter
	bne.s	T_7CE
	move.b	#0,$FFFF8260.w		;shiftmd
	jsr	clear_32000_i_T_8D64
	jsr	copy_32000_i_T_8D64_i_T_8D68
	lea	ICE_block_9,A0
	movea.l	T_8D64,A1
	jsr	ICE_unpack
	movea.l	T_8D64,A0
	jsr	FORM_unpack
	jsr	set_FORM_color
	move.b	#1,mouse_work_f
	clr	click_object
T_81A:
	tst	click_object
	beq.s	T_81A
	rts
;
;----------------------------------------------------------------------------
;
legal_form_sub:
	clr.b	mouse_work_f
	move.l	#legal_frect_t,mouse_rect_ptp
	clr.b	mouse_work_f
	move	#1,vbi_counter
T_842:
	tst	vbi_counter
	bne.s	T_842
	movem.l	B_10F38,D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	move.b	#1,$FFFF8260.w		;shiftmd
	move	#1,vbi_counter
T_866:
	tst	vbi_counter
	bne.s	T_866
	move.b	#0,$FFFF8260.w		;shiftmd
	jsr	clear_32000_i_T_8D64
	jsr	copy_32000_i_T_8D64_i_T_8D68
	lea	ICE_block_10,A0
	movea.l	T_8D64,A1
	jsr	ICE_unpack
	movea.l	T_8D64,A0
	jsr	FORM_unpack
	jsr	set_FORM_color
	move.b	#1,mouse_work_f
	clr	click_object
T_8B2:
	tst	click_object
	beq.s	T_8B2
	rts
;
;----------------------------------------------------------------------------
;
optim_form_sub:
	clr.b	mouse_work_f
	move.l	#optim_frect_t,mouse_rect_ptp
	clr.b	mouse_work_f
	move	#1,vbi_counter
T_8DA:
	tst	vbi_counter
	bne.s	T_8DA
	movem.l	B_10F38,D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	move.b	#1,$FFFF8260.w		;shiftmd
	move	#1,vbi_counter
T_8FE:
	tst	vbi_counter
	bne.s	T_8FE
	move.b	#0,$FFFF8260.w		;shiftmd
	jsr	clear_32000_i_T_8D64
	jsr	copy_32000_i_T_8D64_i_T_8D68
	lea	ICE_block_11,A0
	movea.l	T_8D64,A1
	jsr	ICE_unpack
	movea.l	T_8D64,A0
	jsr	FORM_unpack
	jsr	set_FORM_color
	move.b	#1,mouse_work_f
	clr	click_object
T_94A:
	tst	click_object
	beq.s	T_94A
	rts
;
;----------------------------------------------------------------------------
;
scale_form_sub:
	move.b	mouse_work_f,-(SP)
	clr.b	mouse_work_f
	move.l	#scale_frect_t,mouse_rect_ptp
	clr.b	mouse_work_f
	move	#1,vbi_counter
T_978:
	tst	vbi_counter
	bne.s	T_978
	movem.l	B_10F38,D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	move.b	#1,$FFFF8260.w		;shiftmd
	move	#1,vbi_counter
T_99C:
	tst	vbi_counter
	bne.s	T_99C
	move.b	#0,$FFFF8260.w		;shiftmd
	jsr	clear_32000_i_T_8D64
	jsr	copy_32000_i_T_8D64_i_T_8D68
	lea	ICE_block_12,A0
	movea.l	T_8D64,A1
	jsr	ICE_unpack
	movea.l	T_8D64,A0
	jsr	FORM_unpack
	jsr	set_FORM_color
	move.b	#1,mouse_work_f
	clr	click_object
T_9E8:
	tst	click_object
	beq.s	T_9E8
	move.b	(SP)+,mouse_work_f
	rts
;
;
load_error:
	bra	main_loop
;
;----------------------------------------------------------------------------
;
squash_GIF_sub:
;
	move	#320,D2		;new picture width
	move	orig_width,D3
	ext.l	D2		;d2 = 320
	ext.l	D3		;d3 = orig_width
	asr.l	#1,D2		;d2 = 320/2
	asr.l	#1,D3		;d3 = orig_width/2
	asl.l	#8,D2		;d2 = (320/2)*256
	divs	D3,D2		;d2 = ((320/2)*256)/(orig_width/2)
	ext.l	D2
	swap	D2
	asr.l	#8,D2
	move	D2,D4
	swap	D2
	move	D2,T_CC0
	move	D4,T_CC2
;
	move	#200,D2
	move	orig_height,D3
	ext.l	D2
	ext.l	D3
	asr.l	#1,D2
	asr.l	#1,D3
	asl.l	#8,D2
	divs	D3,D2
	ext.l	D2
	swap	D2
	asr.l	#8,D2
	move	D2,D4
	swap	D2
	move	D2,T_CC4
	move	D4,T_CC6
;
	movea.l	T_1612,A2
	lea	B_11858,A3
	movea.l	D_10A54,A1
	move.b	#$33,(A1)+
	move.b	#$32,(A1)+
	move.b	#$30,(A1)+
	move.b	#$20,(A1)+
	move.b	#$32,(A1)+
	move.b	#$30,(A1)+
	move.b	#$30,(A1)+
	move.b	#10,(A1)+
	movem.l	D0-A6,-(SP)
	move.l	#$2EE00,D0
.T_A90:
	clr.b	(A1)+
	subq.l	#1,D0
	bne.s	.T_A90
	movem.l	(SP)+,D0-A6
	movea.l	A1,A0
	moveq	#0,D0
	moveq	#0,D1
	moveq	#0,D3
	move	orig_height,D7
	subq	#1,D7
T_AAA:
	move	D7,-(SP)
	move	D0,-(SP)
	move	D3,-(SP)
	move	T_CC0,D2
	move	T_CC2,D4
	moveq	#0,D0
	moveq	#0,D3
	move	orig_width,D6
	subq	#1,D6
T_AC8:
	move	D6,-(SP)
	moveq	#0,D1
	moveq	#0,D5
	moveq	#0,D6
	move.b	(A2)+,D1
	move	D1,D5
	add	D5,D5
	add	D1,D5
	move	D0,D1
	add	D1,D1
	add	D0,D1
	moveq	#0,D7
	move.b	0(A3,D5.l),D7
	move.b	0(A1,D1.l),D6
	beq.s	.T_AEE
	add	D6,D7
	lsr	#1,D7
.T_AEE:
	move.b	D7,0(A1,D1.l)
	moveq	#0,D7
	move.b	1(A3,D5.l),D7
	move.b	1(A1,D1.l),D6
	beq.s	.T_B02
	add	D6,D7
	lsr	#1,D7
.T_B02:
	move.b	D7,1(A1,D1.l)
	moveq	#0,D7
	move.b	2(A3,D5.l),D7
	move.b	2(A1,D1.l),D6
	beq.s	.T_B16
	add	D6,D7
	lsr	#1,D7
.T_B16:
	move.b	D7,2(A1,D1.l)
	add	D4,D3
	addx	D2,D0
	move	(SP)+,D6
	dbra	D6,T_AC8
	move	(SP)+,D3
	move	(SP)+,D0
	move	T_CC4,D2
	move	T_CC6,D4
	add	D4,D3
	addx	D2,D0
	move	D0,D5
	mulu	#$3C0,D5
	movea.l	A0,A1
	adda.l	D5,A1
	move	(SP)+,D7
	dbra	D7,T_AAA
	rts
;
;----------------------------------------------------------------------------
;
	move	orig_width,D2
	move	#$140,D3
	ext.l	D2
	ext.l	D3
	lsl.l	#8,D2
	divs	D3,D2
	ext.l	D2
	swap	D2
	asr.l	#8,D2
	move	D2,D4
	swap	D2
	move	D2,T_CC0
	move	D4,T_CC2
	move	orig_height,D2
	move	#$C8,D3
	ext.l	D2
	ext.l	D3
	lsl.l	#8,D2
	divs	D3,D2
	ext.l	D2
	swap	D2
	asr.l	#8,D2
	move	D2,D4
	swap	D2
	move	D2,T_CC4
	move	D4,T_CC6
	movea.l	T_1612,A0
	movea.l	A0,A2
	lea	B_11858,A3
	movea.l	D_10A54,A1
	move.b	#$33,(A1)+
	move.b	#$32,(A1)+
	move.b	#$30,(A1)+
	move.b	#$20,(A1)+
	move.b	#$32,(A1)+
	move.b	#$30,(A1)+
	move.b	#$30,(A1)+
	move.b	#10,(A1)+
	moveq	#0,D0
	moveq	#0,D1
	moveq	#0,D3
	move	#$C7,D7
T_BD8:
	move	D0,-(SP)
	move	D3,-(SP)
	move	T_CC0,D2
	move	T_CC2,D4
	moveq	#0,D0
	moveq	#0,D3
	move	#$13F,D6
T_BF0:
	move.b	0(A2,D0.w),D1
	add	D4,D3
	addx	D2,D0
	move	D1,D5
	add	D5,D5
	add	D1,D5
	move.b	0(A3,D5.w),(A1)+
	move.b	1(A3,D5.w),(A1)+
	move.b	2(A3,D5.w),(A1)+
	dbra	D6,T_BF0
	move	(SP)+,D3
	move	(SP)+,D0
	move	T_CC4,D2
	move	T_CC6,D4
	add	D4,D3
	addx	D2,D0
	move	D0,D5
	mulu	orig_width,D5
	movea.l	A0,A2
	adda.l	D5,A2
	dbra	D7,T_BD8
	rts
;
;----------------------------------------------------------------------------
;
cut_GIF_sub:
	movea.l	T_1612,A0
	move	T_402,D0
	adda	D0,A0
	move	T_404,D0
	mulu	orig_width,D0
	adda.l	D0,A0
	movea.l	A0,A2
	lea	B_11858,A3
	movea.l	D_10A54,A1
	move.b	#$33,(A1)+
	move.b	#$32,(A1)+
	move.b	#$30,(A1)+
	move.b	#$20,(A1)+
	move.b	#$32,(A1)+
	move.b	#$30,(A1)+
	move.b	#$30,(A1)+
	move.b	#10,(A1)+
	moveq	#0,D0
	move	orig_height,d4
	sub	#200,d4
	blt.s	.pad_height
	move	orig_width,d5
	sub	#320,d5
	blt.s	.pad_width
	move	#200-1,D7
.next_line:
	move	#320-1,D6
.next_pixel:
	clr	d0
	move.b	(a2)+,d0
	move	d0,d1
	add	D0,D0
	add	D1,D0
	move.b	0(A3,D0),(A1)+
	move.b	1(A3,D0),(A1)+
	move.b	2(A3,D0),(A1)+
	dbra	D6,.next_pixel		;loop back per pixel
	adda	D5,A2
	dbra	D7,.next_line		;loop back per line
	rts
;
.pad_height:
	neg.w	d4			;d4 = vertical pads needed
	subq	#1,d4			;d4 = adapted for dbra
	move	orig_width,d5
	sub	#320,d5
	blt	.pad_dual
	move	orig_height,D7
	subq	#1,d7
.ph_next_line:
	move	#320-1,D6
.ph_next_pixel:
	clr	d0
	move.b	(a2)+,d0
	move	d0,d1
	add	D0,D0
	add	D1,D0
	move.b	0(A3,D0),(A1)+
	move.b	1(A3,D0),(A1)+
	move.b	2(A3,D0),(A1)+
	dbra	D6,.ph_next_pixel	;loop back per pixel
	adda	D5,A2
	dbra	D7,.ph_next_line	;loop back per line
.ph_pad_line:
	move	#320-1,D6
.ph_pad_pixel:
	clr.b	(a1)+
	clr.b	(a1)+
	clr.b	(a1)+
	dbra	d6,.ph_pad_pixel
	dbra	d4,.ph_pad_line
	rts
;
.pad_width:
	neg	d5			;d5 = horizontal pads needed
	move	d5,d4
	lsr	#1,d4			;d4 = left pads needed
	sub	d4,d5			;d5 = right pads needed
	subq	#1,d4			;d4 = adapted for dbra
	subq	#1,d5			;d5 = adapted for dbra
	move	#200-1,D7
.pw_next_line:
	move	d4,d6
.pw_pad_pixel_1:
	clr.b	(a1)+
	clr.b	(a1)+
	clr.b	(a1)+
	dbra	d6,.pw_pad_pixel_1
	move	orig_width,D6
	subq	#1,d6
.pw_next_pixel:
	clr	d0
	move.b	(a2)+,d0
	move	d0,d1
	add	D0,D0
	add	D1,D0
	move.b	0(A3,D0),(A1)+
	move.b	1(A3,D0),(A1)+
	move.b	2(A3,D0),(A1)+
	dbra	D6,.pw_next_pixel		;loop back per pixel
	move	d5,d6
.pw_pad_pixel_2:
	clr.b	(a1)+
	clr.b	(a1)+
	clr.b	(a1)+
	dbra	d6,.pw_pad_pixel_2
	dbra	D7,.pw_next_line	;loop back per line
	rts
;
.pad_dual:
	neg	d5			;d5 = horizontal pads needed
	move	d5,d3
	lsr	#1,d3			;d3 = left pads needed
	sub	d3,d5			;d5 = right pads needed
	subq	#1,d3			;d3 = adapted for dbra
	subq	#1,d5			;d5 = adapted for dbra
	move	orig_height,D7
	subq	#1,d7
.pd_next_line:
	move	d3,d6
.pd_pad_pixel_1:
	clr.b	(a1)+
	clr.b	(a1)+
	clr.b	(a1)+
	dbra	d6,.pd_pad_pixel_1
	move	orig_width,D6
	subq	#1,d6
.pd_next_pixel:
	clr	d0
	move.b	(a2)+,d0
	move	d0,d1
	add	D0,D0
	add	D1,D0
	move.b	0(A3,D0),(A1)+
	move.b	1(A3,D0),(A1)+
	move.b	2(A3,D0),(A1)+
	dbra	D6,.pd_next_pixel	;loop back per pixel
	move	d5,d6
.pd_pad_pixel_2:
	clr.b	(a1)+
	clr.b	(a1)+
	clr.b	(a1)+
	dbra	d6,.pd_pad_pixel_2
	dbra	D7,.pd_next_line	;loop back per line
.pd_pad_line:
	move	#320-1,D6
.pd_pad_pixel_3:
	clr.b	(a1)+
	clr.b	(a1)+
	clr.b	(a1)+
	dbra	d6,.pd_pad_pixel_3
	dbra	d4,.pd_pad_line
	rts
;
;
;----------------------------------------------------------------------------
;
T_CC0:
	dc.w	0
T_CC2:
	dc.w	0
T_CC4:
	dc.w	0
T_CC6:
	dc.w	0
;
;----------------------------------------------------------------------------
;
display_image:
	clr.b	sync_request
	move.b	(hw_syn).w,-(SP)	;syncmode
	st	T_E36
	tst.b	T_1074
	bne.s	.T_CEA
	cmpi.b	#3,src_file_type	;RAW mode ?
	bne.s	.T_CF6
.T_CEA:
	move.b	sync_command,sync_mode
	bra.s	.T_CFE
;
.T_CF6:
	move.b	#2,sync_mode
.T_CFE:
	move.b	sync_mode,(hw_syn).w	;syncmode
	move	#8,vbi_counter
.key_delay_1:
	tst	vbi_counter
	bne.s	.key_delay_1
	jsr	empty_keyboard
	bsr	T_869C
	move	#$2700,sr
	cmpi.b	#0,T_1075
	beq.s	.T_D42
	cmpi.b	#1,T_1075
	beq.s	.T_D42
	move.l	#T_299A,_vbl_list		;_vbl_list
	bra.s	.T_D4A
;
.T_D42:
	move.l	#T_8730,_vbl_list		;_vbl_list
.T_D4A:
	move	#$2300,sr
	move	#1,vbi_counter
.T_D56:
	tst	vbi_counter
	bne.s	.T_D56
	jsr	empty_keyboard
.next_key:
	addq	#1,vbi_counter
.key_delay_2:
	tst	vbi_counter
	bne.s	.key_delay_2
	bsr	Crawio_sub
	tst.b	D0
	bmi.s	.next_key
	cmp.b	#'*',D0			;'*' ?
	bne.s	.T_DB2
	movem.l	D0-A6,-(SP)
	bset	#7,sync_request
	move	#$2700,sr
	movem.l	B_10F38,D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	bchg	#1,(hw_syn).w		;syncmode
	moveq	#-1,D0
.T_DA6:
	dbra	D0,.T_DA6
	move	#$2300,sr
	movem.l	(SP)+,D0-A6
.T_DB2:
	cmp.b	#CR,D0		;Return/Enter ?
	beq.s	T_DD6		;Go save file on Return/Enter
	cmp.b	#$53,D0		;'S' ?
	beq.s	T_DD6		;Go save file on 'S'
	cmp.b	#$73,D0		;'s' ?
	beq.s	T_DD6		;Go save file on 's'
	cmp.b	#$20,D0		;spacebar ?
	beq.s	T_DD6		;Go save file on spacebar
	cmp.b	#ESC,D0		;Escape ?
	beq.s	T_DD0		;Exit without save on Escape
	swap	d0		;d0 = scancode
	cmp.b	#$61,D0		;UNDO ?
	beq.s	T_DD0		;exit without save on UNDO
	bra.s	.next_key	;loop back for new command if current illegal
;
;------------------------------------
;
T_DD0:
	sf	T_E36
T_DD6:
	move.b	(hw_syn).w,D7		;syncmode
	or.b	D7,sync_request
	bsr	T_86E6
	jsr	empty_keyboard
	lea	B_10F38,A0
	jsr	set_a0pi_color
	move.l	T_8D68,D0
	lsr	#8,D0
	move.l	D0,$FFFF8200.w
	move.b	(SP)+,(hw_syn).w	;syncmode
	move	#$14,vbi_counter
.T_E0E:
	tst	vbi_counter
	bne.s	.T_E0E
	rts
;
;----------------------------------------------------------------------------
;
Crawio_sub:
	gemdos	Cconis
	tst.l	D0
	beq.s	.T_E2E
	gemdos	Crawcin
	rts
;
.T_E2E:
	moveq	#-1,D0
	rts
;
;----------------------------------------------------------------------------
;
sync_request:
	dc.b	$0
sync_mode:
	dc.b	$0
src_file_obj:
	dc.b	$0,$0
T_E36:
	dc.b	$0,$0
;
;----------------------------------------------------------------------------
;
T_E38:
	move.b	#2,B_10ACD
	move.l	#B_17B58,T_8B14
	move.l	#B_17B58,T_8B18
	move.l	B_10AB0,T_8B1C
	move.l	B_10AB0,T_8B20
	sf	T_1074
	cmpi	#1,dest_file_obj
	bne.s	T_E82
	move.b	#0,T_1075
	bra.s	T_EFE
;
T_E82:
	cmpi	#2,dest_file_obj
	bne.s	T_E9E
	move.b	#1,T_1075
	move.b	#3,B_10ACD
	bra.s	T_EFE
;
T_E9E:
	cmpi	#3,dest_file_obj
	bne.s	T_EB2
	move.b	#2,T_1075
	bra.s	T_EFE
;
T_EB2:
	cmpi	#5,dest_file_obj
	bne.s	T_ECC
	move.b	#2,T_1075
	st	T_1074
	bra.s	T_EFE
;
T_ECC:
	cmpi	#4,dest_file_obj
	bne.s	T_EE8
	move.b	#3,T_1075
	move.b	#3,B_10ACD
	bra.s	T_EFE
;
T_EE8:
	move.b	#3,T_1075
	move.b	#3,B_10ACD
	st	T_1074
T_EFE:
	cmpi.b	#1,src_file_type
	beq	T_F92
	cmpi.b	#4,src_file_type
	beq	T_1004
	sf	T_1076
	lea	B_10F38,A0
	jsr	set_a0pi_color
	lea	B_1C678,A0
	move.l	D_10A54,B_10ABC
	bsr	T_1E9A
	bsr	T_214C
	tst.b	T_1074
	beq	T_1070
	st	T_1076
	move.l	T_8B1C,T_8B20
	move.l	T_8B14,T_8B18
	move.l	B_10AB4,T_8B1C
	move.l	#B_24678,T_8B14
	lea	B_1C678,A0
	move.l	D_10A54,B_10ABC
	bsr	T_1E9A
	bsr	T_214C
	bra	T_1070
;
T_F92:
	sf	T_1076
	move.l	D_10A54,B_10AB8
	lea	B_1C678,A0
	bsr	T_166A
	bsr	T_19B4
	lea	B_10F38,A0
	jsr	set_a0pi_color
	bsr	T_214C
	tst.b	T_1074
	beq	T_1070
	move.l	T_8B1C,T_8B20
	move.l	T_8B14,T_8B18
	move.l	B_10AB4,T_8B1C
	move.l	#B_24678,T_8B14
	st	T_1076
	bsr	T_1834
	bsr	T_19B4
	bsr	T_214C
	bra.s	T_1070
;
T_1004:
	sf	T_1076
	move.l	D_10A54,D0
	move.l	D0,B_10ABC
	bsr	T_1BE4
	lea	B_10F38,A0
	jsr	set_a0pi_color
	bsr	T_214C
	tst.b	T_1074
	beq.s	T_1070
	move.l	T_8B1C,T_8B20
	move.l	T_8B14,T_8B18
	move.l	B_10AB4,T_8B1C
	move.l	#B_24678,T_8B14
	move.l	D_10A54,B_10ABC
	st	T_1076
	bsr	T_1BE4
	bsr	T_214C
T_1070:
	rts
;
;----------------------------------------------------------------------------
;
dest_file_obj:
	dc.b	$0,$0
T_1074:
	dc.b	$0
T_1075:
	dc.b	$0
T_1076:
	dc.b	$0,$0
;
;----------------------------------------------------------------------------
;
load_GIF_sub:
	move.l	D_10A54,D0
	addi.l	#$2EE08,D0
	move.l	D0,T_160E
	move.l	#B_17B58,T_1616
	move.l	#$4000,T_161A
	gemdos	Fopen,load_pathname_s,!
	tst	D0
	bmi	T_14EC
	move	D0,T_163E
	gemdos	Fread,T_163E,#13,T_1650
	tst.l	D0
	ble	T_14DE
	move.b	T_165A,D0
	andi.b	#7,D0
	addq.b	#1,D0
	moveq	#1,D1
	lsl	D0,D1
	move	D1,T_1640
	mulu	#3,D1
	ext.l	D1
	gemdos	Fread,T_163E,d1,B_11458
	tst.l	D0
	ble	T_14DE
	lea	B_11458,A0
	lea	B_11858,A1
	move	T_1640,D0
	subq	#1,D0
T_112A:
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	dbra	D0,T_112A
	lea	B_11458,A0
	lea	B_11158,A1
	move	T_1640,D7
T_1146:
	subq	#1,D7
	blt.s	T_1168
	moveq	#0,D0
	move.b	(A0),D0
	clr.b	(A0)+
	lsl	#3,D0
	move.b	(A0),D0
	clr.b	(A0)+
	andi.b	#$E0,D0
	lsr.b	#1,D0
	move.b	(A0),D1
	clr.b	(A0)+
	lsr.b	#5,D1
	or.b	D1,D0
	move	D0,(A1)+
	bra.s	T_1146
;
T_1168:
	gemdos	Fread,T_163E,#11,T_165E
	tst.l	D0
	ble	T_14EC
	move.b	T_1666,D1
	lsl	#8,D1
	move.b	T_1665,D1
	move	D1,orig_height
	move.b	T_1664,D0
	lsl	#8,D0
	move.b	T_1663,D0
	move	D0,orig_width
	move	D0,D5
	move	D0,D2
	move	D0,D3
	andi	#-$10,D2
	lsr	#1,D2
	andi	#15,D3
	beq.s	T_11C6
	addq	#8,D2
T_11C6:
	move	D2,T_1648
	move.l	T_160E,D0
	addq.l	#8,D0
	movea.l	D0,A4
	move.l	D0,T_1612
	move	orig_height,T_1646
	btst	#6,T_1667
	beq.s	T_123C
	move	orig_width,D1
	move	D1,D0
	clr	T_15EA
	move	D0,T_15F0
	move	D0,T_15F8
	add	D0,D0
	move	D0,T_15EE
	add	D1,D0
	move	D0,T_15F6
	add	D1,D0
	move	D0,T_15EC
	add	D0,D0
	sub.w	D1,D0
	move	D0,T_15F4
	move	D0,T_15F2
	move.l	#T_15EA,T_160A
T_123C:
	suba.l	A6,A6
	suba.l	A5,A5
	move.b	T_1668,D0
	moveq	#1,D1
	lsl	D0,D1
	move	D1,T_164A
	addq.l	#1,D1
	move	D1,T_164C
	addq.l	#1,D1
	move	D1,T_164E
	subq	#3,D1
	lea	B_11B58,A0
	lea	B_13B58,A1
	lea	B_15B58,A2
T_1274:
	move.b	D1,0(A1,D1.w)
	add	D1,D1
	move	#-$1,0(A0,D1.w)
	lsr	#1,D1
	subq	#1,D1
	bge.s	T_1274
	bsr	T_153C
	clr	D6
	move.b	D0,D6
	clr.l	D4
	swap	D5
	clr	D5
	lea	B_11458,A3
	move	#$FF,D0
T_129E:
	clr.l	(A3)+
	dbra	D0,T_129E
	lea	B_11458,A3
T_12AA:
	swap	D7
	move.b	T_1668,D7
	addq.l	#1,D7
	move.l	#-$100000,D0
	rol.l	D7,D0
	swap	D6
	move	D0,D6
	swap	D6
	swap	D7
	move	T_164E,D7
	bsr	T_14F0
	clr.l	D3
	move	D0,D3
	cmp.w	T_164A,D3
	beq.s	T_12AA
	swap	D3
	swap	D5
	moveq	#0,D1
	subq	#1,D7
	bra.s	T_1358
;
T_12E4:
	bsr	T_14F0
	move	D0,D3
	cmp.w	T_164A,D0
	beq.s	T_12AA
	cmp.w	T_164C,D0
	beq	T_13C6
	cmp.w	D7,D0
	beq.s	T_131E
	clr	D1
	move.b	0(A1,D0.w),0(A2,D1.w)
T_1308:
	add	D0,D0
	move	0(A0,D0.w),D0
	bmi.s	T_131A
	addq	#1,D1
	move.b	0(A1,D0.w),0(A2,D1.w)
	bra.s	T_1308
;
T_131A:
	swap	D3
	bra.s	T_1342
;
T_131E:
	move	#1,D1
	swap	D3
	move	D3,D0
	move.b	0(A1,D0.w),0(A2,D1.w)
T_132C:
	add	D0,D0
	move	0(A0,D0.w),D0
	bmi.s	T_133E
	addq	#1,D1
	move.b	0(A1,D0.w),0(A2,D1.w)
	bra.s	T_132C
;
T_133E:
	move.b	0(A2,D1.w),(A2)
T_1342:
	move.b	0(A2,D1.w),0(A1,D7.w)
	add	D7,D7
	move	D3,0(A0,D7.w)
	lsr	#1,D7
	swap	D5
T_1352:
	clr	D0
	move.b	0(A2,D1.w),D0
T_1358:
	move.b	D0,(A4)+
	add	D0,D0
	add	D0,D0
	addq.l	#1,0(A3,D0.w)
	subq	#1,D5
	beq.s	T_1372
T_1366:
	dbra	D1,T_1352
	addq	#1,D7
	swap	D5
	bra	T_12E4
;
T_1372:
	move	orig_width,D5
	btst	#6,T_1667
	beq.s	T_1366
	clr.l	D0
	movea.l	T_160A,A3
	move	8(A3),D0
	adda.l	D0,A4
	move	$18(A3),D0
	sub.w	D0,T_1646
	bgt.s	T_13BE
	movea.l	T_1612,A4
	adda	2(A3),A4
	move	$12(A3),D0
	neg.w	D0
	add	orig_height,D0
	move	D0,T_1646
	addq.l	#2,T_160A
T_13BE:
	lea	B_11458,A3
	bra.s	T_1366
;
T_13C6:
	lea	T_161E,A0
	moveq	#0,D2
	moveq	#0,D3
	movem.l	D2-D3,(A0)
	movem.l	D2-D3,8(A0)
	movem.l	D2-D3,$10(A0)
	movem.l	D2-D3,$18(A0)
	move	T_1640,D7
	lea	B_11158,A1
	lea	B_11458,A2
T_13F8:
	moveq	#0,D0
	moveq	#0,D1
	move	T_1640,D6
T_1402:
	cmp.l	0(A2,D1.w),D0
	bgt.s	T_140E
	move	D1,D2
	move.l	0(A2,D1.w),D0
T_140E:
	addq	#4,D1
	subq	#1,D6
	bgt.s	T_1402
	move.l	#-1,0(A2,D2.w)
	lsr	#1,D2
	move	0(A1,D2.w),D0
	lea	T_161E,A0
	move	D3,D1
T_142A:
	tst	D1
	beq.s	T_1436
	cmp.w	(A0)+,D0
	beq.s	T_1440
	dbra	D1,T_142A
T_1436:
	move	D0,(A0)
	addq.b	#1,D3
	cmpi.b	#$10,D3
	beq.s	T_1444
T_1440:
	subq	#1,D7
	bgt.s	T_13F8
T_1444:
	lea	T_161E,A0
	move	#15,D0
T_144E:
	tst	(A0)+
	beq.s	T_1458
	dbra	D0,T_144E
	bra.s	T_1466
;
T_1458:
	move	T_161E,-$2(A0)
	clr	T_161E
T_1466:
	lea	T_161E,A0
	lea	B_11158,A1
	lea	B_11358,A2
	move	T_1640,D7
	add	D7,D7
T_1480:
	moveq	#0,D6
	move	#$FF,D0
T_1486:
	moveq	#0,D1
	move	0(A0,D6.w),D3
	move	-2(A1,D7.w),D4
	move	#2,D5
	lsl.l	#4,D3
	lsl.l	#4,D4
T_1498:
	lsr.b	#4,D3
	lsr.b	#4,D4
	sub.b	D4,D3
	move.b	D3,D2
	ext.w	D2
	muls	D2,D2
	add	D2,D1
	lsr	#4,D3
	lsr	#4,D4
	dbra	D5,T_1498
	cmp.w	D1,D0
	ble.s	T_14C0
	move	D1,D0
	lsr	#1,D6
	lsr	#1,D7
	move.b	D6,-1(A2,D7.w)
	add	D6,D6
	add	D7,D7
T_14C0:
	addq	#2,D6
	cmpi	#$20,D6
	blt.s	T_1486
	subq	#2,D7
	bne.s	T_1480
	gemdos	Fclose,T_163E
	moveq	#0,D0
	bra.s	T_14EE
;
T_14DE:
	gemdos	Fclose,T_163E
T_14EC:
	moveq	#-1,D0
T_14EE:
	rts
;
;
T_14F0:
	swap	D7
T_14F2:
	cmp.b	D7,D5
	bgt.s	T_1510
T_14F6:
	bsr.s	T_153C
	tst.l	D0
	bmi.s	T_1536
	subq	#1,D6
	bge.s	T_1508
	tst.b	D0
	beq.s	T_1536
	move	D0,D6
	bra.s	T_14F6
;
T_1508:
	lsl.l	D5,D0
	add.l	D0,D4
	addq.b	#8,D5
	bra.s	T_14F2
;
T_1510:
	swap	D6
	move	D4,D0
	lsr.l	D7,D4
	and	D6,D0
	sub.b	D7,D5
	swap	D7
	cmp.w	D6,D7
	bne.s	T_1532
	swap	D7
	cmpi.b	#12,D7
	beq.s	T_1530
	addq.b	#1,D7
	add	D6,D6
	bset	#0,D6
T_1530:
	swap	D7
T_1532:
	swap	D6
	rts
;
;
T_1536:
	addq.l	#4,SP
	bra	T_13C6
;
T_153C:
	cmpa.l	A5,A6
	bne.s	T_1582
	movem.l	D1-D2/A0-A2,-(SP)
	gemdos	Fread|_ind,T_163E,T_161A,T_1616
	movem.l	(SP)+,D1-D2/A0-A2
	movea.l	T_1616,A5
	movea.l	A5,A6
	adda.l	D0,A6
	tst.l	D0
	bne.s	T_1582
	move.l	T_161A,D0
	add.l	D0,T_A6CC
	moveq	#-1,D0
	rts
;
;
T_1582:
	clr.l	D0
	move.b	(A5)+,D0
	rts
;
;
cut_gif_calc:
	moveq	#0,D4
	movea.l	T_1612,A0
	lea	B_11358,A1
	movea.l	D_10A54,A2
	move	orig_height,D7
T_15A2:
	move	orig_width,D6
	moveq	#$10,D5
T_15AA:
	move.b	(A0)+,D4
	move.b	0(A1,D4.w),D4
	lsl.b	#4,D4
	add.b	D4,D4
	addx	D3,D3
	add.b	D4,D4
	addx	D2,D2
	add.b	D4,D4
	addx	D1,D1
	add.b	D4,D4
	addx	D0,D0
	subq.b	#1,D5
	bne.s	T_15CE
T_15C6:
	movem.w	D0-D3,(A2)
	addq	#8,A2
	moveq	#$10,D5
T_15CE:
	subq	#1,D6
	bne.s	T_15AA
	cmpi.b	#$10,D5
	beq.s	T_15E4
	lsl	D5,D0
	lsl	D5,D1
	lsl	D5,D2
	lsl	D5,D3
	addq	#1,D6
	bra.s	T_15C6
;
T_15E4:
	subq	#1,D7
	bne.s	T_15A2
	rts
;
;
T_15EA:
	dc.b	$0,$0
T_15EC:
	dc.b	$0,$0
T_15EE:
	dc.b	$0,$0
T_15F0:
	dc.b	$0,$0
T_15F2:
	dc.b	$0,$0
T_15F4:
	dc.b	$0,$0
T_15F6:
	dc.b	$0,$0
T_15F8:
	dc.b	$0,$0,$0,$0,$0,$4,$0,$2,$0,$1,$0,$8,$0,$8,$0
	dc.b	$4,$0,$2
T_160A:
	dc.b	$0,$0,$0,$0
T_160E:
	dc.b	$0,$0,$0,$0
T_1612:
	dc.b	$0,$0,$0,$0
T_1616:
	dc.b	$0,$0,$0,$0
T_161A:
	dc.b	$0,$0,$0,$0
T_161E:
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0
T_163E:
	dc.b	$0,$0
T_1640:
	dc.b	$0,$0
orig_width:
	dc.w	0
orig_height:
	dc.w	0
T_1646:
	dc.b	$0,$0
T_1648:
	dc.b	$0,$0
T_164A:
	dc.b	$0,$0
T_164C:
	dc.b	$0,$0
T_164E:
	dc.b	$0,$0
T_1650:
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
T_165A:
	dc.b	$0,$0,$0,$0
T_165E:
	dc.b	$0,$0,$0,$0,$0
T_1663:
	dc.b	$0
T_1664:
	dc.b	$0
T_1665:
	dc.b	$0
T_1666:
	dc.b	$0
T_1667:
	dc.b	$0
T_1668:
	dc.b	$0,$0
T_166A:
	move.l	A0,T_18D8
	move.l	#$43414D47,D0
	bsr	T_1898
	moveq	#0,D1
	tst	D0
	bmi.s	T_1684
	move.l	4(A0),D1
T_1684:
	move.l	D1,T_18E4
	move.l	#$424D4844,D0
	bsr	T_1898
	tst	D0
	bmi	T_1832
	move.b	14(A0),T_18E8
	move	4(A0),T_18E0
	move	6(A0),D0
	move	D0,T_18E2
	cmp.w	#$116,D0
	ble.s	T_16C8
	move.l	T_18E4(PC),D3
	bset	#3,D3
	move.l	D3,T_18E4
T_16C8:
	moveq	#0,D0
	move.b	12(A0),D0
	move	D0,T_18DC
	move	D0,T_18D4
	sf	T_18E9
	moveq	#1,D1
	lsl	D0,D1
	cmp.w	#$20,D1
	ble.s	T_16F8
	cmp.w	#6,D0
	bne.s	T_16F8
	moveq	#$20,D1
	st	T_18E9
T_16F8:
	move	D1,T_18DE
	move	D1,T_18D6
	add	D0,D0
	move	D0,T_18EA
	move.l	#$424F4459,D0
	bsr	T_1898
	tst	D0
	bmi	T_1832
	addq	#4,A0
	movea.l	B_10AB8,A1
	movea.l	A1,A5
	move	T_18E2(PC),D0
	subq	#1,D0
	bmi	T_1832
	lea	T_181E(PC),A4
	tst.b	T_18E8
	beq.s	T_1740
	lea	T_17D2(PC),A4
T_1740:
	move.l	T_18E4(PC),D3
	move	T_18E0(PC),D3
	lsr	#3,D3
	mulu	T_18DC(PC),D3
	move	D3,T_177A
T_1754:
	move	T_18DC(PC),D3
	subq	#1,D3
	moveq	#0,D4
T_175C:
	lea	0(A1,D4.w),A2
	addq	#2,D4
	jsr	(A4)
	dbra	D3,T_175C
	adda	T_177A(PC),A1
	dbra	D0,T_1754
	move.l	A1,B_10ABC
	bra	T_1834
;
T_177A:
	dc.w	$0000			;
	move	T_18E0(PC),D3
	lsr	#3,D3
	mulu	T_18DC(PC),D3
	move	D3,T_17CE
	move	D3,T_17D0
T_1792:
	move	T_18DC(PC),D3
	subq	#1,D3
	moveq	#0,D4
T_179A:
	lea	0(A1,D4.w),A2
	addq	#2,D4
	jsr	(A4)
	dbra	D3,T_179A
	adda	T_17CE(PC),A1
	move	T_18DC(PC),D3
	subq	#1,D3
	moveq	#0,D4
T_17B2:
	lea	0(A5,D4.w),A2
	addq	#2,D4
	jsr	(A4)
	dbra	D3,T_17B2
	adda	T_17D0(PC),A5
	dbra	D0,T_1792
	move.l	A5,B_10ABC
	bra.s	T_1834
;
T_17CE:
	dc.w	$0000			;
T_17D0:
	dc.w	$0000			;
T_17D2:
	lea	T_18EC(PC),A3
	move	T_18E0(PC),D6
	lsr	#3,D6
T_17DC:
	move.b	(A0)+,D7
	ext.w	D7
	bmi.s	T_17EE
T_17E2:
	move.b	(A0)+,(A3)+
	subq	#1,D6
	ble.s	T_1804
	dbra	D7,T_17E2
	bra.s	T_17DC
;
T_17EE:
	cmp.w	#-$80,D7
	beq.s	T_1804
	neg.w	D7
	move.b	(A0)+,D5
T_17F8:
	move.b	D5,(A3)+
	subq	#1,D6
	ble.s	T_1804
	dbra	D7,T_17F8
	bra.s	T_17DC
;
T_1804:
	lea	T_18EC(PC),A3
	move	T_18EA(PC),D5
	move	T_18E0(PC),D6
	lsr	#4,D6
	subq	#1,D6
T_1814:
	move	(A3)+,(A2)
	adda	D5,A2
	dbra	D6,T_1814
	rts
;
;
T_181E:
	move	T_18EA(PC),D5
	move	T_18E0(PC),D6
	lsr	#4,D6
	subq	#1,D6
T_182A:
	move	(A0)+,(A2)
	adda	D5,A2
	dbra	D6,T_182A
T_1832:
	rts
;
;
T_1834:
	move.l	#$434D4150,D0
	bsr.s	T_1898
	tst	D0
	bmi.s	T_1832
	addq	#4,A0
	pea	(A0)
	moveq	#0,D7
	lea	B_10F58,A1
	bsr.s	T_1864
	movea.l	(SP)+,A0
	tst.b	T_18E9
	beq.s	T_1862
	moveq	#1,D7
	lea	B_10F98,A1
	bsr.s	T_1864
T_1862:
	rts
;
;
T_1864:
	move	T_18DE(PC),D0
	subq	#1,D0
T_186A:
	moveq	#0,D1
	moveq	#0,D2
	moveq	#0,D3
	move.b	(A0)+,D3
	move.b	(A0)+,D2
	move.b	(A0)+,D1
	lsr	D7,D1
	lsr	D7,D2
	lsr	D7,D3
	andi	#$F0,D1
	andi	#$F0,D2
	andi	#$F0,D3
	lsl	#4,D3
	lsr	#4,D1
	or	D1,D2
	or	D2,D3
	move	D3,(A1)+
	dbra	D0,T_186A
	rts
;
;
T_1898:
	movea.l	T_18D8(PC),A0
	move	#$3FF,D7
	move.l	D0,D1
	lsr.l	#8,D1
	move.l	D1,D2
	lsr.l	#8,D2
	move.l	D2,D3
	lsr.l	#8,D3
T_18AC:
	cmp.b	(A0),D3
	bne.s	T_18C2
	cmp.b	1(A0),D2
	bne.s	T_18C2
	cmp.b	2(A0),D1
	bne.s	T_18C2
	cmp.b	3(A0),D0
	beq.s	T_18CC
T_18C2:
	addq	#1,A0
	dbra	D7,T_18AC
	moveq	#-1,D0
	bra.s	T_18D2
;
T_18CC:
	addq	#4,A0
	moveq	#0,D0
	tst	D0
T_18D2:
	rts
;
;
T_18D4:
	dc.b	$0,$0
T_18D6:
	dc.b	$0,$0
T_18D8:
	dc.b	$0,$0,$0,$0
T_18DC:
	dc.b	$0,$0
T_18DE:
	dc.b	$0,$0
T_18E0:
	dc.b	$0,$0
T_18E2:
	dc.b	$0,$0
T_18E4:
	dc.b	$0,$0,$0,$0
T_18E8:
	dc.b	$0
T_18E9:
	dc.b	$0
T_18EA:
	dc.b	$0,$0
T_18EC:
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0
T_19B4:
	bsr	set_new_ints
	bsr	T_8E04
	movea.l	B_10AB8,A0
	lea	B_10F58,A1
	movea.l	B_10ABC,A2
	move.l	T_18E4(PC),D3
	btst	#11,D3
	bne	T_1A96
	move	T_18D4(PC),D0
	move	D0,D6
	add	D6,D6
	move	D6,T_1A90
	move	D0,D6
	move	T_18E0(PC),D7
	lsr	#3,D7
	mulu	D7,D6
	btst	#3,D3
	beq.s	T_1A04
	tst.b	T_1076
	beq.s	T_1A02
	adda	D6,A0
T_1A02:
	add	D6,D6
T_1A04:
	move	D6,T_1A92
	move	D0,D6
	subq	#2,D0
	bmi.s	T_1A84
	move	D0,T_1A94
	move	T_18E2,D0
	cmp.w	#$C8,D0
	ble.s	T_1A26
	move	#$C8,D0
T_1A26:
	subq	#1,D0
	moveq	#12,D7
T_1A2A:
	move.b	D0,T_8974
	move	-$2(A2),T_8972
	movea.l	A0,A3
	move	#$13F,D1
	move.l	#$8000,D2
	moveq	#0,D7
T_1A46:
	movea.l	A3,A4
	move	(A4)+,D3
	and	D2,D3
	lsl	D7,D3
	move	T_1A94(PC),D5
T_1A52:
	move	(A4)+,D4
	and	D2,D4
	lsl	D7,D4
	lsr	#1,D3
	or	D4,D3
	dbra	D5,T_1A52
	rol	D6,D3
	add	D3,D3
	move	0(A1,D3.w),(A2)+
	addq	#1,D7
	ror.l	#1,D2
	tst	D2
	bne.s	T_1A78
	swap	D2
	adda	T_1A90(PC),A3
	moveq	#0,D7
T_1A78:
	dbra	D1,T_1A46
	adda	T_1A92(PC),A0
	dbra	D0,T_1A2A
T_1A84:
	bsr	set_old_ints
	bsr	T_1CD2
	rts
;
;
T_1A8E:
	dc.w	$0000			;
T_1A90:
	dc.w	$0000			;
T_1A92:
	dc.w	$0000			;
T_1A94:
	dc.w	$0000			;
T_1A96:
	clr	T_1A8E
	move	T_18D4(PC),D0
	move	D0,D6
	add	D6,D6
	move	D6,T_1A90
	move	D0,D6
	move	T_18E0(PC),D7
	lsr	#3,D7
	mulu	D7,D6
	btst	#3,D3
	beq.s	T_1AC6
	tst.b	T_1076
	beq.s	T_1AC4
	adda	D6,A0
T_1AC4:
	add	D6,D6
T_1AC6:
	move	D6,T_1A92
	moveq	#4,D0
	move	D0,D6
	subq	#2,D0
	bmi	T_1B92
	move	D0,T_1A94
	move	T_18E2,D0
	cmp.w	#$C8,D0
	ble.s	T_1AEC
	move	#$C8,D0
T_1AEC:
	subq	#1,D0
	moveq	#12,D7
T_1AF0:
	move.b	D0,T_8974
	move	-$2(A2),T_8972
	movea.l	A0,A3
	move	#$13F,D1
	move.l	#$8000,D2
	moveq	#0,D7
T_1B0C:
	movea.l	A3,A4
	move	(A4)+,D3
	and	D2,D3
	lsl	D7,D3
	move	T_1A94(PC),D5
T_1B18:
	move	(A4)+,D4
	and	D2,D4
	lsl	D7,D4
	lsr	#1,D3
	or	D4,D3
	dbra	D5,T_1B18
	rol	#4,D3
	move	D3,D4
	add	D4,D4
	move	0(A1,D4.w),D4
	moveq	#0,D5
	move	(A4)+,D6
	and	D2,D6
	lsl	D7,D6
	lsr	#1,D5
	or	D6,D5
	move	(A4)+,D6
	and	D2,D6
	lsl	D7,D6
	lsr	#1,D5
	or	D6,D5
	rol	#2,D5
	beq.s	T_1B66
	move	#-$10,D6
	subq	#1,D5
	beq.s	T_1B56
	eori	#3,D5
T_1B56:
	add	D5,D5
	add	D5,D5
	rol	D5,D3
	rol	D5,D6
	move	T_1A8E(PC),D4
	and	D6,D4
	or	D3,D4
T_1B66:
	move	D4,(A2)+
	move	D4,T_1A8E
	addq	#1,D7
	ror.l	#1,D2
	tst	D2
	bne.s	T_1B80
	swap	D2
	adda	T_1A90,A3
	moveq	#0,D7
T_1B80:
	dbra	D1,T_1B0C
	adda	T_1A92(PC),A0
	clr	T_1A8E
	dbra	D0,T_1AF0
T_1B92:
	bsr	set_old_ints
	bsr	T_1CD2
	rts
;
;
entry_USP:
	dc.l	0
entry_SSP:
	dc.l	0
T_1BA4:
	dc.w	0
T_1BA6:
	dc.w	0
;
;
T_1BA8:
	move	T_1BA6(PC),D5
	eor	D5,T_1BE2
	add	T_1BE2(PC),D1
	add	T_1BE2(PC),D2
	add	T_1BE2(PC),D3
	rts
;
;
T_1BC0:
	move	T_213E(PC),D5
	mulu	#$64A1,D5
	addi	#$7CCB,D5
	move	D5,T_213E
	lsr	#8,D5
	lsr	#5,D5
	andi	#1,D5
	add	D5,D1
	add	D5,D2
	add	D5,D3
	rts
;
;
T_1BE2:
	dc.w	$0000			;
T_1BE4:
	bsr	set_new_ints
	bsr	T_8E04
	movea.l	B_10AC0,A0
	lea	$22(A0),A0
	lea	T_1DFE(PC),A1
	move	#$F00,T_8972
	bsr.s	T_1C3E
	movea.l	B_10AC4,A0
	lea	$22(A0),A0
	lea	T_1E22(PC),A1
	move	#$F0,T_8972
	bsr.s	T_1C3E
	movea.l	B_10AC8,A0
	lea	$22(A0),A0
	lea	T_1E46(PC),A1
	move	#15,T_8972
	bsr.s	T_1C3E
	bsr	T_1CD2
	bsr	set_old_ints
	rts
;
;
T_1C3E:
	tst.b	T_1076
	beq.s	T_1C50
	tst.b	dither_type
	bne.s	T_1C50
	addq	#4,A1
T_1C50:
	move	#4,T_18D4
	movea.l	B_10ABC,A2
	move	T_18D4,D0
	move	D0,D6
	subq	#2,D0
	bmi.s	T_1CD0
	move	D0,T_1A94
	move	#$C7,D0
	moveq	#12,D7
T_1C76:
	move.b	D0,T_8974
	movea.l	A0,A3
	move	#$13F,D1
	move.l	#$8000,D2
	moveq	#0,D7
T_1C8A:
	movea.l	A3,A4
	move	(A4)+,D3
	and	D2,D3
	lsl	D7,D3
	move	T_1A94(PC),D5
T_1C96:
	move	(A4)+,D4
	and	D2,D4
	lsl	D7,D4
	lsr	#1,D3
	or	D4,D3
	dbra	D5,T_1C96
	rol	D6,D3
	add	D3,D3
	move	0(A1,D3.w),D3
	or	D3,(A2)+
	addq	#1,D7
	ror.l	#1,D2
	tst	D2
	bne.s	T_1CC4
	swap	D2
	move	T_18D4,D7
	add	D7,D7
	adda	D7,A3
	moveq	#0,D7
T_1CC4:
	dbra	D1,T_1C8A
	lea	$A0(A0),A0
	dbra	D0,T_1C76
T_1CD0:
	rts
;
;
T_1CD2:
	movem.l	D0-A6,-(SP)
	move	#1,T_1BA4
	move	#1,T_1BA6
	tst.b	T_1074
	beq.s	T_1D0A
	move.b	#1,dither_type
	tst.b	flicker_free_f
	bne.s	T_1D0A
	clr	T_1BA4
	clr	T_1BA6
T_1D0A:
	move	#$707,T_8972
	move	T_213C(PC),T_213E
	clr	T_1BE2
	tst.b	T_1076
	beq.s	T_1D3E
	cmpi.b	#3,B_10ACD
	beq.s	T_1D3E
	move	#1,T_1BE2
	bsr	T_1BC0
T_1D3E:
	lea	nu_joyst_pack,A5
	cmpi.b	#2,dither_type
	bne.s	T_1D54
	lea	T_1BC0(PC),A5
	bra.s	T_1D62
;
T_1D54:
	cmpi.b	#1,dither_type
	bne.s	T_1D62
	lea	T_1BA8(PC),A5
T_1D62:
	move	#$FFF,D6
	cmpi.b	#3,B_10ACD
	beq.s	T_1D74
	move	#$EEE,D6
T_1D74:
	movea.l	B_10ABC,A2
	move	#$C7,D7
T_1D7E:
	move	#$13F,D0
T_1D82:
	move.b	D7,T_8974
	move	(A2),D1
	move	D1,D2
	move	D2,D3
	lsr	#8,D3
	lsr	#4,D2
	andi	#15,D3
	andi	#15,D2
	andi	#15,D1
	jsr	(A5)
	tst.b	T_1076
	beq.s	T_1DC0
	tst.b	dither_type
	bne.s	T_1DC0
	cmpi.b	#3,B_10ACD
	beq.s	T_1DD8
	addq	#1,D3
	addq	#1,D2
	addq	#1,D1
T_1DC0:
	cmp.w	#15,D3
	ble.s	T_1DC8
	moveq	#15,D3
T_1DC8:
	cmp.w	#15,D2
	ble.s	T_1DD0
	moveq	#15,D2
T_1DD0:
	cmp.w	#15,D1
	ble.s	T_1DD8
	moveq	#15,D1
T_1DD8:
	lsl	#8,D3
	lsl	#4,D2
	or	D3,D2
	or	D2,D1
	and	D6,D1
	move	D1,(A2)+
	dbra	D0,T_1D82
	move	T_1BA4,D0
	eor	D0,T_1BE2
	dbra	D7,T_1D7E
	movem.l	(SP)+,D0-A6
	rts
;
;
T_1DFE:
	dc.b	$0,$0,$1,$0,$2,$0,$3,$0,$4,$0,$5,$0,$6,$0,$7
	dc.b	$0,$8,$0,$9,$0,$A,$0,$B,$0,$C,$0,$D,$0,$E,$0
	dc.b	$F,$0,$F,$0,$F,$0
T_1E22:
	dc.b	$0,$0,$0,$10,$0,$20,$0,$30,$0,$40,$0,$50,$0
	dc.b	$60,$0,$70,$0,$80,$0,$90,$0,$A0,$0,$B0,$0,$C0
	dc.b	$0,$D0,$0,$E0,$0,$F0,$0,$F0,$0,$F0
T_1E46:
	dc.b	$0,$0,$0,$1,$0,$2,$0,$3,$0,$4,$0,$5,$0,$6,$0
	dc.b	$7,$0,$8,$0,$9,$0,$A,$0,$B,$0,$C,$0,$D,$0,$E
	dc.b	$0,$F,$0,$F,$0,$F
T_1E6A:
	dc.b	$4,$0,$2,$0,$0,$1,$0,$1,$2,$0,$3,$0,$0,$1,$0
	dc.b	$1
T_1E7A:
	dc.b	$A,$0,$6,$0,$0,$4,$0,$4,$6,$0,$8,$0,$0,$4,$0
	dc.b	$4
T_1E8A:
	dc.b	$14,$0,$C,$0,$0,$8,$0,$8,$C,$0,$10,$0,$0,$8
	dc.b	$0,$8
;
;
T_1E9A:
	move	T_213C(PC),T_213E
	move	#$F0F,T_8972
	bsr	set_new_ints
	move.l	#T_1E7A,T_2140
	move.l	#T_20F2,T_2144
	tst.b	T_1074
	beq.s	T_1EDE
	move.l	#T_1E6A,T_2140
	move.l	#T_20D0,T_2144
T_1EDE:
	cmpi.b	#3,B_10ACD
	beq.s	T_1F18
	move.l	#T_1E8A,T_2140
	move.l	#T_2114,T_2144
	tst.b	T_1074
	beq.s	T_1F18
	move.l	#T_1E7A,T_2140
	move.l	#T_20F2,T_2144
T_1F18:
	bsr	T_8E04
	cmpi.b	#1,dither_type
	beq.s	T_1F38
	cmpi.b	#2,dither_type
	beq.s	T_1F40
	lea	nu_joyst_pack,A5
	bra.s	T_1F44
;
T_1F38:
	lea	T_20AE,A5
	bra.s	T_1F44
;
T_1F40:
	movea.l	T_2144(PC),A5
T_1F44:
	moveq	#0,D4
	moveq	#0,D5
	tst.b	T_1074
	beq.s	T_1F6C
	moveq	#8,D4
	moveq	#8,D5
	cmpi.b	#3,B_10ACD
	beq.s	T_1F62
	moveq	#$10,D4
	moveq	#$10,D5
T_1F62:
	tst.b	T_1076
	beq.s	T_1F6C
	eor	D5,D4
T_1F6C:
	tst.b	flicker_free_f
	bne.s	T_1F76
	moveq	#0,D5
T_1F76:
	pea	(A0)
	moveq	#0,D0
	moveq	#0,D7
T_1F7C:
	moveq	#0,D1
	move.b	(A0)+,D1
	cmp.b	#$20,D1
	beq.s	T_1F92
	subi	#$30,D1
	mulu	#10,D0
	add	D1,D0
	bra.s	T_1F7C
;
T_1F92:
	moveq	#0,D1
	move.b	(A0)+,D1
	cmp.b	#10,D1
	beq.s	T_1FA8
	subi	#$30,D1
	mulu	#10,D7
	add	D1,D7
	bra.s	T_1F92
;
T_1FA8:
	movea.l	(SP)+,A0
T_1FAA:
	cmpi.b	#10,(A0)+
	bne.s	T_1FAA
	movea.l	B_10ABC,A1
	movea.l	T_2140,A2
	move	D0,T_2148
	move	D7,T_214A
	move	#$140,D1
	sub.w	D0,D1
	bpl.s	T_1FDC
	neg.w	D1
	lsr	#1,D1
	mulu	#3,D1
	adda.l	D1,A0
	bra.s	T_1FE2
;
T_1FDC:
	lsr	#1,D1
	add	D1,D1
	adda	D1,A1
T_1FE2:
	move	#$C8,D1
	sub.w	D7,D1
	bpl.s	T_1FFC
	neg.w	D1
	lsr	#1,D1
	mulu	#3,D1
	mulu	T_2148,D1
	adda.l	D1,A0
	bra.s	T_2004
;
T_1FFC:
	lsr	#1,D1
	mulu	#$280,D1
	adda.l	D1,A1
T_2004:
	move	T_2148,D1
	mulu	#3,D1
	movea.l	D1,A6
	cmp.w	#$C8,D7
	ble.s	T_201A
	move	#$C8,D7
T_201A:
	subq	#1,D7
T_201C:
	move.l	A0,-(SP)
	move	T_2148,D0
	cmp.w	#$140,D0
	ble.s	T_202E
	move	#$140,D0
T_202E:
	subq	#1,D0
	movea.l	A1,A4
	move.b	D7,T_8974
T_2038:
	moveq	#0,D1
	moveq	#0,D2
	moveq	#0,D3
	move.b	(A0)+,D1
	move.b	(A0)+,D2
	move.b	(A0)+,D3
	add	D4,D1
	add	D4,D2
	add	D4,D3
	move	D4,-(SP)
	move	D5,-(SP)
	jsr	(A5)
	move	(SP)+,D5
	move	(SP)+,D4
	cmp.w	#$FF,D1
	ble.s	T_205E
	move	#$FF,D1
T_205E:
	cmp.w	#$FF,D2
	ble.s	T_2068
	move	#$FF,D2
T_2068:
	cmp.w	#$FF,D3
	ble.s	T_2072
	move	#$FF,D3
T_2072:
	lsr	#4,D1
	lsr	#4,D2
	lsr	#4,D3
	lsl	#8,D1
	lsl	#4,D2
	or	D3,D2
	or	D2,D1
	andi	#$FFF,D1
	cmpi.b	#3,B_10ACD
	beq.s	T_2092
	andi	#$EEE,D1
T_2092:
	move	D1,(A4)+
	eor	D5,D4
	dbra	D0,T_2038
	eor	D5,D4
	lea	$280(A1),A1
	movea.l	(SP)+,A0
	adda.l	A6,A0
	dbra	D7,T_201C
	bsr	set_old_ints
	rts
;
;
T_20AE:
	move	D7,D5
	andi	#3,D5
	add	D5,D5
	add	D5,D5
	lea	0(A2,D5.w),A3
	move	D0,D5
	andi	#3,D5
	move.b	0(A3,D5.w),D4
	ext.w	D4
	add	D4,D3
	add	D4,D2
	add	D4,D1
	rts
;
;
T_20D0:
	move	T_213E(PC),D5
	mulu	#$64A1,D5
	addi	#$7CCB,D5
	move	D5,T_213E
	lsr	#8,D5
	lsr	#3,D5
	andi	#7,D5
	add	D5,D1
	add	D5,D2
	add	D5,D3
	rts
;
;
T_20F2:
	move	T_213E(PC),D5
	mulu	#$64A1,D5
	addi	#$7CCB,D5
	move	D5,T_213E
	lsr	#8,D5
	lsr	#3,D5
	andi	#15,D5
	add	D5,D1
	add	D5,D2
	add	D5,D3
	rts
;
;
T_2114:
	move	T_213E(PC),D5
	mulu	#$64A1,D5
	addi	#$7CCB,D5
	move	D5,T_213E
	lsr	#8,D5
	lsr	#2,D5
	andi	#$1F,D5
	move	D5,D4
	lsr	#2,D4
	sub.w	D4,D5
	add	D5,D1
	add	D5,D2
	add	D5,D3
	rts
;
;
T_213C:
	dc.w	$6B01			;k
T_213E:
	dc.w	$6B01			;k
T_2140:
	dc.l	0
T_2144:
	dc.l	0
T_2148:
	dc.w	$0000			;
T_214A:
	dc.w	$0000			;
;
;
T_214C:
	jsr	ICE_blocks_1_3_or_2_4
	bsr	T_8E20
	move	#$FFF,T_8972
	bsr	set_new_ints
	move.l	T_8B1C,D0
	movea.l	D0,A0
	lsr	#8,D0
	move.l	D0,$FFFF8200.w
	move	#$1F3F,D1
T_2174:
	clr.l	(A0)+
	dbra	D1,T_2174
	movea.l	B_10ABC,A0
	movea.l	T_8B14,A1
	movea.l	T_8B1C,A6
	lea	D_B660,A2
	lea	$20(A1),A1
	lea	$A0(A6),A6
	move	A6,usp
	lea	T_2302(PC),A6
	cmpi.b	#0,T_1075
	beq	T_2442
	cmpi.b	#1,T_1075
	beq	T_2442
	move	#$C7,D7
T_21BC:
	move	#$C6,D1
	sub.w	D7,D1
	addq	#4,D1
	move.b	D1,T_8974
	swap	D7
	move	#$13F,D1
T_21D0:
	move	D1,-(SP)
	lea	T_2584(PC),A3
	add	D1,D1
	adda	D1,A3
	move	(A3),D1
	add	D1,D1
	move	D1,D2
	lsl	#3,D2
	lea	D_B8E0,A3
	adda	D2,A3
	move	0(A0,D1.w),D0
	bne.s	T_21FC
	cmp.w	#$27A,D1
	blt.s	T_21FC
	moveq	#0,D4
	bra	T_2298
;
T_21FC:
	move	#$7FFF,D6
	moveq	#15,D4
T_2202:
	cmp.w	0(A2,D1.w),D4
	beq	T_2292
	move.b	0(A3,D4.w),D2
	ext.w	D2
	asl	#5,D2
	add	D4,D2
	add	D4,D2
	move	0(A1,D2.w),D3
	bpl.s	T_2246
	movea.l	A1,A5
	adda	D2,A5
	movea	D4,A4
	bra.s	T_223C
;
T_2224:
	cmp.w	0(A2,D1.w),D4
	beq.s	T_223C
	move.b	0(A3,D4.w),D2
	ext.w	D2
	asl	#5,D2
	add	D4,D2
	add	D4,D2
	cmp.w	0(A1,D2.w),D0
	beq.s	T_2298
T_223C:
	dbra	D4,T_2224
	move	D0,(A5)
	move	A4,D4
	bra.s	T_2298
;
T_2246:
	cmp.w	D0,D3
	beq.s	T_2298
	move	D0,D7
	lsr	#8,D7
	move	D3,D2
	lsr	#8,D2
	andi	#15,D2
	sub.w	D2,D7
	add	D7,D7
	move	T_22D8(PC,D7.w),D5
	move	D0,D7
	lsr	#4,D7
	andi	#15,D7
	move	D3,D2
	lsr	#4,D2
	andi	#15,D2
	sub.w	D2,D7
	add	D7,D7
	add	T_22D8(PC,D7.w),D5
	move	D0,D7
	andi	#15,D7
	move	D3,D2
	andi	#15,D2
	sub.w	D2,D7
	add	D7,D7
	add	T_22D8(PC,D7.w),D5
	cmp.w	D6,D5
	bge.s	T_2292
	move	D5,D6
	movea	D4,A4
T_2292:
	dbra	D4,T_2202
	move	A4,D4
T_2298:
	lsr	#1,D1
	lsl	#4,D4
	move.b	D4,0(A6,D1.w)
	move	(SP)+,D1
	dbra	D1,T_21D0
	lea	$280(A0),A0
	lea	$60(A1),A1
	bsr	T_2858
	swap	D7
	dbra	D7,T_21BC
	bra.s	T_22F8
;
	move.b	D0,$1770(SP)
	bclr	D7,-(A0)
	dc.w	$0800			;
	dc.w	$0400			;
	dc.w	$0200			;
	btst	D0,D0
	ori.l	#$400020,D0
	ori.b	#8,(A0)
	ori.b	#2,D4
	dc.w	$0001			;
T_22D8:
	ori.b	#1,D0
	ori.b	#4,D2
	dc.w	$0008			;
	ori.b	#$20,(A0)
	ori	#$80,D0
	btst	D0,D0
	dc.w	$0200			;
	dc.w	$0400			;
	dc.w	$0800			;
	bclr	D7,-(A0)
	dc.w	$1770			; p
	dc.w	$1F40			; @
T_22F8:
	bsr	set_old_ints
	bsr	T_2804
	rts
;
;
T_2302:
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
	ori.b	#0,D0
T_2442:
	move	#$C7,D7
T_2446:
	move	#$C6,D1
	sub.w	D7,D1
	addq	#4,D1
	move.b	D1,T_8974
	swap	D7
	move	#$13F,D1
T_245A:
	move	D1,-(SP)
	lea	T_2584(PC),A3
	add	D1,D1
	adda	D1,A3
	move	(A3),D1
	add	D1,D1
	move	D1,D2
	lsl	#3,D2
	lea	D_B8E0,A3
	adda	D2,A3
	move	0(A0,D1.w),D0
	move	#$7FFF,D6
	moveq	#15,D4
T_247E:
	cmp.w	0(A2,D1.w),D4
	beq	T_2514
	move.b	0(A3,D4.w),D2
	ext.w	D2
	asl	#5,D2
	add	D4,D2
	add	D4,D2
	move	0(A1,D2.w),D3
	bpl.s	T_24C2
	movea.l	A1,A5
	adda	D2,A5
	movea	D4,A4
	bra.s	T_24B8
;
T_24A0:
	cmp.w	0(A2,D1.w),D4
	beq.s	T_24B8
	move.b	0(A3,D4.w),D2
	ext.w	D2
	asl	#5,D2
	add	D4,D2
	add	D4,D2
	cmp.w	0(A1,D2.w),D0
	beq.s	T_251A
T_24B8:
	dbra	D4,T_24A0
	move	D0,(A5)
	move	A4,D4
	bra.s	T_251A
;
T_24C2:
	cmp.w	D0,D3
	beq.s	T_251A
	cmp.w	#$7FFF,D3
	beq.s	T_2514
	move	D0,D7
	lsr	#8,D7
	move	D3,D2
	lsr	#8,D2
	andi	#15,D2
	sub.w	D2,D7
	add	D7,D7
	move	T_255A(PC,D7.w),D5
	move	D0,D7
	lsr	#4,D7
	andi	#15,D7
	move	D3,D2
	lsr	#4,D2
	andi	#15,D2
	sub.w	D2,D7
	add	D7,D7
	add	T_255A(PC,D7.w),D5
	move	D0,D7
	andi	#15,D7
	move	D3,D2
	andi	#15,D2
	sub.w	D2,D7
	add	D7,D7
	add	T_255A(PC,D7.w),D5
	cmp.w	D6,D5
	bge.s	T_2514
	move	D5,D6
	movea	D4,A4
T_2514:
	dbra	D4,T_247E
	move	A4,D4
T_251A:
	lsr	#1,D1
	lsl	#4,D4
	move.b	D4,0(A6,D1.w)
	move	(SP)+,D1
	dbra	D1,T_245A
	lea	$280(A0),A0
	lea	$60(A1),A1
	bsr	T_2858
	swap	D7
	dbra	D7,T_2446
	bra.s	T_257A
;
	dc.b	$1F,$40,$17,$70,$F,$A0,$8,$0,$4,$0,$2,$0,$1
	dc.b	$0,$0,$80,$0,$40,$0,$20,$0,$10,$0,$8,$0,$4,$0
	dc.b	$2,$0,$1
T_255A:
	dc.b	$0,$0,$0,$1,$0,$2,$0,$4,$0,$8,$0,$10,$0,$20
	dc.b	$0,$40,$0,$80,$1,$0,$2,$0,$4,$0,$8,$0,$F,$A0
	dc.b	$17,$70,$1F,$40
T_257A:
	bsr	set_old_ints
	bsr	T_2804
	rts
;
;
T_2584:
	dc.b	$1,$3F,$1,$2F,$1,$1F,$1,$F,$0,$FF,$0,$EF,$0
	dc.b	$DF,$0,$CF,$0,$BF,$0,$AF,$0,$9F,$0,$8F,$0,$7F
	dc.b	$0,$6F,$0,$5F,$0,$4F,$0,$3F,$0,$2F,$0,$1F,$0
	dc.b	$F,$1,$37,$1,$27,$1,$17,$1,$7,$0,$F7,$0,$E7
	dc.b	$0,$D7,$0,$C7,$0,$B7,$0,$A7,$0,$97,$0,$87,$0
	dc.b	$77,$0,$67,$0,$57,$0,$47,$0,$37,$0,$27,$0,$17
	dc.b	$0,$7,$1,$3B,$1,$2B,$1,$1B,$1,$B,$0,$FB,$0,$EB
	dc.b	$0,$DB,$0,$CB,$0,$BB,$0,$AB,$0,$9B,$0,$8B,$0
	dc.b	$7B,$0,$6B,$0,$5B,$0,$4B,$0,$3B,$0,$2B,$0,$1B
	dc.b	$0,$B,$1,$33,$1,$23,$1,$13,$1,$3,$0,$F3,$0,$E3
	dc.b	$0,$D3,$0,$C3,$0,$B3,$0,$A3,$0,$93,$0,$83,$0
	dc.b	$73,$0,$63,$0,$53,$0,$43,$0,$33,$0,$23,$0,$13
	dc.b	$0,$3,$1,$3E,$1,$2E,$1,$1E,$1,$E,$0,$FE,$0,$EE
	dc.b	$0,$DE,$0,$CE,$0,$BE,$0,$AE,$0,$9E,$0,$8E,$0
	dc.b	$7E,$0,$6E,$0,$5E,$0,$4E,$0,$3E,$0,$2E,$0,$1E
	dc.b	$0,$E,$1,$36,$1,$26,$1,$16,$1,$6,$0,$F6,$0,$E6
	dc.b	$0,$D6,$0,$C6,$0,$B6,$0,$A6,$0,$96,$0,$86,$0
	dc.b	$76,$0,$66,$0,$56,$0,$46,$0,$36,$0,$26,$0,$16
	dc.b	$0,$6,$1,$3A,$1,$2A,$1,$1A,$1,$A,$0,$FA,$0,$EA
	dc.b	$0,$DA,$0,$CA,$0,$BA,$0,$AA,$0,$9A,$0,$8A,$0
	dc.b	$7A,$0,$6A,$0,$5A,$0,$4A,$0,$3A,$0,$2A,$0,$1A
	dc.b	$0,$A,$1,$32,$1,$22,$1,$12,$1,$2,$0,$F2,$0,$E2
	dc.b	$0,$D2,$0,$C2,$0,$B2,$0,$A2,$0,$92,$0,$82,$0
	dc.b	$72,$0,$62,$0,$52,$0,$42,$0,$32,$0,$22,$0,$12
	dc.b	$0,$2,$1,$3D,$1,$2D,$1,$1D,$1,$D,$0,$FD,$0,$ED
	dc.b	$0,$DD,$0,$CD,$0,$BD,$0,$AD,$0,$9D,$0,$8D,$0
	dc.b	$7D,$0,$6D,$0,$5D,$0,$4D,$0,$3D,$0,$2D,$0,$1D
	dc.b	$0,$D,$1,$35,$1,$25,$1,$15,$1,$5,$0,$F5,$0,$E5
	dc.b	$0,$D5,$0,$C5,$0,$B5,$0,$A5,$0,$95,$0,$85,$0
	dc.b	$75,$0,$65,$0,$55,$0,$45,$0,$35,$0,$25,$0,$15
	dc.b	$0,$5,$1,$39,$1,$29,$1,$19,$1,$9,$0,$F9,$0,$E9
	dc.b	$0,$D9,$0,$C9,$0,$B9,$0,$A9,$0,$99,$0,$89,$0
	dc.b	$79,$0,$69,$0,$59,$0,$49,$0,$39,$0,$29,$0,$19
	dc.b	$0,$9,$1,$31,$1,$21,$1,$11,$1,$1,$0,$F1,$0,$E1
	dc.b	$0,$D1,$0,$C1,$0,$B1,$0,$A1,$0,$91,$0,$81,$0
	dc.b	$71,$0,$61,$0,$51,$0,$41,$0,$31,$0,$21,$0,$11
	dc.b	$0,$1,$1,$3C,$1,$2C,$1,$1C,$1,$C,$0,$FC,$0,$EC
	dc.b	$0,$DC,$0,$CC,$0,$BC,$0,$AC,$0,$9C,$0,$8C,$0
	dc.b	$7C,$0,$6C,$0,$5C,$0,$4C,$0,$3C,$0,$2C,$0,$1C
	dc.b	$0,$C,$1,$34,$1,$24,$1,$14,$1,$4,$0,$F4,$0,$E4
	dc.b	$0,$D4,$0,$C4,$0,$B4,$0,$A4,$0,$94,$0,$84,$0
	dc.b	$74,$0,$64,$0,$54,$0,$44,$0,$34,$0,$24,$0,$14
	dc.b	$0,$4,$1,$38,$1,$28,$1,$18,$1,$8,$0,$F8,$0,$E8
	dc.b	$0,$D8,$0,$C8,$0,$B8,$0,$A8,$0,$98,$0,$88,$0
	dc.b	$78,$0,$68,$0,$58,$0,$48,$0,$38,$0,$28,$0,$18
	dc.b	$0,$8,$1,$30,$1,$20,$1,$10,$1,$0,$0,$F0,$0,$E0
	dc.b	$0,$D0,$0,$C0,$0,$B0,$0,$A0,$0,$90,$0,$80,$0
	dc.b	$70,$0,$60,$0,$50,$0,$40,$0,$30,$0,$20,$0,$10
	dc.b	$0,$0
;
;
T_2804:
	movea.l	T_8B14,A0
	move	#$255F,D0
T_280E:
	move	(A0),D1
	move	D1,D2
	move	D2,D3
	lsr	#8,D1
	lsr	#4,D2
	andi	#15,D1
	andi	#15,D2
	andi	#15,D3
	ror.b	#1,D1
	move.b	D1,D4
	lsr.b	#4,D4
	or.b	D4,D1
	andi	#15,D1
	ror.b	#1,D2
	move.b	D2,D4
	lsr.b	#4,D4
	or.b	D4,D2
	andi	#15,D2
	ror.b	#1,D3
	move.b	D3,D4
	lsr.b	#4,D4
	or.b	D4,D3
	andi	#15,D3
	lsl	#8,D1
	lsl	#4,D2
	or	D1,D2
	or	D2,D3
	move	D3,(A0)+
	dbra	D0,T_280E
	rts
;
;
T_2858:
	move.l	A6,-(SP)
	move	usp,A6
	lea	T_2302(PC),A4
	moveq	#$13,D5
T_2862:
	moveq	#0,D1
	moveq	#0,D2
	moveq	#0,D3
	moveq	#0,D4
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	move.b	(A4)+,D0
	add.b	D0,D0
	addx	D4,D4
	add.b	D0,D0
	addx	D3,D3
	add.b	D0,D0
	addx	D2,D2
	add.b	D0,D0
	addx	D1,D1
	movem.w	D1-D4,(A6)
	addq	#8,A6
	dbra	D5,T_2862
	move	A6,usp
	movea.l	(SP)+,A6
	rts
;
;
T_299A:
	btst	#1,(hw_syn).w		;syncmode
	bne.s	T_29B4
	move.b	#$10,T_8946
	move.l	#nu_HBI_2,$68.w		;autov_int2
	bra.s	T_29C4
;
T_29B4:
	move.b	#$2E,T_8946
	move.l	#nu_HBI_1,$68.w		;autov_int2
T_29C4:
	move	#$2100,sr
	move.l	T_8B1C,D0
	lsr	#8,D0
	move.l	D0,$FFFF8200.w
	move.l	T_8B1C,D0
	move.l	T_8B20,T_8B1C
	move.l	D0,T_8B20
	move.l	T_8B18,D0
	move.l	T_8B14,T_8B18
	move.l	D0,T_8B14
	movea.l	D0,A0
	addq	#2,A0
	lea	$FFFF8242.w,A1		;color1
	move	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	lea	T_8946,A0
T_2A1E:
	tst.b	(A0)
	bne.s	T_2A1E
	move	#$2300,sr
T_2A26:
	btst	#0,$FFFFFC00.w		;keyctl
	beq.s	T_2A34
	move.b	$FFFFFC02.w,D0		;keybd
	bra.s	T_2A26
;
T_2A34:
	tst	vbi_counter
	ble.s	T_2A42
	subq	#1,vbi_counter
T_2A42:
	rts
;
;
nu_HBI_1:
	subq.b	#1,T_8946
	ble.s	T_2A4E
	rte
;
;
T_2A4E:
	move	#$2700,sr
	movem.l	D0-A6,-(SP)
	move.l	SP,$C0.w
	lea	$FFFF8209.w,A6		;vcountlow
	moveq	#0,D0
	moveq	#$40,D7
T_2A62:
	move.b	(A6),D0
	beq.s	T_2A62
	sub.w	D0,D7
	lsl	D7,D0
	move	#15,D0
T_2A6E:
	dbra	D0,T_2A6E
	nop
	nop
	movea.l	T_8B14(PC),SP
	lea	$20(SP),SP
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movea.l	$C0.w,SP
	movem.l	(SP)+,D0-A6
	move.l	#nu_HBI_dummy,$68.w	;autov_int2
	move.b	#$23,(SP)
nu_HBI_dummy:
	rte
;
;
nu_HBI_2:
	subq.b	#1,T_8946
	ble.s	T_5942
	rte
;
;
T_5942:
	move	#$2700,sr
	movem.l	D0-A6,-(SP)
	move.l	SP,$C0.w
	lea	$FFFF8209.w,A6		;vcountlow
	moveq	#0,D0
	moveq	#$40,D7
T_5956:
	move.b	(A6),D0
	beq.s	T_5956
	sub.w	D0,D7
	lsl	D7,D0
	move	#15,D0
T_5962:
	dbra	D0,T_5962
	nop
	movea.l	T_8B14(PC),SP
	lea	$20(SP),SP
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movem.l	(SP)+,D0-A6
	movem.l	D0-D7,(hw_pal).w	;color0
	movem.l	A0-A6,(hw_pal).w	;color0
	move.l	(SP)+,(hw_pal_14).w	;color14
	lea	(hw_pal).w,A0		;color0
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move.l	(SP)+,(A0)+
	move	#0,(hw_pal).w		;color0
	move.l	(SP)+,(A0)+
	nop
	nop
	nop
	nop
	nop
	nop
	movea.l	$C0.w,SP
	movem.l	(SP)+,D0-A6
	move.l	#nu_HBI_dummy,$68.w	;autov_int2
	move.b	#$23,(SP)
	rte
;
;
T_869C:
	tst.b	T_8B3C
	bne.s	T_86E4
	st	T_8B3C
	xbios	Ikbdws,#0,mouse_off_ik_s
	move	#1,vbi_counter
T_86C4:
	tst	vbi_counter
	bne.s	T_86C4
	move	#$2700,sr
	lea	old_interr_t(PC),A0
	move.l	_vbl_list.w,(A0)+		;_vbl_list
	move.b	$FFFFFA07.w,(A0)+	;iera
	move.b	$FFFFFA09.w,(A0)+	;ierb
	move	#$2300,sr
T_86E4:
	rts
;
;----------------------------------------------------------------------------
;
T_86E6:
	tst.b	T_8B3C
	beq.s	T_872E
	sf	T_8B3C
	move	#1,vbi_counter
T_86FC:
	tst	vbi_counter
	bne.s	T_86FC
	lea	old_interr_t(PC),A0
	move	#$2700,sr
	move.l	(A0)+,_vbl_list		;_vbl_list
	move.b	(A0)+,$FFFFFA07.w	;iera
	move.b	(A0)+,$FFFFFA09.w	;ierb
	move	#$2300,sr
	xbios	Ikbdws,#0,mouse_on_ik_s
T_872E:
	rts
;
;----------------------------------------------------------------------------
;
T_8730:
	btst	#1,(hw_syn).w		;syncmode
	beq.s	T_873C
	bsr.s	T_8750
	bra.s	T_8740
;
T_873C:
	bsr	T_884E
T_8740:
	tst	vbi_counter
	beq.s	T_874E
	subq	#1,vbi_counter
T_874E:
	rts
;
;----------------------------------------------------------------------------
;
T_8750:
	move	sr,-(SP)
	move	#$2700,sr
	lea	(hw_pal).w,A4		;color0
	lea	$FFFF8209.w,A5		;vcountlow
	movea.l	T_8B14,A3
	lea	$20(A3),A3
	move	#$C4,D7
T_876C:
	tst.b	(A5)
	beq.s	T_876C
	move.b	(A5),D0
	neg.b	D0
	lsl	D0,D0
	move	#$1B,D0
T_877A:
	dbra	D0,T_877A
	nop
	nop
T_8782:
	nop
	nop
	lea	(A4),A0
	lea	(A4),A1
	lea	(A4),A2
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	dbra	D7,T_8782
	nop
	lea	(A4),A0
	lea	(A4),A1
	lea	(A4),A2
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	lea	(A4),A0
	lea	(A4),A1
	lea	(A4),A2
	lea	-$4A60(A3),A4
	nop
	nop
	nop
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move	#$2300,sr
T_883C:
	btst	#0,$FFFFFC00.w		;keyctl
	beq.s	T_884A
	move.b	$FFFFFC02.w,D0		;keybd
	bra.s	T_883C
;
T_884A:
	move	(SP)+,sr
	rts
;
;----------------------------------------------------------------------------
;
T_884E:
	move	sr,-(SP)
	move	#$2700,sr
	lea	(hw_pal).w,A4		;color0
	lea	$FFFF8209.w,A5		;vcountlow
	movea.l	T_8B14,A3
	lea	$20(A3),A3
	move	#$C4,D7
T_886A:
	tst.b	(A5)
	beq.s	T_886A
	move.b	(A5),D0
	neg.b	D0
	lsl	D0,D0
	move	#$1B,D0
T_8878:
	dbra	D0,T_8878
	nop
	nop
T_8880:
	nop
	lea	(A4),A0
	lea	(A4),A1
	lea	(A4),A2
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	dbra	D7,T_8880
	lea	(A4),A0
	lea	(A4),A1
	lea	(A4),A2
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	move.l	(A3)+,(A2)+
	lea	(A4),A0
	lea	(A4),A1
	lea	(A4),A2
	lea	-$4A60(A3),A4
	nop
	nop
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A0)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A3)+,(A1)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move.l	(A4)+,(A2)+
	move	#$2300,sr
T_8934:
	btst	#0,$FFFFFC00.w		;keyctl
	beq.s	T_8942
	move.b	$FFFFFC02.w,D0		;keybd
	bra.s	T_8934
;
T_8942:
	move	(SP)+,sr
	rts
;
;----------------------------------------------------------------------------
;
T_8946:
	dc.b	$0,$0
;
;----------------------------------------------------------------------------
;
nu_vbi:
	move.b	#0,$FFFFFA1B.w		;tbcr
	move.b	T_8974(PC),$FFFFFA21.w	;tbdr
	move.b	#8,$FFFFFA1B.w		;tbcr
	move.l	#T_8976,(iv_time_b).w		;diensi_int
	tst	vbi_counter
	beq.s	T_8970
	subq	#1,vbi_counter
T_8970:
	rte
;
;----------------------------------------------------------------------------
;
T_8972:
	dc.b	$0,$0
T_8974:
	dc.b	$0,$0
T_8976:
	move	T_8972(PC),(hw_pal).w	;color0
	bclr	#0,$FFFFFA0F.w		;isra
	move.b	#0,$FFFFFA1B.w		;tbcr
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	clr	(hw_pal).w		;color0
	rte
;
;
set_new_ints:
	movem.l	D0-A6,-(SP)
	xbios	Ikbdws,#0,mouse_off_ik_s
	lea	old_interr_t(PC),A0
	move.l	$70.w,(A0)+		;autov_int4
	move.l	(iv_time_b).w,(A0)+		;diensi_int
	move.b	$FFFFFA07.w,(A0)+	;iera
	move.b	$FFFFFA09.w,(A0)+	;ierb
	move.b	$FFFFFA13.w,(A0)+	;imra
	move.b	$FFFFFA15.w,(A0)+	;imrb
	move.b	$FFFFFA1B.w,(A0)+	;tbcr
	move.b	$FFFFFA21.w,(A0)+	;tbdr
	move.b	$FFFFFA17.w,(A0)+	;vr
	move	#$2700,sr
	move.l	#nu_vbi,$70.w		;autov_int4
	move.b	#$40,$FFFFFA09.w	;ierb
	move.b	#$40,$FFFFFA15.w	;imrb
	move.b	#1,$FFFFFA07.w		;iera
	move.b	#1,$FFFFFA13.w		;imra
	move.b	#0,$FFFFFA1B.w		;tbcr
	move	#$2300,sr
	movem.l	(SP)+,D0-A6
	rts
;
;
set_old_ints:
	movem.l	D0-A6,-(SP)
	lea	old_interr_t(PC),A0
	move	#$2700,sr
	move.l	(A0)+,$70.w		;autov_int4
	move.l	(A0)+,(iv_time_b).w		;diensi_int
	move.b	(A0)+,$FFFFFA07.w	;iera
	move.b	(A0)+,$FFFFFA09.w	;ierb
	move.b	(A0)+,$FFFFFA13.w	;imra
	move.b	(A0)+,$FFFFFA15.w	;imrb
	move.b	(A0)+,$FFFFFA1B.w	;tbcr
	move.b	(A0)+,$FFFFFA21.w	;tbdr
	move.b	(A0)+,$FFFFFA17.w	;vr
	move	#$2300,sr
	xbios	Ikbdws,#0,mouse_on_ik_s
	movem.l	(SP)+,D0-A6
	rts
;
;----------------------------------------------------------------------------
;
T_8B14:
	dc.l	0
T_8B18:
	dc.l	0
T_8B1C:
	dc.l	0
T_8B20:
	dc.l	0
	dc.l	0
old_interr_t:
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
T_8B3C:
	dc.w	$0000
;
;----------------------------------------------------------------------------
;
empty_kb_acia:
	move	D7,-(SP)
T_8B40:
	btst	#0,$FFFFFC00.w		;keyctl
	beq.s	T_8B4E
	move.b	$FFFFFC02.w,D7		;keybd
	bra.s	T_8B40
;
T_8B4E:
	move	(SP)+,D7
	rts
;
;----------------------------------------------------------------------------
;
mouse_off_ik_s:
	dc.b	$12
;
mouse_on_ik_s:
	dc.b	$8
;
T_8B54:
	dc.b	$0
T_8B55:
	dc.b	$0
;
;----------------------------------------------------------------------------
;
T_8B56:
	sf	T_8B54
	move.l	$5A0.w,D0		;_p_cookies
	beq.s	T_8B8E
	movea.l	D0,A0
	moveq	#7,D0
T_8B66:
	cmpi.l	#'_MCH',(A0)
	beq.s	T_8B76
	addq.l	#8,A0
	dbra	D0,T_8B66
	bra.s	T_8B8E
;
T_8B76:
	cmpi.l	#$20010,4(A0)
	bne.s	T_8B8E
	st	T_8B54
	move.b	$FFFF8E21.w,T_8B55	;ste_ctl
T_8B8E:
	bsr	T_8BB6
	rts
;
;
T_8B94:
	tst.b	T_8B54
	beq.s	T_8BA4
	move.b	T_8B55,$FFFF8E21.w	;ste_ctl
T_8BA4:
	rts
;
;
T_8BA6:
	tst.b	T_8B54
	beq.s	T_8BB4
	move.b	#0,$FFFF8E21.w		;ste_ctl
T_8BB4:
	rts
;
;
T_8BB6:
	tst.b	T_8B54
	beq.s	T_8BC4
	move.b	#3,$FFFF8E21.w		;ste_ctl
T_8BC4:
	rts
;
;----------------------------------------------------------------------------
;
save_screenrez:
	xbios	Physbase
	move.l	D0,T_8D6C
	clr.b	D0
	move.l	D0,T_8D68
	xbios	Getrez
	move	D0,T_8D70
	move.l	#B_1C777,D0
	clr.b	D0
	move.l	D0,T_8D64
	xbios	Setscreen|_ind,T_8D68,T_8D68,#0
	movem.l	(hw_pal).w,D0-D7	;color0
	movem.l	D0-D7,T_8D92
	move.l	T_8D68,D0
	addi.l	#$FF,D0
	clr.b	D0
	move.l	D0,B_10AB0
	move.l	T_8D64,D0
	addi.l	#$FF,D0
	clr.b	D0
	move.l	D0,B_10AB4
	move.b	#0,$FFFF820d		;vbaselo
	rts
;
;----------------------------------------------------------------------------
;
rest_screenrez:
	movem.l	T_8D92(PC),D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	xbios	Setscreen|_ind,T_8D6C,T_8D6C,T_8D70
	bsr	empty_keyboard
	rts
;
;----------------------------------------------------------------------------
;
save_interrupt:
	lea	save_interr_t(PC),A0
	move	usp,A1
	move.l	A1,(A0)+
	lea	_vbl_list.w,A1		;_vbl_list
	moveq	#7,D0
T_8CAE:
	move.l	(A1),(A0)+
	clr.l	(A1)+
	dbra	D0,T_8CAE
	move.l	$70.w,(A0)+		;autov_int4
	move.l	$68.w,(A0)+		;autov_int2
	move.l	$118.w,(A0)+		;ikbd_inter
	move.l	$134.w,(A0)+
	move.l	(iv_time_b).w,(A0)+		;diensi_int
	move.b	$FFFFFA07.w,(A0)+	;iera
	move.b	$FFFFFA09.w,(A0)+	;ierb
	move.b	$FFFFFA13.w,(A0)+	;imra
	move.b	$FFFFFA15.w,(A0)+	;imrb
	move.b	$FFFFFA19.w,(A0)+	;tacr
	move.b	$FFFFFA1B.w,(A0)+	;tbcr
	move.b	$FFFFFA1F.w,(A0)+	;tadr
	move.b	$FFFFFA21.w,(A0)+	;tbdr
	move.b	$484.w,(A0)+		;conterm
	move	#$2700,sr
	move.l	#T_96C8,_vbl_list	;_vbl_list
	move.b	#2,$484.w		;conterm
	move	#$2300,sr
	bsr	setnu_joymouse
	rts
;
;----------------------------------------------------------------------------
;
rest_interrupt:
	bsr	resto_joymouse
	lea	save_interr_t(PC),A0
	move	#$2700,sr
	movea.l	(A0)+,A1
	move	A1,usp
	lea	_vbl_list.w,A1		;_vbl_list
	moveq	#7,D0
T_8D20:
	move.l	(A0)+,(A1)+
	dbra	D0,T_8D20
	move.l	(A0)+,$70.w		;autov_int4
	move.l	(A0)+,$68.w		;autov_int2
	move.l	(A0)+,$118.w		;ikbd_inter
	move.l	(A0)+,$134.w
	move.l	(A0)+,(iv_time_b).w
	move.b	(A0)+,$FFFFFA07.w	;iera
	move.b	(A0)+,$FFFFFA09.w	;ierb
	move.b	(A0)+,$FFFFFA13.w	;imra
	move.b	(A0)+,$FFFFFA15.w	;imrb
	move.b	(A0)+,$FFFFFA19.w	;tacr
	move.b	(A0)+,$FFFFFA1B.w	;tbcr
	move.b	(A0)+,$FFFFFA1F.w	;tadr
	move.b	(A0)+,$FFFFFA21.w	;tbdr
	move.b	(A0)+,$484.w		;conterm
	move	#$2300,sr
	rts
;
;----------------------------------------------------------------------------
;
T_8D64:
	dc.b	$0,$0,$0,$0
T_8D68:
	dc.b	$0,$0,$0,$0
T_8D6C:
	dc.b	$0,$0,$0,$0
T_8D70:
	dc.b	$0,$0
;
;------------------------------------
T_8D72:
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0
;------------------------------------
T_8D92:
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0
;------------------------------------
save_interr_t:
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0
;------------------------------------
STE_video_f:
	dc.b	$0,$0
;
;----------------------------------------------------------------------------
;
T_8E04:
	movem.l	D0-A6,-(SP)
	movea.l	B_10ABC,A0
	move.l	#$F9FF,D0
T_8E14:
	clr	(A0)+
	subq.l	#1,D0
	bpl.s	T_8E14
	movem.l	(SP)+,D0-A6
	rts
;
;
T_8E20:
	movem.l	D0-A6,-(SP)
	moveq	#-1,D1
	moveq	#-1,D2
	cmpi.b	#0,T_1075
	beq.s	T_8E3C
	cmpi.b	#1,T_1075
	bne.s	T_8E4A
T_8E3C:
	moveq	#0,D1
	tst.b	legal_colour_f
	beq.s	T_8E4A
	move	#$7FFF,D2
T_8E4A:
	movea.l	T_8B14,A0
	move	#$255,D0
	moveq	#-1,D3
T_8E56:
	move	D1,(A0)+
	move	D3,(A0)+
	move.l	D3,(A0)+
	move.l	D3,(A0)+
	move.l	D3,(A0)+
	move.l	D3,(A0)+
	move.l	D3,(A0)+
	move.l	D3,(A0)+
	move	D3,(A0)+
	move	D2,(A0)+
	dbra	D0,T_8E56
	movem.l	(SP)+,D0-A6
	rts
;
;
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;
;
clear_32000_i_T_8D64:
	movea.l	T_8D64,A0
	move	#$1F3F,D0
T_8E9E:
	clr.l	(A0)+
	dbra	D0,T_8E9E
	rts
;
;
copy_32000_i_T_8D64_i_T_8D68:
	movea.l	T_8D64(PC),A0
	movea.l	T_8D68(PC),A1
	move	#$1F3F,D0
T_8EB2:
	move.l	(A0)+,(A1)+
	dbra	D0,T_8EB2
	rts
;
;
set_FORM_color:
	movem.l	T_8D72(PC),D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	rts
;
;
set_a0pi_color:
	movem.l	(A0)+,D0-D7
	movem.l	D0-D7,(hw_pal).w	;color0
	rts
;
;
FORM_unpack:
	moveq	#8,D6
	moveq	#0,D2
	moveq	#0,D3
	moveq	#0,D4
	move.b	(A0)+,D0
	cmp.b	#2,D0
	ble.s	T_8EE8
	addq	#4,A0
	subq.b	#3,D0
T_8EE8:
	move.b	D0,$FFFF8260.w		;shiftmd
	moveq	#15,D0
	lea	T_8D72(PC),A1
T_8EF2:
	move.b	(A0)+,D1
	lsl	D6,D1
	move.b	(A0)+,D1
	move	D1,(A1)+
	dbra	D0,T_8EF2
	move.b	(A0)+,D0
	lsl	D6,D0
	move.b	(A0)+,D0
	move	D0,D1
	addq	#2,A0
	movea.l	A0,A1
	lea	0(A0,D1.w),A2
	movea.l	T_8D68,A0
	movea.l	A0,A3
T_8F16:
	moveq	#0,D0
	move.b	(A1)+,D0
	bmi.s	T_8F66
	beq.s	T_8F26
	cmp.b	#1,D0
	beq.s	T_8F6A
	bra.s	T_8F2C
;
T_8F26:
	move.b	(A1)+,D0
	lsl	D6,D0
	move.b	(A1)+,D0
T_8F2C:
	subq	#1,D0
	move.b	(A2)+,D1
	lsl	D6,D1
	move.b	(A2)+,D1
T_8F34:
	move	D1,(A0)
	lea	$A0(A0),A0
	addq	#1,D2
	cmp.w	#$C8,D2
	blt.s	T_8F5E
	moveq	#0,D2
	lea	-$7CF8(A0),A0
	addq	#1,D3
	cmp.w	#$14,D3
	blt.s	T_8F5E
	moveq	#0,D3
	addq	#2,D4
	cmp.w	#6,D4
	bgt.s	T_8F64
	lea	0(A3,D4.w),A0
T_8F5E:
	dbra	D0,T_8F34
	bra.s	T_8F16
;
T_8F64:
	rts
;
;
T_8F66:
	neg.b	D0
	bra.s	T_8F70
;
T_8F6A:
	move.b	(A1)+,D0
	lsl	D6,D0
	move.b	(A1)+,D0
T_8F70:
	subq	#1,D0
T_8F72:
	move.b	(A2)+,D1
	lsl	D6,D1
	move.b	(A2)+,D1
	move	D1,(A0)
	lea	$A0(A0),A0
	addq	#1,D2
	cmp.w	#$C8,D2
	blt.s	T_8FA2
	moveq	#0,D2
	lea	-$7CF8(A0),A0
	addq	#1,D3
	cmp.w	#$14,D3
	blt.s	T_8FA2
	moveq	#0,D3
	addq	#2,D4
	cmp.w	#6,D4
	bgt.s	T_8F64
	lea	0(A3,D4.w),A0
T_8FA2:
	dbra	D0,T_8F72
	bra	T_8F16
;
T_8FAA:
	lea	D_B202,A0
	lea	B_10DF8,A1
	moveq	#15,D1
T_8FB8:
	move	(A0)+,D0
	or	(A0)+,D0
	not.w	D0
	move	D0,(A1)+
	dbra	D1,T_8FB8
	rts
;
;
T_8FC6:
	move	mouse_pos_X,D0
	cmp.w	#$130,D0
	blt.s	T_8FD6
	move	#$130,D0
T_8FD6:
	move	D0,T_96C2
	move	mouse_pos_Y,D1
	cmp.w	#$B8,D1
	blt.s	T_8FEC
	move	#$B8,D1
T_8FEC:
	move	D1,T_96C4
	tst.b	mouse_work_f
	bgt.s	T_9018
	bmi.s	T_9010
	move.b	#$FF,mouse_work_f
	tst.b	T_96C6
	beq.s	T_9010
	bra	T_95D6
;
T_9010:
	sf	T_96C6
	rts
;
;
T_9018:
	tst.b	T_96C6
	beq.s	T_9024
	bsr	T_95D6
T_9024:
	lea	B_10E38,A0
	movea.l	T_8D68,A2
	move	T_96C2,D0
	move	D0,T_96BE
	andi	#-$10,D0
	lsr	#1,D0
	adda	D0,A2
	move	T_96C4,D0
	move	D0,T_96C0
	mulu	#$A0,D0
	adda	D0,A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	move.l	(A2)+,(A0)+
	lea	$90(A2),A2
	lea	B_10DF8,A0
	lea	D_B202,A1
	movea.l	T_8D68,A2
	move	T_96C2,D0
	move	D0,D1
	andi	#-$10,D0
	lsr	#1,D0
	adda	D0,A2
	move	T_96C4,D0
	mulu	#$A0,D0
	adda	D0,A2
	andi	#15,D1
	neg.w	D1
	addi	#15,D1
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	moveq	#-1,D6
	moveq	#0,D7
	move	(A0)+,D6
	move	(A1)+,D7
	rol.l	D1,D6
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	swap	D6
	moveq	#0,D7
	move	(A1)+,D7
	lsl.l	D1,D7
	and	D6,8(A2)
	and	D6,12(A2)
	or	D7,8(A2)
	swap	D6
	swap	D7
	and	D6,(A2)
	and	D6,4(A2)
	or	D7,(A2)+
	lea	$9C(A2),A2
	st	T_96C6
	rts
;
;
T_95D6:
	lea	B_10E38,A0
	movea.l	T_8D68,A2
	move	T_96BE,D0
	andi	#-$10,D0
	lsr	#1,D0
	adda	D0,A2
	move	T_96C0,D0
	mulu	#$A0,D0
	adda	D0,A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	move.l	(A0)+,(A2)+
	lea	$90(A2),A2
	rts
;
;
T_96BE:
	dc.b	$0,$0
T_96C0:
	dc.b	$0,$0
T_96C2:
	dc.b	$0,$0
T_96C4:
	dc.b	$0,$0
T_96C6:
	dc.b	$0
mouse_work_f:
	dc.b	$0
;
;
T_96C8:
	bsr	T_8FC6
	tst	vbi_counter
	ble.s	T_96DA
	subq	#1,vbi_counter
T_96DA:
	rts
;
;
chk_mouse_area:
	move	click_pos_X,D5
	move	click_pos_Y,D6
	movea.l	mouse_rect_ptp(PC),A0
T_96EC:
	move	(A0)+,D7
	bmi.s	T_9714
	move	(A0)+,D1
	move	(A0)+,D2
	move	(A0)+,D3
	move	(A0)+,D4
	cmp.w	D1,D5
	blt.s	T_9710
	cmp.w	D3,D5
	bgt.s	T_9710
	cmp.w	D2,D6
	blt.s	T_9710
	cmp.w	D4,D6
	bgt.s	T_9710
	move	D7,click_object
	rts
;
;
T_9710:
	dbra	D0,T_96EC
T_9714:
	rts
;
;
mouse_rect_ptp:
	dc.l	main_frect_t
;
;----------------------------------------------------------------------------
;
setnu_joymouse:
	xbios	Kbdvbase
	movea.l	D0,A0
	move.l	A0,kbdvbase_p
	move.l	$10(A0),o_mouse_pack_p
	move.l	$18(A0),o_joyst_pack_p
	move.l	#nu_mouse_pack,$10(A0)
	move.l	#nu_joyst_pack,$18(A0)
nu_joyst_pack:
	rts
;
;----------------------------------------------------------------------------
;
resto_joymouse:
	movea.l	kbdvbase_p,A0
	move.l	o_mouse_pack_p,$10(A0)
	move.l	o_joyst_pack_p,$18(A0)
	rts
;
;----------------------------------------------------------------------------
;
nu_mouse_pack:
	tst.b	mouse_work_f
	beq	nu_mouse_rts
	move	D0,-(SP)
	move.b	(A0)+,D0
	andi.b	#3,D0
	lsr.b	#1,D0
	bcc.s	T_977E
	ori.b	#2,D0
T_977E:
	move.b	D0,mouse_buttons
	beq.s	T_97A6
	move	mouse_pos_X,click_pos_X
	move	mouse_pos_Y,click_pos_Y
	movem.l	D0-A6,-(SP)
	moveq	#20,d0		;NEW: orig used garbage in low words high byte
	bsr	chk_mouse_area
	movem.l	(SP)+,D0-A6
T_97A6:
	move.b	(A0)+,D0
	ext.w	D0
	add	D0,mouse_pos_X
	cmpi	#3,mouse_pos_X
	bpl.s	T_97C2
	move	#3,mouse_pos_X
T_97C2:
	cmpi	#$13C,mouse_pos_X
	blt.s	T_97D4
	move	#$13C,mouse_pos_X
T_97D4:
	move.b	(A0)+,D0
	ext.w	D0
	add	D0,mouse_pos_Y
	cmpi	#3,mouse_pos_Y
	bpl.s	T_97F0
	move	#3,mouse_pos_Y
T_97F0:
	cmpi	#$C4,mouse_pos_Y
	blt.s	T_9802
	move	#$C4,mouse_pos_Y
T_9802:
	move	(SP)+,D0
nu_mouse_rts:
	rts
;
;----------------------------------------------------------------------------
;
src_file_type:
	dc.w	0	;0=TGA  1=IFF  2=GIF  3=RAW  4=PI1
;
src_obj_to_src_type_t:
	dc.b	5,0,3,2,1,4
;
pathlist_t:
;src_file types
	dc.l	TGA_path_s
	dc.l	IFF_path_s
	dc.l	GIF_path_s
	dc.l	RAW_path_s
	dc.l	PI1_path_s
;dest_file types
	dc.l	SPU_path_s
	dc.l	PCS_path_s
	dc.l	0
;
;
set_path_s_src:
	move	src_file_obj,d0
	beq.s	.default
	cmp	src_obj_to_src_type_t(pc),d0
	ble.s	.use_index
.default:
	moveq	#1,d0
.use_index:
	move	d0,src_file_obj
	move.b	src_obj_to_src_type_t(pc,d0),d0
	move.b	d0,src_file_type
	asl	#2,d0
	move.l	pathlist_t(pc,d0),current_path_p
;
	movea.l	current_path_p(pc),a0
	lea	fsel_filename_s(pc),a1
	jsr	old_name
	cmp.b	#'*',(a1)
	bne.s	.keep_name
	lea	main_path_s,a0
	jsr	old_name
.keep_name:
	movea.l	current_path_p(pc),a0
	jsr	cut_path_name
	lea	wild_name_s(pc),a1
	jsr	new_name
	move.l	typelist_t(pc,d0),a1
	jsr	new_type
	lea	load_prompt_s,a0
	jsr	new_type
	rts
  ;
wild_name_s:
	dc.b	'*',NUL
	even
;
typelist_t:
;src_file types
	dc.l	TGA_type_s
	dc.l	IFF_type_s
	dc.l	GIF_type_s
	dc.l	RAW_type_s
	dc.l	PI1_type_s
;dest_file types
	dc.l	SPU_type_s
	dc.l	PCS_type_s
	dc.l	0
;
TGA_type_s:	dc.b	'.TGA',NUL
IFF_type_s:	dc.b	'.IFF',NUL
GIF_type_s:	dc.b	'.GIF',NUL
RAW_type_s:	dc.b	'.RAW',NUL
PI1_type_s:	dc.b	'.PI1',NUL
SPU_type_s:	dc.b	'.SPU',NUL
PCS_type_s:	dc.b	'.PCS',NUL
	even
;
;----------------------------------------------------------------------------
;
fsel_and_load:
	move.l	#B_1C678,D_10A54
	tst	next_arg
	bgt.s	.have_arg
	lea	load_prompt_s,a0
	move.l	a0,prompt_s_p
	bsr	prep_file_select
	bsr	fsel_input_sub
	bsr	post_file_select
	tst	intout+2
	beq	done_load
	tst.l	D0
	bne	done_load
	tst.b	fsel_filename_s
	seq	d0
	beq	done_load
.have_arg:
	clr	next_arg
	bsr	clear_32000_i_T_8D64
	bsr	copy_32000_i_T_8D64_i_T_8D68
;
	movea.l	current_path_p(pc),a0
	jsr	fix_path
	lea	load_pathname_s(pc),a1
	jsr	old_path
	lea	load_pathname_s(pc),a0
	lea	fsel_filename_s(pc),a1
	jsr	new_name
	movea.l	current_path_p(pc),a0
	jsr	new_name
;
	lea	load_pathname_s(PC),A1
.T_98E8:
	tst.b	(A1)+
	bne.s	.T_98E8
	subq	#5,A1
	moveq	#4-1,D0
.T_98F0:
	cmpi.b	#'.',(A1)+
	beq.s	.T_98FE
	dbra	D0,.T_98F0
	move.b	#'.',(A1)+
	clr.b	(a1)
.T_98FE:
	move.l	A1,T_A6D4
;src_file_type is defined as... 0=TGA  1=IFF  2=GIF  3=RAW  4=PI1
	cmpi.b	#0,src_file_type	;TGA src ?
	beq.s	load_TGA
	cmpi.b	#3,src_file_type	;RAW src ?
	beq	load_RAW
	cmpi.b	#4,src_file_type	;PI1 src ?
	beq	load_PI1
	cmpi.b	#2,src_file_type	;GIF src ?
	beq	load_GIF
load_IFF:
	move.l	D_10A54(PC),T_A6D0
	move.l	#$3E800,T_A6CC
	bsr	T_A4F4
	bne	done_load
	move.l	T_A6CC(PC),D1
	add.l	D1,D_10A54
	bra	done_load
;
load_TGA:
	movem.l	D0-A6,-(SP)
	bsr	rest_interrupt
	movem.l	(SP)+,D0-A6
	move.l	#B_17B58,B_10A5C
	bsr	.T_9A4C
	tst	D0
	bmi	.T_9A3C
	move	B_10AA8,D0
	move	B_10AAA,D1
	move	d0,orig_width
	move	d1,orig_height
	move	D0,D2
	mulu	#3,D2
	movea.l	D_10A54,A1
	move	D0,D4
	mulu	#3,D4
	bsr	T_A3C0
	move.l	A1,B_10AA4
	move	D1,D3
	mulu	D4,D3
	adda.l	D3,A1
	move.l	A1,D_10A54
	jsr	.T_9B08
	tst	D0
	bmi	.T_9A3C
	tst	B_10A76
	bpl	.T_9A2C
	movea.l	B_10AA4,A0
	move	B_10AAA,D0
	subq	#1,D0
	mulu	#3,D0
	mulu	B_10AA8,D0
	movea.l	A0,A1
	adda.l	D0,A1
	move	B_10AA8,D0
	mulu	#3,D0
	movea	D0,A6
	move	B_10AAA,D7
	lsr	#1,D7
	subq	#1,D7
.load_TGA_loop_1:
	movea.l	A0,A2
	movea.l	A1,A3
	adda.l	A6,A0
	suba.l	A6,A1
	move	B_10AA8,D6
	subq	#1,D6
.load_TGA_loop_2:
	move.b	(A2)+,D1
	move.b	(A2)+,D2
	move.b	(A2)+,D3
	move.b	(A3)+,-$3(A2)
	move.b	(A3)+,-$2(A2)
	move.b	(A3)+,-$1(A2)
	move.b	D1,-$3(A3)
	move.b	D2,-$2(A3)
	move.b	D3,-$1(A3)
	dbra	D6,.load_TGA_loop_2
	dbra	D7,.load_TGA_loop_1
.T_9A2C:
	movem.l	D0-A6,-(SP)
	bsr	save_interrupt
	movem.l	(SP)+,D0-A6
	moveq	#0,D0
	rts
;
;------------------------------------
;
.T_9A3C:
	movem.l	D0-A6,-(SP)
	bsr	save_interrupt
	movem.l	(SP)+,D0-A6
	moveq	#-1,D0
	rts
;
;------------------------------------
;
.T_9A4C:
	lea	load_pathname_s,A0
	jsr	.T_9AE0
	move.l	D0,B_10A9C
	lea	load_pathname_s,A0
	bsr	Fopen_ia0_0
	move	D0,B_10A7C
	bpl.s	.T_9A74
	moveq	#-1,D0
	rts
;
;------------------------------------
;
.T_9A74:
	moveq	#$12,D1
	sub.l	D1,B_10A9C
	lea	B_10A60,A0
	bsr	Fread_d0_d1_a0
	lea	B_10A60,A6
	move.b	2(A6),D0
	move.b	D0,B_10A7A
	move	12(A6),D0
	ror	#8,D0
	move	D0,B_10AA8
	move	14(A6),D0
	ror	#8,D0
	move	D0,B_10AAA
	moveq	#0,D0
	move.b	$10(A6),D0
	move	D0,B_10AAC
	move.b	$11(A6),B_10AAE
	move	#1,B_10A76
	moveq	#$20,D0
	and.b	B_10AAE,D0
	bne.s	.T_9ADC
	move	#-$1,B_10A76
.T_9ADC:
	moveq	#0,D0
	rts
;
;------------------------------------
;
.T_9AE0:
	move	#0,-(SP)	;push 0 as modebyte arg of Fsfirst
	move.l	A0,-(SP)	;push -> filepath as arg of Fsfirst
	gemdos	Fgetdta		;Fgetdta
	move.l	D0,B_10DDE
	gemdos	Fsfirst,(),()	;Fsfirst has args on stack
	movea.l	B_10DDE,A0	;a0 -> DTA
	move.l	$1A(A0),D0	;d0 = filesize from DTA
	rts
;
;------------------------------------
;
.T_9B08:
	move.b	B_10A7A,D0
	cmp.b	#2,D0
	beq	.T_9B2C
	cmp.b	#10,D0
	beq	.T_9B2C
	move	B_10A7C,D0
	bsr	Fclose_d0
	moveq	#-1,D0
	rts
;
;------------------------------------
;
.T_9B2C:
	move	B_10AA8,D0
	mulu	B_10AAA,D0
	move.l	D0,B_10A80
	lea	B_10A60,A6
	move.b	0(A6),D0
	beq.s	.T_9B70
	movem.l	D0-A6,-(SP)
	andi.l	#$FF,D0
	move.l	D0,D1
	sub.l	D1,B_10A9C
	move	B_10A7C,D0
	movea.l	B_10AA4,A0
	bsr	Fread_d0_d1_a0
	movem.l	(SP)+,D0-A6
.T_9B70:
	bsr	.T_9B82
	move	B_10A7C,D0
	bsr	Fclose_d0
	moveq	#0,D0
	rts
;
;------------------------------------
;
.T_9B82:
	cmpi	#$18,B_10AAC
	beq.s	.T_9B9A
	cmpi	#$20,B_10AAC
	beq.s	.T_9B9E
	moveq	#0,D0
	bra.s	.T_9BA0
;
.T_9B9A:
	moveq	#1,D0
	bra.s	.T_9BA0
;
.T_9B9E:
	moveq	#2,D0
.T_9BA0:
	add	D0,D0
	cmpi.b	#10,B_10A7A
	bne.s	.T_9BAE
	addq	#1,D0
.T_9BAE:
	lea	.T_9BFC,A6
	lsl	#2,D0
	move.l	0(A6,D0.w),B_10A72
	clr	B_10A7E
	move.l	B_10AA4,-(SP)
.T_9BCA:
	jsr	T_A128
	movea.l	B_10AA4,A1
	movea.l	B_10A72,A6
	jsr	(A6)
	move.l	A1,B_10AA4
	tst.l	B_10A9C
	ble.s	.T_9BF4
	tst.l	B_10A80
	bgt.s	.T_9BCA
.T_9BF4:
	move.l	(SP)+,B_10AA4
	rts
;
;------------------------------------
;
.T_9BFC:
	dc.l	T_A0B8
	dc.l	.T_9C28
	dc.l	T_A0EA
	dc.l	T_9D92
	dc.l	T_A108
	dc.l	T_9F20
;
;------------------------------------
;
.T_9C14:
	dc.l	T_9C42
	dc.l	T_9C5E
	dc.l	T_9D20
	dc.l	T_9C8E
	dc.l	T_9C76
;
;------------------------------------
;
.T_9C28:
	movea.l	B_10A5C,A0
	move	B_10A7E,D0
	lsl	#2,D0
	lea	.T_9C14,A6
	movea.l	0(A6,D0.w),A6
	jmp	(A6)
;
;------------------------------------
;
T_9C42:
	moveq	#0,D7
	move.b	(A0)+,D7
	move	D7,B_10A96
	move	#1,B_10A7E
	subq.l	#1,B_10AA0
	beq	T_9D74
T_9C5E:
	move	B_10A96,D7
	tst.b	D7
	bmi	T_9CFE
	andi	#$7F,D7
	addq	#1,D7
	move	D7,B_10A98
T_9C76:
	move	#3,B_10A7E
	move.b	(A0)+,B_10A90
	subq.l	#1,B_10AA0
	beq	T_9D74
T_9C8E:
	move	#4,B_10A7E
	move.b	B_10A90,D0
	ror	#8,D0
	move.b	(A0)+,D0
	ror	#8,D0
	move	D0,D1
	move	D0,D2
	andi	#$7C00,D0
	andi	#$3E0,D1
	andi	#$1F,D2
	lsr	#7,D0
	lsr	#3,D1
	lsl	#3,D2
	move.b	D0,(A1)+
	move.b	D1,(A1)+
	move.b	D2,(A1)+
	subq.l	#1,B_10A80
	beq	T_9D74
	subq	#1,B_10A98
	subq.l	#1,B_10AA0
	move.l	B_10AA0,D0
	or	B_10A98,D0
	tst.l	D0
	beq	T_9D6C
	tst.l	B_10AA0
	beq	T_9D74
	tst	B_10A98
	bne	T_9C76
	bra	T_9C42
;
T_9CFE:
	andi	#$7F,D7
	move	D7,B_10A9A
	move	#2,B_10A7E
	move.b	(A0)+,B_10A94
	subq.l	#1,B_10AA0
	beq	T_9D74
T_9D20:
	move	B_10A9A,D7
	move.b	B_10A94,D0
	ror	#8,D0
	move.b	(A0)+,D0
	ror	#8,D0
	subq.l	#1,B_10AA0
	move	D0,D1
	move	D0,D2
	andi	#$7C00,D0
	andi	#$3E0,D1
	andi	#$1F,D2
	lsr	#7,D0
	lsr	#3,D1
	lsl	#3,D2
T_9D4E:
	move.b	D0,(A1)+
	move.b	D1,(A1)+
	move.b	D2,(A1)+
	subq.l	#1,B_10A80
	beq	T_9D74
	dbra	D7,T_9D4E
	tst.l	B_10AA0
	bne	T_9C42
T_9D6C:
	move	#0,B_10A7E
T_9D74:
	rts
;
;
T_9D76:
	dc.l	T_9DAC
	dc.l	T_9DC8
	dc.l	T_9E92
	dc.l	T_9EB0
	dc.l	T_9DF8
	dc.l	T_9E10
	dc.l	T_9DE0
T_9D92:
	movea.l	B_10A5C,A0
	move	B_10A7E,D0
	lsl	#2,D0
	lea	T_9D76,A6
	movea.l	0(A6,D0.w),A6
	jmp	(A6)
;
T_9DAC:
	moveq	#0,D7
	move.b	(A0)+,D7
	move	D7,B_10A96
	move	#1,B_10A7E
	subq.l	#1,B_10AA0
	beq	T_9EFA
T_9DC8:
	move	B_10A96,D7
	tst.b	D7
	bmi	T_9E70
	andi	#$7F,D7
	addq	#1,D7
	move	D7,B_10A98
T_9DE0:
	move	#4,B_10A7E
	move.b	(A0)+,B_10A8A
	subq.l	#1,B_10AA0
	beq	T_9EFA
T_9DF8:
	move	#5,B_10A7E
	move.b	(A0)+,B_10A8C
	subq.l	#1,B_10AA0
	beq	T_9EFA
T_9E10:
	move	#6,B_10A7E
	move.b	(A0)+,B_10A8E
	move.b	B_10A8E,(A1)+
	move.b	B_10A8C,(A1)+
	move.b	B_10A8A,(A1)+
	subq.l	#1,B_10A80
	beq	T_9EFA
	subq	#1,B_10A98
	subq.l	#1,B_10AA0
	move.l	B_10AA0,D0
	or	B_10A98,D0
	tst.l	D0
	beq	T_9EF2
	tst.l	B_10AA0
	beq	T_9EFA
	tst	B_10A98
	bne	T_9DE0
	bra	T_9DAC
;
T_9E70:
	andi	#$7F,D7
	move	D7,B_10A9A
	move	#2,B_10A7E
	move.b	(A0)+,B_10A84
	subq.l	#1,B_10AA0
	beq	T_9EFA
T_9E92:
	move	B_10A9A,D7
	move	#3,B_10A7E
	move.b	(A0)+,B_10A86
	subq.l	#1,B_10AA0
	beq	T_9EFA
T_9EB0:
	move	B_10A9A,D7
	move.b	(A0)+,B_10A88
	subq.l	#1,B_10AA0
	move.b	B_10A88,D1
	move.b	B_10A86,D2
	move.b	B_10A84,D3
T_9ED4:
	move.b	D1,(A1)+
	move.b	D2,(A1)+
	move.b	D3,(A1)+
	subq.l	#1,B_10A80
	beq	T_9EFA
	dbra	D7,T_9ED4
	tst.l	B_10AA0
	bne	T_9DAC
T_9EF2:
	move	#0,B_10A7E
T_9EFA:
	rts
;
;
T_9EFC:
	dc.l	T_9F3A
	dc.l	T_9F56
	dc.l	T_A034
	dc.l	T_A052
	dc.l	T_A070
	dc.l	T_9F86
	dc.l	T_9F9E
	dc.l	T_9FB6
	dc.l	T_9F6E
T_9F20:
	movea.l	B_10A5C,A0
	move	B_10A7E,D0
	lsl	#2,D0
	lea	T_9EFC,A6
	movea.l	0(A6,D0.w),A6
	jmp	(A6)
;
T_9F3A:
	moveq	#0,D7
	move.b	(A0)+,D7
	move	D7,B_10A96
	move	#1,B_10A7E
	subq.l	#1,B_10AA0
	beq	T_A0B6
T_9F56:
	move	B_10A96,D7
	tst.b	D7
	bmi	T_A012
	andi	#$7F,D7
	addq	#1,D7
	move	D7,B_10A98
T_9F6E:
	move	#5,B_10A7E
	move.b	(A0)+,B_10A8E
	subq.l	#1,B_10AA0
	beq	T_A0B6
T_9F86:
	move	#6,B_10A7E
	move.b	(A0)+,B_10A8C
	subq.l	#1,B_10AA0
	beq	T_A0B6
T_9F9E:
	move	#7,B_10A7E
	move.b	(A0)+,B_10A8A
	subq.l	#1,B_10AA0
	beq	T_A0B6
T_9FB6:
	move	#8,B_10A7E
	addq.l	#1,A0
	move.b	B_10A8A,(A1)+
	move.b	B_10A8C,(A1)+
	move.b	B_10A8E,(A1)+
	subq.l	#1,B_10A80
	beq	T_A0B6
	subq	#1,B_10A98
	subq.l	#1,B_10AA0
	move.l	B_10AA0,D0
	or	B_10A98,D0
	tst.l	D0
	beq	T_A0AE
	tst.l	B_10AA0
	beq	T_A0B6
	tst	B_10A98
	bne	T_9F6E
	bra	T_9F3A
;
T_A012:
	andi	#$7F,D7
	move	D7,B_10A9A
	move	#2,B_10A7E
	move.b	(A0)+,B_10A88
	subq.l	#1,B_10AA0
	beq	T_A0B6
T_A034:
	move	B_10A9A,D7
	move	#3,B_10A7E
	move.b	(A0)+,B_10A86
	subq.l	#1,B_10AA0
	beq	T_A0B6
T_A052:
	move	B_10A9A,D7
	move	#4,B_10A7E
	move.b	(A0)+,B_10A84
	subq.l	#1,B_10AA0
	beq	T_A0B6
T_A070:
	move	B_10A9A,D7
	addq.l	#1,A0
	subq.l	#1,B_10AA0
	move.b	B_10A84,D1
	move.b	B_10A86,D2
	move.b	B_10A88,D3
T_A090:
	move.b	D1,(A1)+
	move.b	D2,(A1)+
	move.b	D3,(A1)+
	subq.l	#1,B_10A80
	beq	T_A0B6
	dbra	D7,T_A090
	tst.l	B_10AA0
	bne	T_9F3A
T_A0AE:
	move	#0,B_10A7E
T_A0B6:
	rts
;
;
T_A0B8:
	movea.l	B_10A5C,A0
	move.l	B_10AA0,D7
T_A0C4:
	move	(A0)+,D0
	ror	#8,D0
	move	D0,D1
	move	D0,D2
	andi	#$7C00,D0
	andi	#$3E0,D1
	andi	#$1F,D2
	lsr	#7,D0
	lsr	#3,D1
	lsl	#3,D2
	move.b	D0,(A1)+
	move.b	D1,(A1)+
	move.b	D2,(A1)+
	subq.l	#2,D7
	bgt.s	T_A0C4
	rts
;
;
T_A0EA:
	movea.l	B_10A5C,A0
	move.l	B_10AA0,D7
T_A0F6:
	move.b	(A0)+,D3
	move.b	(A0)+,D2
	move.b	(A0)+,D1
	move.b	D1,(A1)+
	move.b	D2,(A1)+
	move.b	D3,(A1)+
	subq.l	#3,D7
	bgt.s	T_A0F6
	rts
;
;
T_A108:
	movea.l	B_10A5C,A0
	move.l	B_10AA0,D7
T_A114:
	move.b	(A0)+,D3
	move.b	(A0)+,D2
	move.b	(A0)+,D1
	addq.l	#1,A0
	move.b	D1,(A1)+
	move.b	D2,(A1)+
	move.b	D3,(A1)+
	subq.l	#4,D7
	bgt.s	T_A114
	rts
;
;
T_A128:
	move.l	B_10A9C,D0
	move.l	T_A160,D1
	sub.l	D1,D0
	bpl.s	T_A140
	moveq	#0,D0
	move.l	B_10A9C,D1
T_A140:
	move.l	D0,B_10A9C
	move.l	D1,B_10AA0
	move	B_10A7C,D0
	movea.l	B_10A5C,A0
	jsr	Fread_d0_d1_a0
	rts
;
;
T_A160:
	dc.l	$00002EE0
;
;
Fopen_ia0_0:
	gemdos	Fopen,(a0),#0
	rts
;
;
Fclose_d0:
	gemdos	Fclose,d0
	rts
;
;
Fread_d0_d1_a0:
	gemdos	Fread,d0,d1,(a0)
	rts
;
;----------------------------------------------------------------------------
;
load_RAW:
	movem.l	D0-A6,-(SP)
	bsr	rest_interrupt
	movem.l	(SP)+,D0-A6
	gemdos	Fopen,load_pathname_s,!
	tst	D0
	bmi	T_A2B8
	move	D0,T_A6CA
	gemdos	Fread,T_A6CA,#4,B_17B58
	lea	B_17B58,A0
	move	(A0)+,D0
	ror	#8,D0
	move	(A0)+,D1
	ror	#8,D1
	move	d0,orig_width
	move	d1,orig_height
	tst	D0
	bmi	T_A276
	tst	D1
	bmi	T_A276
	cmp	#320,D0
	bgt	T_A276
	cmp	#200,D1
	bgt	T_A276
	move	D0,D2
	mulu	#3,D2
	addq	#2,D2
	cmp	#200,D1
	ble.s	T_A212
	move	#200,D1
T_A212:
	cmp.w	#320,D0
	ble.s	T_A21C
	move	#320,D0
T_A21C:
	movea.l	D_10A54,A1
	bsr	T_A3C0
	subq	#1,D1
T_A228:
	movem.l	D0-A6,-(SP)
	gemdos	Fread,T_A6CA,D2,B_17B58
	movem.l	(SP)+,D0-A6
	lea	B_17B5A,A0
	move	D0,D7
	subq	#1,D7
T_A252:
	moveq	#0,D6
	move.b	0(A0,D6.w),(A1)+
	add	D0,D6
	move.b	0(A0,D6.w),(A1)+
	add	D0,D6
	move.b	0(A0,D6.w),(A1)+
	addq	#1,A0
	dbra	D7,T_A252
	dbra	D1,T_A228
	move.l	A1,D_10A54
	bra.s	T_A2A4
;
T_A276:
	move.l	#$2EE04,D0
	lea	B_17B58,A0
	movea.l	D_10A54,A1
	move.l	(A0)+,(A1)+
	movea.l	A1,A0
	bsr	Fread_T_A6CA_d0_ia0
	addi.l	#$2EE08,D_10A54
	move.l	D_10A54,T_A6D0
T_A2A4:
	bsr	Fclose_T_A6CA
	movem.l	D0-A6,-(SP)
	bsr	save_interrupt
	movem.l	(SP)+,D0-A6
	moveq	#0,D0
	rts
;
;
T_A2B8:
	movem.l	D0-A6,-(SP)
	bsr	save_interrupt
	movem.l	(SP)+,D0-A6
	moveq	#-1,D0
	rts
;
;----------------------------------------------------------------------------
;
load_GIF:
	move.l	D_10A54(PC),T_A6D0
	move.l	#8,T_A6CC
	jsr	load_GIF_sub
	tst	D0
	bne	done_load
	move.l	T_A6CC(PC),D1
	add.l	D1,D_10A54
	bra	done_load
;
;----------------------------------------------------------------------------
;
load_PI1:
	move	#320,orig_width
	move	#200,orig_height
	move.l	D_10A54(PC),T_A6D0
	move.l	#32066,T_A6CC
	movea.l	T_A6D4(PC),A0
	move.b	#'R',-$2(A0)
	move.b	#'.',-$1(A0)
	move.b	#'P',(A0)+
	move.b	#'I',(A0)+
	move.b	#'1',(A0)+
	bsr	T_A4F4
	bne	done_load
	move.l	T_A6D0,B_10AC0
	move.l	T_A6CC(PC),D1
	add.l	D1,D_10A54
	add.l	D1,T_A6D0
	movea.l	T_A6D4(PC),A0
	move.b	#'G',-$2(A0)
	move.b	#'.',-$1(A0)
	move.b	#'P',(A0)+
	move.b	#'I',(A0)+
	move.b	#'1',(A0)+
	bsr	T_A4F4
	bne.s	done_load
	move.l	T_A6D0,B_10AC4
	move.l	T_A6CC(PC),D1
	add.l	D1,D_10A54
	add.l	D1,T_A6D0
	movea.l	T_A6D4(PC),A0
	move.b	#'B',-$2(A0)
	move.b	#'.',-$1(A0)
	move.b	#'P',(A0)+
	move.b	#'I',(A0)+
	move.b	#'1',(A0)+
	bsr	T_A4F4
	bne.s	done_load
	move.l	T_A6D0,B_10AC8
	move.l	T_A6CC(PC),D1
	add.l	D1,D_10A54
	add.l	D1,T_A6D0
done_load:
	tst.l	D0
	rts
;
;----------------------------------------------------------------------------
;
T_A3C0:
	lea	B_17B68,A0
	move.b	#10,-(A0)
	move	D1,D7
T_A3CC:
	tst	D7
	beq.s	T_A3E2
	ext.l	D7
	divu	#10,D7
	move.l	D7,D6
	swap	D6
	addi	#$30,D6
	move.b	D6,-(A0)
	bra.s	T_A3CC
;
T_A3E2:
	move.b	#$20,-(A0)
	move	D0,D7
T_A3E8:
	tst	D7
	beq.s	T_A3FE
	ext.l	D7
	divu	#10,D7
	move.l	D7,D6
	swap	D6
	addi	#$30,D6
	move.b	D6,-(A0)
	bra.s	T_A3E8
;
T_A3FE:
	move.b	(A0)+,D6
	move.b	D6,(A1)+
	cmp.b	#10,D6
	bne.s	T_A3FE
	rts
;
;----------------------------------------------------------------------------
;
fsel_and_save:
	cmpi.b	#0,T_1075
	beq.s	fsel_save_SPU
	cmpi.b	#1,T_1075
	beq.s	fsel_save_SPU
fsel_save_PCS:
	jsr	T_A6E0
	lea	PCS_type_s(pc),a0
	move.l	a0,dest_type_s_p
	bra.s	fsel_save_common
;
fsel_save_SPU:
	lea	B_38D98,A1
	movea.l	B_10AB0,A0
	move	#$1F3F,D0
.T_A448:
	move.l	(A0)+,(A1)+
	dbra	D0,.T_A448
	lea	B_17B58,A0
	move	#$12A7,D0
.T_A458:
	move.l	(A0)+,(A1)+
	dbra	D0,.T_A458
	move.l	#SPU_path_s,current_path_p
	move.l	#B_38D98,T_A6D0
	move.l	#$C7A0,T_A6CC
	lea	SPU_type_s(pc),a0
	move.l	a0,dest_type_s_p
fsel_save_common:
;
	lea	save_prompt_s,a0
	move.l	a0,prompt_s_p
	move.l	dest_type_s_p(pc),a1
	jsr	new_type
;
	movea.l	current_path_p(pc),a0
	jsr	cut_path_name
	lea	wild_name_s(pc),a1
	jsr	new_name
	move.l	dest_type_s_p(pc),a1
	jsr	new_type
	lea	fsel_filename_s(pc),a0
	move.l	dest_type_s_p(pc),a1
	jsr	new_type
;
	bsr	prep_file_select
	bsr	fsel_input_sub
	bsr	post_file_select
;
	tst	intout+2
	beq.s	.exit
	tst.l	D0
	bne.s	.exit
	tst.b	fsel_filename_s
	beq.s	.exit
;
	bsr	clear_32000_i_T_8D64
	bsr	copy_32000_i_T_8D64_i_T_8D68
;
	lea	fsel_filename_s(pc),a0
	move.l	dest_type_s_p(pc),a1
	jsr	new_type
	movea.l	current_path_p(pc),a0
	lea	save_pathname_s(pc),a1
	jsr	old_path
	lea	save_pathname_s(pc),a0
	lea	fsel_filename_s(pc),a1
	jsr	new_name
	bsr	save_file
.exit
	rts
;
;----------------------------------------------------------------------------
;
T_A4F4:
	movem.l	D0-A6,-(SP)
	bsr	rest_interrupt
	movem.l	(SP)+,D0-A6
	bsr	Fload_load_pathname_s_T_A6CC_iT_A6D0
	movem.l	D0-A6,-(SP)
	bsr	save_interrupt
	movem.l	(SP)+,D0-A6
	tst.l	D0
	rts
;
;----------------------------------------------------------------------------
;
save_file:
	movem.l	D0-A6,-(SP)
	bsr	rest_interrupt
	movem.l	(SP)+,D0-A6
	movea.l	current_path_p,A1
	move.b	(A1),D1
	subi.b	#$40,D1
	andi	#$FF,D1
	gemdos	Dfree,T_A598(pc),d1
	tst.l	D0
	bne.s	T_A584
	lea	T_A598(PC),A1
	move.l	(A1)+,D1
	addq	#4,A1
	move.l	(A1)+,D2
	move.l	(A1)+,D3
	move.l	T_A6CC(PC),D4
	mulu	D2,D3
	divu	D3,D4
	ext.l	D4
	addq	#1,D4
	cmp.l	D4,D1
	ble.s	T_A572
	bsr	Fsave_save_pathname_s_T_A6CC_iT_A6D0
T_A562:
	movem.l	D0-A6,-(SP)
	bsr	save_interrupt
	movem.l	(SP)+,D0-A6
	tst.l	D0
	rts
;
;----------------------------------------------------------------------------
;
T_A572:
	gemdos	Cconws,T_A5A8(PC)
	bsr	Crawcin_sub
	bra.s	T_A594
;
;----------------------------------------------------------------------------
;
T_A584:
	gemdos	Cconws,T_A5CB(PC)
	bsr	Crawcin_sub
T_A594:
	moveq	#-1,D0
	bra.s	T_A562
;
;----------------------------------------------------------------------------
;
T_A598:
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0
;
T_A5A8:
	dc.b	ESC,'Y',' '+12,' '+5
	dc.b	'YOUR DISK SEEMS TO BE FULL UP.'
	dc.b	NUL
;
T_A5CB:
	dc.b	ESC,'Y',' '+12,' '+0
	dc.b	'THERE SEEMS TO BE A DISK-READING ERROR.'
	dc.b	NUL
;
	even
;
;----------------------------------------------------------------------------
;
Fload_load_pathname_s_T_A6CC_iT_A6D0:
	gemdos	Fopen,load_pathname_s(pc),!
	move.l	D0,D5
	tst.l	D0
	bmi.s	.T_A62E
	gemdos	Fread|_ind,d5,T_A6CC(pc),T_A6D0(pc)
	tst.l	D0
	bpl.s	.T_A632
	gemdos	Fclose,d5
.T_A62E:
	moveq	#-1,D0
	rts
;
.T_A632:
	move.l	D0,T_A6CC
	gemdos	Fclose,d5
	moveq	#0,D0
	rts
;
;----------------------------------------------------------------------------
;
Fsave_save_pathname_s_T_A6CC_iT_A6D0:
	bsr.s	Fdelete_save_pathname_s
	bsr.s	Fcreate_save_pathname_s_0_to_T_A6CA
	bsr.s	Fwrite_T_A6CA_T_A6CC_iT_A6D0
	bsr.s	Fclose_T_A6CA
	rts
;
;----------------------------------------------------------------------------
;
Fdelete_save_pathname_s:
	gemdos	Fdelete,save_pathname_s(pc)
	rts
;
;----------------------------------------------------------------------------
;
Fcreate_save_pathname_s_0_to_T_A6CA:
	gemdos	Fcreate,save_pathname_s(pc),#0
	move	D0,T_A6CA
	rts
;
;----------------------------------------------------------------------------
;
Fclose_T_A6CA:
	gemdos	Fclose,T_A6CA(pc)
	rts
;
;----------------------------------------------------------------------------
;
Fwrite_T_A6CA_T_A6CC_iT_A6D0:
	move.l	T_A6CC(PC),D0
	gemdos	Fwrite|_ind,T_A6CA(pc),d0,T_A6D0(pc)
	rts
;
;----------------------------------------------------------------------------
;
Fread_T_A6CA_d0_ia0:
	gemdos	Fread,T_A6CA(pc),d0,(a0)
	rts
;
;----------------------------------------------------------------------------
;
T_A6CA:
	dc.w	0
T_A6CC:
	dc.l	0
T_A6D0:
	dc.l	0
T_A6D4:
	dc.l	0
;
TOS_version:
	dc.w	0
prompt_s_p:
	dc.l	0
load_prompt_s:
	dc.b	'Load (must be) *.GIF',0
	ds.b	load_prompt_s+32-*
save_prompt_s:
	dc.b	'Save (will be) *.SPU',0
	ds.b	save_prompt_s+32-*
dest_type_s_p:
	dc.l	0
;
current_path_p:
	dc.l	0
	dc.l	0
;
;----------------------------------------------------------------------------
;
T_A6E0:
	move.b	sync_request,D7
	beq.s	T_A6F2
	andi.b	#3,D7
	move.b	D7,sync_mode
T_A6F2:
	movea.l	B_10AB0,A2
	moveq	#$27,D0
T_A6FA:
	clr.l	(A2)+
	dbra	D0,T_A6FA
	movea.l	B_10AB4,A2
	moveq	#$27,D0
T_A708:
	clr.l	(A2)+
	dbra	D0,T_A708
	lea	B_38D98,A2
	lea	6(A2),A1
	move	#$140,0(A2)
	move	#$C8,2(A2)
	sf	4(A2)
	tst.b	T_1074
	sne	4(A2)
	sf	5(A2)
	cmpi.b	#3,B_10ACD
	seq	5(A2)
	bclr	#0,5(A2)
	tst.b	sync_mode
	beq.s	T_A756
	bset	#0,5(A2)
T_A756:
	bsr.s	T_A786
	tst.b	T_1074
	beq.s	T_A762
	bsr.s	T_A79C
T_A762:
	move.l	A1,D0
	subi.l	#B_38D98,D0
	move.l	D0,T_A6CC
	move.l	#B_38D98,T_A6D0
	move.l	#PCS_path_s,current_path_p
	rts
;
;----------------------------------------------------------------------------
;
T_A786:
	movea.l	B_10AB0,A0
	bsr	T_A84A
	lea	B_17B58,A0
	bsr	T_A92C
	rts
;
;
T_A79C:
	movea.l	A1,A3
	movea.l	B_10AB4,A0
	bsr	T_A84A
	move.l	D0,D1
	bsr.s	T_A7FA
	movea.l	B_10AB4,A0
	movea.l	A3,A1
	bsr	T_A84A
	cmp.l	D1,D0
	blt.s	T_A7CA
	bsr.s	T_A7FA
	movea.l	B_10AB4,A0
	movea.l	A3,A1
	bsr	T_A84A
T_A7CA:
	movea.l	A1,A3
	lea	B_24678,A0
	bsr	T_A92C
	move.l	D0,D1
	bsr.s	T_A822
	lea	B_24678,A0
	movea.l	A3,A1
	bsr	T_A92C
	cmp.l	D1,D0
	blt.s	T_A7F8
	bsr.s	T_A822
	lea	B_24678,A0
	movea.l	A3,A1
	bsr	T_A92C
T_A7F8:
	rts
;
;----------------------------------------------------------------------------
;
T_A7FA:
	bchg	#0,4(A2)
	movem.l	D0-A6,-(SP)
	movea.l	B_10AB0,A0
	movea.l	B_10AB4,A1
	move	#$1F3F,D0
T_A814:
	move.l	(A0)+,D1
	eor.l	D1,(A1)+
	dbra	D0,T_A814
	movem.l	(SP)+,D0-A6
	rts
;
;----------------------------------------------------------------------------
;
T_A822:
	bchg	#1,4(A2)
	movem.l	D0-A6,-(SP)
	lea	B_17B58,A0
	lea	B_24678,A1
	move	#$255F,D0
T_A83C:
	move	(A0)+,D1
	eor	D1,(A1)+
	dbra	D0,T_A83C
	movem.l	(SP)+,D0-A6
	rts
;
;----------------------------------------------------------------------------
;
T_A84A:
	move.l	A1,D7
	movem.l	D0-A0/A2-A6,-(SP)
	bsr	T_AA22
	lea	B_29198,A2
	lea	B_30F98,A3
	movea.l	A3,A4
	movea.l	A1,A5
	addq	#2,A1
	move	#$7D00,D1
	moveq	#0,D2
	moveq	#1,D3
	move.b	(A2)+,D6
	moveq	#0,D7
T_A872:
	subq	#1,D1
	bmi.s	T_A890
	move.b	D6,D0
	move.b	(A2)+,D6
	move.b	D0,(A4)+
	addq	#1,D2
	cmp.b	D6,D0
	bne.s	T_A886
	addq	#1,D3
	bra.s	T_A872
;
T_A886:
	cmp.w	#4,D3
	bge.s	T_A890
	moveq	#1,D3
	bra.s	T_A872
;
T_A890:
	cmp.w	#3,D3
	bgt.s	T_A8C8
	addq	#1,D7
	cmp.w	#1,D3
	bgt.s	T_A8A0
	moveq	#0,D3
T_A8A0:
	add	D3,D2
	cmp.w	#$7F,D2
	bgt.s	T_A8B0
	neg.b	D2
	move.b	D2,(A1)+
	neg.b	D2
	bra.s	T_A8BC
;
T_A8B0:
	move.b	#1,(A1)+
	ror	#8,D2
	move.b	D2,(A1)+
	ror	#8,D2
	move.b	D2,(A1)+
T_A8BC:
	subq	#1,D2
	movea.l	A3,A4
T_A8C0:
	move.b	(A4)+,(A1)+
	dbra	D2,T_A8C0
	bra.s	T_A91A
;
T_A8C8:
	sub.w	D3,D2
	ble.s	T_A8F4
	addq	#1,D7
	cmp.w	#$7F,D2
	bgt.s	T_A8DC
	neg.b	D2
	move.b	D2,(A1)+
	neg.b	D2
	bra.s	T_A8E8
;
T_A8DC:
	move.b	#1,(A1)+
	ror	#8,D2
	move.b	D2,(A1)+
	ror	#8,D2
	move.b	D2,(A1)+
T_A8E8:
	subq	#1,D2
	movea.l	A3,A4
T_A8EC:
	move.b	(A4)+,(A1)+
	dbra	D2,T_A8EC
	moveq	#0,D2
T_A8F4:
	addq	#1,D7
	cmp.w	#$7F,D3
	bgt.s	T_A902
	move.b	D3,(A1)+
	move.b	D0,(A1)+
	bra.s	T_A910
;
T_A902:
	move.b	#0,(A1)+
	ror	#8,D3
	move.b	D3,(A1)+
	ror	#8,D3
	move.b	D3,(A1)+
	move.b	D0,(A1)+
T_A910:
	moveq	#1,D3
	movea.l	A3,A4
	tst	D1
	bgt	T_A872
T_A91A:
	ror	#8,D7
	move.b	D7,(A5)+
	ror	#8,D7
	move.b	D7,(A5)
	movem.l	(SP)+,D0-A0/A2-A6
	move.l	A1,D0
	sub.l	D7,D0
	rts
;
;----------------------------------------------------------------------------
;
T_A92C:
	move.l	A1,D7
	movem.l	D0-A0/A2-A6,-(SP)
	lea	B_30F98,A3
	movea.l	A0,A2
	movea.l	A3,A4
	movea.l	A1,A5
	addq	#2,A1
	move	#$2590,D1
	moveq	#0,D2
	moveq	#1,D3
	move	(A2)+,D6
	moveq	#0,D7
T_A94C:
	subq	#1,D1
	bmi.s	T_A96A
	move	D6,D0
	move	(A2)+,D6
	move	D0,(A4)+
	addq	#1,D2
	cmp.w	D6,D0
	bne.s	T_A960
	addq	#1,D3
	bra.s	T_A94C
;
T_A960:
	cmp.w	#4,D3
	bge.s	T_A96A
	moveq	#1,D3
	bra.s	T_A94C
;
T_A96A:
	cmp.w	#3,D3
	bgt.s	T_A9AA
	addq	#1,D7
	cmp.w	#1,D3
	bgt.s	T_A97A
	moveq	#0,D3
T_A97A:
	add	D3,D2
	cmp.w	#$7F,D2
	bgt.s	T_A98A
	neg.b	D2
	move.b	D2,(A1)+
	neg.b	D2
	bra.s	T_A996
;
T_A98A:
	move.b	#1,(A1)+
	ror	#8,D2
	move.b	D2,(A1)+
	ror	#8,D2
	move.b	D2,(A1)+
T_A996:
	subq	#1,D2
	movea.l	A3,A4
T_A99A:
	move	(A4)+,D5
	ror	#8,D5
	move.b	D5,(A1)+
	ror	#8,D5
	move.b	D5,(A1)+
	dbra	D2,T_A99A
	bra.s	T_AA10
;
T_A9AA:
	sub.w	D3,D2
	ble.s	T_A9DC
	addq	#1,D7
	cmp.w	#$7F,D2
	bgt.s	T_A9BE
	neg.b	D2
	move.b	D2,(A1)+
	neg.b	D2
	bra.s	T_A9CA
;
T_A9BE:
	move.b	#1,(A1)+
	ror	#8,D2
	move.b	D2,(A1)+
	ror	#8,D2
	move.b	D2,(A1)+
T_A9CA:
	subq	#1,D2
	movea.l	A3,A4
T_A9CE:
	move	(A4)+,D5
	ror	#8,D5
	move.b	D5,(A1)+
	ror	#8,D5
	move.b	D5,(A1)+
	dbra	D2,T_A9CE
T_A9DC:
	addq	#1,D7
	cmp.w	#$7F,D3
	bgt.s	T_A9F0
	move.b	D3,(A1)+
	ror	#8,D0
	move.b	D0,(A1)+
	ror	#8,D0
	move.b	D0,(A1)+
	bra.s	T_AA04
;
T_A9F0:
	move.b	#0,(A1)+
	ror	#8,D3
	move.b	D3,(A1)+
	ror	#8,D3
	move.b	D3,(A1)+
	ror	#8,D0
	move.b	D0,(A1)+
	ror	#8,D0
	move.b	D0,(A1)+
T_AA04:
	moveq	#0,D2
	moveq	#1,D3
	movea.l	A3,A4
	tst	D1
	bgt	T_A94C
T_AA10:
	ror	#8,D7
	move.b	D7,(A5)+
	ror	#8,D7
	move.b	D7,(A5)
	movem.l	(SP)+,D0-A0/A2-A6
	move.l	A1,D0
	sub.l	D7,D0
	rts
;
;
T_AA22:
	move.l	A0,-(SP)
	move.l	A1,-(SP)
	move	#$14,D3
	move	#$C8,D4
	moveq	#4,D5
	lea	B_29198,A1
T_AA36:
	move	(A0),(A1)+
	addq	#8,A0
	subq	#1,D3
	bne.s	T_AA36
	move	#$14,D3
	subq	#1,D4
	bne.s	T_AA36
	move	#$C8,D4
	lea	-$7CFE(A0),A0
	subq	#1,D5
	bne.s	T_AA36
	movea.l	(SP)+,A1
	movea.l	(SP)+,A0
	move.b	$7CFF(A1),D5
	move.b	D5,$7D01(A1)
	not.b	D5
	move.b	D5,$7D00(A1)
	rts
;
;----------------------------------------------------------------------------
;
fsel_input_sub:
	move.l	SP,T_AB28		;store internal SSP
	movea.l	entry_USP,SP		;SSP = USP of program entry
	gemdos	Super|_ind,entry_SSP	;exit super mode & restore external SSP
	lea	fsel_USP_top,SP
	linea	#9			;showm
	linea	#9			;showm
	move.l	current_path_p,addrin
	move.l	#fsel_filename_s,addrin+4
	cmp	#$0104,TOS_version
	blo.s	.old_fsel
	move.l	prompt_s_p,addrin+8
.new_fsel:
	sub_aes	#fsel_exinput
	bra.s	.done_fsel
;
.old_fsel:
	sub_aes	#fsel_input
.done_fsel:
	linea	#10			;hidem
	linea	#10			;hidem
	movea.l	entry_USP,SP		;USP = USP of program entry
	gemdos	Super,!			;D0 = external SSP,  SSP = internal SSP
	move.l	d0,entry_SSP		;store external SSP (should be unchanged...)
	move.l	T_AB28(pc),SP		;SSP = internal SSP (for reentered super mode)
	moveq	#0,D0
	tst	intout
	bpl.s	T_AB1A
	st	D0
	bra.s	T_AB24
;
T_AB1A:
	tst	intout+2
	bpl.s	T_AB24
	st	D0
T_AB24:
	tst.b	D0
	rts
;
;
T_AB28:
	dc.l	0
;
;----------------------------------------------------------------------------
;
prep_file_select:
	sf	mouse_work_f
	bsr	rest_interrupt
	bsr	rest_screenrez
	bsr.s	empty_keyboard
	rts
;
;----------------------------------------------------------------------------
;
post_file_select:
	movem.l	D0-A6,-(SP)
	bsr.s	empty_keyboard
	bsr	save_screenrez
	bsr	save_interrupt
	bsr	set_FORM_color
	movem.l	(SP)+,D0-A6
	rts
;
;----------------------------------------------------------------------------
;
empty_keyboard:
	bsr	empty_kb_acia
empty_keyqueue:
	gemdos	Cconis
	tst.l	D0
	beq.s	T_AB70
	gemdos	Crawcin
	bra.s	empty_keyqueue
;
T_AB70:
	rts
;
;----------------------------------------------------------------------------
;
Crawcin_sub:
	gemdos	Cconis
	tst.l	D0
	beq.s	Crawcin_sub
	gemdos	Crawcin
	rts
;
;----------------------------------------------------------------------------
;
ICE_blocks_1_3_or_2_4:
	cmpi.b	#0,T_1075
	beq.s	.T_ABB2
	cmpi.b	#1,T_1075
	beq.s	.T_ABB2
	lea	ICE_block_1(PC),A0
	lea	D_B660(PC),A1
	bsr.s	ICE_unpack
	lea	ICE_block_3(PC),A0
	lea	D_B8E0(PC),A1
	bsr.s	ICE_unpack
	rts
;
;
.T_ABB2:
	lea	ICE_block_2(PC),A0
	lea	D_B660(PC),A1
	bsr.s	ICE_unpack
	lea	ICE_block_4(PC),A0
	lea	D_B8E0(PC),A1
	bsr.s	ICE_unpack
	rts
;
;----------------------------------------------------------------------------
;
fix_type_paths:
	lea	pathlist_t,a3
	lea	typelist_t,a2
.next_path:
	tst.l	(a3)
	beq.s	.exit
	lea	main_path_s,a0	;a0 -> main pathname string
	move.l	(a3)+,a1	;a1 -> next path string to init
	jsr	old_path	;init Full pure path
	move.l	a1,a0
	lea	wild_name_s,a1
	jsr	new_name
	move.l	(a2)+,a1
	jsr	new_type
	bra.s	.next_path
;
.exit:
	rts
;
;----------------------------------------------------------------------------
;
ICE_unpack:
	movem.l	D0-A6,-(SP)
	bsr.s	T_AC56
	cmpi.l	#$49434521,D0
	bne	T_AC50
	bsr.s	T_AC56
	lea	-8(A0,D0.l),A5
	bsr.s	T_AC56
	move.l	D0,(SP)
	movea.l	A1,A4
	movea.l	A1,A6
	adda.l	D0,A6
	movea.l	A6,A3
	move.b	-(A5),D7
	bsr	T_AC62
	movea.l	A3,A6
	bsr	T_AC8E
	bcc.s	T_AC50
	move	#$F9F,D7
	bsr	T_AC8E
	bcc.s	T_AC2A
	moveq	#15,D0
	bsr	T_AC98
	move	D1,D7
T_AC2A:
	moveq	#3,D6
T_AC2C:
	move	-(A3),D4
	moveq	#3,D5
T_AC30:
	add	D4,D4
	addx	D0,D0
	add	D4,D4
	addx	D1,D1
	add	D4,D4
	addx	D2,D2
	add	D4,D4
	addx	D3,D3
	dbra	D5,T_AC30
	dbra	D6,T_AC2C
	movem.w	D0-D3,(A3)
	dbra	D7,T_AC2A
T_AC50:
	movem.l	(SP)+,D0-A6
	rts
;
;
T_AC56:
	moveq	#3,D1
T_AC58:
	lsl.l	#8,D0
	move.b	(A0)+,D0
	dbra	D1,T_AC58
	rts
;
;
T_AC62:
	bsr.s	T_AC8E
	bcc.s	T_AC88
	moveq	#0,D1
	bsr.s	T_AC8E
	bcc.s	T_AC82
	lea	T_AD26(PC),A1
	moveq	#4,D3
T_AC72:
	move.l	-(A1),D0
	bsr.s	T_AC98
	swap	D0
	cmp.w	D0,D1
	dbne	D3,T_AC72
	add.l	$14(A1),D1
T_AC82:
	move.b	-(A5),-(A6)
	dbra	D1,T_AC82
T_AC88:
	cmpa.l	A4,A6
	bgt.s	T_ACAA
	rts
;
;
T_AC8E:
	add.b	D7,D7
	bne.s	T_AC96
	move.b	-(A5),D7
	addx.b	D7,D7
T_AC96:
	rts
;
;
T_AC98:
	moveq	#0,D1
T_AC9A:
	add.b	D7,D7
	bne.s	T_ACA2
	move.b	-(A5),D7
	addx.b	D7,D7
T_ACA2:
	addx	D1,D1
	dbra	D0,T_AC9A
	rts
;
;
T_ACAA:
	lea	T_AD3A(PC),A1
	moveq	#3,D2
T_ACB0:
	bsr.s	T_AC8E
	dbcc	D2,T_ACB0
	moveq	#0,D4
	moveq	#0,D1
	move.b	1(A1,D2.w),D0
	ext.w	D0
	bmi.s	T_ACC4
	bsr.s	T_AC98
T_ACC4:
	move.b	6(A1,D2.w),D4
	add	D1,D4
	beq.s	T_ACEE
	lea	T_AD44(PC),A1
	moveq	#1,D2
T_ACD2:
	bsr.s	T_AC8E
	dbcc	D2,T_ACD2
	moveq	#0,D1
	move.b	1(A1,D2.w),D0
	ext.w	D0
	bsr.s	T_AC98
	add	D2,D2
	add	6(A1,D2.w),D1
	bpl.s	T_AD00
	sub.w	D4,D1
	bra.s	T_AD00
;
T_ACEE:
	moveq	#0,D1
	moveq	#5,D0
	moveq	#-1,D2
	bsr.s	T_AC8E
	bcc.s	T_ACFC
	moveq	#8,D0
	moveq	#$3F,D2
T_ACFC:
	bsr.s	T_AC98
	add	D2,D1
T_AD00:
	lea	2(A6,D4.w),A1
	adda	D1,A1
	move.b	-(A1),-(A6)
T_AD08:
	move.b	-(A1),-(A6)
	dbra	D4,T_AD08
	bra	T_AC62
;
	dc.b	$7F,$FF,$0,$E,$0,$FF,$0,$7,$0,$7,$0,$2,$0,$3
	dc.b	$0,$1,$0,$3,$0,$1
T_AD26:
	dc.b	$0,$0,$1,$D,$0,$0,$0,$E,$0,$0,$0,$7,$0,$0,$0
	dc.b	$4,$0,$0,$0,$1
T_AD3A:
	dc.b	$9,$1,$0,$FF,$FF,$8,$4,$2,$1,$0
T_AD44:
	dc.b	$B,$4,$7,$0,$1,$1F,$FF,$FF,$0,$1F
;
;----------------------------------------------------------------------------
;
	SECTION	DATA
;
;----------------------------------------------------------------------------
;
fsel_filename_s:
	ds.b	128
load_pathname_s:
	ds.b	128
save_pathname_s:
	ds.b	128
;
;----------------------------------------------------------------------------
;
TGA_path_s:
	dc.b	'A:\*.TGA'
	ds.b	TGA_path_s+128-*
;
IFF_path_s:
	dc.b	'A:\*.IFF'
	ds.b	IFF_path_s+128-*
;
GIF_path_s:
	dc.b	'A:\*.GIF'
	ds.b	GIF_path_s+128-*
;
RAW_path_s:
	dc.b	'A:\*.RAW'
	ds.b	RAW_path_s+128-*
;
PI1_path_s:
	dc.b	'A:\*.PI1'
	ds.b	PI1_path_s+128-*
;
SPU_path_s:
	dc.b	'A:\*.SPU'
	ds.b	SPU_path_s+128-*
;
PCS_path_s:
	dc.b	'A:\*.PCS'
	ds.b	PCS_path_s+128-*
;
;----------------------------------------------------------------------------
;
main_frect_t:
	dc.b	$0,$1,$0,$59,$0,$14,$0,$E5,$0,$20,$0,$2,$0,$59
	dc.b	$0,$2C,$0,$E5,$0,$38,$0,$3,$0,$59,$0,$44,$0
	dc.b	$E5,$0,$50,$0,$4,$0,$59,$0,$5C,$0,$E5,$0,$68
	dc.b	$0,$5,$0,$59,$0,$74,$0,$E5,$0,$80,$0,$6,$0,$59
	dc.b	$0,$8C,$0,$9F,$0,$98,$0,$7,$0,$A1,$0,$8C,$0
	dc.b	$C2,$0,$98,$0,$8,$0,$C4,$0,$8C,$0,$E5,$0,$98
	dc.b	$0,$9,$0,$59,$0,$A4,$0,$E5,$0,$B0,$FF,$FF
;
dest_frect_t:
	dc.b	$0,$1,$0,$59,$0,$2D,$0,$E5,$0,$39,$0,$2,$0,$59
	dc.b	$0,$45,$0,$E5,$0,$51,$0,$3,$0,$59,$0,$65,$0
	dc.b	$E5,$0,$71,$0,$4,$0,$59,$0,$7D,$0,$E5,$0,$89
	dc.b	$0,$5,$0,$59,$0,$95,$0,$E5,$0,$A1,$0,$6,$0,$59
	dc.b	$0,$AD,$0,$E5,$0,$B9,$FF,$FF
;
C_H_F_frect_t:
	dc.b	$0,$1,$0,$35,$0,$5F,$0,$7A,$0,$6B,$0,$2,$0,$7C
	dc.b	$0,$5F,$0,$C1,$0,$6B,$0,$3,$0,$C3,$0,$5F,$1
	dc.b	$8,$0,$6B,$FF,$FF
;
legal_frect_t:
	dc.b	$0,$1,$0,$48,$0,$5F,$0,$9E,$0,$6B,$0,$2,$0,$A0
	dc.b	$0,$5F,$0,$F6,$0,$6B,$FF,$FF
;
optim_frect_t:
	dc.b	$0,$1,$0,$48,$0,$5F,$0,$9E,$0,$6B,$0,$2,$0,$A0
	dc.b	$0,$5F,$0,$F6,$0,$6B,$FF,$FF
;
;----------------------------------------------------------------------------
;
scale_frect_t:
	dc.b	$0,$1,$0,$48,$0,$5F,$0,$9E,$0,$6B,$0,$2,$0,$A0
	dc.b	$0,$5F,$0,$F6,$0,$6B,$FF,$FF
D_B202:
	dc.b	$FE,$0,$0,$0,$FE,$0,$7C,$0,$BC,$0,$78,$0,$BC
	dc.b	$0,$78,$0,$8E,$0,$7C,$0,$B7,$0,$4E,$0,$CB,$80
	dc.b	$7,$0,$5,$C0,$3,$80,$2,$A0,$1,$C0,$1,$40,$0
	dc.b	$80,$0,$80,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
;		
;----------------------------------------------------------------------------
;
ICE_block_1:
	incbin	ice\block_1.ice		;\
ICE_block_2:
	incbin	ice\block_2.ice		; \/ Unknown
ICE_block_3:
	incbin	ice\block_3.ice		; /\ forms.  (background ?)
ICE_block_4:
	incbin	ice\block_4.ice		;/
;
D_B660:
	ds.b	640
D_B8E0:
	ds.b	5120
;
ICE_block_5:
	incbin	ice\block_5.ice		;main form
ICE_block_7:
	incbin	ice\block_7.ice		;dest form
ICE_block_9:
	incbin	ice\block_9.ice		;C_H_F form
ICE_block_10:
	incbin	ice\block_10.ice	;legal form
ICE_block_11:
	incbin	ice\block_11.ice	;optim form
ICE_block_12:
	incbin	ice\block_12.ice	;scale form
ICE_block_13:
	incbin	ice\block_13.ice	;help form
;
;----------------------------------------------------------------------------
;
D_10A54:
	dc.l	B_1C678
mouse_pos_X:
	dc.b	$0,$A0
mouse_pos_Y:
	dc.b	$0,$64
;
;----------------------------------------------------------------------------
;
	SECTION	BSS
;
;----------------------------------------------------------------------------
;
B_10A5C:
	ds.l	1			;=4
B_10A60:
	ds.w	9			;=18
B_10A72:
	ds.l	1			;=4
B_10A76:
	ds.l	1			;=4
B_10A7A:
	ds.w	1			;=2
B_10A7C:
	ds.w	1			;=2
B_10A7E:
	ds.w	1			;=2
B_10A80:
	ds.l	1			;=4
B_10A84:
	ds.w	1			;=2
B_10A86:
	ds.w	1			;=2
B_10A88:
	ds.w	1			;=2
B_10A8A:
	ds.w	1			;=2
B_10A8C:
	ds.w	1			;=2
B_10A8E:
	ds.w	1			;=2
B_10A90:
	ds.l	1			;=4
B_10A94:
	ds.w	1			;=2
B_10A96:
	ds.w	1			;=2
B_10A98:
	ds.w	1			;=2
B_10A9A:
	ds.w	1			;=2
B_10A9C:
	ds.l	1			;=4
B_10AA0:
	ds.l	1			;=4
B_10AA4:
	ds.l	1			;=4
B_10AA8:
	ds.w	1			;=2
B_10AAA:
	ds.w	1			;=2
B_10AAC:
	ds.w	1			;=2
B_10AAE:
	ds.w	1			;=2
;
clrblk_1_beg:
B_10AB0:
	ds.l	1			;=4
B_10AB4:
	ds.l	1			;=4
B_10AB8:
	ds.l	1			;=4
B_10ABC:
	ds.l	1			;=4
B_10AC0:
	ds.l	1			;=4
B_10AC4:
	ds.l	1			;=4
B_10AC8:
	ds.l	1			;=4
dither_type:
	ds.b	1			;=1
B_10ACD:
	ds.b	1			;=1
legal_colour_f:
	ds.b	1			;=1
flicker_free_f:
	ds.b	1			;=1
sync_command:
	ds.w	1
	ds.w	128			;=258
loc_USP_top:
	ds.l	65			;=260
new_SSP_top:
	ds.l	65			;=260
fsel_USP_top:
	ds.l	1			;=4
B_10DDE:
	ds.l	1			;=4
vbi_counter:
	ds.w	1			;=2
click_object:
	ds.w	1			;=2
click_pos_X:
	ds.w	1			;=2
click_pos_Y:
	ds.w	1			;=2
o_mouse_pack_p:
	ds.l	1			;=4
o_joyst_pack_p:
	ds.l	1			;=4
kbdvbase_p:
	ds.l	1			;=4
mouse_buttons:
	ds.w	1			;=2
B_10DF8:
	ds.l	16			;=64
B_10E38:
	ds.l	64			;=256
B_10F38:
	ds.l	8			;=32
B_10F58:
	ds.l	16			;=64
B_10F98:
	ds.l	112			;=448
B_11158:
	ds.l	128			;=512
B_11358:
	ds.l	64			;=256
B_11458:
	ds.l	256			;=1024
B_11858:
	ds.l	192			;=768
B_11B58:
	ds.l	2048			;=8192
B_13B58:
	ds.l	2048			;=8192
B_15B58:
	ds.l	2048			;=8192
B_17B58:
	ds.w	1			;=2
B_17B5A:
	ds.w	7			;=14
B_17B68:
	ds.l	4804			;=19216
;
clrblk_2_beg:
B_1C678:
	ds.b	255			;=255
B_1C777:
	ds.b	32513			;=32513
B_24678:
	ds.l	4808			;=19232
B_29198:
	ds.l	8064			;=32256
B_30F98:
	ds.l	8064			;=32256
B_38D98:
	ds.l	18874			;=75496
B_4B480:
	ds.l	32000			;=128000
clrblk_end:
;
;----------------------------------------------------------------------------
;
	END
;
;----------------------------------------------------------------------------
;End of file:	PCHROME4.S
;----------------------------------------------------------------------------
