;----------------------------------------------------------------------------
;File name:	METADOS.S			Revision date:	1998.01.29
;Revised by:	Ulf Ronald Andersson		Revision start:	1995.07.06
;----------------------------------------------------------------------------
	include	tos\URAn_DOS.S
	include	tos\URAn_XB.S
;----------------------------------------------------------------------------
sizeof_FCB	=	42
;----------------------------------------------------------------------------
;
	SECTION	TEXT
;
;----------------------------------------------------------------------------
start:
	movea.l	SP,A5
	lea	B_29C4,SP
	movea.l	4(A5),A5
	move.l	A5,B_634E
	move.l	12(A5),D0
	add.l	$1C(A5),D0
	add.l	$14(A5),D0
	add.l	#$100,D0
	move.l	D0,-(SP)
	move.l	D0,-(SP)
	move.l	A5,-(SP)
	clr.w	-(SP)
	move.w	#$4A,-(SP)
	trap	#1			;Mshrink
	adda.w	#12,SP
	clr.l	-(SP)
	move.w	#$20,-(SP)
	trap	#1			;Super
	addq.w	#6,SP
	move.l	D0,-(SP)
	move.w	#$20,-(SP)
	move.l	#D_1F3C,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	pea	B_2C2E
	move.w	#$30,-(SP)
	trap	#14			;Metainit
	addq.l	#6,SP
	tst.l	B_2C2E
	bne.s	abort_boot
	bsr.s	init_sub_0
	bsr	init_sub_1
	move.l	#D_1FB8,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	trap	#1
	addq.w	#6,SP
	move.l	(SP)+,D7
	move.w	#0,-(SP)
	move.l	D7,-(SP)
	move.w	#$31,-(SP)
	trap	#1			;Ptermres
;----------------------------------------------------------------------------
	addq.w	#8,SP
;----------------------------------------------------------------------------
	illegal
;----------------------------------------------------------------------------
abort_boot:				;T_94
	move.l	#D_1FE0,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	trap	#1
	addq.w	#6,SP
	clr.l	-(SP)
	trap	#1			;Pterm0
;----------------------------------------------------------------------------
	illegal
;----------------------------------------------------------------------------
init_sub_0:				;T_AC:
	clr.l	B_63C4
	movea.l	$4F2.w,A0		;_sysbase
	move.w	2(A0),D0
	cmp.w	#$100,D0
	bne.s	T_CC
	move.l	#$56EC,B_63C4
	bra.s	T_DC
;------------------------------------
T_CC:	cmp.w	#$102,D0
	bne.s	T_DC
	move.l	#$7E8E,B_63C4
T_DC:	lea	B_2C14,A0
	move.l	A0,B_2C14
	bsr	T_197A
	move.l	D0,B_29C8
	tst.w	(_longframe).w			;_longframe
	beq.s	T_100
	move.w	#8,frame_size
T_100:
	move.l	$B8.w,MD_xbios_XB+xb_next		;trp14vec
	move.l	#MD_xbios_XB+xb_code,$B8.w		;trp14vec
	lea	C_AUTO_CONFIG_SYS_s,A0
	move	(_bootdev).w,D0		;_bootdev
	add	#'A',D0
	move.b	D0,(A0)
	move	#$19,-(SP)
	trap	#1			;Dgetdrv
	addq	#2,SP
	move	D0,last_Dsetdrv
	move	#100-1,D0
	lea	meta_FCB_t,A0
T_138:
	move.l	#-1,$24(A0)
	adda.l	#sizeof_FCB,A0
	dbra	D0,T_138
	clr.b	B_2C2E
	clr.b	expanded_pathname
	clr.w	B_607C
	lea	B_2AF0,A0
	move.l	A0,B_2AF0
	move.l	$84.w,MD_gemdos_XB+xb_next		;trp1vec
	move.l	#MD_gemdos_XB+xb_code,$84.w		;trp1vec
	move.l	(etv_term).w,MD_etv_term_XB+xb_next		;etv_term
	move.l	#MD_etv_term_XB+xb_code,(etv_term).w		;etv_term
	rts
;----------------------------------------------------------------------------
find_gemdos_device:			;T_18A:
	cmp	#-1,D0
	beq.s	T_1B4
	movea.l	gemdos_device_chain,A0
	bra.s	T_1A2
;------------------------------------
T_198:	cmp	4(A0),D0
	beq.s	T_1AE
	movea.l	0(A0),A0
T_1A2:	cmpa.l	#0,A0
	bne.s	T_198
	moveq	#$F1,D0
	rts
;------------------------------------
T_1AE:	move.l	A0,B_2C20
T_1B4:	rts
;----------------------------------------------------------------------------
find_xbios_device:			;T_1b6
	cmp	#-1,D0
	beq.s	T_1D8
	movea.l	xbios_device_chain,A1
	bra.s	T_1CE
;------------------------------------
T_1C4:	cmp	8(A1),D0
	beq.s	T_1D8
	movea.l	0(A1),A1
T_1CE:	cmpa.l	#0,A1
	bne.s	T_1C4
	moveq	#$F1,D0
T_1D8:	rts
;----------------------------------------------------------------------------
;Start of:	XBRA linked etv_term routine
;----------------------------------------------------------------------------
;T_1DA:
;
	XB_define	MD_etv_term_XB,'_MET'
	movem.l	D0-A6,-(SP)
	bsr	MD_etv_term_sub
	movem.l	(SP)+,D0-A6
	move.l	MD_etv_term_XB+xb_next,-(SP)
	rts
;----------------------------------------------------------------------------
;Start of:	XBRA linked xbios dispatcher
;----------------------------------------------------------------------------
;T_1FA:
;
	XB_define	MD_xbios_XB,'_MET'
	movea.l	B_2C14,A0
	move.l	SP,-(A0)
	move	frame_size,D0
	btst	#5,(SP)
	bne.s	T_21E
	move	usp,SP
	clr	D0
T_21E:
	cmp	#$30,0(SP,D0.w)		;xbios func Metainit ?
	blt.s	MD_exit_to_old_xbios
	cmp	#$3F,0(SP,D0.w)
	bgt.s	MD_exit_to_old_xbios
	cmp	#2,D0
	ble.s	T_246
	move	(SP)+,-(A0)
	move.l	(SP)+,-(A0)
	tst	(_longframe).w			;_longframe
	beq.s	T_240
	move.w	(SP)+,-(A0)
T_240:
	move.w	#1,-(A0)
	bra.s	T_248
;------------------------------------
T_246:
	clr.w	-(A0)
T_248:
	cmpi.w	#$30,(SP)		;xbios func Metainit ?
	beq.s	MD_Metainit
	move.w	2(SP),D0
	bsr	find_xbios_device
	bmi.s	T_28A
	move.w	(SP)+,D1
	move.w	D1,-(A0)
	move.w	(SP)+,D0
	move.w	D0,-(A0)
	movem.l	D3-D7/A3-A6,-(A0)
	move.l	A0,B_2C14
	movea.l	A1,A0
	movea.l	14(A1),A1
	sub.w	#$30,D1
	asl.w	#2,D1
	movea.l	0(A1,D1.w),A1
	jsr	(A1)
	movea.l	B_2C14,A0
	movem.l	(A0)+,D3-D7/A3-A6
	move.w	(A0)+,-(SP)
	move.w	(A0)+,-(SP)
T_28A:
	tst.w	(A0)+
	beq.s	T_29A
	tst.w	(_longframe).w			;_longframe
	beq.s	T_296
	move.w	(A0)+,-(SP)
T_296:
	move.l	(A0)+,-(SP)
	move.w	(A0)+,-(SP)
T_29A:
	movea.l	(A0)+,SP
	move.l	A0,B_2C14
	rte
;------------------------------------
MD_exit_to_old_xbios:			;T_2A4:
	movea.l	(A0)+,SP
	move.l	A0,B_2C14
	movea.l	MD_xbios_XB+xb_next,A0
	jmp	(A0)
	illegal
;------------------------------------
MD_Metainit:			;T_2B6:
	movem.l	A0-A1,-(SP)
	movea.l	10(SP),A0
	lea	D_1F2C,A1
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)
	movem.l	(SP)+,A0-A1
	bra.s	T_28A
;----------------------------------------------------------------------------
;End of:	XBRA linked xbios dispatcher
;----------------------------------------------------------------------------
T_2D2:	cmp.l	#-1,D0
	bgt.s	T_324
	cmp.l	#-$11,D0
	blt.s	T_324
	movea.l	B_2C20,A1
	btst	#2,$115(A1)
	beq.s	T_2F8
	cmp.l	#-13,D0
	beq.s	T_324
T_2F8:	move.l	D0,-(SP)
	move.l	#-1,-(SP)
	move.w	#$101,-(SP)
	move.w	#5,-(SP)
	trap	#13			;Setexec
	addq.l	#8,SP
	movea.l	D0,A0
	move.l	(SP)+,D0
	movea.l	B_2C20,A1
	move.w	4(A1),-(SP)
	subi.w	#$41,(SP)
	move.w	D0,-(SP)
	jsr	(A0)
	addq.l	#4,SP
T_324:	rts
;----------------------------------------------------------------------------
;Start of:	XBRA linked gemdos dispatcher
;----------------------------------------------------------------------------
;T_326:
;
	XB_define	MD_gemdos_XB,'_MET'
	movea.l	B_2AF0,A0
	move.l	SP,-(A0)
	move.w	frame_size,D0
	btst	#5,(SP)
	bne.s	T_34A
	move	usp,SP
	clr.w	D0
T_34A:
	cmpi.w	#0,0(SP,D0.w)
	blt	MD_exit_to_old_gemdos
	cmpi.w	#$15F,0(SP,D0.w)
	bgt	MD_exit_to_old_gemdos
	cmp.w	#2,D0
	ble.s	T_376
	move.w	(SP)+,-(A0)
	move.l	(SP)+,-(A0)
	tst.w	(_longframe).w			;_longframe
	beq.s	T_370
	move.w	(SP)+,-(A0)
T_370:
	move.w	#1,-(A0)
	bra.s	T_378
;------------------------------------
T_376:
	clr.w	-(A0)
T_378:
	movem.l	D2-D7/A1-A6,-(A0)
	move.l	A0,B_2AF0
T_382:
	move.w	(SP),D1
	add.w	D1,D1
	add.w	D1,D1
	lea	MD_gemdos_func_t,A1	;a1 -> MD_gemdos_func_t
	move.l	0(A1,D1.w),D0		;d0 -> MD_gemdos function
	bmi.s	T_3D4
	movea.l	D0,A1
	jsr	(A1)			;call MD_gemdos function subroutine
	tst.l	D0
	bpl.s	T_3B0
	cmp.l	#-$3E9,D0
	beq.s	T_3D4
	bsr	T_2D2
	cmp.l	#$10000,D0
	beq.s	T_382
T_3B0:
	movea.l	B_2AF0,A0
	movem.l	(A0)+,D2-D7/A1-A6
	tst.w	(A0)+
	beq.s	T_3CA
	tst.w	(_longframe).w			;_longframe
	beq.s	T_3C6
	move.w	(A0)+,-(SP)
T_3C6:
	move.l	(A0)+,-(SP)
	move.w	(A0)+,-(SP)
T_3CA:
	movea.l	(A0)+,SP
	move.l	A0,B_2AF0
	rte
;------------------------------------
T_3D4:	movea.l	B_2AF0,A0
	movem.l	(A0)+,D2-D7/A1-A6
	tst.w	(A0)+
	beq.s	MD_exit_to_old_gemdos
	tst.w	(_longframe).w			;_longframe
	beq.s	.T_3EA
	move.w	(A0)+,-(SP)
.T_3EA:
	move.l	(A0)+,-(SP)
	move.w	(A0)+,-(SP)
MD_exit_to_old_gemdos:
	movea.l	(A0)+,SP
	move.l	A0,B_2AF0
	movea.l	MD_gemdos_XB+xb_next,A0
	jmp	(A0)
;----------------------------------------------------------------------------
;End of:	XBRA linked gemdos dispatcher
;----------------------------------------------------------------------------
use_old_gemdos_sub:			;T_3FE:
	move.l	(SP)+,B_2E2E
	tst	(_longframe).w			;_longframe
	beq.s	.T_410
	move	B_29CC,-(SP)
.T_410:
	move.l	#.T_420,-(SP)
	move	sr,-(SP)
	movea.l	MD_gemdos_XB+xb_next,A0
	jmp	(A0)
;
.T_420:
	move.l	B_2E2E,-(SP)
	rts
;----------------------------------------------------------------------------
popfix_long_100_199:			;T_428:
	cmp.l	#100,D0
	blt.s	T_44C
	cmp.l	#199,D0
	bgt.s	T_44C
	tst.l	D0
	rts
;------------------------------------
popfix_word_100_199:			;T_43C:
	cmp	#100,D0
	blt.s	T_44C
	cmp	#199,D0
	bgt.s	T_44C
	tst.l	D0
	rts
;------------------------------------
T_44C:
	tst.l	(SP)+
	move.l	#-$3E9,D0
	rts
;----------------------------------------------------------------------------
find_gemdos_path_device:			;T_456:
	tst.b	0(A0)
	beq.s	.T_470
	cmpi.b	#':',1(A0)
	bne.s	.T_470
	clr.w	D0
	move.b	(A0),D0
	and.w	#$DF,D0			;force upper case
	bra	find_gemdos_device
;
.T_470:
	move.w	last_Dsetdrv,D0
	add.w	#'A',D0
	bra	find_gemdos_device
;----------------------------------------------------------------------------
demand_file_handle:			;T_47E:
	sub	#100,D0
	mulu	#sizeof_FCB,D0
	add.l	#meta_FCB_t,D0
	movea.l	D0,A5			;a5 -> FCB of handle
	tst.w	$28(A5)
	bne.s	E_ERROR_word
	move.l	$24(A5),D0
	rts
;----------------------------------------------------------------------------
demand_dir_handle:			;T_49A:
	sub	#100,D0
	mulu	#sizeof_FCB,D0
	add.l	#meta_FCB_t,D0
	movea.l	D0,A5			;a5 -> FCB of handle
	tst.w	$28(A5)
	beq.s	E_ERROR_word
	move.l	$24(A5),D0
	rts
;----------------------------------------------------------------------------
E_ERROR_word:			;T_4B6:
	move.w	#-$1,D0
	rts
;----------------------------------------------------------------------------
get_device_minus_1:
	tst.w	D0
	bne.s	.T_4C8
	move.w	last_Dsetdrv,D0
	rts
;
.T_4C8:
	subq.w	#1,D0
	rts
;----------------------------------------------------------------------------
assign_FCB_a5:				;T_4CC:
	lea	meta_FCB_t,A5		;a5 -> first FCB (100)
	movea.l	A5,A3
	adda.l	#sizeof_FCB*100,A3
T_4DA:
	tst.l	$24(A5)
	bmi.s	T_4F2
	adda.l	#sizeof_FCB,A5		;a5 -> next FCB
	cmpa.l	A3,A5
	bgt.s	T_4EC
	bra.s	T_4DA
;
T_4EC:
	tst.l	(SP)+
	moveq	#$D9,D0
	rts
;
T_4F2:
	movea.l	A5,A3				;a3 = a5 -> free FCB
	move.w	#sizeof_FCB-1,D0
T_4F8:
	clr.b	(A3)+
	dbra	D0,T_4F8
	rts
;----------------------------------------------------------------------------
assign_dir_FCB:			;T_500:
	lea	meta_FCB_t,A5
	movea.l	A5,A3
	adda.l	#$1068,A3
T_50E:
	tst.l	$24(A5)
	bmi.s	T_4F2
	adda.l	#sizeof_FCB,A5	;a5 -> next FCB
	cmpa.l	A3,A5
	bgt.s	T_520
	bra.s	T_50E
;
T_520:
	tst.l	(SP)+
	moveq	#$DD,D0
	rts
;----------------------------------------------------------------------------
MD_etv_term_sub:
	movea.l	B_29C8,A0
	move.l	(A0),D2
	lea	meta_FCB_t,A5
	movea.l	A5,A3
	adda.l	#$1068,A3
T_53C:	cmp.l	$20(A5),D2
	bne.s	T_548
	tst.l	$24(A5)
	bpl.s	T_554
T_548:	adda.l	#sizeof_FCB,A5
	cmpa.l	A3,A5
	ble.s	T_53C
	rts
;------------------------------------
T_554:	movem.l	D0-A6,-(SP)
	move.l	A5,D0
	sub.l	#meta_FCB_t,D0
	lsr.l	#2,D0
	add.w	#100,D0
	tst.w	$28(A5)
	beq.s	T_57A
	move.l	D0,-(SP)
	move.w	#$12B,-(SP)
	bsr	MD_func_Dclosedir
	addq.w	#6,SP
	bra.s	T_586
;------------------------------------
T_57A:	move.w	D0,-(SP)
	move.w	#$3E,-(SP)
	bsr	MD_func_Fclose
	addq.w	#4,SP
T_586:	movem.l	(SP)+,D0-A6
	move.l	#-1,$24(A5)
	clr.l	$20(A5)
	bra.s	T_548
;----------------------------------------------------------------------------
MD_func_Pterm_x:			;T_598:
	movea.l	(etv_term).w,A0		;etv_term
	jsr	(A0)
	bsr.s	MD_etv_term_sub
	movea.l	#(etv_term)A0
	move.l	(A0),B_621A
	move.l	#T_5B6,(A0)
	bra	T_7B2
;
T_5B6:
	move.l	B_621A,(etv_term).w		;etv_term
	rts
;----------------------------------------------------------------------------
;Start of:	MD_func_Fsnext
;----------------------------------------------------------------------------
MD_func_Fsnext:			;T_5C0:
	bsr	use_old_Fgetdta_sub
	clr.w	D1
	lea	B_5EEC,A1
.T_5CC:
	cmp.l	0(A1,D1.w),D0
	beq.s	.T_5DE
	addq.w	#4,D1
	cmp.w	#$190,D1
	blt.s	.T_5CC
	bra	T_7B2
;
.T_5DE:
	lea	B_607E,A0
	movea.l	0(A0,D1.w),A0
	movea.l	0(A1,D1.w),A5		;a5 -> dta
	suba.l	A1,A1
	bsr	expand_pathname
	bmi	T_7D2
	move.w	4(SP),D0
	asl.w	#2,D0
	movea.l	6(A0),A6
	move.l	0(A6,D0.w),D0
	bmi	T_7C6
	movea.l	D0,A2
	lea	expanded_pathname,A4	;a4 -> expanded pathname
	movea.l	$10E(A0),A3		;a3 -> logical device structure
	move.l	(SP)+,B_6216
	jsr	(A2)			;call device function
	tst.l	D0
	beq.s	T_642
	move.l	D0,-(SP)
	bsr	use_old_Fgetdta_sub
	clr.w	D1
	lea	B_5EEC,A1
T_62E:
	cmp.l	0(A1,D1.w),D0
	bne.s	T_638
	clr.l	0(A1,D1.w)
T_638:
	addq.w	#4,D1
	cmp.w	#$190,D1
	blt.s	T_62E
	move.l	(SP)+,D0
T_642:
	move.l	B_6216,-(SP)
	rts
;----------------------------------------------------------------------------
;End of:	MD_func_Fsnext
;----------------------------------------------------------------------------
;Start of:	MD_func_Fsfirst
;----------------------------------------------------------------------------
MD_func_Fsfirst:			;T_64A:
	movea.l	6(SP),A0
	bsr	find_gemdos_path_device
	bmi	T_780
	movea.l	6(SP),A1
	bsr	expand_pathname
	bmi	T_7D2
	move.l	A0,B_620E
	move.w	4(SP),D1
	asl	#2,D1
	movea.l	6(A0),A6
	move.l	0(A6,D1.w),D1		;d1 -> device function
	bmi	T_7C6
	move.l	D1,-(SP)		;push d1,  -> device function
	bsr	use_old_Fgetdta_sub	;d0 = Fgetdta
	move.l	D0,B_6212
	movea.l	B_620E,A0
	movea.l	(SP)+,A2		;pull a2 -> device function
	movea.l	D0,A5			;a5 -> dta
	lea	expanded_pathname,A4	;a4 -> expanded pathname
	movea.l	$10E(A0),A3		;a3 -> logical device structure
	move.l	(SP)+,B_6216
	jsr	(A2)			;call device function
	move.l	B_6216,-(SP)
	tst.l	D0
	bmi.s	T_6F2
	clr.w	D1
	lea	B_5EEC,A1
	movea.l	B_6212,A2
T_6BA:
	cmpa.l	0(A1,D1.w),A2
	beq.s	T_6F4
	addq.w	#4,D1
	cmp.w	#$190,D1
	blt.s	T_6BA
	bsr.s	T_704
	move.w	B_607C,D1
	asl.w	#2,D1
	lea	B_5EEC,A1
	move.l	A2,0(A1,D1.w)
	lea	B_607E,A1
	move.l	B_620E,0(A1,D1.w)
	addq.w	#1,B_607C
	bsr.s	T_704
T_6F2:
	rts
;------------------------------------
T_6F4:
	lea	B_607E,A1
	move.l	B_620E,0(A1,D1.w)
	rts
;----------------------------------------------------------------------------
;End of:	MD_func_Fsfirst
;----------------------------------------------------------------------------
T_704:
	movem.l	D0-D1/A0-A2,-(SP)
	cmpi.w	#100,B_607C
	bne.s	T_718
	clr.l	B_5EEC
T_718:
	clr.w	D0
	lea	B_5EEC,A0
	lea	B_607E,A1
T_726:
	move.w	B_607C,D1
	asl.w	#2,D1
	cmp.w	D0,D1
	beq.s	T_76C
	tst.l	0(A0,D0.w)
	bne.s	T_768
	move.w	D0,-(SP)
	move.w	B_607C,D1
	asl.w	#2,D1
T_742:
	cmp.w	D1,D0
	beq.s	T_75A
	movea.l	4(A0,D0.w),A2
	move.l	A2,0(A0,D0.w)
	movea.l	4(A1,D0.w),A2
	move.l	A2,0(A1,D0.w)
	addq.w	#4,D0
	bra.s	T_742
;
T_75A:
	clr.l	$FC(A0,D0.w)
	subq.w	#1,B_607C
	move.w	(SP)+,D0
	bra.s	T_726
;
T_768:
	addq.w	#4,D0
	bra.s	T_726
;
T_76C:
	cmp.w	#$190,D0
	bne.s	T_77A
	clr.l	B_5EEC
	bra.s	T_718
;
T_77A:
	movem.l	(SP)+,D0-D1/A0-A2
	rts
;----------------------------------------------------------------------------
T_780:
	bsr.s	use_old_Fgetdta_sub
	move.w	D0,B_6212
	clr.w	D1
	lea	B_5EEC,A1
T_790:
	cmp.l	0(A1,D1.w),D0
	beq.s	T_7A0
	addq.w	#4,D1
	cmp.w	#$190,D1
	blt.s	T_790
	bra.s	T_7B2
;
T_7A0:
	clr.l	0(A1,D1.w)
	bra.s	T_7B2
;----------------------------------------------------------------------------
use_old_Fgetdta_sub:
	move.w	#(Fgetdta&$ff),-(SP)
	bsr	use_old_gemdos_sub
	addq.l	#2,SP
	rts
;----------------------------------------------------------------------------
T_7B2:	move.l	#-$3E9,D0
	rts
;------------------------------------
T_7BA:	moveq	#$FB,D0
	rts
;------------------------------------
E_INVFN_sub:			;T_7BE:
	moveq	#E_INVFN,D0
	rts
;------------------------------------
E_UNDEV_sub:			;T_7C2:
	moveq	#E_UNDEV,D0
	rts
;------------------------------------
T_7C6:	moveq	#$FD,D0
	rts
;------------------------------------
	moveq	#$DD,D0
	rts
;------------------------------------
E_IHNDL_sub:			;T_7CE:
	moveq	#E_IHNDL,D0
	rts
;------------------------------------
T_7D2:	moveq	#$DE,D0
	rts
;------------------------------------
T_7D6:	move.l	#-1,$24(A0)
	rts
;------------------------------------
T_7E0:			;T_7E0:
	movem.l	A0-A1,-(SP)
	lea	expanded_pathname,A0
	addq.l	#3,A0
	subq.l	#2,A2
T_7EE:
	cmpa.l	A0,A2
	ble.s	T_7FE
	cmpi.b	#$5C,-(A2)
	bne.s	T_7EE
	movem.l	(SP)+,A0-A1
	rts
;
T_7FE:
	movea.l	A0,A2
	movem.l	(SP)+,A0-A1
	rts
;------------------------------------
expand_pathname:			;T_806:
	movem.l	A0-A2,-(SP)
	clr.w	D0
	lea	expanded_pathname,A2		;a2 -> room for path
	btst	#1,$115(A0)		;expand mode (0) ?
	beq.s	T_82C
	cmpa.l	#0,A1			;a1 == NULL ?
	bne	T_910
	lea	14(A0),A1		;a1 = a0+14
	bra	T_910
;
T_82C:	cmpa.l	#0,A1			;a1 == NULL ?
	beq.s	T_842
	cmpi.b	#':',1(A1)
	bne.s	T_842
	move.b	(A1)+,D0
	addq.l	#1,A1
	bra.s	T_84A
;
T_842:
	move	4(A0),D0		;d0 = device drive code (based at $21 ???)
	add.b	#$20,D0
T_84A:
	move.b	D0,(A2)+		;store drive char
	move.b	#':',(A2)+		;store ':'
	cmpa.l	#0,A1			;a1 == NULL ?
	bne.s	.T_860
	lea	14(A0),A1		;a1 -> device path
	bra	T_910
;
.T_860:
	cmpi.b	#'\',(A1)		;a1 absolute path ?
	beq.s	T_884
	move.l	A0,-(SP)		;protect a0
	lea	14(A0),A0		;a0 -> device path
.T_86C:
	move.b	(A0)+,(A2)+		;copy device path char
	bne.s	.T_86C			;loop back for entire path
	movea.l	(SP)+,A0		;restore a0
	subq.l	#1,A2			;a2 -> path copy terminator
	cmpi.b	#'\',-$1(A2)		;final backslash ?
	beq.s	T_884
	tst.b	(A1)			;a1 -> NUL ?
	beq.s	T_884
	move.b	#'\',(A2)+		;enforce final backslash
T_884:
	move.b	(A1)+,D0
	cmp.b	#'.',D0
	beq.s	T_894
	cmp.b	#'\',D0
	beq.s	T_8B0
	bra.s	T_8BE
;
T_894:
	tst.b	(A1)
	beq.s	T_884
	cmpi.b	#'.',(A1)
	bne.s	T_8A6
	bsr	T_7E0
	addq.l	#1,A1
	bra.s	T_884
;------------------------------------
T_8A6:	cmpi.b	#'\',(A1)
	bne.s	T_8BE
	addq.l	#1,A1
	bra.s	T_884
;------------------------------------
T_8B0:
	tst.b	(A1)
	bne.s	T_8BE
	cmpi.b	#':',-$1(A2)
	beq.s	T_8BE
	move.b	(A1)+,D0
T_8BE:
	move.b	D0,(A2)+
	bne.s	T_884
	btst	#0,$115(A0)	;force upper case ?
	bne.s	T_8E6
	lea	expanded_pathname,A2
T_8D0:
	move.b	(A2),D0
	cmp.b	#'a',D0
	blt.s	T_8E2
	cmp.b	#'z',D0
	bgt.s	T_8E2
	sub.b	#' ',D0
T_8E2:
	move.b	D0,(A2)+
	bne.s	T_8D0
T_8E6:
	cmpi.b	#'\',-(A2)
	bne.s	T_8E6
T_8EC:
	move.b	-(A2),D0
	cmp.b	#':',D0
	beq.s	T_908
	cmp.b	#'?',D0
	beq.s	T_900
	cmp.b	#'*',D0
	bne.s	T_8EC
T_900:
	moveq	#E_ERROR,D0
	movem.l	(SP)+,A0-A2
	rts
;------------------------------------
T_908:
	clr.l	D0
	movem.l	(SP)+,A0-A2
	rts
;------------------------------------
T_910:
	move.b	(A1)+,(A2)+	;copy path
	bne.s	T_910
	btst	#0,$115(A0)	;force upper case ?
	bne.s	.T_938
	lea	expanded_pathname,A2	;a2 -> path copy start
.T_922:
	move.b	(A2),D0
	cmp.b	#'a',D0
	blt.s	.T_934
	cmp.b	#'z',D0
	bgt.s	.T_934
	sub.b	#$20,D0		;force d0 to upper case
.T_934:
	move.b	D0,(A2)+	;store forced char
	bne.s	.T_922		;loop back for entire path
.T_938:
	clr.l	D0
	movem.l	(SP)+,A0-A2
	rts
;------------------------------------
MD_func_Dgetdrv:			;T_940:
	clr.l	D0
	move.w	last_Dsetdrv,D0
	rts
;------------------------------------
MD_func_Dsetdrv:			;T_94A:
	move.w	6(SP),D2
	move.w	last_Dsetdrv,D1
	move.w	D2,last_Dsetdrv
	move.l	(_drvbits).w,D0		;_drvbits
	btst	D2,D0
	beq.s	T_966
	bra	T_7B2
;------------------------------------
T_966:
	move.w	D1,last_Dsetdrv
	rts
;------------------------------------
MD_func_Dgetpath:			;T_96E:
	move	10(SP),D0
	bsr	get_device_minus_1
	move.l	(_drvbits).w,D1		;_drvbits
	btst	D0,D1
	beq	E_UNDEV_sub
	add	#'A',D0
	bsr	find_gemdos_device
	bmi	T_7B2
	movea.l	6(SP),A1
	lea	14(A0),A0
	tst.b	1(A0)
	bne.s	T_99C
	addq.l	#1,A0
T_99C:	move.b	(A0)+,(A1)+
	bne.s	T_99C
	clr.l	D0
	rts
;------------------------------------
MD_func_Dsetpath:			;T_9A4
	movea.l	6(SP),A0
T_9A8:	cmpi.b	#sizeof_FCB,(A0)
	beq	T_7BA
	cmpi.b	#$3F,(A0)
	beq	T_7BA
	tst.b	(A0)+
	bne.s	T_9A8
	movea.l	6(SP),A0
	bsr	find_gemdos_path_device
	bmi	T_7B2
	movea.l	6(SP),A1
	bsr	expand_pathname
	bmi	T_7D2
	move.w	4(SP),D1
	asl.w	#2,D1
	movea.l	6(A0),A6
	move.l	0(A6,D1.w),D0
	bmi.s	T_A0E
	movea.l	D0,A2
	move.l	A0,B_620E
	lea	expanded_pathname,A4
	movea.l	$10E(A0),A3		;a3 -> logical device structure
	move.l	(SP)+,B_6216
	jsr	(A2)			;call device function
	move.l	B_6216,-(SP)
	tst.l	D0
	bmi.s	T_A20
	movea.l	B_620E,A0
T_A0E:	lea	14(A0),A0
	lea	expanded_pathname,A1
	addq.l	#2,A1
T_A1A:	move.b	(A1)+,(A0)+
	bne.s	T_A1A
	clr.l	D0
T_A20:	rts
;------------------------------------
MD_func_Fcreate_Fopen:			;T_A22:
	movea.l	6(SP),A0
	bsr	find_gemdos_path_device
	bmi	T_7B2
	movea.l	6(SP),A1
	bsr	expand_pathname
	bmi	T_7D2
	bsr	assign_FCB_a5	;a5 -> FCB
	move.w	4(SP),D1
	asl.w	#2,D1
	movea.l	6(A0),A6
	move.l	0(A6,D1.w),D0		;d0 -> device function or is negative
	bmi	T_7C6
	movea.l	D0,A2			;a2 -> device function
	move.l	A5,B_620E
	lea	expanded_pathname,A4		;a4 ->
	movea.l	$10E(A0),A3		;a3 -> logical device structure
	move.l	A0,$24(A5)
	movea.l	B_29C8,A0
	move.l	(A0),$20(A5)
	clr.w	$28(A5)
	move.l	(SP)+,B_6216
	jsr	(A2)			;call device function
	move.l	B_6216,-(SP)
	movea.l	B_620E,A0
	tst.l	D0
	bmi	T_7D6
	move.l	A0,D0
	sub.l	#meta_FCB_t,D0
	divu	#sizeof_FCB,D0
	add.l	#100,D0
	rts
;------------------------------------
MD_func_Fclose:			;T_AA2:
	move.w	6(SP),D0
	bsr	popfix_word_100_199
	bsr	demand_file_handle	;a5 -> FCB of handle
	bmi	E_IHNDL_sub
	move.l	A5,B_620E
	movea.l	D0,A0
	movea.l	6(A0),A6
	move.w	4(SP),D1
	asl.w	#2,D1
	move.l	0(A6,D1.w),D0
	bmi	T_7C6
	movea.l	D0,A2
	movea.l	$10E(A0),A3		;a3 -> logical device structure
	move.l	(SP)+,B_6216
	jsr	(A2)			;call device function
	move.l	B_6216,-(SP)
	movea.l	B_620E,A1
	move.l	#-1,$24(A1)
	clr.l	D0
	rts
;------------------------------------
MD_func_Dfree:			;T_AF2:
	move.w	10(SP),D0
	bsr	get_device_minus_1
	add.w	#'A',D0
	bsr	find_gemdos_device
	bmi	T_7B2
	bra.s	T_B48
;------------------------------------
MD_func_DF_diverse:			;T_B08:
	movea.l	6(SP),A0
	bsr	find_gemdos_path_device
	bmi	T_7B2
	movea.l	6(SP),A1
	bsr	expand_pathname
	bmi	T_7D2
	bra.s	T_B48
;------------------------------------
	move.w	8(SP),D0
	bsr	popfix_word_100_199
	bra.s	T_B3E
;------------------------------------
MD_func_Fseek_Fdatime:			;T_B2C:
	move.w	10(SP),D0
	bsr	popfix_word_100_199
	bra.s	T_B3E
;------------------------------------
MD_func_Fread_Fwrite:			;T_B36:
	move.w	6(SP),D0		;d0 = handle
	bsr	popfix_word_100_199	;abort if handle outside MetaDos range
T_B3E:
	bsr	demand_file_handle	;a5 -> FCB of handle
	bmi	E_IHNDL_sub
	movea.l	D0,A0
T_B48:
	movea.l	6(A0),A6
	move.w	4(SP),D1
	asl.w	#2,D1
	move.l	0(A6,D1.w),D0
	bmi	T_7C6
	movea.l	D0,A2
	lea	expanded_pathname,A4
	movea.l	$10E(A0),A3		;a3 -> logical device structure
	move.l	(SP)+,B_6216
	jsr	(A2)			;call device function
	move.l	B_6216,-(SP)
	rts
;------------------------------------
MD_func_Dopendir:			;T_B76:
	movea.l	6(SP),A0
	bsr	find_gemdos_path_device
	bmi	T_7B2
	movea.l	6(SP),A1
	bsr	expand_pathname
	bmi	T_7D2
	bsr	assign_dir_FCB	;a5 -> dir FCB
	move.w	4(SP),D1
	movea.l	6(A0),A6		;a6 ->
	cmpi.l	#'MAGI',-$10(A6)
	bne	E_INVFN_sub
	cmpi.l	#'CMET',-$C(A6)
	bne	E_INVFN_sub
	cmp.w	-$A(A6),D1
	bgt	E_INVFN_sub
	asl.w	#2,D1
	move.l	0(A6,D1.w),D0		;d0 -> device function Dopendir or is negative
	bmi	E_INVFN_sub
	movea.l	D0,A2			;a2 -> device function Dopendir
	move.l	A5,B_620E
	lea	expanded_pathname,A4	;a4 -> expanded pathname
	movea.l	$10E(A0),A3		;a3 -> logical device structure
	move.l	A0,$24(A5)
	movea.l	B_29C8,A0
	move.l	(A0),$20(A5)
	move.w	#1,$28(A5)
	move.l	(SP)+,B_6216
	jsr	(A2)			;call device function Dopendir
	move.l	B_6216,-(SP)
	movea.l	B_620E,A0
	tst.l	D0
	bmi	T_7D6
	move.l	A0,D0
	sub.l	#meta_FCB_t,D0
	divu	#sizeof_FCB,D0
	add.l	#100,D0
	rts
;------------------------------------
MD_func_Dclosedir:			;T_C18:
	move.l	6(SP),D0
	bsr	popfix_long_100_199
	bsr	demand_dir_handle	;a5 -> FCB of handle
	bmi	E_IHNDL_sub
	move.l	A5,B_620E
	movea.l	D0,A0
	move.w	4(SP),D1
	movea.l	6(A0),A6
	cmpi.l	#'MAGI',-$10(A6)
	bne	E_INVFN_sub
	cmpi.l	#'CMET',-$C(A6)
	bne	E_INVFN_sub
	cmp.w	-$A(A6),D1
	bgt	E_INVFN_sub
	asl.w	#2,D1
	move.l	0(A6,D1.w),D0
	bmi	E_INVFN_sub
	movea.l	D0,A2
	movea.l	$10E(A0),A3		;a3 -> logical device structure
	move.l	(SP)+,B_6216
	jsr	(A2)			;call device function
	move.l	B_6216,-(SP)
	movea.l	B_620E,A1
	move.l	#-1,$24(A1)
	clr.l	D0
	rts
;------------------------------------
MD_func_Fcntl:			;T_C88:
	move.w	6(SP),D0
	bsr	popfix_word_100_199
	bsr	demand_file_handle	;a5 -> FCB of handle
	bmi	E_IHNDL_sub
	movea.l	D0,A0
	bra.s	T_CD2
;------------------------------------
MD_func_Drewinddir:			;T_C9C:
	move.l	6(SP),D0
	bsr	popfix_long_100_199
	bra.s	T_CAE
;------------------------------------
MD_func_Dreaddir_Dxreaddir:		;T_CA6:
	move.l	8(SP),D0
	bsr	popfix_long_100_199
T_CAE:
	bsr	demand_dir_handle	;a5 -> FCB of handle
	bmi	E_IHNDL_sub
	movea.l	D0,A0
	bra.s	T_CD2
;------------------------------------
MD_func_Fxattr_Dcntl:			;T_CBA:
	movea.l	8(SP),A0
	bsr	find_gemdos_path_device
	bmi	T_7B2
	movea.l	8(SP),A1
	bsr	expand_pathname
	bmi	T_7D2
T_CD2:
	move.w	4(SP),D1
	movea.l	6(A0),A6
	cmpi.l	#'MAGI',-$10(A6)
	bne	E_INVFN_sub
	cmpi.l	#'CMET',-$C(A6)
	bne	E_INVFN_sub
	cmp.w	-$A(A6),D1
	bgt	E_INVFN_sub
	asl.w	#2,D1
	move.l	0(A6,D1.w),D0
	bmi	E_INVFN_sub
	movea.l	D0,A2
	lea	expanded_pathname,A4	;a4 -> expanded pathname
	movea.l	$10E(A0),A3		;a3 -> logical device structure
	move.l	(SP)+,B_6216
	jsr	(A2)			;call device function
	move.l	B_6216,-(SP)
	rts
;------------------------------------
MD_func_Dpathconf_D_x_label:		;T_D20:
	movea.l	6(SP),A0
	bsr	find_gemdos_path_device
	bmi	T_7B2
	movea.l	6(SP),A1
	bsr	expand_pathname
	bmi	T_7D2
	bra.s	T_CD2
;------------------------------------
init_sub_1:			;T_D3A
	bsr.s	init_sub_2
	bpl.s	T_D5E
	move.l	D0,-(SP)
	move.l	A0,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	lea	D_214E,A0
	move.l	A0,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	move.l	(SP)+,D0
	bra.s	T_D84
;------------------------------------
T_D5E:	lea	B_629F,A3
	cmpi.b	#sizeof_FCB,(A3)
	bne.s	T_D70
	bsr	init_sub_3
	bra.s	T_D7C
;------------------------------------
T_D70:	movem.l	D7,-(SP)
	bsr	T_1322
	movem.l	(SP)+,D7
T_D7C:	bsr.s	T_DA8
	bmi.s	T_D82
	bra.s	T_D5E
;------------------------------------
T_D82:	moveq	#0,D0
T_D84:	rts
;----------------------------------------------------------------------------
init_sub_2:			;T_D86
	move.w	#0,-(SP)
	move.l	#C_AUTO_CONFIG_SYS_s,-(SP)
	move.w	#$3D,-(SP)
	trap	#1			;Fopen
	addq.w	#8,SP
	tst.w	D0
	bmi.s	T_DA4
	move.w	D0,D7
	bsr.s	T_DA8
	clr.l	D0
	bra.s	T_DA6
T_DA4:	moveq	#$FF,D0
T_DA6:	rts
T_DA8:	lea	B_629F,A3
	move.l	A3,-(SP)
	move.l	#1,-(SP)
	move.w	D7,-(SP)
	move.w	#$3F,-(SP)
	trap	#1			;Fread
	adda.w	#12,SP
	tst.l	D0
	beq	T_E5C
	cmpi.b	#$3B,(A3)
	beq.s	T_E38
	cmpi.b	#10,(A3)
	beq.s	T_DA8
	cmpi.b	#13,(A3)
	beq.s	T_DA8
	cmpi.b	#$20,(A3)
	beq.s	T_DA8
	cmpi.b	#9,(A3)
	beq.s	T_DA8
T_DE6:	addq.l	#1,A3
	move.l	A3,-(SP)
	move.l	#1,-(SP)
	move.w	D7,-(SP)
	move.w	#$3F,-(SP)
	trap	#1			;Fread
	lea	12(SP),SP
	tst.l	D0
	beq.s	T_E60
	cmpi.b	#10,(A3)
	beq.s	T_E60
	cmpi.b	#$3B,(A3)
	bne.s	T_DE6
	move.b	#10,(A3)
T_E10:	movea.l	A3,A2
	addq.l	#1,A2
	move.l	A2,-(SP)
	move.l	A2,-(SP)
	move.l	#1,-(SP)
	move.w	D7,-(SP)
	move.w	#$3F,-(SP)
	trap	#1			;Fread
	adda.w	#12,SP
	movea.l	(SP)+,A2
	tst.l	D0
	beq.s	T_E60
	cmpi.b	#10,(A2)
	beq.s	T_E60
	bra.s	T_E10
T_E38:	move.l	A3,-(SP)
	move.l	#1,-(SP)
	move.w	D7,-(SP)
	move.w	#$3F,-(SP)
	trap	#1			;Fread
	adda.w	#12,SP
	tst.l	D0
	beq	T_DA8
	cmpi.b	#10,(A3)
	beq	T_DA8
	bra.s	T_E38
T_E5C:	move.w	#-$1,D0
T_E60:	move.w	D0,D0
	rts
;----------------------------------------------------------------------------
init_sub_3:			;T_E64
	lea	B_629F,A3
	cmpi.b	#'*',(A3)+
	bne.s	T_EB4
	cmpi.b	#'B',(A3)
	bne.s	T_E86
	cmpi.b	#'O',1(A3)
	bne.s	T_E86
	cmpi.b	#'S',2(A3)
	beq.s	T_EA8
T_E86:	cmpi.b	#'D',(A3)
	bne.s	T_EB4
	cmpi.b	#'O',1(A3)
	bne.s	T_EB4
	cmpi.b	#'S',2(A3)
	bne.s	T_EB4
	bsr	T_12AC
	tst.l	D0
	bmi.s	T_EB6
	bsr.s	T_EF4
	bra.s	T_EB4
T_EA8:	bsr	T_12AC
	tst.l	D0
	bmi.s	T_EB6
	bsr	T_10D0
T_EB4:	rts
;----------------------------------------------------------------------------
T_EB6:	move.l	D0,-(SP)
	move.l	A0,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	move.l	(SP)+,D0
	lea	D_206A,A0
	cmp.l	#-1,D0
	bne.s	T_EDA
	lea	D_2056,A0
	bra.s	T_EE8
;
T_EDA:	cmp.l	#-2,D0
	bne.s	T_EE8
	lea	D_2018,A0
T_EE8:	move.l	A0,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	rts
;----------------------------------------------------------------------------
T_EF4:	movem.l	D0/A0-A2,-(SP)
	movea.l	#$100,A2
	adda.l	D0,A2
	jsr	(A2)			;call start code of .DOS driver
	move.l	D0,B_5EE6		;save -> FunctionTable
	move.l	D1,B_6324		;save -> DriverName
	movem.l	(SP)+,D0/A0-A2
	tst.l	B_5EE6			;any error ?
	bmi	T_1054
T_F1C:	tst.l	gemdos_device_chain
	beq.s	T_F3C
	lea	B_3E9A,A3
	adda.l	#$1F0E,A3
	cmpa.l	B_6320,A3
	ble	T_1056
	bra.s	T_F46
;
T_F3C:	move.l	#B_3E9A,B_6320
T_F46:	addq.l	#1,A2
	tst.b	(A2)
	beq	T_1054
	cmpi.b	#LF,(A2)
	beq	T_1054
	cmpi.b	#',',(A2)
	beq.s	T_F46
	cmpi.b	#' ',(A2)
	beq.s	T_F46
	cmpi.b	#HT,(A2)
	beq.s	T_F46
	cmpi.b	#CR,(A2)
	beq.s	T_F46
	clr.w	D2
	move.b	(A2)+,D2
	cmpi.b	#':',(A2)+
	bne	T_1054
	clr.w	D0
	move.b	(A2),D0
	move.b	D0,B_6348
	movem.l	D2/A0-A2,-(SP)
	movea.l	B_5EE6,A0		;a0 -> FunctionTable of device
	movea.l	(A0),A0			;a0 -> initfun of device
	jsr	(A0)			;call initfun of device
	movem.l	(SP)+,D2/A0-A2
	tst.l	D0			;positive result ?
	bpl.s	T_FBA
	movea.l	B_6324,A0
	movem.l	D2/A2,-(SP)
	move.l	A0,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	movem.l	(SP)+,D2/A2
	bsr	T_1066
	bra	T_F1C
;
T_FBA:			;T_FBA:	;Here d0 -> LogDev struct,  d1 = filename mode bits
	movem.l	D0-D2/A0,-(SP)
	sub	#'A',D2
	blt.s	T_FD8
	cmp.w	#$19,D2
	bgt.s	T_FD8
	lea	B_6328,A0
	move.b	B_6348,0(A0,D2.w)
T_FD8:
	movem.l	(SP)+,D0-D2/A0
	movea.l	B_6320,A1
	tst.l	gemdos_device_chain
	beq.s	T_FFC
	movea.l	A1,A3
	lea	$13E(A3),A3
	move.l	A3,0(A1)
	movea.l	A3,A1
	move.l	A1,B_6320
T_FFC:
	move.l	D0,$10E(A1)		;save -> LogDev struct
	move.l	D1,$112(A1)		;save -> filename mode bits
	clr.l	0(A1)
	move.w	D2,4(A1)
	lea	$11E(A1),A3
	movea.l	B_6324,A4		;a4 -> DriverName
T_1016:
	move.b	(A4)+,(A3)+		;copy DriverName byte
	bne.s	T_1016			;loop back to copy entire DriverName
	move.l	B_5EE6,D0
	addq.l	#4,D0
	move.l	D0,6(A1)
	move.l	(_drvbits).w,D0		;_drvbits
	move.w	4(A1),D1
	sub.w	#$41,D1
	bset	D1,D0
	move.l	D0,(_drvbits).w		;_drvbits
	movea.l	B_6320,A0
	tst.l	gemdos_device_chain
	bne.s	T_104C
	move.l	A0,gemdos_device_chain
T_104C:	bsr	T_11CE
	bra	T_F1C
T_1054:	rts
;
T_1056:	move.l	#D_2084,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	rts
;----------------------------------------------------------------------------
T_1066:			;T_1066:
	movem.l	D0-D2/A0-A2,-(SP)
	cmp.l	#-$27,D0
	bne.s	T_107A
	lea	D_2034,A0
	bra.s	T_10B0
T_107A:	cmp.l	#-5,D0
	bne.s	T_108A
	lea	D_20CC,A0
	bra.s	T_10B0
T_108A:	cmp.l	#-12,D0
	bne.s	T_109A
	lea	D_20F0,A0
	bra.s	T_10B0
T_109A:	cmp.l	#-4,D0
	bne.s	T_10AA
	lea	D_2116,A0
	bra.s	T_10B0
T_10AA:	lea	D_20A6,A0
T_10B0:	move.l	A0,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	lea	D_212E,A0
	move.l	A0,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	movem.l	(SP)+,D0-D2/A0-A2
	rts
;----------------------------------------------------------------------------
T_10D0:	movem.l	D0/A0-A2,-(SP)
	movea.l	#$100,A2
	adda.l	D0,A2
	jsr	(A2)
	move.l	D0,B_5EE6
	movem.l	(SP)+,D0/A0-A2
	tst.l	B_5EE6
	bmi	T_11CC
T_10F2:	addq.l	#1,A2
	tst.b	(A2)
	beq	T_11CC
	cmpi.b	#10,(A2)
	beq	T_11CC
	cmpi.b	#$2C,(A2)
	beq.s	T_10F2
	cmpi.b	#$20,(A2)
	beq.s	T_10F2
	cmpi.b	#9,(A2)
	beq.s	T_10F2
	cmpi.b	#13,(A2)
	beq.s	T_10F2
	clr.w	D0
	move.b	(A2)+,D0
	cmpi.b	#$3A,(A2)+
	beq.s	T_1128
	clr.w	D1
	bra.s	T_1160
T_1128:	clr.w	D1
	move.b	(A2),D1
	sub.w	#$30,D1
	clr.w	D2
	move.b	1(A2),D2
	cmp.b	#$30,D2
	blt.s	T_1160
	cmp.b	#$39,D2
	bgt.s	T_1160
	addq.l	#1,A2
	sub.w	#$30,D2
	asl.b	#4,D1
	or.b	D2,D1
	move.b	D1,D2
	and.b	#$F0,D1
	lsr.b	#1,D1
	move.b	D1,D3
	lsr.b	#2,D1
	add.b	D3,D1
	and.b	#15,D2
	add.b	D2,D1
T_1160:	movem.l	D0/A2,-(SP)
	movea.l	B_5EE6,A0
	movea.l	(A0),A0
	jsr	(A0)
	move.l	D0,D1
	tst.l	D1
	bpl.s	T_1180
	bsr	T_1066
	movem.l	(SP)+,D0/A2
	bra	T_10F2
T_1180:	movem.l	(SP)+,D0/A2
	movea.l	D1,A0
	tst.l	xbios_device_chain
	beq.s	T_11AC
	movea.l	xbios_device_chain,A0
T_1194:	movea.l	0(A0),A1
	cmpa.l	#0,A1
	beq.s	T_11A4
	exg	A1,A0
	bra.s	T_1194
T_11A4:	move.l	D1,0(A0)
	movea.l	D1,A0
	bra.s	T_11B2
T_11AC:	move.l	A0,xbios_device_chain
T_11B2:	lea	D_1F2C,A1
	move.l	(A1),D1
	move.w	8(A0),D0
	sub.w	#$41,D0
	bset	D0,D1
	move.l	D1,(A1)
	bsr.s	T_120A
	bra	T_10F2
T_11CC:	rts
T_11CE:	exg	A0,A3
	lea	$11E(A3),A1
	move.l	A1,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	move.w	4(A3),D0
	beq.s	T_11F8
	lea	D_21AC,A1
	move.b	D0,$15(A1)
	move.l	A1,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
T_11F8:	move.l	#D_21A7,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	exg	A0,A3
	rts
T_120A:	exg	A0,A3
	lea	$1C(A3),A1
	move.l	A1,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	move.l	#D_2176,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	move.w	8(A3),D0
	beq.s	T_1242
	lea	D_2181,A1
	move.b	D0,4(A1)
	move.l	A1,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
T_1242:	move.w	10(A3),D0
	cmp.w	#$12,D0
	bge.s	T_129A
	move.w	10(A3),D0
	and.w	#7,D0
	add.b	#$30,D0
	move.b	D0,D_21A5
	lea	D_2188,A1
	move.w	10(A3),D0
	cmp.w	#8,D0
	blt.s	T_1280
	lea	D_2192,A1
	cmp.w	#$10,D0
	blt.s	T_1280
	lea	D_219C,A1
T_1280:	move.l	A1,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	lea	D_21A5,A1
	move.l	A1,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
T_129A:	move.l	#D_21A7,-(SP)
	move.w	#9,-(SP)
	trap	#1			;Cconws
	addq.w	#6,SP
	exg	A0,A3
	rts
T_12AC:	cmpi.b	#$2C,(A3)+
	bne.s	T_12AC
T_12B2:	cmpi.b	#$20,(A3)+
	bne.s	T_12B2
	movea.l	A3,A0
	lea	B_621F,A1
	clr.b	(A1)+
	clr.b	(A1)
	clr.w	D0
T_12C6:	cmpi.b	#13,(A3)
	beq.s	T_12E2
	cmpi.b	#$2C,(A3)
	beq.s	T_12E2
	cmpi.b	#$20,(A3)
	beq.s	T_12E6
	cmpi.b	#9,(A3)
	beq.s	T_12E6
	addq.l	#1,A3
	bra.s	T_12C6
T_12E2:	movea.l	A3,A2
	bra.s	T_1312
T_12E6:	movea.l	A3,A2
T_12E8:	cmpi.b	#$20,(A2)
	bne.s	T_12F2
	addq.l	#1,A2
	beq.s	T_12E8
T_12F2:	cmpi.b	#13,(A2)
	beq.s	T_130A
	cmpi.b	#$3B,(A2)
	beq.s	T_130A
	cmpi.b	#$2C,(A2)
	beq.s	T_130A
	move.b	(A2)+,(A1)+
	addq.w	#1,D0
	bra.s	T_12F2
T_130A:	clr.b	(A1)+
	move.b	D0,B_621F
T_1312:	clr.b	(A3)+
	movem.l	A0/A2,-(SP)
	bsr	T_13A6
	movem.l	(SP)+,A0/A2
	rts
T_1322:	lea	B_629F,A3
T_1328:	cmpi.b	#$20,(A3)
	bne.s	T_1338
	cmpi.b	#9,(A3)
	bne.s	T_1338
	addq.l	#1,A3
	bra.s	T_1328
T_1338:	movea.l	A3,A0
	lea	B_621F,A1
	clr.b	(A1)+
	clr.b	(A1)
	clr.w	D0
T_1346:	cmpi.b	#10,(A3)
	beq.s	T_135C
	cmpi.b	#$20,(A3)
	beq.s	T_1360
	cmpi.b	#9,(A3)
	beq.s	T_1360
	addq.l	#1,A3
	bra.s	T_1346
T_135C:	movea.l	A3,A2
	bra.s	T_1386
T_1360:	movea.l	A3,A2
T_1362:	cmpi.b	#$20,(A2)
	bne.s	T_136C
	addq.l	#1,A2
	beq.s	T_1362
T_136C:	cmpi.b	#10,(A2)
	beq.s	T_137E
	cmpi.b	#$3B,(A2)
	beq.s	T_137E
	move.b	(A2)+,(A1)+
	addq.w	#1,D0
	bra.s	T_136C
T_137E:	clr.b	(A1)+
	move.b	D0,B_621F
T_1386:	clr.b	(A3)+
	move.l	#0,-(SP)
	move.l	#B_621F,-(SP)
	move.l	A0,-(SP)
	move.w	#0,-(SP)
	move.w	#$4B,-(SP)
	trap	#1			;Pexec
	adda.w	#$10,SP
	rts
T_13A6:	move.w	#0,-(SP)
	move.l	A0,-(SP)
	move.w	#$3D,-(SP)
	trap	#1			;Fopen
	addq.w	#8,SP
	tst.w	D0
	bmi	T_14AC
	move.w	D0,B_6356
	suba.l	#$1C,SP
	move.l	SP,B_634A
	bsr.s	T_13E8
	adda.l	#$1C,SP
	move.l	D0,D3
	move.w	B_6356,-(SP)
	move.w	#$3E,-(SP)
	trap	#1			;Fclose
	addq.w	#4,SP
	move.l	D3,D0
	rts
T_13E8:	move.w	#2,-(SP)
	move.w	B_6356,-(SP)
	move.l	#0,-(SP)
	move.w	#$42,-(SP)
	trap	#1			;Fseek
	adda.w	#10,SP
	move.l	D0,B_6358
	move.w	#0,-(SP)
	move.w	B_6356,-(SP)
	move.l	#0,-(SP)
	move.w	#$42,-(SP)
	trap	#1			;Fseek
	adda.w	#10,SP
	move.l	B_634A,-(SP)
	move.l	#$1C,-(SP)
	move.w	B_6356,-(SP)
	move.w	#$3F,-(SP)
	trap	#1			;Fread
	adda.w	#12,SP
	cmpi.l	#$1C,D0
	bne.s	T_14A8
	movea.l	B_634A,A0
	cmpi.w	#$601A,0(A0)
	bne.s	T_14A8
	move.l	B_6358,D0
	sub.l	#$1C,D0
	add.l	#$100,D0
	add.l	10(A0),D0
	sub.l	14(A0),D0
	beq.s	T_14A8
	move.l	D0,-(SP)
	move.w	#$48,-(SP)
	trap	#1			;Malloc
	addq.w	#6,SP
	move.l	D0,B_6352
	beq.s	T_14B0
	bsr	T_1560
	bsr.s	T_14E6
	bmi.s	T_149A
	bsr.s	T_14B4
	bmi.s	T_149A
	bsr	T_15DA
	move.l	B_6352,D0
	rts
T_149A:	move.l	B_6352,-(SP)
	move.w	#$49,-(SP)
	trap	#1			;Mfree
	addq.w	#6,SP
T_14A8:	moveq	#$FF,D0
	rts
T_14AC:	moveq	#$FD,D0
	rts
T_14B0:	moveq	#$FE,D0
	rts
T_14B4:	movea.l	B_6352,A0
	movea.l	8(A0),A3
	movea.l	$18(A0),A4
	move.l	A3,D3
	move.l	(A4)+,D0
	beq.s	T_14E4
	adda.l	D0,A3
	add.l	D3,(A3)
	clr.w	D0
T_14CE:	move.b	(A4)+,D0
	beq.s	T_14E4
	cmp.b	#1,D0
	bne.s	T_14DE
	adda.w	#$FE,A3
	bra.s	T_14CE
T_14DE:	adda.l	D0,A3
	add.l	D3,(A3)
	bra.s	T_14CE
T_14E4:	rts
T_14E6:	movea.l	B_6352,A3
	movea.l	8(A0),A4
	movea.l	B_634A,A5
	move.l	2(A5),D3
	add.l	6(A5),D3
	move.l	A4,-(SP)
	move.l	D3,-(SP)
	move.w	B_6356,-(SP)
	move.w	#$3F,-(SP)
	trap	#1			;Fread
	adda.w	#12,SP
	cmp.l	D0,D3
	bne.s	T_14A8
	move.l	14(A5),D0
	move.w	#1,-(SP)
	move.w	B_6356,-(SP)
	move.l	D0,-(SP)
	move.w	#$42,-(SP)
	trap	#1			;Fseek
	adda.w	#10,SP
	movea.l	$18(A3),A0
	clr.l	D0
	move.l	D0,0(A0)
	tst.w	$1A(A5)
	bne.s	T_155E
	move.l	A0,-(SP)
	move.l	#$7FFFFFFF,-(SP)
	move.w	B_6356,-(SP)
	move.w	#$3F,-(SP)
	trap	#1			;Fread
	adda.w	#12,SP
	tst.l	D0
	beq	T_14A8
T_155E:	rts
T_1560:	movea.l	B_6352,A0
	movea.l	B_634E,A1
	movea.l	B_634A,A2
	move.l	A0,0(A0)
	move.l	#$100,D0
	add.l	2(A2),D0
	add.l	6(A2),D0
	add.l	10(A2),D0
	move.l	D0,4(A0)
	move.l	A0,D0
	add.l	#$100,D0
	move.l	D0,8(A0)
	move.l	2(A2),12(A0)
	add.l	12(A0),D0
	move.l	D0,$10(A0)
	move.l	6(A2),$14(A0)
	add.l	$14(A0),D0
	move.l	D0,$18(A0)
	move.l	10(A2),$1C(A0)
	move.l	$24(A1),$24(A0)
	move.l	$2C(A1),$2C(A0)
	lea	$80(A0),A1
	move.l	A1,$20(A0)
	lea	B_621F,A2
T_15D4:	move.b	(A2)+,(A1)+
	bne.s	T_15D4
	rts
T_15DA:	movem.l	D3-D7/A3,-(SP)
	movea.l	B_6352,A0
	movea.l	$18(A0),A1
	move.l	$1C(A0),D0
	movea.l	A1,A0
	adda.l	D0,A1
	moveq	#0,D1
	moveq	#0,D2
	moveq	#0,D3
	moveq	#0,D4
	moveq	#0,D5
	moveq	#0,D6
	moveq	#0,D7
	movea.w	D7,A3
	move.l	A0,D0
	btst	#0,D0
	beq.s	T_160A
	move.b	D1,(A0)+
T_160A:	move.l	A1,D0
	sub.l	A0,D0
	and.l	#-$100,D0
	beq.s	T_1642
	lea	0(A0,D0.l),A0
	movea.l	A0,A2
	lsr.l	#8,D0
T_161E:	movem.l	D1-D7/A3,-(A2)
	movem.l	D1-D7/A3,-(A2)
	movem.l	D1-D7/A3,-(A2)
	movem.l	D1-D7/A3,-(A2)
	movem.l	D1-D7/A3,-(A2)
	movem.l	D1-D7/A3,-(A2)
	movem.l	D1-D7/A3,-(A2)
	movem.l	D1-D7/A3,-(A2)
	subq.l	#1,D0
	bne.s	T_161E
T_1642:	cmpa.l	A0,A1
	beq.s	T_164A
	move.b	D1,(A0)+
	bra.s	T_1642
T_164A:	movem.l	(SP)+,D3-D7/A3
	rts
;----------------------------------------------------------------------------
;Start of:	MD_func_Pexec
;----------------------------------------------------------------------------
MD_func_Pexec:			;T_1650:
	tst.w	6(SP)
	beq.s	T_1660
	cmpi.w	#3,6(SP)
	bne	T_7B2
T_1660:	movea.l	8(SP),A0
	cmpi.b	#$3A,1(A0)
	bne.s	T_167C
	clr.w	D0
	move.b	(A0),D0
	cmp.b	#$61,D0
	blt.s	T_1686
	sub.b	#$20,D0
	bra.s	T_1686
T_167C:	move.w	last_Dsetdrv,D0
	add.w	#'A',D0
T_1686:	move.w	D0,B_63BE
	bsr	find_gemdos_device
	bmi	T_7B2
	move.l	A0,B_2C20
	move.w	#0,-(SP)
	move.l	10(SP),-(SP)
	move.w	#$3D,-(SP)
	jsr	MD_func_Fcreate_Fopen
	addq.l	#8,SP
	tst.l	D0
	bmi	T_1740
	move.w	D0,B_63BC
	pea	B_637C
	move.l	#$1C,-(SP)
	move.w	D0,-(SP)
	move.w	#$3F,-(SP)
	bsr	MD_func_Fread_Fwrite
	lea	12(SP),SP
	cmp.l	#$1C,D0
	bne.s	T_1742
	lea	B_637C,A0
	cmpi.w	#$601A,0(A0)
	bne.s	T_1742
	move.l	$10(SP),-(SP)
	move.l	$10(SP),-(SP)
	move.l	$16(A0),-(SP)
	move.w	#7,-(SP)
	move.w	#$4B,-(SP)
	bsr	use_old_gemdos_sub
	lea	$10(SP),SP
	cmp.l	#-$20,D0
	bne.s	T_1728
	move.l	$10(SP),-(SP)
	move.l	$10(SP),-(SP)
	clr.l	-(SP)
	move.w	#5,-(SP)
	move.w	#$4B,-(SP)
	bsr	use_old_gemdos_sub
	lea	$10(SP),SP
T_1728:	tst.l	D0
	bmi.s	T_1734
	move.l	D0,B_63B8
	bsr.s	T_175A
T_1734:	move.l	D0,D3
	bsr.s	T_1748
	move.l	D3,D0
	bmi.s	T_17B8
	bra	T_17D4
T_1740:	rts
T_1742:	bsr.s	T_1748
	moveq	#$BE,D0
	bra.s	T_1740
T_1748:	move.w	B_63BC,-(SP)
	move.w	#$3E,-(SP)
	bsr	MD_func_Fclose
	addq.l	#4,SP
	rts
T_175A:	lea	B_637C,A0
	move.l	#$100,D0
	add.l	2(A0),D0
	add.l	6(A0),D0
	add.l	10(A0),D0
	move.l	D0,B_63C0
	movea.l	B_63B8,A1
	move.l	4(A1),D0
	sub.l	0(A1),D0
	cmp.l	B_63C0,D0
	bmi.s	T_17B4
	bsr	T_190A
	bsr	T_1878
	bmi.s	T_17B4
	bsr	T_1822
	bsr	T_1854
	move.l	B_63B8,D0
	rts
	moveq	#$DF,D0
	bra.s	T_17B6
	moveq	#$BE,D0
	bra.s	T_17B6
	moveq	#$DF,D0
	bra.s	T_17B6
T_17B4:	moveq	#$D9,D0
T_17B6:	rts
T_17B8:	move.l	D0,B_635C
	bsr	T_2D2
	lea	T_1810,A0
	movea.l	B_63B8,A1
	move.l	A0,8(A1)
	bra.s	T_17DA
T_17D4:	clr.l	B_635C
T_17DA:	tst.l	B_63C4
	beq.s	T_17E6
	bsr	T_1946
T_17E6:	clr.l	$10(SP)
	move.l	B_63B8,12(SP)
	clr.l	8(SP)
	move.w	#4,6(SP)
	tst.l	B_63C4
	bne	T_7B2
	move.w	#6,6(SP)
	bra	T_7B2
T_1810:	move.w	B_635C,-(SP)
	clr.w	-(SP)
	move.w	#$4C,-(SP)
	trap	#1			;Pterm
	illegal
	illegal
;----------------------------------------------------------------------------
T_1822:	movea.l	B_63B8,A0
	movea.l	8(A0),A3
	movea.l	$18(A0),A4
	move.l	A3,D3
	move.l	(A4)+,D0
	beq.s	T_1852
	adda.l	D0,A3
	add.l	D3,(A3)
	clr.l	D0
T_183C:	move.b	(A4)+,D0
	beq.s	T_1852
	cmp.b	#1,D0
	bne.s	T_184C
	adda.w	#$FE,A3
	bra.s	T_183C
T_184C:	adda.l	D0,A3
	add.l	D3,(A3)
	bra.s	T_183C
T_1852:	rts
T_1854:	movem.l	D0-A6,-(SP)
	clr.l	D1
	movea.l	B_63B8,A0
	move.l	$1C(A0),D0
	asr.l	#2,D0
	addq.w	#1,D0
	movea.l	$18(A0),A0
T_186C:	move.l	D1,(A0)+
	subq.w	#1,D0
	bne.s	T_186C
	movem.l	(SP)+,D0-A6
	rts
T_1878:	movea.l	B_63B8,A3
	lea	B_637C,A5
	move.l	2(A5),D3
	add.l	6(A5),D3
	move.l	D3,-(SP)
	move.l	8(A3),-(SP)
	move.l	D3,-(SP)
	move.w	B_63BC,-(SP)
	move.w	#$3F,-(SP)
	jsr	MD_func_Fread_Fwrite
	lea	12(SP),SP
	move.l	(SP)+,D3
	cmp.l	D0,D3
	bne	T_17B4
	lea	B_637C,A5
	move.l	14(A5),D0
	move.w	#1,-(SP)
	move.w	B_63BC,-(SP)
	move.l	D0,-(SP)
	move.w	#$42,-(SP)
	bsr	MD_func_Fseek_Fdatime
	lea	10(SP),SP
	movea.l	B_63B8,A3
	movea.l	$18(A3),A0
	clr.l	D0
	move.l	D0,0(A0)
	tst.w	$1A(A5)
	bne.s	T_1902
	move.l	A0,-(SP)
	move.l	#$7FFFFFFF,-(SP)
	move.w	B_63BC,-(SP)
	move.w	#$3F,-(SP)
	bsr	MD_func_Fread_Fwrite
	lea	12(SP),SP
T_1902:	tst.l	D0
	bmi	T_17B4
	rts
T_190A:	movea.l	B_63B8,A0
	lea	B_637C,A2
	move.l	A0,D0
	add.l	#$100,D0
	move.l	D0,8(A0)
	move.l	2(A2),12(A0)
	add.l	12(A0),D0
	move.l	D0,$10(A0)
	move.l	6(A2),$14(A0)
	add.l	$14(A0),D0
	move.l	D0,$18(A0)
	move.l	10(A2),$1C(A0)
	rts
T_1946:	movea.l	B_63C4,A2
	movea.l	4(A2),A3
	movea.l	B_63B8,A2
	movea.l	$2C(A2),A4
T_195A:	cmpa.l	#0,A3
	beq.s	T_1978
	movea.l	4(A3),A0
	cmpa.l	A2,A0
	beq.s	T_196E
	cmpa.l	A4,A0
	bne.s	T_1972
T_196E:	move.l	A2,12(A3)
T_1972:	movea.l	0(A3),A3
	bra.s	T_195A
T_1978:	rts
T_197A:	movea.l	$4F2.w,A0		;_sysbase
	movea.l	8(A0),A0
	cmpi.w	#$102,2(A0)
	bcc.s	T_19A4
	move.w	$1C(A0),D0
	lsr.w	#1,D0
	subq.w	#4,D0
	bne.s	T_199C
	move.l	#$873C,D0
	rts
T_199C:	move.l	#$602C,D0
	rts
T_19A4:	move.l	$28(A0),D0
	rts
;----------------------------------------------------------------------------
	SECTION	DATA
;----------------------------------------------------------------------------
;Start of:	MD_gemdos_func_t
;----------------------------------------------------------------------------
MD_gemdos_func_t:			;D_19AA:
	dc.l	MD_func_Pterm_x			;$000 = 000 = Pterm0
	dc.l	'','','','','','','',''
	dc.l	'','','','',''
	dc.l	MD_func_Dsetdrv			;$00E = 014 = Dsetdrv
	dc.l	'','','','','','','',''
	dc.l	'',''
	dc.l	MD_func_Dgetdrv			;$019 = 025 = Dgetdrv
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','',''
	dc.l	MD_func_Pterm_x			;$031 = 048 = Ptermres
	dc.l	'','','',''
	dc.l	MD_func_Dfree			;$036 = 054 = Dfree
	dc.l	'',''
	dc.l	MD_func_DF_diverse		;$039 = 057 = Dcreate
	dc.l	MD_func_DF_diverse		;$03A = 058 = Ddelete
	dc.l	MD_func_Dsetpath		;$03B = 059 = Dsetpath
	dc.l	MD_func_Fcreate_Fopen		;$03C = 060 = Fcreate
	dc.l	MD_func_Fcreate_Fopen		;$03D = 061 = Fopen
	dc.l	MD_func_Fclose			;$03E = 062 = Fclose
	dc.l	MD_func_Fread_Fwrite		;$03F = 063 = Fread
	dc.l	MD_func_Fread_Fwrite		;$040 = 064 = Fwrite
	dc.l	MD_func_DF_diverse		;$041 = 065 = Fdelete
	dc.l	MD_func_Fseek_Fdatime		;$042 = 066 = Fseek
	dc.l	MD_func_DF_diverse		;$043 = 067 = Fattrib
	dc.l	'','',''
	dc.l	MD_func_Dgetpath		;$047 = 071 = Dgetpath
	dc.l	'','',''
	dc.l	MD_func_Pexec			;$04B = 075 = Pexec
	dc.l	MD_func_Pterm_x			;$04C = 076 = Pterm
	dc.l	''
	dc.l	MD_func_Fsfirst			;$04E = 078 = Fsfirst
	dc.l	MD_func_Fsnext			;$04F = 079 = Fsnext
	dc.l	'','','','','',''
	dc.l	MD_func_DF_diverse		;$056 = 086 = Frename
	dc.l	MD_func_Fseek_Fdatime		;$057 = 087 = Fdatime
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','',''
	dc.l	MD_func_Fcntl			;$104 = 260 = Fcntl
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	'','','','','','',''
	dc.l	MD_func_Dpathconf_D_x_label	;$124 = 292 = Dpathconf
	dc.l	'','',''
	dc.l	MD_func_Dopendir		;$128 = 296 = Dopendir
	dc.l	MD_func_Dreaddir_Dxreaddir	;$129 = 297 = Dreaddir
	dc.l	MD_func_Drewinddir		;$12A = 298 = Drewinddir
	dc.l	MD_func_Dclosedir		;$12B = 299 = Dclosedir
	dc.l	MD_func_Fxattr_Dcntl		;$12C = 300 = Fxattr
	dc.l	'','',''
	dc.l	MD_func_Fxattr_Dcntl		;$130 = 304 = Dcntl
	dc.l	'','','','','','','',''
	dc.l	'','','','','','','',''
	dc.l	''
	dc.l	MD_func_Dreaddir_Dxreaddir	;$142 = 322 = Dxreaddir
	dc.l	'','','','','','','',''
	dc.l	'','','','','','',''
	dc.l	MD_func_Dpathconf_D_x_label	;$152 = 338 = Dreadlabel
	dc.l	MD_func_Dpathconf_D_x_label	;$153 = 339 = Dwritelabel
	dc.l	'','','','','','','',''
	dc.l	'','','',''
;----------------------------------------------------------------------------
;End of:	MD_gemdos_func_t
;----------------------------------------------------------------------------
frame_size:
	dc.b	$0,$6
D_1F2C:	dc.b	$0,$0,$0,$0
	dc.l	D_1FC0
	dc.b	$0,$0,$0,$0
	dc.l	D_1FD6
D_1F3C:	dc.b	$D,$A,$1B,'p Atari MetaDOS   (December 30,'
	dc.b	' 1994) ',$1B,'q',$D,$A,' Version 2.50     '
	dc.b	'            RMS,RJZ',$D,$A,' Copyright Ata'
	dc.b	'ri Corporation     1994',$D,$A
D_1FB8:	dc.b	$D,$A,$D,$0,'@(#)'
D_1FC0:	dc.b	'Atari MetaDOS v2.50',$0,$0
D_1FD6:	dc.b	$2,'P_MET'
	dc.l	B_6328
D_1FE0:	dc.b	'Atari MetaDOS already installed!',$D,$A,$0
C_AUTO_CONFIG_SYS_s:			;D_2004
	dc.b	'C:\AUTO\CONFIG.SYS',$0,$0
D_2018:	dc.b	' no memory to load file.',$D,$A,$0,$0
D_2034:	dc.b	' out of memory to install DOS.',$D,$A,$0,$0
D_2056:	dc.b	' BAD file error.',$D,$A,$0,$0
D_206A:	dc.b	' file not found error.',$D,$A,$0,$0
D_2084:	dc.b	'Out of logical device headers.',$D,$A,$0,$0
D_20A6:	dc.b	' BOS error: device not responding.',$D,$A,$0
	dc.b	$0
D_20CC:	dc.b	' indicates unknown command error.',$D,$A,$0
D_20F0:	dc.b	' indicates general hardware error.',$D,$A,$0
	dc.b	$0
D_2116:	dc.b	' indicates CRC error.',$D,$A,$0
D_212E:	dc.b	'This driver is not installed.',$D,$A,$0
D_214E:	dc.b	'Config.sys not found in auto folder.',$D,$A
	dc.b	$0,$0
D_2176:	dc.b	' installed',$0
D_2181:	dc.b	' as x:',$0
D_2188:	dc.b	' on ACSI ',$0
D_2192:	dc.b	' on SCSI ',$0
D_219C:	dc.b	' on IDE ',$0
D_21A5:	dc.b	'x',$0
D_21A7:	dc.b	'.',$D,$A,$0,$0
D_21AC:	dc.b	' driver installed as x:',$0
;
;----------------------------------------------------------------------------
	SECTION	BSS
;----------------------------------------------------------------------------
;
	ds.l	512			;=2048
B_29C4:	ds.l	1			;=4
B_29C8:	ds.l	1			;=4
B_29CC:	ds.l	73			;=292
B_2AF0:	ds.l	73			;=292
B_2C14:	ds.l	1			;=4
xbios_device_chain:	ds.l	1			;=4	B_2C18
gemdos_device_chain:	ds.l	1			;=4	B_2C1C
B_2C20:	ds.l	2			;=8
last_Dsetdrv:		ds.w	3			;=6	B_2C28
B_2C2E:	ds.l	64			;=256
expanded_pathname:	ds.l	64			;=256	B_2D2E
B_2E2E:	ds.l	1			;=4
meta_FCB_t:	ds.l	1050			;=4200	B_2E32
B_3E9A:	ds.l	2067			;=8268
B_5EE6:	ds.w	3			;=6
B_5EEC:	ds.l	100			;=400
B_607C:	ds.w	1			;=2
B_607E:	ds.l	100			;=400
B_620E:	ds.l	1			;=4
B_6212:	ds.l	1			;=4
B_6216:	ds.l	1			;=4
B_621A:	ds.b	5			;=5
B_621F:	ds.b	128			;=128
B_629F:	ds.b	129			;=129
B_6320:	ds.l	1			;=4
B_6324:	ds.l	1			;=4
B_6328:	ds.l	8			;=32
B_6348:	ds.w	1			;=2
B_634A:	ds.l	1			;=4
B_634E:	ds.l	1			;=4
B_6352:	ds.l	1			;=4
B_6356:	ds.w	1			;=2
B_6358:	ds.l	1			;=4
B_635C:	ds.l	8			;=32
B_637C:	ds.l	15			;=60
B_63B8:	ds.l	1			;=4
B_63BC:	ds.w	1			;=2
B_63BE:	ds.w	1			;=2
B_63C0:	ds.l	1			;=4
B_63C4:	ds.l	1			;=4
;
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	METADOS.S
;----------------------------------------------------------------------------
