;----------------------------------------------------------------------------
;File name:	ICDCD_RA.S			Revision date:	1995.07.06
;Revised by:	Ulf Ronald Andersson		Revision start:	1995.07.06
;----------------------------------------------------------------------------
;Desert	Drain V1.41   68000er Disassembler  06.07.1995 00:57:20
;DATEI:	ICDCDROM.BOS   2547 Bytes
;TEXT:	 2348	$0092C
;DATA:	   68	$00044
;BSS:	  968  $0003C8
;----------------------------------------------------------------------------
;
	output	.BOS
;
;-----------------------------------------------------------------------------
;
MAX_BOS_ENTRIES	= 8	;original value was 8
;
;-----------------------------------------------------------------------------
;
	include	URAn_DOS.S
	include	Meta_Def.S
;
;----------------------------------------------------------------------------
;
	SECTION	TEXT
;
;----------------------------------------------------------------------------
;
start:
	bra	check_cookies
;
delay_10_ms:
	move.l	D0,-(SP)
	moveq	#2,D0
	add.l	$4BA.w,D0		;_hz_200
.T_C:
	cmp.l	$4BA.w,D0		;_hz_200
	bgt.s	.T_C
	move.l	(SP)+,D0
	rts
;
;----------------------------------------------------------------------------
;
T_16:
	move.l	D0,-(SP)
	move	sr,D1
	ori	#$700,sr
	dc.w	$4E7A			;Nz
	dc.w	$0002			;
	or.l	#0,D0
	dc.w	$0808			;
	dc.w	$4E7B			;N{
	dc.w	$0002			;
	move	D1,sr
	move.l	(SP)+,D0
	rts
;
;----------------------------------------------------------------------------
;
T_32:
	st	$43E.w			;flock
	lea	SCSI_cmd_buf,A1
	lea	$FF8604,A0		;hw_dmadata
	move.l	A2,-(SP)
	move.b	3(SP),$FF860D		;dmalow
	move.b	2(SP),$FF860B		;dmamid
	move.b	1(SP),$FF8609		;dmahigh
	adda.l	#4,SP
	move.w	#$190,2(A0)		;(hw_dmacont) = Wr|Reg|SCR|cmd
	move.b	$FFFFFA01.w,D0		;gpip
	move.b	$FFFFFA01.w,D0		;gpip
	move.b	$FFFFFA01.w,D0		;gpip
	move.b	$FFFFFA01.w,D0		;gpip
	move.w	#$90,2(A0)		;(hw_dmacont) = _Rd|Reg|SCR|_cmd
	move.b	$FFFFFA01.w,D0		;gpip
	move.b	$FFFFFA01.w,D0		;gpip
	move.b	$FFFFFA01.w,D0		;gpip
	move.b	$FFFFFA01.w,D0		;gpip
	move.w	D1,0(A0)		;SCR = d1
	jsr	delay_10_ms
	move.w	#$88,2(A0)		;(hw_dmacont) = _Rd|Reg|_extR|_cmd
	move.l	#$C8,D1
	clr.w	D0
	move.b	(A1)+,D0
	bsr	T_10C
	bne.s	T_DE
	sub.w	#2,D2
T_B2:
	move.b	(A1)+,D0
	bsr	T_10C
	bne.s	T_DE
	dbra	D2,T_B2
	move.l	#$7D0,D1
	move.b	(A1)+,D0
	swap	D0
	bsr	T_112
	bne.s	T_DE
	move.w	#$8A,2(A0)
	jsr	delay_10_ms
	move.w	0(A0),D0
T_DE:
	jsr	delay_10_ms
	move.w	#$80,2(A0)
	clr.w	$43E.w			;flock
	andi.l	#$FF,D0
	move.l	D0,B_B1C
	tst.w	new_cpu_f
	beq	T_10A
	jsr	T_16
T_10A:
	rts
;
;----------------------------------------------------------------------------
;
T_10C:
	swap	D0
	move.w	#$8A,D0		;d0 = _Rd|Reg|_extR|data
T_112:
	move.l	D0,(A0)		;split d0 to (hw_dmadata) & (hw_dmacont)
	bsr	delay_10_ms
	move.l	D1,D0
	add.l	$4BA.w,D0		;_hz_200
T_11E:
	btst	#5,$FFFFFA01.w		;gpip
	beq.s	T_130
	cmp.l	$4BA.w,D0		;_hz_200
	bge.s	T_11E
	moveq	#$ffFFffFF,D0
	rts
;
;----------------------------------------------------------------------------
;
T_130:
	moveq	#0,D0
	rts
;
;----------------------------------------------------------------------------
;
check_cookies:
	clr.w	new_cpu_f
	clr.l	fastram_buf_p
	move.l	(_cookies).w,D0
	beq.s	T_17E
	movea.l	D0,A0
T_148:
	tst.l	(A0)
	beq.s	T_17E
	cmpi.l	#'_CPU',(A0)
	bne.s	T_166
	cmpi.l	#20,4(A0)	;CPU older than 68020 ?
	blt.s	T_166
	move.w	#1,new_cpu_f
T_166:
	cmpi.l	#'_FRB',(A0)
	bne.s	T_176
	move.l	4(A0),fastram_buf_p
T_176:
	adda.l	#8,A0
	bra.s	T_148
;
T_17E:
	move.l	#BOS_table_beg,BOS_table_p
	clr.w	B_D32
	move.l	#init_BOS_func_p,D0
	rts
;
;----------------------------------------------------------------------------
;
init_BOS_func:
	tst.l	BOS_table_p
	bne.s	T_1A2
	moveq	#$ffFFffD9,D0
	rts
;
T_1A2:
	move.w	D0,D3
	move.w	D1,-(SP)
	lea	dma_data_buf,A0
	move.w	D1,bos_drive_ID(a0)
	move.w	#$12,D0
	bsr	T_90C
	move.b	#$20,4(A1)
	lea	dma_data_buf,A2
	move.w	#1,D1
	move.w	#5,D2
	jsr	T_32
	move.w	(SP)+,D1
	tst.b	D0
	bmi.s	T_240
	movea.l	BOS_table_p,A1
	movea.l	A1,A0
	move.w	#$3C,D4
	subq.w	#1,D4
T_1EC:
	clr.b	(A1)+
	dbra	D4,T_1EC
	clr.l	0(A0)
	clr.l	4(A0)
	move.l	#Metafunc_t,bos_func_t_p(a0)
	move.w	D1,bos_drive_ID(a0)
	move.w	D3,8(A0)
	lea	T_244,A1
	lea	BOS_title_s(A0),A2
T_214:
	move.b	(A1)+,(A2)+
	bne.s	T_214
	addi.l	#60,BOS_table_p
;;;	move.l	BOS_table_beg,D1	;This BUG (omitted '#') could cause bombs
;;;	add.l	#$1A4,D1		;Also, I generate the sum at assembly
;;;	cmp.l	BOS_table_p,D1		;And use 'cmpi.l' for simpler code
	cmpi.l	#BOS_table_end,BOS_table_p	;;;new;;;
	blt.s	T_23C
	clr.l	BOS_table_p
T_23C:
	move.l	A0,D0
	rts
;
;----------------------------------------------------------------------------
;
T_240:
	moveq	#$ffFFffFE,D0
	rts
;
;----------------------------------------------------------------------------
;
T_244:	dc.b	'ICD AdSCSI CD-ROM/Audio BOS v1.0',$0,$0
;
;----------------------------------------------------------------------------
;
nu_Metaopen:
	movea.l	4(SP),A1
	lea	BOS_title_s(A0),A0
	move.l	A0,(A1)+
	clr.l	(A1)+
	clr.l	(A1)+
	clr.l	(A1)+
	clr.l	D0
	rts
;
;----------------------------------------------------------------------------
;
nu_Metaclose:
	clr.l	D0
	rts
;
;----------------------------------------------------------------------------
;
nu_Metaread:
	bclr	#3,$13(A0)
	move.l	A0,B_B18
	bsr	T_83A
	cmp.b	#$FF,D0
	beq.s	T_2B2
	btst	#3,D0
	bne.s	T_2B6
	btst	#1,D0
	beq.s	T_2B4
	movea.l	B_B18,A0
	bsr	T_75E
	cmp.l	#-$12,D0
	bne.s	T_2B4
T_2B2:
	moveq	#$ffFFffFE,D0
T_2B4:
	rts
;
;----------------------------------------------------------------------------
;
T_2B6:
	move.l	#-$7FFC,D0
	rts
;
;----------------------------------------------------------------------------
;
nu_Metafunc_5:
	bclr	#3,$13(A0)
	move.l	A0,B_B18
	move.w	#11,D0
	bsr	T_90C
	move.b	5(SP),1(A1)
	move.b	6(SP),2(A1)
	move.b	7(SP),3(A1)
	moveq	#0,D1
	lea	dma_data_buf,A2
	move.w	#5,D2
	jsr	T_32
	cmp.b	#$FF,D0
	beq.s	T_31A
	btst	#3,D0
	bne.s	T_31E
	btst	#1,D0
	beq.s	T_31C
	movea.l	B_B18,A0
	bsr	T_75E
	cmp.l	#-$12,D0
	bne.s	T_31C
T_31A:
	moveq	#$ffFFffFE,D0
T_31C:
	rts
;
;----------------------------------------------------------------------------
;
T_31E:
	move.l	#-$7FFC,D0
	rts
;
;----------------------------------------------------------------------------
;
nu_Metastatus:
	move.l	A0,B_B18
	jsr	T_7EC
	cmp.b	#$FF,D0
	beq.s	T_386
	and.l	#15,D0
	beq.s	T_378
	btst	#1,D0
	bne.s	T_354
	btst	#3,D0
	bne.s	T_370
	move.l	#-$7FFE,D0
	bra.s	T_37A
;
T_354:
	lea	BOS_table_beg,A0
T_35A:
	move.w	#8,$12(A0)
	movea.l	0(A0),A0
	cmpa.l	#0,A0
	bne.s	T_35A
	moveq	#8,D0
	bra.s	T_37A
;
T_370:
	move.l	#-$7FFC,D0
	bra.s	T_37A
;
T_378:
	clr.l	D0
T_37A:
	movea.l	B_B18,A0
	or.w	$12(A0),D0
	rts
;
;----------------------------------------------------------------------------
;
T_386:
	move.l	#-$7F80,D0
	rts
;
;----------------------------------------------------------------------------
;
nu_Metastartaudio:
	move.w	4(SP),D0
	and.w	#2,D0
	bne	T_462
	move.l	A0,B_B18
	bsr	T_80A
	ext.l	D0
	bmi	T_460
	move.w	#$47,D0
	bsr	T_90C
	movea.l	6(SP),A2
	move.b	1(A2),D0
	jsr	T_6BE
	lea	dma_data_buf,A2
	adda.l	#6,A2
T_3D2:
	tst.b	(A2)
	beq.s	T_3E2
	cmp.b	(A2),D0
	beq.s	T_3E2
	adda.l	#8,A2
	bra.s	T_3D2
;
T_3E2:
	move.l	2(A2),D0
	jsr	T_706
	move.l	D0,-(SP)
	move.b	1(SP),3(A1)
	move.b	2(SP),4(A1)
	move.b	3(SP),5(A1)
	adda.l	#4,SP
	lea	dma_data_buf,A2
	adda.l	#6,A2
T_412:
	tst.b	(A2)
	beq.s	T_424
	cmpi.b	#$AA,(A2)
	beq.s	T_424
	adda.l	#8,A2
	bra.s	T_412
;
T_424:
	adda.l	#2,A2
	move.l	(A2),D0
	jsr	T_706
	move.l	D0,-(SP)
	move.b	1(SP),6(A1)
	move.b	2(SP),7(A1)
	move.b	3(SP),8(A1)
	adda.l	#4,SP
	lea	dma_data_buf,A2
	move.w	#0,D1
	move.w	#9,D2
	jsr	T_32
T_460:
	rts
;
;----------------------------------------------------------------------------
;
T_462:
	moveq	#$ffFFffFF,D0
	rts
;
;----------------------------------------------------------------------------
;
nu_Metastopaudio:
	move.w	#$1B,D0
	bsr	T_90C
	move.b	#1,1(A1)
	lea	dma_data_buf,A2
	clr.l	D1
	move.w	#5,D2
	jsr	T_32
	rts
;
;----------------------------------------------------------------------------
;
nu_Metasetsongtime:
	move.l	A0,B_B18
	move.w	#$47,D0
	bsr	T_90C
	move.b	7(SP),3(A1)
	move.b	8(SP),4(A1)
	move.b	9(SP),5(A1)
	move.b	11(SP),6(A1)
	move.b	12(SP),7(A1)
	move.b	13(SP),8(A1)
	lea	dma_data_buf,A2
	move.w	#0,D1
	move.w	#9,D2
	jsr	T_32
	cmp.b	#$FF,D0
	beq.s	T_4F8
	btst	#3,D0
	bne.s	T_4F0
	btst	#1,D0
	beq.s	T_4EE
	movea.l	B_B18,A0
	bsr	T_75E
T_4EE:
	rts
;
;----------------------------------------------------------------------------
;
T_4F0:
	move.l	#-$7FFC,D0
	rts
;
;----------------------------------------------------------------------------
;
T_4F8:
	moveq	#$ffFFffFE,D0
	rts
;
;----------------------------------------------------------------------------
;
nu_Metagettoc:
	bclr	#3,$13(A0)
	move.l	A0,B_B18
	bsr	T_80A
	cmp.b	#$FF,D0
	beq.s	T_568
	btst	#3,D0
	bne	T_75E
	btst	#1,D0
	bne	T_75E
	lea	dma_data_buf,A0
	adda.l	#4,A0
	movea.l	6(SP),A1
T_532:
	tst.b	2(A0)
	beq.s	T_562
	move.l	4(A0),D0
	jsr	T_6BE
	move.l	D0,(A1)
	move.b	2(A0),D0
	cmp.b	#$AA,D0
	bne.s	T_552
	move.b	#$A2,D0
T_552:
	move.b	D0,(A1)
	adda.l	#4,A1
	adda.l	#8,A0
	bra.s	T_532
;
T_562:
	clr.l	D0
	move.l	D0,(A1)
	rts
;
;----------------------------------------------------------------------------
;
T_568:
	moveq	#$ffFFffFE,D0
	rts
;
;----------------------------------------------------------------------------
;
nu_Metagetdiscinfo:
	bclr	#3,$13(A0)
	move.l	A0,B_B18
	jsr	T_7EC
	tst.l	D0
	beq.s	T_5BE
	cmp.b	#$FF,D0
	beq	T_6B2
	movea.l	B_B18,A0
	bsr	T_75E
	cmp.l	#-$12,D0
	beq	T_6B0
	cmp.l	#-14,D0
	bne.s	T_5BE
	lea	BOS_table_beg,A0
T_5AC:
	move.w	#8,$12(A0)
	movea.l	0(A0),A0
	cmpa.l	#0,A0
	bne.s	T_5AC
T_5BE:
	tst.l	4(SP)
	beq	T_6B0
	move.l	D0,-(SP)
	movea.l	B_B18,A0
	move.w	#$42,D0
	bsr	T_90C
	move.b	#2,1(A1)
	move.b	#$40,2(A1)
	move.b	#$10,8(A1)
	lea	dma_data_buf,A2
	move.w	#1,D1
	move.w	#9,D2
	jsr	T_32
	ext.l	D0
	bmi	T_6AE
	movea.l	8(SP),A0
	lea	dma_data_buf,A1
	clr.b	0(A0)
	move.b	6(A1),3(A0)
	move.l	12(A1),D0
	and.l	#$FFFFFF,D0
	jsr	T_6BE
	move.l	D0,4(A0)
	move.l	8(A1),D0
	and.l	#$FFFFFF,D0
	jsr	T_6BE
	move.l	D0,8(A0)
	movea.l	B_B18,A0
	bsr	T_80A
	ext.l	D0
	bmi.s	T_6AE
	movea.l	8(SP),A0
	move.b	2(A1),1(A0)
	move.b	3(A1),2(A0)
	clr.w	D0
	move.b	3(A1),D0
	add.w	#1,D0
	jsr	T_706
	move.w	D0,B_D32
	lea	dma_data_buf,A2
	adda.l	#6,A2
T_684:
	tst.b	(A2)
	beq.s	T_6AE
	cmpi.b	#$AA,(A2)
	beq.s	T_696
	adda.l	#8,A2
	bra.s	T_684
;
T_696:
	adda.l	#2,A2
	move.l	(A2),D0
	and.l	#$FFFFFF,D0
	jsr	T_6BE
	move.l	D0,12(A0)
T_6AE:
	move.l	(SP)+,D0
T_6B0:
	rts
;
;----------------------------------------------------------------------------
;
T_6B2:
	move.l	#-$7F80,D0
	rts
;
;----------------------------------------------------------------------------
;
nu_Metawrite_E_UNCMD:
nu_Metaioctl_E_UNCMD:
nu_Metafunc_8_E_UNCMD:
nu_Metafunc_9_E_UNCMD:
nu_Metafunc_A_E_UNCMD:
;
	moveq	#E_UNCMD,D0
	rts
;
;----------------------------------------------------------------------------
;
T_6BE:
	move.l	D0,-(SP)
	clr.l	D0
	move.b	1(SP),D0
	divu	#10,D0
	move.b	D0,D1
	asl.b	#4,D1
	swap	D0
	or.b	D0,D1
	move.b	D1,1(SP)
	clr.l	D0
	move.b	2(SP),D0
	divu	#10,D0
	move.b	D0,D1
	asl.b	#4,D1
	swap	D0
	or.b	D0,D1
	move.b	D1,2(SP)
	clr.l	D0
	move.b	3(SP),D0
	divu	#10,D0
	move.b	D0,D1
	asl.b	#4,D1
	swap	D0
	or.b	D0,D1
	move.b	D1,3(SP)
	move.l	(SP)+,D0
	rts
;
;----------------------------------------------------------------------------
;
T_706:
	movem.l	D1-D3,-(SP)
	move.l	D0,D2
	swap	D2
	swap	D0
	and.b	#$F0,D0
	lsr.b	#1,D0
	move.w	D0,D1
	lsr.b	#2,D0
	add.b	D1,D0
	and.b	#15,D2
	add.b	D2,D0
	swap	D0
	swap	D2
	and.b	#$F0,D0
	lsr.b	#1,D0
	move.w	D0,D1
	lsr.b	#2,D0
	add.b	D1,D0
	and.b	#15,D2
	add.b	D2,D0
	lsr.w	#8,D2
	move.b	D2,D3
	and.b	#15,D3
	and.b	#$F0,D2
	lsr.b	#1,D2
	move.b	D2,D1
	lsr.b	#2,D2
	add.b	D2,D1
	add.b	D3,D1
	lsl.w	#8,D1
	and.l	#$FF00FF,D0
	or.w	D1,D0
	movem.l	(SP)+,D1-D3
	rts
;
;----------------------------------------------------------------------------
;
T_75E:
	move.w	#3,D0
	bsr	T_90C
	move.b	#$20,4(A1)
	lea	dma_data_buf,A2
	move.w	#1,D1
	move.w	#5,D2
	jsr	T_32
	cmp.b	#$FF,D0
	beq.s	T_7A0
	lea	dma_data_buf,A2
	adda.l	#12,A2
	move.b	(A2),D0
	bne.s	T_79A
	moveq	#$ffFFffF2,D0
	rts
;
;----------------------------------------------------------------------------
;
T_79A:
	cmp.b	#4,D0
	bne.s	T_7A4
T_7A0:
	moveq	#$ffFFffFE,D0
	rts
;
;----------------------------------------------------------------------------
;
T_7A4:
	cmp.b	#$3A,D0
	bne.s	T_7AE
	moveq	#$ffFFffEE,D0
	rts
;
;----------------------------------------------------------------------------
;
T_7AE:
	cmp.b	#9,D0
	beq.s	T_7BA
	cmp.b	#$47,D0
	bne.s	T_7BE
T_7BA:
	moveq	#$ffFFffF4,D0
	rts
;
;----------------------------------------------------------------------------
;
T_7BE:
	cmp.b	#$26,D0
	beq.s	T_7CA
	cmp.b	#$2A,D0
	bne.s	T_7CE
T_7CA:
	moveq	#$ffFFffFB,D0
	rts
;
;----------------------------------------------------------------------------
;
T_7CE:
	cmp.b	#$28,D0
	bne.s	T_7D8
	moveq	#$ffFFffF2,D0
	rts
;
;----------------------------------------------------------------------------
;
T_7D8:
	cmp.b	#$20,D0
	beq.s	T_7E4
	cmp.b	#$64,D0
	bne.s	T_7E8
T_7E4:
	moveq	#$ffFFffF9,D0
	rts
;
;----------------------------------------------------------------------------
;
T_7E8:
	moveq	#$ffFFffFF,D0
	rts
;
;----------------------------------------------------------------------------
;
T_7EC:
	move.w	#0,D0
	bsr	T_90C
	lea	dma_data_buf,A2
	move.w	#0,D1
	move.w	#5,D2
	jsr	T_32
	rts
;
;----------------------------------------------------------------------------
;
T_80A:
	move.w	#$43,D0
	bsr	T_90C
	move.b	#2,1(A1)
	move.b	#2,7(A1)
	lea	dma_data_buf,A2
	move.w	#1,D1
	move.w	#9,D2
	jsr	T_32
	rts
;
;----------------------------------------------------------------------------
;
T_83A:
	move.w	#8,D0
	bsr	T_90C
	move.b	13(SP),1(A1)
	move.b	14(SP),2(A1)
	move.b	15(SP),3(A1)
	move.b	$11(SP),4(A1)
	asl.w	#2,D1
	movea.l	8(SP),A2
	clr.l	B_D34
	move.l	A2,D3
	and.l	#-$1000000,D3
	beq.s	T_89E
	move.l	A2,B_D34
	movea.l	fastram_buf_p,A2
	cmp.w	#$80,D1
	blt.s	T_89E
	sub.w	#$80,D1
	asr.w	#2,D1
	move.w	D1,$10(SP)
	addi.l	#$20,12(SP)
	move.b	#$20,8(A1)
	move.w	#$80,D1
T_89E:
	movem.l	D1/A0,-(SP)
	move.w	#5,D2
	jsr	T_32
	movem.l	(SP)+,D1/A0
	tst.l	D0
	bne.s	T_90A
	tst.l	B_D34
	beq.s	T_90A
	move.l	D0,-(SP)
	movea.l	fastram_buf_p,A1
	movea.l	B_D34,A2
	move.w	D1,D0
	asl.w	#3,D0
	subq.w	#1,D0
T_8D0:
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	move.l	(A1)+,(A2)+
	dbra	D0,T_8D0
	move.l	(SP)+,D0
	move.l	A2,8(SP)
	cmp.w	#$80,D1
	blt.s	T_90A
	tst.w	$10(SP)
	beq.s	T_90A
	bra	T_83A
;
T_90A:
	rts
;
;----------------------------------------------------------------------------
;
T_90C:
	move.l	D1,-(SP)
	lea	SCSI_cmd_buf,A1
	clr.l	(A1)
	clr.l	4(A1)
	clr.l	8(A1)
	move.w	bos_drive_ID(a0),D1
	asl.w	#5,D1
	or.w	D0,D1
	move.b	D1,(A1)
	move.l	(SP)+,D1
	rts
;
;----------------------------------------------------------------------------
;
	SECTION	DATA
;
;----------------------------------------------------------------------------
;
init_BOS_func_p:
	dc.l	init_BOS_func
Metafunc_t:
	dc.b	''
	dc.l	nu_Metaopen
	dc.l	nu_Metaclose
	dc.l	nu_Metaread
	dc.l	nu_Metawrite_E_UNCMD
	dc.l	nu_Metafunc_5
	dc.l	nu_Metastatus
	dc.l	nu_Metaioctl_E_UNCMD
	dc.l	nu_Metafunc_8_E_UNCMD
	dc.l	nu_Metafunc_9_E_UNCMD
	dc.l	nu_Metafunc_A_E_UNCMD
	dc.l	nu_Metastartaudio
	dc.l	nu_Metastopaudio
	dc.l	nu_Metasetsongtime
	dc.l	nu_Metagettoc
	dc.l	nu_Metagetdiscinfo
;
;-------------------------------------
;0 VOID Metainit ( META_INFO_1 *buffer );
;1 LONG Metaopen ( SHORT drive, META_DRVINFO *buffer );
;2 LONG Metaclose ( SHORT drive );
;3 LONG Metaread ( SHORT drive, VOID *buffer, LONG blockno, SHORT count );
;4 LONG Metawrite ( SHORT drive, VOID *buffer, LONG blockno, SHORT count );
;5
;6 LONG Metastatus ( SHORT drive, VOID *buffer );
;7 LONG Metaioctl ( SHORT drive, LONG magic, SHORT opcode, VOID *buffer );
;8
;9
;A
;B LONG Metastartaudio ( SHORT drive, SHORT flag, UBYTE *bytes_p);
;C LONG Metastopaudio ( SHORT drive );
;D LONG Metasetsongtime (SHORT drive,SHORT repeat,LONG starttime,LONG endtime );
;E LONG Metagettoc ( SHORT drive, SHORT flag, CD_TOC_ENTRY *buffer );
;F LONG Metadiscinfo ( SHORT drive, CD_DISC_INFO *p );
;-------------------------------------
;----------------------------------------------------------------------------
;
	SECTION	BSS
;
;----------------------------------------------------------------------------
;
BOS_table_p:
	ds.l	1
BOS_table_beg:
	ds.b	MAX_BOS_ENTRIES*60
BOS_table_end:
B_B18:
	ds.l	1
B_B1C:
	ds.l	1
SCSI_cmd_buf:
	ds.b	12
dma_data_buf:
	ds.l	128			;=512
new_cpu_f:
	ds.w	1
fastram_buf_p:
	ds.l	1
B_D32:
	ds.w	1
B_D34:
	ds.l	1
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	ICDCD_RA.S
;----------------------------------------------------------------------------
