	.title	'DC-PORT Terminal Emulator'

*********************************************************
*							*
* Terminal Emulator for DC-PORT				*
* By Gilbert Callaghan					*
* Copyright (c) 1988 Double Click Software		*
*							*
* V0.1 07/31/88 initial version				*
* V0.2 08/06/88 converted for trap handler		*
*							*
*********************************************************

	.include "misc\\atari.d"
	.include "misc\\apstart.s"

DCPORT0	equ	$8000
DCPORT1	equ	$8100
DCPORT2	equ	$8200
DCPORT3	equ	$8300
DCPORT4	equ	$8400

main:	move.b	#1,ports
	Rsconf	#DCPORT1+0,#0,#%10001000,#-1,#-1,#-1
	Rsconf	#DCPORT2+7,#0,#%10001000,#-1,#-1,#-1
	swap	d0
	tst	d0
	bmi	No_Dcp
	Rsconf	#DCPORT3+7,#0,#%10001000,#-1,#-1,#-1
	Rsconf	#DCPORT4+7,#0,#%10001000,#-1,#-1,#-1
	swap	d0
	tst	d0
	bmi.s	start
	move.b	#3,ports

start:	Puts	#msg

	move.w	#0,cport

Con:	Bconstat #CON
	tst.b	d0
	beq	Port1
	Bconin	#CON
	cmp.b	#'`',d0			; exit?
	beq	Term
	cmp.b	#01,d0			; control A?
	bne.s	Con3
	add.b	#1,cport		; yes, inc cport
	move.b	ports,d0
	and.b	d0,cport
	bra	Con

Con3:	tst.b	cport
	bne.s	Con4
	Bconout	#DCPORT1+AUX,d0
	bra.s	Port1
Con4:	cmp.b	#1,cport
	bne.s	Con5
	Bconout	#DCPORT2+AUX,d0
	bra.s	Port1
Con5:	cmp.b	#2,cport
	bne.s	Con6
	Bconout	#DCPORT3+AUX,d0
	bra.s	Port1
Con6:	Bconout	#DCPORT4+AUX,d0
	bra	Port1


Port1:	Bconstat #DCPORT1+AUX
	tst.b	d0
	beq.b	Port2
	Bconin	#DCPORT1+AUX
	and.b	#$7f,d0
	moveq	#0,d1
	Bconout	#CON,d0

Port2:	Bconstat #DCPORT2+AUX
	tst.b	d0
	beq.b	Port3
	Bconin	#DCPORT2+AUX
	and.b	#$7f,d0
	moveq	#0,d1
	Bconout	#CON,d0

Port3:	Bconstat #DCPORT3+AUX
	tst.b	d0
	beq.b	Port4
	Bconin	#DCPORT3+AUX
	and.b	#$7f,d0
	moveq	#0,d1
	Bconout	#CON,d0

Port4:	Bconstat #DCPORT4+AUX
	tst.b	d0
	beq	Con
	Bconin	#DCPORT4+AUX
	and.b	#$7f,d0
	moveq	#1,d1
	Bconout	#CON,d0
	bra	Con

No_Dcp:	Puts	#errmsg
	Bconin	#CON

Term:	Pterm0

msg:	.dc.b	27,"E",10,"Type ` to exit.",13,10
	.dc.b	"Type ^A to switch ports.",13,10,0
errmsg:	.dc.b	27,"E",10,"DC-PORT not available.",13,10,0

	.bss
cport:	.ds.w	1			; current output port
ports:	.ds.w	1			; number of dc ports-1
