/* 32,768 Color Board Tester for Palette Register at location $FF8240 */
/* by Barry Orlando in Mark Williams C */
/* This program displays the 32 grey levels and then the 32,768 colors
   in sequence using background palette 0    */
#include <stdio.h>
#include <osbind.h>
#include <aesbind.h>
#define peekw(wp) (*((int *)wp))
#define pokew(wp,w) (*((int *)wp) = w)

/********************main**************************/
main()
{
	int g, b;
	unsigned int c, r;
	long i;
	for (r = 0; r > 23; r++) printf("\n"); /* clears screen  */
	for (r = 0; r < 32; r++) /* red, green, and blue values = r  */
		{
			/*  c format is .RRRRRGGGGGBBBBB   */
		c = r << 10;            /* red          */
		c += r << 5;		/* green	*/
		c += r;			/* blue		*/
		c = cvrt_m (c);	/* convert to machine code	*/
		printf("           grey level: %d                 \n", r);
		clr_write(c);   /*  set grey level    */
		for (i = 0; i < 65000L; i++); /* added delay  */
		}
	for (r = 0; r < 32; r++)
	   { for (g = 0; g < 32; g++)
	      { for (b = 0; b < 32; b++)
		   {
		   c = r << 10;
		   c += g << 5;
		   c += b;
		   c = cvrt_m (c);
		   clr_write(c);	/* set palette color */
		   printf("\nred: %d  green: %d  blue:%d ",r,g,b);   
		   for (i = 0; i < 30000; i++);  /* Added delay */
	           }
	       }
	    }
	gemdos(0x01);
}

/******************** clr_read ************************/
clr_read()          /* reads color palette register  */
{
	long save_ssp;
	int o;
	save_ssp = Super(0L);
	o = peekw(0xFF8240L);
	Super(save_ssp);
	return (o);
}

/******************** clr_write() ********************/
clr_write(o)           /*   writes to color palette register  */

unsigned int o;
{
	long save_ssp;
	save_ssp = Super(0L);
	pokew(0xFF8240L, o);
	Super(save_ssp);
}

/*********************** cvrt_m() *****************************************/
cvrt_m(a)        /* converts readable code to board compatible code 	*/
unsigned int a;  /* bit pattern in:  .RRRRRGGGGGBBBBB          		*/
                 /* bit order in:    .M321LM321LM321L               	*/
	         /* bit pattern out: .RGBRRRRGGGGBBBB               	*/
		 /* bit order out:   .LLL1M321M321M32               	*/
		 /* bit:             FEDCBA9876543210               	*/
{
unsigned int f;
f =  (0x400 & a) << 4;    /* red bit L	    			*/
f += (0x20 & a) << 8;     /* green bit L			*/
f += (0x1 & a) << 12;     /* blue bit L				*/
f +=  0x800 & a;          /* red bit 1  			*/
f += (0x40 & a) << 1;     /* green bit 1 			*/
f += (0x2 & a) << 2;      /* blue bit 1  			*/
f += (0x7000 & a) >> 4;   /* red bits M,3,2  			*/
f += (0x380 & a) >> 3;    /* green bits M,3,2			*/
f += (0x1C & a) >> 2;     /* blue bits M,3,2			*/
return (f);
}

/********************************** cvrt_b() **********************/
cvrt_b(b)        /* converts back to readable code              */
unsigned int b;
{
int d;
d =  (0x4000 & b) >> 4;    /* red LSB    			*/
d += (0x2000 & b) >> 8;    /* green LSB  			*/
d += (0x1000 & b) >> 12;   /* blue LSB   			*/
d += (0x800 & b);          /* red bit 1 			*/
d += (0x80 & b) >> 1;      /* green bit 1 			*/
d += (0x8 & b) >> 2;       /* blue bit 1  			*/
d += (0x700 & b) << 4;     /* red bits M,3,2			*/
d += (0x70 & b) << 3;	   /* green bits M,3,2			*/
d += (0x7 & b) << 2;       /* blue bits M,3,2			*/
return (d);
}
