!--------------------------------------------------------------------!
!   Include file    CSR8.FOR                                         !
!--------------------------------------------------------------------!
!                                                                    !
!  Declarations for Fortran-Procedures to get & put the status- and  !
!  and control-register (FPSR/FPCR) of the MC68881.                  !
!                                                                    !
!  Creation :   18 Mar 1988    by   F. Pl.                           !
!  Modified :   18 Apr 1988    by   ATC                              !
!                                                                    !
!  Copyright (C) 1988 Prospero Software                              !
!                                                                    !
!                                                                    !
!--------------------------------------------------------------------!

*     FPCR Mode Control Byte values: MC68881 manual Fig. 2-3
        
*     Rounding modes
      INTEGER    FPCR_to_nearest,
     1           FPCR_toward_zero,
     2           FPCR_toward_minus_infinity,
     3           FPCR_toward_plus_infinity

      PARAMETER (FPCR_to_nearest            = $00,
     1           FPCR_toward_zero           = $10,
     2           FPCR_toward_minus_infinity = $20,
     3           FPCR_toward_plus_infinity  = $30)
        
*     Rounding precision
      INTEGER    FPCR_extended,
     1           FPCR_single,
     2           FPCR_double
        
      PARAMETER (FPCR_extended = $00,
     1           FPCR_single   = $40,
     2           FPCR_double   = $80)
        
*     FPSR Accrued Exception Byte values: MC68881 manual Fig. 2-7
        
      INTEGER    FPSR_inexact,
     1           FPSR_divide_by_zero,
     2           FPSR_underflow,
     3           FPSR_overflow,
     4           FPSR_invalid_operation
 
      PARAMETER (FPSR_inexact           = $08,
     1           FPSR_divide_by_zero    = $10,
     2           FPSR_underflow         = $20,
     3           FPSR_overflow          = $40,
     4           FPSR_invalid_operation = $80)
        
*     Interfaces to get/set control/status routines.

!      SUBROUTINE getsr8 (status)         ! Get FPSR status
!      INTEGER*4 status

!      SUBROUTINE getcr8 (condcd)         ! Get FPCR status
!      INTEGER*4 condcd

!      SUBROUTINE setsr8 (status)         ! Set FPSR status
!      INTEGER*4 status

!      SUBROUTINE setcr8 (condcd)         ! Set FPCR status
!      INTEGER*4 condcd


