*     This demonstrates the use of the line A routines to draw simple
*     lines, without the complexity of the GEM VDI
*
*     Date: 29 Oct 1987
*     Copyright (c) 1987 Prospero Software
*

      PROGRAM lineAdemo
      INTEGER*2 fillpattern(0:7)

      CALL line(100,100,100,200)
      CALL line(100,200,200,200)
      CALL line(200,200,200,100)
      CALL line(200,100,100,100)

      fillpattern(0) = $0101
      DO 10 i = 1,7
        fillpattern(i) = fillpattern(i-1) * 2 
10    CONTINUE

      CALL rect(101, 101, 199, 199, fillpattern, 7)

      CALL point(50, 50, 1)
      END

*-------------------------------------------------------------------
*
*     SUBROUTINE line uses the A003 trap to draw a line
*
*-------------------------------------------------------------------
      
      SUBROUTINE line(x1, y1, x2, y2)
      INTEGER x1, x2, y1, y2

      INTEGER*4 regs(0:14), ptr
      EQUIVALENCE (ptr, regs(8))
      
      CALL a000(regs)                     ! Initialise Line A

*     Set up values in Line A variable area
      
      CALL poke2(ptr+38, x1)
      CALL poke2(ptr+40, y1)
      CALL poke2(ptr+42, x2)
      CALL poke2(ptr+44, y2)

      CALL a003(regs)                     ! Draw a line
      END

*-------------------------------------------------------------------
*
*     SUBROUTINE rect uses the A005 trap to draw a rectangle, using
*     the fill pattern given by the array maskarray, which contains
*     repeat number of INTEGER*2 values
*
*-------------------------------------------------------------------

      SUBROUTINE rect(x1, y1, x2, y2, maskarray, repeat)
      INTEGER x1, x2, y1, y2, repeat
      INTEGER*2 maskarray(0:repeat)

      INTEGER*4 regs(0:14), ptr
      EQUIVALENCE (ptr, regs(8))
      
      CALL a000(regs)                     ! Initialise Line A

*     Set up values in Line A variable area
      
      CALL poke2(ptr+38, x1)               ! _X1 field
      CALL poke2(ptr+40, y1)               ! _Y1
      CALL poke2(ptr+42, x2)               ! _X2
      CALL poke2(ptr+44, y2)               ! _Y2
      CALL poke4(ptr+46, iaddr(maskarray)) ! _patptr
      CALL poke2(ptr+50, repeat)           ! _patmsk

      CALL a005(regs)                     ! Draw a rectangle
      END

*-------------------------------------------------------------------
*
*     SUBROUTINE point uses the A001 trap to plot a pixel to a given
*     colour
*
*-------------------------------------------------------------------

      SUBROUTINE point(x, y, colour)
      INTEGER x, y, intin, ptsin, colour

      INTEGER*4 regs(0:14), ptr
      EQUIVALENCE (ptr, regs(8))
      
      CALL a000(regs)                     ! Initialise Line A

      intin = ipeek4(ptr+8)
      ptsin = ipeek4(ptr+12)
      CALL poke2(ptsin, x)
      CALL poke2(ptsin+2, y)
      CALL poke2(intin, colour)

      CALL A001
      END
      
