/*
 * unicode.h vom 08.05.1998
 *
 * Autor:
 * Thomas Binder
 * (gryf@hrzpub.tu-darmstadt.de)
 *
 * Zweck:
 * Enthlt die Tabellen zur Wandlung von Unicode nach ATARI-ASCII,
 * entstanden mit Hilfe des Tools tcs.
 *
 * History:
 * 29.01.1998: - Erstellung
 * 08.05.1998: - Fipptehler in cp20 behoben (-10 statt -1), Dank an
 *               Frank Naumann
 */

WORD cp00[256] = {
  /* 00 - 07 */
     0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 08 - 0f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 10 - 17 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 18 - 1f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 20 - 27 */
  0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
  /* 28 - 2f */
  0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
  /* 30 - 37 */
  0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
  /* 38 - 3f */
  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
  /* 40 - 47 */
  0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
  /* 48 - 4f */
  0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
  /* 50 - 57 */
  0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
  /* 58 - 5f */
  0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
  /* 60 - 67 */
  0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
  /* 68 - 6f */
  0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
  /* 70 - 77 */
  0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
  /* 78 - 7f */
  0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
  /* 80 - 87 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 88 - 8f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 90 - 97 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 98 - 9f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a0 - a7 */
    -1, 0xad, 0x9b, 0x9c,   -1, 0x9d,   -1, 0xdd,
  /* a8 - af */
  0xb9, 0xbd, 0xa6, 0xae, 0xaa,   -1, 0xbe, 0xff,
  /* b0 - b7 */
  0xf8, 0xf1, 0xfd, 0xfe, 0xba, 0xe6, 0xbc, 0xfa,
  /* b8 - bf */
    -1,   -1, 0xa7, 0xaf, 0xac, 0xab,   -1, 0xa8,
  /* c0 - c7 */
  0xb6,   -1,   -1, 0xb7, 0x8e, 0x8f, 0x92, 0x80,
  /* c8 - cf */
    -1, 0x90,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d0 - d7 */
    -1, 0xa5,   -1,   -1,   -1, 0xb8, 0x99,   -1,
  /* d8 - df */
  0xb2,   -1,   -1,   -1, 0x9a,   -1,   -1, 0x9e,
  /* e0 - e7 */
  0x85, 0xa0, 0x83, 0xb0, 0x84, 0x86, 0x91, 0x87,
  /* e8 - ef */
  0x8a, 0x82, 0x88, 0x89, 0x8d, 0xa1, 0x8c, 0x8b,
  /* f0 - f7 */
    -1, 0xa4, 0x95, 0xa2, 0x93, 0xb1, 0x94, 0xf6,
  /* f8 - ff */
  0xb3, 0x97, 0xa3, 0x96, 0x81,   -1,   -1, 0x98};

WORD cp01[256] = {
  /* 00 - 07 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 08 - 0f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 10 - 17 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 18 - 1f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 20 - 27 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 28 - 2f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 30 - 37 */
    -1,   -1, 0xc1, 0xc0,   -1,   -1,   -1,   -1,
  /* 38 - 3f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 40 - 47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 48 - 4f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 50 - 57 */
    -1,   -1, 0xb5, 0xb4,   -1,   -1,   -1,   -1,
  /* 58 - 5f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 60 - 67 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 68 - 6f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 70 - 77 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 78 - 7f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 80 - 87 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 88 - 8f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 90 - 97 */
    -1,   -1, 0x9f,   -1,   -1,   -1,   -1,   -1,
  /* 98 - 9f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a0 - a7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a8 - af */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b0 - b7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b8 - bf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c0 - c7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c8 - cf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d0 - d7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d8 - df */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e0 - e7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e8 - ef */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f0 - f7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f8 - ff */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1};

WORD cp03[256] = {
  /* 00 - 07 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 08 - 0f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 10 - 17 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 18 - 1f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 20 - 27 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 28 - 2f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 30 - 37 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 38 - 3f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 40 - 47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 48 - 4f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 50 - 57 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 58 - 5f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 60 - 67 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 68 - 6f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 70 - 77 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 78 - 7f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 80 - 87 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 88 - 8f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 90 - 97 */
    -1,   -1,   -1, 0xe2,   -1,   -1,   -1,   -1,
  /* 98 - 9f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a0 - a7 */
    -1,   -1,   -1, 0xe4,   -1,   -1, 0xe8,   -1,
  /* a8 - af */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b0 - b7 */
    -1, 0xe0, 0xe1,   -1, 0xeb,   -1,   -1,   -1,
  /* b8 - bf */
  0xe9,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c0 - c7 */
  0xe3,   -1,   -1, 0xe5, 0xe7,   -1, 0xed,   -1,
  /* c8 - cf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d0 - d7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d8 - df */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e0 - e7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e8 - ef */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f0 - f7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f8 - ff */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1};

WORD cp05[256] = {
  /* 00 - 07 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 08 - 0f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 10 - 17 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 18 - 1f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 20 - 27 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 28 - 2f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 30 - 37 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 38 - 3f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 40 - 47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 48 - 4f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 50 - 57 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 58 - 5f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 60 - 67 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 68 - 6f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 70 - 77 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 78 - 7f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 80 - 87 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 88 - 8f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 90 - 97 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 98 - 9f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a0 - a7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a8 - af */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b0 - b7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b8 - bf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c0 - c7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c8 - cf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d0 - d7 */
  0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9,
  /* d8 - df */
  0xca, 0xcb, 0xd9, 0xcc, 0xcd, 0xda, 0xce, 0xd8,
  /* e0 - e7 */
  0xcf, 0xd0, 0xd1, 0xdb, 0xd2, 0xdc, 0xd3, 0xd4,
  /* e8 - ef */
  0xd5, 0xd6, 0xd7,   -1,   -1,   -1,   -1,   -1,
  /* f0 - f7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f8 - ff */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1};

WORD cp20[256] = {
  /* 00 - 07 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 08 - 0f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 10 - 17 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 18 - 1f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 20 - 27 */
  0xbb,   -1, 0xf9,   -1,   -1,   -1,   -1,   -1,
  /* 28 - 2f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 30 - 37 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 38 - 3f */
  0xde,   -1,   -10,   -1,   -1,   -1,   -1,   -1,
  /* 40 - 47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 48 - 4f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 50 - 57 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 58 - 5f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 60 - 67 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 68 - 6f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 70 - 77 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 78 - 7f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1, 0xfc,
  /* 80 - 87 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 88 - 8f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 90 - 97 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 98 - 9f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a0 - a7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a8 - af */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b0 - b7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b8 - bf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c0 - c7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c8 - cf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d0 - d7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d8 - df */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e0 - e7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e8 - ef */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f0 - f7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f8 - ff */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1};

WORD cp21[256] = {
  /* 00 - 07 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 08 - 0f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 10 - 17 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 18 - 1f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 20 - 27 */
    -1,   -1, 0xbf,   -1,   -1,   -1, 0xea,   -1,
  /* 28 - 2f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 30 - 37 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 38 - 3f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 40 - 47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 48 - 4f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 50 - 57 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 58 - 5f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 60 - 67 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 68 - 6f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 70 - 77 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 78 - 7f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 80 - 87 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 88 - 8f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 90 - 97 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 98 - 9f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a0 - a7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a8 - af */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b0 - b7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b8 - bf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c0 - c7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c8 - cf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d0 - d7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d8 - df */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e0 - e7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e8 - ef */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f0 - f7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f8 - ff */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1};

WORD cp22[256] = {
  /* 00 - 07 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 08 - 0f */
  0xee,   -1,   -1,   -1,   -1,   -1,   -1, 0xef,
  /* 10 - 17 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 18 - 1f */
    -1,   -1, 0xfb,   -1,   -1,   -1, 0xdf,   -1,
  /* 20 - 27 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 28 - 2f */
    -1,   -1,   -1,   -1,   -1,   -1, 0xec,   -1,
  /* 30 - 37 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 38 - 3f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 40 - 47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 48 - 4f */
  0xf7,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 50 - 57 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 58 - 5f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 60 - 67 */
    -1, 0xf0,   -1,   -1, 0xf3, 0xf2,   -1,   -1,
  /* 68 - 6f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 70 - 77 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 78 - 7f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 80 - 87 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 88 - 8f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 90 - 97 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 98 - 9f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a0 - a7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a8 - af */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b0 - b7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b8 - bf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c0 - c7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c8 - cf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d0 - d7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d8 - df */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e0 - e7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e8 - ef */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f0 - f7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f8 - ff */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1};

WORD cp23[256] = {
  /* 00 - 07 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 08 - 0f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 10 - 17 */
  0xa9,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 18 - 1f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 20 - 27 */
  0xf4, 0xf5,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 28 - 2f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 30 - 37 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 38 - 3f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 40 - 47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 48 - 4f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 50 - 57 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 58 - 5f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 60 - 67 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 68 - 6f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 70 - 77 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 78 - 7f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 80 - 87 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 88 - 8f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 90 - 97 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* 98 - 9f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a0 - a7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* a8 - af */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b0 - b7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* b8 - bf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c0 - c7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* c8 - cf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d0 - d7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* d8 - df */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e0 - e7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* e8 - ef */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f0 - f7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  /* f8 - ff */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1};

WORD *codepages[256] = {
  /* 00 - 07 */
  cp00, cp01, NULL, cp03, NULL, cp05, NULL, NULL,
  /* 08 - 0f */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  /* 10 - 17 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  /* 18 - 1f */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  /* 20 - 23 */
  cp20, cp21, cp22, cp23};

/* EOF */