; hidevfat.s vom 16.07.1998
;
; Autor:
; Thomas Binder
; (gryf@hrzpub.tu-darmstadt.de)
;
; Zweck:
; Klinkt sich in den GEMDOS-Trap ein (XBRA HVFT) und fngt die
; Aufrufe Fsfirst() und Fsnext() ab, um dafr zu sorgen, da unter
; SingleTOS die zustzlichen VFAT-Verzeichniseintrge nicht mehr
; gefunden werden, da dies u.a. beim Kopieren und/oder bei der
; Anzeige von Verzeichnissen (nicht nur) mit dem Desktop bestimmter
; TOS-Versionen zu Problemen fhren kann.
;
; History:
; 15.07.-
; 16.07.1998: - Erstellung

    super

    equ     _longframe, $59e

	equ		Setexc,		5

	equ		Supexec,	38

	equ		Cconws,		9
	equ		Fgetdta,	47
    equ		Ptermres,	49
    equ		Pterm,		76
    equ     Fsfirst,    78
    equ     Fsnext,     79

    text

; Ist die Routine bereits installiert?
    pea     is_installed(pc)
    move.w	#Supexec,-(sp)
    trap    #14
    addq.l  #6,sp
    tst.w   d0
    bne.s   already_installed
; Neue GEMDOS-Routine einklinken
    pea     new_gemdos(pc)
    move.w  #33,-(sp)
    move.w  #Setexc,-(sp)
    trap    #13
    addq.l  #8,sp
    move.l  d0,old_gemdos
; Erfolgsmeldung ausgeben
    pea     patch_text(pc)
    move.w	#Cconws,-(sp)
    trap    #1
    addq.l  #6,sp
; Gre des resident zu haltenden Speicherbereichs berechnen und
; Programm mit Ptermres beenden
    move.l  #$100,d0
    move.l  4(sp),a0
    add.l   $c(a0),d0
    add.l   $14(a0),d0
    add.l   $1c(a0),d0
    clr.w   -(sp)
    move.l  d0,-(sp)
    move.w	#Ptermres,-(sp)
    trap    #1
; Meldung ausgeben, da die Routine bereits installiert ist
already_installed:
    pea     already_installed_text(pc)
    move.w	#Cconws,-(sp)
    trap    #1
; Programm verlassen (1 fr allgemeinen Fehler zurckgeben)
    move.w  #1,-(sp)
    move.w	#Pterm,-(sp)
    trap    #1

; Die neue GEMDOS-Routine
    dc.b    "XBRAHVFT"
old_gemdos:
    dc.l    0
new_gemdos:
    move.l  usp,a0
    btst    #5,(sp)
    beq.s   goon
; Prfen, ob ein Prozessor mit langen Stackframes aktiv ist und
; Zeiger ggf. entsprechend korrigieren, wenn der trap aus dem
; Supervisor-Modus heraus erfolgte
    lea     6(sp),a0
    tst.w   _longframe.w
    beq.s   goon
    addq.l  #2,a0
goon:
; Register retten
    movem.l a0-a2/d1-d2,-(sp)
; Auf die zu patchenden Routinen prfen und ggf. den Ersatzcode
; anspringen
	cmpi.w	#Fsfirst,(a0)
	beq.s	my_fsfirst
	cmpi.w	#Fsnext,(a0)
	beq		my_fsnext
back:
    movem.l (sp)+,a0-a2/d1-d2
    move.l  old_gemdos(pc),-(sp)
    rts
no_action:
    movem.l (sp)+,a0-a2/d1-d2
    rte

my_fsfirst:
; Erstmal die Parameter fr Fsfirst() auf dem Stack sichern
	move.l	2(a0),-(sp)		; Filename
	move.w	6(a0),-(sp)		; Attribut
; DTA ermitteln und auf dem Stack sichern
	move.w	#Fgetdta,-(sp)
	tst.w	_longframe.w
	beq.s	mfsf_goon1
	move.w	#33*4,-(sp)		; Adresse Vektor 33 bei langem Stackframe
mfsf_goon1:
	pea		mfsf_back1(pc)
	move.w	sr,-(sp)
	move.l	old_gemdos(pc),-(sp)
	rts
mfsf_back1:
	addq.l	#2,sp
	move.l	d0,-(sp)		; DTA in d0
; Jetzt eigentliches Fsfirst() aufrufen
	move.w	4(sp),-(sp)		; Attribut
	move.l	8(sp),-(sp)		; Filename
	move.w	#Fsfirst,-(sp)
	tst.w	_longframe.w
	beq.s	mfsf_goon2
	move.w	#33*4,-(sp)		; Adresse Vektor 33 bei langem Stackframe
mfsf_goon2:
	pea		mfsf_back2(pc)
	move.w	sr,-(sp)
	move.l	old_gemdos(pc),-(sp)
	rts
mfsf_back2:
	addq.l	#8,sp
	bra.s	mfsf_check
mfsf_back3:
	addq.l	#2,sp
mfsf_check:
; Wenn Fehler aufgetreten ist, gleich zurck
	tst.l	d0
	bpl.s	mfsf_ok
	lea		10(sp),sp
	bra.s	no_action
mfsf_ok:
; In DTA prfen, ob Attribut 0xf ist
	move.l	(sp),a0
	cmpi.b	#$f,21(a0)
	beq.s	mfsf_next
; Wenn nicht, dann zurck
	lea		10(sp),sp
	bra.s	no_action
mfsf_next:
; Ansonsten solange Fsnext() aufrufen, bis entweder ein Fehler
; aufgetreten oder das Attribut nicht mehr 0xf ist
	move.w	#Fsnext,-(sp)
	tst.w	_longframe.w
	beq.s	mfsf_goon3
	move.w	#33*4,-(sp)		; Adresse Vektor 33 bei langem Stackframe
mfsf_goon3:
	pea		mfsf_back3
	move.w	sr,-(sp)
	move.l	old_gemdos(pc),-(sp)
	rts

my_fsnext:
; Bei Fsnext() wird der Code von Fsfirst() benutzt; vorher werden
; lediglich die DTA und zwei Dummy-Werte auf den Stack gelegt, um die
; gleiche Stack-Belegung zu haben
	clr.l	-(sp)
	clr.w	-(sp)
	move.w	#Fgetdta,-(sp)
	tst.w	_longframe.w
	beq.s	mfsn_goon
	move.w	#33*4,-(sp)		; Adresse Vektor 33 bei langem Stackframe
mfsn_goon:
	pea		mfsn_back(pc)
	move.w	sr,-(sp)
	move.l	old_gemdos(pc),-(sp)
	rts
mfsn_back:
	addq.l	#2,sp
	move.l	d0,-(sp)		; DTA in d0
	bra.s	mfsf_next

; Diese Routine prft, ob in der XBRA-Kette des GEMDOS-Vektors die
; Patch-Routine bereits eingeklinkt ist
is_installed:
    move.l  33*4.w,a0       ; GEMDOS-Vektor
loop:
    tst.l   a0
    beq.s   not_installed
    cmp.l   #'XBRA',-12(a0)
    bne.s   not_installed
    cmp.l   #'HVFT',-8(a0)
    beq.s   installed
    move.l  -4(a0),a0
    bra.s   loop
installed:
    moveq   #1,d0
    rts
not_installed:
    clr.w   d0
    rts

    data

patch_text:
    dc.b    13,10,"HideVFAT installed!",13,10,0

already_installed_text:
    dc.b    13,10,"HideVFAT is already installed!",13,10,0

; EOF