/*
 *	Librairie RIMM
 *	fichier en tete a inclure par le client
 */

#include <ldg.h>

#include "rimm_struct.h"

char *   (*RIMM_informe)( void );
int      (*RIMM_OpenRIMDataBase)(RIMDB * rimdb, char * path);
int      (*RIMM_CloseRIMDataBase)(RIMDB * rimdb);
int      (*RIMM_GetRIMInfos)(RIMDB * rimdb, long no_rim, RIMINFOS ** riminfos);
int      (*RIMM_DoRIMConfiguration)(RIMDB * rimdb, long no_rim);
int      (*RIMM_OpenImg)(RIMDB * rimdb, long no_rim, char *filename, RIMIMG * rimimg);
int      (*RIMM_CloseImg)(RIMIMG * rimimg);

LDG *ldg_rimm;

void rimminfo(void) {
	(void)form_alert(1,RIMM_informe());
}

void init_ldg_rimm( void) {
	RIMM_informe  = ldg_find("__infos", ldg_rimm);
	RIMM_OpenRIMDataBase  = ldg_find("__OpenRIMDataBase", ldg_rimm);
	RIMM_CloseRIMDataBase  = ldg_find("__CloseRIMDataBase", ldg_rimm);
	RIMM_GetRIMInfos  = ldg_find("__GetRIMInfos", ldg_rimm);
	RIMM_DoRIMConfiguration = ldg_find("__DoRIMConfiguration", ldg_rimm);
   RIMM_OpenImg = ldg_find("__OpenImg",ldg_rimm);
   RIMM_CloseImg = ldg_find("__CloseImg",ldg_rimm);
}
