/*
 *	Librairie RIMM
 *	fichier en tete a inclure par le client : RIMM_struct.h
 */

typedef struct rimdb_struct
{
	int    nb_rim;     /* nombre de RIMs chargs */
	char   path[128];  /* contiendra "C:\PARX.SYS\" par exemple */
	char * reserved1;  /* espace allou par Malloc, contient tous les RIMs */
} RIMDB ;

typedef struct rim_struct
{
	char  Header_RIM [8] ;    /* 'READ_IMG' si tout va bien   */
	char  Format_RIM [4] ;    /* '_VDI' ou '_SHI' ou '_VSH'   */
	short Type_RIM ;          /* 0 : RIM total                */
	                          /* 1 : RIM partiel              */
	                          /* 2 : RIM gnrant             */
	                          /* 3 : RIM gnrant             */
	char  Id_RIM     [8] ;    /* ID du RIM sur 8 caractres   */
	short Version_RIM    ;    /* version du RIM               */
	char  Description[31];    /* 30 caractres + octet nul    */
	char  Configurable   ;    /* 1 si le RIM est configurable */
} RIMINFOS ;

typedef struct rimimg_struct
{
	long no_rim ;              /* numro du RIM qui travaille             */
	long Fh;                   /* handle pour Fopen/Fclose/...            */
	short width;               /* largeur de l'image                      */
	short height;              /* hauteur de l'image                      */
	short nbplans;             /* nb de plans de l'image                  */
#ifdef _TRALALA_
	long size_img;             /* mmoire ncessaire pour charger l'image */
	long size_imgR8V8B8;       /* mmoire ncessaire pour charger l'image */
	                           /* au format 8R8V8B                        */
	char * buffer;             /* buffer o sera charge l'image          */
	short encore;              /* si une autre image est  suivre         */
#endif
} RIMIMG;


/* EOF */
