/**
**/

#include <stdio.h>
#include <support.h>  /* pour itoa() */
#include <xgemfast.h>
#include <string.h>
#include <xfd.h>

#include "rimm_proto.h"
#include "tst_rimm.h"

/********************************************************************
 *  variables locales                                               *
 ********************************************************************/

static long    local_no_rim;
static RIMDB * local_rimdb;

/********************************************************************
 *  fonctions locales                                               *
 ********************************************************************/

static int   _home              __PROTO((int handle, OBJECT *adr, int ob, XMULTI *xm));
static void   home_finit        __PROTO((FENETRE *f));

/********************************************************************
 *  fonctions                                                       *
 ********************************************************************/

/********************************************************************
 *
 *  int fr_home(void)
 *  
 *
 ********************************************************************/

int home_init(OBJECT *adr)
{
	char *strptr;
	RIMINFOS * riminfos;
	char *s, *d;
	int i;
	
	// Nb RIM(s)
	rsc_gstring(adr,HOMENBRI,&strptr);
	itoa(local_rimdb->nb_rim,strptr,10);

	// No RIM
	rsc_gstring(adr,HOMENORI,&strptr);
	itoa(local_no_rim,strptr,10);
	
	(*RIMM_GetRIMInfos)(local_rimdb,local_no_rim,&riminfos);
	
	// Header_RIM
	rsc_gstring(adr,HOMEHEAD,&strptr);
	for (s=riminfos->Header_RIM, d=strptr, i=0; i<8; *d++=*s++, i++)
		;
	*d = 0;

	// Format_RIM
	rsc_gstring(adr,HOMEFORM,&strptr);
	for (s=riminfos->Format_RIM, d=strptr, i=0; i<4; *d++=*s++, i++)
		;
	*d = 0;

	// Type_RIM
	rsc_gstring(adr,HOMETYPE,&strptr);
	itoa(riminfos->Type_RIM,strptr,10);
	switch (riminfos->Type_RIM)
	{
		case 0 : strcat(strptr," (RIM total)"); break;
		case 1 : strcat(strptr," (RIM partiel)"); break;
		case 2 : strcat(strptr," (RIM gnrant)"); break;
		case 3 : strcat(strptr," (RIM gnrant)"); break;
		case 4 : strcat(strptr," (RIM animation)"); break;
		default: strcat(strptr," (???)");
	}

	// Id_RIM
	rsc_gstring(adr,HOMEID,&strptr);
	for (s=riminfos->Id_RIM, d=strptr, i=0; i<8; *d++=*s++, i++)
		;
	*d = 0;
	
	// Version_RIM
	rsc_gstring(adr,HOMEVERS,&strptr);
	itoa(riminfos->Version_RIM,strptr,10);
	
	// Description
	rsc_gstring(adr,HOMEDESC,&strptr);
	for (s=riminfos->Description, d=strptr, i=0; i<30; *d++=*s++, i++)
		;
	*d = 0;

	// Configurable
	rsc_gstring(adr,HOMECONF,&strptr);
	itoa((int)(riminfos->Configurable),strptr,10);
}

int fr_home(RIMDB * rimdb)
{
	OBJECT *adr;

	rsrc_gaddr(0,FRHOME,&adr);
	
	// init
	local_no_rim = 1;
	local_rimdb = rimdb;
	home_init(adr);
	
	// ouverture du formulaire
	fen_formulr(FRHOME,home_finit);
}

/********************************************************************
 *
 *  void home_finit(FENETRE *f)
 *  
 *  f : une fentre qui contiendra le formulaire FRHOME
 *
 *  initialise les pointeurs sur fonction de f
 *
 ********************************************************************/

static void home_finit(f)
FENETRE *f;
{
	strcpy(f->f_titre,"LDG::RIMM");
	f->f_cont.f_rsc.do_rsc = _home;
	f->f_helpcode = 'RIMM';
//	f->f_icone = ICONE;
//	f->f_fde = home_fde;
//	f->f_bubble = home_bubble;
}

/********************************************************************
 *
 *  int _home(int handle, OBJECT *adr, int ob)
 *  
 *  handle : handle de la fenetre contenant le formulaire
 *  adr    : adresse du formulaire
 *  ob     : numro de l'objet du formulaire cliqu
 *
 *  Cette fonction s'occupe de la gestion du formulaire.
 *  retourne, selon l'objet cliqu, BUTTON_VALIDER (boutton 'valider')
 *  BUTTON_ANNULER ('annuler') ou FAUX (les autres bouttons)
 *
 ********************************************************************/

static int _home(handle,adr,ob,xm)
int     handle;
OBJECT *adr;
int     ob;
XMULTI *xm;
{
	char buff[128];
	char img_filename[256];
	int code_erreur;
	
	if (ob == HOMEPPPP)
	{
		if (local_no_rim < local_rimdb->nb_rim)
			local_no_rim ++;
		home_init(adr);
		adr[ob].ob_state &= ~SELECTED;
		xobjc_draw(handle,adr,0);
		return FAUX;
	}

	if (ob == HOMEMMMM)
	{
		if (local_no_rim > 1)
			local_no_rim --;
		home_init(adr);
		adr[ob].ob_state &= ~SELECTED;
		xobjc_draw(handle,adr,0);
		return FAUX;
	}

	if (ob == HOMEDOPA)
	{
		code_erreur = (*RIMM_DoRIMConfiguration)(local_rimdb,local_no_rim);
		sprintf(buff,"[1][RIMM_DoRIMConfiguration|retourne %d][Continue]",code_erreur);
		form_alert(1,buff);
		adr[ob].ob_state &= ~SELECTED;
		xobjc_draw(handle,adr,0);
		return FAUX;
	}
	
	if (ob == HOMEGENE)
	{
		fr_img(local_rimdb,local_no_rim,0L);
		adr[ob].ob_state &= ~SELECTED;
		xobjc_draw(handle,adr,0);
		return FAUX;
	}

	if (ob == HOMEOPEN)
	{
		if (xfd_fselect(img_filename,"Choose an Image") == 0)
			return FAUX;
		fr_img(local_rimdb,local_no_rim,img_filename);
		adr[ob].ob_state &= ~SELECTED;
		xobjc_draw(handle,adr,0);
		return FAUX;
	}
	
	return (FAUX);
}

#ifdef __TRALALA__
/********************************************************************
 *
 *  int home_fde (FENETRE *f, FDE *fde)
 *  
 *  f   : la fentre qui contient le fr
 *  fde : la description du message
 *
 *  traite le message reu.
 *
 ********************************************************************/

static int home_fde(FENETRE *f, FDE *fde)
{
	static char filename[MAX_LEN];
	
	if ((fde->msg[0]==FDE_DROP) && (fde->msg[4]==DND_FILE))
	{
		char *s, *d;
		s = (char *)(fde->cmpt);
		d = filename;
		while ((*s) && (*s!=' '))
		{
			*d++ = *s++;
		}
		*d = 0;
		
		oh_va_start(filename);
	}
	
	return 0;
}

static int home_appliquer(int action)
{
	open_liste();
	add_file(root_file,NULL);
	cherche(action,root_file);
	
	return 0;
}

static int home_bubble(FENETRE *f, int x, int y, int ob)
{
	switch(ob)
	{
		case HOMEROOT :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BHOMEPAG,NULL) );
			break;
		case HOMEFILE :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BFICHRES,NULL) );
			break;
		case HOMEFRES :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BFENERES,NULL) );
			break;
		case HOMELFHP :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BLFHP,NULL) );
			break;
		case HOMELFUS :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BLFUS,NULL) );
			break;
		case HOMELFMA :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BLFMA,NULL) );
			break;
		case HOMELLEX :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BLLEX,NULL) );
			break;
		case HOMELFIN :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BLFIN,NULL) );
			break;
		case HOMEHOTL :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BHOTLIST,NULL) );
			break;
	}
	return 0;
}
#endif

/* EOF */