/**
**/

#include <stdio.h>
#include <support.h>  /* pour itoa() */
#include <xgemfast.h>
#include <string.h>
#include <xfd.h>

#include "rimm_proto.h"
#include "tst_rimm.h"

/********************************************************************
 *  variables locales                                               *
 ********************************************************************/

static long    local_no_rim;
static RIMDB * local_rimdb;
static RIMIMG  local_rimimg;

/********************************************************************
 *  fonctions locales                                               *
 ********************************************************************/

static int   _rimg              __PROTO((int handle, OBJECT *adr, int ob, XMULTI *xm));
static void   rimg_finit        __PROTO((FENETRE *f));

/********************************************************************
 *  fonctions                                                       *
 ********************************************************************/

/********************************************************************
 *
 *  int fr_img(void)
 *  
 *
 ********************************************************************/

int rimg_init(OBJECT *adr)
{
	char *strptr;
	
	// No RIM
	rsc_gstring(adr,RIMGNORI,&strptr);
	ultoa(local_rimimg.no_rim,strptr,10);

	// Width
	rsc_gstring(adr,RIMGWIDT,&strptr);
	itoa(local_rimimg.width,strptr,10);

	// Height
	rsc_gstring(adr,RIMGHEIG,&strptr);
	itoa(local_rimimg.height,strptr,10);
	
	// Nb plans
	rsc_gstring(adr,RIMGNBPL,&strptr);
	itoa(local_rimimg.nbplans,strptr,10);

	// Fh
	rsc_gstring(adr,RIMGFH,&strptr);
	itoa(local_rimimg.Fh,strptr,10);
}

int fr_img(RIMDB * rimdb, long no_rim, char * filename)
{
	OBJECT *adr;
	int code_retour;
	char buff[256];

	rsrc_gaddr(0,FRIMG,&adr);
	
	// init
	local_no_rim = no_rim;
	local_rimdb  = rimdb;
	local_rimimg.width   = f_bureau.f_wl;
	local_rimimg.height  = f_bureau.f_wh;
	local_rimimg.nbplans = gl_nbplans;
	
	code_retour = (*RIMM_OpenImg)(local_rimdb, local_no_rim, filename, &local_rimimg);
	sprintf(buff,"[1][OpenImg return|%d][continue]",code_retour);
	form_alert(1,buff);
	if (code_retour > 0L)
	{	
		rimg_init(adr);
		// ouverture du formulaire
		fen_alerte(FRIMG,rimg_finit);
	}
}

/********************************************************************
 *
 *  void rimg_finit(FENETRE *f)
 *  
 *  f : une fentre qui contiendra le formulaire FRHOME
 *
 *  initialise les pointeurs sur fonction de f
 *
 ********************************************************************/

static void rimg_finit(f)
FENETRE *f;
{
	strcpy(f->f_titre,"An Opened IMG");
	f->f_cont.f_rsc.do_rsc = _rimg;
	f->f_helpcode = 'RIMM';
//	f->f_icone = ICONE;
//	f->f_fde = home_fde;
//	f->f_bubble = home_bubble;
}

/********************************************************************
 *
 *  int _rimg(int handle, OBJECT *adr, int ob)
 *  
 *  handle : handle de la fenetre contenant le formulaire
 *  adr    : adresse du formulaire
 *  ob     : numro de l'objet du formulaire cliqu
 *
 *  Cette fonction s'occupe de la gestion du formulaire.
 *  retourne, selon l'objet cliqu, BUTTON_VALIDER (boutton 'valider')
 *  BUTTON_ANNULER ('annuler') ou FAUX (les autres bouttons)
 *
 ********************************************************************/

static int _rimg(handle,adr,ob,xm)
int     handle;
OBJECT *adr;
int     ob;
XMULTI *xm;
{
	char buff[128];
	int code_retour;
	
	if (ob == RIMGCLOS)
	{
		code_retour = (*RIMM_CloseImg)(&local_rimimg);
		sprintf(buff,"[1][CloseImg retourne|%d][continue]",code_retour);
		adr[ob].ob_state &= ~SELECTED;
		xobjc_draw(handle,adr,0);
		return BUTTON_VALIDER;
	}
	
	return (FAUX);
}

#ifdef __TRALALA__
/********************************************************************
 *
 *  int home_fde (FENETRE *f, FDE *fde)
 *  
 *  f   : la fentre qui contient le fr
 *  fde : la description du message
 *
 *  traite le message reu.
 *
 ********************************************************************/

static int home_fde(FENETRE *f, FDE *fde)
{
	static char filename[MAX_LEN];
	
	if ((fde->msg[0]==FDE_DROP) && (fde->msg[4]==DND_FILE))
	{
		char *s, *d;
		s = (char *)(fde->cmpt);
		d = filename;
		while ((*s) && (*s!=' '))
		{
			*d++ = *s++;
		}
		*d = 0;
		
		oh_va_start(filename);
	}
	
	return 0;
}

static int home_appliquer(int action)
{
	open_liste();
	add_file(root_file,NULL);
	cherche(action,root_file);
	
	return 0;
}

static int home_bubble(FENETRE *f, int x, int y, int ob)
{
	switch(ob)
	{
		case HOMEROOT :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BHOMEPAG,NULL) );
			break;
		case HOMEFILE :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BFICHRES,NULL) );
			break;
		case HOMEFRES :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BFENERES,NULL) );
			break;
		case HOMELFHP :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BLFHP,NULL) );
			break;
		case HOMELFUS :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BLFUS,NULL) );
			break;
		case HOMELFMA :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BLFMA,NULL) );
			break;
		case HOMELLEX :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BLLEX,NULL) );
			break;
		case HOMELFIN :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BLFIN,NULL) );
			break;
		case HOMEHOTL :
			xfd_bubble_show(f,x,y, rsc_gfrstr(BHOTLIST,NULL) );
			break;
	}
	return 0;
}
#endif

/* EOF */