/*
 *	Exemple d'application client de LDG
 *	
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <xgemfast.h>
#include <xfd.h>
#include <ldg.h>

#include "tst_rimm.h"

/* Contient les dclarations des fonctions des lib */
#include "rimm.h"

RIMDB rimdb;
char img_filename[256];

static void do_menubar(int ob)
{
	char buff[128];
	int code_erreur;
	
	switch (ob)
	{
		case MINFOS   : rimminfo(); break;
		case MOPNDB   : code_erreur = (*RIMM_OpenRIMDataBase)(&rimdb,NULL);
		                sprintf(buff,"[1][RIMM_OpenRIMDataBase|retourne %d][Continue]",code_erreur);
		                form_alert(1,buff);
		                break;
		case MCLSDB   : code_erreur = (*RIMM_CloseRIMDataBase)(&rimdb);
		                sprintf(buff,"[1][RIMM_CloseRIMDataBase|retourne %d][Continue]",code_erreur);
		                form_alert(1,buff);
		                break;
		case MOPENIMG : 
		                if (xfd_fselect(img_filename,"Choose an Image") == 0)
		                    break;
		                fr_img(&rimdb,0L,img_filename);
		                break;
		case MHOME    : fr_home(&rimdb); break;
		case MQUIT    : quitter = VRAI; break;
	}
}

int main (void)
{
	char alrt[64];
	
	*img_filename = 0;
	
	/* Init GEM */
	xfd_init("TST_RIMM.RSC",MENU,do_menubar);
	
	/* On charge les modules */
	ldg_rimm  = ldg_exec( ap_id, "rimm.ldg");
	if( ldg_rimm)
		init_ldg_rimm();
	else
	{
		sprintf( alrt, "[1][Erreur Lib RIMM (%d)][OK]", ldg_error());
		form_alert( 1, alrt);
	}
	
	rimminfo();

	ldg_term( ap_id, ldg_rimm);
	
	xfd_do();
	xfd_close();

	return 0;
}
