/*
 *	Librairies Dynamiques GEM
 *	dfinitions pour les librairies dynamiques GEM de type LDG 
 * 	Version portable Gnuc/PureC
 *
 *	Copyright 97/98 by Olivier Landemarre and Dominique Brziat
 */

#ifndef __LDGAPP__
#define __LDGAPP__

#ifdef __SOZOBONX__
	#include <types.h>
#else
	#include <portab.h>
#endif

/* Les messages */

#define LDG_REQUEST 	0x4C45  /* demande d'infos  la librairie (client->ldg)*/
#define LDG_TERM       	0x4C47  /* la librairie quitte (ldg->client) */
							    /* le client n'utilise plus la lib (client->ldg) */
#define LDG_GARBAGE    	0x4C48  /* mcanisme de garbage collector */	
#define LDG_ERROR      	0x4C49  /* erreur de dclaration */
#define LDG_QUIT       	0x4C4A  /* message interne aux libs */
#define LDG_LIST       	0x4C4B  /* la lib retourne la liste de ses clients */

#define LDG_COOKIE     	0x4C44474DL	/* 'LDGM' */
#define FLEN			128

/* les structures */             

/* Le cookie LDG */
typedef struct {
	WORD version;  		/* version du cookie, 0x0100 pour le moment */
	char path[FLEN];
	WORD garbage;
	WORD idle;
} LDG_INFOS;

typedef struct entrie{
	char *name;  	/* Nom de la procdure */
	char *info;  	/* infos sur la fonction */
	void *func;  	/* adresse de la fonction */
} PROC;


/* La structure associ au message LDG_ANSWER */
/* structure recue cot client */
typedef struct ldg {
	LONG magic;	/* doit valoir 'LDGM'   */
	WORD vers;   	/* Version de la librairie */
	WORD id;     	/* id du lanceur 	*/
	WORD num;    	/* nombre d'entres        */
	PROC *list;  	/* les fonctions de la lib */
	char *infos; 	/* infos, description de la lib */
	void *baspag;	/* adresse du module */
	WORD flags;		/* nouveau depuis LDG vers. 0.99 */
	void (*close)(void);	/* fonction excute par ldg_term  0.99c */
	/* version 1.00 */
	WORD vers_ldg;		/* Version protocol LDG */
	char path[FLEN];	/* chemin de la librairie */
	LONG user_ext;		/* extension de la lib, ce champ est libre */
	LONG addr_ext;		/* pour permettre l'extension facilement */
} LDG;

	/* structure  dclarer cot client et  passer  ldg_init() */
typedef struct ldglib {
	WORD vers;   	/* Version de la librairie */
	WORD num;    	/* nombre d'entres        */
	PROC *list;  	/* les fonctions de la lib */
	char *infos; 	/* infos, description de la lib */
	WORD flags;	/* nouveau depuis LDG vers. 0.99 */
	void (*close)(void);	/* fonction excute par ldg_term  0.99c */
	/* version 1.00 */
	LONG user_ext;		/* extension de la lib, ce champ est libre */
} LDGLIB;

/* valeur du champ 'flags' */
#define LDG_NOT_SHARED	0x1	/* la lib ne peut pas etre partage */
#define LDG_LOCKED		0x2	/* la lib est vrrouill */
#define LDG_RESIDENT	0x4 /* la lib est rsidente en mmoire */

/* Code erreur */
#define LDG_LIB_FULLED	-1
#define LDG_APP_FULLED	-2
#define LDG_ERR_EXEC	-3
#define LDG_BAD_FORMAT	-4
#define LDG_LIB_LOCKED	-6
#define LDG_NO_MANAGER	-7
#define LDG_NOT_FOUND	-8
#define LDG_BAD_LIB		LDG_BAD_FORMAT

/* fonctions pour le client : */
LDG*	ldg_exec	( int app_id, char *name);
void 	ldg_term	( int app_id, LDG *ldg);
int  	ldg_error	( void);
void*	ldg_find	( char *name, LDG *ldg);

/* fonctions pour le serveur : */
int  	ldg_init	( LDGLIB *libldg);

/* divers */
int 	ldg_cookie	( long, long *);
void 	ldg_debug	( char *, ...);
void *	ldg_Malloc	(long size);
void *	ldg_Calloc	(long count,long size);
int 	ldg_Free	(void *memory);
void *	ldg_Realloc	( void *oldblk, long oldsize, long newsize);

/* Version de la librarie */
struct version {
	char *name;
	WORD  num;
};

extern struct version ldg_version;

#endif __LDGAPP__
