/*
 *	Exemple d'application client de LDG
 *	sous la librairie WINDOM
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windom.h>
#include <ldg.h>
#include "ex_app.h"

/* Contient les dclarations des fonctions des lib */
#include "..\libs\ex_lib.h"
#include "..\libs\popup.h"

extern AESPB ldg_aespb;

#ifdef DEBUG
LONG CDECL __popup( OBJECT *menu, LONG x, LONG y, LONG item, AESPB *aespb);
#endif

/* Gestion du formulaire */

void form( WINDOW *win) {
	int res = evnt.buff[4];
	OBJECT *tree;
	int x,y;
	static int res2 = 0;
	double f;
	Real   r;
	
	switch( res) {
	case POPUP:
		rsrc_gaddr( 0, LIST, &tree);
		objc_offset( FORM(win), res, &x, &y);
		res2 = (*_popup)( tree, (LONG)x, (LONG)y, -1L, &ldg_aespb );
		if( res2 > 0) {
			strcpy( ObjcString( FORM(win), POPUP, NULL), tree[res2].ob_spec.free_string);
		} else
			strcpy( ObjcString( FORM(win), POPUP, NULL), " ****** ");
		ObjcDraw( OC_FORM, win, POPUP, 0);
		break;
	case CALCUL:
		switch( res2) {
		case 1:
			form_alert(1,(*mathinfo)());
			break;
		case 3:
			r.value = atof(ObjcString(FORM(win),INPUT,NULL));
			f = (*cosinus)( &r);
			sprintf( ObjcString(FORM(win), INPUT, NULL), "%5f", (float)f);
			ObjcDraw( OC_FORM, win, INPUT, 0);
			break;
		case 2:
			r.value = atof(ObjcString(FORM(win),INPUT,NULL));
			f = (*sinus)( &r);
			sprintf( ObjcString(FORM(win), INPUT, NULL), "%5f", (float)f);
			ObjcDraw( OC_FORM, win, INPUT, 0);
			break;
		}
		break;
	case OK:
		snd_msg( win, WM_CLOSED, 0, 0, 0, 0);
		break;
	}
	ObjcChange( OC_FORM, win, res, NORMAL, 1);
}

/* Partie Principale */

int main(void) {
	int res;
	OBJECT *dial;
	char alrt[80];

	/* Init GEM */
	ApplInit();
	RsrcLoad( "ex_app.rsc");
	
	/* On charge les modules */
	ldg_math  = ldg_exec( app.id, "ex_lib.ldg");
	if( ldg_math)
		init_ldg_math();
	else {
		sprintf( alrt, "[1][Erreur Lib math (%d)][OK]", ldg_error());
		form_alert( 1, alrt);
	}

#ifndef DEBUG
	ldg_popup = ldg_exec( app.id, "popup.ldg");
	if( ldg_popup)
		init_ldg_popup();
	else{
		sprintf( alrt, "[1][Erreur Lib popup (%d)][OK]", ldg_error());
		form_alert( 1, alrt);
	}
#else
	*_popup = __popup;
#endif

	/* Le reste de l'appli */

	rsrc_gaddr( 0, INFO_LDG, &dial);
	FormCreate( dial, NAME|CLOSER|MOVER, form, "Exemple Client", NULL, 1, 0);
		
	do {
		res = EvntWindom( MU_MESAG|MU_BUTTON);

		if( res & MU_MESAG) {
			switch( evnt.buff[0]) {
			/* seul message a grer */
			case LDG_TERM:
				form_alert( 1, "[1][Plus de lib en mmoire][OK]");
				break;
			/* juste un test */
			case AP_TERM:
				ApplExit();
				exit(0);
				break;
			case LDG_ERROR:
				sprintf( alrt, "[1][error %d][OK]", evnt.buff[3]);
				form_alert( 1, alrt);
				break;
			}
		}
	} while( wglb.first);

	/* Fin des librairies */
#ifndef DEBUG
	ldg_term( app.id, ldg_popup);
#endif
	ldg_term( app.id, ldg_math);

	/* Fin de l'environnement GEM */	
	RsrcFree();
	ApplExit();
	return 0;
}